'''
test_dct.py

Unit tests for the dct module.

Updated 3/4/2013
'''

import dct
import math
import numpy as np
import scipy.fftpack
import unittest

class TestDCT(unittest.TestCase):
    def setUp(self):
        self.MIN_POWER = 8
        self.MAX_POWER = 10
        self.EPSILON = .0001

    def test_equal_scipy_arange(self):
        count = 0
        for i in range(self.MIN_POWER,self.MAX_POWER+1):
            signal = np.arange(2**i, dtype=np.float64)
            theirs = scipy.fftpack.dct(signal, norm='ortho')
            ours = dct.dct(signal)
            for j in range(len(theirs)):
                if abs(theirs[j] - ours[j]) > self.EPSILON:
                    count += 1
            print i
            self.assertEqual(count,0,"There were %d errors compared to scipy"%(count))

if __name__=='__main__':
    try:
        unittest.main()
    except SystemExit as inst:
        if inst.args[0] is True: # raised by sys.exit(True) when tests failed
            raise
