'''
test_dwt.py

Unit tests for the dwt module.

Updated 3/4/2013
'''

import pywt
import PyGASP.dwt as dwt
import math
import numpy as np
import unittest

class TestDWT(unittest.TestCase):
    def setUp(self):
        self.MIN_POWER = 12
        self.MAX_POWER = 12
        self.wav = 'db2'
        self.level = 1
        self.mode = 'zpd'
        self.EPSILON = .0001

    #@unittest.skipIf(pywt_not_installed, "pywt not installed")
    def test_equal_pywt_arange(self):
        count = 0
        for i in range(self.MIN_POWER,self.MAX_POWER+1):
            signal = np.arange(2**i)                
            theirs = pywt.wavedec(signal,self.wav,level=self.level,mode=self.mode)
            ours = dwt.dwt(signal,wav=self.wav, levels=self.level, mode=self.mode)
            for j in range(len(theirs)):
                for k in range(len(theirs[j])):
                    if abs(theirs[j][k] - ours[j][k]) > self.EPSILON:
                        count += 1
            self.assertEqual(count,0,"There were %d errors compared to pywt"%(count))

if __name__=='__main__':
    try:
        unittest.main()
    except SystemExit as inst:
        if inst.args[0] is True: # raised by sys.exit(True) when tests failed
            raise
