'''
test_fft.py

Unit tests for the fft module.

Updated 3/4/2013
'''

import PyGASP.fft.fftIterative as fftIt

import sys
import site


#from PyGASP.fft import *
import math
import numpy as np
import unittest

class TestFFT(unittest.TestCase):
    def setUp(self):
        self.MIN_POWER = 4
        self.MAX_POWER = 8
        self.EPSILON = .01

    def test_equal_numpy_arange(self):
        count = 0
        for i in range(self.MIN_POWER,self.MAX_POWER+1):
            signal = np.arange(2**i)                
            theirs = np.fft.fft(signal)
            ours = fftIt.fft(signal)
            for j in range(len(theirs)):
                if abs(theirs[j] - ours[j]) > self.EPSILON:
                    count += 1
            print i
            self.assertEqual(count,0,"There were %d errors compared to numpy"%(count))

if __name__=='__main__':
    try:
        unittest.main()
    except SystemExit as inst:
        if inst.args[0] is True: # raised by sys.exit(True) when tests failed
            raise
