#-----------------------------------------------------------------------------
# Copyright (c) 2013, PyInstaller Development Team.
#
# Distributed under the terms of the GNU General Public License with exception
# for distributing bootloader.
#
# The full license is in the file COPYING.txt, distributed with this software.
#-----------------------------------------------------------------------------


import os


hiddenimports = [
    # win32com client and server util
    # modules could be hidden imports
    # of some modules using win32com.
    # Included for completeness.
    'win32com.client.util',
    'win32com.server.util',
]


def hook(mod):
    # win32com module changes sys.path and wrapps win32comext modules.
    pth = str(mod.__path__[0])
    if os.path.isdir(pth):
        mod.__path__.append(
            os.path.normpath(os.path.join(pth, '..', 'win32comext')))
    return mod
