/**
 * $Id: tiny_mce_dev.js 470 2007-12-03 15:06:58Z spocke $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2007, Moxiecode Systems AB, All rights reserved.
 *
 * This file should only be used while developing TinyMCE 
 * tiny_mce.js or tiny_mce_src.js should be used in a production environment.
 * This file loads the js files from classes instead of a merged copy.
 */

(function() {
	var i, nl = document.getElementsByTagName('script'), base, src, p, li, query = '', it;

	if (window.tinyMCEPreInit) {
		base = tinyMCEPreInit.base;
		query = tinyMCEPreInit.query || '';
	} else {
		for (i=0; i<nl.length; i++) {
			src = nl[i].src;

			if (src && src.indexOf("tiny_mce_dev.js") != -1) {
				base = src.substring(0, src.lastIndexOf('/'));

				if ((p = src.indexOf('?')) != -1)
					query = src.substring(p + 1);
			}
		}
	}

	// Parse query string
	li = query.split('&');
	query = {};
	for (i=0; i<li.length; i++) {
		it = li[i].split('=');
		query[unescape(it[0])] = unescape(it[1]);
	}

	nl = null;

	function include(u) {
		document.write('<script type="text/javascript" src="' + base + '/classes/' + u + '"></script>');
	};

	// Firebug
	if (query.debug) {
		document.documentElement.setAttribute("debug", "true");
		include('firebug/firebug.js');
	}

	// Core ns
	include('tinymce.js');

	// Load framework adapter
	if (query.api) {
		include('adapter/' + query.api + '/' + query.api + '.js');
		include('adapter/' + query.api + '/adapter.js');
	}

	// Core API
	include('util/Dispatcher.js');
	include('util/URI.js');
	include('util/Cookie.js');
	include('util/JSON.js');
	include('util/XHR.js');
	include('util/JSONRequest.js');
	include('dom/DOMUtils.js');
	include('dom/Event.js');
	include('dom/Element.js');
	include('dom/Selection.js');
	include('dom/XMLWriter.js');
	include('dom/StringWriter.js');
	include('dom/Serializer.js');
	include('dom/ScriptLoader.js');
	include('ui/Control.js');
	include('ui/Container.js');
	include('ui/Separator.js');
	include('ui/MenuItem.js');
	include('ui/Menu.js');
	include('ui/DropMenu.js');
	include('ui/Button.js');
	include('ui/ListBox.js');
	include('ui/NativeListBox.js');
	include('ui/SplitButton.js');
	include('ui/ColorSplitButton.js');
	include('ui/Toolbar.js');
	include('AddOnManager.js');
	include('EditorManager.js');
	include('Editor.js');
	include('EditorCommands.js');
	include('UndoManager.js');
	include('ForceBlocks.js');
	include('ControlManager.js');
	include('WindowManager.js');

	// Developer API
	include('xml/Parser.js');
	include('Developer.js');
}());