/* content from:
 * http://marijn.haverbeke.nl/codemirror/js/util.js
 * http://marijn.haverbeke.nl/codemirror/js/stringstream.js
 * http://marijn.haverbeke.nl/codemirror/js/select.js
 * http://marijn.haverbeke.nl/codemirror/js/undo.js
 * http://marijn.haverbeke.nl/codemirror/js/editor.js
 * http://marijn.haverbeke.nl/codemirror/js/tokenize.js
 * closure compiled 2010-09-24 */
function method(e,k){return function(){e[k].apply(e,arguments)}}var StopIteration={toString:function(){return"StopIteration"}};function forEach(e,k){if(e.next)try{for(;;)k(e.next())}catch(i){if(i!=StopIteration)throw i;}else for(var m=0;m<e.length;m++)k(e[m])}function map(e,k){var i=[];forEach(e,function(m){i.push(k(m))});return i}function matcher(e){return function(k){return e.test(k)}}function hasClass(e,k){var i=e.className;return i&&RegExp("(^| )"+k+"($| )").test(i)}
function insertAfter(e,k){k.parentNode.insertBefore(e,k.nextSibling);return e}function removeElement(e){e.parentNode&&e.parentNode.removeChild(e)}function clearElement(e){for(;e.firstChild;)e.removeChild(e.firstChild)}function isAncestor(e,k){for(;k=k.parentNode;)if(e==k)return true;return false}var nbsp="\u00a0",matching={"{":"}","[":"]","(":")","}":"{","]":"[",")":"("};
function normalizeEvent(e){if(!e.stopPropagation){e.stopPropagation=function(){this.cancelBubble=true};e.preventDefault=function(){this.returnValue=false}}if(!e.stop)e.stop=function(){this.stopPropagation();this.preventDefault()};if(e.type=="keypress"){e.code=e.charCode==null?e.keyCode:e.charCode;e.character=String.fromCharCode(e.code)}return e}
function addEventHandler(e,k,i,m){function n(p){i(normalizeEvent(p||window.event))}if(typeof e.addEventListener=="function"){e.addEventListener(k,n,false);if(m)return function(){e.removeEventListener(k,n,false)}}else{e.attachEvent("on"+k,n);if(m)return function(){e.detachEvent("on"+k,n)}}}function nodeText(e){return e.textContent||e.innerText||e.nodeValue||""}function nodeTop(e){for(var k=0;e.offsetParent;){k+=e.offsetTop;e=e.offsetParent}return k}
function isBR(e){e=e.nodeName;return e=="BR"||e=="br"}function isSpan(e){e=e.nodeName;return e=="SPAN"||e=="span"};var stringStream=function(e){function k(){for(;m==i.length;){n+=i;i="";m=0;try{i=e.next()}catch(p){if(p!=StopIteration)throw p;else return false}}return true}var i="",m=0,n="";return{peek:function(){if(!k())return null;return i.charAt(m)},next:function(){if(!k())if(n.length>0)throw"End of stringstream reached without emptying buffer ('"+n+"').";else throw StopIteration;return i.charAt(m++)},get:function(){var p=n;n="";if(m>0){p+=i.slice(0,m);i=i.slice(m);m=0}return p},push:function(p){i=i.slice(0,
m)+p+i.slice(m)},lookAhead:function(p,u,v,b){function a(j){return b?j.toLowerCase():j}p=a(p);var c=false,d=n,f=m;for(v&&this.nextWhileMatches(/[\s\u00a0]/);;){v=m+p.length;var g=i.length-m;if(v<=i.length){c=p==a(i.slice(m,v));m=v;break}else if(p.slice(0,g)==a(i.slice(m))){n+=i;i="";try{i=e.next()}catch(h){break}m=0;p=p.slice(g)}else break}if(!(c&&u)){i=n.slice(d.length)+i;m=f;n=d}return c},more:function(){return this.peek()!==null},applies:function(p){var u=this.peek();return u!==null&&p(u)},nextWhile:function(p){for(var u;(u=
this.peek())!==null&&p(u);)this.next()},matches:function(p){var u=this.peek();return u!==null&&p.test(u)},nextWhileMatches:function(p){for(var u;(u=this.peek())!==null&&p.test(u);)this.next()},equals:function(p){return p===this.peek()},endOfLine:function(){var p=this.peek();return p==null||p=="\n"}}};var select={};
(function(){function e(a,c){for(;a&&a.parentNode!=c;)a=a.parentNode;return a}function k(a,c){for(;!a.previousSibling&&a.parentNode!=c;)a=a.parentNode;return e(a.previousSibling,c)}select.ie_selection=document.selection&&document.selection.createRangeCollection;select.scrollToNode=function(a,c){if(a){for(var d=a,f=document.body,g=document.documentElement,h=!d.nextSibling||!d.nextSibling.nextSibling||!d.nextSibling.nextSibling.nextSibling,j=0;d&&!d.offsetTop;){j++;d=d.previousSibling}if(j==0)h=false;
if(!(webkit&&d&&d.offsetTop==5&&d.offsetLeft==5)){j=j*(d?d.offsetHeight:0);var l=0,o=a?a.offsetWidth:0;for(d=d;d&&d.offsetParent;){j+=d.offsetTop;isBR(d)||(l+=d.offsetLeft);d=d.offsetParent}d=f.scrollLeft||g.scrollLeft||0;f=f.scrollTop||g.scrollTop||0;var s=false,t=window.innerWidth||g.clientWidth||0;if(c||o<t){if(c){var q=select.offsetInNode(a),w=nodeText(a).length;if(w)l+=o*(q/w)}o=l-d;if(o<0||o>t){d=l;s=true}}l=j-f;if(l<0||h||l>(window.innerHeight||g.clientHeight||0)-50){f=h?1E6:j;s=true}s&&window.scrollTo(d,
f)}}};select.scrollToCursor=function(a){select.scrollToNode(select.selectionTopNode(a,true)||a.firstChild,true)};var i=null;select.snapshotChanged=function(){if(i)i.changed=true};select.snapshotReplaceNode=function(a,c,d,f){function g(h){if(a==h.node){i.changed=true;if(d&&h.offset>d)h.offset-=d;else{h.node=c;h.offset+=f||0}}}if(i){g(i.start);g(i.end)}};select.snapshotMove=function(a,c,d,f,g){function h(j){if(a==j.node&&(!g||j.offset==0)){i.changed=true;j.node=c;j.offset=f?Math.max(0,j.offset+d):d}}
if(i){h(i.start);h(i.end)}};if(select.ie_selection){var m=function(a){function c(o){for(var s=null;!s&&o;){s=o.nextSibling;o=o.parentNode}return d(s)}function d(o){for(;o&&o.firstChild;)o=o.firstChild;return{node:o,offset:0}}var f=document.selection.createRange();f.collapse(a);a=f.parentElement();if(!isAncestor(document.body,a))return null;if(!a.firstChild)return d(a);var g=f.duplicate();g.moveToElementText(a);g.collapse(true);for(var h=a.firstChild;h;h=h.nextSibling){if(h.nodeType==3){var j=h.nodeValue.length;
g.move("character",j)}else{g.moveToElementText(h);g.collapse(false)}var l=f.compareEndPoints("StartToStart",g);if(l==0)return c(h);if(l!=1){if(h.nodeType!=3)return d(h);g.setEndPoint("StartToEnd",f);return{node:h,offset:j-g.text.length}}}return c(a)};select.markSelection=function(){i=null;if(document.selection){var a=m(true),c=m(false);if(a&&c)i={start:a,end:c,changed:false}}};select.selectMarked=function(){function a(f){var g=document.body.createTextRange(),h=f.node;if(h)if(h.nodeType==3){g.moveToElementText(h.parentNode);
for(f=f.offset;h.previousSibling;){h=h.previousSibling;f+=(h.innerText||"").length}g.move("character",f)}else{g.moveToElementText(h);g.collapse(true)}else{g.moveToElementText(document.body);g.collapse(false)}return g}if(i&&i.changed){var c=a(i.start),d=a(i.end);c.setEndPoint("StartToEnd",d);c.select()}};select.offsetInNode=function(a){var c=document.selection;if(!c)return 0;c=c.createRange();var d=c.duplicate();try{d.moveToElementText(a)}catch(f){return 0}c.setEndPoint("StartToStart",d);return c.text.length};
select.selectionTopNode=function(a,c){function d(s,t){if(t.nodeType==3){for(var q=0,w=t.previousSibling;w&&w.nodeType==3;){q+=w.nodeValue.length;w=w.previousSibling}if(w){try{s.moveToElementText(w)}catch(y){return false}s.collapse(false)}else s.moveToElementText(t.parentNode);q&&s.move("character",q)}else try{s.moveToElementText(t)}catch(r){return false}return true}var f=document.selection;if(!f)return false;var g=f.createRange(),h=g.duplicate();g.collapse(c);var j=g.parentElement();if(j&&isAncestor(a,
j)){h.moveToElementText(j);if(g.compareEndPoints("StartToStart",h)==1)return e(j,a)}c=0;for(j=a.childNodes.length-1;c<j;){var l=Math.ceil((j+c)/2),o=a.childNodes[l];if(!o)return false;if(!d(h,o))return false;if(g.compareEndPoints("StartToStart",h)==1)c=l;else j=l-1}if(c==0){f=f.createRange();g=f.duplicate();g.moveToElementText(a);if(f.compareEndPoints("StartToStart",g)==0)return null}return a.childNodes[c]||null};select.focusAfterNode=function(a,c){var d=document.body.createTextRange();d.moveToElementText(a||
c);d.collapse(!a);d.select()};select.somethingSelected=function(){var a=document.selection;return a&&a.createRange().text!=""};var n=function(a){var c=document.selection;if(c){c=c.createRange();c.pasteHTML(a);c.collapse(false);c.select()}};select.insertNewlineAtCursor=function(){n("<br>")};select.insertTabAtCursor=function(){n("\u00a0\u00a0\u00a0\u00a0")};select.cursorPos=function(a,c){var d=document.selection;if(!d)return null;for(var f=select.selectionTopNode(a,c);f&&!isBR(f);)f=f.previousSibling;
d=d.createRange();var g=d.duplicate();d.collapse(c);if(f){g.moveToElementText(f);g.collapse(false)}else{try{g.moveToElementText(a)}catch(h){return null}g.collapse(true)}d.setEndPoint("StartToStart",g);return{node:f,offset:d.text.length}};select.setCursorPos=function(a,c,d){function f(h){var j=document.body.createTextRange();if(h.node){j.moveToElementText(h.node);j.collapse(false)}else{j.moveToElementText(a);j.collapse(true)}j.move("character",h.offset);return j}var g=f(c);d&&d!=c&&g.setEndPoint("EndToEnd",
f(d));g.select()};select.getBookmark=function(a){var c=select.cursorPos(a,true);a=select.cursorPos(a,false);if(c&&a)return{from:c,to:a}};select.setBookmark=function(a,c){c&&select.setCursorPos(a,c.from,c.to)}}else{var p=function(a,c){for(;a.nodeType!=3&&!isBR(a);){var d=a.childNodes[c]||a.nextSibling;for(c=0;!d&&a.parentNode;){a=a.parentNode;d=a.nextSibling}a=d;if(!d)break}return{node:a,offset:c}};select.markSelection=function(){var a=window.getSelection();if(!a||a.rangeCount==0)return i=null;a=a.getRangeAt(0);
i={start:p(a.startContainer,a.startOffset),end:p(a.endContainer,a.endOffset),changed:false}};select.selectMarked=function(){function a(){if(d.start.node==d.end.node&&d.start.offset==d.end.offset){var g=window.getSelection();if(!g||g.rangeCount==0)return true;g=g.getRangeAt(0);g=p(g.startContainer,g.startOffset);return d.start.node!=g.node||d.start.offset!=g.offset}}function c(g,h){if(g.node)g.offset==0?f["set"+h+"Before"](g.node):f["set"+h](g.node,g.offset);else f.setStartAfter(document.body.lastChild||
document.body)}var d=i;if(d&&(d.changed||webkit&&a())){var f=document.createRange();c(d.end,"End");c(d.start,"Start");u(f)}};var u=function(a){var c=window.getSelection();if(c){c.removeAllRanges();c.addRange(a)}},v=function(){var a=window.getSelection();return!a||a.rangeCount==0?false:a.getRangeAt(0)};select.selectionTopNode=function(a,c){var d=v();if(!d)return false;var f=c?d.startContainer:d.endContainer,g=c?d.startOffset:d.endOffset;window.opera&&!c&&d.endContainer==a&&d.endOffset==d.startOffset+
1&&a.childNodes[d.startOffset]&&isBR(a.childNodes[d.startOffset])&&g--;return f.nodeType==3?g>0?e(f,a):k(f,a):f.nodeName.toUpperCase()=="HTML"?g==1?null:a.lastChild:f==a?g==0?null:f.childNodes[g-1]:g==f.childNodes.length?e(f,a):g==0?k(f,a):e(f.childNodes[g-1],a)};select.focusAfterNode=function(a,c){var d=document.createRange();d.setStartBefore(c.firstChild||c);if(a&&!a.firstChild)d.setEndAfter(a);else a?d.setEnd(a,a.childNodes.length):d.setEndBefore(c.firstChild||c);d.collapse(false);u(d)};select.somethingSelected=
function(){var a=v();return a&&!a.collapsed};select.offsetInNode=function(a){var c=v();if(!c)return 0;c=c.cloneRange();c.setStartBefore(a);return c.toString().length};var b=function(a){var c=v();if(c){c.deleteContents();c.insertNode(a);webkitLastLineHack(document.body);if(window.opera&&isBR(a)&&isSpan(a.parentNode)){c=a.nextSibling;var d=a.parentNode,f=d.parentNode;f.insertBefore(a,d.nextSibling);for(d="";c&&c.nodeType==3;c=c.nextSibling){d+=c.nodeValue;removeElement(c)}f.insertBefore(makePartSpan(d,
document),a.nextSibling)}c=document.createRange();c.selectNode(a);c.collapse(false);u(c)}};select.insertNewlineAtCursor=function(){b(document.createElement("BR"))};select.insertTabAtCursor=function(){b(document.createTextNode("\u00a0\u00a0\u00a0\u00a0"))};select.cursorPos=function(a,c){var d=v();if(d){for(var f=select.selectionTopNode(a,c);f&&!isBR(f);)f=f.previousSibling;d=d.cloneRange();d.collapse(c);f?d.setStartAfter(f):d.setStartBefore(a);d=d.toString();return{node:f,offset:d.length}}};select.setCursorPos=
function(a,c,d){function f(h,j,l){function o(w){w.nodeType==3?s.push(w):forEach(w.childNodes,o)}if(j==0&&h&&!h.nextSibling){g["set"+l+"After"](h);return true}if(h=h?h.nextSibling:a.firstChild){if(j==0){g["set"+l+"Before"](h);return true}for(var s=[];;){for(;h&&!s.length;){o(h);h=h.nextSibling}var t=s.shift();if(!t)return false;var q=t.nodeValue.length;if(q>=j){g["set"+l](t,j);return true}j-=q}}}var g=document.createRange();d=d||c;f(d.node,d.offset,"End")&&f(c.node,c.offset,"Start")&&u(g)}}})();function UndoHistory(e,k,i,m){this.container=e;this.maxDepth=k;this.commitDelay=i;this.editor=m;this.parent=m.parent;this.last=this.first=e={text:"",from:null,to:null};this.firstTouched=false;this.history=[];this.redoHistory=[];this.touched=[]}
UndoHistory.prototype={scheduleCommit:function(){var e=this;this.parent.clearTimeout(this.commitTimeout);this.commitTimeout=this.parent.setTimeout(function(){e.tryCommit()},this.commitDelay)},touch:function(e){this.setTouched(e);this.scheduleCommit()},undo:function(){this.commit();if(this.history.length){var e=this.history.pop();this.redoHistory.push(this.updateTo(e,"applyChain"));this.notifyEnvironment();return this.chainNode(e)}},redo:function(){this.commit();if(this.redoHistory.length){var e=this.redoHistory.pop();
this.addUndoLevel(this.updateTo(e,"applyChain"));this.notifyEnvironment();return this.chainNode(e)}},clear:function(){this.history=[];this.redoHistory=[]},historySize:function(){return{undo:this.history.length,redo:this.redoHistory.length}},push:function(e,k,i){for(var m=[],n=0;n<i.length;n++){var p=n==i.length-1?k:this.container.ownerDocument.createElement("BR");m.push({from:e,to:p,text:cleanText(i[n])});e=p}this.pushChains([m],e==null&&k==null);this.notifyEnvironment()},pushChains:function(e,k){this.commit(k);
this.addUndoLevel(this.updateTo(e,"applyChain"));this.redoHistory=[]},chainNode:function(e){for(var k=0;k<e.length;k++){var i=e[k][0];if(i=i&&(i.from||i.to))return i}},reset:function(){this.history=[];this.redoHistory=[]},textAfter:function(e){return this.after(e).text},nodeAfter:function(e){return this.after(e).to},nodeBefore:function(e){return this.before(e).from},tryCommit:function(){if(window.parent&&window.UndoHistory)this.editor.highlightDirty()?this.commit(true):this.scheduleCommit()},commit:function(e){this.parent.clearTimeout(this.commitTimeout);
e||this.editor.highlightDirty(true);e=this.touchedChains();if(e.length){this.addUndoLevel(this.updateTo(e,"linkChain"));this.redoHistory=[];this.notifyEnvironment()}},updateTo:function(e,k){for(var i=[],m=[],n=0;n<e.length;n++){i.push(this.shadowChain(e[n]));m.push(this[k](e[n]))}k=="applyChain"&&this.notifyDirty(m);return i},notifyDirty:function(e){forEach(e,method(this.editor,"addDirtyNode"));this.editor.scheduleHighlight()},notifyEnvironment:function(){this.onChange&&this.onChange();window.frameElement&&
window.frameElement.CodeMirror.updateNumbers&&window.frameElement.CodeMirror.updateNumbers()},linkChain:function(e){for(var k=0;k<e.length;k++){var i=e[k];if(i.from)i.from.historyAfter=i;else this.first=i;if(i.to)i.to.historyBefore=i;else this.last=i}},after:function(e){return e?e.historyAfter:this.first},before:function(e){return e?e.historyBefore:this.last},setTouched:function(e){if(e){if(!e.historyTouched){this.touched.push(e);e.historyTouched=true}}else this.firstTouched=true},addUndoLevel:function(e){this.history.push(e);
this.history.length>this.maxDepth&&this.history.shift()},touchedChains:function(){function e(v,b){if(v)v.historyTemp=b;else n=b}function k(v){for(var b=[],a=v?v.nextSibling:m.container.firstChild;a&&!isBR(a);a=a.nextSibling)a.currentText&&b.push(a.currentText);return{from:v,to:a,text:cleanText(b.join(""))}}function i(v,b){for(var a=b+"Sibling",c=v[a];c&&!isBR(c);)c=c[a];return c}var m=this,n=null,p=[];m.firstTouched&&m.touched.push(null);forEach(m.touched,function(v){if(!(v&&v.parentNode!=m.container)){if(v)v.historyTouched=
false;else m.firstTouched=false;var b=k(v),a=m.after(v);if(!a||a.text!=b.text||a.to!=b.to){p.push(b);e(v,b)}}});var u=[];m.touched=[];forEach(p,function(v){if(v.from?v.from.historyTemp:n){for(var b=[],a=v.from,c=true;;){var d=a?a.historyTemp:n;if(!d)if(c)break;else d=k(a);b.unshift(d);e(a,null);if(!a)break;c=m.after(a);a=i(a,"previous")}a=v.to;for(c=m.before(v.from);;){if(!a)break;d=a?a.historyTemp:n;if(!d)if(c)break;else d=k(a);b.push(d);e(a,null);c=m.before(a);a=i(a,"next")}u.push(b)}});return u},
shadowChain:function(e){var k=[],i=this.after(e[0].from);for(e=e[e.length-1].to;;){k.push(i);i=i.to;if(!i||i==e)break;else i=i.historyAfter||this.before(e)}return k},applyChain:function(e){var k=select.cursorPos(this.container,false),i=this,m=e[0].from,n=e[e.length-1].to;(function(c,d){for(var f=c?c.nextSibling:i.container.firstChild;f!=d;){var g=f.nextSibling;removeElement(f);f=g}})(m,n);for(var p=0;p<e.length;p++){var u=e[p];p>0&&i.container.insertBefore(u.from,n);var v=makePartSpan(fixSpaces(u.text));
i.container.insertBefore(v,n);if(k&&k.node==u.from){v=0;var b=this.after(u.from);if(b&&p==e.length-1){for(var a=0;a<k.offset&&u.text.charAt(a)==b.text.charAt(a);a++);if(k.offset>a)v=u.text.length-b.text.length}select.setCursorPos(this.container,{node:u.from,offset:Math.max(0,k.offset+v)})}else k&&p==e.length-1&&k.node&&k.node.parentNode!=this.container&&select.setCursorPos(this.container,{node:u.from,offset:u.text.length})}this.linkChain(e);return m}};var internetExplorer=document.selection&&window.ActiveXObject&&/MSIE/.test(navigator.userAgent),webkit=/AppleWebKit/.test(navigator.userAgent),safari=/Apple Computers, Inc/.test(navigator.vendor),gecko=/gecko\/(\d{8})/i.test(navigator.userAgent),mac=/Mac/.test(navigator.platform),brokenOpera=window.opera&&/Version\/10.[56]/.test(navigator.userAgent);function makeWhiteSpace(e){for(var k=[],i=true;e>0;e--){k.push(i||e==1?nbsp:" ");i^=true}return k.join("")}
function fixSpaces(e){if(e.charAt(0)==" ")e=nbsp+e.slice(1);return e.replace(/\t/g,function(){return makeWhiteSpace(indentUnit)}).replace(/[ \u00a0]{2,}/g,function(k){return makeWhiteSpace(k.length)})}function cleanText(e){return e.replace(/\u00a0/g," ")}function makePartSpan(e){var k=e;if(e.nodeType==3)k=e.nodeValue;else e=document.createTextNode(k);var i=document.createElement("SPAN");i.isPart=true;i.appendChild(e);i.currentText=k;return i}
var webkitLastLineHack=webkit?function(e){var k=e.lastChild;if(!k||!k.hackBR){k=document.createElement("BR");k.hackBR=true;e.appendChild(k)}}:function(){},Editor=function(){function e(b){var a=makeWhiteSpace(indentUnit);return map(b.replace(/\t/g,a).replace(/\u00a0/g," ").replace(/\r\n?/g,"\n").split("\n"),fixSpaces)}function k(b,a){function c(g,h){if(g.nodeType==3){if((g.nodeValue=fixSpaces(g.nodeValue.replace(/\r/g,"").replace(/\n/g," "))).length)f=false;d.push(g)}else if(isBR(g)&&g.childNodes.length==
0){f=true;d.push(g)}else{for(var j=g.firstChild;j;j=j.nextSibling)c(j);if(!f&&v.hasOwnProperty(g.nodeName.toUpperCase())){f=true;if(!a||!h)d.push(document.createElement("BR"))}}}var d=[],f=true;c(b,true);return d}function i(b){function a(g){var h=g.parentNode,j=g.nextSibling;return function(l){h.insertBefore(l,j)}}var c=[],d=null,f=true;return{next:function(){if(!b)throw StopIteration;var g=b;b=g.nextSibling;var h;if(g.isPart&&g.childNodes.length==1&&g.firstChild.nodeType==3){g.currentText=g.firstChild.nodeValue;
h=!/[\n\t\r]/.test(g.currentText)}else h=false;if(h){c.push(g);f=false;return g.currentText}else if(isBR(g)){f&&window.opera&&g.parentNode.insertBefore(makePartSpan(""),g);c.push(g);f=true;return"\n"}else{h=!g.nextSibling;d=a(g);removeElement(g);g=k(g,h);for(h=0;h<g.length;h++){var j=g,l=h,o=g[h],s="\n";if(o.nodeType==3){select.snapshotChanged();o=makePartSpan(o);s=o.currentText;f=false}else{f&&window.opera&&d(makePartSpan(""));f=true}o.dirty=true;c.push(o);d(o);j[l]=s}return g.join("")}},nodes:c}}
function m(b){for(;b&&!isBR(b);)b=b.previousSibling;return b}function n(b,a){if(b){if(isBR(b))b=b.nextSibling}else b=a.firstChild;for(;b&&!isBR(b);)b=b.nextSibling;return b}function p(b,a,c,d){function f(j){j=cleanText(b.history.textAfter(j));return d?j.toLowerCase():j}this.editor=b;this.history=b.history;this.history.commit();this.valid=!!a;this.atOccurrence=false;if(d==undefined)d=a==a.toLowerCase();var g={node:null,offset:0};if(c&&typeof c=="object"&&typeof c.character=="number"){b.checkLine(c.line);
c={node:c.line,offset:c.character};this.pos={from:c,to:c}}else this.pos=c?{from:select.cursorPos(b.container,true)||g,to:select.cursorPos(b.container,false)||g}:{from:g,to:g};var h=(this.caseFold?a.toLowerCase():a).split("\n");this.matches=h.length==1?function(j,l,o){var s=f(l),t=a.length,q;if(j?o>=t&&(q=s.lastIndexOf(a,o-t))!=-1:(q=s.indexOf(a,o))!=-1)return{from:{node:l,offset:q},to:{node:l,offset:q+t}}}:function(j,l,o){var s=j?h.length-1:0,t=h[s],q=f(l),w=j?q.indexOf(t)+t.length:q.lastIndexOf(t);
if(!(j?w>=o||w!=t.length:w<=o||w!=q.length-t.length))for(o=l;;){if(j&&!o)break;o=j?this.history.nodeBefore(o):this.history.nodeAfter(o);if(!j&&!o)break;q=f(o);t=h[j?--s:++s];if(s>0&&s<h.length-1)if(q!=t)break;else continue;s=j?q.lastIndexOf(t):q.indexOf(t)+t.length;if(j?s!=q.length-t.length:s!=t.length)break;return{from:{node:j?o:l,offset:j?s:w},to:{node:j?l:o,offset:j?w:s}}}}}function u(b){this.options=b;window.indentUnit=b.indentUnit;this.parent=parent;var a=this.container=document.body;this.history=
new UndoHistory(a,b.undoDepth,b.undoDelay,this);var c=this;if(!u.Parser)throw"No parser loaded.";b.parserConfig&&u.Parser.configure&&u.Parser.configure(b.parserConfig);b.readOnly||select.setCursorPos(a,{node:null,offset:0});this.dirty=[];this.importCode(b.content||"");this.history.onChange=b.onChange;if(b.readOnly){if(!b.textWrapping)a.style.whiteSpace="nowrap"}else{if(b.continuousScanning!==false){this.scanner=this.documentScanner(b.passTime);this.delayScanning()}var d=function(){if(document.body.contentEditable!=
undefined&&internetExplorer)document.body.contentEditable="true";else document.designMode="on";if(internetExplorer&&b.height!="dynamic")document.body.style.minHeight=frameElement.clientHeight-2*document.body.offsetTop-5+"px";document.documentElement.style.borderWidth="0";if(!b.textWrapping)a.style.whiteSpace="nowrap"};try{d()}catch(f){var g=addEventHandler(document,"focus",function(){g();d()},true)}addEventHandler(document,"keydown",method(this,"keyDown"));addEventHandler(document,"keypress",method(this,
"keyPress"));addEventHandler(document,"keyup",method(this,"keyUp"));var h=function(){c.cursorActivity(false)};addEventHandler(document.body,"mouseup",h);addEventHandler(document.body,"cut",h);gecko&&addEventHandler(window,"pagehide",function(){c.unloaded=true});addEventHandler(document.body,"paste",function(j){h();var l=null;try{var o=j.clipboardData||window.clipboardData;if(o)l=o.getData("Text")}catch(s){}if(l!==null){j.stop();c.replaceSelection(l);select.scrollToCursor(c.container)}});this.options.autoMatchParens&&
addEventHandler(document.body,"click",method(this,"scheduleParenHighlight"))}}var v={P:true,DIV:true,LI:true};p.prototype={findNext:function(){return this.find(false)},findPrevious:function(){return this.find(true)},find:function(b){function a(){var h={node:f,offset:g};c.pos={from:h,to:h};return c.atOccurrence=false}if(!this.valid)return false;var c=this,d=b?this.pos.from:this.pos.to,f=d.node,g=d.offset;if(f&&!f.parentNode){f=null;g=0}for(;;){if(this.pos=this.matches(b,f,g))return this.atOccurrence=
true;if(b){if(!f)return a();f=this.history.nodeBefore(f);g=this.history.textAfter(f).length}else{d=this.history.nodeAfter(f);if(!d){g=this.history.textAfter(f).length;return a()}f=d;g=0}}},select:function(){if(this.atOccurrence){select.setCursorPos(this.editor.container,this.pos.from,this.pos.to);select.scrollToCursor(this.editor.container)}},replace:function(b){if(this.atOccurrence){this.pos.to=this.editor.replaceRange(this.pos.from,this.pos.to,b);this.atOccurrence=false}},position:function(){if(this.atOccurrence)return{line:this.pos.from.node,
character:this.pos.from.offset}}};u.prototype={importCode:function(b){this.history.push(null,null,e(b));this.history.reset()},getCode:function(){if(!this.container.firstChild)return"";var b=[];select.markSelection();forEach(i(this.container.firstChild),method(b,"push"));webkitLastLineHack(this.container);select.selectMarked();webkit&&this.container.lastChild.hackBR&&b.pop();return cleanText(b.join(""))},checkLine:function(b){if(b===false||!(b==null||b.parentNode==this.container))throw parent.CodeMirror.InvalidLineHandle;
},cursorPosition:function(b){if(b==null)b=true;return(b=select.cursorPos(this.container,b))?{line:b.node,character:b.offset}:{line:null,character:0}},firstLine:function(){return null},lastLine:function(){return this.container.lastChild?m(this.container.lastChild):null},nextLine:function(b){this.checkLine(b);return n(b,this.container)||false},prevLine:function(b){this.checkLine(b);if(b==null)return false;return m(b.previousSibling)},visibleLineCount:function(){for(var b=this.container.firstChild;b&&
isBR(b);)b=b.nextSibling;if(!b)return false;return Math.floor((window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight)/b.offsetHeight)},selectLines:function(b,a,c,d){this.checkLine(b);b={node:b,offset:a};a=null;if(d!==undefined){this.checkLine(c);a={node:c,offset:d}}select.setCursorPos(this.container,b,a);select.scrollToCursor(this.container)},lineContent:function(b){var a=[];for(b=b?b.nextSibling:this.container.firstChild;b&&!isBR(b);b=b.nextSibling)a.push(nodeText(b));
return cleanText(a.join(""))},setLineContent:function(b,a){this.history.commit();this.replaceRange({node:b,offset:0},{node:b,offset:this.history.textAfter(b).length},a);this.addDirtyNode(b);this.scheduleHighlight()},removeLine:function(b){for(var a=b?b.nextSibling:this.container.firstChild;a;){var c=a.nextSibling;removeElement(a);if(isBR(a))break;a=c}this.addDirtyNode(b);this.scheduleHighlight()},insertIntoLine:function(b,a,c){var d=null;if(a=="end")d=n(b,this.container);else for(var f=b?b.nextSibling:
this.container.firstChild;f;f=f.nextSibling){if(a==0){d=f;break}var g=nodeText(f);if(g.length>a){d=f.nextSibling;c=g.slice(0,a)+c+g.slice(a);removeElement(f);break}a-=g.length}a=e(c);for(c=0;c<a.length;c++){c>0&&this.container.insertBefore(document.createElement("BR"),d);this.container.insertBefore(makePartSpan(a[c]),d)}this.addDirtyNode(b);this.scheduleHighlight()},selectedText:function(){var b=this.history;b.commit();var a=select.cursorPos(this.container,true),c=select.cursorPos(this.container,
false);if(!a||!c)return"";if(a.node==c.node)return b.textAfter(a.node).slice(a.offset,c.offset);var d=[b.textAfter(a.node).slice(a.offset)];for(a=b.nodeAfter(a.node);a!=c.node;a=b.nodeAfter(a))d.push(b.textAfter(a));d.push(b.textAfter(c.node).slice(0,c.offset));return cleanText(d.join("\n"))},replaceSelection:function(b){this.history.commit();var a=select.cursorPos(this.container,true),c=select.cursorPos(this.container,false);if(a&&c){c=this.replaceRange(a,c,b);select.setCursorPos(this.container,
c);webkitLastLineHack(this.container)}},cursorCoords:function(b){function a(h,j){var l=-(document.body.scrollTop||document.documentElement.scrollTop||0),o=-(document.body.scrollLeft||document.documentElement.scrollLeft||0)+j;forEach([h,window.frameElement],function(s){for(;s;){o+=s.offsetLeft;l+=s.offsetTop;s=s.offsetParent}});return{x:o,y:l,yBot:l+h.offsetHeight}}function c(h,j){var l=document.createElement("SPAN");l.appendChild(document.createTextNode(h));try{return j(l)}finally{l.parentNode&&l.parentNode.removeChild(l)}}
var d=select.cursorPos(this.container,b);if(!d)return null;b=d.offset;for(var f=d.node,g=this;b;){f=f?f.nextSibling:this.container.firstChild;d=nodeText(f);if(b<d.length)return c(d.substr(0,b),function(h){h.style.position="absolute";h.style.visibility="hidden";h.className=f.className;g.container.appendChild(h);return a(f,h.offsetWidth)});b-=d.length}return f&&isSpan(f)?a(f,f.offsetWidth):f&&f.nextSibling&&isSpan(f.nextSibling)?a(f.nextSibling,0):c("\u200b",function(h){f?f.parentNode.insertBefore(h,
f.nextSibling):g.container.insertBefore(h,g.container.firstChild);return a(h,0)})},reroutePasteEvent:function(){if(!(this.capturingPaste||window.opera)){this.capturingPaste=true;var b=window.frameElement.CodeMirror.textareaHack;parent.focus();b.value="";b.focus();var a=this;this.parent.setTimeout(function(){a.capturingPaste=false;window.focus();a.selectionSnapshot&&window.select.setBookmark(a.container,a.selectionSnapshot);var c=b.value;if(c){a.replaceSelection(c);select.scrollToCursor(a.container)}},
10)}},replaceRange:function(b,a,c){c=e(c);c[0]=this.history.textAfter(b.node).slice(0,b.offset)+c[0];var d=c[c.length-1];c[c.length-1]=d+this.history.textAfter(a.node).slice(a.offset);a=this.history.nodeAfter(a.node);this.history.push(b.node,a,c);return{node:this.history.nodeBefore(a),offset:d.length}},getSearchCursor:function(b,a,c){return new p(this,b,a,c)},reindent:function(){this.container.firstChild&&this.indentRegion(null,this.container.lastChild)},reindentSelection:function(b){if(select.somethingSelected()){var a=
select.selectionTopNode(this.container,true),c=select.selectionTopNode(this.container,false);a===false||c===false||this.indentRegion(a,c,b)}else this.indentAtCursor(b)},grabKeys:function(b,a){this.frozen=b;this.keyFilter=a},ungrabKeys:function(){this.frozen="leave"},setParser:function(b,a){u.Parser=window[b];(a=a||this.options.parserConfig)&&u.Parser.configure&&u.Parser.configure(a);if(this.container.firstChild){forEach(this.container.childNodes,function(c){if(c.nodeType!=3)c.dirty=true});this.addDirtyNode(this.firstChild);
this.scheduleHighlight()}},keyDown:function(b){if(this.frozen=="leave")this.keyFilter=this.frozen=null;if(this.frozen&&(!this.keyFilter||this.keyFilter(b.keyCode,b))){b.stop();this.frozen(b)}else{var a=b.keyCode;this.delayScanning();this.options.autoMatchParens&&this.scheduleParenHighlight();if(a==13){if(b.ctrlKey&&!b.altKey)this.reparseBuffer();else{select.insertNewlineAtCursor();a=this.options.enterMode;if(a!="flat")this.indentAtCursor(a=="keep"?"keep":undefined);select.scrollToCursor(this.container)}b.stop()}else if(a==
9&&this.options.tabMode!="default"&&!b.ctrlKey){this.handleTab(!b.shiftKey);b.stop()}else if(a==32&&b.shiftKey&&this.options.tabMode=="default"){this.handleTab(true);b.stop()}else if(a==36&&!b.shiftKey&&!b.ctrlKey)this.home()&&b.stop();else if(a==35&&!b.shiftKey&&!b.ctrlKey)this.end()&&b.stop();else if(a==33&&!b.shiftKey&&!b.ctrlKey&&!gecko)this.pageUp()&&b.stop();else if(a==34&&!b.shiftKey&&!b.ctrlKey&&!gecko)this.pageDown()&&b.stop();else if((a==219||a==221)&&b.ctrlKey&&!b.altKey){this.highlightParens(b.shiftKey,
true);b.stop()}else if(b.metaKey&&!b.shiftKey&&(a==37||a==39)){var c=select.selectionTopNode(this.container);if(!(c===false||!this.container.firstChild)){if(a==37)select.focusAfterNode(m(c),this.container);else{a=n(c,this.container);select.focusAfterNode(a?a.previousSibling:this.container.lastChild,this.container)}b.stop()}}else if((b.ctrlKey||b.metaKey)&&!b.altKey)if(b.shiftKey&&a==90||a==89){select.scrollToNode(this.history.redo());b.stop()}else if(a==90||safari&&a==8){select.scrollToNode(this.history.undo());
b.stop()}else if(a==83&&this.options.saveFunction){this.options.saveFunction();b.stop()}else a==86&&!mac&&this.reroutePasteEvent()}},keyPress:function(b){var a=this.options.electricChars&&u.Parser.electricChars,c=this;if(this.frozen&&(!this.keyFilter||this.keyFilter(b.keyCode||b.code,b))||b.code==13||b.code==9&&this.options.tabMode!="default"||b.code==32&&b.shiftKey&&this.options.tabMode=="default")b.stop();else if(mac&&(b.ctrlKey||b.metaKey)&&b.character=="v")this.reroutePasteEvent();else if(a&&
a.indexOf(b.character)!=-1)this.parent.setTimeout(function(){c.indentAtCursor(null)},0);else if(brokenOpera)if(b.code==8){var d=select.selectionTopNode(this.container);c=this;var f=d?d.nextSibling:this.container.firstChild;d!==false&&f&&isBR(f)&&this.parent.setTimeout(function(){select.selectionTopNode(c.container)==f&&select.focusAfterNode(f.previousSibling,c.container)},20)}else if(b.code==46){d=select.selectionTopNode(this.container);c=this;d&&isBR(d)&&this.parent.setTimeout(function(){select.selectionTopNode(c.container)!=
d&&select.focusAfterNode(d,c.container)},20)}},keyUp:function(b){this.cursorActivity(b.keyCode>=16&&b.keyCode<=18||b.keyCode>=33&&b.keyCode<=40)},indentLineAfter:function(b,a){function c(o){o=o?o.nextSibling:d.container.firstChild;if(!o||!hasClass(o,"whitespace"))return null;return o}var d=this,f=c(b),g=0,h=f?f.currentText.length:0;if(a=="keep"){if(b){var j=c(m(b.previousSibling));if(j)g=j.currentText.length}}else{var l=f?f.nextSibling:b?b.nextSibling:this.container.firstChild;j=b&&l&&l.currentText?
l.currentText:"";if(a!=null&&this.options.tabMode=="shift")g=a?h+indentUnit:Math.max(0,h-indentUnit);else if(b)g=b.indentation(j,h,a);else if(u.Parser.firstIndentation)g=u.Parser.firstIndentation(j,h,a)}h=g-h;if(h<0)if(g==0){if(l)select.snapshotMove(f.firstChild,l.firstChild||l,0);removeElement(f);f=null}else{select.snapshotMove(f.firstChild,f.firstChild,h,true);f.currentText=makeWhiteSpace(g);f.firstChild.nodeValue=f.currentText}else if(h>0)if(f){f.currentText=makeWhiteSpace(g);f.firstChild.nodeValue=
f.currentText;select.snapshotMove(f.firstChild,f.firstChild,h,true)}else{f=makePartSpan(makeWhiteSpace(g));f.className="whitespace";b?insertAfter(f,b):this.container.insertBefore(f,this.container.firstChild);select.snapshotMove(l&&(l.firstChild||l),f.firstChild,g,false,true)}else f&&select.snapshotMove(f.firstChild,f.firstChild,g,false);h!=0&&this.addDirtyNode(b)},highlightAtCursor:function(){var b=select.selectionTopNode(this.container,true),a=select.selectionTopNode(this.container,false);if(b===
false||a===false)return false;select.markSelection();if(this.highlight(b,n(a,this.container),true,20)===false)return false;select.selectMarked();return true},handleTab:function(b){this.options.tabMode=="spaces"?select.insertTabAtCursor():this.reindentSelection(b)},home:function(){var b=select.selectionTopNode(this.container,true),a=b;if(b===false||!(!b||b.isPart||isBR(b))||!this.container.firstChild)return false;for(;b&&!isBR(b);)b=b.previousSibling;var c=b?b.nextSibling:this.container.firstChild;
c&&c!=a&&c.isPart&&hasClass(c,"whitespace")?select.focusAfterNode(c,this.container):select.focusAfterNode(b,this.container);select.scrollToCursor(this.container);return true},end:function(){var b=select.selectionTopNode(this.container,true);if(b===false)return false;b=n(b,this.container);if(!b)return false;select.focusAfterNode(b.previousSibling,this.container);select.scrollToCursor(this.container);return true},pageUp:function(){var b=this.cursorPosition().line,a=this.visibleLineCount();if(b===false||
a===false)return false;a-=2;for(var c=0;c<a;c++){b=this.prevLine(b);if(b===false)break}if(c==0)return false;select.setCursorPos(this.container,{node:b,offset:0});select.scrollToCursor(this.container);return true},pageDown:function(){var b=this.cursorPosition().line,a=this.visibleLineCount();if(b===false||a===false)return false;a-=2;for(var c=0;c<a;c++){var d=this.nextLine(b);if(d===false)break;b=d}if(c==0)return false;select.setCursorPos(this.container,{node:b,offset:0});select.scrollToCursor(this.container);
return true},scheduleParenHighlight:function(){this.parenEvent&&this.parent.clearTimeout(this.parenEvent);var b=this;this.parenEvent=this.parent.setTimeout(function(){b.highlightParens()},300)},highlightParens:function(b,a){function c(q,w){if(q)if(h.options.markParen)h.options.markParen(q,w);else{q.style.fontWeight="bold";q.style.color=w?"#8F8":"#F88"}}function d(q){if(q)if(h.options.unmarkParen)h.options.unmarkParen(q);else{q.style.fontWeight="";q.style.color=""}}function f(q){if(q.currentText)return(q=
q.currentText.match(/^[\s\u00a0]*([\(\)\[\]{}])[\s\u00a0]*$/))&&q[1]}function g(){for(var q=[],w,y=true,r=l;r;r=s?r.nextSibling:r.previousSibling)if(r.className==o&&isSpan(r)&&(w=f(r))){if(/[\(\[\{]/.test(w)==s)q.push(w);else if(q.length){if(q.pop()!=matching[w])y=false}else y=false;if(!q.length)break}else if(r.dirty||!isSpan(r)&&!isBR(r))return{node:r,status:"dirty"};return{node:r,status:r&&y}}var h=this;if(!a&&h.highlighted){d(h.highlighted[0]);d(h.highlighted[1])}if(window.parent&&window.select){this.parenEvent&&
this.parent.clearTimeout(this.parenEvent);this.parenEvent=null;var j,l=select.selectionTopNode(this.container,true);if(l&&this.highlightAtCursor())if((l=select.selectionTopNode(this.container,true))&&((j=f(l))||(l=l.nextSibling)&&(j=f(l))))for(var o=l.className,s=/[\(\[\{]/.test(j);;){var t=g();if(t.status=="dirty"){this.highlight(t.node,n(t.node));t.node.dirty=false}else{c(l,t.status);c(t.node,t.status);if(a)h.parent.setTimeout(function(){d(l);d(t.node)},500);else h.highlighted=[l,t.node];b&&t.node&&
select.focusAfterNode(t.node.previousSibling,this.container);break}}}},indentAtCursor:function(b){if(this.container.firstChild)if(this.highlightAtCursor()){var a=select.selectionTopNode(this.container,false);if(a!==false){select.markSelection();this.indentLineAfter(m(a),b);select.selectMarked()}}},indentRegion:function(b,a,c){var d=b=m(b),f=b&&m(b.previousSibling);isBR(a)||(a=n(a,this.container));this.addDirtyNode(b);do{var g=n(d,this.container);d&&this.highlight(f,g,true);this.indentLineAfter(d,
c);f=d;d=g}while(d!=a);select.setCursorPos(this.container,{node:b,offset:0},{node:a,offset:0})},cursorActivity:function(b){if(this.unloaded){window.document.designMode="off";window.document.designMode="on";this.unloaded=false}if(internetExplorer){this.container.createTextRange().execCommand("unlink");this.selectionSnapshot=select.getBookmark(this.container)}var a=this.options.cursorActivity;if(!b||a){var c=select.selectionTopNode(this.container,false);if(!(c===false||!this.container.firstChild)){c=
c||this.container.firstChild;a&&a(c);if(!b){this.scheduleHighlight();this.addDirtyNode(c)}}}},reparseBuffer:function(){forEach(this.container.childNodes,function(b){b.dirty=true});this.container.firstChild&&this.addDirtyNode(this.container.firstChild)},addDirtyNode:function(b){if(b=b||this.container.firstChild){for(var a=0;a<this.dirty.length;a++)if(this.dirty[a]==b)return;if(b.nodeType!=3)b.dirty=true;this.dirty.push(b)}},allClean:function(){return!this.dirty.length},scheduleHighlight:function(){var b=
this;this.parent.clearTimeout(this.highlightTimeout);this.highlightTimeout=this.parent.setTimeout(function(){b.highlightDirty()},this.options.passDelay)},getDirtyNode:function(){for(;this.dirty.length>0;){var b=this.dirty.pop();try{for(;b&&b.parentNode!=this.container;)b=b.parentNode;if(b&&(b.dirty||b.nodeType==3))return b}catch(a){}}return null},highlightDirty:function(b){if(!window.parent||!window.select)return false;this.options.readOnly||select.markSelection();for(var a,c=b?null:(new Date).getTime()+
this.options.passTime;((new Date).getTime()<c||b)&&(a=this.getDirtyNode());){var d=this.highlight(a,c);d&&d.node&&d.dirty&&this.addDirtyNode(d.node.nextSibling)}this.options.readOnly||select.selectMarked();a&&this.scheduleHighlight();return this.dirty.length==0},documentScanner:function(b){var a=this,c=null;return function(){if(window.parent&&window.select){if(c&&c.parentNode!=a.container)c=null;select.markSelection();var d=a.highlight(c,(new Date).getTime()+b,true);select.selectMarked();d=d?d.node&&
d.node.nextSibling:null;c=c==d?null:d;a.delayScanning()}}},delayScanning:function(){if(this.scanner){this.parent.clearTimeout(this.documentScan);this.documentScan=this.parent.setTimeout(this.scanner,this.options.continuousScanning)}},highlight:function(b,a,c,d){function f(r){if(r){var x=r.oldNextSibling;if(q||x===undefined||r.nextSibling!=x)h.history.touch(r);r.oldNextSibling=r.nextSibling}else{x=h.container.oldFirstChild;if(q||x===undefined||h.container.firstChild!=x)h.history.touch(null);h.container.oldFirstChild=
h.container.firstChild}}var g=this.container,h=this,j=this.options.activeTokens,l=typeof a=="number"?a:null;if(!g.firstChild)return false;for(;b&&(!b.parserFromHere||b.dirty);){if(d!=null&&isBR(b)&&--d<0)return false;b=b.previousSibling}if(b&&!b.nextSibling)return false;var o=i(b?b.nextSibling:g.firstChild);d=stringStream(o);var s=b?b.parserFromHere(d):u.Parser.make(d),t={current:null,get:function(){if(!this.current)this.current=o.nodes.shift();return this.current},next:function(){this.current=null},
remove:function(){g.removeChild(this.get());this.current=null},getNonEmpty:function(){for(var r=this.get();r&&isSpan(r)&&r.currentText=="";)if(window.opera&&(r.previousSibling==null||isBR(r.previousSibling))&&(r.nextSibling==null||isBR(r.nextSibling))){this.next();r=this.get()}else{var x=r;this.remove();r=this.get();select.snapshotMove(x.firstChild,r&&(r.firstChild||r),0)}return r}},q=false,w=true,y=0;forEach(s,function(r){var x=t.getNonEmpty();if(r.value=="\n"){if(!isBR(x))throw"Parser out of sync. Expected BR.";
if(x.dirty||!x.indentation)q=true;f(b);b=x;x.parserFromHere=s.copy();x.indentation=r.indentation;x.dirty=false;if(l==null&&x==a)throw StopIteration;if(l!=null&&(new Date).getTime()>=l||!q&&!w&&y>1&&!c)throw StopIteration;w=q;q=false;y=0;t.next()}else{if(!isSpan(x))throw"Parser out of sync. Expected SPAN.";if(x.dirty)q=true;y++;if(!x.reduced&&x.currentText==r.value&&x.className==r.style){x.dirty=false;t.next()}else{q=true;var z=makePartSpan(r.value);z.className=r.style;g.insertBefore(z,x);j&&j(z,r,
h);r=r.value.length;for(var B=0;r>0;){x=t.get();var A=x.currentText.length;select.snapshotReplaceNode(x.firstChild,z.firstChild,r,B);if(A>r){x=x;x.currentText=x.currentText.substring(r);x.reduced=true;r=0}else{r-=A;B+=A;t.remove()}}}}});f(b);webkitLastLineHack(this.container);return{node:t.getNonEmpty(),dirty:q}}};return u}();addEventHandler(window,"load",function(){var e=window.frameElement.CodeMirror;e.editor=new Editor(e.options);this.parent.setTimeout(method(e,"init"),0)});function tokenizer(e,k){function i(n){return n!="\n"&&/^[\s\u00a0]*$/.test(n)}var m={state:k,take:function(n){if(typeof n=="string")n={style:n,type:n};n.content=(n.content||"")+e.get();/\n$/.test(n.content)||e.nextWhile(i);n.value=n.content+e.get();return n},next:function(){if(!e.more())throw StopIteration;var n;if(e.equals("\n")){e.next();return this.take("whitespace")}if(e.applies(i))n="whitespace";else for(;!n;)n=this.state(e,function(p){m.state=p});return this.take(n)}};return m};