/* content from:
 * https://github.com/marijnh/CodeMirror/raw/master/js/util.js
 * https://github.com/marijnh/CodeMirror/raw/master/js/stringstream.js
 * https://github.com/marijnh/CodeMirror/raw/master/js/select.js
 * https://github.com/marijnh/CodeMirror/raw/master/js/undo.js
 * https://github.com/marijnh/CodeMirror/raw/master/js/editor.js
 * https://github.com/marijnh/CodeMirror/raw/master/js/tokenize.js
 * closure compiled 2011-05-17 */
function method(b,f){return function(){b[f].apply(b,arguments)}}var StopIteration={toString:function(){return"StopIteration"}};function forEach(b,f){if(b.next)try{for(;;)f(b.next())}catch(c){if(c!=StopIteration)throw c;}else for(var d=0;d<b.length;d++)f(b[d])}function map(b,f){var c=[];forEach(b,function(b){c.push(f(b))});return c}function matcher(b){return function(f){return b.test(f)}}function hasClass(b,f){var c=b.className;return c&&RegExp("(^| )"+f+"($| )").test(c)}
function removeClass(b,f){b.className=b.className.replace(RegExp(" "+f+"\\b","g"),"");return b}function insertAfter(b,f){f.parentNode.insertBefore(b,f.nextSibling);return b}function removeElement(b){b.parentNode&&b.parentNode.removeChild(b)}function clearElement(b){for(;b.firstChild;)b.removeChild(b.firstChild)}function isAncestor(b,f){for(;f=f.parentNode;)if(b==f)return!0;return!1}var nbsp="\u00a0",matching={"{":"}","[":"]","(":")","}":"{","]":"[",")":"("};
function normalizeEvent(b){if(!b.stopPropagation)b.stopPropagation=function(){this.cancelBubble=!0},b.preventDefault=function(){this.returnValue=!1};if(!b.stop)b.stop=function(){this.stopPropagation();this.preventDefault()};if(b.type=="keypress")b.code=b.charCode==null?b.keyCode:b.charCode,b.character=String.fromCharCode(b.code);return b}
function addEventHandler(b,f,c,d){function h(b){c(normalizeEvent(b||window.event))}if(typeof b.addEventListener=="function"){if(b.addEventListener(f,h,!1),d)return function(){b.removeEventListener(f,h,!1)}}else if(b.attachEvent("on"+f,h),d)return function(){b.detachEvent("on"+f,h)}}function nodeText(b){return b.textContent||b.innerText||b.nodeValue||""}function nodeTop(b){for(var f=0;b.offsetParent;)f+=b.offsetTop,b=b.offsetParent;return f}function isBR(b){b=b.nodeName;return b=="BR"||b=="br"}
function isSpan(b){b=b.nodeName;return b=="SPAN"||b=="span"};var stringStream=function(b){function f(){for(;d==c.length;){h+=c;c="";d=0;try{c=b.next()}catch(f){if(f!=StopIteration)throw f;else return!1}}return!0}var c="",d=0,h="";return{peek:function(){if(!f())return null;return c.charAt(d)},next:function(){if(!f())if(h.length>0)throw"End of stringstream reached without emptying buffer ('"+h+"').";else throw StopIteration;return c.charAt(d++)},get:function(){var b=h;h="";d>0&&(b+=c.slice(0,d),c=c.slice(d),d=0);return b},push:function(b){c=c.slice(0,d)+b+c.slice(d)},
lookAhead:function(f,o,a,e){function g(a){return e?a.toLowerCase():a}var f=g(f),m=!1,r=h,n=d;for(a&&this.nextWhileMatches(/[\s\u00a0]/);;){var a=d+f.length,i=c.length-d;if(a<=c.length){m=f==g(c.slice(d,a));d=a;break}else if(f.slice(0,i)==g(c.slice(d))){h+=c;c="";try{c=b.next()}catch(k){if(k!=StopIteration)throw k;break}d=0;f=f.slice(i)}else break}if(!m||!o)c=h.slice(r.length)+c,d=n,h=r;return m},lookAheadRegex:function(f,h){if(f.source.charAt(0)!="^")throw Error("Regexps passed to lookAheadRegex must start with ^");
for(;c.indexOf("\n",d)==-1;)try{c+=b.next()}catch(a){if(a!=StopIteration)throw a;break}var e=c.slice(d).match(f);e&&h&&(d+=e[0].length);return e},more:function(){return this.peek()!==null},applies:function(b){var c=this.peek();return c!==null&&b(c)},nextWhile:function(b){for(var c;(c=this.peek())!==null&&b(c);)this.next()},matches:function(b){var c=this.peek();return c!==null&&b.test(c)},nextWhileMatches:function(b){for(var c;(c=this.peek())!==null&&b.test(c);)this.next()},equals:function(b){return b===
this.peek()},endOfLine:function(){var b=this.peek();return b==null||b=="\n"}}};var select={};
(function(){function b(a,e){for(;a&&a.parentNode!=e;)a=a.parentNode;return a}function f(a,e){for(;!a.previousSibling&&a.parentNode!=e;)a=a.parentNode;return b(a.previousSibling,e)}function c(a){var e=a.nextSibling;if(e){for(;e.firstChild;)e=e.firstChild;return e.nodeType==3||isBR(e)?e:c(e)}else{for(a=a.parentNode;a&&!a.nextSibling;)a=a.parentNode;return a&&c(a)}}select.ie_selection=document.selection&&document.selection.createRangeCollection;select.scrollToNode=function(a,e){if(a){for(var b=a,g=document.body,
k=document.documentElement,j=!b.nextSibling||!b.nextSibling.nextSibling||!b.nextSibling.nextSibling.nextSibling,c=0;b&&!b.offsetTop;)c++,b=b.previousSibling;c==0&&(j=!1);if(!webkit||!b||!(b.offsetTop==5&&b.offsetLeft==5)){c*=b?b.offsetHeight:0;for(var f=0,d=a?a.offsetWidth:0;b&&b.offsetParent;)c+=b.offsetTop,isBR(b)||(f+=b.offsetLeft),b=b.offsetParent;var b=g.scrollLeft||k.scrollLeft||0,g=g.scrollTop||k.scrollTop||0,p=!1,h=window.innerWidth||k.clientWidth||0;if(e||d<h){if(e){var o=select.offsetInNode(a),
w=nodeText(a).length;w&&(f+=d*(o/w))}d=f-b;if(d<0||d>h)b=f,p=!0}f=c-g;if(f<0||j||f>(window.innerHeight||k.clientHeight||0)-50)g=j?1E6:c,p=!0;p&&window.scrollTo(b,g)}}};select.scrollToCursor=function(a){select.scrollToNode(select.selectionTopNode(a,!0)||a.firstChild,!0)};var d=null;select.snapshotChanged=function(){if(d)d.changed=!0};select.snapshotReplaceNode=function(a,e,b,g){function k(j){if(a==j.node)d.changed=!0,b&&j.offset>b?j.offset-=b:(j.node=e,j.offset+=g||0);else if(select.ie_selection&&
j.offset==0&&j.node==c(a))d.changed=!0}d&&(k(d.start),k(d.end))};select.snapshotMove=function(a,e,b,g,k){function j(j){if(a==j.node&&(!k||j.offset==0))d.changed=!0,j.node=e,j.offset=g?Math.max(0,j.offset+b):b}d&&(j(d.start),j(d.end))};if(select.ie_selection){var h=function(){var a=document.selection;if(!a)return null;return a.createRange?a.createRange():a.createTextRange()},l=function(a){function e(a){for(var m=null;!m&&a;)m=a.nextSibling,a=a.parentNode;return b(m)}function b(a){for(;a&&a.firstChild;)a=
a.firstChild;return{node:a,offset:0}}var g=h();g.collapse(a);a=g.parentElement();if(!isAncestor(document.body,a))return null;if(!a.firstChild)return b(a);var k=g.duplicate();k.moveToElementText(a);k.collapse(!0);for(var j=a.firstChild;j;j=j.nextSibling){if(j.nodeType==3){var c=j.nodeValue.length;k.move("character",c)}else k.moveToElementText(j),k.collapse(!1);var f=g.compareEndPoints("StartToStart",k);if(f==0)return e(j);if(f!=1){if(j.nodeType!=3)return b(j);k.setEndPoint("StartToEnd",g);return{node:j,
offset:c-k.text.length}}}return e(a)};select.markSelection=function(){d=null;if(document.selection){var a=l(!0),e=l(!1);a&&e&&(d={start:a,end:e,changed:!1})}};select.selectMarked=function(){function a(e){var b=document.body.createTextRange(),m=e.node;if(m)if(m.nodeType==3){b.moveToElementText(m.parentNode);for(e=e.offset;m.previousSibling;)m=m.previousSibling,e+=(m.innerText||"").length;b.move("character",e)}else b.moveToElementText(m),b.collapse(!0);else b.moveToElementText(document.body),b.collapse(!1);
return b}if(d&&d.changed){var e=a(d.start),b=a(d.end);e.setEndPoint("StartToEnd",b);e.select()}};select.offsetInNode=function(a){var e=h();if(!e)return 0;var b=e.duplicate();try{b.moveToElementText(a)}catch(g){return 0}e.setEndPoint("StartToStart",b);return e.text.length};select.selectionTopNode=function(a,e){function g(a,e){if(e.nodeType==3){for(var b=0,m=e.previousSibling;m&&m.nodeType==3;)b+=m.nodeValue.length,m=m.previousSibling;if(m){try{a.moveToElementText(m)}catch(r){return!1}a.collapse(!1)}else a.moveToElementText(e.parentNode);
b&&a.move("character",b)}else try{a.moveToElementText(e)}catch(n){return!1}return!0}var i=h();if(!i)return!1;var c=i.duplicate();i.collapse(e);var j=i.parentElement();if(j&&isAncestor(a,j)&&(c.moveToElementText(j),i.compareEndPoints("StartToStart",c)==1))return b(j,a);e=0;for(j=a.childNodes.length-1;e<j;){var f=Math.ceil((j+e)/2),d=a.childNodes[f];if(!d)return!1;if(!g(c,d))return!1;i.compareEndPoints("StartToStart",c)==1?e=f:j=f-1}if(e==0){i=h();c=i.duplicate();try{c.moveToElementText(a)}catch(o){return null}if(i.compareEndPoints("StartToStart",
c)==0)return null}return a.childNodes[e]||null};select.focusAfterNode=function(a,e){var b=document.body.createTextRange();b.moveToElementText(a||e);b.collapse(!a);b.select()};select.somethingSelected=function(){var a=h();return a&&a.text!=""};var o=function(a){var e=h();e&&(e.pasteHTML(a),e.collapse(!1),e.select())};select.insertNewlineAtCursor=function(){o("<br>")};select.insertTabAtCursor=function(){o("\u00a0\u00a0\u00a0\u00a0")};select.cursorPos=function(a,e){var b=h();if(!b)return null;for(var g=
select.selectionTopNode(a,e);g&&!isBR(g);)g=g.previousSibling;var c=b.duplicate();b.collapse(e);if(g)c.moveToElementText(g),c.collapse(!1);else{try{c.moveToElementText(a)}catch(j){return null}c.collapse(!0)}b.setEndPoint("StartToStart",c);return{node:g,offset:b.text.length}};select.setCursorPos=function(a,e,b){function g(e){var b=document.body.createTextRange();e.node?(b.moveToElementText(e.node),b.collapse(!1)):(b.moveToElementText(a),b.collapse(!0));b.move("character",e.offset);return b}var c=g(e);
b&&b!=e&&c.setEndPoint("EndToEnd",g(b));c.select()};select.getBookmark=function(a){var e=select.cursorPos(a,!0),a=select.cursorPos(a,!1);if(e&&a)return{from:e,to:a}};select.setBookmark=function(a,e){e&&select.setCursorPos(a,e.from,e.to)}}else{var a=function(a,e){for(;a.nodeType!=3&&!isBR(a);){for(var b=a.childNodes[e]||a.nextSibling,e=0;!b&&a.parentNode;)a=a.parentNode,b=a.nextSibling;a=b;if(!b)break}return{node:a,offset:e}};select.markSelection=function(){var e=window.getSelection();if(!e||e.rangeCount==
0)return d=null;e=e.getRangeAt(0);d={start:a(e.startContainer,e.startOffset),end:a(e.endContainer,e.endOffset),changed:!1}};select.selectMarked=function(){function b(){if(n.start.node==n.end.node&&n.start.offset==n.end.offset){var e=window.getSelection();if(!e||e.rangeCount==0)return!0;e=e.getRangeAt(0);e=a(e.startContainer,e.startOffset);return n.start.node!=e.node||n.start.offset!=e.offset}}function g(a,e){if(a.node)if(a.offset==0)c["set"+e+"Before"](a.node);else c["set"+e](a.node,a.offset);else c.setStartAfter(document.body.lastChild||
document.body)}var n=d;if(n&&(n.changed||webkit&&b())){var c=document.createRange();g(n.end,"End");g(n.start,"Start");e(c)}};var e=function(a){var e=window.getSelection();e&&(e.removeAllRanges(),e.addRange(a))},g=function(){var a=window.getSelection();return!a||a.rangeCount==0?!1:a.getRangeAt(0)};select.selectionTopNode=function(a,e){var c=g();if(!c)return!1;var i=e?c.startContainer:c.endContainer,d=e?c.startOffset:c.endOffset;window.opera&&!e&&c.endContainer==a&&c.endOffset==c.startOffset+1&&a.childNodes[c.startOffset]&&
isBR(a.childNodes[c.startOffset])&&d--;return i.nodeType==3?d>0?b(i,a):f(i,a):i.nodeName.toUpperCase()=="HTML"?d==1?null:a.lastChild:i==a?d==0?null:i.childNodes[d-1]:d==i.childNodes.length?b(i,a):d==0?f(i,a):b(i.childNodes[d-1],a)};select.focusAfterNode=function(a,b){var g=document.createRange();g.setStartBefore(b.firstChild||b);a&&!a.firstChild?g.setEndAfter(a):a?g.setEnd(a,a.childNodes.length):g.setEndBefore(b.firstChild||b);g.collapse(!1);e(g)};select.somethingSelected=function(){var a=g();return a&&
!a.collapsed};select.offsetInNode=function(a){var e=g();if(!e)return 0;e=e.cloneRange();e.setStartBefore(a);return e.toString().length};select.insertNodeAtCursor=function(a){var b=g();if(b){b.deleteContents();b.insertNode(a);webkitLastLineHack(document.body);if(window.opera&&isBR(a)&&isSpan(a.parentNode)){var b=a.nextSibling,c=a.parentNode,i=c.parentNode;i.insertBefore(a,c.nextSibling);for(c="";b&&b.nodeType==3;b=b.nextSibling)c+=b.nodeValue,removeElement(b);i.insertBefore(makePartSpan(c,document),
a.nextSibling)}b=document.createRange();b.selectNode(a);b.collapse(!1);e(b)}};select.insertNewlineAtCursor=function(){select.insertNodeAtCursor(document.createElement("BR"))};select.insertTabAtCursor=function(){select.insertNodeAtCursor(document.createTextNode("\u00a0\u00a0\u00a0\u00a0"))};select.cursorPos=function(a,e){var b=g();if(b){for(var c=select.selectionTopNode(a,e);c&&!isBR(c);)c=c.previousSibling;b=b.cloneRange();b.collapse(e);c?b.setStartAfter(c):b.setStartBefore(a);return{node:c,offset:b.toString().length}}};
select.setCursorPos=function(a,b,g){function c(e,b,g){function i(a){a.nodeType==3?n.push(a):forEach(a.childNodes,i)}if(b==0&&e&&!e.nextSibling)return f["set"+g+"After"](e),!0;if(e=e?e.nextSibling:a.firstChild){if(b==0)return f["set"+g+"Before"](e),!0;for(var n=[];;){for(;e&&!n.length;)i(e),e=e.nextSibling;var r=n.shift();if(!r)return!1;var d=r.nodeValue.length;if(d>=b)return f["set"+g](r,b),!0;b-=d}}}var f=document.createRange(),g=g||b;c(g.node,g.offset,"End")&&c(b.node,b.offset,"Start")&&e(f)}}})();function UndoHistory(b,f,c,d){this.container=b;this.maxDepth=f;this.commitDelay=c;this.editor=d;this.last=this.first=b={text:"",from:null,to:null};this.firstTouched=!1;this.history=[];this.redoHistory=[];this.touched=[];this.lostundo=0}
UndoHistory.prototype={scheduleCommit:function(){var b=this;parent.clearTimeout(this.commitTimeout);this.commitTimeout=parent.setTimeout(function(){b.tryCommit()},this.commitDelay)},touch:function(b){this.setTouched(b);this.scheduleCommit()},undo:function(){this.commit();if(this.history.length){var b=this.history.pop();this.redoHistory.push(this.updateTo(b,"applyChain"));this.notifyEnvironment();return this.chainNode(b)}},redo:function(){this.commit();if(this.redoHistory.length){var b=this.redoHistory.pop();
this.addUndoLevel(this.updateTo(b,"applyChain"));this.notifyEnvironment();return this.chainNode(b)}},clear:function(){this.history=[];this.redoHistory=[];this.lostundo=0},historySize:function(){return{undo:this.history.length,redo:this.redoHistory.length,lostundo:this.lostundo}},push:function(b,f,c){for(var d=[],h=0;h<c.length;h++){var l=h==c.length-1?f:document.createElement("br");d.push({from:b,to:l,text:cleanText(c[h])});b=l}this.pushChains([d],b==null&&f==null);this.notifyEnvironment()},pushChains:function(b,
f){this.commit(f);this.addUndoLevel(this.updateTo(b,"applyChain"));this.redoHistory=[]},chainNode:function(b){for(var f=0;f<b.length;f++){var c=b[f][0];if(c=c&&(c.from||c.to))return c}},reset:function(){this.history=[];this.redoHistory=[];this.lostundo=0},textAfter:function(b){return this.after(b).text},nodeAfter:function(b){return this.after(b).to},nodeBefore:function(b){return this.before(b).from},tryCommit:function(){window&&window.parent&&window.UndoHistory&&(this.editor.highlightDirty()?this.commit(!0):
this.scheduleCommit())},commit:function(b){parent.clearTimeout(this.commitTimeout);b||this.editor.highlightDirty(!0);b=this.touchedChains();if(b.length)this.addUndoLevel(this.updateTo(b,"linkChain")),this.redoHistory=[],this.notifyEnvironment()},updateTo:function(b,f){for(var c=[],d=[],h=0;h<b.length;h++)c.push(this.shadowChain(b[h])),d.push(this[f](b[h]));f=="applyChain"&&this.notifyDirty(d);return c},notifyDirty:function(b){forEach(b,method(this.editor,"addDirtyNode"));this.editor.scheduleHighlight()},
notifyEnvironment:function(){if(this.onChange)this.onChange(this.editor);window.frameElement&&window.frameElement.CodeMirror.updateNumbers&&window.frameElement.CodeMirror.updateNumbers()},linkChain:function(b){for(var f=0;f<b.length;f++){var c=b[f];c.from?c.from.historyAfter=c:this.first=c;c.to?c.to.historyBefore=c:this.last=c}},after:function(b){return b?b.historyAfter:this.first},before:function(b){return b?b.historyBefore:this.last},setTouched:function(b){if(b){if(!b.historyTouched)this.touched.push(b),
b.historyTouched=!0}else this.firstTouched=!0},addUndoLevel:function(b){this.history.push(b);this.history.length>this.maxDepth&&(this.history.shift(),this.lostundo+=1)},touchedChains:function(){function b(b){for(var a=[],e=b?b.nextSibling:c.container.firstChild;e&&(!isBR(e)||e.hackBR);e=e.nextSibling)!e.hackBR&&e.currentText&&a.push(e.currentText);return{from:b,to:e,text:cleanText(a.join(""))}}function f(b,a){for(var e=a+"Sibling",g=b[e];g&&!isBR(g);)g=g[e];return g}var c=this,d=null,h=[];c.firstTouched&&
c.touched.push(null);forEach(c.touched,function(f){if(!f||!(f.parentNode!=c.container||f.hackBR)){f?f.historyTouched=!1:c.firstTouched=!1;var a=b(f),e=c.after(f);if(!e||e.text!=a.text||e.to!=a.to)h.push(a),f?f.historyTemp=a:d=a}});var l=[];c.touched=[];forEach(h,function(h){if(h.from?h.from.historyTemp:d){for(var a=[],e=h.from,g=!0;;){var m=e?e.historyTemp:d;if(!m)if(g)break;else m=b(e);a.unshift(m);e?e.historyTemp=null:d=null;if(!e)break;g=c.after(e);e=f(e,"previous")}e=h.to;for(g=c.before(h.from);;){if(!e)break;
m=e?e.historyTemp:d;if(!m)if(g)break;else m=b(e);a.push(m);e?e.historyTemp=null:d=null;g=c.before(e);e=f(e,"next")}l.push(a)}});return l},shadowChain:function(b){for(var f=[],c=this.after(b[0].from),b=b[b.length-1].to;;)if(f.push(c),c=c.to,!c||c==b)break;else c=c.historyAfter||this.before(b);return f},applyChain:function(b){var f=select.cursorPos(this.container,!1),c=this,d=b[0].from,h=b[b.length-1].to;(function(a,e){for(var b=a?a.nextSibling:c.container.firstChild;b!=e;){var g=b.nextSibling;removeElement(b);
b=g}})(d,h);for(var l=0;l<b.length;l++){var o=b[l];l>0&&c.container.insertBefore(o.from,h);var a=makePartSpan(fixSpaces(o.text));c.container.insertBefore(a,h);if(f&&f.node==o.from){var a=0,e=this.after(o.from);if(e&&l==b.length-1){for(var g=0;g<f.offset&&o.text.charAt(g)==e.text.charAt(g);g++);f.offset>g&&(a=o.text.length-e.text.length)}select.setCursorPos(this.container,{node:o.from,offset:Math.max(0,f.offset+a)})}else f&&l==b.length-1&&f.node&&f.node.parentNode!=this.container&&select.setCursorPos(this.container,
{node:o.from,offset:o.text.length})}this.linkChain(b);return d}};var internetExplorer=document.selection&&window.ActiveXObject&&/MSIE/.test(navigator.userAgent),webkit=/AppleWebKit/.test(navigator.userAgent),safari=/Apple Computer, Inc/.test(navigator.vendor),gecko=navigator.userAgent.match(/gecko\/(\d{8})/i);gecko&&(gecko=Number(gecko[1]));var mac=/Mac/.test(navigator.platform),brokenOpera=window.opera&&/Version\/10.[56]/.test(navigator.userAgent),slowWebkit=/AppleWebKit\/533/.test(navigator.userAgent);
function makeWhiteSpace(b){for(var f=[],c=!0;b>0;b--)f.push(c||b==1?nbsp:" "),c^=1;return f.join("")}function fixSpaces(b){b.charAt(0)==" "&&(b=nbsp+b.slice(1));return b.replace(/\t/g,function(){return makeWhiteSpace(indentUnit)}).replace(/[ \u00a0]{2,}/g,function(b){return makeWhiteSpace(b.length)})}function cleanText(b){return b.replace(/\u00a0/g," ").replace(/\u200b/g,"")}
function makePartSpan(b){var f=b;b.nodeType==3?f=b.nodeValue:b=document.createTextNode(f);var c=document.createElement("span");c.isPart=!0;c.appendChild(b);c.currentText=f;return c}function alwaysZero(){return 0}var webkitLastLineHack=webkit?function(b){var f=b.lastChild;if(!f||!f.hackBR)f=document.createElement("br"),f.hackBR=!0,b.appendChild(f)}:function(){};
function asEditorLines(b){var f=makeWhiteSpace(indentUnit);return map(b.replace(/\t/g,f).replace(/\u00a0/g," ").replace(/\r\n?/g,"\n").split("\n"),fixSpaces)}
var Editor=function(){function b(a,e){function b(a,i){if(a.nodeType==3)(a.nodeValue=fixSpaces(a.nodeValue.replace(/[\r\u200b]/g,"").replace(/\n/g," "))).length&&(f=!1),c.push(a);else if(isBR(a)&&a.childNodes.length==0)f=!0,c.push(a);else{for(var d=a.firstChild;d;d=d.nextSibling)b(d);!f&&o.hasOwnProperty(a.nodeName.toUpperCase())&&(f=!0,(!e||!i)&&c.push(document.createElement("br")))}}var c=[],f=!0;b(a,!0);return c}function f(a){function e(a){var e=a.parentNode,b=a.nextSibling;return function(a){e.insertBefore(a,
b)}}var g=[],c=null,f=!0;return{next:function(){if(!a)throw StopIteration;var d=a;a=d.nextSibling;var i;d.isPart&&d.childNodes.length==1&&d.firstChild.nodeType==3?(i=d.firstChild.nodeValue,d.dirty=d.dirty||i!=d.currentText,d.currentText=i,i=!/[\n\t\r]/.test(d.currentText)):i=!1;if(i)return g.push(d),f=!1,d.currentText;else if(isBR(d))return f&&window.opera&&d.parentNode.insertBefore(makePartSpan(""),d),g.push(d),f=!0,"\n";else{i=!d.nextSibling;c=e(d);removeElement(d);d=b(d,i);for(i=0;i<d.length;i++){var h=
d,j=i,s=d[i],t="\n";s.nodeType==3?(select.snapshotChanged(),s=makePartSpan(s),t=s.currentText,f=!1):(f&&window.opera&&c(makePartSpan("")),f=!0);s.dirty=!0;g.push(s);c(s);h[j]=t}return d.join("")}},nodes:g}}function c(a){for(;a&&!isBR(a);)a=a.previousSibling;return a}function d(a,e){if(a){if(isBR(a))a=a.nextSibling}else a=e.firstChild;for(;a&&!isBR(a);)a=a.nextSibling;return a}function h(a,e,b,c){function f(e){e=cleanText(a.history.textAfter(e));return c?e.toLowerCase():e}this.editor=a;this.history=
a.history;this.history.commit();this.valid=!!e;this.atOccurrence=!1;c==void 0&&(c=typeof e=="string"&&e==e.toLowerCase());var d={node:null,offset:0},i=this;b&&typeof b=="object"&&typeof b.character=="number"?(a.checkLine(b.line),b={node:b.line,offset:b.character},this.pos={from:b,to:b}):this.pos=b?{from:select.cursorPos(a.container,!0)||d,to:select.cursorPos(a.container,!1)||d}:{from:d,to:d};if(typeof e!="string")this.matches=function(a,b,g){if(a)for(var a=f(b).slice(0,g),c=a.match(e),g=0;c;){var d=
a.indexOf(c[0]);g+=d;a=a.slice(d+1);if(d=a.match(e))c=d;else break}else a=f(b).slice(g),g=(c=a.match(e))&&g+a.indexOf(c[0]);if(c)return i.currentMatch=c,{from:{node:b,offset:g},to:{node:b,offset:g+c[0].length}}};else{c&&(e=e.toLowerCase());var h=e.split("\n");this.matches=h.length==1?function(a,b,g){var c=f(b),d=e.length,m;if(a?g>=d&&(m=c.lastIndexOf(e,g-d))!=-1:(m=c.indexOf(e,g))!=-1)return{from:{node:b,offset:m},to:{node:b,offset:m+d}}}:function(a,e,b){var g=a?h.length-1:0,c=h[g],d=f(e),m=a?d.indexOf(c)+
c.length:d.lastIndexOf(c);if(!(a?m>=b||m!=c.length:m<=b||m!=d.length-c.length))for(b=e;;){if(a&&!b)break;b=a?this.history.nodeBefore(b):this.history.nodeAfter(b);if(!a&&!b)break;d=f(b);c=h[a?--g:++g];if(g>0&&g<h.length-1)if(d!=c)break;else continue;g=a?d.lastIndexOf(c):d.indexOf(c)+c.length;if(a?g!=d.length-c.length:g!=c.length)break;return{from:{node:a?b:e,offset:a?g:m},to:{node:a?e:b,offset:a?m:g}}}}}}function l(a){this.options=a;window.indentUnit=a.indentUnit;var b=this.container=document.body;
this.history=new UndoHistory(b,a.undoDepth,a.undoDelay,this);var g=this;if(!l.Parser)throw"No parser loaded.";a.parserConfig&&l.Parser.configure&&l.Parser.configure(a.parserConfig);!a.readOnly&&!internetExplorer&&select.setCursorPos(b,{node:null,offset:0});this.dirty=[];this.importCode(a.content||"");this.history.onChange=a.onChange;if(a.readOnly){if(!a.textWrapping)b.style.whiteSpace="nowrap"}else{if(a.continuousScanning!==!1)this.scanner=this.documentScanner(a.passTime),this.delayScanning();var c=
function(){document.body.contentEditable!=void 0&&internetExplorer?document.body.contentEditable="true":document.designMode="on";if(internetExplorer&&a.height!="dynamic")document.body.style.minHeight=window.frameElement.clientHeight-2*document.body.offsetTop-5+"px";document.documentElement.style.borderWidth="0";if(!a.textWrapping)b.style.whiteSpace="nowrap"};try{c()}catch(d){var f=addEventHandler(document,"focus",function(){f();c()},!0)}addEventHandler(document,"keydown",method(this,"keyDown"));addEventHandler(document,
"keypress",method(this,"keyPress"));addEventHandler(document,"keyup",method(this,"keyUp"));var i=function(){g.cursorActivity(!1)};addEventHandler(internetExplorer?document.body:window,"mouseup",i);addEventHandler(document.body,"cut",i);gecko&&addEventHandler(window,"pagehide",function(){g.unloaded=!0});addEventHandler(document.body,"paste",function(a){i();var b=null;try{var e=a.clipboardData||window.clipboardData;e&&(b=e.getData("Text"))}catch(c){}b!==null&&(a.stop(),g.replaceSelection(b),select.scrollToCursor(g.container))});
this.options.autoMatchParens&&addEventHandler(document.body,"click",method(this,"scheduleParenHighlight"))}}var o={P:!0,DIV:!0,LI:!0};h.prototype={findNext:function(){return this.find(!1)},findPrevious:function(){return this.find(!0)},find:function(a){function b(){var a={node:d,offset:f};g.pos={from:a,to:a};return g.atOccurrence=!1}if(!this.valid)return!1;var g=this,c=a?this.pos.from:this.pos.to,d=c.node,f=c.offset;d&&!d.parentNode&&(d=null,f=0);for(;;){if(this.pos=this.matches(a,d,f))return this.atOccurrence=
!0;if(a){if(!d)return b();d=this.history.nodeBefore(d);f=this.history.textAfter(d).length}else{c=this.history.nodeAfter(d);if(!c)return f=this.history.textAfter(d).length,b();d=c;f=0}}},select:function(){this.atOccurrence&&(select.setCursorPos(this.editor.container,this.pos.from,this.pos.to),select.scrollToCursor(this.editor.container))},replace:function(a){if(this.atOccurrence){var b=this.currentMatch;b&&(a=a.replace(/\\(\d)/,function(a,c){return b[c]}));this.pos.to=this.editor.replaceRange(this.pos.from,
this.pos.to,a);this.atOccurrence=!1}},position:function(){if(this.atOccurrence)return{line:this.pos.from.node,character:this.pos.from.offset}}};l.prototype={importCode:function(a){var b=asEditorLines(a);if(!this.options.incrementalLoading||b.length<1E3)this.history.push(null,null,b),this.history.reset();else{var c=0,d=this,f=function(){var a=b.slice(c,c+1E3);a.push("");d.history.push(d.history.nodeBefore(null),null,a);d.history.reset();c+=1E3;c<b.length&&parent.setTimeout(f,1E3)};f()}},getCode:function(){if(!this.container.firstChild)return"";
var a=[];select.markSelection();forEach(f(this.container.firstChild),method(a,"push"));select.selectMarked();webkit&&this.container.lastChild.hackBR&&a.pop();webkitLastLineHack(this.container);return cleanText(a.join(""))},checkLine:function(a){if(a===!1||!(a==null||a.parentNode==this.container||a.hackBR))throw parent.CodeMirror.InvalidLineHandle;},cursorPosition:function(a){a==null&&(a=!0);return(a=select.cursorPos(this.container,a))?{line:a.node,character:a.offset}:{line:null,character:0}},firstLine:function(){return null},
lastLine:function(){var a=this.container.lastChild;a&&(a=c(a));a&&a.hackBR&&(a=c(a.previousSibling));return a},nextLine:function(a){this.checkLine(a);a=d(a,this.container);return!a||a.hackBR?!1:a},prevLine:function(a){this.checkLine(a);if(a==null)return!1;return c(a.previousSibling)},visibleLineCount:function(){for(var a=this.container.firstChild;a&&isBR(a);)a=a.nextSibling;if(!a)return!1;return Math.floor((window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight)/a.offsetHeight)},
selectLines:function(a,b,c,d){this.checkLine(a);a={node:a,offset:b};b=null;d!==void 0&&(this.checkLine(c),b={node:c,offset:d});select.setCursorPos(this.container,a,b);select.scrollToCursor(this.container)},lineContent:function(a){for(var b=[],a=a?a.nextSibling:this.container.firstChild;a&&!isBR(a);a=a.nextSibling)b.push(nodeText(a));return cleanText(b.join(""))},setLineContent:function(a,b){this.history.commit();this.replaceRange({node:a,offset:0},{node:a,offset:this.history.textAfter(a).length},
b);this.addDirtyNode(a);this.scheduleHighlight()},removeLine:function(a){for(var b=a?a.nextSibling:this.container.firstChild;b;){var c=b.nextSibling;removeElement(b);if(isBR(b))break;b=c}this.addDirtyNode(a);this.scheduleHighlight()},insertIntoLine:function(a,b,c){var f=null;if(b=="end")f=d(a,this.container);else for(var h=a?a.nextSibling:this.container.firstChild;h;h=h.nextSibling){if(b==0){f=h;break}var n=nodeText(h);if(n.length>b){f=h.nextSibling;c=n.slice(0,b)+c+n.slice(b);removeElement(h);break}b-=
n.length}b=asEditorLines(c);for(c=0;c<b.length;c++)c>0&&this.container.insertBefore(document.createElement("BR"),f),this.container.insertBefore(makePartSpan(b[c]),f);this.addDirtyNode(a);this.scheduleHighlight()},selectedText:function(){var a=this.history;a.commit();var b=select.cursorPos(this.container,!0),c=select.cursorPos(this.container,!1);if(!b||!c)return"";if(b.node==c.node)return a.textAfter(b.node).slice(b.offset,c.offset);for(var d=[a.textAfter(b.node).slice(b.offset)],b=a.nodeAfter(b.node);b!=
c.node;b=a.nodeAfter(b))d.push(a.textAfter(b));d.push(a.textAfter(c.node).slice(0,c.offset));return cleanText(d.join("\n"))},replaceSelection:function(a){this.history.commit();var b=select.cursorPos(this.container,!0),c=select.cursorPos(this.container,!1);b&&c&&(c=this.replaceRange(b,c,a),select.setCursorPos(this.container,c),webkitLastLineHack(this.container))},cursorCoords:function(a,b){function c(a,g){var d=-(document.body.scrollTop||document.documentElement.scrollTop||0),f=-(document.body.scrollLeft||
document.documentElement.scrollLeft||0)+g;forEach([a,b?null:window.frameElement],function(a){for(;a;)f+=a.offsetLeft,d+=a.offsetTop,a=a.offsetParent});return{x:f,y:d,yBot:d+a.offsetHeight}}function d(a,b){var e=document.createElement("SPAN");e.appendChild(document.createTextNode(a));try{return b(e)}finally{e.parentNode&&e.parentNode.removeChild(e)}}var f=select.cursorPos(this.container,a);if(!f)return null;for(var h=f.offset,i=f.node,k=this;h;){i=i?i.nextSibling:this.container.firstChild;f=nodeText(i);
if(h<f.length)return d(f.substr(0,h),function(a){a.style.position="absolute";a.style.visibility="hidden";a.className=i.className;k.container.appendChild(a);return c(i,a.offsetWidth)});h-=f.length}return i&&isSpan(i)?c(i,i.offsetWidth):i&&i.nextSibling&&isSpan(i.nextSibling)?c(i.nextSibling,0):d("\u200b",function(a){i?i.parentNode.insertBefore(a,i.nextSibling):k.container.insertBefore(a,k.container.firstChild);return c(a,0)})},reroutePasteEvent:function(){if(!this.capturingPaste&&!(window.opera||gecko&&
gecko>=20101026)){this.capturingPaste=!0;var a=window.frameElement.CodeMirror.textareaHack,b=this.cursorCoords(!0,!0);a.style.top=b.y+"px";if(internetExplorer&&(b=select.getBookmark(this.container)))this.selectionSnapshot=b;parent.focus();a.value="";a.focus();var c=this;parent.setTimeout(function(){c.capturingPaste=!1;window.focus();c.selectionSnapshot&&window.select.setBookmark(c.container,c.selectionSnapshot);var b=a.value;b&&(c.replaceSelection(b),select.scrollToCursor(c.container))},10)}},replaceRange:function(a,
b,c){c=asEditorLines(c);c[0]=this.history.textAfter(a.node).slice(0,a.offset)+c[0];var d=c[c.length-1];c[c.length-1]=d+this.history.textAfter(b.node).slice(b.offset);b=this.history.nodeAfter(b.node);this.history.push(a.node,b,c);return{node:this.history.nodeBefore(b),offset:d.length}},getSearchCursor:function(a,b,c){return new h(this,a,b,c)},reindent:function(){this.container.firstChild&&this.indentRegion(null,this.container.lastChild)},reindentSelection:function(a){if(select.somethingSelected()){var b=
select.selectionTopNode(this.container,!0),c=select.selectionTopNode(this.container,!1);b===!1||c===!1||this.indentRegion(b,c,a,!0)}else this.indentAtCursor(a)},grabKeys:function(a,b){this.frozen=a;this.keyFilter=b},ungrabKeys:function(){this.frozen="leave"},setParser:function(a,b){l.Parser=window[a];(b=b||this.options.parserConfig)&&l.Parser.configure&&l.Parser.configure(b);this.container.firstChild&&(forEach(this.container.childNodes,function(a){if(a.nodeType!=3)a.dirty=!0}),this.addDirtyNode(this.firstChild),
this.scheduleHighlight())},keyDown:function(a){if(this.frozen=="leave")this.keyFilter=this.frozen=null;if(this.frozen&&(!this.keyFilter||this.keyFilter(a.keyCode,a)))a.stop(),this.frozen(a);else{var b=a.keyCode;this.delayScanning();this.options.autoMatchParens&&this.scheduleParenHighlight();if(b==13)a.ctrlKey&&!a.altKey?this.reparseBuffer():(select.insertNewlineAtCursor(),b=this.options.enterMode,b!="flat"&&this.indentAtCursor(b=="keep"?"keep":void 0),select.scrollToCursor(this.container)),a.stop();
else if(b==9&&this.options.tabMode!="default"&&!a.ctrlKey)this.handleTab(!a.shiftKey),a.stop();else if(b==32&&a.shiftKey&&this.options.tabMode=="default")this.handleTab(!0),a.stop();else if(b==36&&!a.shiftKey&&!a.ctrlKey)this.home()&&a.stop();else if(b==35&&!a.shiftKey&&!a.ctrlKey)this.end()&&a.stop();else if(b==33&&!a.shiftKey&&!a.ctrlKey&&!gecko)this.pageUp()&&a.stop();else if(b==34&&!a.shiftKey&&!a.ctrlKey&&!gecko)this.pageDown()&&a.stop();else if((b==219||b==221)&&a.ctrlKey&&!a.altKey)this.highlightParens(a.shiftKey,
!0),a.stop();else if(a.metaKey&&!a.shiftKey&&(b==37||b==39)){var f=select.selectionTopNode(this.container);f!==!1&&this.container.firstChild&&(b==37?select.focusAfterNode(c(f),this.container):(b=d(f,this.container),select.focusAfterNode(b?b.previousSibling:this.container.lastChild,this.container)),a.stop())}else if((a.ctrlKey||a.metaKey)&&!a.altKey)a.shiftKey&&b==90||b==89?(select.scrollToNode(this.history.redo()),a.stop()):b==90||safari&&b==8?(select.scrollToNode(this.history.undo()),a.stop()):b==
83&&this.options.saveFunction?(this.options.saveFunction(),a.stop()):b==86&&!mac&&this.reroutePasteEvent()}},keyPress:function(a){var b=this.options.electricChars&&l.Parser.electricChars,c=this;if(this.frozen&&(!this.keyFilter||this.keyFilter(a.keyCode||a.code,a))||a.code==13||a.code==9&&this.options.tabMode!="default"||a.code==32&&a.shiftKey&&this.options.tabMode=="default")a.stop();else if(mac&&(a.ctrlKey||a.metaKey)&&a.character=="v")this.reroutePasteEvent();else if(b&&b.indexOf(a.character)!=
-1)parent.setTimeout(function(){c.indentAtCursor(null)},0);else if(brokenOpera)if(a.code==8){var d=select.selectionTopNode(this.container),c=this,f=d?d.nextSibling:this.container.firstChild;d!==!1&&f&&isBR(f)&&parent.setTimeout(function(){select.selectionTopNode(c.container)==f&&select.focusAfterNode(f.previousSibling,c.container)},20)}else a.code==46&&(d=select.selectionTopNode(this.container),c=this,d&&isBR(d)&&parent.setTimeout(function(){select.selectionTopNode(c.container)!=d&&select.focusAfterNode(d,
c.container)},20));else if(slowWebkit&&(f=(d=select.selectionTopNode(this.container))?d.nextSibling:this.container.firstChild,d&&f&&isBR(f)&&!isBR(d))){var h=document.createTextNode("\u200b");this.container.insertBefore(h,f);parent.setTimeout(function(){h.nodeValue=="\u200b"?removeElement(h):h.nodeValue=h.nodeValue.replace("\u200b","")},20)}webkit&&!this.options.textWrapping&&setTimeout(function(){var a=select.selectionTopNode(c.container,!0);a&&a.nodeType==3&&a.previousSibling&&isBR(a.previousSibling)&&
a.nextSibling&&isBR(a.nextSibling)&&a.parentNode.replaceChild(document.createElement("BR"),a.previousSibling)},50)},keyUp:function(a){this.cursorActivity(a.keyCode>=16&&a.keyCode<=18||a.keyCode>=33&&a.keyCode<=40)},indentLineAfter:function(a,b){function d(a){a=a?a.nextSibling:f.container.firstChild;if(!a||!hasClass(a,"whitespace"))return null;return a}var f=this,h=d(a),n=0,i=h?h.currentText.length:0,k=h?h.nextSibling:a?a.nextSibling:this.container.firstChild;if(b=="keep"){if(a){var j=d(c(a.previousSibling));
if(j)n=j.currentText.length}}else j=a&&k&&k.currentText?k.currentText:"",b!=null&&this.options.tabMode!="indent"?n=b?i+indentUnit:Math.max(0,i-indentUnit):a?n=a.indentation(j,i,b,k):l.Parser.firstIndentation&&(n=l.Parser.firstIndentation(j,i,b,k));i=n-i;i<0?n==0?(k&&select.snapshotMove(h.firstChild,k.firstChild||k,0),removeElement(h),h=null):(select.snapshotMove(h.firstChild,h.firstChild,i,!0),h.currentText=makeWhiteSpace(n),h.firstChild.nodeValue=h.currentText):i>0?h?(h.currentText=makeWhiteSpace(n),
h.firstChild.nodeValue=h.currentText,select.snapshotMove(h.firstChild,h.firstChild,i,!0)):(h=makePartSpan(makeWhiteSpace(n)),h.className="whitespace",a?insertAfter(h,a):this.container.insertBefore(h,this.container.firstChild),select.snapshotMove(k&&(k.firstChild||k),h.firstChild,n,!1,!0)):h&&select.snapshotMove(h.firstChild,h.firstChild,n,!1);i!=0&&this.addDirtyNode(a)},highlightAtCursor:function(){var a=select.selectionTopNode(this.container,!0),b=select.selectionTopNode(this.container,!1);if(a===
!1||b===!1)return!1;select.markSelection();if(this.highlight(a,d(b,this.container),!0,20)===!1)return!1;select.selectMarked();return!0},handleTab:function(a){this.options.tabMode=="spaces"&&!select.somethingSelected()?select.insertTabAtCursor():this.reindentSelection(a)},home:function(){var a=select.selectionTopNode(this.container,!0),b=a;if(a===!1||a&&!a.isPart&&!isBR(a)||!this.container.firstChild)return!1;for(;a&&!isBR(a);)a=a.previousSibling;var c=a?a.nextSibling:this.container.firstChild;c&&
c!=b&&c.isPart&&hasClass(c,"whitespace")?select.focusAfterNode(c,this.container):select.focusAfterNode(a,this.container);select.scrollToCursor(this.container);return!0},end:function(){var a=select.selectionTopNode(this.container,!0);if(a===!1)return!1;a=d(a,this.container);if(!a)return!1;select.focusAfterNode(a.previousSibling,this.container);select.scrollToCursor(this.container);return!0},pageUp:function(){var a=this.cursorPosition().line,b=this.visibleLineCount();if(a===!1||b===!1)return!1;b-=2;
for(var c=0;c<b;c++)if(a=this.prevLine(a),a===!1)break;if(c==0)return!1;select.setCursorPos(this.container,{node:a,offset:0});select.scrollToCursor(this.container);return!0},pageDown:function(){var a=this.cursorPosition().line,b=this.visibleLineCount();if(a===!1||b===!1)return!1;b-=2;for(var c=0;c<b;c++){var d=this.nextLine(a);if(d===!1)break;a=d}if(c==0)return!1;select.setCursorPos(this.container,{node:a,offset:0});select.scrollToCursor(this.container);return!0},scheduleParenHighlight:function(){this.parenEvent&&
parent.clearTimeout(this.parenEvent);var a=this;this.parenEvent=parent.setTimeout(function(){a.highlightParens()},300)},highlightParens:function(a,b){function c(a,b){if(a)k?k.call?k(a,b):a.className+=" "+k[b?0:1]:(a.style.fontWeight="bold",a.style.color=b?"#8F8":"#F88")}function f(a){if(a)k&&!k.call?removeClass(removeClass(a,k[0]),k[1]):i.options.unmarkParen?i.options.unmarkParen(a):(a.style.fontWeight="",a.style.color="")}function h(a){if(a.currentText)return(a=a.currentText.match(/^[\s\u00a0]*([\(\)\[\]{}])[\s\u00a0]*$/))&&
a[1]}function n(){for(var a=[],b,c=!0,e=l;e;e=q?e.nextSibling:e.previousSibling)if(e.className==o&&isSpan(e)&&(b=h(e))){if(/[\(\[\{]/.test(b)==q?a.push(b):a.length?a.pop()!=matching[b]&&(c=!1):c=!1,!a.length)break}else if(e.dirty||!isSpan(e)&&!isBR(e))return{node:e,status:"dirty"};return{node:e,status:e&&c}}var i=this,k=this.options.markParen;typeof k=="string"&&(k=[k,k]);!b&&i.highlighted&&(f(i.highlighted[0]),f(i.highlighted[1]));if(window&&window.parent&&window.select){this.parenEvent&&parent.clearTimeout(this.parenEvent);
this.parenEvent=null;var j,l=select.selectionTopNode(this.container,!0);if(l&&this.highlightAtCursor()&&(l=select.selectionTopNode(this.container,!0))&&((j=h(l))||(l=l.nextSibling)&&(j=h(l))))for(var o=l.className,q=/[\(\[\{]/.test(j);;){var p=n();if(p.status=="dirty")this.highlight(p.node,d(p.node)),p.node.dirty=!1;else{c(l,p.status);c(p.node,p.status);b?parent.setTimeout(function(){f(l);f(p.node)},500):i.highlighted=[l,p.node];a&&p.node&&select.focusAfterNode(p.node.previousSibling,this.container);
break}}}},indentAtCursor:function(a){if(this.container.firstChild&&this.highlightAtCursor()){var b=select.selectionTopNode(this.container,!1);b!==!1&&(select.markSelection(),this.indentLineAfter(c(b),a),select.selectMarked())}},indentRegion:function(a,b,f,h){var l=a=c(a),n=a&&c(a.previousSibling);isBR(b)||(b=d(b,this.container));this.addDirtyNode(a);do{var i=d(l,this.container);l&&this.highlight(n,i,!0);this.indentLineAfter(l,f);n=l;l=i}while(l!=b);h&&select.setCursorPos(this.container,{node:a,offset:0},
{node:b,offset:0})},cursorActivity:function(a){if(this.unloaded)window.document.designMode="off",window.document.designMode="on",this.unloaded=!1;if(internetExplorer){this.container.createTextRange().execCommand("unlink");clearTimeout(this.saveSelectionSnapshot);var b=this;this.saveSelectionSnapshot=setTimeout(function(){var a=select.getBookmark(b.container);if(a)b.selectionSnapshot=a},200)}var c=this.options.onCursorActivity;if(!a||c){var d=select.selectionTopNode(this.container,!1);d!==!1&&this.container.firstChild&&
(d=d||this.container.firstChild,c&&c(d),a||(this.scheduleHighlight(),this.addDirtyNode(d)))}},reparseBuffer:function(){forEach(this.container.childNodes,function(a){a.dirty=!0});this.container.firstChild&&this.addDirtyNode(this.container.firstChild)},addDirtyNode:function(a){if(a=a||this.container.firstChild){for(var b=0;b<this.dirty.length;b++)if(this.dirty[b]==a)return;if(a.nodeType!=3)a.dirty=!0;this.dirty.push(a)}},allClean:function(){return!this.dirty.length},scheduleHighlight:function(){var a=
this;parent.clearTimeout(this.highlightTimeout);this.highlightTimeout=parent.setTimeout(function(){a.highlightDirty()},this.options.passDelay)},getDirtyNode:function(){for(;this.dirty.length>0;){var a=this.dirty.pop();try{for(;a&&a.parentNode!=this.container;)a=a.parentNode;if(a&&(a.dirty||a.nodeType==3))return a}catch(b){}}return null},highlightDirty:function(a){if(!window||!window.parent||!window.select)return!1;this.options.readOnly||select.markSelection();for(var b,c=a?null:(new Date).getTime()+
this.options.passTime;((new Date).getTime()<c||a)&&(b=this.getDirtyNode());){var d=this.highlight(b,c);d&&d.node&&d.dirty&&this.addDirtyNode(d.node.nextSibling)}this.options.readOnly||select.selectMarked();b&&this.scheduleHighlight();return this.dirty.length==0},documentScanner:function(a){var b=this,c=null;return function(){if(window&&window.parent&&window.select){c&&c.parentNode!=b.container&&(c=null);select.markSelection();var d=b.highlight(c,(new Date).getTime()+a,!0);select.selectMarked();d=
d?d.node&&d.node.nextSibling:null;c=c==d?null:d;b.delayScanning()}}},delayScanning:function(){if(this.scanner)parent.clearTimeout(this.documentScan),this.documentScan=parent.setTimeout(this.scanner,this.options.continuousScanning)},highlight:function(a,b,c,d){function h(a){if(a){var b=a.oldNextSibling;(p||b===void 0||a.nextSibling!=b)&&i.history.touch(a);a.oldNextSibling=a.nextSibling}else b=i.container.oldFirstChild,(p||b===void 0||i.container.firstChild!=b)&&i.history.touch(null),i.container.oldFirstChild=
i.container.firstChild}var n=this.container,i=this,k=this.options.activeTokens,j=typeof b=="number"?b:null;if(!n.firstChild)return!1;for(;a&&(!a.parserFromHere||a.dirty);){if(d!=null&&isBR(a)&&--d<0)return!1;a=a.previousSibling}if(a&&!a.nextSibling)return!1;var o=f(a?a.nextSibling:n.firstChild),d=stringStream(o),t=a?a.parserFromHere(d):l.Parser.make(d),q={current:null,get:function(){if(!this.current)this.current=o.nodes.shift();return this.current},next:function(){this.current=null},remove:function(){n.removeChild(this.get());
this.current=null},getNonEmpty:function(){for(var a=this.get();a&&isSpan(a)&&a.currentText=="";)if(window.opera&&(a.previousSibling==null||isBR(a.previousSibling))&&(a.nextSibling==null||isBR(a.nextSibling)))this.next(),a=this.get();else{var b=a;this.remove();a=this.get();select.snapshotMove(b.firstChild,a&&(a.firstChild||a),0)}return a}},p=!1,v=!0,u=0;forEach(t,function(d){var f=q.getNonEmpty();if(d.value=="\n"){if(!isBR(f))throw"Parser out of sync. Expected BR.";if(f.dirty||!f.indentation)p=!0;
h(a);a=f;f.parserFromHere=t.copy();f.indentation=d.indentation||alwaysZero;f.dirty=!1;if(j==null&&f==b)throw StopIteration;if(j!=null&&(new Date).getTime()>=j||!p&&!v&&u>1&&!c)throw StopIteration;v=p;p=!1;u=0;q.next()}else{if(!isSpan(f))throw"Parser out of sync. Expected SPAN.";f.dirty&&(p=!0);u++;if(!f.reduced&&f.currentText==d.value&&f.className==d.style)k&&f.dirty&&k(f,d,i),f.dirty=!1,q.next();else{p=!0;var l=makePartSpan(d.value);l.className=d.style;n.insertBefore(l,f);k&&k(l,d,i);for(var d=d.value.length,
m=0;d>0;){var f=q.get(),o=f.currentText.length;select.snapshotReplaceNode(f.firstChild,l.firstChild,d,m);o>d?(f.currentText=f.currentText.substring(d),f.reduced=!0,d=0):(d-=o,m+=o,q.remove())}}}});h(a);webkitLastLineHack(this.container);return{node:q.getNonEmpty(),dirty:p}}};return l}();addEventHandler(window,"load",function(){var b=window.frameElement.CodeMirror;b.editor=new Editor(b.options);parent.setTimeout(method(b,"init"),0)});function tokenizer(b,f){function c(b){return b!="\n"&&/^[\s\u00a0]*$/.test(b)}var d={state:f,take:function(d){typeof d=="string"&&(d={style:d,type:d});d.content=(d.content||"")+b.get();/\n$/.test(d.content)||b.nextWhile(c);d.value=d.content+b.get();return d},next:function(){if(!b.more())throw StopIteration;var f;if(b.equals("\n"))return b.next(),this.take("whitespace");if(b.applies(c))f="whitespace";else for(;!f;)f=this.state(b,function(b){d.state=b});return this.take(f)}};return d};