#!/usr/bin/env python
# encoding: utf-8
#
# Copyright (c) 2010 Doug Hellmann.  All rights reserved.
#
"""log10 example
"""
#end_pymotw_header

import math

print '{:2}  {:^12}  {:^10}  {:^20}  {:8}'.format(
    'i', 'x', 'accurate', 'inaccurate', 'mismatch',
    )
print '{:-^2}  {:-^12}  {:-^10}  {:-^20}  {:-^8}'.format(
    '', '', '', '', '',
    )

for i in range(0, 10):
    x = math.pow(10, i)
    accurate = math.log10(x)
    inaccurate = math.log(x, 10)
    match = '' if int(inaccurate) == i else '*'
    print '{:2d}  {:12.1f}  {:10.8f}  {:20.18f}  {:^5}'.format(
        i, x, accurate, inaccurate, match,
        )
