#include <stdint.h>
#include "mtgp64-fast.h"
#define MTGPDC_MEXP 11213
#define MTGPDC_N 176
#define MTGPDC_FLOOR_2P 128
#define MTGPDC_CEIL_2P 256
#define MTGPDC_PARAM_TABLE mtgp64dc_params_fast_11213

mtgp64_params_fast_t mtgp64dc_params_fast_11213[]
 = {
    {
        /* No.0 delta:2493 weight:2759 */
        11213,
        10,
        12,
        20,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x139ad59400000000),
         UINT64_C(0xf3874bc900000000),
         UINT64_C(0xe01d9e5d00000000),
         UINT64_C(0xd293000000000000),
         UINT64_C(0xc109d59400000000),
         UINT64_C(0x21144bc900000000),
         UINT64_C(0x328e9e5d00000000),
         UINT64_C(0x0000540400000000),
         UINT64_C(0x139a819000000000),
         UINT64_C(0xf3871fcd00000000),
         UINT64_C(0xe01dca5900000000),
         UINT64_C(0xd293540400000000),
         UINT64_C(0xc109819000000000),
         UINT64_C(0x21141fcd00000000),
         UINT64_C(0x328eca5900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0068000000000000),
         UINT64_C(0x0051800000000000),
         UINT64_C(0x0039800000000000),
         UINT64_C(0x5910100000000000),
         UINT64_C(0x5978100000000000),
         UINT64_C(0x5941900000000000),
         UINT64_C(0x5929900000000000),
         UINT64_C(0x4013f00000000000),
         UINT64_C(0x407bf00000000000),
         UINT64_C(0x4042700000000000),
         UINT64_C(0x402a700000000000),
         UINT64_C(0x1903e00000000000),
         UINT64_C(0x196be00000000000),
         UINT64_C(0x1952600000000000),
         UINT64_C(0x193a600000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0068000000000),
         UINT64_C(0x3ff0051800000000),
         UINT64_C(0x3ff0039800000000),
         UINT64_C(0x3ff5910100000000),
         UINT64_C(0x3ff5978100000000),
         UINT64_C(0x3ff5941900000000),
         UINT64_C(0x3ff5929900000000),
         UINT64_C(0x3ff4013f00000000),
         UINT64_C(0x3ff407bf00000000),
         UINT64_C(0x3ff4042700000000),
         UINT64_C(0x3ff402a700000000),
         UINT64_C(0x3ff1903e00000000),
         UINT64_C(0x3ff196be00000000),
         UINT64_C(0x3ff1952600000000),
         UINT64_C(0x3ff193a600000000)},
        UINT64_C(0xfff8000000000000),
        {0xba,0x7d,0x1f,0xbb,0xa4,0x70,0xe3,0xac,0xa8,0x19,
         0x62,0x00,0x74,0x6e,0x29,0x47,0x4c,0xb4,0x10,0x35,0x00}
    },
    {
        /* No.1 delta:2435 weight:3589 */
        11213,
        32,
        9,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x9aa1db6800000000),
         UINT64_C(0x2898b6a900000000),
         UINT64_C(0xb2396dc100000000),
         UINT64_C(0xdc22000100000000),
         UINT64_C(0x4683db6900000000),
         UINT64_C(0xf4bab6a800000000),
         UINT64_C(0x6e1b6dc000000000),
         UINT64_C(0x0000d23e00000000),
         UINT64_C(0x9aa1095600000000),
         UINT64_C(0x2898649700000000),
         UINT64_C(0xb239bfff00000000),
         UINT64_C(0xdc22d23f00000000),
         UINT64_C(0x4683095700000000),
         UINT64_C(0xf4ba649600000000),
         UINT64_C(0x6e1bbffe00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2800200000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x2800200000000000),
         UINT64_C(0x7000200000000000),
         UINT64_C(0x5800000000000000),
         UINT64_C(0x7000200000000000),
         UINT64_C(0x5800000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x2803d00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x2803d00000000000),
         UINT64_C(0x7003d00000000000),
         UINT64_C(0x5803f00000000000),
         UINT64_C(0x7003d00000000000),
         UINT64_C(0x5803f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2800200000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2800200000000),
         UINT64_C(0x3ff7000200000000),
         UINT64_C(0x3ff5800000000000),
         UINT64_C(0x3ff7000200000000),
         UINT64_C(0x3ff5800000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff2803d00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff2803d00000000),
         UINT64_C(0x3ff7003d00000000),
         UINT64_C(0x3ff5803f00000000),
         UINT64_C(0x3ff7003d00000000),
         UINT64_C(0x3ff5803f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x74,0x44,0x3b,0xff,0x1f,0x5f,0x20,0xe9,0x0b,0x16,
         0xef,0x53,0x28,0x6c,0xec,0xf4,0x11,0x63,0x3c,0x62,0x00}
    },
    {
        /* No.2 delta:2576 weight:3627 */
        11213,
        15,
        6,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xabab911e00000000),
         UINT64_C(0xe4509f0100000000),
         UINT64_C(0x4ffb0e1f00000000),
         UINT64_C(0xa2cf000200000000),
         UINT64_C(0x0964911c00000000),
         UINT64_C(0x469f9f0300000000),
         UINT64_C(0xed340e1d00000000),
         UINT64_C(0x00005c8400000000),
         UINT64_C(0xababcd9a00000000),
         UINT64_C(0xe450c38500000000),
         UINT64_C(0x4ffb529b00000000),
         UINT64_C(0xa2cf5c8600000000),
         UINT64_C(0x0964cd9800000000),
         UINT64_C(0x469fc38700000000),
         UINT64_C(0xed34529900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6003800000000000),
         UINT64_C(0x6008600000000000),
         UINT64_C(0x000be00000000000),
         UINT64_C(0x1000200000000000),
         UINT64_C(0x7003a00000000000),
         UINT64_C(0x7008400000000000),
         UINT64_C(0x100bc00000000000),
         UINT64_C(0x000bf00000000000),
         UINT64_C(0x6008700000000000),
         UINT64_C(0x6003900000000000),
         UINT64_C(0x0000100000000000),
         UINT64_C(0x100bd00000000000),
         UINT64_C(0x7008500000000000),
         UINT64_C(0x7003b00000000000),
         UINT64_C(0x1000300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff6003800000000),
         UINT64_C(0x3ff6008600000000),
         UINT64_C(0x3ff000be00000000),
         UINT64_C(0x3ff1000200000000),
         UINT64_C(0x3ff7003a00000000),
         UINT64_C(0x3ff7008400000000),
         UINT64_C(0x3ff100bc00000000),
         UINT64_C(0x3ff000bf00000000),
         UINT64_C(0x3ff6008700000000),
         UINT64_C(0x3ff6003900000000),
         UINT64_C(0x3ff0000100000000),
         UINT64_C(0x3ff100bd00000000),
         UINT64_C(0x3ff7008500000000),
         UINT64_C(0x3ff7003b00000000),
         UINT64_C(0x3ff1000300000000)},
        UINT64_C(0xfff8000000000000),
        {0x46,0x28,0xd1,0x6f,0x53,0x7d,0x61,0x39,0xf7,0xc9,
         0xb9,0xc9,0x60,0xea,0x38,0xf1,0xcd,0x2c,0x7e,0xd2,0x00}
    },
    {
        /* No.3 delta:6162 weight:2445 */
        11213,
        8,
        27,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe1cae92500000000),
         UINT64_C(0x42cc3d6300000000),
         UINT64_C(0xa306d44600000000),
         UINT64_C(0x779b000300000000),
         UINT64_C(0x9651e92600000000),
         UINT64_C(0x35573d6000000000),
         UINT64_C(0xd49dd44500000000),
         UINT64_C(0x00002c3e00000000),
         UINT64_C(0xe1cac51b00000000),
         UINT64_C(0x42cc115d00000000),
         UINT64_C(0xa306f87800000000),
         UINT64_C(0x779b2c3d00000000),
         UINT64_C(0x9651c51800000000),
         UINT64_C(0x3557115e00000000),
         UINT64_C(0xd49df87b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x449f400000000000),
         UINT64_C(0x240e800000000000),
         UINT64_C(0x6091c00000000000),
         UINT64_C(0x0922800000000000),
         UINT64_C(0x4dbdc00000000000),
         UINT64_C(0x2d2c000000000000),
         UINT64_C(0x69b3400000000000),
         UINT64_C(0x0757f00000000000),
         UINT64_C(0x43c8b00000000000),
         UINT64_C(0x2359700000000000),
         UINT64_C(0x67c6300000000000),
         UINT64_C(0x0e75700000000000),
         UINT64_C(0x4aea300000000000),
         UINT64_C(0x2a7bf00000000000),
         UINT64_C(0x6ee4b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff449f400000000),
         UINT64_C(0x3ff240e800000000),
         UINT64_C(0x3ff6091c00000000),
         UINT64_C(0x3ff0922800000000),
         UINT64_C(0x3ff4dbdc00000000),
         UINT64_C(0x3ff2d2c000000000),
         UINT64_C(0x3ff69b3400000000),
         UINT64_C(0x3ff0757f00000000),
         UINT64_C(0x3ff43c8b00000000),
         UINT64_C(0x3ff2359700000000),
         UINT64_C(0x3ff67c6300000000),
         UINT64_C(0x3ff0e75700000000),
         UINT64_C(0x3ff4aea300000000),
         UINT64_C(0x3ff2a7bf00000000),
         UINT64_C(0x3ff6ee4b00000000)},
        UINT64_C(0xfff8000000000000),
        {0x1c,0x31,0x19,0x90,0xf6,0xdf,0xbe,0x46,0x23,0x9d,
         0xaf,0x3c,0x1d,0x40,0x6b,0x9c,0x58,0xbf,0x3b,0x86,0x00}
    },
    {
        /* No.4 delta:2316 weight:2705 */
        11213,
        13,
        13,
        19,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3cc8a84500000000),
         UINT64_C(0x7b3241b200000000),
         UINT64_C(0x47fae9f700000000),
         UINT64_C(0x3a99000400000000),
         UINT64_C(0x0651a84100000000),
         UINT64_C(0x41ab41b600000000),
         UINT64_C(0x7d63e9f300000000),
         UINT64_C(0x000075a900000000),
         UINT64_C(0x3cc8ddec00000000),
         UINT64_C(0x7b32341b00000000),
         UINT64_C(0x47fa9c5e00000000),
         UINT64_C(0x3a9975ad00000000),
         UINT64_C(0x0651dde800000000),
         UINT64_C(0x41ab341f00000000),
         UINT64_C(0x7d639c5a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4008500000000000),
         UINT64_C(0x0066b00000000000),
         UINT64_C(0x406ee00000000000),
         UINT64_C(0x205e200000000000),
         UINT64_C(0x6056700000000000),
         UINT64_C(0x2038900000000000),
         UINT64_C(0x6030c00000000000),
         UINT64_C(0x001ff00000000000),
         UINT64_C(0x4017a00000000000),
         UINT64_C(0x0079400000000000),
         UINT64_C(0x4071100000000000),
         UINT64_C(0x2041d00000000000),
         UINT64_C(0x6049800000000000),
         UINT64_C(0x2027600000000000),
         UINT64_C(0x602f300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4008500000000),
         UINT64_C(0x3ff0066b00000000),
         UINT64_C(0x3ff406ee00000000),
         UINT64_C(0x3ff205e200000000),
         UINT64_C(0x3ff6056700000000),
         UINT64_C(0x3ff2038900000000),
         UINT64_C(0x3ff6030c00000000),
         UINT64_C(0x3ff001ff00000000),
         UINT64_C(0x3ff4017a00000000),
         UINT64_C(0x3ff0079400000000),
         UINT64_C(0x3ff4071100000000),
         UINT64_C(0x3ff2041d00000000),
         UINT64_C(0x3ff6049800000000),
         UINT64_C(0x3ff2027600000000),
         UINT64_C(0x3ff602f300000000)},
        UINT64_C(0xfff8000000000000),
        {0xc7,0x64,0x76,0xa6,0xf8,0x8a,0x7e,0x05,0x33,0x81,
         0x0a,0x05,0xe2,0x08,0x78,0xf0,0x59,0x4c,0xc2,0x6c,0x00}
    },
    {
        /* No.5 delta:1949 weight:3297 */
        11213,
        22,
        13,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x09719cba00000000),
         UINT64_C(0x8511f52500000000),
         UINT64_C(0x8c60699f00000000),
         UINT64_C(0xe6fe000500000000),
         UINT64_C(0xef8f9cbf00000000),
         UINT64_C(0x63eff52000000000),
         UINT64_C(0x6a9e699a00000000),
         UINT64_C(0x000055ff00000000),
         UINT64_C(0x0971c94500000000),
         UINT64_C(0x8511a0da00000000),
         UINT64_C(0x8c603c6000000000),
         UINT64_C(0xe6fe55fa00000000),
         UINT64_C(0xef8fc94000000000),
         UINT64_C(0x63efa0df00000000),
         UINT64_C(0x6a9e3c6500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x303e000000000000),
         UINT64_C(0x202d000000000000),
         UINT64_C(0x1013000000000000),
         UINT64_C(0x3001e00000000000),
         UINT64_C(0x003fe00000000000),
         UINT64_C(0x102ce00000000000),
         UINT64_C(0x2012e00000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x603df00000000000),
         UINT64_C(0x702ef00000000000),
         UINT64_C(0x4010f00000000000),
         UINT64_C(0x6002100000000000),
         UINT64_C(0x503c100000000000),
         UINT64_C(0x402f100000000000),
         UINT64_C(0x7011100000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff303e000000000),
         UINT64_C(0x3ff202d000000000),
         UINT64_C(0x3ff1013000000000),
         UINT64_C(0x3ff3001e00000000),
         UINT64_C(0x3ff003fe00000000),
         UINT64_C(0x3ff102ce00000000),
         UINT64_C(0x3ff2012e00000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff603df00000000),
         UINT64_C(0x3ff702ef00000000),
         UINT64_C(0x3ff4010f00000000),
         UINT64_C(0x3ff6002100000000),
         UINT64_C(0x3ff503c100000000),
         UINT64_C(0x3ff402f100000000),
         UINT64_C(0x3ff7011100000000)},
        UINT64_C(0xfff8000000000000),
        {0x5c,0x21,0x9a,0xa0,0x6a,0x55,0x17,0x6a,0xc5,0x6b,
         0x9d,0xf8,0xd1,0xd6,0x37,0x55,0x64,0x71,0x0a,0xf1,0x00}
    },
    {
        /* No.6 delta:2567 weight:2747 */
        11213,
        38,
        23,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5951d72700000000),
         UINT64_C(0xa190874a00000000),
         UINT64_C(0xf8c1506d00000000),
         UINT64_C(0x0569000600000000),
         UINT64_C(0x5c38d72100000000),
         UINT64_C(0xa4f9874c00000000),
         UINT64_C(0xfda8506b00000000),
         UINT64_C(0x0000ed1d00000000),
         UINT64_C(0x59513a3a00000000),
         UINT64_C(0xa1906a5700000000),
         UINT64_C(0xf8c1bd7000000000),
         UINT64_C(0x0569ed1b00000000),
         UINT64_C(0x5c383a3c00000000),
         UINT64_C(0xa4f96a5100000000),
         UINT64_C(0xfda8bd7600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc001800000000000),
         UINT64_C(0x0002b00000000000),
         UINT64_C(0xc003300000000000),
         UINT64_C(0x0000900000000000),
         UINT64_C(0xc001100000000000),
         UINT64_C(0x0002200000000000),
         UINT64_C(0xc003a00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0xc002700000000000),
         UINT64_C(0x0001400000000000),
         UINT64_C(0xc000c00000000000),
         UINT64_C(0x0003600000000000),
         UINT64_C(0xc002e00000000000),
         UINT64_C(0x0001d00000000000),
         UINT64_C(0xc000500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffc001800000000),
         UINT64_C(0x3ff0002b00000000),
         UINT64_C(0x3ffc003300000000),
         UINT64_C(0x3ff0000900000000),
         UINT64_C(0x3ffc001100000000),
         UINT64_C(0x3ff0002200000000),
         UINT64_C(0x3ffc003a00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ffc002700000000),
         UINT64_C(0x3ff0001400000000),
         UINT64_C(0x3ffc000c00000000),
         UINT64_C(0x3ff0003600000000),
         UINT64_C(0x3ffc002e00000000),
         UINT64_C(0x3ff0001d00000000),
         UINT64_C(0x3ffc000500000000)},
        UINT64_C(0xfff8000000000000),
        {0x58,0x95,0x12,0x32,0x7e,0x70,0x91,0x24,0x17,0x7a,
         0xb7,0x62,0x0f,0x28,0x12,0xf1,0x76,0xea,0x4c,0xab,0x00}
    },
    {
        /* No.7 delta:7267 weight:2665 */
        11213,
        34,
        22,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x63e03f2900000000),
         UINT64_C(0x43a8dd6100000000),
         UINT64_C(0x2048e24800000000),
         UINT64_C(0xc5e0000700000000),
         UINT64_C(0xa6003f2e00000000),
         UINT64_C(0x8648dd6600000000),
         UINT64_C(0xe5a8e24f00000000),
         UINT64_C(0x0000a1e200000000),
         UINT64_C(0x63e09ecb00000000),
         UINT64_C(0x43a87c8300000000),
         UINT64_C(0x204843aa00000000),
         UINT64_C(0xc5e0a1e500000000),
         UINT64_C(0xa6009ecc00000000),
         UINT64_C(0x86487c8400000000),
         UINT64_C(0xe5a843ad00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x495d400000000000),
         UINT64_C(0x0cb4000000000000),
         UINT64_C(0x45e9400000000000),
         UINT64_C(0x0203b00000000000),
         UINT64_C(0x4b5ef00000000000),
         UINT64_C(0x0eb7b00000000000),
         UINT64_C(0x47eaf00000000000),
         UINT64_C(0x4467f00000000000),
         UINT64_C(0x0d3ab00000000000),
         UINT64_C(0x48d3f00000000000),
         UINT64_C(0x018eb00000000000),
         UINT64_C(0x4664400000000000),
         UINT64_C(0x0f39000000000000),
         UINT64_C(0x4ad0400000000000),
         UINT64_C(0x038d000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff495d400000000),
         UINT64_C(0x3ff0cb4000000000),
         UINT64_C(0x3ff45e9400000000),
         UINT64_C(0x3ff0203b00000000),
         UINT64_C(0x3ff4b5ef00000000),
         UINT64_C(0x3ff0eb7b00000000),
         UINT64_C(0x3ff47eaf00000000),
         UINT64_C(0x3ff4467f00000000),
         UINT64_C(0x3ff0d3ab00000000),
         UINT64_C(0x3ff48d3f00000000),
         UINT64_C(0x3ff018eb00000000),
         UINT64_C(0x3ff4664400000000),
         UINT64_C(0x3ff0f39000000000),
         UINT64_C(0x3ff4ad0400000000),
         UINT64_C(0x3ff038d000000000)},
        UINT64_C(0xfff8000000000000),
        {0xdf,0x30,0xf6,0x25,0x47,0xe7,0xb6,0x4f,0x7a,0x7b,
         0xe0,0xc7,0x98,0x99,0x0f,0xf1,0x1c,0xf5,0x71,0x4e,0x00}
    },
    {
        /* No.8 delta:4076 weight:3751 */
        11213,
        33,
        1,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x34b1ea5300000000),
         UINT64_C(0x100d6d6600000000),
         UINT64_C(0x24bc873500000000),
         UINT64_C(0x9e86000800000000),
         UINT64_C(0xaa37ea5b00000000),
         UINT64_C(0x8e8b6d6e00000000),
         UINT64_C(0xba3a873d00000000),
         UINT64_C(0x00005cc000000000),
         UINT64_C(0x34b1b69300000000),
         UINT64_C(0x100d31a600000000),
         UINT64_C(0x24bcdbf500000000),
         UINT64_C(0x9e865cc800000000),
         UINT64_C(0xaa37b69b00000000),
         UINT64_C(0x8e8b31ae00000000),
         UINT64_C(0xba3adbfd00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4890000000000000),
         UINT64_C(0x05cdc00000000000),
         UINT64_C(0x4d5dc00000000000),
         UINT64_C(0x004ba00000000000),
         UINT64_C(0x48dba00000000000),
         UINT64_C(0x0586600000000000),
         UINT64_C(0x4d16600000000000),
         UINT64_C(0x42a3f00000000000),
         UINT64_C(0x0a33f00000000000),
         UINT64_C(0x476e300000000000),
         UINT64_C(0x0ffe300000000000),
         UINT64_C(0x42e8500000000000),
         UINT64_C(0x0a78500000000000),
         UINT64_C(0x4725900000000000),
         UINT64_C(0x0fb5900000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4890000000000),
         UINT64_C(0x3ff05cdc00000000),
         UINT64_C(0x3ff4d5dc00000000),
         UINT64_C(0x3ff004ba00000000),
         UINT64_C(0x3ff48dba00000000),
         UINT64_C(0x3ff0586600000000),
         UINT64_C(0x3ff4d16600000000),
         UINT64_C(0x3ff42a3f00000000),
         UINT64_C(0x3ff0a33f00000000),
         UINT64_C(0x3ff476e300000000),
         UINT64_C(0x3ff0ffe300000000),
         UINT64_C(0x3ff42e8500000000),
         UINT64_C(0x3ff0a78500000000),
         UINT64_C(0x3ff4725900000000),
         UINT64_C(0x3ff0fb5900000000)},
        UINT64_C(0xfff8000000000000),
        {0xdb,0xb2,0xe0,0x09,0x6f,0x77,0xc7,0xd1,0x5d,0x5c,
         0x12,0x9b,0xf7,0xeb,0x4b,0x16,0x4c,0x5d,0x10,0xe7,0x00}
    },
    {
        /* No.9 delta:1883 weight:3375 */
        11213,
        43,
        5,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa535df2600000000),
         UINT64_C(0x08b0b63900000000),
         UINT64_C(0xad85691f00000000),
         UINT64_C(0x73c6000900000000),
         UINT64_C(0xd6f3df2f00000000),
         UINT64_C(0x7b76b63000000000),
         UINT64_C(0xde43691600000000),
         UINT64_C(0x0000ddb900000000),
         UINT64_C(0xa535029f00000000),
         UINT64_C(0x08b06b8000000000),
         UINT64_C(0xad85b4a600000000),
         UINT64_C(0x73c6ddb000000000),
         UINT64_C(0xd6f3029600000000),
         UINT64_C(0x7b766b8900000000),
         UINT64_C(0xde43b4af00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc220000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0xe220000000000000),
         UINT64_C(0x4020000000000000),
         UINT64_C(0x8200000000000000),
         UINT64_C(0x6020000000000000),
         UINT64_C(0xa200000000000000),
         UINT64_C(0x3803f00000000000),
         UINT64_C(0xfa23f00000000000),
         UINT64_C(0x1803f00000000000),
         UINT64_C(0xda23f00000000000),
         UINT64_C(0x7823f00000000000),
         UINT64_C(0xba03f00000000000),
         UINT64_C(0x5823f00000000000),
         UINT64_C(0x9a03f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffc220000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ffe220000000000),
         UINT64_C(0x3ff4020000000000),
         UINT64_C(0x3ff8200000000000),
         UINT64_C(0x3ff6020000000000),
         UINT64_C(0x3ffa200000000000),
         UINT64_C(0x3ff3803f00000000),
         UINT64_C(0x3fffa23f00000000),
         UINT64_C(0x3ff1803f00000000),
         UINT64_C(0x3ffda23f00000000),
         UINT64_C(0x3ff7823f00000000),
         UINT64_C(0x3ffba03f00000000),
         UINT64_C(0x3ff5823f00000000),
         UINT64_C(0x3ff9a03f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x14,0x9f,0xed,0x25,0x4d,0xa5,0xc8,0xd7,0x31,0x72,
         0xb0,0x85,0x12,0x08,0x60,0xf6,0x13,0x8b,0x1b,0x2b,0x00}
    },
    {
        /* No.10 delta:4540 weight:2847 */
        11213,
        39,
        14,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xcb51b38e00000000),
         UINT64_C(0x78091b1700000000),
         UINT64_C(0xb358a89900000000),
         UINT64_C(0xbcbd000a00000000),
         UINT64_C(0x77ecb38400000000),
         UINT64_C(0xc4b41b1d00000000),
         UINT64_C(0x0fe5a89300000000),
         UINT64_C(0x00002caf00000000),
         UINT64_C(0xcb519f2100000000),
         UINT64_C(0x780937b800000000),
         UINT64_C(0xb358843600000000),
         UINT64_C(0xbcbd2ca500000000),
         UINT64_C(0x77ec9f2b00000000),
         UINT64_C(0xc4b437b200000000),
         UINT64_C(0x0fe5843c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x407c500000000000),
         UINT64_C(0x6214c00000000000),
         UINT64_C(0x2268900000000000),
         UINT64_C(0x0405400000000000),
         UINT64_C(0x4479100000000000),
         UINT64_C(0x6611800000000000),
         UINT64_C(0x266dd00000000000),
         UINT64_C(0x1063f00000000000),
         UINT64_C(0x501fa00000000000),
         UINT64_C(0x7277300000000000),
         UINT64_C(0x320b600000000000),
         UINT64_C(0x1466b00000000000),
         UINT64_C(0x541ae00000000000),
         UINT64_C(0x7672700000000000),
         UINT64_C(0x360e200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff407c500000000),
         UINT64_C(0x3ff6214c00000000),
         UINT64_C(0x3ff2268900000000),
         UINT64_C(0x3ff0405400000000),
         UINT64_C(0x3ff4479100000000),
         UINT64_C(0x3ff6611800000000),
         UINT64_C(0x3ff266dd00000000),
         UINT64_C(0x3ff1063f00000000),
         UINT64_C(0x3ff501fa00000000),
         UINT64_C(0x3ff7277300000000),
         UINT64_C(0x3ff320b600000000),
         UINT64_C(0x3ff1466b00000000),
         UINT64_C(0x3ff541ae00000000),
         UINT64_C(0x3ff7672700000000),
         UINT64_C(0x3ff360e200000000)},
        UINT64_C(0xfff8000000000000),
        {0xa5,0xcf,0x13,0x58,0xef,0x50,0xfc,0x76,0x6f,0x9b,
         0x11,0x07,0xda,0x3e,0x56,0x81,0x18,0x02,0x05,0x16,0x00}
    },
    {
        /* No.11 delta:6875 weight:2585 */
        11213,
        17,
        18,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x783de3e800000000),
         UINT64_C(0x3f8118ef00000000),
         UINT64_C(0x47bcfb0700000000),
         UINT64_C(0x3556000b00000000),
         UINT64_C(0x4d6be3e300000000),
         UINT64_C(0x0ad718e400000000),
         UINT64_C(0x72eafb0c00000000),
         UINT64_C(0x00000e1400000000),
         UINT64_C(0x783dedfc00000000),
         UINT64_C(0x3f8116fb00000000),
         UINT64_C(0x47bcf51300000000),
         UINT64_C(0x35560e1f00000000),
         UINT64_C(0x4d6bedf700000000),
         UINT64_C(0x0ad716f000000000),
         UINT64_C(0x72eaf51800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0c64000000000000),
         UINT64_C(0x11f0000000000000),
         UINT64_C(0x1d94000000000000),
         UINT64_C(0x4a64000000000000),
         UINT64_C(0x4600000000000000),
         UINT64_C(0x5b94000000000000),
         UINT64_C(0x57f0000000000000),
         UINT64_C(0x0263f00000000000),
         UINT64_C(0x0e07f00000000000),
         UINT64_C(0x1393f00000000000),
         UINT64_C(0x1ff7f00000000000),
         UINT64_C(0x4807f00000000000),
         UINT64_C(0x4463f00000000000),
         UINT64_C(0x59f7f00000000000),
         UINT64_C(0x5593f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0c64000000000),
         UINT64_C(0x3ff11f0000000000),
         UINT64_C(0x3ff1d94000000000),
         UINT64_C(0x3ff4a64000000000),
         UINT64_C(0x3ff4600000000000),
         UINT64_C(0x3ff5b94000000000),
         UINT64_C(0x3ff57f0000000000),
         UINT64_C(0x3ff0263f00000000),
         UINT64_C(0x3ff0e07f00000000),
         UINT64_C(0x3ff1393f00000000),
         UINT64_C(0x3ff1ff7f00000000),
         UINT64_C(0x3ff4807f00000000),
         UINT64_C(0x3ff4463f00000000),
         UINT64_C(0x3ff59f7f00000000),
         UINT64_C(0x3ff5593f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xc3,0x25,0x35,0x81,0x9e,0x56,0x56,0x32,0x9f,0x1a,
         0x66,0x11,0x6e,0xef,0x2d,0x76,0x31,0xff,0x61,0x28,0x00}
    },
    {
        /* No.12 delta:2355 weight:3447 */
        11213,
        10,
        17,
        15,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1eb1d9ce00000000),
         UINT64_C(0x84ff01cc00000000),
         UINT64_C(0x9a4ed80200000000),
         UINT64_C(0xd98d000c00000000),
         UINT64_C(0xc73cd9c200000000),
         UINT64_C(0x5d7201c000000000),
         UINT64_C(0x43c3d80e00000000),
         UINT64_C(0x00004b0600000000),
         UINT64_C(0x1eb192c800000000),
         UINT64_C(0x84ff4aca00000000),
         UINT64_C(0x9a4e930400000000),
         UINT64_C(0xd98d4b0a00000000),
         UINT64_C(0xc73c92c400000000),
         UINT64_C(0x5d724ac600000000),
         UINT64_C(0x43c3930800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8003c00000000000),
         UINT64_C(0x0008800000000000),
         UINT64_C(0x800b400000000000),
         UINT64_C(0x204db00000000000),
         UINT64_C(0xa04e700000000000),
         UINT64_C(0x2045300000000000),
         UINT64_C(0xa046f00000000000),
         UINT64_C(0x1023f00000000000),
         UINT64_C(0x9020300000000000),
         UINT64_C(0x102b700000000000),
         UINT64_C(0x9028b00000000000),
         UINT64_C(0x306e400000000000),
         UINT64_C(0xb06d800000000000),
         UINT64_C(0x3066c00000000000),
         UINT64_C(0xb065000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff8003c00000000),
         UINT64_C(0x3ff0008800000000),
         UINT64_C(0x3ff800b400000000),
         UINT64_C(0x3ff204db00000000),
         UINT64_C(0x3ffa04e700000000),
         UINT64_C(0x3ff2045300000000),
         UINT64_C(0x3ffa046f00000000),
         UINT64_C(0x3ff1023f00000000),
         UINT64_C(0x3ff9020300000000),
         UINT64_C(0x3ff102b700000000),
         UINT64_C(0x3ff9028b00000000),
         UINT64_C(0x3ff306e400000000),
         UINT64_C(0x3ffb06d800000000),
         UINT64_C(0x3ff3066c00000000),
         UINT64_C(0x3ffb065000000000)},
        UINT64_C(0xfff8000000000000),
        {0x2f,0x35,0xb5,0xb9,0xac,0x4b,0x7d,0xbe,0xab,0x35,
         0x0d,0x73,0x40,0xb3,0x44,0xea,0x19,0xf2,0x72,0xe0,0x00}
    },
    {
        /* No.13 delta:4067 weight:2905 */
        11213,
        6,
        13,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5b949fb800000000),
         UINT64_C(0xe83910e700000000),
         UINT64_C(0xb3ad8f5f00000000),
         UINT64_C(0xcf77000d00000000),
         UINT64_C(0x94e39fb500000000),
         UINT64_C(0x274e10ea00000000),
         UINT64_C(0x7cda8f5200000000),
         UINT64_C(0x0000160800000000),
         UINT64_C(0x5b9489b000000000),
         UINT64_C(0xe83906ef00000000),
         UINT64_C(0xb3ad995700000000),
         UINT64_C(0xcf77160500000000),
         UINT64_C(0x94e389bd00000000),
         UINT64_C(0x274e06e200000000),
         UINT64_C(0x7cda995a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1043a00000000000),
         UINT64_C(0x0647400000000000),
         UINT64_C(0x1604e00000000000),
         UINT64_C(0x6634800000000000),
         UINT64_C(0x7677200000000000),
         UINT64_C(0x6073c00000000000),
         UINT64_C(0x7030600000000000),
         UINT64_C(0x1db3f00000000000),
         UINT64_C(0x0df0500000000000),
         UINT64_C(0x1bf4b00000000000),
         UINT64_C(0x0bb7100000000000),
         UINT64_C(0x7b87700000000000),
         UINT64_C(0x6bc4d00000000000),
         UINT64_C(0x7dc0300000000000),
         UINT64_C(0x6d83900000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1043a00000000),
         UINT64_C(0x3ff0647400000000),
         UINT64_C(0x3ff1604e00000000),
         UINT64_C(0x3ff6634800000000),
         UINT64_C(0x3ff7677200000000),
         UINT64_C(0x3ff6073c00000000),
         UINT64_C(0x3ff7030600000000),
         UINT64_C(0x3ff1db3f00000000),
         UINT64_C(0x3ff0df0500000000),
         UINT64_C(0x3ff1bf4b00000000),
         UINT64_C(0x3ff0bb7100000000),
         UINT64_C(0x3ff7b87700000000),
         UINT64_C(0x3ff6bc4d00000000),
         UINT64_C(0x3ff7dc0300000000),
         UINT64_C(0x3ff6d83900000000)},
        UINT64_C(0xfff8000000000000),
        {0xf9,0x21,0x4f,0x6a,0x08,0x67,0x07,0x1a,0x2d,0x14,
         0xbe,0xb3,0x04,0x35,0x54,0x66,0xee,0x9c,0x82,0x94,0x00}
    },
    {
        /* No.14 delta:2663 weight:3071 */
        11213,
        9,
        21,
        11,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8ceaf82800000000),
         UINT64_C(0x3fcb179e00000000),
         UINT64_C(0xb321efb600000000),
         UINT64_C(0xffd1000e00000000),
         UINT64_C(0x733bf82600000000),
         UINT64_C(0xc01a179000000000),
         UINT64_C(0x4cf0efb800000000),
         UINT64_C(0x0000b64000000000),
         UINT64_C(0x8cea4e6800000000),
         UINT64_C(0x3fcba1de00000000),
         UINT64_C(0xb32159f600000000),
         UINT64_C(0xffd1b64e00000000),
         UINT64_C(0x733b4e6600000000),
         UINT64_C(0xc01aa1d000000000),
         UINT64_C(0x4cf059f800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1042a00000000000),
         UINT64_C(0x1001500000000000),
         UINT64_C(0x0043f00000000000),
         UINT64_C(0x4028400000000000),
         UINT64_C(0x506ae00000000000),
         UINT64_C(0x5029100000000000),
         UINT64_C(0x406bb00000000000),
         UINT64_C(0x1203f00000000000),
         UINT64_C(0x0241500000000000),
         UINT64_C(0x0202a00000000000),
         UINT64_C(0x1240000000000000),
         UINT64_C(0x522bb00000000000),
         UINT64_C(0x4269100000000000),
         UINT64_C(0x422ae00000000000),
         UINT64_C(0x5268400000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1042a00000000),
         UINT64_C(0x3ff1001500000000),
         UINT64_C(0x3ff0043f00000000),
         UINT64_C(0x3ff4028400000000),
         UINT64_C(0x3ff506ae00000000),
         UINT64_C(0x3ff5029100000000),
         UINT64_C(0x3ff406bb00000000),
         UINT64_C(0x3ff1203f00000000),
         UINT64_C(0x3ff0241500000000),
         UINT64_C(0x3ff0202a00000000),
         UINT64_C(0x3ff1240000000000),
         UINT64_C(0x3ff522bb00000000),
         UINT64_C(0x3ff4269100000000),
         UINT64_C(0x3ff422ae00000000),
         UINT64_C(0x3ff5268400000000)},
        UINT64_C(0xfff8000000000000),
        {0x0e,0x2e,0x62,0x1b,0x9e,0x35,0x9a,0x95,0x36,0x27,
         0x33,0xdc,0x00,0x54,0x9a,0xc5,0x94,0x00,0x01,0x5b,0x00}
    },
    {
        /* No.15 delta:5443 weight:3101 */
        11213,
        8,
        19,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2354451400000000),
         UINT64_C(0x223c1c6e00000000),
         UINT64_C(0x0168597a00000000),
         UINT64_C(0xd873000f00000000),
         UINT64_C(0xfb27451b00000000),
         UINT64_C(0xfa4f1c6100000000),
         UINT64_C(0xd91b597500000000),
         UINT64_C(0x0000043c00000000),
         UINT64_C(0x2354412800000000),
         UINT64_C(0x223c185200000000),
         UINT64_C(0x01685d4600000000),
         UINT64_C(0xd873043300000000),
         UINT64_C(0xfb27412700000000),
         UINT64_C(0xfa4f185d00000000),
         UINT64_C(0xd91b5d4900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0000800000000000),
         UINT64_C(0xd070400000000000),
         UINT64_C(0xd070c00000000000),
         UINT64_C(0x2091400000000000),
         UINT64_C(0x2091c00000000000),
         UINT64_C(0xf0e1000000000000),
         UINT64_C(0xf0e1800000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x1003700000000000),
         UINT64_C(0xc073b00000000000),
         UINT64_C(0xc073300000000000),
         UINT64_C(0x3092b00000000000),
         UINT64_C(0x3092300000000000),
         UINT64_C(0xe0e2f00000000000),
         UINT64_C(0xe0e2700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000800000000),
         UINT64_C(0x3ffd070400000000),
         UINT64_C(0x3ffd070c00000000),
         UINT64_C(0x3ff2091400000000),
         UINT64_C(0x3ff2091c00000000),
         UINT64_C(0x3fff0e1000000000),
         UINT64_C(0x3fff0e1800000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff1003700000000),
         UINT64_C(0x3ffc073b00000000),
         UINT64_C(0x3ffc073300000000),
         UINT64_C(0x3ff3092b00000000),
         UINT64_C(0x3ff3092300000000),
         UINT64_C(0x3ffe0e2f00000000),
         UINT64_C(0x3ffe0e2700000000)},
        UINT64_C(0xfff8000000000000),
        {0x87,0x8c,0x2b,0x60,0xf2,0xe4,0xde,0x1a,0x79,0xc2,
         0xa9,0x7e,0x68,0x3a,0xff,0x9d,0x3d,0x01,0x35,0x25,0x00}
    },
    {
        /* No.16 delta:1988 weight:2881 */
        11213,
        23,
        6,
        10,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc7f2a82d00000000),
         UINT64_C(0x857c938a00000000),
         UINT64_C(0x428e3ba700000000),
         UINT64_C(0xb786001000000000),
         UINT64_C(0x7074a83d00000000),
         UINT64_C(0x32fa939a00000000),
         UINT64_C(0xf5083bb700000000),
         UINT64_C(0x0000545200000000),
         UINT64_C(0xc7f2fc7f00000000),
         UINT64_C(0x857cc7d800000000),
         UINT64_C(0x428e6ff500000000),
         UINT64_C(0xb786544200000000),
         UINT64_C(0x7074fc6f00000000),
         UINT64_C(0x32fac7c800000000),
         UINT64_C(0xf5086fe500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3340200000000000),
         UINT64_C(0x2000400000000000),
         UINT64_C(0x1340600000000000),
         UINT64_C(0x0200000000000000),
         UINT64_C(0x3140200000000000),
         UINT64_C(0x2200400000000000),
         UINT64_C(0x1140600000000000),
         UINT64_C(0x3003f00000000000),
         UINT64_C(0x0343d00000000000),
         UINT64_C(0x1003b00000000000),
         UINT64_C(0x2343900000000000),
         UINT64_C(0x3203f00000000000),
         UINT64_C(0x0143d00000000000),
         UINT64_C(0x1203b00000000000),
         UINT64_C(0x2143900000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3340200000000),
         UINT64_C(0x3ff2000400000000),
         UINT64_C(0x3ff1340600000000),
         UINT64_C(0x3ff0200000000000),
         UINT64_C(0x3ff3140200000000),
         UINT64_C(0x3ff2200400000000),
         UINT64_C(0x3ff1140600000000),
         UINT64_C(0x3ff3003f00000000),
         UINT64_C(0x3ff0343d00000000),
         UINT64_C(0x3ff1003b00000000),
         UINT64_C(0x3ff2343900000000),
         UINT64_C(0x3ff3203f00000000),
         UINT64_C(0x3ff0143d00000000),
         UINT64_C(0x3ff1203b00000000),
         UINT64_C(0x3ff2143900000000)},
        UINT64_C(0xfff8000000000000),
        {0xb3,0xf8,0x91,0x65,0xa5,0xd5,0x74,0x7f,0xb2,0xfe,
         0xed,0x9b,0xaf,0x34,0xac,0x2d,0xb7,0xdb,0x6c,0x64,0x00}
    },
    {
        /* No.17 delta:2671 weight:3165 */
        11213,
        17,
        28,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xec580c8e00000000),
         UINT64_C(0x0386e54400000000),
         UINT64_C(0xefdee9ca00000000),
         UINT64_C(0xc3d2001100000000),
         UINT64_C(0x2f8a0c9f00000000),
         UINT64_C(0xc054e55500000000),
         UINT64_C(0x2c0ce9db00000000),
         UINT64_C(0x0000f9b300000000),
         UINT64_C(0xec58f53d00000000),
         UINT64_C(0x03861cf700000000),
         UINT64_C(0xefde107900000000),
         UINT64_C(0xc3d2f9a200000000),
         UINT64_C(0x2f8af52c00000000),
         UINT64_C(0xc0541ce600000000),
         UINT64_C(0x2c0c106800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x90cb900000000000),
         UINT64_C(0x4042700000000000),
         UINT64_C(0xd089e00000000000),
         UINT64_C(0x40be300000000000),
         UINT64_C(0xd075a00000000000),
         UINT64_C(0x00fc400000000000),
         UINT64_C(0x9037d00000000000),
         UINT64_C(0x0043f00000000000),
         UINT64_C(0x9088600000000000),
         UINT64_C(0x4001800000000000),
         UINT64_C(0xd0ca100000000000),
         UINT64_C(0x40fdc00000000000),
         UINT64_C(0xd036500000000000),
         UINT64_C(0x00bfb00000000000),
         UINT64_C(0x9074200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff90cb900000000),
         UINT64_C(0x3ff4042700000000),
         UINT64_C(0x3ffd089e00000000),
         UINT64_C(0x3ff40be300000000),
         UINT64_C(0x3ffd075a00000000),
         UINT64_C(0x3ff00fc400000000),
         UINT64_C(0x3ff9037d00000000),
         UINT64_C(0x3ff0043f00000000),
         UINT64_C(0x3ff9088600000000),
         UINT64_C(0x3ff4001800000000),
         UINT64_C(0x3ffd0ca100000000),
         UINT64_C(0x3ff40fdc00000000),
         UINT64_C(0x3ffd036500000000),
         UINT64_C(0x3ff00bfb00000000),
         UINT64_C(0x3ff9074200000000)},
        UINT64_C(0xfff8000000000000),
        {0x5f,0xa4,0x5a,0x76,0xde,0xd1,0x67,0x36,0xb9,0xae,
         0xda,0x66,0xc5,0xd9,0x20,0x11,0x52,0x3e,0x49,0x83,0x00}
    },
    {
        /* No.18 delta:2020 weight:3629 */
        11213,
        16,
        10,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6f34551c00000000),
         UINT64_C(0x933939ee00000000),
         UINT64_C(0xfc0d6cf200000000),
         UINT64_C(0x5ea5001200000000),
         UINT64_C(0x3191550e00000000),
         UINT64_C(0xcd9c39fc00000000),
         UINT64_C(0xa2a86ce000000000),
         UINT64_C(0x0000bbf100000000),
         UINT64_C(0x6f34eeed00000000),
         UINT64_C(0x9339821f00000000),
         UINT64_C(0xfc0dd70300000000),
         UINT64_C(0x5ea5bbe300000000),
         UINT64_C(0x3191eeff00000000),
         UINT64_C(0xcd9c820d00000000),
         UINT64_C(0xa2a8d71100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2002400000000000),
         UINT64_C(0x1000400000000000),
         UINT64_C(0x3002000000000000),
         UINT64_C(0x1010000000000000),
         UINT64_C(0x3012400000000000),
         UINT64_C(0x0010400000000000),
         UINT64_C(0x2012000000000000),
         UINT64_C(0xa003f00000000000),
         UINT64_C(0x8001b00000000000),
         UINT64_C(0xb003b00000000000),
         UINT64_C(0x9001f00000000000),
         UINT64_C(0xb013f00000000000),
         UINT64_C(0x9011b00000000000),
         UINT64_C(0xa013b00000000000),
         UINT64_C(0x8011f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2002400000000),
         UINT64_C(0x3ff1000400000000),
         UINT64_C(0x3ff3002000000000),
         UINT64_C(0x3ff1010000000000),
         UINT64_C(0x3ff3012400000000),
         UINT64_C(0x3ff0010400000000),
         UINT64_C(0x3ff2012000000000),
         UINT64_C(0x3ffa003f00000000),
         UINT64_C(0x3ff8001b00000000),
         UINT64_C(0x3ffb003b00000000),
         UINT64_C(0x3ff9001f00000000),
         UINT64_C(0x3ffb013f00000000),
         UINT64_C(0x3ff9011b00000000),
         UINT64_C(0x3ffa013b00000000),
         UINT64_C(0x3ff8011f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x5b,0xaa,0x80,0xc3,0xe2,0xd2,0x2f,0x73,0x36,0xcb,
         0x0c,0x18,0x46,0x5f,0x40,0x27,0x3f,0x2c,0x90,0x01,0x00}
    },
    {
        /* No.19 delta:2441 weight:3541 */
        11213,
        27,
        8,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x29a71f1a00000000),
         UINT64_C(0xf135101c00000000),
         UINT64_C(0xd8920f0600000000),
         UINT64_C(0x4e73001300000000),
         UINT64_C(0x67d41f0900000000),
         UINT64_C(0xbf46100f00000000),
         UINT64_C(0x96e10f1500000000),
         UINT64_C(0x0000394100000000),
         UINT64_C(0x29a7265b00000000),
         UINT64_C(0xf135295d00000000),
         UINT64_C(0xd892364700000000),
         UINT64_C(0x4e73395200000000),
         UINT64_C(0x67d4264800000000),
         UINT64_C(0xbf46294e00000000),
         UINT64_C(0x96e1365400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0002000000000000),
         UINT64_C(0x2004000000000000),
         UINT64_C(0x2006000000000000),
         UINT64_C(0x0410000000000000),
         UINT64_C(0x0412000000000000),
         UINT64_C(0x2414000000000000),
         UINT64_C(0x2416000000000000),
         UINT64_C(0x0213f00000000000),
         UINT64_C(0x0211f00000000000),
         UINT64_C(0x2217f00000000000),
         UINT64_C(0x2215f00000000000),
         UINT64_C(0x0603f00000000000),
         UINT64_C(0x0601f00000000000),
         UINT64_C(0x2607f00000000000),
         UINT64_C(0x2605f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0002000000000),
         UINT64_C(0x3ff2004000000000),
         UINT64_C(0x3ff2006000000000),
         UINT64_C(0x3ff0410000000000),
         UINT64_C(0x3ff0412000000000),
         UINT64_C(0x3ff2414000000000),
         UINT64_C(0x3ff2416000000000),
         UINT64_C(0x3ff0213f00000000),
         UINT64_C(0x3ff0211f00000000),
         UINT64_C(0x3ff2217f00000000),
         UINT64_C(0x3ff2215f00000000),
         UINT64_C(0x3ff0603f00000000),
         UINT64_C(0x3ff0601f00000000),
         UINT64_C(0x3ff2607f00000000),
         UINT64_C(0x3ff2605f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x10,0x07,0xfe,0x20,0x40,0xbf,0x2f,0xce,0x0a,0xe5,
         0xb1,0x03,0x9d,0x4a,0xfc,0xc9,0xc8,0x6c,0x9b,0x90,0x00}
    },
    {
        /* No.20 delta:4122 weight:2727 */
        11213,
        15,
        24,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x49999bb900000000),
         UINT64_C(0xadd2628000000000),
         UINT64_C(0xe44bf93900000000),
         UINT64_C(0x1345001400000000),
         UINT64_C(0x5adc9bad00000000),
         UINT64_C(0xbe97629400000000),
         UINT64_C(0xf70ef92d00000000),
         UINT64_C(0x00002c9c00000000),
         UINT64_C(0x4999b72500000000),
         UINT64_C(0xadd24e1c00000000),
         UINT64_C(0xe44bd5a500000000),
         UINT64_C(0x13452c8800000000),
         UINT64_C(0x5adcb73100000000),
         UINT64_C(0xbe974e0800000000),
         UINT64_C(0xf70ed5b100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2654000000000000),
         UINT64_C(0x184b500000000000),
         UINT64_C(0x3e1f500000000000),
         UINT64_C(0x1729800000000000),
         UINT64_C(0x317d800000000000),
         UINT64_C(0x0f62d00000000000),
         UINT64_C(0x2936d00000000000),
         UINT64_C(0x00c3f00000000000),
         UINT64_C(0x2697f00000000000),
         UINT64_C(0x1888a00000000000),
         UINT64_C(0x3edca00000000000),
         UINT64_C(0x17ea700000000000),
         UINT64_C(0x31be700000000000),
         UINT64_C(0x0fa1200000000000),
         UINT64_C(0x29f5200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2654000000000),
         UINT64_C(0x3ff184b500000000),
         UINT64_C(0x3ff3e1f500000000),
         UINT64_C(0x3ff1729800000000),
         UINT64_C(0x3ff317d800000000),
         UINT64_C(0x3ff0f62d00000000),
         UINT64_C(0x3ff2936d00000000),
         UINT64_C(0x3ff00c3f00000000),
         UINT64_C(0x3ff2697f00000000),
         UINT64_C(0x3ff1888a00000000),
         UINT64_C(0x3ff3edca00000000),
         UINT64_C(0x3ff17ea700000000),
         UINT64_C(0x3ff31be700000000),
         UINT64_C(0x3ff0fa1200000000),
         UINT64_C(0x3ff29f5200000000)},
        UINT64_C(0xfff8000000000000),
        {0xdc,0x20,0x3e,0xc0,0x65,0x6d,0xea,0x01,0xa9,0xd8,
         0x2f,0xa8,0x2b,0x2b,0xa5,0x86,0xcb,0x4d,0x89,0x5c,0x00}
    },
    {
        /* No.21 delta:2719 weight:3271 */
        11213,
        46,
        5,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xdef93ea400000000),
         UINT64_C(0x7996333e00000000),
         UINT64_C(0xa76f0d9a00000000),
         UINT64_C(0x04bc001500000000),
         UINT64_C(0xda453eb100000000),
         UINT64_C(0x7d2a332b00000000),
         UINT64_C(0xa3d30d8f00000000),
         UINT64_C(0x000022fd00000000),
         UINT64_C(0xdef91c5900000000),
         UINT64_C(0x799611c300000000),
         UINT64_C(0xa76f2f6700000000),
         UINT64_C(0x04bc22e800000000),
         UINT64_C(0xda451c4c00000000),
         UINT64_C(0x7d2a11d600000000),
         UINT64_C(0xa3d32f7200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4000400000000000),
         UINT64_C(0x2001000000000000),
         UINT64_C(0x6001400000000000),
         UINT64_C(0x2002f00000000000),
         UINT64_C(0x6002b00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x4003b00000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x1003b00000000000),
         UINT64_C(0x7002f00000000000),
         UINT64_C(0x3002b00000000000),
         UINT64_C(0x7001000000000000),
         UINT64_C(0x3001400000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x1000400000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4000400000000),
         UINT64_C(0x3ff2001000000000),
         UINT64_C(0x3ff6001400000000),
         UINT64_C(0x3ff2002f00000000),
         UINT64_C(0x3ff6002b00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff4003b00000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff1003b00000000),
         UINT64_C(0x3ff7002f00000000),
         UINT64_C(0x3ff3002b00000000),
         UINT64_C(0x3ff7001000000000),
         UINT64_C(0x3ff3001400000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff1000400000000)},
        UINT64_C(0xfff8000000000000),
        {0x8b,0x00,0x99,0x91,0x10,0xfa,0xb6,0xde,0x19,0x15,
         0x34,0x6c,0x9a,0xef,0x0c,0x49,0x48,0x66,0x99,0x47,0x00}
    },
    {
        /* No.22 delta:2325 weight:3479 */
        11213,
        35,
        3,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x7dc34e8c00000000),
         UINT64_C(0x9aa85e3900000000),
         UINT64_C(0xe76b10b500000000),
         UINT64_C(0xf1f6001600000000),
         UINT64_C(0x8c354e9a00000000),
         UINT64_C(0x6b5e5e2f00000000),
         UINT64_C(0x169d10a300000000),
         UINT64_C(0x0000641600000000),
         UINT64_C(0x7dc32a9a00000000),
         UINT64_C(0x9aa83a2f00000000),
         UINT64_C(0xe76b74a300000000),
         UINT64_C(0xf1f6640000000000),
         UINT64_C(0x8c352a8c00000000),
         UINT64_C(0x6b5e3a3900000000),
         UINT64_C(0x169d74b500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x000d000000000000),
         UINT64_C(0x3023c00000000000),
         UINT64_C(0x302ec00000000000),
         UINT64_C(0x0005800000000000),
         UINT64_C(0x0008800000000000),
         UINT64_C(0x3026400000000000),
         UINT64_C(0x302b400000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x000ef00000000000),
         UINT64_C(0x3020300000000000),
         UINT64_C(0x302d300000000000),
         UINT64_C(0x0006700000000000),
         UINT64_C(0x000b700000000000),
         UINT64_C(0x3025b00000000000),
         UINT64_C(0x3028b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff000d000000000),
         UINT64_C(0x3ff3023c00000000),
         UINT64_C(0x3ff302ec00000000),
         UINT64_C(0x3ff0005800000000),
         UINT64_C(0x3ff0008800000000),
         UINT64_C(0x3ff3026400000000),
         UINT64_C(0x3ff302b400000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff000ef00000000),
         UINT64_C(0x3ff3020300000000),
         UINT64_C(0x3ff302d300000000),
         UINT64_C(0x3ff0006700000000),
         UINT64_C(0x3ff000b700000000),
         UINT64_C(0x3ff3025b00000000),
         UINT64_C(0x3ff3028b00000000)},
        UINT64_C(0xfff8000000000000),
        {0x93,0x9c,0xf1,0xaf,0xc9,0x10,0xae,0x3b,0xcd,0xe0,
         0x04,0x7b,0x55,0x8d,0x80,0xf3,0x3f,0x85,0x49,0x4d,0x00}
    },
    {
        /* No.23 delta:2725 weight:3711 */
        11213,
        27,
        2,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x28aee2b900000000),
         UINT64_C(0x6075124100000000),
         UINT64_C(0x48dbf0f800000000),
         UINT64_C(0xd78c001700000000),
         UINT64_C(0xff22e2ae00000000),
         UINT64_C(0xb7f9125600000000),
         UINT64_C(0x9f57f0ef00000000),
         UINT64_C(0x00007cc500000000),
         UINT64_C(0x28ae9e7c00000000),
         UINT64_C(0x60756e8400000000),
         UINT64_C(0x48db8c3d00000000),
         UINT64_C(0xd78c7cd200000000),
         UINT64_C(0xff229e6b00000000),
         UINT64_C(0xb7f96e9300000000),
         UINT64_C(0x9f578c2a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0041000000000000),
         UINT64_C(0x4000500000000000),
         UINT64_C(0x4041500000000000),
         UINT64_C(0x0022100000000000),
         UINT64_C(0x0063100000000000),
         UINT64_C(0x4022400000000000),
         UINT64_C(0x4063400000000000),
         UINT64_C(0x2023f00000000000),
         UINT64_C(0x2062f00000000000),
         UINT64_C(0x6023a00000000000),
         UINT64_C(0x6062a00000000000),
         UINT64_C(0x2001e00000000000),
         UINT64_C(0x2040e00000000000),
         UINT64_C(0x6001b00000000000),
         UINT64_C(0x6040b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0041000000000),
         UINT64_C(0x3ff4000500000000),
         UINT64_C(0x3ff4041500000000),
         UINT64_C(0x3ff0022100000000),
         UINT64_C(0x3ff0063100000000),
         UINT64_C(0x3ff4022400000000),
         UINT64_C(0x3ff4063400000000),
         UINT64_C(0x3ff2023f00000000),
         UINT64_C(0x3ff2062f00000000),
         UINT64_C(0x3ff6023a00000000),
         UINT64_C(0x3ff6062a00000000),
         UINT64_C(0x3ff2001e00000000),
         UINT64_C(0x3ff2040e00000000),
         UINT64_C(0x3ff6001b00000000),
         UINT64_C(0x3ff6040b00000000)},
        UINT64_C(0xfff8000000000000),
        {0x96,0x7f,0x23,0xb9,0x55,0x09,0x95,0xd8,0xa9,0x4f,
         0x02,0xd4,0x01,0xd1,0xad,0x31,0xbc,0x5f,0x19,0x09,0x00}
    },
    {
        /* No.24 delta:2861 weight:4075 */
        11213,
        24,
        2,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8b8ad33200000000),
         UINT64_C(0x12ce6b6500000000),
         UINT64_C(0x9944b85700000000),
         UINT64_C(0xedce001800000000),
         UINT64_C(0x6644d32a00000000),
         UINT64_C(0xff006b7d00000000),
         UINT64_C(0x748ab84f00000000),
         UINT64_C(0x0000330c00000000),
         UINT64_C(0x8b8ae03e00000000),
         UINT64_C(0x12ce586900000000),
         UINT64_C(0x99448b5b00000000),
         UINT64_C(0xedce331400000000),
         UINT64_C(0x6644e02600000000),
         UINT64_C(0xff00587100000000),
         UINT64_C(0x748a8b4300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0013f00000000000),
         UINT64_C(0x3024400000000000),
         UINT64_C(0x3037b00000000000),
         UINT64_C(0x0043c00000000000),
         UINT64_C(0x0050300000000000),
         UINT64_C(0x3067800000000000),
         UINT64_C(0x3074700000000000),
         UINT64_C(0x102bf00000000000),
         UINT64_C(0x1038000000000000),
         UINT64_C(0x200fb00000000000),
         UINT64_C(0x201c400000000000),
         UINT64_C(0x1068300000000000),
         UINT64_C(0x107bc00000000000),
         UINT64_C(0x204c700000000000),
         UINT64_C(0x205f800000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0013f00000000),
         UINT64_C(0x3ff3024400000000),
         UINT64_C(0x3ff3037b00000000),
         UINT64_C(0x3ff0043c00000000),
         UINT64_C(0x3ff0050300000000),
         UINT64_C(0x3ff3067800000000),
         UINT64_C(0x3ff3074700000000),
         UINT64_C(0x3ff102bf00000000),
         UINT64_C(0x3ff1038000000000),
         UINT64_C(0x3ff200fb00000000),
         UINT64_C(0x3ff201c400000000),
         UINT64_C(0x3ff1068300000000),
         UINT64_C(0x3ff107bc00000000),
         UINT64_C(0x3ff204c700000000),
         UINT64_C(0x3ff205f800000000)},
        UINT64_C(0xfff8000000000000),
        {0x38,0x5b,0x91,0x40,0xdb,0x09,0x84,0x3b,0xdd,0xe9,
         0x46,0x53,0x7a,0x8a,0xf3,0xd7,0xfe,0xad,0xe2,0x44,0x00}
    },
    {
        /* No.25 delta:2340 weight:3025 */
        11213,
        23,
        4,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6dcbcc8000000000),
         UINT64_C(0xed6a44ad00000000),
         UINT64_C(0x80a1882d00000000),
         UINT64_C(0xc93c001900000000),
         UINT64_C(0xa4f7cc9900000000),
         UINT64_C(0x245644b400000000),
         UINT64_C(0x499d883400000000),
         UINT64_C(0x0000713d00000000),
         UINT64_C(0x6dcbbdbd00000000),
         UINT64_C(0xed6a359000000000),
         UINT64_C(0x80a1f91000000000),
         UINT64_C(0xc93c712400000000),
         UINT64_C(0xa4f7bda400000000),
         UINT64_C(0x2456358900000000),
         UINT64_C(0x499df90900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0800000000000000),
         UINT64_C(0xd000000000000000),
         UINT64_C(0xd800000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0800000000000000),
         UINT64_C(0xd000000000000000),
         UINT64_C(0xd800000000000000),
         UINT64_C(0x0043f00000000000),
         UINT64_C(0x0843f00000000000),
         UINT64_C(0xd043f00000000000),
         UINT64_C(0xd843f00000000000),
         UINT64_C(0x0043f00000000000),
         UINT64_C(0x0843f00000000000),
         UINT64_C(0xd043f00000000000),
         UINT64_C(0xd843f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0800000000000),
         UINT64_C(0x3ffd000000000000),
         UINT64_C(0x3ffd800000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0800000000000),
         UINT64_C(0x3ffd000000000000),
         UINT64_C(0x3ffd800000000000),
         UINT64_C(0x3ff0043f00000000),
         UINT64_C(0x3ff0843f00000000),
         UINT64_C(0x3ffd043f00000000),
         UINT64_C(0x3ffd843f00000000),
         UINT64_C(0x3ff0043f00000000),
         UINT64_C(0x3ff0843f00000000),
         UINT64_C(0x3ffd043f00000000),
         UINT64_C(0x3ffd843f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x1b,0xb3,0x97,0xf0,0x37,0x13,0xd6,0x2c,0x11,0xa9,
         0x15,0x11,0xa4,0x35,0xd4,0xde,0xea,0x80,0x2c,0xbf,0x00}
    },
    {
        /* No.26 delta:4473 weight:3103 */
        11213,
        21,
        25,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8b7095a100000000),
         UINT64_C(0xe406370600000000),
         UINT64_C(0x6f76a2a700000000),
         UINT64_C(0x8547001a00000000),
         UINT64_C(0x0e3795bb00000000),
         UINT64_C(0x6141371c00000000),
         UINT64_C(0xea31a2bd00000000),
         UINT64_C(0x00003dfb00000000),
         UINT64_C(0x8b70a85a00000000),
         UINT64_C(0xe4060afd00000000),
         UINT64_C(0x6f769f5c00000000),
         UINT64_C(0x85473de100000000),
         UINT64_C(0x0e37a84000000000),
         UINT64_C(0x61410ae700000000),
         UINT64_C(0xea319f4600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x44a5000000000000),
         UINT64_C(0x107e800000000000),
         UINT64_C(0x54db800000000000),
         UINT64_C(0x7060400000000000),
         UINT64_C(0x34c5400000000000),
         UINT64_C(0x601ec00000000000),
         UINT64_C(0x24bbc00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x54a6f00000000000),
         UINT64_C(0x007d700000000000),
         UINT64_C(0x44d8700000000000),
         UINT64_C(0x6063b00000000000),
         UINT64_C(0x24c6b00000000000),
         UINT64_C(0x701d300000000000),
         UINT64_C(0x34b8300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff44a5000000000),
         UINT64_C(0x3ff107e800000000),
         UINT64_C(0x3ff54db800000000),
         UINT64_C(0x3ff7060400000000),
         UINT64_C(0x3ff34c5400000000),
         UINT64_C(0x3ff601ec00000000),
         UINT64_C(0x3ff24bbc00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff54a6f00000000),
         UINT64_C(0x3ff007d700000000),
         UINT64_C(0x3ff44d8700000000),
         UINT64_C(0x3ff6063b00000000),
         UINT64_C(0x3ff24c6b00000000),
         UINT64_C(0x3ff701d300000000),
         UINT64_C(0x3ff34b8300000000)},
        UINT64_C(0xfff8000000000000),
        {0x80,0xfd,0x90,0xea,0x21,0xc8,0x32,0xf7,0x74,0x54,
         0xd5,0x89,0x51,0x2d,0xea,0x19,0x27,0x67,0x7e,0xdc,0x00}
    },
    {
        /* No.27 delta:3569 weight:2781 */
        11213,
        13,
        25,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa47d219400000000),
         UINT64_C(0x8baa572600000000),
         UINT64_C(0x2fd776b200000000),
         UINT64_C(0xdb7a001b00000000),
         UINT64_C(0x7f07218f00000000),
         UINT64_C(0x50d0573d00000000),
         UINT64_C(0xf4ad76a900000000),
         UINT64_C(0x0000094b00000000),
         UINT64_C(0xa47d28df00000000),
         UINT64_C(0x8baa5e6d00000000),
         UINT64_C(0x2fd77ff900000000),
         UINT64_C(0xdb7a095000000000),
         UINT64_C(0x7f0728c400000000),
         UINT64_C(0x50d05e7600000000),
         UINT64_C(0xf4ad7fe200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0442c00000000000),
         UINT64_C(0x0838c00000000000),
         UINT64_C(0x0c7a000000000000),
         UINT64_C(0x9045200000000000),
         UINT64_C(0x9407e00000000000),
         UINT64_C(0x987de00000000000),
         UINT64_C(0x9c3f200000000000),
         UINT64_C(0x1073f00000000000),
         UINT64_C(0x1431300000000000),
         UINT64_C(0x184b300000000000),
         UINT64_C(0x1c09f00000000000),
         UINT64_C(0x8036d00000000000),
         UINT64_C(0x8474100000000000),
         UINT64_C(0x880e100000000000),
         UINT64_C(0x8c4cd00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0442c00000000),
         UINT64_C(0x3ff0838c00000000),
         UINT64_C(0x3ff0c7a000000000),
         UINT64_C(0x3ff9045200000000),
         UINT64_C(0x3ff9407e00000000),
         UINT64_C(0x3ff987de00000000),
         UINT64_C(0x3ff9c3f200000000),
         UINT64_C(0x3ff1073f00000000),
         UINT64_C(0x3ff1431300000000),
         UINT64_C(0x3ff184b300000000),
         UINT64_C(0x3ff1c09f00000000),
         UINT64_C(0x3ff8036d00000000),
         UINT64_C(0x3ff8474100000000),
         UINT64_C(0x3ff880e100000000),
         UINT64_C(0x3ff8c4cd00000000)},
        UINT64_C(0xfff8000000000000),
        {0x17,0x05,0xf7,0xf0,0x7a,0xec,0x96,0x9c,0x22,0x48,
         0x05,0x15,0xf3,0x3c,0xeb,0x19,0xf1,0x48,0x84,0x86,0x00}
    },
    {
        /* No.28 delta:4949 weight:2365 */
        11213,
        43,
        1,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xb8c752c100000000),
         UINT64_C(0x9fb3be5000000000),
         UINT64_C(0x2774ec9100000000),
         UINT64_C(0x6dcc001c00000000),
         UINT64_C(0xd50b52dd00000000),
         UINT64_C(0xf27fbe4c00000000),
         UINT64_C(0x4ab8ec8d00000000),
         UINT64_C(0x000032fa00000000),
         UINT64_C(0xb8c7603b00000000),
         UINT64_C(0x9fb38caa00000000),
         UINT64_C(0x2774de6b00000000),
         UINT64_C(0x6dcc32e600000000),
         UINT64_C(0xd50b602700000000),
         UINT64_C(0xf27f8cb600000000),
         UINT64_C(0x4ab8de7700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0723000000000000),
         UINT64_C(0x6380000000000000),
         UINT64_C(0x64a3000000000000),
         UINT64_C(0x365f200000000000),
         UINT64_C(0x317c200000000000),
         UINT64_C(0x55df200000000000),
         UINT64_C(0x52fc200000000000),
         UINT64_C(0x031ff00000000000),
         UINT64_C(0x043cf00000000000),
         UINT64_C(0x609ff00000000000),
         UINT64_C(0x67bcf00000000000),
         UINT64_C(0x3540d00000000000),
         UINT64_C(0x3263d00000000000),
         UINT64_C(0x56c0d00000000000),
         UINT64_C(0x51e3d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0723000000000),
         UINT64_C(0x3ff6380000000000),
         UINT64_C(0x3ff64a3000000000),
         UINT64_C(0x3ff365f200000000),
         UINT64_C(0x3ff317c200000000),
         UINT64_C(0x3ff55df200000000),
         UINT64_C(0x3ff52fc200000000),
         UINT64_C(0x3ff031ff00000000),
         UINT64_C(0x3ff043cf00000000),
         UINT64_C(0x3ff609ff00000000),
         UINT64_C(0x3ff67bcf00000000),
         UINT64_C(0x3ff3540d00000000),
         UINT64_C(0x3ff3263d00000000),
         UINT64_C(0x3ff56c0d00000000),
         UINT64_C(0x3ff51e3d00000000)},
        UINT64_C(0xfff8000000000000),
        {0xdd,0x14,0x12,0xf8,0xa6,0x00,0x4c,0xbc,0x48,0x80,
         0x4d,0xfe,0x0b,0xac,0xcd,0xf8,0x20,0xdc,0x44,0x96,0x00}
    },
    {
        /* No.29 delta:2406 weight:3481 */
        11213,
        14,
        9,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc3b022ae00000000),
         UINT64_C(0xe7ae240100000000),
         UINT64_C(0x241e06af00000000),
         UINT64_C(0x026c001d00000000),
         UINT64_C(0xc1dc22b300000000),
         UINT64_C(0xe5c2241c00000000),
         UINT64_C(0x267206b200000000),
         UINT64_C(0x00001c2500000000),
         UINT64_C(0xc3b03e8b00000000),
         UINT64_C(0xe7ae382400000000),
         UINT64_C(0x241e1a8a00000000),
         UINT64_C(0x026c1c3800000000),
         UINT64_C(0xc1dc3e9600000000),
         UINT64_C(0xe5c2383900000000),
         UINT64_C(0x26721a9700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1002600000000000),
         UINT64_C(0x0001000000000000),
         UINT64_C(0x1003600000000000),
         UINT64_C(0x4810200000000000),
         UINT64_C(0x5812400000000000),
         UINT64_C(0x4811200000000000),
         UINT64_C(0x5813400000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x0001900000000000),
         UINT64_C(0x1002f00000000000),
         UINT64_C(0x0000900000000000),
         UINT64_C(0x5813d00000000000),
         UINT64_C(0x4811b00000000000),
         UINT64_C(0x5812d00000000000),
         UINT64_C(0x4810b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1002600000000),
         UINT64_C(0x3ff0001000000000),
         UINT64_C(0x3ff1003600000000),
         UINT64_C(0x3ff4810200000000),
         UINT64_C(0x3ff5812400000000),
         UINT64_C(0x3ff4811200000000),
         UINT64_C(0x3ff5813400000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff0001900000000),
         UINT64_C(0x3ff1002f00000000),
         UINT64_C(0x3ff0000900000000),
         UINT64_C(0x3ff5813d00000000),
         UINT64_C(0x3ff4811b00000000),
         UINT64_C(0x3ff5812d00000000),
         UINT64_C(0x3ff4810b00000000)},
        UINT64_C(0xfff8000000000000),
        {0xe3,0xae,0x70,0x66,0xcc,0xda,0x4c,0xb6,0x09,0xaf,
         0x33,0x07,0x44,0x6a,0x92,0xf3,0x67,0x05,0x7c,0x44,0x00}
    },
    {
        /* No.30 delta:2632 weight:2305 */
        11213,
        46,
        9,
        20,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2395441800000000),
         UINT64_C(0xaa9f145400000000),
         UINT64_C(0x890a504c00000000),
         UINT64_C(0x5596001e00000000),
         UINT64_C(0x7603440600000000),
         UINT64_C(0xff09144a00000000),
         UINT64_C(0xdc9c505200000000),
         UINT64_C(0x00004ed700000000),
         UINT64_C(0x23950acf00000000),
         UINT64_C(0xaa9f5a8300000000),
         UINT64_C(0x890a1e9b00000000),
         UINT64_C(0x55964ec900000000),
         UINT64_C(0x76030ad100000000),
         UINT64_C(0xff095a9d00000000),
         UINT64_C(0xdc9c1e8500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2022400000000000),
         UINT64_C(0x0002a00000000000),
         UINT64_C(0x2020e00000000000),
         UINT64_C(0x401bc00000000000),
         UINT64_C(0x6039800000000000),
         UINT64_C(0x4019600000000000),
         UINT64_C(0x603b200000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x2021b00000000000),
         UINT64_C(0x0001500000000000),
         UINT64_C(0x2023100000000000),
         UINT64_C(0x4018300000000000),
         UINT64_C(0x603a700000000000),
         UINT64_C(0x401a900000000000),
         UINT64_C(0x6038d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2022400000000),
         UINT64_C(0x3ff0002a00000000),
         UINT64_C(0x3ff2020e00000000),
         UINT64_C(0x3ff401bc00000000),
         UINT64_C(0x3ff6039800000000),
         UINT64_C(0x3ff4019600000000),
         UINT64_C(0x3ff603b200000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff2021b00000000),
         UINT64_C(0x3ff0001500000000),
         UINT64_C(0x3ff2023100000000),
         UINT64_C(0x3ff4018300000000),
         UINT64_C(0x3ff603a700000000),
         UINT64_C(0x3ff401a900000000),
         UINT64_C(0x3ff6038d00000000)},
        UINT64_C(0xfff8000000000000),
        {0x4c,0x26,0xb5,0x2f,0x4f,0xd4,0x58,0x0d,0x9a,0xa6,
         0xb0,0x88,0x90,0x5a,0xd6,0x63,0x1e,0x53,0x93,0x04,0x00}
    },
    {
        /* No.31 delta:4175 weight:3715 */
        11213,
        21,
        5,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x9b013d7300000000),
         UINT64_C(0x7a058a4f00000000),
         UINT64_C(0xe104b73c00000000),
         UINT64_C(0x7515001f00000000),
         UINT64_C(0xee143d6c00000000),
         UINT64_C(0x0f108a5000000000),
         UINT64_C(0x9411b72300000000),
         UINT64_C(0x0000175000000000),
         UINT64_C(0x9b012a2300000000),
         UINT64_C(0x7a059d1f00000000),
         UINT64_C(0xe104a06c00000000),
         UINT64_C(0x7515174f00000000),
         UINT64_C(0xee142a3c00000000),
         UINT64_C(0x0f109d0000000000),
         UINT64_C(0x9411a07300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x1023f00000000000),
         UINT64_C(0x1023f00000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x1023f00000000000),
         UINT64_C(0x1023f00000000000),
         UINT64_C(0x0023f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff1023f00000000),
         UINT64_C(0x3ff1023f00000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff1023f00000000),
         UINT64_C(0x3ff1023f00000000),
         UINT64_C(0x3ff0023f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x72,0x9a,0x24,0xd0,0xfb,0x14,0x66,0xdf,0xcf,0x81,
         0xcb,0x81,0x50,0x5f,0x45,0x67,0xab,0x7a,0x3c,0xf9,0x00}
    },
    {
        /* No.32 delta:2129 weight:3011 */
        11213,
        20,
        8,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe54ff0b700000000),
         UINT64_C(0x14de716000000000),
         UINT64_C(0xf19181d700000000),
         UINT64_C(0x7611002000000000),
         UINT64_C(0x935ef09700000000),
         UINT64_C(0x62cf714000000000),
         UINT64_C(0x878081f700000000),
         UINT64_C(0x0000811500000000),
         UINT64_C(0xe54f71a200000000),
         UINT64_C(0x14def07500000000),
         UINT64_C(0xf19100c200000000),
         UINT64_C(0x7611813500000000),
         UINT64_C(0x935e718200000000),
         UINT64_C(0x62cff05500000000),
         UINT64_C(0x878000e200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0f06400000000000),
         UINT64_C(0x0601400000000000),
         UINT64_C(0x0907000000000000),
         UINT64_C(0x6000800000000000),
         UINT64_C(0x6f06c00000000000),
         UINT64_C(0x6601c00000000000),
         UINT64_C(0x6907800000000000),
         UINT64_C(0x0083f00000000000),
         UINT64_C(0x0f85b00000000000),
         UINT64_C(0x0682b00000000000),
         UINT64_C(0x0984f00000000000),
         UINT64_C(0x6083700000000000),
         UINT64_C(0x6f85300000000000),
         UINT64_C(0x6682300000000000),
         UINT64_C(0x6984700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0f06400000000),
         UINT64_C(0x3ff0601400000000),
         UINT64_C(0x3ff0907000000000),
         UINT64_C(0x3ff6000800000000),
         UINT64_C(0x3ff6f06c00000000),
         UINT64_C(0x3ff6601c00000000),
         UINT64_C(0x3ff6907800000000),
         UINT64_C(0x3ff0083f00000000),
         UINT64_C(0x3ff0f85b00000000),
         UINT64_C(0x3ff0682b00000000),
         UINT64_C(0x3ff0984f00000000),
         UINT64_C(0x3ff6083700000000),
         UINT64_C(0x3ff6f85300000000),
         UINT64_C(0x3ff6682300000000),
         UINT64_C(0x3ff6984700000000)},
        UINT64_C(0xfff8000000000000),
        {0x3e,0xa0,0xc3,0x7f,0xf9,0x75,0x6c,0x29,0x8b,0xb6,
         0x44,0xea,0xf7,0xa0,0xb4,0x08,0x4c,0x9d,0xe0,0x81,0x00}
    },
    {
        /* No.33 delta:9222 weight:3741 */
        11213,
        31,
        3,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2376a56e00000000),
         UINT64_C(0x5e35e08600000000),
         UINT64_C(0x7d4345e800000000),
         UINT64_C(0x02df002100000000),
         UINT64_C(0x21a9a54f00000000),
         UINT64_C(0x5ceae0a700000000),
         UINT64_C(0x7f9c45c900000000),
         UINT64_C(0x0000164800000000),
         UINT64_C(0x2376b32600000000),
         UINT64_C(0x5e35f6ce00000000),
         UINT64_C(0x7d4353a000000000),
         UINT64_C(0x02df166900000000),
         UINT64_C(0x21a9b30700000000),
         UINT64_C(0x5ceaf6ef00000000),
         UINT64_C(0x7f9c538100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3400000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x3400000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x2400000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x2400000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x3403f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x3403f00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x2403f00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x2403f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3400000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3400000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff2400000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff2400000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff3403f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff3403f00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff2403f00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff2403f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xca,0x18,0xfc,0x3d,0xa7,0xf2,0xe2,0x3d,0xb8,0x0a,
         0x0b,0x59,0x87,0x6b,0x4c,0x67,0x5f,0x68,0xeb,0x85,0x00}
    },
    {
        /* No.34 delta:2251 weight:3161 */
        11213,
        35,
        4,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x57c20a7e00000000),
         UINT64_C(0x4497029100000000),
         UINT64_C(0x135508ef00000000),
         UINT64_C(0x388f002200000000),
         UINT64_C(0x6f4d0a5c00000000),
         UINT64_C(0x7c1802b300000000),
         UINT64_C(0x2bda08cd00000000),
         UINT64_C(0x0000a6b000000000),
         UINT64_C(0x57c2acce00000000),
         UINT64_C(0x4497a42100000000),
         UINT64_C(0x1355ae5f00000000),
         UINT64_C(0x388fa69200000000),
         UINT64_C(0x6f4dacec00000000),
         UINT64_C(0x7c18a40300000000),
         UINT64_C(0x2bdaae7d00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0c00800000000000),
         UINT64_C(0x4002500000000000),
         UINT64_C(0x4c02d00000000000),
         UINT64_C(0x0008000000000000),
         UINT64_C(0x0c08800000000000),
         UINT64_C(0x400a500000000000),
         UINT64_C(0x4c0ad00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x4c03700000000000),
         UINT64_C(0x0001a00000000000),
         UINT64_C(0x0c01200000000000),
         UINT64_C(0x400bf00000000000),
         UINT64_C(0x4c0b700000000000),
         UINT64_C(0x0009a00000000000),
         UINT64_C(0x0c09200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0c00800000000),
         UINT64_C(0x3ff4002500000000),
         UINT64_C(0x3ff4c02d00000000),
         UINT64_C(0x3ff0008000000000),
         UINT64_C(0x3ff0c08800000000),
         UINT64_C(0x3ff400a500000000),
         UINT64_C(0x3ff4c0ad00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff4c03700000000),
         UINT64_C(0x3ff0001a00000000),
         UINT64_C(0x3ff0c01200000000),
         UINT64_C(0x3ff400bf00000000),
         UINT64_C(0x3ff4c0b700000000),
         UINT64_C(0x3ff0009a00000000),
         UINT64_C(0x3ff0c09200000000)},
        UINT64_C(0xfff8000000000000),
        {0x02,0x98,0x7b,0x21,0xeb,0x11,0x45,0x2d,0x05,0xf5,
         0xfe,0x79,0x00,0xa3,0x98,0xbe,0x18,0x32,0x56,0x3d,0x00}
    },
    {
        /* No.35 delta:2373 weight:2379 */
        11213,
        33,
        9,
        22,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x379bfbac00000000),
         UINT64_C(0x688c729900000000),
         UINT64_C(0x5f17893500000000),
         UINT64_C(0xa165002300000000),
         UINT64_C(0x96fefb8f00000000),
         UINT64_C(0xc9e972ba00000000),
         UINT64_C(0xfe72891600000000),
         UINT64_C(0x0000f5cf00000000),
         UINT64_C(0x379b0e6300000000),
         UINT64_C(0x688c875600000000),
         UINT64_C(0x5f177cfa00000000),
         UINT64_C(0xa165f5ec00000000),
         UINT64_C(0x96fe0e4000000000),
         UINT64_C(0xc9e9877500000000),
         UINT64_C(0xfe727cd900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa042800000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0xa042800000000000),
         UINT64_C(0x8003800000000000),
         UINT64_C(0x2041000000000000),
         UINT64_C(0x8003800000000000),
         UINT64_C(0x2041000000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0xb041700000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0xb041700000000000),
         UINT64_C(0x9000700000000000),
         UINT64_C(0x3042f00000000000),
         UINT64_C(0x9000700000000000),
         UINT64_C(0x3042f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffa042800000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffa042800000000),
         UINT64_C(0x3ff8003800000000),
         UINT64_C(0x3ff2041000000000),
         UINT64_C(0x3ff8003800000000),
         UINT64_C(0x3ff2041000000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ffb041700000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ffb041700000000),
         UINT64_C(0x3ff9000700000000),
         UINT64_C(0x3ff3042f00000000),
         UINT64_C(0x3ff9000700000000),
         UINT64_C(0x3ff3042f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xfc,0x06,0x81,0x60,0x05,0xfe,0xec,0xe1,0x1f,0xdd,
         0x56,0x5f,0x04,0xd3,0xc0,0x3e,0xe7,0x7d,0xdb,0x28,0x00}
    },
    {
        /* No.36 delta:2355 weight:3655 */
        11213,
        38,
        9,
        7,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5884d09300000000),
         UINT64_C(0x1f8ad31100000000),
         UINT64_C(0x470e038200000000),
         UINT64_C(0x2d89002400000000),
         UINT64_C(0x750dd0b700000000),
         UINT64_C(0x3203d33500000000),
         UINT64_C(0x6a8703a600000000),
         UINT64_C(0x00005d2300000000),
         UINT64_C(0x58848db000000000),
         UINT64_C(0x1f8a8e3200000000),
         UINT64_C(0x470e5ea100000000),
         UINT64_C(0x2d895d0700000000),
         UINT64_C(0x750d8d9400000000),
         UINT64_C(0x32038e1600000000),
         UINT64_C(0x6a875e8500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4000600000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x0000600000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0x7000600000000000),
         UINT64_C(0x7000000000000000),
         UINT64_C(0x3000600000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x2003900000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x6003900000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x1003900000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x5003900000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4000600000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff0000600000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ff7000600000000),
         UINT64_C(0x3ff7000000000000),
         UINT64_C(0x3ff3000600000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff2003900000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff6003900000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff1003900000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff5003900000000)},
        UINT64_C(0xfff8000000000000),
        {0x50,0xf6,0xb1,0x15,0x93,0x37,0x6b,0x92,0xb4,0xec,
         0x93,0x79,0xb6,0x3a,0x70,0x84,0xd9,0xe4,0x55,0x8d,0x00}
    },
    {
        /* No.37 delta:3622 weight:3913 */
        11213,
        24,
        1,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x63a0300b00000000),
         UINT64_C(0x70269f0e00000000),
         UINT64_C(0x1386af0500000000),
         UINT64_C(0xf589002500000000),
         UINT64_C(0x9629302e00000000),
         UINT64_C(0x85af9f2b00000000),
         UINT64_C(0xe60faf2000000000),
         UINT64_C(0x0000f70a00000000),
         UINT64_C(0x63a0c70100000000),
         UINT64_C(0x7026680400000000),
         UINT64_C(0x1386580f00000000),
         UINT64_C(0xf589f72f00000000),
         UINT64_C(0x9629c72400000000),
         UINT64_C(0x85af682100000000),
         UINT64_C(0xe60f582a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xdbee800000000000),
         UINT64_C(0x0059100000000000),
         UINT64_C(0xdbb7900000000000),
         UINT64_C(0x3124c00000000000),
         UINT64_C(0xeaca400000000000),
         UINT64_C(0x317dd00000000000),
         UINT64_C(0xea93500000000000),
         UINT64_C(0x041ff00000000000),
         UINT64_C(0xdff1700000000000),
         UINT64_C(0x0446e00000000000),
         UINT64_C(0xdfa8600000000000),
         UINT64_C(0x353b300000000000),
         UINT64_C(0xeed5b00000000000),
         UINT64_C(0x3562200000000000),
         UINT64_C(0xee8ca00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffdbee800000000),
         UINT64_C(0x3ff0059100000000),
         UINT64_C(0x3ffdbb7900000000),
         UINT64_C(0x3ff3124c00000000),
         UINT64_C(0x3ffeaca400000000),
         UINT64_C(0x3ff317dd00000000),
         UINT64_C(0x3ffea93500000000),
         UINT64_C(0x3ff041ff00000000),
         UINT64_C(0x3ffdff1700000000),
         UINT64_C(0x3ff0446e00000000),
         UINT64_C(0x3ffdfa8600000000),
         UINT64_C(0x3ff353b300000000),
         UINT64_C(0x3ffeed5b00000000),
         UINT64_C(0x3ff3562200000000),
         UINT64_C(0x3ffee8ca00000000)},
        UINT64_C(0xfff8000000000000),
        {0xbd,0xde,0xa5,0x17,0xd1,0xf5,0x01,0xf2,0x12,0xb2,
         0xe5,0xa3,0x09,0xc5,0xc1,0xa5,0xd0,0xc5,0x7a,0x12,0x00}
    },
    {
        /* No.38 delta:2096 weight:3639 */
        11213,
        43,
        7,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x9798625900000000),
         UINT64_C(0x0479c90d00000000),
         UINT64_C(0x93e1ab5400000000),
         UINT64_C(0x424a002600000000),
         UINT64_C(0xd5d2627f00000000),
         UINT64_C(0x4633c92b00000000),
         UINT64_C(0xd1abab7200000000),
         UINT64_C(0x0000c60600000000),
         UINT64_C(0x9798a45f00000000),
         UINT64_C(0x04790f0b00000000),
         UINT64_C(0x93e16d5200000000),
         UINT64_C(0x424ac62000000000),
         UINT64_C(0xd5d2a47900000000),
         UINT64_C(0x46330f2d00000000),
         UINT64_C(0xd1ab6d7400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0180800000000000),
         UINT64_C(0x0080700000000000),
         UINT64_C(0x0100f00000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0180800000000000),
         UINT64_C(0x0080700000000000),
         UINT64_C(0x0100f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0183700000000000),
         UINT64_C(0x0083800000000000),
         UINT64_C(0x0103000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0183700000000000),
         UINT64_C(0x0083800000000000),
         UINT64_C(0x0103000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0180800000000),
         UINT64_C(0x3ff0080700000000),
         UINT64_C(0x3ff0100f00000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0180800000000),
         UINT64_C(0x3ff0080700000000),
         UINT64_C(0x3ff0100f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0183700000000),
         UINT64_C(0x3ff0083800000000),
         UINT64_C(0x3ff0103000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0183700000000),
         UINT64_C(0x3ff0083800000000),
         UINT64_C(0x3ff0103000000000)},
        UINT64_C(0xfff8000000000000),
        {0xae,0x1d,0x0e,0x19,0x11,0x9f,0x28,0x9f,0x9a,0x3c,
         0xef,0x85,0x05,0x77,0x3f,0x7c,0x7d,0xba,0xce,0x59,0x00}
    },
    {
        /* No.39 delta:5011 weight:3713 */
        11213,
        12,
        2,
        7,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xfc84266300000000),
         UINT64_C(0xfce8208600000000),
         UINT64_C(0x006c06e500000000),
         UINT64_C(0xeef9002700000000),
         UINT64_C(0x127d264400000000),
         UINT64_C(0x121120a100000000),
         UINT64_C(0xee9506c200000000),
         UINT64_C(0x0000553b00000000),
         UINT64_C(0xfc84735800000000),
         UINT64_C(0xfce875bd00000000),
         UINT64_C(0x006c53de00000000),
         UINT64_C(0xeef9551c00000000),
         UINT64_C(0x127d737f00000000),
         UINT64_C(0x1211759a00000000),
         UINT64_C(0xee9553f900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2012000000000000),
         UINT64_C(0x1041100000000000),
         UINT64_C(0x3053100000000000),
         UINT64_C(0x0800000000000000),
         UINT64_C(0x2812000000000000),
         UINT64_C(0x1841100000000000),
         UINT64_C(0x3853100000000000),
         UINT64_C(0x000bf00000000000),
         UINT64_C(0x2019f00000000000),
         UINT64_C(0x104ae00000000000),
         UINT64_C(0x3058e00000000000),
         UINT64_C(0x080bf00000000000),
         UINT64_C(0x2819f00000000000),
         UINT64_C(0x184ae00000000000),
         UINT64_C(0x3858e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2012000000000),
         UINT64_C(0x3ff1041100000000),
         UINT64_C(0x3ff3053100000000),
         UINT64_C(0x3ff0800000000000),
         UINT64_C(0x3ff2812000000000),
         UINT64_C(0x3ff1841100000000),
         UINT64_C(0x3ff3853100000000),
         UINT64_C(0x3ff000bf00000000),
         UINT64_C(0x3ff2019f00000000),
         UINT64_C(0x3ff104ae00000000),
         UINT64_C(0x3ff3058e00000000),
         UINT64_C(0x3ff080bf00000000),
         UINT64_C(0x3ff2819f00000000),
         UINT64_C(0x3ff184ae00000000),
         UINT64_C(0x3ff3858e00000000)},
        UINT64_C(0xfff8000000000000),
        {0xef,0x1a,0x1e,0x52,0x6c,0x16,0x09,0x7f,0xab,0x42,
         0x05,0x9c,0x6c,0x0c,0x90,0x81,0x37,0x56,0x23,0x86,0x00}
    },
    {
        /* No.40 delta:3477 weight:4125 */
        11213,
        19,
        1,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa69c4fab00000000),
         UINT64_C(0xa11bfc8e00000000),
         UINT64_C(0x0787b32500000000),
         UINT64_C(0x4c18002800000000),
         UINT64_C(0xea844f8300000000),
         UINT64_C(0xed03fca600000000),
         UINT64_C(0x4b9fb30d00000000),
         UINT64_C(0x00009d5100000000),
         UINT64_C(0xa69cd2fa00000000),
         UINT64_C(0xa11b61df00000000),
         UINT64_C(0x07872e7400000000),
         UINT64_C(0x4c189d7900000000),
         UINT64_C(0xea84d2d200000000),
         UINT64_C(0xed0361f700000000),
         UINT64_C(0x4b9f2e5c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x96e2400000000000),
         UINT64_C(0x014dc00000000000),
         UINT64_C(0x97af800000000000),
         UINT64_C(0x28fd800000000000),
         UINT64_C(0xbe1fc00000000000),
         UINT64_C(0x29b0400000000000),
         UINT64_C(0xbf52000000000000),
         UINT64_C(0x0077f00000000000),
         UINT64_C(0x9695b00000000000),
         UINT64_C(0x013a300000000000),
         UINT64_C(0x97d8700000000000),
         UINT64_C(0x288a700000000000),
         UINT64_C(0xbe68300000000000),
         UINT64_C(0x29c7b00000000000),
         UINT64_C(0xbf25f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff96e2400000000),
         UINT64_C(0x3ff014dc00000000),
         UINT64_C(0x3ff97af800000000),
         UINT64_C(0x3ff28fd800000000),
         UINT64_C(0x3ffbe1fc00000000),
         UINT64_C(0x3ff29b0400000000),
         UINT64_C(0x3ffbf52000000000),
         UINT64_C(0x3ff0077f00000000),
         UINT64_C(0x3ff9695b00000000),
         UINT64_C(0x3ff013a300000000),
         UINT64_C(0x3ff97d8700000000),
         UINT64_C(0x3ff288a700000000),
         UINT64_C(0x3ffbe68300000000),
         UINT64_C(0x3ff29c7b00000000),
         UINT64_C(0x3ffbf25f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xb8,0xad,0x69,0x94,0x45,0x50,0x98,0x37,0x75,0x8f,
         0xf3,0xce,0x26,0xe4,0x82,0x11,0x45,0xd1,0x9b,0xa8,0x00}
    },
    {
        /* No.41 delta:2614 weight:2641 */
        11213,
        6,
        6,
        10,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xf6bf38d400000000),
         UINT64_C(0x0f7a546100000000),
         UINT64_C(0xf9c56cb500000000),
         UINT64_C(0xff0a002900000000),
         UINT64_C(0x09b538fd00000000),
         UINT64_C(0xf070544800000000),
         UINT64_C(0x06cf6c9c00000000),
         UINT64_C(0x0000d28e00000000),
         UINT64_C(0xf6bfea5a00000000),
         UINT64_C(0x0f7a86ef00000000),
         UINT64_C(0xf9c5be3b00000000),
         UINT64_C(0xff0ad2a700000000),
         UINT64_C(0x09b5ea7300000000),
         UINT64_C(0xf07086c600000000),
         UINT64_C(0x06cfbe1200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x201c100000000000),
         UINT64_C(0x8046c00000000000),
         UINT64_C(0xa05ad00000000000),
         UINT64_C(0x0040800000000000),
         UINT64_C(0x205c900000000000),
         UINT64_C(0x8006400000000000),
         UINT64_C(0xa01a500000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x401fe00000000000),
         UINT64_C(0xe045300000000000),
         UINT64_C(0xc059200000000000),
         UINT64_C(0x6043700000000000),
         UINT64_C(0x405f600000000000),
         UINT64_C(0xe005b00000000000),
         UINT64_C(0xc019a00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff201c100000000),
         UINT64_C(0x3ff8046c00000000),
         UINT64_C(0x3ffa05ad00000000),
         UINT64_C(0x3ff0040800000000),
         UINT64_C(0x3ff205c900000000),
         UINT64_C(0x3ff8006400000000),
         UINT64_C(0x3ffa01a500000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff401fe00000000),
         UINT64_C(0x3ffe045300000000),
         UINT64_C(0x3ffc059200000000),
         UINT64_C(0x3ff6043700000000),
         UINT64_C(0x3ff405f600000000),
         UINT64_C(0x3ffe005b00000000),
         UINT64_C(0x3ffc019a00000000)},
        UINT64_C(0xfff8000000000000),
        {0x9c,0x2e,0x54,0xeb,0x68,0x3e,0x6c,0x9f,0xa1,0xcb,
         0x98,0xa5,0xba,0x7b,0x59,0x31,0xfb,0x1c,0x17,0xef,0x00}
    },
    {
        /* No.42 delta:5880 weight:2135 */
        11213,
        41,
        25,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4e50bace00000000),
         UINT64_C(0x8b26ae4800000000),
         UINT64_C(0xc576148600000000),
         UINT64_C(0xab17002a00000000),
         UINT64_C(0xe547bae400000000),
         UINT64_C(0x2031ae6200000000),
         UINT64_C(0x6e6114ac00000000),
         UINT64_C(0x000090f000000000),
         UINT64_C(0x4e502a3e00000000),
         UINT64_C(0x8b263eb800000000),
         UINT64_C(0xc576847600000000),
         UINT64_C(0xab1790da00000000),
         UINT64_C(0xe5472a1400000000),
         UINT64_C(0x20313e9200000000),
         UINT64_C(0x6e61845c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0b6d000000000000),
         UINT64_C(0x8040000000000000),
         UINT64_C(0x8b2d000000000000),
         UINT64_C(0x2062000000000000),
         UINT64_C(0x2b0f000000000000),
         UINT64_C(0xa022000000000000),
         UINT64_C(0xab4f000000000000),
         UINT64_C(0x1087f00000000000),
         UINT64_C(0x1beaf00000000000),
         UINT64_C(0x90c7f00000000000),
         UINT64_C(0x9baaf00000000000),
         UINT64_C(0x30e5f00000000000),
         UINT64_C(0x3b88f00000000000),
         UINT64_C(0xb0a5f00000000000),
         UINT64_C(0xbbc8f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0b6d000000000),
         UINT64_C(0x3ff8040000000000),
         UINT64_C(0x3ff8b2d000000000),
         UINT64_C(0x3ff2062000000000),
         UINT64_C(0x3ff2b0f000000000),
         UINT64_C(0x3ffa022000000000),
         UINT64_C(0x3ffab4f000000000),
         UINT64_C(0x3ff1087f00000000),
         UINT64_C(0x3ff1beaf00000000),
         UINT64_C(0x3ff90c7f00000000),
         UINT64_C(0x3ff9baaf00000000),
         UINT64_C(0x3ff30e5f00000000),
         UINT64_C(0x3ff3b88f00000000),
         UINT64_C(0x3ffb0a5f00000000),
         UINT64_C(0x3ffbbc8f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x0b,0x81,0xd2,0xe1,0x5f,0xdd,0xe6,0xfb,0x85,0x0d,
         0x31,0xd8,0x21,0x42,0x26,0x2f,0xf1,0x4a,0x45,0x1c,0x00}
    },
    {
        /* No.43 delta:4981 weight:1383 */
        11213,
        5,
        1,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x299a431500000000),
         UINT64_C(0x50f520aa00000000),
         UINT64_C(0x796f63bf00000000),
         UINT64_C(0xee13002b00000000),
         UINT64_C(0xc789433e00000000),
         UINT64_C(0xbee6208100000000),
         UINT64_C(0x977c639400000000),
         UINT64_C(0x0000efdd00000000),
         UINT64_C(0x299aacc800000000),
         UINT64_C(0x50f5cf7700000000),
         UINT64_C(0x796f8c6200000000),
         UINT64_C(0xee13eff600000000),
         UINT64_C(0xc789ace300000000),
         UINT64_C(0xbee6cf5c00000000),
         UINT64_C(0x977c8c4900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2840000000000000),
         UINT64_C(0x110d000000000000),
         UINT64_C(0x394d000000000000),
         UINT64_C(0xc06b900000000000),
         UINT64_C(0xe82b900000000000),
         UINT64_C(0xd166900000000000),
         UINT64_C(0xf926900000000000),
         UINT64_C(0x00bbf00000000000),
         UINT64_C(0x28fbf00000000000),
         UINT64_C(0x11b6f00000000000),
         UINT64_C(0x39f6f00000000000),
         UINT64_C(0xc0d0600000000000),
         UINT64_C(0xe890600000000000),
         UINT64_C(0xd1dd600000000000),
         UINT64_C(0xf99d600000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2840000000000),
         UINT64_C(0x3ff110d000000000),
         UINT64_C(0x3ff394d000000000),
         UINT64_C(0x3ffc06b900000000),
         UINT64_C(0x3ffe82b900000000),
         UINT64_C(0x3ffd166900000000),
         UINT64_C(0x3fff926900000000),
         UINT64_C(0x3ff00bbf00000000),
         UINT64_C(0x3ff28fbf00000000),
         UINT64_C(0x3ff11b6f00000000),
         UINT64_C(0x3ff39f6f00000000),
         UINT64_C(0x3ffc0d0600000000),
         UINT64_C(0x3ffe890600000000),
         UINT64_C(0x3ffd1dd600000000),
         UINT64_C(0x3fff99d600000000)},
        UINT64_C(0xfff8000000000000),
        {0x42,0x07,0x47,0x10,0xa4,0x69,0x72,0x5d,0xdc,0x52,
         0x90,0x5d,0x69,0x6a,0x54,0x94,0xd1,0x24,0x87,0x37,0x00}
    },
    {
        /* No.44 delta:3617 weight:3195 */
        11213,
        38,
        19,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc48596b600000000),
         UINT64_C(0x3f06918600000000),
         UINT64_C(0xfb83073000000000),
         UINT64_C(0xe2a0002c00000000),
         UINT64_C(0x2625969a00000000),
         UINT64_C(0xdda691aa00000000),
         UINT64_C(0x1923071c00000000),
         UINT64_C(0x00001a0200000000),
         UINT64_C(0xc4858cb400000000),
         UINT64_C(0x3f068b8400000000),
         UINT64_C(0xfb831d3200000000),
         UINT64_C(0xe2a01a2e00000000),
         UINT64_C(0x26258c9800000000),
         UINT64_C(0xdda68ba800000000),
         UINT64_C(0x19231d1e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4fa1c00000000000),
         UINT64_C(0x8621600000000000),
         UINT64_C(0xc980a00000000000),
         UINT64_C(0x0043000000000000),
         UINT64_C(0x4fe2c00000000000),
         UINT64_C(0x8662600000000000),
         UINT64_C(0xc9c3a00000000000),
         UINT64_C(0x17b3f00000000000),
         UINT64_C(0x5812300000000000),
         UINT64_C(0x9192900000000000),
         UINT64_C(0xde33500000000000),
         UINT64_C(0x17f0f00000000000),
         UINT64_C(0x5851300000000000),
         UINT64_C(0x91d1900000000000),
         UINT64_C(0xde70500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4fa1c00000000),
         UINT64_C(0x3ff8621600000000),
         UINT64_C(0x3ffc980a00000000),
         UINT64_C(0x3ff0043000000000),
         UINT64_C(0x3ff4fe2c00000000),
         UINT64_C(0x3ff8662600000000),
         UINT64_C(0x3ffc9c3a00000000),
         UINT64_C(0x3ff17b3f00000000),
         UINT64_C(0x3ff5812300000000),
         UINT64_C(0x3ff9192900000000),
         UINT64_C(0x3ffde33500000000),
         UINT64_C(0x3ff17f0f00000000),
         UINT64_C(0x3ff5851300000000),
         UINT64_C(0x3ff91d1900000000),
         UINT64_C(0x3ffde70500000000)},
        UINT64_C(0xfff8000000000000),
        {0xf2,0xce,0x7b,0xab,0xba,0xba,0xb5,0xab,0xb6,0xb5,
         0x09,0x4a,0x70,0x9a,0x6b,0x48,0x59,0x26,0xe3,0x3a,0x00}
    },
    {
        /* No.45 delta:2689 weight:3551 */
        11213,
        33,
        5,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x40b640bb00000000),
         UINT64_C(0xce5f415600000000),
         UINT64_C(0x8ee901ed00000000),
         UINT64_C(0xa48d002d00000000),
         UINT64_C(0xe43b409600000000),
         UINT64_C(0x6ad2417b00000000),
         UINT64_C(0x2a6401c000000000),
         UINT64_C(0x000085cb00000000),
         UINT64_C(0x40b6c57000000000),
         UINT64_C(0xce5fc49d00000000),
         UINT64_C(0x8ee9842600000000),
         UINT64_C(0xa48d85e600000000),
         UINT64_C(0xe43bc55d00000000),
         UINT64_C(0x6ad2c4b000000000),
         UINT64_C(0x2a64840b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0x1000400000000000),
         UINT64_C(0x2000400000000000),
         UINT64_C(0x1000400000000000),
         UINT64_C(0x2000400000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x3003f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x3003f00000000000),
         UINT64_C(0x1003b00000000000),
         UINT64_C(0x2003b00000000000),
         UINT64_C(0x1003b00000000000),
         UINT64_C(0x2003b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ff1000400000000),
         UINT64_C(0x3ff2000400000000),
         UINT64_C(0x3ff1000400000000),
         UINT64_C(0x3ff2000400000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff3003f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff3003f00000000),
         UINT64_C(0x3ff1003b00000000),
         UINT64_C(0x3ff2003b00000000),
         UINT64_C(0x3ff1003b00000000),
         UINT64_C(0x3ff2003b00000000)},
        UINT64_C(0xfff8000000000000),
        {0xb3,0x20,0x9b,0xb1,0x05,0x5f,0x67,0x1a,0x2a,0x29,
         0x0d,0xc3,0x2e,0x89,0xf1,0xd3,0x0b,0x8d,0xd6,0xfc,0x00}
    },
    {
        /* No.46 delta:4987 weight:1627 */
        11213,
        36,
        1,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5b945b7400000000),
         UINT64_C(0x1eb6b84c00000000),
         UINT64_C(0x4522e33800000000),
         UINT64_C(0x162c002e00000000),
         UINT64_C(0x4db85b5a00000000),
         UINT64_C(0x089ab86200000000),
         UINT64_C(0x530ee31600000000),
         UINT64_C(0x0000f96d00000000),
         UINT64_C(0x5b94a21900000000),
         UINT64_C(0x1eb6412100000000),
         UINT64_C(0x45221a5500000000),
         UINT64_C(0x162cf94300000000),
         UINT64_C(0x4db8a23700000000),
         UINT64_C(0x089a410f00000000),
         UINT64_C(0x530e1a7b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0c35800000000000),
         UINT64_C(0x1051800000000000),
         UINT64_C(0x1c64000000000000),
         UINT64_C(0x6921100000000000),
         UINT64_C(0x6514900000000000),
         UINT64_C(0x7970900000000000),
         UINT64_C(0x7545100000000000),
         UINT64_C(0x01c3f00000000000),
         UINT64_C(0x0df6700000000000),
         UINT64_C(0x1192700000000000),
         UINT64_C(0x1da7f00000000000),
         UINT64_C(0x68e2e00000000000),
         UINT64_C(0x64d7600000000000),
         UINT64_C(0x78b3600000000000),
         UINT64_C(0x7486e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0c35800000000),
         UINT64_C(0x3ff1051800000000),
         UINT64_C(0x3ff1c64000000000),
         UINT64_C(0x3ff6921100000000),
         UINT64_C(0x3ff6514900000000),
         UINT64_C(0x3ff7970900000000),
         UINT64_C(0x3ff7545100000000),
         UINT64_C(0x3ff01c3f00000000),
         UINT64_C(0x3ff0df6700000000),
         UINT64_C(0x3ff1192700000000),
         UINT64_C(0x3ff1da7f00000000),
         UINT64_C(0x3ff68e2e00000000),
         UINT64_C(0x3ff64d7600000000),
         UINT64_C(0x3ff78b3600000000),
         UINT64_C(0x3ff7486e00000000)},
        UINT64_C(0xfff8000000000000),
        {0x65,0xe6,0x9e,0xd2,0xbd,0xa3,0xe4,0x2a,0x26,0x72,
         0xf1,0xac,0xb0,0x41,0xef,0x78,0x15,0x72,0xcb,0x3f,0x00}
    },
    {
        /* No.47 delta:3723 weight:2885 */
        11213,
        33,
        13,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2d89a82900000000),
         UINT64_C(0xb67418a200000000),
         UINT64_C(0x9bfdb08b00000000),
         UINT64_C(0x9f3d002f00000000),
         UINT64_C(0xb2b4a80600000000),
         UINT64_C(0x2949188d00000000),
         UINT64_C(0x04c0b0a400000000),
         UINT64_C(0x0000dc2b00000000),
         UINT64_C(0x2d89740200000000),
         UINT64_C(0xb674c48900000000),
         UINT64_C(0x9bfd6ca000000000),
         UINT64_C(0x9f3ddc0400000000),
         UINT64_C(0xb2b4742d00000000),
         UINT64_C(0x2949c4a600000000),
         UINT64_C(0x04c06c8f00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0191600000000000),
         UINT64_C(0xe330300000000000),
         UINT64_C(0xe2a1500000000000),
         UINT64_C(0x6500000000000000),
         UINT64_C(0x6491600000000000),
         UINT64_C(0x8630300000000000),
         UINT64_C(0x87a1500000000000),
         UINT64_C(0x109bf00000000000),
         UINT64_C(0x110a900000000000),
         UINT64_C(0xf3abc00000000000),
         UINT64_C(0xf23aa00000000000),
         UINT64_C(0x759bf00000000000),
         UINT64_C(0x740a900000000000),
         UINT64_C(0x96abc00000000000),
         UINT64_C(0x973aa00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0191600000000),
         UINT64_C(0x3ffe330300000000),
         UINT64_C(0x3ffe2a1500000000),
         UINT64_C(0x3ff6500000000000),
         UINT64_C(0x3ff6491600000000),
         UINT64_C(0x3ff8630300000000),
         UINT64_C(0x3ff87a1500000000),
         UINT64_C(0x3ff109bf00000000),
         UINT64_C(0x3ff110a900000000),
         UINT64_C(0x3fff3abc00000000),
         UINT64_C(0x3fff23aa00000000),
         UINT64_C(0x3ff759bf00000000),
         UINT64_C(0x3ff740a900000000),
         UINT64_C(0x3ff96abc00000000),
         UINT64_C(0x3ff973aa00000000)},
        UINT64_C(0xfff8000000000000),
        {0xef,0xa3,0x77,0x65,0x6d,0xd4,0x60,0x00,0x73,0x95,
         0xb3,0x63,0x53,0xac,0x5a,0xef,0x87,0x38,0x4f,0x3a,0x00}
    },
    {
        /* No.48 delta:3962 weight:3449 */
        11213,
        20,
        1,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x7932c1c500000000),
         UINT64_C(0x69c1f3ee00000000),
         UINT64_C(0x10f3322b00000000),
         UINT64_C(0xbf07003000000000),
         UINT64_C(0xc635c1f500000000),
         UINT64_C(0xd6c6f3de00000000),
         UINT64_C(0xaff4321b00000000),
         UINT64_C(0x0000f94f00000000),
         UINT64_C(0x7932388a00000000),
         UINT64_C(0x69c10aa100000000),
         UINT64_C(0x10f3cb6400000000),
         UINT64_C(0xbf07f97f00000000),
         UINT64_C(0xc63538ba00000000),
         UINT64_C(0xd6c60a9100000000),
         UINT64_C(0xaff4cb5400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x20efd00000000000),
         UINT64_C(0x007b400000000000),
         UINT64_C(0x2094900000000000),
         UINT64_C(0xb100900000000000),
         UINT64_C(0x91ef400000000000),
         UINT64_C(0xb17bd00000000000),
         UINT64_C(0x9194000000000000),
         UINT64_C(0x109bf00000000000),
         UINT64_C(0x3074200000000000),
         UINT64_C(0x10e0b00000000000),
         UINT64_C(0x300f600000000000),
         UINT64_C(0xa19b600000000000),
         UINT64_C(0x8174b00000000000),
         UINT64_C(0xa1e0200000000000),
         UINT64_C(0x810ff00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff20efd00000000),
         UINT64_C(0x3ff007b400000000),
         UINT64_C(0x3ff2094900000000),
         UINT64_C(0x3ffb100900000000),
         UINT64_C(0x3ff91ef400000000),
         UINT64_C(0x3ffb17bd00000000),
         UINT64_C(0x3ff9194000000000),
         UINT64_C(0x3ff109bf00000000),
         UINT64_C(0x3ff3074200000000),
         UINT64_C(0x3ff10e0b00000000),
         UINT64_C(0x3ff300f600000000),
         UINT64_C(0x3ffa19b600000000),
         UINT64_C(0x3ff8174b00000000),
         UINT64_C(0x3ffa1e0200000000),
         UINT64_C(0x3ff810ff00000000)},
        UINT64_C(0xfff8000000000000),
        {0x89,0xab,0x3e,0xa0,0x95,0x73,0x37,0x03,0xb9,0xeb,
         0xa8,0x4e,0x39,0x32,0x35,0x5a,0x1c,0x59,0x59,0xbb,0x00}
    },
    {
        /* No.49 delta:2488 weight:3765 */
        11213,
        37,
        6,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xf761c6b500000000),
         UINT64_C(0x7923a2b200000000),
         UINT64_C(0x8e42640700000000),
         UINT64_C(0xbc7c003100000000),
         UINT64_C(0x4b1dc68400000000),
         UINT64_C(0xc55fa28300000000),
         UINT64_C(0x323e643600000000),
         UINT64_C(0x0000954b00000000),
         UINT64_C(0xf76153fe00000000),
         UINT64_C(0x792337f900000000),
         UINT64_C(0x8e42f14c00000000),
         UINT64_C(0xbc7c957a00000000),
         UINT64_C(0x4b1d53cf00000000),
         UINT64_C(0xc55f37c800000000),
         UINT64_C(0x323ef17d00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x1000200000000000),
         UINT64_C(0x0000200000000000),
         UINT64_C(0x0000200000000000),
         UINT64_C(0x1000200000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0013f00000000000),
         UINT64_C(0x1013f00000000000),
         UINT64_C(0x1013d00000000000),
         UINT64_C(0x0013d00000000000),
         UINT64_C(0x0013d00000000000),
         UINT64_C(0x1013d00000000000),
         UINT64_C(0x1013f00000000000),
         UINT64_C(0x0013f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff1000200000000),
         UINT64_C(0x3ff0000200000000),
         UINT64_C(0x3ff0000200000000),
         UINT64_C(0x3ff1000200000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0013f00000000),
         UINT64_C(0x3ff1013f00000000),
         UINT64_C(0x3ff1013d00000000),
         UINT64_C(0x3ff0013d00000000),
         UINT64_C(0x3ff0013d00000000),
         UINT64_C(0x3ff1013d00000000),
         UINT64_C(0x3ff1013f00000000),
         UINT64_C(0x3ff0013f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x1e,0xc7,0x7b,0x62,0xd4,0x07,0xbc,0x92,0x36,0x83,
         0x91,0xe6,0x17,0xe7,0xd3,0x7d,0xc4,0x5c,0x6b,0xc9,0x00}
    },
    {
        /* No.50 delta:2548 weight:3733 */
        11213,
        28,
        7,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5c55eee100000000),
         UINT64_C(0xf3451bac00000000),
         UINT64_C(0xaf10f54d00000000),
         UINT64_C(0x8f6b003200000000),
         UINT64_C(0xd33eeed300000000),
         UINT64_C(0x7c2e1b9e00000000),
         UINT64_C(0x207bf57f00000000),
         UINT64_C(0x0000bbfe00000000),
         UINT64_C(0x5c55551f00000000),
         UINT64_C(0xf345a05200000000),
         UINT64_C(0xaf104eb300000000),
         UINT64_C(0x8f6bbbcc00000000),
         UINT64_C(0xd33e552d00000000),
         UINT64_C(0x7c2ea06000000000),
         UINT64_C(0x207b4e8100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0800000000000000),
         UINT64_C(0x4020000000000000),
         UINT64_C(0x4820000000000000),
         UINT64_C(0x0040200000000000),
         UINT64_C(0x0840200000000000),
         UINT64_C(0x4060200000000000),
         UINT64_C(0x4860200000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0803f00000000000),
         UINT64_C(0x4023f00000000000),
         UINT64_C(0x4823f00000000000),
         UINT64_C(0x0043d00000000000),
         UINT64_C(0x0843d00000000000),
         UINT64_C(0x4063d00000000000),
         UINT64_C(0x4863d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0800000000000),
         UINT64_C(0x3ff4020000000000),
         UINT64_C(0x3ff4820000000000),
         UINT64_C(0x3ff0040200000000),
         UINT64_C(0x3ff0840200000000),
         UINT64_C(0x3ff4060200000000),
         UINT64_C(0x3ff4860200000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0803f00000000),
         UINT64_C(0x3ff4023f00000000),
         UINT64_C(0x3ff4823f00000000),
         UINT64_C(0x3ff0043d00000000),
         UINT64_C(0x3ff0843d00000000),
         UINT64_C(0x3ff4063d00000000),
         UINT64_C(0x3ff4863d00000000)},
        UINT64_C(0xfff8000000000000),
        {0xa2,0xeb,0x18,0xf3,0xec,0x6b,0xa0,0x1e,0x48,0x0f,
         0x74,0x94,0x7b,0x02,0xce,0xde,0xa4,0x44,0xf9,0x75,0x00}
    },
    {
        /* No.51 delta:6876 weight:3149 */
        11213,
        43,
        16,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x9b27b8a900000000),
         UINT64_C(0xa1a631b300000000),
         UINT64_C(0x3a81891a00000000),
         UINT64_C(0x37f0003300000000),
         UINT64_C(0xacd7b89a00000000),
         UINT64_C(0x9656318000000000),
         UINT64_C(0x0d71892900000000),
         UINT64_C(0x0000d7b200000000),
         UINT64_C(0x9b276f1b00000000),
         UINT64_C(0xa1a6e60100000000),
         UINT64_C(0x3a815ea800000000),
         UINT64_C(0x37f0d78100000000),
         UINT64_C(0xacd76f2800000000),
         UINT64_C(0x9656e63200000000),
         UINT64_C(0x0d715e9b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x147f000000000000),
         UINT64_C(0x0bc0000000000000),
         UINT64_C(0x1fbf000000000000),
         UINT64_C(0x0f20100000000000),
         UINT64_C(0x1b5f100000000000),
         UINT64_C(0x04e0100000000000),
         UINT64_C(0x109f100000000000),
         UINT64_C(0x08cff00000000000),
         UINT64_C(0x1cb0f00000000000),
         UINT64_C(0x030ff00000000000),
         UINT64_C(0x1770f00000000000),
         UINT64_C(0x07efe00000000000),
         UINT64_C(0x1390e00000000000),
         UINT64_C(0x0c2fe00000000000),
         UINT64_C(0x1850e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff147f000000000),
         UINT64_C(0x3ff0bc0000000000),
         UINT64_C(0x3ff1fbf000000000),
         UINT64_C(0x3ff0f20100000000),
         UINT64_C(0x3ff1b5f100000000),
         UINT64_C(0x3ff04e0100000000),
         UINT64_C(0x3ff109f100000000),
         UINT64_C(0x3ff08cff00000000),
         UINT64_C(0x3ff1cb0f00000000),
         UINT64_C(0x3ff030ff00000000),
         UINT64_C(0x3ff1770f00000000),
         UINT64_C(0x3ff07efe00000000),
         UINT64_C(0x3ff1390e00000000),
         UINT64_C(0x3ff0c2fe00000000),
         UINT64_C(0x3ff1850e00000000)},
        UINT64_C(0xfff8000000000000),
        {0x51,0x4d,0x32,0x93,0x08,0x99,0xa3,0x75,0xbd,0xad,
         0xdb,0xd5,0xad,0x1d,0x89,0x2d,0xfd,0x84,0xc1,0xe2,0x00}
    },
    {
        /* No.52 delta:2379 weight:2079 */
        11213,
        26,
        13,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa424c89700000000),
         UINT64_C(0x370f5dfb00000000),
         UINT64_C(0x932b956c00000000),
         UINT64_C(0x859e003400000000),
         UINT64_C(0x21bac8a300000000),
         UINT64_C(0xb2915dcf00000000),
         UINT64_C(0x16b5955800000000),
         UINT64_C(0x000048fd00000000),
         UINT64_C(0xa424806a00000000),
         UINT64_C(0x370f150600000000),
         UINT64_C(0x932bdd9100000000),
         UINT64_C(0x859e48c900000000),
         UINT64_C(0x21ba805e00000000),
         UINT64_C(0xb291153200000000),
         UINT64_C(0x16b5dda500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1029200000000000),
         UINT64_C(0x4164000000000000),
         UINT64_C(0x514d200000000000),
         UINT64_C(0x0133000000000000),
         UINT64_C(0x111a200000000000),
         UINT64_C(0x4057000000000000),
         UINT64_C(0x507e200000000000),
         UINT64_C(0x1043f00000000000),
         UINT64_C(0x006ad00000000000),
         UINT64_C(0x5127f00000000000),
         UINT64_C(0x410ed00000000000),
         UINT64_C(0x1170f00000000000),
         UINT64_C(0x0159d00000000000),
         UINT64_C(0x5014f00000000000),
         UINT64_C(0x403dd00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1029200000000),
         UINT64_C(0x3ff4164000000000),
         UINT64_C(0x3ff514d200000000),
         UINT64_C(0x3ff0133000000000),
         UINT64_C(0x3ff111a200000000),
         UINT64_C(0x3ff4057000000000),
         UINT64_C(0x3ff507e200000000),
         UINT64_C(0x3ff1043f00000000),
         UINT64_C(0x3ff006ad00000000),
         UINT64_C(0x3ff5127f00000000),
         UINT64_C(0x3ff410ed00000000),
         UINT64_C(0x3ff1170f00000000),
         UINT64_C(0x3ff0159d00000000),
         UINT64_C(0x3ff5014f00000000),
         UINT64_C(0x3ff403dd00000000)},
        UINT64_C(0xfff8000000000000),
        {0x15,0x1f,0x67,0x4a,0x1d,0xd0,0xb2,0x1c,0xb7,0xab,
         0x3d,0x75,0xfa,0xdf,0x3c,0x52,0x0a,0x95,0x9e,0x15,0x00}
    },
    {
        /* No.53 delta:3063 weight:3727 */
        11213,
        28,
        4,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xb678cf8b00000000),
         UINT64_C(0xd307737a00000000),
         UINT64_C(0x657fbcf100000000),
         UINT64_C(0x5214003500000000),
         UINT64_C(0xe46ccfbe00000000),
         UINT64_C(0x8113734f00000000),
         UINT64_C(0x376bbcc400000000),
         UINT64_C(0x0000ac8300000000),
         UINT64_C(0xb678630800000000),
         UINT64_C(0xd307dff900000000),
         UINT64_C(0x657f107200000000),
         UINT64_C(0x5214acb600000000),
         UINT64_C(0xe46c633d00000000),
         UINT64_C(0x8113dfcc00000000),
         UINT64_C(0x376b104700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4002c00000000000),
         UINT64_C(0x0002a00000000000),
         UINT64_C(0x4000600000000000),
         UINT64_C(0x4000a00000000000),
         UINT64_C(0x0002600000000000),
         UINT64_C(0x4002000000000000),
         UINT64_C(0x0000c00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x0001300000000000),
         UINT64_C(0x4001500000000000),
         UINT64_C(0x0003900000000000),
         UINT64_C(0x0003500000000000),
         UINT64_C(0x4001900000000000),
         UINT64_C(0x0001f00000000000),
         UINT64_C(0x4003300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4002c00000000),
         UINT64_C(0x3ff0002a00000000),
         UINT64_C(0x3ff4000600000000),
         UINT64_C(0x3ff4000a00000000),
         UINT64_C(0x3ff0002600000000),
         UINT64_C(0x3ff4002000000000),
         UINT64_C(0x3ff0000c00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff0001300000000),
         UINT64_C(0x3ff4001500000000),
         UINT64_C(0x3ff0003900000000),
         UINT64_C(0x3ff0003500000000),
         UINT64_C(0x3ff4001900000000),
         UINT64_C(0x3ff0001f00000000),
         UINT64_C(0x3ff4003300000000)},
        UINT64_C(0xfff8000000000000),
        {0xa2,0x2f,0x78,0x0d,0x6c,0xcd,0xb6,0xde,0xd4,0x00,
         0x55,0x5f,0xa3,0x51,0xc4,0x8b,0x0f,0x15,0xf9,0x2b,0x00}
    },
    {
        /* No.54 delta:2760 weight:3751 */
        11213,
        10,
        8,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x010348b900000000),
         UINT64_C(0x76ddb3b900000000),
         UINT64_C(0x77defb0000000000),
         UINT64_C(0x244b003600000000),
         UINT64_C(0x2548488f00000000),
         UINT64_C(0x5296b38f00000000),
         UINT64_C(0x5395fb3600000000),
         UINT64_C(0x00009eec00000000),
         UINT64_C(0x0103d65500000000),
         UINT64_C(0x76dd2d5500000000),
         UINT64_C(0x77de65ec00000000),
         UINT64_C(0x244b9eda00000000),
         UINT64_C(0x2548d66300000000),
         UINT64_C(0x52962d6300000000),
         UINT64_C(0x539565da00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0010200000000000),
         UINT64_C(0x0048000000000000),
         UINT64_C(0x0058200000000000),
         UINT64_C(0x0000200000000000),
         UINT64_C(0x0010000000000000),
         UINT64_C(0x0048200000000000),
         UINT64_C(0x0058000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0013d00000000000),
         UINT64_C(0x004bf00000000000),
         UINT64_C(0x005bd00000000000),
         UINT64_C(0x0003d00000000000),
         UINT64_C(0x0013f00000000000),
         UINT64_C(0x004bd00000000000),
         UINT64_C(0x005bf00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0010200000000),
         UINT64_C(0x3ff0048000000000),
         UINT64_C(0x3ff0058200000000),
         UINT64_C(0x3ff0000200000000),
         UINT64_C(0x3ff0010000000000),
         UINT64_C(0x3ff0048200000000),
         UINT64_C(0x3ff0058000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0013d00000000),
         UINT64_C(0x3ff004bf00000000),
         UINT64_C(0x3ff005bd00000000),
         UINT64_C(0x3ff0003d00000000),
         UINT64_C(0x3ff0013f00000000),
         UINT64_C(0x3ff004bd00000000),
         UINT64_C(0x3ff005bf00000000)},
        UINT64_C(0xfff8000000000000),
        {0xeb,0x74,0xfe,0xe7,0xc7,0xbe,0x51,0x93,0x09,0x3e,
         0x1a,0xaf,0x45,0x55,0x80,0x9d,0x21,0x3b,0x44,0xe8,0x00}
    },
    {
        /* No.55 delta:3081 weight:2289 */
        11213,
        37,
        9,
        19,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x870dc84000000000),
         UINT64_C(0x1f37af8100000000),
         UINT64_C(0x983a67c100000000),
         UINT64_C(0x4b71003700000000),
         UINT64_C(0xcc7cc87700000000),
         UINT64_C(0x5446afb600000000),
         UINT64_C(0xd34b67f600000000),
         UINT64_C(0x0000362100000000),
         UINT64_C(0x870dfe6100000000),
         UINT64_C(0x1f3799a000000000),
         UINT64_C(0x983a51e000000000),
         UINT64_C(0x4b71361600000000),
         UINT64_C(0xcc7cfe5600000000),
         UINT64_C(0x5446999700000000),
         UINT64_C(0xd34b51d700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8286000000000000),
         UINT64_C(0x1003900000000000),
         UINT64_C(0x9285900000000000),
         UINT64_C(0x0002600000000000),
         UINT64_C(0x8284600000000000),
         UINT64_C(0x1001f00000000000),
         UINT64_C(0x9287f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x8285f00000000000),
         UINT64_C(0x1000600000000000),
         UINT64_C(0x9286600000000000),
         UINT64_C(0x0001900000000000),
         UINT64_C(0x8287900000000000),
         UINT64_C(0x1002000000000000),
         UINT64_C(0x9284000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff8286000000000),
         UINT64_C(0x3ff1003900000000),
         UINT64_C(0x3ff9285900000000),
         UINT64_C(0x3ff0002600000000),
         UINT64_C(0x3ff8284600000000),
         UINT64_C(0x3ff1001f00000000),
         UINT64_C(0x3ff9287f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff8285f00000000),
         UINT64_C(0x3ff1000600000000),
         UINT64_C(0x3ff9286600000000),
         UINT64_C(0x3ff0001900000000),
         UINT64_C(0x3ff8287900000000),
         UINT64_C(0x3ff1002000000000),
         UINT64_C(0x3ff9284000000000)},
        UINT64_C(0xfff8000000000000),
        {0x75,0x07,0x31,0xb6,0x35,0xcc,0x73,0x24,0xf9,0xf9,
         0x46,0xe9,0x85,0xe7,0xd0,0x0f,0xe1,0x4a,0x43,0xe2,0x00}
    },
    {
        /* No.56 delta:4531 weight:2155 */
        11213,
        4,
        1,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x63fc03c500000000),
         UINT64_C(0x833ebdea00000000),
         UINT64_C(0xe0c2be2f00000000),
         UINT64_C(0xa3f3003800000000),
         UINT64_C(0xc00f03fd00000000),
         UINT64_C(0x20cdbdd200000000),
         UINT64_C(0x4331be1700000000),
         UINT64_C(0x000076fd00000000),
         UINT64_C(0x63fc753800000000),
         UINT64_C(0x833ecb1700000000),
         UINT64_C(0xe0c2c8d200000000),
         UINT64_C(0xa3f376c500000000),
         UINT64_C(0xc00f750000000000),
         UINT64_C(0x20cdcb2f00000000),
         UINT64_C(0x4331c8ea00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x204e200000000000),
         UINT64_C(0x5a69a00000000000),
         UINT64_C(0x7a27800000000000),
         UINT64_C(0x94c2000000000000),
         UINT64_C(0xb48c200000000000),
         UINT64_C(0xceaba00000000000),
         UINT64_C(0xeee5800000000000),
         UINT64_C(0x0143f00000000000),
         UINT64_C(0x210dd00000000000),
         UINT64_C(0x5b2a500000000000),
         UINT64_C(0x7b64700000000000),
         UINT64_C(0x9581f00000000000),
         UINT64_C(0xb5cfd00000000000),
         UINT64_C(0xcfe8500000000000),
         UINT64_C(0xefa6700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff204e200000000),
         UINT64_C(0x3ff5a69a00000000),
         UINT64_C(0x3ff7a27800000000),
         UINT64_C(0x3ff94c2000000000),
         UINT64_C(0x3ffb48c200000000),
         UINT64_C(0x3ffceaba00000000),
         UINT64_C(0x3ffeee5800000000),
         UINT64_C(0x3ff0143f00000000),
         UINT64_C(0x3ff210dd00000000),
         UINT64_C(0x3ff5b2a500000000),
         UINT64_C(0x3ff7b64700000000),
         UINT64_C(0x3ff9581f00000000),
         UINT64_C(0x3ffb5cfd00000000),
         UINT64_C(0x3ffcfe8500000000),
         UINT64_C(0x3ffefa6700000000)},
        UINT64_C(0xfff8000000000000),
        {0xc3,0x5f,0x5f,0x74,0xa8,0x8f,0x1d,0xa1,0x8a,0xe9,
         0x30,0x60,0xb4,0xab,0x16,0x8b,0x3f,0xa7,0x8d,0x56,0x00}
    },
    {
        /* No.57 delta:2271 weight:3657 */
        11213,
        32,
        5,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x60d3a51d00000000),
         UINT64_C(0xacd695b200000000),
         UINT64_C(0xcc0530af00000000),
         UINT64_C(0xea33003900000000),
         UINT64_C(0x8ae0a52400000000),
         UINT64_C(0x46e5958b00000000),
         UINT64_C(0x2636309600000000),
         UINT64_C(0x00008d0000000000),
         UINT64_C(0x60d3281d00000000),
         UINT64_C(0xacd618b200000000),
         UINT64_C(0xcc05bdaf00000000),
         UINT64_C(0xea338d3900000000),
         UINT64_C(0x8ae0282400000000),
         UINT64_C(0x46e5188b00000000),
         UINT64_C(0x2636bd9600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc000400000000000),
         UINT64_C(0x0800600000000000),
         UINT64_C(0xc800200000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0xc000400000000000),
         UINT64_C(0x0800600000000000),
         UINT64_C(0xc800200000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0xc003b00000000000),
         UINT64_C(0x0803900000000000),
         UINT64_C(0xc803d00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0xc003b00000000000),
         UINT64_C(0x0803900000000000),
         UINT64_C(0xc803d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffc000400000000),
         UINT64_C(0x3ff0800600000000),
         UINT64_C(0x3ffc800200000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffc000400000000),
         UINT64_C(0x3ff0800600000000),
         UINT64_C(0x3ffc800200000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ffc003b00000000),
         UINT64_C(0x3ff0803900000000),
         UINT64_C(0x3ffc803d00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ffc003b00000000),
         UINT64_C(0x3ff0803900000000),
         UINT64_C(0x3ffc803d00000000)},
        UINT64_C(0xfff8000000000000),
        {0xd8,0x4f,0x24,0xb3,0xf5,0xbe,0x30,0xe9,0x39,0xb6,
         0xe4,0x6b,0xb7,0x78,0xd2,0xb8,0xe1,0xe6,0xf1,0x58,0x00}
    },
    {
        /* No.58 delta:2702 weight:3153 */
        11213,
        40,
        8,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1c4f15b900000000),
         UINT64_C(0xe763696d00000000),
         UINT64_C(0xfb2c7cd400000000),
         UINT64_C(0x3254003a00000000),
         UINT64_C(0x2e1b158300000000),
         UINT64_C(0xd537695700000000),
         UINT64_C(0xc9787cee00000000),
         UINT64_C(0x0000867a00000000),
         UINT64_C(0x1c4f93c300000000),
         UINT64_C(0xe763ef1700000000),
         UINT64_C(0xfb2cfaae00000000),
         UINT64_C(0x3254864000000000),
         UINT64_C(0x2e1b93f900000000),
         UINT64_C(0xd537ef2d00000000),
         UINT64_C(0xc978fa9400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0080200000000000),
         UINT64_C(0x1004000000000000),
         UINT64_C(0x1084200000000000),
         UINT64_C(0x8000200000000000),
         UINT64_C(0x8080000000000000),
         UINT64_C(0x9004200000000000),
         UINT64_C(0x9084000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0083d00000000000),
         UINT64_C(0x1007f00000000000),
         UINT64_C(0x1087d00000000000),
         UINT64_C(0x8003d00000000000),
         UINT64_C(0x8083f00000000000),
         UINT64_C(0x9007d00000000000),
         UINT64_C(0x9087f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0080200000000),
         UINT64_C(0x3ff1004000000000),
         UINT64_C(0x3ff1084200000000),
         UINT64_C(0x3ff8000200000000),
         UINT64_C(0x3ff8080000000000),
         UINT64_C(0x3ff9004200000000),
         UINT64_C(0x3ff9084000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0083d00000000),
         UINT64_C(0x3ff1007f00000000),
         UINT64_C(0x3ff1087d00000000),
         UINT64_C(0x3ff8003d00000000),
         UINT64_C(0x3ff8083f00000000),
         UINT64_C(0x3ff9007d00000000),
         UINT64_C(0x3ff9087f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x53,0x66,0xe1,0x5c,0x33,0x8d,0x63,0xc9,0x45,0x68,
         0x7c,0x7d,0x50,0x3f,0x54,0x1e,0x1c,0x19,0x66,0x51,0x00}
    },
    {
        /* No.59 delta:2232 weight:3063 */
        11213,
        12,
        14,
        18,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x41928f8800000000),
         UINT64_C(0x973767dd00000000),
         UINT64_C(0xd6a5e85500000000),
         UINT64_C(0xc195003b00000000),
         UINT64_C(0x80078fb300000000),
         UINT64_C(0x56a267e600000000),
         UINT64_C(0x1730e86e00000000),
         UINT64_C(0x0000857500000000),
         UINT64_C(0x41920afd00000000),
         UINT64_C(0x9737e2a800000000),
         UINT64_C(0xd6a56d2000000000),
         UINT64_C(0xc195854e00000000),
         UINT64_C(0x80070ac600000000),
         UINT64_C(0x56a2e29300000000),
         UINT64_C(0x17306d1b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0043200000000000),
         UINT64_C(0x403c000000000000),
         UINT64_C(0x407f200000000000),
         UINT64_C(0x5012000000000000),
         UINT64_C(0x5051200000000000),
         UINT64_C(0x102e000000000000),
         UINT64_C(0x106d200000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0040d00000000000),
         UINT64_C(0x403ff00000000000),
         UINT64_C(0x407cd00000000000),
         UINT64_C(0x5011f00000000000),
         UINT64_C(0x5052d00000000000),
         UINT64_C(0x102df00000000000),
         UINT64_C(0x106ed00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0043200000000),
         UINT64_C(0x3ff403c000000000),
         UINT64_C(0x3ff407f200000000),
         UINT64_C(0x3ff5012000000000),
         UINT64_C(0x3ff5051200000000),
         UINT64_C(0x3ff102e000000000),
         UINT64_C(0x3ff106d200000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0040d00000000),
         UINT64_C(0x3ff403ff00000000),
         UINT64_C(0x3ff407cd00000000),
         UINT64_C(0x3ff5011f00000000),
         UINT64_C(0x3ff5052d00000000),
         UINT64_C(0x3ff102df00000000),
         UINT64_C(0x3ff106ed00000000)},
        UINT64_C(0xfff8000000000000),
        {0xce,0x60,0x6d,0x39,0x36,0x95,0x9d,0xe1,0x41,0x13,
         0x12,0xb3,0x54,0x9b,0x29,0x1a,0x99,0x38,0x20,0x3f,0x00}
    },
    {
        /* No.60 delta:6101 weight:2329 */
        11213,
        6,
        26,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x77be3d9c00000000),
         UINT64_C(0x0550441d00000000),
         UINT64_C(0x72ee798100000000),
         UINT64_C(0x1280003c00000000),
         UINT64_C(0x653e3da000000000),
         UINT64_C(0x17d0442100000000),
         UINT64_C(0x606e79bd00000000),
         UINT64_C(0x000044e900000000),
         UINT64_C(0x77be797500000000),
         UINT64_C(0x055000f400000000),
         UINT64_C(0x72ee3d6800000000),
         UINT64_C(0x128044d500000000),
         UINT64_C(0x653e794900000000),
         UINT64_C(0x17d000c800000000),
         UINT64_C(0x606e3d5400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8c2d800000000000),
         UINT64_C(0xc9b1800000000000),
         UINT64_C(0x459c000000000000),
         UINT64_C(0x2b02000000000000),
         UINT64_C(0xa72f800000000000),
         UINT64_C(0xe2b3800000000000),
         UINT64_C(0x6e9e000000000000),
         UINT64_C(0x240bf00000000000),
         UINT64_C(0xa826700000000000),
         UINT64_C(0xedba700000000000),
         UINT64_C(0x6197f00000000000),
         UINT64_C(0x0f09f00000000000),
         UINT64_C(0x8324700000000000),
         UINT64_C(0xc6b8700000000000),
         UINT64_C(0x4a95f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff8c2d800000000),
         UINT64_C(0x3ffc9b1800000000),
         UINT64_C(0x3ff459c000000000),
         UINT64_C(0x3ff2b02000000000),
         UINT64_C(0x3ffa72f800000000),
         UINT64_C(0x3ffe2b3800000000),
         UINT64_C(0x3ff6e9e000000000),
         UINT64_C(0x3ff240bf00000000),
         UINT64_C(0x3ffa826700000000),
         UINT64_C(0x3ffedba700000000),
         UINT64_C(0x3ff6197f00000000),
         UINT64_C(0x3ff0f09f00000000),
         UINT64_C(0x3ff8324700000000),
         UINT64_C(0x3ffc6b8700000000),
         UINT64_C(0x3ff4a95f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x96,0x64,0x4d,0xcd,0x44,0x17,0x59,0xf6,0x6d,0xca,
         0x35,0x9c,0x4c,0x44,0x87,0x7d,0x74,0x22,0x3f,0xfe,0x00}
    },
    {
        /* No.61 delta:3872 weight:3087 */
        11213,
        6,
        24,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x75f460d500000000),
         UINT64_C(0xe5bd19d200000000),
         UINT64_C(0x9049790700000000),
         UINT64_C(0xc15c003d00000000),
         UINT64_C(0xb4a860e800000000),
         UINT64_C(0x24e119ef00000000),
         UINT64_C(0x5115793a00000000),
         UINT64_C(0x00004b3300000000),
         UINT64_C(0x75f42be600000000),
         UINT64_C(0xe5bd52e100000000),
         UINT64_C(0x9049323400000000),
         UINT64_C(0xc15c4b0e00000000),
         UINT64_C(0xb4a82bdb00000000),
         UINT64_C(0x24e152dc00000000),
         UINT64_C(0x5115320900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0203800000000000),
         UINT64_C(0x0873700000000000),
         UINT64_C(0x0a70f00000000000),
         UINT64_C(0x4074d00000000000),
         UINT64_C(0x4277500000000000),
         UINT64_C(0x4807a00000000000),
         UINT64_C(0x4a04200000000000),
         UINT64_C(0x1017f00000000000),
         UINT64_C(0x1214700000000000),
         UINT64_C(0x1864800000000000),
         UINT64_C(0x1a67000000000000),
         UINT64_C(0x5063200000000000),
         UINT64_C(0x5260a00000000000),
         UINT64_C(0x5810500000000000),
         UINT64_C(0x5a13d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0203800000000),
         UINT64_C(0x3ff0873700000000),
         UINT64_C(0x3ff0a70f00000000),
         UINT64_C(0x3ff4074d00000000),
         UINT64_C(0x3ff4277500000000),
         UINT64_C(0x3ff4807a00000000),
         UINT64_C(0x3ff4a04200000000),
         UINT64_C(0x3ff1017f00000000),
         UINT64_C(0x3ff1214700000000),
         UINT64_C(0x3ff1864800000000),
         UINT64_C(0x3ff1a67000000000),
         UINT64_C(0x3ff5063200000000),
         UINT64_C(0x3ff5260a00000000),
         UINT64_C(0x3ff5810500000000),
         UINT64_C(0x3ff5a13d00000000)},
        UINT64_C(0xfff8000000000000),
        {0xdb,0x66,0xda,0xd5,0xd9,0x6a,0xe8,0xc1,0xd0,0xe7,
         0xea,0x28,0xf5,0x6d,0x9d,0xf2,0xd2,0xae,0xa2,0x72,0x00}
    },
    {
        /* No.62 delta:3315 weight:3625 */
        11213,
        17,
        4,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xfeb8f4dc00000000),
         UINT64_C(0x3abcc48e00000000),
         UINT64_C(0xc404305200000000),
         UINT64_C(0x06ba003e00000000),
         UINT64_C(0xf802f4e200000000),
         UINT64_C(0x3c06c4b000000000),
         UINT64_C(0xc2be306c00000000),
         UINT64_C(0x0000be7900000000),
         UINT64_C(0xfeb84aa500000000),
         UINT64_C(0x3abc7af700000000),
         UINT64_C(0xc4048e2b00000000),
         UINT64_C(0x06babe4700000000),
         UINT64_C(0xf8024a9b00000000),
         UINT64_C(0x3c067ac900000000),
         UINT64_C(0xc2be8e1500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1040000000000000),
         UINT64_C(0xc018000000000000),
         UINT64_C(0xd058000000000000),
         UINT64_C(0x3202400000000000),
         UINT64_C(0x2242400000000000),
         UINT64_C(0xf21a400000000000),
         UINT64_C(0xe25a400000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x1043f00000000000),
         UINT64_C(0xc01bf00000000000),
         UINT64_C(0xd05bf00000000000),
         UINT64_C(0x3201b00000000000),
         UINT64_C(0x2241b00000000000),
         UINT64_C(0xf219b00000000000),
         UINT64_C(0xe259b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1040000000000),
         UINT64_C(0x3ffc018000000000),
         UINT64_C(0x3ffd058000000000),
         UINT64_C(0x3ff3202400000000),
         UINT64_C(0x3ff2242400000000),
         UINT64_C(0x3fff21a400000000),
         UINT64_C(0x3ffe25a400000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff1043f00000000),
         UINT64_C(0x3ffc01bf00000000),
         UINT64_C(0x3ffd05bf00000000),
         UINT64_C(0x3ff3201b00000000),
         UINT64_C(0x3ff2241b00000000),
         UINT64_C(0x3fff219b00000000),
         UINT64_C(0x3ffe259b00000000)},
        UINT64_C(0xfff8000000000000),
        {0x2a,0x96,0x8f,0x73,0x0b,0x5b,0xa8,0x40,0xe4,0x96,
         0x7b,0xc8,0xbb,0xb4,0x33,0x54,0x6f,0x26,0x23,0x87,0x00}
    },
    {
        /* No.63 delta:2482 weight:3467 */
        11213,
        28,
        9,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x92e4213900000000),
         UINT64_C(0xaed2690a00000000),
         UINT64_C(0x3c36483300000000),
         UINT64_C(0x1082003f00000000),
         UINT64_C(0x8266210600000000),
         UINT64_C(0xbe50693500000000),
         UINT64_C(0x2cb4480c00000000),
         UINT64_C(0x00002b7700000000),
         UINT64_C(0x92e40a4e00000000),
         UINT64_C(0xaed2427d00000000),
         UINT64_C(0x3c36634400000000),
         UINT64_C(0x10822b4800000000),
         UINT64_C(0x82660a7100000000),
         UINT64_C(0xbe50424200000000),
         UINT64_C(0x2cb4637b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0048800000000000),
         UINT64_C(0x1008000000000000),
         UINT64_C(0x1040800000000000),
         UINT64_C(0x0050200000000000),
         UINT64_C(0x0018a00000000000),
         UINT64_C(0x1058200000000000),
         UINT64_C(0x1010a00000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x006b700000000000),
         UINT64_C(0x102bf00000000000),
         UINT64_C(0x1063700000000000),
         UINT64_C(0x0073d00000000000),
         UINT64_C(0x003b500000000000),
         UINT64_C(0x107bd00000000000),
         UINT64_C(0x1033500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0048800000000),
         UINT64_C(0x3ff1008000000000),
         UINT64_C(0x3ff1040800000000),
         UINT64_C(0x3ff0050200000000),
         UINT64_C(0x3ff0018a00000000),
         UINT64_C(0x3ff1058200000000),
         UINT64_C(0x3ff1010a00000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff006b700000000),
         UINT64_C(0x3ff102bf00000000),
         UINT64_C(0x3ff1063700000000),
         UINT64_C(0x3ff0073d00000000),
         UINT64_C(0x3ff003b500000000),
         UINT64_C(0x3ff107bd00000000),
         UINT64_C(0x3ff1033500000000)},
        UINT64_C(0xfff8000000000000),
        {0x12,0x4e,0x8a,0xa3,0xff,0xee,0x4f,0xf5,0x97,0xb4,
         0x04,0x1d,0x98,0xf2,0x4b,0x10,0x1f,0xff,0xd5,0x3d,0x00}
    },
    {
        /* No.64 delta:2064 weight:2571 */
        11213,
        32,
        9,
        19,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xae24d2ac00000000),
         UINT64_C(0xdf66a22300000000),
         UINT64_C(0x7142708f00000000),
         UINT64_C(0xd562004000000000),
         UINT64_C(0x7b46d2ec00000000),
         UINT64_C(0x0a04a26300000000),
         UINT64_C(0xa42070cf00000000),
         UINT64_C(0x0000a9cd00000000),
         UINT64_C(0xae247b6100000000),
         UINT64_C(0xdf660bee00000000),
         UINT64_C(0x7142d94200000000),
         UINT64_C(0xd562a98d00000000),
         UINT64_C(0x7b467b2100000000),
         UINT64_C(0x0a040bae00000000),
         UINT64_C(0xa420d90200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x7c02000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x5c02000000000000),
         UINT64_C(0xc211000000000000),
         UINT64_C(0xbe13000000000000),
         UINT64_C(0xe211000000000000),
         UINT64_C(0x9e13000000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x3c01f00000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x1c01f00000000000),
         UINT64_C(0x8212f00000000000),
         UINT64_C(0xfe10f00000000000),
         UINT64_C(0xa212f00000000000),
         UINT64_C(0xde10f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff7c02000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff5c02000000000),
         UINT64_C(0x3ffc211000000000),
         UINT64_C(0x3ffbe13000000000),
         UINT64_C(0x3ffe211000000000),
         UINT64_C(0x3ff9e13000000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff3c01f00000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff1c01f00000000),
         UINT64_C(0x3ff8212f00000000),
         UINT64_C(0x3fffe10f00000000),
         UINT64_C(0x3ffa212f00000000),
         UINT64_C(0x3ffde10f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x34,0xe4,0xaa,0xb2,0xcc,0xa9,0x2f,0xe0,0x90,0xae,
         0x0f,0xee,0x36,0xa8,0x1c,0xfe,0xf9,0x63,0x05,0x32,0x00}
    },
    {
        /* No.65 delta:3226 weight:2839 */
        11213,
        35,
        5,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x23616a6000000000),
         UINT64_C(0x1a6e288c00000000),
         UINT64_C(0x390f42ec00000000),
         UINT64_C(0x4cde004100000000),
         UINT64_C(0x6fbf6a2100000000),
         UINT64_C(0x56b028cd00000000),
         UINT64_C(0x75d142ad00000000),
         UINT64_C(0x0000754d00000000),
         UINT64_C(0x23611f2d00000000),
         UINT64_C(0x1a6e5dc100000000),
         UINT64_C(0x390f37a100000000),
         UINT64_C(0x4cde750c00000000),
         UINT64_C(0x6fbf1f6c00000000),
         UINT64_C(0x56b05d8000000000),
         UINT64_C(0x75d137e000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0022000000000000),
         UINT64_C(0x0003000000000000),
         UINT64_C(0x0021000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x2022000000000000),
         UINT64_C(0x2003000000000000),
         UINT64_C(0x2021000000000000),
         UINT64_C(0x0083f00000000000),
         UINT64_C(0x00a1f00000000000),
         UINT64_C(0x0080f00000000000),
         UINT64_C(0x00a2f00000000000),
         UINT64_C(0x2083f00000000000),
         UINT64_C(0x20a1f00000000000),
         UINT64_C(0x2080f00000000000),
         UINT64_C(0x20a2f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0022000000000),
         UINT64_C(0x3ff0003000000000),
         UINT64_C(0x3ff0021000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff2022000000000),
         UINT64_C(0x3ff2003000000000),
         UINT64_C(0x3ff2021000000000),
         UINT64_C(0x3ff0083f00000000),
         UINT64_C(0x3ff00a1f00000000),
         UINT64_C(0x3ff0080f00000000),
         UINT64_C(0x3ff00a2f00000000),
         UINT64_C(0x3ff2083f00000000),
         UINT64_C(0x3ff20a1f00000000),
         UINT64_C(0x3ff2080f00000000),
         UINT64_C(0x3ff20a2f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x8f,0x60,0xd7,0x5c,0xcf,0x83,0x52,0xe3,0x96,0x87,
         0x30,0xff,0xc8,0xef,0x70,0x39,0xdb,0x62,0xbd,0xa4,0x00}
    },
    {
        /* No.66 delta:2243 weight:3181 */
        11213,
        9,
        6,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3d22cded00000000),
         UINT64_C(0x40bbd4df00000000),
         UINT64_C(0x7d99193200000000),
         UINT64_C(0x6ad4004200000000),
         UINT64_C(0x57f6cdaf00000000),
         UINT64_C(0x2a6fd49d00000000),
         UINT64_C(0x174d197000000000),
         UINT64_C(0x0000122400000000),
         UINT64_C(0x3d22dfc900000000),
         UINT64_C(0x40bbc6fb00000000),
         UINT64_C(0x7d990b1600000000),
         UINT64_C(0x6ad4126600000000),
         UINT64_C(0x57f6df8b00000000),
         UINT64_C(0x2a6fc6b900000000),
         UINT64_C(0x174d0b5400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2202800000000000),
         UINT64_C(0x0803000000000000),
         UINT64_C(0x2a01800000000000),
         UINT64_C(0x2100900000000000),
         UINT64_C(0x0302100000000000),
         UINT64_C(0x2903900000000000),
         UINT64_C(0x0b01100000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x2201700000000000),
         UINT64_C(0x0800f00000000000),
         UINT64_C(0x2a02700000000000),
         UINT64_C(0x2103600000000000),
         UINT64_C(0x0301e00000000000),
         UINT64_C(0x2900600000000000),
         UINT64_C(0x0b02e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2202800000000),
         UINT64_C(0x3ff0803000000000),
         UINT64_C(0x3ff2a01800000000),
         UINT64_C(0x3ff2100900000000),
         UINT64_C(0x3ff0302100000000),
         UINT64_C(0x3ff2903900000000),
         UINT64_C(0x3ff0b01100000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff2201700000000),
         UINT64_C(0x3ff0800f00000000),
         UINT64_C(0x3ff2a02700000000),
         UINT64_C(0x3ff2103600000000),
         UINT64_C(0x3ff0301e00000000),
         UINT64_C(0x3ff2900600000000),
         UINT64_C(0x3ff0b02e00000000)},
        UINT64_C(0xfff8000000000000),
        {0x46,0x4a,0x79,0xb2,0xf3,0xbd,0xf7,0xc6,0x9a,0x30,
         0xcf,0x94,0x12,0x5d,0x68,0x5a,0xfb,0x18,0x5e,0x38,0x00}
    },
    {
        /* No.67 delta:3931 weight:2873 */
        11213,
        13,
        22,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4be36c9100000000),
         UINT64_C(0x98c3552e00000000),
         UINT64_C(0xd32039bf00000000),
         UINT64_C(0xce99004300000000),
         UINT64_C(0x857a6cd200000000),
         UINT64_C(0x565a556d00000000),
         UINT64_C(0x1db939fc00000000),
         UINT64_C(0x0000e84f00000000),
         UINT64_C(0x4be384de00000000),
         UINT64_C(0x98c3bd6100000000),
         UINT64_C(0xd320d1f000000000),
         UINT64_C(0xce99e80c00000000),
         UINT64_C(0x857a849d00000000),
         UINT64_C(0x565abd2200000000),
         UINT64_C(0x1db9d1b300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1eaf000000000000),
         UINT64_C(0x0999000000000000),
         UINT64_C(0x1736000000000000),
         UINT64_C(0x0042100000000000),
         UINT64_C(0x1eed100000000000),
         UINT64_C(0x09db100000000000),
         UINT64_C(0x1774100000000000),
         UINT64_C(0x4c93f00000000000),
         UINT64_C(0x523cf00000000000),
         UINT64_C(0x450af00000000000),
         UINT64_C(0x5ba5f00000000000),
         UINT64_C(0x4cd1e00000000000),
         UINT64_C(0x527ee00000000000),
         UINT64_C(0x4548e00000000000),
         UINT64_C(0x5be7e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1eaf000000000),
         UINT64_C(0x3ff0999000000000),
         UINT64_C(0x3ff1736000000000),
         UINT64_C(0x3ff0042100000000),
         UINT64_C(0x3ff1eed100000000),
         UINT64_C(0x3ff09db100000000),
         UINT64_C(0x3ff1774100000000),
         UINT64_C(0x3ff4c93f00000000),
         UINT64_C(0x3ff523cf00000000),
         UINT64_C(0x3ff450af00000000),
         UINT64_C(0x3ff5ba5f00000000),
         UINT64_C(0x3ff4cd1e00000000),
         UINT64_C(0x3ff527ee00000000),
         UINT64_C(0x3ff4548e00000000),
         UINT64_C(0x3ff5be7e00000000)},
        UINT64_C(0xfff8000000000000),
        {0xfb,0x4b,0x72,0xb7,0xbe,0x77,0x9d,0x0a,0x5b,0xa0,
         0x59,0xc4,0xac,0x9c,0x2f,0x87,0x12,0xe1,0x5d,0x48,0x00}
    },
    {
        /* No.68 delta:2369 weight:3601 */
        11213,
        42,
        18,
        14,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa8d69f9000000000),
         UINT64_C(0x9012464800000000),
         UINT64_C(0x38c4d9d800000000),
         UINT64_C(0x7352004400000000),
         UINT64_C(0xdb849fd400000000),
         UINT64_C(0xe340460c00000000),
         UINT64_C(0x4b96d99c00000000),
         UINT64_C(0x00008d0b00000000),
         UINT64_C(0xa8d6129b00000000),
         UINT64_C(0x9012cb4300000000),
         UINT64_C(0x38c454d300000000),
         UINT64_C(0x73528d4f00000000),
         UINT64_C(0xdb8412df00000000),
         UINT64_C(0xe340cb0700000000),
         UINT64_C(0x4b96549700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0003200000000000),
         UINT64_C(0x0000900000000000),
         UINT64_C(0x0003b00000000000),
         UINT64_C(0x5000900000000000),
         UINT64_C(0x5003b00000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x5003200000000000),
         UINT64_C(0x1043f00000000000),
         UINT64_C(0x1040d00000000000),
         UINT64_C(0x1043600000000000),
         UINT64_C(0x1040400000000000),
         UINT64_C(0x4043600000000000),
         UINT64_C(0x4040400000000000),
         UINT64_C(0x4043f00000000000),
         UINT64_C(0x4040d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0003200000000),
         UINT64_C(0x3ff0000900000000),
         UINT64_C(0x3ff0003b00000000),
         UINT64_C(0x3ff5000900000000),
         UINT64_C(0x3ff5003b00000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff5003200000000),
         UINT64_C(0x3ff1043f00000000),
         UINT64_C(0x3ff1040d00000000),
         UINT64_C(0x3ff1043600000000),
         UINT64_C(0x3ff1040400000000),
         UINT64_C(0x3ff4043600000000),
         UINT64_C(0x3ff4040400000000),
         UINT64_C(0x3ff4043f00000000),
         UINT64_C(0x3ff4040d00000000)},
        UINT64_C(0xfff8000000000000),
        {0x41,0xc8,0xaf,0x8d,0x7d,0x40,0x3a,0x6e,0x00,0xd3,
         0x0e,0x8d,0x69,0xcb,0x0f,0x9b,0xae,0x76,0x44,0xdb,0x00}
    },
    {
        /* No.69 delta:2214 weight:3267 */
        11213,
        14,
        11,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xf06160ef00000000),
         UINT64_C(0xf55e70bd00000000),
         UINT64_C(0x053f105200000000),
         UINT64_C(0x71ae004500000000),
         UINT64_C(0x81cf60aa00000000),
         UINT64_C(0x84f070f800000000),
         UINT64_C(0x7491101700000000),
         UINT64_C(0x0000911b00000000),
         UINT64_C(0xf061f1f400000000),
         UINT64_C(0xf55ee1a600000000),
         UINT64_C(0x053f814900000000),
         UINT64_C(0x71ae915e00000000),
         UINT64_C(0x81cff1b100000000),
         UINT64_C(0x84f0e1e300000000),
         UINT64_C(0x7491810c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x484d000000000000),
         UINT64_C(0x0042200000000000),
         UINT64_C(0x480f200000000000),
         UINT64_C(0x0020000000000000),
         UINT64_C(0x486d000000000000),
         UINT64_C(0x0062200000000000),
         UINT64_C(0x482f200000000000),
         UINT64_C(0x0013f00000000000),
         UINT64_C(0x485ef00000000000),
         UINT64_C(0x0051d00000000000),
         UINT64_C(0x481cd00000000000),
         UINT64_C(0x0033f00000000000),
         UINT64_C(0x487ef00000000000),
         UINT64_C(0x0071d00000000000),
         UINT64_C(0x483cd00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff484d000000000),
         UINT64_C(0x3ff0042200000000),
         UINT64_C(0x3ff480f200000000),
         UINT64_C(0x3ff0020000000000),
         UINT64_C(0x3ff486d000000000),
         UINT64_C(0x3ff0062200000000),
         UINT64_C(0x3ff482f200000000),
         UINT64_C(0x3ff0013f00000000),
         UINT64_C(0x3ff485ef00000000),
         UINT64_C(0x3ff0051d00000000),
         UINT64_C(0x3ff481cd00000000),
         UINT64_C(0x3ff0033f00000000),
         UINT64_C(0x3ff487ef00000000),
         UINT64_C(0x3ff0071d00000000),
         UINT64_C(0x3ff483cd00000000)},
        UINT64_C(0xfff8000000000000),
        {0x06,0x0d,0x1c,0xc9,0x7c,0xe3,0x00,0x8f,0x57,0x0e,
         0x18,0x89,0x32,0xc0,0xe4,0x38,0x8c,0xf1,0xee,0xe6,0x00}
    },
    {
        /* No.70 delta:2539 weight:3015 */
        11213,
        28,
        25,
        7,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc756545000000000),
         UINT64_C(0x70f5681d00000000),
         UINT64_C(0xb7a33c4d00000000),
         UINT64_C(0x54f9004600000000),
         UINT64_C(0x93af541600000000),
         UINT64_C(0x240c685b00000000),
         UINT64_C(0xe35a3c0b00000000),
         UINT64_C(0x00009f1200000000),
         UINT64_C(0xc756cb4200000000),
         UINT64_C(0x70f5f70f00000000),
         UINT64_C(0xb7a3a35f00000000),
         UINT64_C(0x54f99f5400000000),
         UINT64_C(0x93afcb0400000000),
         UINT64_C(0x240cf74900000000),
         UINT64_C(0xe35aa31900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0800d00000000000),
         UINT64_C(0x0100000000000000),
         UINT64_C(0x0900d00000000000),
         UINT64_C(0x1060400000000000),
         UINT64_C(0x1860900000000000),
         UINT64_C(0x1160400000000000),
         UINT64_C(0x1960900000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0803200000000000),
         UINT64_C(0x0103f00000000000),
         UINT64_C(0x0903200000000000),
         UINT64_C(0x1063b00000000000),
         UINT64_C(0x1863600000000000),
         UINT64_C(0x1163b00000000000),
         UINT64_C(0x1963600000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0800d00000000),
         UINT64_C(0x3ff0100000000000),
         UINT64_C(0x3ff0900d00000000),
         UINT64_C(0x3ff1060400000000),
         UINT64_C(0x3ff1860900000000),
         UINT64_C(0x3ff1160400000000),
         UINT64_C(0x3ff1960900000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0803200000000),
         UINT64_C(0x3ff0103f00000000),
         UINT64_C(0x3ff0903200000000),
         UINT64_C(0x3ff1063b00000000),
         UINT64_C(0x3ff1863600000000),
         UINT64_C(0x3ff1163b00000000),
         UINT64_C(0x3ff1963600000000)},
        UINT64_C(0xfff8000000000000),
        {0xd9,0x9f,0xfa,0xb7,0x10,0x8b,0x3d,0xd6,0x6d,0x29,
         0x64,0xe7,0x6f,0x7f,0x95,0xf6,0xba,0x3a,0x8d,0x46,0x00}
    },
    {
        /* No.71 delta:2888 weight:3489 */
        11213,
        39,
        9,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x87af261b00000000),
         UINT64_C(0x03fcd00a00000000),
         UINT64_C(0x8453f61100000000),
         UINT64_C(0x8287004700000000),
         UINT64_C(0x0528265c00000000),
         UINT64_C(0x817bd04d00000000),
         UINT64_C(0x06d4f65600000000),
         UINT64_C(0x000050b200000000),
         UINT64_C(0x87af76a900000000),
         UINT64_C(0x03fc80b800000000),
         UINT64_C(0x8453a6a300000000),
         UINT64_C(0x828750f500000000),
         UINT64_C(0x052876ee00000000),
         UINT64_C(0x817b80ff00000000),
         UINT64_C(0x06d4a6e400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x6000000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x6000000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x6003f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff6000000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff6000000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff6003f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x55,0x97,0x05,0x3a,0xf3,0x3b,0x52,0x7a,0x7a,0xdc,
         0x9c,0x43,0x81,0x2f,0x51,0x72,0x09,0x70,0xf3,0x6f,0x00}
    },
    {
        /* No.72 delta:5153 weight:2659 */
        11213,
        8,
        14,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xba10724f00000000),
         UINT64_C(0xf65fe54700000000),
         UINT64_C(0x4c4f970800000000),
         UINT64_C(0x10aa004800000000),
         UINT64_C(0xaaba720700000000),
         UINT64_C(0xe6f5e50f00000000),
         UINT64_C(0x5ce5974000000000),
         UINT64_C(0x00003d5600000000),
         UINT64_C(0xba104f1900000000),
         UINT64_C(0xf65fd81100000000),
         UINT64_C(0x4c4faa5e00000000),
         UINT64_C(0x10aa3d1e00000000),
         UINT64_C(0xaaba4f5100000000),
         UINT64_C(0xe6f5d85900000000),
         UINT64_C(0x5ce5aa1600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x979d800000000000),
         UINT64_C(0x1c0a000000000000),
         UINT64_C(0x8b97800000000000),
         UINT64_C(0x0a22400000000000),
         UINT64_C(0x9dbfc00000000000),
         UINT64_C(0x1628400000000000),
         UINT64_C(0x81b5c00000000000),
         UINT64_C(0x004ff00000000000),
         UINT64_C(0x97d2700000000000),
         UINT64_C(0x1c45f00000000000),
         UINT64_C(0x8bd8700000000000),
         UINT64_C(0x0a6db00000000000),
         UINT64_C(0x9df0300000000000),
         UINT64_C(0x1667b00000000000),
         UINT64_C(0x81fa300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff979d800000000),
         UINT64_C(0x3ff1c0a000000000),
         UINT64_C(0x3ff8b97800000000),
         UINT64_C(0x3ff0a22400000000),
         UINT64_C(0x3ff9dbfc00000000),
         UINT64_C(0x3ff1628400000000),
         UINT64_C(0x3ff81b5c00000000),
         UINT64_C(0x3ff004ff00000000),
         UINT64_C(0x3ff97d2700000000),
         UINT64_C(0x3ff1c45f00000000),
         UINT64_C(0x3ff8bd8700000000),
         UINT64_C(0x3ff0a6db00000000),
         UINT64_C(0x3ff9df0300000000),
         UINT64_C(0x3ff1667b00000000),
         UINT64_C(0x3ff81fa300000000)},
        UINT64_C(0xfff8000000000000),
        {0x87,0x09,0xa3,0x45,0xbc,0x11,0xf6,0xb4,0xab,0x61,
         0x5c,0x7d,0x21,0xc9,0x36,0xd6,0x55,0x5e,0xdd,0xcb,0x00}
    },
    {
        /* No.73 delta:2692 weight:3741 */
        11213,
        10,
        4,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xb6fb3d2c00000000),
         UINT64_C(0x143331f600000000),
         UINT64_C(0xa2c80cda00000000),
         UINT64_C(0xbc80004900000000),
         UINT64_C(0x0a7b3d6500000000),
         UINT64_C(0xa8b331bf00000000),
         UINT64_C(0x1e480c9300000000),
         UINT64_C(0x00004e7e00000000),
         UINT64_C(0xb6fb735200000000),
         UINT64_C(0x14337f8800000000),
         UINT64_C(0xa2c842a400000000),
         UINT64_C(0xbc804e3700000000),
         UINT64_C(0x0a7b731b00000000),
         UINT64_C(0xa8b37fc100000000),
         UINT64_C(0x1e4842ed00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0002400000000000),
         UINT64_C(0x900a400000000000),
         UINT64_C(0x9008000000000000),
         UINT64_C(0x0010c00000000000),
         UINT64_C(0x0012800000000000),
         UINT64_C(0x901a800000000000),
         UINT64_C(0x9018c00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0001b00000000000),
         UINT64_C(0x9009b00000000000),
         UINT64_C(0x900bf00000000000),
         UINT64_C(0x0013300000000000),
         UINT64_C(0x0011700000000000),
         UINT64_C(0x9019700000000000),
         UINT64_C(0x901b300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0002400000000),
         UINT64_C(0x3ff900a400000000),
         UINT64_C(0x3ff9008000000000),
         UINT64_C(0x3ff0010c00000000),
         UINT64_C(0x3ff0012800000000),
         UINT64_C(0x3ff901a800000000),
         UINT64_C(0x3ff9018c00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0001b00000000),
         UINT64_C(0x3ff9009b00000000),
         UINT64_C(0x3ff900bf00000000),
         UINT64_C(0x3ff0013300000000),
         UINT64_C(0x3ff0011700000000),
         UINT64_C(0x3ff9019700000000),
         UINT64_C(0x3ff901b300000000)},
        UINT64_C(0xfff8000000000000),
        {0xbc,0x4f,0x7f,0xcc,0xc1,0x56,0x28,0x53,0x67,0x40,
         0xce,0xce,0x0e,0x1c,0x5d,0x44,0xc8,0x29,0x64,0x52,0x00}
    },
    {
        /* No.74 delta:2202 weight:2035 */
        11213,
        26,
        9,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xbca4706300000000),
         UINT64_C(0x00271c5500000000),
         UINT64_C(0xbc836c3600000000),
         UINT64_C(0x204b004a00000000),
         UINT64_C(0x9cef702900000000),
         UINT64_C(0x206c1c1f00000000),
         UINT64_C(0x9cc86c7c00000000),
         UINT64_C(0x0000d56a00000000),
         UINT64_C(0xbca4a50900000000),
         UINT64_C(0x0027c93f00000000),
         UINT64_C(0xbc83b95c00000000),
         UINT64_C(0x204bd52000000000),
         UINT64_C(0x9cefa54300000000),
         UINT64_C(0x206cc97500000000),
         UINT64_C(0x9cc8b91600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4040000000000000),
         UINT64_C(0xc000800000000000),
         UINT64_C(0x8040800000000000),
         UINT64_C(0x1002000000000000),
         UINT64_C(0x5042000000000000),
         UINT64_C(0xd002800000000000),
         UINT64_C(0x9042800000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x4043f00000000000),
         UINT64_C(0xc003700000000000),
         UINT64_C(0x8043700000000000),
         UINT64_C(0x1001f00000000000),
         UINT64_C(0x5041f00000000000),
         UINT64_C(0xd001700000000000),
         UINT64_C(0x9041700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4040000000000),
         UINT64_C(0x3ffc000800000000),
         UINT64_C(0x3ff8040800000000),
         UINT64_C(0x3ff1002000000000),
         UINT64_C(0x3ff5042000000000),
         UINT64_C(0x3ffd002800000000),
         UINT64_C(0x3ff9042800000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff4043f00000000),
         UINT64_C(0x3ffc003700000000),
         UINT64_C(0x3ff8043700000000),
         UINT64_C(0x3ff1001f00000000),
         UINT64_C(0x3ff5041f00000000),
         UINT64_C(0x3ffd001700000000),
         UINT64_C(0x3ff9041700000000)},
        UINT64_C(0xfff8000000000000),
        {0x05,0x1f,0x2a,0x8d,0x5f,0x9e,0x20,0xc9,0x08,0x8e,
         0x3b,0x0c,0x9a,0xab,0x7c,0x67,0x3c,0xda,0x9b,0xb2,0x00}
    },
    {
        /* No.75 delta:2045 weight:3557 */
        11213,
        11,
        7,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6a0ccfce00000000),
         UINT64_C(0x125f881700000000),
         UINT64_C(0x785347d900000000),
         UINT64_C(0x0cf7004b00000000),
         UINT64_C(0x66fbcf8500000000),
         UINT64_C(0x1ea8885c00000000),
         UINT64_C(0x74a4479200000000),
         UINT64_C(0x0000195800000000),
         UINT64_C(0x6a0cd69600000000),
         UINT64_C(0x125f914f00000000),
         UINT64_C(0x78535e8100000000),
         UINT64_C(0x0cf7191300000000),
         UINT64_C(0x66fbd6dd00000000),
         UINT64_C(0x1ea8910400000000),
         UINT64_C(0x74a45eca00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1042000000000000),
         UINT64_C(0x1040200000000000),
         UINT64_C(0x0002200000000000),
         UINT64_C(0x9002000000000000),
         UINT64_C(0x8040000000000000),
         UINT64_C(0x8042200000000000),
         UINT64_C(0x9000200000000000),
         UINT64_C(0x7223f00000000000),
         UINT64_C(0x6261f00000000000),
         UINT64_C(0x6263d00000000000),
         UINT64_C(0x7221d00000000000),
         UINT64_C(0xe221f00000000000),
         UINT64_C(0xf263f00000000000),
         UINT64_C(0xf261d00000000000),
         UINT64_C(0xe223d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1042000000000),
         UINT64_C(0x3ff1040200000000),
         UINT64_C(0x3ff0002200000000),
         UINT64_C(0x3ff9002000000000),
         UINT64_C(0x3ff8040000000000),
         UINT64_C(0x3ff8042200000000),
         UINT64_C(0x3ff9000200000000),
         UINT64_C(0x3ff7223f00000000),
         UINT64_C(0x3ff6261f00000000),
         UINT64_C(0x3ff6263d00000000),
         UINT64_C(0x3ff7221d00000000),
         UINT64_C(0x3ffe221f00000000),
         UINT64_C(0x3fff263f00000000),
         UINT64_C(0x3fff261d00000000),
         UINT64_C(0x3ffe223d00000000)},
        UINT64_C(0xfff8000000000000),
        {0xe9,0x11,0xcf,0x85,0x22,0xd2,0xca,0xac,0x2e,0xb1,
         0x9f,0xc3,0x35,0x13,0xf3,0x82,0x1d,0xa5,0xda,0x79,0x00}
    },
    {
        /* No.76 delta:2802 weight:1701 */
        11213,
        45,
        18,
        14,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x824296c000000000),
         UINT64_C(0x8145166e00000000),
         UINT64_C(0x030780ae00000000),
         UINT64_C(0xc9ad004c00000000),
         UINT64_C(0x4bef968c00000000),
         UINT64_C(0x48e8162200000000),
         UINT64_C(0xcaaa80e200000000),
         UINT64_C(0x0000659000000000),
         UINT64_C(0x8242f35000000000),
         UINT64_C(0x814573fe00000000),
         UINT64_C(0x0307e53e00000000),
         UINT64_C(0xc9ad65dc00000000),
         UINT64_C(0x4beff31c00000000),
         UINT64_C(0x48e873b200000000),
         UINT64_C(0xcaaae57200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0400100000000000),
         UINT64_C(0x1050000000000000),
         UINT64_C(0x1450100000000000),
         UINT64_C(0x9024000000000000),
         UINT64_C(0x9424100000000000),
         UINT64_C(0x8074000000000000),
         UINT64_C(0x8474100000000000),
         UINT64_C(0x002bf00000000000),
         UINT64_C(0x042be00000000000),
         UINT64_C(0x107bf00000000000),
         UINT64_C(0x147be00000000000),
         UINT64_C(0x900ff00000000000),
         UINT64_C(0x940fe00000000000),
         UINT64_C(0x805ff00000000000),
         UINT64_C(0x845fe00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0400100000000),
         UINT64_C(0x3ff1050000000000),
         UINT64_C(0x3ff1450100000000),
         UINT64_C(0x3ff9024000000000),
         UINT64_C(0x3ff9424100000000),
         UINT64_C(0x3ff8074000000000),
         UINT64_C(0x3ff8474100000000),
         UINT64_C(0x3ff002bf00000000),
         UINT64_C(0x3ff042be00000000),
         UINT64_C(0x3ff107bf00000000),
         UINT64_C(0x3ff147be00000000),
         UINT64_C(0x3ff900ff00000000),
         UINT64_C(0x3ff940fe00000000),
         UINT64_C(0x3ff805ff00000000),
         UINT64_C(0x3ff845fe00000000)},
        UINT64_C(0xfff8000000000000),
        {0x28,0x73,0xcd,0x4d,0x6d,0xbc,0x1f,0xfb,0x0a,0xf5,
         0x01,0xff,0x03,0xdb,0xd6,0x2f,0x96,0xa8,0x9e,0x34,0x00}
    },
    {
        /* No.77 delta:2941 weight:3471 */
        11213,
        41,
        9,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x00153fdd00000000),
         UINT64_C(0x44f49f2300000000),
         UINT64_C(0x44e1a0fe00000000),
         UINT64_C(0xd3e3004d00000000),
         UINT64_C(0xd3f63f9000000000),
         UINT64_C(0x97179f6e00000000),
         UINT64_C(0x9702a0b300000000),
         UINT64_C(0x0000dd7000000000),
         UINT64_C(0x0015e2ad00000000),
         UINT64_C(0x44f4425300000000),
         UINT64_C(0x44e17d8e00000000),
         UINT64_C(0xd3e3dd3d00000000),
         UINT64_C(0xd3f6e2e000000000),
         UINT64_C(0x9717421e00000000),
         UINT64_C(0x97027dc300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4020000000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x1020000000000000),
         UINT64_C(0x9000000000000000),
         UINT64_C(0xd020000000000000),
         UINT64_C(0xc000000000000000),
         UINT64_C(0x8020000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x4023f00000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x1023f00000000000),
         UINT64_C(0x9003f00000000000),
         UINT64_C(0xd023f00000000000),
         UINT64_C(0xc003f00000000000),
         UINT64_C(0x8023f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4020000000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff1020000000000),
         UINT64_C(0x3ff9000000000000),
         UINT64_C(0x3ffd020000000000),
         UINT64_C(0x3ffc000000000000),
         UINT64_C(0x3ff8020000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff4023f00000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff1023f00000000),
         UINT64_C(0x3ff9003f00000000),
         UINT64_C(0x3ffd023f00000000),
         UINT64_C(0x3ffc003f00000000),
         UINT64_C(0x3ff8023f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xd0,0x8a,0x34,0x6d,0xd7,0xa0,0x26,0xb4,0xb2,0x12,
         0xc1,0x28,0xe6,0xc5,0x89,0xf0,0x2c,0x3e,0xfe,0xd6,0x00}
    },
    {
        /* No.78 delta:2675 weight:2943 */
        11213,
        6,
        18,
        14,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x50612c8c00000000),
         UINT64_C(0x56ce967300000000),
         UINT64_C(0x06afbaff00000000),
         UINT64_C(0x6fa8004e00000000),
         UINT64_C(0x3fc92cc200000000),
         UINT64_C(0x3966963d00000000),
         UINT64_C(0x6907bab100000000),
         UINT64_C(0x0000f56700000000),
         UINT64_C(0x5061d9eb00000000),
         UINT64_C(0x56ce631400000000),
         UINT64_C(0x06af4f9800000000),
         UINT64_C(0x6fa8f52900000000),
         UINT64_C(0x3fc9d9a500000000),
         UINT64_C(0x3966635a00000000),
         UINT64_C(0x69074fd600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2034600000000000),
         UINT64_C(0x802c000000000000),
         UINT64_C(0xa018600000000000),
         UINT64_C(0x3004700000000000),
         UINT64_C(0x1030100000000000),
         UINT64_C(0xb028700000000000),
         UINT64_C(0x901c100000000000),
         UINT64_C(0x206ff00000000000),
         UINT64_C(0x005b900000000000),
         UINT64_C(0xa043f00000000000),
         UINT64_C(0x8077900000000000),
         UINT64_C(0x106b800000000000),
         UINT64_C(0x305fe00000000000),
         UINT64_C(0x9047800000000000),
         UINT64_C(0xb073e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2034600000000),
         UINT64_C(0x3ff802c000000000),
         UINT64_C(0x3ffa018600000000),
         UINT64_C(0x3ff3004700000000),
         UINT64_C(0x3ff1030100000000),
         UINT64_C(0x3ffb028700000000),
         UINT64_C(0x3ff901c100000000),
         UINT64_C(0x3ff206ff00000000),
         UINT64_C(0x3ff005b900000000),
         UINT64_C(0x3ffa043f00000000),
         UINT64_C(0x3ff8077900000000),
         UINT64_C(0x3ff106b800000000),
         UINT64_C(0x3ff305fe00000000),
         UINT64_C(0x3ff9047800000000),
         UINT64_C(0x3ffb073e00000000)},
        UINT64_C(0xfff8000000000000),
        {0xea,0x46,0x5e,0xde,0xc5,0x19,0x8a,0xf7,0xac,0xad,
         0x4c,0xb7,0xde,0x46,0xf0,0x5d,0x7c,0x3c,0x63,0xb1,0x00}
    },
    {
        /* No.79 delta:2699 weight:2715 */
        11213,
        5,
        10,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xeeddd82500000000),
         UINT64_C(0x44f2473e00000000),
         UINT64_C(0xaa2f9f1b00000000),
         UINT64_C(0x198c004f00000000),
         UINT64_C(0xf751d86a00000000),
         UINT64_C(0x5d7e477100000000),
         UINT64_C(0xb3a39f5400000000),
         UINT64_C(0x0000035700000000),
         UINT64_C(0xeedddb7200000000),
         UINT64_C(0x44f2446900000000),
         UINT64_C(0xaa2f9c4c00000000),
         UINT64_C(0x198c031800000000),
         UINT64_C(0xf751db3d00000000),
         UINT64_C(0x5d7e442600000000),
         UINT64_C(0xb3a39c0300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x10f4200000000000),
         UINT64_C(0x2048200000000000),
         UINT64_C(0x30bc000000000000),
         UINT64_C(0x006c400000000000),
         UINT64_C(0x1098600000000000),
         UINT64_C(0x2024600000000000),
         UINT64_C(0x30d0400000000000),
         UINT64_C(0x0013f00000000000),
         UINT64_C(0x10e7d00000000000),
         UINT64_C(0x205bd00000000000),
         UINT64_C(0x30aff00000000000),
         UINT64_C(0x007fb00000000000),
         UINT64_C(0x108b900000000000),
         UINT64_C(0x2037900000000000),
         UINT64_C(0x30c3b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff10f4200000000),
         UINT64_C(0x3ff2048200000000),
         UINT64_C(0x3ff30bc000000000),
         UINT64_C(0x3ff006c400000000),
         UINT64_C(0x3ff1098600000000),
         UINT64_C(0x3ff2024600000000),
         UINT64_C(0x3ff30d0400000000),
         UINT64_C(0x3ff0013f00000000),
         UINT64_C(0x3ff10e7d00000000),
         UINT64_C(0x3ff205bd00000000),
         UINT64_C(0x3ff30aff00000000),
         UINT64_C(0x3ff007fb00000000),
         UINT64_C(0x3ff108b900000000),
         UINT64_C(0x3ff2037900000000),
         UINT64_C(0x3ff30c3b00000000)},
        UINT64_C(0xfff8000000000000),
        {0x18,0x69,0xcb,0x06,0xe7,0x9e,0x5d,0x0a,0x45,0x11,
         0x62,0x83,0x05,0xf8,0x93,0x0e,0x7f,0x2b,0x62,0x4f,0x00}
    },
    {
        /* No.80 delta:2930 weight:3483 */
        11213,
        13,
        10,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0a6e832c00000000),
         UINT64_C(0xcf6003be00000000),
         UINT64_C(0xc50e809200000000),
         UINT64_C(0x98a5005000000000),
         UINT64_C(0x92cb837c00000000),
         UINT64_C(0x57c503ee00000000),
         UINT64_C(0x5dab80c200000000),
         UINT64_C(0x0000283f00000000),
         UINT64_C(0x0a6eab1300000000),
         UINT64_C(0xcf602b8100000000),
         UINT64_C(0xc50ea8ad00000000),
         UINT64_C(0x98a5286f00000000),
         UINT64_C(0x92cbab4300000000),
         UINT64_C(0x57c52bd100000000),
         UINT64_C(0x5daba8fd00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0002900000000000),
         UINT64_C(0x4003500000000000),
         UINT64_C(0x4001c00000000000),
         UINT64_C(0x0003d00000000000),
         UINT64_C(0x0001400000000000),
         UINT64_C(0x4000800000000000),
         UINT64_C(0x4002100000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x5001600000000000),
         UINT64_C(0x1000a00000000000),
         UINT64_C(0x1002300000000000),
         UINT64_C(0x5000200000000000),
         UINT64_C(0x5002b00000000000),
         UINT64_C(0x1003700000000000),
         UINT64_C(0x1001e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0002900000000),
         UINT64_C(0x3ff4003500000000),
         UINT64_C(0x3ff4001c00000000),
         UINT64_C(0x3ff0003d00000000),
         UINT64_C(0x3ff0001400000000),
         UINT64_C(0x3ff4000800000000),
         UINT64_C(0x3ff4002100000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff5001600000000),
         UINT64_C(0x3ff1000a00000000),
         UINT64_C(0x3ff1002300000000),
         UINT64_C(0x3ff5000200000000),
         UINT64_C(0x3ff5002b00000000),
         UINT64_C(0x3ff1003700000000),
         UINT64_C(0x3ff1001e00000000)},
        UINT64_C(0xfff8000000000000),
        {0x8f,0xf2,0xa3,0x7d,0x5e,0x2d,0xdc,0xc6,0xfa,0x96,
         0x03,0x27,0x43,0x3c,0x5f,0xef,0x79,0xae,0xa2,0x6f,0x00}
    },
    {
        /* No.81 delta:2928 weight:3839 */
        11213,
        14,
        3,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4127532000000000),
         UINT64_C(0xfd954bfe00000000),
         UINT64_C(0xbcb218de00000000),
         UINT64_C(0x0841005100000000),
         UINT64_C(0x4966537100000000),
         UINT64_C(0xf5d44baf00000000),
         UINT64_C(0xb4f3188f00000000),
         UINT64_C(0x0000382d00000000),
         UINT64_C(0x41276b0d00000000),
         UINT64_C(0xfd9573d300000000),
         UINT64_C(0xbcb220f300000000),
         UINT64_C(0x0841387c00000000),
         UINT64_C(0x49666b5c00000000),
         UINT64_C(0xf5d4738200000000),
         UINT64_C(0xb4f320a200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x400e400000000000),
         UINT64_C(0x4003800000000000),
         UINT64_C(0x000dc00000000000),
         UINT64_C(0x0002d00000000000),
         UINT64_C(0x400c900000000000),
         UINT64_C(0x4001500000000000),
         UINT64_C(0x000f100000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x600db00000000000),
         UINT64_C(0x6000700000000000),
         UINT64_C(0x200e300000000000),
         UINT64_C(0x2001200000000000),
         UINT64_C(0x600f600000000000),
         UINT64_C(0x6002a00000000000),
         UINT64_C(0x200ce00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff400e400000000),
         UINT64_C(0x3ff4003800000000),
         UINT64_C(0x3ff000dc00000000),
         UINT64_C(0x3ff0002d00000000),
         UINT64_C(0x3ff400c900000000),
         UINT64_C(0x3ff4001500000000),
         UINT64_C(0x3ff000f100000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff600db00000000),
         UINT64_C(0x3ff6000700000000),
         UINT64_C(0x3ff200e300000000),
         UINT64_C(0x3ff2001200000000),
         UINT64_C(0x3ff600f600000000),
         UINT64_C(0x3ff6002a00000000),
         UINT64_C(0x3ff200ce00000000)},
        UINT64_C(0xfff8000000000000),
        {0xe1,0xad,0xff,0xfb,0xa8,0x9f,0x65,0xbe,0x0d,0xd7,
         0x1d,0x13,0xd9,0x91,0x48,0xd2,0x3b,0x12,0x30,0xc5,0x00}
    },
    {
        /* No.82 delta:2512 weight:3371 */
        11213,
        9,
        3,
        7,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8556e74500000000),
         UINT64_C(0x5a809b0d00000000),
         UINT64_C(0xdfd67c4800000000),
         UINT64_C(0x05e5005200000000),
         UINT64_C(0x80b3e71700000000),
         UINT64_C(0x5f659b5f00000000),
         UINT64_C(0xda337c1a00000000),
         UINT64_C(0x0000a49600000000),
         UINT64_C(0x855643d300000000),
         UINT64_C(0x5a803f9b00000000),
         UINT64_C(0xdfd6d8de00000000),
         UINT64_C(0x05e5a4c400000000),
         UINT64_C(0x80b3438100000000),
         UINT64_C(0x5f653fc900000000),
         UINT64_C(0xda33d88c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8880500000000000),
         UINT64_C(0x4006c00000000000),
         UINT64_C(0xc886900000000000),
         UINT64_C(0x0050100000000000),
         UINT64_C(0x88d0400000000000),
         UINT64_C(0x4056d00000000000),
         UINT64_C(0xc8d6800000000000),
         UINT64_C(0x007bf00000000000),
         UINT64_C(0x88fba00000000000),
         UINT64_C(0x407d300000000000),
         UINT64_C(0xc8fd600000000000),
         UINT64_C(0x002be00000000000),
         UINT64_C(0x88abb00000000000),
         UINT64_C(0x402d200000000000),
         UINT64_C(0xc8ad700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff8880500000000),
         UINT64_C(0x3ff4006c00000000),
         UINT64_C(0x3ffc886900000000),
         UINT64_C(0x3ff0050100000000),
         UINT64_C(0x3ff88d0400000000),
         UINT64_C(0x3ff4056d00000000),
         UINT64_C(0x3ffc8d6800000000),
         UINT64_C(0x3ff007bf00000000),
         UINT64_C(0x3ff88fba00000000),
         UINT64_C(0x3ff407d300000000),
         UINT64_C(0x3ffc8fd600000000),
         UINT64_C(0x3ff002be00000000),
         UINT64_C(0x3ff88abb00000000),
         UINT64_C(0x3ff402d200000000),
         UINT64_C(0x3ffc8ad700000000)},
        UINT64_C(0xfff8000000000000),
        {0xf5,0xa9,0x66,0xa4,0x33,0x2e,0xd7,0x83,0xae,0xd9,
         0xbe,0x27,0x1f,0xbb,0xac,0x4a,0x8a,0xa3,0x62,0xce,0x00}
    },
    {
        /* No.83 delta:5152 weight:1699 */
        11213,
        45,
        15,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x979d8eda00000000),
         UINT64_C(0xa2050ccb00000000),
         UINT64_C(0x3598821100000000),
         UINT64_C(0x397c005300000000),
         UINT64_C(0xaee18e8900000000),
         UINT64_C(0x9b790c9800000000),
         UINT64_C(0x0ce4824200000000),
         UINT64_C(0x0000f1dd00000000),
         UINT64_C(0x979d7f0700000000),
         UINT64_C(0xa205fd1600000000),
         UINT64_C(0x359873cc00000000),
         UINT64_C(0x397cf18e00000000),
         UINT64_C(0xaee17f5400000000),
         UINT64_C(0x9b79fd4500000000),
         UINT64_C(0x0ce4739f00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0473800000000000),
         UINT64_C(0xf70f000000000000),
         UINT64_C(0xf37c800000000000),
         UINT64_C(0x0a18400000000000),
         UINT64_C(0x0e6bc00000000000),
         UINT64_C(0xfd17400000000000),
         UINT64_C(0xf964c00000000000),
         UINT64_C(0x050bf00000000000),
         UINT64_C(0x0178700000000000),
         UINT64_C(0xf204f00000000000),
         UINT64_C(0xf677700000000000),
         UINT64_C(0x0f13b00000000000),
         UINT64_C(0x0b60300000000000),
         UINT64_C(0xf81cb00000000000),
         UINT64_C(0xfc6f300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0473800000000),
         UINT64_C(0x3fff70f000000000),
         UINT64_C(0x3fff37c800000000),
         UINT64_C(0x3ff0a18400000000),
         UINT64_C(0x3ff0e6bc00000000),
         UINT64_C(0x3fffd17400000000),
         UINT64_C(0x3fff964c00000000),
         UINT64_C(0x3ff050bf00000000),
         UINT64_C(0x3ff0178700000000),
         UINT64_C(0x3fff204f00000000),
         UINT64_C(0x3fff677700000000),
         UINT64_C(0x3ff0f13b00000000),
         UINT64_C(0x3ff0b60300000000),
         UINT64_C(0x3fff81cb00000000),
         UINT64_C(0x3fffc6f300000000)},
        UINT64_C(0xfff8000000000000),
        {0x45,0xb9,0x8b,0xaa,0xee,0xa4,0x7a,0x9e,0x3d,0x2d,
         0x50,0xc8,0x1f,0xb5,0x33,0x57,0x77,0x62,0x71,0x69,0x00}
    },
    {
        /* No.84 delta:2796 weight:2857 */
        11213,
        23,
        3,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2e7ba48000000000),
         UINT64_C(0xab99d65600000000),
         UINT64_C(0x85e272d600000000),
         UINT64_C(0x4dcd005400000000),
         UINT64_C(0x63b6a4d400000000),
         UINT64_C(0xe654d60200000000),
         UINT64_C(0xc82f728200000000),
         UINT64_C(0x0000478300000000),
         UINT64_C(0x2e7be30300000000),
         UINT64_C(0xab9991d500000000),
         UINT64_C(0x85e2355500000000),
         UINT64_C(0x4dcd47d700000000),
         UINT64_C(0x63b6e35700000000),
         UINT64_C(0xe654918100000000),
         UINT64_C(0xc82f350100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5022400000000000),
         UINT64_C(0x5003000000000000),
         UINT64_C(0x0021400000000000),
         UINT64_C(0x1000c00000000000),
         UINT64_C(0x4022800000000000),
         UINT64_C(0x4003c00000000000),
         UINT64_C(0x1021800000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x1021b00000000000),
         UINT64_C(0x1000f00000000000),
         UINT64_C(0x4022b00000000000),
         UINT64_C(0x5003300000000000),
         UINT64_C(0x0021700000000000),
         UINT64_C(0x0000300000000000),
         UINT64_C(0x5022700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff5022400000000),
         UINT64_C(0x3ff5003000000000),
         UINT64_C(0x3ff0021400000000),
         UINT64_C(0x3ff1000c00000000),
         UINT64_C(0x3ff4022800000000),
         UINT64_C(0x3ff4003c00000000),
         UINT64_C(0x3ff1021800000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff1021b00000000),
         UINT64_C(0x3ff1000f00000000),
         UINT64_C(0x3ff4022b00000000),
         UINT64_C(0x3ff5003300000000),
         UINT64_C(0x3ff0021700000000),
         UINT64_C(0x3ff0000300000000),
         UINT64_C(0x3ff5022700000000)},
        UINT64_C(0xfff8000000000000),
        {0xd7,0xa6,0xfa,0x66,0x3f,0x5f,0xf1,0x6c,0x9e,0x76,
         0xc1,0x4f,0xc8,0xeb,0x27,0x1a,0x67,0x2e,0x76,0x35,0x00}
    },
    {
        /* No.85 delta:3255 weight:4013 */
        11213,
        11,
        2,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1f7785f300000000),
         UINT64_C(0x1447126000000000),
         UINT64_C(0x0b30979300000000),
         UINT64_C(0x2d46005500000000),
         UINT64_C(0x323185a600000000),
         UINT64_C(0x3901123500000000),
         UINT64_C(0x267697c600000000),
         UINT64_C(0x00000a1800000000),
         UINT64_C(0x1f778feb00000000),
         UINT64_C(0x1447187800000000),
         UINT64_C(0x0b309d8b00000000),
         UINT64_C(0x2d460a4d00000000),
         UINT64_C(0x32318fbe00000000),
         UINT64_C(0x3901182d00000000),
         UINT64_C(0x26769dde00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x107e900000000000),
         UINT64_C(0x000c400000000000),
         UINT64_C(0x1072d00000000000),
         UINT64_C(0x4c11200000000000),
         UINT64_C(0x5c6fb00000000000),
         UINT64_C(0x4c1d600000000000),
         UINT64_C(0x5c63f00000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x407d600000000000),
         UINT64_C(0x500fb00000000000),
         UINT64_C(0x4071200000000000),
         UINT64_C(0x1c12d00000000000),
         UINT64_C(0x0c6c400000000000),
         UINT64_C(0x1c1e900000000000),
         UINT64_C(0x0c60000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff107e900000000),
         UINT64_C(0x3ff000c400000000),
         UINT64_C(0x3ff1072d00000000),
         UINT64_C(0x3ff4c11200000000),
         UINT64_C(0x3ff5c6fb00000000),
         UINT64_C(0x3ff4c1d600000000),
         UINT64_C(0x3ff5c63f00000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff407d600000000),
         UINT64_C(0x3ff500fb00000000),
         UINT64_C(0x3ff4071200000000),
         UINT64_C(0x3ff1c12d00000000),
         UINT64_C(0x3ff0c6c400000000),
         UINT64_C(0x3ff1c1e900000000),
         UINT64_C(0x3ff0c60000000000)},
        UINT64_C(0xfff8000000000000),
        {0x69,0x84,0x8f,0xee,0x97,0x9c,0x6b,0x48,0xd5,0xe3,
         0xca,0x3e,0x1e,0x90,0x98,0x0e,0x88,0x45,0xa1,0xfa,0x00}
    },
    {
        /* No.86 delta:5924 weight:2523 */
        11213,
        31,
        22,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x123867d300000000),
         UINT64_C(0xa01a42b000000000),
         UINT64_C(0xb222256300000000),
         UINT64_C(0x622f005600000000),
         UINT64_C(0x7017678500000000),
         UINT64_C(0xc23542e600000000),
         UINT64_C(0xd00d253500000000),
         UINT64_C(0x0000b96300000000),
         UINT64_C(0x1238deb000000000),
         UINT64_C(0xa01afbd300000000),
         UINT64_C(0xb2229c0000000000),
         UINT64_C(0x622fb93500000000),
         UINT64_C(0x7017dee600000000),
         UINT64_C(0xc235fb8500000000),
         UINT64_C(0xd00d9c5600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0e3d000000000000),
         UINT64_C(0x4dab000000000000),
         UINT64_C(0x4396000000000000),
         UINT64_C(0x2060000000000000),
         UINT64_C(0x2e5d000000000000),
         UINT64_C(0x6dcb000000000000),
         UINT64_C(0x63f6000000000000),
         UINT64_C(0x084ff00000000000),
         UINT64_C(0x0672f00000000000),
         UINT64_C(0x45e4f00000000000),
         UINT64_C(0x4bd9f00000000000),
         UINT64_C(0x282ff00000000000),
         UINT64_C(0x2612f00000000000),
         UINT64_C(0x6584f00000000000),
         UINT64_C(0x6bb9f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0e3d000000000),
         UINT64_C(0x3ff4dab000000000),
         UINT64_C(0x3ff4396000000000),
         UINT64_C(0x3ff2060000000000),
         UINT64_C(0x3ff2e5d000000000),
         UINT64_C(0x3ff6dcb000000000),
         UINT64_C(0x3ff63f6000000000),
         UINT64_C(0x3ff084ff00000000),
         UINT64_C(0x3ff0672f00000000),
         UINT64_C(0x3ff45e4f00000000),
         UINT64_C(0x3ff4bd9f00000000),
         UINT64_C(0x3ff282ff00000000),
         UINT64_C(0x3ff2612f00000000),
         UINT64_C(0x3ff6584f00000000),
         UINT64_C(0x3ff6bb9f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x6f,0x08,0xc9,0x38,0x28,0xec,0x8d,0xa8,0x68,0x40,
         0xc9,0xbb,0xe5,0x0b,0x45,0x58,0x82,0x59,0x5a,0x20,0x00}
    },
    {
        /* No.87 delta:2324 weight:1529 */
        11213,
        36,
        9,
        20,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x42ef432700000000),
         UINT64_C(0x9933817f00000000),
         UINT64_C(0xdbdcc25800000000),
         UINT64_C(0x5e67005700000000),
         UINT64_C(0x1c88437000000000),
         UINT64_C(0xc754812800000000),
         UINT64_C(0x85bbc20f00000000),
         UINT64_C(0x0000650a00000000),
         UINT64_C(0x42ef262d00000000),
         UINT64_C(0x9933e47500000000),
         UINT64_C(0xdbdca75200000000),
         UINT64_C(0x5e67655d00000000),
         UINT64_C(0x1c88267a00000000),
         UINT64_C(0xc754e42200000000),
         UINT64_C(0x85bba70500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x20e0000000000000),
         UINT64_C(0x0002000000000000),
         UINT64_C(0x20e2000000000000),
         UINT64_C(0x0011e00000000000),
         UINT64_C(0x20f1e00000000000),
         UINT64_C(0x0013e00000000000),
         UINT64_C(0x20f3e00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x60e3f00000000000),
         UINT64_C(0x4001f00000000000),
         UINT64_C(0x60e1f00000000000),
         UINT64_C(0x4012100000000000),
         UINT64_C(0x60f2100000000000),
         UINT64_C(0x4010100000000000),
         UINT64_C(0x60f0100000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff20e0000000000),
         UINT64_C(0x3ff0002000000000),
         UINT64_C(0x3ff20e2000000000),
         UINT64_C(0x3ff0011e00000000),
         UINT64_C(0x3ff20f1e00000000),
         UINT64_C(0x3ff0013e00000000),
         UINT64_C(0x3ff20f3e00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff60e3f00000000),
         UINT64_C(0x3ff4001f00000000),
         UINT64_C(0x3ff60e1f00000000),
         UINT64_C(0x3ff4012100000000),
         UINT64_C(0x3ff60f2100000000),
         UINT64_C(0x3ff4010100000000),
         UINT64_C(0x3ff60f0100000000)},
        UINT64_C(0xfff8000000000000),
        {0x90,0xeb,0xeb,0xbb,0x2e,0x05,0x2a,0xb4,0x3f,0xae,
         0x54,0x02,0xc0,0x18,0x12,0xab,0xb7,0x06,0xad,0x56,0x00}
    },
    {
        /* No.88 delta:2541 weight:2909 */
        11213,
        23,
        9,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xff63959e00000000),
         UINT64_C(0x4b75bc6a00000000),
         UINT64_C(0xb41629f400000000),
         UINT64_C(0xddae005800000000),
         UINT64_C(0x22cd95c600000000),
         UINT64_C(0x96dbbc3200000000),
         UINT64_C(0x69b829ac00000000),
         UINT64_C(0x0000d50a00000000),
         UINT64_C(0xff63409400000000),
         UINT64_C(0x4b75696000000000),
         UINT64_C(0xb416fcfe00000000),
         UINT64_C(0xddaed55200000000),
         UINT64_C(0x22cd40cc00000000),
         UINT64_C(0x96db693800000000),
         UINT64_C(0x69b8fca600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0003400000000000),
         UINT64_C(0x0000c00000000000),
         UINT64_C(0x0003800000000000),
         UINT64_C(0x0100400000000000),
         UINT64_C(0x0103000000000000),
         UINT64_C(0x0100800000000000),
         UINT64_C(0x0103c00000000000),
         UINT64_C(0x4023f00000000000),
         UINT64_C(0x4020b00000000000),
         UINT64_C(0x4023300000000000),
         UINT64_C(0x4020700000000000),
         UINT64_C(0x4123b00000000000),
         UINT64_C(0x4120f00000000000),
         UINT64_C(0x4123700000000000),
         UINT64_C(0x4120300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0003400000000),
         UINT64_C(0x3ff0000c00000000),
         UINT64_C(0x3ff0003800000000),
         UINT64_C(0x3ff0100400000000),
         UINT64_C(0x3ff0103000000000),
         UINT64_C(0x3ff0100800000000),
         UINT64_C(0x3ff0103c00000000),
         UINT64_C(0x3ff4023f00000000),
         UINT64_C(0x3ff4020b00000000),
         UINT64_C(0x3ff4023300000000),
         UINT64_C(0x3ff4020700000000),
         UINT64_C(0x3ff4123b00000000),
         UINT64_C(0x3ff4120f00000000),
         UINT64_C(0x3ff4123700000000),
         UINT64_C(0x3ff4120300000000)},
        UINT64_C(0xfff8000000000000),
        {0x4e,0x29,0x52,0x63,0xe7,0xb0,0xf7,0xde,0xdf,0xe4,
         0x08,0x6b,0x95,0x26,0x64,0xfe,0x6e,0x18,0x3f,0x1d,0x00}
    },
    {
        /* No.89 delta:5719 weight:2617 */
        11213,
        24,
        23,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x9a5e846a00000000),
         UINT64_C(0x477da15f00000000),
         UINT64_C(0xdd23253500000000),
         UINT64_C(0xa1b2005900000000),
         UINT64_C(0x3bec843300000000),
         UINT64_C(0xe6cfa10600000000),
         UINT64_C(0x7c91256c00000000),
         UINT64_C(0x00005f5500000000),
         UINT64_C(0x9a5edb3f00000000),
         UINT64_C(0x477dfe0a00000000),
         UINT64_C(0xdd237a6000000000),
         UINT64_C(0xa1b25f0c00000000),
         UINT64_C(0x3becdb6600000000),
         UINT64_C(0xe6cffe5300000000),
         UINT64_C(0x7c917a3900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x205c800000000000),
         UINT64_C(0x2121100000000000),
         UINT64_C(0x017d900000000000),
         UINT64_C(0x4094100000000000),
         UINT64_C(0x60c8900000000000),
         UINT64_C(0x61b5000000000000),
         UINT64_C(0x41e9800000000000),
         UINT64_C(0x1017f00000000000),
         UINT64_C(0x304b700000000000),
         UINT64_C(0x3136e00000000000),
         UINT64_C(0x116a600000000000),
         UINT64_C(0x5083e00000000000),
         UINT64_C(0x70df600000000000),
         UINT64_C(0x71a2f00000000000),
         UINT64_C(0x51fe700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff205c800000000),
         UINT64_C(0x3ff2121100000000),
         UINT64_C(0x3ff017d900000000),
         UINT64_C(0x3ff4094100000000),
         UINT64_C(0x3ff60c8900000000),
         UINT64_C(0x3ff61b5000000000),
         UINT64_C(0x3ff41e9800000000),
         UINT64_C(0x3ff1017f00000000),
         UINT64_C(0x3ff304b700000000),
         UINT64_C(0x3ff3136e00000000),
         UINT64_C(0x3ff116a600000000),
         UINT64_C(0x3ff5083e00000000),
         UINT64_C(0x3ff70df600000000),
         UINT64_C(0x3ff71a2f00000000),
         UINT64_C(0x3ff51fe700000000)},
        UINT64_C(0xfff8000000000000),
        {0x15,0x28,0x5e,0x0e,0xde,0xf8,0xee,0xb9,0xf7,0x64,
         0xec,0xee,0xc3,0x34,0xf9,0x73,0xbe,0x17,0x6e,0xb4,0x00}
    },
    {
        /* No.90 delta:2392 weight:1543 */
        11213,
        44,
        12,
        19,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xcf974e4600000000),
         UINT64_C(0x2c24c6d400000000),
         UINT64_C(0xe3b3889200000000),
         UINT64_C(0xa5f5005a00000000),
         UINT64_C(0x6a624e1c00000000),
         UINT64_C(0x89d1c68e00000000),
         UINT64_C(0x464688c800000000),
         UINT64_C(0x0000818600000000),
         UINT64_C(0xcf97cfc000000000),
         UINT64_C(0x2c24475200000000),
         UINT64_C(0xe3b3091400000000),
         UINT64_C(0xa5f581dc00000000),
         UINT64_C(0x6a62cf9a00000000),
         UINT64_C(0x89d1470800000000),
         UINT64_C(0x4646094e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5002000000000000),
         UINT64_C(0x6401000000000000),
         UINT64_C(0x3403000000000000),
         UINT64_C(0x0100c00000000000),
         UINT64_C(0x5102c00000000000),
         UINT64_C(0x6501c00000000000),
         UINT64_C(0x3503c00000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x7001f00000000000),
         UINT64_C(0x4402f00000000000),
         UINT64_C(0x1400f00000000000),
         UINT64_C(0x2103300000000000),
         UINT64_C(0x7101300000000000),
         UINT64_C(0x4502300000000000),
         UINT64_C(0x1500300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff5002000000000),
         UINT64_C(0x3ff6401000000000),
         UINT64_C(0x3ff3403000000000),
         UINT64_C(0x3ff0100c00000000),
         UINT64_C(0x3ff5102c00000000),
         UINT64_C(0x3ff6501c00000000),
         UINT64_C(0x3ff3503c00000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff7001f00000000),
         UINT64_C(0x3ff4402f00000000),
         UINT64_C(0x3ff1400f00000000),
         UINT64_C(0x3ff2103300000000),
         UINT64_C(0x3ff7101300000000),
         UINT64_C(0x3ff4502300000000),
         UINT64_C(0x3ff1500300000000)},
        UINT64_C(0xfff8000000000000),
        {0xe5,0x0f,0xa4,0xe9,0xf9,0x48,0xca,0xbe,0x51,0xf7,
         0x0c,0xed,0x21,0xd1,0x67,0x0d,0xcd,0x2f,0x1a,0x78,0x00}
    },
    {
        /* No.91 delta:5665 weight:2633 */
        11213,
        33,
        26,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x7ed432ce00000000),
         UINT64_C(0x90dc3bc500000000),
         UINT64_C(0xee08090b00000000),
         UINT64_C(0xe3e6005b00000000),
         UINT64_C(0x9d32329500000000),
         UINT64_C(0x733a3b9e00000000),
         UINT64_C(0x0dee095000000000),
         UINT64_C(0x0000e9a700000000),
         UINT64_C(0x7ed4db6900000000),
         UINT64_C(0x90dcd26200000000),
         UINT64_C(0xee08e0ac00000000),
         UINT64_C(0xe3e6e9fc00000000),
         UINT64_C(0x9d32db3200000000),
         UINT64_C(0x733ad23900000000),
         UINT64_C(0x0deee0f700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x725fc00000000000),
         UINT64_C(0x084d100000000000),
         UINT64_C(0x7a12d00000000000),
         UINT64_C(0x2209800000000000),
         UINT64_C(0x5056400000000000),
         UINT64_C(0x2a44900000000000),
         UINT64_C(0x581b500000000000),
         UINT64_C(0x110ff00000000000),
         UINT64_C(0x6350300000000000),
         UINT64_C(0x1942e00000000000),
         UINT64_C(0x6b1d200000000000),
         UINT64_C(0x3306700000000000),
         UINT64_C(0x4159b00000000000),
         UINT64_C(0x3b4b600000000000),
         UINT64_C(0x4914a00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff725fc00000000),
         UINT64_C(0x3ff084d100000000),
         UINT64_C(0x3ff7a12d00000000),
         UINT64_C(0x3ff2209800000000),
         UINT64_C(0x3ff5056400000000),
         UINT64_C(0x3ff2a44900000000),
         UINT64_C(0x3ff581b500000000),
         UINT64_C(0x3ff110ff00000000),
         UINT64_C(0x3ff6350300000000),
         UINT64_C(0x3ff1942e00000000),
         UINT64_C(0x3ff6b1d200000000),
         UINT64_C(0x3ff3306700000000),
         UINT64_C(0x3ff4159b00000000),
         UINT64_C(0x3ff3b4b600000000),
         UINT64_C(0x3ff4914a00000000)},
        UINT64_C(0xfff8000000000000),
        {0xca,0x20,0x78,0x0a,0x4a,0xa1,0x2e,0xfe,0xdd,0xbd,
         0x3b,0xb8,0x22,0x7a,0xaa,0xf5,0x72,0xbf,0x91,0x33,0x00}
    },
    {
        /* No.92 delta:2629 weight:3611 */
        11213,
        9,
        7,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2896a59300000000),
         UINT64_C(0x8edd038800000000),
         UINT64_C(0xa64ba61b00000000),
         UINT64_C(0xe501005c00000000),
         UINT64_C(0xcd97a5cf00000000),
         UINT64_C(0x6bdc03d400000000),
         UINT64_C(0x434aa64700000000),
         UINT64_C(0x00005b6300000000),
         UINT64_C(0x2896fef000000000),
         UINT64_C(0x8edd58eb00000000),
         UINT64_C(0xa64bfd7800000000),
         UINT64_C(0xe5015b3f00000000),
         UINT64_C(0xcd97feac00000000),
         UINT64_C(0x6bdc58b700000000),
         UINT64_C(0x434afd2400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0003000000000000),
         UINT64_C(0x1000800000000000),
         UINT64_C(0x1003800000000000),
         UINT64_C(0x3004d00000000000),
         UINT64_C(0x3007d00000000000),
         UINT64_C(0x2004500000000000),
         UINT64_C(0x2007500000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x1000f00000000000),
         UINT64_C(0x0003700000000000),
         UINT64_C(0x0000700000000000),
         UINT64_C(0x2007200000000000),
         UINT64_C(0x2004200000000000),
         UINT64_C(0x3007a00000000000),
         UINT64_C(0x3004a00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0003000000000),
         UINT64_C(0x3ff1000800000000),
         UINT64_C(0x3ff1003800000000),
         UINT64_C(0x3ff3004d00000000),
         UINT64_C(0x3ff3007d00000000),
         UINT64_C(0x3ff2004500000000),
         UINT64_C(0x3ff2007500000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff1000f00000000),
         UINT64_C(0x3ff0003700000000),
         UINT64_C(0x3ff0000700000000),
         UINT64_C(0x3ff2007200000000),
         UINT64_C(0x3ff2004200000000),
         UINT64_C(0x3ff3007a00000000),
         UINT64_C(0x3ff3004a00000000)},
        UINT64_C(0xfff8000000000000),
        {0xde,0xed,0xad,0x41,0x8f,0xb2,0x41,0xf6,0x6e,0x7a,
         0xfd,0x0f,0xad,0x63,0x1d,0x1f,0x42,0x54,0xc4,0x5c,0x00}
    },
    {
        /* No.93 delta:3271 weight:3877 */
        11213,
        11,
        2,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x652a1b4700000000),
         UINT64_C(0x18babc4400000000),
         UINT64_C(0x7d90a70300000000),
         UINT64_C(0x9b6f005d00000000),
         UINT64_C(0xfe451b1a00000000),
         UINT64_C(0x83d5bc1900000000),
         UINT64_C(0xe6ffa75e00000000),
         UINT64_C(0x0000ea9700000000),
         UINT64_C(0x652af1d000000000),
         UINT64_C(0x18ba56d300000000),
         UINT64_C(0x7d904d9400000000),
         UINT64_C(0x9b6feaca00000000),
         UINT64_C(0xfe45f18d00000000),
         UINT64_C(0x83d5568e00000000),
         UINT64_C(0xe6ff4dc900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0030800000000000),
         UINT64_C(0x0101c00000000000),
         UINT64_C(0x0131400000000000),
         UINT64_C(0x0060c00000000000),
         UINT64_C(0x0050400000000000),
         UINT64_C(0x0161000000000000),
         UINT64_C(0x0151800000000000),
         UINT64_C(0x302ff00000000000),
         UINT64_C(0x301f700000000000),
         UINT64_C(0x312e300000000000),
         UINT64_C(0x311eb00000000000),
         UINT64_C(0x304f300000000000),
         UINT64_C(0x307fb00000000000),
         UINT64_C(0x314ef00000000000),
         UINT64_C(0x317e700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0030800000000),
         UINT64_C(0x3ff0101c00000000),
         UINT64_C(0x3ff0131400000000),
         UINT64_C(0x3ff0060c00000000),
         UINT64_C(0x3ff0050400000000),
         UINT64_C(0x3ff0161000000000),
         UINT64_C(0x3ff0151800000000),
         UINT64_C(0x3ff302ff00000000),
         UINT64_C(0x3ff301f700000000),
         UINT64_C(0x3ff312e300000000),
         UINT64_C(0x3ff311eb00000000),
         UINT64_C(0x3ff304f300000000),
         UINT64_C(0x3ff307fb00000000),
         UINT64_C(0x3ff314ef00000000),
         UINT64_C(0x3ff317e700000000)},
        UINT64_C(0xfff8000000000000),
        {0x7e,0x9f,0x22,0xc7,0x0e,0x02,0x18,0x3e,0x13,0x75,
         0x3d,0xcf,0x1b,0xb9,0xde,0xa5,0x2a,0xe9,0x4b,0x11,0x00}
    },
    {
        /* No.94 delta:2540 weight:3135 */
        11213,
        20,
        5,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x09ac17a500000000),
         UINT64_C(0x6f33da8100000000),
         UINT64_C(0x669fcd2400000000),
         UINT64_C(0xb02a005e00000000),
         UINT64_C(0xb98617fb00000000),
         UINT64_C(0xdf19dadf00000000),
         UINT64_C(0xd6b5cd7a00000000),
         UINT64_C(0x0000fb0900000000),
         UINT64_C(0x09acecac00000000),
         UINT64_C(0x6f33218800000000),
         UINT64_C(0x669f362d00000000),
         UINT64_C(0xb02afb5700000000),
         UINT64_C(0xb986ecf200000000),
         UINT64_C(0xdf1921d600000000),
         UINT64_C(0xd6b5367300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0808400000000000),
         UINT64_C(0x6020000000000000),
         UINT64_C(0x6828400000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0808400000000000),
         UINT64_C(0x6020000000000000),
         UINT64_C(0x6828400000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x080bb00000000000),
         UINT64_C(0x6023f00000000000),
         UINT64_C(0x682bb00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x080bb00000000000),
         UINT64_C(0x6023f00000000000),
         UINT64_C(0x682bb00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0808400000000),
         UINT64_C(0x3ff6020000000000),
         UINT64_C(0x3ff6828400000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0808400000000),
         UINT64_C(0x3ff6020000000000),
         UINT64_C(0x3ff6828400000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff080bb00000000),
         UINT64_C(0x3ff6023f00000000),
         UINT64_C(0x3ff682bb00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff080bb00000000),
         UINT64_C(0x3ff6023f00000000),
         UINT64_C(0x3ff682bb00000000)},
        UINT64_C(0xfff8000000000000),
        {0xb0,0x6e,0xe7,0x30,0xeb,0x77,0x57,0xd4,0x79,0xad,
         0x89,0x0d,0x8d,0xb6,0x4b,0x97,0x2f,0x4c,0x75,0xe2,0x00}
    },
    {
        /* No.95 delta:2688 weight:2005 */
        11213,
        30,
        3,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6a29fa6c00000000),
         UINT64_C(0xed04edc700000000),
         UINT64_C(0x872d17ab00000000),
         UINT64_C(0x849d005f00000000),
         UINT64_C(0xeeb4fa3300000000),
         UINT64_C(0x6999ed9800000000),
         UINT64_C(0x03b017f400000000),
         UINT64_C(0x0000956600000000),
         UINT64_C(0x6a296f0a00000000),
         UINT64_C(0xed0478a100000000),
         UINT64_C(0x872d82cd00000000),
         UINT64_C(0x849d953900000000),
         UINT64_C(0xeeb46f5500000000),
         UINT64_C(0x699978fe00000000),
         UINT64_C(0x03b0829200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0844800000000000),
         UINT64_C(0x0018100000000000),
         UINT64_C(0x085c900000000000),
         UINT64_C(0x4003a00000000000),
         UINT64_C(0x4847200000000000),
         UINT64_C(0x401bb00000000000),
         UINT64_C(0x485f300000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x4847700000000000),
         UINT64_C(0x401be00000000000),
         UINT64_C(0x485f600000000000),
         UINT64_C(0x0000500000000000),
         UINT64_C(0x0844d00000000000),
         UINT64_C(0x0018400000000000),
         UINT64_C(0x085cc00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0844800000000),
         UINT64_C(0x3ff0018100000000),
         UINT64_C(0x3ff085c900000000),
         UINT64_C(0x3ff4003a00000000),
         UINT64_C(0x3ff4847200000000),
         UINT64_C(0x3ff401bb00000000),
         UINT64_C(0x3ff485f300000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff4847700000000),
         UINT64_C(0x3ff401be00000000),
         UINT64_C(0x3ff485f600000000),
         UINT64_C(0x3ff0000500000000),
         UINT64_C(0x3ff0844d00000000),
         UINT64_C(0x3ff0018400000000),
         UINT64_C(0x3ff085cc00000000)},
        UINT64_C(0xfff8000000000000),
        {0xd1,0x55,0x88,0xfa,0xba,0x16,0x07,0xd9,0x55,0xe3,
         0xb2,0x4e,0x44,0xb2,0xfa,0xed,0xf3,0xda,0x50,0x02,0x00}
    },
    {
        /* No.96 delta:2531 weight:2971 */
        11213,
        15,
        5,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe74a82dc00000000),
         UINT64_C(0x8b5eb9fd00000000),
         UINT64_C(0x6c143b2100000000),
         UINT64_C(0x5b5c006000000000),
         UINT64_C(0xbc1682bc00000000),
         UINT64_C(0xd002b99d00000000),
         UINT64_C(0x37483b4100000000),
         UINT64_C(0x00003dd100000000),
         UINT64_C(0xe74abf0d00000000),
         UINT64_C(0x8b5e842c00000000),
         UINT64_C(0x6c1406f000000000),
         UINT64_C(0x5b5c3db100000000),
         UINT64_C(0xbc16bf6d00000000),
         UINT64_C(0xd002844c00000000),
         UINT64_C(0x3748069000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1022000000000000),
         UINT64_C(0x0000100000000000),
         UINT64_C(0x1022100000000000),
         UINT64_C(0x0002000000000000),
         UINT64_C(0x1020000000000000),
         UINT64_C(0x0002100000000000),
         UINT64_C(0x1020100000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x0021f00000000000),
         UINT64_C(0x1003e00000000000),
         UINT64_C(0x0021e00000000000),
         UINT64_C(0x1001f00000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x1001e00000000000),
         UINT64_C(0x0023e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1022000000000),
         UINT64_C(0x3ff0000100000000),
         UINT64_C(0x3ff1022100000000),
         UINT64_C(0x3ff0002000000000),
         UINT64_C(0x3ff1020000000000),
         UINT64_C(0x3ff0002100000000),
         UINT64_C(0x3ff1020100000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff0021f00000000),
         UINT64_C(0x3ff1003e00000000),
         UINT64_C(0x3ff0021e00000000),
         UINT64_C(0x3ff1001f00000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff1001e00000000),
         UINT64_C(0x3ff0023e00000000)},
        UINT64_C(0xfff8000000000000),
        {0x8b,0x7e,0x49,0x90,0x19,0x8b,0xed,0x9c,0xfd,0xaf,
         0x81,0x2d,0xdd,0xf9,0x8a,0xcb,0xaf,0xc7,0xa3,0x91,0x00}
    },
    {
        /* No.97 delta:2114 weight:3457 */
        11213,
        25,
        10,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x46a8e4c500000000),
         UINT64_C(0x47357f4800000000),
         UINT64_C(0x019d9b8d00000000),
         UINT64_C(0x1b3d006100000000),
         UINT64_C(0x5d95e4a400000000),
         UINT64_C(0x5c087f2900000000),
         UINT64_C(0x1aa09bec00000000),
         UINT64_C(0x0000494000000000),
         UINT64_C(0x46a8ad8500000000),
         UINT64_C(0x4735360800000000),
         UINT64_C(0x019dd2cd00000000),
         UINT64_C(0x1b3d492100000000),
         UINT64_C(0x5d95ade400000000),
         UINT64_C(0x5c08366900000000),
         UINT64_C(0x1aa0d2ac00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe003700000000000),
         UINT64_C(0x0002000000000000),
         UINT64_C(0xe001700000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0xf003700000000000),
         UINT64_C(0x1002000000000000),
         UINT64_C(0xf001700000000000),
         UINT64_C(0x4043f00000000000),
         UINT64_C(0xa040800000000000),
         UINT64_C(0x4041f00000000000),
         UINT64_C(0xa042800000000000),
         UINT64_C(0x5043f00000000000),
         UINT64_C(0xb040800000000000),
         UINT64_C(0x5041f00000000000),
         UINT64_C(0xb042800000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffe003700000000),
         UINT64_C(0x3ff0002000000000),
         UINT64_C(0x3ffe001700000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3fff003700000000),
         UINT64_C(0x3ff1002000000000),
         UINT64_C(0x3fff001700000000),
         UINT64_C(0x3ff4043f00000000),
         UINT64_C(0x3ffa040800000000),
         UINT64_C(0x3ff4041f00000000),
         UINT64_C(0x3ffa042800000000),
         UINT64_C(0x3ff5043f00000000),
         UINT64_C(0x3ffb040800000000),
         UINT64_C(0x3ff5041f00000000),
         UINT64_C(0x3ffb042800000000)},
        UINT64_C(0xfff8000000000000),
        {0xc9,0x99,0xe9,0x9c,0x7f,0x1e,0x65,0xc1,0xe7,0x25,
         0x40,0x32,0x71,0xd5,0x8e,0x1a,0xf4,0x66,0xbd,0x67,0x00}
    },
    {
        /* No.98 delta:2786 weight:3401 */
        11213,
        20,
        2,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3ef7418e00000000),
         UINT64_C(0x6b1556ab00000000),
         UINT64_C(0x55e2172500000000),
         UINT64_C(0xfc9a006200000000),
         UINT64_C(0xc26d41ec00000000),
         UINT64_C(0x978f56c900000000),
         UINT64_C(0xa978174700000000),
         UINT64_C(0x0000b95d00000000),
         UINT64_C(0x3ef7f8d300000000),
         UINT64_C(0x6b15eff600000000),
         UINT64_C(0x55e2ae7800000000),
         UINT64_C(0xfc9ab93f00000000),
         UINT64_C(0xc26df8b100000000),
         UINT64_C(0x978fef9400000000),
         UINT64_C(0xa978ae1a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0029800000000000),
         UINT64_C(0x004d200000000000),
         UINT64_C(0x0064a00000000000),
         UINT64_C(0x6002e00000000000),
         UINT64_C(0x602b600000000000),
         UINT64_C(0x604fc00000000000),
         UINT64_C(0x6066400000000000),
         UINT64_C(0x100bf00000000000),
         UINT64_C(0x1022700000000000),
         UINT64_C(0x1046d00000000000),
         UINT64_C(0x106f500000000000),
         UINT64_C(0x7009100000000000),
         UINT64_C(0x7020900000000000),
         UINT64_C(0x7044300000000000),
         UINT64_C(0x706db00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0029800000000),
         UINT64_C(0x3ff004d200000000),
         UINT64_C(0x3ff0064a00000000),
         UINT64_C(0x3ff6002e00000000),
         UINT64_C(0x3ff602b600000000),
         UINT64_C(0x3ff604fc00000000),
         UINT64_C(0x3ff6066400000000),
         UINT64_C(0x3ff100bf00000000),
         UINT64_C(0x3ff1022700000000),
         UINT64_C(0x3ff1046d00000000),
         UINT64_C(0x3ff106f500000000),
         UINT64_C(0x3ff7009100000000),
         UINT64_C(0x3ff7020900000000),
         UINT64_C(0x3ff7044300000000),
         UINT64_C(0x3ff706db00000000)},
        UINT64_C(0xfff8000000000000),
        {0x16,0x25,0x03,0x09,0xe5,0x5d,0x5a,0xbb,0x37,0x84,
         0x48,0x15,0x21,0x90,0x72,0x16,0xaf,0x9c,0xc1,0xbc,0x00}
    },
    {
        /* No.99 delta:3373 weight:3497 */
        11213,
        18,
        5,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2586fd9600000000),
         UINT64_C(0x4cc0efe500000000),
         UINT64_C(0x6946127300000000),
         UINT64_C(0xafae006300000000),
         UINT64_C(0x8a28fdf500000000),
         UINT64_C(0xe36eef8600000000),
         UINT64_C(0xc6e8121000000000),
         UINT64_C(0x0000c15b00000000),
         UINT64_C(0x25863ccd00000000),
         UINT64_C(0x4cc02ebe00000000),
         UINT64_C(0x6946d32800000000),
         UINT64_C(0xafaec13800000000),
         UINT64_C(0x8a283cae00000000),
         UINT64_C(0xe36e2edd00000000),
         UINT64_C(0xc6e8d34b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0080000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0080000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0080000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0080000000000000),
         UINT64_C(0xa003f00000000000),
         UINT64_C(0xa083f00000000000),
         UINT64_C(0xa003f00000000000),
         UINT64_C(0xa083f00000000000),
         UINT64_C(0xa003f00000000000),
         UINT64_C(0xa083f00000000000),
         UINT64_C(0xa003f00000000000),
         UINT64_C(0xa083f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0080000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0080000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0080000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0080000000000),
         UINT64_C(0x3ffa003f00000000),
         UINT64_C(0x3ffa083f00000000),
         UINT64_C(0x3ffa003f00000000),
         UINT64_C(0x3ffa083f00000000),
         UINT64_C(0x3ffa003f00000000),
         UINT64_C(0x3ffa083f00000000),
         UINT64_C(0x3ffa003f00000000),
         UINT64_C(0x3ffa083f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x65,0x97,0x46,0xef,0xff,0x59,0x8c,0x2c,0xd9,0x35,
         0xd6,0x0c,0x16,0x15,0x7d,0x3b,0x83,0xe2,0x59,0x07,0x00}
    },
    {
        /* No.100 delta:2428 weight:2639 */
        11213,
        35,
        5,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xba3ee3d700000000),
         UINT64_C(0x5015d99000000000),
         UINT64_C(0xea2b3a4700000000),
         UINT64_C(0xacb6006400000000),
         UINT64_C(0x1688e3b300000000),
         UINT64_C(0xfca3d9f400000000),
         UINT64_C(0x469d3a2300000000),
         UINT64_C(0x0000e3b000000000),
         UINT64_C(0xba3e006700000000),
         UINT64_C(0x50153a2000000000),
         UINT64_C(0xea2bd9f700000000),
         UINT64_C(0xacb6e3d400000000),
         UINT64_C(0x1688000300000000),
         UINT64_C(0xfca33a4400000000),
         UINT64_C(0x469dd99300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8010600000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x8010600000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0xb010600000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0xb010600000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x8033900000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x8033900000000000),
         UINT64_C(0x3023f00000000000),
         UINT64_C(0xb033900000000000),
         UINT64_C(0x3023f00000000000),
         UINT64_C(0xb033900000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff8010600000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff8010600000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ffb010600000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ffb010600000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff8033900000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff8033900000000),
         UINT64_C(0x3ff3023f00000000),
         UINT64_C(0x3ffb033900000000),
         UINT64_C(0x3ff3023f00000000),
         UINT64_C(0x3ffb033900000000)},
        UINT64_C(0xfff8000000000000),
        {0xe0,0x4d,0x5d,0x3e,0x7d,0x70,0xde,0x13,0xf4,0x07,
         0xbb,0xbc,0x8b,0xac,0x6c,0x41,0xba,0x34,0x40,0x3b,0x00}
    },
    {
        /* No.101 delta:6756 weight:2179 */
        11213,
        4,
        20,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xd5e65a0700000000),
         UINT64_C(0xd0d47f9c00000000),
         UINT64_C(0x0532259b00000000),
         UINT64_C(0x860a006500000000),
         UINT64_C(0x53ec5a6200000000),
         UINT64_C(0x56de7ff900000000),
         UINT64_C(0x833825fe00000000),
         UINT64_C(0x00003a1700000000),
         UINT64_C(0xd5e6601000000000),
         UINT64_C(0xd0d4458b00000000),
         UINT64_C(0x05321f8c00000000),
         UINT64_C(0x860a3a7200000000),
         UINT64_C(0x53ec607500000000),
         UINT64_C(0x56de45ee00000000),
         UINT64_C(0x83381fe900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0fe4000000000000),
         UINT64_C(0xcbc1800000000000),
         UINT64_C(0xc425800000000000),
         UINT64_C(0x004d800000000000),
         UINT64_C(0x0fa9800000000000),
         UINT64_C(0xcb8c000000000000),
         UINT64_C(0xc468000000000000),
         UINT64_C(0x1243f00000000000),
         UINT64_C(0x1da7f00000000000),
         UINT64_C(0xd982700000000000),
         UINT64_C(0xd666700000000000),
         UINT64_C(0x120e700000000000),
         UINT64_C(0x1dea700000000000),
         UINT64_C(0xd9cff00000000000),
         UINT64_C(0xd62bf00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0fe4000000000),
         UINT64_C(0x3ffcbc1800000000),
         UINT64_C(0x3ffc425800000000),
         UINT64_C(0x3ff004d800000000),
         UINT64_C(0x3ff0fa9800000000),
         UINT64_C(0x3ffcb8c000000000),
         UINT64_C(0x3ffc468000000000),
         UINT64_C(0x3ff1243f00000000),
         UINT64_C(0x3ff1da7f00000000),
         UINT64_C(0x3ffd982700000000),
         UINT64_C(0x3ffd666700000000),
         UINT64_C(0x3ff120e700000000),
         UINT64_C(0x3ff1dea700000000),
         UINT64_C(0x3ffd9cff00000000),
         UINT64_C(0x3ffd62bf00000000)},
        UINT64_C(0xfff8000000000000),
        {0x8c,0x0c,0xb1,0x5a,0x62,0xbb,0x29,0xb5,0xea,0xce,
         0xef,0x0b,0xf3,0xab,0x58,0xbd,0x28,0xa8,0xed,0xcd,0x00}
    },
    {
        /* No.102 delta:2517 weight:2997 */
        11213,
        40,
        28,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x959bbc2b00000000),
         UINT64_C(0x4159cdc400000000),
         UINT64_C(0xd4c271ef00000000),
         UINT64_C(0x1856006600000000),
         UINT64_C(0x8dcdbc4d00000000),
         UINT64_C(0x590fcda200000000),
         UINT64_C(0xcc94718900000000),
         UINT64_C(0x000064ba00000000),
         UINT64_C(0x959bd89100000000),
         UINT64_C(0x4159a97e00000000),
         UINT64_C(0xd4c2155500000000),
         UINT64_C(0x185664dc00000000),
         UINT64_C(0x8dcdd8f700000000),
         UINT64_C(0x590fa91800000000),
         UINT64_C(0xcc94153300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x380b700000000000),
         UINT64_C(0xa028000000000000),
         UINT64_C(0x9823700000000000),
         UINT64_C(0x5006800000000000),
         UINT64_C(0x680df00000000000),
         UINT64_C(0xf02e800000000000),
         UINT64_C(0xc825f00000000000),
         UINT64_C(0x7027f00000000000),
         UINT64_C(0x482c800000000000),
         UINT64_C(0xd00ff00000000000),
         UINT64_C(0xe804800000000000),
         UINT64_C(0x2021700000000000),
         UINT64_C(0x182a000000000000),
         UINT64_C(0x8009700000000000),
         UINT64_C(0xb802000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff380b700000000),
         UINT64_C(0x3ffa028000000000),
         UINT64_C(0x3ff9823700000000),
         UINT64_C(0x3ff5006800000000),
         UINT64_C(0x3ff680df00000000),
         UINT64_C(0x3fff02e800000000),
         UINT64_C(0x3ffc825f00000000),
         UINT64_C(0x3ff7027f00000000),
         UINT64_C(0x3ff482c800000000),
         UINT64_C(0x3ffd00ff00000000),
         UINT64_C(0x3ffe804800000000),
         UINT64_C(0x3ff2021700000000),
         UINT64_C(0x3ff182a000000000),
         UINT64_C(0x3ff8009700000000),
         UINT64_C(0x3ffb802000000000)},
        UINT64_C(0xfff8000000000000),
        {0xf4,0xeb,0x2a,0x87,0xc7,0xdd,0x50,0xa9,0xc2,0xfc,
         0xb6,0xd2,0xcc,0x33,0x82,0x8f,0x0d,0xc6,0x2f,0x18,0x00}
    },
    {
        /* No.103 delta:2431 weight:3791 */
        11213,
        34,
        2,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xec50595200000000),
         UINT64_C(0x8a0385a500000000),
         UINT64_C(0x6653dcf700000000),
         UINT64_C(0x1e67006700000000),
         UINT64_C(0xf237593500000000),
         UINT64_C(0x946485c200000000),
         UINT64_C(0x7834dc9000000000),
         UINT64_C(0x000054f500000000),
         UINT64_C(0xec500da700000000),
         UINT64_C(0x8a03d15000000000),
         UINT64_C(0x6653880200000000),
         UINT64_C(0x1e67549200000000),
         UINT64_C(0xf2370dc000000000),
         UINT64_C(0x9464d13700000000),
         UINT64_C(0x7834886500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x08e0e00000000000),
         UINT64_C(0x02ad100000000000),
         UINT64_C(0x0a4df00000000000),
         UINT64_C(0x0043400000000000),
         UINT64_C(0x08a3a00000000000),
         UINT64_C(0x02ee500000000000),
         UINT64_C(0x0a0eb00000000000),
         UINT64_C(0x0053f00000000000),
         UINT64_C(0x08b3100000000000),
         UINT64_C(0x02fee00000000000),
         UINT64_C(0x0a1e000000000000),
         UINT64_C(0x0010b00000000000),
         UINT64_C(0x08f0500000000000),
         UINT64_C(0x02bda00000000000),
         UINT64_C(0x0a5d400000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff08e0e00000000),
         UINT64_C(0x3ff02ad100000000),
         UINT64_C(0x3ff0a4df00000000),
         UINT64_C(0x3ff0043400000000),
         UINT64_C(0x3ff08a3a00000000),
         UINT64_C(0x3ff02ee500000000),
         UINT64_C(0x3ff0a0eb00000000),
         UINT64_C(0x3ff0053f00000000),
         UINT64_C(0x3ff08b3100000000),
         UINT64_C(0x3ff02fee00000000),
         UINT64_C(0x3ff0a1e000000000),
         UINT64_C(0x3ff0010b00000000),
         UINT64_C(0x3ff08f0500000000),
         UINT64_C(0x3ff02bda00000000),
         UINT64_C(0x3ff0a5d400000000)},
        UINT64_C(0xfff8000000000000),
        {0x83,0x4e,0x12,0x9f,0x91,0x43,0xae,0x28,0x40,0x59,
         0xee,0x8c,0x4d,0xc1,0x35,0x3b,0x3a,0xd3,0xf1,0x3c,0x00}
    },
    {
        /* No.104 delta:2273 weight:3479 */
        11213,
        22,
        9,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc0545c7300000000),
         UINT64_C(0x2de513fe00000000),
         UINT64_C(0xedb14f8d00000000),
         UINT64_C(0x046e006800000000),
         UINT64_C(0xc43a5c1b00000000),
         UINT64_C(0x298b139600000000),
         UINT64_C(0xe9df4fe500000000),
         UINT64_C(0x0000ce5700000000),
         UINT64_C(0xc054922400000000),
         UINT64_C(0x2de5dda900000000),
         UINT64_C(0xedb181da00000000),
         UINT64_C(0x046ece3f00000000),
         UINT64_C(0xc43a924c00000000),
         UINT64_C(0x298bddc100000000),
         UINT64_C(0xe9df81b200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0002000000000000),
         UINT64_C(0x2040000000000000),
         UINT64_C(0x2042000000000000),
         UINT64_C(0x0000800000000000),
         UINT64_C(0x0002800000000000),
         UINT64_C(0x2040800000000000),
         UINT64_C(0x2042800000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x1001f00000000000),
         UINT64_C(0x3043f00000000000),
         UINT64_C(0x3041f00000000000),
         UINT64_C(0x1003700000000000),
         UINT64_C(0x1001700000000000),
         UINT64_C(0x3043700000000000),
         UINT64_C(0x3041700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0002000000000),
         UINT64_C(0x3ff2040000000000),
         UINT64_C(0x3ff2042000000000),
         UINT64_C(0x3ff0000800000000),
         UINT64_C(0x3ff0002800000000),
         UINT64_C(0x3ff2040800000000),
         UINT64_C(0x3ff2042800000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff1001f00000000),
         UINT64_C(0x3ff3043f00000000),
         UINT64_C(0x3ff3041f00000000),
         UINT64_C(0x3ff1003700000000),
         UINT64_C(0x3ff1001700000000),
         UINT64_C(0x3ff3043700000000),
         UINT64_C(0x3ff3041700000000)},
        UINT64_C(0xfff8000000000000),
        {0x3d,0x66,0xab,0x7a,0xc6,0x78,0xd9,0x50,0x68,0xdb,
         0x91,0xd1,0x06,0x76,0x9a,0xcd,0xd2,0xab,0x19,0x29,0x00}
    },
    {
        /* No.105 delta:2281 weight:1589 */
        11213,
        36,
        6,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8df9e72900000000),
         UINT64_C(0xa7624c7700000000),
         UINT64_C(0x2a9bab5e00000000),
         UINT64_C(0xbba6006900000000),
         UINT64_C(0x365fe74000000000),
         UINT64_C(0x1cc44c1e00000000),
         UINT64_C(0x913dab3700000000),
         UINT64_C(0x00001bbf00000000),
         UINT64_C(0x8df9fc9600000000),
         UINT64_C(0xa76257c800000000),
         UINT64_C(0x2a9bb0e100000000),
         UINT64_C(0xbba61bd600000000),
         UINT64_C(0x365ffcff00000000),
         UINT64_C(0x1cc457a100000000),
         UINT64_C(0x913db08800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0058800000000000),
         UINT64_C(0x4082000000000000),
         UINT64_C(0x40da800000000000),
         UINT64_C(0x0002a00000000000),
         UINT64_C(0x005a200000000000),
         UINT64_C(0x4080a00000000000),
         UINT64_C(0x40d8200000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x005b700000000000),
         UINT64_C(0x4081f00000000000),
         UINT64_C(0x40d9700000000000),
         UINT64_C(0x0001500000000000),
         UINT64_C(0x0059d00000000000),
         UINT64_C(0x4083500000000000),
         UINT64_C(0x40dbd00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0058800000000),
         UINT64_C(0x3ff4082000000000),
         UINT64_C(0x3ff40da800000000),
         UINT64_C(0x3ff0002a00000000),
         UINT64_C(0x3ff005a200000000),
         UINT64_C(0x3ff4080a00000000),
         UINT64_C(0x3ff40d8200000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff005b700000000),
         UINT64_C(0x3ff4081f00000000),
         UINT64_C(0x3ff40d9700000000),
         UINT64_C(0x3ff0001500000000),
         UINT64_C(0x3ff0059d00000000),
         UINT64_C(0x3ff4083500000000),
         UINT64_C(0x3ff40dbd00000000)},
        UINT64_C(0xfff8000000000000),
        {0xea,0x0a,0x8c,0xaa,0x3b,0x76,0xc8,0x57,0x84,0x0d,
         0xc7,0xbb,0xf3,0x04,0x52,0xe1,0xeb,0x2a,0x67,0x80,0x00}
    },
    {
        /* No.106 delta:3405 weight:3107 */
        11213,
        15,
        12,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x123d293900000000),
         UINT64_C(0xa050890400000000),
         UINT64_C(0xb26da03d00000000),
         UINT64_C(0x3359006a00000000),
         UINT64_C(0x2164295300000000),
         UINT64_C(0x9309896e00000000),
         UINT64_C(0x8134a05700000000),
         UINT64_C(0x0000012400000000),
         UINT64_C(0x123d281d00000000),
         UINT64_C(0xa050882000000000),
         UINT64_C(0xb26da11900000000),
         UINT64_C(0x3359014e00000000),
         UINT64_C(0x2164287700000000),
         UINT64_C(0x9309884a00000000),
         UINT64_C(0x8134a17300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x140b400000000000),
         UINT64_C(0x4002900000000000),
         UINT64_C(0x5409d00000000000),
         UINT64_C(0x500a000000000000),
         UINT64_C(0x4401400000000000),
         UINT64_C(0x1008900000000000),
         UINT64_C(0x0403d00000000000),
         UINT64_C(0x7403f00000000000),
         UINT64_C(0x6008b00000000000),
         UINT64_C(0x3401600000000000),
         UINT64_C(0x200a200000000000),
         UINT64_C(0x2409f00000000000),
         UINT64_C(0x3002b00000000000),
         UINT64_C(0x640b600000000000),
         UINT64_C(0x7000200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff140b400000000),
         UINT64_C(0x3ff4002900000000),
         UINT64_C(0x3ff5409d00000000),
         UINT64_C(0x3ff500a000000000),
         UINT64_C(0x3ff4401400000000),
         UINT64_C(0x3ff1008900000000),
         UINT64_C(0x3ff0403d00000000),
         UINT64_C(0x3ff7403f00000000),
         UINT64_C(0x3ff6008b00000000),
         UINT64_C(0x3ff3401600000000),
         UINT64_C(0x3ff200a200000000),
         UINT64_C(0x3ff2409f00000000),
         UINT64_C(0x3ff3002b00000000),
         UINT64_C(0x3ff640b600000000),
         UINT64_C(0x3ff7000200000000)},
        UINT64_C(0xfff8000000000000),
        {0xab,0xf7,0x86,0xaa,0x12,0x85,0x52,0xb2,0x5c,0xeb,
         0x46,0xa5,0x12,0x2e,0xaf,0xf8,0xb2,0x9e,0xaf,0x5c,0x00}
    },
    {
        /* No.107 delta:2490 weight:3373 */
        11213,
        43,
        20,
        12,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xca31108700000000),
         UINT64_C(0xaea85f8a00000000),
         UINT64_C(0x64994f0d00000000),
         UINT64_C(0x1ff3006b00000000),
         UINT64_C(0xd5c210ec00000000),
         UINT64_C(0xb15b5fe100000000),
         UINT64_C(0x7b6a4f6600000000),
         UINT64_C(0x0000321e00000000),
         UINT64_C(0xca31229900000000),
         UINT64_C(0xaea86d9400000000),
         UINT64_C(0x64997d1300000000),
         UINT64_C(0x1ff3327500000000),
         UINT64_C(0xd5c222f200000000),
         UINT64_C(0xb15b6dff00000000),
         UINT64_C(0x7b6a7d7800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0102000000000000),
         UINT64_C(0xa000000000000000),
         UINT64_C(0xa102000000000000),
         UINT64_C(0x6100000000000000),
         UINT64_C(0x6002000000000000),
         UINT64_C(0xc100000000000000),
         UINT64_C(0xc002000000000000),
         UINT64_C(0x9003f00000000000),
         UINT64_C(0x9101f00000000000),
         UINT64_C(0x3003f00000000000),
         UINT64_C(0x3101f00000000000),
         UINT64_C(0xf103f00000000000),
         UINT64_C(0xf001f00000000000),
         UINT64_C(0x5103f00000000000),
         UINT64_C(0x5001f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0102000000000),
         UINT64_C(0x3ffa000000000000),
         UINT64_C(0x3ffa102000000000),
         UINT64_C(0x3ff6100000000000),
         UINT64_C(0x3ff6002000000000),
         UINT64_C(0x3ffc100000000000),
         UINT64_C(0x3ffc002000000000),
         UINT64_C(0x3ff9003f00000000),
         UINT64_C(0x3ff9101f00000000),
         UINT64_C(0x3ff3003f00000000),
         UINT64_C(0x3ff3101f00000000),
         UINT64_C(0x3fff103f00000000),
         UINT64_C(0x3fff001f00000000),
         UINT64_C(0x3ff5103f00000000),
         UINT64_C(0x3ff5001f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x72,0xb2,0xb6,0xa2,0xf3,0xd2,0x7d,0xa5,0xa8,0xe8,
         0x5c,0xc8,0xe5,0x58,0xe0,0x4e,0x4a,0xd9,0xa8,0x90,0x00}
    },
    {
        /* No.108 delta:2246 weight:2989 */
        11213,
        35,
        7,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x991cb35c00000000),
         UINT64_C(0x37aad34b00000000),
         UINT64_C(0xaeb6601700000000),
         UINT64_C(0xd70b006c00000000),
         UINT64_C(0x4e17b33000000000),
         UINT64_C(0xe0a1d32700000000),
         UINT64_C(0x79bd607b00000000),
         UINT64_C(0x0000163600000000),
         UINT64_C(0x991ca56a00000000),
         UINT64_C(0x37aac57d00000000),
         UINT64_C(0xaeb6762100000000),
         UINT64_C(0xd70b165a00000000),
         UINT64_C(0x4e17a50600000000),
         UINT64_C(0xe0a1c51100000000),
         UINT64_C(0x79bd764d00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x6008000000000000),
         UINT64_C(0x7008000000000000),
         UINT64_C(0x9000000000000000),
         UINT64_C(0x8000000000000000),
         UINT64_C(0xf008000000000000),
         UINT64_C(0xe008000000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x700bf00000000000),
         UINT64_C(0x600bf00000000000),
         UINT64_C(0x8003f00000000000),
         UINT64_C(0x9003f00000000000),
         UINT64_C(0xe00bf00000000000),
         UINT64_C(0xf00bf00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff6008000000000),
         UINT64_C(0x3ff7008000000000),
         UINT64_C(0x3ff9000000000000),
         UINT64_C(0x3ff8000000000000),
         UINT64_C(0x3fff008000000000),
         UINT64_C(0x3ffe008000000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff700bf00000000),
         UINT64_C(0x3ff600bf00000000),
         UINT64_C(0x3ff8003f00000000),
         UINT64_C(0x3ff9003f00000000),
         UINT64_C(0x3ffe00bf00000000),
         UINT64_C(0x3fff00bf00000000)},
        UINT64_C(0xfff8000000000000),
        {0x2d,0xc0,0xf9,0x04,0x6d,0x3e,0x06,0x88,0x61,0xc8,
         0x38,0x13,0x28,0x91,0x7f,0x2e,0xaa,0x91,0xac,0xb6,0x00}
    },
    {
        /* No.109 delta:2756 weight:2839 */
        11213,
        4,
        10,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xaa82204100000000),
         UINT64_C(0x6a7c0eea00000000),
         UINT64_C(0xc0fe2eab00000000),
         UINT64_C(0x0dfb006d00000000),
         UINT64_C(0xa779202c00000000),
         UINT64_C(0x67870e8700000000),
         UINT64_C(0xcd052ec600000000),
         UINT64_C(0x00008b8700000000),
         UINT64_C(0xaa82abc600000000),
         UINT64_C(0x6a7c856d00000000),
         UINT64_C(0xc0fea52c00000000),
         UINT64_C(0x0dfb8bea00000000),
         UINT64_C(0xa779abab00000000),
         UINT64_C(0x6787850000000000),
         UINT64_C(0xcd05a54100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x007d400000000000),
         UINT64_C(0x80a4000000000000),
         UINT64_C(0x80d9400000000000),
         UINT64_C(0x1044000000000000),
         UINT64_C(0x1039400000000000),
         UINT64_C(0x90e0000000000000),
         UINT64_C(0x909d400000000000),
         UINT64_C(0x8003f00000000000),
         UINT64_C(0x807eb00000000000),
         UINT64_C(0x00a7f00000000000),
         UINT64_C(0x00dab00000000000),
         UINT64_C(0x9047f00000000000),
         UINT64_C(0x903ab00000000000),
         UINT64_C(0x10e3f00000000000),
         UINT64_C(0x109eb00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff007d400000000),
         UINT64_C(0x3ff80a4000000000),
         UINT64_C(0x3ff80d9400000000),
         UINT64_C(0x3ff1044000000000),
         UINT64_C(0x3ff1039400000000),
         UINT64_C(0x3ff90e0000000000),
         UINT64_C(0x3ff909d400000000),
         UINT64_C(0x3ff8003f00000000),
         UINT64_C(0x3ff807eb00000000),
         UINT64_C(0x3ff00a7f00000000),
         UINT64_C(0x3ff00dab00000000),
         UINT64_C(0x3ff9047f00000000),
         UINT64_C(0x3ff903ab00000000),
         UINT64_C(0x3ff10e3f00000000),
         UINT64_C(0x3ff109eb00000000)},
        UINT64_C(0xfff8000000000000),
        {0xea,0xd8,0x00,0xec,0xf3,0x0f,0xb4,0x0c,0x4e,0xbc,
         0x1a,0x4c,0x9d,0xc2,0x17,0x21,0x92,0x00,0x2d,0x2c,0x00}
    },
    {
        /* No.110 delta:2227 weight:3053 */
        11213,
        25,
        19,
        13,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3b4fa8ab00000000),
         UINT64_C(0xade1d69600000000),
         UINT64_C(0x96ae7e3d00000000),
         UINT64_C(0x7a00006e00000000),
         UINT64_C(0x414fa8c500000000),
         UINT64_C(0xd7e1d6f800000000),
         UINT64_C(0xecae7e5300000000),
         UINT64_C(0x0000085000000000),
         UINT64_C(0x3b4fa0fb00000000),
         UINT64_C(0xade1dec600000000),
         UINT64_C(0x96ae766d00000000),
         UINT64_C(0x7a00083e00000000),
         UINT64_C(0x414fa09500000000),
         UINT64_C(0xd7e1dea800000000),
         UINT64_C(0xecae760300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4021500000000000),
         UINT64_C(0x1000f00000000000),
         UINT64_C(0x5021a00000000000),
         UINT64_C(0x0000800000000000),
         UINT64_C(0x4021d00000000000),
         UINT64_C(0x1000700000000000),
         UINT64_C(0x5021200000000000),
         UINT64_C(0x0043f00000000000),
         UINT64_C(0x4062a00000000000),
         UINT64_C(0x1043000000000000),
         UINT64_C(0x5062500000000000),
         UINT64_C(0x0043700000000000),
         UINT64_C(0x4062200000000000),
         UINT64_C(0x1043800000000000),
         UINT64_C(0x5062d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4021500000000),
         UINT64_C(0x3ff1000f00000000),
         UINT64_C(0x3ff5021a00000000),
         UINT64_C(0x3ff0000800000000),
         UINT64_C(0x3ff4021d00000000),
         UINT64_C(0x3ff1000700000000),
         UINT64_C(0x3ff5021200000000),
         UINT64_C(0x3ff0043f00000000),
         UINT64_C(0x3ff4062a00000000),
         UINT64_C(0x3ff1043000000000),
         UINT64_C(0x3ff5062500000000),
         UINT64_C(0x3ff0043700000000),
         UINT64_C(0x3ff4062200000000),
         UINT64_C(0x3ff1043800000000),
         UINT64_C(0x3ff5062d00000000)},
        UINT64_C(0xfff8000000000000),
        {0xa7,0xd9,0x5f,0x7b,0xfd,0x31,0x36,0x28,0x42,0xe1,
         0x46,0xcf,0x5e,0x01,0xb9,0xa3,0x15,0x0b,0x7b,0xe5,0x00}
    },
    {
        /* No.111 delta:2645 weight:3885 */
        11213,
        41,
        2,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3e959dec00000000),
         UINT64_C(0x2a0b945d00000000),
         UINT64_C(0x149e09b100000000),
         UINT64_C(0x05c8006f00000000),
         UINT64_C(0x3b5d9d8300000000),
         UINT64_C(0x2fc3943200000000),
         UINT64_C(0x115609de00000000),
         UINT64_C(0x00005dec00000000),
         UINT64_C(0x3e95c00000000000),
         UINT64_C(0x2a0bc9b100000000),
         UINT64_C(0x149e545d00000000),
         UINT64_C(0x05c85d8300000000),
         UINT64_C(0x3b5dc06f00000000),
         UINT64_C(0x2fc3c9de00000000),
         UINT64_C(0x1156543200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3801000000000000),
         UINT64_C(0x0020100000000000),
         UINT64_C(0x3821100000000000),
         UINT64_C(0x0084000000000000),
         UINT64_C(0x3885000000000000),
         UINT64_C(0x00a4100000000000),
         UINT64_C(0x38a5100000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x5802f00000000000),
         UINT64_C(0x6023e00000000000),
         UINT64_C(0x5822e00000000000),
         UINT64_C(0x6087f00000000000),
         UINT64_C(0x5886f00000000000),
         UINT64_C(0x60a7e00000000000),
         UINT64_C(0x58a6e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3801000000000),
         UINT64_C(0x3ff0020100000000),
         UINT64_C(0x3ff3821100000000),
         UINT64_C(0x3ff0084000000000),
         UINT64_C(0x3ff3885000000000),
         UINT64_C(0x3ff00a4100000000),
         UINT64_C(0x3ff38a5100000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff5802f00000000),
         UINT64_C(0x3ff6023e00000000),
         UINT64_C(0x3ff5822e00000000),
         UINT64_C(0x3ff6087f00000000),
         UINT64_C(0x3ff5886f00000000),
         UINT64_C(0x3ff60a7e00000000),
         UINT64_C(0x3ff58a6e00000000)},
        UINT64_C(0xfff8000000000000),
        {0xd7,0x94,0x81,0x2c,0x20,0x5d,0x73,0x39,0xed,0xb6,
         0x20,0xfe,0x56,0x1f,0xcf,0x7f,0x51,0x33,0x34,0x58,0x00}
    },
    {
        /* No.112 delta:6127 weight:2379 */
        11213,
        19,
        17,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xab542d5800000000),
         UINT64_C(0x7189f6b100000000),
         UINT64_C(0xdadddbe900000000),
         UINT64_C(0x6369007000000000),
         UINT64_C(0xc83d2d2800000000),
         UINT64_C(0x12e0f6c100000000),
         UINT64_C(0xb9b4db9900000000),
         UINT64_C(0x0000b2b000000000),
         UINT64_C(0xab549fe800000000),
         UINT64_C(0x7189440100000000),
         UINT64_C(0xdadd695900000000),
         UINT64_C(0x6369b2c000000000),
         UINT64_C(0xc83d9f9800000000),
         UINT64_C(0x12e0447100000000),
         UINT64_C(0xb9b4692900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x41b6800000000000),
         UINT64_C(0x2918200000000000),
         UINT64_C(0x68aea00000000000),
         UINT64_C(0x4100000000000000),
         UINT64_C(0x00b6800000000000),
         UINT64_C(0x6818200000000000),
         UINT64_C(0x29aea00000000000),
         UINT64_C(0x9013f00000000000),
         UINT64_C(0xd1a5700000000000),
         UINT64_C(0xb90bd00000000000),
         UINT64_C(0xf8bd500000000000),
         UINT64_C(0xd113f00000000000),
         UINT64_C(0x90a5700000000000),
         UINT64_C(0xf80bd00000000000),
         UINT64_C(0xb9bd500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff41b6800000000),
         UINT64_C(0x3ff2918200000000),
         UINT64_C(0x3ff68aea00000000),
         UINT64_C(0x3ff4100000000000),
         UINT64_C(0x3ff00b6800000000),
         UINT64_C(0x3ff6818200000000),
         UINT64_C(0x3ff29aea00000000),
         UINT64_C(0x3ff9013f00000000),
         UINT64_C(0x3ffd1a5700000000),
         UINT64_C(0x3ffb90bd00000000),
         UINT64_C(0x3fff8bd500000000),
         UINT64_C(0x3ffd113f00000000),
         UINT64_C(0x3ff90a5700000000),
         UINT64_C(0x3fff80bd00000000),
         UINT64_C(0x3ffb9bd500000000)},
        UINT64_C(0xfff8000000000000),
        {0x6c,0x28,0xb0,0x2c,0x8b,0x79,0xc2,0xf6,0xe5,0xd2,
         0xab,0x95,0xba,0x82,0x1e,0x95,0xb5,0xcc,0x44,0x3c,0x00}
    },
    {
        /* No.113 delta:2187 weight:1803 */
        11213,
        30,
        10,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xd83b05e000000000),
         UINT64_C(0x2f501e2d00000000),
         UINT64_C(0xf76b1bcd00000000),
         UINT64_C(0x9e37007100000000),
         UINT64_C(0x460c059100000000),
         UINT64_C(0xb1671e5c00000000),
         UINT64_C(0x695c1bbc00000000),
         UINT64_C(0x00000bd600000000),
         UINT64_C(0xd83b0e3600000000),
         UINT64_C(0x2f5015fb00000000),
         UINT64_C(0xf76b101b00000000),
         UINT64_C(0x9e370ba700000000),
         UINT64_C(0x460c0e4700000000),
         UINT64_C(0xb167158a00000000),
         UINT64_C(0x695c106a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2002400000000000),
         UINT64_C(0xa004c00000000000),
         UINT64_C(0x8006800000000000),
         UINT64_C(0x0002e00000000000),
         UINT64_C(0x2000a00000000000),
         UINT64_C(0xa006200000000000),
         UINT64_C(0x8004600000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x0001b00000000000),
         UINT64_C(0x8007300000000000),
         UINT64_C(0xa005700000000000),
         UINT64_C(0x2001100000000000),
         UINT64_C(0x0003500000000000),
         UINT64_C(0x8005d00000000000),
         UINT64_C(0xa007900000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2002400000000),
         UINT64_C(0x3ffa004c00000000),
         UINT64_C(0x3ff8006800000000),
         UINT64_C(0x3ff0002e00000000),
         UINT64_C(0x3ff2000a00000000),
         UINT64_C(0x3ffa006200000000),
         UINT64_C(0x3ff8004600000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff0001b00000000),
         UINT64_C(0x3ff8007300000000),
         UINT64_C(0x3ffa005700000000),
         UINT64_C(0x3ff2001100000000),
         UINT64_C(0x3ff0003500000000),
         UINT64_C(0x3ff8005d00000000),
         UINT64_C(0x3ffa007900000000)},
        UINT64_C(0xfff8000000000000),
        {0x41,0xd5,0x1f,0x60,0x6b,0xa5,0x20,0xcb,0x27,0x91,
         0x4a,0x26,0x5b,0x92,0x95,0xcd,0x06,0x96,0xae,0x4d,0x00}
    },
    {
        /* No.114 delta:4234 weight:3141 */
        11213,
        6,
        18,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8a1af8b600000000),
         UINT64_C(0x718014ab00000000),
         UINT64_C(0xfb9aec1d00000000),
         UINT64_C(0x6202007200000000),
         UINT64_C(0xe818f8c400000000),
         UINT64_C(0x138214d900000000),
         UINT64_C(0x9998ec6f00000000),
         UINT64_C(0x00003a6a00000000),
         UINT64_C(0x8a1ac2dc00000000),
         UINT64_C(0x71802ec100000000),
         UINT64_C(0xfb9ad67700000000),
         UINT64_C(0x62023a1800000000),
         UINT64_C(0xe818c2ae00000000),
         UINT64_C(0x13822eb300000000),
         UINT64_C(0x9998d60500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0d42d00000000000),
         UINT64_C(0x0084000000000000),
         UINT64_C(0x0dc6d00000000000),
         UINT64_C(0x0240000000000000),
         UINT64_C(0x0f02d00000000000),
         UINT64_C(0x02c4000000000000),
         UINT64_C(0x0f86d00000000000),
         UINT64_C(0x603bf00000000000),
         UINT64_C(0x6d79200000000000),
         UINT64_C(0x60bff00000000000),
         UINT64_C(0x6dfd200000000000),
         UINT64_C(0x627bf00000000000),
         UINT64_C(0x6f39200000000000),
         UINT64_C(0x62fff00000000000),
         UINT64_C(0x6fbd200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0d42d00000000),
         UINT64_C(0x3ff0084000000000),
         UINT64_C(0x3ff0dc6d00000000),
         UINT64_C(0x3ff0240000000000),
         UINT64_C(0x3ff0f02d00000000),
         UINT64_C(0x3ff02c4000000000),
         UINT64_C(0x3ff0f86d00000000),
         UINT64_C(0x3ff603bf00000000),
         UINT64_C(0x3ff6d79200000000),
         UINT64_C(0x3ff60bff00000000),
         UINT64_C(0x3ff6dfd200000000),
         UINT64_C(0x3ff627bf00000000),
         UINT64_C(0x3ff6f39200000000),
         UINT64_C(0x3ff62fff00000000),
         UINT64_C(0x3ff6fbd200000000)},
        UINT64_C(0xfff8000000000000),
        {0x54,0xf6,0x3e,0x6c,0x9e,0x56,0xa8,0xbb,0xdd,0xbc,
         0x5b,0x1b,0xfc,0x66,0x0b,0x1a,0xfc,0x21,0x57,0xee,0x00}
    },
    {
        /* No.115 delta:2059 weight:3757 */
        11213,
        46,
        5,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x749df13e00000000),
         UINT64_C(0x6288b56400000000),
         UINT64_C(0x1615445a00000000),
         UINT64_C(0xc72c007300000000),
         UINT64_C(0xb3b1f14d00000000),
         UINT64_C(0xa5a4b51700000000),
         UINT64_C(0xd139442900000000),
         UINT64_C(0x0000959900000000),
         UINT64_C(0x749d64a700000000),
         UINT64_C(0x628820fd00000000),
         UINT64_C(0x1615d1c300000000),
         UINT64_C(0xc72c95ea00000000),
         UINT64_C(0xb3b164d400000000),
         UINT64_C(0xa5a4208e00000000),
         UINT64_C(0xd139d1b000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8000000000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0xd000000000000000),
         UINT64_C(0x6000000000000000),
         UINT64_C(0xe000000000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0xb000000000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x9003f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0xc003f00000000000),
         UINT64_C(0x7003f00000000000),
         UINT64_C(0xf003f00000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0xa003f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff8000000000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ffd000000000000),
         UINT64_C(0x3ff6000000000000),
         UINT64_C(0x3ffe000000000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ffb000000000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff9003f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ffc003f00000000),
         UINT64_C(0x3ff7003f00000000),
         UINT64_C(0x3fff003f00000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ffa003f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xd9,0x4f,0xf0,0xe0,0x43,0x9c,0x29,0x0b,0x6d,0x8e,
         0x61,0xe3,0x4a,0x21,0xe3,0xf6,0x95,0x6a,0xfe,0x1d,0x00}
    },
    {
        /* No.116 delta:2537 weight:3389 */
        11213,
        10,
        8,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1a1db74c00000000),
         UINT64_C(0x664ce71800000000),
         UINT64_C(0x7c51505400000000),
         UINT64_C(0x3672007400000000),
         UINT64_C(0x2c6fb73800000000),
         UINT64_C(0x503ee76c00000000),
         UINT64_C(0x4a23502000000000),
         UINT64_C(0x0000c0e700000000),
         UINT64_C(0x1a1d77ab00000000),
         UINT64_C(0x664c27ff00000000),
         UINT64_C(0x7c5190b300000000),
         UINT64_C(0x3672c09300000000),
         UINT64_C(0x2c6f77df00000000),
         UINT64_C(0x503e278b00000000),
         UINT64_C(0x4a2390c700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0002e00000000000),
         UINT64_C(0x0041c00000000000),
         UINT64_C(0x0043200000000000),
         UINT64_C(0x2040c00000000000),
         UINT64_C(0x2042200000000000),
         UINT64_C(0x2001000000000000),
         UINT64_C(0x2003e00000000000),
         UINT64_C(0x2013f00000000000),
         UINT64_C(0x2011100000000000),
         UINT64_C(0x2052300000000000),
         UINT64_C(0x2050d00000000000),
         UINT64_C(0x0053300000000000),
         UINT64_C(0x0051d00000000000),
         UINT64_C(0x0012f00000000000),
         UINT64_C(0x0010100000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0002e00000000),
         UINT64_C(0x3ff0041c00000000),
         UINT64_C(0x3ff0043200000000),
         UINT64_C(0x3ff2040c00000000),
         UINT64_C(0x3ff2042200000000),
         UINT64_C(0x3ff2001000000000),
         UINT64_C(0x3ff2003e00000000),
         UINT64_C(0x3ff2013f00000000),
         UINT64_C(0x3ff2011100000000),
         UINT64_C(0x3ff2052300000000),
         UINT64_C(0x3ff2050d00000000),
         UINT64_C(0x3ff0053300000000),
         UINT64_C(0x3ff0051d00000000),
         UINT64_C(0x3ff0012f00000000),
         UINT64_C(0x3ff0010100000000)},
        UINT64_C(0xfff8000000000000),
        {0xb4,0x04,0x49,0x68,0xc9,0x7d,0xec,0x4e,0x51,0x2b,
         0xa7,0x0c,0xb6,0x2c,0x21,0x0a,0xfd,0x3b,0xec,0x6a,0x00}
    },
    {
        /* No.117 delta:2139 weight:3441 */
        11213,
        22,
        8,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xb7444ab600000000),
         UINT64_C(0x7378a45300000000),
         UINT64_C(0xc43ceee500000000),
         UINT64_C(0x7a20007500000000),
         UINT64_C(0xcd644ac300000000),
         UINT64_C(0x0958a42600000000),
         UINT64_C(0xbe1cee9000000000),
         UINT64_C(0x0000347000000000),
         UINT64_C(0xb7447ec600000000),
         UINT64_C(0x7378902300000000),
         UINT64_C(0xc43cda9500000000),
         UINT64_C(0x7a20340500000000),
         UINT64_C(0xcd647eb300000000),
         UINT64_C(0x0958905600000000),
         UINT64_C(0xbe1cdae000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6000000000000000),
         UINT64_C(0xa000000000000000),
         UINT64_C(0xc000000000000000),
         UINT64_C(0x0002000000000000),
         UINT64_C(0x6002000000000000),
         UINT64_C(0xa002000000000000),
         UINT64_C(0xc002000000000000),
         UINT64_C(0x0403f00000000000),
         UINT64_C(0x6403f00000000000),
         UINT64_C(0xa403f00000000000),
         UINT64_C(0xc403f00000000000),
         UINT64_C(0x0401f00000000000),
         UINT64_C(0x6401f00000000000),
         UINT64_C(0xa401f00000000000),
         UINT64_C(0xc401f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff6000000000000),
         UINT64_C(0x3ffa000000000000),
         UINT64_C(0x3ffc000000000000),
         UINT64_C(0x3ff0002000000000),
         UINT64_C(0x3ff6002000000000),
         UINT64_C(0x3ffa002000000000),
         UINT64_C(0x3ffc002000000000),
         UINT64_C(0x3ff0403f00000000),
         UINT64_C(0x3ff6403f00000000),
         UINT64_C(0x3ffa403f00000000),
         UINT64_C(0x3ffc403f00000000),
         UINT64_C(0x3ff0401f00000000),
         UINT64_C(0x3ff6401f00000000),
         UINT64_C(0x3ffa401f00000000),
         UINT64_C(0x3ffc401f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x96,0xf8,0xdf,0xa7,0x51,0xd4,0xfc,0x99,0xf3,0xeb,
         0x2a,0xed,0xdc,0x0f,0x14,0x99,0xbe,0xb0,0x91,0x37,0x00}
    },
    {
        /* No.118 delta:3013 weight:3583 */
        11213,
        17,
        6,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x552aee8400000000),
         UINT64_C(0x452a5dd500000000),
         UINT64_C(0x1000b35100000000),
         UINT64_C(0x2939007600000000),
         UINT64_C(0x7c13eef200000000),
         UINT64_C(0x6c135da300000000),
         UINT64_C(0x3939b32700000000),
         UINT64_C(0x00000ea100000000),
         UINT64_C(0x552ae02500000000),
         UINT64_C(0x452a537400000000),
         UINT64_C(0x1000bdf000000000),
         UINT64_C(0x29390ed700000000),
         UINT64_C(0x7c13e05300000000),
         UINT64_C(0x6c13530200000000),
         UINT64_C(0x3939bd8600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0022600000000000),
         UINT64_C(0x0022600000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x2022600000000000),
         UINT64_C(0x2022600000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0021900000000000),
         UINT64_C(0x0021900000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x2021900000000000),
         UINT64_C(0x2021900000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0022600000000),
         UINT64_C(0x3ff0022600000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff2022600000000),
         UINT64_C(0x3ff2022600000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0021900000000),
         UINT64_C(0x3ff0021900000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff2021900000000),
         UINT64_C(0x3ff2021900000000)},
        UINT64_C(0xfff8000000000000),
        {0x11,0xba,0x51,0xab,0xc2,0xcb,0x89,0x4b,0x24,0x2b,
         0x89,0x2c,0x35,0x29,0xac,0xf1,0x34,0x1e,0x31,0x2f,0x00}
    },
    {
        /* No.119 delta:2433 weight:3939 */
        11213,
        12,
        4,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x912e360500000000),
         UINT64_C(0xc17be8a300000000),
         UINT64_C(0x5055dea600000000),
         UINT64_C(0x484f007700000000),
         UINT64_C(0xd961367200000000),
         UINT64_C(0x8934e8d400000000),
         UINT64_C(0x181aded100000000),
         UINT64_C(0x00003dd100000000),
         UINT64_C(0x912e0bd400000000),
         UINT64_C(0xc17bd57200000000),
         UINT64_C(0x5055e37700000000),
         UINT64_C(0x484f3da600000000),
         UINT64_C(0xd9610ba300000000),
         UINT64_C(0x8934d50500000000),
         UINT64_C(0x181ae30000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x8026000000000000),
         UINT64_C(0x0046900000000000),
         UINT64_C(0x8060900000000000),
         UINT64_C(0x0003600000000000),
         UINT64_C(0x8025600000000000),
         UINT64_C(0x0045f00000000000),
         UINT64_C(0x8063f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x8025f00000000000),
         UINT64_C(0x0045600000000000),
         UINT64_C(0x8063600000000000),
         UINT64_C(0x0000900000000000),
         UINT64_C(0x8026900000000000),
         UINT64_C(0x0046000000000000),
         UINT64_C(0x8060000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff8026000000000),
         UINT64_C(0x3ff0046900000000),
         UINT64_C(0x3ff8060900000000),
         UINT64_C(0x3ff0003600000000),
         UINT64_C(0x3ff8025600000000),
         UINT64_C(0x3ff0045f00000000),
         UINT64_C(0x3ff8063f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff8025f00000000),
         UINT64_C(0x3ff0045600000000),
         UINT64_C(0x3ff8063600000000),
         UINT64_C(0x3ff0000900000000),
         UINT64_C(0x3ff8026900000000),
         UINT64_C(0x3ff0046000000000),
         UINT64_C(0x3ff8060000000000)},
        UINT64_C(0xfff8000000000000),
        {0xe6,0x2b,0x57,0x84,0x00,0x39,0x17,0x20,0x7d,0x51,
         0xad,0x98,0x57,0x41,0x61,0x69,0x1b,0x8d,0xab,0x30,0x00}
    },
    {
        /* No.120 delta:4555 weight:2785 */
        11213,
        6,
        27,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x148a552f00000000),
         UINT64_C(0x3b1bd87000000000),
         UINT64_C(0x2f918d5f00000000),
         UINT64_C(0x300f007800000000),
         UINT64_C(0x2485555700000000),
         UINT64_C(0x0b14d80800000000),
         UINT64_C(0x1f9e8d2700000000),
         UINT64_C(0x0000450c00000000),
         UINT64_C(0x148a102300000000),
         UINT64_C(0x3b1b9d7c00000000),
         UINT64_C(0x2f91c85300000000),
         UINT64_C(0x300f457400000000),
         UINT64_C(0x2485105b00000000),
         UINT64_C(0x0b149d0400000000),
         UINT64_C(0x1f9ec82b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2277000000000000),
         UINT64_C(0x1877800000000000),
         UINT64_C(0x3a00800000000000),
         UINT64_C(0x0826000000000000),
         UINT64_C(0x2a51000000000000),
         UINT64_C(0x1051800000000000),
         UINT64_C(0x3226800000000000),
         UINT64_C(0x180bf00000000000),
         UINT64_C(0x3a7cf00000000000),
         UINT64_C(0x007c700000000000),
         UINT64_C(0x220b700000000000),
         UINT64_C(0x102df00000000000),
         UINT64_C(0x325af00000000000),
         UINT64_C(0x085a700000000000),
         UINT64_C(0x2a2d700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2277000000000),
         UINT64_C(0x3ff1877800000000),
         UINT64_C(0x3ff3a00800000000),
         UINT64_C(0x3ff0826000000000),
         UINT64_C(0x3ff2a51000000000),
         UINT64_C(0x3ff1051800000000),
         UINT64_C(0x3ff3226800000000),
         UINT64_C(0x3ff180bf00000000),
         UINT64_C(0x3ff3a7cf00000000),
         UINT64_C(0x3ff007c700000000),
         UINT64_C(0x3ff220b700000000),
         UINT64_C(0x3ff102df00000000),
         UINT64_C(0x3ff325af00000000),
         UINT64_C(0x3ff085a700000000),
         UINT64_C(0x3ff2a2d700000000)},
        UINT64_C(0xfff8000000000000),
        {0xf9,0xdb,0x3e,0xb1,0x90,0x78,0x1c,0x4a,0x25,0x52,
         0xfb,0xa9,0xec,0x6e,0x62,0x50,0x58,0x89,0x62,0x56,0x00}
    },
    {
        /* No.121 delta:8407 weight:3685 */
        11213,
        15,
        2,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xbd5a518800000000),
         UINT64_C(0xc771f55200000000),
         UINT64_C(0x7a2ba4da00000000),
         UINT64_C(0x67f9007900000000),
         UINT64_C(0xdaa351f100000000),
         UINT64_C(0xa088f52b00000000),
         UINT64_C(0x1dd2a4a300000000),
         UINT64_C(0x0000d46b00000000),
         UINT64_C(0xbd5a85e300000000),
         UINT64_C(0xc771213900000000),
         UINT64_C(0x7a2b70b100000000),
         UINT64_C(0x67f9d41200000000),
         UINT64_C(0xdaa3859a00000000),
         UINT64_C(0xa088214000000000),
         UINT64_C(0x1dd270c800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x0200000000000000),
         UINT64_C(0x4200000000000000),
         UINT64_C(0x6000000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x6200000000000000),
         UINT64_C(0x2200000000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x4203f00000000000),
         UINT64_C(0x0203f00000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x2203f00000000000),
         UINT64_C(0x6203f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff0200000000000),
         UINT64_C(0x3ff4200000000000),
         UINT64_C(0x3ff6000000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff6200000000000),
         UINT64_C(0x3ff2200000000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff4203f00000000),
         UINT64_C(0x3ff0203f00000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff2203f00000000),
         UINT64_C(0x3ff6203f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x70,0x10,0xe8,0x20,0xb2,0xce,0x9c,0x54,0xdd,0x5a,
         0x93,0x94,0x82,0x6d,0x2b,0xdc,0xa7,0x0e,0x86,0xc9,0x00}
    },
    {
        /* No.122 delta:2808 weight:3141 */
        11213,
        11,
        23,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0f138bc000000000),
         UINT64_C(0xec0e559b00000000),
         UINT64_C(0xe31dde5b00000000),
         UINT64_C(0xbbf3007a00000000),
         UINT64_C(0xb4e08bba00000000),
         UINT64_C(0x57fd55e100000000),
         UINT64_C(0x58eede2100000000),
         UINT64_C(0x000058f600000000),
         UINT64_C(0x0f13d33600000000),
         UINT64_C(0xec0e0d6d00000000),
         UINT64_C(0xe31d86ad00000000),
         UINT64_C(0xbbf3588c00000000),
         UINT64_C(0xb4e0d34c00000000),
         UINT64_C(0x57fd0d1700000000),
         UINT64_C(0x58ee86d700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2048600000000000),
         UINT64_C(0x0000200000000000),
         UINT64_C(0x2048400000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x0048600000000000),
         UINT64_C(0x2000200000000000),
         UINT64_C(0x0048400000000000),
         UINT64_C(0x2013f00000000000),
         UINT64_C(0x005b900000000000),
         UINT64_C(0x2013d00000000000),
         UINT64_C(0x005bb00000000000),
         UINT64_C(0x0013f00000000000),
         UINT64_C(0x205b900000000000),
         UINT64_C(0x0013d00000000000),
         UINT64_C(0x205bb00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2048600000000),
         UINT64_C(0x3ff0000200000000),
         UINT64_C(0x3ff2048400000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff0048600000000),
         UINT64_C(0x3ff2000200000000),
         UINT64_C(0x3ff0048400000000),
         UINT64_C(0x3ff2013f00000000),
         UINT64_C(0x3ff005b900000000),
         UINT64_C(0x3ff2013d00000000),
         UINT64_C(0x3ff005bb00000000),
         UINT64_C(0x3ff0013f00000000),
         UINT64_C(0x3ff205b900000000),
         UINT64_C(0x3ff0013d00000000),
         UINT64_C(0x3ff205bb00000000)},
        UINT64_C(0xfff8000000000000),
        {0x46,0x3f,0x0d,0x95,0x67,0xa7,0xca,0x87,0xa5,0x7b,
         0xd5,0x3d,0xf8,0xd1,0x59,0xe4,0x9e,0x82,0xf2,0xd2,0x00}
    },
    {
        /* No.123 delta:2879 weight:3273 */
        11213,
        20,
        6,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc4f2901c00000000),
         UINT64_C(0x32ad629700000000),
         UINT64_C(0xf65ff28b00000000),
         UINT64_C(0xcbfe007b00000000),
         UINT64_C(0x0f0c906700000000),
         UINT64_C(0xf95362ec00000000),
         UINT64_C(0x3da1f2f000000000),
         UINT64_C(0x0000755700000000),
         UINT64_C(0xc4f2e54b00000000),
         UINT64_C(0x32ad17c000000000),
         UINT64_C(0xf65f87dc00000000),
         UINT64_C(0xcbfe752c00000000),
         UINT64_C(0x0f0ce53000000000),
         UINT64_C(0xf95317bb00000000),
         UINT64_C(0x3da187a700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5802000000000000),
         UINT64_C(0x0002200000000000),
         UINT64_C(0x5800200000000000),
         UINT64_C(0x0003a00000000000),
         UINT64_C(0x5801a00000000000),
         UINT64_C(0x0001800000000000),
         UINT64_C(0x5803800000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x5801f00000000000),
         UINT64_C(0x0001d00000000000),
         UINT64_C(0x5803d00000000000),
         UINT64_C(0x0000500000000000),
         UINT64_C(0x5802500000000000),
         UINT64_C(0x0002700000000000),
         UINT64_C(0x5800700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff5802000000000),
         UINT64_C(0x3ff0002200000000),
         UINT64_C(0x3ff5800200000000),
         UINT64_C(0x3ff0003a00000000),
         UINT64_C(0x3ff5801a00000000),
         UINT64_C(0x3ff0001800000000),
         UINT64_C(0x3ff5803800000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff5801f00000000),
         UINT64_C(0x3ff0001d00000000),
         UINT64_C(0x3ff5803d00000000),
         UINT64_C(0x3ff0000500000000),
         UINT64_C(0x3ff5802500000000),
         UINT64_C(0x3ff0002700000000),
         UINT64_C(0x3ff5800700000000)},
        UINT64_C(0xfff8000000000000),
        {0x8c,0xab,0x48,0x92,0x97,0x04,0xed,0x7f,0x8c,0xec,
         0x63,0x38,0xd5,0xec,0xb0,0x16,0xa7,0x54,0x09,0x5f,0x00}
    },
    {
        /* No.124 delta:5231 weight:3221 */
        11213,
        14,
        11,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x385c697000000000),
         UINT64_C(0xa20941a500000000),
         UINT64_C(0x9a5528d500000000),
         UINT64_C(0xb2f5007c00000000),
         UINT64_C(0x8aa9690c00000000),
         UINT64_C(0x10fc41d900000000),
         UINT64_C(0x28a028a900000000),
         UINT64_C(0x0000212100000000),
         UINT64_C(0x385c485100000000),
         UINT64_C(0xa209608400000000),
         UINT64_C(0x9a5509f400000000),
         UINT64_C(0xb2f5215d00000000),
         UINT64_C(0x8aa9482d00000000),
         UINT64_C(0x10fc60f800000000),
         UINT64_C(0x28a0098800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0820100000000000),
         UINT64_C(0x0040000000000000),
         UINT64_C(0x0860100000000000),
         UINT64_C(0x0020000000000000),
         UINT64_C(0x0800100000000000),
         UINT64_C(0x0060000000000000),
         UINT64_C(0x0840100000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0823e00000000000),
         UINT64_C(0x0043f00000000000),
         UINT64_C(0x0863e00000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x0803e00000000000),
         UINT64_C(0x0063f00000000000),
         UINT64_C(0x0843e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0820100000000),
         UINT64_C(0x3ff0040000000000),
         UINT64_C(0x3ff0860100000000),
         UINT64_C(0x3ff0020000000000),
         UINT64_C(0x3ff0800100000000),
         UINT64_C(0x3ff0060000000000),
         UINT64_C(0x3ff0840100000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0823e00000000),
         UINT64_C(0x3ff0043f00000000),
         UINT64_C(0x3ff0863e00000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff0803e00000000),
         UINT64_C(0x3ff0063f00000000),
         UINT64_C(0x3ff0843e00000000)},
        UINT64_C(0xfff8000000000000),
        {0x01,0xd0,0xd5,0x5a,0x1b,0x45,0xa1,0x88,0x2e,0x27,
         0x67,0x16,0x79,0x9b,0x94,0x01,0xf2,0xd3,0xe1,0x35,0x00}
    },
    {
        /* No.125 delta:2473 weight:3809 */
        11213,
        21,
        6,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x32cd18b000000000),
         UINT64_C(0x0284a3de00000000),
         UINT64_C(0x3049bb6e00000000),
         UINT64_C(0xe8de007d00000000),
         UINT64_C(0xda1318cd00000000),
         UINT64_C(0xea5aa3a300000000),
         UINT64_C(0xd897bb1300000000),
         UINT64_C(0x00001faf00000000),
         UINT64_C(0x32cd071f00000000),
         UINT64_C(0x0284bc7100000000),
         UINT64_C(0x3049a4c100000000),
         UINT64_C(0xe8de1fd200000000),
         UINT64_C(0xda13076200000000),
         UINT64_C(0xea5abc0c00000000),
         UINT64_C(0xd897a4bc00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2820000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x3820000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x6820000000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x7820000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x2823f00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x3823f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x6823f00000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x7823f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2820000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff3820000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff6820000000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff7820000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff2823f00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff3823f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff6823f00000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff7823f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x8e,0xc1,0xcf,0x5e,0xda,0x61,0x89,0x2c,0x02,0x8b,
         0x41,0x61,0x06,0xc5,0x59,0xa0,0xc8,0x79,0xfb,0xab,0x00}
    },
    {
        /* No.126 delta:4436 weight:3169 */
        11213,
        21,
        17,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3a663dd100000000),
         UINT64_C(0x7b38e26900000000),
         UINT64_C(0x415edfb800000000),
         UINT64_C(0x564a007e00000000),
         UINT64_C(0x6c2c3daf00000000),
         UINT64_C(0x2d72e21700000000),
         UINT64_C(0x1714dfc600000000),
         UINT64_C(0x00004a4a00000000),
         UINT64_C(0x3a66779b00000000),
         UINT64_C(0x7b38a82300000000),
         UINT64_C(0x415e95f200000000),
         UINT64_C(0x564a4a3400000000),
         UINT64_C(0x6c2c77e500000000),
         UINT64_C(0x2d72a85d00000000),
         UINT64_C(0x1714958c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0561200000000000),
         UINT64_C(0x091f800000000000),
         UINT64_C(0x0c7ea00000000000),
         UINT64_C(0x0401a00000000000),
         UINT64_C(0x0160800000000000),
         UINT64_C(0x0d1e200000000000),
         UINT64_C(0x087f000000000000),
         UINT64_C(0x0803f00000000000),
         UINT64_C(0x0d62d00000000000),
         UINT64_C(0x011c700000000000),
         UINT64_C(0x047d500000000000),
         UINT64_C(0x0c02500000000000),
         UINT64_C(0x0963700000000000),
         UINT64_C(0x051dd00000000000),
         UINT64_C(0x007cf00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0561200000000),
         UINT64_C(0x3ff091f800000000),
         UINT64_C(0x3ff0c7ea00000000),
         UINT64_C(0x3ff0401a00000000),
         UINT64_C(0x3ff0160800000000),
         UINT64_C(0x3ff0d1e200000000),
         UINT64_C(0x3ff087f000000000),
         UINT64_C(0x3ff0803f00000000),
         UINT64_C(0x3ff0d62d00000000),
         UINT64_C(0x3ff011c700000000),
         UINT64_C(0x3ff047d500000000),
         UINT64_C(0x3ff0c02500000000),
         UINT64_C(0x3ff0963700000000),
         UINT64_C(0x3ff051dd00000000),
         UINT64_C(0x3ff007cf00000000)},
        UINT64_C(0xfff8000000000000),
        {0x0e,0x26,0x6e,0xe8,0xdc,0xfd,0xee,0x27,0xa3,0x45,
         0x20,0xef,0xd5,0xea,0x8b,0x7c,0xb6,0xac,0x2f,0xac,0x00}
    },
    {
        /* No.127 delta:6898 weight:2565 */
        11213,
        4,
        16,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6395545800000000),
         UINT64_C(0x182cb29500000000),
         UINT64_C(0x7bb9e6cd00000000),
         UINT64_C(0x6f94007f00000000),
         UINT64_C(0x0c01542700000000),
         UINT64_C(0x77b8b2ea00000000),
         UINT64_C(0x142de6b200000000),
         UINT64_C(0x000018fb00000000),
         UINT64_C(0x63954ca300000000),
         UINT64_C(0x182caa6e00000000),
         UINT64_C(0x7bb9fe3600000000),
         UINT64_C(0x6f94188400000000),
         UINT64_C(0x0c014cdc00000000),
         UINT64_C(0x77b8aa1100000000),
         UINT64_C(0x142dfe4900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0936000000000000),
         UINT64_C(0x0f08000000000000),
         UINT64_C(0x063e000000000000),
         UINT64_C(0x0c81a00000000000),
         UINT64_C(0x05b7a00000000000),
         UINT64_C(0x0389a00000000000),
         UINT64_C(0x0abfa00000000000),
         UINT64_C(0x8253f00000000000),
         UINT64_C(0x8b65f00000000000),
         UINT64_C(0x8d5bf00000000000),
         UINT64_C(0x846df00000000000),
         UINT64_C(0x8ed2500000000000),
         UINT64_C(0x87e4500000000000),
         UINT64_C(0x81da500000000000),
         UINT64_C(0x88ec500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0936000000000),
         UINT64_C(0x3ff0f08000000000),
         UINT64_C(0x3ff063e000000000),
         UINT64_C(0x3ff0c81a00000000),
         UINT64_C(0x3ff05b7a00000000),
         UINT64_C(0x3ff0389a00000000),
         UINT64_C(0x3ff0abfa00000000),
         UINT64_C(0x3ff8253f00000000),
         UINT64_C(0x3ff8b65f00000000),
         UINT64_C(0x3ff8d5bf00000000),
         UINT64_C(0x3ff846df00000000),
         UINT64_C(0x3ff8ed2500000000),
         UINT64_C(0x3ff87e4500000000),
         UINT64_C(0x3ff81da500000000),
         UINT64_C(0x3ff88ec500000000)},
        UINT64_C(0xfff8000000000000),
        {0xb8,0x74,0xd9,0x7c,0x8d,0x17,0x0c,0x93,0x18,0x2a,
         0x55,0xa2,0x4c,0xdc,0x18,0xe0,0x87,0x4f,0xcf,0x89,0x00}
    },
    {
        /* No.128 delta:2696 weight:3057 */
        11213,
        33,
        6,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0d55cb8800000000),
         UINT64_C(0x4ede341700000000),
         UINT64_C(0x438bff9f00000000),
         UINT64_C(0xdbe8008000000000),
         UINT64_C(0xd6bdcb0800000000),
         UINT64_C(0x9536349700000000),
         UINT64_C(0x9863ff1f00000000),
         UINT64_C(0x0000fdbc00000000),
         UINT64_C(0x0d55363400000000),
         UINT64_C(0x4edec9ab00000000),
         UINT64_C(0x438b022300000000),
         UINT64_C(0xdbe8fd3c00000000),
         UINT64_C(0xd6bd36b400000000),
         UINT64_C(0x9536c92b00000000),
         UINT64_C(0x986302a300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x6000800000000000),
         UINT64_C(0x6000800000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x2000800000000000),
         UINT64_C(0x2000800000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x6003700000000000),
         UINT64_C(0x6003700000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x2003700000000000),
         UINT64_C(0x2003700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff6000800000000),
         UINT64_C(0x3ff6000800000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff2000800000000),
         UINT64_C(0x3ff2000800000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff6003700000000),
         UINT64_C(0x3ff6003700000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff2003700000000),
         UINT64_C(0x3ff2003700000000)},
        UINT64_C(0xfff8000000000000),
        {0x0d,0x83,0xfc,0xe5,0x01,0x0a,0xb2,0x20,0x50,0x2c,
         0x60,0xd7,0x8b,0xac,0xbb,0xab,0x5c,0x8b,0x86,0xb9,0x00}
    },
    {
        /* No.129 delta:6494 weight:2645 */
        11213,
        17,
        23,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x438f6eab00000000),
         UINT64_C(0xe423006500000000),
         UINT64_C(0xa7ac6ece00000000),
         UINT64_C(0xe08b008100000000),
         UINT64_C(0xa3046e2a00000000),
         UINT64_C(0x04a800e400000000),
         UINT64_C(0x47276e4f00000000),
         UINT64_C(0x0000092100000000),
         UINT64_C(0x438f678a00000000),
         UINT64_C(0xe423094400000000),
         UINT64_C(0xa7ac67ef00000000),
         UINT64_C(0xe08b09a000000000),
         UINT64_C(0xa304670b00000000),
         UINT64_C(0x04a809c500000000),
         UINT64_C(0x4727676e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1abe200000000000),
         UINT64_C(0x26c5000000000000),
         UINT64_C(0x3c7b200000000000),
         UINT64_C(0x0a0b900000000000),
         UINT64_C(0x10b5b00000000000),
         UINT64_C(0x2cce900000000000),
         UINT64_C(0x3670b00000000000),
         UINT64_C(0x118ff00000000000),
         UINT64_C(0x0b31d00000000000),
         UINT64_C(0x374af00000000000),
         UINT64_C(0x2df4d00000000000),
         UINT64_C(0x1b84600000000000),
         UINT64_C(0x013a400000000000),
         UINT64_C(0x3d41600000000000),
         UINT64_C(0x27ff400000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1abe200000000),
         UINT64_C(0x3ff26c5000000000),
         UINT64_C(0x3ff3c7b200000000),
         UINT64_C(0x3ff0a0b900000000),
         UINT64_C(0x3ff10b5b00000000),
         UINT64_C(0x3ff2cce900000000),
         UINT64_C(0x3ff3670b00000000),
         UINT64_C(0x3ff118ff00000000),
         UINT64_C(0x3ff0b31d00000000),
         UINT64_C(0x3ff374af00000000),
         UINT64_C(0x3ff2df4d00000000),
         UINT64_C(0x3ff1b84600000000),
         UINT64_C(0x3ff013a400000000),
         UINT64_C(0x3ff3d41600000000),
         UINT64_C(0x3ff27ff400000000)},
        UINT64_C(0xfff8000000000000),
        {0x2a,0x17,0x03,0xc3,0xd6,0xe6,0xcf,0x8f,0xf7,0x02,
         0x18,0x1a,0x11,0xb4,0xf4,0xda,0xfd,0xd3,0x36,0xbd,0x00}
    },
    {
        /* No.130 delta:3496 weight:2909 */
        11213,
        16,
        29,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa41d40d500000000),
         UINT64_C(0xe37cc6b000000000),
         UINT64_C(0x4761866500000000),
         UINT64_C(0x1a6c008200000000),
         UINT64_C(0xbe71405700000000),
         UINT64_C(0xf910c63200000000),
         UINT64_C(0x5d0d86e700000000),
         UINT64_C(0x00007cc900000000),
         UINT64_C(0xa41d3c1c00000000),
         UINT64_C(0xe37cba7900000000),
         UINT64_C(0x4761faac00000000),
         UINT64_C(0x1a6c7c4b00000000),
         UINT64_C(0xbe713c9e00000000),
         UINT64_C(0xf910bafb00000000),
         UINT64_C(0x5d0dfa2e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4009300000000000),
         UINT64_C(0x3047400000000000),
         UINT64_C(0x704e700000000000),
         UINT64_C(0x0814800000000000),
         UINT64_C(0x481db00000000000),
         UINT64_C(0x3853c00000000000),
         UINT64_C(0x785af00000000000),
         UINT64_C(0x1063f00000000000),
         UINT64_C(0x506ac00000000000),
         UINT64_C(0x2024b00000000000),
         UINT64_C(0x602d800000000000),
         UINT64_C(0x1877700000000000),
         UINT64_C(0x587e400000000000),
         UINT64_C(0x2830300000000000),
         UINT64_C(0x6839000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4009300000000),
         UINT64_C(0x3ff3047400000000),
         UINT64_C(0x3ff704e700000000),
         UINT64_C(0x3ff0814800000000),
         UINT64_C(0x3ff481db00000000),
         UINT64_C(0x3ff3853c00000000),
         UINT64_C(0x3ff785af00000000),
         UINT64_C(0x3ff1063f00000000),
         UINT64_C(0x3ff506ac00000000),
         UINT64_C(0x3ff2024b00000000),
         UINT64_C(0x3ff602d800000000),
         UINT64_C(0x3ff1877700000000),
         UINT64_C(0x3ff587e400000000),
         UINT64_C(0x3ff2830300000000),
         UINT64_C(0x3ff6839000000000)},
        UINT64_C(0xfff8000000000000),
        {0xa8,0xa9,0x6b,0xb9,0x17,0x15,0x43,0x9c,0x5b,0x6e,
         0x43,0xb6,0xe0,0x98,0x4d,0x0f,0x58,0xc8,0x46,0xe1,0x00}
    },
    {
        /* No.131 delta:1887 weight:3077 */
        11213,
        38,
        10,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x98b0557d00000000),
         UINT64_C(0x1b2c738c00000000),
         UINT64_C(0x839c26f100000000),
         UINT64_C(0xeda1008300000000),
         UINT64_C(0x751155fe00000000),
         UINT64_C(0xf68d730f00000000),
         UINT64_C(0x6e3d267200000000),
         UINT64_C(0x000027c700000000),
         UINT64_C(0x98b072ba00000000),
         UINT64_C(0x1b2c544b00000000),
         UINT64_C(0x839c013600000000),
         UINT64_C(0xeda1274400000000),
         UINT64_C(0x7511723900000000),
         UINT64_C(0xf68d54c800000000),
         UINT64_C(0x6e3d01b500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1068600000000000),
         UINT64_C(0x6048000000000000),
         UINT64_C(0x7020600000000000),
         UINT64_C(0x0040200000000000),
         UINT64_C(0x1028400000000000),
         UINT64_C(0x6008200000000000),
         UINT64_C(0x7060400000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x306b900000000000),
         UINT64_C(0x404bf00000000000),
         UINT64_C(0x5023900000000000),
         UINT64_C(0x2043d00000000000),
         UINT64_C(0x302bb00000000000),
         UINT64_C(0x400bd00000000000),
         UINT64_C(0x5063b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1068600000000),
         UINT64_C(0x3ff6048000000000),
         UINT64_C(0x3ff7020600000000),
         UINT64_C(0x3ff0040200000000),
         UINT64_C(0x3ff1028400000000),
         UINT64_C(0x3ff6008200000000),
         UINT64_C(0x3ff7060400000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff306b900000000),
         UINT64_C(0x3ff404bf00000000),
         UINT64_C(0x3ff5023900000000),
         UINT64_C(0x3ff2043d00000000),
         UINT64_C(0x3ff302bb00000000),
         UINT64_C(0x3ff400bd00000000),
         UINT64_C(0x3ff5063b00000000)},
        UINT64_C(0xfff8000000000000),
        {0x3a,0xf2,0x40,0xa6,0xb8,0x64,0xa3,0x4d,0x51,0x39,
         0x01,0xa6,0x8a,0x70,0x64,0x8d,0x05,0xbb,0x90,0x0f,0x00}
    },
    {
        /* No.132 delta:2324 weight:3649 */
        11213,
        10,
        11,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5a5cda8900000000),
         UINT64_C(0x34c7003e00000000),
         UINT64_C(0x6e9bdab700000000),
         UINT64_C(0x3ab9008400000000),
         UINT64_C(0x60e5da0d00000000),
         UINT64_C(0x0e7e00ba00000000),
         UINT64_C(0x5422da3300000000),
         UINT64_C(0x0000bfe300000000),
         UINT64_C(0x5a5c656a00000000),
         UINT64_C(0x34c7bfdd00000000),
         UINT64_C(0x6e9b655400000000),
         UINT64_C(0x3ab9bf6700000000),
         UINT64_C(0x60e565ee00000000),
         UINT64_C(0x0e7ebf5900000000),
         UINT64_C(0x542265d000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0063c00000000000),
         UINT64_C(0x0006400000000000),
         UINT64_C(0x0065800000000000),
         UINT64_C(0x0012100000000000),
         UINT64_C(0x0071d00000000000),
         UINT64_C(0x0014500000000000),
         UINT64_C(0x0077900000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x2060300000000000),
         UINT64_C(0x2005b00000000000),
         UINT64_C(0x2066700000000000),
         UINT64_C(0x2011e00000000000),
         UINT64_C(0x2072200000000000),
         UINT64_C(0x2017a00000000000),
         UINT64_C(0x2074600000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0063c00000000),
         UINT64_C(0x3ff0006400000000),
         UINT64_C(0x3ff0065800000000),
         UINT64_C(0x3ff0012100000000),
         UINT64_C(0x3ff0071d00000000),
         UINT64_C(0x3ff0014500000000),
         UINT64_C(0x3ff0077900000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff2060300000000),
         UINT64_C(0x3ff2005b00000000),
         UINT64_C(0x3ff2066700000000),
         UINT64_C(0x3ff2011e00000000),
         UINT64_C(0x3ff2072200000000),
         UINT64_C(0x3ff2017a00000000),
         UINT64_C(0x3ff2074600000000)},
        UINT64_C(0xfff8000000000000),
        {0xa5,0xb4,0xa0,0x8b,0xbf,0x17,0xb8,0x5d,0x7e,0x55,
         0x2b,0x31,0xc8,0x0e,0x86,0xa1,0xb3,0x50,0x28,0x55,0x00}
    },
    {
        /* No.133 delta:1870 weight:1609 */
        11213,
        36,
        11,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2142ff0100000000),
         UINT64_C(0x746787ef00000000),
         UINT64_C(0x552578ee00000000),
         UINT64_C(0x5228008500000000),
         UINT64_C(0x736aff8400000000),
         UINT64_C(0x264f876a00000000),
         UINT64_C(0x070d786b00000000),
         UINT64_C(0x0000ea8e00000000),
         UINT64_C(0x2142158f00000000),
         UINT64_C(0x74676d6100000000),
         UINT64_C(0x5525926000000000),
         UINT64_C(0x5228ea0b00000000),
         UINT64_C(0x736a150a00000000),
         UINT64_C(0x264f6de400000000),
         UINT64_C(0x070d92e500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x511f200000000000),
         UINT64_C(0x4003500000000000),
         UINT64_C(0x111c700000000000),
         UINT64_C(0x0008800000000000),
         UINT64_C(0x5117a00000000000),
         UINT64_C(0x400bd00000000000),
         UINT64_C(0x1114f00000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x311cd00000000000),
         UINT64_C(0x2000a00000000000),
         UINT64_C(0x711f800000000000),
         UINT64_C(0x600b700000000000),
         UINT64_C(0x3114500000000000),
         UINT64_C(0x2008200000000000),
         UINT64_C(0x7117000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff511f200000000),
         UINT64_C(0x3ff4003500000000),
         UINT64_C(0x3ff111c700000000),
         UINT64_C(0x3ff0008800000000),
         UINT64_C(0x3ff5117a00000000),
         UINT64_C(0x3ff400bd00000000),
         UINT64_C(0x3ff1114f00000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff311cd00000000),
         UINT64_C(0x3ff2000a00000000),
         UINT64_C(0x3ff711f800000000),
         UINT64_C(0x3ff600b700000000),
         UINT64_C(0x3ff3114500000000),
         UINT64_C(0x3ff2008200000000),
         UINT64_C(0x3ff7117000000000)},
        UINT64_C(0xfff8000000000000),
        {0x01,0xca,0xb1,0x1d,0x08,0x86,0x36,0x91,0xf4,0x63,
         0x3b,0x85,0xc2,0x42,0xbe,0x84,0x78,0x4c,0x51,0xcf,0x00}
    },
    {
        /* No.134 delta:2822 weight:3351 */
        11213,
        16,
        20,
        12,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x08dddd0d00000000),
         UINT64_C(0x833829d900000000),
         UINT64_C(0x8be5f4d400000000),
         UINT64_C(0xdb05008600000000),
         UINT64_C(0xd3d8dd8b00000000),
         UINT64_C(0x583d295f00000000),
         UINT64_C(0x50e0f45200000000),
         UINT64_C(0x0000fe2300000000),
         UINT64_C(0x08dd232e00000000),
         UINT64_C(0x8338d7fa00000000),
         UINT64_C(0x8be50af700000000),
         UINT64_C(0xdb05fea500000000),
         UINT64_C(0xd3d823a800000000),
         UINT64_C(0x583dd77c00000000),
         UINT64_C(0x50e00a7100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0003800000000000),
         UINT64_C(0x4025600000000000),
         UINT64_C(0x4026e00000000000),
         UINT64_C(0x0000600000000000),
         UINT64_C(0x0003e00000000000),
         UINT64_C(0x4025000000000000),
         UINT64_C(0x4026800000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x1000700000000000),
         UINT64_C(0x5026900000000000),
         UINT64_C(0x5025100000000000),
         UINT64_C(0x1003900000000000),
         UINT64_C(0x1000100000000000),
         UINT64_C(0x5026f00000000000),
         UINT64_C(0x5025700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0003800000000),
         UINT64_C(0x3ff4025600000000),
         UINT64_C(0x3ff4026e00000000),
         UINT64_C(0x3ff0000600000000),
         UINT64_C(0x3ff0003e00000000),
         UINT64_C(0x3ff4025000000000),
         UINT64_C(0x3ff4026800000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff1000700000000),
         UINT64_C(0x3ff5026900000000),
         UINT64_C(0x3ff5025100000000),
         UINT64_C(0x3ff1003900000000),
         UINT64_C(0x3ff1000100000000),
         UINT64_C(0x3ff5026f00000000),
         UINT64_C(0x3ff5025700000000)},
        UINT64_C(0xfff8000000000000),
        {0xe9,0x3a,0xc0,0x42,0xf6,0x97,0x7f,0x2e,0x83,0x34,
         0xcd,0x4e,0x5a,0x9e,0x7d,0x03,0xce,0x80,0x74,0x71,0x00}
    },
    {
        /* No.135 delta:2618 weight:3603 */
        11213,
        6,
        7,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa44e863d00000000),
         UINT64_C(0x5518a33800000000),
         UINT64_C(0xf156250500000000),
         UINT64_C(0x5cb7008700000000),
         UINT64_C(0xf8f986ba00000000),
         UINT64_C(0x09afa3bf00000000),
         UINT64_C(0xade1258200000000),
         UINT64_C(0x00009d7c00000000),
         UINT64_C(0xa44e1b4100000000),
         UINT64_C(0x55183e4400000000),
         UINT64_C(0xf156b87900000000),
         UINT64_C(0x5cb79dfb00000000),
         UINT64_C(0xf8f91bc600000000),
         UINT64_C(0x09af3ec300000000),
         UINT64_C(0xade1b8fe00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x006f000000000000),
         UINT64_C(0x0050900000000000),
         UINT64_C(0x003f900000000000),
         UINT64_C(0x003c600000000000),
         UINT64_C(0x0053600000000000),
         UINT64_C(0x006cf00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0073f00000000000),
         UINT64_C(0x001cf00000000000),
         UINT64_C(0x0023600000000000),
         UINT64_C(0x004c600000000000),
         UINT64_C(0x004f900000000000),
         UINT64_C(0x0020900000000000),
         UINT64_C(0x001f000000000000),
         UINT64_C(0x0070000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff006f000000000),
         UINT64_C(0x3ff0050900000000),
         UINT64_C(0x3ff003f900000000),
         UINT64_C(0x3ff003c600000000),
         UINT64_C(0x3ff0053600000000),
         UINT64_C(0x3ff006cf00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0073f00000000),
         UINT64_C(0x3ff001cf00000000),
         UINT64_C(0x3ff0023600000000),
         UINT64_C(0x3ff004c600000000),
         UINT64_C(0x3ff004f900000000),
         UINT64_C(0x3ff0020900000000),
         UINT64_C(0x3ff001f000000000),
         UINT64_C(0x3ff0070000000000)},
        UINT64_C(0xfff8000000000000),
        {0xb4,0x06,0x76,0xa5,0x13,0x1a,0xdf,0x2a,0x63,0x09,
         0xf9,0x62,0x1b,0x66,0x0c,0xd0,0x86,0xb9,0x8f,0xec,0x00}
    },
    {
        /* No.136 delta:3029 weight:2851 */
        11213,
        15,
        28,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc0511d9f00000000),
         UINT64_C(0x21a52ec900000000),
         UINT64_C(0xe1f4335600000000),
         UINT64_C(0x6787008800000000),
         UINT64_C(0xa7d61d1700000000),
         UINT64_C(0x46222e4100000000),
         UINT64_C(0x867333de00000000),
         UINT64_C(0x0000ffdb00000000),
         UINT64_C(0xc051e24400000000),
         UINT64_C(0x21a5d11200000000),
         UINT64_C(0xe1f4cc8d00000000),
         UINT64_C(0x6787ff5300000000),
         UINT64_C(0xa7d6e2cc00000000),
         UINT64_C(0x4622d19a00000000),
         UINT64_C(0x8673cc0500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x006eb00000000000),
         UINT64_C(0x1052600000000000),
         UINT64_C(0x103cd00000000000),
         UINT64_C(0xa011500000000000),
         UINT64_C(0xa07fe00000000000),
         UINT64_C(0xb043300000000000),
         UINT64_C(0xb02d800000000000),
         UINT64_C(0x1023f00000000000),
         UINT64_C(0x104d400000000000),
         UINT64_C(0x0071900000000000),
         UINT64_C(0x001f200000000000),
         UINT64_C(0xb032a00000000000),
         UINT64_C(0xb05c100000000000),
         UINT64_C(0xa060c00000000000),
         UINT64_C(0xa00e700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff006eb00000000),
         UINT64_C(0x3ff1052600000000),
         UINT64_C(0x3ff103cd00000000),
         UINT64_C(0x3ffa011500000000),
         UINT64_C(0x3ffa07fe00000000),
         UINT64_C(0x3ffb043300000000),
         UINT64_C(0x3ffb02d800000000),
         UINT64_C(0x3ff1023f00000000),
         UINT64_C(0x3ff104d400000000),
         UINT64_C(0x3ff0071900000000),
         UINT64_C(0x3ff001f200000000),
         UINT64_C(0x3ffb032a00000000),
         UINT64_C(0x3ffb05c100000000),
         UINT64_C(0x3ffa060c00000000),
         UINT64_C(0x3ffa00e700000000)},
        UINT64_C(0xfff8000000000000),
        {0xfd,0x56,0x80,0x86,0x66,0x70,0x9f,0x69,0x0b,0xd5,
         0x8a,0x4c,0xd5,0xe6,0x9c,0xa7,0x95,0xce,0xaa,0x6c,0x00}
    },
    {
        /* No.137 delta:2354 weight:3565 */
        11213,
        39,
        10,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x23e155fd00000000),
         UINT64_C(0x26848d3600000000),
         UINT64_C(0x0565d8cb00000000),
         UINT64_C(0x46d8008900000000),
         UINT64_C(0x6539557400000000),
         UINT64_C(0x605c8dbf00000000),
         UINT64_C(0x43bdd84200000000),
         UINT64_C(0x0000045d00000000),
         UINT64_C(0x23e151a000000000),
         UINT64_C(0x2684896b00000000),
         UINT64_C(0x0565dc9600000000),
         UINT64_C(0x46d804d400000000),
         UINT64_C(0x6539512900000000),
         UINT64_C(0x605c89e200000000),
         UINT64_C(0x43bddc1f00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3000800000000000),
         UINT64_C(0x0002600000000000),
         UINT64_C(0x3002e00000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x3000800000000000),
         UINT64_C(0x0002600000000000),
         UINT64_C(0x3002e00000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x1003700000000000),
         UINT64_C(0x2001900000000000),
         UINT64_C(0x1001100000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x1003700000000000),
         UINT64_C(0x2001900000000000),
         UINT64_C(0x1001100000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3000800000000),
         UINT64_C(0x3ff0002600000000),
         UINT64_C(0x3ff3002e00000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3000800000000),
         UINT64_C(0x3ff0002600000000),
         UINT64_C(0x3ff3002e00000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff1003700000000),
         UINT64_C(0x3ff2001900000000),
         UINT64_C(0x3ff1001100000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff1003700000000),
         UINT64_C(0x3ff2001900000000),
         UINT64_C(0x3ff1001100000000)},
        UINT64_C(0xfff8000000000000),
        {0xa0,0xa8,0x80,0xeb,0x09,0x42,0x5b,0xa7,0x2d,0xa8,
         0xb4,0xc4,0x14,0xef,0xcf,0x1d,0x81,0xa8,0xed,0xf6,0x00}
    },
    {
        /* No.138 delta:3407 weight:2879 */
        11213,
        8,
        11,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x7c63b91600000000),
         UINT64_C(0x50781b4500000000),
         UINT64_C(0x2c1ba25300000000),
         UINT64_C(0xbb94008a00000000),
         UINT64_C(0xc7f7b99c00000000),
         UINT64_C(0xebec1bcf00000000),
         UINT64_C(0x978fa2d900000000),
         UINT64_C(0x000061dc00000000),
         UINT64_C(0x7c63d8ca00000000),
         UINT64_C(0x50787a9900000000),
         UINT64_C(0x2c1bc38f00000000),
         UINT64_C(0xbb94615600000000),
         UINT64_C(0xc7f7d84000000000),
         UINT64_C(0xebec7a1300000000),
         UINT64_C(0x978fc30500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x62b6000000000000),
         UINT64_C(0x0051000000000000),
         UINT64_C(0x62e7000000000000),
         UINT64_C(0x0022e00000000000),
         UINT64_C(0x6294e00000000000),
         UINT64_C(0x0073e00000000000),
         UINT64_C(0x62c5e00000000000),
         UINT64_C(0x018bf00000000000),
         UINT64_C(0x633df00000000000),
         UINT64_C(0x01daf00000000000),
         UINT64_C(0x636cf00000000000),
         UINT64_C(0x01a9100000000000),
         UINT64_C(0x631f100000000000),
         UINT64_C(0x01f8100000000000),
         UINT64_C(0x634e100000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff62b6000000000),
         UINT64_C(0x3ff0051000000000),
         UINT64_C(0x3ff62e7000000000),
         UINT64_C(0x3ff0022e00000000),
         UINT64_C(0x3ff6294e00000000),
         UINT64_C(0x3ff0073e00000000),
         UINT64_C(0x3ff62c5e00000000),
         UINT64_C(0x3ff018bf00000000),
         UINT64_C(0x3ff633df00000000),
         UINT64_C(0x3ff01daf00000000),
         UINT64_C(0x3ff636cf00000000),
         UINT64_C(0x3ff01a9100000000),
         UINT64_C(0x3ff631f100000000),
         UINT64_C(0x3ff01f8100000000),
         UINT64_C(0x3ff634e100000000)},
        UINT64_C(0xfff8000000000000),
        {0x39,0x7c,0xa0,0xc4,0x0a,0x41,0xa1,0x7b,0x92,0xd7,
         0x79,0xe1,0x01,0xb2,0x97,0x37,0x6c,0x78,0x0c,0xe5,0x00}
    },
    {
        /* No.139 delta:2544 weight:3487 */
        11213,
        22,
        7,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xd0a3004400000000),
         UINT64_C(0x5caf7f6300000000),
         UINT64_C(0x8c0c7f2700000000),
         UINT64_C(0xb364008b00000000),
         UINT64_C(0x63c700cf00000000),
         UINT64_C(0xefcb7fe800000000),
         UINT64_C(0x3f687fac00000000),
         UINT64_C(0x0000038e00000000),
         UINT64_C(0xd0a303ca00000000),
         UINT64_C(0x5caf7ced00000000),
         UINT64_C(0x8c0c7ca900000000),
         UINT64_C(0xb364030500000000),
         UINT64_C(0x63c7034100000000),
         UINT64_C(0xefcb7c6600000000),
         UINT64_C(0x3f687c2200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0080000000000000),
         UINT64_C(0x1800000000000000),
         UINT64_C(0x1880000000000000),
         UINT64_C(0x0420000000000000),
         UINT64_C(0x04a0000000000000),
         UINT64_C(0x1c20000000000000),
         UINT64_C(0x1ca0000000000000),
         UINT64_C(0x0013f00000000000),
         UINT64_C(0x0093f00000000000),
         UINT64_C(0x1813f00000000000),
         UINT64_C(0x1893f00000000000),
         UINT64_C(0x0433f00000000000),
         UINT64_C(0x04b3f00000000000),
         UINT64_C(0x1c33f00000000000),
         UINT64_C(0x1cb3f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0080000000000),
         UINT64_C(0x3ff1800000000000),
         UINT64_C(0x3ff1880000000000),
         UINT64_C(0x3ff0420000000000),
         UINT64_C(0x3ff04a0000000000),
         UINT64_C(0x3ff1c20000000000),
         UINT64_C(0x3ff1ca0000000000),
         UINT64_C(0x3ff0013f00000000),
         UINT64_C(0x3ff0093f00000000),
         UINT64_C(0x3ff1813f00000000),
         UINT64_C(0x3ff1893f00000000),
         UINT64_C(0x3ff0433f00000000),
         UINT64_C(0x3ff04b3f00000000),
         UINT64_C(0x3ff1c33f00000000),
         UINT64_C(0x3ff1cb3f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xe5,0x99,0x84,0xb9,0x21,0x8e,0xee,0xf5,0xe8,0x36,
         0xa6,0x38,0x92,0xe0,0xc5,0xfe,0x08,0xf9,0xff,0x38,0x00}
    },
    {
        /* No.140 delta:2431 weight:3487 */
        11213,
        22,
        5,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xbc495c8000000000),
         UINT64_C(0xac50e62000000000),
         UINT64_C(0x1019baa000000000),
         UINT64_C(0x15a4008c00000000),
         UINT64_C(0xa9ed5c0c00000000),
         UINT64_C(0xb9f4e6ac00000000),
         UINT64_C(0x05bdba2c00000000),
         UINT64_C(0x0000419d00000000),
         UINT64_C(0xbc491d1d00000000),
         UINT64_C(0xac50a7bd00000000),
         UINT64_C(0x1019fb3d00000000),
         UINT64_C(0x15a4411100000000),
         UINT64_C(0xa9ed1d9100000000),
         UINT64_C(0xb9f4a73100000000),
         UINT64_C(0x05bdfbb100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5800300000000000),
         UINT64_C(0x0002600000000000),
         UINT64_C(0x5802500000000000),
         UINT64_C(0x0001200000000000),
         UINT64_C(0x5801100000000000),
         UINT64_C(0x0003400000000000),
         UINT64_C(0x5803700000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x5803c00000000000),
         UINT64_C(0x0001900000000000),
         UINT64_C(0x5801a00000000000),
         UINT64_C(0x0002d00000000000),
         UINT64_C(0x5802e00000000000),
         UINT64_C(0x0000b00000000000),
         UINT64_C(0x5800800000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff5800300000000),
         UINT64_C(0x3ff0002600000000),
         UINT64_C(0x3ff5802500000000),
         UINT64_C(0x3ff0001200000000),
         UINT64_C(0x3ff5801100000000),
         UINT64_C(0x3ff0003400000000),
         UINT64_C(0x3ff5803700000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff5803c00000000),
         UINT64_C(0x3ff0001900000000),
         UINT64_C(0x3ff5801a00000000),
         UINT64_C(0x3ff0002d00000000),
         UINT64_C(0x3ff5802e00000000),
         UINT64_C(0x3ff0000b00000000),
         UINT64_C(0x3ff5800800000000)},
        UINT64_C(0xfff8000000000000),
        {0xdb,0xd4,0xf4,0xb3,0xfb,0xe6,0x99,0x89,0x30,0x77,
         0x06,0xe8,0x4f,0x9f,0xb3,0x88,0xf7,0xe6,0x8f,0x71,0x00}
    },
    {
        /* No.141 delta:3055 weight:3071 */
        11213,
        24,
        29,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x91e24e2f00000000),
         UINT64_C(0x2337efca00000000),
         UINT64_C(0xb2d5a1e500000000),
         UINT64_C(0x682c008d00000000),
         UINT64_C(0xf9ce4ea200000000),
         UINT64_C(0x4b1bef4700000000),
         UINT64_C(0xdaf9a16800000000),
         UINT64_C(0x0000326900000000),
         UINT64_C(0x91e27c4600000000),
         UINT64_C(0x2337dda300000000),
         UINT64_C(0xb2d5938c00000000),
         UINT64_C(0x682c32e400000000),
         UINT64_C(0xf9ce7ccb00000000),
         UINT64_C(0x4b1bdd2e00000000),
         UINT64_C(0xdaf9930100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0065500000000000),
         UINT64_C(0x5011500000000000),
         UINT64_C(0x5074000000000000),
         UINT64_C(0x0052400000000000),
         UINT64_C(0x0037100000000000),
         UINT64_C(0x5043100000000000),
         UINT64_C(0x5026400000000000),
         UINT64_C(0x1293f00000000000),
         UINT64_C(0x12f6a00000000000),
         UINT64_C(0x4282a00000000000),
         UINT64_C(0x42e7f00000000000),
         UINT64_C(0x12c1b00000000000),
         UINT64_C(0x12a4e00000000000),
         UINT64_C(0x42d0e00000000000),
         UINT64_C(0x42b5b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0065500000000),
         UINT64_C(0x3ff5011500000000),
         UINT64_C(0x3ff5074000000000),
         UINT64_C(0x3ff0052400000000),
         UINT64_C(0x3ff0037100000000),
         UINT64_C(0x3ff5043100000000),
         UINT64_C(0x3ff5026400000000),
         UINT64_C(0x3ff1293f00000000),
         UINT64_C(0x3ff12f6a00000000),
         UINT64_C(0x3ff4282a00000000),
         UINT64_C(0x3ff42e7f00000000),
         UINT64_C(0x3ff12c1b00000000),
         UINT64_C(0x3ff12a4e00000000),
         UINT64_C(0x3ff42d0e00000000),
         UINT64_C(0x3ff42b5b00000000)},
        UINT64_C(0xfff8000000000000),
        {0xe7,0x20,0xed,0x4a,0x36,0xc9,0x62,0x68,0x7d,0x83,
         0x6b,0x7a,0x6e,0x44,0x68,0x4d,0x34,0x24,0xbb,0x67,0x00}
    },
    {
        /* No.142 delta:4125 weight:2465 */
        11213,
        39,
        9,
        19,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0cc0efa000000000),
         UINT64_C(0x67ab3f0b00000000),
         UINT64_C(0x6b6bd0ab00000000),
         UINT64_C(0x105f008e00000000),
         UINT64_C(0x1c9fef2e00000000),
         UINT64_C(0x77f43f8500000000),
         UINT64_C(0x7b34d02500000000),
         UINT64_C(0x0000d5c700000000),
         UINT64_C(0x0cc03a6700000000),
         UINT64_C(0x67abeacc00000000),
         UINT64_C(0x6b6b056c00000000),
         UINT64_C(0x105fd54900000000),
         UINT64_C(0x1c9f3ae900000000),
         UINT64_C(0x77f4ea4200000000),
         UINT64_C(0x7b3405e200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0c00200000000000),
         UINT64_C(0x0002800000000000),
         UINT64_C(0x0c02a00000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0c00200000000000),
         UINT64_C(0x0002800000000000),
         UINT64_C(0x0c02a00000000000),
         UINT64_C(0x1067f00000000000),
         UINT64_C(0x1c67d00000000000),
         UINT64_C(0x1065700000000000),
         UINT64_C(0x1c65500000000000),
         UINT64_C(0x1067f00000000000),
         UINT64_C(0x1c67d00000000000),
         UINT64_C(0x1065700000000000),
         UINT64_C(0x1c65500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0c00200000000),
         UINT64_C(0x3ff0002800000000),
         UINT64_C(0x3ff0c02a00000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0c00200000000),
         UINT64_C(0x3ff0002800000000),
         UINT64_C(0x3ff0c02a00000000),
         UINT64_C(0x3ff1067f00000000),
         UINT64_C(0x3ff1c67d00000000),
         UINT64_C(0x3ff1065700000000),
         UINT64_C(0x3ff1c65500000000),
         UINT64_C(0x3ff1067f00000000),
         UINT64_C(0x3ff1c67d00000000),
         UINT64_C(0x3ff1065700000000),
         UINT64_C(0x3ff1c65500000000)},
        UINT64_C(0xfff8000000000000),
        {0x81,0x4c,0xff,0xf7,0x01,0x43,0x9d,0x3b,0x7e,0x62,
         0x5c,0xc4,0x40,0x9b,0xc2,0x44,0x91,0x33,0x8d,0x6b,0x00}
    },
    {
        /* No.143 delta:2557 weight:3919 */
        11213,
        12,
        6,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xf5fb5b2a00000000),
         UINT64_C(0x6a04ffd900000000),
         UINT64_C(0x9fffa4f300000000),
         UINT64_C(0x4271008f00000000),
         UINT64_C(0xb78a5ba500000000),
         UINT64_C(0x2875ff5600000000),
         UINT64_C(0xdd8ea47c00000000),
         UINT64_C(0x000020c600000000),
         UINT64_C(0xf5fb7bec00000000),
         UINT64_C(0x6a04df1f00000000),
         UINT64_C(0x9fff843500000000),
         UINT64_C(0x4271204900000000),
         UINT64_C(0xb78a7b6300000000),
         UINT64_C(0x2875df9000000000),
         UINT64_C(0xdd8e84ba00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x400a100000000000),
         UINT64_C(0x1120100000000000),
         UINT64_C(0x512a000000000000),
         UINT64_C(0x1001a00000000000),
         UINT64_C(0x500bb00000000000),
         UINT64_C(0x0121b00000000000),
         UINT64_C(0x412ba00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x4009e00000000000),
         UINT64_C(0x1123e00000000000),
         UINT64_C(0x5129f00000000000),
         UINT64_C(0x1002500000000000),
         UINT64_C(0x5008400000000000),
         UINT64_C(0x0122400000000000),
         UINT64_C(0x4128500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff400a100000000),
         UINT64_C(0x3ff1120100000000),
         UINT64_C(0x3ff512a000000000),
         UINT64_C(0x3ff1001a00000000),
         UINT64_C(0x3ff500bb00000000),
         UINT64_C(0x3ff0121b00000000),
         UINT64_C(0x3ff412ba00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff4009e00000000),
         UINT64_C(0x3ff1123e00000000),
         UINT64_C(0x3ff5129f00000000),
         UINT64_C(0x3ff1002500000000),
         UINT64_C(0x3ff5008400000000),
         UINT64_C(0x3ff0122400000000),
         UINT64_C(0x3ff4128500000000)},
        UINT64_C(0xfff8000000000000),
        {0x04,0x62,0x6c,0x19,0x14,0xaf,0x0f,0xe7,0xc7,0x57,
         0xfc,0xa7,0xfa,0xa4,0xa6,0x21,0x1e,0x67,0xd8,0x98,0x00}
    },
    {
        /* No.144 delta:2389 weight:2137 */
        11213,
        46,
        9,
        20,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x47a7854c00000000),
         UINT64_C(0x6c05c4e600000000),
         UINT64_C(0x2ba241aa00000000),
         UINT64_C(0x99e4009000000000),
         UINT64_C(0xde4385dc00000000),
         UINT64_C(0xf5e1c47600000000),
         UINT64_C(0xb246413a00000000),
         UINT64_C(0x00003e7400000000),
         UINT64_C(0x47a7bb3800000000),
         UINT64_C(0x6c05fa9200000000),
         UINT64_C(0x2ba27fde00000000),
         UINT64_C(0x99e43ee400000000),
         UINT64_C(0xde43bba800000000),
         UINT64_C(0xf5e1fa0200000000),
         UINT64_C(0xb2467f4e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0073400000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x1073400000000000),
         UINT64_C(0x000c100000000000),
         UINT64_C(0x007f500000000000),
         UINT64_C(0x100c100000000000),
         UINT64_C(0x107f500000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0070b00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x1070b00000000000),
         UINT64_C(0x000fe00000000000),
         UINT64_C(0x007ca00000000000),
         UINT64_C(0x100fe00000000000),
         UINT64_C(0x107ca00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0073400000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff1073400000000),
         UINT64_C(0x3ff000c100000000),
         UINT64_C(0x3ff007f500000000),
         UINT64_C(0x3ff100c100000000),
         UINT64_C(0x3ff107f500000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0070b00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff1070b00000000),
         UINT64_C(0x3ff000fe00000000),
         UINT64_C(0x3ff007ca00000000),
         UINT64_C(0x3ff100fe00000000),
         UINT64_C(0x3ff107ca00000000)},
        UINT64_C(0xfff8000000000000),
        {0x89,0xf2,0x37,0x11,0xe3,0x03,0xb7,0x3b,0xf7,0xef,
         0xdb,0xfc,0xf4,0x16,0xdb,0x0b,0x67,0xe0,0x07,0x0d,0x00}
    },
    {
        /* No.145 delta:2661 weight:3407 */
        11213,
        17,
        2,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xba35d26100000000),
         UINT64_C(0x0c3dad5500000000),
         UINT64_C(0xb6087f3400000000),
         UINT64_C(0x9935009100000000),
         UINT64_C(0x2300d2f000000000),
         UINT64_C(0x9508adc400000000),
         UINT64_C(0x2f3d7fa500000000),
         UINT64_C(0x00003e0400000000),
         UINT64_C(0xba35ec6500000000),
         UINT64_C(0x0c3d935100000000),
         UINT64_C(0xb608413000000000),
         UINT64_C(0x99353e9500000000),
         UINT64_C(0x2300ecf400000000),
         UINT64_C(0x950893c000000000),
         UINT64_C(0x2f3d41a100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0070000000000000),
         UINT64_C(0x4048200000000000),
         UINT64_C(0x4038200000000000),
         UINT64_C(0xd02c300000000000),
         UINT64_C(0xd05c300000000000),
         UINT64_C(0x9064100000000000),
         UINT64_C(0x9014100000000000),
         UINT64_C(0x004ff00000000000),
         UINT64_C(0x003ff00000000000),
         UINT64_C(0x4007d00000000000),
         UINT64_C(0x4077d00000000000),
         UINT64_C(0xd063c00000000000),
         UINT64_C(0xd013c00000000000),
         UINT64_C(0x902be00000000000),
         UINT64_C(0x905be00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0070000000000),
         UINT64_C(0x3ff4048200000000),
         UINT64_C(0x3ff4038200000000),
         UINT64_C(0x3ffd02c300000000),
         UINT64_C(0x3ffd05c300000000),
         UINT64_C(0x3ff9064100000000),
         UINT64_C(0x3ff9014100000000),
         UINT64_C(0x3ff004ff00000000),
         UINT64_C(0x3ff003ff00000000),
         UINT64_C(0x3ff4007d00000000),
         UINT64_C(0x3ff4077d00000000),
         UINT64_C(0x3ffd063c00000000),
         UINT64_C(0x3ffd013c00000000),
         UINT64_C(0x3ff902be00000000),
         UINT64_C(0x3ff905be00000000)},
        UINT64_C(0xfff8000000000000),
        {0xf6,0x93,0xad,0xf3,0x11,0x05,0xb2,0xe2,0xbd,0x17,
         0x42,0x22,0xf4,0x34,0xf8,0x2f,0x52,0x8a,0x82,0x8b,0x00}
    },
    {
        /* No.146 delta:7503 weight:2741 */
        11213,
        24,
        16,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc6795b3600000000),
         UINT64_C(0x84cb031b00000000),
         UINT64_C(0x42b2582d00000000),
         UINT64_C(0xc3d1009200000000),
         UINT64_C(0x05a85ba400000000),
         UINT64_C(0x471a038900000000),
         UINT64_C(0x816358bf00000000),
         UINT64_C(0x000053d500000000),
         UINT64_C(0xc67908e300000000),
         UINT64_C(0x84cb50ce00000000),
         UINT64_C(0x42b20bf800000000),
         UINT64_C(0xc3d1534700000000),
         UINT64_C(0x05a8087100000000),
         UINT64_C(0x471a505c00000000),
         UINT64_C(0x81630b6a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x42a5000000000000),
         UINT64_C(0x216b100000000000),
         UINT64_C(0x63ce100000000000),
         UINT64_C(0x1228900000000000),
         UINT64_C(0x508d900000000000),
         UINT64_C(0x3343800000000000),
         UINT64_C(0x71e6800000000000),
         UINT64_C(0x8843f00000000000),
         UINT64_C(0xcae6f00000000000),
         UINT64_C(0xa928e00000000000),
         UINT64_C(0xeb8de00000000000),
         UINT64_C(0x9a6b600000000000),
         UINT64_C(0xd8ce600000000000),
         UINT64_C(0xbb00700000000000),
         UINT64_C(0xf9a5700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff42a5000000000),
         UINT64_C(0x3ff216b100000000),
         UINT64_C(0x3ff63ce100000000),
         UINT64_C(0x3ff1228900000000),
         UINT64_C(0x3ff508d900000000),
         UINT64_C(0x3ff3343800000000),
         UINT64_C(0x3ff71e6800000000),
         UINT64_C(0x3ff8843f00000000),
         UINT64_C(0x3ffcae6f00000000),
         UINT64_C(0x3ffa928e00000000),
         UINT64_C(0x3ffeb8de00000000),
         UINT64_C(0x3ff9a6b600000000),
         UINT64_C(0x3ffd8ce600000000),
         UINT64_C(0x3ffbb00700000000),
         UINT64_C(0x3fff9a5700000000)},
        UINT64_C(0xfff8000000000000),
        {0x52,0xe6,0x17,0x17,0x9f,0x34,0x8f,0xc0,0x16,0xcc,
         0x07,0xe0,0x58,0xbb,0x48,0x32,0x8d,0x17,0x18,0x94,0x00}
    },
    {
        /* No.147 delta:2429 weight:3161 */
        11213,
        37,
        17,
        15,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x317a8d0500000000),
         UINT64_C(0x7f8da54d00000000),
         UINT64_C(0x4ef7284800000000),
         UINT64_C(0x3a91009300000000),
         UINT64_C(0x0beb8d9600000000),
         UINT64_C(0x451ca5de00000000),
         UINT64_C(0x746628db00000000),
         UINT64_C(0x0000e1e500000000),
         UINT64_C(0x317a6ce000000000),
         UINT64_C(0x7f8d44a800000000),
         UINT64_C(0x4ef7c9ad00000000),
         UINT64_C(0x3a91e17600000000),
         UINT64_C(0x0beb6c7300000000),
         UINT64_C(0x451c443b00000000),
         UINT64_C(0x7466c93e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0008600000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0008600000000000),
         UINT64_C(0x0003400000000000),
         UINT64_C(0x000b200000000000),
         UINT64_C(0x0003400000000000),
         UINT64_C(0x000b200000000000),
         UINT64_C(0x2283f00000000000),
         UINT64_C(0x228b900000000000),
         UINT64_C(0x2283f00000000000),
         UINT64_C(0x228b900000000000),
         UINT64_C(0x2280b00000000000),
         UINT64_C(0x2288d00000000000),
         UINT64_C(0x2280b00000000000),
         UINT64_C(0x2288d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0008600000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0008600000000),
         UINT64_C(0x3ff0003400000000),
         UINT64_C(0x3ff000b200000000),
         UINT64_C(0x3ff0003400000000),
         UINT64_C(0x3ff000b200000000),
         UINT64_C(0x3ff2283f00000000),
         UINT64_C(0x3ff228b900000000),
         UINT64_C(0x3ff2283f00000000),
         UINT64_C(0x3ff228b900000000),
         UINT64_C(0x3ff2280b00000000),
         UINT64_C(0x3ff2288d00000000),
         UINT64_C(0x3ff2280b00000000),
         UINT64_C(0x3ff2288d00000000)},
        UINT64_C(0xfff8000000000000),
        {0xf7,0x02,0x63,0xc8,0x61,0x8b,0x05,0x3b,0xc6,0xa9,
         0x5e,0x21,0xfc,0x24,0x0f,0xf2,0x08,0x0a,0x25,0x78,0x00}
    },
    {
        /* No.148 delta:2542 weight:2081 */
        11213,
        30,
        5,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x394e93c600000000),
         UINT64_C(0x07b3362300000000),
         UINT64_C(0x3efda5e500000000),
         UINT64_C(0xa548009400000000),
         UINT64_C(0x9c06935200000000),
         UINT64_C(0xa2fb36b700000000),
         UINT64_C(0x9bb5a57100000000),
         UINT64_C(0x0000821e00000000),
         UINT64_C(0x394e11d800000000),
         UINT64_C(0x07b3b43d00000000),
         UINT64_C(0x3efd27fb00000000),
         UINT64_C(0xa548828a00000000),
         UINT64_C(0x9c06114c00000000),
         UINT64_C(0xa2fbb4a900000000),
         UINT64_C(0x9bb5276f00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc100000000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0xf100000000000000),
         UINT64_C(0xc000000000000000),
         UINT64_C(0x0100000000000000),
         UINT64_C(0xf000000000000000),
         UINT64_C(0x3100000000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0xd103f00000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0xe103f00000000000),
         UINT64_C(0xd003f00000000000),
         UINT64_C(0x1103f00000000000),
         UINT64_C(0xe003f00000000000),
         UINT64_C(0x2103f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffc100000000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3fff100000000000),
         UINT64_C(0x3ffc000000000000),
         UINT64_C(0x3ff0100000000000),
         UINT64_C(0x3fff000000000000),
         UINT64_C(0x3ff3100000000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ffd103f00000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ffe103f00000000),
         UINT64_C(0x3ffd003f00000000),
         UINT64_C(0x3ff1103f00000000),
         UINT64_C(0x3ffe003f00000000),
         UINT64_C(0x3ff2103f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x40,0xe0,0x30,0xa6,0x52,0x14,0xcb,0x00,0xb8,0x29,
         0x1a,0x90,0x0c,0x26,0x6f,0x83,0x88,0x80,0xc5,0xa4,0x00}
    },
    {
        /* No.149 delta:2654 weight:3675 */
        11213,
        11,
        6,
        10,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x717a9f5a00000000),
         UINT64_C(0xbb89ba2600000000),
         UINT64_C(0xcaf3257c00000000),
         UINT64_C(0x40e1009500000000),
         UINT64_C(0x319b9fcf00000000),
         UINT64_C(0xfb68bab300000000),
         UINT64_C(0x8a1225e900000000),
         UINT64_C(0x0000516900000000),
         UINT64_C(0x717ace3300000000),
         UINT64_C(0xbb89eb4f00000000),
         UINT64_C(0xcaf3741500000000),
         UINT64_C(0x40e151fc00000000),
         UINT64_C(0x319bcea600000000),
         UINT64_C(0xfb68ebda00000000),
         UINT64_C(0x8a12748000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1044800000000000),
         UINT64_C(0x7000800000000000),
         UINT64_C(0x6044000000000000),
         UINT64_C(0x0003c00000000000),
         UINT64_C(0x1047400000000000),
         UINT64_C(0x7003400000000000),
         UINT64_C(0x6047c00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x1047700000000000),
         UINT64_C(0x7003700000000000),
         UINT64_C(0x6047f00000000000),
         UINT64_C(0x0000300000000000),
         UINT64_C(0x1044b00000000000),
         UINT64_C(0x7000b00000000000),
         UINT64_C(0x6044300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1044800000000),
         UINT64_C(0x3ff7000800000000),
         UINT64_C(0x3ff6044000000000),
         UINT64_C(0x3ff0003c00000000),
         UINT64_C(0x3ff1047400000000),
         UINT64_C(0x3ff7003400000000),
         UINT64_C(0x3ff6047c00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff1047700000000),
         UINT64_C(0x3ff7003700000000),
         UINT64_C(0x3ff6047f00000000),
         UINT64_C(0x3ff0000300000000),
         UINT64_C(0x3ff1044b00000000),
         UINT64_C(0x3ff7000b00000000),
         UINT64_C(0x3ff6044300000000)},
        UINT64_C(0xfff8000000000000),
        {0x9e,0xb3,0xf4,0xff,0x0f,0x8e,0x1a,0x5b,0xff,0x75,
         0x74,0xfc,0xcb,0xdc,0xd3,0x01,0x2d,0x81,0xba,0x52,0x00}
    },
    {
        /* No.150 delta:2327 weight:3229 */
        11213,
        41,
        9,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe33d1f7100000000),
         UINT64_C(0x11fae37000000000),
         UINT64_C(0xf2c7fc0100000000),
         UINT64_C(0xf6ef009600000000),
         UINT64_C(0x15d21fe700000000),
         UINT64_C(0xe715e3e600000000),
         UINT64_C(0x0428fc9700000000),
         UINT64_C(0x0000aa5800000000),
         UINT64_C(0xe33db52900000000),
         UINT64_C(0x11fa492800000000),
         UINT64_C(0xf2c7565900000000),
         UINT64_C(0xf6efaace00000000),
         UINT64_C(0x15d2b5bf00000000),
         UINT64_C(0xe71549be00000000),
         UINT64_C(0x042856cf00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1020800000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x4020800000000000),
         UINT64_C(0x0800000000000000),
         UINT64_C(0x1820800000000000),
         UINT64_C(0x5800000000000000),
         UINT64_C(0x4820800000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x4023700000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x1023700000000000),
         UINT64_C(0x5803f00000000000),
         UINT64_C(0x4823700000000000),
         UINT64_C(0x0803f00000000000),
         UINT64_C(0x1823700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1020800000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff4020800000000),
         UINT64_C(0x3ff0800000000000),
         UINT64_C(0x3ff1820800000000),
         UINT64_C(0x3ff5800000000000),
         UINT64_C(0x3ff4820800000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff4023700000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff1023700000000),
         UINT64_C(0x3ff5803f00000000),
         UINT64_C(0x3ff4823700000000),
         UINT64_C(0x3ff0803f00000000),
         UINT64_C(0x3ff1823700000000)},
        UINT64_C(0xfff8000000000000),
        {0xc2,0x50,0x4d,0x88,0xe4,0x83,0xb3,0x77,0xeb,0x0b,
         0x66,0x37,0xf8,0xf0,0x0e,0x23,0x25,0x7a,0xb0,0xd9,0x00}
    },
    {
        /* No.151 delta:3991 weight:3101 */
        11213,
        24,
        17,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5c975c0600000000),
         UINT64_C(0x7a2be18700000000),
         UINT64_C(0x26bcbd8100000000),
         UINT64_C(0x6df2009700000000),
         UINT64_C(0x31655c9100000000),
         UINT64_C(0x17d9e11000000000),
         UINT64_C(0x4b4ebd1600000000),
         UINT64_C(0x00002b8700000000),
         UINT64_C(0x5c97778100000000),
         UINT64_C(0x7a2bca0000000000),
         UINT64_C(0x26bc960600000000),
         UINT64_C(0x6df22b1000000000),
         UINT64_C(0x3165771600000000),
         UINT64_C(0x17d9ca9700000000),
         UINT64_C(0x4b4e969100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4c03400000000000),
         UINT64_C(0x4060900000000000),
         UINT64_C(0x0c63d00000000000),
         UINT64_C(0x4012000000000000),
         UINT64_C(0x0c11400000000000),
         UINT64_C(0x0072900000000000),
         UINT64_C(0x4c71d00000000000),
         UINT64_C(0x112bf00000000000),
         UINT64_C(0x5d28b00000000000),
         UINT64_C(0x514b600000000000),
         UINT64_C(0x1d48200000000000),
         UINT64_C(0x5139f00000000000),
         UINT64_C(0x1d3ab00000000000),
         UINT64_C(0x1159600000000000),
         UINT64_C(0x5d5a200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4c03400000000),
         UINT64_C(0x3ff4060900000000),
         UINT64_C(0x3ff0c63d00000000),
         UINT64_C(0x3ff4012000000000),
         UINT64_C(0x3ff0c11400000000),
         UINT64_C(0x3ff0072900000000),
         UINT64_C(0x3ff4c71d00000000),
         UINT64_C(0x3ff112bf00000000),
         UINT64_C(0x3ff5d28b00000000),
         UINT64_C(0x3ff514b600000000),
         UINT64_C(0x3ff1d48200000000),
         UINT64_C(0x3ff5139f00000000),
         UINT64_C(0x3ff1d3ab00000000),
         UINT64_C(0x3ff1159600000000),
         UINT64_C(0x3ff5d5a200000000)},
        UINT64_C(0xfff8000000000000),
        {0xf4,0x7d,0x9d,0x65,0x83,0x04,0xd5,0xe9,0xc0,0xa5,
         0xb4,0xfb,0x24,0x5b,0xab,0x1e,0xec,0x70,0x48,0x97,0x00}
    },
    {
        /* No.152 delta:2134 weight:2873 */
        11213,
        23,
        8,
        7,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x82b4dc9d00000000),
         UINT64_C(0xa5bc5a0300000000),
         UINT64_C(0x2708869e00000000),
         UINT64_C(0x753b009800000000),
         UINT64_C(0xf78fdc0500000000),
         UINT64_C(0xd0875a9b00000000),
         UINT64_C(0x5233860600000000),
         UINT64_C(0x0000344500000000),
         UINT64_C(0x82b4e8d800000000),
         UINT64_C(0xa5bc6e4600000000),
         UINT64_C(0x2708b2db00000000),
         UINT64_C(0x753b34dd00000000),
         UINT64_C(0xf78fe84000000000),
         UINT64_C(0xd0876ede00000000),
         UINT64_C(0x5233b24300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0040800000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0040800000000000),
         UINT64_C(0x3180000000000000),
         UINT64_C(0x31c0800000000000),
         UINT64_C(0x3180000000000000),
         UINT64_C(0x31c0800000000000),
         UINT64_C(0x0123f00000000000),
         UINT64_C(0x0163700000000000),
         UINT64_C(0x0123f00000000000),
         UINT64_C(0x0163700000000000),
         UINT64_C(0x30a3f00000000000),
         UINT64_C(0x30e3700000000000),
         UINT64_C(0x30a3f00000000000),
         UINT64_C(0x30e3700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0040800000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0040800000000),
         UINT64_C(0x3ff3180000000000),
         UINT64_C(0x3ff31c0800000000),
         UINT64_C(0x3ff3180000000000),
         UINT64_C(0x3ff31c0800000000),
         UINT64_C(0x3ff0123f00000000),
         UINT64_C(0x3ff0163700000000),
         UINT64_C(0x3ff0123f00000000),
         UINT64_C(0x3ff0163700000000),
         UINT64_C(0x3ff30a3f00000000),
         UINT64_C(0x3ff30e3700000000),
         UINT64_C(0x3ff30a3f00000000),
         UINT64_C(0x3ff30e3700000000)},
        UINT64_C(0xfff8000000000000),
        {0xec,0x34,0x65,0xa3,0xfd,0x98,0xa5,0xd2,0x9b,0xd6,
         0x4a,0xfd,0x80,0x30,0x80,0xcb,0x9b,0xcc,0x54,0x75,0x00}
    },
    {
        /* No.153 delta:2940 weight:3633 */
        11213,
        39,
        8,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xd7f3083f00000000),
         UINT64_C(0x8009eb2c00000000),
         UINT64_C(0x57fae31300000000),
         UINT64_C(0x0400009900000000),
         UINT64_C(0xd3f308a600000000),
         UINT64_C(0x8409ebb500000000),
         UINT64_C(0x53fae38a00000000),
         UINT64_C(0x0000becf00000000),
         UINT64_C(0xd7f3b6f000000000),
         UINT64_C(0x800955e300000000),
         UINT64_C(0x57fa5ddc00000000),
         UINT64_C(0x0400be5600000000),
         UINT64_C(0xd3f3b66900000000),
         UINT64_C(0x8409557a00000000),
         UINT64_C(0x53fa5d4500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0002000000000000),
         UINT64_C(0x1800800000000000),
         UINT64_C(0x1802800000000000),
         UINT64_C(0x1010800000000000),
         UINT64_C(0x1012800000000000),
         UINT64_C(0x0810000000000000),
         UINT64_C(0x0812000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0001f00000000000),
         UINT64_C(0x1803700000000000),
         UINT64_C(0x1801700000000000),
         UINT64_C(0x1013700000000000),
         UINT64_C(0x1011700000000000),
         UINT64_C(0x0813f00000000000),
         UINT64_C(0x0811f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0002000000000),
         UINT64_C(0x3ff1800800000000),
         UINT64_C(0x3ff1802800000000),
         UINT64_C(0x3ff1010800000000),
         UINT64_C(0x3ff1012800000000),
         UINT64_C(0x3ff0810000000000),
         UINT64_C(0x3ff0812000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0001f00000000),
         UINT64_C(0x3ff1803700000000),
         UINT64_C(0x3ff1801700000000),
         UINT64_C(0x3ff1013700000000),
         UINT64_C(0x3ff1011700000000),
         UINT64_C(0x3ff0813f00000000),
         UINT64_C(0x3ff0811f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x24,0xf6,0xb9,0x63,0x79,0x61,0xba,0xa2,0xa2,0x24,
         0x47,0x2a,0x34,0x1d,0xe6,0x9a,0xcf,0xac,0x06,0x2a,0x00}
    },
    {
        /* No.154 delta:2576 weight:3415 */
        11213,
        6,
        8,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x47ad15b300000000),
         UINT64_C(0x36fa7f9600000000),
         UINT64_C(0x71576a2500000000),
         UINT64_C(0x8ef5009a00000000),
         UINT64_C(0xc958152900000000),
         UINT64_C(0xb80f7f0c00000000),
         UINT64_C(0xffa26abf00000000),
         UINT64_C(0x00004a0400000000),
         UINT64_C(0x47ad5fb700000000),
         UINT64_C(0x36fa359200000000),
         UINT64_C(0x7157202100000000),
         UINT64_C(0x8ef54a9e00000000),
         UINT64_C(0xc9585f2d00000000),
         UINT64_C(0xb80f350800000000),
         UINT64_C(0xffa220bb00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2080800000000000),
         UINT64_C(0x6020800000000000),
         UINT64_C(0x40a0000000000000),
         UINT64_C(0x710a100000000000),
         UINT64_C(0x518a900000000000),
         UINT64_C(0x112a900000000000),
         UINT64_C(0x31aa100000000000),
         UINT64_C(0x0293f00000000000),
         UINT64_C(0x2213700000000000),
         UINT64_C(0x62b3700000000000),
         UINT64_C(0x4233f00000000000),
         UINT64_C(0x7399e00000000000),
         UINT64_C(0x5319600000000000),
         UINT64_C(0x13b9600000000000),
         UINT64_C(0x3339e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2080800000000),
         UINT64_C(0x3ff6020800000000),
         UINT64_C(0x3ff40a0000000000),
         UINT64_C(0x3ff710a100000000),
         UINT64_C(0x3ff518a900000000),
         UINT64_C(0x3ff112a900000000),
         UINT64_C(0x3ff31aa100000000),
         UINT64_C(0x3ff0293f00000000),
         UINT64_C(0x3ff2213700000000),
         UINT64_C(0x3ff62b3700000000),
         UINT64_C(0x3ff4233f00000000),
         UINT64_C(0x3ff7399e00000000),
         UINT64_C(0x3ff5319600000000),
         UINT64_C(0x3ff13b9600000000),
         UINT64_C(0x3ff3339e00000000)},
        UINT64_C(0xfff8000000000000),
        {0xf4,0xba,0x5b,0xa2,0x3f,0xfd,0xc3,0xf5,0xea,0x58,
         0xcd,0x56,0xeb,0x6e,0x18,0x50,0x08,0x37,0xe3,0x47,0x00}
    },
    {
        /* No.155 delta:2083 weight:1555 */
        11213,
        36,
        10,
        21,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xea9ee74c00000000),
         UINT64_C(0x34ac7dfc00000000),
         UINT64_C(0xde329ab000000000),
         UINT64_C(0xa3b6009b00000000),
         UINT64_C(0x4928e7d700000000),
         UINT64_C(0x971a7d6700000000),
         UINT64_C(0x7d849a2b00000000),
         UINT64_C(0x000043e300000000),
         UINT64_C(0xea9ea4af00000000),
         UINT64_C(0x34ac3e1f00000000),
         UINT64_C(0xde32d95300000000),
         UINT64_C(0xa3b6437800000000),
         UINT64_C(0x4928a43400000000),
         UINT64_C(0x971a3e8400000000),
         UINT64_C(0x7d84d9c800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1007000000000000),
         UINT64_C(0x0003e00000000000),
         UINT64_C(0x1004e00000000000),
         UINT64_C(0x6008000000000000),
         UINT64_C(0x700f000000000000),
         UINT64_C(0x600be00000000000),
         UINT64_C(0x700ce00000000000),
         UINT64_C(0x4023f00000000000),
         UINT64_C(0x5024f00000000000),
         UINT64_C(0x4020100000000000),
         UINT64_C(0x5027100000000000),
         UINT64_C(0x202bf00000000000),
         UINT64_C(0x302cf00000000000),
         UINT64_C(0x2028100000000000),
         UINT64_C(0x302f100000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1007000000000),
         UINT64_C(0x3ff0003e00000000),
         UINT64_C(0x3ff1004e00000000),
         UINT64_C(0x3ff6008000000000),
         UINT64_C(0x3ff700f000000000),
         UINT64_C(0x3ff600be00000000),
         UINT64_C(0x3ff700ce00000000),
         UINT64_C(0x3ff4023f00000000),
         UINT64_C(0x3ff5024f00000000),
         UINT64_C(0x3ff4020100000000),
         UINT64_C(0x3ff5027100000000),
         UINT64_C(0x3ff202bf00000000),
         UINT64_C(0x3ff302cf00000000),
         UINT64_C(0x3ff2028100000000),
         UINT64_C(0x3ff302f100000000)},
        UINT64_C(0xfff8000000000000),
        {0xbe,0x66,0xa2,0xbb,0x52,0x63,0x33,0xbf,0x66,0x1e,
         0x49,0x00,0x2e,0xc5,0x91,0xdd,0xd9,0x01,0x89,0x2b,0x00}
    },
    {
        /* No.156 delta:1987 weight:3411 */
        11213,
        24,
        14,
        18,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x83ff684000000000),
         UINT64_C(0xcb1ef2b300000000),
         UINT64_C(0x48e19af300000000),
         UINT64_C(0xe1fd009c00000000),
         UINT64_C(0x620268dc00000000),
         UINT64_C(0x2ae3f22f00000000),
         UINT64_C(0xa91c9a6f00000000),
         UINT64_C(0x0000e82100000000),
         UINT64_C(0x83ff806100000000),
         UINT64_C(0xcb1e1a9200000000),
         UINT64_C(0x48e172d200000000),
         UINT64_C(0xe1fde8bd00000000),
         UINT64_C(0x620280fd00000000),
         UINT64_C(0x2ae31a0e00000000),
         UINT64_C(0xa91c724e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2001300000000000),
         UINT64_C(0x0043000000000000),
         UINT64_C(0x2042300000000000),
         UINT64_C(0x3002c00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x3041c00000000000),
         UINT64_C(0x1040f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x2002c00000000000),
         UINT64_C(0x0040f00000000000),
         UINT64_C(0x2041c00000000000),
         UINT64_C(0x3001300000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x3042300000000000),
         UINT64_C(0x1043000000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2001300000000),
         UINT64_C(0x3ff0043000000000),
         UINT64_C(0x3ff2042300000000),
         UINT64_C(0x3ff3002c00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff3041c00000000),
         UINT64_C(0x3ff1040f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff2002c00000000),
         UINT64_C(0x3ff0040f00000000),
         UINT64_C(0x3ff2041c00000000),
         UINT64_C(0x3ff3001300000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff3042300000000),
         UINT64_C(0x3ff1043000000000)},
        UINT64_C(0xfff8000000000000),
        {0x5d,0xb9,0xe8,0xbf,0xde,0x6f,0x75,0x47,0xf2,0x3e,
         0x8d,0x3d,0x7b,0x2c,0x99,0xb0,0x6e,0x9b,0xa4,0x29,0x00}
    },
    {
        /* No.157 delta:5818 weight:3287 */
        11213,
        16,
        1,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3bbcacf500000000),
         UINT64_C(0x55b16fbc00000000),
         UINT64_C(0x6e0dc34900000000),
         UINT64_C(0x8555009d00000000),
         UINT64_C(0xbee9ac6800000000),
         UINT64_C(0xd0e46f2100000000),
         UINT64_C(0xeb58c3d400000000),
         UINT64_C(0x0000479500000000),
         UINT64_C(0x3bbceb6000000000),
         UINT64_C(0x55b1282900000000),
         UINT64_C(0x6e0d84dc00000000),
         UINT64_C(0x8555470800000000),
         UINT64_C(0xbee9ebfd00000000),
         UINT64_C(0xd0e428b400000000),
         UINT64_C(0xeb58844100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5c06400000000000),
         UINT64_C(0x0933000000000000),
         UINT64_C(0x5535400000000000),
         UINT64_C(0x6002400000000000),
         UINT64_C(0x3c04000000000000),
         UINT64_C(0x6931400000000000),
         UINT64_C(0x3537000000000000),
         UINT64_C(0x011bf00000000000),
         UINT64_C(0x5d1db00000000000),
         UINT64_C(0x0828f00000000000),
         UINT64_C(0x542eb00000000000),
         UINT64_C(0x6119b00000000000),
         UINT64_C(0x3d1ff00000000000),
         UINT64_C(0x682ab00000000000),
         UINT64_C(0x342cf00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff5c06400000000),
         UINT64_C(0x3ff0933000000000),
         UINT64_C(0x3ff5535400000000),
         UINT64_C(0x3ff6002400000000),
         UINT64_C(0x3ff3c04000000000),
         UINT64_C(0x3ff6931400000000),
         UINT64_C(0x3ff3537000000000),
         UINT64_C(0x3ff011bf00000000),
         UINT64_C(0x3ff5d1db00000000),
         UINT64_C(0x3ff0828f00000000),
         UINT64_C(0x3ff542eb00000000),
         UINT64_C(0x3ff6119b00000000),
         UINT64_C(0x3ff3d1ff00000000),
         UINT64_C(0x3ff682ab00000000),
         UINT64_C(0x3ff342cf00000000)},
        UINT64_C(0xfff8000000000000),
        {0x87,0x04,0x1e,0x6a,0x42,0xf8,0x97,0xc1,0xab,0x77,
         0xef,0x7f,0x00,0x11,0xd8,0x98,0x42,0x66,0x53,0xc2,0x00}
    },
    {
        /* No.158 delta:2090 weight:2523 */
        11213,
        44,
        4,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x5cf2544100000000),
         UINT64_C(0x7abd4fbb00000000),
         UINT64_C(0x264f1bfa00000000),
         UINT64_C(0x8de0009e00000000),
         UINT64_C(0xd11254df00000000),
         UINT64_C(0xf75d4f2500000000),
         UINT64_C(0xabaf1b6400000000),
         UINT64_C(0x0000b87700000000),
         UINT64_C(0x5cf2ec3600000000),
         UINT64_C(0x7abdf7cc00000000),
         UINT64_C(0x264fa38d00000000),
         UINT64_C(0x8de0b8e900000000),
         UINT64_C(0xd112eca800000000),
         UINT64_C(0xf75df75200000000),
         UINT64_C(0xabafa31300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1041c00000000000),
         UINT64_C(0x4000100000000000),
         UINT64_C(0x5041d00000000000),
         UINT64_C(0x1002c00000000000),
         UINT64_C(0x0043000000000000),
         UINT64_C(0x5002d00000000000),
         UINT64_C(0x4043100000000000),
         UINT64_C(0x8003f00000000000),
         UINT64_C(0x9042300000000000),
         UINT64_C(0xc003e00000000000),
         UINT64_C(0xd042200000000000),
         UINT64_C(0x9001300000000000),
         UINT64_C(0x8040f00000000000),
         UINT64_C(0xd001200000000000),
         UINT64_C(0xc040e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1041c00000000),
         UINT64_C(0x3ff4000100000000),
         UINT64_C(0x3ff5041d00000000),
         UINT64_C(0x3ff1002c00000000),
         UINT64_C(0x3ff0043000000000),
         UINT64_C(0x3ff5002d00000000),
         UINT64_C(0x3ff4043100000000),
         UINT64_C(0x3ff8003f00000000),
         UINT64_C(0x3ff9042300000000),
         UINT64_C(0x3ffc003e00000000),
         UINT64_C(0x3ffd042200000000),
         UINT64_C(0x3ff9001300000000),
         UINT64_C(0x3ff8040f00000000),
         UINT64_C(0x3ffd001200000000),
         UINT64_C(0x3ffc040e00000000)},
        UINT64_C(0xfff8000000000000),
        {0xbb,0xf3,0xf4,0x59,0x84,0x41,0xc0,0x8b,0x8e,0xe8,
         0x96,0x16,0x9c,0xf3,0x96,0xd9,0x34,0x0b,0x0d,0xe4,0x00}
    },
    {
        /* No.159 delta:2051 weight:3709 */
        11213,
        33,
        5,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xaed3d9c600000000),
         UINT64_C(0xb22ab55700000000),
         UINT64_C(0x1cf96c9100000000),
         UINT64_C(0x69cf009f00000000),
         UINT64_C(0xc71cd95900000000),
         UINT64_C(0xdbe5b5c800000000),
         UINT64_C(0x75366c0e00000000),
         UINT64_C(0x0000e1e700000000),
         UINT64_C(0xaed3382100000000),
         UINT64_C(0xb22a54b000000000),
         UINT64_C(0x1cf98d7600000000),
         UINT64_C(0x69cfe17800000000),
         UINT64_C(0xc71c38be00000000),
         UINT64_C(0xdbe5542f00000000),
         UINT64_C(0x75368de900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0030000000000000),
         UINT64_C(0x8000000000000000),
         UINT64_C(0x8030000000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x5030000000000000),
         UINT64_C(0xd000000000000000),
         UINT64_C(0xd030000000000000),
         UINT64_C(0x9003f00000000000),
         UINT64_C(0x9033f00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x1033f00000000000),
         UINT64_C(0xc003f00000000000),
         UINT64_C(0xc033f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x4033f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0030000000000),
         UINT64_C(0x3ff8000000000000),
         UINT64_C(0x3ff8030000000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff5030000000000),
         UINT64_C(0x3ffd000000000000),
         UINT64_C(0x3ffd030000000000),
         UINT64_C(0x3ff9003f00000000),
         UINT64_C(0x3ff9033f00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff1033f00000000),
         UINT64_C(0x3ffc003f00000000),
         UINT64_C(0x3ffc033f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff4033f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x3b,0xd5,0x62,0x08,0x98,0x46,0x48,0x0e,0x2f,0x7f,
         0x75,0xf3,0xfc,0x74,0x3b,0xf3,0x68,0xd7,0xb3,0xc3,0x00}
    },
    {
        /* No.160 delta:4152 weight:2997 */
        11213,
        27,
        20,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x788a889800000000),
         UINT64_C(0x0c859ba000000000),
         UINT64_C(0x740f133800000000),
         UINT64_C(0x928000a000000000),
         UINT64_C(0xea0a883800000000),
         UINT64_C(0x9e059b0000000000),
         UINT64_C(0xe68f139800000000),
         UINT64_C(0x00000a5100000000),
         UINT64_C(0x788a82c900000000),
         UINT64_C(0x0c8591f100000000),
         UINT64_C(0x740f196900000000),
         UINT64_C(0x92800af100000000),
         UINT64_C(0xea0a826900000000),
         UINT64_C(0x9e05915100000000),
         UINT64_C(0xe68f19c900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1051b00000000000),
         UINT64_C(0x1003600000000000),
         UINT64_C(0x0052d00000000000),
         UINT64_C(0x6440600000000000),
         UINT64_C(0x7411d00000000000),
         UINT64_C(0x7443000000000000),
         UINT64_C(0x6412b00000000000),
         UINT64_C(0x0203f00000000000),
         UINT64_C(0x1252400000000000),
         UINT64_C(0x1200900000000000),
         UINT64_C(0x0251200000000000),
         UINT64_C(0x6643900000000000),
         UINT64_C(0x7612200000000000),
         UINT64_C(0x7640f00000000000),
         UINT64_C(0x6611400000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1051b00000000),
         UINT64_C(0x3ff1003600000000),
         UINT64_C(0x3ff0052d00000000),
         UINT64_C(0x3ff6440600000000),
         UINT64_C(0x3ff7411d00000000),
         UINT64_C(0x3ff7443000000000),
         UINT64_C(0x3ff6412b00000000),
         UINT64_C(0x3ff0203f00000000),
         UINT64_C(0x3ff1252400000000),
         UINT64_C(0x3ff1200900000000),
         UINT64_C(0x3ff0251200000000),
         UINT64_C(0x3ff6643900000000),
         UINT64_C(0x3ff7612200000000),
         UINT64_C(0x3ff7640f00000000),
         UINT64_C(0x3ff6611400000000)},
        UINT64_C(0xfff8000000000000),
        {0xb9,0x68,0x78,0x5c,0xd0,0x81,0x18,0xfe,0xe8,0x81,
         0x5d,0x37,0x13,0x70,0xf2,0x14,0xab,0x99,0xa4,0x7f,0x00}
    },
    {
        /* No.161 delta:4511 weight:1889 */
        11213,
        4,
        1,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa32f6bc100000000),
         UINT64_C(0xb8c6e97000000000),
         UINT64_C(0x1be982b100000000),
         UINT64_C(0xec3c00a100000000),
         UINT64_C(0x4f136b6000000000),
         UINT64_C(0x54fae9d100000000),
         UINT64_C(0xf7d5821000000000),
         UINT64_C(0x000075f900000000),
         UINT64_C(0xa32f1e3800000000),
         UINT64_C(0xb8c69c8900000000),
         UINT64_C(0x1be9f74800000000),
         UINT64_C(0xec3c755800000000),
         UINT64_C(0x4f131e9900000000),
         UINT64_C(0x54fa9c2800000000),
         UINT64_C(0xf7d5f7e900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x091c000000000000),
         UINT64_C(0x118fa00000000000),
         UINT64_C(0x1893a00000000000),
         UINT64_C(0x0600000000000000),
         UINT64_C(0x0f1c000000000000),
         UINT64_C(0x178fa00000000000),
         UINT64_C(0x1e93a00000000000),
         UINT64_C(0x605bf00000000000),
         UINT64_C(0x6947f00000000000),
         UINT64_C(0x71d4500000000000),
         UINT64_C(0x78c8500000000000),
         UINT64_C(0x665bf00000000000),
         UINT64_C(0x6f47f00000000000),
         UINT64_C(0x77d4500000000000),
         UINT64_C(0x7ec8500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff091c000000000),
         UINT64_C(0x3ff118fa00000000),
         UINT64_C(0x3ff1893a00000000),
         UINT64_C(0x3ff0600000000000),
         UINT64_C(0x3ff0f1c000000000),
         UINT64_C(0x3ff178fa00000000),
         UINT64_C(0x3ff1e93a00000000),
         UINT64_C(0x3ff605bf00000000),
         UINT64_C(0x3ff6947f00000000),
         UINT64_C(0x3ff71d4500000000),
         UINT64_C(0x3ff78c8500000000),
         UINT64_C(0x3ff665bf00000000),
         UINT64_C(0x3ff6f47f00000000),
         UINT64_C(0x3ff77d4500000000),
         UINT64_C(0x3ff7ec8500000000)},
        UINT64_C(0xfff8000000000000),
        {0x31,0x94,0x36,0xb6,0x4e,0xa1,0x03,0xe8,0xde,0x4d,
         0x4a,0x0b,0xe4,0x6d,0xb4,0xdd,0xf0,0x6c,0x86,0xd9,0x00}
    },
    {
        /* No.162 delta:2557 weight:2049 */
        11213,
        30,
        5,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x528310c600000000),
         UINT64_C(0x4519df7c00000000),
         UINT64_C(0x179acfba00000000),
         UINT64_C(0x2d9200a200000000),
         UINT64_C(0x7f11106400000000),
         UINT64_C(0x688bdfde00000000),
         UINT64_C(0x3a08cf1800000000),
         UINT64_C(0x0000a06400000000),
         UINT64_C(0x5283b0a200000000),
         UINT64_C(0x45197f1800000000),
         UINT64_C(0x179a6fde00000000),
         UINT64_C(0x2d92a0c600000000),
         UINT64_C(0x7f11b00000000000),
         UINT64_C(0x688b7fba00000000),
         UINT64_C(0x3a086f7c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0020800000000000),
         UINT64_C(0x0813800000000000),
         UINT64_C(0x0833000000000000),
         UINT64_C(0x0002400000000000),
         UINT64_C(0x0022c00000000000),
         UINT64_C(0x0811c00000000000),
         UINT64_C(0x0831400000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0023700000000000),
         UINT64_C(0x0810700000000000),
         UINT64_C(0x0830f00000000000),
         UINT64_C(0x0001b00000000000),
         UINT64_C(0x0021300000000000),
         UINT64_C(0x0812300000000000),
         UINT64_C(0x0832b00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0020800000000),
         UINT64_C(0x3ff0813800000000),
         UINT64_C(0x3ff0833000000000),
         UINT64_C(0x3ff0002400000000),
         UINT64_C(0x3ff0022c00000000),
         UINT64_C(0x3ff0811c00000000),
         UINT64_C(0x3ff0831400000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0023700000000),
         UINT64_C(0x3ff0810700000000),
         UINT64_C(0x3ff0830f00000000),
         UINT64_C(0x3ff0001b00000000),
         UINT64_C(0x3ff0021300000000),
         UINT64_C(0x3ff0812300000000),
         UINT64_C(0x3ff0832b00000000)},
        UINT64_C(0xfff8000000000000),
        {0x4e,0x1d,0x9a,0x99,0x1a,0xe4,0x6a,0x87,0x8f,0x67,
         0xd6,0xb4,0x14,0x7d,0xdf,0x7b,0x46,0x6d,0x15,0x39,0x00}
    },
    {
        /* No.163 delta:7894 weight:3463 */
        11213,
        20,
        2,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3313285000000000),
         UINT64_C(0xa0cc277900000000),
         UINT64_C(0x93df0f2900000000),
         UINT64_C(0xa71300a300000000),
         UINT64_C(0x940028f300000000),
         UINT64_C(0x07df27da00000000),
         UINT64_C(0x34cc0f8a00000000),
         UINT64_C(0x0000efbf00000000),
         UINT64_C(0x3313c7ef00000000),
         UINT64_C(0xa0ccc8c600000000),
         UINT64_C(0x93dfe09600000000),
         UINT64_C(0xa713ef1c00000000),
         UINT64_C(0x9400c74c00000000),
         UINT64_C(0x07dfc86500000000),
         UINT64_C(0x34cce03500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1400000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x0400000000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0x2400000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x3400000000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x3403f00000000000),
         UINT64_C(0x3003f00000000000),
         UINT64_C(0x2403f00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x0403f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x1403f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1400000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff0400000000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ff2400000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff3400000000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff3403f00000000),
         UINT64_C(0x3ff3003f00000000),
         UINT64_C(0x3ff2403f00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff0403f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff1403f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x44,0x97,0xa9,0x80,0x53,0xa7,0xe2,0x25,0x73,0x5f,
         0x9a,0x43,0xac,0x6e,0x5f,0x36,0xdf,0x02,0x57,0xed,0x00}
    },
    {
        /* No.164 delta:3195 weight:3805 */
        11213,
        31,
        3,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x15bc64cb00000000),
         UINT64_C(0xcac171d400000000),
         UINT64_C(0xdf7d151f00000000),
         UINT64_C(0x159400a400000000),
         UINT64_C(0x0028646f00000000),
         UINT64_C(0xdf55717000000000),
         UINT64_C(0xcae915bb00000000),
         UINT64_C(0x0000c57700000000),
         UINT64_C(0x15bca1bc00000000),
         UINT64_C(0xcac1b4a300000000),
         UINT64_C(0xdf7dd06800000000),
         UINT64_C(0x1594c5d300000000),
         UINT64_C(0x0028a11800000000),
         UINT64_C(0xdf55b40700000000),
         UINT64_C(0xcae9d0cc00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0003000000000000),
         UINT64_C(0x6034000000000000),
         UINT64_C(0x6037000000000000),
         UINT64_C(0x0010100000000000),
         UINT64_C(0x0013100000000000),
         UINT64_C(0x6024100000000000),
         UINT64_C(0x6027100000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x4000f00000000000),
         UINT64_C(0x2037f00000000000),
         UINT64_C(0x2034f00000000000),
         UINT64_C(0x4013e00000000000),
         UINT64_C(0x4010e00000000000),
         UINT64_C(0x2027e00000000000),
         UINT64_C(0x2024e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0003000000000),
         UINT64_C(0x3ff6034000000000),
         UINT64_C(0x3ff6037000000000),
         UINT64_C(0x3ff0010100000000),
         UINT64_C(0x3ff0013100000000),
         UINT64_C(0x3ff6024100000000),
         UINT64_C(0x3ff6027100000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff4000f00000000),
         UINT64_C(0x3ff2037f00000000),
         UINT64_C(0x3ff2034f00000000),
         UINT64_C(0x3ff4013e00000000),
         UINT64_C(0x3ff4010e00000000),
         UINT64_C(0x3ff2027e00000000),
         UINT64_C(0x3ff2024e00000000)},
        UINT64_C(0xfff8000000000000),
        {0x57,0x2c,0xb5,0x65,0x8b,0x6e,0x7b,0xa3,0x83,0x9f,
         0x81,0xd6,0x4e,0xe2,0x0e,0xd1,0x77,0xe8,0x95,0xf6,0x00}
    },
    {
        /* No.165 delta:2036 weight:3399 */
        11213,
        32,
        18,
        14,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x27f9b40700000000),
         UINT64_C(0x42dd6b0600000000),
         UINT64_C(0x6524df0100000000),
         UINT64_C(0xc88e00a500000000),
         UINT64_C(0xef77b4a200000000),
         UINT64_C(0x8a536ba300000000),
         UINT64_C(0xadaadfa400000000),
         UINT64_C(0x00005d4400000000),
         UINT64_C(0x27f9e94300000000),
         UINT64_C(0x42dd364200000000),
         UINT64_C(0x6524824500000000),
         UINT64_C(0xc88e5de100000000),
         UINT64_C(0xef77e9e600000000),
         UINT64_C(0x8a5336e700000000),
         UINT64_C(0xadaa82e000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe100000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0xa100000000000000),
         UINT64_C(0x5040800000000000),
         UINT64_C(0xb140800000000000),
         UINT64_C(0x1040800000000000),
         UINT64_C(0xf140800000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0xe103f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0xa103f00000000000),
         UINT64_C(0x5043700000000000),
         UINT64_C(0xb143700000000000),
         UINT64_C(0x1043700000000000),
         UINT64_C(0xf143700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffe100000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ffa100000000000),
         UINT64_C(0x3ff5040800000000),
         UINT64_C(0x3ffb140800000000),
         UINT64_C(0x3ff1040800000000),
         UINT64_C(0x3fff140800000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ffe103f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ffa103f00000000),
         UINT64_C(0x3ff5043700000000),
         UINT64_C(0x3ffb143700000000),
         UINT64_C(0x3ff1043700000000),
         UINT64_C(0x3fff143700000000)},
        UINT64_C(0xfff8000000000000),
        {0xea,0x81,0x82,0xf9,0x80,0x8f,0xc0,0xa8,0xac,0x70,
         0x79,0x89,0xe8,0x11,0xde,0xae,0x19,0x95,0x6f,0x85,0x00}
    },
    {
        /* No.166 delta:5115 weight:3837 */
        11213,
        15,
        1,
        7,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xd0bd179e00000000),
         UINT64_C(0x6d8286c600000000),
         UINT64_C(0xbd3f915800000000),
         UINT64_C(0x223c00a600000000),
         UINT64_C(0xf281173800000000),
         UINT64_C(0x4fbe866000000000),
         UINT64_C(0x9f0391fe00000000),
         UINT64_C(0x0000b0d300000000),
         UINT64_C(0xd0bda74d00000000),
         UINT64_C(0x6d82361500000000),
         UINT64_C(0xbd3f218b00000000),
         UINT64_C(0x223cb07500000000),
         UINT64_C(0xf281a7eb00000000),
         UINT64_C(0x4fbe36b300000000),
         UINT64_C(0x9f03212d00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0202000000000000),
         UINT64_C(0x005c000000000000),
         UINT64_C(0x025e000000000000),
         UINT64_C(0x1104000000000000),
         UINT64_C(0x1306000000000000),
         UINT64_C(0x1158000000000000),
         UINT64_C(0x135a000000000000),
         UINT64_C(0x2013f00000000000),
         UINT64_C(0x2211f00000000000),
         UINT64_C(0x204ff00000000000),
         UINT64_C(0x224df00000000000),
         UINT64_C(0x3117f00000000000),
         UINT64_C(0x3315f00000000000),
         UINT64_C(0x314bf00000000000),
         UINT64_C(0x3349f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0202000000000),
         UINT64_C(0x3ff005c000000000),
         UINT64_C(0x3ff025e000000000),
         UINT64_C(0x3ff1104000000000),
         UINT64_C(0x3ff1306000000000),
         UINT64_C(0x3ff1158000000000),
         UINT64_C(0x3ff135a000000000),
         UINT64_C(0x3ff2013f00000000),
         UINT64_C(0x3ff2211f00000000),
         UINT64_C(0x3ff204ff00000000),
         UINT64_C(0x3ff224df00000000),
         UINT64_C(0x3ff3117f00000000),
         UINT64_C(0x3ff3315f00000000),
         UINT64_C(0x3ff314bf00000000),
         UINT64_C(0x3ff3349f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xb3,0xca,0xdd,0x0d,0xc8,0xaf,0x06,0xa0,0x0a,0x3c,
         0x98,0xfa,0x5b,0xcc,0x51,0x08,0x99,0x40,0xde,0x3c,0x00}
    },
    {
        /* No.167 delta:4597 weight:3963 */
        11213,
        17,
        1,
        3,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc31abac000000000),
         UINT64_C(0x3e7a8edb00000000),
         UINT64_C(0xfd60341b00000000),
         UINT64_C(0x489a00a700000000),
         UINT64_C(0x8b80ba6700000000),
         UINT64_C(0x76e08e7c00000000),
         UINT64_C(0xb5fa34bc00000000),
         UINT64_C(0x0000a18d00000000),
         UINT64_C(0xc31a1b4d00000000),
         UINT64_C(0x3e7a2f5600000000),
         UINT64_C(0xfd60959600000000),
         UINT64_C(0x489aa12a00000000),
         UINT64_C(0x8b801bea00000000),
         UINT64_C(0x76e02ff100000000),
         UINT64_C(0xb5fa953100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x052e400000000000),
         UINT64_C(0x0061100000000000),
         UINT64_C(0x054f500000000000),
         UINT64_C(0x0816c00000000000),
         UINT64_C(0x0d38800000000000),
         UINT64_C(0x0877d00000000000),
         UINT64_C(0x0d59900000000000),
         UINT64_C(0x482ff00000000000),
         UINT64_C(0x4d01b00000000000),
         UINT64_C(0x484ee00000000000),
         UINT64_C(0x4d60a00000000000),
         UINT64_C(0x4039300000000000),
         UINT64_C(0x4517700000000000),
         UINT64_C(0x4058200000000000),
         UINT64_C(0x4576600000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff052e400000000),
         UINT64_C(0x3ff0061100000000),
         UINT64_C(0x3ff054f500000000),
         UINT64_C(0x3ff0816c00000000),
         UINT64_C(0x3ff0d38800000000),
         UINT64_C(0x3ff0877d00000000),
         UINT64_C(0x3ff0d59900000000),
         UINT64_C(0x3ff482ff00000000),
         UINT64_C(0x3ff4d01b00000000),
         UINT64_C(0x3ff484ee00000000),
         UINT64_C(0x3ff4d60a00000000),
         UINT64_C(0x3ff4039300000000),
         UINT64_C(0x3ff4517700000000),
         UINT64_C(0x3ff4058200000000),
         UINT64_C(0x3ff4576600000000)},
        UINT64_C(0xfff8000000000000),
        {0x75,0x04,0xa3,0x29,0x1f,0xa3,0x62,0x5c,0x95,0x8f,
         0x03,0xb8,0x36,0xd1,0x92,0xdd,0x79,0x6e,0x4c,0xf8,0x00}
    },
    {
        /* No.168 delta:2711 weight:3577 */
        11213,
        41,
        9,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0e438aa500000000),
         UINT64_C(0xd0534df500000000),
         UINT64_C(0xde10c75000000000),
         UINT64_C(0xf59200a800000000),
         UINT64_C(0xfbd18a0d00000000),
         UINT64_C(0x25c14d5d00000000),
         UINT64_C(0x2b82c7f800000000),
         UINT64_C(0x0000ec9300000000),
         UINT64_C(0x0e43663600000000),
         UINT64_C(0xd053a16600000000),
         UINT64_C(0xde102bc300000000),
         UINT64_C(0xf592ec3b00000000),
         UINT64_C(0xfbd1669e00000000),
         UINT64_C(0x25c1a1ce00000000),
         UINT64_C(0x2b822b6b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0800200000000000),
         UINT64_C(0x0000200000000000),
         UINT64_C(0x0800000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0800200000000000),
         UINT64_C(0x0000200000000000),
         UINT64_C(0x0800000000000000),
         UINT64_C(0x3007f00000000000),
         UINT64_C(0x3807d00000000000),
         UINT64_C(0x3007d00000000000),
         UINT64_C(0x3807f00000000000),
         UINT64_C(0x3007f00000000000),
         UINT64_C(0x3807d00000000000),
         UINT64_C(0x3007d00000000000),
         UINT64_C(0x3807f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0800200000000),
         UINT64_C(0x3ff0000200000000),
         UINT64_C(0x3ff0800000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0800200000000),
         UINT64_C(0x3ff0000200000000),
         UINT64_C(0x3ff0800000000000),
         UINT64_C(0x3ff3007f00000000),
         UINT64_C(0x3ff3807d00000000),
         UINT64_C(0x3ff3007d00000000),
         UINT64_C(0x3ff3807f00000000),
         UINT64_C(0x3ff3007f00000000),
         UINT64_C(0x3ff3807d00000000),
         UINT64_C(0x3ff3007d00000000),
         UINT64_C(0x3ff3807f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xa6,0x50,0xd6,0x7c,0x68,0xa8,0x45,0x51,0xf3,0x39,
         0x84,0xb4,0xc7,0xd4,0xd7,0xb0,0xf0,0x7d,0x15,0x38,0x00}
    },
    {
        /* No.169 delta:2192 weight:3861 */
        11213,
        42,
        4,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xb67d8eaf00000000),
         UINT64_C(0xee8b1da000000000),
         UINT64_C(0x58f6930f00000000),
         UINT64_C(0x5c9500a900000000),
         UINT64_C(0xeae88e0600000000),
         UINT64_C(0xb21e1d0900000000),
         UINT64_C(0x046393a600000000),
         UINT64_C(0x00004d9100000000),
         UINT64_C(0xb67dc33e00000000),
         UINT64_C(0xee8b503100000000),
         UINT64_C(0x58f6de9e00000000),
         UINT64_C(0x5c954d3800000000),
         UINT64_C(0xeae8c39700000000),
         UINT64_C(0xb21e509800000000),
         UINT64_C(0x0463de3700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0x0800800000000000),
         UINT64_C(0x3800800000000000),
         UINT64_C(0x9008500000000000),
         UINT64_C(0xa008500000000000),
         UINT64_C(0x9808d00000000000),
         UINT64_C(0xa808d00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x3003f00000000000),
         UINT64_C(0x0803700000000000),
         UINT64_C(0x3803700000000000),
         UINT64_C(0x900ba00000000000),
         UINT64_C(0xa00ba00000000000),
         UINT64_C(0x980b200000000000),
         UINT64_C(0xa80b200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ff0800800000000),
         UINT64_C(0x3ff3800800000000),
         UINT64_C(0x3ff9008500000000),
         UINT64_C(0x3ffa008500000000),
         UINT64_C(0x3ff9808d00000000),
         UINT64_C(0x3ffa808d00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff3003f00000000),
         UINT64_C(0x3ff0803700000000),
         UINT64_C(0x3ff3803700000000),
         UINT64_C(0x3ff900ba00000000),
         UINT64_C(0x3ffa00ba00000000),
         UINT64_C(0x3ff980b200000000),
         UINT64_C(0x3ffa80b200000000)},
        UINT64_C(0xfff8000000000000),
        {0x68,0x8b,0xc7,0x55,0xf0,0xa6,0xea,0xca,0xe1,0x0d,
         0x56,0x33,0xbf,0xd6,0x43,0x1b,0x71,0x85,0xd1,0x5f,0x00}
    },
    {
        /* No.170 delta:2412 weight:2845 */
        11213,
        40,
        22,
        10,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xcd54358300000000),
         UINT64_C(0x45139eb900000000),
         UINT64_C(0x8847ab3a00000000),
         UINT64_C(0xad9200aa00000000),
         UINT64_C(0x60c6352900000000),
         UINT64_C(0xe8819e1300000000),
         UINT64_C(0x25d5ab9000000000),
         UINT64_C(0x000044ac00000000),
         UINT64_C(0xcd54712f00000000),
         UINT64_C(0x4513da1500000000),
         UINT64_C(0x8847ef9600000000),
         UINT64_C(0xad92440600000000),
         UINT64_C(0x60c6718500000000),
         UINT64_C(0xe881dabf00000000),
         UINT64_C(0x25d5ef3c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2800000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x6800000000000000),
         UINT64_C(0x0000400000000000),
         UINT64_C(0x2800400000000000),
         UINT64_C(0x4000400000000000),
         UINT64_C(0x6800400000000000),
         UINT64_C(0x902bf00000000000),
         UINT64_C(0xb82bf00000000000),
         UINT64_C(0xd02bf00000000000),
         UINT64_C(0xf82bf00000000000),
         UINT64_C(0x902bb00000000000),
         UINT64_C(0xb82bb00000000000),
         UINT64_C(0xd02bb00000000000),
         UINT64_C(0xf82bb00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2800000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff6800000000000),
         UINT64_C(0x3ff0000400000000),
         UINT64_C(0x3ff2800400000000),
         UINT64_C(0x3ff4000400000000),
         UINT64_C(0x3ff6800400000000),
         UINT64_C(0x3ff902bf00000000),
         UINT64_C(0x3ffb82bf00000000),
         UINT64_C(0x3ffd02bf00000000),
         UINT64_C(0x3fff82bf00000000),
         UINT64_C(0x3ff902bb00000000),
         UINT64_C(0x3ffb82bb00000000),
         UINT64_C(0x3ffd02bb00000000),
         UINT64_C(0x3fff82bb00000000)},
        UINT64_C(0xfff8000000000000),
        {0xc9,0xe6,0xf8,0x46,0x23,0x50,0x77,0xef,0x8f,0x9d,
         0x45,0x55,0xb2,0xbf,0xc8,0xc7,0x19,0x6a,0x80,0x08,0x00}
    },
    {
        /* No.171 delta:6955 weight:2291 */
        11213,
        19,
        24,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xf987f66d00000000),
         UINT64_C(0xca08e47900000000),
         UINT64_C(0x338f121400000000),
         UINT64_C(0x1e5b00ab00000000),
         UINT64_C(0xe7dcf6c600000000),
         UINT64_C(0xd453e4d200000000),
         UINT64_C(0x2dd412bf00000000),
         UINT64_C(0x0000121000000000),
         UINT64_C(0xf987e47d00000000),
         UINT64_C(0xca08f66900000000),
         UINT64_C(0x338f000400000000),
         UINT64_C(0x1e5b12bb00000000),
         UINT64_C(0xe7dce4d600000000),
         UINT64_C(0xd453f6c200000000),
         UINT64_C(0x2dd400af00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x9d60000000000000),
         UINT64_C(0x08c0000000000000),
         UINT64_C(0x95a0000000000000),
         UINT64_C(0x005e000000000000),
         UINT64_C(0x9d3e000000000000),
         UINT64_C(0x089e000000000000),
         UINT64_C(0x95fe000000000000),
         UINT64_C(0x8cc3f00000000000),
         UINT64_C(0x11a3f00000000000),
         UINT64_C(0x8403f00000000000),
         UINT64_C(0x1963f00000000000),
         UINT64_C(0x8c9df00000000000),
         UINT64_C(0x11fdf00000000000),
         UINT64_C(0x845df00000000000),
         UINT64_C(0x193df00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff9d60000000000),
         UINT64_C(0x3ff08c0000000000),
         UINT64_C(0x3ff95a0000000000),
         UINT64_C(0x3ff005e000000000),
         UINT64_C(0x3ff9d3e000000000),
         UINT64_C(0x3ff089e000000000),
         UINT64_C(0x3ff95fe000000000),
         UINT64_C(0x3ff8cc3f00000000),
         UINT64_C(0x3ff11a3f00000000),
         UINT64_C(0x3ff8403f00000000),
         UINT64_C(0x3ff1963f00000000),
         UINT64_C(0x3ff8c9df00000000),
         UINT64_C(0x3ff11fdf00000000),
         UINT64_C(0x3ff845df00000000),
         UINT64_C(0x3ff193df00000000)},
        UINT64_C(0xfff8000000000000),
        {0x48,0x6b,0x67,0x20,0xfc,0x5b,0xec,0x72,0x1b,0x6b,
         0x38,0x06,0xea,0xe8,0xb6,0x53,0x32,0x3d,0x07,0x18,0x00}
    },
    {
        /* No.172 delta:3037 weight:2067 */
        11213,
        3,
        5,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xaa08bdc400000000),
         UINT64_C(0xad74d95c00000000),
         UINT64_C(0x077c649800000000),
         UINT64_C(0xf4cb00ac00000000),
         UINT64_C(0x5ec3bd6800000000),
         UINT64_C(0x59bfd9f000000000),
         UINT64_C(0xf3b7643400000000),
         UINT64_C(0x00009c5500000000),
         UINT64_C(0xaa08219100000000),
         UINT64_C(0xad74450900000000),
         UINT64_C(0x077cf8cd00000000),
         UINT64_C(0xf4cb9cf900000000),
         UINT64_C(0x5ec3213d00000000),
         UINT64_C(0x59bf45a500000000),
         UINT64_C(0xf3b7f86100000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2868000000000000),
         UINT64_C(0x4054000000000000),
         UINT64_C(0x683c000000000000),
         UINT64_C(0x0111000000000000),
         UINT64_C(0x2979000000000000),
         UINT64_C(0x4145000000000000),
         UINT64_C(0x692d000000000000),
         UINT64_C(0x301bf00000000000),
         UINT64_C(0x1873f00000000000),
         UINT64_C(0x704ff00000000000),
         UINT64_C(0x5827f00000000000),
         UINT64_C(0x310af00000000000),
         UINT64_C(0x1962f00000000000),
         UINT64_C(0x715ef00000000000),
         UINT64_C(0x5936f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2868000000000),
         UINT64_C(0x3ff4054000000000),
         UINT64_C(0x3ff683c000000000),
         UINT64_C(0x3ff0111000000000),
         UINT64_C(0x3ff2979000000000),
         UINT64_C(0x3ff4145000000000),
         UINT64_C(0x3ff692d000000000),
         UINT64_C(0x3ff301bf00000000),
         UINT64_C(0x3ff1873f00000000),
         UINT64_C(0x3ff704ff00000000),
         UINT64_C(0x3ff5827f00000000),
         UINT64_C(0x3ff310af00000000),
         UINT64_C(0x3ff1962f00000000),
         UINT64_C(0x3ff715ef00000000),
         UINT64_C(0x3ff5936f00000000)},
        UINT64_C(0xfff8000000000000),
        {0x69,0xa4,0x88,0x52,0x2a,0xa9,0xf3,0x07,0x6f,0x2f,
         0x28,0x71,0x91,0xeb,0x65,0xfc,0xaa,0xb5,0x61,0x81,0x00}
    },
    {
        /* No.173 delta:2306 weight:3753 */
        11213,
        7,
        11,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x665a7bcb00000000),
         UINT64_C(0xbe52bc5100000000),
         UINT64_C(0xd808c79a00000000),
         UINT64_C(0x34b300ad00000000),
         UINT64_C(0x52e97b6600000000),
         UINT64_C(0x8ae1bcfc00000000),
         UINT64_C(0xecbbc73700000000),
         UINT64_C(0x0000b8a900000000),
         UINT64_C(0x665ac36200000000),
         UINT64_C(0xbe5204f800000000),
         UINT64_C(0xd8087f3300000000),
         UINT64_C(0x34b3b80400000000),
         UINT64_C(0x52e9c3cf00000000),
         UINT64_C(0x8ae1045500000000),
         UINT64_C(0xecbb7f9e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1056000000000000),
         UINT64_C(0x0010000000000000),
         UINT64_C(0x1046000000000000),
         UINT64_C(0x3008200000000000),
         UINT64_C(0x205e200000000000),
         UINT64_C(0x3018200000000000),
         UINT64_C(0x204e200000000000),
         UINT64_C(0x2023f00000000000),
         UINT64_C(0x3075f00000000000),
         UINT64_C(0x2033f00000000000),
         UINT64_C(0x3065f00000000000),
         UINT64_C(0x102bd00000000000),
         UINT64_C(0x007dd00000000000),
         UINT64_C(0x103bd00000000000),
         UINT64_C(0x006dd00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1056000000000),
         UINT64_C(0x3ff0010000000000),
         UINT64_C(0x3ff1046000000000),
         UINT64_C(0x3ff3008200000000),
         UINT64_C(0x3ff205e200000000),
         UINT64_C(0x3ff3018200000000),
         UINT64_C(0x3ff204e200000000),
         UINT64_C(0x3ff2023f00000000),
         UINT64_C(0x3ff3075f00000000),
         UINT64_C(0x3ff2033f00000000),
         UINT64_C(0x3ff3065f00000000),
         UINT64_C(0x3ff102bd00000000),
         UINT64_C(0x3ff007dd00000000),
         UINT64_C(0x3ff103bd00000000),
         UINT64_C(0x3ff006dd00000000)},
        UINT64_C(0xfff8000000000000),
        {0xc1,0x6c,0xf2,0xd3,0x68,0xe7,0xb8,0xeb,0x2d,0x2d,
         0xd2,0xd2,0x38,0xa7,0x94,0xc6,0x68,0x08,0xe5,0x1a,0x00}
    },
    {
        /* No.174 delta:3768 weight:3153 */
        11213,
        22,
        17,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc6992a8b00000000),
         UINT64_C(0x73a66e4e00000000),
         UINT64_C(0xb53f44c500000000),
         UINT64_C(0xe23200ae00000000),
         UINT64_C(0x24ab2a2500000000),
         UINT64_C(0x91946ee000000000),
         UINT64_C(0x570d446b00000000),
         UINT64_C(0x00003ccf00000000),
         UINT64_C(0xc699164400000000),
         UINT64_C(0x73a6528100000000),
         UINT64_C(0xb53f780a00000000),
         UINT64_C(0xe2323c6100000000),
         UINT64_C(0x24ab16ea00000000),
         UINT64_C(0x9194522f00000000),
         UINT64_C(0x570d78a400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1045000000000000),
         UINT64_C(0x4f49c00000000000),
         UINT64_C(0x5f0cc00000000000),
         UINT64_C(0x30f3000000000000),
         UINT64_C(0x20b6000000000000),
         UINT64_C(0x7fbac00000000000),
         UINT64_C(0x6fffc00000000000),
         UINT64_C(0x2007f00000000000),
         UINT64_C(0x3042f00000000000),
         UINT64_C(0x6f4e300000000000),
         UINT64_C(0x7f0b300000000000),
         UINT64_C(0x10f4f00000000000),
         UINT64_C(0x00b1f00000000000),
         UINT64_C(0x5fbd300000000000),
         UINT64_C(0x4ff8300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1045000000000),
         UINT64_C(0x3ff4f49c00000000),
         UINT64_C(0x3ff5f0cc00000000),
         UINT64_C(0x3ff30f3000000000),
         UINT64_C(0x3ff20b6000000000),
         UINT64_C(0x3ff7fbac00000000),
         UINT64_C(0x3ff6fffc00000000),
         UINT64_C(0x3ff2007f00000000),
         UINT64_C(0x3ff3042f00000000),
         UINT64_C(0x3ff6f4e300000000),
         UINT64_C(0x3ff7f0b300000000),
         UINT64_C(0x3ff10f4f00000000),
         UINT64_C(0x3ff00b1f00000000),
         UINT64_C(0x3ff5fbd300000000),
         UINT64_C(0x3ff4ff8300000000)},
        UINT64_C(0xfff8000000000000),
        {0xfc,0x6f,0x31,0x04,0x5d,0x9e,0xbc,0x51,0x43,0x2a,
         0xc6,0x7b,0x5a,0x19,0xbf,0x6b,0x05,0xde,0x11,0x37,0x00}
    },
    {
        /* No.175 delta:2044 weight:2141 */
        11213,
        44,
        9,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4cd0392300000000),
         UINT64_C(0xd0190b8000000000),
         UINT64_C(0x9cc932a300000000),
         UINT64_C(0x631b00af00000000),
         UINT64_C(0x2fcb398c00000000),
         UINT64_C(0xb3020b2f00000000),
         UINT64_C(0xffd2320c00000000),
         UINT64_C(0x0000683800000000),
         UINT64_C(0x4cd0511b00000000),
         UINT64_C(0xd01963b800000000),
         UINT64_C(0x9cc95a9b00000000),
         UINT64_C(0x631b689700000000),
         UINT64_C(0x2fcb51b400000000),
         UINT64_C(0xb302631700000000),
         UINT64_C(0xffd25a3400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0000800000000000),
         UINT64_C(0x5000100000000000),
         UINT64_C(0x5000900000000000),
         UINT64_C(0x9000000000000000),
         UINT64_C(0x9000800000000000),
         UINT64_C(0xc000100000000000),
         UINT64_C(0xc000900000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x4003700000000000),
         UINT64_C(0x1003e00000000000),
         UINT64_C(0x1003600000000000),
         UINT64_C(0xd003f00000000000),
         UINT64_C(0xd003700000000000),
         UINT64_C(0x8003e00000000000),
         UINT64_C(0x8003600000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000800000000),
         UINT64_C(0x3ff5000100000000),
         UINT64_C(0x3ff5000900000000),
         UINT64_C(0x3ff9000000000000),
         UINT64_C(0x3ff9000800000000),
         UINT64_C(0x3ffc000100000000),
         UINT64_C(0x3ffc000900000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff4003700000000),
         UINT64_C(0x3ff1003e00000000),
         UINT64_C(0x3ff1003600000000),
         UINT64_C(0x3ffd003f00000000),
         UINT64_C(0x3ffd003700000000),
         UINT64_C(0x3ff8003e00000000),
         UINT64_C(0x3ff8003600000000)},
        UINT64_C(0xfff8000000000000),
        {0x76,0x3b,0x67,0x08,0x6c,0x8d,0xc5,0x2d,0x9d,0x97,
         0xef,0xd1,0xb3,0x22,0xda,0x8a,0xd5,0x9a,0xbb,0xea,0x00}
    },
    {
        /* No.176 delta:5763 weight:3569 */
        11213,
        22,
        3,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xfe7b2fad00000000),
         UINT64_C(0xc8f3a8ef00000000),
         UINT64_C(0x3688874200000000),
         UINT64_C(0x613900b000000000),
         UINT64_C(0x9f422f1d00000000),
         UINT64_C(0xa9caa85f00000000),
         UINT64_C(0x57b187f200000000),
         UINT64_C(0x000083eb00000000),
         UINT64_C(0xfe7bac4600000000),
         UINT64_C(0xc8f32b0400000000),
         UINT64_C(0x368804a900000000),
         UINT64_C(0x6139835b00000000),
         UINT64_C(0x9f42acf600000000),
         UINT64_C(0xa9ca2bb400000000),
         UINT64_C(0x57b1041900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0000800000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0000800000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x5000800000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x5000800000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0003700000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0003700000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x5003700000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x5003700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000800000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000800000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff5000800000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff5000800000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0003700000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0003700000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff5003700000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff5003700000000)},
        UINT64_C(0xfff8000000000000),
        {0x64,0x96,0xf1,0x5e,0x12,0x6c,0x62,0x82,0xa7,0x8f,
         0xc1,0x89,0x7c,0x93,0x0a,0xef,0xe0,0x2a,0x11,0xc0,0x00}
    },
    {
        /* No.177 delta:2516 weight:3727 */
        11213,
        12,
        7,
        4,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe889099100000000),
         UINT64_C(0xb7323caf00000000),
         UINT64_C(0x5fbb353e00000000),
         UINT64_C(0x916100b100000000),
         UINT64_C(0x79e8092000000000),
         UINT64_C(0x26533c1e00000000),
         UINT64_C(0xceda358f00000000),
         UINT64_C(0x0000bb2d00000000),
         UINT64_C(0xe889b2bc00000000),
         UINT64_C(0xb732878200000000),
         UINT64_C(0x5fbb8e1300000000),
         UINT64_C(0x9161bb9c00000000),
         UINT64_C(0x79e8b20d00000000),
         UINT64_C(0x2653873300000000),
         UINT64_C(0xceda8ea200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0002800000000000),
         UINT64_C(0x4000200000000000),
         UINT64_C(0x4002a00000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0002800000000000),
         UINT64_C(0x4000200000000000),
         UINT64_C(0x4002a00000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x2001700000000000),
         UINT64_C(0x6003d00000000000),
         UINT64_C(0x6001500000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x2001700000000000),
         UINT64_C(0x6003d00000000000),
         UINT64_C(0x6001500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0002800000000),
         UINT64_C(0x3ff4000200000000),
         UINT64_C(0x3ff4002a00000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0002800000000),
         UINT64_C(0x3ff4000200000000),
         UINT64_C(0x3ff4002a00000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff2001700000000),
         UINT64_C(0x3ff6003d00000000),
         UINT64_C(0x3ff6001500000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff2001700000000),
         UINT64_C(0x3ff6003d00000000),
         UINT64_C(0x3ff6001500000000)},
        UINT64_C(0xfff8000000000000),
        {0x1f,0x23,0x8a,0x64,0x82,0x54,0x92,0xb1,0x1e,0xf5,
         0x6e,0x63,0x7f,0xa3,0xc7,0x1b,0xc3,0x38,0x7d,0xb8,0x00}
    },
    {
        /* No.178 delta:2884 weight:2881 */
        11213,
        4,
        6,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xbba770f800000000),
         UINT64_C(0x8fdd318b00000000),
         UINT64_C(0x347a417300000000),
         UINT64_C(0xbb6700b200000000),
         UINT64_C(0x00c0704a00000000),
         UINT64_C(0x34ba313900000000),
         UINT64_C(0x8f1d41c100000000),
         UINT64_C(0x0000345100000000),
         UINT64_C(0xbba744a900000000),
         UINT64_C(0x8fdd05da00000000),
         UINT64_C(0x347a752200000000),
         UINT64_C(0xbb6734e300000000),
         UINT64_C(0x00c0441b00000000),
         UINT64_C(0x34ba056800000000),
         UINT64_C(0x8f1d759000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6001800000000000),
         UINT64_C(0x7000000000000000),
         UINT64_C(0x1001800000000000),
         UINT64_C(0x5008c00000000000),
         UINT64_C(0x3009400000000000),
         UINT64_C(0x2008c00000000000),
         UINT64_C(0x4009400000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x4002700000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x3002700000000000),
         UINT64_C(0x700b300000000000),
         UINT64_C(0x100ab00000000000),
         UINT64_C(0x000b300000000000),
         UINT64_C(0x600ab00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff6001800000000),
         UINT64_C(0x3ff7000000000000),
         UINT64_C(0x3ff1001800000000),
         UINT64_C(0x3ff5008c00000000),
         UINT64_C(0x3ff3009400000000),
         UINT64_C(0x3ff2008c00000000),
         UINT64_C(0x3ff4009400000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff4002700000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff3002700000000),
         UINT64_C(0x3ff700b300000000),
         UINT64_C(0x3ff100ab00000000),
         UINT64_C(0x3ff000b300000000),
         UINT64_C(0x3ff600ab00000000)},
        UINT64_C(0xfff8000000000000),
        {0x74,0x08,0x72,0x50,0xc6,0x61,0x70,0x64,0xd0,0xfc,
         0x36,0x3e,0x36,0x72,0x9e,0x2f,0xa1,0x9f,0x2e,0x64,0x00}
    },
    {
        /* No.179 delta:2146 weight:3539 */
        11213,
        29,
        9,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x26d4764000000000),
         UINT64_C(0x633388d900000000),
         UINT64_C(0x45e7fe9900000000),
         UINT64_C(0x059200b300000000),
         UINT64_C(0x234676f300000000),
         UINT64_C(0x66a1886a00000000),
         UINT64_C(0x4075fe2a00000000),
         UINT64_C(0x0000fb6400000000),
         UINT64_C(0x26d48d2400000000),
         UINT64_C(0x633373bd00000000),
         UINT64_C(0x45e705fd00000000),
         UINT64_C(0x0592fbd700000000),
         UINT64_C(0x23468d9700000000),
         UINT64_C(0x66a1730e00000000),
         UINT64_C(0x4075054e00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2042100000000000),
         UINT64_C(0x0002000000000000),
         UINT64_C(0x2040100000000000),
         UINT64_C(0x8000000000000000),
         UINT64_C(0xa042100000000000),
         UINT64_C(0x8002000000000000),
         UINT64_C(0xa040100000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x2041e00000000000),
         UINT64_C(0x0001f00000000000),
         UINT64_C(0x2043e00000000000),
         UINT64_C(0x8003f00000000000),
         UINT64_C(0xa041e00000000000),
         UINT64_C(0x8001f00000000000),
         UINT64_C(0xa043e00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2042100000000),
         UINT64_C(0x3ff0002000000000),
         UINT64_C(0x3ff2040100000000),
         UINT64_C(0x3ff8000000000000),
         UINT64_C(0x3ffa042100000000),
         UINT64_C(0x3ff8002000000000),
         UINT64_C(0x3ffa040100000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff2041e00000000),
         UINT64_C(0x3ff0001f00000000),
         UINT64_C(0x3ff2043e00000000),
         UINT64_C(0x3ff8003f00000000),
         UINT64_C(0x3ffa041e00000000),
         UINT64_C(0x3ff8001f00000000),
         UINT64_C(0x3ffa043e00000000)},
        UINT64_C(0xfff8000000000000),
        {0x47,0x8e,0x4e,0x3f,0x92,0xe3,0x5e,0x21,0xf4,0xa5,
         0x55,0xfc,0xe1,0xb6,0x4a,0xe1,0xeb,0x3f,0x47,0x6f,0x00}
    },
    {
        /* No.180 delta:2351 weight:3431 */
        11213,
        29,
        8,
        7,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x830425d200000000),
         UINT64_C(0x46f156c800000000),
         UINT64_C(0xc5f5731a00000000),
         UINT64_C(0x835000b400000000),
         UINT64_C(0x0054256600000000),
         UINT64_C(0xc5a1567c00000000),
         UINT64_C(0x46a573ae00000000),
         UINT64_C(0x0000692200000000),
         UINT64_C(0x83044cf000000000),
         UINT64_C(0x46f13fea00000000),
         UINT64_C(0xc5f51a3800000000),
         UINT64_C(0x8350699600000000),
         UINT64_C(0x00544c4400000000),
         UINT64_C(0xc5a13f5e00000000),
         UINT64_C(0x46a51a8c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0040200000000000),
         UINT64_C(0x0200100000000000),
         UINT64_C(0x0240300000000000),
         UINT64_C(0x8080000000000000),
         UINT64_C(0x80c0200000000000),
         UINT64_C(0x8280100000000000),
         UINT64_C(0x82c0300000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x4043d00000000000),
         UINT64_C(0x4203e00000000000),
         UINT64_C(0x4243c00000000000),
         UINT64_C(0xc083f00000000000),
         UINT64_C(0xc0c3d00000000000),
         UINT64_C(0xc283e00000000000),
         UINT64_C(0xc2c3c00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0040200000000),
         UINT64_C(0x3ff0200100000000),
         UINT64_C(0x3ff0240300000000),
         UINT64_C(0x3ff8080000000000),
         UINT64_C(0x3ff80c0200000000),
         UINT64_C(0x3ff8280100000000),
         UINT64_C(0x3ff82c0300000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff4043d00000000),
         UINT64_C(0x3ff4203e00000000),
         UINT64_C(0x3ff4243c00000000),
         UINT64_C(0x3ffc083f00000000),
         UINT64_C(0x3ffc0c3d00000000),
         UINT64_C(0x3ffc283e00000000),
         UINT64_C(0x3ffc2c3c00000000)},
        UINT64_C(0xfff8000000000000),
        {0x39,0xaa,0x8e,0xbc,0xe2,0x38,0x10,0xbd,0xf7,0xfe,
         0xa6,0x07,0x3b,0xb9,0x10,0x2c,0xa2,0x62,0x29,0x72,0x00}
    },
    {
        /* No.181 delta:2380 weight:3805 */
        11213,
        22,
        2,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1bf3682500000000),
         UINT64_C(0x462e25ce00000000),
         UINT64_C(0x5ddd4deb00000000),
         UINT64_C(0x01cf00b500000000),
         UINT64_C(0x1a3c689000000000),
         UINT64_C(0x47e1257b00000000),
         UINT64_C(0x5c124d5e00000000),
         UINT64_C(0x00008e1400000000),
         UINT64_C(0x1bf3e63100000000),
         UINT64_C(0x462eabda00000000),
         UINT64_C(0x5dddc3ff00000000),
         UINT64_C(0x01cf8ea100000000),
         UINT64_C(0x1a3ce68400000000),
         UINT64_C(0x47e1ab6f00000000),
         UINT64_C(0x5c12c34a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0a5a400000000000),
         UINT64_C(0x0049000000000000),
         UINT64_C(0x0a13400000000000),
         UINT64_C(0x2020900000000000),
         UINT64_C(0x2a7ad00000000000),
         UINT64_C(0x2069900000000000),
         UINT64_C(0x2a33d00000000000),
         UINT64_C(0x200bf00000000000),
         UINT64_C(0x2a51b00000000000),
         UINT64_C(0x2042f00000000000),
         UINT64_C(0x2a18b00000000000),
         UINT64_C(0x002b600000000000),
         UINT64_C(0x0a71200000000000),
         UINT64_C(0x0062600000000000),
         UINT64_C(0x0a38200000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0a5a400000000),
         UINT64_C(0x3ff0049000000000),
         UINT64_C(0x3ff0a13400000000),
         UINT64_C(0x3ff2020900000000),
         UINT64_C(0x3ff2a7ad00000000),
         UINT64_C(0x3ff2069900000000),
         UINT64_C(0x3ff2a33d00000000),
         UINT64_C(0x3ff200bf00000000),
         UINT64_C(0x3ff2a51b00000000),
         UINT64_C(0x3ff2042f00000000),
         UINT64_C(0x3ff2a18b00000000),
         UINT64_C(0x3ff002b600000000),
         UINT64_C(0x3ff0a71200000000),
         UINT64_C(0x3ff0062600000000),
         UINT64_C(0x3ff0a38200000000)},
        UINT64_C(0xfff8000000000000),
        {0xb4,0x0a,0x9f,0x2f,0xfe,0xee,0x13,0x5b,0x21,0x55,
         0xe8,0x43,0xcb,0x86,0xdd,0x62,0xca,0xde,0x22,0xa8,0x00}
    },
    {
        /* No.182 delta:7461 weight:3387 */
        11213,
        33,
        17,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe45ab12b00000000),
         UINT64_C(0xbd1fc0ec00000000),
         UINT64_C(0x594571c700000000),
         UINT64_C(0x2d5700b600000000),
         UINT64_C(0xc90db19d00000000),
         UINT64_C(0x9048c05a00000000),
         UINT64_C(0x7412717100000000),
         UINT64_C(0x0000792d00000000),
         UINT64_C(0xe45ac80600000000),
         UINT64_C(0xbd1fb9c100000000),
         UINT64_C(0x594508ea00000000),
         UINT64_C(0x2d57799b00000000),
         UINT64_C(0xc90dc8b000000000),
         UINT64_C(0x9048b97700000000),
         UINT64_C(0x7412085c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3080000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x3080000000000000),
         UINT64_C(0x2200000000000000),
         UINT64_C(0x1280000000000000),
         UINT64_C(0x2200000000000000),
         UINT64_C(0x1280000000000000),
         UINT64_C(0x4403f00000000000),
         UINT64_C(0x7483f00000000000),
         UINT64_C(0x4403f00000000000),
         UINT64_C(0x7483f00000000000),
         UINT64_C(0x6603f00000000000),
         UINT64_C(0x5683f00000000000),
         UINT64_C(0x6603f00000000000),
         UINT64_C(0x5683f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3080000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3080000000000),
         UINT64_C(0x3ff2200000000000),
         UINT64_C(0x3ff1280000000000),
         UINT64_C(0x3ff2200000000000),
         UINT64_C(0x3ff1280000000000),
         UINT64_C(0x3ff4403f00000000),
         UINT64_C(0x3ff7483f00000000),
         UINT64_C(0x3ff4403f00000000),
         UINT64_C(0x3ff7483f00000000),
         UINT64_C(0x3ff6603f00000000),
         UINT64_C(0x3ff5683f00000000),
         UINT64_C(0x3ff6603f00000000),
         UINT64_C(0x3ff5683f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xa5,0x0f,0x8d,0x30,0xcf,0x55,0x95,0x7a,0x04,0x35,
         0xbd,0x72,0x7c,0x79,0xe3,0x75,0xa2,0xe9,0x1f,0x28,0x00}
    },
    {
        /* No.183 delta:4746 weight:2199 */
        11213,
        5,
        1,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xc73258ea00000000),
         UINT64_C(0x0945d29b00000000),
         UINT64_C(0xce778a7100000000),
         UINT64_C(0xc0cd00b700000000),
         UINT64_C(0x07ff585d00000000),
         UINT64_C(0xc988d22c00000000),
         UINT64_C(0x0eba8ac600000000),
         UINT64_C(0x0000b46000000000),
         UINT64_C(0xc732ec8a00000000),
         UINT64_C(0x094566fb00000000),
         UINT64_C(0xce773e1100000000),
         UINT64_C(0xc0cdb4d700000000),
         UINT64_C(0x07ffec3d00000000),
         UINT64_C(0xc988664c00000000),
         UINT64_C(0x0eba3ea600000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6044000000000000),
         UINT64_C(0x6036000000000000),
         UINT64_C(0x0072000000000000),
         UINT64_C(0x102f500000000000),
         UINT64_C(0x706b500000000000),
         UINT64_C(0x7019500000000000),
         UINT64_C(0x105d500000000000),
         UINT64_C(0xa423f00000000000),
         UINT64_C(0xc467f00000000000),
         UINT64_C(0xc415f00000000000),
         UINT64_C(0xa451f00000000000),
         UINT64_C(0xb40ca00000000000),
         UINT64_C(0xd448a00000000000),
         UINT64_C(0xd43aa00000000000),
         UINT64_C(0xb47ea00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff6044000000000),
         UINT64_C(0x3ff6036000000000),
         UINT64_C(0x3ff0072000000000),
         UINT64_C(0x3ff102f500000000),
         UINT64_C(0x3ff706b500000000),
         UINT64_C(0x3ff7019500000000),
         UINT64_C(0x3ff105d500000000),
         UINT64_C(0x3ffa423f00000000),
         UINT64_C(0x3ffc467f00000000),
         UINT64_C(0x3ffc415f00000000),
         UINT64_C(0x3ffa451f00000000),
         UINT64_C(0x3ffb40ca00000000),
         UINT64_C(0x3ffd448a00000000),
         UINT64_C(0x3ffd43aa00000000),
         UINT64_C(0x3ffb47ea00000000)},
        UINT64_C(0xfff8000000000000),
        {0xd9,0x10,0x64,0xe3,0x70,0xa4,0xf3,0xc9,0xac,0x77,
         0xd9,0x7f,0xe0,0x26,0xbe,0xd9,0x1e,0x42,0xfe,0x2c,0x00}
    },
    {
        /* No.184 delta:2447 weight:3603 */
        11213,
        19,
        11,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xac5a6ce600000000),
         UINT64_C(0x5c6bcc7f00000000),
         UINT64_C(0xf031a09900000000),
         UINT64_C(0xd91e00b800000000),
         UINT64_C(0x75446c5e00000000),
         UINT64_C(0x8575ccc700000000),
         UINT64_C(0x292fa02100000000),
         UINT64_C(0x0000db7400000000),
         UINT64_C(0xac5ab79200000000),
         UINT64_C(0x5c6b170b00000000),
         UINT64_C(0xf0317bed00000000),
         UINT64_C(0xd91edbcc00000000),
         UINT64_C(0x7544b72a00000000),
         UINT64_C(0x857517b300000000),
         UINT64_C(0x292f7b5500000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0003000000000000),
         UINT64_C(0x2100200000000000),
         UINT64_C(0x2103200000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x5003000000000000),
         UINT64_C(0x7100200000000000),
         UINT64_C(0x7103200000000000),
         UINT64_C(0x1403f00000000000),
         UINT64_C(0x1400f00000000000),
         UINT64_C(0x3503d00000000000),
         UINT64_C(0x3500d00000000000),
         UINT64_C(0x4403f00000000000),
         UINT64_C(0x4400f00000000000),
         UINT64_C(0x6503d00000000000),
         UINT64_C(0x6500d00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0003000000000),
         UINT64_C(0x3ff2100200000000),
         UINT64_C(0x3ff2103200000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff5003000000000),
         UINT64_C(0x3ff7100200000000),
         UINT64_C(0x3ff7103200000000),
         UINT64_C(0x3ff1403f00000000),
         UINT64_C(0x3ff1400f00000000),
         UINT64_C(0x3ff3503d00000000),
         UINT64_C(0x3ff3500d00000000),
         UINT64_C(0x3ff4403f00000000),
         UINT64_C(0x3ff4400f00000000),
         UINT64_C(0x3ff6503d00000000),
         UINT64_C(0x3ff6500d00000000)},
        UINT64_C(0xfff8000000000000),
        {0xd8,0x7c,0x4f,0x91,0x09,0x0a,0x18,0x63,0x7a,0xce,
         0x80,0x66,0xbf,0x0f,0xf2,0xdd,0xaa,0x97,0x4d,0xd5,0x00}
    },
    {
        /* No.185 delta:2331 weight:2933 */
        11213,
        40,
        11,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0e51d6d600000000),
         UINT64_C(0xb65b1a8a00000000),
         UINT64_C(0xb80acc5c00000000),
         UINT64_C(0x025100b900000000),
         UINT64_C(0x0c00d66f00000000),
         UINT64_C(0xb40a1a3300000000),
         UINT64_C(0xba5bcce500000000),
         UINT64_C(0x00005bde00000000),
         UINT64_C(0x0e518d0800000000),
         UINT64_C(0xb65b415400000000),
         UINT64_C(0xb80a978200000000),
         UINT64_C(0x02515b6700000000),
         UINT64_C(0x0c008db100000000),
         UINT64_C(0xb40a41ed00000000),
         UINT64_C(0xba5b973b00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2065000000000000),
         UINT64_C(0x0042800000000000),
         UINT64_C(0x2027800000000000),
         UINT64_C(0x4060000000000000),
         UINT64_C(0x6005000000000000),
         UINT64_C(0x4022800000000000),
         UINT64_C(0x6047800000000000),
         UINT64_C(0x0023f00000000000),
         UINT64_C(0x2046f00000000000),
         UINT64_C(0x0061700000000000),
         UINT64_C(0x2004700000000000),
         UINT64_C(0x4043f00000000000),
         UINT64_C(0x6026f00000000000),
         UINT64_C(0x4001700000000000),
         UINT64_C(0x6064700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2065000000000),
         UINT64_C(0x3ff0042800000000),
         UINT64_C(0x3ff2027800000000),
         UINT64_C(0x3ff4060000000000),
         UINT64_C(0x3ff6005000000000),
         UINT64_C(0x3ff4022800000000),
         UINT64_C(0x3ff6047800000000),
         UINT64_C(0x3ff0023f00000000),
         UINT64_C(0x3ff2046f00000000),
         UINT64_C(0x3ff0061700000000),
         UINT64_C(0x3ff2004700000000),
         UINT64_C(0x3ff4043f00000000),
         UINT64_C(0x3ff6026f00000000),
         UINT64_C(0x3ff4001700000000),
         UINT64_C(0x3ff6064700000000)},
        UINT64_C(0xfff8000000000000),
        {0x77,0xb0,0xb1,0x2e,0x81,0x74,0x74,0x38,0x5b,0xc4,
         0xc0,0xe6,0x66,0xe5,0x16,0x31,0x97,0xc5,0x71,0xbd,0x00}
    },
    {
        /* No.186 delta:2965 weight:2001 */
        11213,
        3,
        6,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xf61f6faa00000000),
         UINT64_C(0xc35a134100000000),
         UINT64_C(0x35457ceb00000000),
         UINT64_C(0x836500ba00000000),
         UINT64_C(0x757a6f1000000000),
         UINT64_C(0x403f13fb00000000),
         UINT64_C(0xb6207c5100000000),
         UINT64_C(0x0000790800000000),
         UINT64_C(0xf61f16a200000000),
         UINT64_C(0xc35a6a4900000000),
         UINT64_C(0x354505e300000000),
         UINT64_C(0x836579b200000000),
         UINT64_C(0x757a161800000000),
         UINT64_C(0x403f6af300000000),
         UINT64_C(0xb620055900000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xa800b00000000000),
         UINT64_C(0x0044100000000000),
         UINT64_C(0xa844a00000000000),
         UINT64_C(0x004b400000000000),
         UINT64_C(0xa84bf00000000000),
         UINT64_C(0x000f500000000000),
         UINT64_C(0xa80fe00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0xb803400000000000),
         UINT64_C(0x1047e00000000000),
         UINT64_C(0xb847500000000000),
         UINT64_C(0x1048b00000000000),
         UINT64_C(0xb848000000000000),
         UINT64_C(0x100ca00000000000),
         UINT64_C(0xb80c100000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffa800b00000000),
         UINT64_C(0x3ff0044100000000),
         UINT64_C(0x3ffa844a00000000),
         UINT64_C(0x3ff004b400000000),
         UINT64_C(0x3ffa84bf00000000),
         UINT64_C(0x3ff000f500000000),
         UINT64_C(0x3ffa80fe00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ffb803400000000),
         UINT64_C(0x3ff1047e00000000),
         UINT64_C(0x3ffb847500000000),
         UINT64_C(0x3ff1048b00000000),
         UINT64_C(0x3ffb848000000000),
         UINT64_C(0x3ff100ca00000000),
         UINT64_C(0x3ffb80c100000000)},
        UINT64_C(0xfff8000000000000),
        {0x0e,0xa8,0xcf,0x6f,0xca,0xee,0x09,0xf7,0x72,0xf2,
         0xa9,0x51,0x1b,0xa5,0xda,0x17,0x4c,0xf5,0x59,0x6f,0x00}
    },
    {
        /* No.187 delta:2683 weight:2289 */
        11213,
        26,
        7,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x699a468900000000),
         UINT64_C(0xf323b34700000000),
         UINT64_C(0x9ab9f5ce00000000),
         UINT64_C(0xd9c900bb00000000),
         UINT64_C(0xb053463200000000),
         UINT64_C(0x2aeab3fc00000000),
         UINT64_C(0x4370f57500000000),
         UINT64_C(0x0000277900000000),
         UINT64_C(0x699a61f000000000),
         UINT64_C(0xf323943e00000000),
         UINT64_C(0x9ab9d2b700000000),
         UINT64_C(0xd9c927c200000000),
         UINT64_C(0xb053614b00000000),
         UINT64_C(0x2aea948500000000),
         UINT64_C(0x4370d20c00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0x5000300000000000),
         UINT64_C(0x6000300000000000),
         UINT64_C(0x6000000000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x3000300000000000),
         UINT64_C(0x0000300000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x3003f00000000000),
         UINT64_C(0x5003c00000000000),
         UINT64_C(0x6003c00000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x3003c00000000000),
         UINT64_C(0x0003c00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ff5000300000000),
         UINT64_C(0x3ff6000300000000),
         UINT64_C(0x3ff6000000000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff3000300000000),
         UINT64_C(0x3ff0000300000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff3003f00000000),
         UINT64_C(0x3ff5003c00000000),
         UINT64_C(0x3ff6003c00000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff3003c00000000),
         UINT64_C(0x3ff0003c00000000)},
        UINT64_C(0xfff8000000000000),
        {0x6c,0x10,0x5a,0xe7,0x07,0xe2,0xc8,0x58,0x85,0x8d,
         0x6e,0x37,0xaa,0x98,0x57,0x8e,0xd6,0xe8,0x36,0x12,0x00}
    },
    {
        /* No.188 delta:2689 weight:3093 */
        11213,
        25,
        7,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x6238cf8900000000),
         UINT64_C(0xd79a511f00000000),
         UINT64_C(0xb5a29e9600000000),
         UINT64_C(0x9ebe00bc00000000),
         UINT64_C(0xfc86cf3500000000),
         UINT64_C(0x492451a300000000),
         UINT64_C(0x2b1c9e2a00000000),
         UINT64_C(0x000076cd00000000),
         UINT64_C(0x6238b94400000000),
         UINT64_C(0xd79a27d200000000),
         UINT64_C(0xb5a2e85b00000000),
         UINT64_C(0x9ebe767100000000),
         UINT64_C(0xfc86b9f800000000),
         UINT64_C(0x4924276e00000000),
         UINT64_C(0x2b1ce8e700000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0200800000000000),
         UINT64_C(0x0200800000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0000000000000000),
         UINT64_C(0x0200800000000000),
         UINT64_C(0x0200800000000000),
         UINT64_C(0x8003f00000000000),
         UINT64_C(0x8003f00000000000),
         UINT64_C(0x8203700000000000),
         UINT64_C(0x8203700000000000),
         UINT64_C(0x8003f00000000000),
         UINT64_C(0x8003f00000000000),
         UINT64_C(0x8203700000000000),
         UINT64_C(0x8203700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0200800000000),
         UINT64_C(0x3ff0200800000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0200800000000),
         UINT64_C(0x3ff0200800000000),
         UINT64_C(0x3ff8003f00000000),
         UINT64_C(0x3ff8003f00000000),
         UINT64_C(0x3ff8203700000000),
         UINT64_C(0x3ff8203700000000),
         UINT64_C(0x3ff8003f00000000),
         UINT64_C(0x3ff8003f00000000),
         UINT64_C(0x3ff8203700000000),
         UINT64_C(0x3ff8203700000000)},
        UINT64_C(0xfff8000000000000),
        {0x80,0x86,0xed,0x71,0xc8,0x6b,0xa8,0xb8,0x02,0xfb,
         0xf8,0x44,0xd9,0x48,0x1b,0x89,0x8d,0x6c,0x35,0xec,0x00}
    },
    {
        /* No.189 delta:6617 weight:3303 */
        11213,
        29,
        16,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xb1a8b73c00000000),
         UINT64_C(0x9c4d5a4d00000000),
         UINT64_C(0x2de5ed7100000000),
         UINT64_C(0x53cb00bd00000000),
         UINT64_C(0xe263b78100000000),
         UINT64_C(0xcf865af000000000),
         UINT64_C(0x7e2eedcc00000000),
         UINT64_C(0x0000340300000000),
         UINT64_C(0xb1a8833f00000000),
         UINT64_C(0x9c4d6e4e00000000),
         UINT64_C(0x2de5d97200000000),
         UINT64_C(0x53cb34be00000000),
         UINT64_C(0xe263838200000000),
         UINT64_C(0xcf866ef300000000),
         UINT64_C(0x7e2ed9cf00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xd115000000000000),
         UINT64_C(0x0e26800000000000),
         UINT64_C(0xdf33800000000000),
         UINT64_C(0x0912400000000000),
         UINT64_C(0xd807400000000000),
         UINT64_C(0x0734c00000000000),
         UINT64_C(0xd621c00000000000),
         UINT64_C(0x0d03f00000000000),
         UINT64_C(0xdc16f00000000000),
         UINT64_C(0x0325700000000000),
         UINT64_C(0xd230700000000000),
         UINT64_C(0x0411b00000000000),
         UINT64_C(0xd504b00000000000),
         UINT64_C(0x0a37300000000000),
         UINT64_C(0xdb22300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ffd115000000000),
         UINT64_C(0x3ff0e26800000000),
         UINT64_C(0x3ffdf33800000000),
         UINT64_C(0x3ff0912400000000),
         UINT64_C(0x3ffd807400000000),
         UINT64_C(0x3ff0734c00000000),
         UINT64_C(0x3ffd621c00000000),
         UINT64_C(0x3ff0d03f00000000),
         UINT64_C(0x3ffdc16f00000000),
         UINT64_C(0x3ff0325700000000),
         UINT64_C(0x3ffd230700000000),
         UINT64_C(0x3ff0411b00000000),
         UINT64_C(0x3ffd504b00000000),
         UINT64_C(0x3ff0a37300000000),
         UINT64_C(0x3ffdb22300000000)},
        UINT64_C(0xfff8000000000000),
        {0x13,0x92,0x18,0x76,0xe6,0xd9,0x6f,0xe6,0xca,0x2b,
         0x72,0x0c,0x80,0x96,0x02,0xee,0x04,0xb8,0xe1,0x8c,0x00}
    },
    {
        /* No.190 delta:5879 weight:2263 */
        11213,
        7,
        26,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1c8baa1900000000),
         UINT64_C(0xc1c4f7b800000000),
         UINT64_C(0xdd4f5da100000000),
         UINT64_C(0x39c000be00000000),
         UINT64_C(0x254baaa700000000),
         UINT64_C(0xf804f70600000000),
         UINT64_C(0xe48f5d1f00000000),
         UINT64_C(0x00005f4700000000),
         UINT64_C(0x1c8bf55e00000000),
         UINT64_C(0xc1c4a8ff00000000),
         UINT64_C(0xdd4f02e600000000),
         UINT64_C(0x39c05ff900000000),
         UINT64_C(0x254bf5e000000000),
         UINT64_C(0xf804a84100000000),
         UINT64_C(0xe48f025800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x567e000000000000),
         UINT64_C(0x400e000000000000),
         UINT64_C(0x1670000000000000),
         UINT64_C(0x104a800000000000),
         UINT64_C(0x4634800000000000),
         UINT64_C(0x5044800000000000),
         UINT64_C(0x063a800000000000),
         UINT64_C(0xa25bf00000000000),
         UINT64_C(0xf425f00000000000),
         UINT64_C(0xe255f00000000000),
         UINT64_C(0xb42bf00000000000),
         UINT64_C(0xb211700000000000),
         UINT64_C(0xe46f700000000000),
         UINT64_C(0xf21f700000000000),
         UINT64_C(0xa461700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff567e000000000),
         UINT64_C(0x3ff400e000000000),
         UINT64_C(0x3ff1670000000000),
         UINT64_C(0x3ff104a800000000),
         UINT64_C(0x3ff4634800000000),
         UINT64_C(0x3ff5044800000000),
         UINT64_C(0x3ff063a800000000),
         UINT64_C(0x3ffa25bf00000000),
         UINT64_C(0x3fff425f00000000),
         UINT64_C(0x3ffe255f00000000),
         UINT64_C(0x3ffb42bf00000000),
         UINT64_C(0x3ffb211700000000),
         UINT64_C(0x3ffe46f700000000),
         UINT64_C(0x3fff21f700000000),
         UINT64_C(0x3ffa461700000000)},
        UINT64_C(0xfff8000000000000),
        {0x03,0xbd,0x25,0xe1,0x44,0x55,0x3f,0xb7,0xd7,0x65,
         0x8f,0x5c,0x38,0x89,0x43,0xda,0x96,0xe7,0x76,0x64,0x00}
    },
    {
        /* No.191 delta:2335 weight:3369 */
        11213,
        25,
        7,
        9,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x45bf5ae600000000),
         UINT64_C(0x8e95b6e100000000),
         UINT64_C(0xcb2aec0700000000),
         UINT64_C(0x52b000bf00000000),
         UINT64_C(0x170f5a5900000000),
         UINT64_C(0xdc25b65e00000000),
         UINT64_C(0x999aecb800000000),
         UINT64_C(0x0000c08500000000),
         UINT64_C(0x45bf9a6300000000),
         UINT64_C(0x8e95766400000000),
         UINT64_C(0xcb2a2c8200000000),
         UINT64_C(0x52b0c03a00000000),
         UINT64_C(0x170f9adc00000000),
         UINT64_C(0xdc2576db00000000),
         UINT64_C(0x999a2c3d00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2000000000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x7000000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x6000000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x3000000000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x7003f00000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x3003f00000000000),
         UINT64_C(0x1003f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2000000000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff7000000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff6000000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff3000000000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff7003f00000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff3003f00000000),
         UINT64_C(0x3ff1003f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xb4,0x5c,0xa2,0x65,0x73,0x76,0xce,0xbf,0x5d,0xdf,
         0xce,0x0f,0x84,0xc1,0xea,0x79,0x17,0xb9,0x71,0x2d,0x00}
    },
    {
        /* No.192 delta:4104 weight:3063 */
        11213,
        10,
        23,
        2,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x175aa88c00000000),
         UINT64_C(0x7e28513000000000),
         UINT64_C(0x6972f9bc00000000),
         UINT64_C(0xb66e00c000000000),
         UINT64_C(0xa134a84c00000000),
         UINT64_C(0xc84651f000000000),
         UINT64_C(0xdf1cf97c00000000),
         UINT64_C(0x0000a6f800000000),
         UINT64_C(0x175a0e7400000000),
         UINT64_C(0x7e28f7c800000000),
         UINT64_C(0x69725f4400000000),
         UINT64_C(0xb66ea63800000000),
         UINT64_C(0xa1340eb400000000),
         UINT64_C(0xc846f70800000000),
         UINT64_C(0xdf1c5f8400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x19eda00000000000),
         UINT64_C(0x4140e00000000000),
         UINT64_C(0x58ad400000000000),
         UINT64_C(0x004e800000000000),
         UINT64_C(0x19a3200000000000),
         UINT64_C(0x410e600000000000),
         UINT64_C(0x58e3c00000000000),
         UINT64_C(0x200bf00000000000),
         UINT64_C(0x39e6500000000000),
         UINT64_C(0x614b100000000000),
         UINT64_C(0x78a6b00000000000),
         UINT64_C(0x2045700000000000),
         UINT64_C(0x39a8d00000000000),
         UINT64_C(0x6105900000000000),
         UINT64_C(0x78e8300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff19eda00000000),
         UINT64_C(0x3ff4140e00000000),
         UINT64_C(0x3ff58ad400000000),
         UINT64_C(0x3ff004e800000000),
         UINT64_C(0x3ff19a3200000000),
         UINT64_C(0x3ff410e600000000),
         UINT64_C(0x3ff58e3c00000000),
         UINT64_C(0x3ff200bf00000000),
         UINT64_C(0x3ff39e6500000000),
         UINT64_C(0x3ff614b100000000),
         UINT64_C(0x3ff78a6b00000000),
         UINT64_C(0x3ff2045700000000),
         UINT64_C(0x3ff39a8d00000000),
         UINT64_C(0x3ff6105900000000),
         UINT64_C(0x3ff78e8300000000)},
        UINT64_C(0xfff8000000000000),
        {0x7e,0xcb,0x1b,0x7f,0xd5,0xd5,0x2b,0x02,0x0e,0x04,
         0x2b,0xf8,0xdc,0xa2,0x06,0x97,0xe5,0x60,0x99,0xe1,0x00}
    },
    {
        /* No.193 delta:3982 weight:2887 */
        11213,
        34,
        13,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x02e4976e00000000),
         UINT64_C(0x2a978daa00000000),
         UINT64_C(0x28731ac400000000),
         UINT64_C(0x04f400c100000000),
         UINT64_C(0x061097af00000000),
         UINT64_C(0x2e638d6b00000000),
         UINT64_C(0x2c871a0500000000),
         UINT64_C(0x0000049500000000),
         UINT64_C(0x02e493fb00000000),
         UINT64_C(0x2a97893f00000000),
         UINT64_C(0x28731e5100000000),
         UINT64_C(0x04f4045400000000),
         UINT64_C(0x0610933a00000000),
         UINT64_C(0x2e6389fe00000000),
         UINT64_C(0x2c871e9000000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1407200000000000),
         UINT64_C(0xa103000000000000),
         UINT64_C(0xb504200000000000),
         UINT64_C(0x1b08200000000000),
         UINT64_C(0x0f0f000000000000),
         UINT64_C(0xba0b200000000000),
         UINT64_C(0xae0c000000000000),
         UINT64_C(0x0243f00000000000),
         UINT64_C(0x1644d00000000000),
         UINT64_C(0xa340f00000000000),
         UINT64_C(0xb747d00000000000),
         UINT64_C(0x194bd00000000000),
         UINT64_C(0x0d4cf00000000000),
         UINT64_C(0xb848d00000000000),
         UINT64_C(0xac4ff00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1407200000000),
         UINT64_C(0x3ffa103000000000),
         UINT64_C(0x3ffb504200000000),
         UINT64_C(0x3ff1b08200000000),
         UINT64_C(0x3ff0f0f000000000),
         UINT64_C(0x3ffba0b200000000),
         UINT64_C(0x3ffae0c000000000),
         UINT64_C(0x3ff0243f00000000),
         UINT64_C(0x3ff1644d00000000),
         UINT64_C(0x3ffa340f00000000),
         UINT64_C(0x3ffb747d00000000),
         UINT64_C(0x3ff194bd00000000),
         UINT64_C(0x3ff0d4cf00000000),
         UINT64_C(0x3ffb848d00000000),
         UINT64_C(0x3ffac4ff00000000)},
        UINT64_C(0xfff8000000000000),
        {0xcd,0x66,0xf6,0x83,0x82,0xa5,0xfd,0x6e,0x5b,0x7d,
         0xad,0x60,0x5d,0x9a,0x8e,0x02,0x54,0xb3,0x46,0x18,0x00}
    },
    {
        /* No.194 delta:2435 weight:3641 */
        11213,
        33,
        6,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x7750ff6a00000000),
         UINT64_C(0x89438cdc00000000),
         UINT64_C(0xfe1373b600000000),
         UINT64_C(0x356a00c200000000),
         UINT64_C(0x423affa800000000),
         UINT64_C(0xbc298c1e00000000),
         UINT64_C(0xcb79737400000000),
         UINT64_C(0x0000d44000000000),
         UINT64_C(0x77502b2a00000000),
         UINT64_C(0x8943589c00000000),
         UINT64_C(0xfe13a7f600000000),
         UINT64_C(0x356ad48200000000),
         UINT64_C(0x423a2be800000000),
         UINT64_C(0xbc29585e00000000),
         UINT64_C(0xcb79a73400000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1000000000000000),
         UINT64_C(0x2020000000000000),
         UINT64_C(0x3020000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x5000000000000000),
         UINT64_C(0x6020000000000000),
         UINT64_C(0x7020000000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x2023f00000000000),
         UINT64_C(0x3023f00000000000),
         UINT64_C(0x4003f00000000000),
         UINT64_C(0x5003f00000000000),
         UINT64_C(0x6023f00000000000),
         UINT64_C(0x7023f00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff1000000000000),
         UINT64_C(0x3ff2020000000000),
         UINT64_C(0x3ff3020000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff5000000000000),
         UINT64_C(0x3ff6020000000000),
         UINT64_C(0x3ff7020000000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff2023f00000000),
         UINT64_C(0x3ff3023f00000000),
         UINT64_C(0x3ff4003f00000000),
         UINT64_C(0x3ff5003f00000000),
         UINT64_C(0x3ff6023f00000000),
         UINT64_C(0x3ff7023f00000000)},
        UINT64_C(0xfff8000000000000),
        {0xeb,0x5f,0x03,0xfc,0xfb,0xcb,0x73,0x2d,0x12,0x47,
         0x67,0xb0,0xcb,0xb6,0xb1,0xaf,0x46,0xd6,0xa8,0xf1,0x00}
    },
    {
        /* No.195 delta:2602 weight:3353 */
        11213,
        8,
        6,
        1,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xd6c51f9500000000),
         UINT64_C(0x649c981100000000),
         UINT64_C(0xb259878400000000),
         UINT64_C(0xf19200c300000000),
         UINT64_C(0x27571f5600000000),
         UINT64_C(0x950e98d200000000),
         UINT64_C(0x43cb874700000000),
         UINT64_C(0x00006d6d00000000),
         UINT64_C(0xd6c572f800000000),
         UINT64_C(0x649cf57c00000000),
         UINT64_C(0xb259eae900000000),
         UINT64_C(0xf1926dae00000000),
         UINT64_C(0x2757723b00000000),
         UINT64_C(0x950ef5bf00000000),
         UINT64_C(0x43cbea2a00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x2003000000000000),
         UINT64_C(0x4000000000000000),
         UINT64_C(0x6003000000000000),
         UINT64_C(0x2403800000000000),
         UINT64_C(0x0400800000000000),
         UINT64_C(0x6403800000000000),
         UINT64_C(0x4400800000000000),
         UINT64_C(0x2003f00000000000),
         UINT64_C(0x0000f00000000000),
         UINT64_C(0x6003f00000000000),
         UINT64_C(0x4000f00000000000),
         UINT64_C(0x0400700000000000),
         UINT64_C(0x2403700000000000),
         UINT64_C(0x4400700000000000),
         UINT64_C(0x6403700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff2003000000000),
         UINT64_C(0x3ff4000000000000),
         UINT64_C(0x3ff6003000000000),
         UINT64_C(0x3ff2403800000000),
         UINT64_C(0x3ff0400800000000),
         UINT64_C(0x3ff6403800000000),
         UINT64_C(0x3ff4400800000000),
         UINT64_C(0x3ff2003f00000000),
         UINT64_C(0x3ff0000f00000000),
         UINT64_C(0x3ff6003f00000000),
         UINT64_C(0x3ff4000f00000000),
         UINT64_C(0x3ff0400700000000),
         UINT64_C(0x3ff2403700000000),
         UINT64_C(0x3ff4400700000000),
         UINT64_C(0x3ff6403700000000)},
        UINT64_C(0xfff8000000000000),
        {0x09,0xe5,0x02,0xc8,0xfd,0x8b,0xdf,0x5d,0xba,0x6e,
         0xce,0x20,0x14,0xe0,0x61,0xa3,0x20,0x91,0x3e,0x85,0x00}
    },
    {
        /* No.196 delta:3008 weight:2053 */
        11213,
        4,
        7,
        8,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xd0c95a5100000000),
         UINT64_C(0xe433cd3100000000),
         UINT64_C(0x34fa976000000000),
         UINT64_C(0x736600c400000000),
         UINT64_C(0xa3af5a9500000000),
         UINT64_C(0x9755cdf500000000),
         UINT64_C(0x479c97a400000000),
         UINT64_C(0x0000597700000000),
         UINT64_C(0xd0c9032600000000),
         UINT64_C(0xe433944600000000),
         UINT64_C(0x34face1700000000),
         UINT64_C(0x736659b300000000),
         UINT64_C(0xa3af03e200000000),
         UINT64_C(0x9755948200000000),
         UINT64_C(0x479cced300000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0087800000000000),
         UINT64_C(0x0061a00000000000),
         UINT64_C(0x00e6200000000000),
         UINT64_C(0x2003800000000000),
         UINT64_C(0x2084000000000000),
         UINT64_C(0x2062200000000000),
         UINT64_C(0x20e5a00000000000),
         UINT64_C(0x4267f00000000000),
         UINT64_C(0x42e0700000000000),
         UINT64_C(0x4206500000000000),
         UINT64_C(0x4281d00000000000),
         UINT64_C(0x6264700000000000),
         UINT64_C(0x62e3f00000000000),
         UINT64_C(0x6205d00000000000),
         UINT64_C(0x6282500000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0087800000000),
         UINT64_C(0x3ff0061a00000000),
         UINT64_C(0x3ff00e6200000000),
         UINT64_C(0x3ff2003800000000),
         UINT64_C(0x3ff2084000000000),
         UINT64_C(0x3ff2062200000000),
         UINT64_C(0x3ff20e5a00000000),
         UINT64_C(0x3ff4267f00000000),
         UINT64_C(0x3ff42e0700000000),
         UINT64_C(0x3ff4206500000000),
         UINT64_C(0x3ff4281d00000000),
         UINT64_C(0x3ff6264700000000),
         UINT64_C(0x3ff62e3f00000000),
         UINT64_C(0x3ff6205d00000000),
         UINT64_C(0x3ff6282500000000)},
        UINT64_C(0xfff8000000000000),
        {0xf0,0xa0,0x85,0x82,0xb4,0xa7,0x4c,0xec,0xa1,0x07,
         0x4a,0x96,0x86,0x24,0x0e,0xc1,0x49,0x02,0x0c,0x20,0x00}
    },
    {
        /* No.197 delta:2780 weight:2005 */
        11213,
        26,
        27,
        5,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x1150fcd900000000),
         UINT64_C(0x0075e15f00000000),
         UINT64_C(0x11251d8600000000),
         UINT64_C(0x814700c500000000),
         UINT64_C(0x9017fc1c00000000),
         UINT64_C(0x8132e19a00000000),
         UINT64_C(0x90621d4300000000),
         UINT64_C(0x0000296b00000000),
         UINT64_C(0x1150d5b200000000),
         UINT64_C(0x0075c83400000000),
         UINT64_C(0x112534ed00000000),
         UINT64_C(0x814729ae00000000),
         UINT64_C(0x9017d57700000000),
         UINT64_C(0x8132c8f100000000),
         UINT64_C(0x9062342800000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x003ac00000000000),
         UINT64_C(0x1003200000000000),
         UINT64_C(0x1039e00000000000),
         UINT64_C(0x6002600000000000),
         UINT64_C(0x6038a00000000000),
         UINT64_C(0x7001400000000000),
         UINT64_C(0x703b800000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x0039300000000000),
         UINT64_C(0x1000d00000000000),
         UINT64_C(0x103a100000000000),
         UINT64_C(0x6001900000000000),
         UINT64_C(0x603b500000000000),
         UINT64_C(0x7002b00000000000),
         UINT64_C(0x7038700000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff003ac00000000),
         UINT64_C(0x3ff1003200000000),
         UINT64_C(0x3ff1039e00000000),
         UINT64_C(0x3ff6002600000000),
         UINT64_C(0x3ff6038a00000000),
         UINT64_C(0x3ff7001400000000),
         UINT64_C(0x3ff703b800000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff0039300000000),
         UINT64_C(0x3ff1000d00000000),
         UINT64_C(0x3ff103a100000000),
         UINT64_C(0x3ff6001900000000),
         UINT64_C(0x3ff603b500000000),
         UINT64_C(0x3ff7002b00000000),
         UINT64_C(0x3ff7038700000000)},
        UINT64_C(0xfff8000000000000),
        {0x41,0x2b,0xcf,0x85,0x40,0x27,0xc4,0xd1,0xd2,0x44,
         0xe5,0x18,0x77,0xd0,0x98,0x41,0x16,0x99,0x8e,0x69,0x00}
    },
    {
        /* No.198 delta:2540 weight:3651 */
        11213,
        15,
        4,
        6,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0xe6cc260800000000),
         UINT64_C(0x5a07249300000000),
         UINT64_C(0xbccb029b00000000),
         UINT64_C(0x619500c600000000),
         UINT64_C(0x875926ce00000000),
         UINT64_C(0x3b92245500000000),
         UINT64_C(0xdd5e025d00000000),
         UINT64_C(0x0000459000000000),
         UINT64_C(0xe6cc639800000000),
         UINT64_C(0x5a07610300000000),
         UINT64_C(0xbccb470b00000000),
         UINT64_C(0x6195455600000000),
         UINT64_C(0x8759635e00000000),
         UINT64_C(0x3b9261c500000000),
         UINT64_C(0xdd5e47cd00000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x4002400000000000),
         UINT64_C(0x4003200000000000),
         UINT64_C(0x0001600000000000),
         UINT64_C(0x1004a00000000000),
         UINT64_C(0x5006e00000000000),
         UINT64_C(0x5007800000000000),
         UINT64_C(0x1005c00000000000),
         UINT64_C(0x0003f00000000000),
         UINT64_C(0x4001b00000000000),
         UINT64_C(0x4000d00000000000),
         UINT64_C(0x0002900000000000),
         UINT64_C(0x1007500000000000),
         UINT64_C(0x5005100000000000),
         UINT64_C(0x5004700000000000),
         UINT64_C(0x1006300000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff4002400000000),
         UINT64_C(0x3ff4003200000000),
         UINT64_C(0x3ff0001600000000),
         UINT64_C(0x3ff1004a00000000),
         UINT64_C(0x3ff5006e00000000),
         UINT64_C(0x3ff5007800000000),
         UINT64_C(0x3ff1005c00000000),
         UINT64_C(0x3ff0003f00000000),
         UINT64_C(0x3ff4001b00000000),
         UINT64_C(0x3ff4000d00000000),
         UINT64_C(0x3ff0002900000000),
         UINT64_C(0x3ff1007500000000),
         UINT64_C(0x3ff5005100000000),
         UINT64_C(0x3ff5004700000000),
         UINT64_C(0x3ff1006300000000)},
        UINT64_C(0xfff8000000000000),
        {0x46,0xa1,0x45,0x70,0xc4,0x13,0xbf,0x01,0x84,0x97,
         0xba,0x7a,0x11,0xfa,0x91,0xc5,0x48,0x19,0xbd,0x62,0x00}
    },
    {
        /* No.199 delta:2397 weight:3235 */
        11213,
        34,
        17,
        15,
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x342d230400000000),
         UINT64_C(0xda6b556700000000),
         UINT64_C(0xee46766300000000),
         UINT64_C(0x937400c700000000),
         UINT64_C(0xa75923c300000000),
         UINT64_C(0x491f55a000000000),
         UINT64_C(0x7d3276a400000000),
         UINT64_C(0x000081f600000000),
         UINT64_C(0x342da2f200000000),
         UINT64_C(0xda6bd49100000000),
         UINT64_C(0xee46f79500000000),
         UINT64_C(0x9374813100000000),
         UINT64_C(0xa759a23500000000),
         UINT64_C(0x491fd45600000000),
         UINT64_C(0x7d32f75200000000)},
        {UINT64_C(0x0000000000000000),
         UINT64_C(0x0008100000000000),
         UINT64_C(0x6400000000000000),
         UINT64_C(0x6408100000000000),
         UINT64_C(0x0000400000000000),
         UINT64_C(0x0008500000000000),
         UINT64_C(0x6400400000000000),
         UINT64_C(0x6408500000000000),
         UINT64_C(0x1003f00000000000),
         UINT64_C(0x100be00000000000),
         UINT64_C(0x7403f00000000000),
         UINT64_C(0x740be00000000000),
         UINT64_C(0x1003b00000000000),
         UINT64_C(0x100ba00000000000),
         UINT64_C(0x7403b00000000000),
         UINT64_C(0x740ba00000000000)},
        {UINT64_C(0x3ff0000000000000),
         UINT64_C(0x3ff0008100000000),
         UINT64_C(0x3ff6400000000000),
         UINT64_C(0x3ff6408100000000),
         UINT64_C(0x3ff0000400000000),
         UINT64_C(0x3ff0008500000000),
         UINT64_C(0x3ff6400400000000),
         UINT64_C(0x3ff6408500000000),
         UINT64_C(0x3ff1003f00000000),
         UINT64_C(0x3ff100be00000000),
         UINT64_C(0x3ff7403f00000000),
         UINT64_C(0x3ff740be00000000),
         UINT64_C(0x3ff1003b00000000),
         UINT64_C(0x3ff100ba00000000),
         UINT64_C(0x3ff7403b00000000),
         UINT64_C(0x3ff740ba00000000)},
        UINT64_C(0xfff8000000000000),
        {0xf4,0x9b,0x53,0x4a,0x73,0x84,0x03,0x58,0xdb,0x4b,
         0x7e,0x18,0xa5,0x8a,0x0e,0xdd,0x66,0x21,0x8e,0xe8,0x00}
    }
};
extern const int mtgpdc_params_11213_num;
const int mtgpdc_params_11213_num  = 200;
