
# pma.py -o Stack3FSM Stack Filter3
# 15 states, 28 transitions, 15 accepting states, 0 unsafe states, 0 finished and 0 deadend states

# actions here are just labels, but must be symbols with __name__ attribute

def Push(): pass
def Pop(): pass

# states, key of each state here is its number in graph etc. below

states = {
  0 : {'Stack': {'stack': []}},
  1 : {'Stack': {'stack': [2]}},
  2 : {'Stack': {'stack': [1]}},
  3 : {'Stack': {'stack': [2, 2]}},
  4 : {'Stack': {'stack': [1, 2]}},
  5 : {'Stack': {'stack': [2, 1]}},
  6 : {'Stack': {'stack': [1, 1]}},
  7 : {'Stack': {'stack': [2, 2, 2]}},
  8 : {'Stack': {'stack': [1, 2, 2]}},
  9 : {'Stack': {'stack': [2, 1, 2]}},
  10 : {'Stack': {'stack': [1, 1, 2]}},
  11 : {'Stack': {'stack': [2, 2, 1]}},
  12 : {'Stack': {'stack': [1, 2, 1]}},
  13 : {'Stack': {'stack': [2, 1, 1]}},
  14 : {'Stack': {'stack': [1, 1, 1]}},
}

# initial state, accepting states, unsafe states, frontier states, deadend states

initial = 0
accepting = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]
unsafe = []
frontier = []
finished = []
deadend = []
runstarts = [0]

# finite state machine, list of tuples: (current, (action, args, result), next)

graph = (
  (0, (Push, (2,), None), 1),
  (0, (Push, (1,), None), 2),
  (1, (Pop, (), 2), 0),
  (1, (Push, (2,), None), 3),
  (1, (Push, (1,), None), 4),
  (2, (Pop, (), 1), 0),
  (2, (Push, (2,), None), 5),
  (2, (Push, (1,), None), 6),
  (3, (Pop, (), 2), 1),
  (3, (Push, (2,), None), 7),
  (3, (Push, (1,), None), 8),
  (4, (Pop, (), 1), 1),
  (4, (Push, (2,), None), 9),
  (4, (Push, (1,), None), 10),
  (5, (Pop, (), 2), 2),
  (5, (Push, (2,), None), 11),
  (5, (Push, (1,), None), 12),
  (6, (Pop, (), 1), 2),
  (6, (Push, (2,), None), 13),
  (6, (Push, (1,), None), 14),
  (7, (Pop, (), 2), 3),
  (8, (Pop, (), 1), 3),
  (9, (Pop, (), 2), 4),
  (10, (Pop, (), 1), 4),
  (11, (Pop, (), 2), 5),
  (12, (Pop, (), 1), 5),
  (13, (Pop, (), 2), 6),
  (14, (Pop, (), 1), 6),
)
