
PyModel bin directory
=====================

This directory contains the commands for PyModel.

To use PyModel, this directory must be on your execution *PATH*.
Or, its contents must be installed in some directory that is on your
execution *PATH*.  See *pymodel_paths* in this directory.

There are two versions of some commands.  The version without a file
type is a *bash* script for Unix/Linux/Mac; the version with *.bat* is
a batch file for Windows.  There are no Windows versions of some
commands.

The commands are:

- *pma*, *pmg*, *pmt*, *pmv*: the four main PyModel commands.  They
  just run the Python modules with the same names in the *pymodel*
  directory.  For details, see *commands.txt* in the *notes* directory, or print
  their built-in help by typing *pma -h* etc.

- *dotpdf*, *dotps*, *dotsvg*: run the Graphviz *dot* program to
  produce *.pdf*, *.ps*, or *.svg* graphics files from the *.dot*
  files generated by *pmg*

- *trun*: runs test scripts, including sample demonstrations.  See
   *test.txt* in the *notes* directory.

- *tdiff*: works with *trun* to execute and check
  regression tests.  See *test.txt* in the *notes* directory.

- *tclean*: remove files created by running test scripts. See
   *test.txt* in the *notes* directory.

- *clogdiff*: same as *tdiff*, used in versions before 1.0,
  deprecated, retained for backward compatibility

- *wsgirunner*: runs WSGI-compliant web applications on *localhost*,
  such as *webapp* in the *WebApplication* sample, or *wsgidemo* here.

- *pymodel_paths*: assigns paths for running PyModel from these *PyModel*
    directories.  To prepare to use PyModel, execute this script,
    or put the commands from this script into your *.profile* or *.bashrc*.
    These commands add *PyModel/bin* to the execution
    *PATH*, and add *PyModel/pymodel* to the *PYTHONPATH*. They also
    add the current directory to the *PYTHONPATH*, because the
    PyModel programs *pmt* etc. all import Python modules in the
    current directory that are named on the command line.  
    (If you install PyModel so its commands and modules are placed
    in system directories, you may no longer need these commands.)

- *pymodel_paths.bat*: Windows batch file, assigns paths for running
    PyModel from these *PyModel* directories.  To prepare to use
    PyModel, execute this batch file, or arrange to have it executed
    each time you log in.  These commands add *PyModel/bin* to the
    execution *PATH*, and add *PyModel/pymodel* to the
    *PYTHONPATH*. They also add the current directory to the
    *PYTHONPATH*, because the PyModel programs *pmt* etc. all import
    Python modules in the current directory that are named on the
    command line.  Unlike the *bash* script, this batch file also adds
    *PyModel/pymodel* to the execution *PATH*.  (If you install
    PyModel so its commands and modules are placed in system
    directories, you may no longer need these commands.)  This file
    also adds the *.PY* extension to *PATHEXT* so you can run the
    *.py* files in *PyModel/pymodel* without typing the *.py*
    extension on the command line.

- *tpath*: puts the current directory on *PYTHONPATH*, alternative
  to *pymodel_paths* to use when PyModel is installed in system directories,
  might still be needed even then.  See *test.txt* in the *notes* directory

Revised May 2013
