Notes on PyModel
================

This directory contains some of the PyModel documentation.  See also
the *README* files in each directory, the slides and papers in the
[*talks*](../talks) directory, and the web pages in the
[*www*](../www) directory.

These are the files in this *notes* directory, in a recommended
reading order:

* *concepts.md*: concepts and vocabulary

* *commands.txt*: PyModel commands and how to use them. Also,
   *pma.txt*, *pmg.txt*, *pmt.txt*, and *pmv.txt* on each command.

* *samples.txt*: where to find the samples and how to run them.  See also
  the *README* in the samples directory and in each sample subdirectory.

* *models.txt*: how to write and use model programs, FSMs, and test suites

* *composition.txt*: how and why to use composition to combine models

* *strategy.txt*: how to select or write an optional strategy to guide test runs

* *stepper.txt*: how to write the test harness needed to test an implementation

* *test.txt*: how to script and run tests on the PyModel software itself

* *advice.txt*: miscellaneous tips and advice

* *socket_experiments.txt*: steppers and other files in the socket sample that
                          are not discussed in its *README*

* *releases.txt*: release history 

* *release-0.85.txt*: release notes

* *release-0.9.txt*: release notes

* *release-1.0.txt*: release notes


Revised May 2013
