''' Sample OPC Items for testing purposes '''

import datetime
from PyOPC.OPCContainers import *

# Initial timestamp for all ItemValues
def_ts = datetime.datetime(2006, 2, 15, 12, 15, 18)

TestOPCItems = ((ItemContainer(ItemName='sample_integer',
                               Value=14,
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 (OPCProperty(Name='accessRights',
                              Value='readWriteable'),
                  OPCProperty(Name='description',
                              Value='Integer Item'),
                  OPCProperty(Name='MyProperty',
                              Value = 'foobar',
                              ItemPath='MyPath',
                              ItemName='MyName'))),
                (ItemContainer(ItemName='sample_integerRO',
                               Value=14,
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 (OPCProperty(Name='accessRights',
                              Value='readable'),
                  OPCProperty(Name='description',
                              Value='RO Integer Item'),
                  OPCProperty(Name='MyProperty1',
                              Value = 'blabar',
                              ItemPath='MyPath',
                              ItemName='MyName'))),
                (ItemContainer(ItemName='sample_float',
                               Value=96.43,
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_boolean',
                               Value=True,
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_string',
                               Value='TestString',
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_time',
                               Value=datetime.datetime(2006,2,27,11,16,20),
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_qname',
                               Value=QNameValue('http://my.qn.org/xyz','ABC'),
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_ArrayOfInt',
                               Value=[1,2,3],
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_ArrayOfFloat',
                               Value=[12.2, 13.4, 15.6],
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_ArrayOfBoolean',
                               Value=[True, False, False],
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_ArrayOfBoolean',
                               Value=[True, False, False],
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_ArrayOfString',
                               Value=['foo', 'bar'],
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                # FIXME
                # (ItemContainer(ItemName='sample_ArrayOfDateTime',
                #               Value=[],
                #               Timestamp=def_ts,
                #               QualityField='good',
                #               LimitField='none',
                #               VendorField=0),)
                (ItemContainer(ItemName='sample_ArrayOfAnyType',
                               Value=[1, 'bar',3.2],
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0),
                 None),
                (ItemContainer(ItemName='sample_delay_05',
                               Value=123,
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0,
                               ReadDelay=500),
                 None),
                (ItemContainer(ItemName='sample_delay_1',
                               Value=456,
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0,
                               ReadDelay=1000),
                 None),
                (ItemContainer(ItemName='sample_delay_5',
                               Value=789,
                               Timestamp=def_ts,
                               QualityField='good',
                               LimitField='none',
                               VendorField=0,
                               ReadDelay=5000),
                 None)
                )
