'''OpenGL extension ATI.separate_stencil

Overview (from the spec)
	
	This extension provides the ability to modify the stencil buffer
	differently based on the facing direction of the primitive that
	generated the fragment.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/ATI/separate_stencil.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_STENCIL_BACK_FUNC_ATI = constant.Constant( 'GL_STENCIL_BACK_FUNC_ATI', 0x8800 )
GL_STENCIL_BACK_FAIL_ATI = constant.Constant( 'GL_STENCIL_BACK_FAIL_ATI', 0x8801 )
GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = constant.Constant( 'GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI', 0x8802 )
GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = constant.Constant( 'GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI', 0x8803 )
glStencilOpSeparateATI = platform.createExtensionFunction( 
	'glStencilOpSeparateATI', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLenum, constants.GLenum,),
	doc = 'glStencilOpSeparateATI( GLenum(face), GLenum(sfail), GLenum(dpfail), GLenum(dppass) ) -> None',
	argNames = ('face', 'sfail', 'dpfail', 'dppass',),
)

glStencilFuncSeparateATI = platform.createExtensionFunction( 
	'glStencilFuncSeparateATI', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLint, constants.GLuint,),
	doc = 'glStencilFuncSeparateATI( GLenum(frontfunc), GLenum(backfunc), GLint(ref), GLuint(mask) ) -> None',
	argNames = ('frontfunc', 'backfunc', 'ref', 'mask',),
)


def glInitSeparateStencilATI():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_ATI_separate_stencil' )
