'''OpenGL extension NV.multisample_filter_hint

Overview (from the spec)
	
	OpenGL multisampling typically assumes that the samples of a given
	pixel are weighted uniformly and averaged to compute the pixel's
	resolved color.  This extension provides a hint that permits
	implementations to provide an alternative method of resolving the
	color of multisampled pixels.
	
	As an example of such an alternative method, NVIDIA's GeForce3 GPU
	provides a technique known as Quincunx filtering.  This technique
	is used in two-sample multisampling, but it blends the pixel's two
	samples and three additional samples from adjacent pixels.  The sample
	pattern is analogous to the 5 pattern on a die.  The quality of this
	technique is widely regarded as comparable to 4 sample multisampling.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/NV/multisample_filter_hint.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_NV_multisample_filter_hint'
_DEPRECATED = False
GL_MULTISAMPLE_FILTER_HINT_NV = constant.Constant( 'GL_MULTISAMPLE_FILTER_HINT_NV', 0x8534 )
glget.addGLGetConstant( GL_MULTISAMPLE_FILTER_HINT_NV, (1,) )


def glInitMultisampleFilterHintNV():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
