'''OpenGL extension OML.resample

Overview (from the spec)
	
	This extension enhances the resampling capabilities of the
	OML_subsample extension. It is loosely based on the SGIX_resample
	extension.
	
	When converting data from subsampled to uniform sampling, upsampling
	may be performed by one of three methods: component replication,
	zero fill, or adjacent neighbor averaging.
	
	When converting data from uniform sampling to subsampled form,
	downsampling may be performed only by component decimation (point
	sampling) or averaging.
	
	Upsampling and downsampling filters other than those defined by this
	extension may be performed by appropriate use of convolution and
	other pixel transfer operations. The zero fill unpacking mode is
	included to assist applications wanting to define their own filters.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/OML/resample.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_OML_resample'
_DEPRECATED = False
GL_PACK_RESAMPLE_OML = constant.Constant( 'GL_PACK_RESAMPLE_OML', 0x8984 )
glget.addGLGetConstant( GL_PACK_RESAMPLE_OML, (1,) )
GL_UNPACK_RESAMPLE_OML = constant.Constant( 'GL_UNPACK_RESAMPLE_OML', 0x8985 )
glget.addGLGetConstant( GL_UNPACK_RESAMPLE_OML, (1,) )
GL_RESAMPLE_REPLICATE_OML = constant.Constant( 'GL_RESAMPLE_REPLICATE_OML', 0x8986 )
GL_RESAMPLE_ZERO_FILL_OML = constant.Constant( 'GL_RESAMPLE_ZERO_FILL_OML', 0x8987 )
GL_RESAMPLE_AVERAGE_OML = constant.Constant( 'GL_RESAMPLE_AVERAGE_OML', 0x8988 )
GL_RESAMPLE_DECIMATE_OML = constant.Constant( 'GL_RESAMPLE_DECIMATE_OML', 0x8989 )


def glInitResampleOML():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
