'''OpenGL extension ARB.point_sprite

Overview (from the spec)
	
	Applications such as particle systems have tended to use OpenGL quads
	rather than points to render their geometry, since they would like
	to use a custom-drawn texture for each particle, rather than the
	traditional OpenGL round antialiased points, and each fragment in
	a point has the same texture coordinates as every other fragment.
	
	Unfortunately, specifying the geometry for these quads can be
	expensive, since it quadruples the amount of geometry required, and
	may also require the application to do extra processing to compute
	the location of each vertex.
	
	The purpose of this extension is to allow such applications to use
	points rather than quads.  When GL_POINT_SPRITE_ARB is enabled,
	the state of point antialiasing is ignored.  For each texture unit,
	the app can then specify whether to replace the existing texture
	coordinates with point sprite texture coordinates, which are
	interpolated across the point.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/ARB/point_sprite.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_ARB_point_sprite'
_DEPRECATED = False
GL_POINT_SPRITE_ARB = constant.Constant( 'GL_POINT_SPRITE_ARB', 0x8861 )
glget.addGLGetConstant( GL_POINT_SPRITE_ARB, (1,) )
GL_COORD_REPLACE_ARB = constant.Constant( 'GL_COORD_REPLACE_ARB', 0x8862 )


def glInitPointSpriteARB():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
