'''OpenGL extension ARB.pixel_buffer_object

Overview (from the spec)
	
	This extension expands on the interface provided by the
	ARB_vertex_buffer_object extension (and later integrated into OpenGL
	1.5) in order to permit buffer objects to be used not only with vertex
	array data, but also with pixel data.  The intent is to provide more
	acceleration opportunities for OpenGL pixel commands.
	
	While a single buffer object can be bound for both vertex arrays and
	pixel commands, we use the designations vertex buffer object (VBO)
	and pixel buffer object (PBO) to indicate their particular usage in
	a given situation.
	
	Recall that buffer objects conceptually are nothing more than arrays
	of bytes, just like any chunk of memory.  ARB_vertex_buffer_object
	allows GL commands to source data from a buffer object by binding the
	buffer object to a given target and then overloading a certain set of
	GL commands' pointer arguments to refer to offsets inside the buffer,
	rather than pointers to user memory.  An offset is encoded in a
	pointer by adding the offset to a null pointer.
	
	This extension does not add any new functionality to buffer objects
	themselves.  It simply adds two new targets to which buffer objects
	can be bound: GL_PIXEL_PACK_BUFFER and GL_PIXEL_UNPACK_BUFFER.  When a
	buffer object is bound to the GL_PIXEL_PACK_BUFFER target, commands
	such as glReadPixels pack (write) their data into a buffer object.
	When a buffer object is bound to the GL_PIXEL_UNPACK_BUFFER target,
	commands such as glDrawPixels and glTexImage2D unpack (read) their
	data from a buffer object.
	
	There are a several approaches to improve graphics performance
	with PBOs.  Some of the most interesting approaches are:
	
	- Streaming texture updates:  If the application uses
	  glMapBuffer/glUnmapBuffer to write its data for glTexSubImage into
	  a buffer object, at least one of the data copies usually required
	  to download a texture can be eliminated, significantly increasing
	  texture download performance.
	
	- Streaming draw pixels: When glDrawPixels sources client memory,
	  OpenGL says the client memory can be modified immediately after the
	  glDrawPixels command returns without disturbing the drawn image.
	  This typically necessitates unpacking and copying the image prior
	  to glDrawPixels returning.  However, when using glDrawPixels with
	  a pixel pack buffer object, glDrawPixels may return prior to image
	  unpacking because future modification of the buffer data requires
	  explicit commands (glMapBuffer, glBufferData, or glBufferSubData).
	
	- Asynchronous glReadPixels:  If an application needs to read back a
	  number of images and process them with the CPU, the existing GL
	  interface makes it nearly impossible to pipeline this operation.
	  The driver will typically send the hardware a readback command
	  when glReadPixels is called, and then wait for all of the data to
	  be available before returning control to the application.  Then,
	  the application can either process the data immediately or call
	  glReadPixels again; in neither case will the readback overlap with
	  the processing.  If the application issues several readbacks
	  into several buffer objects, however, and then maps each one to
	  process its data, then the readbacks can proceed in parallel with
	  the data processing.
	
	- Render to vertex array:  The application can use a fragment
	  program to render some image into one of its buffers, then read
	  this image out into a buffer object via glReadPixels.  Then, it can
	  use this buffer object as a source of vertex data.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/ARB/pixel_buffer_object.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_ARB_pixel_buffer_object'
_DEPRECATED = False
GL_PIXEL_PACK_BUFFER_ARB = constant.Constant( 'GL_PIXEL_PACK_BUFFER_ARB', 0x88EB )
GL_PIXEL_UNPACK_BUFFER_ARB = constant.Constant( 'GL_PIXEL_UNPACK_BUFFER_ARB', 0x88EC )
GL_PIXEL_PACK_BUFFER_BINDING_ARB = constant.Constant( 'GL_PIXEL_PACK_BUFFER_BINDING_ARB', 0x88ED )
glget.addGLGetConstant( GL_PIXEL_PACK_BUFFER_BINDING_ARB, (1,) )
GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = constant.Constant( 'GL_PIXEL_UNPACK_BUFFER_BINDING_ARB', 0x88EF )
glget.addGLGetConstant( GL_PIXEL_UNPACK_BUFFER_BINDING_ARB, (1,) )


def glInitPixelBufferObjectARB():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
