'''OpenGL extension SGIX.ycrcb

Overview (from the spec)
	
	This extension provides a method for OpenGL to read and store 
	images that are defined in standard YCRCB 422 and 444 video formats.
	As with the CYMK extension, conversion to RGBA takes place immediately 
	following the unpack pixel store, and preceding the pack pixel store 
	operations, and is only available on transfers to and from memory.  
	The algorithms that convert between YCRCB and RGBA are "black-box"
	in nature, and left undefined by the extension.
	
	Two new formats are added, YCRCB_422_SGIX and YCRCB_444_SGIX.
	
	To handle the difference in sampling rate for 422 video, the pixel 
	storage operations treat YCRCB_422_SGIX as a 2 component format,
	where the first component represents chroma, and the second luma.
	The chroma component alternates between Cb and Cr values on
	a per pixel basis.  If the specified image <width> parameter is not
	a multiple of 2, then fragments or texels that result from processing 
	the <width>th column of pixels will have undefined color value.
	
	YCRCB_444_SGIX is defined as a 3 component format representing 
	the Cb, Y, and Cr values per pixel.
	
	As with the CMYK extension, this extension doesn't preclude the 
	possiblity of other higher quality conversion methods.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/SGIX/ycrcb.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIX_ycrcb'
_DEPRECATED = False
GL_YCRCB_422_SGIX = constant.Constant( 'GL_YCRCB_422_SGIX', 0x81BB )
GL_YCRCB_444_SGIX = constant.Constant( 'GL_YCRCB_444_SGIX', 0x81BC )


def glInitYcrcbSGIX():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
