'''OpenGL extension ARB.separate_shader_objects

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.separate_shader_objects to provide a more 
Python-friendly API

Overview (from the spec)
	
	Conventional GLSL requires multiple shader stages (vertex,
	fragment, geometry, tessellation control, and tessellation
	evaluation) to be linked into a single monolithic program object to
	specify a GLSL shader for each stage.
	
	While GLSL's monolithic approach has some advantages for
	optimizing shaders as a unit that span multiple stages, all
	existing GPU hardware supports the more flexible mix-and-match
	approach.
	
	Shaders written for HLSL9, Cg, the prior OpenGL assembly program
	extensions, and game console favor a more flexible "mix-and-match"
	approach to specifying shaders independently for these different
	shader stages.  Many developers build their shader content around
	the mix-and-match approach where they can use a single vertex shader
	with multiple fragment shaders (or vice versa).
	
	This extension adopts a "mix-and-match" shader stage model for GLSL
	allowing multiple different GLSL program objects to be bound at once
	each to an individual rendering pipeline stage independently of
	other stage bindings. This allows program objects to contain only
	the shader stages that best suit the applications needs.
	
	This extension introduces the program pipeline object that serves as
	a container for the program bound to any particular rendering stage.
	It can be bound, unbound, and rebound to simply save and restore the
	complete shader stage to program object bindings.
	
	To bind a program object to a specific shader stage or set of
	stages, UseProgramStages is used.  The VERTEX_SHADER_BIT,
	GEOMETRY_SHADER_BIT, FRAGMENT_SHADER_BIT, TESS_CONTROL_SHADER_BIT,
	and TESS_EVALUATION_SHADER_BIT tokens refer to the conventional
	vertex, geometry, fragment, tessellation control and tessellation
	evaluation stages respectively. ActiveShaderProgram specifies the
	program that Uniform* commands will update.
	
	While ActiveShaderProgram allows the use of conventional Uniform*
	commands to update uniform variable values for separable program
	objects, this extension provides a preferrable interface in a set
	of ProgramUniform* commands that update the same uniform variables
	but take a parameter indicating the program object to be updated,
	rather than updating the currently active program object. These
	commands mirror those introduced in EXT_direct_state_access.
	
	While glActiveShaderProgram provides a selector for setting and
	querying uniform values of a program object, the glProgramUniform*
	commands provide a selector-free way to modify uniforms of a GLSL
	program object without an explicit bind. This selector-free model
	reduces API overhead and provides a cleaner interface for
	applications.
	
	Separate linking creates the possibility that certain output varyings
	of a shader may go unread by the subsequent shader inputting varyings.
	In this case, the output varyings are simply ignored.  It is also
	possible input varyings from a shader may not be written as output
	varyings of a preceding shader.  In this case, the unwritten input
	varying values are undefined.
	
	This extension builds on the proof-of-concept provided by
	EXT_separate_shader_objects which demonstrated that separate
	shader objects can work for GLSL.  EXT_separate_shader_objects
	was a response to repeated requests for this functionality from
	3D developers.
	
	This ARB version addresses several "loose ends" in the prior
	EXT extension.  In particular, it allows user-defined varyings
	with explicitly defined locations or implicitly assigned locations.
	
	This ARB extension extends the GLSL language's use of layout
	qualifiers to provide cross-stage interfacing.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/separate_shader_objects.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.separate_shader_objects import *
### END AUTOGENERATED SECTION