'''OpenGL extension NV.draw_texture

This module customises the behaviour of the 
OpenGL.raw.GL.NV.draw_texture to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a new function, DrawTextureNV(), allowing
	applications to draw an screen-aligned rectangle displaying some or all of
	the contents of a two-dimensional or rectangle texture.  Callers specify a
	texture object, an optional sampler object, window coordinates of the
	rectangle to draw, and texture coordinates corresponding to the corners of
	the rectangle.  For each fragment produced by the rectangle, DrawTextureNV
	interpolates the texture coordinates, performs a texture lookup, and uses
	the texture result as the fragment color.
	
	No shaders are used by DrawTextureNV; the results of the texture lookup
	are used in lieu of a fragment shader output.  The fragments generated are
	processed by all per-fragment operations.  In particular,
	DrawTextureNV() fully supports blending and multisampling.
	
	While this functionality can be obtained in unextended OpenGL by drawing a
	rectangle and using a fragment shader to do a texture lookup,
	DrawTextureNV() is likely to have better power efficiency on
	implementations supporting this extension.  Additionally, use of this
	extension frees the application developer from having to set up
	specialized shaders, transformation matrices, vertex attributes, and
	various other state in order to render the rectangle.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/draw_texture.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.NV.draw_texture import *
### END AUTOGENERATED SECTION