'''OpenGL extension EXT.packed_depth_stencil

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.packed_depth_stencil to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/packed_depth_stencil.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.EXT.packed_depth_stencil import *
from OpenGL.raw.GL.EXT.packed_depth_stencil import _EXTENSION_NAME

def glInitPackedDepthStencilEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION
# Setup the new image types
from OpenGL import images 
from OpenGL.raw.GL.VERSION.GL_1_1 import GL_UNSIGNED_INT
images.TYPE_TO_ARRAYTYPE[ GL_UNSIGNED_INT_24_8_EXT ] = GL_UNSIGNED_INT
images.TIGHT_PACK_FORMATS[ GL_UNSIGNED_INT_24_8_EXT ] = 4
images.COMPONENT_COUNTS[ GL_DEPTH_STENCIL_EXT ] = 4
