'''OpenGL extension APPLE.specular_vector

This module customises the behaviour of the 
OpenGL.raw.GL.APPLE.specular_vector to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/APPLE/specular_vector.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.APPLE.specular_vector import *
from OpenGL.raw.GL.APPLE.specular_vector import _EXTENSION_NAME

def glInitSpecularVectorAPPLE():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION
from OpenGL.GL import glget
glget.addGLGetConstant( GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE, (1,) ) # check size...