'''OpenGL extension SGIS.texture4D

This module customises the behaviour of the 
OpenGL.raw.GL.SGIS.texture4D to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIS/texture4D.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.SGIS.texture4D import *
from OpenGL.raw.GL.SGIS.texture4D import _EXTENSION_NAME

def glInitTexture4DSGIS():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION

from OpenGL.GL import images as _i
_i.images.RANK_PACKINGS.setdefault(4,[]).extend([
    (glPixelStorei,GL_PACK_SKIP_VOLUMES_SGIS, 0),
    (glPixelStorei,GL_PACK_IMAGE_DEPTH_SGIS, 0),
])
