'''OpenGL extension ARB.transpose_matrix

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.transpose_matrix to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/transpose_matrix.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.transpose_matrix import *
from OpenGL.raw.GL.ARB.transpose_matrix import _EXTENSION_NAME

def glInitTransposeMatrixARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION
for typ,arrayType in (
    ('d',arrays.GLdoubleArray),
    ('f',arrays.GLfloatArray),
):
    for function in ('glLoadTransposeMatrix','glMultTransposeMatrix'):
        name = '%s%sARB'%(function,typ)
        globals()[name] = arrays.setInputArraySizeType(
            globals()[name],
            16,
            arrayType,
            'm',
        )
        try:
            del function,name
        except NameError as err:
            pass
    try:
        del typ,arrayType
    except NameError as err:
        pass
