'''OpenGL extension NV.float_buffer

This module customises the behaviour of the 
OpenGL.raw.GLX.NV.float_buffer to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/float_buffer.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GLX import _types
from OpenGL.raw.GLX.NV.float_buffer import *
from OpenGL.raw.GLX.NV.float_buffer import _EXTENSION_NAME

def glInitFloatBufferNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION