/* *********************************************************************************************** */

// #shader_type fragment

#version 330

/* *********************************************************************************************** */

uniform sampler1D stipple_texture;

/* *********************************************************************************************** */

in VertexAttributes
{
  vec4 colour;
  float stipple_position;
} vertex;

/* *********************************************************************************************** */

out vec4 fragment_colour;

/* *********************************************************************************************** */

void main()
{
  vec4 stipple_colour = texture(stipple_texture, vertex.stipple_position);
  if (stipple_colour.x == .0)
    discard;
  fragment_colour = vertex.colour;
}

/* *********************************************************************************************** *
 *
 * End
 *
 * *********************************************************************************************** */
