! ***********************************************************************
! dataSpec_P5B.f90 - (october, 20th 2009)
! ***********************************************************************

! **********************************************************************
! these modules contain the spectral domain of PROSPECT & SAIL (lambda)
! (nw wavelengths with 1 nm spectral resolution),
! and the spectral coefficients for leaf, canopy, atmsphere and soil:
! [1] = refractive index of leaf material
! [2] = specific absorption coefficient of chlorophyll (a+b) (cm2.microg-1)
! [3] = specific absorption coefficient of carotenoids (cm2.microg-1)
! [4] = specific absorption coefficient of brown pigments (arbitrary units)
! [5] = specific absorption coefficient of water (cm-1)
! [6] = specific absorption coefficient of dry matter (cm2.g-1)
! [7] = fraction of direct light
! [8] = fraction of diffuse light
! [9] = reflectance of a dry soil
! [10] = reflectance of a wet soil
! Fret et al. (2008), PROSPECT-4 and 5: Advances in the Leaf Optical
! Properties Model Separating Photosynthetic Pigments, Remote Sensing of
! Environment
! The specific absorption coefficient corresponding to brown pigment is
! provided by Frederic Baret (EMMAH, INRA Avignon, baret@avignon.inra.fr)
! and used with his autorization.

! **********************************************************************
! **********************************************************************

MODULE MOD_dataSpec_P5B
	IMPLICIT NONE

INTEGER,PARAMETER :: nw=2101
INTEGER*4 :: lambda(nw)
REAL*8 :: refractive(nw),k_Cab(nw),k_Car(nw),k_Brown(nw),k_Cw(nw),k_Cm(nw)
REAL*8 :: Es(nw),Ed(nw),Rsoil1(nw),Rsoil2(nw)
INTEGER*4 i

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!							wavelength								!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (lambda(i),i=1,100)/&
	400.,401.,402.,403.,404.,405.,406.,407.,408.,409.,&
	410.,411.,412.,413.,414.,415.,416.,417.,418.,419.,&
	420.,421.,422.,423.,424.,425.,426.,427.,428.,429.,&
	430.,431.,432.,433.,434.,435.,436.,437.,438.,439.,&
	440.,441.,442.,443.,444.,445.,446.,447.,448.,449.,&
	450.,451.,452.,453.,454.,455.,456.,457.,458.,459.,&
	460.,461.,462.,463.,464.,465.,466.,467.,468.,469.,&
	470.,471.,472.,473.,474.,475.,476.,477.,478.,479.,&
	480.,481.,482.,483.,484.,485.,486.,487.,488.,489.,&
	490.,491.,492.,493.,494.,495.,496.,497.,498.,499/

		DATA (lambda(i),i=101,200)/&
	500.,501.,502.,503.,504.,505.,506.,507.,508.,509.,&
	510.,511.,512.,513.,514.,515.,516.,517.,518.,519.,&
	520.,521.,522.,523.,524.,525.,526.,527.,528.,529.,&
	530.,531.,532.,533.,534.,535.,536.,537.,538.,539.,&
	540.,541.,542.,543.,544.,545.,546.,547.,548.,549.,&
	550.,551.,552.,553.,554.,555.,556.,557.,558.,559.,&
	560.,561.,562.,563.,564.,565.,566.,567.,568.,569.,&
	570.,571.,572.,573.,574.,575.,576.,577.,578.,579.,&
	580.,581.,582.,583.,584.,585.,586.,587.,588.,589.,&
	590.,591.,592.,593.,594.,595.,596.,597.,598.,599/

		DATA (lambda(i),i=201,300)/&
	600.,601.,602.,603.,604.,605.,606.,607.,608.,609.,&
	610.,611.,612.,613.,614.,615.,616.,617.,618.,619.,&
	620.,621.,622.,623.,624.,625.,626.,627.,628.,629.,&
	630.,631.,632.,633.,634.,635.,636.,637.,638.,639.,&
	640.,641.,642.,643.,644.,645.,646.,647.,648.,649.,&
	650.,651.,652.,653.,654.,655.,656.,657.,658.,659.,&
	660.,661.,662.,663.,664.,665.,666.,667.,668.,669.,&
	670.,671.,672.,673.,674.,675.,676.,677.,678.,679.,&
	680.,681.,682.,683.,684.,685.,686.,687.,688.,689.,&
	690.,691.,692.,693.,694.,695.,696.,697.,698.,699/

		DATA (lambda(i),i=301,400)/&
	700.,701.,702.,703.,704.,705.,706.,707.,708.,709.,&
	710.,711.,712.,713.,714.,715.,716.,717.,718.,719.,&
	720.,721.,722.,723.,724.,725.,726.,727.,728.,729.,&
	730.,731.,732.,733.,734.,735.,736.,737.,738.,739.,&
	740.,741.,742.,743.,744.,745.,746.,747.,748.,749.,&
	750.,751.,752.,753.,754.,755.,756.,757.,758.,759.,&
	760.,761.,762.,763.,764.,765.,766.,767.,768.,769.,&
	770.,771.,772.,773.,774.,775.,776.,777.,778.,779.,&
	780.,781.,782.,783.,784.,785.,786.,787.,788.,789.,&
	790.,791.,792.,793.,794.,795.,796.,797.,798.,799/

		DATA (lambda(i),i=401,500)/&
	800.,801.,802.,803.,804.,805.,806.,807.,808.,809.,&
	810.,811.,812.,813.,814.,815.,816.,817.,818.,819.,&
	820.,821.,822.,823.,824.,825.,826.,827.,828.,829.,&
	830.,831.,832.,833.,834.,835.,836.,837.,838.,839.,&
	840.,841.,842.,843.,844.,845.,846.,847.,848.,849.,&
	850.,851.,852.,853.,854.,855.,856.,857.,858.,859.,&
	860.,861.,862.,863.,864.,865.,866.,867.,868.,869.,&
	870.,871.,872.,873.,874.,875.,876.,877.,878.,879.,&
	880.,881.,882.,883.,884.,885.,886.,887.,888.,889.,&
	890.,891.,892.,893.,894.,895.,896.,897.,898.,899/

		DATA (lambda(i),i=501,600)/&
	900.,901.,902.,903.,904.,905.,906.,907.,908.,909.,&
	910.,911.,912.,913.,914.,915.,916.,917.,918.,919.,&
	920.,921.,922.,923.,924.,925.,926.,927.,928.,929.,&
	930.,931.,932.,933.,934.,935.,936.,937.,938.,939.,&
	940.,941.,942.,943.,944.,945.,946.,947.,948.,949.,&
	950.,951.,952.,953.,954.,955.,956.,957.,958.,959.,&
	960.,961.,962.,963.,964.,965.,966.,967.,968.,969.,&
	970.,971.,972.,973.,974.,975.,976.,977.,978.,979.,&
	980.,981.,982.,983.,984.,985.,986.,987.,988.,989.,&
	990.,991.,992.,993.,994.,995.,996.,997.,998.,999/

		DATA (lambda(i),i=601,700)/&
	1000.,1001.,1002.,1003.,1004.,1005.,1006.,1007.,1008.,1009.,&
	1010.,1011.,1012.,1013.,1014.,1015.,1016.,1017.,1018.,1019.,&
	1020.,1021.,1022.,1023.,1024.,1025.,1026.,1027.,1028.,1029.,&
	1030.,1031.,1032.,1033.,1034.,1035.,1036.,1037.,1038.,1039.,&
	1040.,1041.,1042.,1043.,1044.,1045.,1046.,1047.,1048.,1049.,&
	1050.,1051.,1052.,1053.,1054.,1055.,1056.,1057.,1058.,1059.,&
	1060.,1061.,1062.,1063.,1064.,1065.,1066.,1067.,1068.,1069.,&
	1070.,1071.,1072.,1073.,1074.,1075.,1076.,1077.,1078.,1079.,&
	1080.,1081.,1082.,1083.,1084.,1085.,1086.,1087.,1088.,1089.,&
	1090.,1091.,1092.,1093.,1094.,1095.,1096.,1097.,1098.,1099/

		DATA (lambda(i),i=701,800)/&
	1100.,1101.,1102.,1103.,1104.,1105.,1106.,1107.,1108.,1109.,&
	1110.,1111.,1112.,1113.,1114.,1115.,1116.,1117.,1118.,1119.,&
	1120.,1121.,1122.,1123.,1124.,1125.,1126.,1127.,1128.,1129.,&
	1130.,1131.,1132.,1133.,1134.,1135.,1136.,1137.,1138.,1139.,&
	1140.,1141.,1142.,1143.,1144.,1145.,1146.,1147.,1148.,1149.,&
	1150.,1151.,1152.,1153.,1154.,1155.,1156.,1157.,1158.,1159.,&
	1160.,1161.,1162.,1163.,1164.,1165.,1166.,1167.,1168.,1169.,&
	1170.,1171.,1172.,1173.,1174.,1175.,1176.,1177.,1178.,1179.,&
	1180.,1181.,1182.,1183.,1184.,1185.,1186.,1187.,1188.,1189.,&
	1190.,1191.,1192.,1193.,1194.,1195.,1196.,1197.,1198.,1199/

		DATA (lambda(i),i=801,900)/&
	1200.,1201.,1202.,1203.,1204.,1205.,1206.,1207.,1208.,1209.,&
	1210.,1211.,1212.,1213.,1214.,1215.,1216.,1217.,1218.,1219.,&
	1220.,1221.,1222.,1223.,1224.,1225.,1226.,1227.,1228.,1229.,&
	1230.,1231.,1232.,1233.,1234.,1235.,1236.,1237.,1238.,1239.,&
	1240.,1241.,1242.,1243.,1244.,1245.,1246.,1247.,1248.,1249.,&
	1250.,1251.,1252.,1253.,1254.,1255.,1256.,1257.,1258.,1259.,&
	1260.,1261.,1262.,1263.,1264.,1265.,1266.,1267.,1268.,1269.,&
	1270.,1271.,1272.,1273.,1274.,1275.,1276.,1277.,1278.,1279.,&
	1280.,1281.,1282.,1283.,1284.,1285.,1286.,1287.,1288.,1289.,&
	1290.,1291.,1292.,1293.,1294.,1295.,1296.,1297.,1298.,1299/

		DATA (lambda(i),i=901,1000)/&
	1300.,1301.,1302.,1303.,1304.,1305.,1306.,1307.,1308.,1309.,&
	1310.,1311.,1312.,1313.,1314.,1315.,1316.,1317.,1318.,1319.,&
	1320.,1321.,1322.,1323.,1324.,1325.,1326.,1327.,1328.,1329.,&
	1330.,1331.,1332.,1333.,1334.,1335.,1336.,1337.,1338.,1339.,&
	1340.,1341.,1342.,1343.,1344.,1345.,1346.,1347.,1348.,1349.,&
	1350.,1351.,1352.,1353.,1354.,1355.,1356.,1357.,1358.,1359.,&
	1360.,1361.,1362.,1363.,1364.,1365.,1366.,1367.,1368.,1369.,&
	1370.,1371.,1372.,1373.,1374.,1375.,1376.,1377.,1378.,1379.,&
	1380.,1381.,1382.,1383.,1384.,1385.,1386.,1387.,1388.,1389.,&
	1390.,1391.,1392.,1393.,1394.,1395.,1396.,1397.,1398.,1399/

		DATA (lambda(i),i=1001,1100)/&
	1400.,1401.,1402.,1403.,1404.,1405.,1406.,1407.,1408.,1409.,&
	1410.,1411.,1412.,1413.,1414.,1415.,1416.,1417.,1418.,1419.,&
	1420.,1421.,1422.,1423.,1424.,1425.,1426.,1427.,1428.,1429.,&
	1430.,1431.,1432.,1433.,1434.,1435.,1436.,1437.,1438.,1439.,&
	1440.,1441.,1442.,1443.,1444.,1445.,1446.,1447.,1448.,1449.,&
	1450.,1451.,1452.,1453.,1454.,1455.,1456.,1457.,1458.,1459.,&
	1460.,1461.,1462.,1463.,1464.,1465.,1466.,1467.,1468.,1469.,&
	1470.,1471.,1472.,1473.,1474.,1475.,1476.,1477.,1478.,1479.,&
	1480.,1481.,1482.,1483.,1484.,1485.,1486.,1487.,1488.,1489.,&
	1490.,1491.,1492.,1493.,1494.,1495.,1496.,1497.,1498.,1499/

		DATA (lambda(i),i=1101,1200)/&
	1500.,1501.,1502.,1503.,1504.,1505.,1506.,1507.,1508.,1509.,&
	1510.,1511.,1512.,1513.,1514.,1515.,1516.,1517.,1518.,1519.,&
	1520.,1521.,1522.,1523.,1524.,1525.,1526.,1527.,1528.,1529.,&
	1530.,1531.,1532.,1533.,1534.,1535.,1536.,1537.,1538.,1539.,&
	1540.,1541.,1542.,1543.,1544.,1545.,1546.,1547.,1548.,1549.,&
	1550.,1551.,1552.,1553.,1554.,1555.,1556.,1557.,1558.,1559.,&
	1560.,1561.,1562.,1563.,1564.,1565.,1566.,1567.,1568.,1569.,&
	1570.,1571.,1572.,1573.,1574.,1575.,1576.,1577.,1578.,1579.,&
	1580.,1581.,1582.,1583.,1584.,1585.,1586.,1587.,1588.,1589.,&
	1590.,1591.,1592.,1593.,1594.,1595.,1596.,1597.,1598.,1599/

		DATA (lambda(i),i=1201,1300)/&
	1600.,1601.,1602.,1603.,1604.,1605.,1606.,1607.,1608.,1609.,&
	1610.,1611.,1612.,1613.,1614.,1615.,1616.,1617.,1618.,1619.,&
	1620.,1621.,1622.,1623.,1624.,1625.,1626.,1627.,1628.,1629.,&
	1630.,1631.,1632.,1633.,1634.,1635.,1636.,1637.,1638.,1639.,&
	1640.,1641.,1642.,1643.,1644.,1645.,1646.,1647.,1648.,1649.,&
	1650.,1651.,1652.,1653.,1654.,1655.,1656.,1657.,1658.,1659.,&
	1660.,1661.,1662.,1663.,1664.,1665.,1666.,1667.,1668.,1669.,&
	1670.,1671.,1672.,1673.,1674.,1675.,1676.,1677.,1678.,1679.,&
	1680.,1681.,1682.,1683.,1684.,1685.,1686.,1687.,1688.,1689.,&
	1690.,1691.,1692.,1693.,1694.,1695.,1696.,1697.,1698.,1699/

		DATA (lambda(i),i=1301,1400)/&
	1700.,1701.,1702.,1703.,1704.,1705.,1706.,1707.,1708.,1709.,&
	1710.,1711.,1712.,1713.,1714.,1715.,1716.,1717.,1718.,1719.,&
	1720.,1721.,1722.,1723.,1724.,1725.,1726.,1727.,1728.,1729.,&
	1730.,1731.,1732.,1733.,1734.,1735.,1736.,1737.,1738.,1739.,&
	1740.,1741.,1742.,1743.,1744.,1745.,1746.,1747.,1748.,1749.,&
	1750.,1751.,1752.,1753.,1754.,1755.,1756.,1757.,1758.,1759.,&
	1760.,1761.,1762.,1763.,1764.,1765.,1766.,1767.,1768.,1769.,&
	1770.,1771.,1772.,1773.,1774.,1775.,1776.,1777.,1778.,1779.,&
	1780.,1781.,1782.,1783.,1784.,1785.,1786.,1787.,1788.,1789.,&
	1790.,1791.,1792.,1793.,1794.,1795.,1796.,1797.,1798.,1799/

		DATA (lambda(i),i=1401,1500)/&
	1800.,1801.,1802.,1803.,1804.,1805.,1806.,1807.,1808.,1809.,&
	1810.,1811.,1812.,1813.,1814.,1815.,1816.,1817.,1818.,1819.,&
	1820.,1821.,1822.,1823.,1824.,1825.,1826.,1827.,1828.,1829.,&
	1830.,1831.,1832.,1833.,1834.,1835.,1836.,1837.,1838.,1839.,&
	1840.,1841.,1842.,1843.,1844.,1845.,1846.,1847.,1848.,1849.,&
	1850.,1851.,1852.,1853.,1854.,1855.,1856.,1857.,1858.,1859.,&
	1860.,1861.,1862.,1863.,1864.,1865.,1866.,1867.,1868.,1869.,&
	1870.,1871.,1872.,1873.,1874.,1875.,1876.,1877.,1878.,1879.,&
	1880.,1881.,1882.,1883.,1884.,1885.,1886.,1887.,1888.,1889.,&
	1890.,1891.,1892.,1893.,1894.,1895.,1896.,1897.,1898.,1899/

		DATA (lambda(i),i=1501,1600)/&
	1900.,1901.,1902.,1903.,1904.,1905.,1906.,1907.,1908.,1909.,&
	1910.,1911.,1912.,1913.,1914.,1915.,1916.,1917.,1918.,1919.,&
	1920.,1921.,1922.,1923.,1924.,1925.,1926.,1927.,1928.,1929.,&
	1930.,1931.,1932.,1933.,1934.,1935.,1936.,1937.,1938.,1939.,&
	1940.,1941.,1942.,1943.,1944.,1945.,1946.,1947.,1948.,1949.,&
	1950.,1951.,1952.,1953.,1954.,1955.,1956.,1957.,1958.,1959.,&
	1960.,1961.,1962.,1963.,1964.,1965.,1966.,1967.,1968.,1969.,&
	1970.,1971.,1972.,1973.,1974.,1975.,1976.,1977.,1978.,1979.,&
	1980.,1981.,1982.,1983.,1984.,1985.,1986.,1987.,1988.,1989.,&
	1990.,1991.,1992.,1993.,1994.,1995.,1996.,1997.,1998.,1999/

		DATA (lambda(i),i=1601,1700)/&
	2000.,2001.,2002.,2003.,2004.,2005.,2006.,2007.,2008.,2009.,&
	2010.,2011.,2012.,2013.,2014.,2015.,2016.,2017.,2018.,2019.,&
	2020.,2021.,2022.,2023.,2024.,2025.,2026.,2027.,2028.,2029.,&
	2030.,2031.,2032.,2033.,2034.,2035.,2036.,2037.,2038.,2039.,&
	2040.,2041.,2042.,2043.,2044.,2045.,2046.,2047.,2048.,2049.,&
	2050.,2051.,2052.,2053.,2054.,2055.,2056.,2057.,2058.,2059.,&
	2060.,2061.,2062.,2063.,2064.,2065.,2066.,2067.,2068.,2069.,&
	2070.,2071.,2072.,2073.,2074.,2075.,2076.,2077.,2078.,2079.,&
	2080.,2081.,2082.,2083.,2084.,2085.,2086.,2087.,2088.,2089.,&
	2090.,2091.,2092.,2093.,2094.,2095.,2096.,2097.,2098.,2099/

		DATA (lambda(i),i=1701,1800)/&
	2100.,2101.,2102.,2103.,2104.,2105.,2106.,2107.,2108.,2109.,&
	2110.,2111.,2112.,2113.,2114.,2115.,2116.,2117.,2118.,2119.,&
	2120.,2121.,2122.,2123.,2124.,2125.,2126.,2127.,2128.,2129.,&
	2130.,2131.,2132.,2133.,2134.,2135.,2136.,2137.,2138.,2139.,&
	2140.,2141.,2142.,2143.,2144.,2145.,2146.,2147.,2148.,2149.,&
	2150.,2151.,2152.,2153.,2154.,2155.,2156.,2157.,2158.,2159.,&
	2160.,2161.,2162.,2163.,2164.,2165.,2166.,2167.,2168.,2169.,&
	2170.,2171.,2172.,2173.,2174.,2175.,2176.,2177.,2178.,2179.,&
	2180.,2181.,2182.,2183.,2184.,2185.,2186.,2187.,2188.,2189.,&
	2190.,2191.,2192.,2193.,2194.,2195.,2196.,2197.,2198.,2199/

		DATA (lambda(i),i=1801,1900)/&
	2200.,2201.,2202.,2203.,2204.,2205.,2206.,2207.,2208.,2209.,&
	2210.,2211.,2212.,2213.,2214.,2215.,2216.,2217.,2218.,2219.,&
	2220.,2221.,2222.,2223.,2224.,2225.,2226.,2227.,2228.,2229.,&
	2230.,2231.,2232.,2233.,2234.,2235.,2236.,2237.,2238.,2239.,&
	2240.,2241.,2242.,2243.,2244.,2245.,2246.,2247.,2248.,2249.,&
	2250.,2251.,2252.,2253.,2254.,2255.,2256.,2257.,2258.,2259.,&
	2260.,2261.,2262.,2263.,2264.,2265.,2266.,2267.,2268.,2269.,&
	2270.,2271.,2272.,2273.,2274.,2275.,2276.,2277.,2278.,2279.,&
	2280.,2281.,2282.,2283.,2284.,2285.,2286.,2287.,2288.,2289.,&
	2290.,2291.,2292.,2293.,2294.,2295.,2296.,2297.,2298.,2299/

		DATA (lambda(i),i=1901,2000)/&
	2300.,2301.,2302.,2303.,2304.,2305.,2306.,2307.,2308.,2309.,&
	2310.,2311.,2312.,2313.,2314.,2315.,2316.,2317.,2318.,2319.,&
	2320.,2321.,2322.,2323.,2324.,2325.,2326.,2327.,2328.,2329.,&
	2330.,2331.,2332.,2333.,2334.,2335.,2336.,2337.,2338.,2339.,&
	2340.,2341.,2342.,2343.,2344.,2345.,2346.,2347.,2348.,2349.,&
	2350.,2351.,2352.,2353.,2354.,2355.,2356.,2357.,2358.,2359.,&
	2360.,2361.,2362.,2363.,2364.,2365.,2366.,2367.,2368.,2369.,&
	2370.,2371.,2372.,2373.,2374.,2375.,2376.,2377.,2378.,2379.,&
	2380.,2381.,2382.,2383.,2384.,2385.,2386.,2387.,2388.,2389.,&
	2390.,2391.,2392.,2393.,2394.,2395.,2396.,2397.,2398.,2399/

		DATA (lambda(i),i=2001,2101)/&
	2400.,2401.,2402.,2403.,2404.,2405.,2406.,2407.,2408.,2409.,&
	2410.,2411.,2412.,2413.,2414.,2415.,2416.,2417.,2418.,2419.,&
	2420.,2421.,2422.,2423.,2424.,2425.,2426.,2427.,2428.,2429.,&
	2430.,2431.,2432.,2433.,2434.,2435.,2436.,2437.,2438.,2439.,&
	2440.,2441.,2442.,2443.,2444.,2445.,2446.,2447.,2448.,2449.,&
	2450.,2451.,2452.,2453.,2454.,2455.,2456.,2457.,2458.,2459.,&
	2460.,2461.,2462.,2463.,2464.,2465.,2466.,2467.,2468.,2469.,&
	2470.,2471.,2472.,2473.,2474.,2475.,2476.,2477.,2478.,2479.,&
	2480.,2481.,2482.,2483.,2484.,2485.,2486.,2487.,2488.,2489.,&
	2490.,2491.,2492.,2493.,2494.,2495.,2496.,2497.,2498.,2499.,&
	2500./

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!						Refractive index							!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (refractive(i),i=1,100)/&
	1.4955,1.4958,1.4960,1.4964,1.4971,1.4978,1.4986,1.4995,1.5006,1.5016,&
	1.5024,1.5031,1.5041,1.5052,1.5065,1.5076,1.5088,1.5099,1.5110,1.5122,&
	1.5134,1.5144,1.5156,1.5168,1.5181,1.5195,1.5206,1.5212,1.5219,1.5228,&
	1.5235,1.5241,1.5249,1.5256,1.5262,1.5267,1.5272,1.5276,1.5279,1.5282,&
	1.5286,1.5290,1.5292,1.5294,1.5294,1.5295,1.5293,1.5291,1.5289,1.5286,&
	1.5282,1.5278,1.5273,1.5268,1.5262,1.5256,1.5249,1.5243,1.5237,1.5230,&
	1.5224,1.5217,1.5210,1.5203,1.5196,1.5189,1.5184,1.5178,1.5173,1.5170,&
	1.5166,1.5163,1.5159,1.5156,1.5153,1.5150,1.5148,1.5145,1.5142,1.5139,&
	1.5135,1.5131,1.5125,1.5119,1.5111,1.5103,1.5092,1.5080,1.5067,1.5051,&
	1.5034,1.5015,1.4994,1.4971,1.4947,1.4921,1.4894,1.4866,1.4837,1.4807/

		DATA (refractive(i),i=101,200)/&
	1.4776,1.4744,1.4712,1.4680,1.4647,1.4615,1.4583,1.4553,1.4523,1.4495,&
	1.4468,1.4443,1.4419,1.4397,1.4377,1.4360,1.4344,1.4331,1.4319,1.4310,&
	1.4302,1.4296,1.4291,1.4288,1.4286,1.4286,1.4286,1.4287,1.4288,1.4290,&
	1.4292,1.4294,1.4296,1.4298,1.4300,1.4302,1.4303,1.4305,1.4306,1.4307,&
	1.4308,1.4309,1.4309,1.4310,1.4310,1.4310,1.4309,1.4308,1.4307,1.4305,&
	1.4303,1.4301,1.4298,1.4294,1.4290,1.4285,1.4280,1.4274,1.4268,1.4262,&
	1.4255,1.4248,1.4241,1.4234,1.4227,1.4220,1.4213,1.4206,1.4199,1.4192,&
	1.4185,1.4179,1.4173,1.4167,1.4161,1.4156,1.4151,1.4146,1.4141,1.4137,&
	1.4133,1.4129,1.4126,1.4123,1.4120,1.4117,1.4114,1.4112,1.4109,1.4107,&
	1.4105,1.4103,1.4101,1.4099,1.4097,1.4095,1.4093,1.4091,1.4089,1.4087/
	
		DATA (refractive(i),i=201,300)/&
	1.4086,1.4084,1.4082,1.4081,1.4079,1.4078,1.4077,1.4076,1.4075,1.4075,&
	1.4075,1.4075,1.4075,1.4076,1.4077,1.4077,1.4078,1.4079,1.4080,1.4081,&
	1.4082,1.4083,1.4083,1.4083,1.4083,1.4082,1.4082,1.4081,1.4079,1.4078,&
	1.4077,1.4076,1.4076,1.4076,1.4078,1.4080,1.4083,1.4087,1.4093,1.4100,&
	1.4108,1.4118,1.4128,1.4140,1.4153,1.4166,1.4179,1.4193,1.4206,1.4218,&
	1.4229,1.4240,1.4250,1.4261,1.4272,1.4284,1.4298,1.4315,1.4335,1.4357,&
	1.4383,1.4411,1.4442,1.4475,1.4509,1.4544,1.4579,1.4614,1.4649,1.4682,&
	1.4714,1.4744,1.4773,1.4802,1.4830,1.4857,1.4884,1.4909,1.4932,1.4951,&
	1.4963,1.4967,1.4958,1.4936,1.4899,1.4847,1.4780,1.4702,1.4618,1.4530,&
	1.4445,1.4366,1.4296,1.4237,1.4190,1.4154,1.4129,1.4112,1.4104,1.4102/

		DATA (refractive(i),i=301,400)/&
	1.4106,1.4113,1.4124,1.4137,1.4152,1.4168,1.4186,1.4204,1.4222,1.4242,&
	1.4261,1.4281,1.4301,1.4321,1.4341,1.4361,1.4382,1.4402,1.4422,1.4442,&
	1.4462,1.4481,1.4500,1.4518,1.4536,1.4554,1.4571,1.4587,1.4603,1.4618,&
	1.4632,1.4646,1.4659,1.4671,1.4683,1.4694,1.4704,1.4713,1.4721,1.4729,&
	1.4736,1.4742,1.4747,1.4752,1.4756,1.4759,1.4762,1.4764,1.4765,1.4766,&
	1.4766,1.4767,1.4767,1.4767,1.4767,1.4766,1.4766,1.4765,1.4764,1.4763,&
	1.4762,1.4761,1.4759,1.4758,1.4756,1.4754,1.4752,1.4751,1.4748,1.4746,&
	1.4744,1.4742,1.4739,1.4737,1.4734,1.4732,1.4729,1.4727,1.4725,1.4722,&
	1.4720,1.4718,1.4716,1.4714,1.4712,1.4710,1.4708,1.4706,1.4703,1.4701,&
	1.4700,1.4698,1.4696,1.4694,1.4692,1.4690,1.4688,1.4686,1.4684,1.4682/

		DATA (refractive(i),i=401,500)/&
	1.4681,1.4679,1.4677,1.4675,1.4674,1.4672,1.4670,1.4668,1.4666,1.4665,&
	1.4663,1.4662,1.4660,1.4659,1.4657,1.4655,1.4654,1.4652,1.4651,1.4649,&
	1.4648,1.4646,1.4645,1.4643,1.4641,1.4639,1.4638,1.4636,1.4635,1.4633,&
	1.4631,1.4630,1.4628,1.4627,1.4626,1.4625,1.4623,1.4622,1.4620,1.4619,&
	1.4617,1.4616,1.4614,1.4613,1.4611,1.4610,1.4608,1.4607,1.4605,1.4604,&
	1.4602,1.4601,1.4600,1.4599,1.4597,1.4596,1.4595,1.4594,1.4592,1.4591,&
	1.4589,1.4587,1.4586,1.4584,1.4583,1.4582,1.4582,1.4581,1.4580,1.4579,&
	1.4577,1.4576,1.4574,1.4572,1.4571,1.4569,1.4568,1.4566,1.4565,1.4563,&
	1.4562,1.4560,1.4559,1.4558,1.4556,1.4554,1.4553,1.4551,1.4550,1.4548,&
	1.4547,1.4545,1.4544,1.4542,1.4541,1.4539,1.4538,1.4536,1.4535,1.4533/

		DATA (refractive(i),i=501,600)/&
	1.4532,1.4531,1.4529,1.4528,1.4526,1.4525,1.4524,1.4522,1.4521,1.4519,&
	1.4518,1.4516,1.4515,1.4513,1.4512,1.4511,1.4509,1.4508,1.4506,1.4505,&
	1.4503,1.4502,1.4500,1.4498,1.4497,1.4495,1.4493,1.4492,1.4491,1.4489,&
	1.4488,1.4487,1.4485,1.4483,1.4481,1.4479,1.4478,1.4477,1.4476,1.4474,&
	1.4472,1.4469,1.4466,1.4465,1.4463,1.4462,1.4461,1.4461,1.4461,1.4460,&
	1.4457,1.4455,1.4453,1.4451,1.4450,1.4449,1.4448,1.4447,1.4445,1.4445,&
	1.4445,1.4442,1.4440,1.4438,1.4437,1.4436,1.4436,1.4435,1.4434,1.4434,&
	1.4434,1.4434,1.4432,1.4430,1.4428,1.4427,1.4426,1.4425,1.4423,1.4421,&
	1.4420,1.4418,1.4416,1.4415,1.4414,1.4414,1.4414,1.4415,1.4416,1.4416,&
	1.4415,1.4414,1.4413,1.4411,1.4409,1.4407,1.4405,1.4403,1.4401,1.4400/

		DATA (refractive(i),i=601,700)/&
	1.4399,1.4397,1.4395,1.4394,1.4393,1.4392,1.4392,1.4391,1.4391,1.4390,&
	1.4389,1.4387,1.4386,1.4385,1.4384,1.4384,1.4383,1.4381,1.4379,1.4378,&
	1.4376,1.4374,1.4372,1.4371,1.4370,1.4369,1.4368,1.4367,1.4365,1.4365,&
	1.4364,1.4364,1.4363,1.4363,1.4363,1.4363,1.4363,1.4362,1.4361,1.4360,&
	1.4359,1.4357,1.4356,1.4354,1.4352,1.4351,1.4351,1.4350,1.4349,1.4349,&
	1.4348,1.4347,1.4345,1.4343,1.4342,1.4342,1.4342,1.4341,1.4340,1.4339,&
	1.4338,1.4337,1.4335,1.4334,1.4333,1.4333,1.4334,1.4333,1.4333,1.4332,&
	1.4330,1.4329,1.4328,1.4327,1.4325,1.4324,1.4322,1.4321,1.4319,1.4318,&
	1.4317,1.4316,1.4315,1.4314,1.4314,1.4313,1.4312,1.4310,1.4309,1.4307,&
	1.4305,1.4304,1.4303,1.4302,1.4302,1.4301,1.4300,1.4297,1.4295,1.4294/

		DATA (refractive(i),i=701,800)/&
	1.4293,1.4292,1.4291,1.4290,1.4289,1.4288,1.4286,1.4284,1.4283,1.4283,&
	1.4284,1.4284,1.4284,1.4284,1.4283,1.4282,1.4282,1.4280,1.4278,1.4276,&
	1.4275,1.4274,1.4272,1.4270,1.4268,1.4267,1.4267,1.4266,1.4265,1.4264,&
	1.4263,1.4262,1.4260,1.4259,1.4258,1.4257,1.4256,1.4256,1.4255,1.4254,&
	1.4252,1.4250,1.4249,1.4248,1.4247,1.4244,1.4241,1.4239,1.4237,1.4235,&
	1.4234,1.4233,1.4231,1.4230,1.4228,1.4226,1.4224,1.4224,1.4223,1.4223,&
	1.4222,1.4222,1.4221,1.4221,1.4221,1.4219,1.4217,1.4216,1.4215,1.4215,&
	1.4214,1.4212,1.4210,1.4208,1.4207,1.4206,1.4206,1.4206,1.4206,1.4206,&
	1.4205,1.4203,1.4200,1.4199,1.4198,1.4199,1.4201,1.4204,1.4205,1.4205,&
	1.4203,1.4200,1.4196,1.4192,1.4189,1.4187,1.4187,1.4188,1.4188,1.4187/

		DATA (refractive(i),i=801,900)/&
	1.4186,1.4185,1.4182,1.4181,1.4179,1.4178,1.4177,1.4177,1.4176,1.4175,&
	1.4173,1.4173,1.4172,1.4171,1.4170,1.4168,1.4167,1.4165,1.4164,1.4163,&
	1.4161,1.4158,1.4156,1.4155,1.4154,1.4153,1.4151,1.4151,1.4151,1.4150,&
	1.4148,1.4147,1.4146,1.4145,1.4144,1.4143,1.4141,1.4139,1.4136,1.4134,&
	1.4133,1.4130,1.4128,1.4128,1.4128,1.4127,1.4126,1.4124,1.4122,1.4122,&
	1.4121,1.4121,1.4121,1.4119,1.4118,1.4116,1.4115,1.4113,1.4112,1.4112,&
	1.4111,1.4111,1.4110,1.4108,1.4106,1.4104,1.4102,1.4102,1.4102,1.4103,&
	1.4103,1.4101,1.4099,1.4097,1.4095,1.4093,1.4091,1.4091,1.4091,1.4090,&
	1.4089,1.4088,1.4085,1.4083,1.4081,1.4080,1.4079,1.4078,1.4077,1.4078,&
	1.4078,1.4078,1.4077,1.4076,1.4075,1.4073,1.4070,1.4068,1.4066,1.4064/

		DATA (refractive(i),i=901,1000)/&
	1.4064,1.4062,1.4061,1.4059,1.4056,1.4055,1.4055,1.4055,1.4055,1.4056,&
	1.4057,1.4058,1.4058,1.4056,1.4055,1.4053,1.4051,1.4050,1.4049,1.4048,&
	1.4046,1.4045,1.4044,1.4044,1.4044,1.4045,1.4045,1.4043,1.4042,1.4040,&
	1.4040,1.4041,1.4041,1.4040,1.4036,1.4034,1.4032,1.4031,1.4030,1.4031,&
	1.4033,1.4033,1.4033,1.4031,1.4028,1.4023,1.4017,1.4013,1.4010,1.4010,&
	1.4008,1.4007,1.4004,1.4002,1.4000,1.4002,1.4004,1.4009,1.4011,1.4015,&
	1.4016,1.4015,1.4010,1.4002,1.3996,1.3992,1.3989,1.3992,1.3994,1.3997,&
	1.4000,1.4000,1.4000,1.4003,1.4002,1.3999,1.4002,1.4004,1.4008,1.4009,&
	1.4019,1.4015,1.4010,1.4000,1.4001,1.3988,1.3978,1.3971,1.3960,1.3967,&
	1.3958,1.3955,1.3952,1.3953,1.3945,1.3960,1.3961,1.3950,1.3946,1.3942/

		DATA (refractive(i),i=1001,1100)/&
	1.3938,1.3935,1.3926,1.3926,1.3930,1.3943,1.3943,1.3944,1.3944,1.3937,&
	1.3933,1.3934,1.3934,1.3935,1.3933,1.3931,1.3928,1.3925,1.3920,1.3918,&
	1.3915,1.3910,1.3904,1.3898,1.3892,1.3880,1.3872,1.3865,1.3858,1.3852,&
	1.3843,1.3838,1.3829,1.3823,1.3810,1.3801,1.3794,1.3785,1.3776,1.3771,&
	1.3765,1.3758,1.3751,1.3743,1.3733,1.3725,1.3717,1.3711,1.3707,1.3703,&
	1.3700,1.3700,1.3697,1.3692,1.3685,1.3680,1.3675,1.3670,1.3667,1.3662,&
	1.3657,1.3659,1.3658,1.3656,1.3656,1.3654,1.3650,1.3653,1.3651,1.3649,&
	1.3650,1.3646,1.3641,1.3644,1.3640,1.3644,1.3643,1.3644,1.3647,1.3646,&
	1.3649,1.3644,1.3641,1.3635,1.3635,1.3633,1.3631,1.3635,1.3635,1.3643,&
	1.3642,1.3646,1.3643,1.3642,1.3637,1.3640,1.3638,1.3640,1.3640,1.3640/

		DATA (refractive(i),i=1101,1200)/&
	1.3646,1.3645,1.3650,1.3650,1.3652,1.3657,1.3656,1.3660,1.3657,1.3661,&
	1.3665,1.3667,1.3670,1.3666,1.3669,1.3673,1.3673,1.3680,1.3686,1.3686,&
	1.3689,1.3693,1.3690,1.3694,1.3697,1.3695,1.3697,1.3698,1.3696,1.3698,&
	1.3700,1.3706,1.3705,1.3709,1.3712,1.3717,1.3718,1.3721,1.3721,1.3724,&
	1.3723,1.3721,1.3723,1.3723,1.3725,1.3723,1.3723,1.3727,1.3729,1.3730,&
	1.3730,1.3730,1.3731,1.3734,1.3734,1.3736,1.3737,1.3738,1.3735,1.3735,&
	1.3734,1.3735,1.3736,1.3738,1.3737,1.3738,1.3736,1.3737,1.3735,1.3735,&
	1.3735,1.3734,1.3734,1.3734,1.3735,1.3732,1.3733,1.3732,1.3732,1.3735,&
	1.3736,1.3739,1.3742,1.3741,1.3738,1.3737,1.3737,1.3736,1.3735,1.3737,&
	1.3738,1.3741,1.3743,1.3744,1.3744,1.3743,1.3740,1.3740,1.3741,1.3741/

		DATA (refractive(i),i=1201,1300)/&
	1.3742,1.3742,1.3741,1.3743,1.3743,1.3743,1.3742,1.3741,1.3740,1.3740,&
	1.3738,1.3736,1.3734,1.3733,1.3731,1.3730,1.3730,1.3731,1.3730,1.3732,&
	1.3731,1.3730,1.3729,1.3728,1.3727,1.3726,1.3725,1.3726,1.3725,1.3726,&
	1.3726,1.3724,1.3719,1.3718,1.3716,1.3715,1.3712,1.3713,1.3711,1.3710,&
	1.3707,1.3708,1.3707,1.3708,1.3708,1.3710,1.3712,1.3715,1.3715,1.3716,&
	1.3714,1.3714,1.3712,1.3713,1.3709,1.3708,1.3704,1.3704,1.3700,1.3698,&
	1.3695,1.3694,1.3692,1.3690,1.3687,1.3687,1.3684,1.3685,1.3684,1.3683,&
	1.3683,1.3687,1.3681,1.3678,1.3674,1.3670,1.3665,1.3665,1.3664,1.3663,&
	1.3659,1.3659,1.3656,1.3655,1.3654,1.3655,1.3654,1.3654,1.3651,1.3651,&
	1.3648,1.3648,1.3647,1.3648,1.3647,1.3647,1.3646,1.3647,1.3646,1.3644/

		DATA (refractive(i),i=1301,1400)/&
	1.3640,1.3638,1.3635,1.3634,1.3632,1.3631,1.3628,1.3629,1.3627,1.3629,&
	1.3629,1.3627,1.3625,1.3625,1.3623,1.3622,1.3619,1.3620,1.3619,1.3619,&
	1.3616,1.3615,1.3612,1.3611,1.3611,1.3612,1.3613,1.3617,1.3617,1.3618,&
	1.3618,1.3617,1.3615,1.3616,1.3615,1.3616,1.3618,1.3617,1.3616,1.3616,&
	1.3613,1.3612,1.3612,1.3616,1.3616,1.3617,1.3618,1.3621,1.3623,1.3625,&
	1.3626,1.3626,1.3625,1.3627,1.3633,1.3637,1.3637,1.3636,1.3635,1.3633,&
	1.3630,1.3629,1.3632,1.3636,1.3641,1.3646,1.3651,1.3653,1.3648,1.3640,&
	1.3630,1.3620,1.3615,1.3608,1.3608,1.3611,1.3617,1.3628,1.3638,1.3645,&
	1.3649,1.3646,1.3637,1.3625,1.3613,1.3601,1.3595,1.3593,1.3599,1.3607,&
	1.3614,1.3623,1.3627,1.3627,1.3624,1.3622,1.3619,1.3616,1.3616,1.3617/

		DATA (refractive(i),i=1401,1500)/&
	1.3619,1.3621,1.3622,1.3626,1.3630,1.3635,1.3637,1.3639,1.3636,1.3632,&
	1.3629,1.3625,1.3623,1.3625,1.3628,1.3634,1.3638,1.3645,1.3649,1.3652,&
	1.3652,1.3650,1.3645,1.3642,1.3639,1.3638,1.3636,1.3634,1.3631,1.3632,&
	1.3631,1.3630,1.3624,1.3623,1.3623,1.3623,1.3626,1.3629,1.3629,1.3630,&
	1.3628,1.3622,1.3615,1.3607,1.3601,1.3597,1.3597,1.3599,1.3597,1.3597,&
	1.3595,1.3599,1.3593,1.3597,1.3602,1.3613,1.3625,1.3633,1.3638,1.3645,&
	1.3643,1.3648,1.3629,1.3632,1.3635,1.3645,1.3647,1.3662,1.3668,1.3684,&
	1.3653,1.3658,1.3663,1.3663,1.3671,1.3668,1.3680,1.3626,1.3620,1.3624,&
	1.3627,1.3617,1.3628,1.3562,1.3557,1.3558,1.3559,1.3555,1.3508,1.3504,&
	1.3511,1.3520,1.3525,1.3493,1.3503,1.3524,1.3546,1.3578,1.3556,1.3583/

		DATA (refractive(i),i=1501,1600)/&
	1.3601,1.3610,1.3595,1.3599,1.3606,1.3611,1.3598,1.3600,1.3601,1.3606,&
	1.3599,1.3600,1.3603,1.3608,1.3606,1.3613,1.3615,1.3614,1.3606,1.3600,&
	1.3591,1.3582,1.3573,1.3564,1.3556,1.3547,1.3538,1.3530,1.3522,1.3513,&
	1.3505,1.3497,1.3489,1.3481,1.3473,1.3465,1.3457,1.3450,1.3442,1.3434,&
	1.3427,1.3420,1.3412,1.3405,1.3398,1.3391,1.3384,1.3377,1.3371,1.3364,&
	1.3357,1.3351,1.3344,1.3338,1.3332,1.3326,1.3320,1.3314,1.3308,1.3302,&
	1.3297,1.3291,1.3286,1.3280,1.3275,1.3270,1.3265,1.3260,1.3255,1.3251,&
	1.3246,1.3242,1.3237,1.3233,1.3229,1.3225,1.3221,1.3217,1.3213,1.3209,&
	1.3206,1.3203,1.3199,1.3196,1.3193,1.3190,1.3187,1.3185,1.3182,1.3180,&
	1.3177,1.3175,1.3173,1.3171,1.3169,1.3168,1.3166,1.3165,1.3163,1.3162/

		DATA (refractive(i),i=1601,1700)/&
	1.3161,1.3160,1.3159,1.3159,1.3158,1.3157,1.3156,1.3155,1.3154,1.3153,&
	1.3152,1.3151,1.3150,1.3150,1.3149,1.3148,1.3147,1.3146,1.3146,1.3145,&
	1.3144,1.3143,1.3142,1.3141,1.3140,1.3139,1.3138,1.3137,1.3136,1.3135,&
	1.3134,1.3133,1.3132,1.3131,1.3130,1.3129,1.3128,1.3127,1.3126,1.3125,&
	1.3124,1.3123,1.3122,1.3121,1.3120,1.3119,1.3118,1.3117,1.3116,1.3115,&
	1.3114,1.3113,1.3112,1.3110,1.3109,1.3108,1.3107,1.3106,1.3105,1.3104,&
	1.3103,1.3102,1.3101,1.3099,1.3098,1.3097,1.3096,1.3095,1.3094,1.3093,&
	1.3092,1.3091,1.3090,1.3088,1.3087,1.3086,1.3085,1.3084,1.3082,1.3081,&
	1.3080,1.3079,1.3078,1.3076,1.3075,1.3074,1.3073,1.3072,1.3070,1.3069,&
	1.3068,1.3067,1.3066,1.3064,1.3063,1.3062,1.3061,1.3060,1.3059,1.3058/

		DATA (refractive(i),i=1701,1800)/&
	1.3057,1.3056,1.3055,1.3053,1.3052,1.3051,1.3050,1.3049,1.3047,1.3046,&
	1.3045,1.3044,1.3043,1.3041,1.3040,1.3039,1.3038,1.3037,1.3035,1.3034,&
	1.3033,1.3032,1.3031,1.3029,1.3028,1.3027,1.3026,1.3025,1.3023,1.3022,&
	1.3021,1.3020,1.3019,1.3017,1.3016,1.3015,1.3014,1.3013,1.3011,1.3010,&
	1.3009,1.3008,1.3007,1.3005,1.3004,1.3003,1.3002,1.3001,1.2999,1.2998,&
	1.2997,1.2996,1.2995,1.2993,1.2992,1.2991,1.2990,1.2989,1.2987,1.2986,&
	1.2985,1.2984,1.2983,1.2981,1.2980,1.2979,1.2978,1.2977,1.2975,1.2974,&
	1.2973,1.2972,1.2970,1.2969,1.2967,1.2966,1.2965,1.2964,1.2962,1.2961,&
	1.2960,1.2959,1.2958,1.2957,1.2956,1.2955,1.2954,1.2953,1.2951,1.2950,&
	1.2949,1.2948,1.2947,1.2945,1.2944,1.2943,1.2942,1.2941,1.2939,1.2938/

		DATA (refractive(i),i=1801,1900)/&
	1.2937,1.2936,1.2935,1.2933,1.2932,1.2931,1.2930,1.2928,1.2927,1.2925,&
	1.2924,1.2923,1.2922,1.2920,1.2919,1.2918,1.2917,1.2916,1.2914,1.2913,&
	1.2912,1.2911,1.2910,1.2908,1.2907,1.2906,1.2905,1.2904,1.2902,1.2901,&
	1.2900,1.2899,1.2898,1.2896,1.2895,1.2894,1.2893,1.2892,1.2890,1.2889,&
	1.2888,1.2887,1.2886,1.2884,1.2883,1.2882,1.2881,1.2880,1.2878,1.2877,&
	1.2876,1.2875,1.2874,1.2873,1.2872,1.2871,1.2870,1.2869,1.2867,1.2866,&
	1.2865,1.2864,1.2863,1.2862,1.2861,1.2860,1.2859,1.2858,1.2856,1.2855,&
	1.2854,1.2853,1.2852,1.2850,1.2849,1.2848,1.2847,1.2846,1.2845,1.2844,&
	1.2843,1.2842,1.2841,1.2840,1.2839,1.2838,1.2837,1.2836,1.2834,1.2833,&
	1.2832,1.2831,1.2830,1.2829,1.2828,1.2827,1.2826,1.2825,1.2824,1.2823/

		DATA (refractive(i),i=1901,2000)/&
	1.2822,1.2821,1.2820,1.2818,1.2817,1.2816,1.2815,1.2814,1.2813,1.2812,&
	1.2811,1.2810,1.2809,1.2808,1.2807,1.2806,1.2805,1.2804,1.2803,1.2802,&
	1.2801,1.2800,1.2799,1.2799,1.2798,1.2797,1.2796,1.2795,1.2795,1.2794,&
	1.2793,1.2792,1.2791,1.2791,1.2790,1.2789,1.2788,1.2788,1.2787,1.2787,&
	1.2786,1.2785,1.2785,1.2784,1.2784,1.2783,1.2782,1.2781,1.2780,1.2779,&
	1.2778,1.2777,1.2776,1.2776,1.2775,1.2774,1.2773,1.2772,1.2771,1.2770,&
	1.2769,1.2768,1.2767,1.2766,1.2765,1.2764,1.2763,1.2762,1.2761,1.2760,&
	1.2759,1.2758,1.2757,1.2757,1.2756,1.2755,1.2754,1.2753,1.2753,1.2752,&
	1.2751,1.2750,1.2749,1.2749,1.2748,1.2747,1.2746,1.2745,1.2745,1.2744,&
	1.2743,1.2742,1.2742,1.2741,1.2741,1.2740,1.2739,1.2739,1.2738,1.2738/

		DATA (refractive(i),i=2001,2101)/&
	1.2737,1.2736,1.2736,1.2735,1.2735,1.2734,1.2733,1.2733,1.2732,1.2732,&
	1.2731,1.2730,1.2730,1.2729,1.2729,1.2728,1.2727,1.2727,1.2726,1.2726,&
	1.2725,1.2725,1.2724,1.2724,1.2723,1.2723,1.2722,1.2722,1.2721,1.2721,&
	1.2720,1.2720,1.2719,1.2719,1.2718,1.2718,1.2717,1.2717,1.2716,1.2716,&
	1.2715,1.2715,1.2714,1.2714,1.2713,1.2713,1.2713,1.2713,1.2712,1.2712,&
	1.2712,1.2712,1.2711,1.2711,1.2710,1.2710,1.2710,1.2710,1.2709,1.2709,&
	1.2709,1.2709,1.2709,1.2708,1.2708,1.2708,1.2708,1.2708,1.2708,1.2708,&
	1.2708,1.2708,1.2708,1.2708,1.2708,1.2708,1.2708,1.2709,1.2709,1.2710,&
	1.2710,1.2711,1.2712,1.2712,1.2713,1.2714,1.2715,1.2716,1.2717,1.2718,&
	1.2719,1.2720,1.2722,1.2723,1.2725,1.2726,1.2728,1.2730,1.2732,1.2734,&
	1.2736/

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				specific absorption of chlorophyll					!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (k_Cab(i),i=1,100)/&
	2.676E-02,3.113E-02,3.561E-02,3.972E-02,4.321E-02,4.606E-02,4.815E-02,5.007E-02,5.189E-02,5.346E-02,&
	5.526E-02,5.721E-02,5.891E-02,6.004E-02,6.100E-02,6.189E-02,6.259E-02,6.318E-02,6.367E-02,6.416E-02,&
	6.475E-02,6.555E-02,6.628E-02,6.690E-02,6.718E-02,6.747E-02,6.795E-02,6.855E-02,6.897E-02,6.931E-02,&
	6.979E-02,7.037E-02,7.082E-02,7.114E-02,7.141E-02,7.160E-02,7.174E-02,7.177E-02,7.171E-02,7.156E-02,&
	7.120E-02,7.048E-02,6.963E-02,6.883E-02,6.789E-02,6.685E-02,6.583E-02,6.480E-02,6.358E-02,6.225E-02,&
	6.090E-02,5.956E-02,5.813E-02,5.677E-02,5.553E-02,5.439E-02,5.330E-02,5.224E-02,5.135E-02,5.056E-02,&
	4.990E-02,4.934E-02,4.891E-02,4.852E-02,4.812E-02,4.767E-02,4.729E-02,4.698E-02,4.673E-02,4.647E-02,&
	4.622E-02,4.606E-02,4.589E-02,4.570E-02,4.552E-02,4.535E-02,4.519E-02,4.492E-02,4.466E-02,4.442E-02,&
	4.413E-02,4.373E-02,4.325E-02,4.275E-02,4.216E-02,4.149E-02,4.073E-02,3.989E-02,3.895E-02,3.791E-02,&
	3.683E-02,3.571E-02,3.455E-02,3.335E-02,3.215E-02,3.094E-02,2.972E-02,2.850E-02,2.730E-02,2.615E-02/

		DATA (k_Cab(i),i=101,200)/&
	2.502e-02,2.392e-02,2.284e-02,2.179e-02,2.077e-02,1.979e-02,1.883e-02,1.790e-02,1.702e-02,1.617e-02,&
	1.536e-02,1.458e-02,1.383e-02,1.312e-02,1.246e-02,1.183e-02,1.126e-02,1.074e-02,1.027e-02,9.855e-03,&
	9.490e-03,9.176e-03,8.910e-03,8.698e-03,8.542e-03,8.437e-03,8.381e-03,8.373e-03,8.411e-03,8.486e-03,&
	8.595e-03,8.735e-03,8.905e-03,9.098e-03,9.313e-03,9.544e-03,9.789e-03,1.004e-02,1.030e-02,1.056e-02,&
	1.083e-02,1.108e-02,1.133e-02,1.157e-02,1.180e-02,1.201e-02,1.221e-02,1.239e-02,1.256e-02,1.271e-02,&
	1.286e-02,1.300e-02,1.314e-02,1.327e-02,1.340e-02,1.353e-02,1.367e-02,1.380e-02,1.394e-02,1.408e-02,&
	1.421e-02,1.435e-02,1.451e-02,1.469e-02,1.489e-02,1.511e-02,1.535e-02,1.561e-02,1.589e-02,1.619e-02,&
	1.650e-02,1.683e-02,1.716e-02,1.749e-02,1.782e-02,1.814e-02,1.846e-02,1.876e-02,1.905e-02,1.933e-02,&
	1.960e-02,1.986e-02,2.011e-02,2.035e-02,2.058e-02,2.079e-02,2.100e-02,2.120e-02,2.138e-02,2.155e-02,&
	2.171e-02,2.185e-02,2.199e-02,2.211e-02,2.222e-02,2.231e-02,2.241e-02,2.250e-02,2.259e-02,2.269e-02/

		DATA (k_Cab(i),i=201,300)/&
	2.279e-02,2.291e-02,2.304e-02,2.319e-02,2.337e-02,2.356e-02,2.378e-02,2.403e-02,2.430e-02,2.459e-02,&
	2.489e-02,2.520e-02,2.552e-02,2.586e-02,2.620e-02,2.654e-02,2.687e-02,2.719e-02,2.750e-02,2.778e-02,&
	2.803e-02,2.826e-02,2.845e-02,2.862e-02,2.877e-02,2.888e-02,2.898e-02,2.905e-02,2.910e-02,2.916e-02,&
	2.921e-02,2.928e-02,2.938e-02,2.951e-02,2.969e-02,2.993e-02,3.022e-02,3.059e-02,3.102e-02,3.152e-02,&
	3.208e-02,3.269e-02,3.335e-02,3.405e-02,3.478e-02,3.552e-02,3.626e-02,3.698e-02,3.767e-02,3.831e-02,&
	3.890e-02,3.943e-02,3.993e-02,4.043e-02,4.095e-02,4.152e-02,4.217e-02,4.293e-02,4.380e-02,4.478e-02,&
	4.588e-02,4.709e-02,4.837e-02,4.970e-02,5.106e-02,5.239e-02,5.368e-02,5.488e-02,5.595e-02,5.688e-02,&
	5.765e-02,5.826e-02,5.871e-02,5.900e-02,5.914e-02,5.914e-02,5.899e-02,5.868e-02,5.819e-02,5.748e-02,&
	5.650e-02,5.522e-02,5.361e-02,5.168e-02,4.941e-02,4.689e-02,4.416e-02,4.128e-02,3.834e-02,3.541e-02,&
	3.254e-02,2.978e-02,2.717e-02,2.473e-02,2.247e-02,2.039e-02,1.850e-02,1.678e-02,1.523e-02,1.384e-02/

		DATA (k_Cab(i),i=301,400)/&
	1.259e-02,1.147e-02,1.048e-02,9.594e-03,8.804e-03,8.099e-03,7.465e-03,6.892e-03,6.371e-03,5.897e-03,&
	5.461e-03,5.061e-03,4.691e-03,4.348e-03,4.029e-03,3.733e-03,3.456e-03,3.199e-03,2.960e-03,2.736e-03,&
	2.528e-03,2.334e-03,2.153e-03,1.985e-03,1.829e-03,1.683e-03,1.549e-03,1.424e-03,1.309e-03,1.202e-03,&
	1.103e-03,1.012e-03,9.269e-04,8.485e-04,7.768e-04,7.110e-04,6.505e-04,5.948e-04,5.437e-04,4.967e-04,&
	4.539e-04,4.150e-04,3.794e-04,3.471e-04,3.177e-04,2.909e-04,2.666e-04,2.450e-04,2.255e-04,2.079e-04,&
	1.924e-04,1.773e-04,1.629e-04,1.493e-04,1.364e-04,1.243e-04,1.128e-04,1.020e-04,9.188e-05,8.240e-05,&
	7.354e-05,6.529e-05,5.763e-05,5.054e-05,4.400e-05,3.800e-05,3.251e-05,2.753e-05,2.302e-05,1.898e-05,&
	1.539e-05,1.222e-05,9.466e-06,7.101e-06,5.109e-06,3.473e-06,2.175e-06,1.196e-06,5.200e-07,1.270e-07,&
	0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,&
	0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00/

		DATA (k_Cab(i),i=401,2101)/1701*0./

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				specific absorption of carotenoids					!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (k_Car(i),i=1,100)/&
	2.895e-01,2.796e-01,2.693e-01,2.601e-01,2.525e-01,2.456e-01,2.402e-01,2.352e-01,2.303e-01,2.255e-01,&
	2.203e-01,2.151e-01,2.105e-01,2.069e-01,2.035e-01,2.002e-01,1.971e-01,1.943e-01,1.914e-01,1.889e-01,&
	1.866e-01,1.844e-01,1.823e-01,1.805e-01,1.792e-01,1.777e-01,1.762e-01,1.747e-01,1.735e-01,1.724e-01,&
	1.715e-01,1.707e-01,1.701e-01,1.694e-01,1.688e-01,1.682e-01,1.678e-01,1.674e-01,1.670e-01,1.667e-01,&
	1.664e-01,1.659e-01,1.653e-01,1.647e-01,1.641e-01,1.632e-01,1.624e-01,1.615e-01,1.605e-01,1.592e-01,&
	1.577e-01,1.561e-01,1.544e-01,1.528e-01,1.513e-01,1.497e-01,1.483e-01,1.468e-01,1.454e-01,1.440e-01,&
	1.425e-01,1.411e-01,1.397e-01,1.384e-01,1.371e-01,1.358e-01,1.347e-01,1.335e-01,1.325e-01,1.316e-01,&
	1.308e-01,1.302e-01,1.296e-01,1.292e-01,1.288e-01,1.285e-01,1.282e-01,1.280e-01,1.277e-01,1.274e-01,&
	1.270e-01,1.265e-01,1.260e-01,1.253e-01,1.244e-01,1.234e-01,1.223e-01,1.211e-01,1.197e-01,1.182e-01,&
	1.166e-01,1.150e-01,1.132e-01,1.114e-01,1.096e-01,1.076e-01,1.056e-01,1.035e-01,1.013e-01,9.901e-02/

		DATA (k_Car(i),i=101,200)/&
	9.660e-02,9.420e-02,9.179e-02,8.939e-02,8.699e-02,8.460e-02,8.221e-02,7.983e-02,7.746e-02,7.510e-02,&
	7.275e-02,7.041e-02,6.809e-02,6.578e-02,6.349e-02,6.122e-02,5.897e-02,5.673e-02,5.453e-02,5.234e-02,&
	5.018e-02,4.805e-02,4.594e-02,4.387e-02,4.182e-02,3.981e-02,3.783e-02,3.588e-02,3.397e-02,3.210e-02,&
	3.026e-02,2.847e-02,2.672e-02,2.501e-02,2.334e-02,2.172e-02,2.015e-02,1.863e-02,1.715e-02,1.573e-02,&
	1.436e-02,1.304e-02,1.178e-02,1.057e-02,9.420e-03,8.330e-03,7.301e-03,6.334e-03,5.429e-03,4.589e-03,&
	3.816e-03,3.109e-03,2.471e-03,1.903e-03,1.406e-03,9.822e-04,6.322e-04,3.577e-04,1.599e-04,4.019e-05,&
	0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,&
	0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,&
	0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,&
	0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00,0.000e+00/

		DATA (k_Car(i),i=201,2101)/1901*0./

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				specific absorption of Brown pigments				!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (k_Brown(i),i=1,100)/&
	5.272e-001,5.262e-001,5.252e-001,5.242e-001,5.232e-001,5.222e-001,5.212e-001,5.202e-001,5.192e-001,5.182e-001,&
	5.172e-001,5.162e-001,5.152e-001,5.142e-001,5.132e-001,5.122e-001,5.112e-001,5.102e-001,5.092e-001,5.082e-001,&
	5.072e-001,5.062e-001,5.052e-001,5.042e-001,5.032e-001,5.022e-001,5.012e-001,5.002e-001,4.992e-001,4.982e-001,&
	4.972e-001,4.960e-001,4.948e-001,4.936e-001,4.924e-001,4.912e-001,4.900e-001,4.888e-001,4.876e-001,4.864e-001,&
	4.852e-001,4.840e-001,4.829e-001,4.817e-001,4.805e-001,4.793e-001,4.781e-001,4.769e-001,4.757e-001,4.745e-001,&
	4.733e-001,4.720e-001,4.708e-001,4.695e-001,4.683e-001,4.670e-001,4.658e-001,4.645e-001,4.633e-001,4.620e-001,&
	4.608e-001,4.597e-001,4.587e-001,4.577e-001,4.566e-001,4.556e-001,4.546e-001,4.535e-001,4.525e-001,4.515e-001,&
	4.504e-001,4.494e-001,4.484e-001,4.473e-001,4.463e-001,4.453e-001,4.442e-001,4.432e-001,4.422e-001,4.411e-001,&
	4.401e-001,4.388e-001,4.375e-001,4.362e-001,4.350e-001,4.337e-001,4.324e-001,4.311e-001,4.298e-001,4.285e-001,&
	4.272e-001,4.260e-001,4.247e-001,4.234e-001,4.221e-001,4.208e-001,4.195e-001,4.183e-001,4.170e-001,4.157e-001/

		DATA (k_Brown(i),i=101,200)/&
	4.144e-001,4.135e-001,4.127e-001,4.118e-001,4.109e-001,4.100e-001,4.092e-001,4.083e-001,4.074e-001,4.065e-001,&
	4.057e-001,4.047e-001,4.038e-001,4.028e-001,4.019e-001,4.009e-001,4.000e-001,3.990e-001,3.981e-001,3.971e-001,&
	3.962e-001,3.952e-001,3.943e-001,3.933e-001,3.924e-001,3.914e-001,3.905e-001,3.895e-001,3.886e-001,3.876e-001,&
	3.867e-001,3.846e-001,3.824e-001,3.803e-001,3.782e-001,3.760e-001,3.739e-001,3.718e-001,3.696e-001,3.675e-001,&
	3.654e-001,3.639e-001,3.625e-001,3.611e-001,3.597e-001,3.582e-001,3.568e-001,3.554e-001,3.540e-001,3.525e-001,&
	3.511e-001,3.500e-001,3.489e-001,3.478e-001,3.467e-001,3.456e-001,3.445e-001,3.434e-001,3.423e-001,3.412e-001,&
	3.401e-001,3.383e-001,3.366e-001,3.348e-001,3.330e-001,3.312e-001,3.294e-001,3.276e-001,3.258e-001,3.241e-001,&
	3.223e-001,3.202e-001,3.182e-001,3.162e-001,3.141e-001,3.121e-001,3.100e-001,3.080e-001,3.059e-001,3.039e-001,&
	3.019e-001,2.999e-001,2.979e-001,2.959e-001,2.940e-001,2.920e-001,2.900e-001,2.881e-001,2.861e-001,2.841e-001,&
	2.821e-001,2.803e-001,2.784e-001,2.766e-001,2.747e-001,2.728e-001,2.710e-001,2.691e-001,2.673e-001,2.654e-001/

		DATA (k_Brown(i),i=201,300)/&
	2.636e-001,2.618e-001,2.601e-001,2.584e-001,2.566e-001,2.549e-001,2.532e-001,2.515e-001,2.497e-001,2.480e-001,&
	2.463e-001,2.447e-001,2.431e-001,2.414e-001,2.398e-001,2.382e-001,2.366e-001,2.350e-001,2.334e-001,2.318e-001,&
	2.302e-001,2.288e-001,2.273e-001,2.258e-001,2.244e-001,2.229e-001,2.215e-001,2.200e-001,2.185e-001,2.171e-001,&
	2.156e-001,2.143e-001,2.129e-001,2.115e-001,2.102e-001,2.088e-001,2.074e-001,2.061e-001,2.047e-001,2.033e-001,&
	2.020e-001,2.007e-001,1.994e-001,1.981e-001,1.968e-001,1.955e-001,1.942e-001,1.929e-001,1.916e-001,1.903e-001,&
	1.890e-001,1.878e-001,1.865e-001,1.853e-001,1.841e-001,1.829e-001,1.816e-001,1.804e-001,1.792e-001,1.780e-001,&
	1.768e-001,1.755e-001,1.742e-001,1.729e-001,1.717e-001,1.704e-001,1.691e-001,1.679e-001,1.666e-001,1.653e-001,&
	1.641e-001,1.627e-001,1.613e-001,1.600e-001,1.586e-001,1.572e-001,1.559e-001,1.545e-001,1.532e-001,1.518e-001,&
	1.504e-001,1.491e-001,1.478e-001,1.464e-001,1.451e-001,1.437e-001,1.424e-001,1.411e-001,1.397e-001,1.384e-001,&
	1.370e-001,1.358e-001,1.345e-001,1.333e-001,1.320e-001,1.308e-001,1.295e-001,1.283e-001,1.270e-001,1.258e-001/

		DATA (k_Brown(i),i=301,400)/&
	1.245e-001,1.234e-001,1.223e-001,1.212e-001,1.200e-001,1.189e-001,1.178e-001,1.167e-001,1.156e-001,1.144e-001,&
	1.133e-001,1.122e-001,1.111e-001,1.100e-001,1.089e-001,1.078e-001,1.067e-001,1.056e-001,1.046e-001,1.035e-001,&
	1.024e-001,1.013e-001,1.003e-001,9.931e-002,9.829e-002,9.727e-002,9.625e-002,9.524e-002,9.422e-002,9.320e-002,&
	9.218e-002,9.120e-002,9.022e-002,8.924e-002,8.827e-002,8.729e-002,8.631e-002,8.533e-002,8.435e-002,8.337e-002,&
	8.239e-002,8.155e-002,8.070e-002,7.985e-002,7.901e-002,7.816e-002,7.732e-002,7.647e-002,7.562e-002,7.478e-002,&
	7.393e-002,7.319e-002,7.245e-002,7.171e-002,7.097e-002,7.023e-002,6.949e-002,6.875e-002,6.801e-002,6.727e-002,&
	6.653e-002,6.586e-002,6.519e-002,6.452e-002,6.385e-002,6.318e-002,6.251e-002,6.184e-002,6.117e-002,6.050e-002,&
	5.983e-002,5.913e-002,5.843e-002,5.773e-002,5.704e-002,5.634e-002,5.564e-002,5.494e-002,5.424e-002,5.354e-002,&
	5.284e-002,5.226e-002,5.167e-002,5.109e-002,5.050e-002,4.992e-002,4.933e-002,4.874e-002,4.816e-002,4.757e-002,&
	4.699e-002,4.646e-002,4.594e-002,4.542e-002,4.490e-002,4.437e-002,4.385e-002,4.333e-002,4.281e-002,4.228e-002/

		DATA (k_Brown(i),i=401,500)/&
	4.176e-002,4.128e-002,4.081e-002,4.033e-002,3.985e-002,3.937e-002,3.889e-002,3.841e-002,3.793e-002,3.746e-002,&
	3.698e-002,3.657e-002,3.615e-002,3.574e-002,3.533e-002,3.492e-002,3.451e-002,3.409e-002,3.368e-002,3.327e-002,&
	3.286e-002,3.249e-002,3.212e-002,3.175e-002,3.139e-002,3.102e-002,3.065e-002,3.028e-002,2.991e-002,2.954e-002,&
	2.918e-002,2.885e-002,2.852e-002,2.819e-002,2.786e-002,2.753e-002,2.720e-002,2.688e-002,2.655e-002,2.622e-002,&
	2.589e-002,2.559e-002,2.529e-002,2.499e-002,2.469e-002,2.440e-002,2.410e-002,2.380e-002,2.350e-002,2.320e-002,&
	2.290e-002,2.264e-002,2.238e-002,2.212e-002,2.186e-002,2.159e-002,2.133e-002,2.107e-002,2.081e-002,2.055e-002,&
	2.029e-002,2.006e-002,1.983e-002,1.961e-002,1.938e-002,1.915e-002,1.893e-002,1.870e-002,1.847e-002,1.825e-002,&
	1.802e-002,1.782e-002,1.762e-002,1.742e-002,1.723e-002,1.703e-002,1.683e-002,1.663e-002,1.643e-002,1.623e-002,&
	1.604e-002,1.586e-002,1.568e-002,1.551e-002,1.533e-002,1.516e-002,1.498e-002,1.481e-002,1.463e-002,1.446e-002,&
	1.428e-002,1.414e-002,1.400e-002,1.385e-002,1.371e-002,1.357e-002,1.343e-002,1.328e-002,1.314e-002,1.300e-002/

		DATA (k_Brown(i),i=501,600)/&
	1.286e-002,1.275e-002,1.265e-002,1.255e-002,1.245e-002,1.235e-002,1.225e-002,1.215e-002,1.205e-002,1.195e-002,&
	1.185e-002,1.175e-002,1.165e-002,1.155e-002,1.145e-002,1.135e-002,1.125e-002,1.115e-002,1.105e-002,1.096e-002,&
	1.086e-002,1.076e-002,1.066e-002,1.056e-002,1.047e-002,1.037e-002,1.027e-002,1.017e-002,1.008e-002,9.980e-003,&
	9.884e-003,9.787e-003,9.691e-003,9.595e-003,9.500e-003,9.404e-003,9.309e-003,9.214e-003,9.120e-003,9.025e-003,&
	8.931e-003,8.837e-003,8.743e-003,8.650e-003,8.557e-003,8.464e-003,8.371e-003,8.279e-003,8.187e-003,8.095e-003,&
	8.004e-003,7.913e-003,7.822e-003,7.732e-003,7.641e-003,7.552e-003,7.462e-003,7.373e-003,7.284e-003,7.195e-003,&
	7.107e-003,7.019e-003,6.932e-003,6.844e-003,6.758e-003,6.671e-003,6.585e-003,6.499e-003,6.414e-003,6.329e-003,&
	6.244e-003,6.160e-003,6.076e-003,5.993e-003,5.910e-003,5.827e-003,5.745e-003,5.663e-003,5.581e-003,5.500e-003,&
	5.419e-003,5.339e-003,5.259e-003,5.180e-003,5.101e-003,5.023e-003,4.945e-003,4.867e-003,4.790e-003,4.713e-003,&
	4.637e-003,4.561e-003,4.486e-003,4.411e-003,4.337e-003,4.263e-003,4.190e-003,4.117e-003,4.044e-003,3.972e-003/

		DATA (k_Brown(i),i=601,700)/&
	3.901e-003,3.830e-003,3.760e-003,3.690e-003,3.620e-003,3.552e-003,3.483e-003,3.416e-003,3.348e-003,3.282e-003,&
	3.215e-003,3.150e-003,3.085e-003,3.020e-003,2.956e-003,2.893e-003,2.830e-003,2.768e-003,2.706e-003,2.645e-003,&
	2.585e-003,2.525e-003,2.465e-003,2.407e-003,2.348e-003,2.291e-003,2.234e-003,2.178e-003,2.122e-003,2.067e-003,&
	2.012e-003,1.959e-003,1.905e-003,1.853e-003,1.801e-003,1.750e-003,1.699e-003,1.649e-003,1.600e-003,1.551e-003,&
	1.503e-003,1.456e-003,1.409e-003,1.363e-003,1.318e-003,1.274e-003,1.230e-003,1.187e-003,1.144e-003,1.102e-003,&
	1.061e-003,1.021e-003,9.811e-004,9.422e-004,9.040e-004,8.665e-004,8.297e-004,7.937e-004,7.584e-004,7.239e-004,&
	6.901e-004,6.571e-004,6.248e-004,5.933e-004,5.626e-004,5.326e-004,5.034e-004,4.750e-004,4.473e-004,4.205e-004,&
	3.944e-004,3.691e-004,3.446e-004,3.210e-004,2.981e-004,2.760e-004,2.548e-004,2.344e-004,2.148e-004,1.960e-004,&
	1.780e-004,1.609e-004,1.446e-004,1.292e-004,1.146e-004,1.009e-004,8.804e-005,7.603e-005,6.488e-005,5.460e-005,&
	4.519e-005,3.666e-005,2.901e-005,2.225e-005,1.637e-005,1.138e-005,7.297e-006,4.111e-006,1.830e-006,4.581e-007/

		DATA (k_Brown(i),i=701,2101)/1401*0./

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!					specific absorption of water					!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	    DATA (k_Cw(i),i=1,100)/&
	5.800E-05,5.852E-05,5.900E-05,5.989E-05,6.100E-05,6.203E-05,6.300E-05,6.399E-05,6.500E-05,6.603E-05,&
	6.700E-05,6.790E-05,6.900E-05,7.050E-05,7.200E-05,7.312E-05,7.400E-05,7.490E-05,7.600E-05,7.740E-05,&
	7.900E-05,8.063E-05,8.200E-05,8.297E-05,8.400E-05,8.551E-05,8.700E-05,8.800E-05,8.900E-05,9.050E-05,&
	9.200E-05,9.300E-05,9.400E-05,9.550E-05,9.700E-05,9.801E-05,9.900E-05,1.005E-04,1.020E-04,1.031E-04,&
	1.040E-04,1.050E-04,1.060E-04,1.070E-04,1.080E-04,1.090E-04,1.100E-04,1.110E-04,1.120E-04,1.130E-04,&
	1.140E-04,1.150E-04,1.160E-04,1.170E-04,1.180E-04,1.190E-04,1.200E-04,1.210E-04,1.220E-04,1.230E-04,&
	1.240E-04,1.250E-04,1.260E-04,1.270E-04,1.280E-04,1.289E-04,1.300E-04,1.315E-04,1.330E-04,1.340E-04,&
	1.350E-04,1.364E-04,1.380E-04,1.396E-04,1.410E-04,1.424E-04,1.440E-04,1.459E-04,1.480E-04,1.499E-04,&
	1.520E-04,1.544E-04,1.570E-04,1.596E-04,1.620E-04,1.643E-04,1.670E-04,1.704E-04,1.740E-04,1.775E-04,&
	1.810E-04,1.849E-04,1.890E-04,1.934E-04,1.980E-04,2.031E-04,2.090E-04,2.158E-04,2.230E-04,2.303E-04/

      DATA (k_Cw(i),i=101,200)/&
	2.380E-04,2.463E-04,2.550E-04,2.640E-04,2.730E-04,2.819E-04,2.910E-04,3.004E-04,3.100E-04,3.194E-04,&
	3.290E-04,3.390E-04,3.490E-04,3.588E-04,3.680E-04,3.767E-04,3.860E-04,3.962E-04,4.040E-04,4.069E-04,&
	4.090E-04,4.138E-04,4.160E-04,4.112E-04,4.090E-04,4.176E-04,4.270E-04,4.268E-04,4.230E-04,4.237E-04,&
	4.290E-04,4.371E-04,4.450E-04,4.506E-04,4.560E-04,4.631E-04,4.700E-04,4.748E-04,4.800E-04,4.879E-04,&
	4.950E-04,4.983E-04,5.030E-04,5.141E-04,5.270E-04,5.363E-04,5.440E-04,5.532E-04,5.640E-04,5.759E-04,&
	5.880E-04,5.998E-04,6.110E-04,6.215E-04,6.310E-04,6.391E-04,6.460E-04,6.520E-04,6.580E-04,6.647E-04,&
	6.720E-04,6.793E-04,6.860E-04,6.920E-04,6.990E-04,7.084E-04,7.180E-04,7.257E-04,7.340E-04,7.455E-04,&
	7.590E-04,7.729E-04,7.870E-04,8.020E-04,8.190E-04,8.386E-04,8.580E-04,8.754E-04,8.960E-04,9.238E-04,&
	9.520E-04,9.745E-04,1.000E-03,1.037E-03,1.079E-03,1.119E-03,1.159E-03,1.204E-03,1.253E-03,1.304E-03,&
	1.356E-03,1.408E-03,1.459E-03,1.510E-03,1.567E-03,1.635E-03,1.700E-03,1.758E-03,1.860E-03,2.042E-03/

      DATA (k_Cw(i),i=201,300)/&
	2.224E-03,2.323E-03,2.366E-03,2.400E-03,2.448E-03,2.519E-03,2.587E-03,2.629E-03,2.653E-03,2.674E-03,&
	2.691E-03,2.704E-03,2.715E-03,2.727E-03,2.740E-03,2.753E-03,2.764E-03,2.775E-03,2.785E-03,2.797E-03,&
	2.810E-03,2.824E-03,2.839E-03,2.854E-03,2.868E-03,2.881E-03,2.893E-03,2.907E-03,2.922E-03,2.938E-03,&
	2.955E-03,2.972E-03,2.988E-03,3.000E-03,3.011E-03,3.023E-03,3.038E-03,3.057E-03,3.076E-03,3.094E-03,&
	3.111E-03,3.127E-03,3.144E-03,3.162E-03,3.181E-03,3.202E-03,3.223E-03,3.242E-03,3.263E-03,3.289E-03,&
	3.315E-03,3.338E-03,3.362E-03,3.390E-03,3.423E-03,3.461E-03,3.508E-03,3.567E-03,3.636E-03,3.712E-03,&
	3.791E-03,3.866E-03,3.931E-03,3.981E-03,4.019E-03,4.049E-03,4.072E-03,4.087E-03,4.098E-03,4.109E-03,&
	4.122E-03,4.137E-03,4.150E-03,4.160E-03,4.173E-03,4.196E-03,4.223E-03,4.248E-03,4.270E-03,4.293E-03,&
	4.318E-03,4.347E-03,4.381E-03,4.418E-03,4.458E-03,4.500E-03,4.545E-03,4.594E-03,4.646E-03,4.701E-03,&
	4.760E-03,4.827E-03,4.903E-03,4.986E-03,5.071E-03,5.154E-03,5.244E-03,5.351E-03,5.470E-03,5.594E-03/

      DATA (k_Cw(i),i=301,400)/&
	5.722E-03,5.855E-03,5.995E-03,6.146E-03,6.303E-03,6.463E-03,6.628E-03,6.804E-03,6.993E-03,7.197E-03,&
	7.415E-03,7.647E-03,7.893E-03,8.157E-03,8.445E-03,8.763E-03,9.109E-03,9.479E-03,9.871E-03,1.029E-02,&
	1.072E-02,1.119E-02,1.168E-02,1.218E-02,1.268E-02,1.319E-02,1.372E-02,1.428E-02,1.487E-02,1.551E-02,&
	1.621E-02,1.699E-02,1.787E-02,1.886E-02,1.992E-02,2.101E-02,2.207E-02,2.306E-02,2.394E-02,2.469E-02,&
	2.532E-02,2.583E-02,2.623E-02,2.652E-02,2.672E-02,2.689E-02,2.702E-02,2.713E-02,2.722E-02,2.728E-02,&
	2.733E-02,2.738E-02,2.741E-02,2.745E-02,2.748E-02,2.751E-02,2.754E-02,2.758E-02,2.763E-02,2.767E-02,&
	2.771E-02,2.773E-02,2.773E-02,2.774E-02,2.774E-02,2.773E-02,2.770E-02,2.766E-02,2.761E-02,2.757E-02,&
	2.754E-02,2.752E-02,2.748E-02,2.741E-02,2.731E-02,2.720E-02,2.710E-02,2.701E-02,2.690E-02,2.675E-02,&
	2.659E-02,2.645E-02,2.633E-02,2.624E-02,2.613E-02,2.593E-02,2.558E-02,2.523E-02,2.513E-02,2.501E-02,&
	2.466E-02,2.447E-02,2.412E-02,2.389E-02,2.374E-02,2.355E-02,2.337E-02,2.318E-02,2.304E-02,2.281E-02/

      DATA (k_Cw(i),i=401,500)/&
	2.246E-02,2.243E-02,2.238E-02,2.222E-02,2.204E-02,2.201E-02,2.204E-02,2.196E-02,2.177E-02,2.190E-02,&
	2.188E-02,2.188E-02,2.198E-02,2.210E-02,2.223E-02,2.233E-02,2.248E-02,2.276E-02,2.304E-02,2.311E-02,&
	2.329E-02,2.388E-02,2.446E-02,2.475E-02,2.516E-02,2.620E-02,2.769E-02,2.830E-02,2.914E-02,3.108E-02,&
	3.214E-02,3.297E-02,3.459E-02,3.606E-02,3.662E-02,3.702E-02,3.788E-02,3.829E-02,3.854E-02,3.909E-02,&
	3.949E-02,3.972E-02,4.000E-02,4.040E-02,4.057E-02,4.075E-02,4.115E-02,4.127E-02,4.149E-02,4.204E-02,&
	4.199E-02,4.223E-02,4.254E-02,4.272E-02,4.280E-02,4.306E-02,4.360E-02,4.369E-02,4.379E-02,4.433E-02,&
	4.454E-02,4.466E-02,4.505E-02,4.527E-02,4.552E-02,4.605E-02,4.658E-02,4.691E-02,4.705E-02,4.713E-02,&
	4.752E-02,4.833E-02,4.867E-02,4.894E-02,4.960E-02,5.006E-02,5.050E-02,5.115E-02,5.153E-02,5.204E-02,&
	5.298E-02,5.346E-02,5.386E-02,5.465E-02,5.528E-02,5.566E-02,5.596E-02,5.653E-02,5.745E-02,5.789E-02,&
	5.831E-02,5.924E-02,5.982E-02,6.009E-02,6.035E-02,6.094E-02,6.185E-02,6.226E-02,6.269E-02,6.360E-02/

      DATA (k_Cw(i),i=501,600)/&
	6.407E-02,6.458E-02,6.562E-02,6.636E-02,6.672E-02,6.699E-02,6.769E-02,6.900E-02,6.989E-02,7.037E-02,&
	7.085E-02,7.187E-02,7.358E-02,7.486E-02,7.562E-02,7.630E-02,7.792E-02,8.085E-02,8.292E-02,8.410E-02,&
	8.528E-02,8.801E-02,9.268E-02,9.584E-02,9.819E-02,1.012E-01,1.042E-01,1.066E-01,1.113E-01,1.194E-01,&
	1.246E-01,1.281E-01,1.327E-01,1.374E-01,1.410E-01,1.465E-01,1.557E-01,1.635E-01,1.688E-01,1.732E-01,&
	1.818E-01,1.963E-01,2.050E-01,2.106E-01,2.187E-01,2.287E-01,2.386E-01,2.468E-01,2.542E-01,2.701E-01,&
	2.976E-01,3.153E-01,3.274E-01,3.438E-01,3.622E-01,3.785E-01,3.930E-01,4.068E-01,4.184E-01,4.273E-01,&
	4.385E-01,4.538E-01,4.611E-01,4.633E-01,4.663E-01,4.701E-01,4.733E-01,4.756E-01,4.772E-01,4.785E-01,&
	4.800E-01,4.814E-01,4.827E-01,4.843E-01,4.864E-01,4.870E-01,4.867E-01,4.864E-01,4.857E-01,4.841E-01,&
	4.821E-01,4.804E-01,4.786E-01,4.764E-01,4.738E-01,4.710E-01,4.677E-01,4.641E-01,4.604E-01,4.570E-01,&
	4.532E-01,4.482E-01,4.434E-01,4.397E-01,4.362E-01,4.316E-01,4.265E-01,4.215E-01,4.168E-01,4.121E-01/

      DATA (k_Cw(i),i=601,700)/&
	4.072E-01,4.017E-01,3.963E-01,3.915E-01,3.868E-01,3.816E-01,3.760E-01,3.701E-01,3.640E-01,3.581E-01,&
	3.521E-01,3.461E-01,3.402E-01,3.349E-01,3.297E-01,3.243E-01,3.191E-01,3.141E-01,3.086E-01,3.022E-01,&
	2.957E-01,2.897E-01,2.840E-01,2.782E-01,2.724E-01,2.672E-01,2.621E-01,2.566E-01,2.506E-01,2.444E-01,&
	2.391E-01,2.357E-01,2.331E-01,2.299E-01,2.251E-01,2.198E-01,2.151E-01,2.109E-01,2.064E-01,2.020E-01,&
	1.981E-01,1.944E-01,1.904E-01,1.868E-01,1.841E-01,1.818E-01,1.790E-01,1.752E-01,1.715E-01,1.687E-01,&
	1.664E-01,1.639E-01,1.613E-01,1.586E-01,1.562E-01,1.545E-01,1.532E-01,1.522E-01,1.510E-01,1.495E-01,&
	1.475E-01,1.457E-01,1.447E-01,1.442E-01,1.438E-01,1.433E-01,1.426E-01,1.418E-01,1.412E-01,1.410E-01,&
	1.409E-01,1.408E-01,1.406E-01,1.405E-01,1.408E-01,1.414E-01,1.426E-01,1.435E-01,1.438E-01,1.439E-01,&
	1.443E-01,1.456E-01,1.475E-01,1.498E-01,1.519E-01,1.534E-01,1.547E-01,1.561E-01,1.580E-01,1.604E-01,&
	1.632E-01,1.659E-01,1.677E-01,1.693E-01,1.712E-01,1.739E-01,1.777E-01,1.824E-01,1.866E-01,1.890E-01/

      DATA (k_Cw(i),i=701,800)/&
	1.906E-01,1.929E-01,1.967E-01,2.005E-01,2.031E-01,2.051E-01,2.079E-01,2.123E-01,2.166E-01,2.196E-01,&
	2.219E-01,2.251E-01,2.298E-01,2.337E-01,2.346E-01,2.342E-01,2.353E-01,2.397E-01,2.450E-01,2.491E-01,&
	2.528E-01,2.578E-01,2.650E-01,2.719E-01,2.765E-01,2.811E-01,2.891E-01,3.023E-01,3.164E-01,3.271E-01,&
	3.378E-01,3.533E-01,3.770E-01,4.037E-01,4.281E-01,4.502E-01,4.712E-01,4.932E-01,5.202E-01,5.572E-01,&
	6.052E-01,6.520E-01,6.863E-01,7.159E-01,7.535E-01,8.064E-01,8.597E-01,8.981E-01,9.253E-01,9.493E-01,&
	9.769E-01,1.008E+00,1.041E+00,1.073E+00,1.100E+00,1.119E+00,1.131E+00,1.140E+00,1.150E+00,1.160E+00,&
	1.170E+00,1.181E+00,1.190E+00,1.194E+00,1.196E+00,1.197E+00,1.200E+00,1.203E+00,1.205E+00,1.206E+00,&
	1.207E+00,1.213E+00,1.223E+00,1.232E+00,1.234E+00,1.232E+00,1.229E+00,1.230E+00,1.233E+00,1.236E+00,&
	1.239E+00,1.241E+00,1.244E+00,1.248E+00,1.252E+00,1.256E+00,1.258E+00,1.260E+00,1.262E+00,1.265E+00,&
	1.267E+00,1.270E+00,1.272E+00,1.275E+00,1.277E+00,1.280E+00,1.282E+00,1.283E+00,1.283E+00,1.279E+00/

      DATA (k_Cw(i),i=801,900)/&
	1.272E+00,1.266E+00,1.267E+00,1.271E+00,1.273E+00,1.271E+00,1.265E+00,1.260E+00,1.258E+00,1.258E+00,&
	1.257E+00,1.252E+00,1.247E+00,1.243E+00,1.243E+00,1.243E+00,1.240E+00,1.233E+00,1.224E+00,1.216E+00,&
	1.214E+00,1.214E+00,1.213E+00,1.210E+00,1.205E+00,1.200E+00,1.199E+00,1.198E+00,1.197E+00,1.194E+00,&
	1.189E+00,1.184E+00,1.180E+00,1.176E+00,1.171E+00,1.166E+00,1.161E+00,1.158E+00,1.157E+00,1.157E+00,&
	1.155E+00,1.152E+00,1.148E+00,1.142E+00,1.138E+00,1.133E+00,1.130E+00,1.126E+00,1.123E+00,1.120E+00,&
	1.116E+00,1.111E+00,1.107E+00,1.103E+00,1.101E+00,1.101E+00,1.101E+00,1.101E+00,1.100E+00,1.098E+00,&
	1.094E+00,1.089E+00,1.085E+00,1.084E+00,1.083E+00,1.083E+00,1.082E+00,1.081E+00,1.080E+00,1.079E+00,&
	1.080E+00,1.083E+00,1.087E+00,1.093E+00,1.099E+00,1.104E+00,1.107E+00,1.109E+00,1.111E+00,1.115E+00,&
	1.121E+00,1.129E+00,1.137E+00,1.147E+00,1.156E+00,1.164E+00,1.170E+00,1.175E+00,1.181E+00,1.188E+00,&
	1.196E+00,1.206E+00,1.216E+00,1.227E+00,1.239E+00,1.252E+00,1.267E+00,1.283E+00,1.297E+00,1.310E+00/

      DATA (k_Cw(i),i=901,1000)/&
	1.323E+00,1.336E+00,1.351E+00,1.370E+00,1.392E+00,1.416E+00,1.440E+00,1.465E+00,1.489E+00,1.511E+00,&
	1.532E+00,1.555E+00,1.580E+00,1.610E+00,1.642E+00,1.672E+00,1.701E+00,1.728E+00,1.758E+00,1.791E+00,&
	1.831E+00,1.872E+00,1.911E+00,1.943E+00,1.974E+00,2.007E+00,2.047E+00,2.098E+00,2.153E+00,2.203E+00,&
	2.243E+00,2.277E+00,2.312E+00,2.357E+00,2.415E+00,2.479E+00,2.540E+00,2.590E+00,2.631E+00,2.666E+00,&
	2.701E+00,2.738E+00,2.780E+00,2.829E+00,2.889E+00,2.960E+00,3.033E+00,3.097E+00,3.146E+00,3.181E+00,&
	3.226E+00,3.267E+00,3.319E+00,3.363E+00,3.412E+00,3.449E+00,3.504E+00,3.544E+00,3.600E+00,3.648E+00,&
	3.701E+00,3.752E+00,3.802E+00,3.871E+00,3.927E+00,3.985E+00,4.064E+00,4.125E+00,4.216E+00,4.302E+00,&
	4.389E+00,4.504E+00,4.630E+00,4.737E+00,4.904E+00,5.092E+00,5.260E+00,5.479E+00,5.720E+00,6.006E+00,&
	6.242E+00,6.580E+00,6.927E+00,7.313E+00,7.633E+00,8.089E+00,8.545E+00,9.030E+00,9.591E+00,1.002E+01,&
	1.063E+01,1.122E+01,1.184E+01,1.245E+01,1.316E+01,1.369E+01,1.434E+01,1.509E+01,1.578E+01,1.646E+01/

      DATA (k_Cw(i),i=1001,1100)/&
	1.714E+01,1.781E+01,1.854E+01,1.919E+01,1.980E+01,2.029E+01,2.089E+01,2.146E+01,2.202E+01,2.260E+01,&
	2.313E+01,2.360E+01,2.407E+01,2.450E+01,2.493E+01,2.533E+01,2.571E+01,2.606E+01,2.641E+01,2.673E+01,&
	2.701E+01,2.729E+01,2.756E+01,2.782E+01,2.806E+01,2.835E+01,2.856E+01,2.875E+01,2.892E+01,2.908E+01,&
	2.926E+01,2.940E+01,2.956E+01,2.966E+01,2.982E+01,2.993E+01,3.003E+01,3.014E+01,3.023E+01,3.029E+01,&
	3.036E+01,3.042E+01,3.046E+01,3.049E+01,3.052E+01,3.053E+01,3.055E+01,3.056E+01,3.056E+01,3.055E+01,&
	3.054E+01,3.051E+01,3.049E+01,3.045E+01,3.041E+01,3.035E+01,3.029E+01,3.023E+01,3.014E+01,3.006E+01,&
	2.998E+01,2.983E+01,2.971E+01,2.957E+01,2.936E+01,2.917E+01,2.899E+01,2.872E+01,2.851E+01,2.829E+01,&
	2.800E+01,2.777E+01,2.754E+01,2.722E+01,2.699E+01,2.664E+01,2.638E+01,2.611E+01,2.581E+01,2.555E+01,&
	2.522E+01,2.497E+01,2.468E+01,2.443E+01,2.413E+01,2.388E+01,2.364E+01,2.332E+01,2.307E+01,2.274E+01,&
	2.250E+01,2.218E+01,2.193E+01,2.163E+01,2.139E+01,2.107E+01,2.082E+01,2.052E+01,2.025E+01,2.001E+01/

      DATA (k_Cw(i),i=1101,1200)/&
	1.972E+01,1.951E+01,1.924E+01,1.900E+01,1.874E+01,1.847E+01,1.827E+01,1.802E+01,1.784E+01,1.758E+01,&
	1.734E+01,1.712E+01,1.688E+01,1.671E+01,1.647E+01,1.623E+01,1.606E+01,1.583E+01,1.562E+01,1.545E+01,&
	1.525E+01,1.504E+01,1.489E+01,1.468E+01,1.447E+01,1.432E+01,1.413E+01,1.395E+01,1.381E+01,1.364E+01,&
	1.348E+01,1.329E+01,1.316E+01,1.298E+01,1.282E+01,1.265E+01,1.254E+01,1.238E+01,1.223E+01,1.206E+01,&
	1.193E+01,1.181E+01,1.166E+01,1.152E+01,1.137E+01,1.126E+01,1.114E+01,1.100E+01,1.088E+01,1.075E+01,&
	1.064E+01,1.054E+01,1.044E+01,1.032E+01,1.022E+01,1.011E+01,1.001E+01,9.912E+00,9.839E+00,9.754E+00,&
	9.660E+00,9.563E+00,9.477E+00,9.383E+00,9.305E+00,9.202E+00,9.133E+00,9.047E+00,8.977E+00,8.898E+00,&
	8.820E+00,8.742E+00,8.665E+00,8.588E+00,8.509E+00,8.448E+00,8.364E+00,8.295E+00,8.234E+00,8.157E+00,&
	8.104E+00,8.036E+00,7.959E+00,7.890E+00,7.834E+00,7.773E+00,7.712E+00,7.654E+00,7.609E+00,7.548E+00,&
	7.495E+00,7.432E+00,7.374E+00,7.315E+00,7.252E+00,7.203E+00,7.164E+00,7.124E+00,7.084E+00,7.041E+00/

      DATA (k_Cw(i),i=1201,1300)/&
	6.987E+00,6.943E+00,6.910E+00,6.865E+00,6.828E+00,6.776E+00,6.742E+00,6.714E+00,6.695E+00,6.654E+00,&
	6.630E+00,6.599E+00,6.567E+00,6.526E+00,6.501E+00,6.474E+00,6.449E+00,6.420E+00,6.401E+00,6.363E+00,&
	6.345E+00,6.309E+00,6.282E+00,6.250E+00,6.214E+00,6.186E+00,6.163E+00,6.130E+00,6.121E+00,6.091E+00,&
	6.076E+00,6.053E+00,6.048E+00,6.016E+00,6.005E+00,5.982E+00,5.973E+00,5.947E+00,5.940E+00,5.919E+00,&
	5.911E+00,5.887E+00,5.875E+00,5.846E+00,5.826E+00,5.798E+00,5.787E+00,5.751E+00,5.746E+00,5.718E+00,&
	5.705E+00,5.685E+00,5.684E+00,5.657E+00,5.658E+00,5.644E+00,5.648E+00,5.626E+00,5.626E+00,5.619E+00,&
	5.618E+00,5.603E+00,5.614E+00,5.597E+00,5.603E+00,5.582E+00,5.584E+00,5.564E+00,5.563E+00,5.547E+00,&
	5.545E+00,5.536E+00,5.542E+00,5.529E+00,5.532E+00,5.525E+00,5.533E+00,5.528E+00,5.529E+00,5.516E+00,&
	5.524E+00,5.516E+00,5.526E+00,5.520E+00,5.520E+00,5.516E+00,5.522E+00,5.511E+00,5.527E+00,5.511E+00,&
	5.519E+00,5.515E+00,5.520E+00,5.510E+00,5.518E+00,5.523E+00,5.538E+00,5.535E+00,5.544E+00,5.557E+00/

      DATA (k_Cw(i),i=1301,1400)/&
	5.571E+00,5.583E+00,5.606E+00,5.607E+00,5.629E+00,5.636E+00,5.664E+00,5.670E+00,5.693E+00,5.702E+00,&
	5.733E+00,5.752E+00,5.766E+00,5.776E+00,5.797E+00,5.811E+00,5.829E+00,5.842E+00,5.877E+00,5.891E+00,&
	5.930E+00,5.945E+00,5.972E+00,5.999E+00,6.025E+00,6.051E+00,6.087E+00,6.096E+00,6.136E+00,6.166E+00,&
	6.198E+00,6.219E+00,6.256E+00,6.284E+00,6.335E+00,6.369E+00,6.392E+00,6.445E+00,6.493E+00,6.517E+00,&
	6.571E+00,6.617E+00,6.658E+00,6.689E+00,6.748E+00,6.796E+00,6.842E+00,6.897E+00,6.955E+00,7.003E+00,&
	7.054E+00,7.111E+00,7.179E+00,7.235E+00,7.274E+00,7.339E+00,7.414E+00,7.481E+00,7.536E+00,7.594E+00,&
	7.669E+00,7.734E+00,7.776E+00,7.833E+00,7.893E+00,7.952E+00,8.000E+00,8.045E+00,8.103E+00,8.155E+00,&
	8.205E+00,8.241E+00,8.264E+00,8.321E+00,8.352E+00,8.394E+00,8.430E+00,8.448E+00,8.477E+00,8.512E+00,&
	8.535E+00,8.562E+00,8.593E+00,8.618E+00,8.640E+00,8.670E+00,8.689E+00,8.720E+00,8.738E+00,8.755E+00,&
	8.777E+00,8.778E+00,8.778E+00,8.794E+00,8.805E+00,8.807E+00,8.809E+00,8.811E+00,8.799E+00,8.795E+00/

      DATA (k_Cw(i),i=1401,1500)/&
	8.789E+00,8.779E+00,8.767E+00,8.754E+00,8.750E+00,8.738E+00,8.739E+00,8.735E+00,8.744E+00,8.753E+00,&
	8.755E+00,8.780E+00,8.787E+00,8.790E+00,8.798E+00,8.794E+00,8.811E+00,8.820E+00,8.836E+00,8.845E+00,&
	8.854E+00,8.858E+00,8.868E+00,8.869E+00,8.884E+00,8.888E+00,8.900E+00,8.922E+00,8.951E+00,8.973E+00,&
	9.010E+00,9.034E+00,9.110E+00,9.146E+00,9.195E+00,9.259E+00,9.315E+00,9.380E+00,9.457E+00,9.535E+00,&
	9.633E+00,9.723E+00,9.824E+00,9.935E+00,1.005E+01,1.018E+01,1.031E+01,1.042E+01,1.059E+01,1.075E+01,&
	1.094E+01,1.110E+01,1.139E+01,1.160E+01,1.184E+01,1.208E+01,1.235E+01,1.266E+01,1.301E+01,1.334E+01,&
	1.375E+01,1.412E+01,1.478E+01,1.529E+01,1.586E+01,1.641E+01,1.709E+01,1.774E+01,1.853E+01,1.925E+01,&
	2.051E+01,2.148E+01,2.250E+01,2.367E+01,2.483E+01,2.622E+01,2.751E+01,2.972E+01,3.144E+01,3.317E+01,&
	3.504E+01,3.725E+01,3.927E+01,4.269E+01,4.530E+01,4.789E+01,5.060E+01,5.360E+01,5.761E+01,6.088E+01,&
	6.401E+01,6.720E+01,7.059E+01,7.497E+01,7.841E+01,8.157E+01,8.469E+01,8.752E+01,9.189E+01,9.456E+01/

      DATA (k_Cw(i),i=1501,1600)/&
	9.722E+01,9.995E+01,1.033E+02,1.057E+02,1.078E+02,1.097E+02,1.123E+02,1.140E+02,1.157E+02,1.171E+02,&
	1.190E+02,1.203E+02,1.215E+02,1.226E+02,1.240E+02,1.248E+02,1.257E+02,1.265E+02,1.275E+02,1.281E+02,&
	1.286E+02,1.292E+02,1.296E+02,1.299E+02,1.303E+02,1.304E+02,1.306E+02,1.306E+02,1.306E+02,1.305E+02,&
	1.304E+02,1.301E+02,1.299E+02,1.296E+02,1.291E+02,1.287E+02,1.282E+02,1.275E+02,1.270E+02,1.264E+02,&
	1.256E+02,1.249E+02,1.242E+02,1.232E+02,1.224E+02,1.216E+02,1.206E+02,1.197E+02,1.190E+02,1.178E+02,&
	1.170E+02,1.157E+02,1.149E+02,1.140E+02,1.128E+02,1.118E+02,1.110E+02,1.097E+02,1.088E+02,1.076E+02,&
	1.066E+02,1.058E+02,1.044E+02,1.036E+02,1.023E+02,1.014E+02,1.005E+02,9.928E+01,9.831E+01,9.711E+01,&
	9.631E+01,9.488E+01,9.412E+01,9.341E+01,9.206E+01,9.121E+01,9.009E+01,8.929E+01,8.804E+01,8.725E+01,&
	8.611E+01,8.532E+01,8.460E+01,8.336E+01,8.262E+01,8.151E+01,8.076E+01,7.973E+01,7.904E+01,7.800E+01,&
	7.723E+01,7.628E+01,7.557E+01,7.463E+01,7.392E+01,7.298E+01,7.234E+01,7.141E+01,7.082E+01,6.986E+01/

      DATA (k_Cw(i),i=1601,1700)/&
	6.924E+01,6.865E+01,6.779E+01,6.688E+01,6.634E+01,6.548E+01,6.490E+01,6.412E+01,6.358E+01,6.281E+01,&
	6.232E+01,6.156E+01,6.105E+01,6.029E+01,5.980E+01,5.907E+01,5.857E+01,5.788E+01,5.746E+01,5.680E+01,&
	5.632E+01,5.566E+01,5.503E+01,5.463E+01,5.398E+01,5.356E+01,5.294E+01,5.256E+01,5.197E+01,5.138E+01,&
	5.098E+01,5.047E+01,5.006E+01,4.951E+01,4.915E+01,4.860E+01,4.806E+01,4.773E+01,4.718E+01,4.685E+01,&
	4.635E+01,4.584E+01,4.553E+01,4.503E+01,4.473E+01,4.426E+01,4.379E+01,4.348E+01,4.302E+01,4.273E+01,&
	4.228E+01,4.186E+01,4.155E+01,4.115E+01,4.072E+01,4.046E+01,4.002E+01,3.975E+01,3.934E+01,3.894E+01,&
	3.868E+01,3.827E+01,3.790E+01,3.762E+01,3.726E+01,3.687E+01,3.664E+01,3.628E+01,3.592E+01,3.568E+01,&
	3.536E+01,3.499E+01,3.479E+01,3.447E+01,3.413E+01,3.392E+01,3.363E+01,3.329E+01,3.309E+01,3.280E+01,&
	3.251E+01,3.231E+01,3.200E+01,3.172E+01,3.154E+01,3.127E+01,3.097E+01,3.071E+01,3.052E+01,3.025E+01,&
	2.999E+01,2.980E+01,2.958E+01,2.929E+01,2.906E+01,2.888E+01,2.865E+01,2.840E+01,2.822E+01,2.799E+01/

      DATA (k_Cw(i),i=1701,1800)/&
	2.776E+01,2.751E+01,2.737E+01,2.713E+01,2.692E+01,2.671E+01,2.657E+01,2.637E+01,2.617E+01,2.597E+01,&
	2.584E+01,2.565E+01,2.547E+01,2.528E+01,2.518E+01,2.501E+01,2.485E+01,2.466E+01,2.455E+01,2.438E+01,&
	2.420E+01,2.401E+01,2.386E+01,2.374E+01,2.358E+01,2.342E+01,2.328E+01,2.318E+01,2.304E+01,2.289E+01,&
	2.275E+01,2.262E+01,2.252E+01,2.239E+01,2.227E+01,2.214E+01,2.202E+01,2.194E+01,2.183E+01,2.172E+01,&
	2.162E+01,2.150E+01,2.140E+01,2.133E+01,2.123E+01,2.112E+01,2.102E+01,2.091E+01,2.085E+01,2.077E+01,&
	2.067E+01,2.058E+01,2.049E+01,2.040E+01,2.033E+01,2.027E+01,2.018E+01,2.010E+01,2.002E+01,1.995E+01,&
	1.987E+01,1.983E+01,1.976E+01,1.969E+01,1.963E+01,1.958E+01,1.952E+01,1.946E+01,1.942E+01,1.938E+01,&
	1.933E+01,1.928E+01,1.923E+01,1.918E+01,1.913E+01,1.909E+01,1.904E+01,1.900E+01,1.896E+01,1.889E+01,&
	1.884E+01,1.880E+01,1.874E+01,1.870E+01,1.866E+01,1.860E+01,1.856E+01,1.852E+01,1.849E+01,1.845E+01,&
	1.843E+01,1.839E+01,1.837E+01,1.837E+01,1.838E+01,1.837E+01,1.836E+01,1.835E+01,1.835E+01,1.835E+01/

      DATA (k_Cw(i),i=1801,1900)/&
	1.834E+01,1.833E+01,1.833E+01,1.833E+01,1.834E+01,1.833E+01,1.834E+01,1.834E+01,1.832E+01,1.831E+01,&
	1.829E+01,1.828E+01,1.828E+01,1.829E+01,1.829E+01,1.830E+01,1.832E+01,1.835E+01,1.836E+01,1.837E+01,&
	1.837E+01,1.838E+01,1.837E+01,1.840E+01,1.842E+01,1.843E+01,1.846E+01,1.849E+01,1.851E+01,1.854E+01,&
	1.857E+01,1.858E+01,1.860E+01,1.864E+01,1.865E+01,1.867E+01,1.870E+01,1.875E+01,1.879E+01,1.883E+01,&
	1.888E+01,1.893E+01,1.897E+01,1.903E+01,1.908E+01,1.913E+01,1.919E+01,1.924E+01,1.929E+01,1.934E+01,&
	1.940E+01,1.946E+01,1.951E+01,1.961E+01,1.966E+01,1.973E+01,1.980E+01,1.985E+01,1.991E+01,1.997E+01,&
	2.004E+01,2.013E+01,2.020E+01,2.027E+01,2.038E+01,2.046E+01,2.054E+01,2.062E+01,2.071E+01,2.079E+01,&
	2.087E+01,2.094E+01,2.103E+01,2.111E+01,2.126E+01,2.135E+01,2.145E+01,2.153E+01,2.164E+01,2.174E+01,&
	2.183E+01,2.192E+01,2.202E+01,2.212E+01,2.223E+01,2.234E+01,2.245E+01,2.264E+01,2.276E+01,2.287E+01,&
	2.301E+01,2.313E+01,2.327E+01,2.338E+01,2.351E+01,2.363E+01,2.377E+01,2.385E+01,2.409E+01,2.418E+01/

      DATA (k_Cw(i),i=1901,2000)/&
	2.433E+01,2.444E+01,2.459E+01,2.470E+01,2.485E+01,2.495E+01,2.523E+01,2.534E+01,2.549E+01,2.564E+01,&
	2.579E+01,2.592E+01,2.611E+01,2.623E+01,2.653E+01,2.664E+01,2.681E+01,2.695E+01,2.712E+01,2.727E+01,&
	2.744E+01,2.756E+01,2.789E+01,2.802E+01,2.819E+01,2.838E+01,2.855E+01,2.869E+01,2.903E+01,2.916E+01,&
	2.934E+01,2.951E+01,2.969E+01,2.988E+01,3.002E+01,3.038E+01,3.054E+01,3.073E+01,3.092E+01,3.107E+01,&
	3.145E+01,3.160E+01,3.180E+01,3.199E+01,3.219E+01,3.238E+01,3.272E+01,3.290E+01,3.311E+01,3.331E+01,&
	3.348E+01,3.388E+01,3.404E+01,3.426E+01,3.447E+01,3.468E+01,3.486E+01,3.528E+01,3.547E+01,3.570E+01,&
	3.592E+01,3.610E+01,3.656E+01,3.675E+01,3.697E+01,3.716E+01,3.761E+01,3.777E+01,3.801E+01,3.827E+01,&
	3.848E+01,3.892E+01,3.913E+01,3.938E+01,3.957E+01,4.007E+01,4.024E+01,4.050E+01,4.078E+01,4.096E+01,&
	4.147E+01,4.167E+01,4.196E+01,4.220E+01,4.268E+01,4.293E+01,4.319E+01,4.342E+01,4.388E+01,4.413E+01,&
	4.439E+01,4.464E+01,4.513E+01,4.538E+01,4.565E+01,4.590E+01,4.638E+01,4.663E+01,4.690E+01,4.714E+01/

		DATA (k_Cw(i),i=2001,2101)/&
	4.764E+01,4.787E+01,4.817E+01,4.836E+01,4.894E+01,4.917E+01,4.940E+01,4.997E+01,5.021E+01,5.050E+01,&
	5.078E+01,5.131E+01,5.159E+01,5.191E+01,5.246E+01,5.275E+01,5.310E+01,5.339E+01,5.401E+01,5.429E+01,&
	5.462E+01,5.523E+01,5.555E+01,5.588E+01,5.618E+01,5.686E+01,5.713E+01,5.746E+01,5.808E+01,5.841E+01,&
	5.878E+01,5.946E+01,5.976E+01,6.009E+01,6.039E+01,6.107E+01,6.146E+01,6.180E+01,6.250E+01,6.286E+01,&
	6.316E+01,6.392E+01,6.427E+01,6.462E+01,6.539E+01,6.574E+01,6.609E+01,6.685E+01,6.725E+01,6.759E+01,&
	6.842E+01,6.881E+01,6.918E+01,7.009E+01,7.046E+01,7.084E+01,7.174E+01,7.212E+01,7.249E+01,7.340E+01,&
	7.381E+01,7.423E+01,7.514E+01,7.554E+01,7.591E+01,7.675E+01,7.718E+01,7.801E+01,7.839E+01,7.880E+01,&
	7.970E+01,8.005E+01,8.046E+01,8.136E+01,8.173E+01,8.215E+01,8.295E+01,8.338E+01,8.423E+01,8.474E+01,&
	8.510E+01,8.584E+01,8.617E+01,8.637E+01,8.708E+01,8.762E+01,8.884E+01,8.904E+01,8.945E+01,9.055E+01,&
	9.089E+01,9.134E+01,9.204E+01,9.244E+01,9.308E+01,9.333E+01,9.358E+01,9.416E+01,9.448E+01,9.499E+01,&
	9.530E+01/


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				specific absorption of dry matter					!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (k_Cm(i),i=1,100)/&
	1.097E+02,1.037E+02,9.798E+01,9.244E+01,8.713E+01,8.231E+01,7.806E+01,7.404E+01,7.013E+01,6.654E+01,&
	6.300E+01,5.954E+01,5.616E+01,5.301E+01,5.001E+01,4.723E+01,4.463E+01,4.220E+01,3.996E+01,3.780E+01,&
	3.567E+01,3.362E+01,3.170E+01,2.993E+01,2.832E+01,2.679E+01,2.535E+01,2.402E+01,2.276E+01,2.150E+01,&
	2.024E+01,1.901E+01,1.785E+01,1.676E+01,1.575E+01,1.481E+01,1.392E+01,1.312E+01,1.233E+01,1.161E+01,&
	1.096E+01,1.041E+01,9.924E+00,9.410E+00,8.947E+00,8.508E+00,8.087E+00,7.640E+00,7.269E+00,6.939E+00,&
	6.660E+00,6.422E+00,6.222E+00,6.010E+00,5.782E+00,5.573E+00,5.370E+00,5.173E+00,4.946E+00,4.761E+00,&
	4.575E+00,4.419E+00,4.259E+00,4.117E+00,4.006E+00,3.945E+00,3.853E+00,3.784E+00,3.671E+00,3.554E+00,&
	3.462E+00,3.364E+00,3.282E+00,3.184E+00,3.102E+00,3.051E+00,2.983E+00,2.947E+00,2.913E+00,2.869E+00,&
	2.803E+00,2.777E+00,2.751E+00,2.726E+00,2.702E+00,2.679E+00,2.656E+00,2.634E+00,2.613E+00,2.593E+00,&
	2.573E+00,2.554E+00,2.536E+00,2.519E+00,2.502E+00,2.486E+00,2.471E+00,2.457E+00,2.443E+00,2.430E+00/

		DATA (k_Cm(i),i=101,200)/&
	2.417E+00,2.405E+00,2.394E+00,2.384E+00,2.374E+00,2.365E+00,2.356E+00,2.348E+00,2.341E+00,2.334E+00,&
	2.328E+00,2.323E+00,2.318E+00,2.314E+00,2.310E+00,2.307E+00,2.304E+00,2.303E+00,2.301E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00/

		DATA (k_Cm(i),i=201,300)/&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00/

		DATA (k_Cm(i),i=301,400)/&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00/

		DATA (k_Cm(i),i=401,500)/&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00/
		
		DATA (k_Cm(i),i=501,600)/&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00/

		DATA (k_Cm(i),i=601,700)/&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00/

		DATA (k_Cm(i),i=701,800)/&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,&
	2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00,2.300E+00/

		DATA (k_Cm(i),i=801,900)/&
	2.300E+00,2.300E+00,2.301E+00,2.301E+00,2.302E+00,2.303E+00,2.305E+00,2.306E+00,2.308E+00,2.310E+00,&
	2.312E+00,2.315E+00,2.318E+00,2.320E+00,2.323E+00,2.327E+00,2.330E+00,2.334E+00,2.338E+00,2.342E+00,&
	2.346E+00,2.350E+00,2.354E+00,2.359E+00,2.364E+00,2.369E+00,2.374E+00,2.379E+00,2.384E+00,2.389E+00,&
	2.395E+00,2.400E+00,2.406E+00,2.412E+00,2.418E+00,2.424E+00,2.430E+00,2.436E+00,2.442E+00,2.448E+00,&
	2.454E+00,2.461E+00,2.467E+00,2.473E+00,2.480E+00,2.486E+00,2.493E+00,2.499E+00,2.506E+00,2.512E+00,&
	2.519E+00,2.525E+00,2.532E+00,2.538E+00,2.545E+00,2.551E+00,2.558E+00,2.564E+00,2.570E+00,2.577E+00,&
	2.583E+00,2.589E+00,2.595E+00,2.601E+00,2.607E+00,2.613E+00,2.619E+00,2.625E+00,2.631E+00,2.636E+00,&
	2.642E+00,2.647E+00,2.652E+00,2.657E+00,2.662E+00,2.667E+00,2.672E+00,2.677E+00,2.681E+00,2.685E+00,&
	2.689E+00,2.693E+00,2.697E+00,2.701E+00,2.704E+00,2.708E+00,2.711E+00,2.714E+00,2.716E+00,2.719E+00,&
	2.721E+00,2.723E+00,2.725E+00,2.726E+00,2.728E+00,2.729E+00,2.730E+00,2.730E+00,2.731E+00,2.731E+00/

		DATA (k_Cm(i),i=901,1000)/&
	2.721E+00,2.736E+00,2.728E+00,2.719E+00,2.712E+00,2.698E+00,2.702E+00,2.691E+00,2.688E+00,2.686E+00,&
	2.682E+00,2.676E+00,2.675E+00,2.677E+00,2.670E+00,2.671E+00,2.668E+00,2.670E+00,2.674E+00,2.674E+00,&
	2.683E+00,2.674E+00,2.675E+00,2.682E+00,2.683E+00,2.665E+00,2.661E+00,2.668E+00,2.670E+00,2.674E+00,&
	2.664E+00,2.661E+00,2.665E+00,2.668E+00,2.681E+00,2.686E+00,2.684E+00,2.697E+00,2.712E+00,2.720E+00,&
	2.717E+00,2.726E+00,2.744E+00,2.743E+00,2.751E+00,2.763E+00,2.778E+00,2.793E+00,2.818E+00,2.835E+00,&
	2.865E+00,2.879E+00,2.899E+00,2.918E+00,2.936E+00,2.953E+00,2.966E+00,2.977E+00,2.981E+00,2.942E+00,&
	2.888E+00,2.864E+00,2.877E+00,2.886E+00,2.888E+00,2.891E+00,2.899E+00,2.887E+00,2.884E+00,2.900E+00,&
	2.929E+00,2.969E+00,3.014E+00,3.053E+00,3.075E+00,3.111E+00,3.128E+00,3.130E+00,3.103E+00,3.051E+00,&
	2.980E+00,2.941E+00,2.920E+00,2.931E+00,2.950E+00,2.979E+00,3.025E+00,3.048E+00,3.066E+00,3.087E+00,&
	3.099E+00,3.090E+00,3.088E+00,3.081E+00,3.086E+00,3.071E+00,3.065E+00,3.069E+00,3.067E+00,3.085E+00/

		DATA (k_Cm(i),i=1001,1100)/&
	3.094E+00,3.110E+00,3.136E+00,3.149E+00,3.158E+00,3.191E+00,3.230E+00,3.266E+00,3.298E+00,3.356E+00,&
	3.419E+00,3.476E+00,3.534E+00,3.584E+00,3.632E+00,3.708E+00,3.775E+00,3.847E+00,3.931E+00,3.987E+00,&
	4.071E+00,4.156E+00,4.242E+00,4.320E+00,4.395E+00,4.480E+00,4.561E+00,4.638E+00,4.708E+00,4.782E+00,&
	4.846E+00,4.906E+00,4.974E+00,5.026E+00,5.071E+00,5.131E+00,5.179E+00,5.220E+00,5.271E+00,5.322E+00,&
	5.358E+00,5.403E+00,5.441E+00,5.460E+00,5.481E+00,5.500E+00,5.523E+00,5.548E+00,5.560E+00,5.575E+00,&
	5.582E+00,5.597E+00,5.611E+00,5.639E+00,5.653E+00,5.675E+00,5.682E+00,5.685E+00,5.680E+00,5.689E+00,&
	5.711E+00,5.723E+00,5.715E+00,5.716E+00,5.732E+00,5.741E+00,5.743E+00,5.752E+00,5.745E+00,5.744E+00,&
	5.757E+00,5.766E+00,5.781E+00,5.787E+00,5.798E+00,5.810E+00,5.808E+00,5.815E+00,5.825E+00,5.824E+00,&
	5.827E+00,5.854E+00,5.878E+00,5.900E+00,5.908E+00,5.922E+00,5.940E+00,5.962E+00,5.963E+00,5.966E+00,&
	5.982E+00,5.990E+00,5.994E+00,6.016E+00,6.014E+00,6.025E+00,6.008E+00,6.022E+00,6.021E+00,6.027E+00/

		DATA (k_Cm(i),i=1101,1200)/&
	6.027E+00,6.035E+00,6.025E+00,6.009E+00,5.990E+00,5.987E+00,5.984E+00,5.971E+00,5.971E+00,5.973E+00,&
	5.951E+00,5.952E+00,5.939E+00,5.933E+00,5.931E+00,5.925E+00,5.909E+00,5.897E+00,5.884E+00,5.881E+00,&
	5.876E+00,5.856E+00,5.843E+00,5.830E+00,5.818E+00,5.807E+00,5.799E+00,5.792E+00,5.776E+00,5.783E+00,&
	5.776E+00,5.767E+00,5.762E+00,5.769E+00,5.756E+00,5.762E+00,5.737E+00,5.740E+00,5.757E+00,5.756E+00,&
	5.751E+00,5.754E+00,5.751E+00,5.750E+00,5.744E+00,5.744E+00,5.754E+00,5.744E+00,5.735E+00,5.740E+00,&
	5.732E+00,5.728E+00,5.731E+00,5.724E+00,5.724E+00,5.715E+00,5.697E+00,5.693E+00,5.703E+00,5.700E+00,&
	5.713E+00,5.728E+00,5.731E+00,5.735E+00,5.743E+00,5.754E+00,5.753E+00,5.744E+00,5.746E+00,5.746E+00,&
	5.746E+00,5.750E+00,5.749E+00,5.743E+00,5.740E+00,5.747E+00,5.739E+00,5.755E+00,5.749E+00,5.753E+00,&
	5.745E+00,5.732E+00,5.735E+00,5.724E+00,5.725E+00,5.712E+00,5.702E+00,5.700E+00,5.700E+00,5.686E+00,&
	5.685E+00,5.672E+00,5.659E+00,5.627E+00,5.613E+00,5.590E+00,5.591E+00,5.563E+00,5.552E+00,5.525E+00/

		DATA (k_Cm(i),i=1201,1300)/&
	5.517E+00,5.506E+00,5.494E+00,5.459E+00,5.450E+00,5.438E+00,5.428E+00,5.407E+00,5.391E+00,5.382E+00,&
	5.376E+00,5.358E+00,5.347E+00,5.333E+00,5.319E+00,5.301E+00,5.292E+00,5.284E+00,5.274E+00,5.258E+00,&
	5.253E+00,5.249E+00,5.233E+00,5.222E+00,5.211E+00,5.204E+00,5.210E+00,5.200E+00,5.193E+00,5.186E+00,&
	5.177E+00,5.175E+00,5.178E+00,5.173E+00,5.152E+00,5.135E+00,5.139E+00,5.128E+00,5.121E+00,5.114E+00,&
	5.126E+00,5.107E+00,5.104E+00,5.100E+00,5.109E+00,5.114E+00,5.112E+00,5.128E+00,5.137E+00,5.131E+00,&
	5.152E+00,5.175E+00,5.194E+00,5.200E+00,5.244E+00,5.257E+00,5.273E+00,5.289E+00,5.335E+00,5.366E+00,&
	5.389E+00,5.427E+00,5.453E+00,5.490E+00,5.522E+00,5.562E+00,5.605E+00,5.652E+00,5.698E+00,5.744E+00,&
	5.743E+00,5.642E+00,5.689E+00,5.722E+00,5.755E+00,5.798E+00,5.848E+00,5.875E+00,5.918E+00,5.971E+00,&
	6.022E+00,6.061E+00,6.116E+00,6.173E+00,6.214E+00,6.266E+00,6.319E+00,6.382E+00,6.426E+00,6.486E+00,&
	6.542E+00,6.579E+00,6.616E+00,6.666E+00,6.728E+00,6.771E+00,6.807E+00,6.858E+00,6.908E+00,6.959E+00/

		DATA (k_Cm(i),i=1301,1400)/&
	7.006E+00,7.052E+00,7.093E+00,7.136E+00,7.164E+00,7.199E+00,7.232E+00,7.266E+00,7.315E+00,7.340E+00,&
	7.361E+00,7.399E+00,7.440E+00,7.473E+00,7.505E+00,7.525E+00,7.557E+00,7.579E+00,7.604E+00,7.633E+00,&
	7.653E+00,7.674E+00,7.691E+00,7.699E+00,7.708E+00,7.721E+00,7.730E+00,7.729E+00,7.712E+00,7.702E+00,&
	7.695E+00,7.670E+00,7.644E+00,7.618E+00,7.585E+00,7.555E+00,7.517E+00,7.479E+00,7.451E+00,7.435E+00,&
	7.408E+00,7.379E+00,7.363E+00,7.347E+00,7.332E+00,7.332E+00,7.332E+00,7.304E+00,7.295E+00,7.296E+00,&
	7.291E+00,7.292E+00,7.292E+00,7.281E+00,7.283E+00,7.264E+00,7.250E+00,7.240E+00,7.228E+00,7.210E+00,&
	7.186E+00,7.164E+00,7.143E+00,7.114E+00,7.101E+00,7.069E+00,7.038E+00,7.003E+00,6.974E+00,6.928E+00,&
	6.889E+00,6.839E+00,6.793E+00,6.764E+00,6.729E+00,6.694E+00,6.662E+00,6.613E+00,6.572E+00,6.546E+00,&
	6.522E+00,6.507E+00,6.482E+00,6.484E+00,6.479E+00,6.494E+00,6.496E+00,6.491E+00,6.461E+00,6.440E+00,&
	6.430E+00,6.413E+00,6.421E+00,6.399E+00,6.379E+00,6.365E+00,6.372E+00,6.346E+00,6.321E+00,6.310E+00/

		DATA (k_Cm(i),i=1401,1500)/&
	6.314E+00,6.282E+00,6.277E+00,6.270E+00,6.258E+00,6.242E+00,6.234E+00,6.221E+00,6.231E+00,6.221E+00,&
	6.205E+00,6.193E+00,6.192E+00,6.179E+00,6.159E+00,6.143E+00,6.143E+00,6.120E+00,6.098E+00,6.087E+00,&
	6.063E+00,6.056E+00,6.053E+00,6.040E+00,6.044E+00,6.007E+00,5.996E+00,5.994E+00,5.997E+00,5.975E+00,&
	5.954E+00,5.946E+00,5.927E+00,5.914E+00,5.890E+00,5.873E+00,5.832E+00,5.794E+00,5.768E+00,5.728E+00,&
	5.681E+00,5.680E+00,5.655E+00,5.648E+00,5.620E+00,5.594E+00,5.567E+00,5.557E+00,5.552E+00,5.553E+00,&
	5.539E+00,5.524E+00,5.507E+00,5.505E+00,5.487E+00,5.474E+00,5.462E+00,5.450E+00,5.448E+00,5.441E+00,&
	5.440E+00,5.442E+00,5.450E+00,5.466E+00,5.461E+00,5.452E+00,5.445E+00,5.412E+00,5.379E+00,5.280E+00,&
	5.228E+00,5.199E+00,5.171E+00,5.139E+00,5.124E+00,5.112E+00,5.129E+00,5.145E+00,5.173E+00,5.176E+00,&
	5.185E+00,5.183E+00,5.200E+00,5.202E+00,5.204E+00,5.224E+00,5.244E+00,5.297E+00,5.318E+00,5.376E+00,&
	5.441E+00,5.491E+00,5.561E+00,5.629E+00,5.687E+00,5.757E+00,5.830E+00,5.911E+00,5.998E+00,6.090E+00/

		DATA (k_Cm(i),i=1501,1600)/&
	6.193E+00,6.330E+00,6.449E+00,6.581E+00,6.710E+00,6.838E+00,6.970E+00,7.107E+00,7.238E+00,7.388E+00,&
	7.506E+00,7.635E+00,7.767E+00,7.874E+00,7.977E+00,8.071E+00,8.150E+00,8.220E+00,8.292E+00,8.350E+00,&
	8.449E+00,8.521E+00,8.583E+00,8.666E+00,8.723E+00,8.759E+00,8.821E+00,8.864E+00,8.909E+00,8.941E+00,&
	8.949E+00,8.955E+00,8.983E+00,9.022E+00,9.043E+00,9.044E+00,9.028E+00,9.034E+00,9.052E+00,9.048E+00,&
	9.041E+00,9.037E+00,9.036E+00,9.035E+00,9.021E+00,9.016E+00,9.008E+00,8.970E+00,8.974E+00,8.953E+00,&
	8.957E+00,8.937E+00,8.923E+00,8.912E+00,8.895E+00,8.891E+00,8.880E+00,8.867E+00,8.855E+00,8.852E+00,&
	8.861E+00,8.864E+00,8.876E+00,8.869E+00,8.873E+00,8.855E+00,8.828E+00,8.839E+00,8.855E+00,8.856E+00,&
	8.833E+00,8.842E+00,8.844E+00,8.830E+00,8.808E+00,8.818E+00,8.807E+00,8.797E+00,8.794E+00,8.791E+00,&
	8.795E+00,8.772E+00,8.754E+00,8.759E+00,8.760E+00,8.746E+00,8.762E+00,8.778E+00,8.790E+00,8.795E+00,&
	8.811E+00,8.848E+00,8.874E+00,8.885E+00,8.913E+00,8.944E+00,8.981E+00,8.988E+00,9.001E+00,9.034E+00/

		DATA (k_Cm(i),i=1601,1700)/&
	9.076E+00,9.111E+00,9.141E+00,9.171E+00,9.214E+00,9.255E+00,9.304E+00,9.356E+00,9.406E+00,9.448E+00,&
	9.516E+00,9.578E+00,9.638E+00,9.692E+00,9.763E+00,9.845E+00,9.953E+00,1.004E+01,1.015E+01,1.027E+01,&
	1.039E+01,1.052E+01,1.063E+01,1.077E+01,1.091E+01,1.103E+01,1.119E+01,1.135E+01,1.150E+01,1.166E+01,&
	1.181E+01,1.201E+01,1.217E+01,1.235E+01,1.251E+01,1.269E+01,1.287E+01,1.307E+01,1.325E+01,1.346E+01,&
	1.364E+01,1.384E+01,1.404E+01,1.423E+01,1.441E+01,1.461E+01,1.481E+01,1.499E+01,1.518E+01,1.534E+01,&
	1.554E+01,1.571E+01,1.591E+01,1.607E+01,1.622E+01,1.637E+01,1.653E+01,1.667E+01,1.678E+01,1.690E+01,&
	1.698E+01,1.709E+01,1.718E+01,1.725E+01,1.734E+01,1.739E+01,1.748E+01,1.755E+01,1.761E+01,1.767E+01,&
	1.771E+01,1.777E+01,1.783E+01,1.787E+01,1.794E+01,1.795E+01,1.799E+01,1.805E+01,1.809E+01,1.813E+01,&
	1.820E+01,1.827E+01,1.830E+01,1.835E+01,1.841E+01,1.846E+01,1.852E+01,1.856E+01,1.861E+01,1.866E+01,&
	1.871E+01,1.876E+01,1.881E+01,1.885E+01,1.890E+01,1.896E+01,1.903E+01,1.907E+01,1.911E+01,1.916E+01/

		DATA (k_Cm(i),i=1701,1800)/&
	1.921E+01,1.927E+01,1.929E+01,1.932E+01,1.935E+01,1.936E+01,1.940E+01,1.943E+01,1.947E+01,1.951E+01,&
	1.953E+01,1.956E+01,1.960E+01,1.961E+01,1.962E+01,1.966E+01,1.966E+01,1.969E+01,1.970E+01,1.972E+01,&
	1.974E+01,1.974E+01,1.976E+01,1.978E+01,1.979E+01,1.982E+01,1.982E+01,1.983E+01,1.986E+01,1.988E+01,&
	1.989E+01,1.989E+01,1.993E+01,1.993E+01,1.997E+01,2.001E+01,2.001E+01,2.004E+01,2.007E+01,2.011E+01,&
	2.014E+01,2.015E+01,2.017E+01,2.019E+01,2.022E+01,2.023E+01,2.023E+01,2.026E+01,2.027E+01,2.029E+01,&
	2.028E+01,2.027E+01,2.029E+01,2.029E+01,2.031E+01,2.029E+01,2.026E+01,2.030E+01,2.031E+01,2.030E+01,&
	2.030E+01,2.031E+01,2.029E+01,2.029E+01,2.026E+01,2.025E+01,2.023E+01,2.020E+01,2.016E+01,2.015E+01,&
	2.012E+01,2.009E+01,2.007E+01,2.003E+01,1.998E+01,1.996E+01,1.991E+01,1.986E+01,1.980E+01,1.975E+01,&
	1.969E+01,1.964E+01,1.959E+01,1.953E+01,1.947E+01,1.941E+01,1.936E+01,1.931E+01,1.922E+01,1.918E+01,&
	1.912E+01,1.906E+01,1.899E+01,1.890E+01,1.885E+01,1.881E+01,1.875E+01,1.867E+01,1.861E+01,1.858E+01/

		DATA (k_Cm(i),i=1801,1900)/&
	1.852E+01,1.846E+01,1.840E+01,1.834E+01,1.829E+01,1.824E+01,1.819E+01,1.813E+01,1.807E+01,1.803E+01,&
	1.798E+01,1.792E+01,1.788E+01,1.782E+01,1.780E+01,1.775E+01,1.773E+01,1.768E+01,1.768E+01,1.766E+01,&
	1.763E+01,1.762E+01,1.763E+01,1.764E+01,1.764E+01,1.766E+01,1.770E+01,1.774E+01,1.779E+01,1.786E+01,&
	1.795E+01,1.803E+01,1.814E+01,1.825E+01,1.836E+01,1.851E+01,1.866E+01,1.881E+01,1.895E+01,1.913E+01,&
	1.932E+01,1.951E+01,1.972E+01,1.994E+01,2.017E+01,2.040E+01,2.065E+01,2.089E+01,2.114E+01,2.140E+01,&
	2.163E+01,2.186E+01,2.210E+01,2.237E+01,2.262E+01,2.290E+01,2.313E+01,2.339E+01,2.361E+01,2.387E+01,&
	2.410E+01,2.435E+01,2.455E+01,2.479E+01,2.499E+01,2.521E+01,2.541E+01,2.562E+01,2.583E+01,2.605E+01,&
	2.626E+01,2.643E+01,2.657E+01,2.674E+01,2.689E+01,2.701E+01,2.718E+01,2.732E+01,2.742E+01,2.754E+01,&
	2.763E+01,2.777E+01,2.794E+01,2.804E+01,2.821E+01,2.836E+01,2.850E+01,2.863E+01,2.878E+01,2.896E+01,&
	2.913E+01,2.922E+01,2.937E+01,2.947E+01,2.960E+01,2.970E+01,2.982E+01,2.997E+01,3.007E+01,3.018E+01/

		DATA (k_Cm(i),i=1901,2000)/&
	3.028E+01,3.040E+01,3.053E+01,3.060E+01,3.066E+01,3.070E+01,3.076E+01,3.078E+01,3.075E+01,3.074E+01,&
	3.072E+01,3.065E+01,3.058E+01,3.051E+01,3.045E+01,3.034E+01,3.029E+01,3.023E+01,3.015E+01,3.004E+01,&
	3.000E+01,2.998E+01,2.991E+01,2.986E+01,2.984E+01,2.981E+01,2.976E+01,2.973E+01,2.976E+01,2.977E+01,&
	2.979E+01,2.981E+01,2.985E+01,2.989E+01,2.999E+01,3.000E+01,3.005E+01,3.007E+01,3.011E+01,3.017E+01,&
	3.022E+01,3.023E+01,3.029E+01,3.028E+01,3.029E+01,3.027E+01,3.027E+01,3.024E+01,3.019E+01,3.010E+01,&
	3.010E+01,3.003E+01,2.993E+01,2.983E+01,2.984E+01,2.975E+01,2.966E+01,2.958E+01,2.948E+01,2.930E+01,&
	2.926E+01,2.920E+01,2.913E+01,2.902E+01,2.890E+01,2.882E+01,2.873E+01,2.873E+01,2.870E+01,2.865E+01,&
	2.858E+01,2.854E+01,2.851E+01,2.846E+01,2.838E+01,2.834E+01,2.823E+01,2.820E+01,2.817E+01,2.809E+01,&
	2.803E+01,2.803E+01,2.801E+01,2.794E+01,2.791E+01,2.790E+01,2.784E+01,2.779E+01,2.781E+01,2.782E+01,&
	2.781E+01,2.781E+01,2.783E+01,2.785E+01,2.785E+01,2.782E+01,2.782E+01,2.780E+01,2.780E+01,2.778E+01/

		DATA (k_Cm(i),i=2001,2101)/&
	2.783E+01,2.784E+01,2.788E+01,2.791E+01,2.799E+01,2.804E+01,2.812E+01,2.811E+01,2.819E+01,2.819E+01,&
	2.817E+01,2.817E+01,2.831E+01,2.837E+01,2.848E+01,2.853E+01,2.859E+01,2.870E+01,2.874E+01,2.887E+01,&
	2.898E+01,2.910E+01,2.923E+01,2.934E+01,2.944E+01,2.959E+01,2.973E+01,2.987E+01,3.002E+01,3.016E+01,&
	3.035E+01,3.043E+01,3.064E+01,3.084E+01,3.098E+01,3.122E+01,3.132E+01,3.152E+01,3.165E+01,3.184E+01,&
	3.204E+01,3.221E+01,3.233E+01,3.255E+01,3.282E+01,3.315E+01,3.339E+01,3.360E+01,3.384E+01,3.410E+01,&
	3.426E+01,3.452E+01,3.473E+01,3.497E+01,3.519E+01,3.539E+01,3.561E+01,3.579E+01,3.604E+01,3.618E+01,&
	3.636E+01,3.660E+01,3.675E+01,3.682E+01,3.699E+01,3.711E+01,3.735E+01,3.758E+01,3.792E+01,3.796E+01,&
	3.812E+01,3.822E+01,3.833E+01,3.856E+01,3.874E+01,3.877E+01,3.884E+01,3.883E+01,3.879E+01,3.886E+01,&
	3.900E+01,3.900E+01,3.906E+01,3.905E+01,3.916E+01,3.928E+01,3.948E+01,3.943E+01,3.951E+01,3.964E+01,&
	3.953E+01,3.960E+01,3.958E+01,3.954E+01,3.940E+01,3.936E+01,3.917E+01,3.926E+01,3.893E+01,3.921E+01,&
	3.871E+01/

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				direct energy from the sum							!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (Es(i),i=1,100)/&
	5.910E-01,5.980E-01,6.050E-01,6.120E-01,6.190E-01,6.260E-01,6.330E-01,6.400E-01,6.470E-01,6.540E-01,&
	6.610E-01,6.680E-01,6.750E-01,6.820E-01,6.890E-01,6.960E-01,7.030E-01,7.100E-01,7.170E-01,7.240E-01,&
	7.310E-01,7.376E-01,7.442E-01,7.508E-01,7.574E-01,7.640E-01,7.706E-01,7.772E-01,7.838E-01,7.904E-01,&
	7.970E-01,8.036E-01,8.102E-01,8.168E-01,8.234E-01,8.300E-01,8.366E-01,8.432E-01,8.498E-01,8.564E-01,&
	8.630E-01,8.743E-01,8.856E-01,8.969E-01,9.082E-01,9.195E-01,9.308E-01,9.421E-01,9.534E-01,9.647E-01,&
	9.760E-01,9.873E-01,9.986E-01,1.010E+00,1.021E+00,1.033E+00,1.044E+00,1.055E+00,1.066E+00,1.078E+00,&
	1.089E+00,1.094E+00,1.100E+00,1.105E+00,1.110E+00,1.116E+00,1.121E+00,1.126E+00,1.131E+00,1.137E+00,&
	1.142E+00,1.147E+00,1.153E+00,1.158E+00,1.163E+00,1.169E+00,1.174E+00,1.179E+00,1.184E+00,1.190E+00,&
	1.195E+00,1.194E+00,1.194E+00,1.193E+00,1.192E+00,1.191E+00,1.191E+00,1.190E+00,1.189E+00,1.188E+00,&
	1.188E+00,1.187E+00,1.186E+00,1.185E+00,1.185E+00,1.184E+00,1.183E+00,1.182E+00,1.182E+00,1.181E+00/

		DATA (Es(i),i=101,200)/&
	1.180E+00,1.180E+00,1.181E+00,1.181E+00,1.181E+00,1.182E+00,1.182E+00,1.182E+00,1.182E+00,1.183E+00,&
	1.183E+00,1.183E+00,1.184E+00,1.184E+00,1.184E+00,1.185E+00,1.185E+00,1.185E+00,1.185E+00,1.186E+00,&
	1.186E+00,1.191E+00,1.195E+00,1.200E+00,1.204E+00,1.209E+00,1.213E+00,1.218E+00,1.222E+00,1.227E+00,&
	1.231E+00,1.236E+00,1.240E+00,1.245E+00,1.249E+00,1.254E+00,1.258E+00,1.263E+00,1.267E+00,1.272E+00,&
	1.276E+00,1.278E+00,1.279E+00,1.281E+00,1.282E+00,1.284E+00,1.285E+00,1.287E+00,1.288E+00,1.290E+00,&
	1.291E+00,1.293E+00,1.294E+00,1.296E+00,1.297E+00,1.299E+00,1.300E+00,1.302E+00,1.303E+00,1.305E+00,&
	1.306E+00,1.309E+00,1.312E+00,1.314E+00,1.317E+00,1.320E+00,1.323E+00,1.325E+00,1.328E+00,1.331E+00,&
	1.334E+00,1.336E+00,1.339E+00,1.342E+00,1.345E+00,1.347E+00,1.350E+00,1.353E+00,1.356E+00,1.358E+00,&
	1.361E+00,1.361E+00,1.360E+00,1.360E+00,1.360E+00,1.359E+00,1.359E+00,1.359E+00,1.358E+00,1.358E+00,&
	1.358E+00,1.357E+00,1.357E+00,1.356E+00,1.356E+00,1.356E+00,1.355E+00,1.355E+00,1.355E+00,1.354E+00/

		DATA (Es(i),i=201,300)/&
	1.354E+00,1.356E+00,1.357E+00,1.359E+00,1.360E+00,1.362E+00,1.363E+00,1.365E+00,1.366E+00,1.368E+00,&
	1.370E+00,1.371E+00,1.373E+00,1.374E+00,1.376E+00,1.377E+00,1.379E+00,1.380E+00,1.382E+00,1.383E+00,&
	1.385E+00,1.385E+00,1.385E+00,1.385E+00,1.386E+00,1.386E+00,1.386E+00,1.386E+00,1.386E+00,1.386E+00,&
	1.387E+00,1.387E+00,1.387E+00,1.387E+00,1.387E+00,1.387E+00,1.387E+00,1.388E+00,1.388E+00,1.388E+00,&
	1.388E+00,1.387E+00,1.386E+00,1.384E+00,1.383E+00,1.382E+00,1.381E+00,1.379E+00,1.378E+00,1.377E+00,&
	1.376E+00,1.374E+00,1.373E+00,1.372E+00,1.371E+00,1.369E+00,1.368E+00,1.367E+00,1.366E+00,1.364E+00,&
	1.363E+00,1.364E+00,1.365E+00,1.366E+00,1.367E+00,1.368E+00,1.368E+00,1.369E+00,1.370E+00,1.371E+00,&
	1.372E+00,1.373E+00,1.374E+00,1.375E+00,1.376E+00,1.377E+00,1.377E+00,1.378E+00,1.379E+00,1.380E+00,&
	1.381E+00,1.375E+00,1.368E+00,1.362E+00,1.355E+00,1.349E+00,1.343E+00,1.336E+00,1.330E+00,1.323E+00,&
	1.317E+00,1.311E+00,1.304E+00,1.298E+00,1.291E+00,1.285E+00,1.279E+00,1.272E+00,1.266E+00,1.259E+00/

		DATA (Es(i),i=301,400)/&
	1.253E+00,1.236E+00,1.219E+00,1.201E+00,1.184E+00,1.167E+00,1.150E+00,1.133E+00,1.115E+00,1.098E+00,&
	1.081E+00,1.064E+00,1.047E+00,1.029E+00,1.012E+00,9.950E-01,9.778E-01,9.606E-01,9.434E-01,9.262E-01,&
	9.090E-01,9.248E-01,9.405E-01,9.563E-01,9.720E-01,9.878E-01,1.004E+00,1.019E+00,1.035E+00,1.051E+00,&
	1.067E+00,1.082E+00,1.098E+00,1.114E+00,1.130E+00,1.145E+00,1.161E+00,1.177E+00,1.193E+00,1.208E+00,&
	1.224E+00,1.182E+00,1.139E+00,1.097E+00,1.054E+00,1.012E+00,9.693E-01,9.269E-01,8.844E-01,8.420E-01,&
	7.995E-01,7.571E-01,7.146E-01,6.722E-01,6.297E-01,5.873E-01,5.448E-01,5.024E-01,4.599E-01,4.175E-01,&
	3.750E-01,4.185E-01,4.619E-01,5.054E-01,5.488E-01,5.923E-01,6.357E-01,6.792E-01,7.226E-01,7.661E-01,&
	8.095E-01,8.530E-01,8.964E-01,9.399E-01,9.833E-01,1.027E+00,1.070E+00,1.114E+00,1.157E+00,1.201E+00,&
	1.244E+00,1.242E+00,1.240E+00,1.238E+00,1.235E+00,1.233E+00,1.231E+00,1.229E+00,1.227E+00,1.225E+00,&
	1.223E+00,1.220E+00,1.218E+00,1.216E+00,1.214E+00,1.212E+00,1.210E+00,1.207E+00,1.205E+00,1.203E+00/

		DATA (Es(i),i=401,500)/&
	1.201E+00,1.188E+00,1.174E+00,1.161E+00,1.147E+00,1.134E+00,1.121E+00,1.107E+00,1.094E+00,1.080E+00,&
	1.067E+00,1.054E+00,1.040E+00,1.027E+00,1.013E+00,1.000E+00,9.866E-01,9.732E-01,9.598E-01,9.464E-01,&
	9.330E-01,9.416E-01,9.502E-01,9.588E-01,9.674E-01,9.760E-01,9.846E-01,9.932E-01,1.002E+00,1.010E+00,&
	1.019E+00,1.028E+00,1.036E+00,1.045E+00,1.053E+00,1.062E+00,1.071E+00,1.079E+00,1.088E+00,1.096E+00,&
	1.105E+00,1.105E+00,1.106E+00,1.106E+00,1.107E+00,1.107E+00,1.108E+00,1.108E+00,1.109E+00,1.109E+00,&
	1.110E+00,1.110E+00,1.110E+00,1.111E+00,1.111E+00,1.112E+00,1.112E+00,1.113E+00,1.113E+00,1.114E+00,&
	1.114E+00,1.114E+00,1.113E+00,1.113E+00,1.112E+00,1.112E+00,1.111E+00,1.111E+00,1.110E+00,1.110E+00,&
	1.109E+00,1.109E+00,1.108E+00,1.108E+00,1.107E+00,1.107E+00,1.106E+00,1.106E+00,1.105E+00,1.105E+00,&
	1.104E+00,1.087E+00,1.070E+00,1.053E+00,1.036E+00,1.019E+00,1.002E+00,9.850E-01,9.680E-01,9.510E-01,&
	9.340E-01,9.170E-01,9.000E-01,8.830E-01,8.660E-01,8.490E-01,8.320E-01,8.150E-01,7.980E-01,7.810E-01/
		
		DATA (Es(i),i=501,600)/&
	7.640E-01,7.758E-01,7.876E-01,7.994E-01,8.112E-01,8.230E-01,8.348E-01,8.466E-01,8.584E-01,8.702E-01,&
	8.820E-01,8.938E-01,9.056E-01,9.174E-01,9.292E-01,9.410E-01,9.528E-01,9.646E-01,9.764E-01,9.882E-01,&
	1.000E+00,9.771E-01,9.542E-01,9.313E-01,9.084E-01,8.855E-01,8.626E-01,8.397E-01,8.168E-01,7.939E-01,&
	7.710E-01,7.481E-01,7.252E-01,7.023E-01,6.794E-01,6.565E-01,6.336E-01,6.107E-01,5.878E-01,5.649E-01,&
	5.420E-01,5.412E-01,5.403E-01,5.395E-01,5.386E-01,5.378E-01,5.369E-01,5.361E-01,5.352E-01,5.344E-01,&
	5.335E-01,5.327E-01,5.318E-01,5.310E-01,5.301E-01,5.293E-01,5.284E-01,5.276E-01,5.267E-01,5.259E-01,&
	5.250E-01,5.362E-01,5.474E-01,5.586E-01,5.698E-01,5.810E-01,5.922E-01,6.034E-01,6.146E-01,6.258E-01,&
	6.370E-01,6.482E-01,6.594E-01,6.706E-01,6.818E-01,6.930E-01,7.042E-01,7.154E-01,7.266E-01,7.378E-01,&
	7.490E-01,7.564E-01,7.638E-01,7.712E-01,7.786E-01,7.860E-01,7.934E-01,8.008E-01,8.082E-01,8.156E-01,&
	8.230E-01,8.304E-01,8.378E-01,8.452E-01,8.526E-01,8.600E-01,8.674E-01,8.748E-01,8.822E-01,8.896E-01/

		DATA (Es(i),i=601,700)/&
	8.970E-01,8.952E-01,8.933E-01,8.915E-01,8.896E-01,8.878E-01,8.859E-01,8.841E-01,8.822E-01,8.804E-01,&
	8.785E-01,8.767E-01,8.748E-01,8.730E-01,8.711E-01,8.693E-01,8.674E-01,8.656E-01,8.637E-01,8.619E-01,&
	8.600E-01,8.588E-01,8.575E-01,8.563E-01,8.550E-01,8.538E-01,8.525E-01,8.513E-01,8.500E-01,8.488E-01,&
	8.475E-01,8.463E-01,8.450E-01,8.438E-01,8.425E-01,8.413E-01,8.400E-01,8.388E-01,8.375E-01,8.363E-01,&
	8.350E-01,8.333E-01,8.316E-01,8.299E-01,8.282E-01,8.265E-01,8.248E-01,8.231E-01,8.214E-01,8.197E-01,&
	8.180E-01,8.163E-01,8.146E-01,8.129E-01,8.112E-01,8.095E-01,8.078E-01,8.061E-01,8.044E-01,8.027E-01,&
	8.010E-01,7.977E-01,7.944E-01,7.911E-01,7.878E-01,7.845E-01,7.812E-01,7.779E-01,7.746E-01,7.713E-01,&
	7.680E-01,7.647E-01,7.614E-01,7.581E-01,7.548E-01,7.515E-01,7.482E-01,7.449E-01,7.416E-01,7.383E-01,&
	7.350E-01,7.326E-01,7.302E-01,7.278E-01,7.254E-01,7.230E-01,7.206E-01,7.182E-01,7.158E-01,7.134E-01,&
	7.110E-01,7.086E-01,7.062E-01,7.038E-01,7.014E-01,6.990E-01,6.966E-01,6.942E-01,6.918E-01,6.894E-01/

		DATA (Es(i),i=701,800)/&
	6.870E-01,6.634E-01,6.397E-01,6.161E-01,5.924E-01,5.688E-01,5.451E-01,5.215E-01,4.978E-01,4.742E-01,&
	4.505E-01,4.269E-01,4.032E-01,3.796E-01,3.559E-01,3.323E-01,3.086E-01,2.850E-01,2.613E-01,2.377E-01,&
	2.140E-01,2.231E-01,2.321E-01,2.412E-01,2.502E-01,2.593E-01,2.683E-01,2.774E-01,2.864E-01,2.955E-01,&
	3.045E-01,3.136E-01,3.226E-01,3.317E-01,3.407E-01,3.498E-01,3.588E-01,3.679E-01,3.769E-01,3.860E-01,&
	3.950E-01,3.950E-01,3.949E-01,3.949E-01,3.948E-01,3.948E-01,3.947E-01,3.947E-01,3.946E-01,3.946E-01,&
	3.945E-01,3.945E-01,3.944E-01,3.944E-01,3.943E-01,3.943E-01,3.942E-01,3.942E-01,3.941E-01,3.941E-01,&
	3.940E-01,4.020E-01,4.099E-01,4.179E-01,4.258E-01,4.338E-01,4.417E-01,4.497E-01,4.576E-01,4.656E-01,&
	4.735E-01,4.815E-01,4.894E-01,4.974E-01,5.053E-01,5.133E-01,5.212E-01,5.292E-01,5.371E-01,5.451E-01,&
	5.530E-01,5.526E-01,5.522E-01,5.518E-01,5.514E-01,5.510E-01,5.506E-01,5.502E-01,5.498E-01,5.494E-01,&
	5.490E-01,5.486E-01,5.482E-01,5.478E-01,5.474E-01,5.470E-01,5.466E-01,5.462E-01,5.458E-01,5.454E-01/

		DATA (Es(i),i=801,900)/&
	5.450E-01,5.477E-01,5.504E-01,5.531E-01,5.558E-01,5.585E-01,5.612E-01,5.639E-01,5.666E-01,5.693E-01,&
	5.720E-01,5.747E-01,5.774E-01,5.801E-01,5.828E-01,5.855E-01,5.882E-01,5.909E-01,5.936E-01,5.963E-01,&
	5.990E-01,5.984E-01,5.978E-01,5.972E-01,5.966E-01,5.960E-01,5.954E-01,5.948E-01,5.942E-01,5.936E-01,&
	5.930E-01,5.924E-01,5.918E-01,5.912E-01,5.906E-01,5.900E-01,5.894E-01,5.888E-01,5.882E-01,5.876E-01,&
	5.870E-01,5.848E-01,5.825E-01,5.803E-01,5.780E-01,5.758E-01,5.735E-01,5.713E-01,5.690E-01,5.668E-01,&
	5.645E-01,5.623E-01,5.600E-01,5.578E-01,5.555E-01,5.533E-01,5.510E-01,5.488E-01,5.465E-01,5.443E-01,&
	5.420E-01,5.406E-01,5.392E-01,5.378E-01,5.364E-01,5.350E-01,5.336E-01,5.322E-01,5.308E-01,5.294E-01,&
	5.280E-01,5.266E-01,5.252E-01,5.238E-01,5.224E-01,5.210E-01,5.196E-01,5.182E-01,5.168E-01,5.154E-01,&
	5.140E-01,5.114E-01,5.088E-01,5.062E-01,5.036E-01,5.010E-01,4.984E-01,4.958E-01,4.932E-01,4.906E-01,&
	4.880E-01,4.854E-01,4.828E-01,4.802E-01,4.776E-01,4.750E-01,4.724E-01,4.698E-01,4.672E-01,4.646E-01/

		DATA (Es(i),i=901,1000)/&
	4.620E-01,4.553E-01,4.485E-01,4.418E-01,4.350E-01,4.283E-01,4.215E-01,4.148E-01,4.080E-01,4.013E-01,&
	3.945E-01,3.878E-01,3.810E-01,3.743E-01,3.675E-01,3.608E-01,3.540E-01,3.473E-01,3.405E-01,3.338E-01,&
	3.270E-01,3.239E-01,3.207E-01,3.176E-01,3.144E-01,3.113E-01,3.081E-01,3.050E-01,3.018E-01,2.987E-01,&
	2.955E-01,2.924E-01,2.892E-01,2.861E-01,2.829E-01,2.798E-01,2.766E-01,2.735E-01,2.703E-01,2.672E-01,&
	2.640E-01,2.512E-01,2.383E-01,2.255E-01,2.126E-01,1.998E-01,1.869E-01,1.741E-01,1.612E-01,1.484E-01,&
	1.355E-01,1.227E-01,1.098E-01,9.695E-02,8.410E-02,7.125E-02,5.840E-02,4.555E-02,3.270E-02,1.985E-02,&
	7.000E-03,6.800E-03,6.600E-03,6.400E-03,6.200E-03,6.000E-03,5.800E-03,5.600E-03,5.400E-03,5.200E-03,&
	5.000E-03,4.800E-03,4.600E-03,4.400E-03,4.200E-03,4.000E-03,3.800E-03,3.600E-03,3.400E-03,3.200E-03,&
	3.000E-03,3.900E-03,4.800E-03,5.700E-03,6.600E-03,7.500E-03,8.400E-03,9.300E-03,1.020E-02,1.110E-02,&
	1.200E-02,1.290E-02,1.380E-02,1.470E-02,1.560E-02,1.650E-02,1.740E-02,1.830E-02,1.920E-02,2.010E-02/

		DATA (Es(i),i=1001,1100)/&
	2.100E-02,2.095E-02,2.090E-02,2.085E-02,2.080E-02,2.075E-02,2.070E-02,2.065E-02,2.060E-02,2.055E-02,&
	2.050E-02,2.045E-02,2.040E-02,2.035E-02,2.030E-02,2.025E-02,2.020E-02,2.015E-02,2.010E-02,2.005E-02,&
	2.000E-02,2.170E-02,2.340E-02,2.510E-02,2.680E-02,2.850E-02,3.020E-02,3.190E-02,3.360E-02,3.530E-02,&
	3.700E-02,3.870E-02,4.040E-02,4.210E-02,4.380E-02,4.550E-02,4.720E-02,4.890E-02,5.060E-02,5.230E-02,&
	5.400E-02,5.795E-02,6.190E-02,6.585E-02,6.980E-02,7.375E-02,7.770E-02,8.165E-02,8.560E-02,8.955E-02,&
	9.350E-02,9.745E-02,1.014E-01,1.054E-01,1.093E-01,1.133E-01,1.172E-01,1.212E-01,1.251E-01,1.291E-01,&
	1.330E-01,1.327E-01,1.324E-01,1.321E-01,1.318E-01,1.315E-01,1.312E-01,1.309E-01,1.306E-01,1.303E-01,&
	1.300E-01,1.297E-01,1.294E-01,1.291E-01,1.288E-01,1.285E-01,1.282E-01,1.279E-01,1.276E-01,1.273E-01,&
	1.270E-01,1.384E-01,1.497E-01,1.611E-01,1.724E-01,1.838E-01,1.951E-01,2.065E-01,2.178E-01,2.292E-01,&
	2.405E-01,2.519E-01,2.632E-01,2.746E-01,2.859E-01,2.973E-01,3.086E-01,3.200E-01,3.313E-01,3.427E-01/

		DATA (Es(i),i=1101,1200)/&
	3.540E-01,3.541E-01,3.541E-01,3.542E-01,3.542E-01,3.543E-01,3.543E-01,3.544E-01,3.544E-01,3.545E-01,&
	3.545E-01,3.546E-01,3.546E-01,3.547E-01,3.547E-01,3.548E-01,3.548E-01,3.549E-01,3.549E-01,3.550E-01,&
	3.550E-01,3.556E-01,3.561E-01,3.567E-01,3.572E-01,3.578E-01,3.583E-01,3.589E-01,3.594E-01,3.600E-01,&
	3.605E-01,3.611E-01,3.616E-01,3.622E-01,3.627E-01,3.633E-01,3.638E-01,3.644E-01,3.649E-01,3.655E-01,&
	3.660E-01,3.659E-01,3.658E-01,3.657E-01,3.656E-01,3.655E-01,3.654E-01,3.653E-01,3.652E-01,3.651E-01,&
	3.650E-01,3.649E-01,3.648E-01,3.647E-01,3.646E-01,3.645E-01,3.644E-01,3.643E-01,3.642E-01,3.641E-01,&
	3.640E-01,3.626E-01,3.611E-01,3.597E-01,3.582E-01,3.568E-01,3.553E-01,3.539E-01,3.524E-01,3.510E-01,&
	3.495E-01,3.481E-01,3.466E-01,3.452E-01,3.437E-01,3.423E-01,3.408E-01,3.394E-01,3.379E-01,3.365E-01,&
	3.350E-01,3.350E-01,3.349E-01,3.349E-01,3.348E-01,3.348E-01,3.347E-01,3.347E-01,3.346E-01,3.346E-01,&
	3.345E-01,3.345E-01,3.344E-01,3.344E-01,3.343E-01,3.343E-01,3.342E-01,3.342E-01,3.341E-01,3.341E-01/

		DATA (Es(i),i=1201,1300)/&
	3.340E-01,3.338E-01,3.335E-01,3.333E-01,3.330E-01,3.328E-01,3.325E-01,3.323E-01,3.320E-01,3.318E-01,&
	3.315E-01,3.313E-01,3.310E-01,3.308E-01,3.305E-01,3.303E-01,3.300E-01,3.298E-01,3.295E-01,3.293E-01,&
	3.290E-01,3.280E-01,3.270E-01,3.260E-01,3.250E-01,3.240E-01,3.230E-01,3.220E-01,3.210E-01,3.200E-01,&
	3.190E-01,3.180E-01,3.170E-01,3.160E-01,3.150E-01,3.140E-01,3.130E-01,3.120E-01,3.110E-01,3.100E-01,&
	3.090E-01,3.089E-01,3.087E-01,3.086E-01,3.084E-01,3.083E-01,3.081E-01,3.080E-01,3.078E-01,3.077E-01,&
	3.075E-01,3.074E-01,3.072E-01,3.071E-01,3.069E-01,3.068E-01,3.066E-01,3.065E-01,3.063E-01,3.062E-01,&
	3.060E-01,3.054E-01,3.047E-01,3.041E-01,3.034E-01,3.028E-01,3.021E-01,3.015E-01,3.008E-01,3.002E-01,&
	2.995E-01,2.989E-01,2.982E-01,2.976E-01,2.969E-01,2.963E-01,2.956E-01,2.950E-01,2.943E-01,2.937E-01,&
	2.930E-01,2.923E-01,2.915E-01,2.908E-01,2.900E-01,2.893E-01,2.885E-01,2.878E-01,2.870E-01,2.863E-01,&
	2.855E-01,2.848E-01,2.840E-01,2.833E-01,2.825E-01,2.818E-01,2.810E-01,2.803E-01,2.795E-01,2.788E-01/

		DATA (Es(i),i=1301,1400)/&
	2.780E-01,2.777E-01,2.774E-01,2.771E-01,2.768E-01,2.765E-01,2.762E-01,2.759E-01,2.756E-01,2.753E-01,&
	2.750E-01,2.747E-01,2.744E-01,2.741E-01,2.738E-01,2.735E-01,2.732E-01,2.729E-01,2.726E-01,2.723E-01,&
	2.720E-01,2.689E-01,2.658E-01,2.627E-01,2.596E-01,2.565E-01,2.534E-01,2.503E-01,2.472E-01,2.441E-01,&
	2.410E-01,2.379E-01,2.348E-01,2.317E-01,2.286E-01,2.255E-01,2.224E-01,2.193E-01,2.162E-01,2.131E-01,&
	2.100E-01,2.119E-01,2.138E-01,2.157E-01,2.176E-01,2.195E-01,2.214E-01,2.233E-01,2.252E-01,2.271E-01,&
	2.290E-01,2.309E-01,2.328E-01,2.347E-01,2.366E-01,2.385E-01,2.404E-01,2.423E-01,2.442E-01,2.461E-01,&
	2.480E-01,2.427E-01,2.373E-01,2.320E-01,2.266E-01,2.213E-01,2.159E-01,2.106E-01,2.052E-01,1.999E-01,&
	1.945E-01,1.892E-01,1.838E-01,1.785E-01,1.731E-01,1.678E-01,1.624E-01,1.571E-01,1.517E-01,1.464E-01,&
	1.410E-01,1.356E-01,1.302E-01,1.248E-01,1.194E-01,1.140E-01,1.086E-01,1.032E-01,9.780E-02,9.240E-02,&
	8.700E-02,8.160E-02,7.620E-02,7.080E-02,6.540E-02,6.000E-02,5.460E-02,4.920E-02,4.380E-02,3.840E-02/

		DATA (Es(i),i=1401,1500)/&
	3.300E-02,3.160E-02,3.020E-02,2.880E-02,2.740E-02,2.600E-02,2.460E-02,2.320E-02,2.180E-02,2.040E-02,&
	1.900E-02,1.760E-02,1.620E-02,1.480E-02,1.340E-02,1.200E-02,1.060E-02,9.200E-03,7.800E-03,6.400E-03,&
	5.000E-03,4.900E-03,4.800E-03,4.700E-03,4.600E-03,4.500E-03,4.400E-03,4.300E-03,4.200E-03,4.100E-03,&
	4.000E-03,3.900E-03,3.800E-03,3.700E-03,3.600E-03,3.500E-03,3.400E-03,3.300E-03,3.200E-03,3.100E-03,&
	3.000E-03,2.900E-03,2.800E-03,2.700E-03,2.600E-03,2.500E-03,2.400E-03,2.300E-03,2.200E-03,2.100E-03,&
	2.000E-03,1.900E-03,1.800E-03,1.700E-03,1.600E-03,1.500E-03,1.400E-03,1.300E-03,1.200E-03,1.100E-03,&
	1.000E-03,1.900E-03,2.800E-03,3.700E-03,4.600E-03,5.500E-03,6.400E-03,7.300E-03,8.200E-03,9.100E-03,&
	1.000E-02,1.090E-02,1.180E-02,1.270E-02,1.360E-02,1.450E-02,1.540E-02,1.630E-02,1.720E-02,1.810E-02,&
	1.900E-02,1.810E-02,1.720E-02,1.630E-02,1.540E-02,1.450E-02,1.360E-02,1.270E-02,1.180E-02,1.090E-02,&
	1.000E-02,9.100E-03,8.200E-03,7.300E-03,6.400E-03,5.500E-03,4.600E-03,3.700E-03,2.800E-03,1.900E-03/

		DATA (Es(i),i=1501,1600)/&
	1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,&
	1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,&
	1.000E-03,1.250E-03,1.500E-03,1.750E-03,2.000E-03,2.250E-03,2.500E-03,2.750E-03,3.000E-03,3.250E-03,&
	3.500E-03,3.750E-03,4.000E-03,4.250E-03,4.500E-03,4.750E-03,5.000E-03,5.250E-03,5.500E-03,5.750E-03,&
	6.000E-03,7.100E-03,8.200E-03,9.300E-03,1.040E-02,1.150E-02,1.260E-02,1.370E-02,1.480E-02,1.590E-02,&
	1.700E-02,1.810E-02,1.920E-02,2.030E-02,2.140E-02,2.250E-02,2.360E-02,2.470E-02,2.580E-02,2.690E-02,&
	2.800E-02,3.150E-02,3.500E-02,3.850E-02,4.200E-02,4.550E-02,4.900E-02,5.250E-02,5.600E-02,5.950E-02,&
	6.300E-02,6.650E-02,7.000E-02,7.350E-02,7.700E-02,8.050E-02,8.400E-02,8.750E-02,9.100E-02,9.450E-02,&
	9.800E-02,9.720E-02,9.640E-02,9.560E-02,9.480E-02,9.400E-02,9.320E-02,9.240E-02,9.160E-02,9.080E-02,&
	9.000E-02,8.920E-02,8.840E-02,8.760E-02,8.680E-02,8.600E-02,8.520E-02,8.440E-02,8.360E-02,8.280E-02/

		DATA (Es(i),i=1601,1700)/&
	8.200E-02,8.015E-02,7.830E-02,7.645E-02,7.460E-02,7.275E-02,7.090E-02,6.905E-02,6.720E-02,6.535E-02,&
	6.350E-02,6.165E-02,5.980E-02,5.795E-02,5.610E-02,5.425E-02,5.240E-02,5.055E-02,4.870E-02,4.685E-02,&
	4.500E-02,4.965E-02,5.430E-02,5.895E-02,6.360E-02,6.825E-02,7.290E-02,7.755E-02,8.220E-02,8.685E-02,&
	9.150E-02,9.615E-02,1.008E-01,1.055E-01,1.101E-01,1.148E-01,1.194E-01,1.241E-01,1.287E-01,1.334E-01,&
	1.380E-01,1.363E-01,1.346E-01,1.329E-01,1.312E-01,1.295E-01,1.278E-01,1.261E-01,1.244E-01,1.227E-01,&
	1.210E-01,1.193E-01,1.176E-01,1.159E-01,1.142E-01,1.125E-01,1.108E-01,1.091E-01,1.074E-01,1.057E-01,&
	1.040E-01,1.054E-01,1.068E-01,1.082E-01,1.096E-01,1.110E-01,1.124E-01,1.138E-01,1.152E-01,1.166E-01,&
	1.180E-01,1.194E-01,1.208E-01,1.222E-01,1.236E-01,1.250E-01,1.264E-01,1.278E-01,1.292E-01,1.306E-01,&
	1.320E-01,1.317E-01,1.314E-01,1.311E-01,1.308E-01,1.305E-01,1.302E-01,1.299E-01,1.296E-01,1.293E-01,&
	1.290E-01,1.287E-01,1.284E-01,1.281E-01,1.278E-01,1.275E-01,1.272E-01,1.269E-01,1.266E-01,1.263E-01/

		DATA (Es(i),i=1701,1800)/&
	1.260E-01,1.262E-01,1.264E-01,1.266E-01,1.268E-01,1.270E-01,1.272E-01,1.274E-01,1.276E-01,1.278E-01,&
	1.280E-01,1.282E-01,1.284E-01,1.286E-01,1.288E-01,1.290E-01,1.292E-01,1.294E-01,1.296E-01,1.298E-01,&
	1.300E-01,1.301E-01,1.301E-01,1.302E-01,1.302E-01,1.303E-01,1.303E-01,1.304E-01,1.304E-01,1.305E-01,&
	1.305E-01,1.306E-01,1.306E-01,1.307E-01,1.307E-01,1.308E-01,1.308E-01,1.309E-01,1.309E-01,1.310E-01,&
	1.310E-01,1.301E-01,1.292E-01,1.283E-01,1.274E-01,1.265E-01,1.256E-01,1.247E-01,1.238E-01,1.229E-01,&
	1.220E-01,1.211E-01,1.202E-01,1.193E-01,1.184E-01,1.175E-01,1.166E-01,1.157E-01,1.148E-01,1.139E-01,&
	1.130E-01,1.129E-01,1.127E-01,1.126E-01,1.124E-01,1.123E-01,1.121E-01,1.120E-01,1.118E-01,1.117E-01,&
	1.115E-01,1.114E-01,1.112E-01,1.111E-01,1.109E-01,1.108E-01,1.106E-01,1.105E-01,1.103E-01,1.102E-01,&
	1.100E-01,1.094E-01,1.087E-01,1.081E-01,1.074E-01,1.068E-01,1.061E-01,1.055E-01,1.048E-01,1.042E-01,&
	1.035E-01,1.029E-01,1.022E-01,1.016E-01,1.009E-01,1.003E-01,9.960E-02,9.895E-02,9.830E-02,9.765E-02/

		DATA (Es(i),i=1801,1900)/&
	9.700E-02,9.775E-02,9.850E-02,9.925E-02,1.000E-01,1.008E-01,1.015E-01,1.023E-01,1.030E-01,1.038E-01,&
	1.045E-01,1.053E-01,1.060E-01,1.068E-01,1.075E-01,1.083E-01,1.090E-01,1.098E-01,1.105E-01,1.113E-01,&
	1.120E-01,1.118E-01,1.115E-01,1.113E-01,1.110E-01,1.108E-01,1.105E-01,1.103E-01,1.100E-01,1.098E-01,&
	1.095E-01,1.093E-01,1.090E-01,1.088E-01,1.085E-01,1.083E-01,1.080E-01,1.078E-01,1.075E-01,1.073E-01,&
	1.070E-01,1.065E-01,1.059E-01,1.054E-01,1.048E-01,1.043E-01,1.037E-01,1.032E-01,1.026E-01,1.021E-01,&
	1.015E-01,1.010E-01,1.004E-01,9.985E-02,9.930E-02,9.875E-02,9.820E-02,9.765E-02,9.710E-02,9.655E-02,&
	9.600E-02,9.590E-02,9.580E-02,9.570E-02,9.560E-02,9.550E-02,9.540E-02,9.530E-02,9.520E-02,9.510E-02,&
	9.500E-02,9.490E-02,9.480E-02,9.470E-02,9.460E-02,9.450E-02,9.440E-02,9.430E-02,9.420E-02,9.410E-02,&
	9.400E-02,9.355E-02,9.310E-02,9.265E-02,9.220E-02,9.175E-02,9.130E-02,9.085E-02,9.040E-02,8.995E-02,&
	8.950E-02,8.905E-02,8.860E-02,8.815E-02,8.770E-02,8.725E-02,8.680E-02,8.635E-02,8.590E-02,8.545E-02/

		DATA (Es(i),i=1901,2000)/&
	8.500E-02,8.430E-02,8.360E-02,8.290E-02,8.220E-02,8.150E-02,8.080E-02,8.010E-02,7.940E-02,7.870E-02,&
	7.800E-02,7.730E-02,7.660E-02,7.590E-02,7.520E-02,7.450E-02,7.380E-02,7.310E-02,7.240E-02,7.170E-02,&
	7.100E-02,7.105E-02,7.110E-02,7.115E-02,7.120E-02,7.125E-02,7.130E-02,7.135E-02,7.140E-02,7.145E-02,&
	7.150E-02,7.155E-02,7.160E-02,7.165E-02,7.170E-02,7.175E-02,7.180E-02,7.185E-02,7.190E-02,7.195E-02,&
	7.200E-02,7.195E-02,7.190E-02,7.185E-02,7.180E-02,7.175E-02,7.170E-02,7.165E-02,7.160E-02,7.155E-02,&
	7.150E-02,7.145E-02,7.140E-02,7.135E-02,7.130E-02,7.125E-02,7.120E-02,7.115E-02,7.110E-02,7.105E-02,&
	7.100E-02,7.025E-02,6.950E-02,6.875E-02,6.800E-02,6.725E-02,6.650E-02,6.575E-02,6.500E-02,6.425E-02,&
	6.350E-02,6.275E-02,6.200E-02,6.125E-02,6.050E-02,5.975E-02,5.900E-02,5.825E-02,5.750E-02,5.675E-02,&
	5.600E-02,5.685E-02,5.770E-02,5.855E-02,5.940E-02,6.025E-02,6.110E-02,6.195E-02,6.280E-02,6.365E-02,&
	6.450E-02,6.535E-02,6.620E-02,6.705E-02,6.790E-02,6.875E-02,6.960E-02,7.045E-02,7.130E-02,7.215E-02/

		DATA (Es(i),i=2001,2101)/&
	7.300E-02,7.085E-02,6.870E-02,6.655E-02,6.440E-02,6.225E-02,6.010E-02,5.795E-02,5.580E-02,5.365E-02,&
	5.150E-02,4.935E-02,4.720E-02,4.505E-02,4.290E-02,4.075E-02,3.860E-02,3.645E-02,3.430E-02,3.215E-02,&
	3.000E-02,3.195E-02,3.390E-02,3.585E-02,3.780E-02,3.975E-02,4.170E-02,4.365E-02,4.560E-02,4.755E-02,&
	4.950E-02,5.145E-02,5.340E-02,5.535E-02,5.730E-02,5.925E-02,6.120E-02,6.315E-02,6.510E-02,6.705E-02,&
	6.900E-02,6.755E-02,6.610E-02,6.465E-02,6.320E-02,6.175E-02,6.030E-02,5.885E-02,5.740E-02,5.595E-02,&
	5.450E-02,5.305E-02,5.160E-02,5.015E-02,4.870E-02,4.725E-02,4.580E-02,4.435E-02,4.290E-02,4.145E-02,&
	4.000E-02,3.960E-02,3.920E-02,3.880E-02,3.840E-02,3.800E-02,3.760E-02,3.720E-02,3.680E-02,3.640E-02,&
	3.600E-02,3.560E-02,3.520E-02,3.480E-02,3.440E-02,3.400E-02,3.360E-02,3.320E-02,3.280E-02,3.240E-02,&
	3.200E-02,3.110E-02,3.020E-02,2.930E-02,2.840E-02,2.750E-02,2.660E-02,2.570E-02,2.480E-02,2.390E-02,&
	2.300E-02,2.210E-02,2.120E-02,2.030E-02,1.940E-02,1.850E-02,1.760E-02,1.670E-02,1.580E-02,1.490E-02,&
	1.400E-02/

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				diffuse energy from the sum							!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (Ed(i),i=1,100)/&
	2.413E+00,2.413E+00,2.414E+00,2.414E+00,2.414E+00,2.415E+00,2.415E+00,2.415E+00,2.415E+00,2.416E+00,&
	2.416E+00,2.416E+00,2.417E+00,2.417E+00,2.417E+00,2.418E+00,2.418E+00,2.418E+00,2.418E+00,2.419E+00,&
	2.419E+00,2.418E+00,2.417E+00,2.416E+00,2.415E+00,2.414E+00,2.413E+00,2.412E+00,2.411E+00,2.410E+00,&
	2.410E+00,2.409E+00,2.408E+00,2.407E+00,2.406E+00,2.405E+00,2.404E+00,2.403E+00,2.402E+00,2.401E+00,&
	2.400E+00,2.412E+00,2.424E+00,2.435E+00,2.447E+00,2.459E+00,2.471E+00,2.483E+00,2.494E+00,2.506E+00,&
	2.518E+00,2.530E+00,2.542E+00,2.553E+00,2.565E+00,2.577E+00,2.589E+00,2.601E+00,2.612E+00,2.624E+00,&
	2.636E+00,2.634E+00,2.632E+00,2.630E+00,2.628E+00,2.626E+00,2.623E+00,2.621E+00,2.619E+00,2.617E+00,&
	2.615E+00,2.613E+00,2.611E+00,2.609E+00,2.607E+00,2.605E+00,2.602E+00,2.600E+00,2.598E+00,2.596E+00,&
	2.594E+00,2.579E+00,2.565E+00,2.550E+00,2.535E+00,2.521E+00,2.506E+00,2.491E+00,2.477E+00,2.462E+00,&
	2.448E+00,2.433E+00,2.418E+00,2.404E+00,2.389E+00,2.374E+00,2.360E+00,2.345E+00,2.330E+00,2.316E+00/

		DATA (Ed(i),i=101,200)/&
	2.301E+00,2.290E+00,2.279E+00,2.268E+00,2.257E+00,2.246E+00,2.234E+00,2.223E+00,2.212E+00,2.201E+00,&
	2.190E+00,2.179E+00,2.168E+00,2.157E+00,2.146E+00,2.135E+00,2.123E+00,2.112E+00,2.101E+00,2.090E+00,&
	2.079E+00,2.076E+00,2.073E+00,2.070E+00,2.067E+00,2.064E+00,2.061E+00,2.058E+00,2.055E+00,2.052E+00,&
	2.049E+00,2.045E+00,2.042E+00,2.039E+00,2.036E+00,2.033E+00,2.030E+00,2.027E+00,2.024E+00,2.021E+00,&
	2.018E+00,2.011E+00,2.004E+00,1.997E+00,1.990E+00,1.983E+00,1.975E+00,1.968E+00,1.961E+00,1.954E+00,&
	1.947E+00,1.940E+00,1.933E+00,1.926E+00,1.919E+00,1.912E+00,1.904E+00,1.897E+00,1.890E+00,1.883E+00,&
	1.876E+00,1.871E+00,1.867E+00,1.862E+00,1.857E+00,1.852E+00,1.848E+00,1.843E+00,1.838E+00,1.833E+00,&
	1.829E+00,1.824E+00,1.819E+00,1.814E+00,1.810E+00,1.805E+00,1.800E+00,1.795E+00,1.791E+00,1.786E+00,&
	1.781E+00,1.774E+00,1.767E+00,1.760E+00,1.752E+00,1.745E+00,1.738E+00,1.731E+00,1.724E+00,1.717E+00,&
	1.710E+00,1.702E+00,1.695E+00,1.688E+00,1.681E+00,1.674E+00,1.667E+00,1.659E+00,1.652E+00,1.645E+00/

		DATA (Ed(i),i=201,300)/&
	1.638E+00,1.635E+00,1.631E+00,1.628E+00,1.624E+00,1.621E+00,1.617E+00,1.614E+00,1.610E+00,1.607E+00,&
	1.604E+00,1.600E+00,1.597E+00,1.593E+00,1.590E+00,1.586E+00,1.583E+00,1.579E+00,1.576E+00,1.572E+00,&
	1.569E+00,1.564E+00,1.560E+00,1.555E+00,1.550E+00,1.546E+00,1.541E+00,1.536E+00,1.532E+00,1.527E+00,&
	1.523E+00,1.518E+00,1.513E+00,1.509E+00,1.504E+00,1.499E+00,1.495E+00,1.490E+00,1.485E+00,1.481E+00,&
	1.476E+00,1.470E+00,1.464E+00,1.458E+00,1.451E+00,1.445E+00,1.439E+00,1.433E+00,1.427E+00,1.421E+00,&
	1.415E+00,1.408E+00,1.402E+00,1.396E+00,1.390E+00,1.384E+00,1.378E+00,1.371E+00,1.365E+00,1.359E+00,&
	1.353E+00,1.350E+00,1.347E+00,1.344E+00,1.340E+00,1.337E+00,1.334E+00,1.331E+00,1.328E+00,1.325E+00,&
	1.322E+00,1.318E+00,1.315E+00,1.312E+00,1.309E+00,1.306E+00,1.303E+00,1.299E+00,1.296E+00,1.293E+00,&
	1.290E+00,1.281E+00,1.271E+00,1.262E+00,1.253E+00,1.243E+00,1.234E+00,1.225E+00,1.215E+00,1.206E+00,&
	1.197E+00,1.187E+00,1.178E+00,1.168E+00,1.159E+00,1.150E+00,1.140E+00,1.131E+00,1.122E+00,1.112E+00/

		DATA (Ed(i),i=301,400)/&
	1.103E+00,1.085E+00,1.068E+00,1.050E+00,1.032E+00,1.014E+00,9.965E-01,9.788E-01,9.610E-01,9.433E-01,&
	9.255E-01,9.078E-01,8.900E-01,8.723E-01,8.545E-01,8.368E-01,8.190E-01,8.013E-01,7.835E-01,7.658E-01,&
	7.480E-01,7.579E-01,7.677E-01,7.776E-01,7.874E-01,7.973E-01,8.071E-01,8.170E-01,8.268E-01,8.367E-01,&
	8.465E-01,8.564E-01,8.662E-01,8.761E-01,8.859E-01,8.958E-01,9.056E-01,9.155E-01,9.253E-01,9.352E-01,&
	9.450E-01,9.114E-01,8.777E-01,8.441E-01,8.104E-01,7.768E-01,7.431E-01,7.095E-01,6.758E-01,6.422E-01,&
	6.085E-01,5.749E-01,5.412E-01,5.076E-01,4.739E-01,4.403E-01,4.066E-01,3.730E-01,3.393E-01,3.057E-01,&
	2.720E-01,3.015E-01,3.310E-01,3.605E-01,3.900E-01,4.195E-01,4.490E-01,4.785E-01,5.080E-01,5.375E-01,&
	5.670E-01,5.965E-01,6.260E-01,6.555E-01,6.850E-01,7.145E-01,7.440E-01,7.735E-01,8.030E-01,8.325E-01,&
	8.620E-01,8.586E-01,8.552E-01,8.518E-01,8.484E-01,8.450E-01,8.416E-01,8.382E-01,8.348E-01,8.314E-01,&
	8.280E-01,8.246E-01,8.212E-01,8.178E-01,8.144E-01,8.110E-01,8.076E-01,8.042E-01,8.008E-01,7.974E-01/

		DATA (Ed(i),i=401,500)/&
	7.940E-01,7.840E-01,7.739E-01,7.639E-01,7.538E-01,7.438E-01,7.337E-01,7.237E-01,7.136E-01,7.036E-01,&
	6.935E-01,6.835E-01,6.734E-01,6.634E-01,6.533E-01,6.433E-01,6.332E-01,6.232E-01,6.131E-01,6.031E-01,&
	5.930E-01,5.972E-01,6.013E-01,6.055E-01,6.096E-01,6.138E-01,6.179E-01,6.221E-01,6.262E-01,6.304E-01,&
	6.345E-01,6.387E-01,6.428E-01,6.470E-01,6.511E-01,6.553E-01,6.594E-01,6.636E-01,6.677E-01,6.719E-01,&
	6.760E-01,6.752E-01,6.744E-01,6.736E-01,6.728E-01,6.720E-01,6.712E-01,6.704E-01,6.696E-01,6.688E-01,&
	6.680E-01,6.672E-01,6.664E-01,6.656E-01,6.648E-01,6.640E-01,6.632E-01,6.624E-01,6.616E-01,6.608E-01,&
	6.600E-01,6.580E-01,6.560E-01,6.540E-01,6.520E-01,6.500E-01,6.480E-01,6.460E-01,6.440E-01,6.420E-01,&
	6.400E-01,6.380E-01,6.360E-01,6.340E-01,6.320E-01,6.300E-01,6.280E-01,6.260E-01,6.240E-01,6.220E-01,&
	6.200E-01,6.094E-01,5.988E-01,5.882E-01,5.776E-01,5.670E-01,5.564E-01,5.458E-01,5.352E-01,5.246E-01,&
	5.140E-01,5.034E-01,4.928E-01,4.822E-01,4.716E-01,4.610E-01,4.504E-01,4.398E-01,4.292E-01,4.186E-01/

		DATA (Ed(i),i=501,600)/&
	4.080E-01,4.130E-01,4.179E-01,4.229E-01,4.278E-01,4.328E-01,4.377E-01,4.427E-01,4.476E-01,4.526E-01,&
	4.575E-01,4.625E-01,4.674E-01,4.724E-01,4.773E-01,4.823E-01,4.872E-01,4.922E-01,4.971E-01,5.021E-01,&
	5.070E-01,4.948E-01,4.826E-01,4.704E-01,4.582E-01,4.460E-01,4.338E-01,4.216E-01,4.094E-01,3.972E-01,&
	3.850E-01,3.728E-01,3.606E-01,3.484E-01,3.362E-01,3.240E-01,3.118E-01,2.996E-01,2.874E-01,2.752E-01,&
	2.630E-01,2.621E-01,2.611E-01,2.602E-01,2.592E-01,2.583E-01,2.573E-01,2.564E-01,2.554E-01,2.545E-01,&
	2.535E-01,2.526E-01,2.516E-01,2.507E-01,2.497E-01,2.488E-01,2.478E-01,2.469E-01,2.459E-01,2.450E-01,&
	2.440E-01,2.484E-01,2.528E-01,2.572E-01,2.616E-01,2.660E-01,2.704E-01,2.748E-01,2.792E-01,2.836E-01,&
	2.880E-01,2.924E-01,2.968E-01,3.012E-01,3.056E-01,3.100E-01,3.144E-01,3.188E-01,3.232E-01,3.276E-01,&
	3.320E-01,3.344E-01,3.368E-01,3.392E-01,3.416E-01,3.440E-01,3.464E-01,3.488E-01,3.512E-01,3.536E-01,&
	3.560E-01,3.584E-01,3.608E-01,3.632E-01,3.656E-01,3.680E-01,3.704E-01,3.728E-01,3.752E-01,3.776E-01/

		DATA (Ed(i),i=601,700)/&
	3.800E-01,3.786E-01,3.771E-01,3.757E-01,3.742E-01,3.728E-01,3.713E-01,3.699E-01,3.684E-01,3.670E-01,&
	3.655E-01,3.641E-01,3.626E-01,3.612E-01,3.597E-01,3.583E-01,3.568E-01,3.554E-01,3.539E-01,3.525E-01,&
	3.510E-01,3.499E-01,3.487E-01,3.476E-01,3.464E-01,3.453E-01,3.441E-01,3.430E-01,3.418E-01,3.407E-01,&
	3.395E-01,3.384E-01,3.372E-01,3.361E-01,3.349E-01,3.338E-01,3.326E-01,3.315E-01,3.303E-01,3.292E-01,&
	3.280E-01,3.268E-01,3.256E-01,3.244E-01,3.232E-01,3.220E-01,3.208E-01,3.196E-01,3.184E-01,3.172E-01,&
	3.160E-01,3.148E-01,3.136E-01,3.124E-01,3.112E-01,3.100E-01,3.088E-01,3.076E-01,3.064E-01,3.052E-01,&
	3.040E-01,3.023E-01,3.006E-01,2.989E-01,2.972E-01,2.955E-01,2.938E-01,2.921E-01,2.904E-01,2.887E-01,&
	2.870E-01,2.853E-01,2.836E-01,2.819E-01,2.802E-01,2.785E-01,2.768E-01,2.751E-01,2.734E-01,2.717E-01,&
	2.700E-01,2.687E-01,2.674E-01,2.661E-01,2.648E-01,2.635E-01,2.622E-01,2.609E-01,2.596E-01,2.583E-01,&
	2.570E-01,2.557E-01,2.544E-01,2.531E-01,2.518E-01,2.505E-01,2.492E-01,2.479E-01,2.466E-01,2.453E-01/

		DATA (Ed(i),i=701,800)/&
	2.440E-01,2.356E-01,2.271E-01,2.187E-01,2.102E-01,2.018E-01,1.933E-01,1.849E-01,1.764E-01,1.680E-01,&
	1.595E-01,1.511E-01,1.426E-01,1.342E-01,1.257E-01,1.173E-01,1.088E-01,1.004E-01,9.190E-02,8.345E-02,&
	7.500E-02,7.790E-02,8.080E-02,8.370E-02,8.660E-02,8.950E-02,9.240E-02,9.530E-02,9.820E-02,1.011E-01,&
	1.040E-01,1.069E-01,1.098E-01,1.127E-01,1.156E-01,1.185E-01,1.214E-01,1.243E-01,1.272E-01,1.301E-01,&
	1.330E-01,1.328E-01,1.326E-01,1.324E-01,1.322E-01,1.320E-01,1.318E-01,1.316E-01,1.314E-01,1.312E-01,&
	1.310E-01,1.308E-01,1.306E-01,1.304E-01,1.302E-01,1.300E-01,1.298E-01,1.296E-01,1.294E-01,1.292E-01,&
	1.290E-01,1.314E-01,1.337E-01,1.361E-01,1.384E-01,1.408E-01,1.431E-01,1.455E-01,1.478E-01,1.502E-01,&
	1.525E-01,1.549E-01,1.572E-01,1.596E-01,1.619E-01,1.643E-01,1.666E-01,1.690E-01,1.713E-01,1.737E-01,&
	1.760E-01,1.757E-01,1.754E-01,1.751E-01,1.748E-01,1.745E-01,1.742E-01,1.739E-01,1.736E-01,1.733E-01,&
	1.730E-01,1.727E-01,1.724E-01,1.721E-01,1.718E-01,1.715E-01,1.712E-01,1.709E-01,1.706E-01,1.703E-01/

		DATA (Ed(i),i=801,900)/&
	1.700E-01,1.707E-01,1.713E-01,1.720E-01,1.726E-01,1.733E-01,1.739E-01,1.746E-01,1.752E-01,1.759E-01,&
	1.765E-01,1.772E-01,1.778E-01,1.785E-01,1.791E-01,1.798E-01,1.804E-01,1.811E-01,1.817E-01,1.824E-01,&
	1.830E-01,1.826E-01,1.822E-01,1.818E-01,1.814E-01,1.810E-01,1.806E-01,1.802E-01,1.798E-01,1.794E-01,&
	1.790E-01,1.786E-01,1.782E-01,1.778E-01,1.774E-01,1.770E-01,1.766E-01,1.762E-01,1.758E-01,1.754E-01,&
	1.750E-01,1.742E-01,1.734E-01,1.726E-01,1.718E-01,1.710E-01,1.702E-01,1.694E-01,1.686E-01,1.678E-01,&
	1.670E-01,1.662E-01,1.654E-01,1.646E-01,1.638E-01,1.630E-01,1.622E-01,1.614E-01,1.606E-01,1.598E-01,&
	1.590E-01,1.585E-01,1.579E-01,1.574E-01,1.568E-01,1.563E-01,1.557E-01,1.552E-01,1.546E-01,1.541E-01,&
	1.535E-01,1.530E-01,1.524E-01,1.519E-01,1.513E-01,1.508E-01,1.502E-01,1.497E-01,1.491E-01,1.486E-01,&
	1.480E-01,1.472E-01,1.463E-01,1.455E-01,1.446E-01,1.438E-01,1.429E-01,1.421E-01,1.412E-01,1.404E-01,&
	1.395E-01,1.387E-01,1.378E-01,1.370E-01,1.361E-01,1.353E-01,1.344E-01,1.336E-01,1.327E-01,1.319E-01/

		DATA (Ed(i),i=901,1000)/&
	1.310E-01,1.291E-01,1.271E-01,1.252E-01,1.232E-01,1.213E-01,1.193E-01,1.174E-01,1.154E-01,1.135E-01,&
	1.115E-01,1.096E-01,1.076E-01,1.057E-01,1.037E-01,1.018E-01,9.980E-02,9.785E-02,9.590E-02,9.395E-02,&
	9.200E-02,9.110E-02,9.020E-02,8.930E-02,8.840E-02,8.750E-02,8.660E-02,8.570E-02,8.480E-02,8.390E-02,&
	8.300E-02,8.210E-02,8.120E-02,8.030E-02,7.940E-02,7.850E-02,7.760E-02,7.670E-02,7.580E-02,7.490E-02,&
	7.400E-02,7.040E-02,6.680E-02,6.320E-02,5.960E-02,5.600E-02,5.240E-02,4.880E-02,4.520E-02,4.160E-02,&
	3.800E-02,3.440E-02,3.080E-02,2.720E-02,2.360E-02,2.000E-02,1.640E-02,1.280E-02,9.200E-03,5.600E-03,&
	2.000E-03,1.950E-03,1.900E-03,1.850E-03,1.800E-03,1.750E-03,1.700E-03,1.650E-03,1.600E-03,1.550E-03,&
	1.500E-03,1.450E-03,1.400E-03,1.350E-03,1.300E-03,1.250E-03,1.200E-03,1.150E-03,1.100E-03,1.050E-03,&
	1.000E-03,1.250E-03,1.500E-03,1.750E-03,2.000E-03,2.250E-03,2.500E-03,2.750E-03,3.000E-03,3.250E-03,&
	3.500E-03,3.750E-03,4.000E-03,4.250E-03,4.500E-03,4.750E-03,5.000E-03,5.250E-03,5.500E-03,5.750E-03/

		DATA (Ed(i),i=1001,1100)/&
	6.000E-03,5.950E-03,5.900E-03,5.850E-03,5.800E-03,5.750E-03,5.700E-03,5.650E-03,5.600E-03,5.550E-03,&
	5.500E-03,5.450E-03,5.400E-03,5.350E-03,5.300E-03,5.250E-03,5.200E-03,5.150E-03,5.100E-03,5.050E-03,&
	5.000E-03,5.450E-03,5.900E-03,6.350E-03,6.800E-03,7.250E-03,7.700E-03,8.150E-03,8.600E-03,9.050E-03,&
	9.500E-03,9.950E-03,1.040E-02,1.085E-02,1.130E-02,1.175E-02,1.220E-02,1.265E-02,1.310E-02,1.355E-02,&
	1.400E-02,1.505E-02,1.610E-02,1.715E-02,1.820E-02,1.925E-02,2.030E-02,2.135E-02,2.240E-02,2.345E-02,&
	2.450E-02,2.555E-02,2.660E-02,2.765E-02,2.870E-02,2.975E-02,3.080E-02,3.185E-02,3.290E-02,3.395E-02,&
	3.500E-02,3.495E-02,3.490E-02,3.485E-02,3.480E-02,3.475E-02,3.470E-02,3.465E-02,3.460E-02,3.455E-02,&
	3.450E-02,3.445E-02,3.440E-02,3.435E-02,3.430E-02,3.425E-02,3.420E-02,3.415E-02,3.410E-02,3.405E-02,&
	3.400E-02,3.690E-02,3.980E-02,4.270E-02,4.560E-02,4.850E-02,5.140E-02,5.430E-02,5.720E-02,6.010E-02,&
	6.300E-02,6.590E-02,6.880E-02,7.170E-02,7.460E-02,7.750E-02,8.040E-02,8.330E-02,8.620E-02,8.910E-02/

		DATA (Ed(i),i=1101,1200)/&
	9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,&
	9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,9.200E-02,&
	9.200E-02,9.210E-02,9.220E-02,9.230E-02,9.240E-02,9.250E-02,9.260E-02,9.270E-02,9.280E-02,9.290E-02,&
	9.300E-02,9.310E-02,9.320E-02,9.330E-02,9.340E-02,9.350E-02,9.360E-02,9.370E-02,9.380E-02,9.390E-02,&
	9.400E-02,9.390E-02,9.380E-02,9.370E-02,9.360E-02,9.350E-02,9.340E-02,9.330E-02,9.320E-02,9.310E-02,&
	9.300E-02,9.290E-02,9.280E-02,9.270E-02,9.260E-02,9.250E-02,9.240E-02,9.230E-02,9.220E-02,9.210E-02,&
	9.200E-02,9.155E-02,9.110E-02,9.065E-02,9.020E-02,8.975E-02,8.930E-02,8.885E-02,8.840E-02,8.795E-02,&
	8.750E-02,8.705E-02,8.660E-02,8.615E-02,8.570E-02,8.525E-02,8.480E-02,8.435E-02,8.390E-02,8.345E-02,&
	8.300E-02,8.290E-02,8.280E-02,8.270E-02,8.260E-02,8.250E-02,8.240E-02,8.230E-02,8.220E-02,8.210E-02,&
	8.200E-02,8.190E-02,8.180E-02,8.170E-02,8.160E-02,8.150E-02,8.140E-02,8.130E-02,8.120E-02,8.110E-02/

		DATA (Ed(i),i=1201,1300)/&
	8.100E-02,8.085E-02,8.070E-02,8.055E-02,8.040E-02,8.025E-02,8.010E-02,7.995E-02,7.980E-02,7.965E-02,&
	7.950E-02,7.935E-02,7.920E-02,7.905E-02,7.890E-02,7.875E-02,7.860E-02,7.845E-02,7.830E-02,7.815E-02,&
	7.800E-02,7.770E-02,7.740E-02,7.710E-02,7.680E-02,7.650E-02,7.620E-02,7.590E-02,7.560E-02,7.530E-02,&
	7.500E-02,7.470E-02,7.440E-02,7.410E-02,7.380E-02,7.350E-02,7.320E-02,7.290E-02,7.260E-02,7.230E-02,&
	7.200E-02,7.190E-02,7.180E-02,7.170E-02,7.160E-02,7.150E-02,7.140E-02,7.130E-02,7.120E-02,7.110E-02,&
	7.100E-02,7.090E-02,7.080E-02,7.070E-02,7.060E-02,7.050E-02,7.040E-02,7.030E-02,7.020E-02,7.010E-02,&
	7.000E-02,6.975E-02,6.950E-02,6.925E-02,6.900E-02,6.875E-02,6.850E-02,6.825E-02,6.800E-02,6.775E-02,&
	6.750E-02,6.725E-02,6.700E-02,6.675E-02,6.650E-02,6.625E-02,6.600E-02,6.575E-02,6.550E-02,6.525E-02,&
	6.500E-02,6.480E-02,6.460E-02,6.440E-02,6.420E-02,6.400E-02,6.380E-02,6.360E-02,6.340E-02,6.320E-02,&
	6.300E-02,6.280E-02,6.260E-02,6.240E-02,6.220E-02,6.200E-02,6.180E-02,6.160E-02,6.140E-02,6.120E-02/

		DATA (Ed(i),i=1301,1400)/&
	6.100E-02,6.090E-02,6.080E-02,6.070E-02,6.060E-02,6.050E-02,6.040E-02,6.030E-02,6.020E-02,6.010E-02,&
	6.000E-02,5.990E-02,5.980E-02,5.970E-02,5.960E-02,5.950E-02,5.940E-02,5.930E-02,5.920E-02,5.910E-02,&
	5.900E-02,5.830E-02,5.760E-02,5.690E-02,5.620E-02,5.550E-02,5.480E-02,5.410E-02,5.340E-02,5.270E-02,&
	5.200E-02,5.130E-02,5.060E-02,4.990E-02,4.920E-02,4.850E-02,4.780E-02,4.710E-02,4.640E-02,4.570E-02,&
	4.500E-02,4.535E-02,4.570E-02,4.605E-02,4.640E-02,4.675E-02,4.710E-02,4.745E-02,4.780E-02,4.815E-02,&
	4.850E-02,4.885E-02,4.920E-02,4.955E-02,4.990E-02,5.025E-02,5.060E-02,5.095E-02,5.130E-02,5.165E-02,&
	5.200E-02,5.085E-02,4.970E-02,4.855E-02,4.740E-02,4.625E-02,4.510E-02,4.395E-02,4.280E-02,4.165E-02,&
	4.050E-02,3.935E-02,3.820E-02,3.705E-02,3.590E-02,3.475E-02,3.360E-02,3.245E-02,3.130E-02,3.015E-02,&
	2.900E-02,2.790E-02,2.680E-02,2.570E-02,2.460E-02,2.350E-02,2.240E-02,2.130E-02,2.020E-02,1.910E-02,&
	1.800E-02,1.690E-02,1.580E-02,1.470E-02,1.360E-02,1.250E-02,1.140E-02,1.030E-02,9.200E-03,8.100E-03/

		DATA (Ed(i),i=1401,1500)/&
	7.000E-03,6.700E-03,6.400E-03,6.100E-03,5.800E-03,5.500E-03,5.200E-03,4.900E-03,4.600E-03,4.300E-03,&
	4.000E-03,3.700E-03,3.400E-03,3.100E-03,2.800E-03,2.500E-03,2.200E-03,1.900E-03,1.600E-03,1.300E-03,&
	1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,&
	1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,1.000E-03,&
	1.000E-03,9.500E-04,9.000E-04,8.500E-04,8.000E-04,7.500E-04,7.000E-04,6.500E-04,6.000E-04,5.500E-04,&
	5.000E-04,4.500E-04,4.000E-04,3.500E-04,3.000E-04,2.500E-04,2.000E-04,1.500E-04,1.000E-04,5.000E-05,&
	0.335E-17,2.000E-04,4.000E-04,6.000E-04,8.000E-04,1.000E-03,1.200E-03,1.400E-03,1.600E-03,1.800E-03,&
	2.000E-03,2.200E-03,2.400E-03,2.600E-03,2.800E-03,3.000E-03,3.200E-03,3.400E-03,3.600E-03,3.800E-03,&
	4.000E-03,3.800E-03,3.600E-03,3.400E-03,3.200E-03,3.000E-03,2.800E-03,2.600E-03,2.400E-03,2.200E-03,&
	2.000E-03,1.800E-03,1.600E-03,1.400E-03,1.200E-03,1.000E-03,8.000E-04,6.000E-04,4.000E-04,2.000E-04/

		DATA (Ed(i),i=1501,1600)/&
	0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,&
	0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,0.000E+00,&
	0.000E+00,5.000E-05,1.000E-04,1.500E-04,2.000E-04,2.500E-04,3.000E-04,3.500E-04,4.000E-04,4.500E-04,&
	5.000E-04,5.500E-04,6.000E-04,6.500E-04,7.000E-04,7.500E-04,8.000E-04,8.500E-04,9.000E-04,9.500E-04,&
	1.000E-03,1.200E-03,1.400E-03,1.600E-03,1.800E-03,2.000E-03,2.200E-03,2.400E-03,2.600E-03,2.800E-03,&
	3.000E-03,3.200E-03,3.400E-03,3.600E-03,3.800E-03,4.000E-03,4.200E-03,4.400E-03,4.600E-03,4.800E-03,&
	5.000E-03,5.650E-03,6.300E-03,6.950E-03,7.600E-03,8.250E-03,8.900E-03,9.550E-03,1.020E-02,1.085E-02,&
	1.150E-02,1.215E-02,1.280E-02,1.345E-02,1.410E-02,1.475E-02,1.540E-02,1.605E-02,1.670E-02,1.735E-02,&
	1.800E-02,1.785E-02,1.770E-02,1.755E-02,1.740E-02,1.725E-02,1.710E-02,1.695E-02,1.680E-02,1.665E-02,&
	1.650E-02,1.635E-02,1.620E-02,1.605E-02,1.590E-02,1.575E-02,1.560E-02,1.545E-02,1.530E-02,1.515E-02/

		DATA (Ed(i),i=1601,1700)/&
	1.500E-02,1.465E-02,1.430E-02,1.395E-02,1.360E-02,1.325E-02,1.290E-02,1.255E-02,1.220E-02,1.185E-02,&
	1.150E-02,1.115E-02,1.080E-02,1.045E-02,1.010E-02,9.750E-03,9.400E-03,9.050E-03,8.700E-03,8.350E-03,&
	8.000E-03,8.800E-03,9.600E-03,1.040E-02,1.120E-02,1.200E-02,1.280E-02,1.360E-02,1.440E-02,1.520E-02,&
	1.600E-02,1.680E-02,1.760E-02,1.840E-02,1.920E-02,2.000E-02,2.080E-02,2.160E-02,2.240E-02,2.320E-02,&
	2.400E-02,2.370E-02,2.340E-02,2.310E-02,2.280E-02,2.250E-02,2.220E-02,2.190E-02,2.160E-02,2.130E-02,&
	2.100E-02,2.070E-02,2.040E-02,2.010E-02,1.980E-02,1.950E-02,1.920E-02,1.890E-02,1.860E-02,1.830E-02,&
	1.800E-02,1.825E-02,1.850E-02,1.875E-02,1.900E-02,1.925E-02,1.950E-02,1.975E-02,2.000E-02,2.025E-02,&
	2.050E-02,2.075E-02,2.100E-02,2.125E-02,2.150E-02,2.175E-02,2.200E-02,2.225E-02,2.250E-02,2.275E-02,&
	2.300E-02,2.290E-02,2.280E-02,2.270E-02,2.260E-02,2.250E-02,2.240E-02,2.230E-02,2.220E-02,2.210E-02,&
	2.200E-02,2.190E-02,2.180E-02,2.170E-02,2.160E-02,2.150E-02,2.140E-02,2.130E-02,2.120E-02,2.110E-02/

		DATA (Ed(i),i=1701,1800)/&
	2.100E-02,2.105E-02,2.110E-02,2.115E-02,2.120E-02,2.125E-02,2.130E-02,2.135E-02,2.140E-02,2.145E-02,&
	2.150E-02,2.155E-02,2.160E-02,2.165E-02,2.170E-02,2.175E-02,2.180E-02,2.185E-02,2.190E-02,2.195E-02,&
	2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,&
	2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,2.200E-02,&
	2.200E-02,2.185E-02,2.170E-02,2.155E-02,2.140E-02,2.125E-02,2.110E-02,2.095E-02,2.080E-02,2.065E-02,&
	2.050E-02,2.035E-02,2.020E-02,2.005E-02,1.990E-02,1.975E-02,1.960E-02,1.945E-02,1.930E-02,1.915E-02,&
	1.900E-02,1.895E-02,1.890E-02,1.885E-02,1.880E-02,1.875E-02,1.870E-02,1.865E-02,1.860E-02,1.855E-02,&
	1.850E-02,1.845E-02,1.840E-02,1.835E-02,1.830E-02,1.825E-02,1.820E-02,1.815E-02,1.810E-02,1.805E-02,&
	1.800E-02,1.790E-02,1.780E-02,1.770E-02,1.760E-02,1.750E-02,1.740E-02,1.730E-02,1.720E-02,1.710E-02,&
	1.700E-02,1.690E-02,1.680E-02,1.670E-02,1.660E-02,1.650E-02,1.640E-02,1.630E-02,1.620E-02,1.610E-02/

		DATA (Ed(i),i=1801,1900)/&
	1.600E-02,1.610E-02,1.620E-02,1.630E-02,1.640E-02,1.650E-02,1.660E-02,1.670E-02,1.680E-02,1.690E-02,&
	1.700E-02,1.710E-02,1.720E-02,1.730E-02,1.740E-02,1.750E-02,1.760E-02,1.770E-02,1.780E-02,1.790E-02,&
	1.800E-02,1.795E-02,1.790E-02,1.785E-02,1.780E-02,1.775E-02,1.770E-02,1.765E-02,1.760E-02,1.755E-02,&
	1.750E-02,1.745E-02,1.740E-02,1.735E-02,1.730E-02,1.725E-02,1.720E-02,1.715E-02,1.710E-02,1.705E-02,&
	1.700E-02,1.695E-02,1.690E-02,1.685E-02,1.680E-02,1.675E-02,1.670E-02,1.665E-02,1.660E-02,1.655E-02,&
	1.650E-02,1.645E-02,1.640E-02,1.635E-02,1.630E-02,1.625E-02,1.620E-02,1.615E-02,1.610E-02,1.605E-02,&
	1.600E-02,1.595E-02,1.590E-02,1.585E-02,1.580E-02,1.575E-02,1.570E-02,1.565E-02,1.560E-02,1.555E-02,&
	1.550E-02,1.545E-02,1.540E-02,1.535E-02,1.530E-02,1.525E-02,1.520E-02,1.515E-02,1.510E-02,1.505E-02,&
	1.500E-02,1.495E-02,1.490E-02,1.485E-02,1.480E-02,1.475E-02,1.470E-02,1.465E-02,1.460E-02,1.455E-02,&
	1.450E-02,1.445E-02,1.440E-02,1.435E-02,1.430E-02,1.425E-02,1.420E-02,1.415E-02,1.410E-02,1.405E-02/

		DATA (Ed(i),i=1901,2000)/&
	1.400E-02,1.385E-02,1.370E-02,1.355E-02,1.340E-02,1.325E-02,1.310E-02,1.295E-02,1.280E-02,1.265E-02,&
	1.250E-02,1.235E-02,1.220E-02,1.205E-02,1.190E-02,1.175E-02,1.160E-02,1.145E-02,1.130E-02,1.115E-02,&
	1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,&
	1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,&
	1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,&
	1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,1.100E-02,&
	1.100E-02,1.090E-02,1.080E-02,1.070E-02,1.060E-02,1.050E-02,1.040E-02,1.030E-02,1.020E-02,1.010E-02,&
	1.000E-02,9.900E-03,9.800E-03,9.700E-03,9.600E-03,9.500E-03,9.400E-03,9.300E-03,9.200E-03,9.100E-03,&
	9.000E-03,9.100E-03,9.200E-03,9.300E-03,9.400E-03,9.500E-03,9.600E-03,9.700E-03,9.800E-03,9.900E-03,&
	1.000E-02,1.010E-02,1.020E-02,1.030E-02,1.040E-02,1.050E-02,1.060E-02,1.070E-02,1.080E-02,1.090E-02/

		DATA (Ed(i),i=2001,2101)/&
	1.100E-02,1.070E-02,1.040E-02,1.010E-02,9.800E-03,9.500E-03,9.200E-03,8.900E-03,8.600E-03,8.300E-03,&
	8.000E-03,7.700E-03,7.400E-03,7.100E-03,6.800E-03,6.500E-03,6.200E-03,5.900E-03,5.600E-03,5.300E-03,&
	5.000E-03,5.250E-03,5.500E-03,5.750E-03,6.000E-03,6.250E-03,6.500E-03,6.750E-03,7.000E-03,7.250E-03,&
	7.500E-03,7.750E-03,8.000E-03,8.250E-03,8.500E-03,8.750E-03,9.000E-03,9.250E-03,9.500E-03,9.750E-03,&
	1.000E-02,9.800E-03,9.600E-03,9.400E-03,9.200E-03,9.000E-03,8.800E-03,8.600E-03,8.400E-03,8.200E-03,&
	8.000E-03,7.800E-03,7.600E-03,7.400E-03,7.200E-03,7.000E-03,6.800E-03,6.600E-03,6.400E-03,6.200E-03,&
	6.000E-03,5.950E-03,5.900E-03,5.850E-03,5.800E-03,5.750E-03,5.700E-03,5.650E-03,5.600E-03,5.550E-03,&
	5.500E-03,5.450E-03,5.400E-03,5.350E-03,5.300E-03,5.250E-03,5.200E-03,5.150E-03,5.100E-03,5.050E-03,&
	5.000E-03,4.850E-03,4.700E-03,4.550E-03,4.400E-03,4.250E-03,4.100E-03,3.950E-03,3.800E-03,3.650E-03,&
	3.500E-03,3.350E-03,3.200E-03,3.050E-03,2.900E-03,2.750E-03,2.600E-03,2.450E-03,2.300E-03,2.150E-03,&
	2.000E-03/


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!						soil 1 reflectance							!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (Rsoil1(i),i=1,100)/&
	2.377E-01,2.373E-01,2.369E-01,2.365E-01,2.360E-01,2.356E-01,2.352E-01,2.348E-01,2.344E-01,2.340E-01,&
	2.336E-01,2.332E-01,2.328E-01,2.324E-01,2.320E-01,2.316E-01,2.312E-01,2.308E-01,2.304E-01,2.299E-01,&
	2.295E-01,2.290E-01,2.284E-01,2.278E-01,2.272E-01,2.267E-01,2.263E-01,2.259E-01,2.254E-01,2.250E-01,&
	2.246E-01,2.243E-01,2.240E-01,2.237E-01,2.234E-01,2.231E-01,2.228E-01,2.224E-01,2.221E-01,2.218E-01,&
	2.215E-01,2.215E-01,2.215E-01,2.215E-01,2.215E-01,2.214E-01,2.215E-01,2.215E-01,2.216E-01,2.217E-01,&
	2.217E-01,2.218E-01,2.219E-01,2.219E-01,2.220E-01,2.221E-01,2.222E-01,2.224E-01,2.225E-01,2.227E-01,&
	2.228E-01,2.230E-01,2.231E-01,2.233E-01,2.234E-01,2.236E-01,2.238E-01,2.240E-01,2.241E-01,2.243E-01,&
	2.245E-01,2.247E-01,2.249E-01,2.251E-01,2.253E-01,2.256E-01,2.258E-01,2.260E-01,2.262E-01,2.264E-01,&
	2.266E-01,2.269E-01,2.271E-01,2.273E-01,2.276E-01,2.278E-01,2.280E-01,2.283E-01,2.285E-01,2.287E-01,&
	2.289E-01,2.293E-01,2.297E-01,2.302E-01,2.306E-01,2.310E-01,2.314E-01,2.319E-01,2.324E-01,2.329E-01/

		DATA (Rsoil1(i),i=101,200)/&
	2.333E-01,2.340E-01,2.346E-01,2.353E-01,2.359E-01,2.366E-01,2.371E-01,2.376E-01,2.381E-01,2.387E-01,&
	2.392E-01,2.396E-01,2.400E-01,2.405E-01,2.409E-01,2.413E-01,2.418E-01,2.422E-01,2.427E-01,2.431E-01,&
	2.436E-01,2.441E-01,2.446E-01,2.452E-01,2.457E-01,2.462E-01,2.467E-01,2.472E-01,2.477E-01,2.482E-01,&
	2.487E-01,2.492E-01,2.497E-01,2.502E-01,2.507E-01,2.512E-01,2.517E-01,2.522E-01,2.527E-01,2.532E-01,&
	2.537E-01,2.542E-01,2.546E-01,2.551E-01,2.556E-01,2.561E-01,2.566E-01,2.571E-01,2.576E-01,2.582E-01,&
	2.587E-01,2.592E-01,2.598E-01,2.603E-01,2.609E-01,2.614E-01,2.620E-01,2.626E-01,2.631E-01,2.637E-01,&
	2.642E-01,2.647E-01,2.651E-01,2.655E-01,2.659E-01,2.664E-01,2.667E-01,2.671E-01,2.675E-01,2.679E-01,&
	2.683E-01,2.686E-01,2.690E-01,2.694E-01,2.698E-01,2.702E-01,2.707E-01,2.712E-01,2.717E-01,2.722E-01,&
	2.727E-01,2.732E-01,2.737E-01,2.742E-01,2.747E-01,2.752E-01,2.757E-01,2.762E-01,2.767E-01,2.772E-01,&
	2.777E-01,2.782E-01,2.787E-01,2.792E-01,2.797E-01,2.802E-01,2.807E-01,2.812E-01,2.818E-01,2.823E-01/

		DATA (Rsoil1(i),i=201,300)/&
	2.828E-01,2.833E-01,2.838E-01,2.844E-01,2.849E-01,2.855E-01,2.861E-01,2.866E-01,2.872E-01,2.878E-01,&
	2.884E-01,2.890E-01,2.896E-01,2.902E-01,2.908E-01,2.913E-01,2.919E-01,2.924E-01,2.929E-01,2.934E-01,&
	2.939E-01,2.944E-01,2.950E-01,2.955E-01,2.960E-01,2.965E-01,2.970E-01,2.975E-01,2.980E-01,2.985E-01,&
	2.990E-01,2.995E-01,2.999E-01,3.004E-01,3.008E-01,3.013E-01,3.017E-01,3.022E-01,3.026E-01,3.030E-01,&
	3.035E-01,3.039E-01,3.044E-01,3.048E-01,3.053E-01,3.057E-01,3.062E-01,3.066E-01,3.071E-01,3.075E-01,&
	3.080E-01,3.086E-01,3.092E-01,3.097E-01,3.103E-01,3.109E-01,3.117E-01,3.125E-01,3.133E-01,3.141E-01,&
	3.149E-01,3.156E-01,3.162E-01,3.169E-01,3.176E-01,3.182E-01,3.188E-01,3.193E-01,3.199E-01,3.204E-01,&
	3.210E-01,3.216E-01,3.221E-01,3.227E-01,3.232E-01,3.238E-01,3.244E-01,3.250E-01,3.257E-01,3.263E-01,&
	3.269E-01,3.275E-01,3.281E-01,3.288E-01,3.294E-01,3.300E-01,3.304E-01,3.309E-01,3.313E-01,3.317E-01,&
	3.322E-01,3.325E-01,3.328E-01,3.332E-01,3.335E-01,3.338E-01,3.341E-01,3.345E-01,3.348E-01,3.351E-01/

		DATA (Rsoil1(i),i=301,400)/&
	3.355E-01,3.361E-01,3.367E-01,3.373E-01,3.379E-01,3.385E-01,3.392E-01,3.398E-01,3.405E-01,3.412E-01,&
	3.418E-01,3.424E-01,3.429E-01,3.434E-01,3.439E-01,3.444E-01,3.449E-01,3.454E-01,3.459E-01,3.464E-01,&
	3.469E-01,3.476E-01,3.483E-01,3.490E-01,3.497E-01,3.504E-01,3.512E-01,3.520E-01,3.529E-01,3.537E-01,&
	3.545E-01,3.549E-01,3.553E-01,3.557E-01,3.560E-01,3.564E-01,3.568E-01,3.572E-01,3.575E-01,3.579E-01,&
	3.583E-01,3.587E-01,3.591E-01,3.595E-01,3.600E-01,3.604E-01,3.609E-01,3.615E-01,3.621E-01,3.626E-01,&
	3.632E-01,3.637E-01,3.643E-01,3.649E-01,3.654E-01,3.660E-01,3.667E-01,3.674E-01,3.681E-01,3.688E-01,&
	3.695E-01,3.700E-01,3.705E-01,3.710E-01,3.715E-01,3.719E-01,3.722E-01,3.725E-01,3.728E-01,3.731E-01,&
	3.733E-01,3.736E-01,3.739E-01,3.742E-01,3.745E-01,3.747E-01,3.752E-01,3.758E-01,3.763E-01,3.768E-01,&
	3.773E-01,3.778E-01,3.783E-01,3.789E-01,3.794E-01,3.799E-01,3.804E-01,3.808E-01,3.813E-01,3.817E-01,&
	3.822E-01,3.825E-01,3.829E-01,3.832E-01,3.836E-01,3.839E-01,3.843E-01,3.846E-01,3.850E-01,3.853E-01/

		DATA (Rsoil1(i),i=401,500)/&
	3.857E-01,3.862E-01,3.866E-01,3.871E-01,3.876E-01,3.881E-01,3.886E-01,3.891E-01,3.896E-01,3.901E-01,&
	3.906E-01,3.911E-01,3.917E-01,3.922E-01,3.928E-01,3.933E-01,3.939E-01,3.944E-01,3.950E-01,3.955E-01,&
	3.961E-01,3.966E-01,3.971E-01,3.976E-01,3.981E-01,3.987E-01,3.991E-01,3.995E-01,3.999E-01,4.003E-01,&
	4.007E-01,4.010E-01,4.013E-01,4.015E-01,4.018E-01,4.021E-01,4.023E-01,4.026E-01,4.028E-01,4.031E-01,&
	4.034E-01,4.038E-01,4.043E-01,4.047E-01,4.052E-01,4.056E-01,4.061E-01,4.066E-01,4.070E-01,4.075E-01,&
	4.079E-01,4.082E-01,4.085E-01,4.088E-01,4.091E-01,4.094E-01,4.097E-01,4.099E-01,4.102E-01,4.104E-01,&
	4.107E-01,4.110E-01,4.113E-01,4.116E-01,4.119E-01,4.122E-01,4.128E-01,4.134E-01,4.139E-01,4.145E-01,&
	4.150E-01,4.155E-01,4.160E-01,4.165E-01,4.170E-01,4.175E-01,4.178E-01,4.182E-01,4.185E-01,4.189E-01,&
	4.193E-01,4.196E-01,4.200E-01,4.204E-01,4.207E-01,4.211E-01,4.214E-01,4.217E-01,4.221E-01,4.224E-01,&
	4.227E-01,4.230E-01,4.232E-01,4.235E-01,4.237E-01,4.240E-01,4.242E-01,4.245E-01,4.247E-01,4.250E-01/
		
		DATA (Rsoil1(i),i=501,600)/&
	4.252E-01,4.255E-01,4.258E-01,4.261E-01,4.264E-01,4.267E-01,4.270E-01,4.274E-01,4.277E-01,4.281E-01,&
	4.284E-01,4.288E-01,4.291E-01,4.295E-01,4.298E-01,4.302E-01,4.306E-01,4.311E-01,4.315E-01,4.319E-01,&
	4.324E-01,4.328E-01,4.333E-01,4.337E-01,4.342E-01,4.346E-01,4.351E-01,4.355E-01,4.359E-01,4.364E-01,&
	4.368E-01,4.370E-01,4.373E-01,4.376E-01,4.378E-01,4.381E-01,4.384E-01,4.386E-01,4.389E-01,4.392E-01,&
	4.394E-01,4.397E-01,4.400E-01,4.403E-01,4.406E-01,4.409E-01,4.412E-01,4.415E-01,4.418E-01,4.421E-01,&
	4.424E-01,4.427E-01,4.430E-01,4.433E-01,4.436E-01,4.438E-01,4.439E-01,4.440E-01,4.441E-01,4.441E-01,&
	4.442E-01,4.443E-01,4.444E-01,4.445E-01,4.446E-01,4.447E-01,4.450E-01,4.453E-01,4.456E-01,4.459E-01,&
	4.462E-01,4.465E-01,4.468E-01,4.471E-01,4.474E-01,4.477E-01,4.479E-01,4.482E-01,4.485E-01,4.487E-01,&
	4.490E-01,4.492E-01,4.495E-01,4.497E-01,4.500E-01,4.502E-01,4.506E-01,4.509E-01,4.513E-01,4.516E-01,&
	4.520E-01,4.525E-01,4.530E-01,4.535E-01,4.540E-01,4.545E-01,4.549E-01,4.553E-01,4.557E-01,4.561E-01/

		DATA (Rsoil1(i),i=601,700)/&
	4.565E-01,4.568E-01,4.571E-01,4.573E-01,4.576E-01,4.579E-01,4.579E-01,4.580E-01,4.580E-01,4.580E-01,&
	4.581E-01,4.582E-01,4.583E-01,4.584E-01,4.585E-01,4.586E-01,4.589E-01,4.591E-01,4.594E-01,4.597E-01,&
	4.599E-01,4.602E-01,4.604E-01,4.606E-01,4.608E-01,4.611E-01,4.613E-01,4.614E-01,4.616E-01,4.618E-01,&
	4.620E-01,4.622E-01,4.623E-01,4.625E-01,4.627E-01,4.628E-01,4.628E-01,4.627E-01,4.627E-01,4.627E-01,&
	4.626E-01,4.626E-01,4.626E-01,4.625E-01,4.625E-01,4.625E-01,4.625E-01,4.626E-01,4.626E-01,4.627E-01,&
	4.628E-01,4.628E-01,4.629E-01,4.630E-01,4.631E-01,4.631E-01,4.632E-01,4.633E-01,4.634E-01,4.635E-01,&
	4.636E-01,4.640E-01,4.645E-01,4.649E-01,4.653E-01,4.658E-01,4.661E-01,4.664E-01,4.667E-01,4.670E-01,&
	4.673E-01,4.673E-01,4.674E-01,4.675E-01,4.676E-01,4.677E-01,4.677E-01,4.678E-01,4.679E-01,4.680E-01,&
	4.681E-01,4.682E-01,4.684E-01,4.685E-01,4.687E-01,4.688E-01,4.690E-01,4.692E-01,4.694E-01,4.696E-01,&
	4.698E-01,4.701E-01,4.704E-01,4.708E-01,4.711E-01,4.714E-01,4.715E-01,4.716E-01,4.716E-01,4.717E-01/

		DATA (Rsoil1(i),i=701,800)/&
	4.718E-01,4.717E-01,4.717E-01,4.716E-01,4.716E-01,4.715E-01,4.718E-01,4.720E-01,4.723E-01,4.725E-01,&
	4.728E-01,4.731E-01,4.733E-01,4.736E-01,4.739E-01,4.742E-01,4.743E-01,4.745E-01,4.746E-01,4.748E-01,&
	4.749E-01,4.749E-01,4.749E-01,4.749E-01,4.749E-01,4.749E-01,4.749E-01,4.749E-01,4.749E-01,4.749E-01,&
	4.749E-01,4.751E-01,4.753E-01,4.755E-01,4.757E-01,4.759E-01,4.761E-01,4.764E-01,4.766E-01,4.768E-01,&
	4.770E-01,4.773E-01,4.775E-01,4.777E-01,4.779E-01,4.782E-01,4.784E-01,4.786E-01,4.788E-01,4.791E-01,&
	4.793E-01,4.793E-01,4.794E-01,4.794E-01,4.795E-01,4.796E-01,4.795E-01,4.795E-01,4.795E-01,4.795E-01,&
	4.795E-01,4.799E-01,4.802E-01,4.805E-01,4.808E-01,4.811E-01,4.811E-01,4.811E-01,4.811E-01,4.811E-01,&
	4.811E-01,4.813E-01,4.815E-01,4.816E-01,4.818E-01,4.820E-01,4.825E-01,4.829E-01,4.833E-01,4.838E-01,&
	4.842E-01,4.845E-01,4.847E-01,4.850E-01,4.852E-01,4.855E-01,4.857E-01,4.858E-01,4.860E-01,4.862E-01,&
	4.864E-01,4.863E-01,4.863E-01,4.863E-01,4.863E-01,4.863E-01,4.863E-01,4.864E-01,4.864E-01,4.864E-01/

		DATA (Rsoil1(i),i=801,900)/&
	4.864E-01,4.866E-01,4.868E-01,4.870E-01,4.872E-01,4.874E-01,4.875E-01,4.875E-01,4.876E-01,4.877E-01,&
	4.877E-01,4.878E-01,4.878E-01,4.878E-01,4.878E-01,4.879E-01,4.881E-01,4.884E-01,4.887E-01,4.889E-01,&
	4.892E-01,4.893E-01,4.893E-01,4.894E-01,4.895E-01,4.896E-01,4.897E-01,4.897E-01,4.898E-01,4.899E-01,&
	4.900E-01,4.901E-01,4.902E-01,4.903E-01,4.904E-01,4.905E-01,4.907E-01,4.909E-01,4.912E-01,4.914E-01,&
	4.916E-01,4.919E-01,4.921E-01,4.924E-01,4.926E-01,4.929E-01,4.929E-01,4.929E-01,4.930E-01,4.930E-01,&
	4.930E-01,4.929E-01,4.928E-01,4.927E-01,4.926E-01,4.924E-01,4.926E-01,4.928E-01,4.930E-01,4.932E-01,&
	4.934E-01,4.935E-01,4.936E-01,4.937E-01,4.938E-01,4.939E-01,4.939E-01,4.940E-01,4.940E-01,4.941E-01,&
	4.941E-01,4.942E-01,4.943E-01,4.945E-01,4.946E-01,4.947E-01,4.948E-01,4.950E-01,4.951E-01,4.953E-01,&
	4.954E-01,4.957E-01,4.959E-01,4.962E-01,4.965E-01,4.967E-01,4.969E-01,4.972E-01,4.974E-01,4.976E-01,&
	4.979E-01,4.980E-01,4.982E-01,4.984E-01,4.986E-01,4.988E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01/

		DATA (Rsoil1(i),i=901,1000)/&
	4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,&
	4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,&
	4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.986E-01,4.986E-01,4.986E-01,4.986E-01,&
	4.986E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.987E-01,4.989E-01,4.990E-01,4.991E-01,4.993E-01,&
	4.994E-01,4.996E-01,4.997E-01,4.999E-01,5.000E-01,5.002E-01,5.002E-01,5.003E-01,5.003E-01,5.003E-01,&
	5.004E-01,5.004E-01,5.004E-01,5.004E-01,5.004E-01,5.004E-01,5.002E-01,5.000E-01,4.998E-01,4.996E-01,&
	4.995E-01,4.993E-01,4.992E-01,4.991E-01,4.990E-01,4.989E-01,4.989E-01,4.989E-01,4.989E-01,4.989E-01,&
	4.989E-01,4.989E-01,4.989E-01,4.989E-01,4.989E-01,4.989E-01,4.988E-01,4.988E-01,4.988E-01,4.988E-01,&
	4.988E-01,4.979E-01,4.970E-01,4.962E-01,4.953E-01,4.944E-01,4.940E-01,4.937E-01,4.933E-01,4.930E-01,&
	4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01/

		DATA (Rsoil1(i),i=1001,1100)/&
	4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,4.926E-01,&
	4.925E-01,4.933E-01,4.940E-01,4.947E-01,4.955E-01,4.962E-01,4.968E-01,4.974E-01,4.980E-01,4.986E-01,&
	4.992E-01,4.994E-01,4.997E-01,4.999E-01,5.001E-01,5.003E-01,5.004E-01,5.005E-01,5.006E-01,5.006E-01,&
	5.007E-01,5.007E-01,5.008E-01,5.008E-01,5.008E-01,5.008E-01,5.008E-01,5.008E-01,5.008E-01,5.008E-01,&
	5.008E-01,5.008E-01,5.008E-01,5.008E-01,5.008E-01,5.008E-01,5.007E-01,5.006E-01,5.006E-01,5.005E-01,&
	5.004E-01,5.004E-01,5.005E-01,5.005E-01,5.006E-01,5.006E-01,5.008E-01,5.011E-01,5.014E-01,5.016E-01,&
	5.019E-01,5.020E-01,5.022E-01,5.023E-01,5.025E-01,5.026E-01,5.027E-01,5.028E-01,5.029E-01,5.031E-01,&
	5.032E-01,5.032E-01,5.033E-01,5.033E-01,5.034E-01,5.034E-01,5.032E-01,5.030E-01,5.028E-01,5.026E-01,&
	5.024E-01,5.022E-01,5.020E-01,5.019E-01,5.017E-01,5.015E-01,5.017E-01,5.019E-01,5.021E-01,5.023E-01,&
	5.025E-01,5.027E-01,5.029E-01,5.031E-01,5.033E-01,5.035E-01,5.036E-01,5.037E-01,5.038E-01,5.040E-01/

		DATA (Rsoil1(i),i=1101,1200)/&
	5.041E-01,5.039E-01,5.037E-01,5.036E-01,5.034E-01,5.033E-01,5.035E-01,5.036E-01,5.038E-01,5.040E-01,&
	5.042E-01,5.044E-01,5.047E-01,5.049E-01,5.051E-01,5.054E-01,5.057E-01,5.061E-01,5.065E-01,5.068E-01,&
	5.072E-01,5.072E-01,5.073E-01,5.073E-01,5.073E-01,5.074E-01,5.072E-01,5.071E-01,5.069E-01,5.068E-01,&
	5.067E-01,5.067E-01,5.067E-01,5.067E-01,5.067E-01,5.067E-01,5.068E-01,5.070E-01,5.071E-01,5.072E-01,&
	5.074E-01,5.075E-01,5.076E-01,5.078E-01,5.079E-01,5.080E-01,5.080E-01,5.079E-01,5.078E-01,5.077E-01,&
	5.077E-01,5.075E-01,5.074E-01,5.073E-01,5.072E-01,5.071E-01,5.072E-01,5.074E-01,5.075E-01,5.077E-01,&
	5.078E-01,5.079E-01,5.080E-01,5.082E-01,5.083E-01,5.084E-01,5.084E-01,5.084E-01,5.084E-01,5.084E-01,&
	5.084E-01,5.084E-01,5.084E-01,5.084E-01,5.084E-01,5.084E-01,5.084E-01,5.084E-01,5.085E-01,5.085E-01,&
	5.085E-01,5.087E-01,5.089E-01,5.090E-01,5.092E-01,5.094E-01,5.096E-01,5.097E-01,5.099E-01,5.101E-01,&
	5.103E-01,5.103E-01,5.104E-01,5.104E-01,5.105E-01,5.106E-01,5.103E-01,5.101E-01,5.099E-01,5.097E-01/

		DATA (Rsoil1(i),i=1201,1300)/&
	5.095E-01,5.093E-01,5.091E-01,5.089E-01,5.087E-01,5.085E-01,5.086E-01,5.087E-01,5.088E-01,5.089E-01,&
	5.090E-01,5.091E-01,5.092E-01,5.093E-01,5.095E-01,5.096E-01,5.095E-01,5.093E-01,5.092E-01,5.091E-01,&
	5.090E-01,5.089E-01,5.087E-01,5.086E-01,5.085E-01,5.084E-01,5.083E-01,5.083E-01,5.083E-01,5.082E-01,&
	5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.082E-01,&
	5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.082E-01,5.085E-01,5.089E-01,5.092E-01,5.096E-01,&
	5.099E-01,5.101E-01,5.104E-01,5.106E-01,5.109E-01,5.111E-01,5.109E-01,5.107E-01,5.106E-01,5.104E-01,&
	5.102E-01,5.100E-01,5.098E-01,5.097E-01,5.095E-01,5.093E-01,5.091E-01,5.090E-01,5.088E-01,5.086E-01,&
	5.084E-01,5.083E-01,5.083E-01,5.082E-01,5.081E-01,5.081E-01,5.081E-01,5.081E-01,5.080E-01,5.080E-01,&
	5.080E-01,5.080E-01,5.080E-01,5.080E-01,5.080E-01,5.080E-01,5.080E-01,5.080E-01,5.080E-01,5.080E-01,&
	5.080E-01,5.082E-01,5.084E-01,5.086E-01,5.088E-01,5.090E-01,5.093E-01,5.095E-01,5.098E-01,5.101E-01/

		DATA (Rsoil1(i),i=1301,1400)/&
	5.103E-01,5.106E-01,5.108E-01,5.111E-01,5.114E-01,5.116E-01,5.117E-01,5.118E-01,5.119E-01,5.120E-01,&
	5.121E-01,5.122E-01,5.122E-01,5.122E-01,5.123E-01,5.123E-01,5.120E-01,5.116E-01,5.113E-01,5.110E-01,&
	5.107E-01,5.104E-01,5.102E-01,5.100E-01,5.098E-01,5.095E-01,5.096E-01,5.096E-01,5.097E-01,5.097E-01,&
	5.098E-01,5.095E-01,5.092E-01,5.089E-01,5.086E-01,5.083E-01,5.085E-01,5.086E-01,5.088E-01,5.090E-01,&
	5.091E-01,5.092E-01,5.093E-01,5.094E-01,5.095E-01,5.096E-01,5.096E-01,5.096E-01,5.096E-01,5.096E-01,&
	5.096E-01,5.097E-01,5.098E-01,5.099E-01,5.101E-01,5.102E-01,5.102E-01,5.103E-01,5.103E-01,5.104E-01,&
	5.105E-01,5.102E-01,5.100E-01,5.098E-01,5.096E-01,5.094E-01,5.092E-01,5.090E-01,5.088E-01,5.086E-01,&
	5.084E-01,5.082E-01,5.081E-01,5.079E-01,5.078E-01,5.076E-01,5.078E-01,5.079E-01,5.081E-01,5.082E-01,&
	5.084E-01,5.086E-01,5.088E-01,5.091E-01,5.093E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01,&
	5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01/

		DATA (Rsoil1(i),i=1401,1500)/&
	5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.095E-01,5.094E-01,5.094E-01,5.094E-01,5.094E-01,5.094E-01,&
	5.094E-01,5.090E-01,5.086E-01,5.082E-01,5.078E-01,5.074E-01,5.073E-01,5.072E-01,5.071E-01,5.070E-01,&
	5.069E-01,5.071E-01,5.074E-01,5.076E-01,5.079E-01,5.082E-01,5.081E-01,5.081E-01,5.080E-01,5.080E-01,&
	5.079E-01,5.076E-01,5.073E-01,5.070E-01,5.067E-01,5.064E-01,5.066E-01,5.069E-01,5.071E-01,5.073E-01,&
	5.076E-01,5.079E-01,5.083E-01,5.087E-01,5.091E-01,5.095E-01,5.097E-01,5.100E-01,5.103E-01,5.105E-01,&
	5.108E-01,5.110E-01,5.112E-01,5.115E-01,5.117E-01,5.119E-01,5.122E-01,5.125E-01,5.128E-01,5.131E-01,&
	5.134E-01,5.138E-01,5.142E-01,5.147E-01,5.151E-01,5.155E-01,5.153E-01,5.152E-01,5.150E-01,5.148E-01,&
	5.146E-01,5.142E-01,5.137E-01,5.133E-01,5.128E-01,5.124E-01,5.102E-01,5.081E-01,5.059E-01,5.037E-01,&
	5.016E-01,5.016E-01,5.016E-01,5.015E-01,5.015E-01,5.015E-01,5.019E-01,5.023E-01,5.026E-01,5.030E-01,&
	5.034E-01,5.038E-01,5.042E-01,5.046E-01,5.050E-01,5.055E-01,5.061E-01,5.067E-01,5.073E-01,5.080E-01/

		DATA (Rsoil1(i),i=1501,1600)/&
	5.086E-01,5.086E-01,5.086E-01,5.085E-01,5.085E-01,5.085E-01,5.081E-01,5.076E-01,5.072E-01,5.068E-01,&
	5.064E-01,5.059E-01,5.055E-01,5.051E-01,5.047E-01,5.042E-01,5.038E-01,5.034E-01,5.030E-01,5.027E-01,&
	5.023E-01,5.019E-01,5.015E-01,5.011E-01,5.007E-01,5.003E-01,5.003E-01,5.003E-01,5.003E-01,5.003E-01,&
	5.003E-01,4.992E-01,4.980E-01,4.969E-01,4.958E-01,4.946E-01,4.943E-01,4.939E-01,4.935E-01,4.931E-01,&
	4.927E-01,4.924E-01,4.920E-01,4.916E-01,4.912E-01,4.908E-01,4.907E-01,4.905E-01,4.904E-01,4.902E-01,&
	4.901E-01,4.902E-01,4.903E-01,4.904E-01,4.905E-01,4.906E-01,4.905E-01,4.904E-01,4.902E-01,4.901E-01,&
	4.900E-01,4.900E-01,4.900E-01,4.900E-01,4.900E-01,4.900E-01,4.902E-01,4.904E-01,4.906E-01,4.907E-01,&
	4.909E-01,4.911E-01,4.913E-01,4.914E-01,4.916E-01,4.918E-01,4.930E-01,4.941E-01,4.953E-01,4.964E-01,&
	4.976E-01,4.976E-01,4.976E-01,4.976E-01,4.976E-01,4.977E-01,4.977E-01,4.977E-01,4.977E-01,4.977E-01,&
	4.977E-01,4.977E-01,4.978E-01,4.978E-01,4.978E-01,4.978E-01,4.978E-01,4.978E-01,4.978E-01,4.978E-01/

		DATA (Rsoil1(i),i=1601,1700)/&
	4.979E-01,4.981E-01,4.983E-01,4.985E-01,4.986E-01,4.988E-01,4.991E-01,4.994E-01,4.996E-01,4.999E-01,&
	5.002E-01,5.004E-01,5.006E-01,5.009E-01,5.011E-01,5.013E-01,5.016E-01,5.018E-01,5.021E-01,5.023E-01,&
	5.025E-01,5.028E-01,5.030E-01,5.033E-01,5.035E-01,5.037E-01,5.038E-01,5.038E-01,5.039E-01,5.039E-01,&
	5.040E-01,5.040E-01,5.040E-01,5.040E-01,5.040E-01,5.040E-01,5.044E-01,5.049E-01,5.053E-01,5.058E-01,&
	5.062E-01,5.065E-01,5.068E-01,5.070E-01,5.073E-01,5.076E-01,5.076E-01,5.076E-01,5.076E-01,5.076E-01,&
	5.076E-01,5.077E-01,5.078E-01,5.079E-01,5.080E-01,5.081E-01,5.085E-01,5.089E-01,5.093E-01,5.097E-01,&
	5.101E-01,5.100E-01,5.100E-01,5.099E-01,5.098E-01,5.098E-01,5.095E-01,5.092E-01,5.089E-01,5.086E-01,&
	5.083E-01,5.080E-01,5.078E-01,5.076E-01,5.073E-01,5.071E-01,5.071E-01,5.071E-01,5.071E-01,5.071E-01,&
	5.071E-01,5.071E-01,5.071E-01,5.070E-01,5.070E-01,5.070E-01,5.070E-01,5.069E-01,5.069E-01,5.068E-01,&
	5.068E-01,5.067E-01,5.067E-01,5.066E-01,5.066E-01,5.065E-01,5.064E-01,5.062E-01,5.061E-01,5.059E-01/


		DATA (Rsoil1(i),i=1701,1800)/&
	5.058E-01,5.054E-01,5.050E-01,5.047E-01,5.043E-01,5.039E-01,5.043E-01,5.047E-01,5.050E-01,5.054E-01,&
	5.058E-01,5.056E-01,5.055E-01,5.054E-01,5.052E-01,5.051E-01,5.050E-01,5.048E-01,5.047E-01,5.046E-01,&
	5.044E-01,5.047E-01,5.051E-01,5.054E-01,5.057E-01,5.060E-01,5.055E-01,5.050E-01,5.045E-01,5.040E-01,&
	5.035E-01,5.039E-01,5.043E-01,5.047E-01,5.051E-01,5.055E-01,5.053E-01,5.051E-01,5.048E-01,5.046E-01,&
	5.044E-01,5.041E-01,5.037E-01,5.034E-01,5.031E-01,5.028E-01,5.024E-01,5.021E-01,5.018E-01,5.015E-01,&
	5.011E-01,5.009E-01,5.007E-01,5.005E-01,5.003E-01,5.000E-01,4.998E-01,4.996E-01,4.994E-01,4.992E-01,&
	4.990E-01,4.988E-01,4.986E-01,4.984E-01,4.981E-01,4.979E-01,4.978E-01,4.976E-01,4.974E-01,4.972E-01,&
	4.970E-01,4.972E-01,4.974E-01,4.975E-01,4.977E-01,4.979E-01,4.979E-01,4.979E-01,4.979E-01,4.979E-01,&
	4.979E-01,4.963E-01,4.946E-01,4.929E-01,4.912E-01,4.895E-01,4.889E-01,4.883E-01,4.877E-01,4.871E-01,&
	4.865E-01,4.859E-01,4.854E-01,4.848E-01,4.842E-01,4.836E-01,4.833E-01,4.830E-01,4.827E-01,4.824E-01/

		DATA (Rsoil1(i),i=1801,1900)/&
	4.821E-01,4.820E-01,4.819E-01,4.818E-01,4.817E-01,4.816E-01,4.816E-01,4.815E-01,4.815E-01,4.815E-01,&
	4.815E-01,4.817E-01,4.818E-01,4.820E-01,4.821E-01,4.823E-01,4.827E-01,4.831E-01,4.836E-01,4.840E-01,&
	4.844E-01,4.849E-01,4.853E-01,4.858E-01,4.862E-01,4.867E-01,4.873E-01,4.879E-01,4.884E-01,4.890E-01,&
	4.896E-01,4.902E-01,4.908E-01,4.914E-01,4.920E-01,4.926E-01,4.924E-01,4.922E-01,4.920E-01,4.919E-01,&
	4.917E-01,4.914E-01,4.911E-01,4.908E-01,4.905E-01,4.902E-01,4.902E-01,4.902E-01,4.902E-01,4.901E-01,&
	4.901E-01,4.901E-01,4.900E-01,4.899E-01,4.898E-01,4.897E-01,4.895E-01,4.893E-01,4.891E-01,4.889E-01,&
	4.887E-01,4.889E-01,4.892E-01,4.894E-01,4.896E-01,4.898E-01,4.900E-01,4.902E-01,4.904E-01,4.906E-01,&
	4.908E-01,4.910E-01,4.912E-01,4.914E-01,4.916E-01,4.918E-01,4.920E-01,4.923E-01,4.925E-01,4.927E-01,&
	4.929E-01,4.926E-01,4.924E-01,4.921E-01,4.919E-01,4.916E-01,4.910E-01,4.904E-01,4.898E-01,4.892E-01,&
	4.886E-01,4.885E-01,4.884E-01,4.883E-01,4.882E-01,4.882E-01,4.879E-01,4.875E-01,4.872E-01,4.869E-01/

		DATA (Rsoil1(i),i=1901,2000)/&
	4.866E-01,4.863E-01,4.860E-01,4.857E-01,4.853E-01,4.850E-01,4.847E-01,4.844E-01,4.841E-01,4.838E-01,&
	4.835E-01,4.832E-01,4.830E-01,4.828E-01,4.825E-01,4.823E-01,4.823E-01,4.823E-01,4.823E-01,4.823E-01,&
	4.823E-01,4.823E-01,4.823E-01,4.823E-01,4.823E-01,4.823E-01,4.822E-01,4.822E-01,4.822E-01,4.822E-01,&
	4.822E-01,4.817E-01,4.813E-01,4.809E-01,4.805E-01,4.801E-01,4.797E-01,4.793E-01,4.789E-01,4.785E-01,&
	4.781E-01,4.778E-01,4.776E-01,4.773E-01,4.771E-01,4.768E-01,4.769E-01,4.770E-01,4.770E-01,4.771E-01,&
	4.772E-01,4.773E-01,4.773E-01,4.774E-01,4.775E-01,4.775E-01,4.776E-01,4.777E-01,4.778E-01,4.779E-01,&
	4.780E-01,4.778E-01,4.777E-01,4.776E-01,4.774E-01,4.773E-01,4.770E-01,4.767E-01,4.765E-01,4.762E-01,&
	4.759E-01,4.756E-01,4.754E-01,4.751E-01,4.748E-01,4.745E-01,4.747E-01,4.748E-01,4.749E-01,4.750E-01,&
	4.752E-01,4.752E-01,4.753E-01,4.754E-01,4.755E-01,4.755E-01,4.752E-01,4.748E-01,4.744E-01,4.740E-01,&
	4.736E-01,4.736E-01,4.735E-01,4.734E-01,4.734E-01,4.733E-01,4.731E-01,4.729E-01,4.727E-01,4.725E-01/

		DATA (Rsoil1(i),i=2001,2101)/&
	4.723E-01,4.718E-01,4.714E-01,4.709E-01,4.704E-01,4.699E-01,4.695E-01,4.691E-01,4.686E-01,4.682E-01,&
	4.678E-01,4.678E-01,4.678E-01,4.678E-01,4.678E-01,4.678E-01,4.678E-01,4.677E-01,4.677E-01,4.677E-01,&
	4.677E-01,4.675E-01,4.673E-01,4.671E-01,4.668E-01,4.666E-01,4.662E-01,4.658E-01,4.653E-01,4.649E-01,&
	4.645E-01,4.640E-01,4.636E-01,4.632E-01,4.627E-01,4.623E-01,4.620E-01,4.616E-01,4.613E-01,4.609E-01,&
	4.606E-01,4.602E-01,4.599E-01,4.595E-01,4.592E-01,4.588E-01,4.585E-01,4.581E-01,4.578E-01,4.574E-01,&
	4.571E-01,4.567E-01,4.564E-01,4.561E-01,4.557E-01,4.554E-01,4.551E-01,4.548E-01,4.545E-01,4.541E-01,&
	4.538E-01,4.535E-01,4.532E-01,4.529E-01,4.526E-01,4.523E-01,4.522E-01,4.521E-01,4.521E-01,4.520E-01,&
	4.519E-01,4.518E-01,4.518E-01,4.517E-01,4.516E-01,4.516E-01,4.513E-01,4.510E-01,4.507E-01,4.505E-01,&
	4.502E-01,4.499E-01,4.497E-01,4.494E-01,4.491E-01,4.488E-01,4.487E-01,4.486E-01,4.485E-01,4.483E-01,&
	4.482E-01,4.482E-01,4.482E-01,4.482E-01,4.482E-01,4.482E-01,4.478E-01,4.475E-01,4.471E-01,4.467E-01,&
	4.464E-01/

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!						soil 2 reflectance							!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		DATA (Rsoil2(i),i=1,100)/&
	3.208E-02,3.195E-02,3.181E-02,3.168E-02,3.154E-02,3.141E-02,3.125E-02,3.108E-02,3.092E-02,3.076E-02,&
	3.059E-02,3.044E-02,3.028E-02,3.012E-02,2.996E-02,2.980E-02,2.969E-02,2.957E-02,2.946E-02,2.934E-02,&
	2.923E-02,2.911E-02,2.900E-02,2.888E-02,2.877E-02,2.865E-02,2.854E-02,2.842E-02,2.831E-02,2.819E-02,&
	2.808E-02,2.793E-02,2.779E-02,2.764E-02,2.750E-02,2.735E-02,2.720E-02,2.705E-02,2.690E-02,2.675E-02,&
	2.660E-02,2.646E-02,2.632E-02,2.618E-02,2.604E-02,2.590E-02,2.578E-02,2.566E-02,2.553E-02,2.541E-02,&
	2.529E-02,2.523E-02,2.518E-02,2.513E-02,2.508E-02,2.502E-02,2.502E-02,2.502E-02,2.502E-02,2.501E-02,&
	2.501E-02,2.501E-02,2.501E-02,2.500E-02,2.500E-02,2.500E-02,2.500E-02,2.499E-02,2.499E-02,2.499E-02,&
	2.499E-02,2.498E-02,2.498E-02,2.498E-02,2.498E-02,2.497E-02,2.483E-02,2.468E-02,2.453E-02,2.438E-02,&
	2.423E-02,2.423E-02,2.423E-02,2.423E-02,2.422E-02,2.422E-02,2.422E-02,2.422E-02,2.421E-02,2.421E-02,&
	2.421E-02,2.450E-02,2.479E-02,2.508E-02,2.537E-02,2.566E-02,2.565E-02,2.565E-02,2.565E-02,2.565E-02/

		DATA (Rsoil2(i),i=101,200)/&
	2.564E-02,2.564E-02,2.564E-02,2.564E-02,2.563E-02,2.563E-02,2.570E-02,2.577E-02,2.584E-02,2.591E-02,&
	2.598E-02,2.598E-02,2.598E-02,2.598E-02,2.597E-02,2.597E-02,2.597E-02,2.597E-02,2.596E-02,2.596E-02,&
	2.596E-02,2.596E-02,2.595E-02,2.595E-02,2.595E-02,2.595E-02,2.594E-02,2.594E-02,2.594E-02,2.594E-02,&
	2.593E-02,2.593E-02,2.593E-02,2.593E-02,2.592E-02,2.592E-02,2.614E-02,2.635E-02,2.657E-02,2.679E-02,&
	2.700E-02,2.700E-02,2.700E-02,2.700E-02,2.699E-02,2.699E-02,2.735E-02,2.772E-02,2.808E-02,2.844E-02,&
	2.880E-02,2.880E-02,2.880E-02,2.879E-02,2.879E-02,2.879E-02,2.879E-02,2.878E-02,2.878E-02,2.878E-02,&
	2.878E-02,2.877E-02,2.877E-02,2.877E-02,2.877E-02,2.877E-02,2.884E-02,2.891E-02,2.898E-02,2.905E-02,&
	2.912E-02,2.912E-02,2.911E-02,2.911E-02,2.911E-02,2.911E-02,2.918E-02,2.926E-02,2.934E-02,2.942E-02,&
	2.950E-02,2.978E-02,3.006E-02,3.034E-02,3.062E-02,3.090E-02,3.090E-02,3.090E-02,3.090E-02,3.089E-02,&
	3.089E-02,3.089E-02,3.089E-02,3.088E-02,3.088E-02,3.088E-02,3.088E-02,3.087E-02,3.087E-02,3.087E-02/

		DATA (Rsoil2(i),i=201,300)/&
	3.087E-02,3.098E-02,3.110E-02,3.122E-02,3.133E-02,3.145E-02,3.147E-02,3.150E-02,3.152E-02,3.155E-02,&
	3.157E-02,3.157E-02,3.157E-02,3.156E-02,3.156E-02,3.156E-02,3.163E-02,3.170E-02,3.177E-02,3.184E-02,&
	3.191E-02,3.198E-02,3.205E-02,3.212E-02,3.219E-02,3.227E-02,3.263E-02,3.299E-02,3.335E-02,3.371E-02,&
	3.408E-02,3.407E-02,3.407E-02,3.407E-02,3.407E-02,3.406E-02,3.425E-02,3.443E-02,3.461E-02,3.479E-02,&
	3.498E-02,3.515E-02,3.533E-02,3.551E-02,3.568E-02,3.586E-02,3.593E-02,3.600E-02,3.607E-02,3.614E-02,&
	3.621E-02,3.636E-02,3.650E-02,3.664E-02,3.679E-02,3.693E-02,3.710E-02,3.727E-02,3.743E-02,3.760E-02,&
	3.777E-02,3.782E-02,3.786E-02,3.791E-02,3.795E-02,3.800E-02,3.829E-02,3.858E-02,3.887E-02,3.916E-02,&
	3.945E-02,3.944E-02,3.944E-02,3.944E-02,3.944E-02,3.943E-02,3.980E-02,4.016E-02,4.052E-02,4.088E-02,&
	4.124E-02,4.131E-02,4.138E-02,4.146E-02,4.153E-02,4.160E-02,4.167E-02,4.174E-02,4.181E-02,4.188E-02,&
	4.195E-02,4.195E-02,4.194E-02,4.194E-02,4.194E-02,4.194E-02,4.193E-02,4.193E-02,4.193E-02,4.193E-02/

		DATA (Rsoil2(i),i=301,400)/&
	4.193E-02,4.214E-02,4.236E-02,4.257E-02,4.279E-02,4.301E-02,4.332E-02,4.363E-02,4.394E-02,4.426E-02,&
	4.457E-02,4.462E-02,4.466E-02,4.471E-02,4.476E-02,4.480E-02,4.495E-02,4.509E-02,4.523E-02,4.538E-02,&
	4.552E-02,4.566E-02,4.581E-02,4.595E-02,4.609E-02,4.624E-02,4.653E-02,4.682E-02,4.711E-02,4.739E-02,&
	4.768E-02,4.805E-02,4.841E-02,4.877E-02,4.913E-02,4.949E-02,4.971E-02,4.993E-02,5.014E-02,5.036E-02,&
	5.058E-02,5.073E-02,5.089E-02,5.105E-02,5.121E-02,5.136E-02,5.156E-02,5.175E-02,5.195E-02,5.214E-02,&
	5.233E-02,5.253E-02,5.272E-02,5.292E-02,5.311E-02,5.330E-02,5.355E-02,5.380E-02,5.404E-02,5.429E-02,&
	5.454E-02,5.461E-02,5.468E-02,5.475E-02,5.482E-02,5.489E-02,5.489E-02,5.488E-02,5.488E-02,5.488E-02,&
	5.488E-02,5.490E-02,5.493E-02,5.496E-02,5.498E-02,5.501E-02,5.549E-02,5.597E-02,5.645E-02,5.692E-02,&
	5.740E-02,5.753E-02,5.766E-02,5.778E-02,5.791E-02,5.804E-02,5.813E-02,5.821E-02,5.830E-02,5.839E-02,&
	5.847E-02,5.884E-02,5.920E-02,5.956E-02,5.992E-02,6.028E-02,6.028E-02,6.028E-02,6.028E-02,6.027E-02/

		DATA (Rsoil2(i),i=401,500)/&
	6.027E-02,6.063E-02,6.100E-02,6.136E-02,6.172E-02,6.208E-02,6.223E-02,6.237E-02,6.251E-02,6.266E-02,&
	6.280E-02,6.280E-02,6.279E-02,6.279E-02,6.279E-02,6.279E-02,6.300E-02,6.322E-02,6.344E-02,6.365E-02,&
	6.387E-02,6.433E-02,6.479E-02,6.525E-02,6.571E-02,6.616E-02,6.643E-02,6.669E-02,6.696E-02,6.722E-02,&
	6.749E-02,6.749E-02,6.748E-02,6.748E-02,6.748E-02,6.748E-02,6.747E-02,6.747E-02,6.747E-02,6.747E-02,&
	6.747E-02,6.776E-02,6.806E-02,6.836E-02,6.866E-02,6.896E-02,6.938E-02,6.981E-02,7.023E-02,7.066E-02,&
	7.109E-02,7.108E-02,7.108E-02,7.108E-02,7.108E-02,7.107E-02,7.107E-02,7.107E-02,7.107E-02,7.106E-02,&
	7.106E-02,7.113E-02,7.119E-02,7.126E-02,7.132E-02,7.139E-02,7.197E-02,7.256E-02,7.315E-02,7.373E-02,&
	7.432E-02,7.432E-02,7.431E-02,7.431E-02,7.431E-02,7.431E-02,7.445E-02,7.459E-02,7.474E-02,7.488E-02,&
	7.502E-02,7.521E-02,7.539E-02,7.558E-02,7.576E-02,7.595E-02,7.614E-02,7.632E-02,7.651E-02,7.670E-02,&
	7.689E-02,7.717E-02,7.745E-02,7.772E-02,7.800E-02,7.828E-02,7.848E-02,7.867E-02,7.887E-02,7.907E-02/
		
		DATA (Rsoil2(i),i=501,600)/&
	7.927E-02,7.943E-02,7.959E-02,7.975E-02,7.991E-02,8.007E-02,8.006E-02,8.006E-02,8.006E-02,8.006E-02,&
	8.005E-02,8.022E-02,8.039E-02,8.056E-02,8.073E-02,8.090E-02,8.120E-02,8.151E-02,8.181E-02,8.212E-02,&
	8.243E-02,8.272E-02,8.301E-02,8.330E-02,8.359E-02,8.389E-02,8.404E-02,8.419E-02,8.434E-02,8.449E-02,&
	8.464E-02,8.495E-02,8.526E-02,8.557E-02,8.588E-02,8.619E-02,8.636E-02,8.653E-02,8.670E-02,8.686E-02,&
	8.703E-02,8.737E-02,8.771E-02,8.804E-02,8.838E-02,8.872E-02,8.882E-02,8.893E-02,8.904E-02,8.914E-02,&
	8.925E-02,8.947E-02,8.969E-02,8.991E-02,9.013E-02,9.035E-02,9.058E-02,9.081E-02,9.104E-02,9.127E-02,&
	9.151E-02,9.189E-02,9.227E-02,9.265E-02,9.303E-02,9.341E-02,9.355E-02,9.369E-02,9.384E-02,9.398E-02,&
	9.412E-02,9.437E-02,9.461E-02,9.485E-02,9.509E-02,9.534E-02,9.540E-02,9.546E-02,9.552E-02,9.558E-02,&
	9.564E-02,9.569E-02,9.575E-02,9.580E-02,9.586E-02,9.591E-02,9.617E-02,9.643E-02,9.669E-02,9.695E-02,&
	9.722E-02,9.797E-02,9.872E-02,9.947E-02,1.002E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01/

		DATA (Rsoil2(i),i=601,700)/&
	1.010E-01,1.010E-01,1.011E-01,1.011E-01,1.012E-01,1.012E-01,1.015E-01,1.017E-01,1.019E-01,1.022E-01,&
	1.024E-01,1.026E-01,1.028E-01,1.031E-01,1.033E-01,1.035E-01,1.035E-01,1.035E-01,1.035E-01,1.035E-01,&
	1.035E-01,1.035E-01,1.035E-01,1.035E-01,1.035E-01,1.035E-01,1.042E-01,1.049E-01,1.056E-01,1.063E-01,&
	1.070E-01,1.075E-01,1.080E-01,1.086E-01,1.091E-01,1.096E-01,1.096E-01,1.096E-01,1.096E-01,1.096E-01,&
	1.096E-01,1.096E-01,1.096E-01,1.096E-01,1.096E-01,1.096E-01,1.096E-01,1.096E-01,1.096E-01,1.096E-01,&
	1.096E-01,1.097E-01,1.099E-01,1.100E-01,1.102E-01,1.103E-01,1.105E-01,1.108E-01,1.110E-01,1.112E-01,&
	1.114E-01,1.118E-01,1.121E-01,1.125E-01,1.129E-01,1.132E-01,1.132E-01,1.132E-01,1.132E-01,1.132E-01,&
	1.132E-01,1.135E-01,1.138E-01,1.141E-01,1.144E-01,1.146E-01,1.148E-01,1.150E-01,1.152E-01,1.154E-01,&
	1.156E-01,1.158E-01,1.160E-01,1.162E-01,1.163E-01,1.165E-01,1.168E-01,1.171E-01,1.174E-01,1.176E-01,&
	1.179E-01,1.182E-01,1.184E-01,1.186E-01,1.188E-01,1.191E-01,1.191E-01,1.192E-01,1.193E-01,1.194E-01/

		DATA (Rsoil2(i),i=701,800)/&
	1.195E-01,1.196E-01,1.197E-01,1.199E-01,1.200E-01,1.202E-01,1.204E-01,1.206E-01,1.209E-01,1.211E-01,&
	1.213E-01,1.215E-01,1.217E-01,1.218E-01,1.220E-01,1.221E-01,1.223E-01,1.225E-01,1.226E-01,1.228E-01,&
	1.229E-01,1.231E-01,1.233E-01,1.234E-01,1.236E-01,1.238E-01,1.240E-01,1.241E-01,1.243E-01,1.245E-01,&
	1.246E-01,1.248E-01,1.250E-01,1.252E-01,1.253E-01,1.255E-01,1.257E-01,1.259E-01,1.261E-01,1.263E-01,&
	1.265E-01,1.267E-01,1.268E-01,1.269E-01,1.271E-01,1.272E-01,1.274E-01,1.275E-01,1.277E-01,1.278E-01,&
	1.279E-01,1.281E-01,1.282E-01,1.284E-01,1.285E-01,1.287E-01,1.288E-01,1.290E-01,1.291E-01,1.293E-01,&
	1.294E-01,1.296E-01,1.297E-01,1.299E-01,1.300E-01,1.302E-01,1.303E-01,1.304E-01,1.306E-01,1.307E-01,&
	1.309E-01,1.310E-01,1.312E-01,1.314E-01,1.316E-01,1.318E-01,1.320E-01,1.322E-01,1.323E-01,1.325E-01,&
	1.327E-01,1.329E-01,1.331E-01,1.334E-01,1.336E-01,1.338E-01,1.340E-01,1.343E-01,1.346E-01,1.348E-01,&
	1.351E-01,1.352E-01,1.353E-01,1.353E-01,1.354E-01,1.355E-01,1.358E-01,1.361E-01,1.364E-01,1.367E-01/

		DATA (Rsoil2(i),i=801,900)/&
	1.369E-01,1.371E-01,1.373E-01,1.374E-01,1.376E-01,1.377E-01,1.383E-01,1.388E-01,1.394E-01,1.399E-01,&
	1.405E-01,1.407E-01,1.409E-01,1.411E-01,1.412E-01,1.414E-01,1.415E-01,1.415E-01,1.415E-01,1.416E-01,&
	1.416E-01,1.420E-01,1.423E-01,1.427E-01,1.431E-01,1.434E-01,1.438E-01,1.442E-01,1.445E-01,1.449E-01,&
	1.453E-01,1.453E-01,1.452E-01,1.452E-01,1.452E-01,1.452E-01,1.453E-01,1.454E-01,1.455E-01,1.455E-01,&
	1.456E-01,1.456E-01,1.456E-01,1.456E-01,1.456E-01,1.456E-01,1.458E-01,1.460E-01,1.462E-01,1.464E-01,&
	1.467E-01,1.469E-01,1.471E-01,1.474E-01,1.476E-01,1.478E-01,1.479E-01,1.479E-01,1.480E-01,1.480E-01,&
	1.481E-01,1.481E-01,1.481E-01,1.481E-01,1.481E-01,1.481E-01,1.481E-01,1.481E-01,1.481E-01,1.481E-01,&
	1.481E-01,1.483E-01,1.485E-01,1.487E-01,1.489E-01,1.491E-01,1.492E-01,1.493E-01,1.494E-01,1.494E-01,&
	1.495E-01,1.499E-01,1.502E-01,1.506E-01,1.510E-01,1.513E-01,1.513E-01,1.513E-01,1.513E-01,1.513E-01,&
	1.513E-01,1.513E-01,1.513E-01,1.513E-01,1.513E-01,1.513E-01,1.517E-01,1.521E-01,1.525E-01,1.529E-01/

		DATA (Rsoil2(i),i=901,1000)/&
	1.533E-01,1.533E-01,1.533E-01,1.534E-01,1.534E-01,1.535E-01,1.535E-01,1.535E-01,1.534E-01,1.534E-01,&
	1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,&
	1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,&
	1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.534E-01,1.532E-01,1.531E-01,1.529E-01,1.527E-01,&
	1.526E-01,1.523E-01,1.520E-01,1.517E-01,1.515E-01,1.512E-01,1.510E-01,1.509E-01,1.507E-01,1.506E-01,&
	1.504E-01,1.504E-01,1.504E-01,1.504E-01,1.504E-01,1.504E-01,1.500E-01,1.497E-01,1.493E-01,1.489E-01,&
	1.486E-01,1.481E-01,1.476E-01,1.471E-01,1.466E-01,1.461E-01,1.454E-01,1.447E-01,1.440E-01,1.433E-01,&
	1.425E-01,1.414E-01,1.403E-01,1.392E-01,1.381E-01,1.370E-01,1.363E-01,1.355E-01,1.348E-01,1.340E-01,&
	1.332E-01,1.321E-01,1.309E-01,1.298E-01,1.287E-01,1.275E-01,1.264E-01,1.252E-01,1.240E-01,1.229E-01,&
	1.217E-01,1.209E-01,1.201E-01,1.193E-01,1.185E-01,1.178E-01,1.169E-01,1.161E-01,1.152E-01,1.143E-01/

		DATA (Rsoil2(i),i=1001,1100)/&
	1.135E-01,1.128E-01,1.122E-01,1.116E-01,1.109E-01,1.103E-01,1.098E-01,1.093E-01,1.088E-01,1.083E-01,&
	1.078E-01,1.070E-01,1.062E-01,1.054E-01,1.046E-01,1.039E-01,1.037E-01,1.036E-01,1.035E-01,1.034E-01,&
	1.032E-01,1.029E-01,1.026E-01,1.024E-01,1.021E-01,1.018E-01,1.016E-01,1.015E-01,1.013E-01,1.012E-01,&
	1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,&
	1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.010E-01,1.012E-01,1.014E-01,1.016E-01,1.019E-01,&
	1.021E-01,1.021E-01,1.021E-01,1.021E-01,1.021E-01,1.021E-01,1.021E-01,1.021E-01,1.021E-01,1.020E-01,&
	1.020E-01,1.023E-01,1.026E-01,1.029E-01,1.032E-01,1.035E-01,1.036E-01,1.037E-01,1.037E-01,1.038E-01,&
	1.039E-01,1.049E-01,1.059E-01,1.069E-01,1.079E-01,1.088E-01,1.092E-01,1.096E-01,1.100E-01,1.104E-01,&
	1.107E-01,1.108E-01,1.108E-01,1.108E-01,1.108E-01,1.108E-01,1.114E-01,1.120E-01,1.126E-01,1.133E-01,&
	1.139E-01,1.144E-01,1.150E-01,1.156E-01,1.161E-01,1.167E-01,1.171E-01,1.175E-01,1.180E-01,1.184E-01/

		DATA (Rsoil2(i),i=1101,1200)/&
	1.188E-01,1.192E-01,1.196E-01,1.200E-01,1.204E-01,1.208E-01,1.212E-01,1.216E-01,1.220E-01,1.223E-01,&
	1.227E-01,1.233E-01,1.239E-01,1.245E-01,1.251E-01,1.257E-01,1.262E-01,1.268E-01,1.274E-01,1.279E-01,&
	1.285E-01,1.291E-01,1.298E-01,1.305E-01,1.311E-01,1.318E-01,1.321E-01,1.324E-01,1.327E-01,1.329E-01,&
	1.332E-01,1.337E-01,1.342E-01,1.347E-01,1.352E-01,1.357E-01,1.360E-01,1.363E-01,1.366E-01,1.369E-01,&
	1.372E-01,1.377E-01,1.381E-01,1.385E-01,1.390E-01,1.394E-01,1.396E-01,1.398E-01,1.400E-01,1.403E-01,&
	1.405E-01,1.407E-01,1.410E-01,1.413E-01,1.415E-01,1.418E-01,1.424E-01,1.429E-01,1.435E-01,1.440E-01,&
	1.446E-01,1.451E-01,1.455E-01,1.460E-01,1.465E-01,1.470E-01,1.475E-01,1.480E-01,1.485E-01,1.489E-01,&
	1.494E-01,1.498E-01,1.501E-01,1.504E-01,1.508E-01,1.511E-01,1.512E-01,1.513E-01,1.515E-01,1.516E-01,&
	1.517E-01,1.517E-01,1.517E-01,1.517E-01,1.517E-01,1.517E-01,1.517E-01,1.517E-01,1.517E-01,1.517E-01,&
	1.517E-01,1.521E-01,1.525E-01,1.530E-01,1.534E-01,1.538E-01,1.541E-01,1.544E-01,1.547E-01,1.550E-01/

		DATA (Rsoil2(i),i=1201,1300)/&
	1.553E-01,1.555E-01,1.557E-01,1.558E-01,1.560E-01,1.562E-01,1.568E-01,1.573E-01,1.578E-01,1.584E-01,&
	1.589E-01,1.590E-01,1.590E-01,1.591E-01,1.592E-01,1.592E-01,1.594E-01,1.595E-01,1.597E-01,1.598E-01,&
	1.600E-01,1.600E-01,1.600E-01,1.600E-01,1.600E-01,1.600E-01,1.603E-01,1.606E-01,1.608E-01,1.611E-01,&
	1.614E-01,1.618E-01,1.621E-01,1.625E-01,1.628E-01,1.631E-01,1.631E-01,1.632E-01,1.632E-01,1.632E-01,&
	1.632E-01,1.632E-01,1.632E-01,1.632E-01,1.632E-01,1.632E-01,1.632E-01,1.632E-01,1.632E-01,1.632E-01,&
	1.632E-01,1.633E-01,1.635E-01,1.636E-01,1.638E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,&
	1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,&
	1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.639E-01,1.638E-01,1.638E-01,&
	1.638E-01,1.639E-01,1.640E-01,1.641E-01,1.641E-01,1.642E-01,1.642E-01,1.642E-01,1.642E-01,1.642E-01,&
	1.642E-01,1.643E-01,1.643E-01,1.644E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01/

		DATA (Rsoil2(i),i=1301,1400)/&
	1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,&
	1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.645E-01,1.642E-01,1.639E-01,1.636E-01,1.633E-01,&
	1.630E-01,1.630E-01,1.630E-01,1.630E-01,1.630E-01,1.630E-01,1.629E-01,1.627E-01,1.626E-01,1.624E-01,&
	1.623E-01,1.623E-01,1.623E-01,1.623E-01,1.623E-01,1.623E-01,1.617E-01,1.612E-01,1.607E-01,1.602E-01,&
	1.597E-01,1.597E-01,1.597E-01,1.597E-01,1.597E-01,1.597E-01,1.597E-01,1.597E-01,1.597E-01,1.597E-01,&
	1.597E-01,1.594E-01,1.592E-01,1.590E-01,1.588E-01,1.586E-01,1.585E-01,1.585E-01,1.584E-01,1.584E-01,&
	1.584E-01,1.580E-01,1.576E-01,1.572E-01,1.568E-01,1.563E-01,1.559E-01,1.555E-01,1.550E-01,1.546E-01,&
	1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,&
	1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,&
	1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01,1.541E-01/

		DATA (Rsoil2(i),i=1401,1500)/&
	1.541E-01,1.540E-01,1.539E-01,1.538E-01,1.538E-01,1.537E-01,1.537E-01,1.537E-01,1.537E-01,1.537E-01,&
	1.537E-01,1.537E-01,1.537E-01,1.537E-01,1.537E-01,1.537E-01,1.536E-01,1.535E-01,1.534E-01,1.534E-01,&
	1.533E-01,1.533E-01,1.533E-01,1.533E-01,1.533E-01,1.533E-01,1.531E-01,1.528E-01,1.526E-01,1.524E-01,&
	1.522E-01,1.519E-01,1.517E-01,1.515E-01,1.512E-01,1.510E-01,1.504E-01,1.497E-01,1.491E-01,1.484E-01,&
	1.478E-01,1.473E-01,1.468E-01,1.463E-01,1.458E-01,1.453E-01,1.441E-01,1.429E-01,1.417E-01,1.404E-01,&
	1.392E-01,1.384E-01,1.375E-01,1.366E-01,1.358E-01,1.349E-01,1.341E-01,1.332E-01,1.323E-01,1.315E-01,&
	1.306E-01,1.287E-01,1.269E-01,1.250E-01,1.231E-01,1.212E-01,1.192E-01,1.171E-01,1.151E-01,1.131E-01,&
	1.111E-01,1.077E-01,1.044E-01,1.010E-01,9.765E-02,9.430E-02,9.322E-02,9.214E-02,9.106E-02,8.998E-02,&
	8.890E-02,8.870E-02,8.850E-02,8.829E-02,8.809E-02,8.789E-02,8.823E-02,8.857E-02,8.891E-02,8.924E-02,&
	8.958E-02,9.038E-02,9.118E-02,9.198E-02,9.278E-02,9.358E-02,9.411E-02,9.464E-02,9.518E-02,9.571E-02/

		DATA (Rsoil2(i),i=1501,1600)/&
	9.624E-02,9.694E-02,9.765E-02,9.835E-02,9.905E-02,9.975E-02,9.931E-02,9.886E-02,9.842E-02,9.797E-02,&
	9.752E-02,9.511E-02,9.269E-02,9.027E-02,8.786E-02,8.544E-02,8.363E-02,8.182E-02,8.002E-02,7.821E-02,&
	7.640E-02,7.433E-02,7.226E-02,7.020E-02,6.813E-02,6.606E-02,6.446E-02,6.285E-02,6.124E-02,5.963E-02,&
	5.802E-02,5.701E-02,5.600E-02,5.499E-02,5.398E-02,5.297E-02,5.225E-02,5.154E-02,5.083E-02,5.011E-02,&
	4.940E-02,4.883E-02,4.826E-02,4.769E-02,4.712E-02,4.655E-02,4.626E-02,4.597E-02,4.567E-02,4.538E-02,&
	4.508E-02,4.508E-02,4.508E-02,4.508E-02,4.507E-02,4.507E-02,4.529E-02,4.550E-02,4.572E-02,4.594E-02,&
	4.615E-02,4.615E-02,4.615E-02,4.615E-02,4.614E-02,4.614E-02,4.614E-02,4.614E-02,4.613E-02,4.613E-02,&
	4.613E-02,4.613E-02,4.612E-02,4.612E-02,4.612E-02,4.612E-02,4.626E-02,4.640E-02,4.655E-02,4.669E-02,&
	4.683E-02,4.731E-02,4.779E-02,4.827E-02,4.875E-02,4.922E-02,4.965E-02,5.009E-02,5.052E-02,5.095E-02,&
	5.138E-02,5.192E-02,5.246E-02,5.299E-02,5.353E-02,5.407E-02,5.463E-02,5.518E-02,5.574E-02,5.630E-02/

		DATA (Rsoil2(i),i=1601,1700)/&
	5.685E-02,5.702E-02,5.720E-02,5.737E-02,5.754E-02,5.771E-02,5.807E-02,5.843E-02,5.879E-02,5.916E-02,&
	5.952E-02,6.013E-02,6.073E-02,6.134E-02,6.194E-02,6.255E-02,6.301E-02,6.347E-02,6.393E-02,6.439E-02,&
	6.486E-02,6.524E-02,6.563E-02,6.601E-02,6.640E-02,6.679E-02,6.720E-02,6.761E-02,6.802E-02,6.843E-02,&
	6.885E-02,6.943E-02,7.002E-02,7.060E-02,7.119E-02,7.177E-02,7.267E-02,7.356E-02,7.445E-02,7.534E-02,&
	7.623E-02,7.693E-02,7.764E-02,7.834E-02,7.904E-02,7.974E-02,8.027E-02,8.080E-02,8.133E-02,8.186E-02,&
	8.239E-02,8.283E-02,8.327E-02,8.371E-02,8.415E-02,8.459E-02,8.514E-02,8.570E-02,8.626E-02,8.681E-02,&
	8.737E-02,8.764E-02,8.791E-02,8.817E-02,8.844E-02,8.871E-02,8.911E-02,8.951E-02,8.992E-02,9.032E-02,&
	9.072E-02,9.072E-02,9.072E-02,9.071E-02,9.071E-02,9.071E-02,9.089E-02,9.107E-02,9.125E-02,9.143E-02,&
	9.162E-02,9.209E-02,9.256E-02,9.303E-02,9.350E-02,9.397E-02,9.447E-02,9.496E-02,9.546E-02,9.596E-02,&
	9.646E-02,9.691E-02,9.737E-02,9.782E-02,9.827E-02,9.872E-02,9.886E-02,9.899E-02,9.913E-02,9.926E-02/

		DATA (Rsoil2(i),i=1701,1800)/&
	9.940E-02,9.976E-02,1.001E-01,1.005E-01,1.008E-01,1.012E-01,1.018E-01,1.025E-01,1.031E-01,1.037E-01,&
	1.043E-01,1.045E-01,1.047E-01,1.049E-01,1.051E-01,1.053E-01,1.059E-01,1.064E-01,1.070E-01,1.075E-01,&
	1.081E-01,1.081E-01,1.081E-01,1.081E-01,1.081E-01,1.081E-01,1.086E-01,1.092E-01,1.098E-01,1.103E-01,&
	1.109E-01,1.111E-01,1.114E-01,1.116E-01,1.118E-01,1.121E-01,1.121E-01,1.122E-01,1.123E-01,1.124E-01,&
	1.124E-01,1.128E-01,1.132E-01,1.136E-01,1.140E-01,1.144E-01,1.145E-01,1.146E-01,1.147E-01,1.148E-01,&
	1.150E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,&
	1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,&
	1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,1.149E-01,&
	1.149E-01,1.149E-01,1.150E-01,1.151E-01,1.152E-01,1.152E-01,1.155E-01,1.157E-01,1.160E-01,1.163E-01,&
	1.165E-01,1.165E-01,1.166E-01,1.166E-01,1.166E-01,1.167E-01,1.174E-01,1.181E-01,1.188E-01,1.196E-01/

		DATA (Rsoil2(i),i=1801,1900)/&
	1.203E-01,1.201E-01,1.200E-01,1.199E-01,1.197E-01,1.196E-01,1.191E-01,1.186E-01,1.181E-01,1.176E-01,&
	1.171E-01,1.167E-01,1.163E-01,1.159E-01,1.156E-01,1.152E-01,1.152E-01,1.152E-01,1.151E-01,1.151E-01,&
	1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,&
	1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,&
	1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,1.151E-01,&
	1.151E-01,1.150E-01,1.149E-01,1.148E-01,1.148E-01,1.147E-01,1.141E-01,1.134E-01,1.128E-01,1.121E-01,&
	1.115E-01,1.115E-01,1.115E-01,1.114E-01,1.114E-01,1.114E-01,1.111E-01,1.108E-01,1.105E-01,1.102E-01,&
	1.099E-01,1.097E-01,1.095E-01,1.093E-01,1.091E-01,1.089E-01,1.086E-01,1.084E-01,1.082E-01,1.079E-01,&
	1.077E-01,1.074E-01,1.071E-01,1.068E-01,1.064E-01,1.061E-01,1.056E-01,1.051E-01,1.046E-01,1.041E-01,&
	1.036E-01,1.029E-01,1.021E-01,1.013E-01,1.005E-01,9.971E-02,9.941E-02,9.910E-02,9.879E-02,9.849E-02/

		DATA (Rsoil2(i),i=1901,2000)/&
	9.818E-02,9.818E-02,9.818E-02,9.817E-02,9.817E-02,9.817E-02,9.817E-02,9.817E-02,9.816E-02,9.816E-02,&
	9.816E-02,9.809E-02,9.802E-02,9.795E-02,9.788E-02,9.781E-02,9.741E-02,9.700E-02,9.660E-02,9.620E-02,&
	9.580E-02,9.537E-02,9.495E-02,9.453E-02,9.411E-02,9.369E-02,9.319E-02,9.269E-02,9.219E-02,9.169E-02,&
	9.118E-02,9.118E-02,9.118E-02,9.118E-02,9.117E-02,9.117E-02,9.078E-02,9.039E-02,9.000E-02,8.961E-02,&
	8.922E-02,8.888E-02,8.853E-02,8.819E-02,8.785E-02,8.750E-02,8.779E-02,8.808E-02,8.837E-02,8.866E-02,&
	8.895E-02,8.865E-02,8.836E-02,8.807E-02,8.777E-02,8.748E-02,8.680E-02,8.613E-02,8.546E-02,8.478E-02,&
	8.411E-02,8.332E-02,8.254E-02,8.176E-02,8.097E-02,8.019E-02,8.011E-02,8.003E-02,7.995E-02,7.987E-02,&
	7.979E-02,7.946E-02,7.914E-02,7.882E-02,7.849E-02,7.817E-02,7.754E-02,7.691E-02,7.628E-02,7.565E-02,&
	7.502E-02,7.496E-02,7.489E-02,7.483E-02,7.476E-02,7.470E-02,7.394E-02,7.318E-02,7.242E-02,7.167E-02,&
	7.091E-02,7.083E-02,7.074E-02,7.066E-02,7.058E-02,7.050E-02,7.015E-02,6.981E-02,6.946E-02,6.912E-02/

		DATA (Rsoil2(i),i=2001,2101)/&
	6.878E-02,6.878E-02,6.877E-02,6.877E-02,6.877E-02,6.877E-02,6.803E-02,6.730E-02,6.657E-02,6.584E-02,&
	6.511E-02,6.445E-02,6.379E-02,6.313E-02,6.247E-02,6.182E-02,6.167E-02,6.153E-02,6.138E-02,6.124E-02,&
	6.110E-02,6.018E-02,5.927E-02,5.835E-02,5.743E-02,5.652E-02,5.619E-02,5.585E-02,5.552E-02,5.519E-02,&
	5.485E-02,5.485E-02,5.485E-02,5.485E-02,5.484E-02,5.484E-02,5.455E-02,5.425E-02,5.396E-02,5.366E-02,&
	5.337E-02,5.337E-02,5.337E-02,5.336E-02,5.336E-02,5.336E-02,5.316E-02,5.297E-02,5.278E-02,5.258E-02,&
	5.239E-02,5.192E-02,5.145E-02,5.099E-02,5.052E-02,5.005E-02,4.963E-02,4.921E-02,4.878E-02,4.836E-02,&
	4.793E-02,4.777E-02,4.761E-02,4.744E-02,4.728E-02,4.711E-02,4.727E-02,4.743E-02,4.759E-02,4.774E-02,&
	4.790E-02,4.796E-02,4.801E-02,4.807E-02,4.813E-02,4.818E-02,4.833E-02,4.847E-02,4.861E-02,4.876E-02,&
	4.890E-02,4.904E-02,4.919E-02,4.933E-02,4.947E-02,4.962E-02,4.961E-02,4.961E-02,4.961E-02,4.961E-02,&
	4.960E-02,4.960E-02,4.960E-02,4.960E-02,4.959E-02,4.959E-02,4.944E-02,4.930E-02,4.915E-02,4.900E-02,&
	4.885E-02/

	END