#!/usr/bin/env python
# coding=utf-8
# Pake: Pythonic Make
# Copyright 2010 MyFreeWeb
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Pake: Pythonic Make.
The simple utility for automating tasks like building apps and different bundles, removing temporary files, migrating databases and other stuff."""
import os
import re

import errors

class Paker(object):
    """Base class that executes actions on targets in the parsed yaml file.
    """
    varre = re.compile('%{\w+}', re.M | re.L)
    
    def __init__(self, parsedyaml, varsover):
        """Init just sets tree and variables in class attribute (self.tree, self.variables)"""
        self.tree = parsedyaml
        try:
            self.variables = self.tree['vars']
        except: self.variables = {} # If we have no vars in yaml, it's empty
        self.variables.update(varsover.items()) # + overrides from command line
        if self.variables.get('debug') == 'true':
            print self.tree
            print self.variables

    def replace_vars(self, atext):
        """Replaces all variables with their value in given text."""
        if self.varre.search(atext):
            for match in self.varre.findall(atext):
                varname = match.replace('{', '').replace('}', '').replace('%', '')
                atext = atext.replace(match, self.variables[varname])
        return atext

    def run_action(self, action, atext):
        """Runs action with atext. Action types are defined inside for now."""
        if action == 'python':
            n = 'make.tmp.py'
            open(n, 'w').write('import os, sys, pakeapi\n' + atext)
            execfile(n)
            os.remove(n)
        elif action == 'shell':
            os.system(atext)
        elif action.startswith('target'):
            self.run_target(atext, reverse=True)
        else:
            raise errors.UnknownActionError(action)

    def run_target(self, target, reverse=False):
        """Runs target :)"""
        tg = self.tree[target].items()
        tg.sort()
        if reverse: tg.reverse() # we need this on recursion

        for action, atext in tg:
            atext = self.replace_vars(atext)
            self.run_action(action, atext)
