"""
Sebastian Raschka 2014

Unit tests for contains_atom function in mol2filter.py

"""

from pyprot.mol2filter import distance_match

MOL2_STR1 = """@<TRIPOS>MOLECULE
ZINC00000016
   37    38     0     0     0
SMALL
USER_CHARGES

@<TRIPOS>ATOM
      1 C1         -0.0184    1.5028    0.0103 C.3       1 <0>        -0.1218
      2 C2          0.0021   -0.0041    0.0020 C.ar      1 <0>        -0.0597
      3 C3          0.0057   -0.6866   -1.2011 C.ar      1 <0>        -0.1229
      4 C4          0.0239   -2.0666   -1.2144 C.ar      1 <0>        -0.0736
      5 C5          0.0392   -2.7722   -0.0132 C.ar      1 <0>        -0.0550
      6 C6          0.0359   -2.0797    1.1957 C.ar      1 <0>        -0.0770
      7 C7          0.0229   -0.6995    1.1975 C.ar      1 <0>        -0.1228
      8 C8          0.0583   -4.2565   -0.0214 C.2       1 <0>         0.1456
      9 C9          0.0693   -5.0940    1.1184 C.2       1 <0>        -0.1743
     10 C10         0.0853   -6.3833    0.6885 C.2       1 <0>         0.0377
     11 O1          0.0847   -6.3706   -0.6593 O.2       1 <0>        -0.0409
     12 N1          0.0623   -5.0208   -1.0858 N.2       1 <0>        -0.2789
     13 C11         0.1015   -7.5830    1.5447 C.2       1 <0>        -0.8000
     14 O2          0.1011   -7.4663    2.7541 O.2       1 <0>        -1.0000
     15 O3          0.1166   -8.8094    0.9860 O.3       1 <0>        -0.3200
     16 C12         0.1318   -9.9275    1.8757 C.3       1 <0>         0.0481
     17 C13         0.1474  -11.2051    1.0767 C.2       1 <0>         0.5149
     18 O4          0.1457  -11.1624   -0.1353 O.2       1 <0>        -0.5094
     19 N2          0.1632  -12.3952    1.7091 N.am      1 <0>        -0.6181
     20 C14         0.1783  -13.6373    0.9324 C.3       1 <0>         0.0795
     21 C15         0.1652  -12.4468    3.1732 C.3       1 <0>         0.0699
     22 H1          1.0042    1.8801    0.0026 H         1 <0>         0.0766
     23 H2         -0.5455    1.8639   -0.8728 H         1 <0>         0.0709
     24 H3         -0.5286    1.8543    0.9071 H         1 <0>         0.0710
     25 H4         -0.0062   -0.1386   -2.1317 H         1 <0>         0.1319
     26 H5          0.0260   -2.5985   -2.1543 H         1 <0>         0.1331
     27 H6          0.0477   -2.6218    2.1297 H         1 <0>         0.1323
     28 H7          0.0244   -0.1617    2.1340 H         1 <0>         0.1328
     29 H8          0.0658   -4.7670    2.1477 H         1 <0>         0.1796
     30 H9          1.0218   -9.8805    2.5032 H         1 <0>         0.1077
     31 H10        -0.7580   -9.9032    2.5049 H         1 <0>         0.1078
     32 H11         0.1743  -13.4005   -0.1316 H         1 <0>         0.0898
     33 H12         1.0759  -14.2064    1.1746 H         1 <0>         0.0652
     34 H13        -0.7039  -14.2291    1.1762 H         1 <0>         0.0649
     35 H14        -0.8619  -12.4728    3.5373 H         1 <0>         0.0644
     36 H15         0.6909  -13.3424    3.5045 H         1 <0>         0.0809
     37 H16         0.6682  -11.5637    3.5672 H         1 <0>         0.0738
@<TRIPOS>BOND
     1    1    2 1
     2    1   22 1
     3    1   23 1
     4    1   24 1
     5    2    7 ar
     6    2    3 ar
     7    3    4 ar
     8    3   25 1
     9    4    5 ar
    10    4   26 1
    11    5    6 ar
    12    5    8 1
    13    6    7 ar
    14    6   27 1
    15    7   28 1
    16    8   12 2
    17    8    9 1
    18    9   10 2
    19    9   29 1
    20   10   11 1
    21   10   13 1
    22   11   12 1
    23   13   14 2
    24   13   15 1
    25   15   16 1
    26   16   17 1
    27   16   30 1
    28   16   31 1
    29   17   18 2
    30   17   19 am
    31   19   20 1
    32   19   21 1
    33   20   32 1
    34   20   33 1
    35   20   34 1
    36   21   35 1
    37   21   36 1
    38   21   37 1"""


MOL2_CONT1 = MOL2_STR1.split('\n')

def test_distance_match():
    assert(distance_match(MOL2_CONT1, [['O.3'],['O.2']], [0,100]) == True)
    assert(distance_match(MOL2_CONT1, [['O.3'],['O.2']], [0,2.90]) == True)
    assert(distance_match(MOL2_CONT1, [['O.3'],['O.2']], [0,1.90]) == False)
