"""
Data about PDB files, codes, and structures.

"""

#################################################################
# IRIDIUM
#################################################################

# The Iridium database by OpenEye Scientific Software contains high-quality, 
# verified protein structures that are recommended for 
# lead optimization, docking, and virtual screening.
#
# Warren, G.L., Do, T.D., Kelley, B.P., Nicholls, A. and Warren, S.D. (2012), 
# “Essential considerations for using protein–ligand structures in drug discovery”, 
# Drug Discovery Today, Vol. 17 No. 23-24, pp. 1270–1281.
#
# The database is freely available at http://www.eyesopen.com/iridiumå



# Highly Trustworthy (Iridium HT): 121 structures

IRIDIUM_HT = [
    "1A28", "1AI5", "1AZM", "1B9V", "1BR6", "1C1B", "1CTR", "1CVU", "1CX2", "1D3H", 
    "1DD7", "1DDS", "1EOC", "1EXA", "1EZQ", "1F0S", "1F0T", "1F0U", "1FCX", "1FCZ", 
    "1FH8", "1FH9", "1FHD", "1FJS", "1FL3", "1FM6", "1FM9", "1FQ5", "1FRP", "1FVT", 
    "1G9V", "1GM8", "1GWX", "1H1P", "1H1S", "1HDY", "1HGG", "1HGH", "1HGI", "1HGJ", 
    "1HNN", "1HP0", "1HQ2", "1HVY", "1HWI", "1HWW", "1IVB", "1IVD", "1IVE", "1IVF", 
    "1IY7", "1JD0", "1JLA", "1K1J", "1K3U", "1KE5", "1L2S", "1L7F", "1LPZ", "1LQD", 
    "1LRH", "1M2Z", "1MBI", "1ML1", "1MMV", "1MQ6", "1MTS", "1MZC", "1N1M", "1N2J", 
    "1N2V", "1NAV", "1OF1", "1OF6", "1OQ5", "1OWE", "1OYT", "1P2Y", "1P62", "1PBD", 
    "1PMN", "1PSO", "1Q1G", "1Q41", "1QHI", "1R58", "1R9O", "1ROB", "1S19", "1SQ5", 
    "1TOW", "1TT1", "1U4D", "1UKZ", "1ULB", "1UML", "1UNL", "1UOU", "1V0P", "1W1P", 
    "1W2G", "1X8X", "1XM6", "1XOQ", "1YDR", "1YDS", "1YDT", "1YQY", "1YV3", "1YVF", 
    "1YWR", "2ACK", "2BR1", "2CTC", "2MCP", "2PCP", "2TMN", "3PTB", "4AAH", "4COX", 
    "4TS1"
    ]


# Mildly Trustworthy (Iridium MT): 104 structures

IRIDIUM_MT = [
    "13GS", "1A07", "1A1B", "1A1E", "1A4K", "1A8T", "1AFQ", "1AKE", "1AVD", "1B59", 
    "1B6J", "1B6K", "1B6L", "1B6M", "1BKM", "1BMQ", "1C2T", "1C3I", "1C5C", "1C5P", 
    "1C5X", "1CBS", "1CDE", "1CDG", "1CET", "1COY", "1CQP", "1CTT", "1D0L", "1DIB", 
    "1DY9", "1EVE", "1F0R", "1FBL", "1GKC", "1GPK", "1GSP", "1HBV", "1I7Z", "1IA1", 
    "1IBG", "1ICN", "1IG3", "1IGJ", "1IVC", "1J3J", "1JJE", "1K7E", "1K7F", "1KEL", 
    "1KZK", "1LMO", "1LPM", "1LYL", "1M48", "1MEH", "1MQ5", "1MRG", "1MRK", "1MTW", 
    "1N46", "1NHU", "1NHV", "1ODW", "1OPK", "1PGP", "1Q4G", "1QH7", "1R1H", "1R55", 
    "1RNT", "1S3V", "1SG0", "1SJ0", "1SLN", "1SNC", "1SQN", "1T40", "1T46", "1T9B", 
    "1THL", "1THY", "1TLP", "1TPP", "1TZ8", "1U1C", "1V48", "1V4S", "1VCJ", "1XOZ", 
    "1Y6B", "1YGC", "1Z95", "25C8", "2ADA", "2BM2", "2BSM", "2TPI", "3TPI", "4HMG", 
    "4TMN", "5TIM", "5TMN", "6TMN"
    ]


# Not Trustworthy (Iridium NT): 8 structures

IRIDIUM_NT = ["1AJ7", "1ATL", "1ETA", "1R09", "1VGC", "1VRH", "2R04", "2R07"]



