# coding: UTF-8
#
# Copyright © 2012, Elizabeth J. Myers, et al. All rights reserved.
# License terms can be found in the LICENSE file at the top level of the source
# tree.

from PyProto.eventloop import Exceptions
from PyProto.eventloop.Events import EVENT_IN, EVENT_OUT, EVENT_EXCEPT
from PyProto.eventloop.engines import nullengine

try: from select import POLLIN, POLLOUT, POLLERR, devpoll
except: raise Exceptions.EventLoopUnsupportedException("devpoll is only supported on Solaris 8 and above.")

class DevPollEventEngine(nullengine.NullEventEngine):
    def __init__(self):
        # Initalise some internal state
        self.devpollhandle = devpoll()

    def __flags_to_devpoll(self, evtype):
        mask = 0
        if evtype & EVENT_IN != 0:
            mask |= POLLIN
        if evtype & EVENT_OUT != 0:
            mask |= POLLOUT
        if evtype & EVENT_EXCEPT != 0:
            mask |= POLLERR

        return mask

    def register_fd(self, fd, evtype):
        mask = self.__flags_to_devpoll(evtype)
        self.devpollhandle.register(fd, mask)

    # Obliterate FD entirely
    def unregister_fd(self, fd):
        self.devpollhandle.unregister(fd)

    def modify_fd(self, fd, evtype):
        mask = self.__flags_to_epoll(evtype)
        self.devpollhandle.modify(fd, mask)

    def run_once(self, timeout=-1):
        if timeout == 0 or timeout is None:
            timeout = -1

        fds = self.devpollhandle.poll(timeout)

        fdlist = []

        for s in fds:
            fd, event = s

            mask = 0
            if event & POLLIN != 0:
                mask |= EVENT_IN
            if event & POLLOUT != 0:
                mask |= EVENT_OUT
            if event & POLLERR != 0:
                mask |= EVENT_EXCEPT

            fdlist.append((fd, mask))

        return fdlist

