# coding: UTF-8
#
# Copyright © 2012, Elizabeth J. Myers, et al. All rights reserved.
# License terms can be found in the LICENSE file at the top level of the source
# tree.

import os, platform
import ctypes
import time

system = platform.system()

if hasattr(time, 'monotonic'):
    monotonic = time.monotonic
    implementation = "Python 3.3+ builtin"
else:
    # Use POSIX monotonic
    if system == 'Linux' or system.endswith('BSD'):
        CLOCK_MONOTONIC = 4 # CLOCK_MONOTONIC_RAW on Linux, it does what we really want.
        class timespec(ctypes.Structure):
            _fields_ = [
                ('tv_sec', ctypes.c_long),
                ('tv_nsec', ctypes.c_long),
            ]
        librt = ctypes.CDLL('librt.so.1', use_errno=True)
        clock_gettime = librt.clock_gettime
        clock_gettime.argtypes = [ctypes.c_int, ctypes.POINTER(timespec)]

        implementation = "clock_gettime"

        def monotonic():
            t = timespec()
            if clock_gettime(CLOCK_MONOTONIC, ctypes.pointer(t)) != 0:
                e = ctypes.get_errno()
                raise OSError(e, os.strerror(e))
            return t.tv_sec
    else:
        # Use time.time as a fallback.
        monotonic = time.time
        implementation = "Fallback (not monotonic)"

