# Contributing to PyReact

## Development Process

The majority of development on PyReact will occur through GitHub. Accordingly, the process for contributing will follow standard GitHub protocol.

### Bugs

We will be using GitHub Issues for our public bugs. Before filing a new task, try to make sure your problem doesn't already exist. Then, provide clear repro steps, with examples if possible.

### Pull Requests

Please submit your patches to PyReact via pull requests. *Before* submitting a pull request, please make sure the following is done:

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests!
3. If you've changed APIs, update the documentation.
4. Make sure your code follows PEP8 style guidelines.
5. If you haven't already, complete the CLA.

### Contributor License Agreement ("CLA")

In order to accept your pull request, we need you to submit a CLA. You only need to do this once, so if you've done this for another Facebook open source project, you're good to go. If you are submitting a pull request for the first time, just let us know that you have completed the CLA and we can cross-check with your GitHub username.

Complete your CLA here: <https://developers.facebook.com/opensource/cla>

## How to Get in Touch

* IRC - [#reactjs on freenode](http://webchat.freenode.net/?channels=reactjs)
* Mailing list - [reactjs on Google Groups](http://groups.google.com/group/reactjs)

## License

By contributing to PyReact, you agree that your contributions will be licensed under the [Apache License Version 2.0 (APLv2)](LICENSE).