"""
Simple script to check if the load balancing works on 1-d data.
"""

try:
    import mpi4py.MPI as mpi
except ImportError:
    import nose.plugins.skip as skip
    reason = "mpi4py not installed"
    raise skip.SkipTest(reason)

# mpi imports
from mpi4py import MPI
comm = MPI.COMM_WORLD
num_procs = comm.Get_size()
rank = comm.Get_rank()

# logging setup
# logging setup
import logging
logger = logging.getLogger()
log_file_name = '/tmp/log_pysph_'+str(rank)
logging.basicConfig(level=logging.DEBUG, filename=log_file_name,
                    filemode='w')
logger.addHandler(logging.StreamHandler())

# local imports
from pysph.base.particle_array import ParticleArray
from pysph.parallel.parallel_cell import ParallelCellManager
from pysph.solver.basic_generators import LineGenerator
from pysph.base.cell import INT_INF
from pysph.base.point import *


pcm = ParallelCellManager(initialize=False, dimension=1)


parray = ParticleArray(name='parray')

if rank == 0:
    lg = LineGenerator(start_point=Point(0, 0, 0),
                       end_point=Point(1.0, 0, 0),
                       particle_spacing=0.01)
    x, y, z = lg.get_coords()

    parray.add_property({'name':'x', 'data':x})
    parray.add_property({'name':'y', 'data':y})
    parray.add_property({'name':'z', 'data':z})
    parray.add_property({'name':'h'})
    parray.align_particles()
    parray.h[:] = 0.01
else:
    parray.add_property({'name':'x'})
    parray.add_property({'name':'y'})
    parray.add_property({'name':'z'})
    parray.add_property({'name':'h'})

pcm.add_array_to_bin(parray)
pcm.initialize()
