#!/usr/bin/env python
'''
Created on Jul 10, 2013

@author: andre
'''
import sys
import time
from pystarlight.util.gridfile import GridFile
from os import path
import random
import os

corruption_chance=0.0
interval = 0.1 # seconds

def rot_bits(data):
    '''
    Maybe corrupt some data.
    '''
    data_out = []
    for _, c in enumerate(data):
        if random.random() < corruption_chance:
            data_out.append('X')
        else:
            data_out.append(c)
    return ''.join(data_out)


def read_grid():
    grid_data = sys.stdin.read()
    grid = GridFile(os.curdir, grid_data)
    return grid


def save_output(filename, data):
    with open(filename, 'w') as f:
        f.write(data)


output_data = '''############################################################################
## OUTPUT of PANcMExStarlight_v03.for      [ElCid@Sanchica - 10/Feb/2012] ##
############################################################################

## Some input info
K0001_0323_eBR_v20.d13                   [arq_obs]  from /se/data/starlight/sl_in/Bzca01_95799/
BASE.gsc01                               [arq_base]
Mask.GeneralEmLines                      [arq_masks]
PMSv03.k1.config                         [arq_config]
  160                                    [N_base]
   0       0       0   0   0             [N_exAV_components N_exAV    IsFIRcOn IsQHRcOn IsPHOcOn] <=== FIRc-fit Y/N?  QHRc-fit Y/N?  PHOc-fit Y/N?
    0                                    [i_FitPowerLaw (1/0 = Yes/No) = NO in this version!!]
-9.99                                    [alpha_PowerLaw]
CCM                                      [red_law_option]
 0.971723     1.000000E-16               [q_norm = A(l_norm)/A(V) & flux_unit]

## (Re)Sampling Parameters
 3650.00                                 [l_ini (A)]
 6950.00                                 [l_fin (A)]
    2.00     40.00                       [dl  &  dl_cushion (A)]

## Normalization info
 5635.00                                 [l_norm (A) - for base]
 5590.00                                 [llow_norm (A) - window for f_obs]
 5680.00                                 [lupp_norm (A) - window for f_obs]
1.253487E-17  1.864544E+03    68.960     [fobs_norm & Lobs_norm & LumDistInMpc]

## S/N
 5350.00                                 [llow_SN (A) - window for S/N]
 5850.00                                 [lupp_SN (A) - window for S/N]
  22.906                                 [S/N in S/N window]
  22.950                                 [S/N in norm. window]
  31.807                                 [S/N_err in S/N window]
  31.868                                 [S/N_err in norm. window]
  1.0000            1                    [fscale_chi2 & IsOptimize_fn_OPT]

## etc...
  -958373050                             [idum_orig]
  1095                                   [NOl_eff]
  1095                                   [Nl_eff]
     0    NSIGMA                         [Ntot_cliped & clip_method]
  4847780                                [Nglobal_steps]
   7                                     [N_chains]
  36                                     [NEX0s_base = N_base in EX0s-fits]
 0   0   1        0   2.0   4.20311E+01  [Clip-Bug, RC-Crash & Burn-In warning-flags, n_censored_weights, wei_nsig_threshold & wei_limit]
    161    161.393    161.324      0.069 [idt_all, wdt_TotTime, wdt_UsrTime & wdt_SysTime (sec)]

## Synthesis Results - Best model ##

 7.12479E-01      7.80165E+02                                       [chi2/Nl_eff & chi2]
     2.68485                                                        [adev (%)]
 7.80165E+02  7.80165E+02  0.00000E+00  0.00000E+00  0.00000E+00    [chi2_TOT chi2_Opt chi2_FIR chi2_QHR chi2_PHO - ALL chi2s!]
    98.08668                                                        [sum-of-x (%)]
 6.42191E+03                                                        [Lum_tot (Lsun/A if distance & flux_unit are Ok...)]
 1.71965E+08                                                        [Mini_tot (Msun  if distance & flux_unit are Ok...)]
 1.24313E+08                                                        [Mcor_tot (Msun  if distance & flux_unit are Ok...)]

  81.05                                                             [v0_min  (km/s)]
 172.21                                                             [vd_min  (km/s)]
 1.4034                                                             [AV_min  (mag)]
  0.000  0.000  0.000  0.000  0.000  0.000  0.000  0.000  0.000  0.000          [exAV_min (mag)] 1...10 of N_exAV =   0

# j     x_j(%)      Mini_j(%)     Mcor_j(%)     age_j(yr)     Z_j      (L/M)_j   exAV?  Mstars   component_j        a/Fe...    |  SSP_chi2r SSP_adev(%)   SSP_AV   SSP_x(%)    |  AV_tot   <LAx>_j(%)
  1      0.0000     0.0000E+00    0.0000E+00    1.000000E+06  0.00370  2.899E-03    0   1.0000   ageGe_00_z004         0.0000     2.5460E+00     5.3820   3.8392    100.663       1.4034      0.0000
  2      0.0000     0.0000E+00    0.0000E+00    3.000000E+06  0.00370  1.391E-02    0   1.0000   ageGe_02_z004         0.0000     2.3294E+00     5.0990   3.4921    100.546       1.4034      0.0000
  3      0.0000     0.0000E+00    0.0000E+00    7.000000E+06  0.00370  7.992E-03    0   0.9659   ageGe_02_z004         0.0000     2.0406E+00     4.7192   3.1745    100.486       1.4034      0.0000
  4      0.0000     0.0000E+00    0.0000E+00    8.000000E+06  0.00370  6.302E-03    0   0.9591   ageGe_02_z004         0.0000     1.9506E+00     4.5884   3.1438    100.424       1.4034      0.0000
  5      0.0000     0.0000E+00    0.0000E+00    9.000000E+06  0.00370  5.264E-03    0   0.9532   ageGe_08_z004         0.0000     1.7515E+00     4.2656   3.0013    100.069       1.4034      0.0000
  6      0.0000     0.0000E+00    0.0000E+00    9.990000E+06  0.00370  4.396E-03    0   0.9532   ageGe_08_z004         0.0000     1.7940E+00     4.3369   3.1361    100.092       1.4034      0.0000
  7      0.0000     0.0000E+00    0.0000E+00    1.000000E+07  0.00370  3.784E-03    0   0.9224   age09_z004            0.0000     1.3155E+00     3.5513   2.6607     99.282       1.4034      0.0000
  8      0.0000     0.0000E+00    0.0000E+00    1.259000E+07  0.00370  2.667E-03    0   0.9143   age11_z004            0.0000     1.4647E+00     3.7907   2.9322     99.543       1.4034      0.0000
  9      0.0000     0.0000E+00    0.0000E+00    1.413000E+07  0.00370  2.163E-03    0   0.9102   age12_z004            0.0000     1.4972E+00     3.8404   3.0250     99.574       1.4034      0.0000
 10      0.0000     0.0000E+00    0.0000E+00    1.778000E+07  0.00370  1.798E-03    0   0.9022   age14_z004            0.0000     1.4570E+00     3.7741   2.9954     99.621       1.4034      0.0000
 11      0.0000     0.0000E+00    0.0000E+00    1.995000E+07  0.00370  1.726E-03    0   0.8982   age15_z004            0.0000     1.3386E+00     3.5895   2.8500     99.566       1.4034      0.0000
 12      0.0000     0.0000E+00    0.0000E+00    2.511900E+07  0.00370  1.592E-03    0   0.8903   age17_z004            0.0000     1.2461E+00     3.4485   2.6673     99.479       1.4034      0.0000
 13      0.0000     0.0000E+00    0.0000E+00    3.162000E+07  0.00370  1.476E-03    0   0.8824   age19_z004            0.0000     1.1206E+00     3.2612   2.3811     99.346       1.4034      0.0000
 14      0.0000     0.0000E+00    0.0000E+00    3.981100E+07  0.00370  1.250E-03    0   0.8747   age21_z004            0.0000     1.1354E+00     3.2870   2.4148     99.450       1.4034      0.0000
 15      0.0000     0.0000E+00    0.0000E+00    5.623000E+07  0.00370  9.821E-04    0   0.8631   age24_z004            0.0000     1.2727E+00     3.5035   2.6128     99.585       1.4034      0.0000
 16      0.0000     0.0000E+00    0.0000E+00    6.300000E+07  0.00370  9.258E-04    0   0.8593   age25_z004            0.0000     1.2745E+00     3.5082   2.5945     99.562       1.4034      0.0000
 17      0.0000     0.0000E+00    0.0000E+00    6.310000E+07  0.00370  9.092E-04    0   0.8596   V00.06m0.71           0.0000     1.3169E+00     3.5585   2.5638     99.109       1.4034      0.0000
 18      0.0000     0.0000E+00    0.0000E+00    7.080000E+07  0.00370  8.527E-04    0   0.8549   V00.07m0.71           0.0000     1.3020E+00     3.5340   2.5295     99.097       1.4034      0.0000
 19      0.0000     0.0000E+00    0.0000E+00    1.000000E+08  0.00370  6.953E-04    0   0.8421   V00.10m0.71           0.0000     1.3117E+00     3.5515   2.5248     99.062       1.4034      0.0000
 20      0.0000     0.0000E+00    0.0000E+00    1.122000E+08  0.00370  6.706E-04    0   0.8380   V00.11m0.71           0.0000     1.2020E+00     3.4002   2.3976     98.558       1.4034      0.0000
 21      0.0000     0.0000E+00    0.0000E+00    1.259000E+08  0.00370  7.174E-04    0   0.8334   V00.12m0.71           0.0000     1.1962E+00     3.5197   1.8502     96.669       1.4034      0.0000
 22      0.0000     0.0000E+00    0.0000E+00    1.585000E+08  0.00370  6.117E-04    0   0.8242   V00.15m0.71           0.0000     1.1650E+00     3.4298   1.9346     96.854       1.4034      0.0000
 23      0.0000     0.0000E+00    0.0000E+00    1.995000E+08  0.00370  5.198E-04    0   0.8150   V00.19m0.71           0.0000     1.1308E+00     3.3310   2.0399     97.321       1.4034      0.0000
 24      0.0000     0.0000E+00    0.0000E+00    2.818000E+08  0.00370  4.067E-04    0   0.8018   V00.28m0.71           0.0000     1.1276E+00     3.2907   2.0399     97.672       1.4034      0.0000
 25      0.0000     0.0000E+00    0.0000E+00    3.548000E+08  0.00370  3.433E-04    0   0.7932   V00.35m0.71           0.0000     1.0775E+00     3.2205   1.9452     97.597       1.4034      0.0000
 26      0.0000     0.0000E+00    0.0000E+00    5.012000E+08  0.00370  2.698E-04    0   0.7804   V00.50m0.71           0.0000     1.0571E+00     3.1773   1.8224     97.559       1.4034      0.0000
 27      0.0000     0.0000E+00    0.0000E+00    7.079000E+08  0.00370  2.138E-04    0   0.7684   V00.70m0.71           0.0000     1.0432E+00     3.1592   1.6496     97.337       1.4034      0.0000
 28      0.0000     0.0000E+00    0.0000E+00    8.913000E+08  0.00370  1.826E-04    0   0.7607   V00.89m0.71           0.0000     1.0193E+00     3.1318   1.5096     97.204       1.4034      0.0000
 29      0.0000     0.0000E+00    0.0000E+00    1.122000E+09  0.00370  1.549E-04    0   0.7534   V01.12m0.71           0.0000     9.7794E-01     3.0931   1.3565     97.268       1.4034      0.0000
 30      0.0000     0.0000E+00    0.0000E+00    1.258900E+09  0.00370  1.496E-04    0   0.7493   V01.25m0.71           0.0000     9.4058E-01     3.0641   1.2126     97.461       1.4034      0.0000
 31      0.0000     0.0000E+00    0.0000E+00    1.412500E+09  0.00370  1.535E-04    0   0.7439   V01.41m0.71           0.0000     9.1629E-01     3.1125   1.0477     97.893       1.4034      0.0000
 32      0.0001     5.0519E-05    5.1267E-05    1.995300E+09  0.00370  9.688E-05    0   0.7336   V01.99m0.71           0.0000     8.7295E-01     3.0708   0.8643     98.278       1.4034      0.0001
 33      0.0000     0.0000E+00    0.0000E+00    2.511900E+09  0.00370  8.141E-05    0   0.7270   V02.51m0.71           0.0000     9.0397E-01     3.2228   0.7225     98.594       1.4034      0.0000
 34      0.0000     0.0000E+00    0.0000E+00    3.548100E+09  0.00370  6.246E-05    0   0.7182   V03.54m0.71           0.0000     9.4510E-01     3.3421   0.6475     98.862       1.4034      0.0000
 35      0.0020     1.5048E-03    1.4838E-03    4.466800E+09  0.00370  5.133E-05    0   0.7128   V04.46m0.71           0.0000     9.6815E-01     3.4123   0.5888     98.914       1.4034      0.0020
 36      0.0000     0.0000E+00    0.0000E+00    6.309600E+09  0.00370  3.823E-05    0   0.7053   V06.30m0.71           0.0000     9.9805E-01     3.4923   0.5104     99.029       1.4034      0.0000
 37      0.0000     0.0000E+00    0.0000E+00    7.943300E+09  0.00370  3.191E-05    0   0.7007   V07.94m0.71           0.0000     1.0240E+00     3.5553   0.4520     99.140       1.4034      0.0000
 38      0.0000     0.0000E+00    0.0000E+00    1.000000E+10  0.00370  2.701E-05    0   0.6967   V10.00m0.71           0.0000     1.0564E+00     3.6363   0.3979     99.271       1.4034      0.0000
 39      0.0000     0.0000E+00    0.0000E+00    1.258930E+10  0.00370  2.317E-05    0   0.6916   V12.58m0.71           0.0000     1.1053E+00     3.7375   0.3338     99.515       1.4034      0.0000
 40      0.0000     0.0000E+00    0.0000E+00    1.412540E+10  0.00370  2.151E-05    0   0.6856   V14.12m0.71           0.0000     1.1137E+00     3.7580   0.3106     99.523       1.4034      0.0000
 41      0.0000     0.0000E+00    0.0000E+00    1.000000E+06  0.00756  3.132E-03    0   1.0000   ageGe_00_z008         0.0000     2.5421E+00     5.3742   3.8297    100.662       1.4034      0.0000
 42      0.0000     0.0000E+00    0.0000E+00    3.000000E+06  0.00756  9.453E-03    0   1.0000   ageGe_02_z008         0.0000     2.4512E+00     5.2619   3.6547    100.611       1.4034      0.0000
 43      0.0000     0.0000E+00    0.0000E+00    7.000000E+06  0.00756  7.962E-03    0   0.9659   ageGe_02_z008         0.0000     1.5792E+00     4.0022   2.8204     99.864       1.4034      0.0000
 44      0.0000     0.0000E+00    0.0000E+00    8.000000E+06  0.00756  6.476E-03    0   0.9591   ageGe_02_z008         0.0000     1.4219E+00     3.7656   2.7352     99.810       1.4034      0.0000
 45      0.0000     0.0000E+00    0.0000E+00    9.000000E+06  0.00756  5.450E-03    0   0.9532   ageGe_08_z008         0.0000     1.2486E+00     3.4822   2.5543     99.422       1.4034      0.0000
 46      0.0000     0.0000E+00    0.0000E+00    9.990000E+06  0.00756  4.847E-03    0   0.9532   ageGe_08_z008         0.0000     1.1895E+00     3.4010   2.5324     99.439       1.4034      0.0000
 47      0.0000     0.0000E+00    0.0000E+00    1.000000E+07  0.00756  3.052E-03    0   0.9224   age09_z008            0.0000     1.4509E+00     3.7750   2.9688     99.569       1.4034      0.0000
 48      0.0000     0.0000E+00    0.0000E+00    1.259000E+07  0.00756  2.569E-03    0   0.9143   age11_z008            0.0000     1.5131E+00     3.8770   3.0386     99.685       1.4034      0.0000
 49      0.0000     0.0000E+00    0.0000E+00    1.413000E+07  0.00756  2.295E-03    0   0.9102   age12_z008            0.0000     1.4941E+00     3.8409   3.0356     99.693       1.4034      0.0000
 50      0.0000     0.0000E+00    0.0000E+00    1.778000E+07  0.00756  1.971E-03    0   0.9022   age14_z008            0.0000     1.3730E+00     3.6495   2.9074     99.640       1.4034      0.0000
 51      0.0000     0.0000E+00    0.0000E+00    1.995000E+07  0.00756  1.848E-03    0   0.8982   age15_z008            0.0000     1.2860E+00     3.5164   2.7992     99.595       1.4034      0.0000
 52      0.0000     0.0000E+00    0.0000E+00    2.511900E+07  0.00756  1.564E-03    0   0.8903   age17_z008            0.0000     1.2500E+00     3.4645   2.7429     99.649       1.4034      0.0000
 53      0.0000     0.0000E+00    0.0000E+00    3.162000E+07  0.00756  1.370E-03    0   0.8824   age19_z008            0.0000     1.1826E+00     3.3642   2.6318     99.629       1.4034      0.0000
 54      0.0000     0.0000E+00    0.0000E+00    3.981100E+07  0.00756  1.156E-03    0   0.8747   age21_z008            0.0000     1.2453E+00     3.4594   2.6950     99.714       1.4034      0.0000
 55      0.0000     0.0000E+00    0.0000E+00    5.623000E+07  0.00756  9.470E-04    0   0.8631   age24_z008            0.0000     1.3031E+00     3.5572   2.7151     99.793       1.4034      0.0000
 56      0.0000     0.0000E+00    0.0000E+00    6.300000E+07  0.00756  8.926E-04    0   0.8593   age25_z008            0.0000     1.3054E+00     3.5672   2.6950     99.810       1.4034      0.0000
 57      0.0000     0.0000E+00    0.0000E+00    6.310000E+07  0.00756  8.868E-04    0   0.8578   V00.06m0.40           0.0000     1.2350E+00     3.4876   2.5715     99.036       1.4034      0.0000
 58      0.0000     0.0000E+00    0.0000E+00    7.080000E+07  0.00756  8.338E-04    0   0.8535   V00.07m0.40           0.0000     1.2139E+00     3.4550   2.5478     98.995       1.4034      0.0000
 59      0.0000     0.0000E+00    0.0000E+00    1.000000E+08  0.00756  6.819E-04    0   0.8403   V00.10m0.40           0.0000     1.2483E+00     3.5044   2.5218     99.045       1.4034      0.0000
 60      0.0000     0.0000E+00    0.0000E+00    1.122000E+08  0.00756  6.383E-04    0   0.8357   V00.11m0.40           0.0000     1.2635E+00     3.5233   2.5401     99.107       1.4034      0.0000
 61      0.0000     0.0000E+00    0.0000E+00    1.259000E+08  0.00756  6.305E-04    0   0.8309   V00.12m0.40           0.0000     1.4387E+00     3.7378   2.0990     96.443       1.4034      0.0000
 62      0.0000     0.0000E+00    0.0000E+00    1.585000E+08  0.00756  5.433E-04    0   0.8220   V00.15m0.40           0.0000     1.2120E+00     3.4231   2.1546     97.114       1.4034      0.0000
 63      0.0000     0.0000E+00    0.0000E+00    1.995000E+08  0.00756  4.625E-04    0   0.8130   V00.19m0.40           0.0000     1.1166E+00     3.2641   2.1670     97.833       1.4034      0.0000
 64      0.0000     0.0000E+00    0.0000E+00    2.818000E+08  0.00756  3.573E-04    0   0.7993   V00.28m0.40           0.0000     1.0938E+00     3.2234   2.1528     97.976       1.4034      0.0000
 65      0.0000     0.0000E+00    0.0000E+00    3.548000E+08  0.00756  3.063E-04    0   0.7905   V00.35m0.40           0.0000     1.0731E+00     3.1897   2.0500     97.799       1.4034      0.0000
 66     18.0812     2.8388E+00    3.0544E+00    5.012000E+08  0.00756  2.425E-04    0   0.7778   V00.50m0.40           0.0000     1.0514E+00     3.1612   1.8933     97.680       1.4034     18.4387
 67      0.0000     0.0000E+00    0.0000E+00    7.079000E+08  0.00756  1.926E-04    0   0.7658   V00.70m0.40           0.0000     9.8934E-01     3.1013   1.6342     97.746       1.4034      0.0000
 68      0.0000     0.0000E+00    0.0000E+00    8.913000E+08  0.00756  1.614E-04    0   0.7583   V00.89m0.40           0.0000     9.4306E-01     3.0612   1.4482     97.916       1.4034      0.0000
 69      0.0000     0.0000E+00    0.0000E+00    1.122000E+09  0.00756  1.376E-04    0   0.7507   V01.12m0.40           0.0000     9.1885E-01     3.0865   1.2534     98.065       1.4034      0.0000
 70      0.0000     0.0000E+00    0.0000E+00    1.258900E+09  0.00756  1.410E-04    0   0.7459   V01.25m0.40           0.0000     8.7772E-01     3.0930   1.0009     98.277       1.4034      0.0000
 71      2.7920     9.2385E-01    9.4788E-01    1.412500E+09  0.00756  1.151E-04    0   0.7417   V01.41m0.40           0.0000     8.4413E-01     3.0288   0.9253     98.333       1.4034      2.7525
 72      0.0000     0.0000E+00    0.0000E+00    1.995300E+09  0.00756  8.143E-05    0   0.7314   V01.99m0.40           0.0000     8.9057E-01     3.2117   0.7345     98.633       1.4034      0.0000
 73      0.0000     0.0000E+00    0.0000E+00    2.511900E+09  0.00756  6.786E-05    0   0.7249   V02.51m0.40           0.0000     9.3603E-01     3.3572   0.5927     98.934       1.4034      0.0000
 74      0.0000     0.0000E+00    0.0000E+00    3.548100E+09  0.00756  5.133E-05    0   0.7168   V03.54m0.40           0.0000     1.0117E+00     3.5558   0.5003     99.011       1.4034      0.0000
 75      0.0000     0.0000E+00    0.0000E+00    4.466800E+09  0.00756  4.325E-05    0   0.7113   V04.46m0.40           0.0000     1.0329E+00     3.6150   0.4436     99.053       1.4034      0.0000
 76      0.0000     0.0000E+00    0.0000E+00    6.309600E+09  0.00756  3.146E-05    0   0.7041   V06.30m0.40           0.0000     1.0994E+00     3.7692   0.3598     99.110       1.4034      0.0000
 77      0.0000     0.0000E+00    0.0000E+00    7.943300E+09  0.00756  2.570E-05    0   0.6997   V07.94m0.40           0.0000     1.1543E+00     3.8732   0.3182     99.187       1.4034      0.0000
 78      0.0000     0.0000E+00    0.0000E+00    1.000000E+10  0.00756  2.209E-05    0   0.6957   V10.00m0.40           0.0000     1.2188E+00     4.0052   0.2424     99.268       1.4034      0.0000
 79      0.0000     0.0000E+00    0.0000E+00    1.258930E+10  0.00756  1.899E-05    0   0.6894   V12.58m0.40           0.0000     1.2657E+00     4.0824   0.1876     99.308       1.4034      0.0000
 80      0.0000     0.0000E+00    0.0000E+00    1.412540E+10  0.00756  1.738E-05    0   0.6834   V14.12m0.40           0.0000     1.3120E+00     4.1615   0.1523     99.224       1.4034      0.0000
 81      0.0000     0.0000E+00    0.0000E+00    1.000000E+06  0.01900  3.749E-03    0   1.0000   ageGe_00_z020         0.0000     2.5459E+00     5.3871   3.8238    100.705       1.4034      0.0000
 82      0.0000     0.0000E+00    0.0000E+00    3.000000E+06  0.01900  7.908E-03    0   1.0000   ageGe_02_z020         0.0000     2.5074E+00     5.3423   3.7055    100.722       1.4034      0.0000
 83      0.0000     0.0000E+00    0.0000E+00    7.000000E+06  0.01900  5.682E-03    0   0.9659   ageGe_02_z020         0.0000     1.2032E+00     3.4273   1.4789     98.225       1.4034      0.0000
 84      4.5919     3.7781E-02    5.0125E-02    8.000000E+06  0.01900  4.627E-03    0   0.9591   ageGe_02_z020         0.0000     1.4388E+00     3.7472   1.6704     97.993       1.4034      4.6439
 85      0.0000     0.0000E+00    0.0000E+00    9.000000E+06  0.01900  2.795E-03    0   0.9532   ageGe_08_z020         0.0000     1.7054E+00     4.1751   2.7334     96.043       1.4034      0.0000
 86      0.0000     0.0000E+00    0.0000E+00    9.990000E+06  0.01900  2.343E-03    0   0.9532   ageGe_08_z020         0.0000     1.7283E+00     4.0989   2.6329     95.163       1.4034      0.0000
 87      0.0000     0.0000E+00    0.0000E+00    1.000000E+07  0.01900  3.090E-03    0   0.9224   age09_z019            0.0000     1.0498E+00     3.1996   2.0895     98.056       1.4034      0.0000
 88      0.0000     0.0000E+00    0.0000E+00    1.259000E+07  0.01900  2.685E-03    0   0.9143   age11_z019            0.0000     1.0490E+00     3.2002   2.4414     98.767       1.4034      0.0000
 89      0.0000     0.0000E+00    0.0000E+00    1.413000E+07  0.01900  2.250E-03    0   0.9102   age12_z019            0.0000     1.0847E+00     3.2550   2.5602     98.735       1.4034      0.0000
 90      0.0000     0.0000E+00    0.0000E+00    1.778000E+07  0.01900  1.740E-03    0   0.9022   age14_z019            0.0000     1.0382E+00     3.1799   2.3917     98.427       1.4034      0.0000
 91      0.5520     1.3664E-02    1.6977E-02    1.995000E+07  0.01900  1.538E-03    0   0.8982   age15_z019            0.0000     1.0316E+00     3.1651   2.4798     98.648       1.4034      0.5726
 92      0.0000     0.0000E+00    0.0000E+00    2.511900E+07  0.01900  1.351E-03    0   0.8903   age17_z019            0.0000     1.0135E+00     3.1333   2.4769     98.893       1.4034      0.0000
 93      0.0000     0.0000E+00    0.0000E+00    3.162000E+07  0.01900  1.102E-03    0   0.8824   age19_z019            0.0000     1.0506E+00     3.1902   2.5679     99.125       1.4034      0.0000
 94      6.9025     2.4808E-01    3.0018E-01    3.981100E+07  0.01900  1.059E-03    0   0.8747   age21_z019            0.0000     1.0642E+00     3.2271   2.5543     99.648       1.4034      7.0997
 95      0.0000     0.0000E+00    0.0000E+00    5.623000E+07  0.01900  9.330E-04    0   0.8631   age24_z019            0.0000     1.1400E+00     3.3572   2.5803     99.943       1.4034      0.0000
 96      0.0000     0.0000E+00    0.0000E+00    6.300000E+07  0.01900  8.607E-04    0   0.8593   age25_z019            0.0000     1.1221E+00     3.3304   2.5324     99.855       1.4034      0.0000
 97      0.0000     0.0000E+00    0.0000E+00    6.310000E+07  0.01900  8.275E-04    0   0.8615   V00.06p0.00           0.0000     1.1416E+00     3.3714   2.4663     98.728       1.4034      0.0000
 98      0.0000     0.0000E+00    0.0000E+00    7.080000E+07  0.01900  7.684E-04    0   0.8578   V00.07p0.00           0.0000     1.1242E+00     3.3530   2.4414     98.703       1.4034      0.0000
 99      0.0000     0.0000E+00    0.0000E+00    1.000000E+08  0.01900  6.189E-04    0   0.8469   V00.10p0.00           0.0000     1.1392E+00     3.3599   2.4319     98.628       1.4034      0.0000
100      0.0000     0.0000E+00    0.0000E+00    1.122000E+08  0.01900  5.779E-04    0   0.8434   V00.11p0.00           0.0000     1.1464E+00     3.3670   2.4177     98.616       1.4034      0.0000
101      0.0000     0.0000E+00    0.0000E+00    1.259000E+08  0.01900  5.381E-04    0   0.8400   V00.12p0.00           0.0000     1.1009E+00     3.2595   2.3621     98.020       1.4034      0.0000
102      0.0000     0.0000E+00    0.0000E+00    1.585000E+08  0.01900  4.599E-04    0   0.8326   V00.15p0.00           0.0000     1.1307E+00     3.3048   2.3947     98.287       1.4034      0.0000
103      0.0000     0.0000E+00    0.0000E+00    1.995000E+08  0.01900  3.961E-04    0   0.8254   V00.19p0.00           0.0000     1.1528E+00     3.3574   2.3965     98.503       1.4034      0.0000
104      0.0000     0.0000E+00    0.0000E+00    2.818000E+08  0.01900  3.125E-04    0   0.8156   V00.28p0.00           0.0000     1.1083E+00     3.3197   2.3154     98.592       1.4034      0.0000
105      6.1524     8.7184E-01    9.7543E-01    3.548000E+08  0.01900  2.687E-04    0   0.8088   V00.35p0.00           0.0000     1.0951E+00     3.3023   2.2174     98.561       1.4034      6.2916
106      0.0000     0.0000E+00    0.0000E+00    5.012000E+08  0.01900  2.116E-04    0   0.7994   V00.50p0.00           0.0000     1.0375E+00     3.2475   1.9671     98.695       1.4034      0.0000
107     13.4528     3.2018E+00    3.4976E+00    7.079000E+08  0.01900  1.600E-04    0   0.7897   V00.70p0.00           0.0000     9.8233E-01     3.2663   1.6331     98.903       1.4034     13.3929
108      0.0000     0.0000E+00    0.0000E+00    8.913000E+08  0.01900  1.330E-04    0   0.7828   V00.89p0.00           0.0000     9.7578E-01     3.3075   1.4007     98.822       1.4034      0.0000
109      0.0000     0.0000E+00    0.0000E+00    1.122000E+09  0.01900  1.111E-04    0   0.7759   V01.12p0.00           0.0000     9.8740E-01     3.3849   1.1909     98.930       1.4034      0.0000
110      0.0019     6.9397E-04    7.4149E-04    1.258900E+09  0.01900  1.066E-04    0   0.7724   V01.25p0.00           0.0000     9.9193E-01     3.4311   1.0181     99.102       1.4034      0.0019
111      0.0000     0.0000E+00    0.0000E+00    1.412500E+09  0.01900  1.035E-04    0   0.7689   V01.41p0.00           0.0000     1.0211E+00     3.5312   0.8343     99.134       1.4034      0.0000
112      0.0000     0.0000E+00    0.0000E+00    1.995300E+09  0.01900  6.511E-05    0   0.7550   V01.99p0.00           0.0000     1.0402E+00     3.5854   0.6816     99.033       1.4034      0.0000
113      0.0000     0.0000E+00    0.0000E+00    2.511900E+09  0.01900  5.301E-05    0   0.7487   V02.51p0.00           0.0000     1.1407E+00     3.8106   0.5461     99.011       1.4034      0.0000
114      0.0000     0.0000E+00    0.0000E+00    3.548100E+09  0.01900  3.908E-05    0   0.7401   V03.54p0.00           0.0000     1.2953E+00     4.1282   0.3533     99.010       1.4034      0.0000
115      0.0004     5.1186E-04    5.2001E-04    4.466800E+09  0.01900  3.292E-05    0   0.7344   V04.46p0.00           0.0000     1.3354E+00     4.1905   0.3210     99.072       1.4034      0.0004
116      0.0000     0.0000E+00    0.0000E+00    6.309600E+09  0.01900  2.382E-05    0   0.7274   V06.30p0.00           0.0000     1.4220E+00     4.3270   0.2455     99.119       1.4034      0.0000
117      0.0000     0.0000E+00    0.0000E+00    7.943300E+09  0.01900  1.993E-05    0   0.7233   V07.94p0.00           0.0000     1.5214E+00     4.4858   0.1850     99.302       1.4034      0.0000
118      0.0000     0.0000E+00    0.0000E+00    1.000000E+10  0.01900  1.685E-05    0   0.7195   V10.00p0.00           0.0000     1.6489E+00     4.6665   0.1025     99.467       1.4034      0.0000
119      0.0028     7.4490E-03    7.3727E-03    1.258930E+10  0.01900  1.422E-05    0   0.7155   V12.58p0.00           0.0000     1.8139E+00     4.8954   0.0000     99.509       1.4034      0.0027
120      0.0000     0.0000E+00    0.0000E+00    1.412540E+10  0.01900  1.314E-05    0   0.7136   V14.12p0.00           0.0000     1.9091E+00     5.1124   0.0000     99.556       1.4034      0.0000
121      0.0000     0.0000E+00    0.0000E+00    1.000000E+06  0.03153  4.415E-03    0   1.0000   ageGe_00_z040         0.0000     2.5619E+00     5.4087   3.8078    100.762       1.4034      0.0000
122      0.0000     0.0000E+00    0.0000E+00    3.000000E+06  0.03153  1.394E-02    0   1.0000   ageGe_02_z040         0.0000     2.2714E+00     5.0482   3.4720    100.909       1.4034      0.0000
123      0.0000     0.0000E+00    0.0000E+00    7.000000E+06  0.03153  4.039E-03    0   0.9659   ageGe_02_z040         0.0000     1.8036E+00     4.0744   1.8129     96.066       1.4034      0.0000
124      0.0000     0.0000E+00    0.0000E+00    8.000000E+06  0.03153  2.303E-03    0   0.9591   ageGe_02_z040         0.0000     2.3499E+00     4.9523   3.1781     95.201       1.4034      0.0000
125      0.0000     0.0000E+00    0.0000E+00    9.000000E+06  0.03153  2.069E-03    0   0.9532   ageGe_08_z040         0.0000     2.2361E+00     4.8509   3.1935     95.602       1.4034      0.0000
126      0.0000     0.0000E+00    0.0000E+00    9.990000E+06  0.03153  1.892E-03    0   0.9532   ageGe_08_z040         0.0000     2.1316E+00     4.7931   3.2520     96.276       1.4034      0.0000
127      0.0000     0.0000E+00    0.0000E+00    1.000000E+07  0.03153  1.938E-03    0   0.9224   age09_z040            0.0000     2.0334E+00     4.7133   3.3035     97.014       1.4034      0.0000
128      0.0000     0.0000E+00    0.0000E+00    1.259000E+07  0.03153  1.811E-03    0   0.9143   age11_z040            0.0000     1.4109E+00     3.7468   2.8672     97.298       1.4034      0.0000
129      0.0000     0.0000E+00    0.0000E+00    1.413000E+07  0.03153  1.704E-03    0   0.9102   age12_z040            0.0000     1.2986E+00     3.5837   2.7258     97.335       1.4034      0.0000
130      2.7351     7.1818E-02    8.9631E-02    1.778000E+07  0.03153  1.450E-03    0   0.9022   age14_z040            0.0000     1.2469E+00     3.5136   2.7246     97.611       1.4034      2.9014
131      0.0000     0.0000E+00    0.0000E+00    1.995000E+07  0.03153  1.467E-03    0   0.8982   age15_z040            0.0000     1.1839E+00     3.3804   2.3870     97.772       1.4034      0.0000
132      7.3937     2.2813E-01    2.8096E-01    2.511900E+07  0.03153  1.234E-03    0   0.8903   age17_z040            0.0000     1.1356E+00     3.3228   2.4656     97.980       1.4034      7.7176
133      0.0000     0.0000E+00    0.0000E+00    3.162000E+07  0.03153  1.063E-03    0   0.8824   age19_z040            0.0000     1.0565E+00     3.2092   2.5354     98.755       1.4034      0.0000
134      0.0000     0.0000E+00    0.0000E+00    3.981100E+07  0.03153  9.066E-04    0   0.8747   age21_z040            0.0000     1.0498E+00     3.2014   2.6033     99.161       1.4034      0.0000
135      0.0000     0.0000E+00    0.0000E+00    5.623000E+07  0.03153  7.721E-04    0   0.8631   age24_z040            0.0000     1.0051E+00     3.1336   2.5182     99.478       1.4034      0.0000
136      4.6395     2.4345E-01    2.8939E-01    6.300000E+07  0.03153  7.256E-04    0   0.8593   age25_z040            0.0000     9.9749E-01     3.1251   2.4940     99.613       1.4034      4.7622
137      0.0000     0.0000E+00    0.0000E+00    6.310000E+07  0.03153  7.055E-04    0   0.8591   V00.06p0.22           0.0000     1.1091E+00     3.3297   2.4396     97.437       1.4034      0.0000
138      0.0000     0.0000E+00    0.0000E+00    7.080000E+07  0.03153  6.643E-04    0   0.8554   V00.07p0.22           0.0000     1.0925E+00     3.2826   2.4769     98.043       1.4034      0.0000
139      0.0000     0.0000E+00    0.0000E+00    1.000000E+08  0.03153  5.599E-04    0   0.8453   V00.10p0.22           0.0000     1.1402E+00     3.3463   2.4816     98.336       1.4034      0.0000
140      0.0000     0.0000E+00    0.0000E+00    1.122000E+08  0.03153  5.239E-04    0   0.8421   V00.11p0.22           0.0000     1.1643E+00     3.3811   2.4911     98.595       1.4034      0.0000
141      0.0000     0.0000E+00    0.0000E+00    1.259000E+08  0.03153  4.911E-04    0   0.8387   V00.12p0.22           0.0000     1.1344E+00     3.3368   2.4721     98.572       1.4034      0.0000
142      0.0000     0.0000E+00    0.0000E+00    1.585000E+08  0.03153  4.262E-04    0   0.8315   V00.15p0.22           0.0000     1.1620E+00     3.3870   2.4787     98.608       1.4034      0.0000
143      0.0000     0.0000E+00    0.0000E+00    1.995000E+08  0.03153  3.683E-04    0   0.8247   V00.19p0.22           0.0000     1.1348E+00     3.3744   2.4166     98.807       1.4034      0.0000
144      0.0000     0.0000E+00    0.0000E+00    2.818000E+08  0.03153  2.946E-04    0   0.8148   V00.28p0.22           0.0000     1.0859E+00     3.3284   2.2883     98.831       1.4034      0.0000
145      0.0000     0.0000E+00    0.0000E+00    3.548000E+08  0.03153  2.526E-04    0   0.8085   V00.35p0.22           0.0000     1.1028E+00     3.3998   2.1724     99.148       1.4034      0.0000
146      0.0045     8.8279E-04    9.7609E-04    5.012000E+08  0.03153  1.945E-04    0   0.7993   V00.50p0.22           0.0000     1.0432E+00     3.3704   1.9163     99.220       1.4034      0.0045
147      0.0000     0.0000E+00    0.0000E+00    7.079000E+08  0.03153  1.454E-04    0   0.7897   V00.70p0.22           0.0000     1.0714E+00     3.5075   1.6218     99.282       1.4034      0.0000
148      0.0000     0.0000E+00    0.0000E+00    8.913000E+08  0.03153  1.199E-04    0   0.7832   V00.89p0.22           0.0000     1.0310E+00     3.4482   1.2867     99.263       1.4034      0.0000
149      0.0000     0.0000E+00    0.0000E+00    1.122000E+09  0.03153  9.943E-05    0   0.7766   V01.12p0.22           0.0000     1.1165E+00     3.6689   1.1234     99.375       1.4034      0.0000
150      0.0000     0.0000E+00    0.0000E+00    1.258900E+09  0.03153  9.226E-05    0   0.7733   V01.25p0.22           0.0000     1.1558E+00     3.7692   0.9980     99.426       1.4034      0.0000
151      0.0000     0.0000E+00    0.0000E+00    1.412500E+09  0.03153  9.016E-05    0   0.7698   V01.41p0.22           0.0000     1.1918E+00     3.8646   0.7810     99.371       1.4034      0.0000
152      0.0000     0.0000E+00    0.0000E+00    1.995300E+09  0.03153  5.748E-05    0   0.7561   V01.99p0.22           0.0000     1.2223E+00     3.9381   0.5669     98.938       1.4034      0.0000
153      0.0000     0.0000E+00    0.0000E+00    2.511900E+09  0.03153  4.594E-05    0   0.7497   V02.51p0.22           0.0000     1.3161E+00     4.1157   0.4684     99.112       1.4034      0.0000
154      0.0000     0.0000E+00    0.0000E+00    3.548100E+09  0.03153  3.469E-05    0   0.7409   V03.54p0.22           0.0000     1.5815E+00     4.5355   0.2480     99.187       1.4034      0.0000
155      0.0000     0.0000E+00    0.0000E+00    4.466800E+09  0.03153  2.866E-05    0   0.7357   V04.46p0.22           0.0000     1.7202E+00     4.7366   0.1706     99.250       1.4034      0.0000
156      0.0726     1.3015E-01    1.3106E-01    6.309600E+09  0.03153  2.123E-05    0   0.7280   V06.30p0.22           0.0000     1.8706E+00     4.9233   0.1151     99.390       1.4034      0.0699
157      0.0000     0.0000E+00    0.0000E+00    7.943300E+09  0.03153  1.760E-05    0   0.7239   V07.94p0.22           0.0000     2.0064E+00     5.1007   0.0489     99.468       1.4034      0.0000
158     11.0608     2.8441E+01    2.8315E+01    1.000000E+10  0.03153  1.481E-05    0   0.7197   V10.00p0.22           0.0000     2.2396E+00     5.4587   0.0000     99.618       1.4034     10.6258
159      9.2087     2.8068E+01    2.7796E+01    1.258930E+10  0.03153  1.249E-05    0   0.7159   V12.58p0.22           0.0000     2.6627E+00     6.1208   0.0000     99.716       1.4034      8.8253
160     10.4396     3.4671E+01    3.4244E+01    1.412540E+10  0.03153  1.146E-05    0   0.7140   V14.12p0.22           0.0000     2.9167E+00     6.4502   0.0000     99.892       1.4034      9.9810


## Synthesis Results - Average & Chains ##

# j    par_j: min, <> & last-chain-values for 1 ...  7 chains. x: 1 -> 160 ; AV: 161 ; exAV (if any):   0 ->   0 ; fn:162
  1      0.0000      0.0423      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  2      0.0000      0.0379      0.0000      0.0000      0.0000      0.0039      1.1211      0.0000      0.0000
  3      0.0000      0.0573      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  4      0.0000      0.1018      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  5      0.0000      0.1908      1.9669      0.0000      0.0000      0.0000      0.0000      0.3118      0.0000
  6      0.0000      0.0476      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  7      0.0000      0.0739      0.0000      0.0000      0.0000      0.0000      0.4418      0.0000      0.0000
  8      0.0000      0.0754      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  9      0.0000      0.2261      0.0000      1.5859      0.0000      2.1086      0.0000      0.0000      0.0000
 10      0.0000      0.0754      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 11      0.0000      0.0954      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 12      0.0000      0.2578      0.0000      0.0000      0.0000      0.0000      0.0000      1.2934      0.0000
 13      0.0000      0.6843      0.3688      1.4968      0.0000      0.0000      0.0000      0.0000      0.0000
 14      0.0000      0.1838      0.0000      0.0000      0.0000      0.0000      0.0000      1.8328      0.0000
 15      0.0000      0.1865      0.0000      1.0048      0.0000      0.0000      0.0000      0.0000      0.0000
 16      0.0000      0.1232      0.0000      0.0000      0.0000      0.0422      1.3716      0.0000      0.0000
 17      0.0000      0.1450      0.0000      0.0000      0.0000      0.5699      0.0000      0.0000      0.0000
 18      0.0000      0.1398      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 19      0.0000      0.4101      0.0000      0.7007      0.0000      0.0000      0.0000      0.0000      0.0000
 20      0.0000      0.1501      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 21      0.0000      0.4227      0.0000      0.0000      0.0000      2.8383      0.0000      0.0000      0.0000
 22      0.0000      0.4867      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 23      0.0000      0.3457      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 24      0.0000      0.4821      0.0000      0.4274      0.0000      0.0000      0.0000      0.0000      1.6165
 25      0.0000      0.4832      0.0000      0.0000      0.0000      1.4598      1.2148      0.0000      0.4806
 26      0.0000      0.4979      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 27      0.0000      1.1103      0.0000      0.5880      0.0000      0.0000      0.0000      2.1804      5.2925
 28      0.0000      1.1355      1.3493      0.0000      0.0000      0.0000      1.9353      4.3299      2.5435
 29      0.0000      0.9779      0.0000      0.0000      0.0000      0.0000      0.7947      0.0000      1.7778
 30      0.0000      0.8678      1.4856      0.0000      1.9480      0.0000      0.1834      0.0000      0.0000
 31      0.0000      0.7073      0.3267      0.0000      0.0000      0.0000      0.0000      1.1488      0.0000
 32      0.0001      1.4581      0.0000      4.7884      0.4412      0.0000      0.0000      4.0716      0.1619
 33      0.0000      0.8599      2.4415      0.0000      0.0000      0.0000      0.0000      0.0000      3.0440
 34      0.0000      1.0032      0.0000      0.0000      0.0000      1.8361      0.0000      3.9068      0.0000
 35      0.0020      0.3891      0.0000      2.0773      0.0000      0.0000      0.0380      0.0000      0.0000
 36      0.0000      0.7738      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 37      0.0000      0.5897      0.0000      0.3888      0.0000      0.0000      0.0000      0.0000      0.0000
 38      0.0000      0.6285      2.6474      0.0000      4.4366      0.0000      0.0000      0.4955      0.0000
 39      0.0000      0.9349      3.2636      1.3814      0.0000      0.0000      2.8133      0.0000      0.0000
 40      0.0000      0.6579      0.0000      3.0011      0.0000      4.4740      0.0000      0.0000      0.0000
 41      0.0000      0.0702      0.0000      0.0000      0.0000      0.0000      1.1502      0.0000      0.0000
 42      0.0000      0.0428      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 43      0.0000      0.0868      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 44      0.0000      0.1280      0.0000      0.9547      0.0000      1.1787      0.0000      0.0000      1.7846
 45      0.0000      0.1466      1.7849      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 46      0.0000      0.1628      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.9652
 47      0.0000      0.1021      0.0000      0.0000      0.0000      0.0000      0.6684      0.6162      0.0000
 48      0.0000      0.0657      0.5750      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 49      0.0000      0.1414      0.0264      1.6128      0.0000      0.0000      0.0000      0.0000      2.4321
 50      0.0000      0.0858      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      1.2631
 51      0.0000      0.1843      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.4249
 52      0.0000      0.1943      0.0000      0.0000      0.0874      0.0000      3.0853      0.0000      0.0000
 53      0.0000      0.1274      1.3939      0.0000      0.0000      0.0000      0.0000      1.1705      0.0000
 54      0.0000      0.2511      0.0000      0.0000      0.0000      2.2079      0.7083      0.2405      2.8656
 55      0.0000      0.0925      0.8713      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 56      0.0000      0.2519      0.0000      0.0000      2.2522      0.0000      0.0000      0.0000      0.0000
 57      0.0000      0.1571      0.4427      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 58      0.0000      0.1428      0.0000      0.0000      0.0000      0.0810      0.0000      0.0000      0.0000
 59      0.0000      0.1220      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 60      0.0000      0.1197      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 61      0.0000      0.4953      0.0000      0.0000      0.0000      0.0000      0.0000      1.8736      0.0000
 62      0.0000      0.2778      0.0000      0.0000      0.0000      0.6491      0.0000      0.0000      0.0000
 63      0.0000      0.2963      0.0000      0.0000      1.9729      0.0245      0.0000      0.0000      0.0000
 64      0.0000      0.3187      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 65      0.0000      0.7293      0.6959      0.0000      3.9752      0.0000      4.5854      0.0000      0.6563
 66     18.0812      0.6244      0.7189      3.6127      5.8211      3.1297      0.8127      2.3971      1.4895
 67      0.0000      1.5824      3.8507      0.0000      0.0000      0.0000      0.0000      2.6105      0.0000
 68      0.0000      1.8027      2.6100      0.0000      0.0000     12.1685      0.0000      0.0000      0.5213
 69      0.0000      1.3429      0.0000      0.0948      1.7162      0.0000      0.0000      0.0000      0.0000
 70      0.0000      1.5621      0.0000      0.0000      0.0000      0.2282      0.0000      0.2047      0.0000
 71      2.7920      2.2877      0.6418      7.5335     12.4890      0.0000      7.1233      2.4688      6.4829
 72      0.0000      1.1180      0.0000      0.0000      0.1962      0.0000      1.5803      0.0000      0.0000
 73      0.0000      1.0204      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.9978
 74      0.0000      0.3985      2.6403      0.0000      2.5712      0.0000      0.0000      0.0000      0.3448
 75      0.0000      0.3872      0.0000      0.0000      0.0000      0.0000      0.0086      0.0000      0.0000
 76      0.0000      0.3892      0.0000      0.0000      0.0000      0.0000      0.8119      0.1168      0.0000
 77      0.0000      0.3726      0.0000      0.0000      0.0000      0.0000      0.6597      0.0000      1.4791
 78      0.0000      0.5406      0.0000      1.3065      0.0982      0.0000      2.4574      0.0000      1.1421
 79      0.0000      0.6043      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 80      0.0000      0.5246      0.7558      0.0000      0.0000      1.6112      0.0000      1.4309      0.0000
 81      0.0000      0.0247      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 82      0.0000      0.0346      0.0000      0.0000      0.0000      0.3154      0.3561      0.0000      0.0000
 83      0.0000      2.9594      0.0000      2.6078      0.0000      0.0000      0.2923      3.5388      0.0000
 84      4.5919      7.1287      8.8035      8.5481      9.8237      5.2009      7.3981      2.5465      5.6363
 85      0.0000      0.2339      0.0000      0.0000      1.1383      0.0000      1.5139      0.8201      0.8246
 86      0.0000      0.3767      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 87      0.0000      0.8588      1.7046      0.0000      2.7806      0.0465      0.0000      2.0954      1.6630
 88      0.0000      0.2868      0.4884      0.0000      0.0000      0.0000      0.0000      0.0386      0.7333
 89      0.0000      0.1929      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 90      0.0000      0.2078      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      1.3628
 91      0.5520      0.7086      0.0000      5.3185      0.0000      0.0000      0.0000      0.2063      2.3366
 92      0.0000      0.4195      4.3124      0.0000      0.0000      0.2417      0.0000      0.0000      0.0000
 93      0.0000      0.1127      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 94      6.9025      0.3025      0.0000      1.7883      0.0000      0.0000      0.0000      0.9896      0.0000
 95      0.0000      0.2857      0.0000      0.0000      0.2055      0.0000      0.0000      0.0000      0.0000
 96      0.0000      0.3047      0.0000      0.0000      0.4101      0.0000      0.0000      0.8005      2.9874
 97      0.0000      0.1763      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 98      0.0000      0.1301      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 99      0.0000      0.1711      1.4456      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
100      0.0000      0.2014      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
101      0.0000      0.2340      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
102      0.0000      0.2656      0.9611      0.0000      0.0000      0.0000      0.0000      1.1513      0.0000
103      0.0000      0.2697      0.0000      0.0000      0.0000      0.0000      0.0000      0.0958      0.0000
104      0.0000      0.2853      0.0000      0.0000      0.0000      0.0000      0.9857      0.2409      0.0000
105      6.1524      0.8414      3.0642      3.6799      4.4209      0.0894      0.0000      0.0000      0.0000
106      0.0000      0.6628      0.0000      0.0723      0.0000      3.0829      0.6082      3.0511      0.8817
107     13.4528      1.6549      0.0000      5.0130      0.0000      0.0000      3.7741      4.4274      0.0000
108      0.0000      1.7393      0.0000      0.0000      0.6649      0.5986      2.6590      3.5912      0.0000
109      0.0000      1.1112      0.0000      1.1938      0.0000      0.0000      0.9284      0.0000      0.0000
110      0.0019      1.2643      2.2763      1.0726      2.2167      0.0000      0.0000      0.0000      2.9814
111      0.0000      1.0937      4.6006      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
112      0.0000      1.8382      0.0000      3.3795      0.0000      0.3045      6.6734      0.0000      4.7365
113      0.0000      0.5362      0.0000      0.0000      0.0000      3.5736      0.6187      2.6749      0.0000
114      0.0000      0.4993      0.0000      0.0000      0.0000      1.9599      0.0000      0.4453      0.0000
115      0.0004      0.9424      0.7252      3.5463      0.0000      0.4681      0.0000      0.8625      0.8286
116      0.0000      1.1513      0.0000      0.0000      0.0000      0.0000      6.0397      0.3742      0.0000
117      0.0000      0.4607      0.0000      0.0000      3.5126      0.9032      0.0000      0.0000      0.0000
118      0.0000      1.2672      0.0000      0.0000      0.0000      0.0000      4.0202      0.0000      0.0000
119      0.0028      1.5518      2.2052      5.9540      3.5358      0.3212      0.0000      2.9943      1.2535
120      0.0000      0.5014      0.0000      0.0000      1.8667      3.2474      0.0000      0.1430      3.2665
121      0.0000      0.0200      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
122      0.0000      0.0666      0.0000      0.0000      0.0000      0.0000      1.1050      0.0000      0.0000
123      0.0000      1.6181      1.9699      0.0000      2.7052      3.9359      2.3446      0.0000      0.0000
124      0.0000      0.0818      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
125      0.0000      0.1508      0.0000      0.0000      0.0000      0.8944      0.0000      0.8215      0.0000
126      0.0000      0.0945      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
127      0.0000      0.0817      0.0000      0.0000      0.0000      0.1238      0.0000      0.0000      0.0000
128      0.0000      0.0980      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
129      0.0000      0.2021      0.0000      0.0000      0.4693      0.0000      0.0000      0.0000      0.0000
130      2.7351      0.1411      0.0000      0.9526      0.0000      0.0000      0.0000      0.0000      0.5426
131      0.0000      0.3820      0.0000      0.0000      0.0000      2.2208      0.6103      1.9924      0.0000
132      7.3937      0.3800      0.0000      1.6643      0.0000      0.0000      0.0000      0.0000      0.5325
133      0.0000      0.5569      0.9024      0.0000      2.7366      0.2110      4.2413      0.7454      0.8195
134      0.0000      0.3288      0.0000      0.0000      0.0000      1.9277      0.0000      1.7797      0.0000
135      0.0000      0.4254      1.8848      0.0000      0.0000      0.0000      0.0000      2.4847      3.4046
136      4.6395      0.2381      0.0000      1.8985      0.0000      0.0000      0.0000      0.0000      0.0000
137      0.0000      0.1831      0.0000      0.7073      0.0000      0.0000      0.0000      0.0000      0.0000
138      0.0000      0.2979      0.0000      0.0000      1.8235      3.2244      0.0000      0.7826      0.0000
139      0.0000      0.1498      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.5530
140      0.0000      0.1093      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
141      0.0000      0.1817      1.9031      0.0000      0.0000      2.7992      0.0000      0.0000      0.5313
142      0.0000      0.1785      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
143      0.0000      0.2874      1.0666      0.0000      0.0000      0.0000      0.0276      0.0000      0.0000
144      0.0000      0.2760      0.0000      0.0000      0.0000      0.0000      1.8498      0.0000      0.0000
145      0.0000      0.3828      0.0000      0.0000      0.0000      0.0000      0.0000      0.4329      0.0000
146      0.0045      0.7865      0.0000      3.2812      1.8402      0.0000      0.0000      0.0000      0.0000
147      0.0000      0.6485      4.8799      0.0000      0.0000      0.0000      0.0000      0.0472      0.6468
148      0.0000      2.5013      0.0000      0.0000      7.9876      7.3746      0.0000      0.0000      0.0000
149      0.0000      0.9304      2.0813      0.6642      0.0000      0.0000      0.0000      0.0000      0.0000
150      0.0000      0.9544      0.0000      0.0000      0.0000      0.0000      0.0000      1.5353      0.0000
151      0.0000      1.0830      0.0000      0.0000      0.0000      0.0000      0.0000      2.9670      0.0000
152      0.0000      0.9382      1.9083      0.0000      1.9042      0.0748      3.2039      0.0000      4.5103
153      0.0000      1.4090      0.0000      0.4052      1.4731      2.4898      4.3107      2.1133      0.0000
154      0.0000      0.6473      0.0000      0.0000      0.0335      0.0000      0.0000      1.7789      0.0000
155      0.0000      1.7862      6.4366      1.8866      0.0000      0.0000      0.0000      5.3862      5.0289
156      0.0726      1.5658      2.5802      2.8881      0.0000      2.4011      0.0000      2.5566      0.2533
157      0.0000      0.4988      2.6284      0.0000      0.0000      2.7058      0.9064      1.9200      0.0000
158     11.0608      2.1978      3.4835      2.8414      2.9877      1.5090      5.1244      2.7393      2.9491
159      9.2087      3.5341      5.0379      3.0868      3.9353      6.0942      4.0503      4.2144     10.0844
160     10.4396      0.9643      0.0000      3.2071      1.6071      5.0325      0.8514      0.0000      0.9806
161      1.4034      1.2826      1.2844      1.2776      1.2788      1.2667      1.2640      1.2766      1.2879
162     98.0867     98.1133     98.2074     98.2130     98.0845     97.9837     98.0590     98.0856     98.0952

# j Lambda-Averaged pop-vectors <LAx_*>_j: min, <> & last-chain-values for 1 ...  7 chains
  1      0.0000      0.0469      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  2      0.0000      0.0409      0.0000      0.0000      0.0000      0.0042      1.2131      0.0000      0.0000
  3      0.0000      0.0608      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  4      0.0000      0.1079      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  5      0.0000      0.2013      2.0765      0.0000      0.0000      0.0000      0.0000      0.3290      0.0000
  6      0.0000      0.0506      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  7      0.0000      0.0773      0.0000      0.0000      0.0000      0.0000      0.4622      0.0000      0.0000
  8      0.0000      0.0799      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
  9      0.0000      0.2406      0.0000      1.6897      0.0000      2.2431      0.0000      0.0000      0.0000
 10      0.0000      0.0800      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 11      0.0000      0.1006      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 12      0.0000      0.2692      0.0000      0.0000      0.0000      0.0000      0.0000      1.3512      0.0000
 13      0.0000      0.7051      0.3804      1.5439      0.0000      0.0000      0.0000      0.0000      0.0000
 14      0.0000      0.1894      0.0000      0.0000      0.0000      0.0000      0.0000      1.8897      0.0000
 15      0.0000      0.1938      0.0000      1.0452      0.0000      0.0000      0.0000      0.0000      0.0000
 16      0.0000      0.1279      0.0000      0.0000      0.0000      0.0437      1.4246      0.0000      0.0000
 17      0.0000      0.1511      0.0000      0.0000      0.0000      0.5935      0.0000      0.0000      0.0000
 18      0.0000      0.1455      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 19      0.0000      0.4265      0.0000      0.7295      0.0000      0.0000      0.0000      0.0000      0.0000
 20      0.0000      0.1560      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 21      0.0000      0.4385      0.0000      0.0000      0.0000      2.9418      0.0000      0.0000      0.0000
 22      0.0000      0.5053      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 23      0.0000      0.3584      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 24      0.0000      0.4976      0.0000      0.4416      0.0000      0.0000      0.0000      0.0000      1.6672
 25      0.0000      0.4972      0.0000      0.0000      0.0000      1.5010      1.2503      0.0000      0.4941
 26      0.0000      0.5099      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 27      0.0000      1.1325      0.0000      0.6003      0.0000      0.0000      0.0000      2.2240      5.3938
 28      0.0000      1.1539      1.3724      0.0000      0.0000      0.0000      1.9668      4.4004      2.5828
 29      0.0000      0.9882      0.0000      0.0000      0.0000      0.0000      0.8031      0.0000      1.7953
 30      0.0000      0.8716      1.4936      0.0000      1.9561      0.0000      0.1842      0.0000      0.0000
 31      0.0000      0.7041      0.3256      0.0000      0.0000      0.0000      0.0000      1.1435      0.0000
 32      0.0001      1.4405      0.0000      4.7353      0.4357      0.0000      0.0000      4.0222      0.1599
 33      0.0000      0.8443      2.3994      0.0000      0.0000      0.0000      0.0000      0.0000      2.9871
 34      0.0000      0.9809      0.0000      0.0000      0.0000      1.7932      0.0000      3.8194      0.0000
 35      0.0020      0.3799      0.0000      2.0299      0.0000      0.0000      0.0371      0.0000      0.0000
 36      0.0000      0.7537      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 37      0.0000      0.5732      0.0000      0.3783      0.0000      0.0000      0.0000      0.0000      0.0000
 38      0.0000      0.6097      2.5710      0.0000      4.3031      0.0000      0.0000      0.4807      0.0000
 39      0.0000      0.9041      3.1591      1.3371      0.0000      0.0000      2.7195      0.0000      0.0000
 40      0.0000      0.6361      0.0000      2.9042      0.0000      4.3200      0.0000      0.0000      0.0000
 41      0.0000      0.0777      0.0000      0.0000      0.0000      0.0000      1.2745      0.0000      0.0000
 42      0.0000      0.0468      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 43      0.0000      0.0908      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 44      0.0000      0.1336      0.0000      0.9969      0.0000      1.2289      0.0000      0.0000      1.8596
 45      0.0000      0.1522      1.8550      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 46      0.0000      0.1689      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      1.0004
 47      0.0000      0.1083      0.0000      0.0000      0.0000      0.0000      0.7097      0.6541      0.0000
 48      0.0000      0.0699      0.6122      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 49      0.0000      0.1504      0.0281      1.7175      0.0000      0.0000      0.0000      0.0000      2.5843
 50      0.0000      0.0907      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      1.3334
 51      0.0000      0.1937      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.4462
 52      0.0000      0.2035      0.0000      0.0000      0.0915      0.0000      3.2330      0.0000      0.0000
 53      0.0000      0.1327      1.4525      0.0000      0.0000      0.0000      0.0000      1.2190      0.0000
 54      0.0000      0.2620      0.0000      0.0000      0.0000      2.3022      0.7393      0.2510      2.9864
 55      0.0000      0.0964      0.9094      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 56      0.0000      0.2623      0.0000      0.0000      2.3446      0.0000      0.0000      0.0000      0.0000
 57      0.0000      0.1638      0.4623      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 58      0.0000      0.1489      0.0000      0.0000      0.0000      0.0844      0.0000      0.0000      0.0000
 59      0.0000      0.1269      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 60      0.0000      0.1245      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 61      0.0000      0.5205      0.0000      0.0000      0.0000      0.0000      0.0000      1.9692      0.0000
 62      0.0000      0.2902      0.0000      0.0000      0.0000      0.6776      0.0000      0.0000      0.0000
 63      0.0000      0.3071      0.0000      0.0000      2.0441      0.0254      0.0000      0.0000      0.0000
 64      0.0000      0.3294      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 65      0.0000      0.7518      0.7181      0.0000      4.0971      0.0000      4.7282      0.0000      0.6760
 66     18.4387      0.6401      0.7377      3.7077      5.9667      3.2063      0.8334      2.4579      1.5258
 67      0.0000      1.6050      3.9091      0.0000      0.0000      0.0000      0.0000      2.6479      0.0000
 68      0.0000      1.8136      2.6283      0.0000      0.0000     12.2314      0.0000      0.0000      0.5241
 69      0.0000      1.3408      0.0000      0.0947      1.7132      0.0000      0.0000      0.0000      0.0000
 70      0.0000      1.5469      0.0000      0.0000      0.0000      0.2257      0.0000      0.2027      0.0000
 71      2.7525      2.2611      0.6349      7.4533     12.3406      0.0000      7.0393      2.4400      6.4037
 72      0.0000      1.0971      0.0000      0.0000      0.1925      0.0000      1.5505      0.0000      0.0000
 73      0.0000      0.9959      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.9734
 74      0.0000      0.3880      2.5734      0.0000      2.5030      0.0000      0.0000      0.0000      0.3356
 75      0.0000      0.3766      0.0000      0.0000      0.0000      0.0000      0.0083      0.0000      0.0000
 76      0.0000      0.3779      0.0000      0.0000      0.0000      0.0000      0.7880      0.1134      0.0000
 77      0.0000      0.3613      0.0000      0.0000      0.0000      0.0000      0.6395      0.0000      1.4336
 78      0.0000      0.5234      0.0000      1.2662      0.0951      0.0000      2.3783      0.0000      1.1053
 79      0.0000      0.5846      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 80      0.0000      0.5078      0.7324      0.0000      0.0000      1.5578      0.0000      1.3850      0.0000
 81      0.0000      0.0273      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 82      0.0000      0.0379      0.0000      0.0000      0.0000      0.3454      0.3904      0.0000      0.0000
 83      0.0000      2.9779      0.0000      2.6267      0.0000      0.0000      0.2942      3.5613      0.0000
 84      4.6439      7.2453      8.9552      8.6963      9.9820      5.2814      7.5200      2.5885      5.7236
 85      0.0000      0.2536      0.0000      0.0000      1.2339      0.0000      1.6422      0.8894      0.8931
 86      0.0000      0.4105      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 87      0.0000      0.8864      1.7609      0.0000      2.8695      0.0480      0.0000      2.1633      1.7149
 88      0.0000      0.2984      0.5086      0.0000      0.0000      0.0000      0.0000      0.0402      0.7623
 89      0.0000      0.2020      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 90      0.0000      0.2166      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      1.4195
 91      0.5726      0.7403      0.0000      5.5621      0.0000      0.0000      0.0000      0.2156      2.4386
 92      0.0000      0.4370      4.4955      0.0000      0.0000      0.2516      0.0000      0.0000      0.0000
 93      0.0000      0.1176      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 94      7.0997      0.3134      0.0000      1.8548      0.0000      0.0000      0.0000      1.0256      0.0000
 95      0.0000      0.2952      0.0000      0.0000      0.2124      0.0000      0.0000      0.0000      0.0000
 96      0.0000      0.3144      0.0000      0.0000      0.4230      0.0000      0.0000      0.8261      3.0789
 97      0.0000      0.1834      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 98      0.0000      0.1352      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
 99      0.0000      0.1779      1.5038      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
100      0.0000      0.2092      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
101      0.0000      0.2441      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
102      0.0000      0.2767      1.0021      0.0000      0.0000      0.0000      0.0000      1.1997      0.0000
103      0.0000      0.2802      0.0000      0.0000      0.0000      0.0000      0.0000      0.0996      0.0000
104      0.0000      0.2949      0.0000      0.0000      0.0000      0.0000      1.0193      0.2491      0.0000
105      6.2916      0.8659      3.1559      3.7907      4.5484      0.0919      0.0000      0.0000      0.0000
106      0.0000      0.6733      0.0000      0.0735      0.0000      3.1289      0.6179      3.0994      0.8948
107     13.3929      1.6549      0.0000      5.0182      0.0000      0.0000      3.7745      4.4278      0.0000
108      0.0000      1.7274      0.0000      0.0000      0.6602      0.5940      2.6408      3.5668      0.0000
109      0.0000      1.0959      0.0000      1.1785      0.0000      0.0000      0.9155      0.0000      0.0000
110      0.0019      1.2396      2.2338      1.0527      2.1728      0.0000      0.0000      0.0000      2.9213
111      0.0000      1.0679      4.4963      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
112      0.0000      1.7924      0.0000      3.2984      0.0000      0.2966      6.5051      0.0000      4.6159
113      0.0000      0.5218      0.0000      0.0000      0.0000      3.4733      0.6019      2.6027      0.0000
114      0.0000      0.4847      0.0000      0.0000      0.0000      1.9002      0.0000      0.4322      0.0000
115      0.0004      0.9140      0.7040      3.4425      0.0000      0.4534      0.0000      0.8363      0.8032
116      0.0000      1.1153      0.0000      0.0000      0.0000      0.0000      5.8479      0.3625      0.0000
117      0.0000      0.4452      0.0000      0.0000      3.3932      0.8716      0.0000      0.0000      0.0000
118      0.0000      1.2217      0.0000      0.0000      0.0000      0.0000      3.8740      0.0000      0.0000
119      0.0027      1.4948      2.1262      5.7404      3.4048      0.3090      0.0000      2.8837      1.2069
120      0.0000      0.4825      0.0000      0.0000      1.7956      3.1204      0.0000      0.1375      3.1416
121      0.0000      0.0221      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
122      0.0000      0.0716      0.0000      0.0000      0.0000      0.0000      1.1898      0.0000      0.0000
123      0.0000      1.6860      2.0544      0.0000      2.8182      4.0978      2.4435      0.0000      0.0000
124      0.0000      0.0918      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
125      0.0000      0.1687      0.0000      0.0000      0.0000      1.0001      0.0000      0.9194      0.0000
126      0.0000      0.1053      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
127      0.0000      0.0907      0.0000      0.0000      0.0000      0.1373      0.0000      0.0000      0.0000
128      0.0000      0.1059      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
129      0.0000      0.2167      0.0000      0.0000      0.5032      0.0000      0.0000      0.0000      0.0000
130      2.9014      0.1509      0.0000      1.0196      0.0000      0.0000      0.0000      0.0000      0.5795
131      0.0000      0.4011      0.0000      0.0000      0.0000      2.3301      0.6410      2.0924      0.0000
132      7.7176      0.3995      0.0000      1.7515      0.0000      0.0000      0.0000      0.0000      0.5593
133      0.0000      0.5828      0.9451      0.0000      2.8632      0.2207      4.4403      0.7802      0.8567
134      0.0000      0.3437      0.0000      0.0000      0.0000      2.0138      0.0000      1.8608      0.0000
135      0.0000      0.4411      1.9557      0.0000      0.0000      0.0000      0.0000      2.5768      3.5262
136      4.7622      0.2462      0.0000      1.9646      0.0000      0.0000      0.0000      0.0000      0.0000
137      0.0000      0.1933      0.0000      0.7473      0.0000      0.0000      0.0000      0.0000      0.0000
138      0.0000      0.3128      0.0000      0.0000      1.9142      3.3833      0.0000      0.8219      0.0000
139      0.0000      0.1567      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.5778
140      0.0000      0.1140      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
141      0.0000      0.1894      1.9857      0.0000      0.0000      2.9164      0.0000      0.0000      0.5534
142      0.0000      0.1860      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000      0.0000
143      0.0000      0.2978      1.1062      0.0000      0.0000      0.0000      0.0286      0.0000      0.0000
144      0.0000      0.2841      0.0000      0.0000      0.0000      0.0000      1.9043      0.0000      0.0000
145      0.0000      0.3902      0.0000      0.0000      0.0000      0.0000      0.0000      0.4413      0.0000
146      0.0045      0.7918      0.0000      3.3068      1.8522      0.0000      0.0000      0.0000      0.0000
147      0.0000      0.6449      4.8568      0.0000      0.0000      0.0000      0.0000      0.0469      0.6427
148      0.0000      2.4634      0.0000      0.0000      7.8645      7.2556      0.0000      0.0000      0.0000
149      0.0000      0.9109      2.0397      0.6510      0.0000      0.0000      0.0000      0.0000      0.0000
150      0.0000      0.9312      0.0000      0.0000      0.0000      0.0000      0.0000      1.4979      0.0000
151      0.0000      1.0529      0.0000      0.0000      0.0000      0.0000      0.0000      2.8844      0.0000
152      0.0000      0.9135      1.8597      0.0000      1.8534      0.0727      3.1182      0.0000      4.3889
153      0.0000      1.3674      0.0000      0.3936      1.4292      2.4133      4.1819      2.0507      0.0000
154      0.0000      0.6262      0.0000      0.0000      0.0324      0.0000      0.0000      1.7207      0.0000
155      0.0000      1.7257      6.2243      1.8243      0.0000      0.0000      0.0000      5.2027      4.8561
156      0.0699      1.5099      2.4903      2.7873      0.0000      2.3121      0.0000      2.4646      0.2441
157      0.0000      0.4804      2.5337      0.0000      0.0000      2.6023      0.8724      1.8488      0.0000
158     10.6258      2.1116      3.3500      2.7323      2.8696      1.4477      4.9205      2.6313      2.8321
159      8.8253      3.3866      4.8321      2.9605      3.7698      5.8314      3.8788      4.0375      9.6591
160      9.9810      0.9218      0.0000      3.0682      1.5357      4.8034      0.8133      0.0000      0.9369

# j   Mcor_j: min, <> & last-chain-values for 1 ...  7 chains
  1  0.0000E+00  1.1765E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
  2  0.0000E+00  2.1945E-04  0.0000E+00  0.0000E+00  0.0000E+00  1.6635E-05  5.4598E-03  0.0000E+00  0.0000E+00
  3  0.0000E+00  5.5855E-04  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
  4  0.0000E+00  1.2492E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
  5  0.0000E+00  2.7847E-03  2.5430E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  4.2913E-03  0.0000E+00
  6  0.0000E+00  8.3170E-04  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
  7  0.0000E+00  1.4522E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  7.2933E-03  0.0000E+00  0.0000E+00
  8  0.0000E+00  2.0839E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
  9  0.0000E+00  7.6664E-03  0.0000E+00  4.4822E-02  0.0000E+00  5.2702E-02  0.0000E+00  0.0000E+00  0.0000E+00
 10  0.0000E+00  3.0468E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 11  0.0000E+00  4.0028E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 12  0.0000E+00  1.1621E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  5.4995E-02  0.0000E+00
 13  0.0000E+00  3.2968E-02  1.5742E-02  6.0105E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 14  0.0000E+00  1.0362E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  9.7456E-02  0.0000E+00
 15  0.0000E+00  1.3209E-02  0.0000E+00  5.9323E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 16  0.0000E+00  9.2146E-03  0.0000E+00  0.0000E+00  0.0000E+00  2.3244E-03  8.6224E-02  0.0000E+00  0.0000E+00
 17  0.0000E+00  1.1048E-02  0.0000E+00  0.0000E+00  0.0000E+00  3.2009E-02  0.0000E+00  0.0000E+00  0.0000E+00
 18  0.0000E+00  1.1297E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 19  0.0000E+00  4.0031E-02  0.0000E+00  5.7014E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 20  0.0000E+00  1.5118E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 21  0.0000E+00  3.9573E-02  0.0000E+00  0.0000E+00  0.0000E+00  1.9588E-01  0.0000E+00  0.0000E+00  0.0000E+00
 22  0.0000E+00  5.2852E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 23  0.0000E+00  4.3686E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 24  0.0000E+00  7.6579E-02  0.0000E+00  5.6596E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  2.0509E-01
 25  0.0000E+00  8.9980E-02  0.0000E+00  0.0000E+00  0.0000E+00  2.0039E-01  1.9013E-01  0.0000E+00  7.1474E-02
 26  0.0000E+00  1.1606E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 27  0.0000E+00  3.2164E-01  0.0000E+00  1.4198E-01  0.0000E+00  0.0000E+00  0.0000E+00  5.9569E-01  1.2244E+00
 28  0.0000E+00  3.8119E-01  4.0131E-01  0.0000E+00  0.0000E+00  0.0000E+00  5.4602E-01  1.3709E+00  6.8189E-01
 29  0.0000E+00  3.8336E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  2.6185E-01  0.0000E+00  5.5660E-01
 30  0.0000E+00  3.5030E-01  5.3132E-01  0.0000E+00  7.3777E-01  0.0000E+00  6.2213E-02  0.0000E+00  0.0000E+00
 31  0.0000E+00  2.7621E-01  1.1305E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  4.2309E-01  0.0000E+00
 32  5.1267E-05  8.8980E-01  0.0000E+00  2.4357E+00  2.5260E-01  0.0000E+00  0.0000E+00  2.3434E+00  7.8909E-02
 33  0.0000E+00  6.1885E-01  1.5567E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.7495E+00
 34  0.0000E+00  9.2962E-01  0.0000E+00  0.0000E+00  0.0000E+00  1.2542E+00  0.0000E+00  3.4143E+00  0.0000E+00
 35  1.4838E-03  4.3546E-01  0.0000E+00  1.9376E+00  0.0000E+00  0.0000E+00  3.5709E-02  0.0000E+00  0.0000E+00
 36  0.0000E+00  1.1504E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 37  0.0000E+00  1.0436E+00  0.0000E+00  5.7352E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 38  0.0000E+00  1.3067E+00  4.8767E+00  0.0000E+00  8.6543E+00  0.0000E+00  0.0000E+00  9.7168E-01  0.0000E+00
 39  0.0000E+00  2.2490E+00  6.9562E+00  2.7700E+00  0.0000E+00  0.0000E+00  5.6881E+00  0.0000E+00  0.0000E+00
 40  0.0000E+00  1.6898E+00  0.0000E+00  6.4250E+00  0.0000E+00  8.4706E+00  0.0000E+00  0.0000E+00  0.0000E+00
 41  0.0000E+00  1.8054E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  2.4872E-02  0.0000E+00  0.0000E+00
 42  0.0000E+00  3.6505E-04  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 43  0.0000E+00  8.4833E-04  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 44  0.0000E+00  1.5282E-03  0.0000E+00  9.4982E-03  0.0000E+00  1.0371E-02  0.0000E+00  0.0000E+00  1.7011E-02
 45  0.0000E+00  2.0666E-03  2.2292E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 46  0.0000E+00  2.5800E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.2218E-02
 47  0.0000E+00  2.4865E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.3683E-02  1.4156E-02  0.0000E+00
 48  0.0000E+00  1.8844E-03  1.4609E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 49  0.0000E+00  4.5173E-03  7.4631E-04  4.2960E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  6.2070E-02
 50  0.0000E+00  3.1654E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  3.7208E-02
 51  0.0000E+00  7.2169E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.3291E-02
 52  0.0000E+00  8.9135E-03  0.0000E+00  0.0000E+00  3.7628E-03  0.0000E+00  1.1898E-01  0.0000E+00  0.0000E+00
 53  0.0000E+00  6.6136E-03  6.4087E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  5.7285E-02  0.0000E+00
 54  0.0000E+00  1.5312E-02  0.0000E+00  0.0000E+00  0.0000E+00  9.9236E-02  3.6297E-02  1.3831E-02  1.3954E-01
 55  0.0000E+00  6.7908E-03  5.6702E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 56  0.0000E+00  1.9544E-02  0.0000E+00  0.0000E+00  1.6394E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 57  0.0000E+00  1.2243E-02  3.0578E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 58  0.0000E+00  1.1782E-02  0.0000E+00  0.0000E+00  0.0000E+00  4.9260E-03  0.0000E+00  0.0000E+00  0.0000E+00
 59  0.0000E+00  1.2117E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 60  0.0000E+00  1.2631E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 61  0.0000E+00  5.2601E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.8767E-01  0.0000E+00
 62  0.0000E+00  3.3872E-02  0.0000E+00  0.0000E+00  0.0000E+00  5.8343E-02  0.0000E+00  0.0000E+00  0.0000E+00
 63  0.0000E+00  4.1977E-02  0.0000E+00  0.0000E+00  2.6219E-01  2.5561E-03  0.0000E+00  0.0000E+00  0.0000E+00
 64  0.0000E+00  5.7448E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 65  0.0000E+00  1.5168E-01  1.2825E-01  0.0000E+00  7.7574E-01  0.0000E+00  8.0158E-01  0.0000E+00  1.0902E-01
 66  3.0544E+00  1.6139E-01  1.6464E-01  7.7841E-01  1.4117E+00  5.9635E-01  1.7657E-01  5.8438E-01  3.0748E-01
 67  0.0000E+00  5.0693E-01  1.0929E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  7.8871E-01  0.0000E+00
 68  0.0000E+00  6.8265E-01  8.7572E-01  0.0000E+00  0.0000E+00  3.3968E+00  0.0000E+00  0.0000E+00  1.5765E-01
 69  0.0000E+00  5.9027E-01  0.0000E+00  3.4720E-02  7.0778E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 70  0.0000E+00  6.6604E-01  0.0000E+00  0.0000E+00  0.0000E+00  7.1716E-02  0.0000E+00  8.2301E-02  0.0000E+00
 71  9.4788E-01  1.1884E+00  2.9539E-01  3.2622E+00  6.0871E+00  0.0000E+00  3.1101E+00  1.2095E+00  2.6896E+00
 72  0.0000E+00  8.0925E-01  0.0000E+00  0.0000E+00  1.3328E-01  0.0000E+00  9.6145E-01  0.0000E+00  0.0000E+00
 73  0.0000E+00  8.7847E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  6.8608E-01
 74  0.0000E+00  4.4843E-01  2.6327E+00  0.0000E+00  2.7149E+00  0.0000E+00  0.0000E+00  0.0000E+00  3.0994E-01
 75  0.0000E+00  5.1307E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  9.5564E-03  0.0000E+00  0.0000E+00
 76  0.0000E+00  7.0201E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.2308E+00  1.9862E-01  0.0000E+00
 77  0.0000E+00  8.1754E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.2166E+00  0.0000E+00  2.5919E+00
 78  0.0000E+00  1.3720E+00  0.0000E+00  2.7639E+00  2.3390E-01  0.0000E+00  5.2417E+00  0.0000E+00  2.3149E+00
 79  0.0000E+00  1.7682E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 80  0.0000E+00  1.6626E+00  2.1223E+00  0.0000E+00  0.0000E+00  3.7645E+00  0.0000E+00  4.2773E+00  0.0000E+00
 81  0.0000E+00  5.2991E-04  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 82  0.0000E+00  3.5295E-04  0.0000E+00  0.0000E+00  0.0000E+00  2.3694E-03  3.0501E-03  0.0000E+00  0.0000E+00
 83  0.0000E+00  4.0539E-02  0.0000E+00  2.9778E-02  0.0000E+00  0.0000E+00  3.3657E-03  4.5719E-02  0.0000E+00
 84  5.0125E-02  1.1907E-01  1.3029E-01  1.1902E-01  1.5395E-01  6.4039E-02  1.0386E-01  4.0116E-02  7.5188E-02
 85  0.0000E+00  6.4269E-03  0.0000E+00  0.0000E+00  2.9347E-02  0.0000E+00  3.4964E-02  2.1254E-02  1.8097E-02
 86  0.0000E+00  1.2351E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 87  0.0000E+00  2.0662E-02  3.6337E-02  0.0000E+00  6.2769E-02  8.2514E-04  0.0000E+00  4.7549E-02  3.1954E-02
 88  0.0000E+00  7.8696E-03  1.1874E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  9.9835E-04  1.6071E-02
 89  0.0000E+00  6.2883E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 90  0.0000E+00  8.6833E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  4.5485E-02
 91  1.6977E-02  3.3344E-02  0.0000E+00  2.0862E-01  0.0000E+00  0.0000E+00  0.0000E+00  9.1570E-03  8.7812E-02
 92  0.0000E+00  2.2285E-02  2.0296E-01  0.0000E+00  0.0000E+00  9.4659E-03  0.0000E+00  0.0000E+00  0.0000E+00
 93  0.0000E+00  7.2745E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 94  3.0018E-01  2.0127E-02  0.0000E+00  9.9196E-02  0.0000E+00  0.0000E+00  0.0000E+00  6.2108E-02  0.0000E+00
 95  0.0000E+00  2.1296E-02  0.0000E+00  0.0000E+00  1.4377E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 96  0.0000E+00  2.4516E-02  0.0000E+00  0.0000E+00  3.0959E-02  0.0000E+00  0.0000E+00  6.0742E-02  1.9195E-01
 97  0.0000E+00  1.4790E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 98  0.0000E+00  1.1706E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
 99  0.0000E+00  1.8874E-02  1.4125E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
100  0.0000E+00  2.3682E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
101  0.0000E+00  2.9432E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
102  0.0000E+00  3.8757E-02  1.2425E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.5843E-01  0.0000E+00
103  0.0000E+00  4.5304E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.5178E-02  0.0000E+00
104  0.0000E+00  6.0008E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.7428E-01  4.7795E-02  0.0000E+00
105  9.7543E-01  2.0413E-01  6.5863E-01  7.4415E-01  1.0063E+00  1.5979E-02  0.0000E+00  0.0000E+00  0.0000E+00
106  0.0000E+00  2.0180E-01  0.0000E+00  1.8339E-02  0.0000E+00  6.9187E-01  1.5562E-01  8.7607E-01  2.1438E-01
107  3.4976E+00  6.5836E-01  0.0000E+00  1.6624E+00  0.0000E+00  0.0000E+00  1.2619E+00  1.6612E+00  0.0000E+00
108  0.0000E+00  8.2498E-01  0.0000E+00  0.0000E+00  2.9588E-01  2.0932E-01  1.0600E+00  1.6065E+00  0.0000E+00
109  0.0000E+00  6.2551E-01  0.0000E+00  5.6015E-01  0.0000E+00  0.0000E+00  4.3922E-01  0.0000E+00  0.0000E+00
110  7.4149E-04  7.3812E-01  1.1775E+00  5.2198E-01  1.2142E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.3901E+00
111  0.0000E+00  6.5459E-01  2.4396E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
112  0.0000E+00  1.7178E+00  0.0000E+00  2.6325E+00  0.0000E+00  2.0977E-01  5.2414E+00  0.0000E+00  3.5350E+00
113  0.0000E+00  6.1029E-01  0.0000E+00  0.0000E+00  0.0000E+00  2.9983E+00  5.9185E-01  2.8714E+00  0.0000E+00
114  0.0000E+00  7.6215E-01  0.0000E+00  0.0000E+00  0.0000E+00  2.2052E+00  0.0000E+00  6.4101E-01  0.0000E+00
115  5.2001E-04  1.6943E+00  1.1551E+00  5.3141E+00  0.0000E+00  6.2029E-01  0.0000E+00  1.4623E+00  1.1897E+00
116  0.0000E+00  2.8333E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.2492E+01  8.6857E-01  0.0000E+00
117  0.0000E+00  1.3474E+00  0.0000E+00  0.0000E+00  9.6377E+00  1.9471E+00  0.0000E+00  0.0000E+00  0.0000E+00
118  0.0000E+00  4.3605E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.1627E+01  0.0000E+00  0.0000E+00
119  7.3727E-03  6.2920E+00  7.9220E+00  2.0123E+01  1.3451E+01  9.6010E-01  0.0000E+00  1.1450E+01  4.0592E+00
120  0.0000E+00  2.1942E+00  0.0000E+00  0.0000E+00  7.6641E+00  1.0476E+01  0.0000E+00  5.9006E-01  1.1416E+01
121  0.0000E+00  3.6548E-04  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
122  0.0000E+00  3.8501E-04  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  5.3694E-03  0.0000E+00  0.0000E+00
123  0.0000E+00  3.1183E-02  3.3636E-02  0.0000E+00  4.8915E-02  5.5915E-02  3.7977E-02  0.0000E+00  0.0000E+00
124  0.0000E+00  2.7466E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
125  0.0000E+00  5.6008E-03  0.0000E+00  0.0000E+00  0.0000E+00  2.4484E-02  0.0000E+00  2.8773E-02  0.0000E+00
126  0.0000E+00  3.8345E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
127  0.0000E+00  3.1339E-03  0.0000E+00  0.0000E+00  0.0000E+00  3.4990E-03  0.0000E+00  0.0000E+00  0.0000E+00
128  0.0000E+00  3.9854E-03  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
129  0.0000E+00  8.7003E-03  0.0000E+00  0.0000E+00  1.8953E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
130  8.9631E-02  7.0773E-03  0.0000E+00  3.9818E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  2.1727E-02
131  0.0000E+00  1.8852E-02  0.0000E+00  0.0000E+00  0.0000E+00  8.0786E-02  2.5313E-02  9.2729E-02  0.0000E+00
132  2.8096E-01  2.2097E-02  0.0000E+00  8.0668E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  2.4729E-02
133  0.0000E+00  3.7253E-02  5.3483E-02  0.0000E+00  1.7175E-01  1.0405E-02  2.3846E-01  4.7025E-02  4.3783E-02
134  0.0000E+00  2.5568E-02  0.0000E+00  0.0000E+00  0.0000E+00  1.1048E-01  0.0000E+00  1.3050E-01  0.0000E+00
135  0.0000E+00  3.8323E-02  1.5043E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  2.1109E-01  2.4493E-01
136  2.8939E-01  2.2726E-02  0.0000E+00  1.5104E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
137  0.0000E+00  1.7970E-02  0.0000E+00  5.7856E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
138  0.0000E+00  3.0914E-02  0.0000E+00  0.0000E+00  1.7753E-01  2.4665E-01  0.0000E+00  7.6596E-02  0.0000E+00
139  0.0000E+00  1.8230E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  5.3734E-02
140  0.0000E+00  1.4157E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
141  0.0000E+00  2.5010E-02  2.3207E-01  0.0000E+00  0.0000E+00  2.8400E-01  0.0000E+00  0.0000E+00  5.8405E-02
142  0.0000E+00  2.8057E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
143  0.0000E+00  5.1874E-02  1.7056E-01  0.0000E+00  0.0000E+00  0.0000E+00  4.1827E-03  0.0000E+00  0.0000E+00
144  0.0000E+00  6.1515E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  3.4649E-01  0.0000E+00  0.0000E+00
145  0.0000E+00  9.8731E-02  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.0529E-01  0.0000E+00
146  9.7609E-04  2.6054E-01  0.0000E+00  9.0604E-01  5.7193E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
147  0.0000E+00  2.8379E-01  1.8920E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.9466E-02  2.2604E-01
148  0.0000E+00  1.3165E+00  0.0000E+00  0.0000E+00  3.9443E+00  2.8612E+00  0.0000E+00  0.0000E+00  0.0000E+00
149  0.0000E+00  5.8560E-01  1.1607E+00  3.4850E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00
150  0.0000E+00  6.4465E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  9.7805E-01  0.0000E+00
151  0.0000E+00  7.4517E-01  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.9254E+00  0.0000E+00
152  0.0000E+00  9.9457E-01  1.7923E+00  0.0000E+00  1.8939E+00  5.8437E-02  2.8545E+00  0.0000E+00  3.8185E+00
153  0.0000E+00  1.8529E+00  0.0000E+00  4.4416E-01  1.8176E+00  2.4137E+00  4.7646E+00  2.6211E+00  0.0000E+00
154  0.0000E+00  1.1141E+00  0.0000E+00  0.0000E+00  5.4094E-02  0.0000E+00  0.0000E+00  2.8876E+00  0.0000E+00
155  0.0000E+00  3.6948E+00  1.1797E+01  3.2530E+00  0.0000E+00  0.0000E+00  0.0000E+00  1.0508E+01  8.3079E+00
156  1.3106E-01  4.3273E+00  6.3179E+00  6.6530E+00  0.0000E+00  4.8915E+00  0.0000E+00  6.6635E+00  5.5906E-01
157  0.0000E+00  1.6528E+00  7.7169E+00  0.0000E+00  0.0000E+00  6.6097E+00  2.5243E+00  6.0007E+00  0.0000E+00
158  2.8315E+01  8.6090E+00  1.2090E+01  9.2775E+00  1.0980E+01  4.3572E+00  1.6871E+01  1.0120E+01  9.2259E+00
159  2.7796E+01  1.6323E+01  2.0616E+01  1.1884E+01  1.7053E+01  2.0749E+01  1.5723E+01  1.8358E+01  3.7198E+01
160  3.4244E+01  4.8400E+00  0.0000E+00  1.3418E+01  7.5682E+00  1.8620E+01  3.5916E+00  0.0000E+00  3.9308E+00

# chi2/Nl_eff & Mass for min, <> & i_chain = 1 ...  7 solutions
chi2 7.1248E-01  7.3989E-01  7.3339E-01  7.2953E-01  7.3071E-01  7.3232E-01  7.3425E-01  7.3404E-01  7.3038E-01
Mass 1.2431E+08  7.2921E+07  8.2429E+07  8.7084E+07  7.7458E+07  9.7520E+07  8.5328E+07  7.6898E+07  9.1739E+07
  81.05                                  [v0_min (km/s) before EX0s...]
 172.21                                  [vd_min (km/s) before EX0s...]



## Synthetic spectrum (Best Model) ##l_obs f_obs f_syn wei Best_f_SSP
 1651       71        1    [Nl_obs & index_Best_SSP & i_SaveBestSingleCompFit]
 3650.00  0.00000E+00  3.64115E-01 -9.90000E+01  2.92516E-01
 3652.00  0.00000E+00  3.72271E-01 -9.90000E+01  3.05698E-01
 3654.00  0.00000E+00  3.82515E-01 -9.90000E+01  3.21903E-01
 3656.00  0.00000E+00  3.90783E-01 -9.90000E+01  3.34502E-01
 3658.00  0.00000E+00  3.96132E-01 -9.90000E+01  3.42176E-01
 3660.00  0.00000E+00  3.97860E-01 -9.90000E+01  3.44293E-01
 3662.00  0.00000E+00  3.95658E-01 -9.90000E+01  3.40444E-01
 3664.00  0.00000E+00  3.92028E-01 -9.90000E+01  3.34764E-01
 3666.00  0.00000E+00  3.89479E-01 -9.90000E+01  3.31186E-01
 3668.00  0.00000E+00  3.87379E-01 -9.90000E+01  3.28063E-01
 3670.00  0.00000E+00  3.86058E-01 -9.90000E+01  3.26032E-01
 3672.00  0.00000E+00  3.87795E-01 -9.90000E+01  3.29848E-01
 3674.00  0.00000E+00  3.89906E-01 -9.90000E+01  3.35030E-01
 3676.00  0.00000E+00  3.87213E-01 -9.90000E+01  3.32338E-01
 3678.00  0.00000E+00  3.80120E-01 -9.90000E+01  3.22330E-01
 3680.00  0.00000E+00  3.74407E-01 -9.90000E+01  3.14599E-01
 3682.00  0.00000E+00  3.73588E-01 -9.90000E+01  3.14498E-01
 3684.00  0.00000E+00  3.73914E-01 -9.90000E+01  3.14953E-01
 3686.00  0.00000E+00  3.71891E-01 -9.90000E+01  3.10150E-01
 3688.00  9.05329E-01  3.72220E-01 -2.40000E+01  3.09088E-01
 3690.00  1.59409E+00  3.79729E-01 -2.40000E+01  3.20835E-01
 3692.00  2.07122E+00  3.89421E-01 -2.40000E+01  3.36519E-01
 3694.00  2.24580E+00  3.93966E-01 -2.40000E+01  3.43537E-01
 3696.00  1.48388E+00  3.94437E-01 -2.40000E+01  3.44704E-01
 3698.00  2.33209E-01  3.97928E-01 -2.40000E+01  3.50743E-01
 3700.00  3.77965E-01  4.03718E-01 -2.40000E+01  3.60033E-01
 3702.00  1.24162E+00  3.99311E-01 -2.40000E+01  3.55188E-01
 3704.00  1.11812E+00  3.82813E-01 -2.40000E+01  3.31235E-01
 3706.00  6.08942E-01  3.71323E-01 -2.40000E+01  3.08937E-01
 3708.00  1.38279E-01  3.72617E-01 -2.40000E+01  3.03938E-01
 3710.00  2.70579E-01  3.76768E-01 -2.40000E+01  3.11517E-01
 3712.00  1.01783E+00  3.82594E-01 -2.40000E+01  3.27871E-01
 3714.00  1.37243E+00  3.98482E-01 -2.40000E+01  3.52983E-01
 3716.00  1.04750E+00  4.15623E-01 -2.40000E+01  3.72169E-01
 3718.00  8.63515E-01  4.11855E-01 -2.40000E+01  3.64659E-01
 3720.00  7.43779E-01  3.83539E-01 -2.40000E+01  3.30765E-01
 3722.00  8.91042E-01  3.58814E-01 -2.40000E+01  3.02855E-01
 3724.00  1.71842E+00  3.67394E-01 -2.40000E+01  3.11303E-01
 3726.00  1.63423E+00  4.00936E-01 -2.40000E+01  3.41926E-01
 3728.00  1.43814E+00  4.26671E-01 -2.40000E+01  3.61217E-01
 3730.00  1.42332E+00  4.24294E-01 -2.40000E+01  3.56552E-01
 3732.00  1.41048E+00  3.92571E-01 -2.40000E+01  3.27649E-01
 3734.00  1.28345E+00  3.52383E-01 -2.40000E+01  2.88047E-01
 3736.00  1.09498E+00  3.40810E-01 -2.40000E+01  2.72023E-01
 3738.00  1.18500E+00  3.72937E-01 -2.40000E+01  2.98284E-01
 3740.00  1.44304E+00  4.23675E-01 -2.40000E+01  3.43948E-01
 3742.00  1.30990E+00  4.56023E-01 -2.40000E+01  3.70409E-01
 3744.00  9.48771E-01  4.52771E-01 -2.40000E+01  3.62299E-01
 3746.00  9.17834E-01  4.19330E-01 -2.40000E+01  3.30414E-01
 3748.00  6.56216E-01  3.73011E-01 -2.40000E+01  2.93079E-01
 3750.00  6.64670E-01  3.42268E-01 -2.40000E+01  2.75326E-01
 3752.00  3.94235E-01  3.54595E-01 -2.40000E+01  2.99018E-01
 3754.00  4.27945E-01  4.04048E-01 -2.40000E+01  3.50202E-01
 3756.00  7.87251E-01  4.54377E-01 -2.40000E+01  3.87025E-01
 3758.00  1.07928E+00  4.81271E-01 -2.40000E+01  3.89231E-01
 3760.00  1.15676E+00  4.90564E-01 -2.40000E+01  3.79171E-01
 3762.00  9.02516E-01  4.92694E-01 -2.40000E+01  3.80505E-01
 3764.00  5.97545E-01  4.83429E-01 -2.40000E+01  3.85313E-01
 3766.00  8.67913E-01  4.55774E-01 -2.40000E+01  3.76684E-01
 3768.00  5.54627E-01  4.13745E-01 -2.40000E+01  3.53758E-01
 3770.00  2.76632E-01  3.77496E-01 -2.40000E+01  3.33995E-01
 3772.00  7.42580E-01  3.73958E-01 -2.40000E+01  3.37921E-01
 3774.00  8.55694E-01  4.09436E-01 -2.40000E+01  3.66064E-01
 3776.00  5.94136E-01  4.63338E-01 -2.40000E+01  4.02029E-01
 3778.00  7.28099E-01  5.14461E-01 -2.40000E+01  4.36513E-01
 3780.00  9.66379E-01  5.54423E-01 -2.40000E+01  4.67588E-01
 3782.00  1.09009E+00  5.79637E-01 -2.40000E+01  4.88789E-01
 3784.00  9.81006E-01  5.87320E-01 -2.40000E+01  4.92284E-01
 3786.00  5.41304E-01  5.77541E-01 -2.40000E+01  4.74833E-01
 3788.00  5.63169E-01  5.55940E-01 -2.40000E+01  4.45404E-01
 3790.00  6.52609E-01  5.29132E-01 -2.40000E+01  4.19459E-01
 3792.00  6.66060E-01  4.95156E-01 -2.40000E+01  3.98040E-01
 3794.00  7.37702E-01  4.47102E-01 -2.40000E+01  3.68784E-01
 3796.00  8.36901E-02  3.90643E-01 -2.40000E+01  3.31226E-01
 3798.00  7.03861E-02  3.51928E-01 -2.40000E+01  3.06498E-01
 3800.00  5.38837E-01  3.59065E-01 -2.40000E+01  3.19328E-01
 3802.00  5.48081E-01  4.09562E-01 -2.40000E+01  3.67094E-01
 3804.00  4.74351E-01  4.71595E-01 -2.40000E+01  4.18643E-01
 3806.00  5.09358E-01  5.20201E-01 -2.40000E+01  4.50530E-01
 3808.00  5.23925E-01  5.55134E-01 -2.40000E+01  4.68694E-01
 3810.00  6.06383E-01  5.82059E-01 -2.40000E+01  4.84724E-01
 3812.00  5.87525E-01  5.95878E-01 -2.40000E+01  4.89462E-01
 3814.00  5.23561E-01  5.93555E-01 -2.40000E+01  4.75958E-01
 3816.00  5.13221E-01  5.83670E-01 -2.40000E+01  4.61159E-01
 3818.00  5.75847E-01  5.72201E-01 -2.40000E+01  4.56651E-01
 3820.00  5.65321E-01  5.59578E-01 -2.40000E+01  4.51880E-01
 3822.00  4.43540E-01  5.50735E-01 -2.40000E+01  4.40960E-01
 3824.00  4.26988E-01  5.42704E-01 -2.40000E+01  4.23771E-01
 3826.00  4.79415E-01  5.25627E-01 -2.40000E+01  4.00420E-01
 3828.00  6.71724E-01  4.98107E-01 -2.40000E+01  3.77812E-01
 3830.00  6.21536E-01  4.60289E-01 -2.40000E+01  3.55728E-01
 3832.00  5.55224E-01  4.09735E-01 -2.40000E+01  3.24559E-01
 3834.00  4.23332E-01  3.56729E-01 -2.40000E+01  2.89134E-01
 3836.00  3.23402E-01  3.28323E-01 -2.40000E+01  2.71186E-01
 3838.00  6.22014E-01  3.42921E-01 -2.40000E+01  2.82465E-01
 3840.00  6.03786E-01  3.91590E-01 -2.40000E+01  3.17227E-01
 3842.00  3.69322E-01  4.52356E-01 -2.40000E+01  3.65668E-01
 3844.00  4.19221E-01  5.07493E-01 -2.40000E+01  4.14357E-01
 3846.00  5.32885E-01  5.48173E-01 -2.40000E+01  4.49989E-01
 3848.00  7.36462E-01  5.74440E-01 -2.40000E+01  4.70351E-01
 3850.00  7.50058E-01  5.91136E-01 -2.40000E+01  4.81519E-01
 3852.00  6.00098E-01  6.03224E-01 -2.40000E+01  4.91305E-01
 3854.00  5.01377E-01  6.10429E-01 -2.40000E+01  4.98563E-01
 3856.00  4.28677E-01  6.12093E-01 -2.40000E+01  4.97259E-01
 3858.00  3.37858E-01  6.12661E-01 -2.40000E+01  4.90544E-01
 3860.00  2.90452E-01  6.15716E-01 -2.40000E+01  4.89490E-01
 3862.00  3.49443E-01  6.21964E-01 -2.40000E+01  5.02535E-01
 3864.00  3.20587E-01  6.28642E-01 -2.40000E+01  5.20839E-01
 3866.00  1.58428E-01  6.31267E-01 -2.40000E+01  5.29364E-01
 3868.00  9.08262E-02  6.28561E-01 -2.40000E+01  5.25366E-01
 3870.00  2.47361E-01  6.20737E-01 -2.40000E+01  5.11172E-01
 3872.00  2.49247E-01  6.09423E-01 -2.40000E+01  4.92785E-01
 3874.00  4.13042E-01  5.99978E-01 -2.40000E+01  4.83332E-01
 3876.00  4.65377E-01  5.90264E-01 -2.40000E+01  4.81271E-01
 3878.00  4.20711E-01  5.72350E-01 -2.40000E+01  4.70902E-01
 3880.00  4.09583E-01  5.47074E-01 -2.40000E+01  4.52944E-01
 3882.00  4.08920E-01  5.16499E-01 -2.40000E+01  4.34607E-01
 3884.00  2.83867E-01  4.76181E-01 -2.40000E+01  4.12154E-01
 3886.00  2.13774E-01  4.23664E-01 -2.40000E+01  3.79182E-01
 3888.00  2.29369E-01  3.74056E-01 -2.40000E+01  3.46194E-01
 3890.00  1.76829E-01  3.57751E-01 -2.40000E+01  3.38891E-01
 3892.00  3.12985E-01  3.87993E-01 -2.40000E+01  3.67212E-01
 3894.00  5.61515E-01  4.43541E-01 -2.40000E+01  4.10440E-01
 3896.00  6.71229E-01  4.96929E-01 -2.40000E+01  4.46779E-01
 3898.00  6.01607E-01  5.38147E-01 -2.40000E+01  4.73211E-01
 3900.00  5.12162E-01  5.68898E-01 -2.40000E+01  4.94113E-01
 3902.00  6.34619E-01  5.92865E-01 -2.40000E+01  5.10932E-01
 3904.00  6.20267E-01  6.10913E-01 -2.40000E+01  5.20318E-01
 3906.00  6.35420E-01  6.26054E-01 -2.40000E+01  5.26350E-01
 3908.00  6.08006E-01  6.44526E-01 -2.40000E+01  5.42238E-01
 3910.00  5.63128E-01  6.64415E-01 -2.40000E+01  5.67775E-01
 3912.00  6.02549E-01  6.77189E-01 -2.40000E+01  5.86632E-01
 3914.00  4.74298E-01  6.80103E-01 -2.40000E+01  5.88572E-01
 3916.00  4.48307E-01  6.76179E-01 -2.40000E+01  5.78876E-01
 3918.00  5.45864E-01  6.67002E-01 -2.40000E+01  5.65476E-01
 3920.00  6.30968E-01  6.55737E-01 -2.40000E+01  5.52811E-01
 3922.00  6.57444E-01  6.49182E-01 -2.40000E+01  5.44544E-01
 3924.00  5.92658E-01  6.46882E-01 -2.40000E+01  5.36843E-01
 3926.00  4.42069E-01  6.38845E-01 -2.40000E+01  5.14325E-01
 3928.00  3.19199E-01  6.18281E-01 -2.40000E+01  4.64934E-01
 3930.00  3.24265E-01  5.85353E-01 -2.40000E+01  3.91601E-01
 3932.00  3.71594E-01  5.46089E-01 -2.40000E+01  3.13137E-01
 3934.00  3.25134E-01  5.19976E-01 -2.40000E+01  2.65657E-01
 3936.00  3.30436E-01  5.28700E-01 -2.40000E+01  2.80952E-01
 3938.00  4.97949E-01  5.66003E-01 -2.40000E+01  3.48236E-01
 3940.00  4.65390E-01  6.05222E-01 -2.40000E+01  4.24085E-01
 3942.00  4.98930E-01  6.28997E-01 -2.40000E+01  4.76745E-01
 3944.00  6.33930E-01  6.39202E-01 -2.40000E+01  5.06837E-01
 3946.00  6.92222E-01  6.46106E-01 -2.40000E+01  5.29149E-01
 3948.00  8.13498E-01  6.52682E-01 -2.40000E+01  5.45949E-01
 3950.00  8.49245E-01  6.56255E-01 -2.40000E+01  5.55117E-01
 3952.00  8.11867E-01  6.54928E-01 -2.40000E+01  5.59312E-01
 3954.00  7.40566E-01  6.48135E-01 -2.40000E+01  5.60041E-01
 3956.00  6.79289E-01  6.34978E-01 -2.40000E+01  5.53684E-01
 3958.00  6.50074E-01  6.14759E-01 -2.40000E+01  5.38379E-01
 3960.00  6.47545E-01  5.84591E-01 -2.40000E+01  5.10930E-01
 3962.00  6.24498E-01  5.40317E-01 -2.40000E+01  4.63587E-01
 3964.00  4.94340E-01  4.82914E-01 -2.40000E+01  3.97333E-01
 3966.00  1.78631E-01  4.16040E-01 -2.40000E+01  3.20004E-01
 3968.00  1.02800E-01  3.50050E-01 -2.40000E+01  2.49740E-01
 3970.00  1.29992E-01  3.10704E-01 -2.40000E+01  2.19413E-01
 3972.00  1.92291E-01  3.22096E-01 -2.40000E+01  2.47418E-01
 3974.00  4.91466E-01  3.78519E-01 -2.40000E+01  3.15946E-01
 3976.00  4.85224E-01  4.52208E-01 -2.40000E+01  3.94085E-01
 3978.00  5.71963E-01  5.20220E-01 -2.40000E+01  4.63199E-01
 3980.00  6.29750E-01  5.73113E-01 -2.40000E+01  5.15431E-01
 3982.00  6.06843E-01  6.09634E-01 -2.40000E+01  5.47106E-01
 3984.00  6.89924E-01  6.35245E-01 -2.40000E+01  5.66122E-01
 3986.00  6.20403E-01  6.56945E-01 -2.40000E+01  5.84627E-01
 3988.00  6.47494E-01  6.76404E-01 -2.40000E+01  6.04524E-01
 3990.00  6.52752E-01  6.91621E-01 -2.40000E+01  6.21181E-01
 3992.00  7.40286E-01  7.02458E-01 -2.40000E+01  6.33189E-01
 3994.00  7.68918E-01  7.08575E-01 -2.40000E+01  6.37954E-01
 3996.00  7.76268E-01  7.09956E-01 -2.40000E+01  6.33819E-01
 3998.00  7.50685E-01  7.11912E-01 -2.40000E+01  6.31289E-01
 4000.00  6.34075E-01  7.19344E-01 -2.40000E+01  6.41903E-01
 4002.00  6.28808E-01  7.26220E-01 -2.40000E+01  6.55916E-01
 4004.00  7.15934E-01  7.24262E-01 -2.40000E+01  6.56136E-01
 4006.00  8.20621E-01  7.16642E-01 -2.40000E+01  6.46651E-01
 4008.00  9.28576E-01  7.14797E-01 -2.40000E+01  6.48316E-01
 4010.00  9.36069E-01  7.21454E-01 -2.40000E+01  6.62923E-01
 4012.00  8.22070E-01  7.31360E-01 -2.40000E+01  6.76344E-01
 4014.00  7.31281E-01  7.40321E-01 -2.40000E+01  6.83242E-01
 4016.00  7.87430E-01  7.47234E-01 -2.40000E+01  6.87991E-01
 4018.00  7.32857E-01  7.52017E-01 -2.40000E+01  6.92781E-01
 4020.00  7.12892E-01  7.53793E-01 -2.40000E+01  6.96372E-01
 4022.00  7.73511E-01  7.48071E-01 -2.40000E+01  6.94895E-01
 4024.00  7.71289E-01  7.34151E-01 -2.40000E+01  6.90835E-01
 4026.00  7.26992E-01  7.21089E-01 -2.40000E+01  6.92024E-01
 4028.00  7.30473E-01  7.16939E-01 -2.40000E+01  6.93492E-01
 4030.00  8.41335E-01  7.15597E-01 -2.40000E+01  6.79909E-01
 4032.00  7.08410E-01  7.11877E-01 -2.40000E+01  6.57372E-01
 4034.00  6.70562E-01  7.13704E-01 -2.40000E+01  6.51403E-01
 4036.00  8.15970E-01  7.28512E-01 -2.40000E+01  6.71946E-01
 4038.00  8.72176E-01  7.48725E-01 -2.40000E+01  7.00538E-01
 4040.00  8.94018E-01  7.59443E-01 -2.40000E+01  7.12677E-01
 4042.00  7.68289E-01  7.54678E-01 -2.40000E+01  7.02505E-01
 4044.00  7.23042E-01  7.38403E-01 -2.40000E+01  6.78315E-01
 4046.00  7.41160E-01  7.23682E-01 -2.40000E+01  6.58767E-01
 4048.00  7.23358E-01  7.25407E-01 -2.40000E+01  6.63736E-01
 4050.00  7.20335E-01  7.39458E-01 -2.40000E+01  6.83459E-01
 4052.00  7.35247E-01  7.48710E-01 -2.40000E+01  6.92912E-01
 4054.00  7.30702E-01  7.45503E-01 -2.40000E+01  6.84682E-01
 4056.00  7.05230E-01  7.36859E-01 -2.40000E+01  6.72069E-01
 4058.00  7.03659E-01  7.30922E-01 -2.40000E+01  6.66642E-01
 4060.00  7.18809E-01  7.28594E-01 -2.40000E+01  6.68068E-01
 4062.00  7.21828E-01  7.23187E-01 -2.40000E+01  6.64100E-01
 4064.00  6.91003E-01  7.14602E-01 -2.40000E+01  6.53057E-01
 4066.00  6.82526E-01  7.12169E-01 -2.40000E+01  6.49971E-01
 4068.00  6.93201E-01  7.16962E-01 -2.40000E+01  6.58792E-01
 4070.00  6.84042E-01  7.20015E-01 -2.40000E+01  6.67610E-01
 4072.00  7.32928E-01  7.15895E-01 -2.40000E+01  6.65352E-01
 4074.00  8.47690E-01  7.08663E-01 -2.40000E+01  6.53980E-01
 4076.00  8.88648E-01  6.99513E-01 -2.40000E+01  6.34109E-01
 4078.00  8.30464E-01  6.94109E-01 -2.40000E+01  6.17589E-01
 4080.00  7.94141E-01  7.00055E-01 -2.40000E+01  6.22385E-01
 4082.00  6.86163E-01  7.10295E-01 -2.40000E+01  6.40913E-01
 4084.00  6.68551E-01  7.11773E-01 -2.40000E+01  6.51181E-01
 4086.00  7.23373E-01  7.06009E-01 -2.40000E+01  6.53361E-01
 4088.00  6.74091E-01  7.00044E-01 -2.40000E+01  6.58855E-01
 4090.00  7.68626E-01  6.90217E-01 -2.40000E+01  6.62580E-01
 4092.00  7.42697E-01  6.69207E-01 -2.40000E+01  6.53261E-01
 4094.00  6.36636E-01  6.34997E-01 -2.40000E+01  6.29084E-01
 4096.00  5.95984E-01  5.87421E-01 -2.40000E+01  5.91288E-01
 4098.00  7.06652E-01  5.29203E-01 -2.40000E+01  5.42336E-01
 4100.00  7.22041E-01  4.70022E-01 -2.40000E+01  4.89060E-01
 4102.00  6.28872E-01  4.32477E-01 -2.40000E+01  4.53029E-01
 4104.00  5.66557E-01  4.39910E-01 -2.40000E+01  4.60182E-01
 4106.00  6.73626E-01  4.87018E-01 -2.40000E+01  5.04082E-01
 4108.00  6.91172E-01  5.44357E-01 -2.40000E+01  5.51727E-01
 4110.00  6.78617E-01  5.90279E-01 -2.40000E+01  5.83596E-01
 4112.00  7.47017E-01  6.25186E-01 -2.40000E+01  6.07177E-01
 4114.00  7.00692E-01  6.55277E-01 -2.40000E+01  6.31316E-01
 4116.00  6.12238E-01  6.78639E-01 -2.40000E+01  6.50993E-01
 4118.00  7.45188E-01  6.90192E-01 -2.40000E+01  6.57474E-01
 4120.00  6.99506E-01  6.93441E-01 -2.40000E+01  6.55365E-01
 4122.00  6.82909E-01  6.98056E-01 -2.40000E+01  6.55797E-01
 4124.00  7.41114E-01  7.06925E-01 -2.40000E+01  6.61831E-01
 4126.00  7.25792E-01  7.12648E-01 -2.40000E+01  6.66719E-01
 4128.00  7.41954E-01  7.08636E-01 -2.40000E+01  6.63879E-01
 4130.00  7.14705E-01  6.99587E-01 -2.40000E+01  6.55813E-01
 4132.00  7.30463E-01  6.95159E-01 -2.40000E+01  6.49141E-01
 4134.00  7.74637E-01  7.02774E-01 -2.40000E+01  6.53373E-01
 4136.00  7.29911E-01  7.20243E-01 -2.40000E+01  6.72544E-01
 4138.00  6.86004E-01  7.36552E-01 -2.40000E+01  6.96487E-01
 4140.00  7.27635E-01  7.40008E-01 -2.40000E+01  7.07846E-01
 4142.00  7.85434E-01  7.27003E-01 -2.40000E+01  6.97466E-01
 4144.00  7.86592E-01  7.10333E-01 -2.40000E+01  6.79933E-01
 4146.00  7.46806E-01  7.08324E-01 -2.40000E+01  6.77172E-01
 4148.00  7.30412E-01  7.19168E-01 -2.40000E+01  6.86285E-01
 4150.00  7.12091E-01  7.28268E-01 -2.40000E+01  6.91287E-01
 4152.00  6.59383E-01  7.29506E-01 -2.40000E+01  6.87908E-01
 4154.00  6.81769E-01  7.27353E-01 -2.40000E+01  6.81818E-01
 4156.00  7.60789E-01  7.27590E-01 -2.40000E+01  6.79843E-01
 4158.00  7.72096E-01  7.33146E-01 -2.40000E+01  6.86896E-01
 4160.00  6.93920E-01  7.42225E-01 -2.40000E+01  7.00934E-01
 4162.00  6.33662E-01  7.49773E-01 -2.40000E+01  7.14228E-01
 4164.00  6.99261E-01  7.52775E-01 -2.40000E+01  7.21465E-01
 4166.00  8.43093E-01  7.50829E-01 -2.40000E+01  7.20871E-01
 4168.00  8.70481E-01  7.45412E-01 -2.40000E+01  7.13463E-01
 4170.00  7.54509E-01  7.37219E-01 -2.40000E+01  6.99144E-01
 4172.00  7.24883E-01  7.25454E-01 -2.40000E+01  6.76685E-01
 4174.00  7.34843E-01  7.15377E-01 -2.40000E+01  6.57097E-01
 4176.00  7.23808E-01  7.12584E-01 -2.40000E+01  6.51449E-01
 4178.00  7.44042E-01  7.15871E-01 -2.40000E+01  6.57454E-01
 4180.00  7.75605E-01  7.22022E-01 -2.40000E+01  6.68676E-01
 4182.00  7.22571E-01  7.28949E-01 -2.40000E+01  6.80062E-01
 4184.00  6.90812E-01  7.35524E-01 -2.40000E+01  6.89343E-01
 4186.00  7.97299E-01  7.38857E-01 -2.40000E+01  6.93755E-01
 4188.00  8.68491E-01  7.39279E-01  1.00844E+01  6.95267E-01
 4190.00  8.60573E-01  7.41869E-01  9.99653E+00  7.00845E-01
 4192.00  7.52274E-01  7.47399E-01  1.04220E+01  7.10225E-01
 4194.00  8.01054E-01  7.49823E-01  1.04051E+01  7.14234E-01
 4196.00  8.72810E-01  7.42445E-01  1.08222E+01  7.02622E-01
 4198.00  8.73161E-01  7.29735E-01  1.10008E+01  6.82732E-01
 4200.00  7.96400E-01  7.21400E-01  1.11279E+01  6.69878E-01
 4202.00  7.03776E-01  7.22241E-01  1.18524E+01  6.69945E-01
 4204.00  6.37122E-01  7.31391E-01  1.24273E+01  6.79595E-01
 4206.00  6.48166E-01  7.44938E-01  1.23720E+01  6.94930E-01
 4208.00  7.40890E-01  7.57084E-01  1.19394E+01  7.11572E-01
 4210.00  7.73253E-01  7.62685E-01  1.18442E+01  7.22754E-01
 4212.00  7.56448E-01  7.61417E-01  1.19124E+01  7.25120E-01
 4214.00  7.31679E-01  7.54989E-01  1.20110E+01  7.17841E-01
 4216.00  7.43949E-01  7.50170E-01  1.22900E+01  7.09562E-01
 4218.00  7.28011E-01  7.55204E-01  1.23580E+01  7.14264E-01
 4220.00  8.06523E-01  7.64453E-01  1.25736E+01  7.26662E-01
 4222.00  8.66088E-01  7.62183E-01  1.19963E+01  7.24878E-01
 4224.00  8.30495E-01  7.41028E-01  1.18842E+01  6.96264E-01
 4226.00  8.65587E-01  7.14366E-01  1.18054E+01  6.59504E-01
 4228.00  7.79174E-01  7.05740E-01  1.25774E+01  6.50776E-01
 4230.00  6.89545E-01  7.20407E-01  1.27935E+01  6.76576E-01
 4232.00  6.47552E-01  7.38476E-01  1.31583E+01  7.03611E-01
 4234.00  6.97375E-01  7.44445E-01  1.27825E+01  7.08059E-01
 4236.00  6.68475E-01  7.43145E-01  1.31662E+01  6.99660E-01
 4238.00  7.22443E-01  7.44996E-01  1.24102E+01  6.96973E-01
 4240.00  8.33941E-01  7.52757E-01  1.19988E+01  7.05791E-01
 4242.00  7.80180E-01  7.63802E-01  1.17656E+01  7.21070E-01
 4244.00  7.65986E-01  7.73000E-01  1.22815E+01  7.32023E-01
 4246.00  7.27007E-01  7.73343E-01  1.25280E+01  7.29170E-01
 4248.00  7.78485E-01  7.62841E-01  1.21475E+01  7.15114E-01
 4250.00  7.54858E-01  7.48707E-01  1.22944E+01  7.03361E-01
 4252.00  7.67445E-01  7.40264E-01  1.20687E+01  7.03006E-01
 4254.00  7.66819E-01  7.39439E-01  1.22882E+01  7.09679E-01
 4256.00  7.88490E-01  7.43362E-01  1.21640E+01  7.15656E-01
 4258.00  7.55976E-01  7.46213E-01  1.25310E+01  7.15230E-01
 4260.00  6.90207E-01  7.45852E-01  1.29587E+01  7.10262E-01
 4262.00  7.43429E-01  7.50410E-01  1.27486E+01  7.14841E-01
 4264.00  7.21523E-01  7.62685E-01  1.34171E+01  7.33548E-01
 4266.00  8.11015E-01  7.70322E-01  1.27140E+01  7.49333E-01
 4268.00  7.68240E-01  7.61713E-01  1.28589E+01  7.42679E-01
 4270.00  7.29515E-01  7.40396E-01  1.27268E+01  7.14212E-01
 4272.00  7.36684E-01  7.19814E-01  1.26117E+01  6.83472E-01
 4274.00  6.72617E-01  7.13687E-01  1.35307E+01  6.73240E-01
 4276.00  6.56485E-01  7.25289E-01  1.37180E+01  6.88294E-01
 4278.00  7.52346E-01  7.44833E-01 -1.20000E+01  7.12367E-01
 4280.00  7.20801E-01  7.57184E-01 -1.20000E+01  7.24268E-01
 4282.00  6.88513E-01  7.58364E-01 -1.20000E+01  7.21180E-01
 4284.00  8.03896E-01  7.53725E-01 -1.20000E+01  7.11474E-01
 4286.00  8.86124E-01  7.46105E-01 -1.20000E+01  6.97887E-01
 4288.00  8.08861E-01  7.34631E-01 -1.20000E+01  6.79412E-01
 4290.00  6.62269E-01  7.23175E-01 -1.20000E+01  6.63260E-01
 4292.00  6.94937E-01  7.20702E-01 -1.20000E+01  6.62435E-01
 4294.00  8.00276E-01  7.24687E-01 -1.20000E+01  6.70332E-01
 4296.00  7.75517E-01  7.23530E-01  1.36912E+01  6.67097E-01
 4298.00  7.54113E-01  7.10131E-01  1.39385E+01  6.42857E-01
 4300.00  7.31018E-01  6.90197E-01  1.42459E+01  6.09193E-01
 4302.00  6.50967E-01  6.76077E-01  1.44540E+01  5.86957E-01
 4304.00  6.22334E-01  6.71667E-01  1.45585E+01  5.82502E-01
 4306.00  6.53985E-01  6.70361E-01  1.45003E+01  5.84814E-01
 4308.00  6.02920E-01  6.68080E-01  1.51522E+01  5.85033E-01
 4310.00  5.97802E-01  6.71457E-01  1.55047E+01  5.90747E-01
 4312.00  6.75914E-01  6.85730E-01  1.50983E+01  6.10220E-01
 4314.00  6.97029E-01  7.08925E-01  1.49497E+01  6.42642E-01
 4316.00  7.20908E-01  7.36223E-01  1.50320E+01  6.84064E-01
 4318.00  8.06304E-01  7.57228E-01  1.45474E+01  7.20525E-01
 4320.00  8.13769E-01  7.60122E-01  1.47974E+01  7.32734E-01
 4322.00  8.17486E-01  7.41911E-01  1.43913E+01  7.14566E-01
 4324.00  7.19954E-01  7.10601E-01  1.45307E+01  6.78937E-01
 4326.00  6.52590E-01  6.84530E-01  1.47261E+01  6.52556E-01
 4328.00  6.76745E-01  6.78576E-01  1.47469E+01  6.54438E-01
 4330.00  8.08819E-01  6.83839E-01  0.00000E+00  6.71595E-01
 4332.00  7.18124E-01  6.80894E-01  0.00000E+00  6.80123E-01
 4334.00  6.53851E-01  6.58769E-01  0.00000E+00  6.67794E-01
 4336.00  6.01192E-01  6.13366E-01  0.00000E+00  6.29287E-01
 4338.00  7.07666E-01  5.49148E-01  0.00000E+00  5.66951E-01
 4340.00  7.82809E-01  4.92518E-01  0.00000E+00  5.09313E-01
 4342.00  7.20280E-01  4.78047E-01  0.00000E+00  4.95739E-01
 4344.00  7.22179E-01  5.12471E-01  0.00000E+00  5.32732E-01
 4346.00  7.22013E-01  5.71139E-01  0.00000E+00  5.90873E-01
 4348.00  6.48361E-01  6.24813E-01  0.00000E+00  6.37774E-01
 4350.00  7.21143E-01  6.58165E-01  0.00000E+00  6.58826E-01
 4352.00  7.70688E-01  6.74026E-01  1.37854E+01  6.61461E-01
 4354.00  7.33091E-01  6.89418E-01  1.41973E+01  6.69293E-01
 4356.00  7.87054E-01  7.12817E-01  1.40103E+01  6.90754E-01
 4358.00  7.60877E-01  7.37730E-01  1.47711E+01  7.14166E-01
 4360.00  7.06321E-01  7.57957E-01  1.48914E+01  7.31953E-01
 4362.00  7.39891E-01  7.75294E-01  1.49266E+01  7.48964E-01
 4364.00  7.51845E-01  7.89201E-01  1.51338E+01  7.64511E-01
 4366.00  8.06170E-01  7.94465E-01  1.52158E+01  7.69714E-01
 4368.00  7.65370E-01  7.89874E-01  1.56164E+01  7.61814E-01
 4370.00  7.52625E-01  7.82066E-01  1.58842E+01  7.50203E-01
 4372.00  7.39680E-01  7.74889E-01  1.56103E+01  7.40391E-01
 4374.00  7.51180E-01  7.68079E-01  1.59738E+01  7.31502E-01
 4376.00  7.66418E-01  7.66340E-01  1.66513E+01  7.30931E-01
 4378.00  7.96418E-01  7.71825E-01  1.66511E+01  7.42796E-01
 4380.00  7.51233E-01  7.72017E-01  1.69289E+01  7.49292E-01
 4382.00  7.36201E-01  7.54448E-01  1.70607E+01  7.31448E-01
 4384.00  7.43775E-01  7.28004E-01  1.71853E+01  6.99785E-01
 4386.00  7.36183E-01  7.16242E-01  1.72549E+01  6.87345E-01
 4388.00  6.96006E-01  7.25309E-01 -2.40000E+01  7.02143E-01
 4390.00  7.13624E-01  7.43354E-01 -2.40000E+01  7.24366E-01
 4392.00  7.94111E-01  7.60119E-01 -2.40000E+01  7.39230E-01
 4394.00  8.56917E-01  7.73041E-01 -2.40000E+01  7.46630E-01
 4396.00  8.78182E-01  7.84120E-01 -2.40000E+01  7.52578E-01
 4398.00  8.79789E-01  7.92632E-01 -2.40000E+01  7.57640E-01
 4400.00  8.56104E-01  7.93201E-01 -2.40000E+01  7.56581E-01
 4402.00  8.14906E-01  7.85300E-01  1.29682E+01  7.51512E-01
 4404.00  8.23892E-01  7.73174E-01  1.77090E+01  7.45796E-01
 4406.00  8.08778E-01  7.66036E-01  1.82544E+01  7.43372E-01
 4408.00  7.68127E-01  7.71937E-01  1.86702E+01  7.49271E-01
 4410.00  8.08400E-01  7.88748E-01  1.85748E+01  7.65129E-01
 4412.00  8.24903E-01  8.03019E-01  1.81440E+01  7.81257E-01
 4414.00  7.89319E-01  8.02378E-01  1.84858E+01  7.82746E-01
 4416.00  7.89742E-01  7.92920E-01  1.85031E+01  7.72555E-01
 4418.00  7.91510E-01  7.91716E-01  1.86752E+01  7.70229E-01
 4420.00  8.05602E-01  8.00875E-01  1.88928E+01  7.80917E-01
 4422.00  8.12423E-01  8.08061E-01  1.85553E+01  7.90592E-01
 4424.00  7.78579E-01  8.08588E-01  1.88531E+01  7.92807E-01
 4426.00  7.51888E-01  8.07291E-01  1.88173E+01  7.92285E-01
 4428.00  7.69012E-01  8.07480E-01  1.85026E+01  7.91696E-01
 4430.00  7.63002E-01  8.07420E-01  1.84129E+01  7.88852E-01
 4432.00  7.49997E-01  8.04543E-01  1.80967E+01  7.82749E-01
 4434.00  8.38553E-01  7.98984E-01  1.72191E+01  7.75830E-01
 4436.00  8.35919E-01  7.97513E-01  1.63769E+01  7.76968E-01
 4438.00  7.68241E-01  8.05224E-01  1.67401E+01  7.89975E-01
 4440.00  7.95976E-01  8.13538E-01  1.70323E+01  7.99542E-01
 4442.00  8.21095E-01  8.13430E-01  1.64939E+01  7.92824E-01
 4444.00  8.21621E-01  8.12066E-01  1.66464E+01  7.83080E-01
 4446.00  8.05215E-01  8.18799E-01  1.68781E+01  7.87974E-01
 4448.00  8.09364E-01  8.28511E-01  1.71606E+01  8.01307E-01
 4450.00  7.74854E-01  8.31531E-01  1.72459E+01  8.07252E-01
 4452.00  8.13782E-01  8.24632E-01  1.77039E+01  8.00313E-01
 4454.00  9.05911E-01  8.10196E-01  1.75354E+01  7.83570E-01
 4456.00  8.53544E-01  7.94703E-01  1.79742E+01  7.65276E-01
 4458.00  7.91809E-01  7.84611E-01  1.74732E+01  7.53968E-01
 4460.00  8.11756E-01  7.81308E-01  1.76889E+01  7.50903E-01
 4462.00  8.59398E-01  7.84489E-01  1.75635E+01  7.54838E-01
 4464.00  8.64021E-01  7.93160E-01  1.78224E+01  7.65014E-01
 4466.00  8.39099E-01  8.00988E-01  1.72523E+01  7.74969E-01
 4468.00  8.09293E-01  8.02050E-01  1.75939E+01  7.79185E-01
 4470.00  8.24708E-01  7.99735E-01  1.78334E+01  7.83656E-01
 4472.00  8.76257E-01  8.04490E-01  1.82194E+01  7.98445E-01
 4474.00  9.02367E-01  8.19950E-01  1.80867E+01  8.21200E-01
 4476.00  9.35011E-01  8.36835E-01  1.74389E+01  8.38400E-01
 4478.00  9.33054E-01  8.41681E-01  1.77700E+01  8.38444E-01
 4480.00  8.99661E-01  8.30150E-01  1.82116E+01  8.21075E-01
 4482.00  8.25276E-01  8.17582E-01  1.85257E+01  8.04339E-01
 4484.00  7.98216E-01  8.22059E-01  1.90109E+01  8.07055E-01
 4486.00  8.48882E-01  8.37417E-01  1.91709E+01  8.21969E-01
 4488.00  8.56958E-01  8.44323E-01  1.92478E+01  8.27820E-01
 4490.00  8.20768E-01  8.39557E-01  1.92535E+01  8.21392E-01
 4492.00  8.07887E-01  8.34012E-01  1.89588E+01  8.15514E-01
 4494.00  7.91586E-01  8.32206E-01  1.92639E+01  8.14729E-01
 4496.00  8.43893E-01  8.34165E-01  1.82352E+01  8.17813E-01
 4498.00  8.68796E-01  8.41539E-01  1.83481E+01  8.26329E-01
 4500.00  8.55647E-01  8.52743E-01  1.86410E+01  8.38972E-01
 4502.00  8.46675E-01  8.65045E-01  1.88882E+01  8.53503E-01
 4504.00  8.43590E-01  8.77766E-01  1.92640E+01  8.69467E-01
 4506.00  8.53038E-01  8.86569E-01  1.90813E+01  8.80820E-01
 4508.00  8.68926E-01  8.87831E-01  1.90736E+01  8.82875E-01
 4510.00  8.70737E-01  8.83755E-01  1.92403E+01  8.79302E-01
 4512.00  8.59765E-01  8.76802E-01  1.91521E+01  8.72906E-01
 4514.00  9.01509E-01  8.68434E-01  1.88760E+01  8.62927E-01
 4516.00  9.12451E-01  8.62201E-01  1.90784E+01  8.52333E-01
 4518.00  8.57916E-01  8.60270E-01  1.94459E+01  8.45750E-01
 4520.00  8.59517E-01  8.60202E-01  1.94478E+01  8.42797E-01
 4522.00  9.01647E-01  8.56420E-01  1.93797E+01  8.37482E-01
 4524.00  9.04180E-01  8.45165E-01  1.90027E+01  8.25329E-01
 4526.00  8.44353E-01  8.27865E-01  1.96356E+01  8.07681E-01
 4528.00  7.77155E-01  8.11004E-01  2.04999E+01  7.90623E-01
 4530.00  7.63738E-01  8.02080E-01  2.02502E+01  7.81262E-01
 4532.00  7.83119E-01  8.02647E-01  1.98910E+01  7.80777E-01
 4534.00  8.35933E-01  8.09355E-01  1.95613E+01  7.86169E-01
 4536.00  8.75051E-01  8.22083E-01  1.99724E+01  8.00004E-01
 4538.00  8.71703E-01  8.39052E-01  2.05191E+01  8.21655E-01
 4540.00  8.46841E-01  8.51357E-01  2.09266E+01  8.38925E-01
 4542.00  8.32524E-01  8.54699E-01  2.07286E+01  8.44165E-01
 4544.00  8.40239E-01  8.52493E-01  2.02149E+01  8.40648E-01
 4546.00  8.48360E-01  8.47353E-01  2.01655E+01  8.32354E-01
 4548.00  8.50557E-01  8.39963E-01  1.99474E+01  8.20748E-01
 4550.00  8.00387E-01  8.33186E-01  2.06962E+01  8.09806E-01
 4552.00  7.64855E-01  8.30238E-01  2.12122E+01  8.04308E-01
 4554.00  8.17256E-01  8.31219E-01  2.05646E+01  8.04418E-01
 4556.00  8.74348E-01  8.37582E-01  2.00344E+01  8.12356E-01
 4558.00  8.93762E-01  8.50170E-01  2.07407E+01  8.29518E-01
 4560.00  9.37799E-01  8.63396E-01  2.02883E+01  8.47337E-01
 4562.00  9.09784E-01  8.69433E-01  2.05821E+01  8.54234E-01
 4564.00  8.49982E-01  8.67519E-01  2.07991E+01  8.50285E-01
 4566.00  7.99426E-01  8.65695E-01  2.14669E+01  8.48006E-01
 4568.00  8.19655E-01  8.68763E-01  2.12576E+01  8.53580E-01
 4570.00  8.61789E-01  8.71747E-01  2.16195E+01  8.59009E-01
 4572.00  9.18765E-01  8.71172E-01  2.13260E+01  8.59246E-01
 4574.00  9.35957E-01  8.70738E-01  2.13445E+01  8.59976E-01
 4576.00  9.20255E-01  8.70796E-01  2.11099E+01  8.61779E-01
 4578.00  8.85145E-01  8.66554E-01  2.14758E+01  8.57421E-01
 4580.00  8.79880E-01  8.56853E-01  2.15663E+01  8.44184E-01
 4582.00  8.44728E-01  8.47545E-01  2.07530E+01  8.29583E-01
 4584.00  8.60978E-01  8.44173E-01  2.10682E+01  8.22909E-01
 4586.00  9.27377E-01  8.47782E-01  1.99106E+01  8.27563E-01
 4588.00  8.82008E-01  8.55586E-01  2.06785E+01  8.38667E-01
 4590.00  8.27172E-01  8.61877E-01  2.16569E+01  8.46619E-01
 4592.00  8.68855E-01  8.62319E-01  2.06965E+01  8.46435E-01
 4594.00  8.33297E-01  8.58976E-01  2.18892E+01  8.42826E-01
 4596.00  8.57238E-01  8.56717E-01  2.11157E+01  8.42176E-01
 4598.00  8.57768E-01  8.56966E-01  2.17354E+01  8.44818E-01
 4600.00  8.62126E-01  8.57563E-01  2.10381E+01  8.47309E-01
 4602.00  9.17491E-01  8.58001E-01  2.14088E+01  8.49156E-01
 4604.00  8.79934E-01  8.60906E-01  2.22223E+01  8.53205E-01
 4606.00  8.41524E-01  8.69154E-01  2.25574E+01  8.61959E-01
 4608.00  8.51173E-01  8.81943E-01  2.21949E+01  8.74764E-01
 4610.00  8.96150E-01  8.92664E-01  2.18347E+01  8.85699E-01
 4612.00  8.93723E-01  8.95458E-01  2.15853E+01  8.88895E-01
 4614.00  9.19166E-01  8.92431E-01  2.21301E+01  8.85879E-01
 4616.00  9.40867E-01  8.88866E-01  2.14935E+01  8.81900E-01
 4618.00  9.19967E-01  8.86384E-01  2.23169E+01  8.79670E-01
 4620.00  8.92986E-01  8.85401E-01  2.25974E+01  8.80549E-01
 4622.00  8.85638E-01  8.87088E-01  2.24314E+01  8.84972E-01
 4624.00  8.76703E-01  8.89730E-01  2.27804E+01  8.89192E-01
 4626.00  8.89500E-01  8.90243E-01  2.20766E+01  8.88905E-01
 4628.00  9.36128E-01  8.88870E-01  2.19323E+01  8.84811E-01
 4630.00  9.63803E-01  8.87518E-01  2.24385E+01  8.80876E-01
 4632.00  9.18671E-01  8.85666E-01  2.26851E+01  8.78335E-01
 4634.00  8.71145E-01  8.81024E-01  2.30401E+01  8.74381E-01
 4636.00  8.52418E-01  8.73937E-01  2.32508E+01  8.68462E-01
 4638.00  8.52797E-01  8.67584E-01  2.33064E+01  8.64040E-01
 4640.00  8.74692E-01  8.65366E-01  2.29645E+01  8.64605E-01
 4642.00  9.05972E-01  8.66536E-01  2.23593E+01  8.67968E-01
 4644.00  9.00860E-01  8.64858E-01  2.21851E+01  8.66353E-01
 4646.00  8.71866E-01  8.56780E-01  2.24067E+01  8.56809E-01
 4648.00  8.60783E-01  8.48844E-01  2.29817E+01  8.48251E-01
 4650.00  8.33809E-01  8.49976E-01  2.34435E+01  8.50072E-01
 4652.00  8.50718E-01  8.59004E-01  2.29096E+01  8.58445E-01
 4654.00  9.00160E-01  8.67559E-01  2.23889E+01  8.63707E-01
 4656.00  9.01056E-01  8.73329E-01  2.25250E+01  8.66505E-01
 4658.00  8.71393E-01  8.81029E-01  2.27307E+01  8.74995E-01
 4660.00  8.54502E-01  8.89404E-01  2.36706E+01  8.86844E-01
 4662.00  8.82995E-01  8.89454E-01  2.37808E+01  8.88685E-01
 4664.00  9.07909E-01  8.77228E-01  2.30265E+01  8.73799E-01
 4666.00  8.50999E-01  8.58714E-01  2.39405E+01  8.48964E-01
 4668.00  8.27465E-01  8.45190E-01  2.41865E+01  8.28941E-01
 4670.00  8.67374E-01  8.45497E-01  2.40457E+01  8.26877E-01
 4672.00  8.74149E-01  8.57056E-01  2.27014E+01  8.41983E-01
 4674.00  8.42960E-01  8.69592E-01  2.22949E+01  8.61374E-01
 4676.00  8.45461E-01  8.76740E-01  2.27465E+01  8.73931E-01
 4678.00  8.66190E-01  8.77559E-01  2.30171E+01  8.75691E-01
 4680.00  8.74678E-01  8.74192E-01  2.36280E+01  8.69947E-01
 4682.00  9.12490E-01  8.71841E-01  2.31981E+01  8.65750E-01
 4684.00  9.19704E-01  8.74028E-01  2.35493E+01  8.68787E-01
 4686.00  8.99487E-01  8.78249E-01  2.38528E+01  8.75183E-01
 4688.00  9.15948E-01  8.80371E-01  2.39067E+01  8.78812E-01
 4690.00  9.06470E-01  8.79985E-01  2.43988E+01  8.79467E-01
 4692.00  8.76691E-01  8.79619E-01  2.38969E+01  8.81319E-01
 4694.00  8.57129E-01  8.80795E-01  2.49517E+01  8.86248E-01
 4696.00  8.74367E-01  8.81056E-01  2.34681E+01  8.89623E-01
 4698.00  8.47736E-01  8.76504E-01  2.42904E+01  8.85000E-01
 4700.00  8.18360E-01  8.68048E-01  2.41043E+01  8.73231E-01
 4702.00  8.33503E-01  8.60769E-01  2.43254E+01  8.61645E-01
 4704.00  8.39637E-01  8.57728E-01  2.48965E+01  8.55536E-01
 4706.00  8.51788E-01  8.57777E-01  2.45757E+01  8.54063E-01
 4708.00  8.46796E-01  8.59060E-01  2.51765E+01  8.54640E-01
 4710.00  8.73023E-01  8.61771E-01  2.48996E+01  8.58497E-01
 4712.00  8.56455E-01  8.65516E-01  2.49726E+01  8.66421E-01
 4714.00  8.39763E-01  8.69629E-01  2.37516E+01  8.75160E-01
 4716.00  8.39658E-01  8.77322E-01  2.53995E+01  8.84109E-01
 4718.00  8.73271E-01  8.90856E-01  2.52011E+01  8.95403E-01
 4720.00  8.94599E-01  9.05365E-01  2.46926E+01  9.06785E-01
 4722.00  9.20928E-01  9.14392E-01  2.50266E+01  9.13480E-01
 4724.00  9.19050E-01  9.15643E-01  2.47999E+01  9.13211E-01
 4726.00  9.08215E-01  9.07861E-01  2.52297E+01  9.04569E-01
 4728.00  8.94816E-01  8.91912E-01  2.50963E+01  8.88822E-01
 4730.00  8.98279E-01  8.76187E-01  2.52756E+01  8.74496E-01
 4732.00  9.04432E-01  8.70289E-01  2.56352E+01  8.70421E-01
 4734.00  9.13695E-01  8.74213E-01  2.50638E+01  8.75748E-01
 4736.00  8.86870E-01  8.81053E-01  2.53742E+01  8.83312E-01
 4738.00  8.56049E-01  8.86899E-01  2.58267E+01  8.89251E-01
 4740.00  8.95790E-01  8.92227E-01  2.55102E+01  8.94218E-01
 4742.00  9.26837E-01  8.97571E-01  2.46166E+01  8.99347E-01
 4744.00  9.29975E-01  9.02690E-01  2.50834E+01  9.04987E-01
 4746.00  9.53310E-01  9.07584E-01  2.51537E+01  9.10767E-01
 4748.00  9.60310E-01  9.11658E-01  2.47352E+01  9.15291E-01
 4750.00  9.92604E-01  9.12943E-01  2.39758E+01  9.16484E-01
 4752.00  9.98484E-01  9.09993E-01  2.44840E+01  9.12816E-01
 4754.00  9.55331E-01  9.04489E-01  2.51097E+01  9.05486E-01
 4756.00  9.34145E-01  8.99988E-01  2.47403E+01  8.98611E-01
 4758.00  9.33305E-01  8.97680E-01  2.49527E+01  8.94674E-01
 4760.00  9.39484E-01  8.94745E-01  2.57306E+01  8.90252E-01
 4762.00  9.49553E-01  8.87995E-01  2.55302E+01  8.80416E-01
 4764.00  9.22272E-01  8.78969E-01  2.57881E+01  8.67809E-01
 4766.00  8.98702E-01  8.73762E-01  2.60632E+01  8.61817E-01
 4768.00  8.89453E-01  8.76681E-01  2.60571E+01  8.67399E-01
 4770.00  8.92615E-01  8.85517E-01  2.64253E+01  8.79731E-01
 4772.00  9.02913E-01  8.95155E-01  2.67451E+01  8.91842E-01
 4774.00  9.09746E-01  9.03539E-01  2.65989E+01  9.02199E-01
 4776.00  9.18694E-01  9.10482E-01  2.69850E+01  9.11059E-01
 4778.00  9.31142E-01  9.14100E-01  2.68968E+01  9.15583E-01
 4780.00  9.47717E-01  9.12587E-01  2.65160E+01  9.13518E-01
 4782.00  9.22864E-01  9.06704E-01  2.68932E+01  9.06537E-01
 4784.00  8.84439E-01  8.99148E-01  2.72143E+01  8.97877E-01
 4786.00  8.69923E-01  8.92846E-01  2.74747E+01  8.90087E-01
 4788.00  8.73300E-01  8.90125E-01  2.73729E+01  8.85842E-01
 4790.00  8.92821E-01  8.92839E-01  2.76613E+01  8.88279E-01
 4792.00  9.16665E-01  9.01673E-01  2.74134E+01  8.98525E-01
 4794.00  9.10012E-01  9.13493E-01  2.76552E+01  9.12179E-01
 4796.00  9.12368E-01  9.21071E-01  2.75005E+01  9.20424E-01
 4798.00  9.02992E-01  9.19795E-01  2.76613E+01  9.18655E-01
 4800.00  8.59461E-01  9.13731E-01  2.79651E+01  9.12322E-01
 4802.00  8.46519E-01  9.09878E-01  2.81385E+01  9.08753E-01
 4804.00  8.86882E-01  9.08626E-01  2.78587E+01  9.07041E-01
 4806.00  8.88725E-01  9.06287E-01  2.78040E+01  9.03179E-01
 4808.00  8.59168E-01  9.03382E-01  2.84213E+01  8.98958E-01
 4810.00  8.57920E-01  9.03544E-01  2.80215E+01  8.98681E-01
 4812.00  8.72617E-01  9.07399E-01  2.72887E+01  9.03032E-01
 4814.00  8.99188E-01  9.12672E-01  2.75558E+01  9.10131E-01
 4816.00  8.96371E-01  9.17800E-01  2.77047E+01  9.18006E-01
 4818.00  8.84900E-01  9.21491E-01  2.76831E+01  9.23806E-01
 4820.00  8.87910E-01  9.20674E-01  2.79016E+01  9.23340E-01
 4822.00  9.31496E-01  9.13268E-01  2.71021E+01  9.14669E-01
 4824.00  9.15452E-01  9.02988E-01  2.67882E+01  9.02714E-01
 4826.00  8.98293E-01  8.96593E-01  2.76382E+01  8.95597E-01
 4828.00  8.74045E-01  8.95359E-01  2.77133E+01  8.94513E-01
 4830.00  8.75309E-01  8.95022E-01  2.70876E+01  8.94075E-01
 4832.00  8.48465E-01  8.93388E-01  2.79481E+01  8.92136E-01
 4834.00  8.39126E-01  8.91551E-01  2.85870E+01  8.90855E-01
 4836.00  8.80628E-01  8.88916E-01  2.75890E+01  8.89880E-01
 4838.00  8.65683E-01  8.82805E-01  2.81949E+01  8.85837E-01
 4840.00  8.35464E-01  8.73387E-01  2.86302E+01  8.78356E-01
 4842.00  8.41124E-01  8.64622E-01  2.80002E+01  8.71550E-01
 4844.00  8.54553E-01  8.58978E-01  2.70755E+01  8.68099E-01
 4846.00  8.13374E-01  8.54044E-01  2.80723E+01  8.65174E-01
 4848.00  7.83326E-01  8.45556E-01  0.00000E+00  8.58465E-01
 4850.00  8.26329E-01  8.31385E-01  0.00000E+00  8.47308E-01
 4852.00  8.76069E-01  8.10262E-01  0.00000E+00  8.31623E-01
 4854.00  8.45384E-01  7.79643E-01  0.00000E+00  8.07711E-01
 4856.00  8.00017E-01  7.38369E-01  0.00000E+00  7.72044E-01
 4858.00  8.20970E-01  6.89051E-01  0.00000E+00  7.24957E-01
 4860.00  9.33753E-01  6.40577E-01  0.00000E+00  6.74392E-01
 4862.00  1.03048E+00  6.11570E-01  0.00000E+00  6.42298E-01
 4864.00  1.00690E+00  6.18921E-01  0.00000E+00  6.50603E-01
 4866.00  8.76447E-01  6.57560E-01  0.00000E+00  6.93318E-01
 4868.00  7.73455E-01  7.03903E-01  0.00000E+00  7.40838E-01
 4870.00  7.70877E-01  7.39610E-01  0.00000E+00  7.71641E-01
 4872.00  7.87219E-01  7.64151E-01  0.00000E+00  7.87394E-01
 4874.00  7.94027E-01  7.86950E-01  0.00000E+00  8.01300E-01
 4876.00  7.98444E-01  8.13280E-01  2.76743E+01  8.20580E-01
 4878.00  8.16135E-01  8.39896E-01  2.79684E+01  8.42032E-01
 4880.00  8.44533E-01  8.60390E-01  2.69099E+01  8.58760E-01
 4882.00  8.32268E-01  8.70208E-01  2.68766E+01  8.65833E-01
 4884.00  8.20375E-01  8.69498E-01  2.73839E+01  8.63667E-01
 4886.00  8.32122E-01  8.62962E-01  2.72832E+01  8.57649E-01
 4888.00  8.41905E-01  8.56298E-01  2.71918E+01  8.53176E-01
 4890.00  8.54803E-01  8.54841E-01  2.67187E+01  8.54496E-01
 4892.00  8.73899E-01  8.64466E-01  2.65386E+01  8.66882E-01
 4894.00  9.01944E-01  8.87363E-01  2.58421E+01  8.91993E-01
 4896.00  9.17160E-01  9.14525E-01  2.54553E+01  9.19629E-01
 4898.00  9.23225E-01  9.31622E-01  2.57166E+01  9.34788E-01
 4900.00  9.29577E-01  9.34291E-01  2.50074E+01  9.34060E-01
 4902.00  9.07490E-01  9.29954E-01  2.52929E+01  9.27083E-01
 4904.00  8.73260E-01  9.26786E-01  2.61065E+01  9.23813E-01
 4906.00  8.51220E-01  9.25675E-01  2.71554E+01  9.24430E-01
 4908.00  8.52166E-01  9.22497E-01  2.72579E+01  9.22180E-01
 4910.00  8.78804E-01  9.16201E-01  2.74295E+01  9.14806E-01
 4912.00  9.18549E-01  9.12126E-01  2.79300E+01  9.09969E-01
 4914.00  9.15489E-01  9.12547E-01  2.78847E+01  9.12282E-01
 4916.00  8.96539E-01  9.09200E-01  2.83603E+01  9.12228E-01
 4918.00  8.58676E-01  8.92711E-01  2.87320E+01  8.98198E-01
 4920.00  8.01403E-01  8.68210E-01  2.93827E+01  8.75177E-01
 4922.00  8.02988E-01  8.53643E-01  3.04685E+01  8.61582E-01
 4924.00  8.40191E-01  8.60646E-01  2.93174E+01  8.68195E-01
 4926.00  8.64844E-01  8.84862E-01  2.94672E+01  8.90327E-01
 4928.00  8.72325E-01  9.13243E-01  3.01116E+01  9.16138E-01
 4930.00  8.95770E-01  9.32553E-01  2.98204E+01  9.32968E-01
 4932.00  9.02143E-01  9.35991E-01  3.01262E+01  9.33366E-01
 4934.00  8.86668E-01  9.26614E-01  2.98578E+01  9.20793E-01
 4936.00  9.21325E-01  9.13025E-01  2.99791E+01  9.06342E-01
 4938.00  9.07492E-01  9.02917E-01  3.13095E+01  8.99064E-01
 4940.00  8.89916E-01  9.02432E-01  0.00000E+00  9.03392E-01
 4942.00  9.05677E-01  9.13919E-01  0.00000E+00  9.19137E-01
 4944.00  9.22081E-01  9.30872E-01  0.00000E+00  9.38255E-01
 4946.00  9.55682E-01  9.44079E-01  0.00000E+00  9.52173E-01
 4948.00  9.26328E-01  9.50929E-01  0.00000E+00  9.60113E-01
 4950.00  8.93011E-01  9.53246E-01  0.00000E+00  9.63851E-01
 4952.00  9.21432E-01  9.50217E-01  0.00000E+00  9.60780E-01
 4954.00  9.14312E-01  9.38597E-01  0.00000E+00  9.47176E-01
 4956.00  9.17653E-01  9.19818E-01  0.00000E+00  9.25755E-01
 4958.00  9.10348E-01  9.04639E-01  0.00000E+00  9.08599E-01
 4960.00  9.41157E-01  9.04156E-01  0.00000E+00  9.07522E-01
 4962.00  9.70889E-01  9.14575E-01  0.00000E+00  9.18475E-01
 4964.00  9.46106E-01  9.21554E-01  0.00000E+00  9.26071E-01
 4966.00  9.19249E-01  9.19211E-01  0.00000E+00  9.23622E-01
 4968.00  8.96883E-01  9.14037E-01  0.00000E+00  9.17812E-01
 4970.00  8.87261E-01  9.13976E-01  0.00000E+00  9.17637E-01
 4972.00  9.07662E-01  9.20037E-01  0.00000E+00  9.24977E-01
 4974.00  9.26064E-01  9.26814E-01  0.00000E+00  9.34289E-01
 4976.00  9.22440E-01  9.27317E-01  0.00000E+00  9.37085E-01
 4978.00  8.94007E-01  9.18075E-01  0.00000E+00  9.27612E-01
 4980.00  8.80849E-01  9.01075E-01  0.00000E+00  9.06694E-01
 4982.00  8.50215E-01  8.82810E-01  0.00000E+00  8.82462E-01
 4984.00  8.12298E-01  8.72806E-01  0.00000E+00  8.68029E-01
 4986.00  7.97317E-01  8.77434E-01  0.00000E+00  8.71990E-01
 4988.00  8.31023E-01  8.92101E-01  0.00000E+00  8.88523E-01
 4990.00  8.77190E-01  9.05571E-01  0.00000E+00  9.03938E-01
 4992.00  8.87460E-01  9.12217E-01  0.00000E+00  9.12109E-01
 4994.00  8.79953E-01  9.14122E-01  0.00000E+00  9.15900E-01
 4996.00  8.77414E-01  9.13061E-01  0.00000E+00  9.17086E-01
 4998.00  8.66548E-01  9.06766E-01  0.00000E+00  9.12838E-01
 5000.00  8.56302E-01  8.93879E-01  0.00000E+00  9.01930E-01
 5002.00  8.48172E-01  8.78407E-01  0.00000E+00  8.88859E-01
 5004.00  8.78957E-01  8.66125E-01  0.00000E+00  8.78951E-01
 5006.00  9.53256E-01  8.60245E-01  0.00000E+00  8.74703E-01
 5008.00  1.02190E+00  8.61225E-01  0.00000E+00  8.76632E-01
 5010.00  1.02425E+00  8.64388E-01  0.00000E+00  8.79474E-01
 5012.00  9.56486E-01  8.62561E-01  0.00000E+00  8.74925E-01
 5014.00  8.99293E-01  8.55765E-01  0.00000E+00  8.63904E-01
 5016.00  8.60530E-01  8.50970E-01  0.00000E+00  8.55646E-01
 5018.00  8.34948E-01  8.52121E-01  0.00000E+00  8.55314E-01
 5020.00  8.35870E-01  8.57881E-01  0.00000E+00  8.62077E-01
 5022.00  8.29980E-01  8.65975E-01  0.00000E+00  8.73198E-01
 5024.00  8.28817E-01  8.75204E-01  0.00000E+00  8.85443E-01
 5026.00  8.59625E-01  8.84308E-01  0.00000E+00  8.95975E-01
 5028.00  8.79530E-01  8.92816E-01  0.00000E+00  9.04710E-01
 5030.00  8.74842E-01  9.02027E-01  3.25816E+01  9.14121E-01
 5032.00  9.00670E-01  9.10756E-01  3.15723E+01  9.22954E-01
 5034.00  8.94728E-01  9.13228E-01  3.16003E+01  9.24110E-01
 5036.00  8.58289E-01  9.04347E-01  3.27853E+01  9.12104E-01
 5038.00  8.56965E-01  8.86130E-01  3.30654E+01  8.90679E-01
 5040.00  8.48120E-01  8.67562E-01  3.29526E+01  8.70949E-01
 5042.00  8.41075E-01  8.61462E-01  3.27382E+01  8.66723E-01
 5044.00  8.69274E-01  8.73551E-01  3.14756E+01  8.83345E-01
 5046.00  9.04575E-01  8.92455E-01  3.10674E+01  9.07285E-01
 5048.00  8.86286E-01  9.01570E-01  3.14440E+01  9.19228E-01
 5050.00  8.85643E-01  8.98879E-01  3.03977E+01  9.16772E-01
 5052.00  8.82070E-01  8.95690E-01  3.11357E+01  9.13894E-01
 5054.00  8.85512E-01  9.00382E-01  3.06200E+01  9.21433E-01
 5056.00  9.00425E-01  9.11618E-01  3.08596E+01  9.36580E-01
 5058.00  9.17703E-01  9.24312E-01  3.01744E+01  9.50509E-01
 5060.00  9.24167E-01  9.33697E-01  2.90910E+01  9.57465E-01
 5062.00  9.17010E-01  9.35142E-01  2.98505E+01  9.54964E-01
 5064.00  9.11709E-01  9.26791E-01  2.96594E+01  9.43132E-01
 5066.00  9.12556E-01  9.13826E-01  2.89672E+01  9.28294E-01
 5068.00  9.03400E-01  9.03901E-01  2.90318E+01  9.18949E-01
 5070.00  9.25030E-01  8.99669E-01  2.83202E+01  9.17066E-01
 5072.00  9.68151E-01  8.98964E-01  2.82261E+01  9.18031E-01
 5074.00  9.88572E-01  8.99149E-01  2.85382E+01  9.17496E-01
 5076.00  9.37288E-01  8.97244E-01  2.97789E+01  9.12756E-01
 5078.00  8.61586E-01  8.90171E-01  2.91910E+01  9.02064E-01
 5080.00  8.15092E-01  8.79235E-01  3.12770E+01  8.88761E-01
 5082.00  8.26473E-01  8.72395E-01  3.18619E+01  8.83029E-01
 5084.00  8.73902E-01  8.75811E-01  3.17842E+01  8.90617E-01
 5086.00  9.15250E-01  8.87637E-01  3.08054E+01  9.06787E-01
 5088.00  9.25744E-01  9.01393E-01  2.96180E+01  9.23145E-01
 5090.00  9.09111E-01  9.12363E-01  3.11494E+01  9.35807E-01
 5092.00  9.23708E-01  9.18644E-01  3.06546E+01  9.44118E-01
 5094.00  9.55004E-01  9.18382E-01  3.06428E+01  9.45660E-01
 5096.00  9.38664E-01  9.09893E-01  3.06436E+01  9.37307E-01
 5098.00  8.99870E-01  8.96491E-01  3.18671E+01  9.22526E-01
 5100.00  8.79768E-01  8.86923E-01  3.17720E+01  9.12272E-01
 5102.00  8.70222E-01  8.86659E-01  3.20327E+01  9.12732E-01
 5104.00  8.66049E-01  8.91335E-01  3.24116E+01  9.17384E-01
 5106.00  8.66208E-01  8.93526E-01  3.24325E+01  9.17370E-01
 5108.00  8.87509E-01  8.91887E-01  3.15381E+01  9.12819E-01
 5110.00  9.07407E-01  8.91546E-01  3.02605E+01  9.11234E-01
 5112.00  9.10919E-01  8.97619E-01  2.99984E+01  9.18212E-01
 5114.00  9.18150E-01  9.09726E-01  3.05132E+01  9.31866E-01
 5116.00  9.41133E-01  9.22312E-01  3.11594E+01  9.45642E-01
 5118.00  9.55753E-01  9.28574E-01  3.10932E+01  9.52835E-01
 5120.00  9.37627E-01  9.23845E-01  3.23994E+01  9.48550E-01
 5122.00  9.09728E-01  9.08704E-01  3.26727E+01  9.33003E-01
 5124.00  8.91053E-01  8.89734E-01  3.20192E+01  9.13398E-01
 5126.00  8.65849E-01  8.75699E-01  3.28814E+01  8.99401E-01
 5128.00  8.54589E-01  8.71320E-01  3.27697E+01  8.95178E-01
 5130.00  8.76341E-01  8.76068E-01  3.19278E+01  8.99300E-01
 5132.00  8.96271E-01  8.86038E-01  3.16963E+01  9.08314E-01
 5134.00  8.92859E-01  8.95291E-01  3.16391E+01  9.17331E-01
 5136.00  9.01434E-01  8.98409E-01  3.09913E+01  9.20690E-01
 5138.00  9.02773E-01  8.93660E-01  3.09971E+01  9.15806E-01
 5140.00  8.70637E-01  8.85150E-01  3.16910E+01  9.06967E-01
 5142.00  8.51987E-01  8.77930E-01  3.19440E+01  9.00122E-01
 5144.00  8.64016E-01  8.73723E-01  3.05422E+01  8.97805E-01
 5146.00  8.63853E-01  8.71468E-01  3.08280E+01  8.98598E-01
 5148.00  8.70561E-01  8.70296E-01  3.00562E+01  9.00174E-01
 5150.00  8.99766E-01  8.70503E-01  2.91290E+01  9.01268E-01
 5152.00  8.97841E-01  8.72724E-01  2.95339E+01  9.02281E-01
 5154.00  8.69443E-01  8.78527E-01  2.98110E+01  9.07048E-01
 5156.00  8.57873E-01  8.89243E-01  3.12201E+01  9.18962E-01
 5158.00  8.80432E-01  9.01761E-01  3.11158E+01  9.34281E-01
 5160.00  8.94468E-01  9.07898E-01  3.14119E+01  9.42937E-01
 5162.00  8.83975E-01  8.99625E-01  3.11678E+01  9.35338E-01
 5164.00  8.63591E-01  8.74008E-01  3.10016E+01  9.07190E-01
 5166.00  8.17246E-01  8.35727E-01  3.11905E+01  8.62181E-01
 5168.00  7.81175E-01  7.98338E-01  3.29242E+01  8.16140E-01
 5170.00  7.75413E-01  7.76415E-01  3.21739E+01  7.88390E-01
 5172.00  7.61355E-01  7.74297E-01  3.45685E+01  7.85521E-01
 5174.00  7.85929E-01  7.91295E-01  3.46658E+01  8.06638E-01
 5176.00  8.13639E-01  8.20772E-01  3.47609E+01  8.42931E-01
 5178.00  8.22440E-01  8.46414E-01  3.41630E+01  8.74761E-01
 5180.00  8.27533E-01  8.52388E-01  3.45403E+01  8.83454E-01
 5182.00  8.35236E-01  8.38012E-01  3.54243E+01  8.67013E-01
 5184.00  8.11723E-01  8.21965E-01  3.54303E+01  8.45379E-01
 5186.00  7.85244E-01  8.25018E-01  3.61984E+01  8.42871E-01
 5188.00  8.22327E-01  8.45355E-01  3.39893E+01  8.59146E-01
 5190.00  8.75024E-01  8.64709E-01  3.49415E+01  8.75830E-01
 5192.00  8.56490E-01  8.71442E-01  3.42957E+01  8.80781E-01
 5194.00  8.39739E-01  8.71703E-01  3.34798E+01  8.79919E-01
 5196.00  8.62138E-01  8.76081E-01  3.46805E+01  8.83408E-01
 5198.00  8.85639E-01  8.86598E-01  3.39643E+01  8.93682E-01
 5200.00  9.33490E-01  8.95842E-01  3.24100E+01  9.04418E-01
 5202.00  9.67641E-01  8.94552E-01  3.16351E+01  9.06429E-01
 5204.00  9.19010E-01  8.79873E-01  3.19282E+01  8.95842E-01
 5206.00  8.31987E-01  8.59289E-01  3.36340E+01  8.79127E-01
 5208.00  7.94360E-01  8.46489E-01  3.39113E+01  8.69353E-01
 5210.00  8.10896E-01  8.50928E-01  3.29932E+01  8.75118E-01
 5212.00  8.44722E-01  8.70268E-01  3.28701E+01  8.93297E-01
 5214.00  8.74364E-01  8.92308E-01  3.08646E+01  9.11809E-01
 5216.00  8.75503E-01  9.07710E-01  3.17423E+01  9.22596E-01
 5218.00  8.95510E-01  9.17446E-01  3.10563E+01  9.28926E-01
 5220.00  9.11735E-01  9.23331E-01  2.98296E+01  9.34159E-01
 5222.00  9.14738E-01  9.20920E-01  3.05422E+01  9.33105E-01
 5224.00  9.28200E-01  9.06446E-01  3.12276E+01  9.19367E-01
 5226.00  9.08103E-01  8.86680E-01  3.20337E+01  8.98451E-01
 5228.00  9.01325E-01  8.76837E-01  3.27116E+01  8.87123E-01
 5230.00  9.32518E-01  8.83272E-01  3.11813E+01  8.93017E-01
 5232.00  9.50367E-01  8.96843E-01  3.12446E+01  9.06398E-01
 5234.00  9.39007E-01  9.08557E-01  3.17843E+01  9.17291E-01
 5236.00  9.15424E-01  9.19501E-01  3.19696E+01  9.27329E-01
 5238.00  9.11227E-01  9.32198E-01  3.28731E+01  9.39892E-01
 5240.00  9.19466E-01  9.44234E-01  3.32947E+01  9.52402E-01
 5242.00  9.11880E-01  9.51519E-01  3.29016E+01  9.60101E-01
 5244.00  9.08149E-01  9.52195E-01  3.32012E+01  9.60405E-01
 5246.00  9.32544E-01  9.46142E-01  3.34072E+01  9.52675E-01
 5248.00  9.42731E-01  9.35945E-01  3.29824E+01  9.39735E-01
 5250.00  9.29426E-01  9.26812E-01  3.29628E+01  9.28146E-01
 5252.00  9.18615E-01  9.23086E-01  3.35146E+01  9.23939E-01
 5254.00  9.10535E-01  9.25939E-01  3.32915E+01  9.28405E-01
 5256.00  8.97569E-01  9.33843E-01  3.21963E+01  9.38773E-01
 5258.00  8.93125E-01  9.41018E-01  3.02909E+01  9.48093E-01
 5260.00  8.87461E-01  9.36760E-01  2.89784E+01  9.44789E-01
 5262.00  8.56280E-01  9.15065E-01  2.89258E+01  9.22611E-01
 5264.00  8.32388E-01  8.82185E-01  2.83315E+01  8.89274E-01
 5266.00  8.44403E-01  8.51889E-01  2.74747E+01  8.60537E-01
 5268.00  8.67471E-01  8.34314E-01  2.74711E+01  8.46353E-01
 5270.00  8.82671E-01  8.32325E-01  2.76828E+01  8.46785E-01
 5272.00  8.74140E-01  8.47050E-01  2.82556E+01  8.60999E-01
 5274.00  8.88265E-01  8.72767E-01  2.86971E+01  8.83201E-01
 5276.00  9.04018E-01  9.00955E-01  2.83127E+01  9.07301E-01
 5278.00  8.80610E-01  9.24501E-01  2.99024E+01  9.28761E-01
 5280.00  8.69616E-01  9.37266E-01  2.95848E+01  9.41592E-01
 5282.00  8.87496E-01  9.40275E-01  2.81557E+01  9.45339E-01
 5284.00  9.01830E-01  9.43256E-01  2.91299E+01  9.48529E-01
 5286.00  9.31309E-01  9.55094E-01  2.89148E+01  9.60008E-01
 5288.00  9.76796E-01  9.72490E-01  2.91168E+01  9.76928E-01
 5290.00  1.00430E+00  9.85841E-01  2.84178E+01  9.90296E-01
 5292.00  1.00331E+00  9.87891E-01  2.90934E+01  9.93228E-01
 5294.00  9.81953E-01  9.76981E-01  2.93917E+01  9.84242E-01
 5296.00  9.53209E-01  9.57226E-01  3.04137E+01  9.66651E-01
 5298.00  9.42295E-01  9.38910E-01  3.07493E+01  9.49217E-01
 5300.00  9.67229E-01  9.33853E-01  3.08009E+01  9.42799E-01
 5302.00  9.83176E-01  9.43969E-01  3.16989E+01  9.49831E-01
 5304.00  9.63091E-01  9.62417E-01  3.20469E+01  9.65352E-01
 5306.00  9.41356E-01  9.79411E-01  3.32883E+01  9.80706E-01
 5308.00  9.43248E-01  9.89839E-01  3.31746E+01  9.90906E-01
 5310.00  9.62061E-01  9.94092E-01  3.37067E+01  9.95771E-01
 5312.00  9.62804E-01  9.92927E-01  3.36715E+01  9.95188E-01
 5314.00  9.55555E-01  9.86922E-01  3.30763E+01  9.89363E-01
 5316.00  9.49191E-01  9.78155E-01  3.42025E+01  9.80434E-01
 5318.00  9.46835E-01  9.70277E-01  3.35905E+01  9.72862E-01
 5320.00  9.65100E-01  9.64329E-01  3.31268E+01  9.67977E-01
 5322.00  9.79544E-01  9.56083E-01  3.17327E+01  9.61359E-01
 5324.00  9.51023E-01  9.39994E-01  3.19103E+01  9.47839E-01
 5326.00  8.96556E-01  9.16952E-01  3.30198E+01  9.28257E-01
 5328.00  8.85249E-01  8.95798E-01  3.16693E+01  9.10094E-01
 5330.00  9.12752E-01  8.91355E-01  3.07696E+01  9.06986E-01
 5332.00  9.32603E-01  9.07162E-01  3.10751E+01  9.21318E-01
 5334.00  9.28908E-01  9.32269E-01  3.13221E+01  9.42133E-01
 5336.00  9.34966E-01  9.52122E-01  3.14476E+01  9.56537E-01
 5338.00  9.57350E-01  9.58514E-01  3.10140E+01  9.59221E-01
 5340.00  9.60858E-01  9.54488E-01  3.10899E+01  9.54674E-01
 5342.00  9.53373E-01  9.50372E-01  3.10384E+01  9.52222E-01
 5344.00  9.52031E-01  9.50786E-01  3.12917E+01  9.55170E-01
 5346.00  9.72719E-01  9.52992E-01  3.14480E+01  9.59759E-01
 5348.00  9.72606E-01  9.55771E-01  3.15978E+01  9.63667E-01
 5350.00  9.35422E-01  9.62198E-01  3.18029E+01  9.69382E-01
 5352.00  9.21163E-01  9.75471E-01  3.30025E+01  9.80565E-01
 5354.00  9.75247E-01  9.92900E-01  3.21869E+01  9.95733E-01
 5356.00  1.04820E+00  1.00861E+00  3.12175E+01  1.00974E+00
 5358.00  1.07119E+00  1.01704E+00  3.15777E+01  1.01675E+00
 5360.00  1.04785E+00  1.01536E+00  3.26607E+01  1.01372E+00
 5362.00  1.02204E+00  1.00414E+00  3.26984E+01  1.00160E+00
 5364.00  1.00222E+00  9.86969E-01  3.20452E+01  9.85274E-01
 5366.00  9.57044E-01  9.67995E-01  2.92047E+01  9.69564E-01
 5368.00  9.21999E-01  9.49968E-01  2.34060E+01  9.56470E-01
 5370.00  9.50732E-01  9.35789E-01  1.94443E+01  9.47286E-01
 5372.00  9.89940E-01  9.33001E-01  1.99434E+01  9.47756E-01
 5374.00  1.00138E+00  9.45838E-01  2.35266E+01  9.60945E-01
 5376.00  1.00250E+00  9.66053E-01  2.78524E+01  9.79005E-01
 5378.00  1.00475E+00  9.82051E-01  3.03942E+01  9.91507E-01
 5380.00  9.86959E-01  9.87954E-01  3.14033E+01  9.93952E-01
 5382.00  9.56290E-01  9.85651E-01  3.19913E+01  9.90233E-01
 5384.00  9.45863E-01  9.81173E-01  3.17849E+01  9.86909E-01
 5386.00  9.43497E-01  9.77538E-01  3.12512E+01  9.85723E-01
 5388.00  9.32889E-01  9.72809E-01  3.19155E+01  9.83151E-01
 5390.00  9.28285E-01  9.64905E-01  3.13493E+01  9.76273E-01
 5392.00  9.21153E-01  9.54633E-01  3.06408E+01  9.66067E-01
 5394.00  9.17037E-01  9.44203E-01  3.15291E+01  9.55418E-01
 5396.00  9.24331E-01  9.35451E-01  3.09008E+01  9.46936E-01
 5398.00  9.31690E-01  9.31148E-01  3.17525E+01  9.43410E-01
 5400.00  9.46142E-01  9.31035E-01  3.31784E+01  9.44450E-01
 5402.00  9.50919E-01  9.29237E-01  3.33610E+01  9.44026E-01
 5404.00  9.37822E-01  9.20966E-01  3.30480E+01  9.37110E-01
 5406.00  9.07315E-01  9.10712E-01  3.40950E+01  9.27809E-01
 5408.00  8.87786E-01  9.08057E-01  3.55209E+01  9.24728E-01
 5410.00  9.17173E-01  9.16422E-01  3.53501E+01  9.30903E-01
 5412.00  9.59510E-01  9.34106E-01  3.56617E+01  9.45359E-01
 5414.00  9.71579E-01  9.54297E-01  3.52187E+01  9.61886E-01
 5416.00  9.69630E-01  9.71317E-01  3.45778E+01  9.75473E-01
 5418.00  9.82799E-01  9.81934E-01  3.41198E+01  9.83586E-01
 5420.00  1.00022E+00  9.84799E-01  3.36283E+01  9.85164E-01
 5422.00  1.00598E+00  9.82742E-01  3.38863E+01  9.82838E-01
 5424.00  9.77013E-01  9.77980E-01  3.27833E+01  9.78771E-01
 5426.00  9.53628E-01  9.72119E-01  3.49013E+01  9.75354E-01
 5428.00  9.82073E-01  9.63082E-01  3.30123E+01  9.70507E-01
 5430.00  9.79762E-01  9.50659E-01  3.25707E+01  9.62291E-01
 5432.00  9.54756E-01  9.40568E-01  3.28978E+01  9.54668E-01
 5434.00  9.50130E-01  9.37139E-01  3.39522E+01  9.51190E-01
 5436.00  9.48242E-01  9.45293E-01  3.34281E+01  9.57202E-01
 5438.00  9.43060E-01  9.64689E-01  3.33411E+01  9.73223E-01
 5440.00  9.66231E-01  9.86454E-01  3.25777E+01  9.91270E-01
 5442.00  1.00279E+00  9.98830E-01  3.05506E+01  1.00106E+00
 5444.00  1.00328E+00  9.94842E-01  3.23522E+01  9.96405E-01
 5446.00  9.84142E-01  9.78844E-01  3.27056E+01  9.81172E-01
 5448.00  9.71509E-01  9.65055E-01  3.20087E+01  9.68610E-01
 5450.00  9.44162E-01  9.60509E-01  3.34747E+01  9.65075E-01
 5452.00  9.27655E-01  9.59557E-01  3.35528E+01  9.65276E-01
 5454.00  9.49026E-01  9.55880E-01  3.41766E+01  9.62901E-01
 5456.00  9.89815E-01  9.51556E-01  3.45384E+01  9.59149E-01
 5458.00  1.00020E+00  9.53638E-01  3.40029E+01  9.60129E-01
 5460.00  9.74642E-01  9.60131E-01  3.43995E+01  9.63913E-01
 5462.00  9.45605E-01  9.64855E-01  3.48136E+01  9.65775E-01
 5464.00  9.49039E-01  9.66541E-01  3.51096E+01  9.65864E-01
 5466.00  9.84003E-01  9.67718E-01  3.53716E+01  9.66951E-01
 5468.00  1.00477E+00  9.69661E-01  3.54704E+01  9.69392E-01
 5470.00  9.80152E-01  9.69466E-01  3.44747E+01  9.69486E-01
 5472.00  9.48734E-01  9.64197E-01  3.41136E+01  9.63827E-01
 5474.00  9.30708E-01  9.54236E-01  3.47263E+01  9.52958E-01
 5476.00  9.18485E-01  9.43353E-01  3.45936E+01  9.41233E-01
 5478.00  9.09826E-01  9.37880E-01 -1.20000E+01  9.35585E-01
 5480.00  7.74549E-01  9.40368E-01 -1.20000E+01  9.38313E-01
 5482.00  5.10009E-01  9.48506E-01 -1.20000E+01  9.46407E-01
 5484.00  7.18784E-01  9.59171E-01 -1.20000E+01  9.57085E-01
 5486.00  1.24769E+00  9.66435E-01 -1.20000E+01  9.65555E-01
 5488.00  1.35971E+00  9.68187E-01 -1.20000E+01  9.69889E-01
 5490.00  1.20755E+00  9.67821E-01 -1.20000E+01  9.72021E-01
 5492.00  1.07413E+00  9.67752E-01 -1.20000E+01  9.73134E-01
 5494.00  1.02260E+00  9.68747E-01 -1.20000E+01  9.73827E-01
 5496.00  1.00488E+00  9.69749E-01  3.25778E+01  9.73764E-01
 5498.00  9.98886E-01  9.69330E-01 -2.40000E+01  9.72412E-01
 5500.00  1.01070E+00  9.67442E-01 -2.40000E+01  9.70320E-01
 5502.00  1.02775E+00  9.63223E-01 -2.40000E+01  9.66721E-01
 5504.00  1.03488E+00  9.58548E-01 -2.40000E+01  9.63227E-01
 5506.00  1.02438E+00  9.54758E-01 -2.40000E+01  9.60074E-01
 5508.00  1.00661E+00  9.52989E-01 -2.40000E+01  9.58330E-01
 5510.00  9.84650E-01  9.51224E-01 -2.40000E+01  9.57135E-01
 5512.00  9.61408E-01  9.48308E-01 -2.40000E+01  9.55774E-01
 5514.00  9.58200E-01  9.48092E-01  3.51915E+01  9.57487E-01
 5516.00  9.71120E-01  9.54485E-01  3.44693E+01  9.64895E-01
 5518.00  9.84802E-01  9.67208E-01  3.43988E+01  9.76814E-01
 5520.00  9.90541E-01  9.80344E-01  3.46043E+01  9.87799E-01
 5522.00  9.94231E-01  9.87507E-01  3.49101E+01  9.92185E-01
 5524.00  9.91810E-01  9.86036E-01  3.40668E+01  9.88229E-01
 5526.00  9.87123E-01  9.77828E-01  3.36148E+01  9.78225E-01
 5528.00  9.83630E-01  9.68861E-01  3.29942E+01  9.68392E-01
 5530.00  9.81023E-01  9.65981E-01  3.26593E+01  9.65307E-01
 5532.00  9.85755E-01  9.68998E-01  3.32951E+01  9.68293E-01
 5534.00  1.00418E+00  9.73991E-01  3.17803E+01  9.73275E-01
 5536.00  1.00620E+00  9.78731E-01  3.33428E+01  9.78482E-01
 5538.00  9.70378E-01  9.83721E-01  3.29024E+01  9.84360E-01
 5540.00  9.32575E-01  9.89518E-01  3.42778E+01  9.90755E-01
 5542.00  9.49729E-01  9.94074E-01  3.22034E+01  9.95045E-01
 5544.00  9.90019E-01  9.96084E-01  3.33037E+01  9.96146E-01
 5546.00  1.00023E+00  9.97136E-01  3.28834E+01  9.96849E-01
 5548.00  1.00215E+00  9.99117E-01  3.62573E+01  9.99756E-01
 5550.00  1.02671E+00  1.00097E+00  3.33958E+01  1.00360E+00
 5552.00  1.03480E+00  1.00018E+00  3.44433E+01  1.00500E+00
 5554.00  1.01615E+00  9.96332E-01  3.55981E+01  1.00270E+00
 5556.00  9.99961E-01  9.91907E-01  3.37326E+01  9.99154E-01
 5558.00  9.84281E-01  9.88523E-01  3.45137E+01  9.96061E-01
 5560.00  9.82556E-01  9.85564E-01  3.52815E+01  9.93153E-01
 5562.00  9.78776E-01  9.80984E-01  3.44496E+01  9.88750E-01
 5564.00  9.77088E-01  9.75259E-01  3.49848E+01  9.82955E-01
 5566.00  1.00367E+00  9.70428E-01  3.41155E+01  9.77491E-01
 5568.00  1.00283E+00  9.68407E-01  3.36855E+01  9.73955E-01
 5570.00  9.83262E-01  9.69281E-01  3.29098E+01  9.72778E-01
 5572.00  9.71499E-01  9.71898E-01  3.30538E+01  9.73589E-01
 5574.00  9.58180E-01  9.75807E-01  3.24599E+01  9.76448E-01
 5576.00  9.85119E-01  9.80798E-01  3.12340E+01  9.80954E-01
 5578.00  1.03439E+00  9.85505E-01  3.10984E+01  9.85717E-01
 5580.00  1.04004E+00  9.87717E-01  3.07543E+01  9.88540E-01
 5582.00  1.02323E+00  9.84243E-01  3.04999E+01  9.86455E-01
 5584.00  1.01399E+00  9.73812E-01  3.11163E+01  9.78175E-01
 5586.00  9.84663E-01  9.57794E-01  3.13495E+01  9.63981E-01
 5588.00  9.52151E-01  9.42608E-01  3.07293E+01  9.49159E-01
 5590.00  9.60474E-01  9.35937E-01  2.92574E+01  9.41158E-01
 5592.00  9.83633E-01  9.39581E-01  2.85846E+01  9.42426E-01
 5594.00  1.00424E+00  9.49113E-01  2.79331E+01  9.49248E-01
 5596.00  1.02726E+00  9.58461E-01  2.85466E+01  9.56339E-01
 5598.00  1.01693E+00  9.62018E-01  2.95727E+01  9.58338E-01
 5600.00  9.80296E-01  9.61422E-01  3.05069E+01  9.57148E-01
 5602.00  9.69083E-01  9.61647E-01  3.18656E+01  9.57388E-01
 5604.00  9.71013E-01  9.68797E-01  3.25391E+01  9.65035E-01
 5606.00  9.75533E-01  9.82849E-01  3.24233E+01  9.79719E-01
 5608.00  9.93060E-01  9.97358E-01  3.27793E+01  9.94834E-01
 5610.00  1.00414E+00  1.00520E+00  3.29055E+01  1.00334E+00
 5612.00  1.00387E+00  1.00250E+00  3.26007E+01  1.00175E+00
 5614.00  1.00349E+00  9.90047E-01  3.27674E+01  9.91215E-01
 5616.00  9.94225E-01  9.74693E-01  3.32064E+01  9.78357E-01
 5618.00  9.68396E-01  9.65129E-01  3.27451E+01  9.71139E-01
 5620.00  9.49372E-01  9.62489E-01  3.29699E+01  9.70047E-01
 5622.00  9.66322E-01  9.63966E-01  3.34811E+01  9.72066E-01
 5624.00  9.97661E-01  9.64438E-01  3.36495E+01  9.72232E-01
 5626.00  1.00275E+00  9.66324E-01  3.32264E+01  9.73436E-01
 5628.00  9.96753E-01  9.72573E-01  3.34008E+01  9.78536E-01
 5630.00  1.00234E+00  9.82047E-01  3.36998E+01  9.86759E-01
 5632.00  1.00925E+00  9.89382E-01  3.38930E+01  9.92979E-01
 5634.00  1.01655E+00  9.90163E-01  3.45569E+01  9.93011E-01
 5636.00  1.01059E+00  9.84934E-01  3.50903E+01  9.87384E-01
 5638.00  9.79891E-01  9.77812E-01  3.44144E+01  9.80021E-01
 5640.00  9.44632E-01  9.72642E-01  3.56689E+01  9.74923E-01
 5642.00  9.57245E-01  9.70976E-01  3.46752E+01  9.73790E-01
 5644.00  9.68823E-01  9.72884E-01  3.46267E+01  9.76770E-01
 5646.00  9.74657E-01  9.76633E-01  3.42757E+01  9.81912E-01
 5648.00  1.00514E+00  9.80866E-01  3.41101E+01  9.87259E-01
 5650.00  1.02222E+00  9.84177E-01  3.36384E+01  9.90545E-01
 5652.00  1.02213E+00  9.85671E-01  3.51843E+01  9.90648E-01
 5654.00  1.00812E+00  9.82544E-01  3.20448E+01  9.85327E-01
 5656.00  9.88266E-01  9.74620E-01  3.34571E+01  9.75250E-01
 5658.00  9.83804E-01  9.63404E-01  3.28278E+01  9.62680E-01
 5660.00  9.75196E-01  9.55610E-01  3.23481E+01  9.55114E-01
 5662.00  9.64214E-01  9.54448E-01  3.25600E+01  9.54636E-01
 5664.00  9.67191E-01  9.60054E-01  3.28379E+01  9.60656E-01
 5666.00  1.00273E+00  9.68255E-01  3.32642E+01  9.68201E-01
 5668.00  1.03859E+00  9.76036E-01  3.05578E+01  9.74495E-01
 5670.00  1.03850E+00  9.84017E-01  3.04331E+01  9.80833E-01
 5672.00  1.01586E+00  9.92825E-01  2.81432E+01  9.88549E-01
 5674.00  1.00994E+00  1.00152E+00  2.72993E+01  9.96956E-01
 5676.00  1.04626E+00  1.00688E+00  2.89364E+01  1.00287E+00
 5678.00  1.06126E+00  1.00682E+00  3.00544E+01  1.00388E+00
 5680.00  1.03060E+00  1.00136E+00  3.24726E+01  9.99638E-01
 5682.00  1.00427E+00  9.93049E-01  3.33824E+01  9.91884E-01
 5684.00  9.76026E-01  9.85708E-01  3.37957E+01  9.83807E-01
 5686.00  9.49114E-01  9.82150E-01  3.35675E+01  9.78464E-01
 5688.00  9.42039E-01  9.83345E-01  3.41774E+01  9.77662E-01
 5690.00  9.47015E-01  9.89162E-01  3.14756E+01  9.82371E-01
 5692.00  9.79715E-01  9.96534E-01  2.83822E+01  9.90037E-01
 5694.00  1.03585E+00  1.00167E+00  2.67743E+01  9.96708E-01
 5696.00  1.07062E+00  1.00179E+00  2.73268E+01  9.98700E-01
 5698.00  1.07095E+00  9.96854E-01  2.75683E+01  9.94880E-01
 5700.00  1.05294E+00  9.89971E-01  2.97611E+01  9.87677E-01
 5702.00  1.02375E+00  9.83454E-01  3.17596E+01  9.79764E-01
 5704.00  9.91755E-01  9.78067E-01  3.18598E+01  9.72974E-01
 5706.00  9.72709E-01  9.71364E-01  3.23948E+01  9.65623E-01
 5708.00  9.71729E-01  9.63630E-01  3.28704E+01  9.58044E-01
 5710.00  9.75997E-01  9.58294E-01  3.33484E+01  9.53322E-01
 5712.00  9.68385E-01  9.59990E-01  3.31180E+01  9.56105E-01
 5714.00  9.77620E-01  9.70354E-01  3.34666E+01  9.67361E-01
 5716.00  1.00864E+00  9.85172E-01  3.39416E+01  9.82512E-01
 5718.00  1.02546E+00  9.99582E-01  3.38073E+01  9.96702E-01
 5720.00  1.02291E+00  1.01047E+00  3.40816E+01  1.00737E+00
 5722.00  1.02895E+00  1.01722E+00  3.34438E+01  1.01415E+00
 5724.00  1.05200E+00  1.01986E+00  3.26396E+01  1.01690E+00
 5726.00  1.06428E+00  1.01852E+00  3.20726E+01  1.01554E+00
 5728.00  1.04688E+00  1.01513E+00  3.16618E+01  1.01212E+00
 5730.00  1.02328E+00  1.01254E+00  3.17827E+01  1.00943E+00
 5732.00  1.03929E+00  1.01189E+00  3.11703E+01  1.00877E+00
 5734.00  1.07433E+00  1.01350E+00  3.10459E+01  1.01046E+00
 5736.00  1.08904E+00  1.01477E+00  3.09834E+01  1.01203E+00
 5738.00  1.07353E+00  1.01479E+00  3.05653E+01  1.01262E+00
 5740.00  1.04385E+00  1.01385E+00  3.02520E+01  1.01187E+00
 5742.00  1.03897E+00  1.01355E+00  3.15133E+01  1.01096E+00
 5744.00  1.05189E+00  1.01452E+00  3.17998E+01  1.01067E+00
 5746.00  1.03712E+00  1.01530E+00  3.20695E+01  1.01053E+00
 5748.00  1.00690E+00  1.01342E+00  3.26638E+01  1.00872E+00
 5750.00  9.96256E-01  1.00950E+00  3.33915E+01  1.00556E+00
 5752.00  1.01006E+00  1.00405E+00  3.32462E+01  1.00094E+00
 5754.00  1.02678E+00  1.00032E+00  3.30401E+01  9.97770E-01
 5756.00  1.04564E+00  1.00033E+00  3.29544E+01  9.98058E-01
 5758.00  1.06849E+00  1.00212E+00  3.18145E+01  1.00012E+00
 5760.00  1.06730E+00  1.00304E+00  3.13295E+01  1.00125E+00
 5762.00  1.05358E+00  1.00249E+00  3.21411E+01  1.00035E+00
 5764.00  1.05235E+00  1.00462E+00  3.20576E+01  1.00138E+00
 5766.00  1.08573E+00  1.01067E+00  2.98548E+01  1.00615E+00
 5768.00  1.12755E+00  1.01749E+00  2.84502E+01  1.01234E+00
 5770.00  1.13303E+00  1.02073E+00  2.71943E+01  1.01590E+00
 5772.00  1.06308E+00  1.01976E+00  2.83943E+01  1.01545E+00
 5774.00  1.00318E+00  1.01690E+00  3.00005E+01  1.01271E+00
 5776.00  9.88839E-01  1.01305E+00  3.07511E+01  1.00864E+00
 5778.00  9.82989E-01  1.00658E+00  3.06599E+01  1.00256E+00
 5780.00  9.70100E-01  9.95013E-01  3.15642E+01  9.93120E-01
 5782.00  9.78046E-01  9.80520E-01  3.23457E+01  9.82659E-01
 5784.00  9.90901E-01  9.68853E-01  3.26171E+01  9.75762E-01
 5786.00  9.78319E-01  9.65421E-01 -1.20000E+01  9.75807E-01
 5788.00  9.81913E-01  9.71331E-01 -1.20000E+01  9.82562E-01
 5790.00  1.00037E+00  9.81608E-01 -1.20000E+01  9.91506E-01
 5792.00  1.01992E+00  9.92570E-01 -1.20000E+01  1.00007E+00
 5794.00  1.04924E+00  1.00165E+00 -1.20000E+01  1.00681E+00
 5796.00  1.04034E+00  1.00886E+00 -1.20000E+01  1.01214E+00
 5798.00  1.00545E+00  1.01488E+00 -1.20000E+01  1.01659E+00
 5800.00  9.95663E-01  1.02095E+00 -1.20000E+01  1.02103E+00
 5802.00  1.02487E+00  1.02570E+00 -1.20000E+01  1.02412E+00
 5804.00  1.01459E+00  1.02815E+00 -1.20000E+01  1.02488E+00
 5806.00  9.88747E-01  1.02797E+00 -1.20000E+01  1.02342E+00
 5808.00  9.91010E-01  1.02742E+00  2.99782E+01  1.02195E+00
 5810.00  9.89696E-01  1.02812E+00  3.06819E+01  1.02186E+00
 5812.00  1.00515E+00  1.02915E+00  3.12378E+01  1.02218E+00
 5814.00  1.05461E+00  1.02928E+00  2.97613E+01  1.02161E+00
 5816.00  1.07088E+00  1.02909E+00  2.88284E+01  1.02080E+00
 5818.00  1.03898E+00  1.03105E+00  3.01369E+01  1.02209E+00
 5820.00  1.02612E+00  1.03525E+00  3.06214E+01  1.02562E+00
 5822.00  1.04533E+00  1.03994E+00  3.13483E+01  1.03015E+00
 5824.00  1.06015E+00  1.04282E+00  3.09318E+01  1.03354E+00
 5826.00  1.05750E+00  1.04393E+00  3.03898E+01  1.03557E+00
 5828.00  1.06074E+00  1.04447E+00  3.01507E+01  1.03672E+00
 5830.00  1.08493E+00  1.04486E+00  2.99946E+01  1.03727E+00
 5832.00  1.09483E+00  1.04420E+00  2.93638E+01  1.03680E+00
 5834.00  1.07556E+00  1.04222E+00  2.79075E+01  1.03538E+00
 5836.00  1.05191E+00  1.03999E+00  2.83025E+01  1.03386E+00
 5838.00  1.04152E+00  1.03892E+00  2.99391E+01  1.03307E+00
 5840.00  1.04773E+00  1.04010E+00  3.07891E+01  1.03368E+00
 5842.00  1.05244E+00  1.04190E+00  3.00444E+01  1.03438E+00
 5844.00  1.05661E+00  1.04193E+00  2.99043E+01  1.03323E+00
 5846.00  1.06931E+00  1.03854E+00  3.01168E+01  1.02867E+00
 5848.00  1.07004E+00  1.03200E+00  3.02024E+01  1.02093E+00
 5850.00  1.05261E+00  1.02378E+00  3.06852E+01  1.01159E+00
 5852.00  1.03048E+00  1.01445E+00  3.11241E+01  1.00139E+00
 5854.00  1.01809E+00  1.00505E+00  3.08233E+01  9.91763E-01
 5856.00  1.02837E+00  9.96782E-01  2.97657E+01  9.84093E-01
 5858.00  1.03789E+00  9.91759E-01  3.03265E+01  9.80036E-01
 5860.00  1.02910E+00  9.92268E-01  3.11296E+01  9.81559E-01
 5862.00  1.00873E+00  9.96443E-01  3.20768E+01  9.86154E-01
 5864.00  9.91988E-01  1.00287E+00  3.22378E+01  9.92889E-01
 5866.00  9.83877E-01  1.00807E+00  0.00000E+00  9.98623E-01
 5868.00  9.83353E-01  1.01219E+00  0.00000E+00  1.00391E+00
 5870.00  9.97258E-01  1.01493E+00  0.00000E+00  1.00855E+00
 5872.00  1.02558E+00  1.01537E+00  0.00000E+00  1.01182E+00
 5874.00  1.04944E+00  1.01294E+00  0.00000E+00  1.01289E+00
 5876.00  1.06027E+00  1.00739E+00  0.00000E+00  1.01091E+00
 5878.00  1.06497E+00  1.00025E+00  0.00000E+00  1.00666E+00
 5880.00  1.05433E+00  9.92446E-01  0.00000E+00  1.00099E+00
 5882.00  1.02635E+00  9.84379E-01  0.00000E+00  9.94479E-01
 5884.00  9.88710E-01  9.71883E-01  0.00000E+00  9.84610E-01
 5886.00  9.55384E-01  9.50046E-01  0.00000E+00  9.67924E-01
 5888.00  9.32927E-01  9.16043E-01  0.00000E+00  9.42064E-01
 5890.00  9.02632E-01  8.77922E-01  0.00000E+00  9.12686E-01
 5892.00  8.59453E-01  8.51288E-01  0.00000E+00  8.92544E-01
 5894.00  8.41267E-01  8.42132E-01  0.00000E+00  8.84950E-01
 5896.00  8.42059E-01  8.51427E-01  0.00000E+00  8.90913E-01
 5898.00  8.63857E-01  8.75330E-01  0.00000E+00  9.07457E-01
 5900.00  9.19191E-01  9.07163E-01  0.00000E+00  9.29721E-01
 5902.00  9.77817E-01  9.41559E-01  0.00000E+00  9.54655E-01
 5904.00  1.00508E+00  9.68777E-01  0.00000E+00  9.73887E-01
 5906.00  1.00744E+00  9.86262E-01  0.00000E+00  9.85567E-01
 5908.00  1.00829E+00  9.96024E-01  0.00000E+00  9.91246E-01
 5910.00  1.03880E+00  1.00036E+00  0.00000E+00  9.92743E-01
 5912.00  1.03360E+00  1.00077E+00  0.00000E+00  9.91387E-01
 5914.00  1.00245E+00  9.97850E-01  0.00000E+00  9.87590E-01
 5916.00  9.85435E-01  9.94970E-01  0.00000E+00  9.84647E-01
 5918.00  9.86389E-01  9.94300E-01  3.33410E+01  9.84501E-01
 5920.00  1.00035E+00  9.96470E-01  3.35693E+01  9.87705E-01
 5922.00  1.00437E+00  9.99595E-01  3.38966E+01  9.92062E-01
 5924.00  1.02173E+00  1.00220E+00  3.41827E+01  9.95658E-01
 5926.00  1.05325E+00  1.00345E+00  3.26330E+01  9.97324E-01
 5928.00  1.04470E+00  1.00345E+00  3.35837E+01  9.96975E-01
 5930.00  1.00263E+00  1.00299E+00  3.38371E+01  9.95453E-01
 5932.00  9.82020E-01  1.00360E+00  3.31118E+01  9.94741E-01
 5934.00  9.81863E-01  1.00502E+00  3.28844E+01  9.94985E-01
 5936.00  1.00653E+00  1.00765E+00  3.31023E+01  9.96881E-01
 5938.00  1.02770E+00  1.00972E+00  3.19117E+01  9.98755E-01
 5940.00  1.01729E+00  1.01052E+00  3.07086E+01  9.99888E-01
 5942.00  1.00672E+00  1.01035E+00  3.25567E+01  1.00014E+00
 5944.00  1.01996E+00  1.01026E+00  3.21884E+01  1.00008E+00
 5946.00  1.01800E+00  1.01010E+00  3.25262E+01  9.99656E-01
 5948.00  1.00221E+00  1.00859E+00  3.27099E+01  9.98102E-01
 5950.00  9.98780E-01  1.00550E+00  3.32744E+01  9.95918E-01
 5952.00  9.96781E-01  1.00157E+00  3.35806E+01  9.93682E-01
 5954.00  9.90646E-01  9.99138E-01  3.42441E+01  9.92958E-01
 5956.00  9.89717E-01  9.99280E-01  3.44515E+01  9.93949E-01
 5958.00  1.00377E+00  1.00223E+00  3.36747E+01  9.96903E-01
 5960.00  1.01562E+00  1.00791E+00  3.28232E+01  1.00195E+00
 5962.00  1.01549E+00  1.01420E+00  3.30616E+01  1.00742E+00
 5964.00  1.01985E+00  1.01951E+00  3.34578E+01  1.01180E+00
 5966.00  1.01583E+00  1.02313E+00  3.34352E+01  1.01430E+00
 5968.00  1.00967E+00  1.02630E+00  3.27932E+01  1.01618E+00
 5970.00  1.01797E+00  1.02911E+00  3.25999E+01  1.01781E+00
 5972.00  1.03032E+00  1.03036E+00  3.22460E+01  1.01832E+00
 5974.00  1.03857E+00  1.02805E+00  3.16329E+01  1.01605E+00
 5976.00  1.03701E+00  1.02243E+00  3.19409E+01  1.01118E+00
 5978.00  1.01924E+00  1.01610E+00  3.29153E+01  1.00624E+00
 5980.00  9.99982E-01  1.01136E+00  3.32226E+01  1.00294E+00
 5982.00  9.89306E-01  1.00824E+00  3.35658E+01  1.00086E+00
 5984.00  9.90232E-01  1.00604E+00  3.45008E+01  9.98931E-01
 5986.00  9.99439E-01  1.00576E+00  3.39442E+01  9.98353E-01
 5988.00  9.95519E-01  1.00764E+00  3.43563E+01  9.99868E-01
 5990.00  9.83517E-01  1.01159E+00  3.45537E+01  1.00390E+00
 5992.00  9.76483E-01  1.01543E+00  3.35043E+01  1.00846E+00
 5994.00  9.81257E-01  1.01788E+00  3.44086E+01  1.01217E+00
 5996.00  1.00383E+00  1.01759E+00  3.28153E+01  1.01330E+00
 5998.00  1.03144E+00  1.01558E+00  3.28813E+01  1.01219E+00
 6000.00  1.04231E+00  1.01327E+00  3.29197E+01  1.00961E+00
 6002.00  1.03348E+00  1.01114E+00  3.29895E+01  1.00615E+00
 6004.00  1.02053E+00  1.00956E+00  3.33447E+01  1.00277E+00
 6006.00  1.01061E+00  1.00773E+00  3.16577E+01  9.99278E-01
 6008.00  9.84028E-01  1.00600E+00  3.22629E+01  9.96403E-01
 6010.00  9.39366E-01  1.00578E+00  3.24811E+01  9.95935E-01
 6012.00  9.20925E-01  1.00540E+00  3.29818E+01  9.96473E-01
 6014.00  9.35285E-01  1.00456E+00  3.26345E+01  9.97434E-01
 6016.00  9.49661E-01  1.00262E+00  3.37267E+01  9.97365E-01
 6018.00  9.70199E-01  1.00026E+00  3.41023E+01  9.96213E-01
 6020.00  9.96784E-01  9.98728E-01  3.47604E+01  9.94914E-01
 6022.00  1.01456E+00  9.99183E-01  3.28181E+01  9.94944E-01
 6024.00  1.02796E+00  1.00256E+00  3.34457E+01  9.97342E-01
 6026.00  1.04713E+00  1.00921E+00  3.23523E+01  1.00251E+00
 6028.00  1.04966E+00  1.01798E+00  3.33396E+01  1.00931E+00
 6030.00  1.03469E+00  1.02709E+00  3.27027E+01  1.01630E+00
 6032.00  1.00176E+00  1.03479E+00  3.26379E+01  1.02217E+00
 6034.00  9.87292E-01  1.04012E+00  3.30775E+01  1.02642E+00
 6036.00  9.94876E-01  1.04267E+00  3.20336E+01  1.02869E+00
 6038.00  1.00468E+00  1.04301E+00  3.35783E+01  1.02936E+00
 6040.00  1.03508E+00  1.04222E+00  3.15606E+01  1.02907E+00
 6042.00  1.05154E+00  1.04192E+00  3.22205E+01  1.02917E+00
 6044.00  1.04788E+00  1.04293E+00  3.17639E+01  1.03055E+00
 6046.00  1.04938E+00  1.04467E+00  3.32006E+01  1.03278E+00
 6048.00  1.04691E+00  1.04587E+00  3.43968E+01  1.03478E+00
 6050.00  1.04159E+00  1.04530E+00  3.38437E+01  1.03520E+00
 6052.00  1.04537E+00  1.04252E+00  3.20201E+01  1.03345E+00
 6054.00  1.03718E+00  1.03831E+00  3.17463E+01  1.03018E+00
 6056.00  1.03788E+00  1.03419E+00  3.14073E+01  1.02681E+00
 6058.00  1.05493E+00  1.03145E+00  3.02451E+01  1.02473E+00
 6060.00  1.06272E+00  1.03011E+00  3.08631E+01  1.02368E+00
 6062.00  1.05971E+00  1.02903E+00  3.26069E+01  1.02226E+00
 6064.00  1.04580E+00  1.02818E+00  3.24326E+01  1.02025E+00
 6066.00  1.02159E+00  1.02962E+00  3.26848E+01  1.02007E+00
 6068.00  1.02312E+00  1.03538E+00  3.17077E+01  1.02419E+00
 6070.00  1.03318E+00  1.04378E+00  3.09780E+01  1.03113E+00
 6072.00  1.02129E+00  1.05168E+00  3.25146E+01  1.03783E+00
 6074.00  1.01575E+00  1.05524E+00  3.42302E+01  1.04050E+00
 6076.00  1.03489E+00  1.05314E+00  3.45636E+01  1.03796E+00
 6078.00  1.05723E+00  1.04670E+00  3.38088E+01  1.03131E+00
 6080.00  1.05846E+00  1.03887E+00  3.40923E+01  1.02347E+00
 6082.00  1.03950E+00  1.03195E+00  3.41445E+01  1.01677E+00
 6084.00  1.01780E+00  1.02746E+00  3.33394E+01  1.01284E+00
 6086.00  1.00955E+00  1.02491E+00  3.24356E+01  1.01136E+00
 6088.00  1.01626E+00  1.02332E+00  3.21684E+01  1.01138E+00
 6090.00  1.01114E+00  1.02168E+00  3.25289E+01  1.01175E+00
 6092.00  9.83532E-01  1.02103E+00  3.31531E+01  1.01315E+00
 6094.00  9.72426E-01  1.02205E+00  3.29548E+01  1.01592E+00
 6096.00  9.88225E-01  1.02369E+00  3.24876E+01  1.01906E+00
 6098.00  9.88827E-01  1.02375E+00  3.31277E+01  1.02033E+00
 6100.00  9.75384E-01  1.02049E+00  3.35270E+01  1.01795E+00
 6102.00  9.82903E-01  1.01384E+00  3.28668E+01  1.01199E+00
 6104.00  1.00038E+00  1.00970E+00  3.32689E+01  1.00815E+00
 6106.00  1.00944E+00  1.01100E+00  3.42999E+01  1.00915E+00
 6108.00  1.00806E+00  1.01690E+00  3.41952E+01  1.01422E+00
 6110.00  9.94725E-01  1.02468E+00  3.51767E+01  1.02109E+00
 6112.00  9.97901E-01  1.03015E+00  3.59763E+01  1.02619E+00
 6114.00  1.01328E+00  1.03249E+00  3.55970E+01  1.02895E+00
 6116.00  1.00986E+00  1.03067E+00  3.36451E+01  1.02847E+00
 6118.00  1.00688E+00  1.02509E+00  3.36669E+01  1.02490E+00
 6120.00  1.02555E+00  1.01635E+00  3.17928E+01  1.01851E+00
 6122.00  1.01799E+00  1.00777E+00  3.41058E+01  1.01206E+00
 6124.00  9.95302E-01  1.00410E+00  3.37894E+01  1.00958E+00
 6126.00  9.94210E-01  1.00511E+00  3.45365E+01  1.01069E+00
 6128.00  1.02284E+00  1.00960E+00  3.43391E+01  1.01417E+00
 6130.00  1.06816E+00  1.01478E+00  3.18488E+01  1.01712E+00
 6132.00  1.07355E+00  1.01653E+00  3.00412E+01  1.01602E+00
 6134.00  1.03221E+00  1.01227E+00  3.07139E+01  1.00934E+00
 6136.00  9.96263E-01  1.00265E+00  3.21020E+01  9.98094E-01
 6138.00  9.79715E-01  9.95107E-01  3.24592E+01  9.89274E-01
 6140.00  9.94755E-01  9.95578E-01  3.31729E+01  9.88129E-01
 6142.00  1.04750E+00  1.00330E+00  3.31571E+01  9.93863E-01
 6144.00  1.06002E+00  1.01489E+00  3.40144E+01  1.00429E+00
 6146.00  1.02745E+00  1.02311E+00  3.32712E+01  1.01229E+00
 6148.00  1.01054E+00  1.02543E+00  3.40322E+01  1.01513E+00
 6150.00  1.00422E+00  1.02346E+00  3.39386E+01  1.01431E+00
 6152.00  9.97739E-01  1.01907E+00  3.15233E+01  1.01200E+00
 6154.00  9.85416E-01  1.01246E+00  2.97953E+01  1.00886E+00
 6156.00  9.89072E-01  1.00294E+00  2.85709E+01  1.00361E+00
 6158.00  1.01208E+00  9.89209E-01  3.20593E+01  9.93958E-01
 6160.00  1.00920E+00  9.71238E-01  3.32740E+01  9.79120E-01
 6162.00  9.61116E-01  9.53760E-01  3.37371E+01  9.62880E-01
 6164.00  9.24402E-01  9.44388E-01  3.32854E+01  9.52331E-01
 6166.00  9.28588E-01  9.44595E-01  3.53109E+01  9.49383E-01
 6168.00  9.54294E-01  9.51062E-01  3.59629E+01  9.51897E-01
 6170.00  9.57662E-01  9.59609E-01  3.46306E+01  9.56875E-01
 6172.00  9.44075E-01  9.68923E-01  3.52053E+01  9.63343E-01
 6174.00  9.39744E-01  9.78100E-01  3.44413E+01  9.70140E-01
 6176.00  9.34583E-01  9.87487E-01  3.43139E+01  9.77568E-01
 6178.00  9.29145E-01  9.96165E-01  3.33172E+01  9.84855E-01
 6180.00  9.29018E-01  1.00272E+00  3.34436E+01  9.90689E-01
 6182.00  9.58520E-01  1.00687E+00  3.17111E+01  9.94742E-01
 6184.00  1.00572E+00  1.00712E+00  3.02871E+01  9.95365E-01
 6186.00  1.01555E+00  1.00211E+00  3.19713E+01  9.91289E-01
 6188.00  1.01040E+00  9.92928E-01 -1.20000E+01  9.83593E-01
 6190.00  1.03272E+00  9.82873E-01 -1.20000E+01  9.75076E-01
 6192.00  1.10351E+00  9.76784E-01 -1.20000E+01  9.70121E-01
 6194.00  1.17702E+00  9.78021E-01 -1.20000E+01  9.71890E-01
 6196.00  1.19686E+00  9.83919E-01 -1.20000E+01  9.77804E-01
 6198.00  1.14368E+00  9.90317E-01 -1.20000E+01  9.84287E-01
 6200.00  1.06000E+00  9.95036E-01 -1.20000E+01  9.89078E-01
 6202.00  1.02092E+00  9.99213E-01 -1.20000E+01  9.93054E-01
 6204.00  1.01517E+00  1.00333E+00 -1.20000E+01  9.96975E-01
 6206.00  1.00745E+00  1.00668E+00 -1.20000E+01  1.00040E+00
 6208.00  1.01786E+00  1.00679E+00 -1.20000E+01  1.00139E+00
 6210.00  1.03611E+00  1.00132E+00 -1.20000E+01  9.97740E-01
 6212.00  1.02489E+00  9.90901E-01  3.45825E+01  9.89482E-01
 6214.00  1.00072E+00  9.77926E-01  3.59585E+01  9.78766E-01
 6216.00  9.88081E-01  9.66867E-01  3.50425E+01  9.69775E-01
 6218.00  9.73799E-01  9.60147E-01  3.46873E+01  9.64720E-01
 6220.00  9.51082E-01  9.57586E-01  3.56426E+01  9.63430E-01
 6222.00  9.52268E-01  9.59194E-01  3.34176E+01  9.65421E-01
 6224.00  9.75349E-01  9.62235E-01  3.19400E+01  9.67839E-01
 6226.00  9.81073E-01  9.63926E-01  3.15528E+01  9.68685E-01
 6228.00  9.81768E-01  9.62406E-01  3.27883E+01  9.66847E-01
 6230.00  9.88038E-01  9.57750E-01  3.39271E+01  9.62565E-01
 6232.00  9.72151E-01  9.54923E-01  3.33951E+01  9.60079E-01
 6234.00  9.48616E-01  9.56846E-01  3.37374E+01  9.61769E-01
 6236.00  9.59812E-01  9.60950E-01  3.43099E+01  9.65283E-01
 6238.00  9.78393E-01  9.62936E-01  3.34635E+01  9.66892E-01
 6240.00  9.66867E-01  9.60626E-01  3.36766E+01  9.64720E-01
 6242.00  9.48792E-01  9.55671E-01  3.60559E+01  9.59935E-01
 6244.00  9.47733E-01  9.51752E-01  3.43694E+01  9.55560E-01
 6246.00  9.46834E-01  9.52089E-01  3.49796E+01  9.54404E-01
 6248.00  9.40977E-01  9.55901E-01  3.46127E+01  9.56344E-01
 6250.00  9.42475E-01  9.59016E-01  3.53425E+01  9.58082E-01
 6252.00  9.41099E-01  9.58084E-01 -1.20000E+01  9.56347E-01
 6254.00  9.32061E-01  9.53352E-01 -1.20000E+01  9.51595E-01
 6256.00  9.23012E-01  9.47538E-01 -1.20000E+01  9.46402E-01
 6258.00  9.19812E-01  9.44507E-01 -1.20000E+01  9.44465E-01
 6260.00  9.35579E-01  9.47742E-01 -1.20000E+01  9.49073E-01
 6262.00  9.33794E-01  9.55875E-01 -1.20000E+01  9.58464E-01
 6264.00  9.30346E-01  9.65014E-01 -1.20000E+01  9.68743E-01
 6266.00  9.47554E-01  9.72505E-01 -1.20000E+01  9.77157E-01
 6268.00  9.67691E-01  9.77579E-01  3.52953E+01  9.82762E-01
 6270.00  9.63672E-01  9.81091E-01  3.60706E+01  9.86087E-01
 6272.00  9.62216E-01  9.84972E-01  3.74343E+01  9.88795E-01
 6274.00  9.95384E-01  9.89123E-01  3.49847E+01  9.90829E-01
 6276.00  1.02019E+00  9.92278E-01  3.55831E+01  9.91299E-01
 6278.00  1.01995E+00  9.93861E-01  3.49741E+01  9.90107E-01
 6280.00  1.02200E+00  9.94041E-01  0.00000E+00  9.88130E-01
 6282.00  1.02106E+00  9.95148E-01  0.00000E+00  9.88202E-01
 6284.00  9.84642E-01  9.98535E-01  0.00000E+00  9.91475E-01
 6286.00  9.44200E-01  1.00326E+00  0.00000E+00  9.96919E-01
 6288.00  9.48302E-01  1.00752E+00  0.00000E+00  1.00238E+00
 6290.00  9.78253E-01  1.00827E+00  0.00000E+00  1.00471E+00
 6292.00  9.94923E-01  1.00474E+00  0.00000E+00  1.00307E+00
 6294.00  1.00351E+00  9.98784E-01  0.00000E+00  9.98554E-01
 6296.00  1.00957E+00  9.91847E-01  0.00000E+00  9.92122E-01
 6298.00  1.02557E+00  9.86089E-01  0.00000E+00  9.85963E-01
 6300.00  1.04920E+00  9.82925E-01  0.00000E+00  9.81821E-01
 6302.00  1.05009E+00  9.82605E-01  0.00000E+00  9.80788E-01
 6304.00  1.02699E+00  9.85985E-01  0.00000E+00  9.84293E-01
 6306.00  9.90294E-01  9.91841E-01  0.00000E+00  9.90685E-01
 6308.00  9.68389E-01  9.97763E-01  0.00000E+00  9.97018E-01
 6310.00  9.84429E-01  1.00032E+00  0.00000E+00  1.00014E+00
 6312.00  9.99979E-01  9.97973E-01  0.00000E+00  9.98763E-01
 6314.00  9.90700E-01  9.91754E-01  0.00000E+00  9.93899E-01
 6316.00  9.78794E-01  9.84294E-01  0.00000E+00  9.87931E-01
 6318.00  9.94706E-01  9.79441E-01  0.00000E+00  9.83888E-01
 6320.00  1.01946E+00  9.80019E-01  0.00000E+00  9.83922E-01
 6322.00  9.98224E-01  9.85795E-01  3.58221E+01  9.88026E-01
 6324.00  9.64109E-01  9.94732E-01  3.65564E+01  9.94836E-01
 6326.00  9.65012E-01  1.00386E+00  3.67167E+01  1.00189E+00
 6328.00  9.77834E-01  1.01050E+00  3.67647E+01  1.00699E+00
 6330.00  9.78148E-01  1.01344E+00  3.59640E+01  1.00922E+00
 6332.00  9.72985E-01  1.01257E+00  3.70390E+01  1.00847E+00
 6334.00  9.76549E-01  1.00842E+00  3.73031E+01  1.00494E+00
 6336.00  9.81257E-01  1.00296E+00  3.56186E+01  1.00036E+00
 6338.00  9.62609E-01  9.99568E-01  3.53202E+01  9.98157E-01
 6340.00  9.49257E-01  9.98670E-01  3.48025E+01  9.98889E-01
 6342.00  9.64873E-01  9.98524E-01  3.47079E+01  1.00110E+00
 6344.00  9.91413E-01  9.97585E-01  3.54001E+01  1.00310E+00
 6346.00  1.00483E+00  9.96519E-01  3.51149E+01  1.00477E+00
 6348.00  1.00971E+00  9.96680E-01  3.57611E+01  1.00660E+00
 6350.00  1.02902E+00  9.97918E-01  3.55320E+01  1.00835E+00
 6352.00  1.04686E+00  9.97721E-01  3.59480E+01  1.00824E+00
 6354.00  1.04251E+00  9.93383E-01  3.48617E+01  1.00454E+00
 6356.00  1.01242E+00  9.84892E-01  3.36178E+01  9.97699E-01
 6358.00  9.96008E-01  9.74195E-01  3.31062E+01  9.89447E-01
 6360.00  9.89187E-01  9.64845E-01  3.25709E+01  9.82501E-01
 6362.00  9.97081E-01  9.60323E-01  3.23889E+01  9.79112E-01
 6364.00  1.02102E+00  9.62504E-01  3.19896E+01  9.80445E-01
 6366.00  1.00677E+00  9.70530E-01  3.27596E+01  9.86288E-01
 6368.00  9.70776E-01  9.81375E-01  3.60222E+01  9.94736E-01
 6370.00  9.70355E-01  9.91915E-01  3.49628E+01  1.00341E+00
 6372.00  9.99057E-01  1.00069E+00  3.48899E+01  1.01109E+00
 6374.00  1.01967E+00  1.00677E+00  3.57669E+01  1.01684E+00
 6376.00  1.01363E+00  1.00960E+00  3.59377E+01  1.01990E+00
 6378.00  1.00051E+00  1.00935E+00  3.68890E+01  1.02030E+00
 6380.00  9.74760E-01  1.00743E+00  3.67198E+01  1.01900E+00
 6382.00  9.59748E-01  1.00587E+00  3.68423E+01  1.01760E+00
 6384.00  9.82785E-01  1.00576E+00  3.64941E+01  1.01700E+00
 6386.00  9.95556E-01  1.00720E+00  3.65818E+01  1.01723E+00
 6388.00  9.93088E-01  1.00890E+00  3.47886E+01  1.01712E+00
 6390.00  9.97351E-01  1.00910E+00  3.11213E+01  1.01528E+00
 6392.00  9.94576E-01  1.00701E+00  2.97478E+01  1.01161E+00
 6394.00  9.84647E-01  1.00424E+00  2.99733E+01  1.00812E+00
 6396.00  9.86271E-01  1.00284E+00  3.29425E+01  1.00688E+00
 6398.00  9.93270E-01  1.00229E+00  3.38497E+01  1.00704E+00
 6400.00  1.00278E+00  1.00278E+00  3.67411E+01  1.00831E+00
 6402.00  1.00688E+00  1.00592E+00  3.72833E+01  1.01203E+00
 6404.00  1.01009E+00  1.01005E+00  3.73447E+01  1.01644E+00
 6406.00  1.00935E+00  1.01285E+00  3.70185E+01  1.01938E+00
 6408.00  9.98383E-01  1.01300E+00  3.54383E+01  1.01972E+00
 6410.00  9.76154E-01  1.01076E+00  3.64590E+01  1.01789E+00
 6412.00  9.55648E-01  1.00727E+00  3.50986E+01  1.01500E+00
 6414.00  9.64612E-01  1.00468E+00  3.41699E+01  1.01295E+00
 6416.00  9.81683E-01  1.00317E+00  3.35638E+01  1.01154E+00
 6418.00  9.89839E-01  1.00197E+00  3.43636E+01  1.00998E+00
 6420.00  9.76816E-01  1.00160E+00  3.50221E+01  1.00869E+00
 6422.00  9.50271E-01  1.00414E+00  3.48936E+01  1.00991E+00
 6424.00  9.65587E-01  1.00968E+00  3.15352E+01  1.01406E+00
 6426.00  1.00612E+00  1.01596E+00  3.11831E+01  1.01875E+00
 6428.00  1.01380E+00  1.02004E+00  3.36682E+01  1.02116E+00
 6430.00  1.01672E+00  1.01999E+00  3.51963E+01  1.01988E+00
 6432.00  1.01729E+00  1.01806E+00  3.61930E+01  1.01751E+00
 6434.00  9.88393E-01  1.01688E+00  3.66378E+01  1.01696E+00
 6436.00  9.79960E-01  1.01677E+00  3.48464E+01  1.01841E+00
 6438.00  9.97108E-01  1.01753E+00  3.48660E+01  1.02090E+00
 6440.00  1.00673E+00  1.02046E+00  3.50937E+01  1.02497E+00
 6442.00  1.01070E+00  1.02550E+00  3.30220E+01  1.03043E+00
 6444.00  1.01246E+00  1.02985E+00  3.02834E+01  1.03479E+00
 6446.00  1.01717E+00  1.03014E+00  3.03540E+01  1.03522E+00
 6448.00  1.01991E+00  1.02412E+00  3.23795E+01  1.02989E+00
 6450.00  1.01133E+00  1.01459E+00  3.34043E+01  1.02133E+00
 6452.00  1.00282E+00  1.00796E+00  3.17897E+01  1.01523E+00
 6454.00  1.00468E+00  1.00660E+00  3.03264E+01  1.01337E+00
 6456.00  1.01988E+00  1.00968E+00  3.07197E+01  1.01486E+00
 6458.00  1.01591E+00  1.01482E+00  3.29826E+01  1.01815E+00
 6460.00  1.00301E+00  1.01803E+00  3.51377E+01  1.02025E+00
 6462.00  1.01166E+00  1.01777E+00  3.57129E+01  1.02009E+00
 6464.00  1.01474E+00  1.01734E+00  3.55751E+01  1.02072E+00
 6466.00  9.98856E-01  1.01903E+00  3.35686E+01  1.02359E+00
 6468.00  9.87432E-01  1.02220E+00  3.11344E+01  1.02725E+00
 6470.00  9.90429E-01  1.02507E+00  3.06751E+01  1.02971E+00
 6472.00  9.95471E-01  1.02654E+00  3.31237E+01  1.03019E+00
 6474.00  1.00667E+00  1.02644E+00  3.45827E+01  1.02903E+00
 6476.00  1.01461E+00  1.02533E+00  3.64293E+01  1.02692E+00
 6478.00  1.01992E+00  1.02355E+00  3.64514E+01  1.02413E+00
 6480.00  1.01165E+00  1.02033E+00  3.59362E+01  1.01991E+00
 6482.00  9.84859E-01  1.01590E+00  3.68195E+01  1.01488E+00
 6484.00  9.62454E-01  1.01219E+00  3.72738E+01  1.01126E+00
 6486.00  9.79332E-01  1.00972E+00  3.53358E+01  1.00952E+00
 6488.00  1.00930E+00  1.00626E+00  3.46798E+01  1.00721E+00
 6490.00  1.01019E+00  9.97998E-01  3.38127E+01  1.00044E+00
 6492.00  9.89763E-01  9.82862E-01  3.40764E+01  9.87141E-01
 6494.00  9.71784E-01  9.63413E-01  3.27128E+01  9.69562E-01
 6496.00  9.35693E-01  9.47866E-01  3.26492E+01  9.55351E-01
 6498.00  9.03976E-01  9.43092E-01  3.64443E+01  9.51726E-01
 6500.00  9.35933E-01  9.50120E-01  3.77989E+01  9.60312E-01
 6502.00  9.89415E-01  9.64937E-01  3.91664E+01  9.77057E-01
 6504.00  1.00434E+00  9.81343E-01  3.73283E+01  9.95188E-01
 6506.00  1.01061E+00  9.94588E-01  3.77778E+01  1.00941E+00
 6508.00  1.02409E+00  1.00291E+00  3.62220E+01  1.01768E+00
 6510.00  1.00627E+00  1.00740E+00  3.58572E+01  1.02085E+00
 6512.00  9.78022E-01  1.00913E+00  3.67223E+01  1.02011E+00
 6514.00  9.63354E-01  1.00863E+00  3.62178E+01  1.01664E+00
 6516.00  9.71047E-01  1.00673E+00  3.65821E+01  1.01218E+00
 6518.00  9.83014E-01  1.00530E+00  3.51638E+01  1.00935E+00
 6520.00  9.94765E-01  1.00606E+00  3.43533E+01  1.00992E+00
 6522.00  1.00067E+00  1.00873E+00  3.45852E+01  1.01327E+00
 6524.00  1.00621E+00  1.01142E+00  3.54513E+01  1.01717E+00
 6526.00  1.01386E+00  1.01234E+00  3.54366E+01  1.01950E+00
 6528.00  1.02313E+00  1.01152E+00  0.00000E+00  1.01992E+00
 6530.00  1.02196E+00  1.01003E+00  0.00000E+00  1.01925E+00
 6532.00  1.01673E+00  1.00877E+00  0.00000E+00  1.01835E+00
 6534.00  1.00557E+00  1.00885E+00  0.00000E+00  1.01838E+00
 6536.00  9.91063E-01  1.01019E+00  0.00000E+00  1.01937E+00
 6538.00  9.99119E-01  1.01138E+00  0.00000E+00  1.02021E+00
 6540.00  1.02452E+00  1.01054E+00  0.00000E+00  1.01929E+00
 6542.00  1.04565E+00  1.00579E+00  0.00000E+00  1.01493E+00
 6544.00  1.02961E+00  9.97220E-01  0.00000E+00  1.00697E+00
 6546.00  1.05242E+00  9.86893E-01  0.00000E+00  9.96979E-01
 6548.00  1.16489E+00  9.77436E-01  0.00000E+00  9.87299E-01
 6550.00  1.27343E+00  9.68691E-01  0.00000E+00  9.78121E-01
 6552.00  1.25870E+00  9.58281E-01  0.00000E+00  9.67983E-01
 6554.00  1.13423E+00  9.43593E-01  0.00000E+00  9.54440E-01
 6556.00  1.04543E+00  9.23167E-01  0.00000E+00  9.34783E-01
 6558.00  1.05627E+00  8.96449E-01  0.00000E+00  9.06514E-01
 6560.00  1.25738E+00  8.64676E-01  0.00000E+00  8.69736E-01
 6562.00  1.78721E+00  8.34692E-01  0.00000E+00  8.32613E-01
 6564.00  2.40914E+00  8.19870E-01  0.00000E+00  8.12714E-01
 6566.00  2.54835E+00  8.27250E-01  0.00000E+00  8.19535E-01
 6568.00  2.04512E+00  8.51707E-01  0.00000E+00  8.46885E-01
 6570.00  1.40936E+00  8.82264E-01  0.00000E+00  8.81163E-01
 6572.00  1.06380E+00  9.09431E-01  0.00000E+00  9.10490E-01
 6574.00  9.65719E-01  9.30181E-01  0.00000E+00  9.31320E-01
 6576.00  9.63373E-01  9.46760E-01  0.00000E+00  9.46750E-01
 6578.00  9.92789E-01  9.61090E-01  0.00000E+00  9.59761E-01
 6580.00  1.07338E+00  9.73225E-01  0.00000E+00  9.70857E-01
 6582.00  1.28975E+00  9.83162E-01  0.00000E+00  9.79782E-01
 6584.00  1.59587E+00  9.91151E-01  0.00000E+00  9.86365E-01
 6586.00  1.73715E+00  9.97078E-01  0.00000E+00  9.90542E-01
 6588.00  1.58394E+00  1.00035E+00  0.00000E+00  9.92231E-01
 6590.00  1.27964E+00  9.99736E-01  0.00000E+00  9.90658E-01
 6592.00  1.05031E+00  9.95378E-01  0.00000E+00  9.86082E-01
 6594.00  9.78450E-01  9.90733E-01  0.00000E+00  9.81663E-01
 6596.00  9.87514E-01  9.89584E-01  0.00000E+00  9.80722E-01
 6598.00  1.00674E+00  9.92843E-01  0.00000E+00  9.83720E-01
 6600.00  1.02787E+00  9.99247E-01  0.00000E+00  9.89273E-01
 6602.00  1.03527E+00  1.00541E+00  0.00000E+00  9.94299E-01
 6604.00  1.01152E+00  1.00842E+00  0.00000E+00  9.96475E-01
 6606.00  9.89420E-01  1.00794E+00  0.00000E+00  9.95941E-01
 6608.00  9.92205E-01  1.00615E+00  0.00000E+00  9.94649E-01
 6610.00  9.99326E-01  1.00630E+00  3.44832E+01  9.95219E-01
 6612.00  9.84166E-01  1.00990E+00  3.49676E+01  9.98607E-01
 6614.00  9.83890E-01  1.01592E+00  3.50224E+01  1.00370E+00
 6616.00  1.01033E+00  1.02232E+00  3.41501E+01  1.00888E+00
 6618.00  1.03463E+00  1.02676E+00  3.31454E+01  1.01237E+00
 6620.00  1.02040E+00  1.02806E+00  3.44977E+01  1.01343E+00
 6622.00  1.00901E+00  1.02585E+00  3.55407E+01  1.01185E+00
 6624.00  1.03662E+00  1.02123E+00  3.56866E+01  1.00832E+00
 6626.00  1.03250E+00  1.01631E+00  3.53844E+01  1.00443E+00
 6628.00  1.01154E+00  1.01200E+00  3.62347E+01  1.00113E+00
 6630.00  9.88856E-01  1.00808E+00  3.49072E+01  9.98367E-01
 6632.00  9.66057E-01  1.00447E+00  3.56507E+01  9.95809E-01
 6634.00  9.72384E-01  1.00224E+00  3.38912E+01  9.93931E-01
 6636.00  9.78524E-01  1.00290E+00  3.52074E+01  9.93825E-01
 6638.00  9.94436E-01  1.00588E+00  3.49010E+01  9.95260E-01
 6640.00  1.01114E+00  1.00926E+00  3.45094E+01  9.97051E-01
 6642.00  1.00640E+00  1.01113E+00  3.49504E+01  9.97894E-01
 6644.00  9.94330E-01  1.01095E+00  3.57794E+01  9.97571E-01
 6646.00  9.99085E-01  1.00990E+00  3.51887E+01  9.97082E-01
 6648.00  1.00552E+00  1.00878E+00  3.70162E+01  9.96674E-01
 6650.00  1.01562E+00  1.00797E+00  3.51500E+01  9.96185E-01
 6652.00  1.01603E+00  1.00721E+00  3.48928E+01  9.95278E-01
 6654.00  1.00552E+00  1.00637E+00  3.53215E+01  9.94040E-01
 6656.00  1.00500E+00  1.00512E+00  3.50566E+01  9.92539E-01
 6658.00  1.01138E+00  1.00305E+00  3.39761E+01  9.90598E-01
 6660.00  1.00822E+00  9.99763E-01  3.44305E+01  9.87855E-01
 6662.00  1.01040E+00  9.95613E-01  3.51331E+01  9.84497E-01
 6664.00  1.01136E+00  9.92459E-01  3.48826E+01  9.81944E-01
 6666.00  1.00395E+00  9.92483E-01  3.54315E+01  9.81815E-01
 6668.00  1.00588E+00  9.96277E-01  3.55338E+01  9.84408E-01
 6670.00  1.02394E+00  1.00229E+00  3.58439E+01  9.88596E-01
 6672.00  1.04163E+00  1.00717E+00  3.64863E+01  9.91955E-01
 6674.00  1.02856E+00  1.00786E+00  3.53120E+01  9.92350E-01
 6676.00  9.92264E-01  1.00348E+00  3.50322E+01  9.89046E-01
 6678.00  9.94980E-01  9.96567E-01  3.43192E+01  9.83621E-01
 6680.00  1.02074E+00  9.91800E-01  3.40453E+01  9.79406E-01
 6682.00  1.01412E+00  9.91626E-01  3.47552E+01  9.78211E-01
 6684.00  9.90866E-01  9.95697E-01  3.48541E+01  9.79968E-01
 6686.00  9.75309E-01  1.00141E+00  3.52813E+01  9.82984E-01
 6688.00  9.74254E-01  1.00623E+00  3.49608E+01  9.85631E-01
 6690.00  9.85344E-01  1.00884E+00  3.56159E+01  9.87158E-01
 6692.00  9.93302E-01  1.00880E+00  3.51314E+01  9.87395E-01
 6694.00  9.99371E-01  1.00651E+00  3.55068E+01  9.86585E-01
 6696.00  9.96418E-01  1.00314E+00  0.00000E+00  9.85362E-01
 6698.00  9.72491E-01  1.00051E+00  0.00000E+00  9.84763E-01
 6700.00  9.56827E-01  9.99376E-01  0.00000E+00  9.85110E-01
 6702.00  9.59699E-01  9.99005E-01  0.00000E+00  9.85781E-01
 6704.00  9.66010E-01  9.98402E-01  0.00000E+00  9.86100E-01
 6706.00  9.74638E-01  9.97328E-01  0.00000E+00  9.85931E-01
 6708.00  9.80525E-01  9.95771E-01  0.00000E+00  9.85144E-01
 6710.00  9.78661E-01  9.93339E-01  0.00000E+00  9.83346E-01
 6712.00  9.83048E-01  9.89177E-01  0.00000E+00  9.79848E-01
 6714.00  1.06602E+00  9.83151E-01  0.00000E+00  9.74430E-01
 6716.00  1.25488E+00  9.76873E-01  0.00000E+00  9.68368E-01
 6718.00  1.40853E+00  9.73154E-01  0.00000E+00  9.64126E-01
 6720.00  1.39356E+00  9.73680E-01  0.00000E+00  9.63519E-01
 6722.00  1.23962E+00  9.77620E-01  0.00000E+00  9.66114E-01
 6724.00  1.10571E+00  9.82968E-01  0.00000E+00  9.70259E-01
 6726.00  1.05941E+00  9.87785E-01  0.00000E+00  9.74250E-01
 6728.00  1.05065E+00  9.91673E-01  0.00000E+00  9.77570E-01
 6730.00  1.10077E+00  9.94781E-01  0.00000E+00  9.80202E-01
 6732.00  1.21352E+00  9.97049E-01  0.00000E+00  9.82052E-01
 6734.00  1.25605E+00  9.98212E-01  0.00000E+00  9.82910E-01
 6736.00  1.18649E+00  9.97974E-01  0.00000E+00  9.82574E-01
 6738.00  1.09012E+00  9.96328E-01  0.00000E+00  9.81106E-01
 6740.00  1.02668E+00  9.93970E-01  0.00000E+00  9.79189E-01
 6742.00  1.01158E+00  9.91525E-01  0.00000E+00  9.77433E-01
 6744.00  1.00570E+00  9.89408E-01  0.00000E+00  9.76067E-01
 6746.00  9.77278E-01  9.87585E-01  0.00000E+00  9.74836E-01
 6748.00  9.63617E-01  9.85792E-01 -1.20000E+01  9.73442E-01
 6750.00  9.92196E-01  9.84357E-01 -1.20000E+01  9.72388E-01
 6752.00  9.50304E-01  9.84267E-01 -1.20000E+01  9.72710E-01
 6754.00  8.42154E-01  9.86644E-01 -1.20000E+01  9.75133E-01
 6756.00  7.48980E-01  9.91762E-01 -1.20000E+01  9.79537E-01
 6758.00  7.17097E-01  9.98376E-01 -1.20000E+01  9.84816E-01
 6760.00  7.50780E-01  1.00433E+00 -1.20000E+01  9.89437E-01
 6762.00  8.20784E-01  1.00765E+00 -1.20000E+01  9.92095E-01
 6764.00  8.62514E-01  1.00754E+00 -1.20000E+01  9.92248E-01
 6766.00  8.80191E-01  1.00468E+00 -1.20000E+01  9.90308E-01
 6768.00  9.17322E-01  1.00122E+00 -1.20000E+01  9.87867E-01
 6770.00  9.47575E-01  9.99529E-01 -1.20000E+01  9.86808E-01
 6772.00  9.35521E-01  1.00101E+00 -1.20000E+01  9.88256E-01
 6774.00  9.13257E-01  1.00533E+00 -1.20000E+01  9.92105E-01
 6776.00  9.08922E-01  1.01013E+00 -1.20000E+01  9.96639E-01
 6778.00  9.25732E-01  1.01265E+00 -1.20000E+01  9.99564E-01
 6780.00  9.24060E-01  1.01112E+00 -1.20000E+01  9.99151E-01
 6782.00  8.89002E-01  1.00573E+00 -1.20000E+01  9.95258E-01
 6784.00  8.94042E-01  9.99027E-01 -1.20000E+01  9.89781E-01
 6786.00  9.24553E-01  9.94308E-01 -1.20000E+01  9.85329E-01
 6788.00  9.30435E-01  9.93138E-01 -1.20000E+01  9.83417E-01
 6790.00  9.25377E-01  9.94727E-01 -1.20000E+01  9.83797E-01
 6792.00  9.36673E-01  9.97131E-01 -1.20000E+01  9.85287E-01
 6794.00  9.60805E-01  9.98971E-01 -1.20000E+01  9.86996E-01
 6796.00  9.97774E-01  1.00026E+00 -1.20000E+01  9.88891E-01
 6798.00  1.02995E+00  1.00158E+00 -1.20000E+01  9.91136E-01
 6800.00  1.03343E+00  1.00324E+00 -1.20000E+01  9.93594E-01
 6802.00  9.98804E-01  1.00494E+00 -1.20000E+01  9.95707E-01
 6804.00  9.69316E-01  1.00617E+00 -1.20000E+01  9.97010E-01
 6806.00  9.82865E-01  1.00665E+00 -1.20000E+01  9.97541E-01
 6808.00  1.03226E+00  1.00641E+00 -1.20000E+01  9.97628E-01
 6810.00  1.06160E+00  1.00572E+00 -1.20000E+01  9.97547E-01
 6812.00  1.02948E+00  1.00496E+00  2.96805E+01  9.97400E-01
 6814.00  9.92623E-01  1.00455E+00  3.25624E+01  9.97246E-01
 6816.00  9.89270E-01  1.00505E+00  3.27723E+01  9.97468E-01
 6818.00  1.00074E+00  1.00661E+00  3.26482E+01  9.98385E-01
 6820.00  1.00401E+00  1.00894E+00  3.30618E+01  1.00003E+00
 6822.00  1.00388E+00  1.01169E+00  3.29402E+01  1.00223E+00
 6824.00  1.01410E+00  1.01411E+00  3.21367E+01  1.00430E+00
 6826.00  1.01766E+00  1.01554E+00  3.14177E+01  1.00563E+00
 6828.00  1.01297E+00  1.01596E+00  3.25166E+01  1.00625E+00
 6830.00  9.99610E-01  1.01607E+00  3.16591E+01  1.00684E+00
 6832.00  9.66273E-01  1.01615E+00  2.80687E+01  1.00771E+00
 6834.00  9.60365E-01  1.01570E+00  2.68155E+01  1.00837E+00
 6836.00  1.00190E+00  1.01365E+00  2.70663E+01  1.00764E+00
 6838.00  1.03889E+00  1.00957E+00  3.04992E+01  1.00479E+00
 6840.00  1.05215E+00  1.00467E+00  3.19322E+01  1.00068E+00
 6842.00  1.06429E+00  1.00143E+00  3.28333E+01  9.97546E-01
 6844.00  1.04596E+00  1.00178E+00  3.33328E+01  9.97284E-01
 6846.00  1.03488E+00  1.00518E+00  3.32295E+01  9.99731E-01
 6848.00  1.01359E+00  1.00924E+00  3.29479E+01  1.00293E+00
 6850.00  9.94071E-01  1.01148E+00  3.26085E+01  1.00470E+00
 6852.00  1.01067E+00  1.01091E+00  3.14528E+01  1.00400E+00
 6854.00  1.02258E+00  1.00806E+00  3.05363E+01  1.00128E+00
 6856.00  1.03937E+00  1.00437E+00  2.77216E+01  9.98110E-01
 6858.00  1.06428E+00  1.00120E+00  2.33414E+01  9.96017E-01
 6860.00  1.05255E+00  9.99329E-01  2.46645E+01  9.95667E-01
 6862.00  1.03174E+00  9.99293E-01  2.63130E+01  9.96949E-01
 6864.00  1.02570E+00  1.00087E+00  2.77878E+01  9.99032E-01
 6866.00  1.01801E+00  1.00276E+00  3.19539E+01  1.00071E+00
 6868.00  9.98880E-01  1.00403E+00  3.36555E+01  1.00161E+00
 6870.00  9.86844E-01  1.00456E+00  3.44453E+01  1.00220E+00
 6872.00  1.00288E+00  1.00495E+00  3.21993E+01  1.00335E+00
 6874.00  1.01970E+00  1.00619E+00  3.13636E+01  1.00574E+00
 6876.00  1.03790E+00  1.00862E+00  3.09349E+01  1.00916E+00
 6878.00  1.04026E+00  1.01159E+00  3.18616E+01  1.01261E+00
 6880.00  1.03840E+00  1.01398E+00  3.08474E+01  1.01490E+00
 6882.00  1.04861E+00  1.01553E+00  3.17690E+01  1.01583E+00
 6884.00  1.04756E+00  1.01718E+00  3.12769E+01  1.01646E+00
 6886.00  1.03212E+00  1.01995E+00  3.21098E+01  1.01808E+00
 6888.00  1.02447E+00  1.02404E+00  3.28951E+01  1.02121E+00
 6890.00  1.05246E+00  1.02845E+00  3.21995E+01  1.02516E+00
 6892.00  1.07415E+00  1.03189E+00  3.08941E+01  1.02876E+00
 6894.00  1.08406E+00  1.03380E+00  2.98711E+01  1.03130E+00
 6896.00  1.08723E+00  1.03457E+00  2.92674E+01  1.03293E+00
 6898.00  1.07014E+00  1.03496E+00  3.00213E+01  1.03435E+00
 6900.00  1.04359E+00  1.03555E+00  3.11278E+01  1.03624E+00
 6902.00  1.04169E+00  1.03651E+00  3.26976E+01  1.03894E+00
 6904.00  1.07433E+00  1.03757E+00  3.14037E+01  1.04213E+00
 6906.00  1.08241E+00  1.03849E+00  3.17370E+01  1.04509E+00
 6908.00  1.05894E+00  1.03899E+00  3.29422E+01  1.04686E+00
 6910.00  1.03641E+00  1.03878E+00  3.38199E+01  1.04667E+00
 6912.00  1.02463E+00  1.03779E+00  3.38539E+01  1.04447E+00
 6914.00  1.03774E+00  1.03640E+00  3.19517E+01  1.04116E+00
 6916.00  1.05830E+00  1.03530E+00  3.07206E+01  1.03824E+00
 6918.00  1.06134E+00  1.03474E+00  3.10212E+01  1.03668E+00
 6920.00  1.05423E+00  1.03419E+00  3.04425E+01  1.03640E+00
 6922.00  1.04786E+00  1.03251E+00  3.03531E+01  1.03645E+00
 6924.00  1.04566E+00  1.02926E+00  3.06533E+01  1.03616E+00
 6926.00  1.03591E+00  1.02544E+00  3.14572E+01  1.03589E+00
 6928.00  1.02341E+00  1.02260E+00  3.13985E+01  1.03628E+00
 6930.00  1.02958E+00  1.02152E+00  3.15459E+01  1.03746E+00
 6932.00  1.05200E+00  1.02211E+00  3.13894E+01  1.03907E+00
 6934.00  1.06798E+00  1.02390E+00  2.82565E+01  1.04079E+00
 6936.00  1.06323E+00  1.02639E+00  2.65410E+01  1.04256E+00
 6938.00  1.03602E+00  1.02900E+00 -2.40000E+01  1.04424E+00
 6940.00  1.02854E+00  1.03091E+00 -2.40000E+01  1.04540E+00
 6942.00  1.04110E+00  1.03127E+00 -2.40000E+01  1.04552E+00
 6944.00  1.01654E+00  1.03015E+00 -2.40000E+01  1.04473E+00
 6946.00  9.95357E-01  1.02861E+00 -2.40000E+01  1.04398E+00
 6948.00  1.01573E+00  1.02757E+00 -2.40000E+01  1.04394E+00
 6950.00  1.03323E+00  1.02717E+00 -2.40000E+01  1.04451E+00
'''

if __name__ == '__main__':
    # Fake the run.
    grid = read_grid()
    for run in grid.runs:
        outfilename = path.join(grid.outDir, run.outFile)
        output_data = rot_bits(output_data)
        save_output(outfilename, output_data)
        print 'saved %s' % outfilename
        # Pretend to have worked.
        print 'sleeping for %.1f seconds.' % interval
        time.sleep(interval)

    print 'Done!'
    sys.exit(0)
