/* file: $RCSfile: delta_T.c,v $
** rcsid: $Id: delta_T.c,v 1.5 2003/09/03 20:19:12 jwp Exp $
** Copyright Jeffrey W Percival
** *******************************************************************
** Space Astronomy Laboratory
** University of Wisconsin
** 1150 University Avenue
** Madison, WI 53706 USA
** *******************************************************************
** Do not use this software without permission.
** Do not use this software without attribution.
** Do not remove or alter any of the lines above.
** *******************************************************************
*/
static char *rcsid = "$Id: delta_T.c,v 1.5 2003/09/03 20:19:12 jwp Exp $";

/*
** *******************************************************************
** $RCSfile: delta_T.c,v $
** (ET - UT1) before 1984.0, (TDT - UT1) after 1984.0
** return the different in seconds
** *******************************************************************
*/

#include "astro.h"

struct s_ttab {
	double y;	/* UT1 in years */
	double dt;	/* delta_T in seconds */
};

static struct s_ttab ttab[] = {
	{ 1620,	124 },
	{ 1621,	119 },
	{ 1622,	115 },
	{ 1623,	110 },
	{ 1624,	106 },
	{ 1625,	102 },
	{ 1626,	98 },
	{ 1627,	95 },
	{ 1628,	91 },
	{ 1629,	88 },
	{ 1630,	85 },
	{ 1631,	82 },
	{ 1632,	79 },
	{ 1633,	77 },
	{ 1634,	74 },
	{ 1635,	72 },
	{ 1636,	70 },
	{ 1637,	67 },
	{ 1638,	65 },
	{ 1639,	63 },
	{ 1640,	62 },
	{ 1641,	60 },
	{ 1642,	58 },
	{ 1643,	57 },
	{ 1644,	55 },
	{ 1645,	54 },
	{ 1646,	53 },
	{ 1647,	51 },
	{ 1648,	50 },
	{ 1649,	49 },
	{ 1650,	48 },
	{ 1651,	47 },
	{ 1652,	46 },
	{ 1653,	45 },
	{ 1654,	44 },
	{ 1655,	43 },
	{ 1656,	42 },
	{ 1657,	41 },
	{ 1658,	40 },
	{ 1659,	38 },
	{ 1660,	37 },
	{ 1661,	36 },
	{ 1662,	35 },
	{ 1663,	34 },
	{ 1664,	33 },
	{ 1665,	32 },
	{ 1666,	31 },
	{ 1667,	30 },
	{ 1668,	28 },
	{ 1669,	27 },
	{ 1670,	26 },
	{ 1671,	25 },
	{ 1672,	24 },
	{ 1673,	23 },
	{ 1674,	22 },
	{ 1675,	21 },
	{ 1676,	20 },
	{ 1677,	19 },
	{ 1678,	18 },
	{ 1679,	17 },
	{ 1680,	16 },
	{ 1681,	15 },
	{ 1682,	14 },
	{ 1683,	14 },
	{ 1684,	13 },
	{ 1685,	12 },
	{ 1686,	12 },
	{ 1687,	11 },
	{ 1688,	11 },
	{ 1689,	10 },
	{ 1690,	10 },
	{ 1691,	10 },
	{ 1692,	9 },
	{ 1693,	9 },
	{ 1694,	9 },
	{ 1695,	9 },
	{ 1696,	9 },
	{ 1697,	9 },
	{ 1698,	9 },
	{ 1699,	9 },
	{ 1700,	9 },
	{ 1701,	9 },
	{ 1702,	9 },
	{ 1703,	9 },
	{ 1704,	9 },
	{ 1705,	9 },
	{ 1706,	9 },
	{ 1707,	9 },
	{ 1708,	10 },
	{ 1709,	10 },
	{ 1710,	10 },
	{ 1711,	10 },
	{ 1712,	10 },
	{ 1713,	10 },
	{ 1714,	10 },
	{ 1715,	10 },
	{ 1716,	10 },
	{ 1717,	11 },
	{ 1718,	11 },
	{ 1719,	11 },
	{ 1720,	11 },
	{ 1721,	11 },
	{ 1722,	11 },
	{ 1723,	11 },
	{ 1724,	11 },
	{ 1725,	11 },
	{ 1726,	11 },
	{ 1727,	11 },
	{ 1728,	11 },
	{ 1729,	11 },
	{ 1730,	11 },
	{ 1731,	11 },
	{ 1732,	11 },
	{ 1733,	11 },
	{ 1734,	12 },
	{ 1735,	12 },
	{ 1736,	12 },
	{ 1737,	12 },
	{ 1738,	12 },
	{ 1739,	12 },
	{ 1740,	12 },
	{ 1741,	12 },
	{ 1742,	12 },
	{ 1743,	12 },
	{ 1744,	13 },
	{ 1745,	13 },
	{ 1746,	13 },
	{ 1747,	13 },
	{ 1748,	13 },
	{ 1749,	13 },
	{ 1750,	13 },
	{ 1751,	14 },
	{ 1752,	14 },
	{ 1753,	14 },
	{ 1754,	14 },
	{ 1755,	14 },
	{ 1756,	14 },
	{ 1757,	14 },
	{ 1758,	15 },
	{ 1759,	15 },
	{ 1760,	15 },
	{ 1761,	15 },
	{ 1762,	15 },
	{ 1763,	15 },
	{ 1764,	15 },
	{ 1765,	16 },
	{ 1766,	16 },
	{ 1767,	16 },
	{ 1768,	16 },
	{ 1769,	16 },
	{ 1770,	16 },
	{ 1771,	16 },
	{ 1772,	16 },
	{ 1773,	16 },
	{ 1774,	16 },
	{ 1775,	17 },
	{ 1776,	17 },
	{ 1777,	17 },
	{ 1778,	17 },
	{ 1779,	17 },
	{ 1780,	17 },
	{ 1781,	17 },
	{ 1782,	17 },
	{ 1783,	17 },
	{ 1784,	17 },
	{ 1785,	17 },
	{ 1786,	17 },
	{ 1787,	17 },
	{ 1788,	17 },
	{ 1789,	17 },
	{ 1790,	17 },
	{ 1791,	17 },
	{ 1792,	16 },
	{ 1793,	16 },
	{ 1794,	16 },
	{ 1795,	16 },
	{ 1796,	15 },
	{ 1797,	15 },
	{ 1798,	14 },
	{ 1799,	14 },
	{ 1800,	13.7 },
	{ 1801,	13.4 },
	{ 1802,	13.1 },
	{ 1803,	12.9 },
	{ 1804,	12.7 },
	{ 1805,	12.6 },
	{ 1806,	12.5 },
	{ 1807,	12.5 },
	{ 1808,	12.5 },
	{ 1809,	12.5 },
	{ 1810,	12.5 },
	{ 1811,	12.5 },
	{ 1812,	12.5 },
	{ 1813,	12.5 },
	{ 1814,	12.5 },
	{ 1815,	12.5 },
	{ 1816,	12.5 },
	{ 1817,	12.4 },
	{ 1818,	12.3 },
	{ 1819,	12.2 },
	{ 1820,	12.0 },
	{ 1821,	11.7 },
	{ 1822,	11.4 },
	{ 1823,	11.1 },
	{ 1824,	10.6 },
	{ 1825,	10.2 },
	{ 1826,	9.6 },
	{ 1827,	9.1 },
	{ 1828,	8.6 },
	{ 1829,	8.0 },
	{ 1830,	7.5 },
	{ 1831,	7.0 },
	{ 1832,	6.6 },
	{ 1833,	6.3 },
	{ 1834,	6.0 },
	{ 1835,	5.8 },
	{ 1836,	5.7 },
	{ 1837,	5.6 },
	{ 1838,	5.6 },
	{ 1839,	5.6 },
	{ 1840,	5.7 },
	{ 1841,	5.8 },
	{ 1842,	5.9 },
	{ 1843,	6.1 },
	{ 1844,	6.2 },
	{ 1845,	6.3 },
	{ 1846,	6.5 },
	{ 1847,	6.6 },
	{ 1848,	6.8 },
	{ 1849,	6.9 },
	{ 1850,	7.1 },
	{ 1851,	7.2 },
	{ 1852,	7.3 },
	{ 1853,	7.4 },
	{ 1854,	7.5 },
	{ 1855,	7.6 },
	{ 1856,	7.7 },
	{ 1857,	7.7 },
	{ 1858,	7.8 },
	{ 1859,	7.8 },
	{ 1860,	7.88 },
	{ 1861,	7.82 },
	{ 1862,	7.54 },
	{ 1863,	6.97 },
	{ 1864,	6.40 },
	{ 1865,	6.02 },
	{ 1866,	5.41 },
	{ 1867,	4.10 },
	{ 1868,	2.92 },
	{ 1869,	1.82 },
	{ 1870,	1.61 },
	{ 1871,	0.10 },
	{ 1872,	-1.02 },
	{ 1873,	-1.28 },
	{ 1874,	-2.69 },
	{ 1875,	-3.24 },
	{ 1876,	-3.64 },
	{ 1877,	-4.54 },
	{ 1878,	-4.71 },
	{ 1879,	-5.11 },
	{ 1880,	-5.40 },
	{ 1881,	-5.42 },
	{ 1882,	-5.20 },
	{ 1883,	-5.46 },
	{ 1884,	-5.46 },
	{ 1885,	-5.79 },
	{ 1886,	-5.63 },
	{ 1887,	-5.64 },
	{ 1888,	-5.80 },
	{ 1889,	-5.66 },
	{ 1890,	-5.87 },
	{ 1891,	-6.01 },
	{ 1892,	-6.19 },
	{ 1893,	-6.64 },
	{ 1894,	-6.44 },
	{ 1895,	-6.47 },
	{ 1896,	-6.09 },
	{ 1897,	-5.76 },
	{ 1898,	-4.66 },
	{ 1899,	-3.74 },
	{ 1900,	-2.72 },
	{ 1901,	-1.54 },
	{ 1902,	-0.02 },
	{ 1903,	1.24 },
	{ 1904,	2.64 },
	{ 1905,	3.86 },
	{ 1906,	5.37 },
	{ 1907,	6.14 },
	{ 1908,	7.75 },
	{ 1909,	9.13 },
	{ 1910,	10.46 },
	{ 1911,	11.53 },
	{ 1912,	13.36 },
	{ 1913,	14.65 },
	{ 1914,	16.01 },
	{ 1915,	17.20 },
	{ 1916,	18.24 },
	{ 1917,	19.06 },
	{ 1918,	20.25 },
	{ 1919,	20.95 },
	{ 1920,	21.16 },
	{ 1921,	22.25 },
	{ 1922,	22.41 },
	{ 1923,	23.03 },
	{ 1924,	23.49 },
	{ 1925,	23.62 },
	{ 1926,	23.86 },
	{ 1927,	24.49 },
	{ 1928,	24.34 },
	{ 1929,	24.08 },
	{ 1930,	24.02 },
	{ 1931,	24.00 },
	{ 1932,	23.87 },
	{ 1933,	23.95 },
	{ 1934,	23.86 },
	{ 1935,	23.93 },
	{ 1936,	23.73 },
	{ 1937,	23.92 },
	{ 1938,	23.96 },
	{ 1939,	24.02 },
	{ 1940,	24.33 },
	{ 1941,	24.83 },
	{ 1942,	25.30 },
	{ 1943,	25.70 },
	{ 1944,	26.24 },
	{ 1945,	26.77 },
	{ 1946,	27.28 },
	{ 1947,	27.78 },
	{ 1948,	28.25 },
	{ 1949,	28.71 },
	{ 1950,	29.15 },
	{ 1951,	29.57 },
	{ 1952,	29.97 },
	{ 1953,	30.36 },
	{ 1954,	30.72 },
	{ 1955,	31.07 },
	{ 1956,	31.35 },
	{ 1957,	31.68 },
	{ 1958,	32.18 },
	{ 1959,	32.68 },
	{ 1960,	33.15 },
	{ 1961,	33.59 },
	{ 1962,	34.00 },
	{ 1963,	34.47 },
	{ 1964,	35.03 },
	{ 1965,	35.73 },
	{ 1966,	36.54 },
	{ 1967,	37.43 },
	{ 1968,	38.29 },
	{ 1969,	39.20 },
	{ 1970,	40.18 },
	{ 1971,	41.17 },
	{ 1972,	42.23 },
	{ 1973,	43.37 },
	{ 1974,	44.49 },
	{ 1975,	45.48 },
	{ 1976,	46.46 },
	{ 1977,	47.52 },
	{ 1978,	48.53 },
	{ 1979,	49.59 },
	{ 1980,	50.54 },
	{ 1981,	51.38 },
	{ 1982,	52.17 },
	{ 1983,	52.96 },
	{ 1984,	53.79 },
	{ 1985,	54.34 },
	{ 1986,	54.87 },
	{ 1987,	55.32 },
	{ 1988,	55.8 },
	{ 1989,	56.3 },
	{ 1990,	56.7 },
};

#define N	(sizeof(ttab) / sizeof(struct s_ttab))

double
delta_T(double ut1)
{
    double dt;
    double slope;
    double y;
    int i1;	/* lower bracketing entry */
    int i2;	/* upper bracketing entry */
    int i;

    /* get the ut1 year */
    y = j2y(ut1);

    /* find the tabular entry just less than this time */
    i1 = 0;
    for (i = 0; i < N-1; i++) {
	if (ttab[i].y < y) {
	    i1 = i;
	}
    }
    i2 = i1 + 1;

    /* linearly interpolate */
    slope = (ttab[i2].dt - ttab[i1].dt) / (ttab[i2].y - ttab[i1].y);
    dt = ttab[i1].dt + slope * (y - ttab[i1].y);

    return(dt);
}
