- expose all the pkcs5/oaep/pss padding functions
- passing `hash=None` to sign/verify will cause it to assume it was passed a digest

- consider allowing `padding='pkcs1'` or `padding='pkcs1.5'

- Replace all generic errors with appropriate standard lib errors.
  To ease the transition, make a new ValueError which extends from the real
  ValueError AND tomcrypt.LibError
  
- Document how Python 3 implementation works.
    - cipher names should be strings
    - keys and ivs are bytes
    - pick upper or lower case for all hex output
    - test all api types
    - update docs to have string prefixes

- Document ECC.
- Test EAX.

- Decide if going to allow for custom ECC curves at all. ecc_decrypt_key
  does not have the logic required for using a custom key as it uses
  ecc_import instead of ecc_ex_import to parse the autogenerated public
  key, and as such it does not work properly with custom curves (as the
  public key will be assumed to be one of the NIST recommended ones).
    - can potentially patch LTC to make the assumption that the public
      key is using the same curve as the one we are calling decrypt on.
    - LTC already has the main 8 keys that most people would use
    - `openssl ecparam -list_curves` shows there are a couple more
      versions of the various NIST curves that LTC has; need to look at
      these and see what is up
    - picking curves is not a trivial business, so I guess 99% of cases
      will be very happy with the recomended curves.


    - Curves are decriptors
        Curve(100) would give me the 112 curve
        curve.make_key() would generate a key
        idx for index into recommended curves
    - still use ecc_make_key_ex, but manually set the curve.idx
        or do ecc_make_key(x, x, self.curve.size, &self.key



- Should ecc.Key.as_string(...) default to ansi format, or LTC?

- hash.Descriptor.factory(user_input) and prng.PRNG.factory(user_input)
    - instead of conform_hash and conform_prng
    - name it better

- utils.is_pem_encoded, pem_encode, pem_decode -> headers, body
       The PEM private key format uses the header and footer lines:

        -----BEGIN EC PRIVATE KEY-----
        -----END EC PRIVATE KEY-----

       The PEM public key format uses the header and footer lines:

        -----BEGIN PUBLIC KEY-----
        -----END PUBLIC KEY-----


- signature verification should accept message and signature in any
  order
    - if an exception is thrown then try the second ordering

- explicit PRNG.done()
- PRNG descriptors

- add tests for everything in the readme

- write a timing-attack-safe string comparison function

- test with Python 3

- options for fixing the linking issues:

	1) Use this trick, but it won't ever work with Windows and I feel that 
	there could be symbol collisions in the future unless I prefix all my 
	variables names, etc.
	
	2) Develop more specific platform-dependent fixes (special linking per 
	platform, etc) 
	
	3) Jam everything together into the one main core module, and write 
	pure Python modules to import the right parts and provide tiny 
	wrappers to restore the class naming, etc.
	
	4) Wrap all of the C functions in cdef wrappers which are importable. All global state would also need to have functions which return pointers to them.

- Standardize on *_length vs *_len vs *_size. The problem with this is that
sometimes it feels more natural to use one than the other. While there may be
value in trying to make it uniform, the purpose of this project is not to get
the API to the point where it is trivially memorizable. There is also, perhaps,
value in refactoring the original API to something more Python like, but
keeping naming schemes exactly the way they are to the original documentation
still applies.

- The memory encrypt/decrypt/hash functions can be methods of the descriptors.
  I actually don't think I'm even going to bother implementing them for the
  moment.


Remaining to Implement
-----------------------

- ctr mode flags (page 38 of pdf):
    CTR COUNTER LITTLE ENDIAN
    CTR COUNTER BIG ENDIAN
    LTC CTR RFC3686
- call cipher done function: We may not see the need for it, but lots of
  other things may
    - we need to provide for this to be done manually, as eax actually
      returns a value from this.
    - automatically call it if it wasnt already called
    - maybe need to check in all the other functions if it has been called
      ; test to see if it explodes
- Add cipher auth modes:
    - EAX on pdf page 46
        - has extra nonce and header in init call
        - extra eax_addheader function
        - the done call has a length for the tag, and returns the tag.
        Perhaps I should standardize that the done call returns a string
        but for nearly everything it will return an empty string. Since
        done currently returns nothing, all this does is unify the API so
        that code simply have to concat everything together, regardless
        of the type of value this returns.
    - OCB on pdf page 50
        - has extra nonce in the init (same length as block size)
        - ocb_encrypt/decrypt assume the length to be the block size.
          hopefully the descriptor functions do not do the same thing
        - the done does different things for encrypt/decrypt... nasty
        - has convenient functions to do all of this
    - CCM on pdf page 53
        - it is only for packet mode, so only the memory function exists.
        I would still have this expose exactly the same API, however. The
        constructor would simply hold onto the key and cipher, while the
        encrypt/decrypt methods would use this special function.
    - GCM on pdf page 56
        - init is the same
        - adds a `gcm_add_iv` function which should be called as the step
          after init
        - adds a `gcm_add_aad` function which should be called after adding
          the iv and before encrypting. need not be called for security
          reasons
        - crypting is done with the `gcm_process` function.
        - done also outputs here
- Document the crazy way the copy function works, and that it may not
  be the nicest thing to be doing.
- expose the hash oid via the descriptor and `find_hash_oid`
    unsigned long OID[16] and unsigned long OIDlen
- use the hash_memory, hash_file, and hash_filehandle on the descriptor
  class
- make sure copy works fine for chc
- test that we can use two chcs at the same time through each other
- use the hmac_memory and hmac_file on the mac descriptor. is there a
  hmac_filehandle as well? there is also a set for omac, pmac, xcbc, f9...
  pelican didn't say
- implement pelican and f9 macs from pdf page 69 and 73
- prng import/export on page 78. the descriptor has an ine export_size
  which indicates the length. descriptor has import/export functions as
  well on page 191
- perhaps export rng_get_bytes as it's own thing
- consider naming the secure rng "srng" or "sys" or something
- pkcs1 module
    - rsa pkcs1.5 padding on pdf page 101
    - rsa oaep in 103
    - rsa pss on 105
- expose rsa_exptmod in a more obvious way (maybe); page 108
- add the lparam arg to oaep
- ecc; evertyhing! page 117
    - keysize in bits should round up.
- consider having rsa key generation round the bits up to the next byte
  automatically
- dsa, everything! page 129
- asn1, everything! page 137
    - is this really nessesary?...
- reconsider the defaults I have given to all of the functions (ie pkcs5)
- base64 is on page 156, but seems unnessesary
- is_prime and rand_prime on page 157
- note that the same thread safety concerns exist as with the base library
- note that I am not bothering to implement the accelerated cipher functions
- note that I am not bother to wrap the math descriptors


