#!/usr/bin/python
# -*- coding: utf-8 -*-

import socket
import sys
import re

class ControlException(Exception):
  pass

class TorControl:
  def __init__(self, password='', host='127.0.0.1', port=int(9051)):
    self.host = (host, port)
    self.password = password
    
    self._connect(self.host)
  
  def _connect(self, host):
    try:
      self.torctl = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
      self.torctl.connect(host)
      self.connected = 1
    except Exception as errmsg:
      raise ControlException(errmsg)
    
    try:
      self.torctl.send("AUTHENTICATE \"%s\"\r\n" % self.password)
      status_code = self.torctl.recv(4096).rstrip()
      if not status_code:
        raise ControlException("Unresponsive tor control process?")
      if status_code == "250 OK":
        self.authenticated = 1
      else:
        raise ControlException(status_code)
    except Exception as errmsg:
      raise ControlException(errmsg)
  
  def signal(self, signal='', *args):
    if self.connected == 1 and self.authenticated == 1:
      self.torctl.send("SIGNAL %s\r\n" % signal)
      status_code = self.torctl.recv(4096).rstrip()
      if not status_code:
        raise ControlException("Unresponsive tor control process?")
      if status_code == "250 OK":
        return True
      else:
        return False
    else:
      raise ControlException("not connected/authenticated")