#!/usr/bin/python
# -*- coding: utf-8 -*-

import socket
import sys
import re

class ControlException(Exception):
  pass

class TorControl:
  def __init__(self, password='', host='127.0.0.1', port=int(9051)):
    self.host = (host, port)
    self.password = password
    self.closed = 0

    self._connect(self.host)

  def _connect(self, host):
    try:
      self.torctl = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
      self.torctl.connect(host)
      self.connected = 1
    except Exception as errmsg:
      raise ControlException(errmsg)
    try:
      self.torctl.send("AUTHENTICATE \"%s\"\r\n" % self.password.encode("utf-8"))
      status_code = self.torctl.recv(4096).rstrip()
      if not status_code:
        raise ControlException("Unresponsive tor control process?")
        self.torctl.close()
      if status_code == "250 OK":
        self.authenticated = 1
      else:
        raise ControlException(status_code)
    except Exception as errmsg:
      raise ControlException(errmsg)

  def close(self):
    if self.closed == 1:
      raise ControlException("already closed")
      return False
    try:
      self.torctl.send("QUIT\r\n")
      status_code = self.torctl.recv(4096).rstrip()
      if not status_code:
        raise ControlException("Unresponsive tor control process?")
        self.torctl.close()
        self.closed = 1
      if status_code == "250 closing connection":
        self.torctl.close()
        self.closed = 1
        return True
      else:
        raise ControlException(status_code)
        return False
    except Exception as errmsg:
      raise ControlException(errmsg)
    return False

  def signal(self, signal='', *args):
    if self.closed == 1:
      raise ControlException("already closed")
      return False
    if self.connected == 1 and self.authenticated == 1:
      self.torctl.send("SIGNAL %s\r\n" % signal.encode("utf-8"))
      status_code = self.torctl.recv(4096).rstrip()
      if not status_code:
        raise ControlException("Unresponsive tor control process?")
        self.torctl.close()
      if status_code == "250 OK":
        return True
      else:
        return False
    else:
      raise ControlException("not connected/authenticated")

  def setconf(self, option='', value='', debug=0, *args):
    if self.closed == 1:
      raise ControlException("already closed")
      return False
    if self.connected == 1 and self.authenticated == 1:
      self.torctl.send("SETCONF %s=%s\r\n" % (option.encode("utf-8"), value.encode("utf-8")))
      status_code = self.torctl.recv(4096).rstrip()
      if not status_code:
        raise ControlException(status_code)
      if status_code == "250 OK":
        return True
      else:
        if debug == 0:
          return False
        else:
          return status_code

  # setconf and resetconf contains *literally* the same code.

  def resetconf(self, option='', value='', debug=0, *args):
    if self.closed == 1:
      raise ControlException("already closed")
      return False
    if self.connected == 1 and self.authenticated == 1:
      self.torctl.send("RESETCONF %s=%s\r\n" % (option.encode("utf-8"), value.encode("utf-8")))
      status_code = self.torctl.recv(4096).rstrip()
      if not status_code:
        raise ControlException(status_code)
      if status_code == "250 OK":
        return True
      else:
        if debug == 0:
          return False
        else:
          return status_code