# The setup script for installing pyTurbSim.
from numpy.distutils.core import setup, Extension
from pyts import _version as ver

setup(name='PyTurbSim',
      version=ver.__version__,
      description='Python implementation of TurbSim',
      author='Levi Kilcher',
      author_email='levi.kilcher@nrel.gov',
      url='http://lkilcher.github.io/pyTurbSim',
      packages=[ver.pkg_name,
                ver.pkg_name + '.io',
                ver.pkg_name + '.gui',
                ver.pkg_name + '.cohereModels',
                ver.pkg_name + '.phaseModels',
                ver.pkg_name + '.profModels',
                ver.pkg_name + '.runConfig',
                ver.pkg_name + '.specModels',
                ver.pkg_name + '.stressModels', ],
      requires=['numpy', ],
      data_files=[
          ('pyts/io/templates',
           ['pyts/io/templates/sum', 'pyts/io/templates/inp'])],
      scripts=['pyTurbSim.py'],
      ext_modules=[Extension('pyts.tslib',
                             sources=['pyts/tslib/tslib.pyf',
                                      'pyts/tslib/tslib.f95',
                                      'pyts/tslib/lapack/lsame.f',
                                      'pyts/tslib/lapack/sdot.f',
                                      'pyts/tslib/lapack/spptrf.f',
                                      'pyts/tslib/lapack/sscal.f',
                                      'pyts/tslib/lapack/sspr.f',
                                      'pyts/tslib/lapack/stpsv.f',
                                      'pyts/tslib/lapack/xerbla.f', ],
                             extra_link_args=['-lgomp'],)],
      )
