from numpy import array
from pyublas import sparse, SparseExecuteMatrix

Float = float
Complex = complex

# bicg ------------------------------------------------------------------------
bicgmat = {}
bicgvec = {}
bicgmat[Float] = \
array([[-9.9815534734728235,  -6.4231760285382364, 0.65893809150759697, 
              16.300206287688862,  -3.4456507918716124,     10.2718381326141, 
             21.938384177283993,   9.0278776393720648,  18.407000150322197, 
             13.901861232634094,   -5.9703365760562122,   12.373948819311574, 
              10.314983662617603, -0.63461989974395139,  -9.0491721007892885, 
             -3.0033524747698603,   0.8805811215771947,   4.6886076063684925, 
              -9.276985363112729,  -9.1723202195035309, -4.8677367593202385, 
              5.0635100814158918, 0.77234931030935994, -0.83614370755763556, 
              4.0885457448138567, -1.0086097591517185,   9.374145785958989, 
             -1.9332970909214606,  21.641215117607718,   14.481053344307519],
       [-8.4954980913834603, 0.076063092245466604, -10.825966402688557, 
             -13.717006419579382,  -7.9649107759611661,   10.964527888315342, 
            -9.2325971769254682,   1.2181448442463372, -1.1294144318024508, 
            -14.648844257845006, -0.095358549999607134,  0.79691903099557604, 
             -19.888512062783352,   6.7356870959790269,  -2.2876311787759711, 
              13.839710587873812,     28.9148130555539,  -6.1246997418471238, 
             -6.4826193217960029,   19.221816177846598, -10.089316959260596, 
              1.5818925633057068,  8.9101360939525023,  -7.7833138209251596, 
              0.4931508234718765,  19.379656549066986, -7.5250802293365506, 
              14.327030641783718, -1.2964200316920755,   18.516642466739611],
       [0.49728681104740435,   12.473983166656604,  10.656829351477167, 
              6.8016145297650086,  0.37248529920278056,  -5.9547428487159593, 
            -8.3319747043135646,  -4.7599191709849116,  20.734227694093047, 
             6.0394211956507355,    8.6989844751873573, -0.23604875422179591, 
             -10.654526008525345,  -5.8791159142206748,  -13.077626627395919, 
              8.8295646761271627,   11.243978312342515,  -14.414694990209735, 
              8.5695255347955275,   7.8519516307526969, -11.202799727147712, 
              8.7374562975662666,  20.854736747707335,  -9.8009568384025982, 
             0.69262813977199711, -13.446033956839807, -3.2816307851558122, 
              5.2994784054167834, -4.5097841050825824,   11.754693920544067],
       [ 25.623763898916717,  -4.4418856150189683,  5.8275802119461693, 
              10.959665915274936,   2.5326716300135605,   -8.609128214238785, 
            -10.242477389042396,  -5.1121151548282153,  29.290758686331962, 
             12.185719527592902,  -0.45511785212655531,  -9.6623773982502499, 
               5.534992226369261,   4.8983914330874327,  -8.5374401023475919, 
             -4.8721874164766685,   9.3548248696583727, -0.62937956206384893, 
              6.4185416378468849,  -3.2676299992105804,  8.8235298906686879, 
              11.113536398377866, -14.819139524108795,   -1.737876036697882, 
             -6.7412378199418876, -5.4116655563663629,  3.6548019548076374, 
             -5.2142339234927126,  24.695021550176381,  -4.3679745034563568],
       [-12.333350686363749,   4.0131744293790206,   9.248714076895574, 
             -1.4256686425606397,  -8.6082420996050537,   1.7578313528153875, 
            -2.2938746023470582,   8.8133086552164759,   10.55915651827064, 
             5.3935424487716723,   -10.795934286975935,  -7.7301185077647592, 
              2.2704682859625369,   10.966885913627337,  0.30927976381189498, 
              4.7884632303660286,   1.5984155804734317,  -0.5862543033717309, 
              11.083873769291731,   7.7198664465959936,  14.431369004422637, 
              9.0898554276076347, -15.464642192307817, -0.99665698296051042, 
              2.1937872090706376, -13.990025111884378, -6.0823640156578769, 
              3.1238074608303625, -1.0993905451341606,  -19.537052923909744],
       [-6.1370771529335899,   7.9909710269148873, -18.838802662313174, 
              5.9963748595017314, -0.97134865598337661,  -7.6488003821798021, 
             8.0436556115233984,  -15.379548520557485, -1.8326251153967641, 
             3.9849437752000783,    8.3369588567964819,   14.183134434275033, 
            -0.11417594171764993,  -3.4607530011869425,  -7.1613502707835828, 
              4.4438384424281248,  -3.7032106758504497, -0.31084684744746044, 
              12.523410690699615,  -7.8295576992139395, -2.0447513617173545, 
              6.6683410986042544,  -14.00288919377115,  -12.855687537096433, 
             -13.084010456432456,  2.5425919065868108,  14.469561786518456, 
             -7.8895875864368001, -14.070245621725906,   5.7245880663344835],
       [-7.4092887617923449,   8.9754189175666852,  5.1989372122561681, 
              8.5755051169239387,   6.6017013683324723,  -9.3203788485316004, 
             23.922860570740767,  -13.986636439510081, -19.995328594213952, 
             9.2685231875348304,    3.9919557617805381,  -14.272021163850896, 
             -9.3743360509821834,   1.3971208442732099,  -9.3108978174536219, 
              6.9846282230460188,  -8.2810416273580163,   5.5430301526753443, 
            -0.95145841443233636,  -14.284465819654377,  3.8725875333598179, 
             -9.5782480334730522,  1.4257056208278327,  -3.8336975755397988, 
              4.2147941675240812, -16.747677821418936,  10.681983709117254, 
              14.168525720172342,  6.3000037836217295,   8.2094645535877646],
       [  12.62800883336924,   18.189446791113294,  7.8275058483035416, 
              10.538374447821941,   23.199536842828245,  -13.737460983985583, 
            -3.5089979071848627,  -19.937499613598106,  -7.355945200475297, 
            -8.3630739557248273,    4.4073635870659027,   10.913613760616563, 
              -3.018887760862119,    9.719834080466855,  -12.844087007861448, 
             -6.8875697670863909,   6.6551886533251912,   11.250907397649829, 
              2.3855932931163277,  -9.7117631081441491,  4.6149632920163084, 
             -6.8795801235974752, -9.6602437710892204,   12.387938557626406, 
              3.5512342862852582,  4.9159223732240562, -7.6193326030031363, 
               11.64663407021383,   17.72391563355497,  -7.1236017257780073],
       [ 10.073420504890301,   6.6988800491025469, -5.2954271556759345, 
              11.277721955250822,    16.10290885461427,  -9.7524383344613845, 
             9.1265369022749336,  -10.067778931271349,  17.630082720911087, 
             10.765271559923166,    17.640812979187253,  -1.2027579577234528, 
             -5.5012829241429984,  -7.3320972782073959,   9.9073237874006299, 
            -0.37580531738166023,   8.6759866008011333,   5.3555184985319579, 
              14.805871917315006,   2.2696266355902734,  1.7252273424940681, 
              6.6044076478485545, -5.0124845909752489,   5.9366949438401173, 
             -10.053454222208693,  15.229072700347535,  9.2990386748276546, 
              0.5776455214990589, -7.0683862587623993,   5.3043799219247534],
       [ 5.2362522068243553,   3.2491210894202065, -8.9551076053965932, 
              3.3156358313392786,   12.462189314408935,  -6.5347857152679634, 
             2.1745103265656014,  -9.8357564635547163,  3.6991599765971541, 
             10.385552993991759,    8.8338175719368053,  -19.068132875959911, 
              6.5476211479016619,  -3.5562175852025573, -0.31426490552672104, 
              6.9764896785405295,  -10.972278938152954,   1.6619511574702712, 
              7.8960949939435192,   12.016102783038709,  16.657429863005479, 
             -11.517866426807474, -4.5743757482224954,   2.9392003721628495, 
              7.7162994587912879,  4.5982602623025208, -1.6171574592749294, 
             -21.763272660431575,  8.5606861015303153,  -13.313863981062399],
       [-3.3173873496793012,   3.8400065039704638, -8.1856164504726294, 
             -16.516297675097416,   1.7930378880564826,  -1.8754466946792636, 
            -12.390313678999176,  -4.2107641622599292,  8.7838693027770969, 
             5.2636872303928541,    3.0531826361034837,  -18.760618769030177, 
             -8.0031174899168551,  -8.3480022357340129,   8.0694739195469225, 
             -7.4153207703839952,  0.20715556169131763,  -3.5111054162647575, 
              1.1274246360877955,   2.4140882773641161, -21.530619801585786, 
              16.226211216631562, -5.3373242605051328,   7.0465278968466913, 
             -6.1699712066856884, -3.0237131154325523,  -7.843031836752302, 
             -12.266116942358774,  1.0725423965531928,  -10.702275307619534],
       [-13.760329667490856,  -5.5239592519822356, -8.5960715314478779, 
              18.595497965935017,    11.48543098716849,   -7.740204251084581, 
            0.54772898336599185,  -6.2880086137151654, -13.909876723232589, 
            -6.3586936274145947,   0.40285871641693094,  -1.8600648309151833, 
              3.1235026848889507,   20.312563176967053,   8.5559709728188675, 
            -0.99796764672963345,   18.465479103245823,  -5.4749315500709592, 
              13.655348201057864,  -13.697180234142321,  10.383065137472139, 
             -11.434896270520303, -2.7485754530925695,   -18.29140087366093, 
              -15.82493895548124,  16.228920441965087, -6.5005779941025637, 
              4.4755510947705792,  25.000614550641931,  -7.6674170898452676],
       [-14.892965901807107,   8.8116009905988388, -15.903051727036559, 
             -11.078115790728397,   17.272047125470063,  -14.186696961795604, 
             10.520014725973221,  -1.4462400277663408,  7.2984487390192925, 
             -4.097627867024487,   -9.9184250344269884,    8.432012559456691, 
              -13.59459165871044,   -22.53252802554784,   1.0204061348415336, 
             -7.9099113400236201,  0.41425167516842887,  -8.7903271388537814, 
             -4.8378865161650682,  -3.1116676028271906,  10.099021442046745, 
            -0.12878865893152466, -5.3513292835715367,   -4.822693570926047, 
              4.4936913805356173, -15.866523460583755, -23.224616704512592, 
             -5.5514602482876843,  10.800366631001683,  -12.229050801789754],
       [-14.017040420255725,  -19.203589773430817,  22.172191182181766, 
             -3.7509085201242662,  -10.761042150711702,   6.6991018561672568, 
             17.442035980817433,   17.500143139992911, -6.7137827114620823, 
             10.509212403012553,    9.1969438692991883,   4.1374235133995558, 
             -4.4855713758766145,  -1.3870627329354641,  0.67970482127812415, 
              2.2745461700513228,  -5.9421300931404186,   2.6176980204536542, 
             0.48845010662411126, -0.45356803875797108, -14.241874847609852, 
              6.5095754361209277,  3.6080751549909476,  -7.9266571715459122, 
              4.1693825828780664,  21.747625702028415, 0.37066266249974322, 
             -14.696098799963268,   5.140845287273331,   14.840979672332644],
       [-3.5373052177901609,   6.5557498561933656,  11.255436052134051, 
              7.2563492252115633,  -19.789700434230056,   7.7774904187550025, 
            -20.187993501115649,   2.8375335832938271,  6.3865093499027044, 
            -2.1806072508014598,    1.3099302993019548,  0.36165852344441202, 
             -10.054282743478018,  -13.904774709611427,  -4.1730101995415279, 
             -22.428016874494862,   2.6226020098284075,   11.729549042906847, 
              2.2631406542247707,   11.591992684462156, -9.9638865903770242, 
            -0.90268299822568443,   2.722693522775963,   -32.71639080777171, 
             -11.503012491943226, -3.7283890028778108, -6.2126496266220173, 
              10.441487076422352,  3.6832680450007889,  -2.1358657669943582],
       [-11.394488021416526,   -3.761013347749925,  17.182488235218958, 
             -14.333421099472412,  -2.5216260240586763,   8.0280865762672882, 
            -8.8472120219773718,  0.16508771676331871, -8.4368946434930123, 
            -8.3245520131498392,   -8.8398948507962221,   -1.596322961234641, 
             -6.0018002638618118,   7.6911763614028414,  -13.657088829404763, 
             -4.7066524303614852,   5.9845982285193733,   15.841351133237644, 
              10.283932830541168,  -37.466479481530477,  6.4555591294869918, 
             -11.391049378914319,  3.4111046570853167,  -9.4470217802971419, 
             -5.6634189807927235, -17.203682966922496,  16.589432283259072, 
              2.6288400284971662, 0.84958591941623596,    2.635323523125495],
       [ 12.834254507006371,    13.39672302298732,  16.791798592669981, 
             -4.5645555710911161,   -14.38803224764504,  -10.855071241951563, 
             8.8259541090831952, -0.68104765472291817,  -14.39944718681687, 
             2.2448549164577507,   -1.2436880332391778,   3.8306302852231875, 
             -9.2208565579563988,   -20.29845331967568, -0.77580506969600305, 
               4.033075213555529,   10.921042385279325,  -7.4850474399717806, 
             -7.3698883718357564,  -3.1339749302558175, -4.7663600366480132, 
            -0.95817055172659882, -10.279131334547378,  -2.7405820241243823, 
              2.1714783201445451, 0.58915133876262427,  4.4084767174800472, 
              1.2302549496439332, -21.660217042813869,  -21.834032109370764],
       [ 6.7742235493048852,  -21.199605598181577, -17.446034679555172, 
             -25.853043856643136,  -12.002410022251178,   12.993919909820255, 
            -3.3660199965824904,   16.646264732515863, -4.6671639051874028, 
            -6.0582072215648655,    3.8858201483587811,  -1.9229212019329369, 
             -2.6943780063220957,   9.7494410942634229,  -15.247458589409739, 
              -5.246379946514482,    16.88741202049669,   13.946028131884781, 
              15.545133256903361,  -1.2219611397296863, -3.1617225030070006, 
               19.42303257239778, -29.423780842139372,  -8.9787891238352948, 
              10.462436281681736,  2.9918759799312582, -3.9377893468712277, 
             -5.0243881515744331,  10.466806592688563, -0.61570305984307472],
       [ 11.095321329544864,  -6.7559232923840735, -2.8447071664004664, 
             -13.013826943063492,   7.8900005057066691,  -6.3345946366278749, 
            -9.1172414802087722,  -5.6958700942953566,  13.803862847847592, 
             4.9193220607546353,    6.7632801395921929, -0.89414514461044992, 
             -12.832538586191093,  -1.1455945198187709,    -13.1096689715006, 
             -4.3994841906622204,  -11.579096511667055,    4.563422925538557, 
              2.1287999741203829,   5.5390505800287055,   1.173615251598394, 
              10.955487321755164,  14.342972444607081,  -9.2293032015624128, 
             -2.0842261529271133, -24.953818793570498, -13.608768862353436, 
              20.040912874747228,  2.3894425930565037, -0.10399051568413253],
       [-5.4953306398534014, -0.94621863809617912,  22.499670842563422, 
             -1.3377020035193508,  -4.9291667421077454,  -8.6916506278046981, 
             12.809058733549962,   3.0833683488372672, -3.8437580064304711, 
            -5.2899002404861841,   -2.2729657377389541,  -1.8198209439732704, 
              3.0781901421005582,   12.040140171195224,  -16.225271582453622, 
             -14.513131253673494, -0.31612388489373067,   1.8626796659746556, 
             -2.9519326716673637,    2.771189252098802,  2.4662465515750966, 
              7.9639133362218226,  1.6264277334718371,  -6.4613100183733696, 
              5.0859686176302503,  4.1519016534582018,  -4.796784965022816, 
             -4.2750563306911564, -15.972171834837924,   0.1374716821556792],
       [-20.517036396603991,   8.4007241094425389,  -11.52999838101762, 
              2.1555210033243051,  -12.060372186820228,  -15.453305652439603, 
             13.073809826375635,   5.0258868631558817, -9.3760715847896599, 
             2.1514653486491366,   0.12214609376267045,  0.35204974472397643, 
              -5.706386955487261,   21.065170262588389,  -7.3736963300228009, 
             -5.0779713807642102,  -3.3274498388627949,  -2.1238207812736727, 
             -21.690217663229387,  -8.5302767474720724,  12.108126359670512, 
             -2.3826773168627913,  6.3406741125435362,   0.5206520788569442, 
               9.483168749187632,  5.0279068885332325, -5.0733397002036797, 
              13.963079534864697, -4.8291162518816675,   14.716635188776827],
       [-2.1850129512252705,  -8.6347789801652279, 0.74749455298647249, 
              4.6101653036335879,  -5.9246159711355464,  -2.0047715447042669, 
             7.9936080257297917,   14.386568725451072,  6.2853316057334965, 
              5.339721498504117,    2.9477836132671014,  -3.1373099317076885, 
              -3.978825414028762,    1.679507236464709,  -14.813636237524115, 
               2.778814537193135,  -3.5522469540362733,  0.30798012619591586, 
              -8.154350928592315,  -3.4499356350883486,  10.805444858301922, 
              7.4881541424113003, -8.1351230942786277,  -1.0489733660368949, 
              -2.916478344171928,  2.9940226192519597,  15.093660500475025, 
             -19.601450476545921,  6.2958064506132665,  -5.4526555376919976],
       [ 3.1184643741318467,   19.319767926982557, -24.491919944949821, 
             -2.6524237122938477,  -7.9472942253899195,   9.1385696658320565, 
            -14.786636447924195,   2.6719838381400489, -12.989881846953528, 
              9.539335480593822,    9.1277962864626385,  -7.6636588389278923, 
              15.167322314811909,    7.188873550681695,  -3.0998676071583193, 
             -2.6936672062367433,  -7.1740316102846338,  -9.8714336010792465, 
              3.1834941039939912,  -8.5890188256284521, -4.1866727406014803, 
             -7.0988707468452814,  -14.80836011769766,   9.3878245206594624, 
            -0.83564650443490973,   5.753511348452804, -3.5216188716887862, 
              -10.67569272245921, -7.2082274909676354,  -1.4818072148680239],
       [ 10.914750591317738,  -14.637225656995254,  12.692359923952159, 
              1.1901369036762928,   4.1443600170803228,  -7.2046767743870017, 
            -4.7130583464646723,   1.8508090331045268, 0.82729396121702881, 
              1.625618206896444,    8.9592064033599801,  -10.442638401853939, 
              15.896174187394861,  -2.4304734668753611,  -15.533605712594502, 
              -10.44563954344931,  0.64556253747227232,     5.22214871303182, 
             -14.956733870045193,   4.3410876790690427,  14.826271174451314, 
             0.89530565328820511,  13.389432148840203,   8.3916946967131771, 
                6.71488596511659, -5.0337261167081282, -5.6047492125886764, 
             -13.010222688100136,  14.418220606193042,  -13.446047141453466],
       [-18.014485598582084,  -13.554816306925851,   11.70964263613447, 
              2.8800275813359901,  -14.524535020128297,   3.6653145817210886, 
             3.5971911656978484,  -11.508153339878733,  2.6028277408143001, 
            -7.5877331710621299,   -1.7534038204448446,   9.0019835176905456, 
              14.742694680195054,  -7.8611127800196225,   6.3529300876691197, 
             -9.8174229062417275,  -5.0122663025443472,  0.66827936395945964, 
             -2.4416489851052336,   18.121920726583895,  4.7611848267150227, 
              9.3626947772018738,  19.491642734970963,   1.0610277906013639, 
            -0.82350222974176657,   6.042869175216822,  2.8514615655503639, 
             -6.6431109091490992,  2.1323871658297637,   6.3505738866981485],
       [0.66797586486942051,   11.911172009137839,  7.9524660708565893, 
              17.351645484904409,  -5.5039445386150252,   9.1921993419215511, 
             8.2029388135076804,   5.0032700536362533,  2.5927330621775018, 
             22.002411167432481,   -3.8779915542526537,  -33.456502524242623, 
             -20.701670216491795,  -1.7413846650139122,    22.77145634332317, 
              9.6578214224314802,   20.099498440770269,   11.054243218013779, 
              4.9791212186510778,   2.1277907236599489, -10.054121763269295, 
              3.3498212263571387, -1.4598357744274617,  -8.7978562910582383, 
              12.567368640358689, -4.7972430112591136,  14.652404354986924, 
              -4.932898156457771, -14.559906091162404,  -19.543714663372945],
       [ 6.7922711307566992,   4.5709183623077383, -15.212593017973751, 
             -2.5610196165692294,    11.67224146344382,  -1.8276977815551168, 
             1.6849490140130918,   1.2198050333211108,  12.104328941919199, 
             2.6262585969586354,   -15.955358621031259,  -16.226616331624662, 
             -12.731463663242526,   3.8234156137819522,  -10.527867491616419, 
               7.946653476941032,   9.9808271662113075,   15.314396423599188, 
             -7.0730693873138337,  -3.0233394268510971,  11.164408463318296, 
             -8.8170392269567017, -15.557280181208702,   -9.997313466589409, 
             -6.7462488865206431,  4.9863475273591389, -11.387575908586054, 
             -18.398137214415435,  -15.60430355497191,   1.4946028229431061],
       [  16.07992231392705,   2.9485187479091852, -2.6047872913351808, 
              12.257603128559252,   7.0947133475897282, -0.24125084147759207, 
             4.4178971563082934,   13.047370350888221, -12.333130823273228, 
            -0.2769681468062174,   -10.500304408487867,   3.6210986001994536, 
             -4.7404169904304752,    7.317626926943845,   1.3194728677636887, 
             -6.7131587227605714,  -8.2281028675927441,  -15.391968847353763, 
              12.977354584997766,  -2.4341066568566827, -15.957392838752805, 
             -17.467661110136127,  -1.466517133809095,  -4.0430965722853358, 
             -11.726437678237486,  6.0475347353206663,  27.994690834744958, 
             0.67126245711270849, -3.7747376798158871,   7.1434894552868897],
       [ 13.785017599406961,  -1.5989777377485279,  22.181534486675773, 
             -3.2250514281333311,  -8.8672304883645303,  -2.0761749952282047, 
            -10.428459938461019,   6.2741304789907719,   5.238678172883084, 
            -2.4446861715497468,    6.7201250469181257,  -0.3709533277392108, 
              1.4626449139337272,   12.937011791514816,    6.211185692314066, 
             0.74834996264736009,   4.1323490276670709,  -7.4129427548780003, 
               1.064299712476098,  -7.2618311051920879,  2.1159839565818652, 
              12.761681625149999,  2.3430500413015012,   19.772325054904911, 
              14.093623678254295, -4.1011498836707814, -9.7536717833968467, 
            -0.84305422492907556, -16.217364520002583,  -0.5268203261708625],
       [ 1.8370187653036014,   22.296009875433782,  4.8482314446160402, 
            -0.83350388182411717,  -11.288630438064731,   3.0237836311860149, 
                15.305770466482,  -15.936651081924555,  6.7563897505588866, 
            -8.4823279243352498,   -28.705704216611892,  -5.3165438615602767, 
             -10.237480743908582,  -3.0678154061277034,  -0.6384048085595766, 
              12.699110010345443,  -4.0411319182366903,  -3.4488872485041391, 
             -10.022566837601731,   15.296893883020129, -5.9143403870907365, 
              2.5704863401659939, -5.7051658864683743,  -13.813282025337566, 
              3.8330404644654124, -15.111675179436887,  5.0055142465718392, 
              25.339338624686242,  5.2302100721383074,  -25.194371999599468]])
bicgvec[Float] = \
array([7.2939969810336605, -0.59342141410233307, 2.6015103766724925, 
       5.4452991882311501, -6.9704315263247052, 1.2569334389093889, 
       8.7314167002651324, 6.9324663223494456, -9.4417655089930559, 
       8.1906075651035728, -2.5717888525890102, 5.4125749768311282, 
       -2.7275573090419876, 4.957532679736488, 0.060920915908017868, 
       7.8199426461248569, -0.21531224243591776, 9.314549539713628, 
       6.3976007205766088, -11.925728567071438, 12.759466799644665, 
       -4.5172998624256362, -5.8232774445040771, -4.4134255902950983, 
       0.73061667538932074, -3.6280496465722711, -1.6359054037117122, 
       -6.3563758625477629, 17.672037328824644, -3.3248506692416608])
bicgmat[Complex] = \
array([[   (-18.5300791092615-7.0687279069424713j), 
            (-10.370707354668266-4.3727396502926377j), 
              (1.7945369774018562-17.751861083574834j), 
             (-3.9852670686647969-0.19585215623814209j), 
               (6.1812138756743105+5.0886313811612149j), 
             (-2.9554027215361418+15.697497134981946j), 
               (5.5346439940566672+11.56384779856019j), 
             (-9.0804299998635631+1.4888273148574014j), 
             (-0.73729212000331568+16.533796941386768j), 
               (21.14810362752992-1.1220659777237456j), 
             (-4.9038175937863757-4.5903417372904034j), 
              (-11.775072811645126+9.2362886899888927j), 
               (10.778154214717159-4.0238842586253201j), 
              (18.848406146404951-4.1736773334932344j), 
               (7.3297750259962893-13.890193503754238j), 
              (14.283638348198487+18.395027636129988j), 
             (-12.300842575864868+7.2375315118133754j), 
            (-0.63474334189989845-4.5266933235444462j), 
              (3.2461465152254014-6.8347814781206147j), 
            (-5.9982520644689323-17.789825685743676j), 
                (11.52759139778717+2.880747915382718j), 
              (21.582126778053517-14.532985038394617j), 
             (-1.3513725785942792+2.2406924225542624j), 
              (4.8409675067726301+8.0818435421429804j), 
             (-8.7104420566975289-9.8055190731617792j), 
              (5.5571327926062875-22.823632840399306j), 
            (-0.59708742855405395+8.9401992290207577j), 
              (2.4971222594107871-4.6242758467483265j), 
              (5.3245646359730179+2.0829227664593057j), 
             (9.9027393008188032+0.8147197484258285j)],
       [  (6.3961719882467705-5.4495872087253394j), 
             (1.7097649569907993+6.7036352968481339j), 
               (7.517928082082288+10.662570367817917j), 
              (-5.9223999948189165-6.3602030500063123j), 
              (-5.2355388583831104+13.072831378095026j), 
               (2.2906557554705813-26.12183981144938j), 
             (-2.9163453248928599-2.9168912301480079j), 
              (3.3224818213400926+20.322725856231788j), 
               (8.6888394248752796+4.1380237890470548j), 
             (-10.418276515965045-6.3006059310083407j), 
              (3.5182882199073879+8.9989390450122482j), 
              (-7.3317649568227825+7.0209521460043458j), 
               (2.0499301062301454+20.151781381207705j), 
              (8.8756681639080313-5.0303820483264055j), 
                (7.0931758147960267+10.78632342910594j), 
             (-11.140329278630183-1.2010949019410719j), 
             (-12.160947325268342+11.711979046092445j), 
             (-22.132751762697197-8.6803112242139733j), 
              (3.0495050254990268+2.3808914488884927j), 
              (8.0199786016965966+14.13929837777675j), 
              (5.6833193213229158-9.4856127261365355j), 
             (-16.644189508637901-13.097108661234234j), 
             (-2.6929433540972973-10.763754451659333j), 
             (2.5231824210014908-0.92622982382990937j), 
             (-14.465519839465635-8.0450237545692396j), 
             (-2.7838357238854221-1.9134972499247489j), 
              (3.2561287136513783+6.2802672329087805j), 
              (12.073961338639389+16.330281831545488j), 
              (4.5650251195007625-1.6754718149889711j), 
            (-12.907056509869609-1.3150336616622673j)],
       [ (-1.1186955289562788-11.962920631180493j), 
            (-0.3573948176532552-11.891026782503198j), 
             (0.37343367014833262+19.306662071613999j), 
               (4.7702406981558916+4.7216248966651992j), 
              (-13.770098985912544+16.204918033159494j), 
             (-2.7522270822430279-4.4589496765185457j), 
             (-10.687937398555608-9.6901064502018723j), 
              (-2.770314655063459-19.348508131229522j), 
               (-8.2104264004624277-1.303478214717263j), 
             (-21.369352291686425-2.3991136663998862j), 
               (1.3394390756466801-20.91569474733074j), 
              (-1.9260478261276543-6.3550747800252463j), 
              (-13.834482979013092+7.9330151569595762j), 
                 (-7.914497256741333-1.9872697434113j), 
               (13.069099453232235-4.6159738943366966j), 
              (2.9743433801150005-2.8497199984547232j), 
              (3.3810836612521022+7.7966021486834354j), 
              (-7.663935033121577-2.3780632600029321j), 
             (-12.363875930468062-2.8334998869727182j), 
             (1.7858879804589625-2.5108329157472427j), 
              (2.4532522471223914+3.0339407415779931j), 
             (4.6713951203626864+0.02271172897343406j), 
             (-15.533011846504106-1.4691384087930224j), 
              (10.336819263388024+4.7175981544833965j), 
            (-10.998184543945843-0.59639206286303492j), 
             (-6.4571613052677792+11.613572334752853j), 
              (-3.286823909018695-3.2248106416559845j), 
             (0.30851782281260698+1.2119840510358826j), 
              (11.263194656697378+12.117192947159506j), 
            (-10.337288921958635-1.1170668552521785j)],
       [(-8.0842045841378845+0.98942469513432019j), 
              (7.9368985052702756+17.73963900639324j), 
              (4.8398081111989004-6.7487628165878588j), 
               (1.7881040583639511+17.844301513170901j), 
              (-6.9345327192283897+9.7029036989335697j), 
              (15.335545916295496-12.794353301301324j), 
            (-0.96153153911093003-4.0881223734892327j), 
              (8.6866842272052089+1.6726812781084575j), 
              (-5.1292715675980105-11.983775883586578j), 
            (-0.45835883524682453+2.6279631229063272j), 
               (3.099217600142024+3.3211907488796397j), 
               (7.3612488066709334-6.1525053839396451j), 
               (4.6942381846559131+5.8997570973525191j), 
             (-17.689735698103789-4.2249324788355107j), 
            (-0.046004001484067039-0.2933654735262391j), 
              (-2.7860650595208303-1.925644662954751j), 
             (-1.770834825549108+0.86750414296686407j), 
              (1.6739023186286084-3.5025411246953175j), 
              (-13.455737668532775-22.11226838972015j), 
             (5.4376193058638584+9.2480681206180009j), 
             (-1.8574167705788192+4.5195506990154062j), 
             (-9.9281808115708117-7.9414665926394505j), 
             (-5.7804836405020099+16.437216495854887j), 
             (-9.9653871435018448+18.380793062051875j), 
             (-11.674545156552242-11.938244873654426j), 
             (-6.0628562069711478-7.6574590392978283j), 
             (0.44438245929593612+1.4644172001191682j), 
              (4.8041454077072627+2.3747419644315522j), 
              (8.2781254306040584-10.148860027814992j), 
            (-8.9643648119007082+8.9487602709550149j)],
       [ (-5.6645241377716937+3.1133189071186478j), 
              (2.579208032723991+1.8519522358597684j), 
              (0.7367915062735314+0.7830842597203197j), 
              (-5.0682567843085282-19.304930074526037j), 
              (-22.073266720167929+4.4220206698497524j), 
             (-4.8041893402998745+17.472399671117508j), 
             (-10.390379080433163+6.3807447688024794j), 
             (-13.169685299310839-5.9060594592450775j), 
              (-10.626153308962872-15.469016894796168j), 
             (-12.236576582127018-6.9185843664179272j), 
              (9.8577101929198854+6.3744502274612858j), 
              (-18.932196873680908-1.9940891318168041j), 
              (-6.7694056933584275-8.9491684859588858j), 
               (5.3194064496953466-7.155864317366941j), 
             (-0.99346556886534698-15.615735141445487j), 
               (14.617297020605735-15.90546912804964j), 
              (8.2777428566792217+1.0222729513120838j), 
              (9.9022351458066318-25.686850874874306j), 
             (-3.5877456457430954+24.528894953997241j), 
            (-2.8647482439691094+4.5586042552238499j), 
            (11.139946134279091+0.095461696163640489j), 
              (2.2451824358519454-16.221783892336624j), 
             (-12.909069438690841+13.687570680595956j), 
               (2.6971243611276963+16.81874303222617j), 
              (5.3210533125947856+2.0556386571337617j), 
             (-7.3715972583146971+16.687808985804196j), 
             (-7.5785944196690034-7.5180118494093486j), 
             (-5.3933862679965312-10.697921323230585j), 
              (19.356497367580754-3.9148012801788328j), 
            (-7.8885056375308702+1.9905614965550393j)],
       [   (2.981561802151802+6.3233436574229263j), 
            (-5.7873029602618198-10.646111516238069j), 
             (13.022779718580333+0.92485295957568991j), 
                 (8.559101211315788+2.900564985453058j), 
               (6.0048552806436817-8.3151227764235696j), 
               (18.13432812507661-11.170251886148257j), 
              (13.808668839074718+5.6122045511693033j), 
             (-10.749178122559993+1.5216205844842063j), 
             (-0.62670410476077576+1.5082605631967856j), 
             (-10.234476164915201-4.7700225162023893j), 
              (9.9088932969633277-8.6230164149100226j), 
              (-1.8600092672124204+2.1768597625592494j), 
              (-11.625885330476775-1.7955266539968171j), 
              (6.7359552280542214+11.097832824937026j), 
               (24.009071113435006-12.484261295902474j), 
             (-2.7651336444998038-14.016269545313575j), 
               (11.77663278457741+8.1514588393062617j), 
             (10.462613529414874+0.16757374113605772j), 
             (-13.231213485848446+10.475976019937336j), 
             (11.928629208284168+16.226558525199312j), 
             (-15.542011699470672-8.8915365530963655j), 
             (-4.7542106763442433-21.072282738532451j), 
             (0.45546399627468281+7.5164370428692662j), 
              (13.109484058734013+5.0298812133963651j), 
             (-9.1330813179916444-2.7753071048092801j), 
             (-2.0432685143366398+7.9558902813982026j), 
            (2.2367738171642628+0.065511662162613962j), 
             (-26.695884393970761+2.3227396755197147j), 
              (-8.120930376239631+18.261780140267877j), 
             (-7.036778841345857+1.1821525367833203j)],
       [ (-3.7900128467753502-16.075178172383929j), 
            (-6.6168219583515642-2.1505922126190717j), 
             (-0.47401616653479839+10.06119363601211j), 
             (-25.065810338798563-0.20490074006002915j), 
              (-5.4396072847315056+14.107801968906067j), 
             (-3.1383615426561167-17.944227288549015j), 
             (-10.531619675755815+8.6039657300686549j), 
              (11.647726563485518+19.324067169400944j), 
                (5.851953403347288-3.6004370358585924j), 
              (-9.3524997795951279+8.478593500698171j), 
             (-1.7491700071664738-4.5404844412666954j), 
              (-20.467630664405082+9.3554755080771255j), 
              (-2.5194883831089241-9.1981566592137032j), 
              (8.1017050314542729-14.460925428853631j), 
              (-16.983421744777395-3.4450233834796458j), 
               (19.20733901726863-8.9799398715910321j), 
             (-4.9682174298460566+1.4363899730023177j), 
              (13.838243885857068+9.7509798841275099j), 
             (-1.8726080671046776+13.998433214412504j), 
            (0.39779977799068617-17.962987372500685j), 
            (-11.319872021884718+0.42571370675791426j), 
               (-3.3019667389014944-3.54592830801771j), 
              (6.2215870479449711+3.7809109169021515j), 
              (-10.100315262405184-2.855543678150982j), 
                (-6.5203658435464265-3.9665665662262j), 
              (1.7523841645866729-4.8142391598407563j), 
             (-5.8422916023513309-10.805539201588076j), 
                (9.57256897871493+3.1855976210114481j), 
             (-8.4351720707936408+1.5841364562729492j), 
            (-1.8958643630012475+10.793020870092839j)],
       [  (2.5934255687310506-2.9156902415521468j), 
             (7.2004959577024872-14.307446237460193j), 
              (24.435155308839573+5.3721368610177658j), 
              (-1.9961340211218728+22.675039651052401j), 
              (4.8573429803644679-0.45715689083825112j), 
             (-15.528730155391326+4.1575375543787931j), 
             (-4.3963425459578156-11.552826651640979j), 
             (-10.237322981496606-1.9265171400265548j), 
               (-20.413518306730506+4.905131937468358j), 
              (1.6318020733302643+11.623918128752219j), 
             (-7.0367587152104427-11.556510023249755j), 
               (-5.103718550962677+5.1700366089770657j), 
                (13.528317917347694-4.784824676237033j), 
               (7.0665296482975286+5.454357968317181j), 
              (-3.5839666513095398-4.6527109749879179j), 
              (-12.67693419253558-9.6626525921903887j), 
              (5.5652428730741699+6.9825871397706525j), 
              (3.1910740362349799+8.4367137041192279j), 
            (-0.86095367187003347+4.6663768608214244j), 
            (-17.806963654803521-6.3426678203157207j), 
             (-7.8879494360296754-22.711928603529845j), 
              (16.801903889322286+18.044235619165189j), 
              (5.6687048386488854+8.4172218011188527j), 
              (13.546680998127181-10.485018385745253j), 
             (-8.3957043332755852+10.522189870182938j), 
              (15.291837805523421-15.975605139695755j), 
              (2.0212200108168323+6.0784061817496138j), 
              (5.9043727471102052+5.2900290325712698j), 
             (-9.0911358294487563+2.1372630024158412j), 
            (-9.1575402497364315+8.3721243334018318j)],
       [  (19.555423115448459+8.1193705363224939j), 
             (13.734580558870777+6.4834156202100317j), 
              (6.5727139448464076+17.098068704287162j), 
              (8.1132435327932804+0.40989288933364865j), 
             (-0.96594873286825811-14.139245256315169j), 
              (-6.919836894594976-12.774284727637188j), 
              (7.2816270049822176-2.5366247302706229j), 
              (10.017740921761455-2.1448819203900333j), 
                (16.38662132442014-7.7129867252247433j), 
              (21.764697190517044-1.9288588561504059j), 
              (4.9675189200443599-4.0404853112204169j), 
            (2.3380788954495548-0.0043727051914025754j), 
              (-2.9003891004254219+3.0352499542090214j), 
             (-1.2529959062364771+20.079436732450226j), 
             (-4.0770584005068109-0.36943709069584452j), 
              (15.799022306582152+5.0683330282673209j), 
              (28.790270287852092+4.8627375004240916j), 
              (7.7929001084055738-2.0974087794968694j), 
              (1.7402142392212085-9.2752852886424222j), 
            (-7.7789986514955087-10.448378763024348j), 
              (11.034472622166149+1.4193021743603391j), 
              (2.1132856639630768-5.3354657648521151j), 
               (2.304244284444033-5.7190393171210063j), 
            (-0.78985559279809159+12.653959074547348j), 
             (0.25487180210224847-11.948018272574535j), 
               (1.6845518445102512-10.04728096308761j), 
             (0.38972374011793165+14.157513270090051j), 
               (1.4526655111315296-11.49281065295116j), 
              (8.0541304060158598+5.4006369038729307j), 
             (7.5565987602907114-21.760993534198061j)],
       [  (14.032311167333535+6.2152867899068003j), 
              (2.237373208006352-7.9695082808124749j), 
             (-7.6416137099805557+9.4710436926514632j), 
              (-5.7681716034552899-9.5413084598831901j), 
               (6.0995928242702977-3.7822940654667954j), 
              (13.314465045216071+7.1842494726296913j), 
              (22.947377626815502-11.132674006163461j), 
              (19.338936027755448-1.4975804966773152j), 
             (-0.72732549265848989-11.373226267377348j), 
              (-6.1744428476421875-8.637803132560828j), 
             (-11.231861758136203-17.777194514893019j), 
              (-0.52593323014437832+9.039349605513241j), 
              (-2.9296371316836267-2.4837344843287963j), 
             (-13.982263079828583+13.239766425106287j), 
               (22.973535399554343-11.939943292943445j), 
             (-15.424504999565174+1.7810874640453718j), 
             (-7.1153708758474306+7.8848595902893459j), 
             (-9.6396224888692874-8.0915384888378075j), 
             (-9.4988271126440633-1.5114956052749517j), 
            (-2.3371139402482997+14.158933915704013j), 
               (-2.8371747364227544-12.0935368286036j), 
              (15.232906222614162+5.1959329738410052j), 
             (-5.8626847623363973+2.9960898859612906j), 
             (-10.208046320850361-3.4079072621526803j), 
              (4.5986436962783355+3.9448783862964865j), 
              (1.0922566892847851-21.690886569813973j), 
                (6.3310003056783728-0.11915927119431j), 
              (8.8441246194022547-3.8744018135810308j), 
              (4.5181134755086232-17.019902265890632j), 
            (-15.623976061227987-6.0613842522235046j)],
       [ (-4.0406959893982251+2.2952450567238216j), 
             (-12.317536224581318+24.46038350594559j), 
              (3.5496321640410331-12.050237232036359j), 
              (-1.8374205624423847+25.814805021612656j), 
               (-13.128547437650301+7.501844541748329j), 
               (23.402507225938002-14.35898053489826j), 
              (32.474849477404156+15.731312746416869j), 
            (-19.738662172851122+0.32212937644834283j), 
            (-0.013108759039668842-16.796328148935828j), 
              (3.4080311292313521+16.346874531554125j), 
             (-7.7343310666960026+7.2360601388165433j), 
               (5.3956412830475378-6.8481065622475468j), 
               (2.5557553928717409-7.1739389930705721j), 
             (-3.6657022708949416+14.845882255797934j), 
               (5.7026349044275237+6.8632578010624137j), 
              (6.6638741310777974-3.9150190015964359j), 
              (4.2842694006600288-1.8569662980340296j), 
             (-15.950886539371421+8.4796736081177251j), 
            (-10.244177225174006+0.45766848361623513j), 
            (-3.8195352006495291-3.2015880965716477j), 
             (-21.235892419543099-6.7983936515201009j), 
            (-0.34760034747625024-17.621855058087213j), 
            (-4.7487268441545814-0.21402250534968303j), 
             (3.2150506772623997+0.30788821357342583j), 
             (-14.766017981073713+15.331488500160074j), 
              (3.3309296372505055-4.1262724968037841j), 
              (-11.95920667612889-7.7683293446853643j), 
             (-20.507193090955916+24.220114120431589j), 
              (2.8557234883193177-4.4225652407038556j), 
              (4.789413479159693-14.067689783712837j)],
       [  (14.787007048925345+12.800303278014749j), 
              (19.77441787924716-6.7164619627457034j), 
             (0.29327231459901465+10.644327795970273j), 
               (4.5285287607093325-3.7269778482911073j), 
              (-1.1011817436707401-1.2786653081076942j), 
              (12.022914972542305+1.0031857539344342j), 
             (-8.2390851881735703-11.882796319427761j), 
              (1.5000125073404029-6.0602628076751328j), 
              (-1.1491602336683406+20.531106055212028j), 
               (2.4741773961469238+15.83144550823671j), 
             (-3.8268632414738613+12.281965004058808j), 
                (9.228952970183693+5.6974384016450008j), 
               (10.281996213792938+5.5357630577312813j), 
              (14.337799938739494+6.2986706904025809j), 
               (8.9862917482016957-6.2506813911707928j), 
              (4.3869635989677178-6.8826548155384479j), 
             (1.6900876601564057-0.69051103617329357j), 
              (-6.933280426557852-8.5601691477383408j), 
              (2.8475082504664901+10.921934465211709j), 
             (-13.13388902999713-7.7105211360273636j), 
             (-2.7467708349601128-2.9514960290011487j), 
             (0.20763841838516944-13.199089770056368j), 
             (-1.7718482117175485+20.164536833324568j), 
             (-16.153983782165149+8.6803338040878391j), 
             (-1.0153213855760153-10.986719868876847j), 
              (-7.8834130144033239-12.25706886901304j), 
              (15.710935530068049+7.2423068461337685j), 
               (5.3617028820190402-2.112686950125565j), 
              (6.2996908681813188-17.466184530780982j), 
            (-2.6773587408602486+8.5573129399846248j)],
       [ (-14.202031524205269-16.239365681678727j), 
            (-5.0805380446100781+13.972661065227058j), 
              (6.4893989262931617-3.4530070107187432j), 
              (-4.1329933290369398-18.364490626477622j), 
              (-2.8508430991755773+9.3607918048621688j), 
            (-3.1682908375223522+0.83775765933251112j), 
               (-9.05890186891037+13.019399816008974j), 
            (-0.26521464280452089+8.8074016477109254j), 
              (-14.525047392652342+12.299571324960608j), 
             (0.16949030305386001+2.7352817770778088j), 
             (-3.0474082141158032-4.0159331456449898j), 
              (-14.921631769601579+3.0806544695938927j), 
              (-3.9343170808427645-5.2012605353730033j), 
               (2.542342435927321+17.414537719515174j), 
            (-7.6547720048928758-0.047242602086596565j), 
              (16.886755635921862+6.2509121841998301j), 
             (-5.2103670085046812+11.722369919898926j), 
              (2.2285575271159308-4.2529458014475399j), 
             (-4.6258836356872219+25.464153101931224j), 
             (1.7434366547346793+3.5922255308244382j), 
              (6.8511560286931603+3.2305235377644066j), 
             (-8.6650966800372196+8.9580466295294876j), 
             (-5.0121952045813813+13.396973373673438j), 
              (5.1403520730625472+6.5877776205343785j), 
             (-15.908080521715085-6.7559495046959261j), 
               (3.544687547156018+10.301605165679872j), 
             (-2.4077329663847897-7.8523049139659786j), 
               (3.361536860424303+4.8073105896504842j), 
            (-30.393945169330017+0.72273640126145555j), 
             (2.9107075350774085+5.4127217507134269j)],
       [(-0.25758506016718608-5.6735188154926171j), 
             (4.6690426015610766-4.7933567211561359j), 
            (-0.18252027000298587-7.4457795291793278j), 
            (-0.055843838330603288-12.533318305591294j), 
             (-0.13088181379533864-7.9550302663801373j), 
             (-9.6440758395681776-6.3784094551051762j), 
             (-8.2121842144252799-2.6250252194132817j), 
              (2.0376374347865314+3.5013096601743507j), 
              (-8.7909947668376045+1.4113270915444585j), 
               (19.375225168322704-2.822807108253123j), 
             (-1.8389122724369067+14.084683654334647j), 
              (-5.3796948093262662+7.9716892501207752j), 
              (-7.2882149212059328+11.280390885466495j), 
             (-3.4269606829989607-6.2834258242098269j), 
               (1.5374507715504069-16.370865078587315j), 
              (5.4042406248460351-2.3317783867838489j), 
             (-9.6436430261139456+16.931280884912322j), 
              (2.7256298836941752-7.7346027513687723j), 
             (-7.4344994380824403+8.6426208786460528j), 
              (4.3176932582733132-9.912052749415059j), 
              (5.8018895268777584+4.8437338837867374j), 
              (1.7414744300699494-15.244133717067571j), 
               (17.89565394619472-9.3776141102054815j), 
             (0.59409648414548999+13.209591593930893j), 
            (-0.35194095570280615+3.1624465993303836j), 
              (1.5824389978538229+1.0038445642553655j), 
            (-0.45175163916047972+1.3371125887210267j), 
              (3.5869851817541947+4.4783881303751389j), 
              (16.694562880254963+2.1373430957500164j), 
             (-19.02126133100197-1.9001770712226829j)],
       [    (9.804409764899729+0.673656504203063j), 
             (6.2715181631309633-8.2002477761436676j), 
             (-2.0657176743305694-3.7973646124883453j), 
               (9.5953457390059604-4.6501111357998628j), 
              (-4.4806641431558001-5.1925837563877248j), 
               (10.148901122597271-8.872121408994019j), 
              (4.5077875945358956-10.129144503154166j), 
              (-11.94544865077402+4.8876959926781431j), 
               (-13.07985209832921-5.7651984972252359j), 
              (10.685405572793435+5.0412649253473321j), 
              (14.409208446350037-4.5593956928272847j), 
               (6.8777587193547083-2.3847065041224078j), 
              (-6.2562691804876414+6.4838869778618724j), 
            (-0.40684134792213672-5.7205294443611301j), 
               (-16.34171223478787-0.1498633448077501j), 
             (-10.568474529499785+1.6011137175654286j), 
              (10.659850532331316-3.3460147117282188j), 
              (0.1573573378901223+17.206053142824199j), 
               (16.14128406012674+7.5307947567773512j), 
             (6.3097596859701017+7.4113011962584618j), 
             (-3.5917803030542843-1.8774910240495026j), 
               (-3.5084574751700526-7.66060520915432j), 
              (8.0876952416248162+20.050270059097571j), 
              (19.079502662456722+3.9290310491321638j), 
              (11.173653538528342-2.5524246470114336j), 
              (9.8003928420217274+17.650735314119672j), 
             (-2.4378852948573995-3.7938935528609075j), 
            (-0.73087782734444329-9.3340539911564839j), 
              (-17.46476220761285-12.418318081291655j), 
            (-8.9187993923828959+3.7131112336868415j)],
       [  (-10.161967748104564+6.762014291163549j), 
            (-2.1554797158487791+10.195352508160395j), 
              (2.1175793903245586+24.786252831870875j), 
               (5.4975251602314827-21.951218044352498j), 
              (-5.2796345466393033-20.392002399063301j), 
             (-11.677991916156179-3.7145545512600182j), 
              (0.3400844539833125+12.700820575717762j), 
             (-22.478337236154712+2.8447996703767577j), 
              (-9.8069997993106526+24.290628075778926j), 
             (-5.3600829111460735-10.603114350292145j), 
             (27.731805031142535-0.95295378827429711j), 
              (3.4993162852523438+0.87718025806250921j), 
              (-22.295683535864281+1.6271278433326752j), 
              (-8.848669932967411+2.5902675729195144j), 
              (-7.7554898794942844-8.0657454979630003j), 
              (16.582302150673527-7.5513201007613793j), 
              (-9.3944836196451931+2.784441845048633j), 
             (-18.348134397521825-6.3093943082780264j), 
             (-3.1633203623231099+5.7729408301402465j), 
            (0.42981814879988844+2.9422589543552107j), 
             (-4.3321346313326723+12.724946678891396j), 
              (3.2355322798550326+1.1408880728765245j), 
             (-2.5458785985481489+3.6729047558603227j), 
             (-16.193161927068154+4.2680749651168242j), 
              (2.7128739848563082-10.640919047047383j), 
             (-4.3394316433608591+10.578216222365583j), 
             (-12.162692442369934+5.5152833042088014j), 
              (3.5816065339743925-16.896569012118093j), 
            (-9.0198646648489458+0.98533719551188059j), 
              (4.7309060557038247-5.542725976612326j)],
       [ (-6.2644313993831879+2.1606925693945183j), 
             (14.568236708994565-9.9542854180689719j), 
              (-3.5172757443685789+12.06929573407483j), 
               (8.8389164773653413+1.4302740844502813j), 
                (1.7731597042577398+9.183432815345288j), 
                (18.944839258543741+2.45901339281686j), 
             (-3.6177189286454841-8.4935296930077904j), 
              (8.6637351339670872+18.233054216026325j), 
              (-12.647682003556103-4.4104614063668848j), 
             (-10.193561225667514+7.9646745968359012j), 
             (-16.164165139408325+5.9482946082654173j), 
               (5.1081725426093758+10.388007115308914j), 
               (14.906938551723414-1.2780132762849108j), 
             (-11.220796377747263+2.9955803735909283j), 
              (-7.5826377055804475+5.3545042623646468j), 
            (-0.37128260356377762+4.5365494078583266j), 
            (-0.76135583110634042+9.6506123121457481j), 
             (-12.939975187145587+11.311216328535032j), 
             (-2.5727878242350846+11.034101381392949j), 
             (8.0014105809185274-1.5404172657871738j), 
             (-10.200888504553888-1.4248126679662616j), 
               (4.577203294899447+3.4138660034535051j), 
              (-2.746446965056224-13.621298232707259j), 
              (11.967503482718556+14.078174490133833j), 
             (-17.670755159137531+17.083332531671644j), 
              (10.609894650930565+5.5949388142501189j), 
               (-2.0031783139029886+20.6962794100853j), 
              (7.7428455703283783+11.459908004153629j), 
             (-1.0811327021990302+9.2184475246126407j), 
             (-10.91244124221938-7.2189461744939285j)],
       [ (-5.5892354826179336+10.715762444360443j), 
            (-8.5515854789929477+27.577108016177952j), 
              (4.1073017265373206-5.2814387920281636j), 
               (-7.2408069984447296+8.667776058479145j), 
               (7.1375894271056932-12.617301452928205j), 
              (9.3926986002164394-4.8595674718980941j), 
            (-4.8236575734011904-0.13109340373377143j), 
              (13.671909343365636-12.054671541140337j), 
              (18.601903239260217-0.52563782465587938j), 
               (4.019734368681072-2.3195108555463593j), 
            (-0.09910853200485957-5.9659328007949259j), 
               (4.5383958837059373-10.267144443800396j), 
                (2.7608589604305904+2.768889880612901j), 
             (-10.933325028926845+2.5360664458072768j), 
              (12.358472754445396-0.83755696586180006j), 
              (-6.4125650158798191+4.209200471040214j), 
             (-10.028639587388977-3.0792461246533098j), 
             (4.7557007191770619-0.74663656454740479j), 
            (-0.45250324676854126-7.5025152031421536j), 
            (0.17772754790405898+11.794914082769971j), 
             (-2.7453011320860607+2.4763282805576883j), 
               (12.26988388901454+8.7096352226025484j), 
              (5.0885031716482123+7.9167386642372159j), 
              (11.847298036827274+15.419007586182625j), 
              (17.924496487588549-2.9051529606188615j), 
              (3.7130936238333598-5.8598692978109277j), 
             (-11.778678653117343+6.8019280265561735j), 
             (-2.7954227389916415+9.7616668283045467j), 
              (8.7391385218596156+9.3861520606680546j), 
             (3.1495433704057376-10.692571976094428j)],
       [ (2.9833686877777303-0.57622904337909742j), 
             (-8.6760047573658809+5.688560067879278j), 
             (-1.8487822571230805-9.1845267376168511j), 
               (-11.22166692689442-1.1221792405846069j), 
            (-3.6095811672978648-0.040845137674360474j), 
             (-14.235351903393633+1.4976692130604752j), 
               (1.024434853303021+26.100975142223234j), 
              (20.753444361032713+2.1254714785725604j), 
               (23.053716618692807-12.190613858934821j), 
             (-20.409026060809445+0.2394649828674619j), 
              (5.3506110079107758+6.9293166945952649j), 
            (13.420876351799924+0.0072580459496101287j), 
              (-5.5758571353185022+5.7574943196893713j), 
               (2.030886678842315+10.117961840158227j), 
              (-15.510992042368505+9.8115513689145697j), 
             (-16.403136553048078-20.810077895111846j), 
               (6.702774941848074+1.8363304027873151j), 
              (-13.482413689885488+5.803421910283201j), 
              (2.0182964831395029-7.1642959944769302j), 
             (-8.8957169061475696+20.88263264636684j), 
              (5.3366243383557546-6.7810059294367289j), 
             (-20.559111129097339-11.791116655118897j), 
             (-2.7799432975614744+9.0663149920880084j), 
              (-11.392006583265831+4.378206870900109j), 
              (9.2062080097959278-10.819364136496672j), 
              (17.872210730374857-15.493980582066534j), 
              (11.699693406302563-11.236211980188781j), 
               (13.75264346976949+5.4441161913232596j), 
              (1.7071683392440073+4.4860320779237597j), 
             (13.929794547257202+8.8417261023341567j)],
       [ (-12.371163861817321+11.083030456841778j), 
              (4.2061072677797204+1.358378107848492j), 
             (-12.267285162939125+16.367390619818384j), 
               (11.457405144243712+17.016364027072719j), 
               (3.0573419288247381+8.0050438382621216j), 
             (-5.5563182915808085+2.5631693345972866j), 
              (-1.5204572614714282-1.739439204333419j), 
             (-6.6274505829305985+5.6578491637517372j), 
             (-0.88176546007076806+5.6306124878292207j), 
             (-7.2948686514520311+6.7049771116437711j), 
             (-7.6080730159642229-19.916558147169283j), 
               (3.1973697704313944+4.1334540409026381j), 
              (-6.4587586302517614+9.3417660163956544j), 
              (11.635241444287146+2.0230981116129434j), 
              (-2.6519403850415131-1.1091222206770988j), 
               (-2.153985094186365-1.489942282944523j), 
             (-5.2980204236128543+9.4177846739507878j), 
               (21.548991075375991+17.41088014467676j), 
             (-22.176792263439914+7.8894405685515405j), 
              (-5.3327039299091359+4.38218879775369j), 
               (3.6063362722118497-1.444881703210956j), 
             (-6.3235626739734574-3.8093828492928861j), 
             (0.38126777734301903-6.9569086737109949j), 
              (2.0652424761776942+15.275491789839579j), 
             (-6.6710962679322083-7.0150346330762279j), 
              (-10.18456056463927-5.4052262016631349j), 
               (7.7342823233704046+5.465184310207877j), 
              (-13.45391408762671+3.7846202167927667j), 
              (8.9507048484532579+4.3012900869881916j), 
             (11.154040813304089+5.2947471349921873j)],
       [  (10.730964210711058-15.859308082985681j), 
            (-7.5148118910712922-11.264740929601642j), 
              (9.5370120237583791-5.7203351425785804j), 
              (0.71645955810383732-4.8127181467384776j), 
               (-9.33590514192759-0.80678875364620062j), 
             (-11.250169327893733-3.1080468330728301j), 
             (-1.6361254151862401+11.420887837464978j), 
              (11.077328224114973+9.8094961469935917j), 
             (-0.71513274482409206-10.920977476056269j), 
              (6.074791056418257+0.91126630280080279j), 
             (-0.68429509031405078-4.490059208134741j), 
              (-8.2504724218140719+3.2021756025255139j), 
              (0.60709720689909941+20.573667964572365j), 
              (10.062855013948491-4.9421167548285938j), 
               (3.8716859979239815+1.5968226359840645j), 
            (-4.8941390279009012+0.88873050884642701j), 
              (8.4457818181486282-5.2840200247506486j), 
              (1.2453911723266371+27.309091611983941j), 
             (-10.679665074566461-6.5864515006383826j), 
            (-10.898505484083413+11.261378348525536j), 
              (1.1937302128298906+20.662643586310054j), 
             (-2.6874542589074779+7.6346626129621429j), 
              (3.2558236604509401-15.482439684427256j), 
              (1.7980635781664192+11.115226231148952j), 
              (9.4368588815181838+10.952509977516382j), 
             (-7.6604404597796885-5.0138980799758723j), 
              (7.3792062257748183-17.612073123095648j), 
               (2.937362262583993+16.539535856386998j), 
              (6.2042794452631984+18.153665084334431j), 
             (-3.4019448960399314+12.76331735237936j)],
       [(-3.5190193834501353+0.45567181866282702j), 
             (7.9059992708261495+1.4405157489212983j), 
               (4.929463184406619-5.4260251251056468j), 
              (-4.4796459072559838+16.040097172386023j), 
              (-12.065232346611648-1.6673255535066021j), 
             (-18.464022149816618+4.6034081722983089j), 
            (-4.4899017806140149+0.41574923795443874j), 
              (3.6493193797958536-11.814645855490992j), 
              (-6.7290736230437922-2.9102626290342366j), 
               (6.942114255125019-26.189586755245507j), 
             (-17.182477051185082-3.8600896288112292j), 
             (0.36164780099113031-0.19817167626819554j), 
              (-10.194638356049328+13.105033914574056j), 
             (-5.8661619223003933+8.5155211494518639j), 
              (-11.733445021723025+12.105200682546149j), 
             (-5.5273918256310761+2.5604248163422398j), 
              (-4.3868248713115356-4.151427192416385j), 
              (2.4235734183892514-11.277636312088859j), 
              (9.4561909411252785+3.2253836648378731j), 
            (-12.035869888640008-13.726871621633682j), 
              (13.805446456756936+7.1553921343155391j), 
               (7.998014505352331+11.045574265393874j), 
            (-3.4033509322688484+0.19449494230849798j), 
               (1.5207996146142391+4.174428588265215j), 
             (-9.3272475068532561-3.7491239374074881j), 
            (-1.8853655938916634-0.76095530259518374j), 
             (-18.922571958498978-6.5270850698171863j), 
             (-6.2746087609555632+2.1750286337723681j), 
             (-5.8580823898926893-17.564466085918674j), 
            (-0.99482217180760424+7.292665719641386j)],
       [ (-11.134050296580416+6.9371360646697235j), 
             (4.4163415123038554-7.9462897572734592j), 
             (-1.9395107568881453+4.0558004888264003j), 
               (9.7248894085769937-9.6438864452519102j), 
             (0.054520186041432765-11.009162065097808j), 
              (8.7404740539869898+3.9323438581353578j), 
              (3.0197053132040965+4.0766689772272011j), 
              (18.084383110880164-5.5190832609747069j), 
                (-4.4243585837433983-9.61924190411038j), 
               (4.3791340523279469+10.46559786991568j), 
              (20.942495850627616+12.784601599744569j), 
               (11.689310062312666+9.0487817137702162j), 
              (-1.6541879782592903-1.5418943585407827j), 
              (2.7854656391201704+14.427740862235616j), 
                (-7.11564021021724-5.4394160736952184j), 
             (-1.5616793052431566-1.3102182554527473j), 
              (5.0115800120510992+5.3435583915781848j), 
            (-5.3108236074194739-0.98534786351460635j), 
              (1.2425727340132973+11.526904504445826j), 
            (-6.3388401642339733+24.083335527176935j), 
              (-7.944797619252018+2.9565887406082547j), 
             (-10.370511058479416+5.3465354681681712j), 
             (-1.0446986167212171-9.4810569551944859j), 
             (-4.2921824096076735-11.892437519973493j), 
               (3.3178968719888435+22.74070464880387j), 
             (-7.4777838030905608+3.0708149935441376j), 
              (-11.50616273297727-2.3789907648943069j), 
              (-2.513340714270607+24.657391937341046j), 
             (-5.3955980098698175+4.4759353299217324j), 
            (-11.153187673578305+8.8822058298615207j)],
       [ (-12.112800106086745-10.682505381830508j), 
            (0.12588845293234205-2.6434409423341201j), 
              (-17.201411845002561-3.785324330999043j), 
              (-6.3857968673934709+1.9100056042505744j), 
              (-1.8276429223520858+1.6646884985657078j), 
             (-0.81149825922484076+7.349344575181318j), 
              (-5.694150741439171-14.333617599778163j), 
             (-12.143499476798006-13.023498013307828j), 
              (-13.313077710132585-9.9078340068458832j), 
              (-8.9959885734391385-23.92864764474481j), 
              (24.547226867007836-8.9067549044711249j), 
               (3.6915330153179844+7.8291013414341171j), 
              (-4.4989052794000042-4.4910809614986889j), 
              (5.8405187274290356-9.6242492459015114j), 
              (-10.336621757579362+8.6793649719675621j), 
              (4.9196960862571064-15.858341325113759j), 
             (0.13285290476759171+6.0016625489264408j), 
             (-12.945285143784799-6.3110746929459385j), 
             (-1.6003344348481066-1.5982033247709826j), 
            (-10.677350400896273-5.6449046117785464j), 
              (3.4112454040906197-11.177024103759468j), 
               (3.5998635506532795+2.790320051169827j), 
             (-4.5866562858013422-5.1859207268236283j), 
              (9.3642536444978539+13.219018385834843j), 
              (-1.6429551179224624-14.60890850634415j), 
             (0.44751085842332428-6.4522881868002298j), 
             (-7.6571022624539591+9.7140753010327572j), 
              (6.7127685067864977-11.510759194378448j), 
              (1.3187537088282135-12.511881176614846j), 
             (-5.2241556671960758+7.486811336036217j)],
       [ (-6.9161951771777641+10.126821446626721j), 
            (-14.976284320158067-2.8786010292877862j), 
             (0.55112081713314542-3.5364881718130166j), 
                (17.801026927432069+5.336134337980396j), 
                 (7.306809734215836+10.10014086188856j), 
              (6.9422302376003442+5.4080166560350351j), 
              (1.4848458689273845-8.9929488717274371j), 
              (-11.52649401114267+13.060995265842841j), 
              (-3.3187567845340982-21.084461961065344j), 
              (5.1001718097725668-11.887579812546662j), 
                 (13.224090973905+11.123173368851313j), 
               (1.0746367962880155-20.012568277095216j), 
               (8.7731102944974708-3.3175973675971959j), 
              (10.187232231862852+8.7641649227045555j), 
                (3.958882124974719-9.9242596632329683j), 
              (1.5637576162418241-7.3772236176062229j), 
              (8.9601536575679646-3.0038265503650168j), 
             (-7.5789735882018352-7.2642247688177362j), 
              (7.2427607553143716-1.4180193953699618j), 
             (3.9432656932992183-15.857504867607666j), 
               (-9.28500340881879+9.9568922106459272j), 
              (5.2189763099581263-3.7611924571069415j), 
             (11.800349326254176+0.84812263398438681j), 
             (-9.9409491876535778+5.0179136513511775j), 
              (6.8231725801261414+9.8195164467878318j), 
              (3.8092482126583906-3.5538837699936683j), 
            (-15.485983157689947-0.95221292626916465j), 
              (-7.5506440195998206+6.306746061195363j), 
             (-5.7612247769999669+11.943528557710215j), 
             (7.4763762465113182-2.0338949640494244j)],
       [  (0.63598360540980237+5.328281725807388j), 
            (-3.6730155178690977-3.5480105057296116j), 
             (-29.446594550745687+7.5642130993091179j), 
              (-3.2176075107198203+11.849028351051194j), 
               (5.1951496534101942-6.1571654427894096j), 
               (-2.56925438530696-4.2154862764265344j), 
            (-3.7144771683970337+0.15238825400141648j), 
             (-2.8364608269170652-5.4779067184170591j), 
               (9.7234991634086594-8.6988178469970237j), 
             (-4.4976324994673007+19.091908145381748j), 
             (0.65610808614558436-7.6461097671500458j), 
               (25.473176778947071+12.026239198390314j), 
             (21.179071765107132-0.040545882741765085j), 
              (1.2376965190582265-18.602150533940417j), 
               (2.1591355570728061+8.3135597953624476j), 
             (-5.2369122167628781+10.228768204488851j), 
              (3.0575108437680414-3.8799728047810396j), 
              (2.2944276322543891-2.8188089516950137j), 
               (4.806664005106672-15.468039367640285j), 
             (-7.5962374533953891-11.34901034485646j), 
             (-5.1011859947025604-3.8489801119186771j), 
              (10.997476615791669+13.678158949154495j), 
             (-5.6428341096222168-11.157013888630996j), 
             (-5.2598978718950473-1.6624638502276778j), 
             (-10.401318295941696-9.4014730884809463j), 
             (-11.041509336717716+5.6268948502906904j), 
              (7.7563666224025498+16.057559179478076j), 
              (-2.544913846360644+15.336022161878782j), 
             (-3.5260839112334876+4.3590695693272332j), 
             (2.1248619644882059-12.237851766148705j)],
       [ (-7.8612378897331823+7.3731842138599744j), 
            (-0.4448760672449375-24.290988146283482j), 
              (19.057105747428128-22.726519567246068j), 
              (-6.3937790598216342+3.4722720462203633j), 
              (-9.1323359005773259-10.298978062666817j), 
             (-6.3362725925687471+2.2913925214225621j), 
             (16.42150963020692+0.029611579454283506j), 
              (3.0700265935004034-5.3449519902103546j), 
             (0.067705100689539041+2.3950158218764948j), 
             (-7.3405432270899107+3.9734961244478999j), 
              (7.4931207914564109+1.1060298753327329j), 
               (4.0889054003771168+1.2570765849595227j), 
              (-9.9630054038357265-6.5894657375227457j), 
             (-6.7859673236063065-2.9678340151921216j), 
               (10.589283004756798+9.5396581021656672j), 
               (10.194083242117156-2.965742351683188j), 
             (-8.4538891924670612+7.0105221483448936j), 
               (-4.93612230295735+14.464848149732614j), 
             (-7.6355833290015154+11.235426006480331j), 
             (17.349929778616445-4.8907309537244057j), 
             (-1.4729572975235516+11.947728980856859j), 
              (11.427150768764808+17.964741497025859j), 
              (-21.21011969742063-10.444754716545923j), 
              (17.268888904202051-13.799434574398061j), 
              (12.777056855180504+9.4311237630659956j), 
              (3.0271484215203692-4.2317692612723654j), 
              (2.5753628756892439+22.488888262308009j), 
              (2.9930668794830484-10.790586388142065j), 
               (4.109709815260489-19.764779331537849j), 
            (-6.0969707868064305+3.9786575515317333j)],
       [ (-9.0922513440702577+1.7549078413643291j), 
            (-4.0167960287242765+7.0571900809827408j), 
              (11.228121410354422+12.480961181357761j), 
                (11.16486547618176-8.7450414892595809j), 
              (-7.8804608805720191+8.6811675146475018j), 
             (-5.3416830120997592-26.671564772080124j), 
              (15.735783392521686+15.831512226985502j), 
              (-2.421634092721586+12.273427320424338j), 
                (6.6425908019679003+15.10969406666517j), 
             (0.12466757682860644+10.459977922284375j), 
              (2.4495175211796245+10.753309082463387j), 
              (2.2371016488716378-0.19751304976567036j), 
            (-0.021097836662244046-8.0880265934281468j), 
             (-3.9013919799434826-15.197288781954823j), 
              (-8.8060301100442988-5.4161360346681944j), 
              (10.312186396931093-16.048789139132907j), 
             (-4.5988690989805798-11.622408871402046j), 
              (9.7240989555961406-12.364984199286619j), 
             (-1.1101628520355491+12.119008049394484j), 
            (-9.0142933882953464-16.101717922339262j), 
              (13.985439693824214-1.8395358437702303j), 
              (5.7980063500154326-1.2003417440262596j), 
               (-9.944791217634867-5.713283753033509j), 
              (4.7471781853000952+1.7499870621210765j), 
             (5.6412455108861872-0.26332070369496829j), 
              (2.0639933444488396+8.9862233159354457j), 
              (10.12774789436566+0.44781389683028827j), 
              (1.7611688304493693+15.373467526878779j), 
              (17.007406584957934+14.622236401012072j), 
            (-12.367456859276482+7.2505006721627199j)],
       [ (-9.9774483769391829-3.0304034650288809j), 
             (0.92736568795923291-4.847012596991517j), 
              (7.1881871490527409+10.925333504838175j), 
               (5.7632780817817286-11.412569231662527j), 
              (-21.062848227055575-7.5817321896393919j), 
              (-4.776878479060346+4.1828567516894815j), 
             (-1.0297193053676699-15.884019477965094j), 
              (9.4509999801747178-11.928966489843081j), 
              (-23.019831724402039-18.707685801330761j), 
             (-7.2098196194750734+12.421299978060071j), 
              (8.5980310226116448-6.1773306725234853j), 
               (-6.324146292719167+10.283176936115712j), 
               (10.735951139453201+6.4479520242877717j), 
              (13.726939465383747+9.1787619204396709j), 
              (-1.6146425308099848-8.6130491483998828j), 
               (13.92562030470604-2.1421721026035474j), 
               (12.14782729640374+9.7059661043615559j), 
              (13.882755306633605+4.7481814808962772j), 
              (-7.821602063197286-2.9008434762902398j), 
             (2.3078347849656744-1.6254374901041388j), 
             (-5.9987189324077717+16.435860431374138j), 
            (-15.909932218608889+0.59539429559220147j), 
              (9.3502800585870727+16.426781070167923j), 
             (-4.3795798853491377-3.1481151846930162j), 
             (-11.680841829418039+3.1633133818822534j), 
             (-19.673319678653268-5.7227268918627772j), 
              (-9.4164867054207129+4.793369196296287j), 
              (7.0539327159937084-22.990376023716269j), 
            (-2.3476270410917746+0.43330817167882513j), 
            (-4.9547723220947333-8.1129976149700429j)],
       [ (3.6021163633416404+0.36210724301933161j), 
              (6.638903379215952+7.1176122618570883j), 
              (-6.9216283374823648+23.52646100746513j), 
               (1.5174620975762287-10.136964558114268j), 
              (-1.7656046105241341+2.0159784813978683j), 
             (-1.1434521818035943-8.2851670770729555j), 
            (-0.82767993045817934+11.087815070181932j), 
              (13.023171854231425+1.3258666695904924j), 
              (-2.8968979932299455-2.1433609892098793j), 
               (1.7957312989566454+13.94995222563705j), 
             (-3.0156422605539563+4.1803068004653809j), 
              (-6.4167772607878595+4.6306563202688276j), 
               (4.6111642216161419+14.574482862440803j), 
              (15.569573319101904+3.7591512012300896j), 
               (4.7748406934879011-2.6513983639335037j), 
             (-6.6283963370432355+3.6843744029716059j), 
              (3.1706864816862232+3.9061237474940134j), 
              (3.1772762636953313-9.1269290857849263j), 
              (-3.761285684255677+22.236667642734499j), 
             (18.642401415377559-10.112685034461368j), 
            (-6.5751578628343896-0.33144875186003997j), 
             (-13.552990387544028-4.2238353090841656j), 
              (4.9733253141644589-4.2722822276641006j), 
             (-4.9893794500725148-14.378263824171464j), 
              (15.398574483751641-3.4711514913606818j), 
             (-8.1473346249789653+8.0315456246518639j), 
              (26.665342034321597+5.6302465647448594j), 
             (-13.062654547440662+1.5880285960720748j), 
             (-3.4261524076753918-28.443540652046075j), 
            (-7.790309152058656+0.90572573276784374j)]])
bicgvec[Complex] = \
array([(2.3688825942270491+6.510767559290727j), 
       (5.2594100999943496+8.727978602385047j), 
       (4.6311152193302965-2.9165293873569831j), 
       (20.766315392130803+0.76005242483999047j), 
       (7.9067857263835872+4.5456696201239275j), 
       (-4.2828101057850763+2.1920685305549124j), 
       (8.1871338143482788+5.1162990944185385j), 
       (-8.4463220928882894+3.4465582982651637j), 
       (2.0704311231968204-0.11528510631377945j), 
       (-4.9676668443252687-7.3502937344784467j), 
       (2.5237093998800004-5.1921589695668722j), 
       (-11.444215424282785+11.646624741516515j), 
       (11.463872480982252-2.6668075947070307j), 
       (0.51718962981683614-8.9454471078924893j), 
       (-7.6984447064627606-0.18537200817889815j), 
       (4.9296836055970692-9.3372970207309809j), 
       (0.27015477269151933+14.253350995955273j), 
       (19.91127603827093+4.1090564786568411j), 
       (-5.7854676264990621-9.7318236779644955j), 
       (2.9058983967408381+1.0516347918242681j), 
       (-11.008439400123997-1.5167161427761977j), 
       (-5.6912238435905511-12.07205983883018j), 
       (0.90739074518097207-21.290187219767915j), 
       (-2.8225973630585055-9.2180885408853754j), 
       (-21.127414968798345+1.3190513637369747j), 
       (-0.57626985890839966+18.51423496780615j), 
       (6.8506199590656554-13.805379035310722j), 
       (-1.2635039500615721+2.0841539165401644j), 
       (1.6844788712687-8.6178488883525777j), 
       (-14.296022860997006+14.494293093519934j)])
# interpolation ---------------------------------------------------------------
interpabs = {}
interpcoeff = {}
interpx = {}
interpabs[Float] = \
array([1.9396576866415047, -3.8254467050222543, 12.440074781171258, 
       -12.067311746451772])
interpcoeff[Float] = \
array([6.5998460935501644, -9.5080729338759937, 1.7970206329375615, 
       0.49432750892036392])
interpx[Float] = \
array([91.01517969778881, -105.01752829304856, 30.027871894692424, 
       -43.523434767488645, 22.976792050643972, -214.79093601400118, 
       -88.35269302211006, -79.266874020567997, -17.482349048929837, 
       15.9774345224823])
interpabs[Complex] = \
array([(-3.4087455813649732-19.231720918260095j), 
       (-4.1146252703550008+21.059265788939918j), 
       (13.916499865069321-10.798462112804195j), 
       (0.27942334703424154+5.2438074014335214j)])
interpcoeff[Complex] = \
array([(5.5519279535834807+6.6485583318054076j), 
       (-17.741842343229003-4.3674453138349367j), 
       (6.625025002203289+12.050001013806252j), 
       (8.9012521645613525+6.4549060653030761j)])
interpx[Complex] = \
array([-304.4570713510746, -29.963828880270082, -85.022041193250601, 
       -127.5361276251477, 42.05101850458329, 37.251891078179369, 
       28.376414695796043, 131.72153223286261, -26.983178978170763, 
       88.772806025376497])
# arpack_classic --------------------------------------------------------------
aclassmat = {}
aclassmat[Float] = \
array([[               0.0, 0.0, 0.0,                0.0, -2.1104253532572601, 
            0.0,                 0.0,                  0.0, 0.0, 
                            0.0],
       [               0.0, 0.0, 0.0,                0.0,                 0.0, 
            0.0,                 0.0,                  0.0, 0.0, 
             13.840202174449663],
       [               0.0, 0.0, 0.0,                0.0,                 0.0, 
            0.0,                 0.0,                  0.0, 0.0, 
                            0.0],
       [               0.0, 0.0, 0.0,                0.0,                 0.0, 
            0.0,                 0.0,                  0.0, 0.0, 
                            0.0],
       [1.6049212877268046, 0.0, 0.0, 4.7115995708327567,                 0.0, 
            0.0,                 0.0,                  0.0, 0.0, 
            -26.867481840214914],
       [               0.0, 0.0, 0.0,                0.0,                 0.0, 
            0.0,                 0.0,                  0.0, 0.0, 
                            0.0],
       [               0.0, 0.0, 0.0,                0.0,                 0.0, 
            0.0,                 0.0, 0.044947987960809468, 0.0, 
                            0.0],
       [               0.0, 0.0, 0.0,                0.0,                 0.0, 
            0.0,                 0.0,                  0.0, 0.0, 
             18.422091394706996],
       [11.184496895273057, 0.0, 0.0,                0.0, -5.3102471507701585, 
            0.0,                 0.0,                  0.0, 0.0, 
                            0.0],
       [               0.0, 0.0, 0.0,                0.0,                 0.0, 
            0.0, -23.510335264698448,                  0.0, 0.0, 
                            0.0]])
aclassmat[Complex] = \
array([[                                       0j, 
                                                  0j, 
                                                  0j, 
            (10.350409593744667-1.3510737476070689j), 0j, 
                                                   0j, 0j, 
                                                   0j, 
             (6.9288875355309543-5.3103338058269198j), 0j],
       [                                       0j, 
                                                  0j, 
                                                  0j, 
                                                  0j, 0j, 
                                                   0j, 0j, 
            (-6.9293837604374042-6.6641632566969342j), 
                                                   0j, 0j],
       [                                       0j, 
                                                  0j, 
                                                  0j, 
                                                  0j, 0j, 
                                                   0j, 0j, 
                                                   0j, 
                                                   0j, 0j],
       [                                       0j, 
            (-1.6705801756075045-1.678637518063665j), 
            (14.496782887959375-17.373375220800888j), 
                                                  0j, 0j, 
                                                   0j, 0j, 
                                                   0j, 
                                                   0j, 0j],
       [                                       0j, 
                                                  0j, 
                                                  0j, 
                                                  0j, 0j, 
                                                   0j, 0j, 
                                                   0j, 
                                                   0j, 0j],
       [                                       0j, 
                                                  0j, 
                                                  0j, 
                                                  0j, 0j, 
            (1.5146299554580132-0.59157410284461198j), 0j, 
                                                   0j, 
            (-11.69268761755986-0.74239872253497907j), 0j],
       [(0.37023425567151058+14.386146210905359j), 
                                                  0j, 
                                                  0j, 
                                                  0j, 0j, 
                                                   0j, 0j, 
                                                   0j, 
                                                   0j, 0j],
       [                                       0j, 
                                                  0j, 
                                                  0j, 
                                                  0j, 0j, 
                                                   0j, 0j, 
                                                   0j, 
                                                   0j, 0j],
       [                                       0j, 
                                                  0j, 
                                                  0j, 
                                                  0j, 0j, 
                                                   0j, 0j, 
                                                   0j, 
            (-24.778624246916337-9.2502817863009739j), 0j],
       [                                       0j, 
                                                  0j, 
                                                  0j, 
                                                  0j, 0j, 
                                                   0j, 0j, 
                                                   0j, 
                                                   0j, 0j]])
# eigenvectors ----------------------------------------------------------------
eigvmat = {}
eigvmat[Float] = \
array([[-14.812483279231687,   3.5488428216955463,   5.5510568295576714, 
             -8.9325267179676402,    3.8253704162969382,   -13.701175483318156, 
              4.7120037162496242,     1.6539591833367395,   18.594602640645753, 
              10.550743466949097,  -6.0568369364578594,  -5.1277616932099281, 
              -2.0834032343157922,   -2.7921096422759333,   13.103428753585792, 
                5.376738598931702,   -3.2043955863120921,  -4.2404154760881889, 
             0.49899900532498292,   5.3757543414507145,  -22.338669379370522, 
             -9.3113705150101218,   2.7270380782525487,   10.760829842442091, 
              23.318814930292188,    6.2401498090870957,   6.6760821153622372, 
             -2.3513487289965611,   5.2437182290013951,    3.2968911187263639, 
              3.1065864243728396,   -8.1557458836857393,   -3.9203357759892414, 
             -16.352156137734497,  -20.769214137774746,    -19.571572633932547, 
             -3.3678065977652469,    2.6675569238494798,    7.9536461642418264, 
              -1.4191678720678835,  -15.651829292386097,   -16.628739077413613, 
             -2.1022531026771789,     9.452178318321355,  -3.5321603006500664, 
                -4.961418394716425, -0.49968922686765921, 
            -0.082412115652826259,  -1.9542668553578144,  -27.256312742952453, 
              6.2341830150257858,  -3.9342189986240212,     13.9562029991678, 
              2.4755515251755522,    10.12100130916612,    5.3869707198096526, 
              8.6112480978246833,   10.721761607110862,   12.454303349473646, 
             -1.1841485076429965,  -18.632361810169066,   15.898285215341179, 
              2.3567235248680447,   -8.7339134374176108, -7.6891212254152812, 
              6.7615182875646678,  7.6440588578607329,   25.668369660811294, 
             -12.930917113990363,  -20.102720381530091,   -3.5955514202680701, 
              1.5137389380289297,   2.4533232670086349,   3.6739281857063739, 
               21.516694401424186,  -14.938322680836118,  -16.611171907634002, 
              4.1550050890279886,   12.287147789257283,    4.1237531436232064, 
               5.0343550983254284,   12.322806244439164,   -16.417910648817497, 
               13.170014600087999,  -2.5554181116123695,   -4.7966817700538726, 
               14.181949874489581,    3.4883987371880796,  -3.1896274981813209, 
             -27.090628262319033,   17.147440152595721,  -9.8656725323823231, 
             -21.638866258937817,   15.137828919953629, -5.1050382355989168, 
             -3.6098962169583402,    -8.979177786241415,  -5.5551851060761068, 
                17.08935503280512,   9.6956173387081481],
       [ 19.679848094135188,  -13.657217675020856,   4.4519042745753836, 
             -4.4069556517394473,     10.15279953697255,  -0.88921104718233457, 
              18.552136918981969,    -4.2875253923455379,   2.2572371823643604, 
             -2.4272874154408361,   9.1067872792581053,   11.971891371561176, 
              -9.8920752185634786,    3.7719250102030299,   7.8319390761840122, 
              -4.9965286717521842,   -15.011482556291165,  -3.7121008277004659, 
              4.9982830179650648,   5.4202614146791763,   10.104758456590034, 
            -0.51603044393833075,  -4.2001476832337357,    7.708228087750185, 
              4.1492062938248537,   -1.6419462781663077,   8.2774551230334907, 
              10.635949251801973,  -10.573541137910532,    2.4490297384177229, 
              15.201531937315128,   -3.9081548105110682,   -8.0158098985614803, 
             -5.8066363057780626, -0.40376731006697697,     2.3884414805926983, 
              1.6095367766606725,    -0.372919805624779,  -0.55014410830498539, 
              -10.051789600017354,   9.7952883788084986,   -0.2721666533524737, 
              13.544082326046576,   -2.6849894724070449,   17.402291397543411, 
                2.2684820644917418,  -8.0550119015485837, 
              -7.2276867827861242,  -8.6682602536553617,  -12.325206421779573, 
              9.7531706563665637,    16.82618464819668, -0.72758764129081432, 
            0.030301873035945021,   15.009672077966854,   -1.0952140074470547, 
             -2.4817592023350734,   25.617114322780161,  -2.8616412552161838, 
             -11.726594868574022,  -1.2834380399774634,  -3.4756647779066374, 
            -0.50929287700058934,    2.6631676137734255,  2.8165536507216538, 
              9.4691100040811218, -2.1051196813852817,  -17.793333381983814, 
              8.9483003670203409,   12.942740449503285,    2.5079876782819936, 
              6.1685917194692044,   14.728837559279706,  -8.9337754529173843, 
               9.4551865031583375,   1.3149178245764896,  -4.2916760768611084, 
              -2.019211307719849,   7.4643957565060894,    6.7729806603467688, 
               2.1360194590856723,   1.2132573009506138,  -0.65477919424174913, 
              -5.3181142706477473,  -19.289937728247338,    -6.847074321299587, 
               3.4551421601570276,   -1.1222501488102994,  -15.731625613441338, 
             0.12552878076377411,  -10.703716177714595,  -5.0412291566441496, 
              1.4539208993766815,   12.445640457603552,  4.9532252826902026, 
             -1.3992565416586049,   -5.1260808269916698,   -10.80511726872437, 
              -19.934157251284432,  -8.4165524547056378],
       [ 3.7427749969470958,   1.4983440206957037,  -12.739987217483154, 
              5.5342304182212274,    16.984099479671812,   -15.505233689982298, 
              3.5461102813376599,     7.8438575232345942,  -2.3962764563925489, 
             -14.777028291749254,  -9.2087325773213635,  -7.4223645486845626, 
              -8.6840354784083225,    8.3652114220826022,   17.065973108553397, 
              -2.1132187640491296,  -0.18554622623321509,   13.558073433470962, 
             -9.0584064931171895,  -15.210333489522494,   19.637116063413064, 
             -21.066553025597571,  -9.5906458299993975,  -3.5630413540315131, 
             -3.9264812068164527,    7.5890273169387878,  -1.4359615450115308, 
            -0.21827273291891156,   3.1205303043700021,    -15.46269419527512, 
              14.964349787074813,   -1.0445150606322435,   -6.2567100186134583, 
             -4.7013103441801105,   3.0390142199938737,    -7.9035373664417294, 
               12.61597209847373,    5.4703190712840897,     1.591056023628179, 
              0.50860867162331713,   4.6951796302888695,    1.6247298855844061, 
              1.7269751766043813,   -1.2030875783041766,  0.28115594081955736, 
               0.27462191884933851,   15.115031864304671, 
              -11.858676026877866,  -1.7580827398326591,   6.8055002713476327, 
            -0.63188731745718363,  -4.2073066360091698,  -12.455140460608497, 
              6.0329753359126332,  0.95716211526486261,   -2.0751878848985603, 
             -11.723983371355056,  -13.075304537110439,  -2.9935258528914006, 
              6.5558378840571594, -0.18688033752031288,   6.0703954827498965, 
             -7.7025716800771074,     4.830771659284089, -1.7201813908921446, 
              24.976113569300409, -5.5070036754420313,  -3.2612715743643701, 
             -2.1807832512493217,  -14.327982221870601,    4.4741428210014869, 
                 19.376736075133,  -12.176524898217799,  -4.5871251104176274, 
              -6.4414234715353826,  -5.7734011571762958,   4.8397717509895894, 
              -5.239433128871279,   10.490545080141029,    2.3564928757369867, 
              -24.794779566387191,  -1.8298792797969994,    13.602455015149053, 
               6.4795878245300331,  -8.7508043247144069,   -13.568005671854731, 
               4.8211172163985303,    26.581725424920407,  0.62635970555746434, 
             0.60706196854401817,   15.911150321043589,  -2.1337607386311181, 
             -6.6904129857863293,  -12.274957373552226,  7.6327687201206071, 
              3.1466232197562287,   -11.128731866446627,   2.5535786470829174, 
              -7.3711877362051101,   11.476880979653997],
       [0.18832910169521538,  -11.795057179188504,   7.2461678456109633, 
               5.992907795209458,   -1.3127108793496334,    6.0232012857604067, 
              6.2393118393063407,     8.4146661812201469,   1.2895757722619106, 
             -2.9638124079776746,   11.636493162983159,  -9.8873173447312492, 
               3.6019725419831783,    2.8034833845733926,   -5.715872719356355, 
               2.6830815825616847,    -11.53539643050104,   -6.769526495436379, 
              9.7812404789531904,   11.628315122519668,  -28.816176590321881, 
             -10.317502515318218,   3.4724764814779969,  -14.863381296748564, 
              7.9447780573133739,    8.4873608906645988,   9.1258480706246754, 
             -13.369340339829787,  -9.9973559547499651,   -4.5229200769618121, 
             -10.525734308638652,    23.395929799908938,    16.957609282377785, 
              13.473337132632846,   7.5237374515159683,     22.684171693178126, 
              9.7559112564708244,   -14.896559320702981,   -11.271359292986345, 
              -4.9178442038304695,  -8.9061677560442511,   -11.570417883220973, 
             -7.8746352132999275,    18.483870375847083,  -6.3162532136502954, 
               -7.8220483628122137, -0.11695538382881655, 
              -9.9930161854265123,   1.6568675683138214,    16.96807959061919, 
               7.084106155034851,   1.1347226112440485,  -10.009283849497789, 
             0.13540703589645325,  -6.3460471507656635,     6.960745859233084, 
              1.2003287195062418,   10.486444072130423, -0.88658562565583621, 
             -5.6358740662591149,  -14.883440533820725,   6.2387662718478589, 
             -2.2597259431025338,   -21.771510217021209,  10.593278520209244, 
              9.7699477123160232, 0.22109357701165905,  -4.6905547339335119, 
              12.328839758418749,  -5.0959927177368849,     7.694644039897609, 
             -14.851148557399103,    12.66166471911221,  -5.0258519442377203, 
              -9.0880548100230758,  -14.338239220688482,     4.12071329330161, 
              13.407935447617202,   6.7153101773533646,    7.2163964773279075, 
              -6.2654099528331617,   1.9195854535031851,   -11.112420962430345, 
             -0.89285731755398134,    3.438760867275275,    2.3656575995512492, 
               12.202739265018979, -0.021353078713782801,  -1.3253054035471943, 
              10.671662244208203,   17.449239071593222,   6.0498542074769084, 
             -6.1060124028191538,  -17.371226740463065, -3.0568167201610179, 
            -0.72124972309446822,    2.3262632849081726,  -10.503092361080292, 
               6.6858344384373645,  -6.6837803341068449],
       [ 14.215132666968366,  -14.183881387257841,  -15.310708455264825, 
              12.536190983217178,    17.972430951130871,   0.29458104089837434, 
              11.591075942105531,    -7.0125838495638426,    12.04969165574826, 
             -4.3366561482869246,   12.041161586370903,  -3.1902709363900672, 
               1.7928747392473352,     5.147732754061086, -0.68615884645329972, 
              -1.3017021798705803,   -9.9637048224846243,  -2.1112695583609637, 
             -3.0591955469859435,  -10.723729864329615,  -15.034483600878648, 
             -23.234294585270327,   10.014053298496258,  -2.6134165724980978, 
             -5.1950827681700575,   -17.288590939575464,   -17.23398903353409, 
              4.1009940809900955,  -15.146024702165784,    3.1343163298396637, 
              5.9369776625256367,    11.055600692644854,   -11.773967683118535, 
             -3.1252685183486135,   4.6295314859586645,     5.9242193338506368, 
               5.614661838667482,    14.718300952653136,   -19.791023598831256, 
               4.8622366731888489,    8.690373832922365,    7.7258756114250646, 
              18.158930523781688,    4.3121284529076771,   1.3826903124147794, 
                 12.51935568608859,   10.677237271679497, 
               9.8033673740763021,   3.1247656778223587,   -13.91725640098343, 
              7.3010639194590263,  -1.9558915558936092,  -10.690379831790473, 
             -1.0224850568930162,  -0.8028409088304409,  -0.78926228393985465, 
             -1.3275659279797609,  -10.859831527217903,   8.2085260661373134, 
             -16.706340831064882,   3.1493647291083233,  0.84287686902323977, 
              6.3571836718779178,   -9.8173098784942852, -7.2075072495442942, 
             -1.0887009569207604, 0.10404616192739452,  -12.415301748461292, 
              12.945294497072361,   18.354697740811378,    -9.940873152466617, 
             -7.7258143026447144,  -13.167546230881783,  -6.8286606862753105, 
              0.20701136706370921,   11.762854182921711,   12.655547374432848, 
              1.2655187374187755,   9.7382521783287626,   -2.1453244950662134, 
              -1.4527315353191228,   12.183904023772667,   -6.8855429613829244, 
               7.4757431898889983,   22.366560908718892,   -3.3893512135545683, 
              -9.8736443779011012,    12.501384853998452,  -14.466028632356849, 
               2.570835666222953,   7.1940934149179894,   5.6990178969773115, 
             -6.0846059171425635,   13.184976536915405, -2.1795837141735714, 
              9.2677596625526544,    4.1228582099276565,   4.4312282798493303, 
               1.7331795272130797,   3.8116739856025443],
       [-2.9157880480691634,  -2.9104183877120593,   6.6287143203172274, 
              16.072469359891468,    15.422051397734482,   -11.766696599239223, 
             -7.3321585404596448,    -22.323408202757101,  -6.3031851058354444, 
             -15.837666269186206,  -1.3898226966607385,  -10.070128472955863, 
              -1.1069185453364241,  -0.78180758051962407,  0.43415332278843427, 
              -19.370135911285406,   -15.454845455741657,  -8.6206865944039937, 
             -4.1644877576317434,   1.5001949900419702,   3.1509245405132926, 
             -24.290119226803888,  -2.8198385919786464,   4.8737294387874144, 
             0.61901499748689948,   -9.8823603296719646,   -6.174856119994919, 
             -1.3269970099765773,  -9.4244464694479237,    12.050837070599147, 
              11.028135134727478,    16.334278540660399,    15.255572536003605, 
             0.20060319263852347,   3.9163884335359871,     1.8670465215293781, 
              2.0401980865967388,    11.192218145652642,    3.7216633418297813, 
               3.2311059544893079,  -8.3811075667855697,   -6.3197097393119037, 
              13.606401742209506,   -4.6200381682057658,  -14.865490016384459, 
               -13.208837131577631,   4.1158559036445226, 
              0.61603487221968578,   1.8746657673067015,  -7.0459569223712473, 
              16.763727028986708,  -1.1130770864186661,  -15.063289294375771, 
              5.5797453378537645,  -14.744928416709818,    3.7895507685107792, 
             -8.8738084695257253,  -4.7584025821978164,   14.865804046624993, 
              14.803651451682471,  0.67605694854363763,   4.8798132674058223, 
             -31.089076329676139,   -8.0619779100540292,  13.104434354189248, 
             -4.2521655270055376,  5.5103773185846761,  -2.5078487956618583, 
               7.157874771918646,   8.3773084781265474,   -21.122447077830927, 
             -6.4113504605930283,  -4.9626723801245518,   15.503905660330116, 
               7.0193735418373402,  -9.9388773056793038,   2.4207195043596621, 
               20.28661269296574,  -20.645822335850546,    13.121644425201684, 
               4.9482384238700776,   8.0020071552999816,   -7.6369397925396632, 
              -18.150017206266064,   17.007522987916754,   -8.1338694401721252, 
             -0.78032050338306558,    10.373963882805285,  -3.3574357520822593, 
             -2.5434443654821877,   6.8866925371748966,   3.8703337537823912, 
             -1.9100776588784254,  -7.0930996000480917, -22.596790560918624, 
             -9.6821416243919831,   -4.4120468960307404,  -5.8300221871161373, 
               10.464538752302229,  -7.0421832982090162],
       [-7.2140799065406815,   1.0144574293659019,  -7.3210675310672588, 
             -16.336255190725911,   -15.845313485167642,   -8.3312573829618657, 
              4.3445018259771571,    -3.2556662458122529,  -15.753403716022545, 
              12.123810759852196,  -8.3785270200480291,  -7.5734877549951403, 
              -7.8701186029333723,    5.5264340193759605,  -11.123782377546798, 
               2.6611391221622571,   -7.2201503459307546,  -13.568862876236603, 
             -10.893622633061426,    13.22502421335397,   14.475898106403635, 
              16.234247264103239,   9.9518333412287223,   5.7657692700162038, 
              2.9911892091531027,     6.831790922486447,   5.9503921250263234, 
               9.752424501479366,    9.441456720344469,   -3.0203161235649683, 
             -9.7142080206722579,   -4.7655796878432888,   -1.2096577176659173, 
              13.085839481775736,  -21.913196718216518,    -19.467389000140006, 
              15.228813465588706,   -3.0921562824313047,   -12.083957504933743, 
              -20.874805416810204,   2.4033737745230264,    15.560329567051339, 
             -6.0249039676963605,   -3.7351865873522208,   1.7297987340335073, 
               -12.210668159197919,   5.8895593515683462, 
              -6.6533345725108992,   -3.467908764775669,  -8.7454931048178608, 
              13.547861936877146,  -5.1863975713219057,   14.398258968235726, 
              1.3521660898118237,  -1.2336292536031466,    12.060358318776132, 
             -7.1307768350644167,  -5.7106633189936726,  -4.4582717430879288, 
              6.4836486139416873,  -9.9864601079821043,   12.743638624901791, 
             -9.4883315673196726,   -5.4180270690776933,  1.7062146435496111, 
              17.589950728039163,  10.329663779980265,  -20.560578373740228, 
             0.48723311561282873,   6.7915400299768161,   -2.2529228399820584, 
              2.0674621472135506,  -9.9175509419384351,  -8.5612103058633551, 
               22.016499628866903,  -11.424860425025882,   5.5574538325981937, 
             -4.1870455468947991,   0.8959413861034109,    7.1557593460846167, 
              -10.540017415555273,   5.6368114976220145,    13.528523192929999, 
               13.836745984419936,   10.088405462596391,    1.5571978502032524, 
               1.6589150299624138,   -1.2852498520536537,   6.7539360058530065, 
              8.9830463179228541,  -3.6121389196942655,  -1.3844279388791005, 
                6.05168930740808,   13.617106695010346,  -9.165157421800707, 
              5.4876499935549159,    -14.27414371354846,   6.1713146774803445, 
              -9.6763182245761978,  -14.052367354920651],
       [ 17.531939425453153,  -3.8864053770053135,  -2.3714709386170569, 
             -5.2047288867590726,   -15.559113874934274,    7.1706090084402287, 
             -6.4822833338121679, -0.0067867915118646925,  -26.692798111628761, 
              18.694757963641937,   5.6460205473437242,   6.2407120874848312, 
              -2.3522947007989705,   -10.193486915319887,   11.185927586773188, 
              -17.510518684491327,    7.2682554384644993,    3.640692470542608, 
              13.197047071153849,  -4.8121111577122031,  -2.1730706506690716, 
             -2.6143871513000754,   6.9184776684164797,   23.210132544352568, 
             -6.7232575722606072,   -1.1859425947518434,   -4.807293271562644, 
             -18.072297156406766,    0.941637445285196,     3.510993763076554, 
              9.0247106544658191,   -3.1409819396273124,   -17.077432787688057, 
              4.1332742552900399,  0.35533685160314632,      4.967395761283135, 
             -3.5624437542765026,    1.1484674187082646,    17.233454842040135, 
               2.8420837311079374,   5.3898374395639737,   -16.633562415147157, 
              11.233977722836046,   -8.3801448544783383,   7.9735279442794553, 
               -5.9921701145373154,   5.9218365376479962, 
              -2.1652974636981144,  -6.6792885882853801,  -17.244870164402609, 
                19.5503566555312,  -13.007320014397269,   5.8119593638487803, 
             -5.3279038418330824,  -20.793344102437636,     4.904640722418625, 
              12.618970335567578,   2.8555261823808649,  -16.292830238135192, 
              14.095702239032397,   12.916770804878428,  -10.416880488545399, 
              12.215385485696075,     4.886545759205486, -13.608862335620245, 
              11.431762264204476, -14.800750481361213,  -11.250008757670681, 
             -18.034351668981188,   2.6296659998675596,   -14.435894702420891, 
              -2.793597750892439,   10.156467127764772,   2.7047683073310962, 
               1.7035849721765621,   15.566650131369462,   10.705579837437947, 
              16.032447182683519,  -5.0868685084850309,   -10.334095105522225, 
             -0.67818465108886217,   6.8398677363711187,    2.6723306324573075, 
                -12.4655054397361,   1.9564739291324031,    24.092998479368042, 
             -0.39286743287419779,    17.039281658661174,   3.8955823152504845, 
              1.5570939380936548,   19.006203818611628,   9.4993762053926858, 
             -4.5982875323968466,   2.0105265417314393, -1.1298478609638236, 
             -10.421779689751974,   -15.662555563465917,   1.3191364352805897, 
               13.276354753435575,  -14.175561009740763],
       [-2.2528758093554226, -0.56911327806353784,  -9.4303724860593672, 
             -4.6950708676827944,   -6.8304187402391783,    6.3341174441672941, 
              1.9577417237836223,    0.99203153203737338,   5.6913702421110548, 
              1.5915783450498278,   5.8636527742049074,  -5.2491876085253573, 
              -4.5106125234748458,    10.148335250864449,  -28.082352123460229, 
              -3.7606565366965894,    5.1744142162090734,  -1.9481063835148307, 
             -17.526380514758952,  -13.995247620479249,   -11.32644734251987, 
              -2.119853953203318,  -9.6508124899238705,  -11.011887319071352, 
               2.761426072620095,   -11.057483459948788,   2.2556514659711664, 
             -2.2677853449200196,   8.8319438323528399,    11.427988940290518, 
             -6.6646775792040867,   -2.1131658083922855,    9.8752633217959147, 
              2.8526220332603227,   8.5709611335131459,    -2.8928614664558063, 
              4.9316342211853277,     4.898271207087789,   -20.798335523571467, 
               -10.25282068009734,   14.169804779000053,    12.306338867574238, 
              4.4637847857906818,   -6.1127928798464923,   7.3505418524478046, 
               -14.263976287469482,   24.149869200119451, 
                12.30068646944359,  -7.6493390395378027,   11.170010234764018, 
              8.2282691249561974,   4.0393574097035954,  -12.637529385252344, 
             -7.5491393291526006,  -17.385101178863614,    3.8686613605591096, 
             -3.5866824356705402,    5.210099561211158,   17.747107957061097, 
              20.229455344088976,    13.54919944019133,  -11.333377019188939, 
              6.6800559990697259,    9.5404863091928007,  5.4788415570629816, 
              14.843229320624294,  12.624567508487775,   3.3790588385476159, 
             -7.4924631681991265,   4.1106027592362615,   -6.2295054222170414, 
              1.1562832869517283,   4.7916418632760074,  -5.3328600529097203, 
              -4.1336915810161301,   -6.419963970970719,     2.56450231380503, 
                3.19077742328435,   9.7360663013776083,     8.216743756919465, 
              -4.6682048976869899,   5.8685595731874587,   -7.2368099646603294, 
               12.269036020348164,  -10.074129537037548,    0.1246629993924348, 
              0.24220202909900973,     3.623517167866515,  0.31163070166077178, 
              1.6991023976997168,  -7.4441774713063396,    2.642454258381048, 
              1.9087933848390173,   4.7494889119354076, -1.4503623898814793, 
             -11.135745800264692,    22.470676433346135,   16.997567190251878, 
             -0.21237440677512351,  -8.2262449183726769],
       [ 18.618935469039229,  0.27696148508683816,  -22.113501622494361, 
            -0.84017789865354509,    -1.950058433297851,    11.791010114732041, 
              -1.386125125644448,    -9.7903579370100839,   7.8427692957168187, 
             -9.4587082228630965,   9.6656718442949359,  -1.1938197519176577, 
               -14.11148096130743,     7.281742390725868,  -16.663225464210381, 
               9.8991088195491166, -0.089749992455236599,   5.0760046224111131, 
             -3.7596397184427928,   14.391109471193278,   6.0391202242379469, 
             -1.9660537851454187,   1.7251020825062917,  -7.7896846063819325, 
             -16.977285845211338,   -8.3231671822745934,   8.0928032582226557, 
              9.9943087032494589,     5.48317001908819,   -11.991911306145591, 
             -31.273360872171267,   -9.8975954132215662,    -6.308156667702848, 
              3.0866271495908517,   4.1216254244830841,     4.1643492365842452, 
              16.333593669555512,    11.954810218462232,    10.450277409043458, 
               13.003673178485313,  0.02368438782337209,   -11.993178648851226, 
             -9.3799541811478981,    -7.007580661756883,  -8.3196305688544374, 
               0.84029958200442667,   14.928154429099816, 
             -0.19526201091009029,   8.3532609963083608,   12.774238319014874, 
              20.887029670327905,  -2.6300783342302987,  -3.7569243620992374, 
               -7.54844098193833,  -2.2214870786536665,   -6.7560815058786305, 
             0.20583704803516403,   11.478508860059611,  -8.0863741551749158, 
             -6.6150055064431861,  -14.972893135444426,   5.3112752360863187, 
             -22.657584698474317,   -15.911316912642533, 0.63015855012638622, 
             -2.9855578968946892,   5.053733062607348,   5.8582306958817121, 
             -11.972397773213695,  -3.6436565684064286,    4.6601980566002235, 
             -7.4094422197504262,   2.8778372361411524,  -6.2445309623096943, 
              -29.599966849878481,  -5.2265001883375106,  -1.6195786105675827, 
             -6.1149753521026398,   12.218153069698275,    0.1750028949266233, 
               5.3437631048996455,  -4.1830621123650245,      5.64643503832521, 
              -3.8866703742162221, -0.22911632965569359,    -8.301485260648672, 
               10.738158250841082,    1.1714185487207804,   3.0821962333998005, 
              11.118661391694282,   5.9197291589839978,  -6.2359909159119562, 
            -0.73937084359710314,   18.560891095595139, -8.1408142772011942, 
             -8.7089901215640744,    9.7394579506920724,   7.3420436513227791, 
              -5.5897991810336043,   4.3886596229340142],
       [  3.991499967321761,   2.8315012453563537,  -13.855923343199256, 
             -9.6471592253493395,   0.54823354710492689,    12.370347561898154, 
             -6.0910890564159441,    -21.917902945583126,   1.8727917884243226, 
              11.189668070804322,  -7.2515761277124104,  -3.4964738911598299, 
               4.6595717862166932,    3.4014874030875775,  -1.6529571348857601, 
              -5.2960188254398926,    1.7035094967340036,   8.5465295768123504, 
             0.49574257435505781,  -11.585271501451244,  -6.0791451214732675, 
              13.882387852327209,   1.8428569236002545,   -10.25833775786994, 
             -2.1379575262122055,    7.1097581032530819,   19.124133665763431, 
              12.049370150252487,   5.7279298366811577,    -15.78068361646219, 
             -17.315304471234512,   -7.9725768816662175,    4.7039342236464012, 
              19.083478776821543,  0.82040439256744524,     5.1241114100487941, 
               6.451443796540703,   -16.906176389940889,    11.191043768230827, 
                12.70036536244862,  -2.4821685511563425,   -15.330269290933954, 
             -0.3981688468040826,   -7.5729154978265019,  -8.8197227032534684, 
                10.726783128491386,  -1.6185898837582151, 
              -15.918517726158825,   1.0318110474425446,   6.3906975836315212, 
             -7.2344690307822956,  -4.0924339794984412,   1.6404072583232274, 
              2.4214922416531408,   2.9892054839790556,   -1.3107103100492563, 
             -4.3772716753149501,  -2.0886294882761702,  -18.041234078218828, 
              6.2793273641931169,  -5.1899509627336489,  0.82712557390977559, 
              5.0308967716258106,   -7.8672404850722462, -2.7074481485020314, 
              9.4055934527597653,  5.3012791124431891,   9.5691793875629312, 
             -5.7683629343500256,   -3.204786557983935,    4.7358488151283966, 
              3.4837090288043395,   2.1203797609951796,  -4.1111259901136901, 
              -5.6605290258114422,   13.024023402296194,   2.9839091360618082, 
             -10.585283953934603,   10.543640027001761,   0.50554291452284683, 
              -5.8280894751401755,  -14.779287990259885,    6.4675359481659083, 
               5.9645902035164058,  -5.4711286461065933,    7.9436489517523556, 
               16.175177371985733,    3.5867923253388319,   10.794396246621146, 
             -11.485657342421195,  -9.5158138469406115,  -6.0281230596457789, 
            -0.37953154362758673,   9.5410650639357737,   3.560309683998033, 
             -2.4177727511056366,    9.6695912178781267,  -4.3529018199317839, 
               3.9218280723291175,   1.5932263717844644],
       [-9.9493299008772205,   12.359356555335266,  -10.328670193735803, 
              16.215648801501604,    7.8771221520447892,   -8.4259917436047136, 
             -3.9454884215299542,     5.5490957118253901,   2.5571215010496795, 
              5.3565453348933829,  -14.739347505017509,   -13.51606528397739, 
               8.5137990159807657, -0.081337151250689632,  -3.7066615396615958, 
              -5.3368444569021705,   -7.1099623532209097,  -0.8701501431112959, 
              3.3741247492477799, -0.36432661161984964,  -10.771339535820658, 
              -22.49765134086633,   10.479812981659173,  -7.8742856014617537, 
              4.9184979410673773,   -1.8126784384504167,  -11.207362808926554, 
              5.9514181745847647,  -8.1364521004331021, -0.078379313942102902, 
             -12.646603195834141,    17.115322736901845,    7.3054649184622287, 
             -9.6409570737575763,   4.7637145308812325,    -9.3906865364558954, 
             -18.473310334940251,    5.8794377152823865,  -0.62446685952677572, 
              -3.1469022990043092,  -3.4651980515062775,    1.0779050304919608, 
             -4.6249859911836113,   -22.922364707889994,  -14.022304345702157, 
                3.0304808083065597,  -2.0912798767015643, 
              -2.8088963815145869,  -8.4386006218855041,   8.8968244136614683, 
             -4.5784118491040395,  -7.5929933032465371,  -7.0738585093340927, 
              15.781676455993324,  -5.9662711705386338,    3.8767184447166159, 
            -0.94952881268285916,  -2.5162715481584352,    18.39321733413253, 
              11.718707950584877, -0.10540657194025095,  -8.3062562974420775, 
              -7.264584198866352,    1.9315961325772322, -16.194972689960629, 
             0.80820902677048234,  6.2734922148356986,  -6.2298830166371335, 
             -8.6487995293607351,   1.1866339917108917,    9.6957665227102492, 
              9.1897064722176722,   27.225257342598852,   12.948981165803472, 
               8.2598110218781855,   -0.586961297687835,  -3.0371864945418392, 
              6.0096136550578008,   3.2030423037012428,     9.491265769794655, 
               5.7328260112198688,   10.543920114025962,    4.3816038138987619, 
              -18.094972305458338,   8.1943337090055444,     1.804152372146715, 
              -2.7096105919086391,    5.0040688620352523,  -2.0629907323680605, 
             -6.9353143216788462,  -6.9462656229525068,  -1.8823236191544552, 
              9.3935837182560764,   11.880370613941153,  1.0092368074966271, 
             -1.9672179286717892,    1.3807624495373534,  -7.3908095866505663, 
               9.7229718497950195,   10.516350108137352],
       [-9.0298621843347338,   5.2444380099424457,   1.4073177133761219, 
              4.7720133832632126,    10.939737419141979,   -20.946655403972411, 
             -19.354999056373067,    -6.7756935733386854,  -13.816457199613074, 
              -4.295412780461934,   10.074447496240747,  -3.5749468520373471, 
              -8.3664566925105994,    5.0389921305339342,  -30.679146184090776, 
              0.62784768070334385,   -7.9943250437314113,   1.2633891480132307, 
              15.451527849554576,   16.873535484892134,  -1.0782647996559407, 
              1.9544946508764951,  -3.2962144564992184,  -18.818540824290221, 
             -12.203304936202661,    3.6715396989049283,   2.8031430389459229, 
              8.3683654525201963,  -4.4216699924736433,    5.5841770584759978, 
             -9.8617335068018264,   -3.5137908877299178,   0.63886750410107007, 
             0.33942715578276117,   9.5043909475106148,     2.1401577060086243, 
             -10.208619022931696,   -20.253072400429115,    -5.428195964551934, 
              -7.4618136643344615,  -15.906516391519974,   -2.5507116328539334, 
              1.0532681006095896,   -1.5192777105638997,  -3.3585529155570311, 
               -10.231802432194995,  -11.001513860038832, 
              -7.0161454585357008, -0.81470393659270279,  -9.6328252010035698, 
             -20.523101697372287,   2.0347933723259959,  -1.0466261163795771, 
              9.1319920896799616,  -9.1855742947476138,     4.805611472957847, 
              10.105764677179272,   13.301232669225467,   -8.735825739191025, 
             -2.4741718846746914,   3.3521464389541933,   -8.808936307853827, 
              5.4282414087429212,    10.306015313715104, 0.69868138957660875, 
              17.838399107318843,  12.898737429359937,  -1.0115728778294339, 
             -11.491470626694738,  -3.0520409002610869,   -3.3143797209506598, 
               2.345871275370532,  -3.8513911279362727,  -5.3533591407412491, 
               3.0431622342969038,  -6.0053435085514746,   5.4678914609307681, 
              -8.739209465386903,  -3.2475718935746385,  -0.31372689747739718, 
               11.558077172140495,   2.5147326551960441,   -10.733838550668038, 
               3.3389429102584018,   2.4166553939100934,    5.2911863913065371, 
              -6.2845166818757523,    9.1868681750435677,  0.94521991168781905, 
              -6.528840756395736,   10.343889243138985,    1.253048380856058, 
             -3.7527865162381255,   15.554616987762799,  11.628429140950471, 
             -15.849003717614591,     18.64702568422322,   10.383383341764764, 
              -1.9051343880080251,   -1.342128499371311],
       [ 16.105666490852968,  -4.9323453168855673,  -5.2923548902772044, 
             0.21359393385027425,   -4.9805654879007157,   -1.0921420976903393, 
              10.142297740532179,    -7.9309298604208678,   7.1476809500534078, 
             -25.317279989043747,  -2.4165465023489996,  -12.931227359497885, 
               13.952634202263773,   -2.1572456975943464,   4.4933821423111118, 
               2.4751484371697248,   -25.207240833166296,   4.5491280288059803, 
             -6.4060938729685235,  -8.4917869432925599,  -2.5505671860565027, 
              6.0195001064778388,   7.2646877617635326,  -4.0674590780883371, 
             -4.0928258858155235,    -4.819036949647491,   1.5305826437006327, 
               6.096216827142598, -0.41092219458445495,    1.2673909688638838, 
             -1.9504624984475594,   -9.9697904031836408,  -0.90788128386407596, 
              7.7148799577907932,  0.88413278621987457,    -4.3516784751771462, 
             -39.431812198376164,    -6.597759135235246,   -1.8200167253886494, 
              -8.3147118220336154,   11.539202082054468,    18.229451795487456, 
               6.194053845651152,   -5.6388621746810479,  -15.802805042500722, 
               -16.619059594966462,    1.246995286700546, 
               6.7718820822637547, -0.50643944806528296,   10.111287672582414, 
             -13.858430292219238,   -5.519211959081046,   6.8548429304413894, 
             -7.3538815762436105, -0.52394141247095705,   -3.5586006493758009, 
             -16.012710229932932,   16.677744905047486,   4.0844508452434471, 
              3.8489361862950511,   17.152831092076383, -0.78857939164293755, 
             -1.8785609777786458,    9.3515725192042591, -8.1921917001633577, 
            -0.65265981435334297,  6.3707082808721935,  -1.8667965233718677, 
             -4.8362905572697477,   8.4099143277255912,   -3.3826148922889159, 
              3.1918808212315404,   6.1690998639602332,  -1.4790595146222514, 
              -11.296812304575559,  -16.878561926620975,  0.15863083962078267, 
              11.146946964288492,   2.3220938306990071,    8.1104117134788627, 
              -12.677542229785621,  -5.9454969393011723,    8.7503133405840376, 
                8.876362733865399,   19.245654638707617,   -10.369345399794941, 
              -12.997989946210069,  -0.50515532047196599,   17.517121104083216, 
              13.599176873536205,  -4.5281818545195129,   6.1534435979733324, 
              9.7866863291580124,  -7.3745219251057001, -7.5238742466744188, 
              2.8991474134166491,   -2.3982221642715338,   16.913108159166278, 
              -6.3010547003570849,  -4.4871073181003061],
       [ 1.3421228611956253,   8.3835134099929096,  -2.8718298447547888, 
             -6.1105601496644582,   0.23823504488341879,   -6.4964902381720746, 
             -1.0591883848994263,    -25.035934406652022,   6.1880162055126551, 
              13.550642106871059,  -5.1419264085509884, -0.11175493834991827, 
              -2.6391993942107956,    1.6217329439968404,  -10.150987115189192, 
               10.202889103943917,   -11.086619183598277,  -4.4751062528684766, 
             -8.6756553577257502,   6.0742562785745866, -0.72523554879752838, 
             -13.845342681695689,  -5.4108779290687057,   10.083927042496203, 
             -6.4693573874119439,   -4.5618326375981209,   16.799795338585859, 
             -2.9396890598150853,  -2.3718692597601843,    8.1584653531933355, 
             -5.7005793196165966,   -3.4566843569295216,    2.8980612068470868, 
              15.156958328437488,  -4.9337406573922067,     2.9514546297308293, 
             -1.9381445028997188,    12.058764867365571,   -8.1630523752218167, 
              -3.3741031404038102,   23.514607943697541,   -5.9023009086925029, 
             0.28202468025907973,     6.182494095202431,   2.2566399261889019, 
               -9.6782097870682335,   13.695201421437881, 
              -13.754080528280149,  -7.8611319039527849,   11.958730910171989, 
              16.566588854152332,  -5.8107950058140387,  -2.5561990090296902, 
             -2.6418717015336761,  -3.1251802059505533,    2.3537482114246786, 
             -11.478296533299828,  -15.804646647588516,   7.5260205230910024, 
               2.247616215697807,   7.6303159002986902,   2.3982313085867419, 
             -1.4921413434061168,    3.8926952801073087, -8.5205989383625109, 
              5.6910595978918055, -3.5149190081273485,   2.7350593392541334, 
              2.5336780894684257,   4.4600972956503897,    14.066947089405186, 
              14.314305032873968,   17.052530546935557,    2.845177987927157, 
               7.0245961288215124,   4.4080414984707623,   12.997562837347047, 
              16.941815952186076,  -9.7592073493753624,   -2.6671909095133719, 
               5.5513257397252627,  -7.6782517311621978,   -6.0681745495949819, 
              -16.970040732474349,  -4.1300414307989506,     3.843726523382982, 
              -8.0411185923071073,  -0.95522677893218455,  -5.2184034800503714, 
              11.176169675146518,   2.1495186382251266,   9.7330751907693607, 
             -3.0795436567517065,  -9.4784110511819044, -4.7383828020102738, 
              14.607759797470774, -0.065220082848924762,   5.8241594020121923, 
               6.5223170676846278, -0.34378340263840523],
       [-5.3392139611179203,  0.49234006893515181,   2.6783919056418179, 
             -13.853504866542483,    8.2967732864016028,    2.5204597604733014, 
              3.2274524688015394,     -1.323844781025497,   1.1918100811734589, 
             -13.944155586269222,  -3.1947258997899737,  -6.3835660108044987, 
              -6.5071701802275426,   -29.855320874591666,  0.56999342324870428, 
               4.7899883479804526,    13.732443850576637,   12.112605344513458, 
             -9.3475375528797464,   5.5824116606120278,  -3.6108659018206102, 
             -13.141175734011416,  -5.9707786111073071,    1.590956154007364, 
             -8.7457232029851628,    12.329187794438958,  -1.4046191775363628, 
             -8.8180197688410349,  -4.4439082578578777,   -1.8141808362005807, 
              10.818015063018773,    2.6860054006084324,     3.078125096449952, 
              6.0982460277547847,    7.888824105452823,    -7.3417924097497718, 
             -2.6788921095271867,    12.833302021789866,   -4.6905495096859431, 
              -3.5342519589126837,     8.15500282794995,    -2.861018681024464, 
              7.5114325849644805,   -14.706015663684022,    6.721898152474644, 
                10.649945181380065, -0.32690018623273209, 
                14.41985798885791,  -8.3301070118643281,  -1.8076452550020861, 
             -2.3891283835244623,   25.705447599983078,  -6.0708619799700845, 
              -5.421490082255449,   1.0209474001376235,     16.33659271942312, 
             -1.9229579512177781,  -2.4630515052460704,   22.692658165722065, 
             0.55254456363053384,  -2.1220253829038698,  -6.6531624802666789, 
             -3.0955652149255735,   -2.9441968045357036, -8.6140589117285398, 
             -12.769624764929951,  1.3293593588313524,   4.0121126645520873, 
              3.8663314042859276,  -1.6044903368611687,    2.9071616036274781, 
              22.957876273341689,  -1.9122799789254419,   5.4359222557104214, 
               4.7037813514939559,    5.584879115974041,  -15.105203383351576, 
             -10.015046317352388,  -4.4374307993146891,     10.88141681437741, 
              -5.9919834968963146,    12.37794390865584,  -0.45886281051986899, 
               9.8706354348232512,   8.6173661794284548,   -5.6367593707711752, 
             -0.32844447908921726,    9.3826943078056466, -0.90136751311021679, 
              21.847318448999481,    12.93329399395288,   11.468463158851122, 
             -13.238483205009262,  -5.6648044262356745,  5.4996609677530195, 
             -8.1669884287950101,    2.4995259836645718,   14.322811411888168, 
               2.4383399961188399,   8.3878948104860278],
       [-1.3250846277593764,   5.5834105129525158,  -12.161844503723444, 
              10.038239490343798,    9.8976604289008705,    2.0223095896166883, 
              2.3276776492509104,     9.5346457137487324,  -9.8584017002298712, 
             -20.167024502833748,  -10.525564586591647,   1.1900023728545082, 
               1.6387406240678635,   -4.9213821703024596,   1.1733872987067633, 
              -19.855543391161284,   -7.6465728507550077,  -4.5431234252055166, 
              10.268298743812668,   8.7404616731237024,   16.186217862968494, 
              2.0212236255846951,  -3.3873266955349428,   3.3290650428709267, 
             -14.891248082106063,   -7.6429165952672884,   15.718621104868474, 
              6.3754393603518187,   10.777292913681203,   -3.6385607438689322, 
             -1.8075107413670677,   -3.0771848195249878,   -11.456210674005282, 
              2.5686136776413782,  -11.973613726309063,    -11.798408132906665, 
             -10.631205475447754,   -3.2047746965823265,    10.928879682696673, 
              -13.818578623032922,   4.4665408972289606,   -9.6509577156351671, 
             -4.9772286457245745,   -7.6501020418820662, -0.68469943418892254, 
               -2.8799243794306606,  -6.4390581285340041, 
              -11.395949752747379,   2.0836512984832107,   -12.15024276499177, 
             -1.9437815977074335,   22.118270195584447,  -2.7523916208995018, 
             -8.8896664440572462,   1.5647219933889636,   -6.7940006208472319, 
             -19.754719660188933,  -4.3940649307454409,   14.928899300927901, 
             -2.6317637244403107,  0.38507784624763808,   4.1153652295093082, 
              18.137727405496079,  -0.85999697909354034,   2.534862830480904, 
             -2.5708350365994392, -4.6792529949650792,  -5.1063885711225696, 
              -2.519716026785324, -0.63915693058384293,    6.7035929218129215, 
             -22.226723246963083,   2.8353645197478805,   2.5633508666352882, 
              -5.0517788897599258,  -2.2521450077584473,   12.595998766744751, 
             -9.4759784837615619,  0.68573882062720171,     -10.2754066576918, 
              -4.3875132698244315,  -18.349848055815439,     15.45820718852158, 
               8.6252557167312602,   6.3845817188887573,   -6.0295244026070263, 
               8.5826766928934504,    10.046284917490865,    6.272016120760683, 
             -1.7444891312657504,   10.456229595613774,   18.794544364852065, 
              4.6905729964347813,  -7.3371941768394313, -9.4639357399671038, 
            -0.73400606981017913,   -8.5112648609900141,   15.708371529134634, 
               1.2883115824905862,   4.5374035262816754],
       [ 7.2864806781784539,   3.0531291916167524,  -14.851712368716761, 
            -0.83928671709409697,    3.8830703734727336,   -3.0876024405943263, 
              5.3982125436148021,     3.0757546043381967,  -22.513883408340092, 
              12.121379961609843,  0.68097787133973009,   7.4279296934091379, 
               15.886579934846296,    5.8548955573914965,    6.665502549455935, 
              -6.4387163280005391,   -2.6960671687493045,  -3.1334613821564479, 
             -5.3274890574809328,   14.502950469878598,  -1.2191858082316227, 
             -3.0754142632257944,  -11.220340969973366,   6.3184620973191432, 
              -4.717205616045236,   -3.4290512873515464,  -8.0535735204669798, 
             -3.1634870039989726,   7.9191550317962767,   -5.8236861120916181, 
             -2.3779657809867989,     1.446121982944726,   -6.5543174430566706, 
               4.491385536589946,   5.3179595047569368,    0.20276266959403166, 
             0.27049128624282731,   -18.784132914201479,   -4.7393151943883716, 
                 -4.9259951825982,   7.1652944037560342,    5.0164827653962929, 
             -5.5963241748509844,   -7.6003361722390963,  0.40093637095083173, 
               -9.2218946424980039,  -1.8040633937427744, 
              -24.918612953141771,   24.224614081858221,   -16.31322760846626, 
              19.625351249168727,   19.059473217791123,   3.1895750699379857, 
             -10.787611796961658,  -12.720215651452623,   -4.5833950704451878, 
              7.8153449072255103,  -3.5700174962611935,  -2.6796455466858871, 
             -5.7924035689935982,  -4.4234839706041873,  -3.4959610346199059, 
             -10.364529144564615,   -13.870202392649691, -2.1884627462937973, 
             -8.4077646700247914, -7.5889779444543537,    -5.71640793259263, 
               16.66296769879634,  -13.111501457019994,   -6.9979810815130161, 
              7.4764609033713514,   2.1533321112544463,   18.386197847994335, 
               8.7786301404401641,  -8.0348829260993906,   7.2440056033502742, 
              10.868050228986199,  -2.1648505187031066,  -0.75228153342617254, 
              0.16171780804320979,   16.899309921363887,    12.047880179286082, 
               -3.201326165044641,   12.843063404682386,    -12.50557876694171, 
               14.265104330002849,    1.9971265164417886,  -14.832797134199636, 
              7.7559167013846997,   6.4848005168482086,   5.0544835512001649, 
             -4.6305014096187831,   13.688205326431213,  -4.771506498043796, 
              9.1608761887876415,    21.109062210824892,   20.224222939417047, 
              -10.433641363522092,   10.271752276640093],
       [-6.5823805784038711,   15.352422838593512,   5.2640921467313309, 
             -7.8738074816650281,    1.4807604251127027,     4.423043243014078, 
             -23.478261489361245,    -10.509918891077719,  -2.8706226539010098, 
               8.774488813069464,  -12.944695430682099,    3.305636429795658, 
               13.004720540515587,    2.4069161726283634,   7.3602844256721589, 
               18.935715844955105,   -7.4869349938580481,  -5.4949134471742909, 
              5.7440969119389713,   8.9279774475754277,  -14.250034981117743, 
            -0.92084058421816328,   15.415157333554584,  -2.8426544450546758, 
             -1.1245166320640794,    11.264218217408931,  -4.5256781291621264, 
             -1.2163450694398135,   17.927433472095338,   -11.328038385207622, 
              6.5095427570346036,    3.5871975221367416,  -0.22468829756795652, 
             -10.751642465420002,  -10.161640124249786,    -7.0025572666992364, 
              11.165586029523729,    6.1106280433728264,   -1.0809029939099088, 
              0.64204320170070206,   1.0676275249469718,   -26.668356050725119, 
              4.1966437321648691,    2.6260577942008507,    12.77141420522333, 
               -16.494017967381932,  -1.9814366339101763, 
               2.7563937318098115,  0.11015903601595931,  -1.3373504242416503, 
              8.2035011897218375,   3.1220221429521371,    8.068280985422378, 
               18.30128145165498,  -1.4430260511331006,   -5.9766876017890755, 
             -18.662778642522326,  -5.8843178503367186,  -16.362776100139413, 
             -2.7487884436803292,  -7.1061205066711697,  -3.4383627758852784, 
             0.19676903990231109,     13.44762408120353,  1.2308654921152138, 
             -8.1482096904041974, -1.3315581141840906,  -2.1901797892596382, 
              19.137816275095506,  -14.973885980810127,   -3.0653767767426077, 
              4.5794824074768616,   10.145608270725708,   13.070087371419669, 
               7.2550996518636737,   9.9429379067989867,  -9.7448817027748262, 
             -7.0842266570175898,  -12.249019191425409,    15.907938104034722, 
               -4.199685034712628,  -6.0224279187201448,   -11.663196722614275, 
               2.9773540768335192,  -2.3317223444339463,    17.463259989428227, 
               5.0896040875171655,    8.3808845584471676,   10.162360859833317, 
              2.0487229178497182,  -3.2632673968848556,   4.5240460312251045, 
             -4.9990077556734249,   1.3873227512435671, -3.9392743342889727, 
              3.3153875705356106,   -3.1793963084096379, -0.36193155563136015, 
              -4.5368573073155165,  -6.6979414852298422],
       [ 4.0188750562938527,   5.3440455191616216,  0.47857485769612862, 
             -6.1309017724362658,   -9.4768523233840956,   -5.3925853779580724, 
             -2.3901141607403105,     4.1658069065724224,   13.968356542496531, 
              10.954948943398783,  -9.0160729100965717,   7.1771330346453377, 
              -8.0569477387989981,   -4.8159019388848785,  -1.4255842862000436, 
              -2.8355516491251658,   -3.4449309399040451,    10.03377983843988, 
             -6.5196933631698473,  -19.871102882379919,  -1.8602090047174316, 
               2.057724296093705,   10.840475860752171,  0.41236038941726844, 
             -2.3820462990357112,    8.4490908834653329,  0.64786189114673487, 
              15.456862587980249,   3.9850041304500969,     6.820248336738981, 
              -17.26416956885139,   -8.5998433320308756,   -4.5942496566348243, 
             -3.2886631373217874,  -12.018652748292578,    -6.8400914067452758, 
            -0.94450311254779196,   -8.9856821183874036,    1.5004580877385323, 
               11.406331657118248,  -13.216381075465485,    16.049574056538127, 
             -11.991300098821714,   -3.5535458947903398,   12.743463012692702, 
               -1.1232762168326824,  0.94793447984974577, 
               15.769387551355823,  -15.441857866024584,  -3.9749626947999395, 
             -33.572617562300941,   9.3429099364815915, 0.032542435124985496, 
             -7.2983740991484636,  -2.5063674066107664,   -5.9865038425394559, 
             -7.9903495260810455,  -13.149441383760676,  -9.1784490944448525, 
             -4.2382939882901667,   6.6899027414641212,  -6.5547779783800317, 
             -15.635319994354786,     -6.07179041697563,  9.8280155225508459, 
              -3.411984274812514,   1.136474535071071, -0.47703836059522142, 
              5.0380803306418711,  -8.2098552895427819,    14.793890098114623, 
              6.7566939415281881,  -20.815487478339133,    5.129947688358798, 
              -16.167226871219746,  -12.867130219002966,   3.7409664322966769, 
              5.9544682501397723,  -4.5107847618742074,    8.3485614660315814, 
               8.5826542616300365,  -4.8095883236469898,    22.356339381100568, 
               9.5547940290856133,    1.523308491239068,    12.353477655257471, 
              -6.7837310815571978,   -14.822029593392212,  -2.8521154699163209, 
              8.6803561363860791,   2.2857263602763949, -0.88716431971836496, 
              1.5311732135619207,   4.0043561182038587,  3.2139945556789256, 
             -4.9058813603796958,    -10.50119742088661,   8.4339474400224379, 
              -3.1326825070289073,  -21.637483026043665],
       [ 11.350725349616384,   3.1258623224181097,  -14.050266489922008, 
             -4.3127619285968617,   -11.612368817561107,    -21.35236234523742, 
              2.1742219911880594,    -13.492611590976084,  -1.6649801938921795, 
             -23.921678578726752,    7.828953266675418,  -34.569444998624455, 
              -7.4553551114358898,   -9.4233330653958767,   2.1449282090310353, 
             -0.21810054746758767,    -4.913383740119853,   9.0250567336959779, 
             -4.3106272767142162,   9.3407768755690874,   10.896128461246015, 
             -12.381713462450808,   1.4813479684510025,  -13.773426874647306, 
            -0.73976273513843716,  -0.91367201601767312,    0.305551961874585, 
              4.0841137664470466,  0.49903678384466293,    3.9027176580777585, 
             -11.905063837685731,   -20.577505789511157,    -0.609124334555184, 
             -18.447409729992515,   7.9680522500860276,   -0.15377029715526505, 
             -5.1619314149859949, -0.034586737711413136,   -1.4708263315961263, 
              -8.5606622432497428,    2.665257992296008,    13.553104659643392, 
              1.3256341123096638,    22.129716656203335,   13.201593099011163, 
               -6.6930128056163518,   4.7689509093647651, 
              -14.343479064209211,  -2.5828133429255362,  -2.4228769695458463, 
                9.35243213721869,  -22.151559720287754,  -8.4869964384620804, 
              5.7489808011497505,  -9.6152625444940316,  -0.88463472610321969, 
             -5.6323383740306703,  -5.7476513307898793,   3.2955678135202215, 
             -8.6234176560027862,  -12.871892104626719,  -10.511281800380214, 
             -1.0267785148850652,   -5.2611912396864611, -10.782704600810746, 
              1.0777215505973283,  3.5305610877330751,  -1.3341355187256922, 
             -15.923043858511779,  -23.565250307183291,    7.3630485084366137, 
             -18.674012356587475,   6.4084417505318578,   -7.462562752650868, 
              -13.820841324492203,   -4.820838862103872,  -1.5075950903766024, 
              7.0181188425924912,  -0.9441383982815017,    5.9933238884511306, 
               12.129232033737836,  0.94436593119666701,    3.7305123918866867, 
              -10.843948559279557,  -4.1935371239999766,    1.8841421882657217, 
              -4.0952428578810087,   -6.8193420136429879,  -8.4696551396492765, 
              5.1013217113516642,   2.1074266322852506,   3.5563513445687627, 
             -9.0499716163368298, -0.69818932474450324, -21.126134223835304, 
              17.547449033633974,   -9.8505761688029594,   19.756213152828256, 
              -2.2575330777330502,    -9.77142025080507],
       [ 7.5227494851234606,  -4.5575903073035233,  -4.1030056876444734, 
             -13.262800001293202,   0.68758995074478146,   -2.3839884841230181, 
              -10.10631880101146,     5.5189079542329713, -0.32274187971319651, 
             -17.591887693095476,  -4.9220413671154652,  -11.791213802480963, 
               2.8324006586962005,    4.6704848990214511,  -5.2755896769781891, 
              -4.7888299658965341,   -30.250057760061594,   15.438058084423556, 
              14.344111607482636,   11.265006639352036, -0.25193862646369714, 
             -5.3831335376326592, -0.31988098489736705,  0.72701553278036679, 
             -1.2718475176887087,   -2.0044801717615353,  -3.6372136343491386, 
              -10.10746450042282,  -7.6010047610154308,    2.2771862323345076, 
             -2.8377186383621011,   -10.757726689191651,   0.46699878023381025, 
              2.2619434742277402,   2.3864610925701557,    -1.7282410914870434, 
              10.724089026705936,  -0.92003184556921891,    10.240271387135436, 
              0.41697913778758672,  -11.431340772421066,  -0.58996150682165394, 
              9.0904139672097024,  -0.64839996851259496,  -7.0984367483152848, 
                22.254864126732642, 0.052825136671355653, 
              -3.9001105784340977,   -13.23060434698823,  0.62503332109347942, 
             0.81840309441476977,  -6.2495666701937385,    11.39140345705805, 
               12.00420434829134,   5.4623270945827604,    5.6354799716782686, 
             -26.783628346770904,  -1.4613756704659966,  -16.323202349355711, 
               16.15672979738169,   5.9483343034503866,   8.3049231668820962, 
              11.218571232714547,    1.4715175207688225, 0.88647533622749952, 
             -14.925612679544006,  8.9337397456092482,   7.0318192722842321, 
             -4.9648836508043219,  -2.9690874120536064,    19.284516285100246, 
             -12.882512371918221,  -2.2992213914599939,   1.3870424742233409, 
               12.141082402796357,   3.2971947067600462,   5.3517950167139823, 
             -22.826070181183077,  -6.9280834718063087,   -3.1884365088149824, 
              -2.9732817059990251,  -4.3012075859430183,    8.8503390184940613, 
               22.161283562108469,    5.588248932012732,   -15.064128374026327, 
              -0.5696703637414986,   -7.0087546360108206,  -2.6535590517383789, 
              15.337237130045215,  -4.5995854261082751,  -6.8639917022418029, 
              3.1804096584352362,    5.217683648123951, -8.0281204057654048, 
             -11.572541216803309,    11.644240039846663,  0.33083779696136045, 
               14.174722626445632,  -3.0370559234863452],
       [-19.474898574346252,   3.4274092275518866,   6.2160891739366075, 
               7.030208294429487,   -2.7661863100910917,    9.7003246732374926, 
              18.103357554803033,    -16.751307237559555,   11.939811773923363, 
             -15.082065739282717,   11.616065536900296,  -5.8510391413682639, 
               3.8894151381234221,   -11.103512306747174,    1.337010153187421, 
             -0.88558048758658459,    11.326440811328535,   4.9320538717203162, 
             -1.8837954126352574,  -12.052082496122399,  -6.7178387485878819, 
             -7.2620805790771108,   16.961128525178886,  -11.660790865466852, 
              4.0657873565432565,    14.677186537064919,   8.3210160474760748, 
               -1.25439840413364,   11.047476692046169,    15.317148472454518, 
              16.410098087881277,    3.9621971269388294,    9.0849629771112177, 
             -15.689235251018857,   10.311594835909265,    -12.441761848895702, 
              0.1630962302661122,   -4.8650776530305366,    7.5837772771863001, 
              -12.589352353476444,   5.3823725041612196,   -12.153340574967395, 
             -5.1809701217972846,    38.410359557455379,    13.75050744622223, 
               0.15318371211544818,  -17.535859856927981, 
               -16.57857958465215,   15.669540532523527,  -3.0697055338717885, 
             -10.219813013578607,  -2.7802455587625898,   -14.55227866158925, 
              2.5785924650504572,  -5.9489279493329983,   0.92872593296076833, 
              4.6837411917602543,  -3.9270357311771336,   14.502649148770599, 
              12.172558807636982,  -31.683222322551416,  -3.4071812810443785, 
             -7.1327370411992996,   -12.120806114578048,  1.5420458560918628, 
              14.674180117659301, -4.6098610646697971,   15.348011209459143, 
             -3.0501419500452212,   -9.202128642203629, -0.011674766687374454, 
             -7.1256982457257507,   1.9591452535097122,  0.83779176938142752, 
              -11.713557176165082,  -0.4465858826015292,   5.8515822534399593, 
             -4.9306235884991505,   14.214883042583859,   -5.5928902563659131, 
               1.1755508050715031,  -5.0216131833696203,   -29.487256910776381, 
              -5.7269808780504423,   9.1211394688483551,   -6.8497777415542309, 
               2.8643998324692834,    3.9075632008917838,  -22.617177347373179, 
              1.3357191658584331,  -6.3999819002143612,   1.5709071166333188, 
              8.4724110306593126,  -12.379119088344089, -22.613714416222219, 
              3.1287354195001953,   -3.6991772087073671,   9.8114460571273661, 
              -4.7339550758381694,  -2.0757823881956838],
       [-16.624043891542645,  -7.7388141029201298,  -6.7284300442239173, 
              5.8916393036416768,    7.6900490293204085,   -7.1755827230517557, 
              7.1992536421044324,     6.6556514088485619,    17.36814394288831, 
            -0.26468859485781476,  -2.5058981324220042,   20.540813804143209, 
               1.6702855541087875,    6.1353092836836378,   1.8908371492725404, 
              -10.310726337462231,   -15.331474379468554, -0.53096079235837323, 
             -0.7456289755767318,  -5.2935572260506376,  -5.4316055210528287, 
             -17.663971203891041,   15.676887055832553,   1.3570172904363476, 
              8.4771462253412171,   -1.9207943706145101,   8.0904007186048723, 
              12.478796128310513,  -4.3298535667868743,    3.3727191751056242, 
             -9.8095094220611205,   -1.6137264177738844,   -5.6112343180580657, 
              9.9883047009805423,   3.8177908129113423,    -12.200388237005344, 
             -8.2440822586724778,   -6.7807757739645655,    18.972526447224869, 
              -4.1041608992451195,  -10.386459723164421,   -3.6140765088616971, 
             -6.4192232957186759,   -0.4849213300737753,  -11.151761868071171, 
                6.7492980492987344, -0.96908667592716202, 
              -14.310657082913597,    5.782895808511233,  0.27386540138754512, 
              6.6474349959071244,  -4.2582235164256232,   7.0651928413509637, 
              10.335814633554852,  -17.321254440771195,   -8.2296311593926088, 
             -11.206203607758841, -0.97443045991961186,   4.6387269733629743, 
               -1.52344992542029,  -7.8259068482123473,   6.5614188593147666, 
             -10.319165717362441,    6.2325244102630881,  4.9012570664083652, 
              -10.31935091652781, -1.0224507454091674,  -2.7520041236372421, 
             -13.944799109373005,   -9.250547538599923,    3.2232180957257421, 
            -0.54441321875623738,  -2.3379616441720139,  -10.940903734456368, 
               10.121302911866707,  -1.3753068883070283,   -5.488497509755403, 
              5.1692559502523725,   2.0550872546914354,    8.7958001699642683, 
            -0.075797066951576009,   11.662742097341841,   -29.235461564477188, 
               4.0288501688058513,  -8.3847011435896963,   -6.4184149235255292, 
              -23.883298628408319,   -1.9330613391780851,  -12.885035477089495, 
              3.5052544682622813,    12.04062059385304,  -9.2341767604636242, 
               2.385891004903403,  -8.0909521744417123,  1.2352481342471346, 
             -5.8313515483282039,    6.7362241285623981,   1.4466234947972296, 
             -0.53604839321459463,   1.0580848396699081],
       [-1.9278853670987119,  -5.2708886584994099,  -2.2612893606654603, 
            -0.75130976728261467,    8.3912724563840193,    8.4774965608996826, 
             0.56638229130715512,     15.942465099545295,   9.2887787743045163, 
             -1.3310918303214248,  -11.635077532723381,  -3.2299016811128078, 
                5.705269169181947,    9.0718080855111936,   10.300588944852009, 
               8.9722244826159141,   -3.6503255792993086,  -3.9128410977674948, 
              -4.506112806472375,  -4.0513736276552867,  -1.1520832195826936, 
              2.4663662957548156,  -6.7363620102228241,  -1.7856390999009499, 
             -1.3159411803252383,   -1.1400813692164646,   3.6752428704330837, 
             -17.170966457945823,  -2.5797819236899047,     10.37038640935744, 
             -11.272002525746798,   -3.4857220281314443,   -9.0511386763115187, 
             -3.3302868335818547,  0.10892805434592862,    -1.1634551570698579, 
              15.963756043761791,   -8.3850889289299317,    12.658457622536396, 
               15.301092061395053,   12.221038388072916,    11.572706606667984, 
              -2.046928268834399,   -15.798101260028785,  -3.9629628196171773, 
                15.910305276629341,   24.308162902133766, 
               12.219096251373703,  -5.3918672171870385,  -10.016659931656713, 
             -1.7253681830557048,  -2.9049484483111465,   5.5343319192154468, 
              7.1182670130831829,  -11.341044941746732,    2.5779985198805075, 
             0.91433367088942719,   -1.464730202135448,  -6.3115784160852204, 
             -5.3657434338552621,   2.8299378687963612,   7.5562989416401045, 
              -1.267740652535843,    6.1104329533061685, -11.021276920769065, 
              -1.400603158308048, -7.5909777228065733,   16.838973618353545, 
              3.2250173372765611,   9.0835226563494569,    -6.925868851027392, 
             0.60900637365332899, -0.35056913938339701,   14.133406458068379, 
              -2.7613951515265196,  -4.2140921938793472,  -7.5007424274068022, 
              10.919885916663002,   2.8890489843376836,   -5.1286662175613476, 
                18.24983162673368,  -5.5284922576577111,   -20.807417005130333, 
              -9.2109122287003604,  -3.2752089345921305,   -4.4447296165204895, 
              0.37308406743724498,   -9.1886501946263781,   7.8381167176032367, 
             -9.2371913480264514,   2.3191286781860465,   3.4383207027953011, 
              8.7822329214050505,   12.890436495720287,  1.5035678643832218, 
              1.6150280361050813,    12.053181316353005,  0.99127745054161431, 
              -21.849850400385805,    1.362881838180551],
       [-15.904923312266009,   2.0097672107260682,   4.9614446954542855, 
              7.4492237823981542,   -2.7270364249213981,    11.663180572368386, 
              -15.25250585421621,     10.371048729755877,    5.668879319495046, 
             -8.1799648090611115,    6.007985651763228,  -10.144189860787698, 
              -6.6619906944017053,    9.5341764360303625,  -5.0645487201455328, 
              -6.6074178859635637,    1.0144486370508428,  -1.2454096832726671, 
             -5.3898068107322725,    15.13542230198208,   18.519611659737368, 
             -6.4324098348422858,   9.8861873192333238,  -11.871796661447275, 
              14.893133806535952,    2.1564618254597638,  -8.6420561185756277, 
             -8.1716954937483912,   5.8202279301834263,    11.957669702153602, 
             -28.808554503064482,   -2.4710270088418391,    15.251291371328538, 
              5.7342189661210536,   2.9766597031641719, -0.0023853902434365138, 
              2.1166015585394944,    8.4218022469645213,   -4.4728727037629792, 
               17.211662405645502,   4.5551889765307463,    5.9709010012236972, 
            -0.35204100537640204,    6.9940016632681576,   5.9812739026216466, 
                6.7600287047781871,  -7.7391678997349231, 
               6.7899845003702417,   3.2738611288601001,   20.665865409978487, 
              5.6325863591688563,  -4.4679693387638473,   3.7681041399407293, 
             -3.0882274912528946,   -13.94415662204535,   -22.154007567681866, 
              8.4375166066052714,  0.81711553729123043,   11.159829516327511, 
              -9.012546424509182,  -13.724618474979151,   1.3352171680549616, 
              12.812453082552604,    2.6496631103826069, -6.7479700458159364, 
              16.913636949959066, -3.3252967866617182,   2.1937580348224981, 
              3.8088264827093044,  -10.273250411850389,   -13.295290693667443, 
             -14.342475152280416,  -4.3168599560057679,   3.5685548101619742, 
              0.91661380992270491,  -12.736862768175541,  -4.5212724631229353, 
              5.7766643400519433, -0.10170482061629396,    11.738185340585588, 
              -2.2486940891450704,  -5.7414707823611195,    3.4086767096439869, 
              -13.400976410246061,   2.2626915172093622,   -13.868291691077903, 
               0.2973788995124062,    1.8553658835353195,  -15.658707211435864, 
             -6.8639258889797468,   10.162160997743012,  -8.4821600426599648, 
             -10.924972541801896,  -8.2175404139580781,  8.5126384884298023, 
              10.902788684756597,    -2.643236227507046,  -15.601913102922069, 
              -12.509287298902308,  -16.780301850401493],
       [-5.4368467883009419,  -4.8875028939095131,   9.5209331554963708, 
              9.2683563225127479,    8.0046627960537471,  -0.17828175490818612, 
              14.310523494852943,     10.438484368849949,  -18.900748787638832, 
             -8.5488385724377594, -0.28447335311166722,   18.308296611901188, 
               19.614603364541697,   -5.1254883934838738,    6.912067491825252, 
               -15.42748440100379,    8.0763014623081002,   14.642555435707576, 
              8.5852011223157181,  -7.5355208002024767,  -1.5839701972447064, 
              2.5880646304971937,   9.9590734432747734,   15.748271176486293, 
             -4.6382782352787979,    5.3184046959724318,   2.5452944386867582, 
              8.4756241633476286,  -10.330059671903486,   -15.808476718478389, 
             -1.8481395064685229,    9.3624268045457075,   -3.4503052125576121, 
             -2.9727834383903979,   -9.870711325041956,     14.319029785766462, 
             -6.9876167131686193,   -24.271844803261885,    4.7249222279916667, 
              -4.2094090902766803,   9.9764556123119803,    4.7313143637913457, 
              11.796831054315193,    16.277393219692872,   7.5781357619120708, 
                10.827879348935269,  -6.6509512944035523, 
              -7.4636950934868018,   9.3601422551803921,  -1.7187894351059694, 
              11.925912466826725,  -11.679177039833766,   13.720706985997992, 
              18.651367546201435,  -2.3315383359356376,   -18.608566972736746, 
             0.41374924175944772,   3.1627117079318054,   5.8953634673177282, 
             -1.8150054387597088,  -19.251422718411003,  0.86636958881212134, 
             -10.108810140795812,    12.591437854412655,  7.6684372071396298, 
             -2.3938983759922055,  2.4384977789109397,  -2.7604701142910528, 
             -5.8852204955598921,   1.5972800873830044,   -7.1330875534493368, 
             -10.776465410064501,    7.657894872499039,  -4.0972798511920914, 
              -4.1913733765547798,   12.989759406521097,  -17.259962264202727, 
             -9.5661331155809144,   4.1716415603313948,   -6.2799616103271658, 
              -4.5131031527663605,    3.067382081754455,  -0.33406633547661302, 
              -6.7246516102639697,   -5.307121151150838,    7.4557893836994165, 
               6.7039803983041937,   -10.291836903862508,  -7.9932023872133726, 
              15.169696164245853,  -4.5998481301681444,  -6.0354706426509033, 
              9.0132551015512625,   18.050570978888722,  15.229636719990323, 
              6.0698148832957086,   -11.870481723265055,  -8.7749193570881872, 
              -4.2425174860296853,  -4.7534839699237992],
       [-11.352626205987018,  -3.5281740257737209,  -9.1413134986528828, 
             -6.7264387610339957,   -2.8378735666180104,   -13.685928301496439, 
                6.10199886942336,     15.174450535903816,   9.3725312427435252, 
             -4.6322244814872446,  -9.3191962756092561,  -7.4599913442771646, 
               -20.00638658868035,   -19.542695703582432,  -3.0538984461747209, 
              -3.0619710386895265,  -0.72507774903202982,  -2.5705840303999814, 
             -15.617932704490249,   6.6375261333092048,   2.9522756204991496, 
              7.9612220512851799,   14.100621034080325,  -9.0576436893526555, 
              7.2691025183220717,    3.5036881417898869,   -4.437019232628848, 
              7.0363147881338959,  -12.905940272776084,   -15.616181777722872, 
             -6.7272919977901164,   -3.8824029266757423,   -5.9429649301666121, 
              4.4028596637524755,  -7.2149997442139266,    -3.9044753863846688, 
             -4.6445672313052979,   -1.1621747966121796,   -20.186155990663259, 
               3.3370161713016184,  -8.7933595103781155,   -37.498607984047624, 
              1.7911713659257136,    4.3516595761801993,   9.8720747176252797, 
                5.7628969973539306,  -2.7455821851333608, 
             -0.54179063978432374,  -4.5798186311754785,    15.78984728677602, 
            -0.99699780716388364,  0.98844782778974849,  0.81103947133412169, 
               7.692021529479395,  -5.3402204643209075,   -11.310522743364189, 
            -0.98095434112158941,   2.9498926258480793,   9.1571507052952192, 
             -15.799591779980389,  -3.3153850188499314,  -10.458658926726843, 
              -6.493941626008656,   -12.022033332048824, -3.8714830062204437, 
            -0.36279816212473665,  15.706945888627146, -0.72118093688853402, 
             -9.7713839348958196,  -5.4357116184634977,   -32.823728081100036, 
              6.5219307780890858, -0.13354393045851454,   15.495806761381115, 
              -9.8554218780443019, -0.20991692115063199,   11.193288305691979, 
              9.8549829011305832,  -2.4474958628434744,    9.7399887633838187, 
               5.1652840695221887,   9.5021001007306953,   -8.7436446539177801, 
               29.463659549968092,  -11.644730360678132,   -7.2081062479052527, 
              -17.756938420042648,   -2.5887517386453833,   12.218098428224843, 
             -7.1355958922074336,    -16.7198336849439,  -3.3518916260144405, 
             -13.959919942473935,   4.6787926846693626,  2.5820718768578454, 
             -5.8436226688911965,   -10.257907626540712,    24.95788282450269, 
              -7.8450678410877046,  0.52433958490319588],
       [ 19.896122635036178,  -2.5656759369809086,   7.4948514026637367, 
             -21.475882731244077,    15.976716810286195,    -9.536529765992011, 
             -5.9297704836346536,    -8.0750752744835719,    10.69087411243439, 
              2.4961782593188273,    -2.98109834283777,   19.656911238894551, 
              -9.8133507682563259,    4.0979032042659966,   25.541787636536881, 
               18.524465443506774,    1.6701309294938163,  -4.1247297958707865, 
              13.698554596940555,   19.005230724191815,  -16.089089545316678, 
               10.43462242161193,   -11.91065103030869,   8.7747833455224065, 
             -4.0647997756939089,     3.967903603576024,  -6.4088510214956163, 
              15.316782445461977,  -4.5748353794205627,    9.8416298440669525, 
                12.5961275986238,   -1.6099756551098485,    1.6037603808736094, 
              3.9711735323707344,  -1.1118619229266389,    -10.831027823776711, 
              18.196675386626218,    1.8550620921128804,   -14.650802486516811, 
               14.253212897690055,  -4.2208687807298002,   -12.246083234143475, 
             -17.221207145949762,    -8.260360954305753,  -1.0960817541771934, 
              -0.27736491254895101,  0.60410982063037288, 
              -18.996884822581851,  -11.553746505220857,   8.0027570460683357, 
              2.9884423054530136,    12.06062110885243,   13.126356374443112, 
               -2.62029536805011,   8.5545285377543561,    4.3160472769401705, 
              15.461300695141215,  -1.1635340141669124,   4.8588544058180467, 
             -4.2506430776656465,   3.6550384255674402,  -6.5712502513481228, 
              29.118488405331245,   -2.1954425406946925, -3.1014426467233203, 
              2.0724893723018574,   1.490150396260528,   -19.29069678817509, 
             -17.671749720404893,  -14.054318687265951,    13.282169808096938, 
              3.1457517018785368,  -3.9147530638081394,  -3.2170600187289371, 
               11.654955026595633,   1.2737878735255452,  -26.227661636505747, 
             0.41359039875808973,   15.221922227517714,   -10.110886589488837, 
               6.8716464623612108,   9.8776088479497979,   -3.0251075393502762, 
               3.9020267694128856,  -7.3637416385027175,    22.430089672729324, 
              -2.9563706909663749,    20.379813107600967,  -11.575105025518768, 
             -7.5537002512775873,  -13.317661332742363,  -3.3618131104226876, 
             -5.1653890057266407,   18.089521900331874, -6.3086457063049926, 
              13.299221150885165,   0.89986413508227048,  -15.874690018442211, 
               2.5833377479686312,   4.1837537432271183],
       [ 19.923660412287312,  -11.127018356842724,  -11.811263902800002, 
             -2.1356459645980967,    2.5144522876433175,    2.4384843627753936, 
             -2.0494964153783122,    -2.3565710621003619,   -3.290169668014709, 
             -4.5305619391401262,   7.3044538824152818,   5.9706414910191992, 
                13.43913151474079,   -10.801030143108655,   16.202471340568781, 
               7.0434656950360299,    2.9341164151267929,  -4.5221054747793152, 
             -3.1709913935234839,  -3.1210840559700088,  -8.5076001795784268, 
             -1.2440684777383564,  -1.5003735500205286,   29.262870275707371, 
              22.071333774761726,      8.67351922455763,  -7.9822461315516859, 
              7.7463455795224023,  -5.5228019915394411,   -9.8211486981206004, 
             -5.2975726417838391,    -3.397649904947706,   -6.2953733466299369, 
             -1.3542576474039083,    -10.2908524039253,    -24.046920111121718, 
              5.4457145244129848,    2.3953309745883353,    4.1523304113081023, 
               6.6948995236468267,   2.6863092527523658,   -7.8813880028856742, 
             -1.1906301610273702,   -1.1284503356142559,   10.271589554451232, 
                13.476466466091644,   6.1873942449056436, 
              -4.1001903849794443,   1.9334481753821811,   8.3097308131410266, 
             -7.7259762693193546,  -10.807739088354307,  -8.7297237917554824, 
             -11.252939573205227,  -17.435179868146161,   -8.8733052900705545, 
               7.642531045531423,   10.805965470995684,    -2.85635821230604, 
             -2.2008240705044573,   9.6332144221911413,  -8.4725946712165356, 
              17.663410782523957,   -5.9145512002691198, -14.882461750137008, 
             -11.928050573205532,  -1.947959917983757,  0.57606607297301005, 
              2.6977633850294973,  -29.265782902463112,    17.063408115285917, 
              23.887386841930187,  -15.924957718122529,  -3.7037402246856042, 
              -2.7429806397208463,   5.8295505020843432,  -7.9559356033826116, 
             -2.9168142909849841,    20.01090129359017,    14.577495917614311, 
               5.7786660501313705, -0.01419939120896746,   -36.313941348796924, 
              -9.8323179445406339,  -2.8795044222886883,    2.6647780260852096, 
               2.7406814987232924,    1.5115955087226318,  0.14759675001660993, 
              8.5538549005135049,   6.1319287632793404,   5.0052285914253192, 
              10.414738444438655,  -2.6056612721207055, -1.5981594888519026, 
             -4.5326945469427944,   -14.314265796463612,  -7.5070123397144259, 
               22.404605199068762,   3.8275278036516545],
       [ 11.728006297785985,   22.570260330109715,  -2.3288329242470343, 
             -2.5764539592831159,     5.682172509339841,   -5.2295615077651583, 
            -0.60429530063262371,    -9.4476727987161269,  -6.2066311057405263, 
             -14.409276982524551,  -8.4128122625532882,   2.0976067372520055, 
               2.4563429759398452,    14.692029890866694,  -4.8041316609762763, 
              -11.189342058492251,   -2.9372366267889127,    6.009288061146167, 
             -1.4718215504328542,  -3.1794180392742453,   5.1015818049720778, 
             -5.0229531968676344,  -6.2468812405439405,  -4.1296029312753681, 
              5.6130604253219696,   -4.0777784043390675,   11.960510242206791, 
              15.348377810710634,   -10.29073184856925,   0.37573292384756984, 
              4.3744486209851612,   -4.4500598359530557,   -12.370299614696574, 
             -3.3081923130042448,  -9.7048986110471152,    -1.6246554440029335, 
             -8.9980709378137735,   -7.1088590395980376,    9.7611240185357122, 
              -11.103855293965939, -0.16483468198761089,    10.429146400203964, 
                -2.0359514479862,   -10.955105127054829,  -2.4270110166585299, 
                5.2372213300899535,  -3.0192586266244579, 
              -1.1627383674425211,   3.0097708941207149,  -1.3426166452844019, 
              7.1379194751872053,  -5.4385372255403466,  -1.2118648161746612, 
             -3.3112083461375255,   9.7662891179502314,     10.67918652382734, 
              10.233245745723732,  -15.082329623596644,  -2.4039347813827434, 
             -2.4321754475640098,   4.3936156425302793,   2.5609776879424762, 
              12.212258949767387,   -6.9775060472875827, -16.982033867058014, 
              23.000049159987768, -3.3960294989854605,  0.35268836486615301, 
             -3.5538837606440583,   12.727465694128103,   -3.3591730397411834, 
              10.849951179129027,  -10.501954488272355,   1.3486731189108609, 
               11.453315456955638,   4.9677815496371656,  -3.1192578988035469, 
             -2.1361184831544708,   10.487453137160397,    -5.729642725667583, 
               -4.485173307738898,   1.2392501482825322,     15.05786258306593, 
               3.0287794022912813,  -1.1656331981120385,   -3.6209416358608815, 
              -1.0382192711064488,    3.1900282706011658,   7.5314050381712603, 
              2.4397105306371549,  -6.0310191907347441,  -16.596092206593212, 
             -7.8392972291206595,   15.592349490645731, -12.344041710421818, 
              14.148677999027289,    5.8941734221480866,   6.6125289153631748, 
              -18.964891539834635,   9.6461337181397724],
       [ 9.4021594834676154,   14.682549498615224,  -9.6521941504231794, 
               -5.65471994583997,   -6.2984758632825315,    15.139793875735879, 
             -1.5611253106590004,     8.5669935350936957,  -20.424691079728674, 
              7.5626973560120403,  -2.9901883877177382,   21.516855600521009, 
              -4.6667736514159079,    13.236991579182947,   6.9299834693087767, 
              -15.718459463855323,    11.392458030100379,   6.7861588166475064, 
              11.631483909810232,   11.292151045054403,  -10.469316218480296, 
            -0.37996710649572246,  -3.1308259431136913,   5.8882734686280811, 
               2.575393884018677,    -3.087042224136189,   2.3867870143884291, 
             -16.690424031756013,   -1.403201097372119,    3.9944875683877608, 
              -8.251689264710544,   -14.414731123321351,    6.7156715263102313, 
              7.3545026731149541,   -12.19715376232741,    -6.3333204360810491, 
             -5.5145062259724362,  0.095074176408066619,    3.4764855416874116, 
            -0.042244569651711972,  -9.6165382833010131,    -7.122777623584545, 
             -6.8753761790733892,   -3.6678093445301578,   15.106953526835124, 
                1.3996658970339828,   15.451738904683513, 
               8.7450991945674215,  -5.1176792004668208,   9.1157954766415124, 
             -19.902728969827816,   1.0787198447018758,   1.0828746069912913, 
              24.441110747634063,   1.5062221624114869,   -39.133560785774449, 
              7.2419681290971365,   16.154664697357166,     12.4030846124876, 
              16.231403542324795,   10.650565434012611,   1.1564335269720802, 
             -5.0408574584084223,    6.7462813312132921, -9.2959741757920291, 
              13.478389751318323,  14.202845509324447, -0.75848732656438367, 
             -16.083882425355071,  -3.2136131012223643,   -10.154705740195118, 
             -12.676708581117841,   5.9153115485900818,   1.0249468817522367, 
               8.2348987005020007,  0.11094420869842843,   9.9027686205496881, 
              16.589818446086642,   5.8668364055403552,    2.7944553241846544, 
               3.1094612751916073,   5.1737514039120942,    1.1962378404095033, 
              -4.7919041859285363,   11.948053808878223,   -12.381007133367026, 
              -15.630586981342059,   -3.1022375820238075,  -3.7625634481610959, 
             -16.242971989114739, -0.58056455658923667,  -5.6625417033658891, 
              2.3867657571542633,  -10.995675112872005,  16.783133990805656, 
               7.642392724364103,   -12.296216560118109,   10.400087231081915, 
              -13.047478339164474,   14.474286961944216],
       [ 4.5316889390660879,   14.660227385420884,   7.1021652865214646, 
             -1.1251155034170066,    -19.93877036168513,   -17.092757371261612, 
             -1.7944323556009276,     4.0991856597259959,  -0.6030341732338641, 
              6.3645375944552098,  -11.859336077405874,  -11.645911586172847, 
              -1.4705558507934569,    9.9313199386144415,   12.343846188490499, 
                5.956361892559805,   -14.629137941048391,    7.646971320872562, 
               9.348203944493406,   7.0137853649901647,   23.263658078599146, 
              1.9491451502133845,  -10.150706975263063, -0.93096120831108398, 
              1.3160048425604582,    22.818938582125373,   1.6282413995769562, 
             -15.318402130928764,  0.44799357763989489,   -7.8203536101339308, 
             -11.906704338781582,   -8.7375670934361693,   -2.9874963829595522, 
              1.4350743983112937,   9.7941213315667994,    -2.7639330167065386, 
               10.04603185401497,    13.798194459429244,     -7.04038410986999, 
               21.631435382171421,  -15.792654009387917,    1.7080719547200092, 
              13.833885155119621,    19.922358914911097,   6.2401327453627955, 
               -10.266630607889677,  -1.7612272296146534, 
                12.40547871117808,    3.714070047988991,  0.27376079126751335, 
             -9.1672809075870738,   6.2929201007802495,   7.8896312792207279, 
             -6.4919349351463742,   4.1933507383985456,    14.932177855247847, 
             -16.792308032253107,  -2.7111033744091872,  0.77966413216035158, 
             -1.9957225502242246,  -17.762097723314604,  -13.559774098512223, 
              2.0152622995814133,   -10.123487905555951, -6.3930213649124923, 
             -4.6375023939553177, 0.91685485664219235, 0.042109376205184554, 
             -5.2326884302267977,  -5.5380186027940592,  -0.96487980637351511, 
              1.4105445470011049,  -3.7775331851246148,  -20.386873665775681, 
              -6.3436795471144416, -0.30844623281128714,  -4.4537104348248207, 
              5.6640087108030315,   17.271053744209443,    16.057163948496374, 
              -14.576324412872019,  -10.418391128894227,   -3.1319211746209885, 
              -2.6185238365386052,  -2.8837144246364277,    14.270316913126059, 
              -3.0800208588241276,   -4.7014147317500656,  -1.0635511418416439, 
              1.8037677586525735,   2.5210717195197292, -0.69952399802912257, 
             -5.9356746507809781,  -28.036038219382455,   8.914065887521426, 
             -8.1830314806388884,    7.9525122308723208,   3.8596741723575176, 
              -4.2907323130214801,   5.9200966356388838],
       [ 5.4250690569329834, -0.47908481323536967,   5.1126598788123783, 
             -12.081207061949822,     -1.47877434254911,   0.21487820405405808, 
              13.302410417070284,     15.589738981661759,  -1.0140941487407875, 
             -1.5803425331841896,   -15.37439315196109,  -5.9408051846030272, 
              -7.0868113664942376,   0.25894271831106491,    18.68872001985525, 
               15.585307181162607,  -0.69644090769828038,  -2.4327170590547151, 
             -1.2733258079060623,   13.949514092995688,  -21.504587522066323, 
            -0.27491187115347859,  0.87190995238685676,  -5.7241515762310069, 
             -3.6352705125219935,   -13.439502614444836,  -5.2975683767241053, 
             -14.113472055036283,  -14.608554082150299,   -8.3594460020799115, 
             -3.6742149997737554,   0.33774341474390734,    4.9543307429760794, 
              2.8300414358324288,  -1.0750763416696207,     10.060848376224635, 
              10.671811438129058,    11.572463928503169,    13.816861533767916, 
               16.976682548661234,  -15.132892011795526,   -14.211695651861538, 
             -10.642038148347773,    6.6088202461807768,   1.7558748737013197, 
               -5.0268555642225863,   2.8501839447596011, 
               -7.903701482272897, -0.12313582259505584,   7.2031414886501386, 
             -9.9155432155512067,   3.8512017797472882,  -20.180013844191013, 
              12.273924575263024,  -8.8232436021100522,    9.7154391643144695, 
              10.402167437505687,   10.895944043421164,  -1.0736563795805265, 
              11.807932404829092,  -3.0782520357915018,   2.0097854420950716, 
              3.4433270814779831, -0.046864286969870009, -13.236672876666063, 
              12.086067018191882,  5.9052700133747917,  -5.7343376082527229, 
              2.0339728668043651,  -1.2833883324282194,    19.707984518880824, 
              13.683948633471106,   7.7132066886792918,   7.4546723113120539, 
               3.6875240116670134,   3.0682398921062677,  -1.5787612353134421, 
              6.8732458695327061,   4.9283018577278579,    13.433234658560753, 
               4.8159916069450155,  -3.7020081107903371,    12.363769487108264, 
               8.1005057803316145,   5.6797803718484037,    3.0820249347866149, 
              -20.708765050009418,   -11.700309877596535,   23.793660905517484, 
              4.7389518418121979,  0.55349806757367537,  -1.4599078013888138, 
             -21.754742856431896,  -7.9566917048873984,  13.584369516761765, 
             -2.3730010475580423,   0.20679328458954063,  -15.526114767487529, 
                13.39396506810928,  -8.9105667772819253],
       [ -6.629588533541126,   1.0304839367847278,   2.5121036732322377, 
             -4.0359669341655655,    9.6275738842908165,    8.4946957742622757, 
             -10.999684782616983,    -6.7643353217648965,  -15.071864970035884, 
             -3.8895798628929406,  -6.6236286241227624,  -13.145519293964824, 
               0.7545775361133783,   -3.0406650930427119,   7.2309906509159845, 
              -10.553822314445537,   -1.9423927481673353,   5.5512372152643366, 
              3.3700454047184962,  -10.281115557929482,   7.0492055209911744, 
             -16.225464116931963,    11.26502431181083,  -13.390327526949921, 
             -9.7753241348624833,    15.569773994039469,  -14.665684164301471, 
              -1.239522277753728,   5.2075244667401241,   -27.758440238719778, 
              25.561916443097342,   -4.0530291156252334, -0.021559216356665079, 
             -6.1754514364955693,   12.852694166022525,      2.712343156662071, 
              2.6606299500754842,    -20.04993912675765,   -15.478724303122533, 
                10.76742499626047,   13.832730491100904,    4.8307961160347936, 
             -3.6663181935159015,    5.5004370690202888,  0.89977632693984089, 
               -11.196220024627035,   -2.524976201503295, 
              -8.0032968768184549, -0.37342782776377759,   8.6031254722932964, 
             -10.030145239206314,  -17.594900138564036,  -1.1605752996049772, 
            -0.57986911459598522,   1.5712440799596294,    5.0138952381392565, 
               -14.3663966417982,   5.5966576519852174,   7.1263153145626932, 
              8.6859753260395021,   9.9747177000069254,   3.8982733123977589, 
              10.386673637749313,   -7.6237723423895174, -7.1026876172191269, 
             -5.0972239128355445, -14.082377524027619,   5.9326924224305921, 
              8.3291181641083192,   19.043640951971291,   -5.8552964147210664, 
            -0.68955984162000161, -0.74804677351468518,  0.14767033943772412, 
               7.7951095665169756,  -4.4735332266964702,   -16.14259012706345, 
             -3.9129663387578733,    1.101382053629764,    4.4473513945560059, 
              -8.1551316907867228,   -5.651577441302102,   -15.115636942242293, 
              -7.2988014362803231, -0.17286911680147873,    4.2367882328142485, 
                28.16905667602494,   -10.721164833749764,   2.1546646902582016, 
             -16.151669143207847,  -9.2701606017657028,   -3.375266407940241, 
             -2.1518212183401313,  -1.1141193882012423,  6.3788125967183653, 
              3.3339520559530551,   -1.9900047548164022, -0.52279216105435389, 
              -19.118774944159021,  -8.9772983830393631],
       [ -5.884544837262129,   17.714493025281666,   9.9465772528273693, 
             -6.5152768174734472,    10.482749105361275,   -14.087151958812941, 
              -4.525608117962415,     -12.68859640869956,   1.7409362635986794, 
              3.8607096881406293,   -10.97084914377843,  -5.8393600092392752, 
               8.8450924974556955,    1.1062863116838044,   1.1934780328192562, 
              -7.2982043320577965,   -5.8447101190563808,   1.4878889357512084, 
              8.9360779357159803,  -15.375027603422842,  -2.4044039217887891, 
              5.8300154003710372,  -4.7985326327550091,  -3.8714061906795809, 
              22.961248671006924,    12.133444849686706,   7.9121506730482105, 
              11.055322431077293,   10.620192929285693,   -5.6652331636527329, 
              12.500326031514833,    7.8595717671040006,    15.352264416299379, 
             -10.349473230832675,  -7.1424776360033775,     8.1084462399571358, 
             -6.4722556458885228,   -9.7174039935189889,    6.9386332327297886, 
               -10.90689676627315,  -3.1383744461196805,   -17.565302975520975, 
             -2.8866842543939395,   -3.9234794377671145,  -8.2783882564034847, 
            -0.0021300164674732352,   12.298015512605724, 
               -1.676753733343078,  -10.475211380848297,   4.7338383662774017, 
              2.2655378704005646,   8.5505721616417958,  -4.0975465883211513, 
              10.822129411296778,   9.3313369796143828,   -6.6971436763927574, 
             -6.4612642808443557,    17.23540115857633,   16.894455609829912, 
              16.975385131655919,   8.7857627133925131,   -3.321721768776158, 
              6.7585805295575927,   -1.4748442536381456,  -12.03541305654981, 
             -2.6525637191761806, -2.2921494307766337,   22.399296389891266, 
              16.750087340056609,   7.2716358743378962,    5.1409076327562282, 
               20.04142318508061,  -13.609914772505963,   12.661825232606979, 
              -2.2923079013005614,     21.4216402792289,  -24.890978701422235, 
              6.3016707123271463,  -2.2222895321132552,    9.7639900521875429, 
               6.3550404437667849,  -7.7817292230838584,    7.9888373211074351, 
               6.7833235175222182,  -12.312580370427963,    15.511063090489539, 
               8.3273418297327133,      13.1403472294853,   -7.504589975140564, 
              3.5874235620068058,    2.222222285468304,   12.579173207326619, 
             -8.8846236859194665,   1.9026206016976146,  15.108298601797125, 
              11.745514716948582,  -0.83330857030830874,  -7.3171330231213609, 
              -8.6870212760635432,   3.2990057911674753],
       [ 2.1312281273250115, -0.13937644283983924, -0.93247082715996998, 
             -7.1638470561166141,    14.793726141599379,   -24.309142224004241, 
              13.988232645705178,     21.326347106795836,  -10.883149332808769, 
             -8.6733169949979292,   8.0230547792474418,  -2.9777414397656976, 
              -6.0826188142840456,    4.2198655156664975,  -8.4634116516742033, 
              -8.0223756245823257,     -4.25415084578428,   7.4175647087782313, 
               2.119475494117478,   6.5347407651134404,   6.6174912836830968, 
             -3.9167886010774238,   8.3032054885415167,   2.2770873440150337, 
              3.9012686553108078,    2.3220472737040203,   15.734163300509698, 
              0.8484233068117939,  -25.864492366809401,   -9.9870457770313532, 
              2.8668870110572464,   -4.0767250222890166,   -1.5502813446568506, 
             -14.387502676498215,  -11.064582000730219,     -9.700557857199092, 
             -4.0587876306113326,   -11.250451462747522,   -10.398845560630026, 
              -17.569595700335917,  -1.1233264417855948,   -3.5104958227489997, 
              7.5023645931326666,   -6.3348656863463209,   14.956336722732308, 
                1.8481932224749562,   11.285281711768038, 
               13.603655595517353,   4.7713666382043174,   4.5131933125615129, 
              13.996878433630147,   7.0136645339660859,   15.602177636846051, 
              3.2059474542392552,  -12.110069783659155,   -14.700655830230897, 
              12.557134165141413,  -21.826353415727375,  -3.6073701032591563, 
             -10.913289200184622,  -5.8491991295576593,   9.1468498909199525, 
             -15.903978773785356,   -3.4892167992938274,  7.2433214086860209, 
              1.5714086468975006,  13.855369904727777,  -11.935089074371731, 
               3.343263427948298,   7.7642093544890045,    3.5482292272788833, 
             -15.124095153797787,  -4.7424410785789579,  -2.5408892564642276, 
               13.010971949069292,   18.365590103077306,    3.847364290046106, 
             0.96895406831384157,   10.976945337802356,    9.8788734081197269, 
              -2.1729502597202695,   12.984846178363687,    2.3522708018794778, 
              -3.1550708393112634,  -3.8356800678676124,    5.1779876059017482, 
               14.539924420470161,   -4.7440074709004438, -0.50080668328151623, 
             -12.266131015632702,  -12.067518802491275,  -1.3872520365131851, 
             -14.099220517686701,  -14.289588102583766,  10.665178602169824, 
              -12.98007475874677,     15.88194629514213,   4.1929171753267109, 
              -2.7012767619779217,    6.165438095972597],
       [ 10.177246686340533,   3.9525226122458692,  -7.5111326825760303, 
              19.742846793982849,     0.359205609853882,    5.6207695650575618, 
             -2.6513722158505839,     7.6890651513034918,   25.194657594061486, 
              4.3099108814954699,  -1.8214178735896329,  -3.5559788901608624, 
              -2.7538869456490565,   -15.893431667816929,  -20.062123431642341, 
               25.842458247439112,   -8.0286995054019439,  -5.5767227461325284, 
             -8.4252825013245705,  -12.028455711296679,   11.779919724016651, 
             -17.421740261555392,  -9.0029882180803185, -0.18994034392498485, 
             -12.598892269393236,   -10.893239160881043,   9.2553377520394289, 
             -1.8664468520863384,  -11.982843302221749,    11.165499068723058, 
              16.118391174427281,  -0.87806239382030715,    -10.74768329805857, 
             0.46306304247070657,  -7.2917624463345163,    -1.2520207249499817, 
              7.9303992508200141,   -20.352376042591075,    12.096666513541908, 
               4.0604878074102997,   1.0207562687829812,    16.102626304160136, 
              5.8387984894662406,    18.901452629007107,  -4.1704197110143122, 
                1.1243134440047142,  -11.074658131512344, 
               7.3379357802105547, -0.97344703877907712,    4.174739755347554, 
             -4.0692835600920851,   7.5950586769177244,  -5.3586853005620592, 
              20.073062817810499,   18.366715115544888,   -2.7177520383943921, 
               13.96132079036253,   3.6508560706708186,    8.140150040938396, 
             -3.8765329308887475,   12.871352509397266,   5.4056990082232979, 
             -20.026853462571928,   -15.602481459606617,  17.311677618998548, 
              16.994110909110709, 0.75005555792252054,   4.6825682999814404, 
              3.6369469834144637,  -8.4822547589477928,    12.050625732613893, 
               21.06186439064496,   17.052134509680286, -0.64464609478877877, 
              -4.1218510501075016,  -18.481138035848325,  -5.7751416222921872, 
             -5.3389865867532738,  -11.151083988328562,    1.5288674356974099, 
              0.22130380850270082,  -10.968790253654028,    5.1419140012872742, 
              -3.5465325509712375,  -1.1488323389059747,     12.60384586591451, 
               6.1446554226529448,    8.2668578513154429,  0.68830528500865329, 
              13.636810765867242,  -13.200864745950708,   10.800544377761307, 
              20.116522198880446,  0.45519377890849999, -10.021867543973308, 
              2.7045551973096056,    6.9105682930449639,  -21.509599238534808, 
               5.8040610935339689,   9.0338734742924007],
       [ 4.8467662672482774,  -3.4456479073949744,   3.4934368222478511, 
              9.7346848704329467,   -8.2203034269713342,   -1.6194394899272244, 
             -13.564149430698084,     7.3591886251810941,   -7.587066476436144, 
              11.261275246168758,   9.3626425364457901,  -1.6777556456263512, 
               4.3314427025421001,    13.931607434077804, -0.39894143428214984, 
              -7.9093930368808856,   -11.720319018442746,   -4.049354052755767, 
             -1.3176699549618018,  -11.147492036619013,   4.8831230943218058, 
             -13.277308928978041,  -8.2038892969246806,   7.2538606527338487, 
             -7.0734527223262855,     -13.6765709719828,   1.0900149354849891, 
               16.25373661656392, -0.83569301771395221,   -2.7932348559878535, 
              10.664419096477427,     10.36251639296572,      7.58518707755485, 
             -5.8672413690548675,   12.279007184957644,    -5.5535769019662942, 
              7.6660215078893668,    -4.511677982020144,   -9.0046733235710672, 
              -7.6454083448395513,   -8.729281564191103,    13.326458828064391, 
              5.5287373573030631,    30.204866657607216,  -15.998245371697591, 
                23.503964522439098,   2.6012754087723788, 
              -6.2286126513290725,   7.3186666581114697,   2.8852040519703612, 
              14.656952747277799,  -3.0381798150505057,  -5.9022018231125646, 
              11.101536667158813,   2.7752580213095319,  -0.83733919892072517, 
             -17.156144103591931,  -1.1289543795851644,    8.290698230758407, 
              15.197833997812557,  -29.885436307885648,  -8.9250238468925946, 
              1.6622083530139249,     11.91087482490898, -3.8774106553797818, 
             0.88128700565011497, -9.0686828428408912,   12.217967734107686, 
               9.572805443981915,  0.61624235047082077,    11.289942045383849, 
              22.922916477124119,  -14.668426246148336, -0.43282679953269831, 
             -0.35231482140446962,  -6.3078083739358535,   7.8312870448542116, 
              4.3945495733219442,  -13.380717454004063,   -2.0617915492516925, 
               1.9969402627173003,  0.10885447067121271,   -6.2865136184500603, 
               10.603305577271822,  0.82476397222742859,    4.7383651754599745, 
               20.132823659865871,    1.1378045125832621,   -3.883587629330711, 
               5.986641924036177,   13.390078099877179,   6.7232474814224874, 
              9.9390625796117824,   4.5306573915085995, -8.5558281303626273, 
             -7.7047688463574353,   -2.0896573751749243,  -12.792965392759879, 
             -0.95497661951018953,  -6.6761055994604774],
       [ 14.419322385983126,  -6.1267065307333501, -0.76914315901594388, 
              19.194916144462454,    3.7707405444788473,  -0.61340733723226604, 
              18.885693810842572,     5.8865688067200921,  -15.534559170952409, 
              8.3264593468742181,  -8.9611164928713833,    6.043061421768936, 
              -2.0814026485498909,    2.9704249559147033,   12.646534290474523, 
               1.3465806937509364,   -1.9085067260807254,  -12.460465814863888, 
             0.81853074331099129,   6.3560787411818005,   6.3048915675768473, 
             -2.7385448112087918, -0.58583364319069919,  -9.4795160880400058, 
              3.3730602632733402,   -4.0234418549447266,   0.5403702681827327, 
              10.382985209377036,  -20.993168429450463,    9.9696793635613759, 
              2.7707332242623828,   -5.9193708044818809,   -5.2801351236299272, 
              27.459394360168467,  -2.5113643294488766,     13.368811445713224, 
             -5.5344448178370556,    13.276728528271931,    22.053907887823215, 
               8.1159102878021621,  -11.850729679872071,   -9.1812074347162458, 
              9.8476303918966313,   -7.6674661776539121,   -2.952973412686426, 
               -10.355466650662796, -0.23319769268294843, 
               4.3210650727997493,   8.5883185853562765,   17.231619501931469, 
             -10.590401342848363,   1.3060205463201662,   21.726338359039346, 
              11.383369566470691,   2.1195806325002939,   0.71845422900203515, 
              10.226176449527804,   19.004827473229803,   -4.230297861324944, 
              6.0420720389955385,   2.7857009543784406,  -9.3774273400110904, 
            -0.23647008883026024,  -0.68082057858877387, -8.3117890889857247, 
             -3.1261655803575028, -5.0370665611630416,  -5.4469843268505009, 
             -5.7106973955435443,  -7.6907053219054742,    10.998716573662639, 
              -10.52789428961092,  -2.3525550811383376,  -12.698120587057096, 
               5.3451644417403843,   14.192475608158109,   9.3825686665340253, 
              23.657708830169369,  -9.8627652183789287,   -3.2418642790907719, 
               4.6663394809697616,   1.0002915433128519,   -16.396028567936263, 
               4.7780620025592411,  -10.676884986242975,    3.8912953031924791, 
               18.083547557415958,   -3.4105551463187442,  0.44101847188860871, 
              9.8412375050850827,  -14.724472459587156,   6.7048986024083739, 
             -6.4068692483577685,   2.9818005815823039,  4.4682643204593333, 
              12.026968201862511,   -7.3991344330496318,   4.9992341613534812, 
              -1.9585959501910324,  -6.0390011797758492],
       [  10.04282427104636,  -3.4170176530213094,  -6.7605243571911187, 
              11.214014006132631,    3.5824984112867178,    6.8359321852470147, 
              12.867804978818304,    0.20520631669619249,   1.6359763378747203, 
              3.0350040798833859,  -13.413819171540361,  -10.176040993482466, 
               1.7158950706743383,   -18.036071259472898,   3.8833973652868554, 
              -17.263343113279667,    14.648015553854609,  -5.8810607313397547, 
              9.9604959235233181,  -3.0940813262160027, -0.23919194701054111, 
             -18.113267335329343,  -4.3615568735609909,   28.795235030945641, 
              5.1964534629103687,   -9.8206921468836175,   5.0137966136474219, 
             0.15466426008947651,  -8.3542241875538519,   -9.6258653952824584, 
              11.466517080898729,    0.8091025359438111,   -4.2172994288967853, 
            0.083744934198636711,   -9.137224874572647,    -18.493228894759891, 
              7.5195756274293259,    1.7978265483614377,   -17.526965862143605, 
               4.9795224153957252, -0.39902681858930228,    8.3367592793766914, 
             -1.8340975167429336,   -1.4033016497171618,  -10.249375786466857, 
               -5.7897120598702942,    19.37661656690894, 
               -1.209006494498355,   4.5128060386754196, -0.98170852698841227, 
              7.0700885051143327,  -2.6964867272318611,    4.197024522271315, 
              3.2027161892156286,   -1.554714841753434,  -0.13032354493629275, 
             -10.063048095550432,  -11.484757517003297,  -2.7806935586922075, 
             0.96079312810869921,  -4.3639084068277061,   9.0540703689330577, 
               3.712498202749384,   -1.4371783118078145,  7.7977715984356379, 
              13.576157731096945, -5.1080895448876884,  -4.6172756190518278, 
              11.619898953050608,   1.0212332791358052,   -6.1990819461140294, 
               3.632125961760166,   7.5126462134558514,  -23.279213067786184, 
              -8.3987250656083106,   2.6511074596943374,   5.6920978609708373, 
              1.1364924579441522,   6.8441154814699683,    9.9192453932887794, 
               3.9988341442404378,  0.03246803325682613,   -7.0493507947116543, 
               16.348629541429887,  -2.9847695888632386,    4.2783717523912985, 
               12.434080212430295,   -4.7276751821560357,   10.236970298150007, 
               11.46236913913987,   19.503086371752389,  -3.4806422329469999, 
             -7.6019469715832209,  -4.9994323527111604,  6.1536139170246473, 
             -9.0906362429802883,   -19.531009271721707,   1.8247242609764946, 
             -0.48846853622712244,  -21.288817115576887],
       [ 13.253290730011907,  -18.886926317180105,   5.0106251210877435, 
             -12.266865251710861,    10.431718114005339,   -6.6386663530979959, 
             0.74228225148144478,     8.0884047882832668,    19.93447774245935, 
              1.0021681088135286,   5.0382045139920484,   4.1805576873906283, 
              -3.3306495880305835,    12.931856498450303,  -13.131185438976305, 
               8.8156356948797718,    11.528882605590194,  -18.102462629876555, 
             -6.0870402804547776,   10.115692605674955,  -7.8542679597398548, 
              16.397117971136481,   5.8803099917991499, -0.77702248900237425, 
              1.2972256327104581,   -15.489477946204866,    5.244910877748783, 
              4.4334034638090163,  -22.703703065848664,   -2.4528404735085965, 
              10.237239505980346,   -22.755130238008178,    30.558223905145688, 
              5.3365155127736923,   16.439567114616306,     7.6609682164980661, 
             -5.2521642447682746,    5.8158824939709719,   -3.1848199281520237, 
               4.1717576518933068,  -6.3230436389620426,   -11.399927428777776, 
             -5.8513244961500002,    5.5224862272248938,  -17.356076434917167, 
               -2.7959267797509795,   5.0835756394466616, 
              0.25394696347646922,   11.054031564127198,   -9.623196510587233, 
             -10.834976620641616,  -5.3862872060566458,   15.540861076366866, 
             -4.8444268551495879,   5.8371280110855874,   -10.469628959434534, 
             -2.2093603060715727, -0.37921454893856432,   10.241514060716293, 
              -2.722013755438593,  -11.863716268397882,    9.838897644081614, 
              28.696290722507904,    5.2226023108862378, -5.4876880090460025, 
              2.6246261668018622, -4.9550328410280198,  0.54124777994443818, 
             -5.8246754858311425,  -12.637682969313634,   -1.2526292111563597, 
              6.4491556751696901,   3.2453518382413078,   13.292814931264758, 
               3.5431708485325455,   9.1171945233137581,   5.1354183240345277, 
              1.4429887938463948,   4.4386792667924198,   -1.4179310708255839, 
               4.7658386346252009,  -3.8798482368612475,    20.797324846191842, 
                2.051385959889545,  -8.7805809931592851,    11.551320789677124, 
               9.5944617177645046,    6.0939978522397791,   11.842176118596846, 
            -0.38772000328739009,   10.822150958323872,  -1.1342557334120269, 
              1.9943106466364988,  -2.6806460151427181,  11.198424690646242, 
             -1.7223318749720709,    6.6757816021817309,   10.137506764043184, 
               2.9835979412993838,   7.4386546112368181],
       [-25.093970966632764,    -8.96587214002769,  -7.0557220290314326, 
              13.824437928529994,     1.103928361981656,   -14.075133639785928, 
             -6.3513045173172644,    0.50478477921123044,  -7.2903026151219965, 
              2.0721454781285233,  -19.113893385465065,   9.7453350291551253, 
               9.2466322368872991,    10.040560362363124,   12.953918474408351, 
               11.460146914318495,   -11.271492304350756,  -12.986616528382513, 
              5.5840933518087166,  -1.9692551215426566,  -3.9067147134992206, 
               -8.47079418597861,   5.3678142541900158,  -17.698674405854653, 
             -3.9166254636354072,   -15.246794229273954,   16.788170857543076, 
            -0.40874105325634591,  0.97751630390624911,    10.075987443982587, 
              4.0855814209515486,    2.1970001387220495,   -6.2926472714208224, 
              9.7737279371984567, -0.46741781921184822,     8.2620125706906418, 
              18.103771022319506,   -12.550017016738483,   -12.172669605849061, 
              -15.692095868128082,   10.474422959586331,   -1.4950736761210344, 
             -8.3218960093998202,   -11.969441248216583,  -2.4598974535707723, 
                8.8220792141401798,   3.2839169126762053, 
              -6.3747718977839432,   2.2580154264114154,   2.7843522947746173, 
             -10.608211388207053,  -9.5895658363618299,   13.251437709682957, 
               12.72200981550891,  -3.6168912194577447,    9.2721062851343028, 
             0.10686191736674266,   17.183712540309823, 0.014698378702021349, 
             -15.462027364183431,  -14.086958736631182,   16.839781880596856, 
              1.3549897438915091,    7.0530504482805378,  14.951288881340956, 
             -1.8097990947568923, -7.0241067329019744,  -8.4930760796131821, 
            -0.44549968562578474,   7.4527634844875568,  -0.28678119884940134, 
              4.7575291921217175,  -8.6302712011952334,  -2.4963288390043297, 
               13.916975696967263,  -9.3721035110544051,  -9.8896673669758943, 
             -10.847946790270306,  -8.9522036161392418,    8.5845021436954614, 
             -0.41843913064141847,   7.1309719204379611,   -29.009294812189047, 
               1.9664497863732187,   18.380430183370144,     8.548663685466277, 
              -14.510746983418175,    1.0660635646125849,  -4.0856064936119454, 
              19.680763830614936,   12.842782521116295,  -8.4152192061985165, 
              4.2218300741519288,   -5.196245747468601,  9.0703458085470885, 
             -1.4707084722419361,   -3.9900065356110219,   -14.67272070387172, 
               2.8629440084746678,   9.2509357145041271],
       [-7.2927814048700483,   7.2454356787198551,    6.620406175565825, 
              16.062654660915978,   -7.1024002693811497,    11.911177305334286, 
             -21.876442192242735,    -15.819441203693273,    2.299304452673264, 
             -6.7414721009301175,   8.1790902332036417,  -10.222167779173004, 
               -25.15360053313827,    1.4049678505624896,  -1.0067787945200044, 
             -0.36391642481979375,    9.5304352415478881,   5.6943509249755291, 
              -4.003501306765803, -0.29736473740696945,  -1.9168662799912579, 
              3.9805789968689851,   3.3642814741514249,   14.071527579953996, 
              6.6601518276611689,   -1.2961146354503397,  -13.813163822936671, 
              15.118681076058813,   -8.011659751179236,    18.099039492828751, 
             -1.9099482388635369,   -20.051275819359724,    2.5214571238014787, 
             -18.125997715754167,   2.8990703213877489,    -14.685143922425596, 
              1.6359894601081446,    16.032334573708752,    5.2746286227388239, 
              -12.296745707493958,   5.7234947451822702,    5.3984730176969435, 
               3.901873508390695,    3.5458342434719854,   12.154987734883946, 
                8.6558882068419365,   5.8912581006084128, 
               8.0091888370093063,  -1.4242530251579417,  -11.975371972088816, 
             0.82378324363637656,   15.083238009158922,  -3.8999090837322461, 
              1.4163569535103915,   9.6451605990998512,   -6.2269194436083843, 
              3.0515174720334222,   1.9359112704100525,  -14.644037238669693, 
              27.764039843626872,   14.540509308506707,  -8.6741166094102748, 
             -12.955215176267016,  -0.84249023508247389,  18.894382929788964, 
              3.9621650270594495,  2.2877061796823761,   6.7752836154535379, 
              7.5010563934896055,   11.514852276368826,    27.861517145236121, 
             -5.9710758934078729,   11.795271940742467,  -2.5807471375223261, 
              -1.2282656569807073,  -5.8200443936002486,  -10.059346916948995, 
              10.155392026450674,  -14.438833634470607,    7.5797010989414133, 
               12.071999888386804,   6.8400041754021608,    -2.388958294265497, 
               3.7967902825235225,  -3.2791560547473679,    7.0231646153332781, 
              -8.3644730256548865,    -4.802569308719419,   2.3469282082599854, 
             -2.1913729697309754,  -12.724502752943918,   12.377997095235358, 
             -8.9443301786044369,  -5.4554527701518136,  7.6612472637749249, 
             -7.6674844518127596,   -15.590488878323143,   5.5709258795282555, 
               10.078766791588109,  -10.119772375292301],
       [ 26.687697485770205, -0.98049676133674646,  -3.2566495944792253, 
             -9.3606532391010528,   -8.8488837910811586,   0.33053001277504984, 
              12.770972046978756,     9.7967574042930288,  -1.7088739658883165, 
            0.032027314539629197,   9.5340152922972514,   9.1074249172770152, 
            -0.044023112841832426,    -8.320225485183121,   4.5993897879364773, 
               7.4516054245514285,     5.429570367829216,   4.7867901639246728, 
              3.6538070956702318,  0.51202958897311801,   -7.754605804303206, 
            -0.51460662274644453,   18.990328565323285,  -6.3416717482216534, 
             -10.967016788814405,   -8.7252118044880156,   11.994475028574637, 
              11.152991663779764,   17.635503521048129,    23.392796606252247, 
              -3.052588116891858,     5.080236194406563,   -10.631396012312377, 
              10.687423286125417,  -11.826359730907958,     4.3094156661382339, 
              8.1039463065260406,    3.8221180251507509,   -6.3661255115017816, 
              -15.777195052680389,  -15.373300157239392,    20.143781611811036, 
              3.6110474831757804, -0.045674532560537162,    7.166486529915117, 
               -10.689535904566522,  -3.4657594458610963, 
                4.018141305531973,  -5.6751404652152218,   1.4759933843122119, 
             -16.154812479249166,  -5.9619032049101879,   2.7508571974127802, 
             -6.4661159593039299,  -3.6401279097575538,    1.2014018533772441, 
              4.9300416802013904,   15.074800340895216,   17.819875011096713, 
            -0.03943299901645754,   4.8327238588494605,  -25.474709888348379, 
            -0.44699488983164526,    3.1581398737567397,  8.6202717119241186, 
              6.9378304623332889,  9.7201582073751762,  -3.4881763080745376, 
             -19.522974533714791,  -9.4741825993929201,    7.0923576437687244, 
             0.27537313029222688,   3.9026527960638342,  -1.6290766023165351, 
            -0.088363079334617234,   2.2978757727134993,  0.99802249625414219, 
              11.644466084894951,   8.1430741369754109,    16.887619744624697, 
              -12.591586173022122,  -2.0175489122587407,    18.233084739311895, 
              -11.447537465687772,   -3.845697372150878,   -9.4777147118019975, 
               1.9174496401215682,   -5.5656336770545369,  -17.428138456031281, 
             -3.8833286225957711,  -17.768225321240131,   -14.14892690666103, 
              6.7399908622558682,  -1.5833762566251139, -8.2428185104940042, 
              -3.762849497025532,    3.3355461714261274,  -2.9067922889371962, 
               5.3008440044424745,   -5.677263595159026],
       [ 1.8196105593214988,  -4.3569951157071545,   1.2359953065939868, 
              6.4810102237779033,    2.6796479831001467,    1.8415195374363089, 
              5.1007030487595735,     9.6596253585327556,  -14.706434364475189, 
             -16.975812412275509,   8.1826346127424099, -0.56864188708729579, 
             0.070789335111451163,      -9.7078319755972,  -12.550781246084428, 
              -1.8717831614583633,   -2.4318617251774812,  -10.072006456945479, 
              3.6530548583571107,   3.6820994135617164,   15.684765412057203, 
              3.0012192531313167,  -17.297622284603456,  -11.276571760447105, 
             -11.333557600922708,    7.5631976209520602,  -12.572538587123013, 
              2.6726438899996596,  -6.4448723370350116,    5.0668376714449526, 
              10.285469854314439,    12.789979444293976,    7.5162973750304296, 
             0.85415341095351038,   11.353925290597001,   -0.59451844615852667, 
              2.1627513492153345,    11.785978225350277,    1.6516245890027828, 
              -7.9887214312369963,  -5.9413714368484891,   -3.9929419761689235, 
             -7.4234107384064432,  -0.58098423467726357,  -8.3188400606871049, 
               -5.8418769006069429,  0.90914779583168071, 
               27.064571752049424,  -7.1063916301820251,   8.7825787232795207, 
              9.7992152010308917,   -5.100096582085154,  -6.0442052430603264, 
              17.615307423705989,  -20.640545356914238,    2.6981855221958275, 
              4.2914109748312477,  -4.5166420420551621,  -4.0037986188856562, 
              1.1580223617946681,   -7.161285484785985,   4.4562523472678874, 
              21.448812558033051,     -17.7039093789646, -5.8247913124350887, 
             -1.4036890319990336,  11.112102992294117,  -3.6137421847026601, 
             -15.384697159948752,  -0.2757448313759252,    4.0645377439998391, 
              2.7309514756591962,   3.6993658087979546,  -10.038448300188325, 
               6.3546920377793059,  -8.7872851703212191,  -13.413414536852617, 
             -2.5828152668365165,    4.815819820058155,   -4.9232895182446503, 
               6.6089426759352863,    14.44910567108516,    2.8819421747052107, 
               4.8367491394377149,   19.334894451170932,      9.70102153587092, 
              -8.5638266997683292,    20.601869749976881,  -1.9407110195289818, 
              1.1561094721654277,   14.281380566213361,   5.8599662928047378, 
             -11.396241485848357,  -3.4470324150140446, -1.9547549621478622, 
              -9.067565805093956,   -19.093136547939299,   9.1557922923086537, 
               12.283768238747712,  -10.693176475203501],
       [ 9.6908774847776105,  -7.0409664465455677,   5.8413722351225097, 
             -1.4957864902401732,    10.452511260197582,   0.96940989992352122, 
             -19.152350428597984,    -11.361486545225519,   2.5913911319985186, 
              16.973987785415218,  -9.4128889548003478,   2.1119234347515463, 
              -2.2898631605037041,   -2.2087402265578699,  -3.2040698037719388, 
              -1.5521946702547615,   -6.2296500775058741,   4.5133962645117895, 
             -7.6164465737632074,   7.0138214340549663,  0.48702861007424042, 
             -6.9013856828508082,  -7.4787034871212015,   6.9351652668147645, 
             -3.3928246450282162,    0.1337069135070279,   8.5387782754065729, 
             -19.348756480603942,  -8.8559583935909441,    3.7750823083604184, 
             -4.8168644520485966,   -7.1657614335675888,   -4.8678883177993857, 
             0.70043326893993607,  -1.5696558606087558,     -1.714212130151116, 
              6.5637957607819573,   -7.4221855396050005,   -1.5990306590321337, 
               4.2012142778320047,  -7.2635705625330784,   -4.7900298236314773, 
             -4.3316554828777782,    24.711875793800701,  -15.650441123469399, 
                2.7955207905020045,  -4.3457878489158945, 
              -9.7901436481031343,   24.760868647673234,  0.80803026897862062, 
              7.3589128641226562,   19.362303638012527,    1.002214381525558, 
              -5.021109924789898,  -2.1792867168754633,    14.361822728824968, 
              16.386386151012712,  -2.7274073603718558,  -12.683767558335774, 
             -2.8600455815074648,    1.692576123279893,  0.97435962023062128, 
              9.6440282215850814,   -6.0146170128136927,  -1.027054898829727, 
               4.182370548938696,  16.452834068976429,  -1.5226218787754544, 
              4.1948793726670495,   14.868455144721114,    2.8443905274150949, 
             -10.472756572303938,  -26.333943145596557,  -5.9806420822870079, 
               1.9587779326132457,  -8.2447993040689269,  -14.401482185191743, 
              0.1769186939987249,  -9.2115623762658334,    -5.498352857952634, 
                1.548564191492797,   -6.226454831318784,    5.6052372673689597, 
              -1.5034407127531721,   3.4188378521350664,   -15.414509453625087, 
                2.634827603279863,   -1.0675516692370777,   10.383884490294601, 
               1.730892335917267,   18.783636348827489,   6.9374618986870633, 
              0.1814665256036799, -0.72777123013392331,  1.2669765693578248, 
              4.6429729961275212,   -2.4994893717624862,  -2.5836149985942605, 
               13.521025923052495,   11.452736692890625],
       [ 6.9453430593518579,  -12.002827318898628,   12.298190101294944, 
              1.6554444962393577,    1.8396810809579442,   -18.285674372770401, 
             -13.939233978038681,      10.39605336399328,   9.3160193557951914, 
               20.27430608819628,  -16.314188319059003,   2.6949468707315258, 
             -0.42622586447302979,   -22.722444662638459,  -3.5438733426936109, 
               12.842758970895296,   -7.8390002419767946, -0.11022748968760651, 
             -4.9503731683966832,   1.5862285966390146,   2.5710637388311168, 
             -9.1060605129878027,  -2.9233625933733949,  -9.2510545648028053, 
              3.9993661527965196,   -2.3016516615644989,  -19.531660160094479, 
             -9.9490801514320353,   7.4445242242018832,    -4.741286853125283, 
              3.7290561506555453,     7.006484781348008,    4.4942695946999764, 
              6.3813811205405653,   0.8598224136893613,    -3.5092534211489204, 
             -3.1792276543831841,     3.470897166407922,    8.6808373359785769, 
               11.336529571415561, -0.96892319233088386,   -1.4897696943876473, 
              -2.416528050151304,    5.1365738056738355,   7.3320084722963781, 
                -8.566415751802662,   9.0272348840845424, 
               0.7460903238103358,   10.458009815678931,   3.6900605070391834, 
              6.0524803074007547,  -5.6732678415734714,  -11.662969656026839, 
             -2.9092249107821955,   14.680357731835908,   -9.8313596632412796, 
            0.083299263156982592,   7.7083794864697524,  -20.285333283112106, 
             -1.3859598189102382,  -3.4882484978044817,  0.80629711240978796, 
               18.62834270506206,    4.1933817350517257,  8.5545452120653493, 
             -8.9414818673371617, -8.6152793195249622,   7.9814382062632294, 
              25.692591449480812,  -15.851548864964968,   -8.4721976145628357, 
              3.2525074605091966,  -2.6892183659358162,  -5.0728909931990671, 
              -9.0263165442557547,    1.618147076589755,    23.62350719547004, 
             -11.189844690184525,  -9.5681375555916315,   -5.4639863334740637, 
               8.3519570086807775,  -3.2884290610173803,    5.0908921531037645, 
              -16.287626779579764,   10.416505275703509,    5.4681554026196943, 
               6.9889485354662506,    12.486457820687143,   11.955521178846888, 
              7.7991236331841343,   15.147670524424317, -0.86152236663314508, 
              -1.910955844126071,   17.580557084749032,   0.992711166404882, 
             -6.0332208293775142,    14.572303234718667,   1.2379902923760231, 
               7.6935269859515447,  -5.3689868959545928],
       [-1.9673055637117942,   8.0770522096894855,  -19.057403478269961, 
             -21.206985268074931,    4.5851657705321305,    12.789802024463482, 
              3.4740587697263203,    -10.081604928923873,   1.5969583874817059, 
              16.125236007141645,   14.110421192901734,  -9.4707155684151676, 
              -7.1189884730191446,   -7.5389381564162843,   10.628949401519668, 
               14.810707786506743,    -8.549051787511539, -0.19124254839786997, 
              5.2109349913150247,   10.897957471611166,  -14.424352315762359, 
             -7.0268971214785001,   4.6446140356012169,  -9.6242273704731058, 
              14.284695060378507,    11.411456169894578,     3.33990943782646, 
             -2.4194128499320344,  -6.5229790127387535,  0.020281591806188451, 
            -0.12450977391340418,   -4.0651317001213148,    2.0401964978071301, 
             -1.9491126867525723,  -17.666585607735605,     -7.815941191278525, 
             -10.209482952230648,    1.7537418634827697,   -6.8301107082056554, 
              -13.405614772622236,  0.54260788593542897,   -2.1426013436113442, 
              3.6480962977378697,   -11.759132768033545,   4.5962714161823843, 
                -3.140472933991699,   11.013401218821022, 
              -1.1265861683258787,  -9.2031382089105165,   18.745581552744571, 
              14.023402450987593,   6.7574943920310648,     4.68360091691744, 
              11.698989321064971,  -5.5040190273518519,   -12.036714381639861, 
             -15.908278056745937,   12.595705970587712,  0.49301469130203218, 
             -12.729308228891226,   3.6752988340236041,  -2.1644653287120312, 
             -16.873342519485451,   -6.4177619801542534,  1.3642894916907455, 
              13.589529029039973, -2.8202416768684135,   5.1518764667668879, 
              10.828674615088685,   13.886412317785171,    1.9780510422741115, 
              7.4482356438520476,  -4.6855966165335836,  -4.4948159188034502, 
               1.0459696728325776,  -2.1181160042030949,   23.036235300185876, 
              8.2398621747142009,  -16.329779166604151,   -16.946754454088861, 
              -1.3503918046550556,   8.3142607469392971,   -17.689084737239412, 
                6.241972428592085,   5.0283862522908409,   -2.9013604189298947, 
               3.7536735793653193,   -3.6416075241969748,    2.205921341782942, 
              13.422570052710501,  -11.436657256291717,  -4.8669857376024632, 
              7.3046531881752692,   8.5181135129091103,  4.5672074230817721, 
             -4.4407515502163015,   -1.2271222572629297,   -7.685716001290654, 
               14.677595013019145,  -9.5428855134015897],
       [ 15.554233637599395,  -7.7983573459865827,  -3.0671831883179115, 
             -3.4193357857945488,    6.2677725474809387,    20.550692575606178, 
               6.482458017612668,     -11.79428875486369,   18.037947331918648, 
              9.6456576277610253,  -4.3516603969215719,   4.0189602863029439, 
              0.60869223161962205,   -19.809798308051359,   22.360800211362136, 
              -23.253415738341904,   -9.9788746545575844,  -10.060803273390368, 
              -5.679723017917004,   1.4282189494114907,   10.554791457986934, 
             -7.2236139207888765,   15.873093369762756,  -10.317995755167326, 
              7.7928567714345398,   -5.0089247294775907,   14.198211380964032, 
              12.266778191317659,   3.7049220307915105,    3.0326088723836269, 
              17.495839385205514,    10.428376139262372,    5.6545127553057348, 
             -10.829803770642352,   11.488499759398588,     7.8865068158998231, 
              9.1854732667846513,   -16.926063780195186,    25.115769518445941, 
              -23.074135983400335,   1.5017001647042305,   -10.588725980048043, 
             -9.2746296985714416,    -1.101046973681024,   23.077148497553551, 
                20.333416158602944,  -6.1164786774805213, 
               3.9277103474885324,  -4.5690029332093571,    4.535363792318102, 
              15.856984938870191,  -1.8995374048152702,  -2.7855359384449714, 
             -7.8016527452223974,  -5.5145692935064936,  -0.89542851255886069, 
              6.1411260475890632,    13.17280136071037,   1.3110198391629622, 
             -2.0030763166986953,  -5.2838564584648609,   7.7185701623378025, 
              2.4421664324667622, -0.098112549162684054,   1.008369388999899, 
              18.090270837036638, -7.9306777177127667,  -7.8242001494913085, 
              11.958165879806323,   2.4371210548473932,    10.173765885027509, 
              7.3006378067716096,   8.0630649740009179,  -11.384733720603739, 
              -3.2458145110891983,  -12.161881642892972,  -4.3689646366864929, 
             -5.7341633862696471,     -26.773305213299,    -7.618602032901272, 
               -10.66283287060725,  -7.5307596637923613,  -0.28828931165422855, 
               6.7247162237520017,  -4.8250482491825188,    8.3620561024133462, 
               23.407975092204648,    9.0294111726700326,    -14.1793818259336, 
              4.8737649155885201,  -9.0786950473490879,  -2.1591152835692475, 
               18.86238739323041,  -2.8984499013658622, -16.745535617363846, 
              24.998726235340932,   -6.2732947093937685,  -10.123919119287908, 
                4.657348526012024,   11.757459031513431],
       [-22.761642961513601,  -12.340408186779634,   7.6293751547415178, 
              3.1377289771215522,    11.606116362543785,    10.591476624005328, 
             -7.0496132327496355,     14.342619426419628,   -8.801708611893913, 
             -7.5701291169745915,  -8.4567451050621365,  -1.7146366393341583, 
              -5.5228947140244253,   -8.1400930605952428,   6.5674593059436823, 
               10.700710980887834,   0.39148923228864474,  -2.5460639344600566, 
             -1.1859372461991415,  -4.4778766296029495,    17.30612012439121, 
              6.1749322189059317,  -5.3361247991323513, -0.30210394471426694, 
              -14.08312116798964,    6.5032904356813281,  -23.615387106055074, 
              4.6508029628069254,  -3.0389352057599162,   -5.7695854511112792, 
             -2.2087026849223919,   -2.3562990487591171,   -4.3879111809883211, 
             -0.7039696688008279,  -5.3110969532308268,    -3.4466214850123311, 
             -11.905519690982487,    15.117973965910323,   -2.9523376218709512, 
               9.7053380166327727,   15.228496734683805,    -13.35008394252027, 
             -23.464613650103765,   -8.4049234174450405,   7.9463942620738699, 
               -1.6832514094968976,  0.15576571974984876, 
               1.3386400521846709,   5.5253136197448409,  -2.6754536374681543, 
              7.3018212005597611,   9.4089577084298845,  -8.2415567180123777, 
              20.487162922464034,   5.6123859169023005,    10.674768521874206, 
                 13.497638567185,  -17.102781868830441,   18.960044696517329, 
             -7.1726320408178204,  -2.0992376061730385,   1.2203995432257047, 
             0.68106760365272789,    4.6190619080180326,  2.6280761166699813, 
             -4.3100621784469624, -4.5817748425513267,   8.3231032415950406, 
             0.20144581642185505,  -1.1927007959596061,    -12.19690055735034, 
             -7.9056292162304409,   3.0797937494009235,   4.3613782784266393, 
                10.53964330463935,   6.1504291793408292,  -7.7312274866417274, 
            -0.42518940328475596,   2.7461893342071262,   -1.7356535639870656, 
              -7.8644288706269139,  -19.938290596794495,   -17.997962395888976, 
              -5.3646580361585503,   11.878164547046502,    7.9610621867436304, 
              -2.3712950537619673,     3.487938995873666,  -2.6960953003584507, 
             0.29074386804208485,  -10.155202389030137,   5.3432152804498028, 
             -12.500094120919096,   5.1371811582709261, -3.3500640039349339, 
              11.971118905591503,    11.415207824507716,  -3.0961181949952521, 
              -8.1767190879734599,   12.654124894012323],
       [ 8.9858211568083615,   14.749153667558126,  -3.5455743429220696, 
              3.6942593292611847,   -4.7586446112335494,   -15.566907326797907, 
             -8.9727359392849948,     12.477675470821918,  -15.833672915010027, 
              4.1852049852148383,   13.171618919513898,   10.846436335416731, 
              -1.6224158008111567,    6.7342372043735477,   6.3798933215949303, 
               9.5240129896733592,    2.5883969054574596,  -3.0170575961507593, 
              7.6201723326505739,   7.2626958277987903,  -12.413252330106328, 
              19.924061003653684,    5.723701524809317,   6.0349911737594333, 
              8.3395301698848776,   -27.479266432028531,  -14.531124617089121, 
              23.299313764980457,    9.143662405720379,   -13.148863110095633, 
             0.49446525824586895,    11.092007197587176,    8.6388878253745567, 
              14.048976476288139,  0.70858622109509051,    -9.8055994762915795, 
             -7.5191707033619926,    3.9313298300365029,    16.484701044810652, 
               9.8308094286611016, 0.033431428902435771,   0.13807286672378821, 
              -9.465043989813072,    4.7777908929034894,  0.13892407996783898, 
               -7.8345837489276837,  0.44833551913836373, 
               -11.81548543531637,  -14.510693287721324,  -1.6111299470273865, 
             -7.5670846308732109,   -2.355722824098383,  -10.764552220344441, 
             0.48560028087508456,   2.4076583272357741,    8.6745492800311528, 
             -11.732604527108684,    5.947795905636494,  -13.167402810766038, 
             -15.414781010311451,  -1.0581742244756462,   20.079646121394113, 
              6.3778619137689319,  -0.46693624708832715, -7.9553640502351977, 
             -13.794643973129666, -8.3942397072148296,   12.032144855006377, 
             -5.1972026230773949,   16.793814043147123,    2.4069106094003039, 
              7.2017023886902232,  -5.4836256981044311,    11.38833342899018, 
             -0.15923327487879199,  -17.465542352647645,  -0.5962028069333043, 
             -5.3061877301381966,   -1.419843435173564,   -8.2768589991150208, 
               11.354414810453468,  -9.2474327019857014,   -12.200261908851477, 
               5.3968119737906157,  -11.397535269231394,    8.9611304445860895, 
              -15.648524728999826,    2.6248452541114893,  -2.2580391685002592, 
             -9.9545274618132424,  -3.6813626585983297,   6.0345285755899027, 
             -2.7735597153141045,  -11.886634649083538,  4.9132848678620178, 
             -8.0289892063313992,   -2.9947906032601992,   9.0937715084438349, 
              -4.1164150342261987,    9.501764255258573],
       [ 8.2483255572249039,    5.139606029801989,  -9.9951247609620193, 
              6.1012440114162834,   -15.500529932728204,      12.2464873960547, 
               6.496884382289311,      13.13510652162504,  -2.8820745085761317, 
            -0.35722057700374021,   -10.32985152919688,     3.85052089913298, 
              -11.680701333166734,   -4.3699267113469356,  -11.385400954673869, 
               2.4735739675379591,    8.4981718918689761,  -10.667898995238374, 
             -7.5571728014703874,   -8.739595985164863,   3.7351937777428286, 
             -3.5370518969966329,   3.8387656149566292,   12.109108535627911, 
             -3.4906484933469089,   -4.4209971853402177,   12.335574935389189, 
             -4.3653197370747137,  -10.667645609816523,    -1.040963685028458, 
              3.7534134142321256,   -8.9213289822711204,  -0.29155486009264536, 
             -5.5212398322623137,  0.57302476144179837,    0.78972781271512815, 
             -2.3602451269050966,    9.4354026564522311,   -2.7146439524074606, 
               8.1462946516036503,   9.1167986141522981,   -10.367224214522455, 
              1.3511888814285915,   -7.2935594868116365,   5.0514128577600772, 
               -23.397039115821222,   3.9215198778136857, 
               3.7170783820197171,  -11.037280718119336,  -4.0261246568742077, 
               18.07210524641064,   7.0418299026195621,   6.7237787234599411, 
              10.395777516274299,  -1.8478415273160529,   -21.961857970654712, 
              1.5325838508723524,   1.1095358804840145,  -1.4594253148131273, 
             -7.7149657781447054,  0.60590372944313253,    14.31602905872422, 
              -10.99423915363692,   -3.5939028763264687, -3.0368250727520363, 
             -14.591838012250376, -1.5082593443301484,   3.2822596637704535, 
              4.6839785469586079,  -6.0748112378473476,   -18.963902575777315, 
             -10.804459078938075,   -4.247039865013635,  -14.210246760348049, 
              -2.4131412868030631,  -6.1598973636137107, 0.098284401504673699, 
              11.994243547806146,  -1.7960169385779421,    19.089744845428729, 
               7.0454363999730232,  -9.4286951634894933,    16.108319434364965, 
               -7.884029383777392,   23.742171714660763,    9.2221684116414337, 
              -17.185730498790331,    -1.553460803486747,   13.254380261958696, 
              10.353168852045314,   -10.91932887509266,  -10.255708285960175, 
             -18.164614261513357,   12.272322194384513, -12.874498003127645, 
              2.2156981233433566,   -2.5891194924224652,  -18.970518123590143, 
            -0.083305555109180723,  -17.130719700957997],
       [ 3.0003125276388207,  -2.7478513330822234,   -10.98607640617338, 
             -12.900642253938583,    7.0804726579119954,   -13.086392676680894, 
             -6.3990942614612365,     3.2487220507570647,   1.6395047123875863, 
             -13.574907814002351,  -5.1168581194073521,   7.0576987672741431, 
              -13.686918475350243,   -13.395871671083162,   3.5461985020988287, 
            -0.058486408392310139,    2.4191426152450766,  -9.7233768980760882, 
              13.932492465381948,   -12.12909381470431,   19.983614893800375, 
              12.074491068352858,   6.6591371184551811,   1.5852682499077799, 
              4.0386096699288201,    6.5619404962161685,  -1.9366902430934483, 
              -18.42876373184151,  -8.6531012640870397,    2.0728391508262805, 
              8.2021783139799869,   -1.2620598548335655,    9.1066123547790809, 
              1.8003345074768486,  0.85704098007178642,     18.222841650837257, 
              1.6786510233162397,    18.282693767542796,   -3.8142958368332103, 
               2.4740632898648691,  -9.3954972180045768,    6.7488791671145556, 
             -8.0761558693173878,    4.9712976582609079,   2.0396327096489313, 
                1.1974431955338656,   -10.59711761529573, 
               6.7855912231295701,   9.7668594833572513,  -4.5345959485060225, 
             -2.2874281680342561,   10.061032352921131,   7.1066808398692318, 
              16.845346263926299,  -21.132800652891866,    2.3347679502444638, 
            0.076821310729955794, -0.21508934894750445,  -5.3287126084676295, 
              9.9745916258832139,   23.979608785810463,  -1.2901493029758673, 
             -15.713835351422683,     7.201873381521164,  15.553035840808178, 
             0.41135575863029183,  1.9613656076041983,  -1.9128711174266448, 
              23.580174934242653,  0.12247009799014719,   -2.3514349791750049, 
             -1.4880109023798704,   1.1812608134840452,  -0.6238069726236708, 
              -11.634285872419278,   15.459143412187316,  0.77629501949597335, 
             0.70515212461187404,  -14.502166265978794,   -5.7319582266599367, 
               2.8808507426741685,  -7.2126447720896261,    3.8086996548986685, 
               3.6318110832754114,   8.6710462162221837,   -4.3791796627763153, 
               9.6313917799221578,    7.5787013744681673,   20.993822997600788, 
              8.6144686228417182,   0.7144827712239481,  -9.1044131528682044, 
              6.8856971158379778,   15.674905123885271,   12.87254275089043, 
              22.827353748616694,    -2.439368220729432,   2.5921383305732286, 
               9.8872428619410222,  -8.0951257120018187],
       [-4.3381420217155089,  0.99132152741308877,  -10.005950769859185, 
              1.6229623232746668,    3.8238103824674159,   -9.4229398289451876, 
             -9.5639674196160946,    -13.311805051707584,  -8.8457223350173528, 
              12.789995072936485,  -1.0528592871812616,   13.182359198495668, 
              -2.6073513844047418,   -4.6365223080542517,  -3.4804574939652309, 
              -3.6649157687674938,   -12.490554509742712,   15.379666471038169, 
             -14.153165544047983,  -3.9654552587431189,  -12.719954597138761, 
              8.6199757283719531,  -4.6776723809870893,   2.6137443016155677, 
             -1.0346270927551589,   -5.1882742548039325,  -14.063713222141496, 
             0.81834708943812218,  -10.351492302938501,  -0.67718866587923587, 
             -12.118990292744122,    2.4534761209012417,    29.956262041908388, 
             -8.3513849923863699,  -3.7065554167020514,     -2.898066043421228, 
              1.7263905785887128,   -20.301304513538028,   -14.805636120587351, 
             -0.40106560681496123,  -6.3143180166900539,    20.604324658402156, 
              4.8441448843128665,     0.108039273688276,   6.1532296024289481, 
               -6.8106884064927398,   12.851204943312499, 
               -14.87247729658532,    8.391025152372805,  -3.2195626870046192, 
             -8.8686550351139459,   3.8555839284779458,  -4.2510986384738185, 
             0.14160644863008093,  0.62859085837749695,    13.460033791926984, 
              9.8203763589181623,  -10.678861389871312,   0.8726355742250852, 
             0.60146936179716648,  -10.381602507660176,    8.551537560024105, 
             -3.0077681859509759,   -1.2266198092224951, -5.5755875957068879, 
              13.042211440039193,  9.4196497968123989,  -12.664632614057004, 
             -2.1156732415394193,  -1.3590202879191773,    1.4814951961818112, 
             -4.5477788365604708,  -10.470402160995667,  -1.4550018311218196, 
               3.0957869889720802,   1.7501675066418165,   4.1729705052825334, 
             -16.265279587661148,  -16.534537245424726,    7.1774336520413327, 
              -4.6135067115108708,   1.1453953337112415,   -8.9181613669281052, 
              -1.9036868247482848,   16.981942676689535,   -7.0755565021647024, 
              -2.2257718074183011,    11.141212587251516,   -11.34416060846684, 
             -13.011568399677795,  -8.4418169127261553,  -4.7602463104512029, 
              9.8048531349981793, -0.70041862936401189,  -11.83982163267701, 
              2.8076387953264934,   -1.7710124681944044,  -5.6900028740173072, 
               15.624645646679189,   11.397356372645607],
       [-6.5320504679085385,  -6.3355115373001318,   2.8535446244248504, 
             -8.9597187120988782,    4.9852555187934042,   -7.7420474497211966, 
              8.8261190546271919,     11.100868037461147,   1.3574639607585413, 
             -7.5884917207687366,  -1.6741962121346285,  -5.7786430800585276, 
                2.797285471391934,   -25.510150963646296,  -11.505878186088962, 
               -3.064775299456139,   -2.9872452566464403,   9.2256435877751599, 
              1.1961597315150339,  -10.011180751343499,   5.9721282347695661, 
              0.5863900603329979,  -3.9104784846119118,  -7.4541478413638886, 
              -15.17189261181082,    3.7444682604125572,  -3.9356951128430846, 
              7.2220047278319743,   9.6912607398026953,   -6.0814999545206918, 
              -13.50097495130999,   -10.574315865917409,    18.117981658926542, 
               12.54482054660722,    8.398635548334374,    -5.8351329163754295, 
              5.7353382922906073,   -12.274005267153335,   -11.168424392940043, 
              -21.001106027088138,   -1.218458881205275,    20.516234609902305, 
              15.997392851853128,    5.5600884397473038,  0.55490925487091503, 
               -18.661407869061119,  -23.342284361511233, 
               14.155649482160504, -0.58219653471900201,   3.6487693314923169, 
             -1.9437306963276781,  -4.5764429172027947,  -10.438647037704269, 
              -4.822180470590923,   15.354292417764778,   -10.369493196989254, 
             -15.225307035651026, 0.077172356962604674,    13.41916123000281, 
              8.1972827618060577,   1.4345209432080597,   14.472857207593925, 
             -9.9991061924015643,    13.227609662922401, -1.2223786657867923, 
             -1.9769380853075693,  3.9009346068668291,   9.6450868729045425, 
             -12.143745668965769,   10.371887849038949,  -0.14685056756168402, 
              11.492463231114584,   13.920297321366952,  0.86184578952234248, 
              -3.0476580447595913,  -18.118970403564479,   0.7828926623801834, 
              3.6398830110140112,   1.5969459695384476,    4.2308297518460938, 
               15.176808788927381,  -15.059304373127322,    1.0814460179215615, 
             0.067449410721211495,   2.9592901431192837,   -2.8804064104004818, 
              -3.7166334425525434,    6.4940447929845107,   5.4321133405864419, 
              8.9518345712419354,    16.82171419181806,   2.2979218183497565, 
              1.0294244139106352,  -5.1468143927268031, -6.9072864027895351, 
               15.55111059298225,    2.5680925112619817,   5.5950531952450522, 
               12.112556102777305,  -1.7986491390963413],
       [ 24.853219152073898,    4.432591653059136,  -8.9330649473163124, 
              11.185144750791789,    17.574910373245856,    5.6148055824893381, 
             -7.4308025098696255,     7.9466487376012314,  -4.5848865665404599, 
             -21.653147223210361,   1.9284786033032386,  -26.978614922524397, 
               8.1384650699746448,   -8.3174657153639622,    8.474038318954511, 
               4.5876975289185289,   -10.678951597727202,   6.5164566843265668, 
             -17.988814378281056,   0.7943943585288421,  -1.0095812984186998, 
              15.418043676303054,  -8.0484729964591075,  -10.151221150575127, 
              14.966181014585931,   -19.283120811614694,   6.4872680700019325, 
             -10.972135271109515,  -3.2690018493610329,    6.4182243077554793, 
              7.1781521106193855,    9.8987832326850942,   -23.397890349336656, 
              9.6610221790725461,  -1.2290578794359357,      3.060940715097737, 
              -18.62018100884892,    14.550349045094443,    2.7024572090403405, 
              -10.059393416870792,   14.203164133705741,   -24.395280247898519, 
             -11.342378215824983,   0.92902775197231779,   -6.854666164363171, 
               -3.1367309961243635,   14.581151944590529, 
              -5.5390109398855589,   1.5874997359528473,   1.1503340388373529, 
              4.4621431132329619,  -1.2065911223071928,  -5.9574227272449161, 
              18.044821116454091,   8.4937479635530782,   -5.3469562604640437, 
             -13.155841765999291,   11.084866116806255,   17.828053985860759, 
             -3.1560059944721477,   9.1992328918913984,  -4.2009550972426242, 
              6.1547096639408361,    10.920079236748794,  5.5847223256186682, 
              3.5967682081390748, 0.28753692184363927,  -3.9778380909378512, 
             -14.215587037237583,    13.75704594378546,    4.5381789838201829, 
              18.409786580231231,    7.659054357299552,   11.122922072406951, 
               5.4885430952191792,  -7.0818410125784208,   2.7933628306366076, 
             -25.008099546906841,  -4.8912974840534424,    17.306053431494735, 
               -27.66590849589609,   4.2844783248894052,   -19.546511909961396, 
               18.683650496248564,  -2.9382922415995871,   -1.0680347559088015, 
              -4.6512595997308095,   0.76911825914964138,  -11.995089599679611, 
              16.917015463350715,  -3.8760903726217788,   -4.664651961056963, 
              20.259543162005876,  -1.0293215470878854,  2.7930110106830019, 
             0.97506821196275417,    -5.543231686681489,   10.243810874882879, 
              -7.6235307331205977,  -8.8772728711077953],
       [-7.7992403712731262,  -16.297173237293102,  -7.4749715599263222, 
             -1.2050617622453206,    -16.11293082176665,   -9.3244182151677197, 
              2.9521812659132554,     4.6526342721929224,   -7.824333769557712, 
              22.667696007532015,   8.6099527789076991,  -13.758574053494534, 
              -15.220254150316856,   -17.268572765837487,  -7.1627753155390295, 
               -2.942927123914167,    5.2501230091831905,   14.479552785496022, 
              5.9068717501406791,  -8.7409648176328414,  -4.9291625972152637, 
             -2.5244788039628974,   4.2180829537734885,   9.2259544174622725, 
              6.2414348344443438,    9.9339614834604824,  -1.9437871365393302, 
             -10.442065840065208,  -2.1909121897641795,    -1.527231589221274, 
             -14.822955938386473,    7.4466452093642772,   -4.0680033479924669, 
              9.6507966154992566,  -2.8690198088949481,     11.170872295571343, 
             -1.8931943636015451,   -11.598157203160479,   -8.9736786733961154, 
              -4.5825184982560403,  -3.9706623703974318,    2.4531534934532897, 
              6.8903359331228309,    1.9526417618785508,   12.299071432507295, 
                6.2617628336462108,  -10.079901036526806, 
               8.7139870221753988,   16.846784343508801,  -7.5477448414296759, 
              9.0596937491998855,  -6.2843554280610681,  -4.7937484337454652, 
              1.3965654112944716,   8.2481564707103558,     0.229191892539584, 
              13.162925727708865,  0.63854803190082576,  -3.4525435407468312, 
             0.97511335648142239,   18.528942852287457,  -3.8248683350422059, 
              10.206018169546098,    2.7908295356248014, -14.141701158787601, 
              -9.511407682471134, -19.112738350812975,   8.8483863917605667, 
             -9.2733640403496889,   2.7436308679337436,   -10.925238775449269, 
              31.431163258109986,  -9.8086586983343782,  -5.0017276321172055, 
               3.0763118688452473,   -14.22132139056869,   7.7958338412401993, 
              -13.17484060333846,   10.102202250723931,   -1.0570082861335359, 
               7.7220767586387753,   10.141322394982291,   -5.5909013354097308, 
            0.0027537105596582576,   16.407705469932324,   -20.674717437582203, 
              -2.4567372768276159,   -19.936688675572835,  -7.9930856944408424, 
             -2.1095390288800737,   2.5762382720239874,   13.450025382741426, 
             -7.7260194944810436,  -15.887814034833523,  9.0621786478967863, 
             -3.3827766633237073,   -4.4897896023734001,   -7.901319496798652, 
               1.3152238135878953,  -4.0861566064660702],
       [ -3.930259030546392,   7.4645432830744856,  -3.4568693072857766, 
                3.48334811655115,   -11.903023305256053,   -2.4450152027960961, 
              14.102517840449632,    -16.550462229406723,  -17.755953508170229, 
              16.720346197436786,   -6.436495147933651,  -0.6122886345993801, 
               2.7442684112616345,    3.2456679507410575,  -5.5824397524903127, 
              -6.5986574721442492,    8.8371740375617076,  -5.3736598470606181, 
              2.9542164929194836,    6.054901785454291,  -14.722032069973569, 
             -11.328034021756121,  -14.370117238998823,  -4.8600515946634957, 
              3.2688186889828468,    1.7511447702580587, -0.92919300798318938, 
             -10.923335207511089,  -5.8424787447561162,     1.069621259382048, 
             -4.4107264022197166,    3.0405453184120486,   -10.642149338070334, 
              4.6776234589967611,   8.7854555548154778,     16.388762818989775, 
              2.8586337242466486,    6.0891406678572313,   -14.147208676043254, 
               9.7219603875096645,   1.3798362432823428,    3.7747921204772128, 
            -0.68210616078488728,    10.197754064709443,   5.2728344511064931, 
               -9.8609642398812856,  0.67709850068869093, 
              -7.8157053261044895,  -8.7933663642429565,  -1.3203384903363449, 
              7.4997517159211995,  -4.2943953264366206,  -12.822250744504682, 
              10.060994116936566,   15.593262334635771,  -0.13561115665208254, 
              19.097732071044724,   9.3253390128232603,  -5.5985961519677279, 
              8.1291993637647746,  0.71034752419698488,   11.007393956641337, 
             -8.1532238423257528,    6.2231489980221166,  3.1155173080373983, 
             0.67794384095342008, -2.8168599974885171,  -2.0398518768076168, 
              5.1858798088041249,  -2.6014378002951162,    10.293703808132108, 
             -18.348773260151169,  -3.0121846662057532,  -1.3829872017909124, 
              -9.0568921064095225,  -14.321845260667756,   6.9774807381822974, 
              9.7268932127008654,  -10.842987614827193,    2.8938141522748677, 
               4.8333375719396603,   4.5184132617042234,   -1.7688448771141649, 
               5.4105653678946775,  -4.0187050857355935,    5.3213747011314174, 
               11.133464463909228,   -4.9926893243658741,  -4.1291255394367425, 
             -1.7633273623045755,   4.6586688877923095,   7.0495383502891595, 
             -1.8342144561059079,  -2.5690803921063168,  4.1489042656402457, 
             -3.9130829127179068,  -0.71499585864136872,  -2.1091276646820463, 
               1.3340046530950047,   5.2812858370056057],
       [ 8.8370433049991846,  -8.7339075906638026,  0.36040176821229852, 
              3.8624895363812177,   -5.9468393686661978,    5.9511678605749498, 
             0.54220212383374333,    -1.5196898339260243,   24.141332504404765, 
             0.12776647359048315,  -5.0561623083621026,   -4.366198998117091, 
             0.012169459859885524,    5.0475521346837402,   2.7201932485069142, 
              -8.1265634739018946,    3.1816828884145054,   5.1376708122576531, 
              8.9208220794075554,  -6.4838902071033608,  -11.498819134960366, 
             -14.842697782860713,   -2.479055814213909,  -4.0047594482989872, 
             0.61763732346591205,   -14.120123399086108,  -4.0211340864690337, 
              4.4111561399781989,  -14.510705111170541,   -21.074390473815896, 
             -6.2558192182504646,   -4.8845108638188801,    -2.274495575038221, 
              -8.077987956653061,  -9.1842642661721499,     12.400571868509726, 
              6.0759698582572543,    4.6652333947871201,   -9.4382895930754138, 
              -5.4884588697446057,  -9.8302315986400366,    3.8027430035435179, 
             0.49296494881696307,   -0.2317894240356225,   2.2649940495132319, 
                7.2769541592185831,  0.36164953918059733, 
               10.250842073523486,    22.53339138584959,  -4.2297128359509237, 
              11.594831896906348,   3.4218717088126844,  -3.3260964659585648, 
             -15.895928614340653,   10.182022698486877,   -15.495558806631514, 
              -7.557295408017489,   8.3976138276955687,  -1.4650293629588762, 
               -5.36345766967416,  -2.7785421488007165,  -16.040592054525732, 
              12.834006704638597,    -19.66858618837529,  10.754769307501197, 
              18.018833144228402,   5.645266988073022,   8.5647364737272831, 
              4.9068661209194921,   12.627650147055959,    6.3809692558518014, 
              6.0674803669949053,  -11.017808004442726,   6.5952612419477861, 
               9.1346597516378143,  -10.947357489030141,    4.017002425907239, 
             -8.1589098899282408,  -5.8557951077410797,    17.778184962720509, 
               15.203077923117158,  -6.5800045998612209,    3.4135184414778443, 
              -10.921217741581724,  -5.0866406983944721, 0.0026448351657554366, 
               1.5272468579123042,    5.9854833257681133,   6.6490739751573571, 
             -1.2330471949438877,   11.053225802874252,   15.203979254554937, 
              1.5503261345014461,   14.100384826704399,  6.7941868442510058, 
              15.875023439922433,     5.601350558079341,   21.011874263918639, 
               3.4342292696851522,  -6.6530349028644817],
       [-3.9466865070321426,   8.5332555365464717,  -13.219234995703587, 
               9.364506193109337,   -6.2342971927320505,   -12.598238379430352, 
            -0.38387921698842919,    -14.864605838064035, -0.96284316531429348, 
               15.41041958746413,   21.914712308741777,   5.9482716502343846, 
              -10.092488667442851,    3.1863704602833471,   14.937407412101527, 
               10.930696979492463,   -0.9013357909275066,     17.1167661619833, 
               -8.39102479211674, -0.20000502555373503,  -14.832192924159981, 
             -5.0219772563102714,  -20.592589310234871,  -22.582713094586619, 
              11.188942589662362,    3.3988590689110127,   11.941940003407128, 
              3.7451048481912741,   1.6488525089547448,    6.7213361286298836, 
             -9.5618661784344603,    11.802884229638945,    -8.853117249752863, 
             -2.4092797722310766,   11.183286539648144,    -20.908591523646468, 
              8.9689948692857229,   -4.6527741724520748,   -19.748417407523284, 
              -22.606247677857006,   3.5462851581708517,   -1.5824294218120074, 
              4.4349340888501203,   -10.928010897375543,  -2.4800682883875527, 
                -6.467260511182392,  -8.9923145967781206, 
              -2.9362752205067149,   4.9619674417380182,   9.1287080791447615, 
              2.5460892955332506,  -2.7281116587867391,   2.5875802142745536, 
              12.364607528311744,   6.5098148323334986,    8.1485861635813688, 
              4.9345029615834797,    16.17694333447163,   -4.823877815714801, 
              9.2488542487509449,    8.949390237496722,   10.938069009221749, 
              16.221215383181967,    -6.376208433142744,  3.2071538934995685, 
              14.838208373977002,  10.105966079522247,    10.15926152293831, 
             -2.8547017681588445,   1.0087072255500846,   0.70227143938747427, 
              5.5889209347698019,  -13.849307501335327,   4.6399054256041881, 
              -2.5778781302056455,   7.1559265215828161,   -3.169183062252138, 
              21.374603504997125,   7.1248479095905122,    22.873914825243041, 
               4.7379452880178468,  -15.921144462649885,   -16.298277171981205, 
              -8.6359353719869141,  -5.8576921617584352,   -2.3343304102147093, 
               15.901460350452313,  -0.71428692205682498,  -19.479926576664422, 
             -14.726344397631436,   8.9335123851923566,  -12.072686908900426, 
             -14.226510121965621,   3.4689642322659315, -6.9605897182563714, 
             -1.8418258669149867,     3.456405865020558,  -3.3989755988184207, 
              -15.374999375327079,  0.23233493685339057],
       [ -10.59120370232462,  -2.9379390872425466,  -13.305867065750011, 
             -18.191307621358728,    9.2179282857590152,    1.0311923897221766, 
             -5.1182681906571412,    -12.454706353543273,  -7.2145725751030367, 
              9.6520884448429491,  0.93172870577411837,   8.3191178004173665, 
            -0.009678263904436088,   -4.4875784678297483,   7.4259645322542047, 
              -12.260897121966289,    8.0847136510353241,   12.766471168363333, 
              10.132946651437805, -0.79069435456011772,   7.5914164753165823, 
              8.4097345328237498,   11.666963596438917,  -21.609520289460235, 
              2.7751730299104196,    3.7467432465248867,   1.5726955821812882, 
              -2.870124776101906, 0.060111413069283214,   -5.5015838420129679, 
             -8.2493883916899726,   0.16452096986614834,   -13.153635809867129, 
             -12.958501475562464,  -1.9369987854308355,     8.3654521593848479, 
              7.0548547589458082,   -0.3805583253401687,   -12.741792798806662, 
              -10.574488923736636,  -10.673047050408474,   -11.334784695527338, 
              3.8816520977260489,    -3.032968532266918,  -5.4552327572395134, 
               -15.730275036199403,   17.711090186663967, 
               6.8077667727123901,  -8.0992672578767646,    8.763217902531995, 
             -7.8095293072279892,   5.5153810289880933,  -18.084310201700831, 
             -12.804912961579708,   14.305115561799147,    -1.835537939002263, 
             -4.5624111539219516,   3.4554771298195428,   5.5462328457531962, 
              2.4976538790957461,   0.8810293336855578,  0.44927895301824344, 
              11.053523754873048,    6.1455184264116989,   9.349826977221122, 
              -12.48506930772632,  6.5374037275914088,   11.156991685378351, 
              10.735834794937606,   10.556915110787097,    14.915677597589887, 
              10.484734697171669,   8.1872767066899463,  -7.0865835707279796, 
               -2.810693096232332,   1.1171929159126417,   25.649044716270918, 
              17.094777714240774,   11.259207902098943,    -8.470724226314255, 
               26.911468980348488,   11.006338307830784,   -21.036307048752803, 
              -7.4519842294983576,  -4.8281333205303216,   -1.3750312559796769, 
             -0.46289100487992429,   -5.6392854682642888,   4.6694738297028211, 
              14.894183549970153,   13.169643996449601,   9.6081685734260169, 
             -11.414043702828874,  -2.6009529888157079,  6.1715441549295065, 
             -2.8712302168635091,   0.15850550590756882,    1.426883085515442, 
              -11.642168536204615,   4.5109169705386467],
       [-13.353572881629667,   0.6470772826001201,  -2.8716738283126158, 
              5.0204686311668656,   -13.924889358216291,   0.73407494568500919, 
              3.0453201439152195,     14.379572182487125,  0.89673372429681919, 
             -5.7131521096899407,   5.0385076321962021,  -1.8052283747911511, 
               6.0527597235060595,    7.8260765139967035,   16.331355967687017, 
                  10.361414138309,    14.465185773299925,   11.138999819017876, 
              15.103429359943686,  -12.421386855078126,  -6.0382818697906027, 
             -2.2897174547784833,   3.3629021150260963,  -3.5112537736145919, 
             -15.073764588323076,    3.7242392750426463,  -24.395253522691732, 
            -0.88584088796754779, -0.13222034652936493,    1.0203732957941885, 
             -13.888886576028334,   -1.4083372119628805,    9.0312657575042827, 
             -8.3971778081601531,   3.6032860242198499,    -12.249970387048709, 
               13.09392684500633,   -4.4835999921555523,   -9.1365189821791635, 
               7.0617040637741102,  -12.763002902581169,   -3.3745244541658104, 
              0.5672534972854395,    5.1148698178951149,  -7.0084101523114661, 
                10.370279499888312,   5.5764048734118337, 
              -11.233401276472465,   10.411445785925411,  -3.7928202343530373, 
            -0.60590719596080289,  0.85634763163550276,   21.792476270095005, 
             0.47896312647505856,  -4.1833761923129718,    12.009644501526262, 
              4.7211553337824839,   5.2751461412474612,   12.572258728932352, 
             -3.8533752342347709,   -8.770734666672789,   2.3388385597865615, 
             -1.8984661060331667,    4.1902467522421487,  2.9623140575764717, 
             -1.6558521249812754,  3.7097262895535894,  -2.3949837953326094, 
              15.688775398327149,   1.6178400528973569,   -6.1828513770352824, 
             -13.325076084064261,   6.9491759183177599,   12.752788803510498, 
               4.5228197786075066,   8.9992393843705418,   2.6835858612639907, 
             -8.6858332430009426,  -15.725000607055275,    2.1038352854443438, 
               4.4251611552475394,  -4.7448309357411658,    24.316980708299234, 
               3.9629621787419649,  -5.9552408124386371,    11.077281570988083, 
               11.950412751127811,    4.1861169958167803,  -8.5108217969526763, 
             -2.5847562936790425,  -14.531573982715804,  -14.752255821994831, 
              3.0172083809926531,   1.3536554338649196,   17.80481961913091, 
             -3.3161925169232469,    4.6866224512354018,  -2.9171522369455749, 
               4.9478768178225208,  -17.886078758683396],
       [ 4.7351305700884074,    9.106901547201085,   21.202102143479369, 
              8.0712484908374833,   -16.663937354154644,    11.896536206514586, 
              11.019454068033971,       25.4103955702018,   11.342727894159431, 
             -4.1445378593327495,   16.674535563821443,   3.9629780256374323, 
               4.1584312522400939,     5.811315711222016,  -13.508881812360498, 
              -2.5925611950874163,   -1.4991319015833595,   -1.328878495710184, 
             -4.0563921372855489,  -1.0591679353114949,   12.710365372295211, 
             -12.722173490393484,   5.8428540572931107,   5.5585261242248354, 
             -2.0558471503321392,   0.79842113726220565,  -19.851662443191845, 
              19.317660920053722,    2.317890323779678,    12.011418231372016, 
             -14.021905109662729,   -5.5509765331456169,   -8.9225266961581831, 
              11.723867863495022,  -2.9650287045821706,    -7.8112055365816859, 
              6.8127411438347805,    3.2885740590334347,     1.367402587382909, 
              -13.598843922642965,  -0.4592351677463013,    8.6803350805082289, 
             -1.8402199292732346,   -12.506663774401861,  -3.5790945025456464, 
                13.023911071191925,   1.2858835172538576, 
              -8.6016095512672184,   12.727727047337037, -0.24399126014213807, 
             -11.582771447935515,   2.8244466639065813, -0.82855517909495724, 
             -14.343997799803931,   11.052627188604147,    6.1696796677112706, 
             -7.8247172435827181,  -17.055209499993055,   19.570982390195422, 
              -6.689370878689167,  -2.2734154120731862,  -5.1327387746282973, 
             -11.882595196139182,   -6.0234721659148027,   10.58988866720709, 
              6.2380368560030552,  11.414940747921321,   4.0275087887963972, 
             -9.6088350866067689,   20.181389490354363,    16.411540488097188, 
             -20.918109700862505,  -6.2486059989001479,   7.0548259918887402, 
              -5.0360883735981581,  -11.267000020535429,  -10.238497415332324, 
             -20.311314063616322,   4.3244110038069046,   0.25127200867324345, 
              -1.0193657740576396,  0.75278480580366625,    6.0601360605886363, 
               9.6260275705898692,   17.629649148441267,  -0.89089240876686859, 
              -1.4799864135854888,   -6.8072891028699667,  -7.2955451850813526, 
             -8.0530727466044354,  -30.703029501565538,   1.6885322187301526, 
              -5.283078990812494,  0.90845547840807472,  18.784277373642315, 
             -7.0441838872470033,   -13.526806151697475,  -11.735360490900357, 
              -18.634177215753095,   0.9696163143729728],
       [-11.515438951410976,  -13.765481544423704,  -9.4928512997747578, 
              5.8016670759244704,   -9.6689945663672354,   -6.2960196441743888, 
             -8.8040597548601554,        3.0397531206215,  -4.3272798612158345, 
             -3.0759648250197937,  -4.0772475106753339,   4.6713732014485823, 
               3.1494875447251092,   -4.3395635788693889,   3.4710530719256742, 
              -14.524182862647312,    13.226637788628707,   8.1693257068098166, 
              6.4266043049388388, -0.57766922471482873,  -14.247092970252433, 
             -6.2939467936270361,  -21.358452024500959,  0.26725548138396615, 
              3.7922465975716149,   0.80899025321017004,   6.0872975309527133, 
             -11.574807222368362,   5.4434250703751506,    8.2197639258572313, 
            -0.70835834950005871,    12.245420088569883,   -2.2495561602460299, 
             0.33670852509357529,  0.62244909372400858,     1.9137674800944882, 
              2.4253288122311969,    9.0603163050421927,   -14.633948367791053, 
              -2.1656518723723197,   9.0660401352784259,   -15.580340485711607, 
             -1.0611532305083056,   0.82560772720839015,  -1.5108577004694896, 
                6.7219835940431141,   7.1077623954172839, 
              -13.041837344824526,   9.4395815717424014,    2.328440595496621, 
              21.639371985891387, -0.54652447515920377,  -9.2136261701935851, 
               7.281763295344442,   6.3258820840774508,   -5.3725344107887807, 
             -9.5770622537472754,   3.0741135572927818,  -3.0198223669270865, 
              2.2482251018074169,   3.0693343306582941,  -13.097048562925693, 
              4.1878998473414955,    10.636984404643577, -3.9167982372520243, 
             -5.6093260622795169,  9.6698289389959093,  -14.261641216280603, 
              -23.63246984897922,  -15.339353668469213,    30.059823646065521, 
             -1.2753916942502164,   15.963130840785439,  -1.8180729512090101, 
              -5.9229569104215969,  -6.5636606745256811,  -5.3455913957642531, 
            -0.84195025113116828,  -18.490482370709834,    23.375415796773211, 
               23.759447778882947,  0.34463594475458659,   -7.4779153263138927, 
               -4.367915955215369,   3.6096832462967794,    -16.89605012652099, 
               15.957847593195533,   -1.1965007690613048,   5.4190590335085131, 
             -5.0383562723336777,  -17.722197877697653,   19.231528950101897, 
              20.850339977233254,   1.0653340825114908, -17.757957316274833, 
              4.6971515363516252,    4.4470492978150293,  -2.8873388410096732, 
               4.9960957719337857,   0.5941710682932384],
       [-4.5845484421759899,   17.609087394412125,   1.2035086603931735, 
             0.13013961250795997,    5.9280906486292286,   -3.0297843659436992, 
              7.6688864210439212,    0.49244879933223878,  -8.4729962570411743, 
             -0.9768829122375835,   4.5226571953762278,   2.1347032788238174, 
               12.031869651489004,    4.2150595612654946,  -10.700788379285626, 
               11.895656688085385,   -17.301380774729218,   4.9983342299552085, 
              4.6754011706359604,   2.4566239437735629,   19.053370252050371, 
              2.4484622599680534,   2.4558628954508439,  -22.341380657774611, 
             -16.325456506688131,   -6.3989485516457574, -0.96871946794425612, 
             -7.9617447301266173,  -1.1706097666813458,    1.7158877971266331, 
             -6.0818729410718433,    5.3537961239334582,   0.92319746572133254, 
              8.5774856679367382,   12.499213545407539,    -7.2815552758618454, 
              1.1957693876847799,   -5.8816602360698482,   -16.767994428020192, 
              -9.4536815732938688,  0.43484617646024348,    6.3065021997084445, 
              7.3636360786245891,   -4.0133666018637406,  -10.093713581224151, 
                -15.70409293338523,   6.6626033099949824, 
               3.8099079785393561,  -2.6489031362775455,   12.760021796321073, 
             -1.9457284994574784,   -4.626706107489083,   1.3072202569092557, 
             -13.160690413562071,  -7.5470878222505622,  -0.20026428944229152, 
              13.157363517999896,    2.246384233658842,   5.0643802184941578, 
             -5.9663727190056024,   5.3070917150946322,  -8.1978496542423169, 
             -1.4675573522693084,    5.3604815477886518,  9.5558441883995275, 
             -15.266865215803341,  5.8949473855676775,   15.296858811846386, 
              21.375488984553851,   8.9352925000171588,   -11.503429700611104, 
              2.5925426246263927,   3.7597583176859004,   6.6536437694605972, 
               13.886149510623497,   10.001140324227647,  -2.6094938198729394, 
             -3.6139672971934744,  -5.6090533445685589,   -2.4433270145477488, 
               7.6965676133320233, -0.78308154340143388,    1.3135735568790832, 
              -8.6644314768042392,   -6.311897146614883,    13.221590954569997, 
              -5.8076642660820692,   -1.6309392163677443,  -4.7162445355218034, 
            -0.47732406069188982,    -5.88666933667609,   14.733389486455318, 
             -2.6110170338175847,  -6.8177727158581707,  25.505909312139543, 
              10.082254829450841,  -0.43549411413535422, -0.62578086601272676, 
               6.3864213386059765,   1.2566397789630914],
       [ 3.3639118685658733, -0.56162533384178004,   9.6083270165564656, 
              8.1384429313405775,  0.082072211949525214,    1.9832505654223531, 
              10.293664693862073,      5.393672258599274,   10.431580003232256, 
              17.546165979991923,   -4.533893827785108,   21.349299261654359, 
              -2.3919414883285834,    -5.715765204652361,   1.7969187583287649, 
              -6.6725664441927357,    5.8211457897862324,   12.560526870574193, 
             -26.151329218153347,  -1.7074844794838937,  -21.454985214739274, 
             -6.6521638949516575,   17.912968512103035,  -6.0902485487915463, 
             -4.7697476765484499,   -7.1619349147412006,   15.920975632271306, 
              18.051153783657952,  -14.531302883527546,   -13.068392532445596, 
             -6.3195474798824165,  -0.51128386150552396,   -7.3557617904291215, 
              19.961222793947471,   7.1443074767004369,    0.46825777097611521, 
             -9.7800078826021224,    5.2182362414389498,    -17.12597425811132, 
              -3.3929451644388049,  -13.508230911531607,    7.4181323984640457, 
             -13.951855515184185,   -10.550859395824981,   15.040615520562024, 
                13.708254954007394,  -14.218424895429827, 
               4.9519709661806992,  -4.5577596584310465,  -8.2353667008666385, 
              11.910510743580682,   3.2505711477958994,   25.830221191363897, 
             -1.4972537855004528,  -13.965737896769033,   -13.683312307710588, 
            -0.23041506070754297,  -1.7482582292587066,   13.366244602039055, 
              -11.32776363310575,   4.8137064112341079,  -10.602153286225835, 
              8.2543212542007787,    1.3455403883774384, -2.7753241705625626, 
             -1.3054464092555707,  11.872607442614541,   11.769622667350257, 
              3.0559656220080891,  -11.606472515052682,   -2.1832062609061582, 
             0.80796396024449746,  -4.6225231131455331,  -13.809623171042727, 
              -10.151638007159345,   3.9091929399118097,   9.3880819372273798, 
              4.0621878969032474,  -6.6573754632652378,      8.47477698333714, 
              -13.614685354489566,   5.5133909493834174,   -10.712467953298839, 
               3.7700573678132261,  -21.739532236601985,   -10.089897747317547, 
              -11.849156490502235,     10.55279999055357,   7.2553057154945986, 
             -17.554979546460519,     19.2191985923935,   4.9906371375273997, 
              5.1347124621099312,  0.30207815856314008, -7.1981630693723613, 
             -5.3247814129808972,     5.689335165431455,  -8.8455615309355533, 
              -2.2528801820430648,  -7.4751851849137827],
       [-9.4196209562574147,  -4.0576634359571164,  -6.1749583579449885, 
              9.1216551548896128,    5.9532079870382857, -0.099129625578307262, 
             -16.349221194860572,     11.849057304703967,    13.72325663952838, 
             0.88926141432275863,   1.4573963597511215,  -10.060080432714035, 
               6.4856151407929001,    -11.93495542282551,   8.4698230718931207, 
              0.98874251354399134,    2.6927764310400955,  -16.199458625025279, 
              6.4040137355770028,   5.2648160112819822,   5.0204728127147771, 
              8.7365740352153605,  -12.731253843497832,  -9.5307001076248223, 
             -1.8576683552915454,   -19.166124472777625,   5.7639056730572236, 
             -1.4461065681906835,   16.330612933855935,    5.2289095205602854, 
             -9.7746029533360144,    8.3208180727237782,   -7.7680927360336618, 
             -6.2240916778020097,   4.6673503287266129,    0.14039910897894042, 
              16.693190411267025,    7.6065270297329501,   -17.281302014420035, 
              -4.0736243743653997,   6.0597467292868359,    15.754502142439645, 
              -7.712660937704138,    2.6767036779229763,   5.4618031706017707, 
               -4.4696837711075244,   3.1882897499773613, 
              -4.4608450813843463,   5.6661820608640943,   1.8420770793964025, 
              7.4145058989217905,   11.168351495558124,  -12.891389994434244, 
              15.566022210619588,  -10.064551464105815,   -5.5801132445811987, 
              14.769494619180424,   5.4308298463214371,  -2.3935482563760151, 
              13.224106233283241,  -2.6918036253765103,  -13.420741676965452, 
             -6.2710698956482203,   -6.5578183466884017, -3.6062515126780363, 
             -14.359585169243498,  15.699575631199746,   2.2571369383672284, 
              24.518812002672391,   8.1886830530151826,    9.5718048208356503, 
              -7.179818920847401,   11.006751893714036,   3.5051947826570262, 
              -15.278836423021422,   -7.661268255665834,   -6.778275421031231, 
              10.199156408835339,   1.8381208988274855,   -8.0546732351219781, 
               5.7944531509555866,  -2.3588212871127929,    13.215810293409923, 
                11.23699617377126,  0.26172343355989081,   -2.2623627085820983, 
               5.7423368565057045,   -4.5180956727210626,   4.3543205100499662, 
              10.770387719635995,  -2.0706500890688289,  -15.840217877690799, 
              2.3049648066988286,   6.5775871591492985, -12.424660553523932, 
              14.941720567138008,   -4.5750163273823983,  -21.050638847258313, 
              -10.172384870935412,  -7.6779502985369614],
       [-9.1572857821447347,  -4.3907853867980808,   4.5534665474445184, 
             -14.137500680507152,   0.36440642405302842,    20.290792289457428, 
             -13.727049440158709,    0.67803207025937495,  -19.723222586390555, 
              11.700844868950224,  -16.772212076823102,  -11.296437213087493, 
              -3.5943593488403347,    7.1982760728055926,  -2.1001068575399002, 
              -4.4961607449789645,   -8.4126982273552979,  -5.8405096758610222, 
             -20.363337368276415,  -5.9574582302528301,  -17.901108037975348, 
              6.8067459535003678,   8.1942689999316993,   10.548133164352615, 
              14.231885932661916,   -9.8933022732370244,  -4.5494795358897751, 
             -7.1691043242207293,   7.2074292521214858,    2.3989996875350048, 
              6.7487892892162629,   -2.2611703098497031,    9.2202095872062699, 
              17.033833534819337,   5.4992927890935048,    0.08248126368957992, 
              2.5459077162132324,    4.6458808564911731,    15.502053982912168, 
               12.171394074428893,   0.6619544975308107,   -3.5775082182662703, 
             -3.7166902456708817,    14.805745958520454,   6.7996637764795196, 
                10.696600303628625,  -20.020777693598447, 
              -18.421528112095643,  -16.535301676537593,  -3.9116909290580626, 
             0.31454205023729942,  -7.3654678048329361,   15.180791953748709, 
             -16.301071903769987,  0.35183836267694107,    7.1033762580459161, 
              8.2268047483187274,  -8.3129930345943155,   -16.40059436028638, 
             -3.8699976047413238,   13.609714473499444,   18.896684727720327, 
              5.5224661712145808,   0.31589595536281551, -8.2052256234608105, 
             -8.5583098667127224, -12.973051709723187,   -11.03905521984235, 
              3.0983851478983375,   10.141141569560668,    16.530242382094844, 
             0.43285001207839124,   13.927279575073612,   5.5716195236185531, 
              -8.8497135172789747,  -22.386049785559425,  -10.314618209577851, 
              3.9836557785784645,  0.34852795194511099,    11.957534865259301, 
              -17.588246446084131,   8.5776103563334996,   -24.037863166257299, 
              -3.4646390135760434,   5.1539907736794266,    5.4389429481283313, 
               1.7178461504059597,    13.497434384813335,   12.723768854531318, 
             -13.235603296637597,   9.0800866692969482,  -1.8449383981318801, 
             -2.8412989238952067,  -11.325153019498186,  10.780915628368039, 
              5.9882761612493765,    8.4957511152520553,    22.52012225374488, 
               9.7078742728455776,  -1.9122172602619245],
       [-11.085481191813486,   -8.797147009483627,   5.6047597889102292, 
               15.45523335038407,    9.8966477491456715,   -8.1672607302595104, 
              12.495037999960445,     10.002211356587356,   3.6720458239850728, 
              3.0948638811953675,   5.7126610080001585,  -2.5479313920108209, 
               3.3675600945971427,   -18.139593181852032,   3.7512608193666601, 
               17.486955782034769,    2.0292010199971515,  -25.007222922532112, 
             -11.987928763696056,  -2.1550180271067325,    2.192665977934507, 
            -0.32831256892066807,  -1.2062040355890467,     14.9761734851773, 
              8.3985888415462124,    7.7726431685818254,  -3.8261989169772486, 
             -11.342741497603059,   5.0159849057091659,   -9.0238459576202761, 
              15.621896124371277,    24.046678087667274,    4.1553011428539293, 
             -25.141623422593845,  -0.3048581172569525,    -11.534631946369691, 
              18.463031035156071,    15.284140327423867,   -1.1245444581065955, 
              -7.4143280352793441,   4.4085878843242918,    5.1120279618348672, 
             -11.980116173522422,    -16.18266465246402,  -1.2567645126775489, 
               -11.487258239425495,  -1.4772320603187006, 
               18.670830100117801,  -6.8718277285549032,  -11.656085906553891, 
              13.365423532098111,  -2.4715563641851683,   5.6536613243465261, 
             0.22633504324618636,  -3.9799312593963232,   -17.761200275759741, 
              15.327910371336317,  -9.8601469197193765,   3.2557489227023222, 
             -1.1294707419769163,    11.07518309119637,   4.5836319897144007, 
             -2.3312454281932684,    10.346436822485913, -4.2394564592659467, 
             -15.629255546755187, -26.998668724547539,  0.21239170743115604, 
             -15.773408073675155,    7.147382623408669,    1.1584866593065608, 
             -21.112623175169205,  -4.1694698951357854,   5.7166353779735646, 
              -11.344297540854811,   16.198717669783051,   9.8472901001801478, 
              7.4529138242420832,  -2.0445795268893354,   -11.453710069862787, 
               1.2348384828907308,  -12.081995090558909,    1.5716650171245348, 
              -4.0593470459663124, -0.11132972363663554,   -3.4105654932972067, 
               8.4352688896302332,     -24.9945877226329,  -5.8573035232825994, 
              21.324810131377212,   11.849780301515413,   -12.69500980513415, 
             -4.5847109478744343,  -2.1148972742472125,  8.9882728598804977, 
             -4.9042470698234935,    10.467351787842738,   1.9121400671623143, 
               10.478301766039777,   11.369578166920459],
       [ 4.6644135283434549,   20.156102305066113,   14.009970809267871, 
             -6.8171407704231823, -0.076678368844510347,   -4.4521587296846095, 
             -2.6271376562584381,    -15.794085749611462,   8.4516536752004807, 
              8.4678494813373071,   8.5858304225764162,  0.33760804097389963, 
              0.10620682558601767,   -4.4247226591234607,   18.644383855667016, 
               16.789940635879905,    7.5915470038946662,  -3.8139674263040884, 
              4.7659462521024274,     9.48313463117392,   3.2038389605293567, 
              16.405529844437602,  -7.5000410317576796,   5.9379555814406713, 
              9.6997541640477625,   -16.776395550476646,  -6.6836185899459313, 
              3.2591973727380488,   7.8096399393726754,   -14.409402434230961, 
             -2.1016396737012983,    -13.34708773460175,   -17.377552195150965, 
             -2.6629499160811565,  -26.617913945491246,   -0.29551955980476258, 
              11.624813533320131,   -10.188098118631579,   0.25959727566673763, 
               7.0562599518147584,  -16.583334581308804,    4.9715032783712862, 
              3.0963209159556211,   -23.252709524784617,  -11.585999820905622, 
               0.89328875979489786,   18.510280776442638, 
              -1.9319322670596719,  -12.551668577700422,  -9.9559954741584473, 
             -1.2360383492076785,  -14.990619130207996,   5.0110362882599198, 
              11.400808642048453,   1.3414150846101998, -0.012150953206234327, 
              2.1502475757400887,  -15.133983476915249,   8.6607856836904151, 
              5.7522964000359345,   7.5257934190918361,   4.2279977719278392, 
             -6.8540615302045325,   -7.0991663966026213,  -4.958004171568942, 
            -0.24291376118501695,  4.6008010271968738,   13.543520466897572, 
               7.165110888344226,    13.85956996904673,    1.9774022360238646, 
              4.9848728959529733,   3.9757669257715329,    0.209317302254315, 
               9.4265390479443365,   5.6655786580763987,  -28.289209400600988, 
             -1.5256747993543112, -0.68678925213260222,    10.534466242061612, 
               12.605887724176085,   13.632287785309369,    5.8608493658710712, 
              -9.9193537083869927,   5.3356123248006826,   -3.3959476063652554, 
               18.862321670781615,   -6.9063753943737503,     25.4244501722103, 
             -13.007203221309137,  -16.791974475339831,   2.6285254710848887, 
             -9.0559278495832967,   9.9964799986212221,  8.9925646176022376, 
              9.9425891413204006,   -3.7463544188216029,  -4.6588847621769771, 
               12.700693396507088,   4.7957741966244232],
       [ 19.026568950026409,  -10.025744888462372,   12.507314067455592, 
              10.996963633281728,    7.2105254110408712,   -3.8261359816830232, 
               16.57963812889825,     7.7750971511670048,  -11.040112746583297, 
               4.780268298087532,  -13.148307186079284,   4.0987569857811161, 
              0.71517155205659144,   -1.8158347561038384,   1.0915000753178532, 
              -14.802004718821147,    8.2599629215191328,   6.4675546388332812, 
             -14.115901487728886,  0.29265751219407377,  -2.7826286023915574, 
             -5.6318128898577076,  -5.0900674815284441,  -7.5616975339388413, 
               -4.96960652384562,   -3.9766010211070384,   4.5530260565533611, 
              1.2133106629812715,   7.6896018141008318,   -5.3806353208897404, 
              13.709219848172387,   -5.0774008366648147,   -9.6718835986958549, 
             -19.385181172123303,   13.502313826772696,    -9.1712305296923642, 
              7.7122389244151428,     3.064803482113784,    -1.667726414267894, 
               18.072966780856124,  -10.825653310315246,   -17.989717512621102, 
             -10.392371358767718,    4.7436016968673913,  -5.9372469388682987, 
               -10.203962443515186,  -12.427400298838728, 
               3.9813966462300114,  -11.138815427654853,   5.4502922520101027, 
             -7.1939167280187633,   7.8198700803911301,  0.41806652664185062, 
              3.9835620765984938,  -7.7901145438393282,    14.256865893543871, 
              16.443600465697962,   -5.576495172031656,   7.5014779821186881, 
              3.9778979763172058,   1.6594990752547694,   9.4468604308450352, 
             0.53079649886825131,   -3.3747669085627989, -3.4582033960630509, 
               15.01305810859882, -12.685221862793526,   -10.39219177565468, 
              2.0804317449676537,   6.3530648095898474,   -9.4734869755170994, 
              12.656353342008265,  -4.2010002091234693,  -1.0962429071101574, 
              0.93707245588371679,   4.8593930285480909,   23.668714008448145, 
              15.153253571104779,   13.029031591263019,   0.85079692408776131, 
               4.2433525056834789,  -14.224156046424206,   0.60321444374782895, 
               15.657392620115345, 0.080116262927746734,   -1.6761685440011564, 
               14.968987968587724,    3.8904996809138832,  -0.9998092942741611, 
             -8.7201004441032524,   8.0020428177559815,   13.953046381489946, 
              2.4431884193003381,  -17.296662360808103,  3.1803262086440527, 
             -7.8069761148530503,   -3.5805835089795752,  -2.0942882328308619, 
              -17.428142402778693, -0.11115990384053689],
       [ 3.7156972803156672,  -6.1337333178729132,   10.363809074745641, 
              8.2313734787514328,    3.8510110351899263,   -10.169685473961643, 
             -8.8784887769802818,    -17.156803267408559,  -5.3977753587851938, 
               12.37986382299823,   1.6799480755035645,  -5.5807244337928452, 
              -21.222546233274549,    4.4096224191195841,  -22.651265403872159, 
               23.379416843750075,   -4.0541607191926134,  -5.0390747098422626, 
             -5.9503441068104577,   2.3655869824026894,  -10.128598892872176, 
             -11.550876774873657,  -4.4906099006227835,   8.0074691149878969, 
             -1.9794565870786285,   -2.2201825999778628,   26.637786252205245, 
              3.9445248489035056,   6.7499739944759396,    11.894697925388762, 
              2.0649494963333135,    6.7466602771849313,    6.0850421130486012, 
              4.0487663745115663,   1.0363263218798175,    -4.6506634564886671, 
              1.2698555104418163,    4.0042873157840884,    5.2937659562601045, 
               -10.15180581905431,  0.46022374952756362,  -0.46453527637117636, 
             -9.9304264005045617,   -5.2442915337072469,  -6.5136269532703972, 
                12.961793880022146,  -29.932806954156753, 
               16.640389947749203,   24.453866928646924,    1.474328589423527, 
             -5.2422722491602318,  -3.4262938997912205,   6.8339103203602516, 
             -19.410725500494991,   10.821763954756776,    10.161282614685692, 
             -9.1960558044943923,   17.673689025160499,  -4.1884877488160024, 
             -3.5206378428816008,  -1.4781659149681645,   6.1746984710074129, 
             -22.455524108007346,    3.0750032256997644, -1.2304575020353288, 
              12.766290328867662,  5.8704853342729173,  -8.6257565655360882, 
             -12.256660138205991,   -8.397898264662599,    9.6714009418966214, 
             -4.7462011347167303,  -4.8142511283414766,  -19.304951793799454, 
              -5.3807219532832828,  0.37420299426327408,   5.8053912591109214, 
             -10.409787291599537,    1.166654029164425,   -24.903590206812328, 
              -1.6592765628890414,  -6.5726585516805098,    6.0387143407668713, 
              -12.994544218741243,   2.0793240734003748,    8.7994285914080592, 
               6.1649509629849906,   -10.113113257432859,  -20.759171593499929, 
            -0.51970735905793541,  -1.2490503962400035,  -3.9631261966335081, 
              6.9059112130718745,  -4.4510653386087116, -4.2448631680309576, 
             -12.625770629548462,   -19.392925058709036,  -3.8965454715551147, 
              -5.0361388195960641,   16.952756451775727],
       [  7.277659586751529,  -11.574645947907896,    6.858725290126567, 
             -5.3854729284186416,    17.275506121065526,   -6.2798168758798862, 
              14.677159081010201,    -7.7984919638075052,   13.373355439965236, 
              1.5632446291644608,  -27.720620094679482,  -2.0328103631710994, 
              -2.2601411754437013,    2.5014454204717049,   2.9057490248674469, 
              -9.6807497086212724,    -13.90321520036073,  -4.7907431740938087, 
              3.7644306857629521,   17.039229731568867,   2.3198085154565988, 
             -3.4144911629221348,  -9.0476200690510105,   2.2740669326281622, 
              2.2145954824814589,   -16.002330369999399,  -2.2640173856243924, 
              -14.15120428493476,  -10.312594025810309,   -11.343552682100926, 
             -3.6419598543237535,   -4.8435155838528461,    9.7670500857823868, 
              3.7848613977558259,   2.0204557652781228,     1.3943100519605589, 
             -10.385695405336046,    -18.31556864945723,   -7.1580840824499612, 
               2.2507868712598427,  0.16526927782255901,   -9.1841297039632384, 
              14.534859538337649,     5.592132567198739,  -8.7741051947172117, 
              -0.67791918469280288,   6.5598285214332481, 
               20.332932048878334,   26.478889451533117,    16.00586872993031, 
              8.5916155599762032,  -3.4061058042505108,  -1.8766493018573629, 
              18.693439175452905,   6.9273317114594644,    10.085019640338766, 
              8.7355664266297346,  0.28225123328312862,    10.52155394637591, 
              1.4804423012688197,   14.245376069116336,   17.409840908730661, 
             -15.119563878064824,   -19.206720314162908, -4.8911191864701697, 
             -8.7712126791851048,  2.8683130858395107,  -6.5704538503848688, 
              13.379560385080659,   8.9601672691014187,   -1.3161803512977097, 
              9.4746326369341176,  -7.8267525248374037,  0.61144563561601373, 
               8.2009805130833797,  -6.8648650782934437,   2.5310368332384323, 
              15.231874855434137,  -6.0799578232569402,   -14.257946000872471, 
               7.1755682462795196,   -9.045887102108022,   -10.434290663924283, 
              -23.108389468692529,   10.430605310986623,     11.09865403159411, 
               20.175238283742299,    12.234348652283572,   14.245563477318965, 
             -3.2351040013074766,  -12.521661741128353,  -25.741488235791259, 
             -28.699122511190886,  -1.0937819268429703, 0.95844584838244706, 
              15.472893376463814,  -0.32161020392250106,  -5.7385564807416696, 
              -6.2494252258430585,   1.6654691755135065],
       [-3.0888174884190231,   10.654638783354853,  -16.350609191761414, 
              10.709278929609098,   -2.8773829716010146,   -8.3310846064940733, 
              3.5631705884332887,     9.6844700529841816,  -5.6620550079960372, 
             -17.796716437807014,  -19.702827435719097,  -5.9766943626287015, 
              -7.7365399033784197,    9.9623024663118205,   1.2908445630320922, 
              -3.6358619026019618,   -3.9107239272477523,   7.2686918251859201, 
             -4.6271182042633177,  -3.0890089126177718,  -10.446089158052434, 
              -6.643927663775032,  -11.767957162151855,   2.7678953963699051, 
             -5.7791752801876921,    0.0860583101805696,  -7.9823291673359478, 
              10.914772040253958,  -17.140490700643856,     11.68328208349217, 
                4.69309705091952,    15.418538159213092,   -2.7354989433015735, 
              22.550176097351088,  -4.7855979393241741,     -9.004404574593746, 
               16.89645643983221,   -4.7754151308641362,   -6.2642281126565145, 
              -6.7268853746388233,   1.2058306670971926,    23.106775393127222, 
              1.5993006480126093,    1.1498170295712364,   2.1874563602625923, 
                3.3851234613239263,   7.8362193000418063, 
              0.47885213287165934,  -15.196366338924825,   10.120497512256058, 
              6.1177029480988976,   7.4011261573502516,  -15.935943970549033, 
             -13.746674754719532,   10.917010645432143,   -3.7285660601165933, 
              15.650209734332396,   -5.493474249639724,   12.205267028288787, 
              1.7776945646788744,  -2.9846838702717058,   1.2436948804762709, 
              10.687806091962532,    7.8304390306340741,  9.4426933460315272, 
              4.7347540295204791, -11.281842393504656,  -4.0870814152972139, 
              2.8895655317698483,   13.739780635021591,     11.67793503393656, 
             -5.1913078559180761,  -12.708043844235103,   3.0959606773683679, 
             -0.39045334637529083,  -2.9085240668250152,  -2.3896524679619038, 
             -13.154108730464234,    -1.09345561044187,       0.5348191038715, 
              -1.1895920118235259,  -9.1640276286504019,    2.4412802829882758, 
              -25.722456645611285,  -6.3820430048844354,     10.43248897348403, 
              -10.361170040776379,   -3.7319204448557519,   1.0441750682648352, 
             -4.3299304490435802,   10.217119183344037,   3.4320136083315349, 
              -6.834409351950308,   2.9776918332413005, -4.0655954521074991, 
            -0.85934830370131743,   -2.4812045910080021,  -8.0611291419134599, 
               18.171754858909924,   14.665950190640761],
       [-15.734415545601211,  -4.0834892672118768,    9.643545609731035, 
              4.2488581432639192,   -4.3786582674527903,    3.6274060091151079, 
              17.509846478701466,      15.51500237908658,  -7.0008279606205246, 
             -1.0181481588627204,   11.411304876481637,  0.57395350215393681, 
              -5.5448207133660663,     -16.8503949540946,  -11.547545226731778, 
               6.2467778017788502,    -7.344679215783481,    18.11154673003999, 
             -4.8210032548601482,  -3.3261404266259449,  -1.2226955627617584, 
             -13.540984093269552,   -6.827039158882485,  -9.9989227966098877, 
             -4.4886730554836856,   -5.0057125350683496,  -7.1415869275131127, 
              4.8989827354149389,  -14.023474701193997,   -4.8730445299958474, 
              7.7614847837645566,    14.970948823284543,    -2.826056070321231, 
              6.3590660268936023,   9.6671510786064268,     5.0506885617750861, 
              -7.640312225703517,    7.8623685028274251,   -5.4455384820172696, 
              0.64561821698194244,   3.9701262790216258,    1.8266667067963365, 
             -10.017411662738374,   -7.8036446492777038,  0.68681268262397943, 
               -10.731492975485139,   8.1856466856002292, 
              -19.059288038439007,   3.1838241920705634,   5.8436158841273942, 
             -7.5912134963238849,  -12.505235350875195,   8.5820607877804491, 
              11.243071221675699,  -8.7504003306971399,    -1.793385163699359, 
             -11.852351833232781,   14.842780296007374,  -5.7136031983698876, 
              5.8732638446396592,   3.2712917830167392,   8.3753391235538501, 
              6.1748129462990677,     8.833616214942877,   2.623160535031404, 
              4.2274785565773021,  5.3379542526457149,   18.105825806272449, 
              24.681333877454001,  -11.247201749492683,    14.740184406948204, 
              13.218899597588432,   7.7711464801791239,   2.7515330403431064, 
              0.17015829885265782,   3.9005138975872056,   4.0453052915129559, 
            -0.48296806012793847,  -12.364891376025341,   -6.0636391727348773, 
              -8.1694931473106145,   6.4687291976564723,   -2.3017648120612457, 
                21.04630503647877,   6.1223153471944141,   -3.8074403436218924, 
               1.7064425594131416,    0.1641214038913513,   12.011384713340318, 
              1.0031839789755148,   13.906818186612375,   6.2008738509237817, 
              2.6703796390903123,   3.5619775221400802, -16.786780503155839, 
              8.3040475880359761,   -14.420604680318931,  -3.3013202298461231, 
              -5.5006522695035187,   4.0033413423122344],
       [ 28.195673757733495,   18.655721826857775, -0.86408968066950709, 
             -10.780992201274342,   -10.503533318179606,    3.2284943268844213, 
              1.1619974672118736,     2.8329865818080044,   3.2757885956466986, 
             -12.539611178472889,   2.2918332977177132,   5.4860873137775226, 
              -5.8967866982525905,   -10.093415100894767,  -16.036302841432303, 
              -8.0348057691248389,  -0.85957815053370612,  -9.6275602804544853, 
              10.641350716643148,   -1.197356798796678,   1.6620417763335045, 
              7.8546995280572638,    4.891459102451245,   19.016720659524371, 
              8.0431652878952153,   -10.202849383178744,  -5.5155077212280803, 
              8.8042863794546324,   3.4407823937213871,   -11.703691292042924, 
              11.395595674977832,    -4.417542263994835,   -11.563572009372397, 
             -3.7216556419012523,  -17.756526636215227,     5.6872338201049333, 
             -9.9220498227504468,   -4.1002976520098713,    7.2134602983471376, 
               2.1734957821744776,   1.7220042098626884,    12.932237687268266, 
             -18.848358261806709,   -10.877992332742988,  -7.3160439225461733, 
                5.4485580884013451,  -7.2997925967046573, 
              -17.075937179416915,   9.4802233076703626,   9.6577880472633932, 
             -6.5918203353816818,   7.3974549957054636,  -3.8394573843591924, 
              1.2005513798844671,  -1.8013530013894039,   -1.7909390482657876, 
             -1.6734712945594501,   21.360796048181609,   -3.577956990275188, 
             -23.360388932782055, -0.71656701966076897,  -5.8812760964384045, 
             -8.9456573524049965,    7.1566633768174945,  9.3229188991883678, 
              13.991327979653024,  6.0576478996947101, -0.89312852415907229, 
              13.631633255631545,   14.962421624360651,    12.331194757447284, 
              8.6515067593138628,   4.0493976890940608,   10.708346539931117, 
              -5.6453415083482481,  -12.268867430217318,   7.7794735429569739, 
            -0.94773412979453642,  -14.848826208929973,   -4.9430193743394799, 
              -7.3211224964750086,  -10.382362255947072,   -7.7361887621738443, 
               5.2930293485177415,  -5.9397549214619572,   -4.2815324876355438, 
              -8.2342025994325638,    12.357936427329506,  -1.5963852304006445, 
             -9.7577043985762302,  -2.9608933528099919,   15.444439920605193, 
             -5.3244286164241759,  0.13816197306888794,  7.8995732515693016, 
              15.366954555621868,    9.7952103135204389,  -12.000605530991937, 
              -1.2932699558492653,   3.3338135442956327],
       [-6.6693231350856585,   5.4402334945539996,  -9.5270794532859906, 
            -0.92394317067484155,    -4.169318802724499,    6.0200549902157521, 
              5.5022272462147068,     19.581294798968187,   11.264014506254135, 
              2.4248915084449503, -0.35376089842022679,   11.928092189474564, 
               17.555854204593253,    -4.356218976923584,  0.96347042634404356, 
               -3.460161301237989,   -9.2102216671509662, -0.66479809941381296, 
             -2.3402069855732313,   13.431454706985802,  -15.295273070107338, 
             -10.092222920970011,  -15.391440004750951,  -1.1109856614762526, 
              7.6704377588722057,  -0.83068585733426104,   15.733268331059202, 
             -2.4657932738431882,   1.3084270270417206,   -2.3414095620866022, 
              2.5714398103502463,   -12.286184550332331,    4.3927336038209051, 
              1.9020659035706569,  -13.165807553667392,      7.421061657466149, 
             -2.9481208344596692,   -3.1734331604871917,    -21.15320118952512, 
              -13.384451121342192,   5.4069537970667678,   -13.686353029196191, 
              -30.83565630859372,    8.0652858841951183,     1.33789372896325, 
                10.311233112900858,  -11.282512308296122, 
              -4.5602823757858495,   7.7756811549427143,   22.337297163346101, 
              4.0309615517963477,  -10.993104211385646,   4.1862994225331169, 
              5.0591726288731529,  -14.955307008323381,    16.556565219139063, 
             -13.759579198197541,   14.903184685430361, -0.47223293969649355, 
               3.591161304023704, -0.90897107625220197,    1.118638711941315, 
             -10.888696347777971,   -15.061722186244353,  2.8753781286382107, 
             0.30922281096605547,  1.2452970280943718,   4.6136122628825822, 
             0.91936634891672808,  -3.4807160708187572,   -6.5717836485575445, 
             -4.0210553782734753,  -6.7698076894132608,  -11.579809254606502, 
              -2.4944889595610094,  -9.4470967236214189,   10.739848969570563, 
              5.4392901159650275,   7.3354859834561683,    3.4132030241238547, 
              0.36684822068250345,   3.8788471622334821,    6.2077629478887184, 
               17.510777405457926,  -9.1087242553051517,     19.94329501829905, 
            -0.077210932812176197,   -14.446629742569247,   4.4987918313089326, 
              7.3742297644588977,   5.4581503777658016,  -4.0749311246174722, 
             -12.219917729716126,   13.955418192957401,  13.309009151232669, 
             -15.859390475348565,  -0.70658410294093521,  -6.2936629124691894, 
               6.7972627586238632,  -27.271912935042387],
       [-7.7961347055746852,  -9.4226457543779993,   12.284438906197634, 
              -5.809890986242463,   -11.344581837754074,   -10.722634278194649, 
              9.2342779214670774,    -11.313808797718503,  -7.6667260283830396, 
              10.338317018160474,  0.11104081203081041,  -9.0107021621305545, 
              -5.5221811415491224,    9.8091673178934364,  -10.123600382467991, 
              -3.7708630883216521,    6.8797353800157417,     12.6623533696566, 
             0.24163044695764749,  -20.310526877766904,  0.18025773217267088, 
             -1.3319846013734824,   8.8337850964377864,    12.68653430751003, 
              1.0087020718367778,    13.560505661711488,     2.67452099250387, 
             -1.0827119717539122,  -2.6363105486267777,    2.0320535785941338, 
              24.659280837461299,    13.195503672495681,    9.4671660947191878, 
             -15.049849484826286, -0.85096116794332388,     2.4752997880931091, 
              4.7067972650107697,   -10.667748669282631, -0.023514851345281442, 
               11.596326948126057,   6.3801160236544465,   -1.4662355393836999, 
              6.1403800500168266,   -5.2053518165136303,    25.40013786986416, 
               -5.5829695734160323,  -13.070672848652588, 
              -9.4928899946223684,   12.292809909038549,   3.7152378208508638, 
              1.8712880119503641,   -5.884560155634281,   2.0505087734032741, 
             -5.1626385779666526,  -6.1848670799766969,  -0.90179780703198997, 
              6.7299982935287206,  -1.7684936770686925,  -18.972229856578263, 
               8.051040343359837,  -25.123436759908131,  -4.0490997454353321, 
             -20.512777200409687,   -3.1540962179397787,  2.6815842571835713, 
              17.160067057663792,  8.8405403976403569,  -10.515945179813674, 
              3.1242218906092507,    2.039377805822868,   -3.0794495574346303, 
              1.0150847196563486,   9.3425664638576116,  -16.064164624918597, 
                24.85919029743129,   14.598951594612386,   10.678815374426572, 
             -10.866167881443138,  -7.3302896576112522,    5.4841223545179201, 
              -8.0929088920296124,   19.012689291103126,   -3.5889100106205301, 
               2.5737610980945185,   6.3918693434645064,    5.5697779255838187, 
              -14.078371211450945,   -10.416246076273993,     6.98419031591982, 
             -1.1389721746762282,   6.3246634244838331,   10.453869129047842, 
             -2.2982927710207623,   13.802483937174173,   8.836021644118734, 
              3.5555997370950414,    1.4406210609880754,  -10.237039442348195, 
              -7.4244834225593586,  -2.5484056421610051],
       [-3.2884748667132357,   7.1391920882037692,  -3.4270235050035303, 
               4.229805930960592,   0.55604061423090567,    4.6109404978958404, 
             -1.2578485972928788,     7.2838397520337335,  -7.8667527638453025, 
              11.077627773294269,  -5.8773996853091539,  -1.8561247035184458, 
               5.5858566403990935,    3.8674776019194863,  -5.9527787272679031, 
               9.5586906448119073,   -4.0808831308158151,   2.2239360555643084, 
              3.9554345992589406,  -1.8669670218733583,   9.4753477083445325, 
             0.76863475628556988,  -2.8900415265662889,    -7.22950062416073, 
             -17.509282722502654,   -16.592309184013978,  0.91976250902090706, 
              32.537389136769072,  0.91536503908195099,     7.056534874193404, 
              5.1449122336377107,    3.7929582953944689,    4.2477294078912289, 
              3.9738548238538107,   5.0835306127222593,    -7.3017612920878951, 
             -1.3210539252583975,   -9.4170785374182095,    14.611474557271082, 
              -16.369249296573098,   14.198212019274841,   -14.204630716358031, 
              16.032391243689592,    9.0315915322923228,   3.0980446715304373, 
                 10.87872349272301,  -17.290320593594874, 
              -28.991676238635197,  -10.489786883197265,    -2.31323890543919, 
             -28.397812864505557,  -2.2798378830199422,    16.07192405293987, 
              4.7057174802868049,   1.8309721198781295,    1.6178351390674595, 
              9.8674452402183679,   12.899194729094592, -0.51248053829870466, 
              0.7343739007328508,  -6.3280310219830564,   -10.19392593282239, 
              3.0597995676448146,   -9.5628007086671456, -17.244395876567374, 
             -14.586403090671322,  28.096244284827023,   4.0217937039389389, 
             -11.647939987879468, -0.48181066673233686,   -6.3466510139573726, 
             -7.1545004178593157,   2.1787539174137054,   7.4890785117847347, 
              -2.8657057030817992,  -9.2248534071449235,   16.235857246645935, 
              12.612951378138131,  -5.7723043411912869,    -9.424865678699879, 
               2.6749417407600355,    1.546783192913914,   -11.034268093583961, 
                1.631381637976816,    3.709697383801549,    4.4657179356686534, 
               4.9813474363949393,    6.2365891350129754, 0.085282151425926794, 
              14.865696575210087,   4.9211586201989563,   21.767966449412995, 
              8.9191037079334894,  -7.0755265081174006,  4.8811202459264491, 
              10.989586383852455,   -11.419201227742064,   -11.15281463975963, 
               14.492876838158759,  0.21164629054569178],
       [ 12.719222151219995,  -11.705779366664384,    9.108278375406373, 
             -6.5838804304938625,   -10.768944125117581,   -4.5211794041364302, 
             -20.718289064841123,     5.1089215519722222,   10.469262523492377, 
            -0.89262034585692585,  -5.0368921395487201,  -3.6010600744224428, 
              -12.653366165418376,    17.185420964844695,   12.362278410964828, 
              -26.449060591366095,    4.2294630866200604,   1.5840995778979285, 
              12.148239610164941,  -9.0993336371100959,  -13.819804100999738, 
             -2.8940189462052457,   5.3591960035491173,  -12.235947586829635, 
             -3.8587648673114301,  -0.45349249566362448,   4.9163352208624174, 
             -14.646764857863747,  -5.4291674368282639,   -5.5519296925343333, 
             -22.115078138297037,    2.6574279829719427,   -3.8136279198015433, 
              7.2039656695970322,   4.6327082518527982,    -1.3786526370638281, 
             -8.0575540865650659,   -3.3968056092468006,   -4.5044954955419261, 
               8.6966626811273713,   12.958530021788292,   -21.472329408134122, 
              2.5816042324711361,   -4.0193950709296002,  -10.547079226465685, 
                4.4095843693086056,    1.629688887193312, 
              -3.0631092627279788,   11.502356427535927,   -9.371638859020667, 
              7.6074680040708609,  0.43826629132316453,  -2.0671169745435112, 
             -11.504587811888776,   9.8998728692105047,  -0.66207929138260724, 
              21.308229323242045,    3.062198438170423,   12.056863788994344, 
              -15.34070384043542,  -2.0464576127427279,  -3.6376770871571136, 
              12.802987922247038,    3.0356767846043828,   2.247954585387185, 
              15.895676290669281,  6.6075144750530033,   6.2107311545494674, 
             -4.7932296854247971,   6.1508152180975628,     -14.0882612764714, 
              1.6302005809349784,    20.50091127873181,   5.3773437118489307, 
              -7.5077823991065227,  -3.5777177204184269,  -1.9196641929995071, 
              2.9968168238860997,  -4.3504721936170858,   -15.854273183438545, 
              -12.898325917440356,  -5.2941387436386043,   -4.9282969030934991, 
              -9.1305875011172049,  -7.3516257891421244,   -9.3845510480966823, 
              -1.6906164677339084,    7.9966307371252476,  -7.0073837899737708, 
              4.2656563044387221,   9.9431322572131347,  -8.0715524654665245, 
             -7.4288724320320281,  -4.6361732975858452, -8.9787060185580714, 
             -13.581190565447043,    6.1049634919720939,  -17.059154466412767, 
               6.6158560236583739,  -10.156325100147665],
       [ 4.0514201135990744,   1.0945529237741052,   -20.86725354782256, 
              13.792095653424894,   -1.9206800883457391,   -3.7322890763009871, 
             -14.255193211243036,       3.01211374974149,  -7.7907027219237621, 
              -9.639883488080347,   13.984837531077947,    -7.77517415274085, 
               18.646772186278277,     10.85755061340636,  -0.5240716922209705, 
              -7.7523985355290712,   -9.3559687446054767,   6.3356718123455966, 
              4.5281577676253404,   8.6508402915078797,  -7.4168719282577271, 
              8.0952033810949455,   8.1246612849311433,   5.0499088200576221, 
             -8.3981475507047492,    2.5188227023091652,  -6.5126217098508903, 
              6.1885184439721748,     9.17803813021842,    15.815477238284529, 
              14.499127862382027,   -13.273226220865258,   -6.7166988360122932, 
              24.863483159675873,  -3.9892779990414611,     5.1957523752421828, 
             -8.3247996613847022,   -10.677608890429536,    -2.042874194511576, 
               8.8297560096751795,   -16.09815552771029, -0.031744396165299574, 
              10.005087693366541,   -4.3962036030781171,   25.389531091128184, 
                4.5513934161747631,  -17.061358823836557, 
               10.652309712963168,   1.8177793864818765,  -2.8549189187790818, 
              -9.795019950285047,   4.5374583436330482,    9.937912817601779, 
             -3.4436111286036213,   7.5814178245001287,    1.8497441867902009, 
               4.327662554056376,  -2.6867206517297086,  -5.0289164758955884, 
             -1.7007017138998926,  -3.2859598142518029,   1.7765545454159393, 
             -11.097419781638358,   -4.3739936445020291,  21.640254487987164, 
             -2.6532710877560959, -6.9762613495711534,   9.0391574987362002, 
               13.11159261065535,  -9.4792962830548468,  -0.61710867680199311, 
            -0.30486863216679644,  -11.344181026481214,  -7.4353267098983125, 
              -2.0573777879105632,     16.6725860318904,  -22.250905394235531, 
             -6.6430033091219434,  -3.6330768107517404,   -9.3135837217816704, 
               10.651123051080154,  -21.735319644675929,    7.9422018280196758, 
               13.702984236676595,   18.665256835331125,    22.715967642775606, 
               8.5536881664179649,   -8.9922500488435304,    6.387657053582644, 
             -7.8884897627248876,   2.8013726588281678,   2.2195429628559822, 
             -11.174598186283022,   11.151117091195523,  15.587592680075726, 
              6.6673313742117717,   -8.8354249241264071,  -3.0386303592779833, 
              -14.687407848977067,  -5.1834750981038962],
       [ 5.5737110545012047,  -1.0546938266996462,   11.106222784322547, 
             0.64593786059916525,   -12.941423620283327,   -10.687230193148524, 
              10.937857905273718,     4.6585862433034357,   4.0808111284032034, 
              2.6918808620331007,  -11.505662839325623,     3.97755301845427, 
              -13.770043594534517,     1.056933919605755,  -4.0503641135261326, 
               5.4991491699714112,    13.805502079440275,  -11.598596713611698, 
              4.7328813821963367,  -6.3086738345162363,   2.3321687021882127, 
              -4.193351176450042,   8.0160264659005751,  -1.1288123403820174, 
              3.0159162342492629,    10.761453282058589,  0.11338373792954165, 
              -8.351500900107439,  -0.8712959561952005,    1.0085220716179037, 
             -22.205503131851458,    3.8851570039083456,     -16.4478136955209, 
              4.1204365573458936,  -9.1541946352235115,    -5.6594738463250591, 
             -4.1796729783890143,    5.3274901669941688,   -2.7959520669320055, 
              -19.557418417113858,   -4.122403791134353,    -3.904102468242765, 
               5.476145233896121,   -0.2174817815785221,  -11.358981018756356, 
               -8.5204717490011674,   21.432117179412447, 
               7.7953605411156301,   11.806210842077277,   -15.33391658099246, 
              6.6082864151503928,   6.1270735685538522,   1.3516914071079942, 
             -6.8018199253591751,   11.185335753538084,    5.4589677605904887, 
              -1.644393858410548,  -2.6819597334821559,  0.91028774187467187, 
              6.4766286622862701,   4.9761693725037288,  -5.3124883802430372, 
               10.70903512917765,    4.8694333499866458,  9.3804283269967463, 
              16.576956026390143,  2.7986325596067587,  -4.4197601909897903, 
             0.84220434310522463,  -8.8398315487308956,    5.6889283962232318, 
              7.3031736850358975,  -7.4708902413047795,  -9.4892531221459961, 
              -1.5323745100325949,  -7.9280297063081591,   5.5167779168586639, 
              10.837501261896506,    8.509823603142765,    3.6825676723563117, 
              -5.1346289415408037,  -16.136370079431895,    5.7892347762170902, 
               4.8560118617034522,   10.738312949827858,    5.7658279776968024, 
              -18.691701508280346,   -8.9179215202533406,  -9.2615393659861684, 
              -13.01871424339598,  -3.2047238798309663,   2.7049976832934828, 
              1.9638068061048322,    2.773520936680745,  4.9541633978479682, 
              7.8771248776693579,    16.037964651606298,  -14.584029932249011, 
               5.9378522091618287,   6.8717561651154107],
       [-13.624952548747309,  -4.1888475595110277,   6.7764914543858534, 
              0.4457231961952865,   -4.8039794773519802,    6.2461957502300152, 
              7.3079368917741085,     9.5292188006297938,   17.828973630471044, 
              5.5389555380380653,   -7.206957875576486,   6.8039951286475393, 
                -7.13076848270937,    4.6846369291097503,   5.2344876016716846, 
              -7.4243180555809216,    4.2083226956907769,   10.959782903604257, 
             -3.3496912019355491,   5.3271878273712767,  -11.771894122599587, 
              9.5161567317396685,   1.0047667822834643,  -10.284351720746193, 
              6.6638279381876897,   -6.6224848151891678,  -4.1326788144313937, 
              4.2538082521280405,   2.9170354309780508,    2.0486223458811383, 
             -1.5052451979009982,    6.0889425343446115,    14.472950909401963, 
             -27.808842457831911,    3.804369359026011,     4.2783838126771734, 
              6.8267099605522343,   -16.601690960395977,   -1.5367020110591014, 
              -2.1477476400255311,  -19.934699130167001,   -4.3004136911103314, 
              13.130828035528774,   -17.633322957060603,  -5.9117944840213603, 
                9.5701958199804693,  -1.9168205268732543, 
              -8.3165533655206509,   0.7757977225271534,   5.0169613930502335, 
             -18.730738051243996,  -2.8423777452278278,  -11.826377066964202, 
             -6.6753606892045845,   5.7871971239522253,   -15.358008514446855, 
              2.3024732389204781,  -9.6179592954913833,   4.5795920827756866, 
            -0.54281082203925235,  -2.9000933741546051, -0.35295232511866892, 
             -0.5337474044848094,   -13.739419001950754, -4.3233361635004144, 
             -7.3770145862581256,  8.5742718586177542,   4.5648714292080221, 
             -3.6197186045736922,  -9.9622155900905067,    0.6837823213901304, 
             -10.623616034193235,    14.75981842587775,  -5.1891627390792507, 
               8.8961724253546333,   1.9838391767829879,    11.39814141234439, 
              5.8093044377156602,  -4.2000131076419365,    6.4045108550025773, 
               7.3891868990743594,   6.7740538894615359,   -12.033087303242329, 
             -0.31289695798606604,   2.3386265435913924,    2.5274621353312936, 
               6.3557753309132359,    6.9868298308417476,  -2.9928170515901238, 
              -9.572130895773153,   14.266251701902689,   3.7852502243637662, 
                -3.3046296988516, -0.57898341307916878, -16.460387943546589, 
              17.365828226093281,   -12.453536633732318,  -12.630427633101089, 
                26.58748415889406,   6.7431014308575454],
       [-2.4645190592410677,   1.0217587991788717,  0.89393549524608817, 
             -14.723928388791187,   -18.414720408790281,    -12.42859271518968, 
             -7.5261251958009794,     10.216253274723231,  -6.7218796494836734, 
              5.9430627588353371,  -7.2738477391386036,   2.1180072611397565, 
               3.4023135260254396,    10.491323309573088,  -24.400383575504463, 
               8.6088743651122606,   -5.3871100910477292,   6.2549268273654048, 
             -3.9721566103120947,   2.1598795719889865,  0.43409516948307408, 
               2.347496860988644,   1.8126022119433385,   13.816481657122585, 
              6.4072873822208827,    4.6804215672987546,   3.4313091558632571, 
              27.789781945553052,  -14.125565089563576,   -11.957325043865941, 
              14.379783198021752,   -6.7734868653304625,    11.127038264065469, 
              4.0399273733816869,  -3.3532163869701783,     2.6849900897385712, 
              19.930450345424624,   -7.7252745334492987,   -3.2601489034096618, 
               7.9659310961834233,   -9.530599378345789,    12.086870062995946, 
              -11.59136540402989,    6.2055232270162204, -0.81533825850406094, 
              -0.89898944115077395,   30.272389846565311, 
             -0.30463578782810263,    6.228327359755415,   6.1735500360133244, 
             -1.5801961680319354,   7.8491845237252802,   10.012527254392573, 
               4.285990173125799,  -19.829522225057524,    12.118704926736921, 
             -1.0493774608271356,  -10.044619991970166,  -9.7456812761524176, 
            -0.76696292220990747,   15.288005560890308,   3.2336404476045022, 
              3.4729528755628047,    6.3549035138364633,  12.932977555170602, 
             -7.6668134756754034, -1.2905211302987782,  0.11327964885819639, 
             0.90525790646792903,  -5.2905923479333419,    2.7606211407531287, 
              8.4306555465761299,   21.837616265108682,  -2.1015072326394906, 
              -4.1144887469683322,  0.55457483553248876,   11.877360204052067, 
             -6.0090528703702617,  -1.8456795001548292,    18.635672378543916, 
              -2.3835185551062592,  -5.3168053679635632,     12.55580636964855, 
               11.165176559972007,   1.3911419404442107,   -6.5627100135156056, 
              -5.1387158306415612,    10.498522861678111,  -6.0447588350467063, 
             -0.1592013805470241,  -5.4511409265756274,   4.1844512310692927, 
              21.223979247831366,  0.48859163132062555,  5.2814248301098985, 
              6.4630286772757364,    6.9177753096415397,   9.9445981570624049, 
              -0.2906019930347486,   15.532647797317862],
       [ 9.9253958453015159,  -12.902854690237231,  -11.356609937579069, 
              1.3682231495375072,    6.0963201135839586,  -0.25753417814984081, 
                9.45126465599642,     12.267334735760917,   1.7269464198913225, 
              9.3015521545788431,   8.6913711910793463,   8.0632997623680804, 
              -3.3611998868776043,   -1.8560410339555546,  -6.4697759015126524, 
               3.3005302812429922,  -0.36885280406830562,  -12.566407159891472, 
              4.5658315682236879,  -18.224579202379299, -0.81920412035733303, 
            0.074366474486941572,  -5.1119665594004768,  -2.4271975364985523, 
              1.7016210076284979,   -2.5367466889545529,   18.731479519325596, 
             -15.844313280947738,   -1.689250629782302,   -2.2499800243842905, 
               5.023107593112254,    6.8623230144405314,   0.38702242522013997, 
              3.6230939720293094,   15.311296328773082,     15.995074938743075, 
              6.1796688182474933,   -5.0197339880543144,  -0.56618966103336876, 
               7.3239456176695272,   20.626067295153657,    6.1439442558268844, 
             -2.5729795759694607,   -12.928365624997348,   22.231189481916957, 
                 8.238362949638061,  -15.173968001710499, 
              -18.340884199720403,  -20.432694939944728,  -11.826723077308031, 
             -6.1538365610465293,   -6.169007119852826,   12.847642619219886, 
              16.058282337111883, -0.51073873931744385,    -3.167340159048714, 
            -0.96760695511287909,   2.0251448127040925,  -6.5654484762656127, 
             -7.9753730335305741,   4.4512270592094403,   7.7162829031843199, 
              10.894527783670959,   -17.992922420953565, -1.8272586129626962, 
             -16.258190390711754,  10.305696186224671, -0.42043637231003345, 
              10.838913095179093,   5.9408816341528459,   -5.8112394440072022, 
             -1.9125681631090055,  -1.7465720087728642,  -8.9631217492456727, 
               4.4528248440357956,   2.7858397686630809,  -13.129955680688319, 
              13.164627915141336,   7.4756518401173722,    0.7771681959582819, 
               5.8711181324061101,   -3.890853749333453, -0.052280378584873777, 
              -17.398814974232586,  -17.907130601771144,    4.3674005784499448, 
              -1.5352476225811851,    17.468679264383624,  -5.9567257143391785, 
             0.38057868414849094,   1.8936492503976798,   5.5307856571159153, 
              2.3541149159694128,   23.455970992447273, -2.3676697968788223, 
             -18.031023675490342,   -5.2281410693483163,   2.8804763208546924, 
               1.4303693932015713,  -14.078897300159261],
       [ 4.3903360613728788,   8.9099584857444682,  -4.6456382677954329, 
              3.6233389589908587,   -7.1229839695841637,    1.0074488839893967, 
              -1.315483583839729,     10.186131194295866,  -2.7446072001370996, 
              8.7316827087933166,   20.543778563057696,   17.777086894410854, 
               5.8943799169001077,   -10.805763639356805,   6.7596942397626592, 
               18.585223574657924,    3.0045904230362224,  -8.5857808644835369, 
              6.7186921518955565,   1.3837059638115043,   4.9872368266302827, 
              15.561472617500256,    14.27725822553043,  -10.920252430762741, 
             -3.1250773172604944,   -16.486980548116037,  -2.0265644059243888, 
              17.373212662620933,  0.58179129059970047,   -13.433009682066622, 
             -10.368077829173934, -0.050663525656985259,    3.5892909157382933, 
             0.38179175669988286,    1.409270742050569,    -6.9706038357719535, 
              -9.823165413805917,   -6.9117408250573718,    2.5519398250626155, 
               8.0625533110539287,  -10.317523959447252,     3.767853361963696, 
             -8.2733269614803877,    7.4403435095096881,  -5.1658053556612673, 
               -18.403709654978357,  -12.159168884567553, 
               2.2997891277427627,  -2.5509284455148258,   9.0926826008226129, 
             -4.3549403957496109,  -12.008988250273958,   1.2522368342515702, 
              2.2883451182611485,    11.73378011856026,    10.019070739747134, 
             -4.5589153839503807, -0.24496175079359195,   17.032654627333759, 
              -5.336989223186074,   21.684296640306371,  -12.939141212757082, 
             -3.0371945466134282,    17.029723797455173,   7.358142838316251, 
              1.8768046810294137,  5.7054235870497738, -0.78045326183929831, 
             -15.851683223022491,   -4.494998017175968,   -12.684542937087272, 
             0.39306072848450108,  -10.503191613559109,  -16.850208852799419, 
             -0.22830829613524684,  -14.660293862472088,  -1.2030123825578993, 
              5.6709172981799361,   4.9443975873666393, -0.089101749661692417, 
              -1.2222779319315484,  -11.593426260092393,  -0.28556348776609852, 
              -1.3105800129326619,  -1.0040577525567762,   -13.390835340012488, 
             -0.34867734462290162,    8.1715549170656789, -0.29355185887229934, 
               7.769537304989532, -0.90458504203852208, -0.47589109471567409, 
              4.2478640435880779,  -2.0300161459700852, -1.8130218704699332, 
              3.3807693935600431,    5.6105915359730059,  -23.131565612810849, 
              -15.226960239500043,  -2.6057660241851237],
       [-6.4907893829394405,   2.9630164690200855,  0.84476559850665467, 
             -3.3419599027645832,    18.874987362164532,    4.3544748425420643, 
              3.0574046296493309,     -14.17511444367565,   21.566837110377769, 
              3.2894477470019634,  -1.7465257832150018,   13.127478252164188, 
              -5.9331763541800253,    1.3717103035598508,  -2.5472576660170718, 
              -11.121596609675198,   -12.775107840127948,   4.4753138319133852, 
             -6.7311870617670175,   13.048479391970048,  -4.8552166866255657, 
              2.7383542578259581,   13.236603771073533,   8.8858696815538156, 
              6.6895979830463359,    9.7914395585288734,   14.447535981152003, 
              4.5040854176599705,  -9.6895754423257152,    -20.82372171124241, 
             -2.8278670365551899,   -9.9754238274112179,   -13.149721062336894, 
             -6.2706727251208214,   11.903929144524286,    -4.8042975057837483, 
             -6.5938996263793603,    1.6753788446327267,    7.7929318994242731, 
                8.944289131135319,   10.184248866369284,  -0.44864946859782984, 
             -4.4047653781210645,    17.699418750824137,  -1.7456753419007316, 
               -5.4909721286411788,  -4.0963794059874559, 
              -15.775503404111149,  -25.776147129135015,   0.1682343491399943, 
             -19.370224428218638,   -7.664462232873392,   0.1648043740355791, 
              5.5075455754575673,  -13.342079350103413,   -9.1297402311830318, 
              8.8235386526475796,  -10.219957448297158,  -1.4373731946138206, 
              9.0237897891898378,   6.1060364136364438,  -5.1991096988462395, 
             -18.843733608201813,   0.15090252806082202,  3.1814010547464111, 
             -11.578833420544266,  9.8787423029100747,   1.5072862662500723, 
              1.9398489436684629,    11.30462470293579,    -11.89128825110847, 
            -0.11466285313496737,   12.384950025054273,  -2.8017991805851308, 
                15.72812042193542,  -14.656110229251677,  -1.5647020798837266, 
              2.3979007448224494,  -10.147103561085064,    2.8842377338545826, 
              -1.5634314092462598,  -4.9994704330723314,    12.905366809924899, 
               2.9051123007261963,   15.267573950941973,   -11.792977692361928, 
              0.33817944075004169,    1.9413442665035527,  0.94608500429205766, 
             -16.661229990816551,  -8.1181226470136671, -0.38978666528207706, 
              23.266154297023469,  -15.113372687655701,   2.710394332454888, 
              2.5670310394570652,   -15.212229634175785,   -23.90552364075857, 
              -4.4329151499366359,  -2.3872860511766398],
       [0.78225482774855792,   12.766465078200323,   2.0799026948708024, 
              12.767039873506274,   -15.686529777904315,    4.3682748919585492, 
             -10.091484579945835,    -1.0860949290062523,  -6.3188251514711844, 
             -6.6867906464346492, -0.28642479084648409,   -5.741673820741747, 
              -12.589152041970554,  -0.69690707317100831,   7.9486372583667473, 
               2.2543899043565911,    6.5103048228799523,   -19.29088918023233, 
             -1.5378546981139598,   9.5785149014148416,  -1.7613894348263315, 
             -4.3048081813466519,   7.2387368783049872,   22.705915577654654, 
             -9.1882908027510215,   -3.6351963138140828,  -4.0466919592049315, 
             -4.7496867087792207,   6.5210800462726484,   -3.6395894547432386, 
               4.457895573103448,   -3.1539539157362118,    4.6219501971555772, 
              12.632683778512808,  -6.0614485614551841,    -1.2515957048928463, 
              9.4928806670663786,   -11.661993931360131,   -1.7615825269563488, 
               7.0583015360664518,  -13.310836945420608,    8.6393746769793438, 
              6.2404716697397431,   -2.9387811650676499,   2.5762503777793833, 
               -8.5440087843814325,  -11.853584553972096, 
              0.85845109966225208,   19.467075497915534,   1.7435203767451199, 
               13.39158275527209,   1.3770244578082134, 0.077789963640708143, 
              22.657420153474938,   9.9274258166165161,  -0.35116190270043196, 
             0.60681322344365474,   4.7631782758703487,  -5.8145652943352975, 
             -4.0361747320455414,  -4.2193969483751381,   5.2332837009145896, 
              9.9228451339801875,   -8.9887204228090845,  -4.189949138299073, 
              9.0630894921320611,   1.567892458842866,  -13.394553413461775, 
             -11.002832276298482,  -5.0991944039740424,    7.5913395690101746, 
               9.372997965112253,     5.04332394271895,   9.6857505701975235, 
               3.4763749908275394,   2.9493605126135369,  -11.062934083527594, 
              6.4121341913733776,   3.7617133351432597,   -17.658284209125267, 
               9.8489141889197214,  -6.3118832002243135,    21.068916537227118, 
              -1.4589974246372144,   11.039817933831412,   -2.8832577195983382, 
               5.8536508925416904,   -3.2782681518756851,  -3.8595922969483825, 
            -0.44652620546499366,   7.8589385181026747,  -7.9692166123317243, 
              12.544505363015798, 0.081007401294070233,  2.9709226102069168, 
              16.134694027955433,    9.6485740205208117,   19.591852356939739, 
               1.2790602906448698,  0.72861470310115006],
       [  7.692748528733679,   6.1346055473194037,   20.667779454229226, 
              12.604367432561947,   0.27844106284281789,   -3.7854409195062906, 
             -8.6162125556256157,     12.304101446436304,  -1.9435293257275013, 
             -12.768474685818052,  -10.986177613369764,    5.591337022554951, 
              -2.4711585981257818,    -4.881300108047248,   1.8289865047949683, 
               1.6891813454475699,    2.5075069792488618,  0.26421176931983698, 
            -0.84298605829842455,   17.649284470426352,   1.6470142114891022, 
               5.205172826741185,   8.4936016352152706,  -4.8043698073621739, 
              5.8140228429147509,    3.0533133785745612,  -9.3507121555838832, 
              5.5873764229883101,   19.505255332882648,    2.8575698253432211, 
              14.800529051678739,    7.4012145677308485,    13.275296173543836, 
              -7.811738935038175,   11.517054947297282,    -11.077033829880236, 
             -1.8713882789815139,    4.4939348864745252,    13.087702388960041, 
              -18.528648913713184,  -10.746511831461225,    21.007836110649798, 
             0.74481353088726554,   -4.9058877238455656,  -14.480186769147007, 
                2.7990986113022625,  -0.1005546582135869, 
              -12.183714697079422,   10.065858865810885,   -5.355634306248346, 
              11.103960439501302,  -3.6725167286886657, -0.31605488803447995, 
             -8.3886128571531096,   16.288603597670242,   -5.5003977608114631, 
              2.3954476027205169,   1.0994991019872811,  -3.7155748534129822, 
              1.3453188022032752,  -10.508464432154492,  -15.244656890121913, 
             -10.850873522578205,  0.094596445287267933, -17.561120064545069, 
              4.6310114090903056,  1.3133155811638306,  -9.6561315722193957, 
              3.3705114717822227,   1.5736678863440976,   -14.419426361681769, 
             -14.590069532811311,   1.9827696848978271,   5.2771223603355377, 
              -3.0766721100130443,    1.560841516109285,    7.028472334697935, 
              0.9701525089555787,   0.8893967121199452,    8.9444818588707928, 
              -12.270560096748198,  -3.0508092470330226,    4.5622065876760782, 
              -2.9711825049338825,   11.592514140332977,    14.770098331225299, 
              -3.7385244851623938,   -9.9708957521738846,  0.42719631185866963, 
             -4.1553455149282925,   -4.348211967427746,   2.5743610159499881, 
                7.22077056570207,  -9.7474751228908296, -4.6566404820766474, 
              4.0131272681459169,    4.1665949946595537,  0.82208531571670784, 
              -5.8705237029206465,  -3.1869270796326301],
       [ 11.810569477672392,  -4.2759299679809128,   13.571294662411402, 
             -15.872654665906708,    -12.73933849695479,   -3.6205769875230303, 
              11.730923785271836,     13.286204289065326,   3.5981384105109262, 
              14.172595922194823,  -7.2323534846085424,   -5.824798598869303, 
               8.5495209597060668,   -2.5654452429899872,  -15.029433972634877, 
              -1.2631281202888791,   -3.9412528014656241,   5.4613084793839315, 
              2.0623492554482259,   11.303892620194491,  -5.7842570143573298, 
              10.959875215452147,   9.3511855659229237,    6.867555576814695, 
              14.974250419463559, -0.062435828135010224,   6.2941187948094584, 
              7.6210406643791089,   11.894899878218499,     2.966501526877229, 
             -2.8746769298526131,    5.7398021791637133,   -10.891293867682721, 
             -11.833308197642944,    19.30484811188817,    -3.9835757626114967, 
              5.7726472476440138,   -3.3372106219590982,    1.6465969001943981, 
               11.574464783271701,  -22.270619887704587,    3.5035462464425047, 
              5.4752252382148123,    3.6257361438294367,   12.557795941613154, 
               -4.8131624016573529,  0.64067026900005186, 
              -1.2526344178559872,   -2.349461870926095,  -7.6994315662149573, 
              5.0451109730209716,   -1.744709166234212,  -2.3221375943017488, 
             -6.5125504294873355,   13.058569020963445,    10.065032160597811, 
              14.771680580893063,  -6.8184781485076265,   8.6715959644404386, 
              4.6252442203243227,  -10.488454520069414,  0.32487787357378778, 
              9.9679668709401099,   0.59193764553629802, 0.85816141636494137, 
             -5.1311109693798365, -3.6421590434288325,    2.254765330063865, 
             -2.3847423888984181,   1.5183241502106477,    4.4463812692246467, 
              7.8083580609709529,   6.7101000650994838,  -14.682607409856235, 
              -9.6680030953354965,   26.152170490626791,  -1.8020451379543658, 
              2.3094229892688753,  -6.7962612139557601,   -12.247596171490096, 
               5.4305404509480084,  -6.5237501269108229,   -5.9764981354866578, 
              -9.3684478639646365,   4.9171935668901066,   -9.4344436609089541, 
              -2.9379450396179152,    2.2209201259846529,   -8.233403475167794, 
              8.5554289980445013,   9.1613347416107125,   28.039803672671887, 
              7.7316795436115191,    -14.9337287020162,  18.477432322337663, 
             -2.9993143516677154,   -14.881208061181248,  -3.1330140481741768, 
              -2.7785807975125989,   18.596687334300974],
       [ 10.719062099505123,  -13.717168904523557,   5.3103877497485215, 
              9.3322498030091268,    1.0577581216986041,    4.5575727090833986, 
              15.072540723285107,    -1.9018549584191313,   11.337634376765749, 
              7.8918379734548649,   14.191902773913201,   2.6908867938698218, 
              -20.498715514431968,    18.728452736297005,  -6.2521628352064509, 
              -12.177451682030922,   -2.6629701992296653,   2.7777282598694342, 
              21.529420100161339,   12.526133865819961,  0.12085049004558235, 
              10.447197773707382,  -8.1710954792147756,  -5.9534521666023892, 
             -8.6394203896904465,   -6.5679204614945119,   7.4288918197897331, 
             -6.0068989607354029, -0.95230211790716057,  -0.92279547395438888, 
              15.799602021966656,   -15.305907046762986,   -17.624426244837096, 
              12.100580142544807,  -14.858573084963563,    -2.2958186013250033, 
             0.59697484830201386,   -0.8527155023436751,   -13.077194216589987, 
              -5.9750473086386799,  -3.5962378435666951,   -8.8544929505050636, 
             -5.5634845942242723,   0.83506721525101613,  -7.0178664573224196, 
               -8.7963365144324328,   22.078630783912207, 
               6.6114261602512228,  -13.812801502606316,   5.0705944222558159, 
              6.1353205468922987,   18.954307421977223,   -2.282162916195277, 
              3.5792103762489882,  -9.5847060094529812,   -13.856638849210228, 
             -12.468226848842377,  -1.7477267630583038,   5.3243902255004798, 
             -6.9388562652426211,  -10.976011008417988,  -2.8302416264028674, 
              7.8149625409840784,   -8.1943176489768099, -5.8398786817354669, 
             -3.8206273880226487, -3.8758059380726713,   1.1081684640922402, 
              3.0282865225690876,   7.6683618171840839,   -3.5052704725453632, 
              14.517976840817843,  -8.2721571674387082,    10.40779114178104, 
              -12.378208891446093,  -10.814466906849091,   11.829185174392196, 
             -22.822057693243138,  -7.6865971466622707,   -1.4405837540504274, 
               8.6774375677842244,  -7.4140008259849699,    8.1868922746158432, 
              -7.1121680913291225, -0.66375831757911263,   -2.8465847722288915, 
                2.284632721145794,    29.896846726761211,    -12.9842933679324, 
             -3.9161590494989569,   -1.015166265173006,   6.3146391767302434, 
             -1.4404923462655959,  -7.2644061608569057,  7.5803525165900174, 
               4.204004335403015,    8.6404880215665827,  -8.1046474602960146, 
              -11.089955789656923, -0.20625575164759077],
       [ 22.497308150344857,   5.6657507353061218,  -5.7077685447641135, 
              2.2698624489103953,     7.841646688607379,   -13.194559733249051, 
             -8.5439476714192377,    -8.4573388330712813,   8.5199145236446512, 
             -0.4344247018063454,    17.31986082176433,   9.4751294974217437, 
              -13.423087918367679,    8.2443667156166143,  -3.2494648056871038, 
              0.41383570111308304,    17.969138399356194,    3.985324518285041, 
             -2.3163297662494458,  -12.900288710640062,   11.181626039178941, 
              7.1172060545806692,  -15.854460680933398,   10.759941230184356, 
              -19.99216981565273,   -11.974903734404688,  -2.4184962178301039, 
             -9.2210545433724196,   1.2127177010878145,   -10.426454190245355, 
             -13.325698936622718,    4.9851730989152419, -0.071845700865444562, 
              30.004700566844086,  -22.575424275092026,     7.0404318422944234, 
               16.12344891883183,     13.30221985525753,   -7.8303184545690634, 
               12.824854929504735,  -15.346522119431627,    5.4055870570809619, 
             -8.0896574346093182,    3.9926999895230026,   5.3604666067682238, 
              -0.41255453206357035,   3.7075848509626663, 
                2.874309291553399,   5.7093126908820864,  -8.3235888306311043, 
              12.055418321956953,  -9.3131015781320876,  -8.4877356454866728, 
              1.1784993808254907,  -11.224710388857645,   -3.0042368388273517, 
              9.0795039709313503,  -6.3850936183616458,   -1.953327606198868, 
             -15.153579562475382,  0.42952512343536037,  0.61554628372758113, 
             -13.208641466689745,    15.608105012358013, -9.6668905934148945, 
             -1.3298236070617797, -2.1207995058180003,  -8.1096477091378549, 
              4.2096286314394451,   18.318172561622521,    7.4083985707257813, 
              3.2165591233857933,   2.5659397898642853,  -27.174466387074784, 
               12.984479219509499,  -9.3713408432882144,  -11.216690486767906, 
               10.52432686035662,   5.2164089869676253,    -6.421333400517554, 
               -4.217194051203391,  -14.482838428899704,  -0.60804174179663351, 
               1.0313423078874651, -0.54570330426649183,    1.5201108329043116, 
              -5.9803373652064593,    3.9701837689599344,  -5.8101149718276197, 
              5.3005303526978391,    10.16170580975183,   4.6442009369857722, 
               3.133175167918052,   17.718539150994815, -7.3470319066230569, 
             -11.343491046469627,   -5.3959517608655343,  -5.1947730735415885, 
               3.9486871093600184,  -11.623917434083811],
       [-9.4911925640730601,   16.196943251556732,  -3.0319035303190138, 
               2.582056195698113,    4.2171079932299378,   -6.3264519982842558, 
              3.0217355321950699,     -5.576232981187184,   3.4879804606813822, 
              5.5947391177171983,  -2.6351261514684623,   1.2135734554778623, 
               7.8201369706615331,     6.758702014058553,   9.1412068614041981, 
               18.701153334802541,   -4.7627392939053506, -0.03761090183536224, 
              6.3364889206823891,   5.7728682725666225,  -4.1054540130421042, 
              1.5102542663496927,   4.9048162547313368,  -8.9856200459174733, 
             -20.088631313880558,    1.2151919558506137,  -7.1824390600462422, 
              9.0366840224114053,   4.8262121482746121,    11.809629844727919, 
             -17.945884000727069,    20.774661770468008,   -2.7970831485582548, 
               3.412673754736391,  -1.9442472551384755,    -5.0505586106427565, 
              5.5918997253203964,   -13.560588785637327,     11.27433138509241, 
               5.0180754758123891,   1.1873999996703704,    2.4383386095791604, 
             -10.241971402925394,    11.538505242014015,    16.29390766121065, 
               -3.1381363917552529,    3.588304565015247, 
              -4.8677177032114285,   19.880524636323294,  -8.1983927464841688, 
             -11.637241841983972,  -2.6708016917660604,  -5.7800096413069042, 
             0.21073589960668121,  -13.483322449396908,   -8.6713275254860331, 
              1.4407910160685038,   12.847774681459514,  -1.7062262337155845, 
               13.65245647433753,  -1.5447257798837246,   3.2035130776872616, 
               7.467324597526666,    5.2322868709756829, 0.16502988187501078, 
            -0.47595246370649846,  11.205103642570588, -0.75041621629165334, 
              4.5605658942127807,   6.7393520173835428,   -8.0201445672219691, 
             -6.3665083358582573,  -8.5608068623542284,  -3.3329591396492715, 
              0.65780714328134138,  -1.4891300037794917,   20.189140878597918, 
              2.1904448089332682,  -5.8157436458007696,   -10.235279903429262, 
              -8.8373673523436622,   4.8324740093904914,   -17.119863985210586, 
               8.6214552437741361,    -15.5945926766711,   -21.105673877132993, 
               4.0663981335974055,    2.3961090338785676,   1.0506244960732916, 
              4.8228508168354827,  -9.0990667681292603,  -0.5142006360847835, 
             -22.832276481272487,   14.286714903899567, -3.4508792316349957, 
             -12.252046347427344,   -5.7104954599076567,   6.7572660124267925, 
               18.424950757361202,   -7.501847173511794],
       [ -9.531556315309496,  -16.721349950120828,   9.7636921185795575, 
               10.02370847628525,    16.863260227959632,    -5.560617964492927, 
              4.0693664714639279,     2.6031853052825977,   6.0923687056647946, 
             -5.9043040160968712,   3.2389803804387163,  -10.207554436754773, 
               3.6468023416434741,    6.2621937648674342,   13.720626468482406, 
               1.9747570635477716,   -15.954556107616302,  0.98635090408292436, 
              17.294360581740943,   17.941835403173055,    11.88152691738912, 
             -10.423990485432082,   4.6958515708515316,  -10.262656702576002, 
             -16.947476189753676,    5.1187550978854537,   2.8851800981175919, 
                13.3063612069278,   1.0598453248120567,    12.723873971397492, 
              4.6722904163768932,    4.3211326935465495,   -7.1004846372998554, 
              8.5813865445762723, -0.45546100650840748,     19.713435499006511, 
              2.2735819631418992,   -5.4806434010855565,   -6.7380607431469821, 
                10.68532307952599,  -9.8064721935054333,   -3.0260898892549175, 
             -2.4543276660521203,     15.21143288694754,   4.2890489482664318, 
                10.178076110458157,   4.1138209897857099, 
              -1.2133468240678937,  -7.4641833528167183,   17.672765541830344, 
              -4.008636597409251,   7.7208686292020943,   6.2003520474781251, 
             -27.270703545325418,   4.6878665222761189,   -14.133316295693302, 
             -1.9020303496032782,   13.433941165252431,  0.38665895687157953, 
              1.6273668313177447, -0.66396241307902426,  -3.8908076233655855, 
             -9.2165004134382222,   0.29136217351146854,  16.679695768304178, 
              3.1655065984513184,  12.878545135509532, -0.82904023543686001, 
              4.3923217949427986,  -18.972768618067747,    8.9242118213282868, 
            -0.23871375744587453,   1.0787746876592368,  -6.0844916372097959, 
               12.002563272638238,    3.387589242140105,  -3.7939837027477004, 
              7.1399555481706525,   7.0041988947918856,   -2.8459272648962459, 
               4.3881153047707526,  0.49557903818064253,     13.36073338781069, 
              -8.0755891041197145,   20.495962778030691,    2.2184779682070195, 
               8.0963793308569425,   0.71723755413298573,   21.981202268082193, 
             -4.8747161462840278,   8.3706820798456274,  -3.9521829980278822, 
             -15.112192703294554,  -5.5569088843835344,  10.109873662188917, 
              1.7145777392167638,    4.9800797535848744,     -3.6601762429933, 
               20.736085632203917,   10.785660134933932],
       [-4.8175320764403144,   -15.82317344586385,   1.0556497349941238, 
              3.6104203046830445,    19.344120625328827,   -7.3661649017873039, 
              -15.45270350912366,     4.8863635296607706,   12.106119582679932, 
            -0.27133627911176034,  -3.2011614729680256,   -15.10191662036541, 
               3.5589954419569425,    2.6673250502311512,  -12.676039172728986, 
              -1.2252563478055978,  -0.92253086154448338,    8.889959123889783, 
              16.423356838938354,  -9.2204388339552086,  -4.6300880236379234, 
              14.182820115368585,  -8.0069232099683685,  -18.566405981661983, 
            -0.46768174288860564,    -17.99519567739533,   23.145806291444035, 
              2.8053315946756872,   -6.658146058839165,    -5.991131086440272, 
              12.122728398313701,   -13.166758455255136,   0.20755757385870641, 
             -5.9664629330219636,  -14.269482767315822,    -18.790885354847468, 
              6.3523998373517827,   -6.5384545532267104,   -5.0606275974694466, 
              -3.4193260864723163,  -10.440805436537621,   -10.095710836016762, 
             -4.2919887902211604,   -10.588347593204395,  -2.6012348005128789, 
               -3.6030942675754787,   14.463250254178696, 
              -16.429315294048095,   12.857407427696124,  -12.555118045118673, 
              17.075134272737237,   12.287377387242476,   7.4821069716130495, 
             -3.1669053386700989,  -10.300830496812727,    22.120235246035158, 
             -14.732978668921318,  -8.9763144547526341,  -8.7813215340164099, 
             -9.4411655447796718,   3.8977341129531369,  -9.2250762220670026, 
             0.90774787879767183,    6.0562255190870529, -5.6378858217171812, 
             -5.9634555147131092,  7.0682136835728304, -0.28583562850534255, 
             -8.8491936929508075,     2.85377577127975,   -8.3298398368343385, 
             -2.2720072084245357,  -1.6293983880263674,  -4.5606837510035216, 
               3.8763628867317097,  -9.4911045674406083,  -1.8767978529991747, 
              12.700623743961234,   6.8145657651865141,   -3.7413475081638725, 
               6.8846064793026578,   2.4207438593850905,   -1.1062841618959176, 
              -17.072085047143993,  -10.489241879677206,    7.3676723620472204, 
              -5.5860296991409157,    3.1366070814698799,    7.744999243640792, 
             -11.820622297714397,   20.415354097004794,   5.8264585230101851, 
             -8.6610579931010037,  -28.695368008665362, -5.8849514662246953, 
              2.3375860800861221,      9.63379336944225,  -5.9016187448304951, 
              -15.992947950630052,  -5.3311047791712385],
       [-13.725374683096746,   5.0832983535066614,  -9.4562486828224674, 
             -7.0918212606697182,   -18.666244154171849,   -5.6595645264264629, 
              3.8958383614148842,    -2.0494909916947184,   12.938622642273449, 
              4.5246696181770236,  -12.171996342608866,  0.74987886022730643, 
              0.93658006828134943,   -8.0681816904452628,   15.596005692464551, 
              -6.6720842203329402,   -4.0971442281061634,   13.314009600432595, 
              6.4531037989321085,  -5.3783345778414402,   10.608019628435986, 
             -5.8874107691544442,  -3.6361055969512659,  -17.534464836425919, 
              10.068573197411583,   -5.4974905612626586, -0.94805039040786132, 
              16.129423857397519,  -11.297903251322275,    8.1183278418738993, 
             -4.8707292573159044,    13.264712268155288,    16.779558572317757, 
              -9.747498606879752,   6.3474603248462049,    -1.6337155040073998, 
             -1.3760670933799419,   -13.171804177398773,   -14.514928605582178, 
              -14.462759816131763,   9.3158386912709901,   -4.3559614624042684, 
              1.6376659281872414,   -12.486918949973854,   22.113365537364452, 
                12.006416162701729,  -9.3822661174863935, 
               14.465372014663965,  -9.1298091452715031,  -3.0028751100793989, 
             -10.467520236318212,  -4.8295523998718455,   0.9839455965417444, 
               4.235128215406796,  -4.5189266242480075,    7.8704512375868525, 
              2.0597120891794822,  -6.0450827053598832,  0.67425097559261005, 
              8.5281615925438707,   4.3922258813532435,  -5.4054775828759318, 
              13.534139314241131,    10.624181139331334, -8.5290648230356609, 
              3.5687171008296961, -11.815013913882009,  0.14141087741641425, 
             -3.9940852432020661,   9.6743028949536694,    11.045850870459091, 
              6.8507966426386959,  -5.8103116125379097,  -11.898316579024812, 
             0.038955836590406655,   15.275890060623816,  -1.1162443681744412, 
              6.0039536252278101,  -6.4080535174118207,   -2.9609218095699403, 
              -17.132498742093997,  -1.4496240913475356,    2.1189787282461183, 
               6.3243244228771527,  -3.7267539625711024,   -22.442224124596848, 
              -7.5219402124567312,   -12.107261654025901,   1.2739140172480099, 
              2.8726105936151303,  -1.0243494079201281,   -2.988967740001478, 
             -5.1559069801959012,  -18.350463966695081, -10.461003672797901, 
              6.8421070790950438,   -7.9199946762667741,  0.84780517953304435, 
              -10.176253877523926,   -7.101531538338949],
       [ 4.9114517246990639,   4.1648996213595115,   2.4902322496593405, 
              1.1811022438660657,    1.4087869984191446,     10.84640995720974, 
              5.3192211860641123,     5.8055361612580905,  -4.7979006349144875, 
              3.2376790875034853,   17.247789962209886, -0.11448068978180377, 
              -7.9993329118742356,    2.8216550806969618,  -6.3811181924477234, 
               7.7556029884274995,    24.302750631966781,   -2.691798993324177, 
             -11.490064541816432,  -2.3987029300350291,  -3.4040836906382053, 
              5.4036740578035944,   1.7517571611458824,   24.685352407730715, 
              18.961401045835416,   -12.363745979629568,   6.7712121577615054, 
            -0.56428414102788027,   2.7448365231444996,   -7.4652223801447253, 
              4.9327285317966831,   -10.935445731487075,    1.6021555568668435, 
              5.9166081675449025,  0.78288670336761124,    0.52201956558506468, 
               9.076033008397804,    1.5432782743423934,   -20.099925827099668, 
              0.36009313255506015,   5.9840130016528281,  -0.28965196077286653, 
             -7.5685611769001913,   -1.5414445721226777,   -8.357641938146509, 
                6.4922383324222945,   5.1488968207974164, 
              -16.179044230992549,  -9.3093496970861143,  -7.2969026075371479, 
             -1.5986613647291099,    15.92298920613236,  -1.9115784942860636, 
              23.065309138118877,  -11.119042437212411,   -29.492434122041836, 
                11.3606387444833,   1.5070034666424448,  -6.5433051032697884, 
             0.60833903502239317,  -1.4926775419195915,   5.5240476784262214, 
              23.246278699168013,    10.509421003301537, -15.661996152937533, 
              8.3161478109850879,  17.842514288924502,   13.894639661303012, 
             0.37107949841613963,  -8.9939671973732587,    6.3521064747766252, 
              7.4986785874416526,   15.818547208131964,    20.39657896159035, 
              -8.0735466925002513,   8.6858831974131174,  -4.3857070882911868, 
             -3.0839775397894842,  -3.2257338615229232,    8.7516629345031056, 
              -7.1483170111550978,  -3.3345837468935629,     4.822719500706544, 
               2.8820201120949402,  -12.334446277727659,    13.622428174710981, 
              -6.4552242070259247,    17.204517916863438,   4.1625950276289929, 
             0.96478857229308279,  -14.365339689410675,    24.01580020322433, 
              13.171403511520442,   -10.94470163094779,  9.0292704669691357, 
              7.1074626610863998,    3.1335801076394265,  -14.481229065024625, 
               -6.410631418441203,  -14.129008596136387],
       [ 1.3131409806855334,  -10.168312296565563, -0.79838106239108542, 
             -9.2952395608373379,    1.2212643002846564,    10.293628797364311, 
             -4.3337912067253042,     5.2695591064945884,  -10.959161030509064, 
              1.6841322542167649,  -14.363365104976342,  -10.370062093783892, 
              -4.0609942692285577,   -19.211691176807641,  -2.1475858033197155, 
               13.125542723172625,    9.0909463762229574,   9.6540573823532743, 
             -12.656133731809247,   5.4916517390628625,  -8.5354927229385407, 
             0.15505291490992967,  -3.6932086209718245,   7.6850508194554932, 
             -10.850954946080405,   -7.2961569771729344,  -6.8496853643899911, 
             -2.8488108541111079,   -4.089673089901237,    12.096718969841643, 
              2.7898628861697361,   -1.6509186841864334,   -14.328581907604651, 
             -3.3000526593057016,   5.1302896251100556,    -5.8849375314315102, 
              1.9656251028488798,    10.129288521639804,   -9.4205632630059526, 
               1.4088013226562808,   -11.86186540826866,    6.1301699850495508, 
             -4.5775228696950254,    14.491250310689225,   3.5613076119896951, 
               -8.0312761583340304,   10.896704415452074, 
               6.3174574414732945,  -9.5709724364747792,  -4.5320827368018737, 
             -9.7884853375597682,   9.6350674786370032,   11.540390911753784, 
              16.244078765654347,  0.62962304684505133,    20.042770526896874, 
              27.720269735082507,   2.9538357219000138,  -6.4001493730932504, 
             -5.7339612762554504,  -4.1655567519603718,   6.5225431884109142, 
              1.9301429929599081,   -8.8542826782277988,   14.65701370665162, 
              8.6853395283174102,  7.0461619552384178,  -9.6286102984736015, 
              1.3670691048569541,  -8.1938074822581424,     11.24165885798595, 
             -1.2925364617829178,  -11.758463326255367,  -7.2519187612782758, 
              -12.152049563289145,  -12.861754542837362,  -13.965770253769401, 
             -15.161211791176704,  -5.9370338736512522,    12.411552847040204, 
              -1.2465355479011184,   13.744504822504522,    5.8717332266667599, 
              -8.5862403464657753,  -2.8723302468242111,    1.8975730972843097, 
               16.694094702266533,    3.9718842045309728,  -5.8131925902852988, 
             -4.2149406853502693,   10.740948382333034,  -4.3468753958759763, 
              9.1312587021743958,    -1.76229825109285,  10.070556358537889, 
             -11.235791699509521,    16.515388742995562,  -9.8536860261929053, 
               7.7262725257724636,  -4.6980628397363935],
       [-8.3848453140118977,  -10.201460208303761,  -3.3240932289725467, 
             -4.7394393093169462,  -0.68625013733689122,   0.46590079015409391, 
              2.1683106259343718,    -4.4088259472733276,  -9.7271960865539597, 
              6.9552426499337114,  -3.1645319302434887,   6.0589403600293164, 
               8.3647266699118425,    -2.038766380681917,  -13.963652282354072, 
               6.2900618554406007,   -3.4511436685075432,   7.1707655145260425, 
             0.40588051639172773,  -2.6919804212373499,   4.6763078802435212, 
              2.5950724104002143,   3.7150582436073574,    4.493183736280141, 
             -7.3203994902573637,    3.7491375207046369,  -3.4870213962506744, 
             -13.294049294637071,  -11.800768519577428,    7.3315474845786888, 
             -16.528844431451926,   0.75921771325884513,   -4.8126146267182959, 
              17.436391449768575,    5.769607666759704,    0.60196585163231475, 
              10.413688135567398,    -22.67868110500746,   -12.165391976147275, 
                8.653910527085527,  -10.047678930261693,    3.5218559153351734, 
            -0.62668983656620636,   -5.1237270831773705,  -8.9972499627478193, 
                8.3465528422596638,   8.7477971702869866, 
               -20.66459977683412,   16.604270570594863,   -3.158251393230425, 
               10.73106777800678,   2.6835877158505683, -0.53464952326163739, 
              -4.724901594149193,  -8.8990345776765558,    15.536411568979403, 
             -22.247843057731664,  -5.1698433183017496,  -9.4014601710546035, 
              13.317971573102113,  -6.0466445043866068,   9.2068655463836819, 
              9.1717955392248189,    4.0437953417047865,  4.1179148077092869, 
              5.7873712215950013, -8.1732276560919779,  -10.275836873974111, 
             -13.423033850204673,   13.277347538998676,   -3.1422381332459732, 
             -2.0483579903445981,   7.3324450845877003,  -12.273080007680013, 
                4.841406530514381,   11.800113999779587,   5.1914680452136501, 
             -5.8881613436011015,  -2.5491986682736818,    7.7179595030062718, 
               8.9250954859207514,   9.5820552818027647,   -3.5243690219133765, 
               3.3670202043394228,  -10.467141099392558,    4.3769493774903658, 
             -0.34259396203490233,   -13.236061458225311,  -5.1202843718432636, 
             -1.8732809790821578,  -3.9527896758154162,   1.1350721226791629, 
              5.9918095071903785,   1.5661021963438249,  22.679503124859473, 
             -6.2176672104001067,   -11.590132519985822, -0.74158495004755076, 
               6.9125299909210947,   21.395395935774001]])
eigvmat[Complex] = \
array([[ (-8.8192504041377831+15.321096990400275j), 
              (-4.3794641362485205-5.1244549768058505j), 
              (-6.631827308712019+5.2577221546152719j), 
              (-3.079178089765203-0.10668115257984087j), 
             (-1.8975563759179082+4.7683432688050811j), 
              (1.4805568007308165+3.4090580387528773j), 
              (-12.250877985402525+7.4098499323173161j), 
              (18.549660588037039-3.5107146923179129j), 
               (7.2851977625795339+5.2871712443053269j), 
               (-2.997389376082201+10.585086181872354j), 
             (-5.3254512344052509+4.8457435961051294j), 
             (-2.9029771757664111+3.5768913220046623j), 
             (-11.611283160035679+4.3578733681234834j), 
              (2.1294058378811243+15.021237919789812j), 
            (-0.82396323946660288-22.105478584986407j), 
              (-3.8699160107231783-8.1792842616605697j), 
                 (3.1317577114283219+9.362479223054887j), 
             (-2.4395384848530473+0.45162203143297358j), 
             (-0.5766522874261536+16.628867260091312j), 
             (-8.4575065008600223-16.380851741957084j), 
             (-6.4745194151568342+9.0217744541998464j), 
               (-2.5374918203271117-13.144885902167708j), 
                (-19.328416739672075+3.43628082481737j), 
               (1.7719073419757518-18.676497214098728j), 
               (1.6538733494268334-14.456881162048049j), 
               (-4.0342171813874224+1.9377767904451557j), 
              (-3.0671504889562891+13.077653103419706j), 
              (4.3653436953005054-13.924793011830946j), 
               (0.19988307052175361+3.9849248434850053j), 
              (-9.0852846593332739+5.3627455024466979j), 
                (27.54415162727248+6.1419907881908111j), 
             (-7.5713510232659109+3.5657113982318691j), 
               (-7.437989609693231+2.2953146237396234j), 
               (8.3956120100710976-4.6478605149860561j), 
               (31.671600906325171-4.8425510060590575j), 
               (9.4537004316929742-1.0771921376878173j), 
               (-2.8052564846319661-7.971183889350427j), 
              (6.1696899745374534-9.4232911018648107j), 
             (-12.054122059701477+14.108364808030558j), 
               (12.215190970284697-5.6539819495528381j), 
             (-5.9990433682802449-12.291662391137038j), 
                (1.7718418239719242+3.5753773647347389j), 
               (-16.25225984712332+2.1253861312305968j), 
              (-6.4204271025490511-9.8931118435671035j), 
              (7.0227855628354749+0.19349413806446988j), 
               (2.5984156552600011-19.174424335602062j), 
              (-12.255733184808523+17.788016469863365j), 
                (-20.512219642160339+22.50979139678148j), 
             (-8.4330786294480777-7.6364118140822246j), 
             (-5.9234462124914842+5.9625443868272212j), 
              (-0.29308931100741298-4.06469480366437j), 
             (-0.56879374150869177-6.9413630452560433j), 
               (8.3049981368488286-7.4950385515182063j), 
              (0.41940129526341041+0.62703907491564181j), 
               (12.891249075419795+5.5939368292247185j), 
              (-23.014241299717231+10.804801694727228j), 
              (-2.0422780869054558-6.9694057296815783j), 
              (3.7128853464738381+0.2453395366383066j), 
               (-19.587766871994742+17.702724378454388j), 
               (14.867648629220403+2.2445766743340507j), 
             (0.37603471834246388-8.3630403768450066j), 
               (1.8707998513903903-7.8214572608532684j), 
               (3.0057899459594095-5.5814303059638277j), 
             (-5.9366996100047666-13.149607620274775j), 
               (4.4369256403273649+11.461441025417262j), 
              (-24.656118525356284+8.8001973266815376j), 
               (-9.1278651583507457+6.742200625676821j), 
             (-1.4713745784130867+5.3787500423548629j), 
              (13.378639612528689-3.3010715835527749j), 
              (0.72563668512288104-4.8946731734473774j), 
              (-2.5837309141417841-13.489518041614758j), 
               (5.4308404076184988+2.3773710164571775j), 
              (7.6060080421930429-26.334653037574604j), 
               (-7.4418571264166804-1.8927769535083501j), 
             (-0.61143126737356823-3.902195883639159j), 
              (-15.329682780845129+10.084749886652917j), 
              (13.503322130125575+18.340407491682459j), 
               (4.4387080072079064-15.104041751848293j), 
              (-7.8097025046510371+8.3711500708707121j), 
              (21.989294760031758-0.68797262916456581j), 
              (1.1755285682455086-3.9581904788544522j), 
             (-26.932038980135534-24.921241483414892j), 
               (5.7834745045480318-1.2669595183341833j), 
              (-14.755575707469731+5.6538279602130288j), 
                (13.00413955271155-6.5002889719399928j), 
              (10.423179954103981-6.0799540507663741j), 
              (3.4972043542716853-3.1532941099348673j), 
               (16.369427021632848-1.5368741482468982j), 
              (0.065629833927987075+12.531019369723621j), 
                 (6.44056487304975+4.2830228781993487j), 
              (-10.642206769299648-17.168795520363144j), 
                (2.5158206842212034+3.3500029032475127j), 
               (9.9125203856570021+17.02483410076502j), 
              (5.0715113807385226+2.6210393282810478j), 
              (3.3711862593529727-11.662769733488361j), 
               (-9.007177402022462+22.852978742775072j), 
               (-7.7776898778691095+17.45997199328658j), 
              (-9.6042460595924037+2.8386544778029732j), 
             (-6.2779927778772384+11.336087712404382j), 
              (8.3940452148479423-7.4157057253194196j)],
       [ (-5.6829892147843095+1.5316854549158723j), 
              (-5.6736117137599091+22.704433731556168j), 
              (-4.9388367370600168+8.403372017411046j), 
              (-15.747323709188603+16.981118023250684j), 
             (-3.5295654710336062+5.7906506154569168j), 
             (-10.014121113837104-4.1960959914320677j), 
               (9.4571542718476405+17.146998529114391j), 
              (1.9847410935514591-18.239149234536768j), 
               (14.084668239342585-6.6974495405114576j), 
               (5.9246158937603663-1.0892154259143134j), 
              (9.9948665266554144+27.144949467231271j), 
              (9.5706556758213139-1.0806762231170666j), 
                (1.820850076633262-8.512557020946879j), 
              (11.457642718579459+9.4219021555815363j), 
             (-15.254850352865617+1.5304973829115056j), 
               (22.502681738933159-8.3187782102366352j), 
              (-0.71408937592238741+4.0561975015549914j), 
              (-6.5000854220269719+11.129212119761146j), 
              (17.192259496048191-16.808057502955482j), 
              (5.1317015007017428+3.4793174356450489j), 
              (8.4834242691026809+1.6389913664324798j), 
                (5.9364205081729668+17.501054593588101j), 
             (-5.8966576768354244-0.98168387153823045j), 
            (-0.086256430103114512-2.8232947831094601j), 
               (8.7123541898019852-27.038114757363822j), 
                (2.2630203286863932-7.7959180909574233j), 
              (-8.607203057320131+0.32936638887746528j), 
              (7.0545021815728512-5.3334442803631008j), 
                (14.756248461189784+3.2772460847323206j), 
               (10.908264191718104-11.913167836345158j), 
              (-4.8899712339237666+29.637847715334821j), 
              (13.499687877103097+2.4118090867007886j), 
             (-2.7190473878843942+0.23384379739936592j), 
             (-0.95849542756205675-28.548762271167661j), 
               (5.6748245536170554+20.230641996068798j), 
               (11.725099032968625+10.770248209882872j), 
               (12.250137180657807-17.731842344546816j), 
             (-12.269823644396665-4.4763753765271517j), 
            (-5.5253674573939673-0.48213157509292504j), 
              (-11.355656749744579+3.7755912186003808j), 
              (9.4985015823870107+2.3319928203865983j), 
               (-12.006149284317706+13.730560287928583j), 
              (-3.0546681659703419+16.188944980596876j), 
               (8.8535515573689469-16.175767526448894j), 
               (-1.763896012334103+17.471610553008684j), 
              (-2.3110492309313075-3.2216697077550021j), 
              (-12.664934568429986-17.330232958995907j), 
               (-2.3333162434097785-12.260197073688133j), 
              (15.102240843091755+11.857002066206629j), 
             (0.18449574510540345+3.3056853815146221j), 
             (-18.667967499574189+2.0257097581376851j), 
              (-8.2227394000847767-11.963295002403772j), 
              (-20.340172426179581-7.9542387222549547j), 
               (-5.1491506253577963+2.5083015286819128j), 
               (6.7599178584204207-6.1468174827169317j), 
                (7.6847393092294052+14.17082525734096j), 
              (-23.530113422036862-7.7065794365640041j), 
             (-14.540702441351216+24.818802138273885j), 
              (-1.3181489192599121-0.61538356849008191j), 
               (5.9493616491610757+6.8347587134883838j), 
              (9.9383382917155334-15.388388889957668j), 
               (4.7609244547030869+6.2370653907154132j), 
                (27.634659820717321+1.667425688461277j), 
             (-18.155538835308015-10.242088210293165j), 
              (-3.3289767088360995-9.7418573881873147j), 
              (-1.3348161299784733+3.0718248439630202j), 
              (-12.346322851116337+5.1365330380227716j), 
             (-6.9051736840382567-22.857457533369683j), 
             (0.39049733772834605-4.9030081881385534j), 
               (5.5283839908352057-3.6891510680113053j), 
               (8.5276388734830242-2.1780009212533145j), 
              (-16.386559862938089+16.595405171681922j), 
              (-12.35643886870715-5.2187548744741861j), 
                (7.7080436902809533-4.4246176212981263j), 
              (-23.24978561368529-2.5677731182674881j), 
              (-8.0712808766492596-8.7780004486739145j), 
               (4.463152901187037-7.3931031034437957j), 
              (-6.1689027452265837-14.508588786721612j), 
               (11.799595863086816-1.9331573409745881j), 
               (-7.4199966634732917-11.24325540915769j), 
              (3.4714201026062277+15.272055989290161j), 
             (-11.177539341781353+2.5141811624820387j), 
               (1.2441141384747381-2.6333825467402949j), 
               (2.2809189982388389+4.8610099901183466j), 
               (13.317820677958743+10.119595537489046j), 
              (4.5557124175509873-7.5997778464701451j), 
             (-2.3635777555775803+20.892430663916333j), 
                (-3.8338314980562398+3.19265660820701j), 
                (0.64967641585047753+10.90453389481546j), 
               (-5.541595575697178+17.672478839270052j), 
              (-21.411374923171337+27.877565459982367j), 
                (13.013500539500193-6.7276153504069471j), 
              (6.2347795698654593-15.664231269533815j), 
            (-0.44274250093039835-8.2897197214567147j), 
             (-3.2461113795982177+9.1972331498207467j), 
                (7.921607353129887+8.8362915835513416j), 
                 (15.1142250430525-9.6754241523601578j), 
               (11.548021177361729-4.1348865699046504j), 
             (-11.528656266519839-6.0169365825401577j), 
             (-3.2719667689384302-14.229153791570788j)],
       [ (-16.272666762266997-1.3478635349366703j), 
               (10.368451127179572-5.6312941197407174j), 
             (-14.186474870022149-2.6438569851887763j), 
               (2.2863069956532796+8.0589097011358746j), 
             (9.7263011776916013+0.79093935343883182j), 
             (-9.3539194282140343-2.0377007768368536j), 
               (27.368305086413773+4.2017572746897898j), 
              (-5.823638012187029-6.6907259573068014j), 
             (-15.919422081146593+0.41814130319593051j), 
              (-14.454084047512437-2.6199414873541138j), 
             (0.38750685981957628+1.1332950764162228j), 
              (1.2369147105507015+16.220875652473531j), 
              (5.9528879111048036+5.8320413314221433j), 
              (3.0435470117315373+3.7218722962918411j), 
             (-20.645407354122497+7.9291472551971633j), 
              (-5.9521724307537225+7.5961403819051565j), 
                (1.8596009242246148-4.7309955458460742j), 
               (13.278323690852197-6.1228711521558656j), 
              (4.2672842800432145+3.8615255290407347j), 
             (0.47724470986296308-4.5505254876150438j), 
              (1.5298479772495501-1.9683937898523891j), 
                 (20.50502553265683+1.3770596318229444j), 
              (-11.498758726935208+9.8220695174648771j), 
                (9.802920981427949+12.341519355944403j), 
               (12.556786237962225+3.1707167411057191j), 
               (-2.4853395353268311+7.6879702840845212j), 
               (6.3322724947022113+23.654426506844565j), 
              (3.4386184096219781-4.6866999446299804j), 
               (-3.5193668892291479+1.7486865190940288j), 
              (-2.6684088881679688+5.5500000576008413j), 
               (-19.844868097630243-2.520935496991636j), 
             (-2.0511407800512376-1.3254633366629962j), 
              (-3.9718046385762906+17.599615520732563j), 
               (16.104287548270161-1.5076105914479312j), 
               (3.3545018474434674+12.279687292998172j), 
              (-5.5258873593409117-20.281212461556912j), 
              (-4.0226680275304343-3.8005948043048892j), 
               (5.569845455184125-8.2751635694718448j), 
            (-0.54308697098103553+7.6545954978240722j), 
               (6.5324847698719886+10.943637298040008j), 
              (-1.7358177441066769+6.795976554555935j), 
                (-5.9737685436431489+2.802887036074329j), 
               (16.582598042733675+6.1983538207003193j), 
              (-12.302350564118957+5.7842929188334091j), 
               (9.1123692052914134-5.5527254644594395j), 
              (-8.0020533655129427+7.1778272940831753j), 
               (0.060639243507374173+30.8762047288186j), 
               (-9.7758755030555999-10.535325761694024j), 
               (1.8918813531777254-3.238750261042501j), 
             (-3.3330757151103034+4.6957461782999417j), 
               (4.5600447498324872-20.60835303271422j), 
               (3.5395432943489604+4.3574045116658455j), 
               (6.3251636882278657+9.8222195116340174j), 
                (0.9204485576684206-5.7013248363377045j), 
              (0.22792752617986464+20.754987677557246j), 
               (2.8015184234822805+2.4248990208128411j), 
                (13.355970836806144+2.349583121871285j), 
             (14.550945542319875-0.71797556989859912j), 
               (-5.8813991171617266-2.6979207509863778j), 
                (11.324865863287899-1.984305310103383j), 
               (4.913367144088312+5.5428955924646868j), 
                (-18.835146889938347-3.99121200831476j), 
               (14.169173408438239-1.9554651836004944j), 
              (6.0516475953156847+14.324873595742449j), 
              (-17.793581704755532+17.328919556327314j), 
              (-6.5151512380904952-11.884342232367546j), 
               (10.715722389216509+9.1777707499510299j), 
              (8.3235269241183421+4.8169212893157063j), 
              (9.1621024048444255+4.2334506504399734j), 
              (-3.6409134043310627+5.2638259637668439j), 
              (-1.5250222790050585+4.0789165457909222j), 
              (-7.5386220655589238+7.0199395549289427j), 
              (19.88356340676188-0.88856876579869737j), 
               (-6.2752040447308897+10.914999075520974j), 
             (-8.7627539459361934+1.4980536182103412j), 
              (0.60536554694438394-21.408357016884256j), 
              (8.6426772998924974-6.4868009310366448j), 
              (2.6434446900887627+0.57008602930046037j), 
                 (17.19025363201505-11.94147968323316j), 
             (5.2373628655832851-0.054271341017634943j), 
              (5.7376265034371308-0.8040332365267584j), 
             (-18.819421555513173-5.5980575668559833j), 
              (-5.9752020653086859+4.5450782506755036j), 
               (1.4381465011762271-7.3787250583544148j), 
              (0.32865043810378936-12.635256538961562j), 
               (14.655672336985873+6.584896752571213j), 
              (1.8728432940700601-4.4449558193504686j), 
                (-5.391725318982906+10.70887120575243j), 
               (-4.2959852559067038-7.8940241914839318j), 
               (1.0252084877756515-13.460597233162295j), 
              (-11.514586771166879+4.2384042006841529j), 
                (4.4159744269642625+1.1743691419077094j), 
              (24.596028610211846+14.442448810373151j), 
             (-7.6255986678539074-14.271587821940809j), 
              (-4.725944394363454-14.051980305907428j), 
             (-0.14360698533743474+3.0901254334367971j), 
              (-9.105257145609162+0.35692341723666332j), 
                (5.112886362889367+17.025416392145235j), 
              (-1.355543604955793+9.2711582512101689j), 
              (2.5856071250811068+6.8643482995796248j)],
       [ (-10.613211448902661-6.3557900111566674j), 
               (17.669564537195399+21.915772152971655j), 
             (-7.8240971111360569-13.436264025121998j), 
              (-5.6151642952554157-12.277837263616702j), 
              (1.5012092203853049-6.7166097928791944j), 
             (-2.5861706848083941-8.7471644694890465j), 
              (23.521064999575138+0.14636436602098352j), 
             (0.40389744507537023-22.672170845043649j), 
              (-14.637483423845641-3.8038309182806023j), 
                (-4.33202557302989+6.1222002151990926j), 
              (8.2931768469307556+6.5895621163710576j), 
             (-5.1376106138479019-5.5903713277543678j), 
             (-6.6158341575160957+5.8714756642565877j), 
              (-2.335439643350993+7.3791101560465568j), 
             (-2.2601840951083236-17.001663282151934j), 
               (14.255053094970094+5.2981855351423999j), 
               (-2.3282912599219041+4.6249899889613459j), 
              (-8.0418846002607047+1.0632676922038862j), 
             (-3.4117856294340361-14.499181873700861j), 
             (0.22705068567056685-22.851144099125129j), 
             (-3.0001543968232003-9.9534069010485382j), 
               (7.2863736172797777-0.21279684609526911j), 
              (-3.3019759937862587-3.9635280848827499j), 
             (-8.9944545482351987-0.68159182688562536j), 
               (-8.1759915321562318-4.484019252267947j), 
               (-11.572918116664017-1.5324706009295173j), 
               (-13.796680318115426-2.624190604023533j), 
                (18.536201463953315-14.9819655259929j), 
                (1.8573924628666476+1.2086284130628493j), 
               (13.398644439080181-9.5176389945239883j), 
              (-6.6465801182107054+5.5958500105253197j), 
             (-4.8428935623229137+21.330046063533032j), 
              (-0.93697773386693095-6.137689479768861j), 
               (23.523061610943124+13.375987720984499j), 
              (-4.9878894337728621+1.9604517310457792j), 
               (7.9142781161553044-3.9498595392996538j), 
              (-21.285723132245273-8.7729651152833075j), 
              (8.1329130287494174+17.237008294692892j), 
            (-4.2467083090967614-0.60207622918393788j), 
               (10.653684121911212-7.5206583332436274j), 
              (17.241340132156804+5.7801528554694084j), 
               (-11.146235236267163-6.8707839267503346j), 
               (6.8079588501178891-3.3720228407679942j), 
              (-2.5994927271252517-11.440326233134591j), 
               (-5.408281063706867+12.694965108950241j), 
               (8.1160363583936217-22.381353228367139j), 
              (-6.1436627242954991+19.395552844312313j), 
                (1.7666098793820013+1.8743901763547681j), 
              (2.8572308458423246+9.0659229396565948j), 
             (-6.7751538436734871-16.148390603609243j), 
             (-16.544468398027902-19.886019315534355j), 
                (18.81604209146797+13.453228383420253j), 
             (-1.0205046685357169-0.14464631323313892j), 
               (-5.5130735879334409-19.924933894032417j), 
              (-7.3182590993253216-20.935678696002604j), 
              (-2.1574520183306989+4.8747019956713817j), 
              (-12.689815973840846-1.5150522829500663j), 
             (-3.0002058705905728+16.505262669708856j), 
               (-5.3696721920637227-4.5361597926109782j), 
                (4.9984294092038049+7.750268821288393j), 
              (8.9823105260881224+2.9699589515248466j), 
                (9.0926171952295505+12.82278639372999j), 
               (1.5055227841468137-1.1348015849414121j), 
              (10.242803133191899+1.1925733013403432j), 
              (-4.7457339866891441+2.5975907045644191j), 
              (-15.195056382806197+15.954616016744778j), 
               (11.150328130462654-1.4344732316811277j), 
             (-7.7558928115429087+7.7015240904295172j), 
             (-10.156096400235228-1.7217833877611217j), 
              (-2.8388978202270576-16.450778283794143j), 
                 (6.4477868373908844-1.02495259850573j), 
               (-10.015341554186071-9.113412471379517j), 
              (1.4308881494426504-23.758967375163344j), 
                (6.4392276418048464+2.8230058298942633j), 
             (-19.280996253457726-21.424917601653959j), 
               (5.3020779003475491-35.794225640276629j), 
            (-14.333376007210177+0.26136157624710254j), 
              (-15.099427210441954+2.0783410509464328j), 
               (28.132192655061885-20.794722967461045j), 
             (-0.84808851585114109+9.2719800267971646j), 
             (-17.578636735968015+13.000858708598086j), 
              (-10.66371760852244+21.528676833389206j), 
             (0.037102797538971333-20.821639833190048j), 
                (3.969249254892715+3.0498706572485217j), 
              (0.66294963853568101-3.9195186300411686j), 
              (-17.882477408626261+10.98710514402204j), 
              (20.926125823401254-16.473198479796864j), 
               (2.3360153539389779+7.9349717879433959j), 
                 (11.20618958086229+4.4923728809394952j), 
              (-11.472925434192849+1.2232541477148979j), 
             (-0.46976839344934673-9.2023950639867991j), 
                (4.2159907449147376-15.765338469818033j), 
                (11.65674164947966+3.648422129204314j), 
              (1.4113514005451733+11.885720184753392j), 
              (18.490482700547155-2.5345973423965233j), 
                (9.3412919791920448-7.302028558294948j), 
              (-20.254600879907187+4.2882035280127102j), 
              (2.9003776024052588+0.15421574200132046j), 
                (24.39280296152279+11.06735036120911j), 
             (-1.6030801497465097-2.8077191253616074j)],
       [  (5.8352321982969189-10.074077072168709j), 
              (-22.547433542002793+2.6607592510793721j), 
              (1.7948486406082513+6.0733925920016887j), 
               (11.470050088793744-5.8029116071753304j), 
            (-3.8467489949392819-0.98841873367585564j), 
              (5.0899866495273169+7.7400668971051232j), 
               (2.0442311819098369-5.2998881419832902j), 
             (-26.495314002712092+4.6644827674532632j), 
              (-9.3738336472568236+4.4634213632967548j), 
              (-16.217620951378663-1.0434339959407977j), 
              (3.7490835942114509+4.2515512939762328j), 
              (17.002635172666078-26.790555828611829j), 
             (-6.3865725949761218+5.8742646842587618j), 
              (2.4909328537518274-2.5627404288914892j), 
             (-23.140846063052273-8.3058373506850067j), 
              (-15.896420955545995-14.389140266130184j), 
               (-4.9708218978076788+9.9307498328482673j), 
                (9.2778630050701878-3.212419087357159j), 
             (-13.754825142089107-1.4826330921844055j), 
             (-8.5836783019871117+10.987191155312583j), 
              (7.7346089189745273+5.0000200322179698j), 
               (-8.0024506050062811-1.0102765477740925j), 
            (4.8242031087913926-0.0058054338135186002j), 
               (9.2577148278844383-2.0014546289058859j), 
              (-20.941758391192195+3.1409661492708625j), 
                (6.6943698353684953-3.5864259179104159j), 
                (-1.257678480530219-17.13043598837876j), 
             (-12.082566857950086+13.031561976603601j), 
              (-3.8246233174770818+0.37230891542429972j), 
               (12.929801566567349-1.0474578129799834j), 
               (12.398963111568349-10.038423299006865j), 
              (10.532806991721761+2.1737888936767753j), 
               (13.200197938646989-3.4190506880414375j), 
               (0.2710621102120867+1.8803076775856153j), 
              (-2.1769163827203144-3.0880609181514229j), 
              (-2.9150475453692866+18.050703539174588j), 
                (18.78475824614258+4.6803329994938689j), 
              (5.8104672913314133-11.976973620478597j), 
              (11.314915355473353+13.328282024082064j), 
               (0.2723691662793582+11.830709664148396j), 
             (-4.4138312749174089-4.6957156922747352j), 
              (-0.43221461414542894+22.854766305254692j), 
              (-4.5549924568657136-16.771069384063466j), 
               (8.5282301689642672-27.710148645784912j), 
               (8.3943305236400025+1.6103793458717752j), 
               (3.3509606200764348+18.593256001156455j), 
              (-9.1913705501394265+3.5814258871966427j), 
                 (-2.7380558379863751-1.79230528593439j), 
               (7.1345344656844745+6.522850560468866j), 
              (9.0637045467340229-9.2934542192172405j), 
             (3.3330816597572985-0.37384097425624563j), 
                (24.58146628941163-12.666193148492864j), 
              (9.6765421200797466-0.41902469482436588j), 
               (-12.296799248277972-5.7701397794499778j), 
               (12.99947451095832+0.46670784934490728j), 
              (0.14413678134145352-1.7723569444947707j), 
              (-3.1271624231312112+6.0674845134988251j), 
             (-3.1656428409630077-5.1789639164871479j), 
              (0.063872947220816115-11.489958609779933j), 
                (8.100100040961248+12.945080535591414j), 
                 (1.142148657124159+6.30561471745244j), 
               (4.3014323525568461+12.918692240240519j), 
               (4.4388788414325511-6.0814988418110065j), 
              (3.8432869133794552+10.752630809919141j), 
               (15.769695320068418+3.3889805237292538j), 
               (2.6296016486025198-11.104772705312612j), 
               (3.4045674899899208+12.503648484860699j), 
             (0.73984496831383506-5.3503961886341234j), 
              (8.8659215078739244-4.1458707666420933j), 
              (-7.1800545920364742-8.5995124452377052j), 
              (-2.7425230168192805-8.3097329671183822j), 
              (0.70777808832186073-24.303145631233647j), 
             (-5.1344598484244948-11.206480566385157j), 
               (-18.299322182552928-4.2837523722809738j), 
               (2.459758445538919+3.4832133519644763j), 
               (-6.5652326140807702+3.940284249375781j), 
             (-12.766404660989931-13.282969066032136j), 
               (12.254989552110093+19.541450195564231j), 
               (12.305582647806927-19.444765044651472j), 
               (15.151682914043491+10.698644240547463j), 
            (-0.12250333838604806-4.5524225814528023j), 
               (12.161012233221269-12.30700564898479j), 
             (-3.7403940199704078-0.64263251185029091j), 
             (-0.19562201462822862+7.9090035872227338j), 
              (20.225621680628215-0.14896222782092922j), 
              (16.375773426965978+8.3643245254200913j), 
             (-1.1911280074771993-1.4463049296614954j), 
              (-14.721059333367542+24.015845182505537j), 
               (-13.944971160218291-11.918158834869281j), 
               (-4.0614873903772901+9.664570344026707j), 
             (-0.27044866092060199-2.0406454552417665j), 
               (-1.3452554333584235+9.7724172104820042j), 
              (3.6322802651118207-6.7291932545560016j), 
             (-4.1124579166132644-10.733406021362802j), 
            (-4.6501392766427738+0.55421250991232673j), 
               (-6.592086585012618+9.1230269803273885j), 
                (9.215011497582168-9.5169294429641891j), 
                (1.3202620555767539-3.486742312340346j), 
             (-0.17004099419505636+4.207505330138563j), 
             (-0.69790424983021948+3.417163339246263j)],
       [  (13.566367909218398-12.818394172736713j), 
              (-6.7172046159607035-12.861494815250721j), 
             (-11.590513640547108+11.305284577159341j), 
               (5.9763474099114378-9.3558505308903221j), 
              (15.466980417667543+5.9352042023969425j), 
              (-6.422445773627123-8.2706171114806875j), 
                (18.39834797519211-1.4696144607656867j), 
             (-7.1242675927657304+24.087074093366951j), 
               (-7.917071389087992+3.8034544648146373j), 
               (-13.800671569709644-5.497506518282016j), 
             (-9.2860695066043473-2.0368302422889268j), 
             (0.82544247994853159+17.882369231907255j), 
             (0.14044342105397953+7.5680811555065128j), 
              (6.7137880222798305-5.6494063965037054j), 
             (-11.705967473152308+3.5531375589736962j), 
            (-0.032662541578770563-4.8400886715993989j), 
                 (0.6735529781297579-2.489751848807058j), 
               (6.3128081196023071-1.1357403540215412j), 
             (-0.7551572526963507+9.4283678427074094j), 
             (-11.517640504434102-4.7533164326530866j), 
               (8.5405012452321039-13.94217514646545j), 
                 (5.019284766885975+5.8409071417380618j), 
              (-1.5130465673826876-8.9802389496417554j), 
              (-5.4848552581335239+6.5198528550729948j), 
               (8.9391948666130414-11.526688823876583j), 
               (-8.0652096057439469+3.2301918242548893j), 
                (5.773547600751705+6.1754754520408328j), 
             (-1.7591211881792146+3.9882592379873576j), 
                 (6.5781688094769279-24.63065625657029j), 
               (2.3247860696074389+5.7889313255412835j), 
               (1.8931316439927848-6.4745181101412683j), 
              (-16.207999485798688-24.50835012646813j), 
               (18.060480172192833-3.2339561915417487j), 
              (-14.711575206717074+12.345335664365699j), 
                (16.420561915244694+14.93687043106272j), 
               (3.1990673655107753-7.9141148059957658j), 
                (1.0827798876692567-1.514239970006712j), 
             (-2.1125118901657438+2.5702532673848517j), 
              (2.1340438809597813+4.5539894230833928j), 
              (-10.781637439316148-1.8659840642020076j), 
              (24.307727012917386+7.3305623543420442j), 
               (-21.789078935289066-17.653745700762752j), 
              (-7.5694983736791075-9.4258837272315894j), 
               (5.7357618502935139-3.9808280918269805j), 
               (4.7897051575141711+1.8742310081617579j), 
                (4.3675619409712425-2.414086220876261j), 
              (-29.532794102462148-10.156741579910271j), 
                (5.5644141319045222-10.676057178595551j), 
              (5.2846611771125342-14.750067447769172j), 
             (-2.5970568065364792+4.2575476504380099j), 
             (-14.092006053115618+8.9945834402103344j), 
               (2.6854949112555255-2.9789641465129284j), 
               (-7.751503729583602-1.9664291946687502j), 
               (-7.2400047548681732+7.2343691068794609j), 
              (-16.012646447649914+11.220971779772245j), 
              (-1.6206675996190345-5.9623786299999875j), 
               (9.8945303611298954+6.6952589528225195j), 
               (3.094226933624256-3.3769327585117974j), 
                (-2.599598357954656+1.4499938221832713j), 
              (-17.034508410429591+15.983845897014536j), 
              (12.751688453760845-11.847419886832339j), 
              (-8.7112606279744806-3.6138977840203679j), 
               (9.6621843163468615-6.4434112044573517j), 
              (14.198610988982745-10.866097807674556j), 
              (-1.1336410163014561+1.6797343171906578j), 
              (-16.856768572843237-3.2902508128681522j), 
               (3.7325561510883194+5.0998169664489659j), 
             (-5.7170537606503116-5.0011082681249786j), 
             (-8.2306325160796696+5.2288915584357802j), 
              (-7.3468826821378217-3.0119311984318347j), 
              (0.80261706020426971-14.665125887276666j), 
               (10.943868606822345-6.6974840917773015j), 
              (3.8363292742671935-0.2270074865805545j), 
                (-21.98799167822623-20.852297879514833j), 
             (-1.3764655026853478+20.133353698546724j), 
              (-14.226461988030408-9.0377985101240057j), 
             (-5.4244348275799332+10.988119042440875j), 
              (-16.303180337805003-11.938123189764816j), 
               (6.8911163561330522+4.8684007766479835j), 
               (12.358012889909036+5.9252395119812418j), 
             (-4.1555758665382196+29.409769026096193j), 
            (-24.095497072854798+0.40877824786247252j), 
               (10.095228409719557+5.7337912685793739j), 
              (-10.187241232831036+4.7597707658689457j), 
              (-4.8823741008882005-8.6096379749557279j), 
             (6.0183220280698544-0.10982015051118106j), 
             (0.88251913161582884+18.220503406604699j), 
              (-3.3968167741964548-6.5854835072374032j), 
                (12.383517734838595+10.514937519232312j), 
                (7.590602147831639-1.6338597216115769j), 
               (7.3513146704944834+7.9525913541293267j), 
                (8.0702754164187702+4.0326747579524111j), 
             (0.41310664512823142+21.295864901969722j), 
              (2.5704804932843741-9.5101519870041624j), 
             (0.72058189765479264+19.159541786501638j), 
              (-3.1960447491088622-17.620796661468642j), 
              (-14.741747908666634-10.300062442169903j), 
              (-8.9936357340110114+11.785630484025473j), 
             (-10.997543728235105-24.284177276840779j), 
             (5.5134821870774298+0.55218364328534941j)],
       [  (16.226776091779612-5.5590635365979697j), 
            (-8.4722374576534083+0.033785087855415667j), 
               (10.04463531501721+4.7302586804473306j), 
              (-9.4475808559380585+2.6538730638254338j), 
               (2.3903834257387873-10.59124975830321j), 
             (-11.943019112244109-1.2261053319867303j), 
               (16.251754641171267+11.984049435300266j), 
             (-7.9406379818381918-3.6649216964674736j), 
               (21.453407863523793-5.2565597404050992j), 
             (-4.2798317926971139-0.33011265167400022j), 
               (1.362833789761007+8.9900959645801031j), 
              (6.1544465108486124-11.762626342603365j), 
              (2.6484030967294019-6.1557666101550961j), 
             (-20.168580948824207-12.252517852116762j), 
             (-16.223445372838981+12.972762484556421j), 
               (15.302892870837772+8.3398284477113496j), 
                (-8.1535054689586008-1.242548234356651j), 
               (13.244580641705415-5.2017728723235015j), 
              (7.1210436587917734+9.9945794008200544j), 
              (3.9406517236480525+8.9164663928087471j), 
              (-14.20493830607761+3.1456799856979334j), 
               (-4.5961660424769759-5.7403240376420186j), 
              (-1.7904011717577559-12.927489126799312j), 
               (3.5819060752063399-21.667038902820895j), 
               (-5.204735771874569+1.8684104784525766j), 
               (-24.283081523084007+9.2022086920749544j), 
              (-11.252996458647786-5.2684998105770937j), 
              (-3.1883391341315583+1.719130119203145j), 
              (-2.6516980732437001+0.31728450145812737j), 
              (-6.2533797557622837+7.8031229802407607j), 
              (-13.361064843852153+11.638687494784623j), 
              (-10.240226185703072-2.310755977027052j), 
             (-16.844888779553578+0.16150862875512542j), 
              (-11.549810949919717-13.201704519030514j), 
               (2.4032567853508224+12.396576854553985j), 
             (-8.0837804797326012-0.84863580400147176j), 
               (16.949351098256201+7.3139637534636108j), 
              (2.6868076599612047+3.8162598382975954j), 
             (-23.693769155145027-10.918803323458697j), 
               (9.0347038478125459+15.787273701523951j), 
             (0.57687195693058868+3.0186862622809807j), 
               (-7.0501325450743524+6.7883710093276299j), 
              (-1.7215948293500931+14.714156450647389j), 
             (-6.1194573394088856+0.39364649751935754j), 
                (2.497784342744811+6.1032152420670469j), 
              (-2.7328982064432674+15.308155074628694j), 
                (16.77386631979094+12.023991106698437j), 
                (20.375476798402353-1.9090654897669324j), 
            (-0.81209635184695939-3.9096411407125813j), 
              (4.5200995966293167-4.8196685209642469j), 
              (-1.4589188367505614+10.84945667773315j), 
               (9.3433815610193705-12.354264502208149j), 
             (-9.0844745744451796+0.41537010674364561j), 
               (2.1097560045021324-0.11577353458609689j), 
             (6.0170735829303723+0.087421147726843035j), 
               (3.6560906254294743+3.2013150389959493j), 
                (-2.961781925101032-4.348425055140539j), 
              (0.99610872563801756+20.44201473818578j), 
                (5.3269276900654141-7.6506716634308969j), 
               (11.987247385458081+20.109438242669047j), 
             (-16.907040840766491-29.794228895932942j), 
               (10.302747371879784-3.0275969140138348j), 
               (3.5221459932485937+16.668798868184961j), 
             (-15.666594292833111+11.959692605909353j), 
               (14.274286457848895+7.7940394916453082j), 
                (4.3478337370118574-12.58492805815745j), 
              (-8.3257743515391596-1.7759434465397104j), 
             (-10.340827229726306+12.249179404755758j), 
            (-0.28824572337266136+6.1757389842118018j), 
             (-13.862374441631216+0.89210763810409621j), 
               (-3.2503977980351428+10.49754058423181j), 
               (12.975013416913811-4.8337748615829614j), 
               (6.712824052132377+6.2055408323990502j), 
                  (0.29151730078675581-9.4526989552659j), 
              (2.5907478325404156-9.6381314981191295j), 
               (20.692146931828471+7.7237211125956673j), 
              (-2.065955883128066+7.4882566883867065j), 
               (6.1331410545536276+11.705468413054296j), 
              (-15.054185777876516+3.2535092970608299j), 
               (-20.801305103045369+10.99694594402729j), 
               (8.664198946374718+3.8255994198142207j), 
                (6.289400581631007+1.562615936802042j), 
              (-4.635365877907117+0.34197593895852918j), 
                (11.98946997779942+6.8339963601170481j), 
              (0.15940315557459697+15.736363159169397j), 
             (-11.176176204033979+14.546665866661341j), 
              (24.851247373468862-16.716550869880223j), 
                (1.8402232310824691+3.609672942651776j), 
                (14.768861544749889+13.157516658538722j), 
              (-21.962797139076446+9.7354273379873533j), 
              (-8.5541662980165203-4.9882881833786712j), 
                (6.9178005675700138-8.2329720155889028j), 
             (-1.2763204396679679+11.793703422614701j), 
             (-4.6479777073711901+28.028084701674921j), 
             (2.1225075130682485-0.74442265922435213j), 
              (-1.8395044318863676-7.6491228834282667j), 
                (2.6221195179109764-2.050356400547555j), 
              (-15.406259038217573+16.243521293574364j), 
             (8.7336191612261231+0.47404978393708075j), 
             (-4.6667483386486692+9.2807242733713977j)],
       [   (1.529879694506473-12.465213417556582j), 
              (-3.9359556868702352-23.991821728369494j), 
             (-1.6934885626963794-8.5719477464856517j), 
              (-14.910154167741695+1.7620975038159614j), 
             (-5.7342557842660966-12.284841340289457j), 
               (6.841800158091532-2.6539774474556839j), 
              (-13.798511909721284-7.5248142566942953j), 
             (-6.6658316784080345-6.1487488128253922j), 
                (10.60052282626976-4.5004840475020718j), 
              (-10.359049992594747-1.4706119709151897j), 
             (-11.041924012029298-12.453861390302096j), 
             (-6.122201229659967-0.96483276156071196j), 
              (3.6843836597578212+7.2320640874796416j), 
               (-7.30459775074526-1.8507554196383769j), 
              (5.1524162249965011+1.6818579903820701j), 
              (-5.6206117797079891+8.1859456380289455j), 
               (-2.6243374802613122+11.367297467379242j), 
                (14.146621270256068-5.094049411087739j), 
              (-4.473563956677328+7.5459832931049844j), 
              (3.7255147171762788-6.7750916000199259j), 
             (-11.043503116209713-8.4473081468157805j), 
                (13.039086057131923-10.759675330703626j), 
               (-0.40817905451391434+10.5050361217806j), 
             (-4.7077847643820716+0.89359522024099425j), 
               (3.7254973663320481+8.2325809092365692j), 
               (-4.1869149369444454+12.596297232463623j), 
               (20.880262647785223-9.0467265532407808j), 
              (-10.66566116768324+2.0414785357747438j), 
              (-3.2439663233204721-0.25668833491382165j), 
               (8.5157537785876425+17.270205142836609j), 
               (8.0855790582195528-12.257105497548526j), 
              (-4.8397893876808027-9.811307411494731j), 
              (0.17677171699027416-11.398497343912293j), 
               (-6.3556781519556518+12.30720887426161j), 
               (8.4451253280323737-14.317084678088033j), 
                (3.723805559332007+3.1801564955298014j), 
              (-3.2777360817521117-7.2467227982883742j), 
             (0.74277605063034591+4.4519718073436474j), 
              (7.2428078548716979-13.922866592277494j), 
               (8.5211789501533897-7.9015802036801794j), 
             (-2.6330784768753546+9.6694991645391539j), 
                (12.902304208734561-4.1184108080555104j), 
               (11.691586099911609+5.8508457415505211j), 
               (1.2582232556645589+3.7658316413595565j), 
              (4.3805125979585533-0.86144697716968655j), 
               (16.746782139714849+4.9442393157028244j), 
               (6.6401929770508694-11.790011803152913j), 
               (-15.171859356808021-2.3058435404633695j), 
             (0.36388946452571019-5.6576836667874817j), 
             (-0.3215684401371135+10.767580143829797j), 
              (2.1662052131825931-3.1709130899394844j), 
             (-3.6680768239741139+0.58594581315240302j), 
               (-24.27936695383401-11.626197363944657j), 
                (12.895010992297578-6.1122552825321117j), 
             (-6.2872578879016334-0.63453450651523036j), 
             (-7.9321137932398553+0.63672289503379609j), 
               (16.510494010995892+1.5896438791624283j), 
               (18.877957690204148+6.952489567100856j), 
               (-9.5528982265642206+7.7066468540646831j), 
              (-19.923588099585626-17.705290759337132j), 
               (-4.96930657135443-7.9510091871714241j), 
              (-3.3268750403128418+2.5363339861694505j), 
              (-3.3539691232652076-20.366206820095371j), 
            (-0.73455083401890642+5.5970714778129373j), 
               (4.3370014226510971-2.9525725697318577j), 
              (-2.8690305221891306-4.2318376458689118j), 
               (14.601339373661549+5.8362964156505992j), 
            (-0.90211303629032558+12.574023137064232j), 
            (-0.53880775471075448-16.763006652845853j), 
               (11.996334307430338+3.9028775860612304j), 
              (-20.384319586682093+11.348236164231489j), 
              (-5.1512313992581626-4.0187282904476236j), 
             (-17.839041151066304+5.1752540136139267j), 
               (-6.8032426460641684-23.416037422867376j), 
             (-12.265675176406109-11.126607100852258j), 
              (-27.301916995310407-1.7808097775266976j), 
                (4.35438095665753-2.3309565837357251j), 
               (8.7083084899995438+6.6790833619197967j), 
              (-1.8138152178634042+6.9524672197915338j), 
               (1.6854136327889226+2.3100200656156491j), 
             (-13.654676155525777-9.6938882190869951j), 
             (-3.1186544613213023+2.6152036936345406j), 
              (2.1216534801911378-0.79066912598188521j), 
               (8.7773347755198134+23.635991004719877j), 
              (-2.4538099535000231-5.2256554020852386j), 
             (-10.060475922955778-3.7723621632833311j), 
             (-2.1122846151916921-7.9886241478450435j), 
               (-9.497389401899385-3.8184079244216558j), 
               (-10.939979938281644-4.3818596949531639j), 
              (-6.5737546720410798-1.3791886969594571j), 
            (-0.59524509520125357+0.23822947508019676j), 
              (-0.85956438371381272+2.1670748241805553j), 
              (4.1260076526145451-16.208141216201678j), 
              (26.514234164355276-1.0520346093197221j), 
             (-2.0828482112523505+6.9086021828253994j), 
              (-6.2098173906880936-18.990793763563715j), 
              (-1.6530847253397232+26.443865799337818j), 
              (-3.0176313103369496-10.646591596453526j), 
             (-5.5706595273697843+21.483027555809141j), 
              (9.4232455058676106+14.296155714938415j)],
       [  (-16.45846648602215-7.4839600988959543j), 
               (4.0580287243387136+32.822864626113152j), 
              (-2.6963976077940996-25.07938272392208j), 
              (-17.789380713806633+9.8577577629644146j), 
              (2.3275584663498501+9.6819237989665687j), 
             (-7.2246251784376909+5.4985303209433125j), 
                (2.7642077943681276+7.925140279163414j), 
              (10.342444957992097+20.016514193466278j), 
              (-3.6343440708273391-13.344337191416901j), 
                (-20.09001902709231-20.63037414535648j), 
               (5.2635783232223705-9.030439253617299j), 
              (-4.0268482138509425-12.77910002079469j), 
               (14.002478395455267-2.945093588027905j), 
              (2.1375257087481203+22.020955474940649j), 
             (-5.8955311302966349+2.9046527174985872j), 
              (-2.3602848900502007-7.5776707841644386j), 
               (-12.174395492755856-6.2388754211722608j), 
            (-0.62573707425874525-0.32058157508432805j), 
             (-2.8302630482603948-2.0749143119222566j), 
             (-10.802584821522432-2.3761720373763962j), 
              (3.8774597055036306+4.6363482605724249j), 
              (-0.34099844448874672+4.1115423510222397j), 
               (7.9309357545041959+11.351392144315808j), 
               (4.2642268365132914+13.664925281298769j), 
               (3.0537676899237405+3.9107694803118545j), 
               (2.720351845876583+0.065712845972677375j), 
               (5.4821125855191983+10.528313653356395j), 
              (2.4697091803387221-10.077799926283646j), 
               (-8.2516537187010215+9.1814279005037349j), 
              (-13.617166367764554+11.797161837789137j), 
                (2.881537243625278+26.407939226941966j), 
            (-0.10591163675473783+12.060957473261926j), 
              (-9.3247114069349273-13.788900362224847j), 
             (-0.29501351939507131-8.7177938004722808j), 
              (-2.7560375458496815-2.0851536203780676j), 
                (6.6259260543704901-13.44835436396192j), 
              (-17.870252296261938+1.4912771873243205j), 
              (-6.798748329328685-1.1750441028336254j), 
             (-3.9816624129615934+16.167847062477875j), 
               (18.707999033023583+4.9543490622502029j), 
              (1.4461291542636814-3.9391944893774831j), 
                 (2.476386438837952+4.5755620649785902j), 
              (6.1623496221684597+0.76592801289290124j), 
              (-17.712430428831254-3.0576420927228272j), 
               (7.5820925873676881+2.0612837378810154j), 
               (-3.8630216750999766+3.440296309158597j), 
                (17.151404786460887-14.76420216801329j), 
                 (19.41722391052047+7.2961854613144075j), 
              (7.8905399347189746-4.8782882188327532j), 
             (-8.3202525831181529+7.0465518465490877j), 
             (-3.9676684558476309+1.9406059833863654j), 
               (-15.041270982706386+13.89636761403677j), 
               (2.9801217424629201-2.1965334267684731j), 
               (-5.2224361574133731-7.2911603337523871j), 
                (11.570488681230957+16.18819354148285j), 
             (-4.0663780512552181-0.23509276136060064j), 
                (13.89867608148429+11.290126214161432j), 
            (-0.47776473243076961+6.4126221748583481j), 
               (-5.1743019001856494+17.236374857176344j), 
                (11.441624475238619+1.094349708172885j), 
             (-6.9561356861702786+12.893615446685162j), 
               (5.1199903260314015-9.4379297888864038j), 
             (-10.925419284964768+0.23361698030876532j), 
              (-13.197028830011382+5.962830924670647j), 
               (1.9727789064250185-4.6745012618446307j), 
               (1.1401913191878199+1.6151674990940676j), 
              (-8.8219602110984638-4.9116980514324853j), 
              (4.2407311544405601+15.671351237777934j), 
              (-6.368864978351656+2.3285521312048978j), 
               (12.505907203982909-10.949469400708956j), 
               (1.5026092568715719+24.873883311055206j), 
             (-0.18033239279670565-13.321288725495517j), 
              (14.001577417877666-13.662460702676668j), 
              (-1.5454020368325794-0.42845413101642327j), 
             (-8.0468838141832837-6.4358000747282507j), 
              (-11.111435190785119-3.7258776420635091j), 
               (21.015549064461414+2.449140129443327j), 
              (-12.994375657449586-20.685042328777776j), 
              (0.63099496188657112-2.3669026595571974j), 
             (-6.4944581579030212+0.93415358593288911j), 
              (5.2968901397219579-1.1175684596013318j), 
             (-15.907326831357171-5.2751004528569831j), 
              (-1.4053908263053554+21.536814924264963j), 
               (10.293605339084706+5.0783198376525709j), 
                (1.7740370806295451-2.696700023301057j), 
             (-4.1672514352942986+14.354190355687191j), 
              (27.707389221015106-9.6792093794829093j), 
               (-3.415720731808694+5.6593976278996996j), 
                (7.4766072243793404-6.0702796035085305j), 
                (22.629772069518481-3.195261237731974j), 
               (3.2692264391940289+16.381933795593195j), 
                  (-17.594137005318+9.4869129905999632j), 
              (4.9122140128833776-16.007564394074009j), 
               (10.273685458736422-4.399651209798173j), 
             (-8.7711015743733149-21.055401289265511j), 
               (-2.077316851574297-9.9230469743570566j), 
               (1.4380220037574771+11.400583568611776j), 
               (8.6575229550011059-6.0902997573403761j), 
             (-19.356423292266886-9.5465090244484294j), 
              (14.823102656761485+3.7181680513897502j)],
       [  (6.6795434966752962+3.6740220805344781j), 
               (12.089995198058103-8.0370013304340411j), 
             (0.12775672841906521-9.5619355733435913j), 
               (1.2187360976450172+5.2510246307419131j), 
              (10.768578129608324-14.567177796481822j), 
              (-8.2257911739306095-10.80982024716114j), 
             (-15.179454556644927+0.30558737483275616j), 
             (-2.1718918426032809+20.444388242826665j), 
               (4.7467766762778849+3.7884991231329317j), 
              (-5.8421105851615884+13.968130100123936j), 
              (8.5763952966924322-27.192928066568687j), 
               (-11.49550496559058-18.77666578011538j), 
             (-3.9198644759179508+0.1028070849921672j), 
            (-0.29501611694482383-3.7482396375618849j), 
                (13.851716814050461-8.78240665297335j), 
              (-0.63814196479723595+1.179678905863905j), 
               (-5.0837784566722286+8.0241335015203994j), 
               (8.8175221110137674-5.9020201115379081j), 
             (-4.1621234380222001+7.8049436905792993j), 
             (3.7663751545194528+0.58697241545400713j), 
             (-1.5267262776107118-6.4165762577108101j), 
               (-9.6629140557706279+1.7212234618793756j), 
               (16.725626530306844-8.0661622439081793j), 
              (-1.4079272866776837+4.0056591713634706j), 
               (12.096029610176098-5.3144232642117837j), 
                (9.4885207858165881+8.6599581499382428j), 
             (-0.73288829462708305+14.847505426133282j), 
              (26.025564109296376-16.385276741695275j), 
               (-4.2771053938167922+9.3262519950658387j), 
               (8.8659603564504881+8.6396348916138379j), 
              (-3.2712755712180459-21.686387236427699j), 
             (-21.141474150748753+19.752931793146079j), 
             (-0.69517510781069691+13.808995787600356j), 
               (3.7806355657342996+3.6961403747805122j), 
               (7.8229107144642374+8.5778273393441324j), 
               (6.6323392576169669+15.274680960285565j), 
              (-7.1987845452200085-30.719930176602467j), 
              (2.6021522162650381-9.7376944019036387j), 
              (13.751389435992502-6.2996296438586477j), 
               (18.554945583102548-20.502942900039397j), 
             (-7.0627176715237807+1.7987806958792052j), 
                (5.1290494704991607+2.5248841711474705j), 
              (-2.1002477023121435-19.322791177937518j), 
              (-3.3557907930870035+2.7820514684347497j), 
               (9.6308033351704463+4.9547423833292301j), 
             (-0.25480643087826516+9.0388845629882493j), 
                (10.20972473632539-3.5217152492910535j), 
               (-17.504950232563051-2.7869511328805978j), 
             (-15.002177036267387+7.2202590379981082j), 
             (-5.0339848159840273+14.765341072106921j), 
             (-5.6182484759155384-11.665636320296882j), 
              (-4.3101957516848968-16.150423143155443j), 
             (-0.69555183425448641+7.8118822697037267j), 
                 (4.8887973969980383-5.996563676837062j), 
               (9.9567926459967513+4.5011298863311895j), 
              (6.0706064020819293+0.21564846623614758j), 
              (-13.904471485873911+13.206737213387905j), 
             (-10.974119696965335+12.975960093719067j), 
                  (5.184550295881567+12.18448967805071j), 
              (-4.8878678120656378-13.804990509851327j), 
              (9.8936564421052768-6.4362444337387892j), 
              (-35.713733447687936-11.618006413236277j), 
              (-1.8347448905334487-0.5170713326596621j), 
              (0.1648576688176169+2.9878451149724987j), 
               (8.0488576686635422+1.6793371632723804j), 
               (-18.563826551233152+2.596979579389775j), 
               (2.0587690985972311-1.6913857135914725j), 
              (22.884468943481664+2.6449046336359765j), 
              (2.2954074348163824-4.3545977914964187j), 
               (2.3093751266250555-1.2029582887766834j), 
               (-5.779068187080842+6.6438075003303778j), 
              (-12.322011764109828-3.2914718417722848j), 
              (4.8342456385650534+8.8798826860598776j), 
                (-9.7685639770700643-13.39573714964062j), 
             (3.9932819940748709-0.23165842620363922j), 
               (11.047053739016073+9.3363291999231084j), 
             (-13.371314733952119+5.3883907450210113j), 
               (10.004340282245771+7.7384674503425703j), 
              (-6.4098605511356963+22.515621949924267j), 
              (0.90016792162132675-23.618974180218807j), 
              (8.0179982055206729+5.6300816811364758j), 
             (-1.9747625100672994+5.9773670547433557j), 
                (3.7396867500146187-11.83879059640031j), 
                (5.5001946349516775-9.124566138941665j), 
             (-14.035769163069693+0.96952530777471102j), 
              (-4.938435398633521+8.4136189861566599j), 
              (13.190341343451665+16.604168702891002j), 
              (-4.7465743961830844-6.9659602734454218j), 
               (-14.519229366164915+11.506550734873315j), 
              (-7.5530747106037115+3.0020098269929099j), 
              (-3.4612071332990144-19.270987924386681j), 
               (-11.509757972412206+15.417672100602029j), 
              (21.057986378195828+21.211213772744209j), 
            (-10.928248011316313+0.40405113110913271j), 
              (11.281352957870816+17.893467461986312j), 
               (-5.2383391918090485+12.41850835041862j), 
              (-10.798119677178512+2.6875814076428002j), 
               (8.3233203168698644-15.784486726793116j), 
             (-12.253935745432409+2.6082283443777059j), 
              (7.3647680886133795+17.530650201511026j)],
       [ (0.77441256978153739+16.951061428599839j), 
              (15.821330876600522+0.89327342588991465j), 
                (15.4357833886476-2.5562295331871816j), 
             (-9.8931301252029833-0.88179827219292684j), 
              (2.9126364257736279-5.4129016464827853j), 
              (16.408557027409294-6.5356473452281634j), 
               (17.503989206249933-19.501575561938289j), 
              (10.745103553340483+9.0185608949518645j), 
              (1.5341308285813327-0.34193947551057619j), 
               (2.5456503685382663+11.953979307143555j), 
             (-5.9041192571885937-14.217083151992158j), 
              (6.4089018160070594+7.6892007665802637j), 
             (-3.2625965296573343+8.2848573274372992j), 
              (2.1106510676310357+2.8810412353945032j), 
              (8.4310664830243436-4.3473731398693545j), 
              (-13.032911022999299-12.475012996249468j), 
              (-0.26083983888640105+17.806651137549817j), 
               (10.830633966687625-19.334595885512897j), 
              (18.459702345083024-1.0807648635449216j), 
               (9.656696385844274-5.0272446500574217j), 
              (3.2294716129677519+4.2004233768635988j), 
                (4.6728972999908054-4.7924963418448723j), 
               (5.0481281446375927-20.594707435084928j), 
              (-7.0264777992387355+10.126099739574109j), 
              (-6.0342181086216247+7.7511326455154688j), 
                (8.8934226089235189-11.355905108511571j), 
              (-9.7812902145047307+12.704844173928073j), 
             (-14.131359906816719+2.3035673005225972j), 
               (-1.4154143935900074+7.3167572629950817j), 
               (2.7164176351241571+15.007747777373501j), 
               (11.339282344877947+2.4555240118536803j), 
             (0.23621024978964816+6.8457503832449005j), 
               (5.0633390680437165-12.218596825851034j), 
               (-21.61442212094348+12.024883753178571j), 
              (-18.733669151789186-11.116053481442167j), 
               (-2.2772703484882806+8.487790887850597j), 
               (21.298495151581918+12.919755208409601j), 
             (-7.1312254896863774-19.653872776360299j), 
             (-18.514315305044001+4.3078478083482938j), 
              (-7.1795091874706118+4.1797874905785308j), 
             (-4.3684733181877542-11.013288041708339j), 
                 (30.392980127005082+2.289555284447752j), 
              (-6.8004357599493872-12.438379866462553j), 
               (2.8828780550516599+14.394648887811632j), 
              (-7.0924818644697938-11.719284058010544j), 
               (12.587402184709164-4.1031189237227963j), 
              (-8.6425924004083861+2.0109258803296042j), 
               (9.9600356226465436-0.92866380373255875j), 
               (9.5855060972642754-8.826845386133094j), 
             (-7.2343966552597871+8.8585309146186066j), 
              (-1.052352284268762-8.5785388061078027j), 
              (-20.171222274945411-16.604920516424372j), 
               (2.1821886727410753+5.3923524227308608j), 
                (17.157902099509055+8.1589462473466448j), 
               (12.711527427294547-15.035385045394641j), 
              (2.4222991643834861-0.13447050645930142j), 
              (-5.9236832476311729-10.479227381404401j), 
             (-18.303059329577287-6.1280091437882165j), 
                (11.862311204105175+11.170789439451079j), 
               (0.78031789380012639+9.496282827660508j), 
             (-3.5933487425526995+6.6604689825963215j), 
              (-18.024058740550263-2.1083595699789122j), 
               (8.7077335441661354+13.017297256139276j), 
             (-3.0612814668930364-1.4675970084958427j), 
              (-2.9842761997149321+6.0502857708068492j), 
               (4.5791876981334951-17.649751314767009j), 
              (-10.381163024395917-1.6850272117939475j), 
              (8.3485436708904288-1.6270997847601181j), 
              (-5.5046304089336653-5.549924403044769j), 
               (22.568765948650661+4.1003866555572301j), 
               (1.5658187322249666-10.819153133413526j), 
               (21.461649149533635+8.7495972271201001j), 
              (2.9868031827749579-1.3770192817334825j), 
               (-20.515009677746534-1.9802637247835873j), 
              (10.787481292695745-7.8130342982828704j), 
              (-1.4247640278739928-11.623086507893897j), 
             (-4.2668606614992726+8.0681553089507059j), 
                (8.5666121834748807+1.546102502004528j), 
               (11.256743013741241-12.836021551366972j), 
               (-3.9070471971291951-15.87237196044914j), 
             (-12.914694537604328-12.972599280275478j), 
             (-14.678433433566305-5.0860031809544912j), 
               (-2.8362054939855814-12.61873277449955j), 
               (2.7882314269583617-12.677882134562488j), 
              (-18.050113395063466-19.770667570047095j), 
               (9.390915219511216-9.7666564875848376j), 
             (-22.369411500896149-5.5883196298679998j), 
              (-3.0414275044708887-11.376740469645092j), 
                (8.2918037634878132+7.7097168053518015j), 
                (9.637843824546545-5.9645765511744395j), 
               (13.508923626081355+18.131664141492646j), 
                 (7.201070579803913-4.5321490517061491j), 
             (-7.8972415120633599-10.669056881607846j), 
             (-6.7032270095570308+3.8356758940265339j), 
             (-16.728080307843712+2.4366691107757665j), 
               (14.500943166262912-2.6475466014127793j), 
                (9.654147310253606+9.6586757314401623j), 
             (-1.9118491214511166+0.53903916298359078j), 
             (-2.0542682978171514+15.329109196995717j), 
             (-1.1558201567689064-7.6158518429229023j)],
       [  (22.816364755116009-3.2805202864021972j), 
                (4.604294565665815-9.9692978817372548j), 
             (-3.1380914543366289+11.131448592129052j), 
               (7.7154873844714125+7.5120956217450008j), 
             (0.97324909460652487-10.756123419619774j), 
             (-3.0105771506189507+28.878343023782055j), 
              (-11.837559999128226-2.8882219482466427j), 
            (-0.33782322098939727+4.3008805348804851j), 
              (-10.197030685201574+1.4807001324474496j), 
              (0.63637217033303473-26.134124248786591j), 
             (-12.850113303471264+14.216768709415657j), 
              (15.208521186943738+8.7559553838999378j), 
            (-0.69410880256469065+12.096105166313135j), 
              (5.7854096282669776-10.058944786419847j), 
              (2.0579532780468064-10.205891317294441j), 
              (-5.6357801898662361+5.3816826244930436j), 
              (-0.85959717572706829-8.6828514092695723j), 
               (5.1124505513638594-6.2198648055767878j), 
             (-38.547550158938364-7.9769076177759066j), 
              (5.2790405651923482-6.8996398050058891j), 
             (-2.0750950146146643+6.3874986082247762j), 
               (-24.578689321017364-2.0567077869663817j), 
               (1.345380997663125-0.38905912065215792j), 
              (-6.9677956907420526+23.795372401678932j), 
               (5.6866110875254625-7.2219908976330238j), 
                (6.0588469782362093-7.4380760264474368j), 
                 (1.57650055939602+22.190765689548222j), 
               (12.556443747048462+4.898272394672655j), 
                (14.262990941781581-13.134553620142526j), 
              (-4.2154547214290146-15.778537795975534j), 
                (16.26438628770082+2.9553467807641876j), 
              (-8.9519105540915707+7.329671941228395j), 
               (12.451306675814763-9.6157202786533134j), 
            (-0.26113773420082304-0.09106987567444004j), 
                  (1.35959794029922+10.33523862882123j), 
                (16.70280781718423+17.185003920422353j), 
              (-12.617855921663972-9.1179982088746883j), 
             (-5.5453467604634703+2.9389309026154375j), 
              (11.193629202005004-14.469836082140299j), 
              (-6.3325056826777466+7.0862054536415267j), 
             (-18.802079727655439-2.0572546511496586j), 
                (5.4143433457600452+5.8587144362249131j), 
               (-4.346767385116471+4.8786242434564651j), 
              (-11.727614952573365+10.075407693796336j), 
              (-14.996981832752168-4.1229845919911261j), 
               (12.641748676747842-8.9296657800980803j), 
               (13.447130159189417-12.817861304538685j), 
               (0.14601624408534891+4.8117021615216027j), 
              (2.8498892544761958-4.8578655782673721j), 
            (0.028130897184579888-4.4854159487816707j), 
             (-15.280243684720936+8.1253571143315497j), 
               (7.1571664909128216+4.8739656938086817j), 
              (-8.2717301091136637-4.9586939049555676j), 
                (-10.87781540716799+9.1424547303662678j), 
             (-0.82636419991129018+12.654933721427795j), 
              (-11.970457471324845+19.624038775073519j), 
                (8.8822076116726887+9.772964300899476j), 
             (-10.423457956466589+8.1495556469824084j), 
               (0.67301512183078072+1.2924067290749082j), 
               (9.4100703379123711-15.503775619060116j), 
             (-5.1196177205723457+6.7291652387310483j), 
               (9.9237957906227887-16.893961986888716j), 
               (-4.694810860737987-7.0136357114457404j), 
              (5.1414209732183185-5.8768772227740307j), 
               (5.9086549708971123-14.233145529749143j), 
               (-12.62407494229504+13.236771325324437j), 
              (-9.0488183292533471-6.5067187497779386j), 
             (-15.103810354861462-3.0965672278693694j), 
              (4.7131646499366919+4.7738006997093372j), 
               (3.0113591608551422-1.5560826667358296j), 
               (11.948202833140218-7.2868587787321504j), 
                (8.2894112423815436-4.050721993322159j), 
             (-3.8841334623805683+3.1025396495887234j), 
               (-17.534618509133846-3.4062998494158281j), 
             (-6.3940985828740864+5.4913364240595186j), 
              (0.15466483698008568-10.370834760945122j), 
             (-11.205656894523234+5.4336270193057636j), 
              (-8.8517027054132171-2.5582369286513491j), 
                (2.990449877981356-7.1932956663399494j), 
             (-5.5357360293719076-0.77280861950953794j), 
             (-4.5955714990386225+26.076510735375507j), 
             (-4.7864120714209184-15.172986422820113j), 
               (2.6210378118021809-2.0873014593838706j), 
               (-11.624362069745104+7.575872642930034j), 
               (2.8397245616502587-6.3826955168992967j), 
             (-2.2226302451716933+18.965941367038454j), 
              (4.5725187399719243+6.6097842182470599j), 
              (-2.5910422751900479+4.3647378944382229j), 
                (15.813998296116292-3.4572118202400488j), 
               (1.1884189683802862+1.8188110065015244j), 
             (-0.16322837536876769-23.392306706743181j), 
                (8.6521555262069523-12.931400792257552j), 
             (-13.977325718242966-2.2202805043530729j), 
              (23.244666470463645+3.2952951666279393j), 
              (7.3339915671473541+4.4728184508320625j), 
              (-5.9897709200097351-3.9441276333137774j), 
                (24.545769880809701+3.317138597132065j), 
               (11.611471016605776+19.981775526219586j), 
               (-1.83913577982156-13.528547594307465j), 
              (4.1344930934770385-15.906557798009274j)],
       [  (11.266218545270721-6.4571264834622157j), 
              (-2.7202893304018279+13.161091643356071j), 
              (-10.17415959441114-6.3362335532699197j), 
              (-5.1777014882823336-22.296864866828521j), 
              (12.012815863086452+16.389403633175213j), 
              (12.536134205133461-12.916325042245402j), 
               (3.0715841929108434+10.075116031072188j), 
             (-16.450613223700316-3.1642668379598144j), 
               (2.0586767257842871-7.4472763207624322j), 
             (11.806908334107082-0.098634357762539135j), 
              (3.5364836031295219+4.8421506159656484j), 
              (2.1516160042282277-1.4491127434751085j), 
              (22.720275380754821+13.333914263601587j), 
             (-11.613443692850815-3.4894052609334802j), 
              (7.7040554598454181+4.8086653119296061j), 
              (0.60527938426681649-3.8141462734154583j), 
               (-2.113426660888428+0.35600789071306232j), 
               (21.975703036978977+0.9342960489278257j), 
             (-3.6739380745060934+3.4278849645145133j), 
              (5.8718853512461919-1.6589002649070019j), 
             (-18.170840880315808+6.5674594690387913j), 
               (-5.1473311984050092-9.8936696142599896j), 
              (-15.820311272529764-2.6423211152980866j), 
               (9.5114437708016411-3.3615332331020573j), 
               (15.492818721160207-2.3869534141825475j), 
               (-21.047937323029309-5.8242536253169632j), 
                  (9.109269081759777+6.49471326938564j), 
             (-11.080206071912572+12.014800692762385j), 
               (-3.5319452529925401+1.8678976376673404j), 
                (2.5609746498325077-13.47316433903897j), 
             (-21.214947277205631+0.56692240089241575j), 
               (11.307445224201411+9.958741817425171j), 
               (-5.0030207521903698-8.004386897333081j), 
               (6.8342026258502155+15.601560167576361j), 
               (2.3445941158941084+3.9543586712854428j), 
              (-9.5970773226390982-7.0252630552776125j), 
              (-8.5766943955801054+6.8440517772409919j), 
              (15.051862900271866-7.3368344555574003j), 
             (0.47640198771411618+6.9234621990800189j), 
               (8.4032521332964425-10.277560829055425j), 
             (-3.8250716843782717-10.499922314818789j), 
                (4.7116421730668359-0.9874927468753113j), 
               (6.9407430804201269+6.0356412541247098j), 
               (10.147819394264868-7.8851233736155617j), 
               (7.8714073056123288+1.9862048904423024j), 
               (6.4851423993320543+3.6088260527324243j), 
               (3.5614270474539977-5.8427467684662524j), 
               (-4.3569792376641612-7.3715644933325253j), 
             (-2.1282608994353418+11.232992255938928j), 
              (1.7697916885264606+8.9873317390869083j), 
              (8.9915471074195104-7.3292008492974485j), 
             (-0.05928935998643365-2.6672141393793543j), 
                (7.964961061489042+19.593098437613932j), 
                (18.936465883063953-1.1259388247263404j), 
              (-1.7915483397988203-8.9116847287975727j), 
              (-2.2363057621709417-1.2622623317891601j), 
               (9.0765528372994719-3.7963929165046242j), 
            (-13.038761978310125+0.75159324657507975j), 
                (12.440445116660221-10.351947242752415j), 
               (7.7015299940818149+14.918635685740291j), 
             (-5.9478219281883007+3.5208816522228781j), 
              (14.563570485959154+0.12600716398040215j), 
                (15.385410854637151-8.598057861525902j), 
                (5.683409291934777-8.414098993066947j), 
              (-8.4391983409312648+15.918106399125612j), 
              (-11.589316565687461-8.6223810988491252j), 
              (2.3028524328123061-0.30840113993386986j), 
             (1.0914296328310922+0.36687642985255531j), 
             (-22.828267912342493+10.359177105886889j), 
               (17.184005323137036+6.6319678304660465j), 
               (-21.69166848355626-2.4529907095824468j), 
               (3.4496731308692081+3.0159297346322083j), 
              (10.08436569347802-0.88236188066242904j), 
                (1.8170630724965178+11.663418203446918j), 
             (-5.2455611679076606-14.656047571769037j), 
               (-14.618319632074448-17.94078848623834j), 
              (10.553129022612882+10.760660279739982j), 
                (2.0569428429564933-4.455758931192106j), 
             (-0.89373329036682991+10.155742479554746j), 
             (-0.62385175223591149-6.1722613417260517j), 
             (-4.3777340043422175-9.3948456327372156j), 
             (-9.9830167614197691+9.1118158772561237j), 
               (5.4329347546022211-10.796195478832139j), 
             (0.083802216407904223-10.596103155975898j), 
              (-3.3713658208360493-19.778459462865268j), 
            (-10.019091571669918-0.37675599889973332j), 
              (8.0777268838759735-7.3092392652378981j), 
             (-14.143169376033999+0.50348118588306279j), 
               (-11.039881025637166-7.0351862569801673j), 
              (-3.3282934293362763-4.0747027374467324j), 
               (4.3067725798833143-14.486276119551531j), 
               (-3.5201646261920665+8.2895880543866145j), 
             (13.345321660848558-0.11135335828932211j), 
              (1.3331809776638257-12.151155441260935j), 
              (2.8677337951925801+1.8333291640533691j), 
              (-13.097510566325676+10.185468334874873j), 
              (-11.188158776983297+1.0510179437776808j), 
               (8.2660994478477807-7.3347219810590492j), 
              (8.2914070538525095-7.5704923363995791j), 
              (4.8928692868975032+2.5863528612949978j)],
       [ (-12.803194596378191+2.8581873821362502j), 
               (14.343628958724608-2.2700538755546682j), 
             (-9.5845324024423171-1.8400790997312515j), 
            (-4.8196810402205861-0.051817376387099157j), 
              (3.9801626685063689+1.1022394561159716j), 
               (2.975866046892532-1.6258774866290469j), 
               (13.202035757886431+1.1148704384137933j), 
             (-9.4848212933842984-5.2045586833771704j), 
              (-8.6162723493273639-11.198292623503798j), 
               (19.767278508326736+7.5493945360690713j), 
             (-8.7236242286709285-1.9779272086077415j), 
              (5.3559029470457578+13.471829237901499j), 
             (-3.9290311206139683+4.1427833799424461j), 
             (-6.7737480509076855+17.337376881279983j), 
             (-16.190406930261005-17.949597742410955j), 
             (-17.671505060767995+0.37844967135058077j), 
                (5.6022667046406003+4.4571328207218617j), 
                (-4.2557920391636834-9.18294618734555j), 
             (-18.321233041109181-3.9799321988339633j), 
             (-3.8598744439628008+4.8500867261245482j), 
             (-13.943280698090559-11.642911083046323j), 
               (-10.570440928052488-12.000620293083218j), 
             (0.099265835488696871-4.3799558515330217j), 
                (14.277032630541049+3.991567423660614j), 
                (3.5121820900172813-13.19456671424218j), 
               (-4.5122104057698422-5.6988453632836364j), 
             (0.15286095998064972+0.22367262175831581j), 
              (6.8216081964332318-2.6978753962917148j), 
                 (12.90030535831977+8.4646945898640631j), 
               (24.146961960615897-4.8511976687604896j), 
              (-2.6080537215108643+12.843241217596846j), 
             (-8.2551683585861184+15.626038799128491j), 
              (-10.609045229202639-1.8009463313350662j), 
              (-21.160286505231248+1.1133141773206479j), 
             (-0.23618139885188955+3.2389282698299047j), 
               (1.4475612429699869+6.2765614998371655j), 
               (-5.355740271040653+13.156761343605737j), 
              (4.7499390187208892+3.2854081167703528j), 
             (-5.3328363673127832-10.078360986880208j), 
                 (18.7383934574158+3.7801104556701075j), 
             (-18.258411896491499+2.1770650298518706j), 
               (-1.5225025816109627+3.5558300201483566j), 
              (-12.011461457997463-8.9601165092800166j), 
              (-6.5376519373815682+4.2784495394606727j), 
             (-0.50180082869839149-24.323304478656063j), 
                (1.7868055921285615-10.10704031152393j), 
               (4.1189157820550779-7.1031038398578792j), 
                (7.9355665427194921-22.965071938569679j), 
             (-9.4245773936516013-3.9667868712346586j), 
             (-2.0293132746978078+6.3881473749336095j), 
              (16.186585985048168-9.4482882895660101j), 
               (-20.311384374342648+14.12266692893138j), 
              (-4.7436568796902625+7.9431075650282512j), 
                (16.553581656312975+1.1627586354265824j), 
              (-6.5081379321618886+4.2312460298902934j), 
               (1.0022061557339004-1.5696180469953427j), 
              (-3.0901976557367523+10.074136445061711j), 
            (-0.25890555503210988+14.303394547373591j), 
                (2.1769386657652707+15.986667533671376j), 
               (-9.7982747215952521+7.450173256607111j), 
            (-14.842118757987643-0.54775818469221149j), 
              (-15.098129661360806-9.5802953445661103j), 
               (16.708188040311811-11.357343213418629j), 
               (22.024894178420041-26.98632227805885j), 
               (10.599052360839288-4.0565225898037056j), 
              (-10.077344902022126+6.4921417083560993j), 
              (-3.3220223844780921-2.8972893520819278j), 
            (-0.44736969089074874-1.5744149596181989j), 
               (2.048807263444075-19.375030786670809j), 
              (-5.0084776023349153-1.4339418751944604j), 
               (12.063332163848786+1.2658817104562867j), 
              (-12.495216338958251+14.734886075910843j), 
             (-5.3536573474912892+17.334916671025255j), 
               (-11.676461190839246-6.7979257567824236j), 
              (-11.62196504239412-2.0234658358135338j), 
               (5.8396434523362908+11.252850685235815j), 
             (-8.2059357475464978-6.7640160461800916j), 
               (4.7980916405225056+3.9687362770997692j), 
              (-6.5875654752225543-5.7094536918861793j), 
               (9.9322787587941122-1.4920448102197301j), 
              (-8.328961948460428-10.261927104597959j), 
              (0.59067168748220433+4.115474557396781j), 
              (-1.5595389960150021+13.607909621134745j), 
              (-2.8832170544776856+7.3573376418271943j), 
               (3.8966107324507453-9.7633634528949482j), 
              (5.2302358994408804+8.3810645221422089j), 
            (-13.234858733278301+0.77603727199543382j), 
               (-20.459890711814669+12.86657803137847j), 
               (-7.2286635307331171-7.9479807172186199j), 
              (-11.533732492271687-7.2444171931517163j), 
               (6.9043645202026003+4.8839605388824872j), 
                 (5.792693250933314+3.1882762268154723j), 
             (-6.4372087401405391-9.8447434735747184j), 
             (-3.5977503151385393+6.8488006738760827j), 
              (14.583599731146615-17.395252092088981j), 
              (-13.792991923722347+1.8234671025096429j), 
               (6.3080060065638799-13.892022399612795j), 
               (21.768175830952995-12.255025881929946j), 
             (-1.5290618713965978-15.799645865237903j), 
             (-13.919425897517515+16.710859649298808j)],
       [ (-18.658117716853106+2.9913177203473102j), 
               (3.2905630197102314-14.128247465074466j), 
             (-6.7509673202591483+12.746157835211635j), 
               (15.422979998213437+3.8779457641275998j), 
              (3.0722450330062836-4.8463558497821566j), 
              (10.480760285945127-11.300062769860176j), 
               (11.805916077487375+2.2452559605446427j), 
              (12.492039041735815+10.840164188786703j), 
              (-7.0833498806840218-1.2657011925402482j), 
               (10.180463180537309+0.8050639550431804j), 
             (-2.3855892334546249+6.6705331047547558j), 
             (-7.8604881034974952+5.6227491761505002j), 
              (1.8288966950824894-2.0384399328613227j), 
               (-4.48241538570303+4.1703842853001865j), 
              (10.880564208994581+12.685659766850748j), 
              (-7.9601200530564373-8.6572790781092284j), 
                 (2.1339142360562176-9.039553851973011j), 
                (7.764544176334649-19.222020185347787j), 
             (-3.2946282141369725+10.583275891433509j), 
              (-1.4675314867040803+18.47163354070581j), 
             (-9.8096496425901787+3.3919730845856688j), 
                (4.1135722702387323-5.6325197927062112j), 
              (-7.5075264891119273-4.0283422578691326j), 
               (1.8293865941000087-7.0602708984159959j), 
              (-5.6304463698628791+14.317556346975708j), 
               (-19.386879135724232-6.0446514507638662j), 
               (1.9298358346509514-14.898412252350589j), 
              (8.6727798179083102-1.4725093902784783j), 
                (-6.7674626934178352+2.393016265947006j), 
                (13.59372425269078+10.945333379557765j), 
              (-1.6560629758531276-9.8292178651934243j), 
             (-12.178529506345882-14.905825524922399j), 
              (-6.0042220820273169+2.5562116050378325j), 
               (11.587319276097324+15.230827616092768j), 
               (6.7859436159574056-3.1355404749002465j), 
               (4.7998044670512945+1.9360310306553874j), 
              (-2.4282694513703591+2.4882364936290577j), 
             (-4.1850244172098812+7.1447231174803569j), 
             (-1.6126397850509329-22.639407467717181j), 
               (17.780817455074697+15.973722339298945j), 
             (-5.4880616207272332-5.3561832567043517j), 
                (2.8828791519562986-0.8357758813102667j), 
              (0.43079278576100632-5.4131944150150719j), 
              (-3.6717763609508087+3.1272678289286215j), 
               (-3.5095762087942117+6.415037897661156j), 
                (10.944555347815164+15.94657379720822j), 
              (-9.7409237591927589+1.0739479025642171j), 
               (-1.4938805561081683+2.6585399707892279j), 
              (2.6416584585796699-23.019221480299564j), 
             (-6.1530875231381978-6.6954187644844954j), 
             (-9.4827340401786095+1.7813628426830861j), 
               (12.76022355698554+0.66274465437724284j), 
                (11.64691103289897+14.052199150895248j), 
                 (6.978584021469687-1.8584520281805887j), 
               (-21.21663456762024-2.6436858455818202j), 
               (5.2964049476568595+2.5586186207017914j), 
               (6.9392892763331044-8.5726517756200451j), 
             (4.4717650448223454-0.75346265875212803j), 
                (2.4099755167273322+1.4493157254003306j), 
              (-11.617466547412146-1.3179102262039697j), 
             (-6.3304041855420401+2.6431334412280809j), 
              (-12.462744093608492-4.0968663161932026j), 
               (5.5657708634834187-1.5031970122076654j), 
              (12.607099501801486-3.6603093587214213j), 
              (-2.1341788465409053-2.7298062614109964j), 
              (-8.3783621153629344+4.5297796032775857j), 
               (5.8602422649825305-6.3563261471574322j), 
               (5.539199304951036-4.9466257241818044j), 
              (6.7722203185362018+5.9223690005079757j), 
              (2.299697150759684+0.028570003724821026j), 
               (11.446381679564581+4.0312241523483658j), 
              (-15.806009419675943-4.8081191783198225j), 
              (2.0158224466201742+1.4124665235858438j), 
               (-5.2671827712803374-8.1201860376183159j), 
             (-10.227491205970658-12.439667828838106j), 
               (7.0594934944636298+10.392947053706262j), 
               (3.6305695468617518+17.97779338573433j), 
              (-15.961905811864391+7.2776782387238672j), 
             (-0.60134269285381969-17.182328658995353j), 
                (3.8407581814891589+6.824685341239852j), 
              (14.825675589094905-10.285635081601585j), 
              (2.1529304060164449+19.732158351937795j), 
               (4.4336059434214308+3.5287772331911187j), 
              (-3.4813058647896842-5.7572193704927805j), 
              (-22.813297679229851-13.332796431306884j), 
             (-1.0137785094910856+19.654027139066123j), 
             (-7.3993536279592655-23.525739633982429j), 
               (-4.813315643959009-10.797022001599288j), 
                (3.3313160850649708-6.6358562720588345j), 
               (4.6351441572036611+5.3026561224000055j), 
               (5.4613106029270888-3.0862817079304139j), 
              (-0.54162672676610191+17.534921658406947j), 
             (-4.2509398466710628-6.6672213895534931j), 
             (-8.1941867939676332+2.6840566196320874j), 
              (14.273458187349483-8.0871233428565077j), 
               (5.5576089730765021+5.5778138833436488j), 
               (9.1662163572969106+2.1003820223096992j), 
              (-4.3249832142106461+1.9871800470128931j), 
              (9.1206238538457534-9.4386409957287523j), 
              (5.7494827407940523-5.7253393858674801j)],
       [  (8.8992354430027092+3.4734009399892956j), 
              (-1.0120238596144446+21.725091878482683j), 
              (14.332877804672563+6.5646667562124152j), 
               (24.323387440683895-3.9368928738340476j), 
            (-0.20954684896997036-1.9594446350356471j), 
              (-2.2715088260687706+4.282589677106408j), 
              (-8.0671248368598061-9.8767282010506534j), 
             (-11.622646718081898-1.9677083897172047j), 
               (9.9228702402030482+12.681439826992005j), 
              (-6.9544033268847105-3.6281250873762039j), 
              (-10.61835358130044-27.385424015214181j), 
             (-9.1603766296179376+2.8894636522090238j), 
              (10.300679046346282+13.895189847257077j), 
             (-2.2990689819908439-5.6692883204022761j), 
               (4.0361019232514543+2.903400116406476j), 
              (-13.863691358725402-9.7734193001975562j), 
                (3.4990504470189387+5.6216518459847897j), 
             (-0.33085529920480478-13.063390937089231j), 
             (-13.099268502494803-9.4169763335556684j), 
            (-13.234315964900103-0.65064394705878659j), 
              (19.158448853608029+9.4354271253084789j), 
               (0.23830567568474942-15.640170797738495j), 
               (-9.4433539970109877-4.790780480379401j), 
              (1.4115683668752959-0.77738847854798299j), 
              (4.2760899841424331-0.45374100667461231j), 
                (4.4226824690525381-7.3189885187774664j), 
             (-0.40123541878077978+16.007973770709448j), 
             (-2.7808449266576796-6.7816457970690625j), 
               (-5.2130731000760715-7.5424998510672303j), 
               (7.4924992771375711+2.9179891387816403j), 
            (-0.33695264777603551-0.57660864552976299j), 
              (8.8235308856221319+24.390220846186971j), 
              (-15.145464099112884+10.725530122421825j), 
             (-1.3178592577863792+0.42493816961524689j), 
              (-14.802352503734639-6.8118346660350282j), 
              (5.2980142586757681-0.40630485240081721j), 
                (7.1211767207311389+22.03322763180752j), 
              (12.671286105954652-5.9865198091198852j), 
              (21.840864099989361-0.9682273780701699j), 
              (9.5328816665476541-0.85723102487639979j), 
              (11.223501680773973-9.1674048017936887j), 
               (-5.4998762783278679-5.8109427064874906j), 
               (8.0719217675289769-11.058303379192033j), 
               (1.2507020208032222+4.3849298579875011j), 
                (7.837519314333079+6.0032350567846171j), 
                (2.8646347958719081-3.099031369624798j), 
              (7.0080110973254026-0.95776093236686122j), 
               (-15.564432275376296-20.450282092963803j), 
            (-0.23485295566123554+11.205476420739309j), 
              (1.5569770763949398+9.5673168680387768j), 
               (13.79801048753489-7.4169877075819155j), 
               (15.151384796045125-12.596458911375226j), 
               (3.3228345409142119-1.3850594681793593j), 
                (2.4036712636655411-2.0224296671281934j), 
              (-3.0811931784504449+2.7810949216133753j), 
              (-4.7498222112326083+6.2298860365721271j), 
              (-4.6808383607649091-11.228279774434657j), 
            (2.4520729229757379-0.044939370429113716j), 
             (-0.37918529061327982+0.58218282932313314j), 
               (1.6898861767363584-5.3385480873932645j), 
             (-3.2015469213184411+11.496050423517657j), 
               (5.7659355779402874-6.2971214673315314j), 
                (-6.66556396727084+10.896324647283803j), 
              (1.4284754378001498-24.350548488471627j), 
              (-5.2051440176295678+2.8349811482989362j), 
                (5.0283456744777464+1.143205763728409j), 
               (5.3128096652214154+18.861990280850481j), 
              (9.1672673683024115-5.2538243733190528j), 
              (3.9650255650588493+8.9276840858951161j), 
               (10.097276950219849+19.680257084800218j), 
                 (1.39919680856935-1.9271876714774963j), 
              (-14.764911399973354+5.9684274620196867j), 
               (15.71021267618905-1.8771117240522563j), 
                (7.6628166408526823-8.4288643312462401j), 
             (-14.658661801686714+15.044087064576084j), 
              (0.77315761374706959+1.3305546100179715j), 
             (-11.199969306932047+12.767058268725119j), 
               (-7.0967039860806373-16.18978734936022j), 
               (5.0362409490010034-1.2222764442685543j), 
              (-23.564314612380205-18.840249261866294j), 
             (-7.0286923340392269-6.3568800600447588j), 
              (13.547392159521198-21.082241064404226j), 
             (-0.37145905553479019+9.8229906712932475j), 
              (-14.254581424866426+15.005469808147598j), 
               (4.5954762720825588-6.3761524019974072j), 
              (12.911398178558365-13.563319209804996j), 
              (8.5541086614914814-9.2370348084019618j), 
               (24.576798208140637+2.4029090122186876j), 
                (8.2541080424933195-6.1943668784784469j), 
               (-7.8939255950090761+7.209077730278624j), 
               (2.7720007366327475+7.6990383861002005j), 
               (-3.1743610026660942-2.6036120060450596j), 
             (-14.720870083783756+1.9914539420396491j), 
              (-3.1371584625758646-11.38473051118676j), 
             (-11.583417532492614-6.4248461270403192j), 
               (11.896094579817396-2.6727182472701849j), 
               (-15.771101674328758-4.348876194010737j), 
              (-7.5811449561132616+25.625052171851394j), 
              (3.9468999580383541+10.135657438670673j), 
              (13.789234920198441-3.9940805451309283j)],
       [  (1.9842320716893622-18.817732578159003j), 
              (-14.241086576710018-1.1927119449519528j), 
              (7.9235583571952688-6.5465686617842644j), 
                 (6.4334322780195183+5.65008579247566j), 
              (19.432741195004198+11.440421392875908j), 
             (-12.064986958221713-21.489150190622674j), 
               (4.6198089129438715-14.285446325047687j), 
              (-15.60574495972463+17.743106191293329j), 
             (-0.50392295744165261-4.3113445595265274j), 
              (-11.039218617368523-4.5905852567699483j), 
             (0.32736126303192176-5.9113220396051087j), 
               (-9.5932151203790657-4.98318216719459j), 
               (8.623043943285877+1.6584540895347946j), 
              (10.511533339286803-12.184047640522396j), 
            (-13.190412768743487-0.45159258636498084j), 
              (-12.063911041266387-16.289910955627317j), 
                (4.7365193571136563-2.9267035379683111j), 
              (-16.377862921940562+15.439958490440462j), 
              (13.964551184347016+9.5600730685908548j), 
              (6.0275510907578509-1.2903230793151912j), 
              (10.462717251693615+5.4353473566809196j), 
               (-7.6325446546913769-12.120339438705944j), 
              (8.6095589462254036+0.79797947681361447j), 
               (3.5526293007954663-16.735274286166156j), 
              (-2.7065845037850411+23.194420099693129j), 
                (13.474354475563096-7.6545268856842661j), 
              (-4.2258680443462913+13.535086646325393j), 
              (5.6129414034256744-11.820030588169795j), 
               (0.91782930306281663-17.533641862627867j), 
               (7.4285383356808756+11.233647433741318j), 
              (-2.5297098695499267-14.159188235611936j), 
              (14.266972322609197+9.4765245578112403j), 
              (11.841176609831969+0.22425387181460099j), 
               (5.4052628848890549+3.5979726823716645j), 
               (13.056530456939406+16.726360429612232j), 
               (1.4114946995987365+14.162969709050051j), 
              (-3.0864452471580965+9.2645818832566782j), 
              (1.7349910920187164-10.240378465676979j), 
              (7.2794209341058984+4.2124773097570385j), 
              (-10.560171218617944-2.2382159595669426j), 
              (-13.704265608041508+4.222964040050619j), 
               (-3.8273441272627924-1.5251400657641654j), 
              (-7.0300788443690232+0.6332617364506038j), 
               (-7.2001796780663856-1.496240407892562j), 
              (-9.1492914700411756-2.7307414307884366j), 
               (-1.9088972571001839+8.159794491631672j), 
               (1.8339066196821685-2.4391655633816418j), 
               (8.5370731945042362+0.95074277498353688j), 
              (7.8919113388422248+1.7953861364240331j), 
               (-2.68246891957698+17.219842430116007j), 
              (2.6973028145686007-5.8411894023985695j), 
               (12.099524750815112-2.5440717399996347j), 
             (-9.5431553365112585+0.96607719311777651j), 
                 (-11.205687382649096-14.7551365428313j), 
              (-9.6361016230086136-5.0084939470583336j), 
              (-6.2028379307949013+9.0500816748730823j), 
               (1.1415480166390897-6.0181552213286018j), 
             (-9.4378469245570233+5.3149082877764711j), 
               (-6.7912161992610409-6.2337073457985444j), 
              (-1.2787436219258772+1.8567886050628641j), 
              (-11.47029962705124-18.183751530703443j), 
             (-0.56639589015855285-3.4207385290881485j), 
              (-4.8871930902194158+3.0507094017742844j), 
             (-15.694972918542398+3.4948473062844334j), 
              (0.72212672248822052+5.5353124030845189j), 
               (11.403875838314345+4.5534848302324544j), 
               (6.7163217782275559+7.4538767783689615j), 
              (24.841662406689959+1.4677934046961476j), 
              (-2.620228687616879-16.320889184063276j), 
               (1.7536800311419998+1.2986386814600244j), 
              (-23.103488911189277-5.1314436424576417j), 
            (-0.77346218959982194+0.63162615586049475j), 
             (-24.043670632324769-8.0954613435554634j), 
                  (17.06946302238909+1.672987324068077j), 
             (-5.6321984889160817+22.343473856508332j), 
             (-8.9795631818525816+0.54668513485079051j), 
             (-18.595691747148791-4.4770680613773219j), 
              (-11.065886027433491+8.1755451455821788j), 
              (-13.323555358553168+6.2944130585773204j), 
              (-1.7342004523008181+7.2074302750939614j), 
              (-12.83803431824108-5.0909164876754378j), 
              (2.7822880930439391-12.856026469835708j), 
              (-10.066872551280762+1.0696151211067442j), 
               (7.5574178190999746-5.3271281785200033j), 
              (-3.9891857600666345-11.638146326916534j), 
             (-1.2988917633416694+8.1289156659925883j), 
              (5.4127074405376927-1.9073457267766047j), 
               (3.0077592088445777-5.7860249425239596j), 
               (-8.0355981415688724+4.1203309241480799j), 
              (-22.537010789122899-1.2275315153560842j), 
             (0.047776432867845595+2.7159595487112824j), 
               (-13.001127916080337-2.2768351570753373j), 
             (-4.6145301124134628+6.8051432719333951j), 
               (24.97322720023384+15.908432665613294j), 
              (14.307437309844946-8.5813147309419886j), 
                (11.92797903000405+11.251731144189064j), 
              (-5.1219950634315161+7.3903726750844845j), 
               (-1.403689589779811+5.3976264169230959j), 
              (-12.32719039271023-14.306758589723172j), 
                (3.81031175809095-6.3463776136868857j)],
       [  (2.9425686293400375+10.231771601873598j), 
              (-5.1335175427134168-7.6794006639944001j), 
              (15.643364306586996+7.5243212476714492j), 
               (12.831624221646916+22.180088400578764j), 
              (-18.96120488932786+16.723951267033222j), 
             (0.67270447027074431+20.170692258066158j), 
              (-7.5553868002726858-4.7634051794063454j), 
              (10.415809808238958+13.322149106209658j), 
              (9.4428623532906517-0.89356360831894821j), 
               (11.280774434911452+4.2780172572342154j), 
              (21.122272426619553+10.950000283046023j), 
             (-17.097119316575885-8.8244164291505172j), 
              (11.510522365113765+2.2150518662401013j), 
             (0.14563255699444061+2.4441564167381165j), 
              (1.5455537349349122-16.160135502645595j), 
               (1.2947932718154342-12.298997943518557j), 
               (-12.987768155702055-4.6821030791025002j), 
               (2.2941185423625106-1.0598151614681735j), 
             (-5.1115810250639591-13.827985759910675j), 
             (-7.0067239003260564-17.050128668377234j), 
              (9.3374847246249111-12.249300682383854j), 
               (-11.347926946933569-25.643199236099061j), 
              (-1.0201220970647338+1.7966567827565381j), 
              (-1.2219439193670503+1.6663631466014441j), 
               (4.2827084008533278+2.1325240847424864j), 
               (-3.8128879166137546+4.6416107975103991j), 
                (3.996752415537919+11.673845498377277j), 
              (6.8139784493194169+15.942781656482776j), 
               (-6.5377928535225607-10.232150829989493j), 
            (-0.089639576757066686-2.1453172833439482j), 
               (-20.34982333036432+20.128517068500908j), 
             (-10.298929722760919+16.208157978146669j), 
               (1.6936927114769895-1.7560135697762727j), 
              (-5.1211691632200314-5.1052028382623504j), 
             (-0.82473557886195981+13.034170228494888j), 
               (5.9220609981051942-10.381645803948187j), 
               (6.6917225650862386+3.4707828756460519j), 
              (13.420542159138238+1.9421930062384702j), 
              (8.8499355248581235-3.9987973921508284j), 
               (11.664294816687937-5.6648025410182861j), 
             (-17.099474129408026-3.3596049053441779j), 
               (-21.031403638239276-3.8200690610922332j), 
              (-11.324036051712289+1.0851511880603628j), 
              (0.47914534293584715-7.5285945741496265j), 
            (-0.46927631596022806+0.63686994766702798j), 
             (0.43583397417055997+0.79461312773315462j), 
               (-13.510520634018002+3.459726639407096j), 
                (-10.58779165021096+11.314116781736995j), 
             (-2.2095265094920262+4.9683091317108161j), 
             (-1.7173992419912452+7.8215882651997894j), 
               (2.471530735535783-2.6208297019093414j), 
               (11.880719962601418+11.337799036025892j), 
              (-7.1258577873417517+7.1078279272237967j), 
                (14.083517482788642-5.8733117765719731j), 
              (-17.330918183898959-6.2057705911173935j), 
               (3.0160930214624493+10.879936637034906j), 
              (-15.154084840233288+1.1864218276201337j), 
             (-18.651473826462365+10.359185981230414j), 
             (-0.88031674767996648-0.30720437405548723j), 
            (-19.351024815247175+0.059178538318395049j), 
              (-6.890587807039342-5.5059600962835393j), 
               (2.1610629824906331+16.615830111939552j), 
              (-7.3013919833381493-9.1447161028416151j), 
             (-4.2796116265757025+12.849500811832844j), 
               (3.1605774311336399+4.6370405973829634j), 
              (-1.3583026655614159-16.176286862888205j), 
               (5.6152724820511404+7.2382815907418028j), 
              (12.507619341458533+12.286647054487862j), 
              (9.2262818786072671-2.3979177694947373j), 
              (-6.1407808119310605-4.5201114648908129j), 
               (1.3729637122449867+7.0902105521510341j), 
               (2.3477481843212105-10.893171993320506j), 
             (5.4150945405032305-0.17673139891842157j), 
                (13.683274246640106-1.7187531036573056j), 
              (24.092538551612389+19.317231373715732j), 
              (-5.8893093474794718+1.1106822745174121j), 
              (-7.039342625870562+2.9735995797722357j), 
              (-4.9597582763935124+6.8369870490599336j), 
              (-10.728995696757016-7.5370739089600036j), 
               (5.7832847557792464-14.562390335713907j), 
             (-12.719777425144731-4.7035689794676738j), 
             (-1.1311330009509344-2.5491229102627373j), 
               (9.4043532164473298+5.6690993879075506j), 
               (-7.2109161611742225-25.26144451314973j), 
               (-7.566339634089875+8.3153476292330364j), 
              (12.367575071606236-26.152734401287859j), 
              (4.2577549919216899-11.238875878863562j), 
              (-12.653951858568359+18.068316599972562j), 
               (-8.6760792357897909+5.7382268156531611j), 
             (-0.10323565212804571-3.3715251182940333j), 
               (-17.63952686728631-6.3102198174165656j), 
               (-6.6779080383657297+27.010976038899464j), 
              (7.9515047409843742+4.1586682385083886j), 
             (-9.3370876016609525-7.0581256926739151j), 
             (-7.8183496891226421-15.374744556688123j), 
              (-8.3171228862308837-10.487542458142654j), 
               (14.918263138835821-14.866604288649675j), 
               (19.16434713172454+0.26966004513618663j), 
             (-11.180019263627585+16.198434870781909j), 
             (-4.4838731060869472+11.420481136366385j)],
       [  (15.468934181300881+6.4479227265509564j), 
                (2.227248857618203+7.5859566226591362j), 
             (-4.3893366083766221+4.6567129278747208j), 
              (-17.358244073683885-3.4321371520355108j), 
             (-8.0266233285916098-2.7935844639324996j), 
              (7.7510228118465241+12.381414816859127j), 
               (1.5038047101272438-7.1935417732069142j), 
             (-6.6577413612494132+15.566263635655543j), 
               (2.5128543162025663+2.7938784205559197j), 
              (-4.1520995512139445+3.3987814185874674j), 
             (-6.8606046905782545-7.6283467239880096j), 
             (-8.2745248279097066+2.4885133281345921j), 
             (-1.6045433142644929+4.0505509222962264j), 
             (-3.9632359911326724-14.194431328632204j), 
             (-10.493501976876837+8.0938460361059192j), 
              (-17.753230010241047+20.329017993758377j), 
                 (5.1252401772267531+4.585951335447283j), 
               (15.125461514705389-5.5361472694800353j), 
              (0.83240717018300048+2.129503669223916j), 
             (-6.3237451299832408+15.084762946569118j), 
             (-3.3644119728615332+12.830910422494327j), 
                (11.163936011520894-1.5095662181227387j), 
               (3.6449540082117031+6.0521186793539687j), 
               (4.5267288867268842-4.9765691827475349j), 
              (-11.046858841066962-3.8101307777088902j), 
              (-0.36382006622717072-3.4708312262843997j), 
               (12.548540481271251+6.3421051671269542j), 
              (5.9519797447370193+8.8372583818213499j), 
               (-3.2936715511013634-12.731557608988338j), 
               (-18.39369124108752-6.7982421371623953j), 
              (-5.4033464464680403+22.598385617923217j), 
                (17.896408727541395+1.90258334825897j), 
               (1.9272213226776902+5.1341688009914783j), 
              (-1.8968668137839537+2.3315911196288037j), 
              (-6.0422256728582493+6.0620199701093966j), 
              (-20.741777408653505-13.635562416808355j), 
              (-11.030984429264416-4.0628696511680236j), 
              (-4.6429787498607125-2.881773814684971j), 
              (16.559031226069603+7.7342135249909507j), 
             (0.010131954801941023-13.877396425921971j), 
             (0.85487603161474091-10.749773050198559j), 
               (-8.6128942767369363+3.3261265644965339j), 
              (-4.7255140315746571+6.7674941802182218j), 
               (8.3488750931318503+5.3292839704352808j), 
               (32.077848067502252-17.010009032902968j), 
              (-2.3764541194683084+7.5895898420426082j), 
               (17.274897837430682-12.761775260979324j), 
                (2.1211190189896478+9.2178229120416368j), 
              (12.608279115665457-9.5779170522332233j), 
             (-18.255837940338594+5.5428110180193428j), 
             (-5.6059774112262932+1.1733226513469099j), 
               (5.0801116091544065-2.5520663219211115j), 
              (-5.0054707926783077-0.2936885745413898j), 
               (0.54104675941237457-14.371679966838567j), 
              (1.6205566506735738+0.10708140988804943j), 
              (-11.186381324989846+2.0084328037128585j), 
              (-1.6615269517532201-6.2196471976787171j), 
              (-12.90843389071596+18.729068541292747j), 
               (-2.0747366999718762+11.147861615270166j), 
            (-1.2698882330710162-0.020825508505673898j), 
               (16.41937117710291-9.0900300213356662j), 
             (-3.0995935745254672-0.98285252632534181j), 
             (0.27792903015133053-0.37994545366120064j), 
             (-2.1722878175569043-2.7085866508674532j), 
              (-18.879793858182591+10.147483763625631j), 
               (9.2481682858901433-11.142677774810272j), 
               (3.8150349561372781-13.773687742227905j), 
             (-2.4180931199784603+3.1404505139126089j), 
              (2.7593227138024674-4.5525025505114138j), 
              (-4.3242609589009682-3.8959422785631026j), 
               (4.7900744772110251-5.1246620339723306j), 
               (4.8417421782386398+9.9629117187279839j), 
             (-15.253911001375197-9.9545580629750248j), 
               (-6.3918638357765598-27.530067190598796j), 
               (1.793547406890851-3.8073278450193309j), 
              (-7.8690501652693348-31.924499143443729j), 
              (-6.396719581931988-12.374400517106462j), 
              (-14.933974816639582-10.030590520685363j), 
              (-9.8198967851679004-19.003458182290821j), 
               (-14.083115984529408+10.50228734775734j), 
                 (5.395877661203011+4.95880851771516j), 
              (5.6395118884114712-20.450993240330007j), 
               (3.0810842795947919-3.5860244141408799j), 
             (-0.92647105501953708-16.019337151705574j), 
              (-14.965269112801369-1.2185849338333747j), 
             (-7.5243811520851267-16.475312239292645j), 
             (-4.2101539441908482+1.9758144372301709j), 
                (4.629859372792497-2.7617652603189913j), 
               (-4.9719931703856046-9.0333158954539936j), 
               (2.5845317811532298+1.3764334613724472j), 
               (6.4064132342891416+1.1865998150613724j), 
                (1.728834542548787-0.44211447832934347j), 
             (-7.2549218942475378-1.0473207597256144j), 
             (-15.671552736152227-2.6340481907214972j), 
               (3.679611949900333-10.579568994026099j), 
              (0.60472398070787503-17.316412314882214j), 
             (-13.130572633494367-0.67695758808504769j), 
               (15.608891465986654-2.6592121908936042j), 
               (-12.890725728677735-2.07599062772079j), 
             (-1.4501279173311397+13.871697709581428j)],
       [ (0.74891514145643889-11.313644613022708j), 
             (-10.021482716522392-0.81725226861605782j), 
             (3.4660864388009571+0.52928710314378069j), 
               (7.2031041965769083-8.3000062241622423j), 
              (1.1834097872031237-7.4882230999789261j), 
             (-7.6452996410742582+2.3784695686566355j), 
              (-4.4840649867419389+3.5877701738403518j), 
              (7.0997904867917025-1.7488650744849448j), 
               (1.9977962432487752-5.4293326330658722j), 
                (4.249647190667031+15.945984377014488j), 
              (5.9846554654539048-3.0398483893032018j), 
              (9.8333100041934802+17.294668061122245j), 
             (-6.1107905424187585-2.0004031809352321j), 
              (15.147061711387018-3.8431154309099105j), 
             (0.48039009271161165+1.5874565905770592j), 
              (0.73289408697519753-10.515959799135363j), 
               (-1.9262523795288187-5.2932521122994567j), 
               (16.887414135587932+12.131380925157856j), 
              (5.3914682831479173-3.2635371030466582j), 
              (28.624694374149833+12.421486596863616j), 
             (-4.9697257854921446-9.0319380363915087j), 
                (7.7694097765501819+13.106451898061898j), 
               (5.8025334544005149-14.336132180602071j), 
              (-6.0984035832448358+8.1880922085939609j), 
               (9.2300850169195865-22.608162300725034j), 
               (-8.0898385574155522+7.2227442256361876j), 
            (-0.086668856871550071+6.2555088942750956j), 
               (12.323366287406905+11.11723756311382j), 
              (0.52224570492489997+0.94282052551782947j), 
               (9.9532846619100344+9.5848673379834004j), 
              (-5.6648496786117075-6.0100849311336857j), 
              (13.080864874723655+5.3600835576891477j), 
               (2.9012362364300053+6.0081287890667863j), 
              (0.37900465366530606+3.2175735566936119j), 
                (4.0573528110338355-7.835615812412545j), 
              (0.19564944876573423-12.536726095395514j), 
              (-9.6390635293663411-4.9031018557607942j), 
             (-8.1962446927009758+2.6336816555999087j), 
             (-8.7277321279808344-3.9734181592937472j), 
              (-4.2002880760262427+6.9994547664775659j), 
             (-12.949011881087609-11.925351917120503j), 
               (-7.9209434652535862+5.3922537482204937j), 
              (-13.372882594729443+2.9308600937404705j), 
              (3.5833400440604297+0.70199558785686023j), 
               (6.6015104048567785+3.9966511093575892j), 
              (-25.797659738815195+5.4144744673841831j), 
               (12.618934499903382+9.9512208105462605j), 
               (-19.796282704102566+1.2900289013278978j), 
             (-2.2989224467620533+13.182272528633806j), 
              (16.673313108293431-17.302166586432165j), 
             (-15.205472935457591+10.052394833116656j), 
              (-1.4227202596823241-7.8339017522783667j), 
              (-8.4909117913189078+10.585897304014974j), 
                (2.6605477377729465-16.179657919934051j), 
               (8.2348624114337809+20.165583067294747j), 
               (9.0326275143672685+16.702980351509243j), 
              (-4.511704281458667+0.65961282637947627j), 
              (18.066483737876606+4.6417984924380642j), 
                 (11.346770423280576+8.244615804047573j), 
               (12.785640249606843-1.6132430116629939j), 
             (-12.887822055005007-6.8687201192270173j), 
              (11.744166906040849-0.55186975337875521j), 
              (2.3420022581236495-0.14502041674804866j), 
             (-16.662919138966746-3.4167999042039225j), 
               (10.306173344695907-21.663825317532716j), 
               (9.5942718320234572+6.5245166371805352j), 
                 (2.5131352983334407-5.33139739131538j), 
             (-8.3803511387800018-5.4465084579439118j), 
              (8.5958907628096686-8.5289819907820572j), 
              (-9.5714716398423576+1.2881688445042601j), 
               (3.7206418265448975-7.6905485934013171j), 
             (-16.125499079389915-0.94171140909486972j), 
             (-3.9684501720452383-12.533541608697805j), 
                (11.737618844193578+1.6093396899392953j), 
              (6.1817120589967214-5.3418754400408064j), 
              (-6.9100978161660676-1.4105050850653214j), 
              (3.4525085190996467+2.5017991477859205j), 
              (-8.4174259408655399+6.1232610489450092j), 
               (12.826999471358665-1.9986983840648884j), 
              (-6.8069833696440432-15.272232578043297j), 
             (-5.8737321649441876-12.918970245114211j), 
             (-4.4808989999473674+19.392499733842282j), 
               (4.3515186315992196-4.4204226510197016j), 
              (-3.7091473503453853-7.8189922899100717j), 
                (-10.680787180404721-14.8885487390965j), 
            (-0.35721495450159035-20.615234681491255j), 
             (-7.4683381284072405-20.803186275641124j), 
               (6.5968384939930012+3.3292099195725338j), 
                (22.664483167404157-1.7148048308215622j), 
               (3.1616942045165315+7.3161532020857472j), 
                (3.2036790978073544+22.06191983657925j), 
               (0.90957137754249273-5.5396634329794221j), 
             (-26.027151468047961-26.528402482923749j), 
              (7.0023926381458601-3.8286970231838824j), 
              (9.0725523791448364+1.6362348513866898j), 
               (13.084379315240311+5.7053424140840576j), 
              (-22.292321428302991-31.478915317425749j), 
              (-16.123889873067945-9.5565502911871452j), 
             (-8.1697014365442371-5.4046102372532667j), 
              (1.7154234656340381-15.048183736714391j)],
       [ (-4.9283508652206613-1.6220416994602729j), 
               (-2.812082798150751+10.047401465518981j), 
              (6.8512333917687211-8.2794021799558131j), 
               (3.0498320238846071+7.2685414417432446j), 
              (8.7888478523070752-8.3497045596631807j), 
             (-6.5195664489859064+8.5252011905566416j), 
              (-2.3634886719962149+6.7381703143665108j), 
            (-8.7764451345537626-0.34254954703955343j), 
               (9.3413988396107062+1.3264992135735731j), 
               (8.6172900157577939-5.6265990497272513j), 
             (-7.1054770011603523-8.5009413292009839j), 
              (18.216798975971539-18.328962013932561j), 
              (15.122031400384436+6.8148463377247808j), 
              (16.164365168526061+3.1074685413959675j), 
             (-12.494583193777853-6.0330498332500158j), 
               (-10.608570620097497+16.69468718280288j), 
               (-6.8462491602181785-0.7558881010610895j), 
               (2.7398169841721987-1.2360227533421255j), 
            (-3.6303650066211866-0.77140813425392851j), 
              (7.7641879225416401+12.361694184013567j), 
              (13.384048188782668+4.2948559127198873j), 
              (-9.9976549241091917-0.32523979834677752j), 
              (-3.2242393575345316+3.3836298108742109j), 
               (9.1217864582648076-8.8410955046915678j), 
              (-1.1757551115850009+7.6334186374114923j), 
               (-16.908534941931279+14.277185978093073j), 
               (6.7537938471268895+3.5432888266511671j), 
              (5.9690540405305637-14.733467085177871j), 
                (6.9931137076261143+5.9805242494219293j), 
              (0.46783460312874203+11.609937770418471j), 
              (-10.016193426135953-9.2787714141124553j), 
                (12.657689231291707-6.92979007046468j), 
               (3.1343459109061933-19.816097905635822j), 
              (-9.8732703276095961-10.616539668297936j), 
             (-17.259919640537042+0.22038840787542685j), 
              (-4.6350621998521193+5.0550439340741899j), 
              (-2.2929394869341251+13.322445396814182j), 
            (-0.23212349397209117+2.2181149912604328j), 
             (-2.5074643109129777-4.7530168995534705j), 
              (-11.421495692074885+3.3706223944619418j), 
             (-7.5302835109381512+1.8640133525208071j), 
               (-17.051583958037483-13.940819446422356j), 
                (16.53911977326284-11.280587570009894j), 
                (8.323396275476334-3.6940141136088336j), 
                 (8.7495620970252279-12.9427078698352j), 
               (3.3485792002208963-2.3238483788044362j), 
              (-12.358230429838574+4.0915314952878692j), 
                (4.6507692485235994-6.7565126173121239j), 
              (7.9953067534944458-14.242422317468096j), 
             (-7.0572581510926202+7.9063052156592857j), 
                (2.19009501849346+17.754424089349104j), 
              (-2.7022879723545197+6.7973569943526755j), 
                (17.44042044796765+6.8005358610126168j), 
                  (-11.6578689254974+6.943867537938595j), 
               (4.9977012946857311+9.8393724640673366j), 
             (-3.5242071218157638-0.74420045731750539j), 
             (-0.02325099473849682-2.9944605068144381j), 
              (3.1334005390775683+8.2264306132084073j), 
               (-2.7708531978821984-14.261936513729342j), 
             (-0.79034358895542323-13.951693224212091j), 
              (2.5170645548966615+17.878027241472083j), 
              (-7.3618022004471042-7.0151139033498735j), 
              (-10.149762044620932+7.5249477322889167j), 
             (-6.2981355150827421+17.355632647364576j), 
              (-1.9357048671897605+2.2433484038651912j), 
               (5.7254336882275076-14.162302966417212j), 
               (5.6806535616220266-1.2409144072158111j), 
              (-4.485488022042845+8.7012543608349127j), 
            (-0.27285059393280153-18.275767879588408j), 
              (-16.897337196330614+6.3276702780179441j), 
              (-8.7182264365146658+5.4745758866402197j), 
              (-6.1910222677083295+9.2658767384263232j), 
              (-11.561525024658215-9.553593043140614j), 
                (14.712425276855047-1.2569813609036029j), 
             (-13.507396081547281-16.163230755560662j), 
               (0.2729748374368503+16.972017893747768j), 
              (7.8018196237822659-20.805867555261976j), 
              (-12.681593539316157+3.6347406278368286j), 
              (-9.5955065561399451-1.2486674038333998j), 
               (7.5494519301002647-17.045838012977555j), 
               (13.14436027603004+5.7473676983471647j), 
            (-0.81344676355873335+2.3042534690198964j), 
              (-4.8457570838990671+9.3697985823447745j), 
              (-4.4381750639685311-8.3206870662226642j), 
              (-17.854794059547167-2.8626905600703418j), 
             (-6.5965560119601365-15.470773539830926j), 
             (-9.9320467557718004+18.575576366312315j), 
               (4.1126313234965934-2.4092181412427709j), 
                (-1.612410404214826+5.2925918492874029j), 
               (9.4959253619139297+3.8770042271141487j), 
                (2.156143278360553-11.523108539752938j), 
               (-13.051185537887742+1.8068913425840669j), 
            (0.027791992156397102-9.3745998820394245j), 
              (8.6572640166733326+6.1371888195817901j), 
               (0.918045404472147-7.0693157846901835j), 
                (9.8100058537452881+10.49970406882078j), 
               (-4.1253828181866723-1.088397184185133j), 
               (8.5045061401963178+13.314274006573097j), 
              (13.651217236306049+20.951205859016486j), 
             (0.91916707267086517+8.1860698418353124j)],
       [ (16.541638206151312-0.30894830307315385j), 
            (-23.705161619490202-0.034411197868289084j), 
             (-9.0969588439092597-0.8550802946547762j), 
               (3.4344750494946692+16.157446820987076j), 
             (1.9220222213160529+0.29598421127604291j), 
               (8.725040011080381-1.8927112889830875j), 
                (24.219029740904876+4.468912081635005j), 
            (-4.4365089078193867-0.70990833174528689j), 
              (-20.484035836735927-5.0101165555223472j), 
              (-4.1877604714717718+12.797968029015196j), 
              (-2.227549261916578-16.567367837715985j), 
             (-11.223859243735497-7.2960681982138533j), 
              (6.8160662236081198+5.1588357684580908j), 
             (-12.123411891244755+7.5548982680118693j), 
             (-7.5913299595563242-8.5296340134720996j), 
               (1.4168864368037117-10.631579879642764j), 
                (-4.219348448669149-4.1266060579014328j), 
               (6.3252441574771412-9.1968500117457719j), 
              (20.051399587748261-19.876261743381171j), 
              (18.573002345517278-4.8397128606126492j), 
             (-5.8755096574685064+7.1185895171246196j), 
               (-4.2936848421163267+2.5098918488113724j), 
               (20.978829083547716-1.1427188888819542j), 
             (-0.72869872332931562+3.6425641767957329j), 
              (-8.2506982056297389+5.9466331852656573j), 
                 (18.731186897531181-8.112524152517512j), 
               (2.0192668940051921-15.579939955728662j), 
             (-3.6072524174676186+5.3001662352672518j), 
               (0.40573413435036243-19.784739419512665j), 
             (7.9917476386976096+0.068644740477237218j), 
               (7.8209326269494852+2.9373801194275009j), 
              (7.6832991053134014-16.286206074633888j), 
               (10.008475774971114+8.4669954433496635j), 
              (-13.041269781312693-14.663094880937583j), 
               (2.7889217355366984-17.810770022026123j), 
             (-0.46218034003616704-6.9391871501517564j), 
              (-6.3320143939107272-6.0796158675942022j), 
              (12.425372808507847-2.6192976361309865j), 
              (-4.304382215694778+20.296093597854039j), 
            (-1.1358638287822802-0.056416930101907306j), 
             (8.8430574847317267+0.47174641503746184j), 
               (-1.5141350615288431+14.807712233304983j), 
              (-0.2908810973141604+3.6559930926140587j), 
               (9.1977118696379101+31.047441017904866j), 
             (0.080469026155207762-7.2174604325307312j), 
                (11.71386324650809-7.6913266607800956j), 
              (-3.9898941240068937+11.241459031637358j), 
               (-4.0569133770793124+10.402029255758867j), 
             (-26.424545564658256+4.1892367121451812j), 
             (-22.581748455217653+1.2925282925200767j), 
             (-5.4615034162658755+10.256564274500715j), 
              (-1.8281805889576717+2.8767712953756854j), 
               (7.8896290388663806+9.0192936642343113j), 
               (-3.3387795703999301-13.342547084498232j), 
             (-0.46277614056894018+17.596572483316404j), 
              (-19.462027728961818-8.8401438971536983j), 
               (8.4858007834706921-17.982772164855476j), 
              (18.498035472813282+4.3430452578450609j), 
                (11.806058865168669+9.4477233490466972j), 
              (-2.0566066674618257+5.4548277046692846j), 
             (-12.302809284754112+9.2154830622290778j), 
              (15.841322743822223+0.88397210481816024j), 
              (-22.078739206243426+2.3785850841824141j), 
             (-4.1835107848588846-9.4541753370180679j), 
               (6.3143281396527859-5.0551267380055673j), 
            (-1.0281231422180579+0.082062538475088542j), 
              (-17.055063390263182-6.9794685048969711j), 
             (-12.436294033901943-5.8557276234353122j), 
              (-5.8511359561254439+2.956257692723999j), 
              (-1.6433454409845496-10.406247442340293j), 
               (-8.363436133120798+4.9487620666046546j), 
              (-5.0559738887874541+6.9619767194143378j), 
              (5.8024902838979759+23.408021849040882j), 
               (-4.1844108632713635+9.0646560313540263j), 
              (11.687927413847714-5.3080054496585767j), 
              (-6.4041224927073905-1.6627712138310891j), 
             (-7.0428777320705303-20.615137474749019j), 
               (9.2609692274762434+8.5455664106260212j), 
              (-6.0047087740638005-13.888890049567051j), 
               (-14.96399847629856+9.1237065602833436j), 
             (0.20662183587605604-12.579425314910008j), 
            (0.035368857881964241-15.880378910984319j), 
               (7.6320615772114184+11.250163228290225j), 
               (16.387889697026747+7.2641445831687221j), 
               (7.7306344979528188+7.0778681685939047j), 
               (12.557162766033791+2.580887706439805j), 
              (22.557450564348436-1.6395182220931823j), 
               (13.716420830434535+17.787829252089622j), 
               (-8.9422923001980372+13.424867865770487j), 
               (15.700166490085895-12.834340216074223j), 
               (4.2939164471105356+11.027466208227759j), 
               (-19.822177874735672+17.257207188983063j), 
              (20.914166903493815-4.4306904892735153j), 
             (-8.7545420908682026-0.3838552726347319j), 
            (-0.75361878863330889-12.499501568934594j), 
               (13.538879790642721+17.245979808034495j), 
              (0.67666814786251239-12.033834224653425j), 
               (-22.48325260258153+10.312154394329848j), 
               (13.406155019877399-11.08323408421268j), 
               (23.892191355122211+8.651531024706733j)],
       [ (-5.3157968821414308+20.007160487773259j), 
              (0.12489424083087264+3.9788742692639683j), 
              (6.4030702635565682+8.8911096186380423j), 
                (7.016715691846068+20.105590767864538j), 
              (8.8181992468283266-4.0803560885289016j), 
              (2.5527632472431145+4.0573075345012208j), 
               (19.983817614225142-12.524668080698337j), 
               (1.683638692862067+19.840348576615774j), 
               (-27.117991222758402-11.54422193487939j), 
               (-10.34924796718582-19.638257178983785j), 
            (-0.36682611866068832+3.8870559586456932j), 
               (11.46173012034742-1.5298854068584862j), 
             (-10.129687601565172-11.319882820564484j), 
             (-2.2558710923517595-7.0862697811570188j), 
             (-12.366620622498608-7.6853585437181318j), 
              (-24.496693312702501-5.1418852805103432j), 
               (-0.29677606818841873-10.25586796534628j), 
               (15.884535414890919+1.7962162584899599j), 
               (7.728152379935227-12.717532215603693j), 
              (12.581769710638351+7.4330870402305695j), 
             (-5.7379646974122522+8.5158811783556452j), 
                  (7.4083330861414041-3.45438056179171j), 
               (4.5995514569269158-8.8279528698223668j), 
                (4.002691460039836+12.413402242979519j), 
                (9.791687182788694+15.249890233638567j), 
                 (23.73843251675374+1.7764473629471196j), 
              (-11.884656108553548-7.6558286416116328j), 
             (0.61957595323131531+6.0270398365702071j), 
               (-16.340290180100652-12.677760127109341j), 
              (-4.2612603021904016-8.6543991302165963j), 
              (-9.3371494345950818-8.5072553927814507j), 
             (-7.8296482424496094-7.3874225205165871j), 
               (8.5796742349966433+6.7640811771020495j), 
              (-3.9498292804965445+4.6683447855843401j), 
              (-2.7006388148808309-9.3094334646449237j), 
               (1.3451900057095025+22.124660549887416j), 
               (10.299340904054869-16.196438687952192j), 
              (8.4602847816649955+8.2626979979621584j), 
             (-7.1863525655986438-3.0475452068012254j), 
              (2.9185715436237469-0.71386301029151555j), 
             (-5.7323327077804223+12.350034555497743j), 
                 (1.6867797033896776-5.816162419419836j), 
              (-7.2731395742094769+8.8175160717639312j), 
               (19.246458490352577-13.407603692850255j), 
               (8.6575812616933749-4.3163869126987668j), 
               (3.2637326270349787+14.144620613637247j), 
             (-7.5633405755113294-0.09845792903366038j), 
                (5.3551166054999166-5.5380476330447035j), 
               (10.62957380336902-15.286545916338772j), 
               (1.9806326863404611+5.930753348635962j), 
              (-11.26791469278503-3.6919837207504154j), 
              (-1.6063082642006044-7.8860724268995739j), 
               (14.499794707679376-1.7968079223923004j), 
               (-5.9222499844087189-2.0783735973445796j), 
              (-6.0373034677316166-20.343142657563117j), 
               (-7.304103134768182+8.3086784720968527j), 
               (7.8752352483339241+3.7605885002517847j), 
             (-9.1688638647752398+1.7246788332568834j), 
               (-4.3663295223811609+1.1088532632690586j), 
               (4.2678673495221346+11.174380794943385j), 
              (4.5379516674846352-8.0735686654064764j), 
             (-0.49162292868778218+3.2906392200084627j), 
                (3.748966707826193-8.8787595956589165j), 
             (15.725542007750203-0.93050622374280478j), 
             (-0.58255840856713836-9.4883233436433034j), 
               (16.431851532330423-4.9701904894091768j), 
                (4.643953183409665-6.5117779828328999j), 
              (9.5329247725060391-10.157389048237356j), 
             (-2.7306215408821295+13.474058920288545j), 
               (19.477991267404256-7.7885099140090723j), 
               (-1.3807849145448654+4.177575497934094j), 
             (-0.12071514468927506-5.1627798080513854j), 
              (4.9514904905212864-2.0742636584348282j), 
                (5.6734287206063829+27.022087373555333j), 
            (-6.7324992073769776-0.48266552983289179j), 
                (2.1746675878910913-4.047047246385767j), 
             (0.46570166332813179+3.1263864307987888j), 
                (6.8081796018630829-13.42297586448365j), 
              (-8.9059003900842093+6.2982292389086103j), 
             (-0.45108614693069204-9.3910583160848891j), 
               (11.08575581679986+6.6519099079413362j), 
              (6.0392628443622982+15.089759132377969j), 
               (25.261307618320693+6.8857173176014843j), 
              (-6.0040685724348783+14.464573533841323j), 
               (10.308141254244635+5.7053625052288535j), 
             (-4.7364397531039426+2.1720150486893721j), 
             (-15.586283306032707-3.1648026295115312j), 
                (1.617778728888708+2.5570290702278302j), 
                 (2.9714232392456514+0.170776372478262j), 
                (5.942776063383266-1.9211173266146466j), 
               (4.1831405400156241+4.5331070106436426j), 
                 (6.8707193482033038-6.184770616846742j), 
             (-15.067726212113627+9.0190258216174115j), 
              (13.606394432432438+4.4078102278595068j), 
             (-10.083074299283998-13.987887012927159j), 
              (-7.3184984059480174-9.3134091447768501j), 
             (-13.594141288075257+0.36971649045372501j), 
               (1.3667530577594913+18.089197171359285j), 
             (-34.110673226754471+9.7683654160008579j), 
              (3.5273571501742467+22.641823268300648j)],
       [   (15.23083621368729+5.0979592963309841j), 
              (-5.5041477247117578+16.647960480528951j), 
             (-7.1509949338115035-4.1533312174276968j), 
              (-14.784267272829849-22.727581303603841j), 
             (-7.7014449894413666+11.187537297526484j), 
             (-6.0237703830213238+2.4158009349244876j), 
              (-7.4198251250975762-10.941762025098098j), 
             (-19.233166119309651-13.820724187967816j), 
               (1.5575521468709588-8.0261935000295885j), 
               (27.486474090672949+7.6947331638013905j), 
               (4.633210871432131+8.5151921107068844j), 
               (4.911814606792829+13.928817193663408j), 
             (-2.3175288186853034-12.399663966018222j), 
             (3.6440974061759328-0.52551517707940487j), 
             (-6.9474987507328585+14.019296707899578j), 
                (4.1162478861483738+10.42950462178969j), 
              (-0.18034133053983298-2.5887712852675193j), 
               (-3.7162802838803675+7.251587599095024j), 
             (-10.488174903225964-19.277287434766897j), 
              (15.986624875069005-13.236923509200265j), 
             (-8.7753649861133294-2.2251990541186579j), 
               (-7.4845311837340587-3.8689973136812812j), 
                (3.418110561875185-8.3180481565793762j), 
               (0.3920971917068502-7.6163945278358023j), 
              (-18.510297493145536-5.9068353048568065j), 
               (0.52534300842433357-9.4441172541200853j), 
                 (3.172266290999215-20.56804235772022j), 
               (7.105551695716529+19.428895156882838j), 
               (-2.5253794973516621-13.895663119308344j), 
               (-6.198031270758813+14.366814136738155j), 
             (-5.9034238505200491-0.21277473462238625j), 
             (5.3908538432479176-0.53769775826363797j), 
            (-0.77044887367974457-0.38776229864535611j), 
               (14.084062600972773+3.0717650815292412j), 
               (1.2213663228530276-3.5822064580865054j), 
              (-4.9884666811025467+6.2458456687666537j), 
               (9.5486981735480363+1.7221593731500404j), 
              (5.1223027332325843+7.4833098121283381j), 
             (-12.417441887037787+3.9909661208178009j), 
               (21.969753202344663-1.2135562989897632j), 
              (10.139528155743072-1.7025014870577131j), 
               (-12.504973026153996+10.127675418876672j), 
               (9.6621320967013951+11.463305949870113j), 
              (-3.4161119687421131-14.663433615825811j), 
               (1.1386142953808231-5.6659433058592503j), 
              (-9.3532421557367513+9.1637407611794792j), 
              (-15.719041374297589+4.6557398110737402j), 
                (-4.9669173201872265-5.186096530180059j), 
                (8.4031117753702862+9.62342801467919j), 
              (14.580125559038636-3.0672302947249723j), 
              (15.657210132456804-10.766159036253409j), 
               (-11.33531534440089+13.503785045137079j), 
             (-0.77173251644163376-5.9724317996353111j), 
            (-0.070530512328861178-0.63233614399392413j), 
               (21.449097569434098-3.0931623635514245j), 
                (4.9459732112541701-10.05248927425791j), 
                  (20.124140327254956-1.7054878630768j), 
              (2.3775603436141566-2.4771701970799223j), 
               (-4.4629318502209268+6.9182941082899871j), 
               (6.8990742116504569-2.3215240059556836j), 
             (-1.7792773269179119-1.5212361087861515j), 
                (2.141178022885172+13.667052916044046j), 
              (-4.8988733280540124-5.2274915932730099j), 
              (-8.7311523607018753+3.830474513770505j), 
                (2.240833898954548+1.8649447410137876j), 
              (5.6662852356140805+0.84466120867473626j), 
              (-3.3474732562872775+6.2615807886945767j), 
             (-9.1318041514520658-2.3609234454240995j), 
             (11.568496028513454+0.36010660528549754j), 
              (-1.7864659545649082+11.032650197859279j), 
              (-5.1969370448918415-14.361621547627957j), 
               (5.2859314933306969+9.2151331062116864j), 
             (-3.1852260471028919+3.2927942071655236j), 
                (-2.9803451044177507+4.717841517128365j), 
              (22.071426545028444-12.597205562282486j), 
              (-1.1544576656288053-4.9956766702113962j), 
             (0.20723240949640412-1.6555017690733465j), 
              (-27.081345307666083-8.1638875947391298j), 
               (-19.28692904190483+8.4216922334609663j), 
              (-1.7395942260048329-16.164310313028206j), 
             (-7.2850066287230186-8.7908901940757929j), 
              (5.7084756503429412+5.5039937802702541j), 
                (1.7038273697463815-10.66320684896785j), 
               (18.368044385492212-3.0324778079763783j), 
               (17.658758657360917+11.546244799129878j), 
              (-1.3653803829966611-5.811176850856973j), 
              (3.3860017053387188+11.293400404392219j), 
               (5.4890436631701789-5.5320618273914839j), 
               (-4.4059229177194386-8.7277699836629274j), 
                (3.6043267618866088+4.544536016943554j), 
              (-2.7547655889546956-3.4605368540162207j), 
               (-2.5953949091869575+1.0600362845176705j), 
               (1.957354245382932-3.4398428431953358j), 
               (12.23108631823418+5.7172479791428312j), 
              (-16.24986456461238-8.8813984274628091j), 
            (-3.1129624892799117-0.097863305208073501j), 
               (2.6377128441980751-5.2515250963004334j), 
              (0.39141259811360846+3.5554275336690573j), 
             (-6.6558901275364226+2.3486373245923859j), 
              (0.76319012073231052+1.045880255193711j)],
       [  (5.0902408311953913-1.0188694192814565j), 
               (7.3984711531258647+22.096742975073727j), 
             (-7.6573799950680277+9.8656039986220954j), 
               (6.2504572464354471-7.4871307342553628j), 
               (4.4691255270136434+8.195705465869473j), 
              (4.4024314256948731-2.7675591107829227j), 
               (9.1156144949777502+7.2845145220818051j), 
              (5.9803464706122718-3.8876406155153487j), 
             (-16.248001101972328-0.84084089982519883j), 
              (-8.9465763988029892+2.5006440168239825j), 
             (-1.2215446706852702+12.827797093209794j), 
             (-2.0449300596049822+5.4980701356331618j), 
              (18.640109835393449-9.0504106210378943j), 
              (-6.63436554537539+0.85016307598373686j), 
              (3.7599163971958856-1.0786153018047737j), 
               (1.4313638739448735-21.784367707074832j), 
              (-0.86647107337602003-16.202279603833293j), 
               (14.289676543525315+3.8195385770486951j), 
             (-8.6151080137693263+16.208415968113748j), 
              (17.553744384167743+12.087727042212871j), 
              (15.451816365050819+2.2301735027038601j), 
               (-13.008745683153741+4.4202567632098919j), 
              (-7.6905646334490276+11.137074676475402j), 
               (8.2456535404227047+1.9949759363122568j), 
              (1.1448547043956163+0.97881530289203711j), 
                (-3.449907334411308-9.3726389317901955j), 
              (-3.9659311365738539+2.6141943225193809j), 
               (0.372286844866907-8.9217627877240204j), 
               (-1.1937067522820102-2.7769038010085882j), 
                (14.15722447461247+8.4461973860683379j), 
               (6.9837478021838706-4.8368059257773446j), 
               (8.9773945611688521-15.71306299743669j), 
               (6.8011470094701156+7.2250698617596001j), 
              (-8.2485101392739288+10.101479030682203j), 
               (12.189830866591759+2.6411232676364427j), 
                (13.12602895169409-11.311163854963766j), 
               (13.871121553466509-19.244103363509907j), 
             (-4.0293363494366492-12.566654676228652j), 
              (-5.2297737579492285-16.10094996927425j), 
              (0.17919578828944097+2.8515409543224806j), 
               (13.926039295708993-1.702663042328437j), 
               (-15.744429223944653-10.507696166070842j), 
              (-10.378066676947622+8.6017980320042469j), 
              (-10.476888209901482+1.9470702611086268j), 
               (-8.822242333086681-8.8795512622151023j), 
                (13.214392009080848-1.014498542239284j), 
               (5.1351957525507128-5.1967096572489684j), 
               (-23.339559820489413+3.0320213880022373j), 
             (-7.0173823933691848+12.249427496583721j), 
               (9.303634443414305+2.4709446163664932j), 
             (-3.1534441257430963-12.085689469232699j), 
               (4.6593136371366377+10.679773140358082j), 
             (-0.71335075742778598-8.7302545088486259j), 
               (-4.9853247562739629-16.403510148139564j), 
              (-6.2942157061056934+5.9341383987830518j), 
              (-3.2951707993256072-4.4082656379695004j), 
               (4.5886831628667357+2.4454995867905964j), 
              (6.4640379543518272+33.281531587348361j), 
                (17.395071827510328-2.8942630571056327j), 
               (8.3821779943295862+9.9989484008723739j), 
             (-12.816647323884684-2.5387802741452137j), 
              (-17.486964688675751-4.4434149156090585j), 
              (-15.001400921165812-6.0311021864017409j), 
             (-2.2722819816544417+3.0374017003485987j), 
               (-6.9189550429868198+5.032048521438611j), 
              (-15.272026558407019+3.0158939386086736j), 
              (-4.5137907029797031-19.431614485135146j), 
             (-10.517419835073047-10.380303013117766j), 
              (-5.693112755009194-13.040426642007073j), 
              (-10.898525861738605-3.3373983228437041j), 
              (-8.1220080348793218+22.297952979755262j), 
               (6.5397764861211165-16.510847020510717j), 
              (-12.326092537422513+12.07667217988427j), 
               (0.49449441167591546-8.6079149757390141j), 
              (0.6639719184044488+2.9973158532712625j), 
               (9.3707247916926697+15.212780374961085j), 
             (0.31425258963735192+3.0054749681616371j), 
                (30.71580520202513+9.2052161239902173j), 
               (2.9704479647426343-2.5448825776378086j), 
               (10.208531199896939+4.8847420251813221j), 
              (7.2355332932833534-2.2538922623361084j), 
             (0.55919449962557588-15.627509169319172j), 
               (2.8806545781260051-4.3660104005509499j), 
                (-1.28923513695772+8.1498545511755811j), 
             (-0.65537859038711388+7.8822855082514618j), 
               (11.62065187798143-14.618723840758639j), 
              (7.6635141292393829+10.184994526329834j), 
               (2.2302017897479747+1.6741504409051868j), 
              (-5.8710715162914315-0.81029070748329812j), 
               (-1.274259405167627-5.4149434250706037j), 
              (-5.8856565297436241+8.4649684789234509j), 
               (-8.6019184103498016-13.478611953429699j), 
             (-2.0925684212237821+5.4409684087222923j), 
              (-10.495781409416676+10.99743003532179j), 
             (-9.3459002510249292-5.4189735745914849j), 
              (-10.040281911287243-9.5355295030877087j), 
               (13.611886170925622-19.423800292253343j), 
               (28.878254789049041+7.6232873546140967j), 
              (8.7404169042634887+19.758165673230156j), 
            (-9.9135332276945363-0.72331061739253411j)],
       [  (7.8199245734279943+11.915320798131081j), 
               (20.662169521857756+8.0683340873976093j), 
              (1.1015713671421943+18.546173591542058j), 
              (0.85004065817179697-1.7167699731835497j), 
             (-3.8887749444467978-8.7561465340099396j), 
             (-4.3531427991007812+8.3472476386186649j), 
              (-3.2342776725807472+6.5359624211719964j), 
              (10.432562644581218-12.140263084068287j), 
              (-2.8772521847980368+12.520173207916145j), 
              (-2.1936819258736313+3.7191762825514929j), 
            (-2.3268505007344338+0.85203355743534992j), 
             (-2.4711162830047018-9.4695211660474286j), 
             (-1.2410551270849577-14.732545433555266j), 
             (-12.777277412891765+4.3785287587086579j), 
               (3.1555337945996431+22.83907926226339j), 
               (1.3650166522126854-7.1471247868346968j), 
               (2.3763667316157906+0.53576067679100525j), 
                (2.954844734322208+4.5978324434130702j), 
             (-22.820643316390349-14.963573341660808j), 
              (-20.59554853839267+7.0056385046856082j), 
             (-5.4013931214004876+6.7338036990352856j), 
                (11.186890018304263-5.5563937900028879j), 
               (6.1086290676528421+6.3475066732973691j), 
               (0.82486111470725709-15.92675977490082j), 
              (-6.5229367518926926+11.644874924186068j), 
               (-3.9776522747113141-8.8344502933571896j), 
               (3.6466073840753954+5.1456573368467016j), 
              (-7.7695834468007963-3.108358722687234j), 
                (-12.933920410376894-20.65723134313092j), 
              (-7.8529030536480846-7.0287865818617323j), 
               (11.867761522755579-1.8138348154171102j), 
              (8.8224327521910197-1.3313142773903013j), 
              (-5.6483337962048727-12.455517348596368j), 
               (13.276385719886454+3.0254440648918441j), 
               (6.8866905666581228-1.5763271130877476j), 
              (-30.355435621276641+10.367977623092017j), 
              (-11.014938382947356-2.5758758015446959j), 
              (2.3655024698724176-1.0169611363834776j), 
             (-12.011483074405762-4.1370814385743779j), 
               (5.9577423346743421-7.9841541923222508j), 
             (-4.3609609894584631+9.0789503844779329j), 
               (-14.775082887280043+11.355332910190288j), 
              (-2.8624192497001459-11.959055426420528j), 
              (-3.9619173031559995+9.5789092221404477j), 
              (-1.4952712099451264+1.8904712468954394j), 
               (5.1045737449647044-1.2391065122611296j), 
              (-5.6798078643543901+4.1343160528375424j), 
               (-11.643472756106263+1.0467699669890176j), 
             (-4.5970215843276288+2.5904143571840632j), 
             (-6.0058127507076371-2.8763949897007715j), 
              (4.8327086350340061-29.122796836255034j), 
               (6.7356019748087794-6.2551194175730274j), 
               (-9.1551062598483508-4.293862417139608j), 
              (0.014800958635234673+2.0683499279178532j), 
              (-5.1065017581452761-1.5914140179973133j), 
               (15.135936001159411-19.921350025180733j), 
               (4.7496842142889326-8.5794578244156217j), 
              (7.5618491638089829-1.2284563691671699j), 
                 (3.806732333698422-8.2775166669380127j), 
              (7.2664196249203439+0.44405241622161196j), 
              (4.6324994372351274+7.5722738185711203j), 
               (17.783689564026236+8.1213157103859075j), 
               (8.6129807748322165-11.545247545179471j), 
            (-0.74993334438598336+3.9015748803919288j), 
              (0.54927554677497203-11.070146226897055j), 
               (-9.689374152958333+13.102826478098963j), 
               (-0.491538536442086+11.733448812387675j), 
             (-2.5488930063512232+13.832632440836353j), 
              (-1.4557243370177351+15.69980213285336j), 
             (-4.2107805908726812+0.76623834761394061j), 
               (0.52071726461323475+25.13634803495675j), 
              (-11.416858546813877+2.1378956524662409j), 
             (-5.5039052676740603-1.4686814981877263j), 
               (0.16801173981650974-18.716054594590517j), 
              (7.9036979780055407-17.933070653471397j), 
               (1.6974046222238273+7.2024447583507865j), 
            (-0.23041885477661891+17.120300567176404j), 
              (-6.5037211886919142+11.372680622058553j), 
               (-8.8485473087063813+12.53528234705646j), 
               (13.112598458029158-4.7494320482092984j), 
              (4.7662624433796843+9.9665589801563161j), 
             (-1.6451444200338265-6.6221625331874536j), 
                (11.828549104253492+7.018986521776065j), 
                (2.6998522066850188+8.701665148291422j), 
              (0.63126566092364089-3.3039185851723554j), 
              (-8.722103954633214-7.3842634585827085j), 
              (18.859843169973249-15.716274087551724j), 
               (2.4663982179966411+2.5947783188885958j), 
               (-11.445935192702851+7.8636544649907556j), 
              (-1.2032228865941033-11.206030655147449j), 
              (4.4434858382111901-0.18988093676581999j), 
                  (4.03376710410061+19.335209118848116j), 
              (10.838154190327682-19.783093427748526j), 
             (-7.9106701640923287+12.515334645343126j), 
             (0.74882589855237103-8.3216271058917162j), 
               (12.366338200455285+7.0104243252049203j), 
               (6.4387880310678458+8.3753427863951266j), 
              (-6.2292160054339938+4.2650739226438015j), 
             (3.7654240897034659+0.48283420727364901j), 
             (-10.73287042818038+0.58835243079848631j)],
       [  (6.8596223016503028-16.673093815382074j), 
              (0.48473260015655018-4.6421483954311515j), 
             (-9.5817802492632964-17.330182062833366j), 
              (0.29447817253141201-28.287573036347261j), 
               (4.7256189783083062-4.812094193349628j), 
             (0.07041229551627437+12.559821429895219j), 
            (-0.53396081318748378-0.37644776140912428j), 
             (-12.922218061591838+6.2015109869077145j), 
             (-4.5206823203377846-0.11505004245457098j), 
               (10.060933631567799+5.8841006746184394j), 
              (11.409252226411898+8.8235800196088139j), 
              (1.7696951138982422-23.466098103627946j), 
              (15.683724874674059+11.364980638939244j), 
             (-9.7899466585332107-3.5372027236833716j), 
              (6.3658644477507185+7.6075589790634659j), 
               (12.881861428761125-7.8784857805158719j), 
                (-5.193636548118219+8.4165583282883123j), 
               (1.5243858949138627-1.6264478951729773j), 
               (3.992494409601353+12.712141604143072j), 
             (-17.466273443837011-4.4138558755464263j), 
             (0.83013603532416391-7.1545962864755976j), 
               (0.28819870854962282+19.941328023181914j), 
               (3.6018223819562003-6.4161403359768485j), 
              (0.57493531099984774-2.4192855267328737j), 
              (-6.7340219149507066+3.0454979130043696j), 
               (14.816607851269808+0.43052985063432864j), 
               (23.127060244652519-2.3327959521467196j), 
             (-18.324714213514174+14.136248776601692j), 
                (3.8450629447311351-7.6018648915810356j), 
              (-1.2995947696857884+7.9138059559376348j), 
              (-7.4617542544632096-3.6662895047355599j), 
             (-1.5514004853778234-19.989331676024875j), 
              (-11.448477882198638-12.512703104576463j), 
              (-4.6551642595895508+14.156624109805286j), 
              (-2.1343550706448693+3.9673968250012956j), 
                (1.9208728798132695+19.73866589949921j), 
              (-8.6574770931903693+2.3278969945543775j), 
            (-0.41945420473789052+4.9996405054519162j), 
              (6.1104549149907506-1.3725176612667631j), 
               (14.358011383280138+2.0410452406503636j), 
             (-4.1412715981970756-3.7136947481085345j), 
                 (21.593295802941199-3.245921920395471j), 
              (-11.989032450755611-1.2022781879985438j), 
              (-2.0527555958858943+3.4357432192227613j), 
               (10.082047205353266+4.8213600264527452j), 
               (4.9316249069583664-2.1400182637277219j), 
              (-7.8136561766508823+10.788554209543076j), 
               (-6.4929873944804548-6.8597585821909366j), 
             (-17.281521111862531-14.692979226799562j), 
             (0.23485690713343774-1.4605817922568414j), 
              (28.013355272356151+15.878332551947292j), 
              (-9.8581105200114898+7.6030758346438621j), 
              (-8.6202685820751395+1.4279508419814837j), 
               (-2.1809566088525236-14.815648603013489j), 
              (-5.5293407216135728+18.124963871217759j), 
               (9.0601072295138234+9.7040601293433468j), 
               (19.330480521006322-4.6690592715545751j), 
             (-13.144126348857313-5.1011628549830643j), 
               (-6.7666788991536331+16.755170116353085j), 
              (-0.8315693706156736+9.6844114873026044j), 
              (-16.14449632777227+12.791314666084999j), 
               (28.772042302090149+13.143761033650705j), 
              (-4.0879702776526674-7.7691862120199033j), 
              (2.5160117019643673-19.834034454359948j), 
               (3.2756126003039849+3.5537144314003166j), 
              (-9.5957731238266533-12.819249494670562j), 
              (20.846077971195456-0.30408530279866958j), 
             (-2.4374888125119369+6.5489845689681818j), 
              (3.4664230395556794-11.055121378456166j), 
               (10.25113046426819+0.11642076621790171j), 
              (-18.150723110107748-21.664842169113356j), 
              (-8.9896247875705182-3.2790880978779708j), 
              (10.956333985706891-8.8455795043320435j), 
                (5.5572980003691264-10.827945520233895j), 
             (-11.081908935471018-5.8519945117379146j), 
              (-1.7959421259779877-11.775471227271508j), 
              (4.0542477420247982-15.633051447387935j), 
                (12.384719562187874-1.330753007188938j), 
               (-1.8493838423080597-9.310557728997388j), 
               (11.697816892832652+16.365029426964568j), 
              (10.920825681680352+15.250684913442427j), 
              (4.5183793632278881+11.807211650143115j), 
              (2.2747267280171117-0.73039993507179435j), 
                (1.999657757133054-11.793092848814473j), 
               (-11.293603551603086-7.120985040627021j), 
              (1.0274121316940581-9.2361808557674543j), 
             (-12.154634200114138+4.1581307191434931j), 
               (12.188191351934494+7.2981631328028476j), 
               (-10.625398696964705-0.6583542000729693j), 
               (12.611207020658501+2.8320337212788593j), 
              (-4.6569551289300746+6.2802936537388918j), 
                (11.498250614808136-10.754565822426169j), 
             (-7.9288621590352157-5.0264577975611004j), 
              (-2.1002438805178203+9.650530793419076j), 
              (3.7577750991277177+8.0002852779666238j), 
               (7.5567431117461714+2.9064684238300904j), 
              (-19.528301956294161+17.967873517055672j), 
               (-6.884402250508268-10.011950035878554j), 
              (16.967214243468725-15.309731797466908j), 
             (-5.1321371161538583-4.5677930189715052j)],
       [ (-8.9483885049050134+20.274898979682263j), 
             (-0.96515167797458512+17.585563918218231j), 
             (-17.847185426671473-7.9919674501639282j), 
               (12.386940583620307-9.4189748663648363j), 
             (-9.1922482936325167-7.0387158080673249j), 
              (9.9113598868812964-7.1063229863999844j), 
               (10.440115749260134+2.0413519770284694j), 
            (-1.4971109389433688-0.24967474378994986j), 
              (2.2744902402079683+0.68717992541249395j), 
               (3.2505765151885964-7.5108853857741531j), 
            (-0.67059862772649459-2.4216832296931359j), 
               (10.786928322089512-4.951792922526935j), 
              (3.8755462299915822-10.894430934953443j), 
                (13.544805326142413-21.5550158684654j), 
               (5.9600316023315898+2.898945676935369j), 
               (2.7182737931916008+0.3359633331306624j), 
                (12.147996903714379+1.1303983769575998j), 
               (7.7574153398410193-9.4980021688546348j), 
             (-1.5358592381943739+10.942483349842249j), 
              (6.7467326908270229+11.193933656249886j), 
             (-11.030278283249759-26.988510493268052j), 
               (-10.62819871241064-0.24075445404921064j), 
               (4.0190671780902205+4.9029722121581765j), 
               (-1.108807279584836-3.8384473617166237j), 
             (-20.762955486574484-0.72090943552763476j), 
                 (-6.107910547721441-6.777226863959668j), 
               (6.6625119442810918+9.9374663947112349j), 
              (6.0289055136262153+5.4760415088031236j), 
               (1.1103468998391872-0.66754888048944694j), 
               (14.375311606285226-11.975207344206547j), 
               (-2.1339425478637235-3.760794763573696j), 
              (7.8216236203497482+6.8060081610639189j), 
             (-0.30692055007711638+14.508066609870202j), 
               (-3.878501615231368+16.873702684393795j), 
              (0.44123830242800471+5.4100746644243358j), 
               (9.0319354484004606-6.4350655152660465j), 
               (5.2398151068489573-2.0483050247409107j), 
             (-17.789744023047746-15.546267575707786j), 
            (-2.2722600308049938-0.82684548442765138j), 
              (0.35162227045001981+7.3646723356664623j), 
              (8.9227408169823956-11.905240482589527j), 
                (11.290115688333675-14.442398758866137j), 
              (-8.0198672126572585+4.9931515406603539j), 
              (-11.098394428993792+7.1798568710007817j), 
              (-3.9661239553117311-15.023303459380843j), 
               (4.8124107624122043+5.9078718128738252j), 
               (13.994097728617934+3.8610163051650623j), 
                (6.9683350800977086+6.2988898018390636j), 
               (13.944660064999578+15.91440462631815j), 
             (0.89646535743564559-7.5116121348790807j), 
              (-2.3491401528490781+18.43447680909776j), 
            (-0.034702901470828572-6.2819362017751352j), 
                (-24.9578640757816+5.3158463103839484j), 
                (5.3324979548732934+9.6547014047843476j), 
              (-3.6259235128440146-26.910396517163019j), 
              (-22.499053976719022+5.5450238516725836j), 
              (-2.6585176952115379+8.1073542054697274j), 
             (-6.5292118803157333-15.210362191845054j), 
                (5.3186459592521595+11.178250447586191j), 
              (11.595770193930342+0.50485459184270509j), 
             (-11.630866249789618-12.260032360706925j), 
              (-1.0385393382668662+2.5780300104771663j), 
               (-2.497003141136469+2.1504863748089806j), 
             (-11.369458391905072-6.7925756968630004j), 
               (-3.3919132620818457+10.99359133672311j), 
              (-2.7565534068814741+9.7201583053755982j), 
               (15.770074050514513-16.521139936739949j), 
              (11.869495723345276+1.8837734043597649j), 
              (7.5343194741188926-5.2693269986319669j), 
               (10.455630317132954+7.3540214181869814j), 
               (5.0679341198400305-9.6577666664200841j), 
               (-7.186798117721704-16.948678095475088j), 
              (7.9860038028093063+3.9118619876668892j), 
              (-0.45162061178161284+6.7906326728726132j), 
              (-13.36187180987106+7.3384579233264873j), 
              (-23.217185527164279-7.2765810541571909j), 
              (0.8179262133528411-14.842768345829329j), 
              (-7.4739342790066008+7.0662184913506065j), 
                  (19.147434148056-5.9752660094828967j), 
              (-2.8082453993557701-11.394447562106489j), 
              (-9.8178106415391451+16.62509579807039j), 
              (7.7524271334159112+10.003565246826922j), 
            (-0.023696736971478082+26.394378563104759j), 
              (-11.580595953998316+3.5497824130255546j), 
               (9.0945051153703975+8.2992196856676905j), 
               (9.350084816553947-8.8776067834584858j), 
             (-7.5926997504041394+14.941809473583271j), 
               (2.4015704458001448+1.6782339520051546j), 
               (0.42915006977869102+6.3441838956346484j), 
              (-13.920991775872293+12.847555217133017j), 
              (-7.6600013048892501-13.317758220918211j), 
                (15.997087937340812+2.9918579396696403j), 
              (1.9486471800939764+6.9203845030934268j), 
             (-8.0647108994162693-3.3935354574119736j), 
             (-19.428465269418517+8.0843859895621062j), 
                (5.751805672556066+15.129025827025817j), 
                (3.5348211718668492+5.983087059540761j), 
               (-5.574129662422882+4.0311260730089495j), 
            (0.038736413367419745-7.9442086142852961j), 
            (-8.8597513048004561+0.83523107202134828j)],
       [(-0.68808255155516673-7.9852231027171179j), 
              (-5.8055327454182146+11.221160663039031j), 
            (-0.40402395086695692+4.8964428579129979j), 
              (-16.395045668552726-3.7197357803916935j), 
              (9.6852499803194281+6.4142722931443155j), 
              (18.495901925329242+8.0309688503254613j), 
             (-5.5879630067025694+0.32806099562241425j), 
             (-6.3301583983493392-16.353946626508499j), 
              (2.2163287421865387-0.81462188037264971j), 
              (-9.0710483528858532-9.6331135200206948j), 
             (-3.9455386764899343+8.4198819551820918j), 
              (12.382491578845618-2.7707795251448415j), 
              (11.139352373514875+3.9166434739732212j), 
             (-15.978596787579482+14.694572498257363j), 
             (-5.6908143333315024+21.722504847957897j), 
             (-7.0420492499767366+0.34938287185320266j), 
               (-18.001505217530816-7.5260502705179118j), 
               (4.8743887468423317+4.0533689584331185j), 
             (-6.0859047375687068+1.1353760798287946j), 
             (-14.388676687986075+5.6085955839779933j), 
              (12.509993213770613-9.3528239184449706j), 
               (-19.980697325895566+3.4037225940467817j), 
                (1.5976427750727982+10.31994029054024j), 
               (10.143804210419709-16.858267184504356j), 
              (-29.606117491764444-1.5472418765833931j), 
               (-15.530880499856966-3.8607349207292252j), 
               (2.0342677858773373+21.172565799082136j), 
              (16.327520024169687-3.0464522772106757j), 
               (-22.005040625673988+5.0450986887743268j), 
               (3.669339616423017+0.62462347577818167j), 
              (-1.4679084196086398-10.486276614305813j), 
             (-3.8792432932676064-15.449526039058801j), 
               (-6.378390677906518-18.009762403544304j), 
               (1.8108712347532592+1.0709838987694669j), 
             (0.67246724402270397+0.12288542718945311j), 
               (18.518045155471079-14.937359863271819j), 
               (3.5854613293375159+14.833857145721236j), 
              (12.151923584177792-17.415512831539115j), 
              (2.9846011063768736+8.6418737828007064j), 
               (5.7859463981782531-6.4457868942076821j), 
             (-5.5754041350526249+7.9571789541392555j), 
               (-11.793607086985878+10.910567869835576j), 
              (0.32318338822845877+3.9348005917503737j), 
               (8.9472296156361466+16.572866845041712j), 
               (19.054862051709392+3.9480390580369447j), 
               (14.508650702104834-18.065383429910142j), 
               (-4.678043486480008+9.9954974929007214j), 
                (6.5369981710440594-2.0729205693125992j), 
              (22.824361660263321-0.8087922520581925j), 
             (-4.6003138024244725+3.2982607281364769j), 
              (6.7036019956907253-12.950410327899926j), 
                (7.7854554307817301-8.864870236825471j), 
              (1.0665485306218025+0.99032902200838868j), 
              (-0.18281032912314188+3.0536566782291952j), 
                (-12.1263429062213-13.154720216815996j), 
               (6.8137609139248969+2.3590805363987961j), 
              (-7.8823131393688559-5.0211462244548493j), 
              (10.431864193758656-6.7980985631392601j), 
               (-7.6110416406510071+8.8743114930069193j), 
               (12.056024802814854-3.3049107905820674j), 
              (20.128787844355958-18.082778920403083j), 
               (6.2007171829202514+18.604858196738874j), 
               (-3.645317122930305+5.4856208275717595j), 
               (6.1870371356726084+21.49773773219248j), 
              (-7.5371898222872247-3.0254280962192515j), 
              (-10.530742961871853+2.9024557880911059j), 
             (-6.7083825880091723-0.37822107632856172j), 
             (-16.190786437459611-4.2871902013222831j), 
             (0.49115367241691743-19.536846759241531j), 
               (7.0394509649865276+7.0804365001549261j), 
               (12.974799419717101+5.1037252355647684j), 
              (-12.303890541673502-2.3562668779198819j), 
              (13.611178105827676-4.3376975505681408j), 
                (19.928637674848968-5.5551294215635627j), 
             (-4.8098549381976587+1.8771144551178451j), 
             (-13.032888392660434-0.65306709859421086j), 
              (8.4198124453910488+7.2521639993145772j), 
               (11.898252634157556-2.1493705986151248j), 
              (0.58879712498440862-6.9550447348890145j), 
               (4.1017757702577686-12.965332724472205j), 
              (9.6390111018793476+3.7562969744163777j), 
              (-1.756484987432374+3.2989160124682426j), 
               (20.104404282397645+26.343879305831752j), 
               (10.231017308371321+11.216313188674444j), 
              (-9.2347478196629709-11.351669228846122j), 
              (-3.6847501583599267+2.450475771048013j), 
             (-15.935375189266122-7.0331571080162778j), 
               (-7.458679429015489+4.2875340765068612j), 
              (0.013295652944685779+4.4018491594244864j), 
               (1.1020489503488122-6.4895237104347192j), 
               (17.497663864928622+3.4019609954278449j), 
                 (6.7221139485347559-3.313573437794866j), 
              (14.583313735916132-2.0617933166461508j), 
             (0.93054626602858914-18.993717694978773j), 
             (-24.566728857024373+9.1147762009121998j), 
                (2.260901126165598+6.7840089480135726j), 
                (11.15282277633175+6.4417578381411369j), 
              (-10.449204887407852+10.514826431657056j), 
              (1.8144308423261162+2.4292318747767143j), 
             (-9.0073383323361185-4.6163991161391325j)],
       [  (3.8620121735073774-12.443056293958289j), 
             (-0.45705872125754138-2.0204402547221303j), 
             (-6.6763025385262793+19.185307662102367j), 
              (-10.854650604440394-14.495210700281165j), 
              (-1.881885421927592+4.6752616434869978j), 
             (7.7089736316955007+0.10428025898794198j), 
               (2.0010249148478083+11.427134993379633j), 
              (-2.626602297669034+16.447123519209079j), 
               (16.323367559331714-14.347725381152516j), 
              (-3.0387900206870535-11.458971160181024j), 
              (-2.9734235930536368+12.32779081595665j), 
              (-21.112591287263143+5.790832792456829j), 
              (11.871222869293485+9.0105897598479032j), 
             (-1.8623329308644234-18.918502376172267j), 
              (-15.73502325812904+11.220108459141239j), 
               (7.0432833404761492-12.327187217698077j), 
               (-7.6900347507944495-3.5206980285141691j), 
               (17.728373222042141-6.8310294836491048j), 
              (1.0856309872574097+10.123351782929861j), 
               (-1.5905056294892608+3.21596609194129j), 
            (-1.1510786724768711-0.46660076961708774j), 
                (7.5527816070120632+1.3076903863935989j), 
              (-16.536526340278904-3.2825351451392493j), 
              (-7.1853154196641587+5.0324263016228326j), 
              (-5.6445824290387279-4.8309924076666215j), 
                 (3.884552441561762-11.818068950627058j), 
               (4.5122887091406936+18.563102337253426j), 
              (0.19385476227080087+8.094971059260871j), 
               (9.2550747417395112-0.61207611563688924j), 
              (4.9075007918746589+0.51139328587510424j), 
                (13.18001674384621-2.7561116597472597j), 
            (-0.14183843971559354+24.754203700498572j), 
               (5.2042604639895353+10.580718291162887j), 
               (10.675210245083049-8.3829958215858511j), 
                (-3.94448513290244-9.1477120895102413j), 
               (7.1005092469891231-2.1969639569001806j), 
              (-9.7386782632911455+0.7157025375680075j), 
              (3.7493592082971663-2.4220823222023271j), 
             (-1.1898399572323193-6.9320679962538865j), 
                (4.484853086071853-1.1989859413876383j), 
                (15.57150202595572-2.150504089352991j), 
             (-0.059399774439297046-2.3472999378683785j), 
               (20.651752154395496+14.552628438674027j), 
              (-11.789353777014533-6.4219540460578015j), 
              (-11.524609419251801-6.8117281417425417j), 
              (-5.1270380220879144-11.821419613295046j), 
              (-4.3827529184664069+33.370823923109022j), 
               (-10.749385759035182-9.2132269291022695j), 
             (11.662342855581123-0.50661285955655599j), 
              (5.5177001412999696-2.3333107001458382j), 
            (-8.9327428137652625+0.57461036656985887j), 
             (-8.8151878873375722+0.65161014089071645j), 
            (-0.94272119580320624+0.34754987798264186j), 
               (-9.1011376652007918-9.5819069911938968j), 
               (4.4991290935379897+1.4701659751152527j), 
              (-6.8625116997638367+12.104645369811475j), 
               (2.6161861848374897+6.6840314831015579j), 
              (3.7754414286843341-5.0018127344562942j), 
                (14.105302707062393-6.7402692736803669j), 
              (-1.3109727461551506-7.2190064410434065j), 
              (32.872171359714535-3.4832827620732658j), 
              (-4.8540715267745638-11.931388171491372j), 
              (-8.5998184148701196+4.6208158601373386j), 
             (-0.57734942692346147-12.98612601587298j), 
              (-16.449668255464104-2.8973605681301966j), 
            (-2.9631458722796045+0.011253797991708888j), 
               (2.2647901212260373+1.1033344375376433j), 
             (-2.6712355387516262-5.5104142271028813j), 
             (-4.7383768454810165+3.5968628598275156j), 
              (-6.4256495005265997-16.778849459979973j), 
              (-2.4193587048696537-9.5881870938434126j), 
              (0.29943447293159892+5.6778647113630445j), 
              (6.0153352042475809-7.3575477136819742j), 
               (0.10399177120220442-3.7720340455769321j), 
             (-7.5372090079201044+14.974112203176373j), 
              (9.6892969522054262-0.12755695624703867j), 
              (3.6797724387449842+0.9040906423875088j), 
              (3.8627049353941563+0.86859464070989423j), 
               (-4.6870776602230908+13.75189235165956j), 
               (1.5775878336900746+11.792444960231609j), 
              (5.5844062460477328-6.9844598274078562j), 
              (0.26743848405850462+2.926790493980052j), 
               (1.0782742212392369-2.5627766904452081j), 
                (1.8451441106029698+3.349629256630227j), 
              (-6.7103439762408623+12.969460273009298j), 
              (14.284908671366665-16.642556698439343j), 
             (0.74409158338222869-11.109808559123239j), 
               (6.0225144339088086+11.463375028261769j), 
               (0.40149184433758434-16.901202936646119j), 
               (14.446007746886298+4.3857915165668153j), 
               (11.698580240316005+5.9847057294319308j), 
                (8.6217570383135129-5.2950519290886451j), 
              (-17.387461742814331+10.93911710515507j), 
              (-1.0307420706771349-9.315556234481317j), 
              (19.942880879877873-3.6304744671229461j), 
               (19.143655323314139+1.6042825100709495j), 
              (-2.2952183932339039+7.5045339361909011j), 
              (-7.1614450027380503-10.794335730196385j), 
              (4.3837376886253434-6.8560657315265958j), 
             (-7.1602563516012321+26.662758890957949j)],
       [  (-9.255477908660275-18.625709494322791j), 
                (10.73814644507233+19.380799497057474j), 
             (-5.6700791021795682+2.9227329114400682j), 
              (-12.316805274782372-3.6684376998529249j), 
              (7.0075612935073917-8.4085118556856102j), 
             (-4.8890599458170687-4.0207988818550442j), 
              (-5.3798157056187108+14.483232297372062j), 
              (4.5103162789570632+12.907187178824778j), 
              (-6.3006838139216379-4.5814666162948017j), 
              (-1.4966206360247805-6.9342200090044495j), 
              (2.0554010312050415+9.6000410880528975j), 
              (5.0720985238977168-4.8957766049453735j), 
              (5.9165109720267264+8.3622453681668301j), 
             (-7.7419465793014162-3.0983941873371039j), 
               (-10.521372161055982-7.28102249184965j), 
              (-9.1325945991317123-3.2277855088674641j), 
                (14.564880669333252+3.1328837321471372j), 
              (-4.4147630013499288-4.4746092917288527j), 
              (-8.825038259459431-5.4473714091014749j), 
              (1.2866839849389475-2.8535408000710611j), 
              (2.8736473917965633+2.0408503639533433j), 
               (-4.4823359955227913-1.1659065079279343j), 
              (-5.2444229199742409+4.9760189344678656j), 
               (17.941146854718852-7.0046786562586796j), 
              (-4.9822958227563348+3.9137283486801304j), 
                 (14.29790423124383-4.9203952993946878j), 
               (9.8024082054323891-10.133728655824552j), 
             (-4.8013133849181981-12.962102096846655j), 
                (7.7085727408583695-2.4171637006854381j), 
              (-4.6978087717720207-1.2235748583631683j), 
               (3.3722383466058203-5.0897678513693378j), 
             (-4.6405706374817761+6.8596875878861905j), 
             (-0.47574147236814901-11.483565172569488j), 
              (-4.1638503175488335+8.1327470385028793j), 
             (-3.5536174745923517-0.65634018166228136j), 
            (-0.64232993262655391+0.53553934801368575j), 
               (14.524976404700467-9.2864521157631117j), 
              (-13.526187372015395+3.129564932439143j), 
               (2.9176085376922245-3.529410488027072j), 
              (0.69087058596538586-12.920255787691957j), 
             (-2.1937432908372685-6.8171557935943881j), 
               (-3.6042256630859666-13.944517756242449j), 
               (1.4282048571847099+11.233232774286886j), 
              (-3.9570811257012068+3.1794071306314797j), 
             (-7.6826260524711341+0.78300539194171503j), 
               (14.964086649633103+6.2444064442885612j), 
             (-10.345673838862551-0.99576558414265659j), 
            (-0.038566893660395556+0.41619070879723913j), 
               (3.8906090121500867+9.783082846246911j), 
             (-0.6224224899068318+4.8808884230715002j), 
              (4.7371759562389446+19.268949443068625j), 
               (-1.5760233220093474+6.958454898605825j), 
               (4.1911944211679533-2.6405024715048278j), 
               (1.9723222701484657+0.31610905632856667j), 
               (1.4959987362452887+20.894530989865828j), 
              (-28.392090449466998+2.5141017366741476j), 
               (7.5838752498594086-14.214890788176273j), 
             (-8.5689332700799792-33.240541220846652j), 
                 (18.97393638668084-14.863085640225025j), 
                (1.143750821970309-4.6174707370726313j), 
               (8.7078285282205421-11.61694477251163j), 
               (5.3958105267761534-8.0176676989660063j), 
              (-6.1046920594167284-4.9738233611821814j), 
              (13.579721034585647+9.8401549524668628j), 
               (-1.9980728055300401+13.28958663951058j), 
               (10.939777056694574-8.0104650341801076j), 
               (5.3597812924611254-19.353320095273485j), 
              (8.8403839344190924-11.412950431193359j), 
             (8.6581793813834427+0.69850394163264318j), 
              (-4.7968015965862367-2.1964818958990238j), 
               (28.282271500326054-9.5568672891140345j), 
               (0.4527925425417712-1.7825721412798723j), 
              (-6.9533340443246665+11.89915525273374j), 
               (-1.3740132838080665-12.464545956795469j), 
              (3.0851489351852477-2.4581157138830561j), 
                (4.0189458522116679-4.870042830037022j), 
              (-3.032896583642005-2.2060284924874303j), 
               (5.2173836447418429+1.2288416232362032j), 
            (-12.983398609064167-0.025008421524665533j), 
               (9.3974979711687752-10.537032443696944j), 
              (7.0172709827787516+11.648377606804313j), 
              (4.3607619140254723+16.126861201062848j), 
               (0.18684310570524668+1.862629073052422j), 
              (-3.6738501201603273-4.0526378787138944j), 
              (-17.641109710168344+8.2807482490008049j), 
            (16.380811967810654-0.063300945252906679j), 
              (-4.3891399916050542-8.752033809798581j), 
              (-11.043847652019219-19.493077239919078j), 
                (10.340564487463116+9.6163331845538949j), 
              (-6.0992622463409933+10.124561911480932j), 
                (14.088549923946108-11.24761313718164j), 
                (3.2238668683722094-17.113088400118663j), 
             (-3.4019129543796423-1.7748111241352749j), 
              (6.3569442020623725+13.719061736249918j), 
              (16.398783388605484+5.9603323596493665j), 
                (9.443592233472005+7.6618374650589836j), 
               (4.0521560698764443+10.196989793047347j), 
                 (5.0264787774617155+5.44922099460568j), 
               (-1.445818339864825-12.01054964367672j), 
            (-0.60942116129320145-4.7140030269097783j)],
       [  (5.9569621112668001-10.980323479263953j), 
                (10.14094581657436-6.0760696707702024j), 
              (4.7315673538759917-3.6219272064343477j), 
               (7.1486948984592145+18.310790507462762j), 
              (3.8160002109955879-3.5366407783464782j), 
              (13.286853623401322-8.0147796694857405j), 
                (10.697746730287658-10.50612187591943j), 
              (-2.1778098409574418-6.366281931674993j), 
                (16.068138076385964+2.616421773703383j), 
               (2.6395379938409307-25.615107843264781j), 
             (-4.8669484476361982-11.189983663756276j), 
               (5.023986348207794+4.6226289868475554j), 
             (0.09577601648554801-1.8646239835625786j), 
              (-4.9050455959213703-11.16192995352006j), 
              (11.496916844095491-7.4238646992095845j), 
              (-4.0141597400866527-6.6100019583863805j), 
               (-9.7480988226793208+5.5617622796844977j), 
               (0.8893332551760379-6.6803414178512019j), 
             (-1.6467803527547618-1.7188527745937399j), 
             (-21.398646871015963-8.1479151821185347j), 
              (3.6933260095116909+15.694033636168621j), 
               (0.82689784122686338+1.3204882384247372j), 
              (-2.4710697687600667-17.019554916175938j), 
             (-0.80778211128522526+4.4141746663819372j), 
              (8.3019225475997835-0.58372107586498567j), 
                 (7.2940923037959893+1.238461795361995j), 
               (-19.68401413187426-7.9055326709179639j), 
             (-2.6384839897626615+4.3898874501305407j), 
                (14.238379087967912+15.328577015767399j), 
               (-1.846373738131712-3.7851109581121154j), 
               (2.2763305094228632-4.0233378308886625j), 
             (-6.6605677023954186-11.882778885571398j), 
                (14.32442122094769-10.422950499208151j), 
              (-12.184471695712887-11.272344775838292j), 
               (12.145247657627255+6.7675762340752463j), 
              (-6.2967193765215796+13.273139055148102j), 
            (-0.082448139754863495+6.1973940906277036j), 
             (-1.4762616925669012+8.2623797609018492j), 
             (-3.6891857420167975-2.3374603711932354j), 
              (-1.7585587784023118+6.3284233315937932j), 
              (4.9764013003518421+2.9573276853595818j), 
                (4.9828715838467721+8.4322051748143032j), 
              (-16.787335836592202+3.0421965999037397j), 
               (-13.98425652757042+19.103581014237296j), 
              (-1.8102043717097116-3.0286498230989349j), 
              (-8.5293324403102737+8.1102176904830383j), 
               (3.6607034471105644+9.5389192733412695j), 
               (-2.1074405479003939-6.9693969548137202j), 
              (7.2373125265701956-9.2960440727097051j), 
             (-1.4522824153268987-3.9618263874115875j), 
             (-19.168781138744343-2.3392404274100449j), 
               (2.4187982633099674-3.5147061426566477j), 
              (-8.2063447982467768+9.1054669325983451j), 
                (6.8612721356881661+1.0942519836314533j), 
               (-1.5515169876076673+11.43130514169313j), 
              (-8.1134941942522225+1.0983539628814922j), 
               (1.2233249778143287-5.7091095284687885j), 
               (12.41565021929642-1.8056788728961215j), 
               (-1.8988813000272244-5.1974754488683272j), 
               (16.251947861415836+3.9565133577968736j), 
              (13.993179322163263-4.2460251002187643j), 
              (-0.4345438167018339+3.6611505796877912j), 
              (-8.3248938442761844+5.4523948174242847j), 
               (7.1156516973103114-13.25356674045933j), 
              (-0.96448181380683107+1.481497731489404j), 
              (-6.7186206497535084-1.5687271196859016j), 
            (-11.775435400358919+0.018968305117274924j), 
             (-7.6876803981059529+7.1793198898538089j), 
             (-1.2109946549638864+8.0744373058099015j), 
               (2.5620362042682512+15.521867430641439j), 
              (-12.444066100525969-4.5889567674847607j), 
                (15.412560382633423-2.187187718771316j), 
              (15.778443046635164-11.850811415707572j), 
               (-1.8571802199064686-21.413587487502127j), 
            (-0.22795249178948873+14.695333246272424j), 
              (-7.3878145985830468-4.5358346839249517j), 
              (-9.324639169681884-7.9857356058205173j), 
              (-13.512314849649169-15.700465425701459j), 
              (-10.595710932546638+9.2419085344071465j), 
              (-23.546065911016882+19.235094796295215j), 
             (-6.974646887997328+0.43174165393034031j), 
             (-16.712581061514324-13.141166071723784j), 
              (-9.1063805557634225-4.7144721189421634j), 
               (3.1373364075564951+6.4078123788049268j), 
               (11.235822307993812-9.7695282656833893j), 
              (11.167046170648664+3.9069913410530051j), 
              (1.5731606344470606-12.376765060386399j), 
              (-6.2084657540087029+6.6283412294234578j), 
                (-3.8960549943314486-14.12774652770381j), 
               (14.289924895318595+1.4736287222659317j), 
               (9.1458639055159239+12.508784027307126j), 
                (-14.97208953758118-13.489922759150698j), 
              (1.8428381309248825+4.8860084807577797j), 
             (-1.732949078742706+0.21611973482742522j), 
              (-2.716448812907029+1.4341570515147404j), 
              (0.95460240683537934-3.5353229528671286j), 
               (10.756873726373961+3.0902049554086752j), 
              (-6.5129289030380733+6.1581137510827251j), 
              (6.6628565731390852+11.526118828186618j), 
              (4.1347053772038489-9.0967980044007106j)],
       [  (17.587119538397175-10.963156115579594j), 
               (-1.246346915344086-4.5133276993004721j), 
            (-3.5517170833719254+0.38356813494678338j), 
              (-11.001262104816332-2.7412523382392577j), 
                 (6.62368042197925-6.847762529333381j), 
             (-16.467382457492143+14.620844834239916j), 
              (-15.690025353283739+4.9468428212171798j), 
             (-14.732262950459399-5.9039954428144705j), 
              (-11.777241416996688-4.9937058141334916j), 
              (-11.280318881226369-13.027564534857099j), 
             (0.41145743944481927-2.7621264803228813j), 
             (-7.1422638421922642-16.323276995570541j), 
              (6.6063214419716854+8.0355811538452713j), 
              (-10.592717731489428-6.480273958970729j), 
            (-0.70870839881033376+23.394900457429706j), 
               (3.2465448384663222-17.415992547181666j), 
                (26.694560363721354-11.048635229665898j), 
               (12.369504859609311+10.821062806150156j), 
             (-2.8109393196430359+9.3411767451995118j), 
             (-8.6870410933553011+7.6479543573609785j), 
             (-3.4161468624718445+2.4521617520539793j), 
               (-11.854298546268225-13.165873743689449j), 
               (9.5545613197112633+7.6809433090212176j), 
               (1.5092610993800299-5.4381054244696481j), 
               (12.083344902415663+2.0387519549974451j), 
               (-3.3721364180111317+2.2292481344166051j), 
              (-5.5136649601036103-1.6076004579925529j), 
               (-22.82999532718452-21.89509924394973j), 
               (-9.0301882184267797+24.459455617354905j), 
               (7.6585293499353835+10.428858365696081j), 
              (-4.7664204519210651+11.531334787807783j), 
              (12.028709113746917+29.020581850574708j), 
               (7.7940949955038636-6.8072457510880042j), 
              (-6.1507298351700337-9.8822163464172696j), 
              (-6.4442531009725768-2.9889203819586281j), 
              (-21.126289330115128+1.9505259192189826j), 
               (-7.665208695831522+13.038894119723103j), 
              (18.049804336895154+0.2213694929688306j), 
              (9.8034198649328967+2.1760598279544272j), 
                (7.1067674809545176-22.47839731484153j), 
              (6.4409815242170323+3.4199716052526363j), 
               (-9.4714036493295026-6.4085055785731635j), 
              (-4.7477433779050786-12.959453439682452j), 
              (3.7347407981069058+0.13649752741415344j), 
                (3.705746312620958-3.6693718577245713j), 
              (-8.3754111250933523-11.044864530255477j), 
              (-7.9642846159556004-18.473237415256104j), 
                (7.8478071024691243+2.0792257192346333j), 
             (-14.295308095501426+3.5147402330764055j), 
             (-3.8353964528765481+11.567226834831239j), 
              (2.1524215429010884+13.394507308055354j), 
              (-5.1737237185303311-7.2345660636761622j), 
              (-4.4444525244393827-2.6489600474265589j), 
                (6.0967912579748464-6.1475332507719935j), 
             (-7.6395910922650847+0.61297618822997879j), 
              (-19.382758334338519-11.468532705746199j), 
             (0.092792162111422188+3.1068422137103262j), 
            (-0.26433460677690057-1.5248568854192015j), 
                (11.317291036624237+21.923370989089854j), 
              (-7.6839702062517468+1.8339247535260037j), 
              (22.001528316912623-11.419978041516687j), 
               (13.706842395809142-4.4053105858288344j), 
              (0.45023285551006598-11.427869140751557j), 
              (16.937017989182181-11.081668793227648j), 
              (-6.2182715635771748-5.1396349536378469j), 
                  (19.187004835307-3.0424764915140496j), 
              (-3.7607258462823538+4.5215901484292731j), 
             (-4.2929150990577734+15.926828367339974j), 
            (0.018961172150832151+15.859666403089017j), 
              (-9.5239778587193804+7.1384731311865508j), 
              (-9.1658979367190661+2.8774524768606824j), 
               (6.9990650005969801-5.0903487960761868j), 
              (3.1004425073071982+7.6497810927938925j), 
               (-7.1487247763837871-12.998556603778722j), 
             (-7.8106933353771879+6.8149218628333328j), 
                (8.5786116799967509+6.854667965241342j), 
            (-0.47838266268310059+16.079499682751973j), 
               (1.7962509235538775+3.1831248340778262j), 
             (-15.184671322437142+0.28346895559185481j), 
                (10.963471255769397+1.097868187385417j), 
             (-12.774415407985018+4.7793040258001849j), 
               (1.9428913983245466-4.084176904296366j), 
                (1.476642884657775-5.0644314347283172j), 
             (-3.9552130326763195+0.98233631984004055j), 
               (8.0528058432339122+8.5182948483696457j), 
             (-13.767339222731096+3.9782132108819308j), 
             (-6.0316799496821716+10.537841997610585j), 
              (5.7829818195340454+0.97574174999587426j), 
                (17.787260635292288-5.9219572500062769j), 
              (-8.5643177198388223+19.169351927215629j), 
               (12.415259602640269+30.059366632536438j), 
                (9.7058638814397025-5.5384912076015151j), 
             (-20.757540979541478+1.8450644146746011j), 
             (-1.3994552713466202-16.979808306493911j), 
            (-0.33835814760352184+3.2214717313755123j), 
               (25.307360230493376-8.4329472908619714j), 
              (2.9015560806255856-0.18258785527817831j), 
                (4.886286094883002+6.4861917676195446j), 
              (7.8724666130476617-15.926059826656092j), 
             (3.7995539146982309-0.33499479630445161j)],
       [ (-4.3440116873020767-15.751142478689491j), 
              (-3.1098516046788767-12.192808207636642j), 
              (9.0172054068114491+13.227954843410208j), 
              (-7.1435751832444847+13.159536050861856j), 
              (10.885196755383204-2.8708370752017198j), 
               (15.724143752449208-6.611402311437371j), 
               (-20.43374796363296-10.908377128905109j), 
             (-7.9104910052047464-2.7852950312221751j), 
               (-5.585733423372659-1.2593051458191513j), 
               (5.0312301754578739+9.3682788989055474j), 
             (-14.573090568311621+6.8876198149725276j), 
             (-13.722019891481533-2.6156518971556943j), 
              (-1.3415283170468268-7.410482889958887j), 
              (4.9146409614064348-3.8548471219541298j), 
             (-10.993333127740115+3.1365962268488339j), 
               (7.3506874067544441+3.7103152862033095j), 
               (-17.710658328331501+3.2531634238813742j), 
             (-2.6890727971831296+0.92920082790512248j), 
              (11.824403150477993-5.8287979522024234j), 
             (-10.715301462732508+2.9323153856813065j), 
              (15.259919666453865+16.095386439454362j), 
                (8.3796992231404204+1.6135053847774228j), 
               (-7.385360757400723+7.4333156714351158j), 
              (3.8033227453479022+0.18412665422981425j), 
              (-1.3964991211866504-6.6685297403374042j), 
                (2.9799970701934249+12.838267836769235j), 
               (9.7692577833010485+12.727353894035033j), 
              (1.2068001686419023+5.4160030393240675j), 
                (1.3233378446049562+7.1329130661863696j), 
              (-3.7773481946345773+23.131364738345699j), 
               (2.0064142022864591+7.3771823005343826j), 
              (24.171106419207842+7.8034307575882735j), 
                (9.747749248168434+14.919724869493496j), 
               (6.5985102257855157-2.3097765236220043j), 
               (6.7683201429208637-17.991766395418843j), 
             (-0.35959907597211349+1.3207891476521199j), 
               (30.601985311741487-5.1876710185212893j), 
              (-23.041595745527061+3.005202556299555j), 
            (-0.53908914109460659-7.1600528793151135j), 
             (-0.01292764308884246+18.791749274664394j), 
             (-6.9395387664614896+2.7819778319033484j), 
                 (2.039248333005788+6.8978477053086991j), 
                (3.8060527477262802-9.340953317783331j), 
                (3.351421614111981+3.2637687742462496j), 
                (1.397049741491373+4.9299600315863925j), 
               (15.856884691620817-7.2675417457247073j), 
                  (9.286455459374384+9.65352011688611j), 
                 (8.0325303766499747-11.22557410066671j), 
              (2.9212861655493039-10.355507944247698j), 
              (-3.554984771251319+5.1775879804245619j), 
              (4.9376781733180817+15.333981627435872j), 
               (3.5200155434428764-7.6307386172549405j), 
               (6.9427443867766119+4.3340133754626615j), 
               (-7.9768825355688424+9.2504329708703246j), 
              (-1.1857581931150238-2.3035013890709513j), 
               (-1.569137340423219-6.2130626219757454j), 
              (-0.7693768754296566+16.538492976632448j), 
              (2.8254328383961158-18.106188673460291j), 
               (-14.793144808219854-8.3654259363670587j), 
              (0.60587932873941786+8.8564548731748438j), 
            (-18.266617541895698-0.10285275089785276j), 
               (10.908051356870258-14.757261708486046j), 
              (2.0910568039383244-0.98245950276189742j), 
             (0.60808716216070458+3.3371757003207265j), 
                (2.0833135224637154+12.02014835852806j), 
              (2.5900421905411468+0.69345854214451363j), 
              (16.33136783119188-0.032821350908849592j), 
              (27.558321735187118+13.857027800274164j), 
              (12.553603164509965+16.971079761654021j), 
              (-3.1392572285179292+12.455563911642916j), 
              (-2.6177632044573378-12.464137725184008j), 
              (-5.0468080002239004-2.9281129637053365j), 
               (-4.82796662655739-4.0454062822079315j), 
                (-6.905717457027432+2.8893603062455342j), 
             (-2.9150633174108398-22.010533125047136j), 
              (-21.546452103218392-3.9393741661904986j), 
              (15.135079282753752-7.1671123191529436j), 
               (-4.145604669249372-2.2798165609515317j), 
              (-16.529468048075106-5.6984058710196015j), 
              (-13.354847292700239+1.7622555865313019j), 
              (7.3743131137881441+6.4668747595635425j), 
              (23.437331448305972-5.2915503563672317j), 
               (6.5796830283322709-23.262346824582977j), 
               (4.4236829815133571-8.7348545155344102j), 
              (-6.9534841531966176-12.630606413080601j), 
               (1.6914228512071823+6.257395495024122j), 
             (-4.7261012072253212-11.984481672021481j), 
              (-7.9686496378611142-7.4844702438505024j), 
              (-3.6974137408691377-0.92937018479116795j), 
               (5.1949622394015362-10.827753660947742j), 
               (9.2438771911687674-7.8084661201664982j), 
            (-0.014076262369057123-0.16890953719245444j), 
              (3.6436142555929618-3.4628649553358954j), 
              (3.6108641079531512+12.364642346636845j), 
             (-1.3153386228544608+3.5557858612213451j), 
              (-6.4889210479633785-14.466336552540326j), 
                (-4.673240056452296+4.670758132864643j), 
              (-4.5760516067265842+8.0909992504264654j), 
             (-10.483037643161097+2.7146250870763455j), 
              (7.4719262548886043+3.6477555020403991j)],
       [ (-4.3032599411888057+4.7070276099493995j), 
               (5.3133878719546503+4.6921634688638267j), 
              (2.5072469295834079+11.490079472530603j), 
              (0.23879150128876522+5.3042256836583901j), 
             (-9.1429836818073245+8.6463175177596394j), 
             (-4.7959673603308062+5.6004856403858021j), 
               (25.717703684631847-5.2032096983402276j), 
              (18.395638210837649-21.556092664176823j), 
               (-2.5156414922879708+11.03476837546954j), 
              (-17.183560836423784+8.1689722787133707j), 
             (-5.6340989976500584-4.9288870901232187j), 
             (-7.8817072921263511-11.665023267270486j), 
             (-0.5824426776288647-11.505581934531143j), 
              (2.9952751955530159+22.462428060089003j), 
             (-8.9062251908016474+6.7611029137952405j), 
               (9.8591365835309706+6.3335098264922598j), 
               (0.31728673267573038+10.939941429285412j), 
              (-5.1648860419288667-9.6617646305517173j), 
              (17.570995390936893-6.2315785696424006j), 
             (-6.8886819725228357-9.9363226125330986j), 
            (-11.243880534084955-0.28808112299802369j), 
               (-3.8050620254589287-2.3169434787146788j), 
               (16.622079299639005+5.2443442615524436j), 
               (2.9902161410830308+3.7022350024943353j), 
               (1.9684258204657414-13.343379939881876j), 
                 (10.555977561464768-3.164205469413655j), 
               (5.9026374799091155+31.777012475852892j), 
              (12.685676745421205-3.2120378235787319j), 
               (-2.9965645913787826+2.3451929820599533j), 
               (4.0938616595520188+5.2802321478986647j), 
              (-5.9212680823232642-16.662103436808675j), 
              (4.0539148657574682-18.234730620623846j), 
               (6.4688361976089546-4.9411309983944527j), 
              (0.46581733394328961-4.6864418386562789j), 
               (11.04331294975143+0.41452212617149198j), 
              (-5.4456168016673159-11.072048298896867j), 
              (-3.8041870079460471+2.3285209996435325j), 
             (-10.409605980977595-16.352426316413464j), 
             (-1.6274793991982086+26.039244900567272j), 
               (1.2132524034570473+4.3012456457090051j), 
             (0.50023285314699684-3.6974929632041151j), 
              (-0.10694500725235656-7.1373680193402276j), 
               (9.1794512926253429-16.410370436785126j), 
               (4.7691734280084734+3.8600036841389063j), 
              (-3.6672792839770105+2.3104308254010579j), 
              (1.3454016378861542-0.81622268165894973j), 
              (-1.5939527660579738+25.781763182390186j), 
               (-9.7650907742915347-6.8615558081246526j), 
              (-7.2687801123598605+9.935738078186219j), 
              (6.2531149083288673+3.8820662914154145j), 
              (-13.4132914840796+0.60801931080527982j), 
              (-0.4198969199078661-2.7436368690726058j), 
              (-8.2730066903438999+6.3719790654313524j), 
                (8.0304897009567693-17.585700364977356j), 
             (-2.2778412322353461+0.48148782660075151j), 
               (3.1091078363620812-11.774833261514397j), 
                (9.7459611732492366-8.113469886295757j), 
              (-18.09243816627896+4.7805691675762914j), 
                (-4.341496363639977-8.7257017783937023j), 
               (14.483773756895816+18.922276815654307j), 
              (2.7399293403383518+14.525971314032491j), 
              (-21.844054372582651-9.3870513534208975j), 
               (-1.995678920217274+6.2991200357072641j), 
              (-2.631017225894678-2.7711364245832746j), 
               (21.059112137403933-10.902573544913947j), 
               (-7.949302215630027+6.4941578259008974j), 
              (-4.8235515353178036-7.6101709973824558j), 
              (10.950990541554017-8.1543245659489845j), 
             (-3.7486930979939865+13.973078444632074j), 
               (6.4507021562109195-17.788930575043111j), 
               (2.5413693339704881-17.616785205682298j), 
              (-4.5354574453534759+5.4155731829615936j), 
             (-7.9833839923595562-16.028590308992882j), 
               (-3.4454255472817423-13.820688473847982j), 
             (-4.3779580158684936-2.4746754696444562j), 
              (-8.5508107469245065+4.1541252309674102j), 
             (-2.7241108600783779+22.429801120146678j), 
              (15.942419976700574+0.88545867382487442j), 
                (2.177716496679424-1.8639774303206935j), 
               (4.6392817317799651+4.9157602095430271j), 
               (16.92594099566762+6.3255596662950389j), 
              (11.971739897447238+11.617645993609631j), 
                (5.5320113845537833-4.204147911521309j), 
               (6.4270864455087366-7.0161723930841298j), 
               (-9.1572772579722574-14.79534029439117j), 
              (4.3169753886935816+1.4148265416501906j), 
              (11.352409247990032+1.6198415032014581j), 
                (6.0271589629363689-3.036101109886288j), 
               (-9.7247810704972082-12.479788757245959j), 
               (-18.40482770077071-13.661209086757509j), 
               (0.2259933639423356-13.560348466706792j), 
              (-0.79506664422541706+12.387884512950455j), 
              (7.1415082241565582+1.8565446997186954j), 
             (-9.0195631236325706+10.563297645468808j), 
              (11.529079125500957+1.6284997455264671j), 
                (-1.1761033249758923+1.31026649516954j), 
              (0.20224103827791029+15.922209531391477j), 
               (17.599665416217821-13.038780400944297j), 
              (3.2882186010975052-6.6129431674629142j), 
              (5.6630284240936604+3.0815273394537908j)],
       [  (0.6720783197725978-8.1899759582148555j), 
             (-2.2069658963371643+0.53744292528514481j), 
             (-7.5678087675285708+7.3285280216991158j), 
             (-0.82218015546294287-1.6475355545772796j), 
             (19.808964232875912-0.41016673168466861j), 
              (10.020343198792997-6.9750594807328419j), 
              (-2.3931944606795446+7.6165218502372483j), 
              (8.2146602090294749+2.8056838182374912j), 
               (15.378947801228138+10.410308741042375j), 
               (-8.770623230093058-12.867741728762756j), 
              (5.3583490021871309+7.4419863784023139j), 
              (16.448034625392186-15.095784018996021j), 
              (6.8695974320328981-9.1240732323177713j), 
             (-6.4153021054658339-8.9903786121752098j), 
               (5.320568129596551-2.5833314023481702j), 
                (1.4742865149963218-5.759580551034686j), 
               (-5.6740033043585401-5.1287393149339415j), 
               (2.2512750748217942-17.054799530911509j), 
              (6.4240321798446729+11.477502082905158j), 
              (15.938264395386469-1.2982560806262711j), 
             (-11.359412879567447+7.4010730329552299j), 
               (-8.1127631804572946+27.709156374026321j), 
                (2.3135784458644952+0.652125126100913j), 
             (-19.543449607538786-0.15304664441340654j), 
               (5.0595375898868635+3.3570593116146412j), 
               (-8.1147296382210072-2.8020842561961063j), 
                (8.634512912704885-14.997987780631787j), 
             (-14.527937067149018+4.3480855486170302j), 
                (1.3551403141876031+8.8283409176753977j), 
               (5.7882924606491972+7.0902787571108403j), 
               (3.0223947710417836-3.6074963675685905j), 
            (-1.520724203070019-0.078029455751904092j), 
               (-6.0881040660220256+6.338958530967397j), 
               (9.6699651073252308-10.266800056881882j), 
               (3.5561319062499819-11.621897295753506j), 
              (-15.900894814621946+10.066580878936835j), 
              (-1.4337879161225595-3.8533777171767536j), 
              (-6.757072914715998-14.149328676082419j), 
              (5.6542462910515532-2.3870864874536877j), 
                (14.98093415407123-17.438424852439141j), 
              (12.043965171093431-9.9303885329481894j), 
                 (3.3252198776103024+1.183806749942129j), 
              (-5.9431581768368922+2.5094460972608292j), 
              (-1.7038142399208396+12.184837328630692j), 
               (-5.8298582540007935-16.34379797711096j), 
              (-11.951438700199766-7.8916789266358265j), 
              (-4.4907985095904408+10.065575962705523j), 
               (-1.6116706074205889-12.204310532323223j), 
             (-6.9345243798404024+1.6285527498290624j), 
              (1.9819260178114946+1.6618232225708198j), 
             (-11.070715475011241+18.143081273456669j), 
               (24.776124734534474+8.3359870079555805j), 
              (-11.667901210976177+10.027754204680031j), 
               (-3.7901296857130089+7.0017469810030981j), 
             (-24.243749711336008+0.53416957663655074j), 
              (-7.1334705557776719-2.0401086879582402j), 
               (2.8405288467933425+18.546844128611127j), 
             (-4.6619738795314216+14.600072922959647j), 
                (0.67248155914511043-1.907478879821574j), 
              (1.5581114515947236-0.86736143270132571j), 
             (-7.7045587046683099+19.228890637756617j), 
              (6.0197668512413625-0.68620280276207857j), 
               (4.3521618553041517-14.589247810190113j), 
               (-3.4927246916326-0.57773413610357549j), 
             (-0.44071574054773016+3.5744176635759044j), 
              (-2.2461013738338806+8.7928117113199722j), 
              (-8.7013524285873309+5.5153532566777654j), 
             (5.9684263829667401+0.30777825880189702j), 
              (12.028057953197324-10.349024682713353j), 
               (7.0855488482651605+11.492502783080234j), 
              (-7.5365579288111011-16.654364498746617j), 
              (-9.0772514963581141+8.6541546174000157j), 
             (-19.194328742109413+11.017580217384888j), 
               (-3.0722729510818443+10.025183500199066j), 
              (-1.230355852696642+10.480453304773434j), 
              (0.67482679367415599-11.748814589122043j), 
              (4.2935295858708313+14.797679675505096j), 
              (-8.6004564379206077-8.6520804732593106j), 
             (-9.7823864691794462+0.75102593413697694j), 
              (-9.8976733341274699+6.6510149244132961j), 
              (15.404701824473852+14.888979455460209j), 
             (0.15408193142473894+16.317090813345484j), 
              (-13.289375176322336-10.566917973155537j), 
             (-9.7303970291570927+0.65091011267209598j), 
              (-10.141866755302914-7.4781361744946482j), 
            (-4.9651753983410103-0.32403004230810106j), 
             (-7.8342406357844006-7.6078408968596101j), 
             (-0.37275315382715513-3.4439405564707561j), 
               (0.52706656428847742+5.6955498708604821j), 
              (-5.9072338847427153-3.3221606356580229j), 
               (9.3869757407749308+11.899913230643261j), 
               (-3.9038501783293063-14.901102394814723j), 
                 (4.7603556361321795+5.5268612768851j), 
             (-3.5056220975251442-16.776266537135037j), 
               (11.777696018118744-1.894035891923791j), 
               (12.546878534574246+3.3107701196622008j), 
              (-2.2260491903015818+12.938827168137156j), 
                (18.62842343034221+4.5597572967925055j), 
            (-2.5953515115040076+0.24945354503198364j), 
             (7.8010057502554293+0.45613286538996523j)],
       [  (23.483766746589577-11.665044670428998j), 
             (-0.49342072422517252+10.202988346433472j), 
             (3.3576252426279716-0.49913590496411447j), 
                (5.9420379057208166-18.49638679456281j), 
              (4.6659904460024251+13.710290002522726j), 
               (23.052198007967775+0.076074359207723j), 
              (-11.416888158586932+15.011457766274081j), 
             (-5.0881841417039944-8.2973966082509349j), 
              (-6.7556125551938537-5.5649811675436691j), 
               (2.9637140098858494+5.4509189873685155j), 
              (16.818197738348406+9.8995497732498077j), 
               (5.8488471096222581-1.287687945470434j), 
            (-0.93558634613834746+7.0275330476691984j), 
             (3.6792155680773115+0.01620379467596729j), 
              (1.5546283255237623-9.9962419844462236j), 
             (-0.97940004838547856+3.4302071676367714j), 
               (-10.786807592156435-16.078032157609769j), 
               (9.4833770046024473-7.0376135442746923j), 
              (3.8771859366960482-10.677937117720379j), 
              (5.6482378708304655+12.879051124709251j), 
              (9.1898984052436568+3.5578132564963498j), 
                (4.6316738598193057+6.3751729627550935j), 
               (-3.6233977995006557-14.71363565775718j), 
               (-1.579170939032061-13.547550428749656j), 
               (16.617741273422052+1.3709350856144988j), 
               (0.74623186085899662+3.1829981566494228j), 
               (2.6465381618533264-18.894457807481174j), 
              (-2.135024695090844-17.068249705735912j), 
                (5.8302533648380415-22.709812675913614j), 
              (0.20543243764411068-1.9483998924002668j), 
               (11.438717347799777-7.6486152705656032j), 
             (-21.654648377746902-13.752806729704403j), 
              (-3.7506252839369782-4.0092594147574063j), 
               (-2.123863803291469+14.113460053504884j), 
               (6.4435419794117612+12.681609623138836j), 
               (2.2494655050397778-1.5813136512055104j), 
              (-6.7908220723531452-9.8413221051437034j), 
              (17.222431072638894-8.0739550529267259j), 
               (19.37569128992935+6.6445755975323531j), 
            (7.5369246704813877-0.0093131408153239847j), 
             (-4.6435592088486928-6.0252089080674667j), 
               (-24.229888616163109+12.740572422515966j), 
             (-0.24346394284746134+5.5028162115596473j), 
              (-10.978782970520363+8.2199214985843962j), 
              (-5.6404735672967643+11.645123497397549j), 
              (0.39935943717463757+8.2786118079181943j), 
               (6.8627541206249196-6.9707060567752492j), 
                (13.499715910649218-13.482248177942317j), 
              (4.5211471843827411+3.8529144502021451j), 
             (-14.334765510562519-5.0858192136918685j), 
            (-0.06370330838196675+10.032541351089099j), 
              (-7.8545631451001574+20.516177188525951j), 
               (-11.51611716418612+2.1000840647191183j), 
                (10.220386517880367+9.0322155556444752j), 
              (-1.7602027143449899+10.508597986721703j), 
                (2.5978555660784508+9.502331161227346j), 
              (-1.6966523662837327-6.3258539007805128j), 
             (-1.7901634689971815-3.9441908561438561j), 
                 (4.420047900854768-4.5422708514731616j), 
               (10.327378293759537-6.4767072918171662j), 
              (7.5370642493839686+3.5856221116932234j), 
               (5.9992078736844023-9.0493590267398716j), 
              (-11.866258831768363+4.0109579311033663j), 
              (4.0521200422887453-19.214102954832693j), 
               (21.325380107886232+2.4593328058517221j), 
               (6.1863922817242489-10.285275044573938j), 
               (5.8307813629755492-3.7864578953704027j), 
             (-27.231688313690615-13.766923977748997j), 
              (6.5388516656558693-5.7473963006401103j), 
              (28.218602207685194-0.90500694808335691j), 
               (17.231725832190111+8.3822820186483131j), 
               (2.8740375496621788+18.585487412119754j), 
             (-10.772628401506603+11.256460828844384j), 
               (-20.803450868718375+16.304191931943961j), 
              (12.167364612604512-7.8881274404895425j), 
              (-3.8137696449725271-7.0066249381595842j), 
              (3.2648449305565652-8.5973303918950563j), 
              (-12.996889948388915+10.806919676285432j), 
               (4.6102349701347451+14.566321716027105j), 
               (5.5946156637941691+7.9146928258233622j), 
              (19.097849602217497-3.4211109285827757j), 
              (-9.8394179261870267-4.725430813062613j), 
               (18.071550911061564-2.4512540118497501j), 
              (-16.257418798484789-12.438339085047224j), 
               (13.458996138187242-2.3383928195741168j), 
              (3.9458023429597091-11.880314379885569j), 
             (-9.3031744757261947+4.7505044819521327j), 
              (-11.259334427662136+2.4386160222227309j), 
                (9.4673007545766943+14.508868183789296j), 
               (5.5713407820395036-13.677999521282514j), 
              (-5.6962043187438081+9.0874271602843297j), 
               (-16.114438702573342+9.9962983901329814j), 
               (14.03813677237407+16.040957895565164j), 
              (6.6092964945544344-6.7865202595625753j), 
              (2.0401483688305264-6.4913710953949373j), 
               (13.534094070138369+8.3730276713015854j), 
                (16.03947569157603-11.042134702118776j), 
              (-9.3952654464850909-4.1167554341901189j), 
              (10.59148594818523+0.40327282711682405j), 
              (1.6120438638575667+7.4161912927722913j)],
       [  (13.307345136734215-2.8105474171412279j), 
              (-10.718458807085359-1.4933421627794961j), 
              (4.5656651500524656-5.9600815789394641j), 
               (3.679586488379968-0.40713032328884652j), 
             (7.6524248761687561-0.13887024830735503j), 
             (-14.743604071737003+1.4237778110530246j), 
               (2.2223851544022803+1.1900297320474955j), 
              (5.5287800640141089-8.4362328447448913j), 
               (-7.405386688092328+16.044688364934856j), 
               (10.997913526883769+3.1101652547510659j), 
              (12.609327945837556-5.6639605040924126j), 
              (13.925442298375454+6.8520005300261575j), 
              (4.0974559706263127+1.5744664978526466j), 
             (-7.3054397717157666+10.150768144973839j), 
              (5.9829703145136452+17.118004037275703j), 
               (2.0833351492392476+7.7552862873882189j), 
                 (3.7288200767774389+1.013257416148903j), 
              (-2.9173536559700479-9.9047899584467665j), 
             (-7.3761713139673049+15.410119010234531j), 
              (11.536507823232668-7.0190976243937673j), 
             (-6.1217106653756623-4.3383619163146756j), 
               (-4.3660404896785572+5.9803924999380733j), 
              (-9.6934930878928647+10.134367251423249j), 
             (-12.132063144595758+0.44788980169177817j), 
              (-1.9409195719009169-7.6175677161801207j), 
                (3.2818892177153476+3.3620933870007583j), 
                 (5.800039886482466+2.233019558660883j), 
            (-5.6617315167781275+0.86648138787429274j), 
               (-6.3841454406098217-5.5460833441102864j), 
             (-7.9531440978050849-0.16709247982447273j), 
              (-7.8002549233962712-13.391460318138442j), 
              (2.3012392386494418-5.2048079303002375j), 
               (9.1536330571301168-0.8078937870439078j), 
                (10.353839689927305+6.282764536940455j), 
               (10.003797011581669-6.6542923459562839j), 
              (-7.5366289326983296-5.0261462624178268j), 
              (-1.5581462625740685+3.9060336405970464j), 
             (-1.4016650398461343-11.649204196234678j), 
               (18.65451437888477+11.548007684970866j), 
              (-9.3376632121326271-8.0185371976213151j), 
             (-3.8993775869011045+23.688447144594306j), 
               (-2.2241998213658825+12.995734325823509j), 
               (6.6684474678943992+15.076390889587861j), 
              (-3.7671292147470199-28.917834865512432j), 
               (7.7714560797820482-20.109595866330856j), 
              (-21.238707007803683+24.629075712741162j), 
               (-13.173399608084516-5.847152108093713j), 
                (8.9768853303138822+1.9573675343791321j), 
              (5.3046954936690458+3.6744055820214134j), 
              (7.8805519303594771+23.096217330080066j), 
              (13.247356837112399+10.031318111409412j), 
                (13.368000740810125+1.788428910400339j), 
              (-1.7739763641581745+14.780309399440835j), 
               (-5.9070896676110252+7.5962369345896299j), 
              (-7.3416454730311909+3.3807217906564602j), 
               (-19.56066853169996+1.2639681499467543j), 
              (-5.8605251594520134-13.658402718846801j), 
              (-1.202742023416514-14.223324986903643j), 
               (-3.9516987302856625-16.634090537965967j), 
              (-3.2904895695915575+16.984052654187096j), 
             (-15.822164436609782-2.4670252714074477j), 
               (3.0094698610545052+2.8446913616984162j), 
             (-1.0099352639525292-0.94550478906765645j), 
              (6.3859670640541513-8.8878278418368204j), 
              (-9.9819293340859545-13.607347510121016j), 
               (-12.40201974298234-23.293285393697026j), 
                 (2.54650880202054-1.8987669061387815j), 
              (8.1995050641142573-18.946456335099793j), 
             (-12.508716552181081-13.681383644250978j), 
               (9.1568225950952353-4.2226785778854454j), 
              (-20.596942560382082-5.1123094082585592j), 
              (-16.419167200400018+2.1893643041017077j), 
               (3.6013654782035727+10.03534604052855j), 
                (3.0935871386064626-2.3489797107986745j), 
              (2.8837995744496991-7.3028765148420218j), 
              (-3.3925803166930697-4.4567639404281207j), 
              (0.3310220358735485-12.610425442625491j), 
               (7.3841434729194591+6.3867761170638824j), 
               (3.9802397733929733-20.243703978021902j), 
               (2.4921957746630814+6.4422847524545475j), 
              (6.5136491122830877+1.1417359450488065j), 
               (11.469792168651573+9.420133266076574j), 
                 (5.003986267900224+10.08388160657789j), 
              (-3.2155706797000301+10.343854409778805j), 
               (12.032135132060976-4.5035452742304773j), 
              (11.120825540243294+2.3213337804651415j), 
             (-16.263528283627153-3.0319247270664258j), 
               (-17.324200726045827+15.86386521376113j), 
                (9.7718415684987434-15.024453467550432j), 
              (18.080704192432794-0.64392682385329336j), 
             (-7.9505003809292996-0.31442721389831513j), 
                (6.8720454094875532+9.9581838359241619j), 
            (-4.8567388064497354+0.84534232369690909j), 
               (1.2295187426723715-4.554693369414295j), 
             (-2.8417791238664454+6.2044537362055259j), 
             (-0.40414443670750583+14.837826426782696j), 
              (14.514668803579553-0.86895765118632173j), 
              (-6.2721359184109655-11.213023863246965j), 
             (-2.4732039642093664+9.8283674698336956j), 
              (10.859101162998419-11.672881110883722j)],
       [  (14.337394090676634-6.7804692088817209j), 
               (-1.6680356172350586-8.249229057588833j), 
             (-1.8037707771042564-3.1441259345216093j), 
              (-7.9733075217679383-13.761991498973178j), 
              (11.626328407112677+6.3172402264980674j), 
             (-13.706972735521564+3.4800788047026998j), 
              (-7.7883399220404534-3.7501234239565644j), 
             (-16.532770171201541-19.144122881147347j), 
              (-6.9886067105645333-9.6234805303699762j), 
              (-2.6806201578169992+2.8772945205931992j), 
              (22.241571531014642+11.884752324467776j), 
               (7.7172011209652851-17.57085822652531j), 
              (2.5175878115363992-4.5257941444294438j), 
              (9.2880974798770133-2.1220575159793849j), 
               (9.8058671804222364+8.027223339414137j), 
              (-25.174775161238362-15.673139782722114j), 
                (10.393047261558046+9.9620939605730872j), 
              (-4.6129249729449349-1.0689063280330626j), 
             (-6.8432814702047082+18.146685342152466j), 
              (-8.5326086022482901-17.14652695867845j), 
            (-8.0795816007412018+0.69722538480133411j), 
               (-9.8651173996012638-2.5735996359660618j), 
              (-10.698579608529762+15.203863740753956j), 
               (6.6105753660766142+3.7492002223739131j), 
               (3.7497126847722861+4.6442343252901832j), 
               (-3.4097739714904702+2.4878852508898723j), 
              (-3.0605427046680274-8.1771524638267401j), 
             (-8.1281782738789303+11.767493386953182j), 
                (5.0457268636751671-3.8921031525900629j), 
               (7.2482438299015959-11.822033128977125j), 
               (4.7651708521435099+20.502133305704056j), 
             (-16.030580255873858-3.5060179701775529j), 
                (3.814793552917453-12.238856818724317j), 
              (10.473252138585622-0.97773121823682563j), 
              (0.34062237395401551-1.8774565037985305j), 
               (6.4694866755513161-6.3635544936353607j), 
              (0.99063188389169665+13.626460443097647j), 
              (10.948508794543743-14.195418320243077j), 
               (11.796056699116447+3.649566461880597j), 
               (1.4803354260400208-2.5757253146031633j), 
              (6.0107271554977126-3.1921041870414446j), 
                (11.181076679980482+8.0637682596867659j), 
              (-1.8539900601454744+25.924438939355163j), 
               (1.1286778729872495-7.6475341928345619j), 
               (-2.8570245112835098-4.926948396028509j), 
             (-0.90134709093930132+8.2612291471097894j), 
                (12.051708600873809+6.735921140152926j), 
                (7.0895267870966006-9.8029663188073872j), 
              (17.397418522028243-8.6965479022780485j), 
             (0.31974449492238199+1.7403631666477117j), 
            (-0.54059599099331657+6.1682472484894992j), 
              (-17.637727117123532+5.4489858313794901j), 
              (-5.7159474518122355-4.3338082438018386j), 
                (-4.315861166991187-7.9657488947653166j), 
               (17.811711081010955-2.6429504617920996j), 
               (1.7667750600730878+0.8388457314958353j), 
               (-5.2779511385119449-6.576209216118948j), 
              (7.3485934796083345+5.3687918829810233j), 
                (7.3120052627902332-16.833070931331907j), 
               (1.2102669495063758+11.077861365792938j), 
             (-2.1770775647513378+8.6085307237959832j), 
               (11.430944345710239+3.7570769044807637j), 
               (27.082988514831765-10.330468087749631j), 
              (11.398671512127954-9.1268250229654804j), 
               (2.0849149717813096-21.702735262133558j), 
               (28.842898392266481-9.2956189576425761j), 
              (0.19639753396171272+13.638985597031501j), 
                (9.451382933657797-7.870632905754718j), 
             (-13.363163512318826+12.278388578845281j), 
               (3.3000364101380057-12.640384563585869j), 
              (-3.3141681435631392+4.2310615251005999j), 
               (-2.587624217971038+21.136579034489639j), 
             (-3.428500549042413-0.14505268594374912j), 
               (-11.150381784193364-10.409609054039684j), 
             (-7.3776776382321199+2.5985175733404553j), 
               (-1.813796316311983-10.498749458941788j), 
              (7.8254142253131889-13.619028194633739j), 
              (0.15666600805561118-1.3470868868129688j), 
               (1.5518961430373475-10.071833928986141j), 
              (-6.1601529670098873-1.1759424432523722j), 
             (-4.6993601189890928-8.4507083977644335j), 
              (-2.3803017478510164-12.07992933656832j), 
               (2.4077499408088037-12.255109586328372j), 
               (-21.806199258069952+7.463933169630705j), 
               (2.2655228422153049+6.3289452580205499j), 
             (-3.3618768542070017+7.5611975263993481j), 
               (-1.9234596460979634-4.08460717501156j), 
               (9.5627578390863395+5.7760928674363177j), 
              (-0.20108909476547621+10.846272590111292j), 
               (-1.5306848512441067+3.230691380636066j), 
                (-2.7150602118910894+11.9931224767105j), 
                (4.0390756805554773-7.3052843613508092j), 
              (0.6559019097435913+4.5617349865237014j), 
             (6.9908402268854042-0.42550305555711287j), 
              (-4.984792001207242+6.1365550005212652j), 
               (-7.123844818267643-5.8281562402145166j), 
               (13.229060056641273+12.839334133241776j), 
               (5.9687757765789806-4.9237983903042331j), 
             (0.19268035382988044+2.6270566617104496j), 
              (0.15068564010401933+9.686581581802864j)],
       [  (-12.886456432577393+18.55386388032646j), 
               (7.9585014136113754+19.230805620546217j), 
             (-9.6054966621756748-8.8592106406204305j), 
                  (5.9378270480971-18.534516393007252j), 
             (9.9285536241591092+0.52278634926130985j), 
              (7.5007830586551085+17.534919659658975j), 
               (6.5096712086484407+5.7278552331336128j), 
             (-3.1443842675150169-1.6980197257819682j), 
               (2.5006416596833509+5.1046783335138501j), 
               (2.1715385113907217+4.2352557597343736j), 
              (6.1650021953385785+1.1649669478222608j), 
              (3.8060493564312115+5.0808288214564321j), 
              (15.592182784407044-11.684690144126815j), 
             (-1.7061408380869287+19.585722038139668j), 
              (9.2306809393620384+9.9864584650397976j), 
              (-1.4841974916832559+21.311215610934305j), 
               (-22.775797804107114+5.3784233031985238j), 
               (7.9402034758690032-5.4256133135806746j), 
             (-9.4795872624188391+16.098370151738536j), 
               (3.4475258556914614-12.80710178168091j), 
             (-5.1994236559708673-4.0776950009048427j), 
              (-0.39554610723932493-3.1519992148878466j), 
              (-9.0811026311190641-10.225909823487127j), 
              (-18.395805737971553-3.5434420659933794j), 
              (-7.2137275675060479-10.004647642868935j), 
                (6.7370455240423439-11.974364855459211j), 
               (-5.6497328869990984+7.605069152408185j), 
            (-2.7765751899644315+0.71041948571828317j), 
                (10.200486242602381-18.967640341389661j), 
              (-4.7424668927657097-4.8294121059106319j), 
                (13.571435836025284-6.743268768640589j), 
             (-6.7703588429457788+12.415967401298021j), 
              (-11.097542346764484+24.819609649603702j), 
              (-12.712328749038456-7.1633710176676217j), 
              (-15.692635897196364+22.378365031788508j), 
                (9.758665245427375-8.6634661402046689j), 
               (10.429892099883693+5.8754774679921082j), 
              (12.172534644175618+24.722049142803016j), 
             (-1.3328517667444588+4.4187448247679093j), 
               (11.409040747155046-8.8730425181436079j), 
             (-1.9690347935002095-8.9113636410753312j), 
               (8.0627948467709682+0.29304795085803842j), 
               (2.3906889027415894+1.7896672183287134j), 
               (11.881637332445393-4.2695099646222436j), 
              (-17.832391267387735-13.483991099089607j), 
              (0.94569896216141414+18.381644709878447j), 
               (6.1040628447155534+8.3277702149010207j), 
                (-15.920166881452216-4.337297907908912j), 
              (1.9780445387354781+8.4640118204677357j), 
            (-13.632058429027749-0.24580888460352082j), 
               (-14.51934835328224+15.76450246264705j), 
                (7.4471384369919766+7.400503586127428j), 
               (-4.1411682866834996-4.973600177275074j), 
              (3.0925243876695463-0.058116637561505216j), 
              (-7.4056902203684718+9.2255761043394191j), 
              (0.28126705184719197-2.9665912981911409j), 
              (-3.0639444257216626+5.2677649565358546j), 
             (0.17561070177308608+5.7214966511939682j), 
                (2.7282780412907144+20.160576119224022j), 
             (-0.26577891757488081-21.424950130270041j), 
            (-0.37567788947299985+3.1926077153188288j), 
              (-3.5887301731922157-6.0594013038885688j), 
                (14.18384120670353-8.3626643399793146j), 
             (-9.4535417442670475-3.2609796903568737j), 
               (1.5814798564072503-5.8384574539337528j), 
              (-9.8785408844556795-10.695112655126131j), 
              (-6.2884743592432644-4.5608672037690621j), 
              (3.9715233521070052-13.614545579385046j), 
             (-6.8300813680583392+4.4706551325192248j), 
               (26.392121193793535-6.2294249465077112j), 
                (17.64520721559165-12.564626229456186j), 
               (1.4842891026672675-13.895035475742086j), 
              (7.5081599143488162+5.9499278993564957j), 
               (-21.035037235659789-7.0426789199948105j), 
              (-4.158269367734829+7.4488835543892806j), 
               (-4.362564768962006-7.0165571320672502j), 
             (-3.0064251594535869-16.055802371484027j), 
               (6.2006078707865502-5.7419683504478947j), 
               (3.6927249664729582+8.5273681252974605j), 
              (-11.379095575639663+11.338026586938653j), 
              (16.430781321666601-15.373935524749031j), 
              (6.4842160176499961-1.4498749897038539j), 
               (11.720499728558558-20.604248755441489j), 
               (13.926122061031192-2.2563330252014886j), 
               (8.1226962437590551-7.5234959747775321j), 
             (-4.4445180316140815-26.259736788803593j), 
              (9.2577638349818159-10.490985083738526j), 
            (-0.092415201797175134+11.283763145380718j), 
                (22.210165854825895-1.7820627881545101j), 
              (-16.238037982207672-15.048789065851068j), 
              (-9.1037819158215427-8.7969283152514635j), 
                (13.377903395147095-1.9803103677441207j), 
             (-3.5510658934528418+15.958813792360333j), 
             (-7.3211172397019419-2.3224277832551921j), 
             (-10.42877145780176-0.85826454329691182j), 
              (-8.9463043119893229+5.7867334039127813j), 
              (-0.4897584153206716+1.4540207070104192j), 
                (1.5828016556095177-11.22360516576107j), 
              (4.1570344973479285-7.9294487095805275j), 
              (-2.9859922567997943+3.960437736213632j)],
       [ (-15.413978296941885+10.297014959623571j), 
              (-8.1685549988434296+4.4646409224473889j), 
              (1.9920175212656446+5.4928388441640621j), 
              (-13.811395559767375+5.4224729825428986j), 
             (-15.198503182455017-5.3130105148579609j), 
                (9.14695250217612+6.0867778298596935j), 
               (-10.807919003300617+17.19101800846045j), 
             (-13.326887315300892+11.812578065172589j), 
              (-21.848586721677371-5.9185471320245604j), 
              (-6.1802011759189801+6.9977447452203458j), 
              (8.2942385547083006+19.980887123722624j), 
             (-5.1736789187450913-3.9736417686620111j), 
             (-1.0224415904743749+1.7695461138959439j), 
             (-15.877734987481277+7.2457208029997879j), 
             (-9.2581729504857719+1.6243230029134068j), 
              (-5.5451792228043741+20.463533980846179j), 
                (1.1908964036554002-6.1596981875982539j), 
              (-10.88468958079689+0.24611938072803707j), 
              (-16.17074618675408-7.9456456783197016j), 
             (-6.5824644277203239+5.1498634322887433j), 
             (-12.419531880173702+6.6573716258714128j), 
                (6.6463168112138185+7.8930309182842731j), 
               (2.7657370095466249+8.7516964785795341j), 
              (-6.5579051247512101-7.2747859282421228j), 
               (2.9914774017022983-0.2469675188526482j), 
                (2.9006690958169834-9.4014036842336939j), 
              (-4.4335274829073965+4.4087888582632377j), 
             (-2.5324907088356143+4.4340217520485847j), 
               (-1.7141695056448794-7.8886542641718957j), 
                (0.34941996933244546+6.44164380151265j), 
               (12.087293458939994+4.3429702147965195j), 
             (1.1240997831404791+0.65298508933545474j), 
              (-7.9104658747760705+6.3508360789054841j), 
               (3.2678728711053355-16.690311695762972j), 
            (0.0036769841539999334-1.9571621870439739j), 
               (4.1446472297523655-7.3387931990049644j), 
               (-15.087880347786189+2.201089297591186j), 
              (-1.1611776550848176-1.290712379889615j), 
             (0.63237453321195725+3.0330663738299739j), 
              (-13.523868060027709-8.4460519317654335j), 
             (-7.8639814663994265-3.1275218441808517j), 
               (-10.651874567635371+17.198197508637016j), 
              (-9.4227718414688049-9.0533709318052136j), 
               (12.959751807549653+26.015916428717738j), 
               (17.121205013029527+11.963304824290045j), 
              (-3.6700310037855761+5.2849007558497485j), 
               (14.236789819661276-10.349581814502303j), 
                (10.085536532093242+0.8988959011027654j), 
             (-7.1111490654176173-10.274726068995783j), 
            (-0.90036388582216764-15.352004720722123j), 
             (-26.366029139316375+11.314177693588638j), 
              (-17.829288114494947-4.4984393788794037j), 
               (6.1752351193658805+2.5557290602409162j), 
               (-9.8393832785143474-7.4072828972087272j), 
              (-2.3363476478870884+17.898437310555295j), 
               (7.2223759708709903-6.6583349767047553j), 
                (3.961969974698043-9.5345584405228543j), 
              (2.6330860105075371+6.5219816610066843j), 
               (-5.9557091484321578-22.887063493393534j), 
              (-5.7639829509818883+11.743611496195136j), 
               (1.531216302265497-6.6528265611276751j), 
              (-8.2821103016480606+7.0113319601645099j), 
              (-11.198143266989923-18.877318045557061j), 
             (-12.031615598775517+2.4239745405151685j), 
              (-15.214880976879003+5.7279479474166841j), 
              (-5.3344277776052937+18.718093760651318j), 
                (19.429062648656526-14.26748093435897j), 
             (-7.7054373091416455-11.887377797725252j), 
             (0.39353255463347053-3.1205518955503644j), 
                (-1.8215402000766054+11.2997899291585j), 
               (12.317539418253414+9.9249909202012159j), 
                 (2.243075535133356-3.982904058746275j), 
              (-1.373156569160527-3.5912224146447826j), 
                (12.921146458819909+1.2071586900819304j), 
              (14.319584698143421+3.7646228078961275j), 
               (11.071155783746091+7.6665702446390407j), 
              (4.1950075513697556-8.1836649221681927j), 
             (-0.32750092175974294-11.210707678358132j), 
             (-0.11750046536386635+7.9020767717891252j), 
               (11.531426191068036+2.5539203294970174j), 
             (-11.053964865217214-1.8828501878951607j), 
               (-21.2392388587973+2.4738675130681225j), 
               (9.4487431623911604+6.1031654535876303j), 
              (-6.0191092417367473+5.5303145861322323j), 
              (-12.798856193365101-2.8473425505416783j), 
             (-1.5457122111755326+5.2237149747601954j), 
             (-30.588958086372543-7.3951088509348386j), 
               (-4.541576128970032-18.499735261248503j), 
                (17.453665526899233+5.4967430688820489j), 
             (25.539781737955686+0.088612618819392835j), 
               (-0.67229158846519377-12.1924719225043j), 
               (-6.1851223453014006-8.0867230994915644j), 
             (-2.4706063599679156-1.9356097881351977j), 
             (-4.2704009024092873+3.8891666160618854j), 
              (9.2107503203717513-4.9282030493722582j), 
               (13.002905373749275-5.7864188790488917j), 
              (-8.1935567732084227-19.554727203456167j), 
               (20.300225163311651+6.3857133472618433j), 
             (-16.113446713657233+2.5696810026377865j), 
            (-2.1218083065195983-0.65934642543872213j)],
       [  (4.3499178277287012+5.9482603635600171j), 
                 (7.59081218882441+3.8910027946417798j), 
               (-23.113481763576438-3.88390679068468j), 
               (11.290062234597206+3.7254517416037154j), 
             (-7.8513064293827073+9.0832778240752763j), 
              (6.2563827224527211+5.2992420243086915j), 
             (-11.591286675068421-0.44719360581120737j), 
             (-8.3421750080811954+14.408571709585097j), 
              (-9.1149109637330081-8.5674530364211581j), 
              (0.16390561287297295-9.0418075166165952j), 
              (10.062204383487604-2.1727834817731955j), 
             (-9.0225725217903125+5.4635027318561242j), 
             (7.5018603290801513+0.91060221323070412j), 
               (6.4653891897932647+2.615257270509221j), 
                 (12.559423789331593-2.0527967326762j), 
               (16.291116629561643+2.4657157055123653j), 
            (-0.0015800086891335377+14.445259039378314j), 
               (-1.1261443422239743+1.832105218080522j), 
              (3.8978777963859401-10.007453331043967j), 
              (16.322082229234368-1.5149058845277601j), 
             (-0.7194646207856048+9.4766120686775253j), 
                (21.914149191161719+7.4895007497404649j), 
              (-11.964688619252893+13.533760407755647j), 
               (3.4205933608004422-1.1561907623375012j), 
              (-2.7801896678128468-4.0406789644534697j), 
                (3.8998190904411354-7.0903984728087712j), 
               (-14.490493844598365-1.072278652945958j), 
              (18.420175388033641+12.110254002655088j), 
            (0.22617607909675164-0.0028385471111126142j), 
              (-9.5085880491074235+4.7539021368829362j), 
             (-2.8384384537923069-0.34575920117084691j), 
               (12.40297414309261+3.0373246309802853j), 
              (-9.4767660053477112+12.583094135520303j), 
               (3.1337171142248206+15.903640696822904j), 
               (9.1828756425089395-3.1411287214526578j), 
               (14.969905886993534+2.3120049971883332j), 
               (13.223058704541323+11.715890866368461j), 
              (5.6453525429143419+5.7788634800993783j), 
            (-0.15731889303174001+12.604077252643389j), 
              (0.56016045949127902-2.1987341992024061j), 
             (-3.7178186187992566+9.2320158548785649j), 
                (-8.456239043000199+13.068154752708082j), 
              (-4.6510146825696381+2.3224230361995146j), 
              (-1.9997647989703757-18.497585972223135j), 
                (8.4509355969197806+7.120815284888204j), 
              (-5.0631080435530853+2.1762506976388423j), 
              (0.98627112153011343+7.1425999238421678j), 
                (2.8341418057264809-21.292020777836854j), 
              (8.0758247418480007-3.0551033884035754j), 
              (5.4553241943532482+5.5074430133503753j), 
              (7.6079987379737313+5.7953774659980715j), 
               (-6.366303729828104+6.4594939522258796j), 
              (-3.7355031614241074+6.0886124378969892j), 
               (-1.7976106940909609-14.793449422580039j), 
              (-16.443324711894313+25.539549723677681j), 
             (0.066250902408606982+6.6323060097592546j), 
               (2.1926268352793499-9.8012602635085511j), 
             (-14.803186934162611-7.2214239153094049j), 
                 (5.7195001440156421-6.448518781019537j), 
              (-23.541378530989789-1.0170245144883809j), 
              (-11.41462133442084-11.950559572967679j), 
               (4.3048532250311924-2.8156381737654854j), 
               (17.907461796170562-16.998495151085734j), 
             (-6.4170692275171968-20.141138947253037j), 
              (-13.759490671167217+13.850608720106932j), 
               (10.589909811565343+17.982614432821585j), 
               (10.582113170716841-10.740212628291408j), 
             (-10.189882121473561-3.7880591627673477j), 
             (0.57596370410332587+3.8996869167992547j), 
               (12.194453777407929+1.4991202052110133j), 
              (6.8812119060110453-0.13225583439878086j), 
               (9.1061183404480612-0.6471155146768105j), 
              (14.484796515144083-1.3111068156906911j), 
                (7.8927713055761899-14.619917342410085j), 
             (9.7078827764188098+0.27592111466886787j), 
              (-9.2045104749044633+7.3197263317321193j), 
               (6.5229479674603494-19.79081517583591j), 
               (-10.51104460943149-8.9633627503882867j), 
              (-15.911021726557323+17.990117900636669j), 
               (7.7273029876678194-9.7972287483843541j), 
             (-2.4603347441566257-6.5683241249148008j), 
             (-11.523997698417723+7.1232293147782233j), 
               (6.7388546656713171+5.3628180265038896j), 
               (24.980371377361426+12.446223594175033j), 
               (-9.400992186988141-8.1485166102814262j), 
             (-1.0274569170955652-10.751983826041485j), 
              (10.090881986960195-1.7943201343756709j), 
               (2.0841052376804785-8.4356229915469942j), 
               (-8.2628828772311387-12.172250694040823j), 
              (-5.7926715733571381+6.6651315873734003j), 
              (-13.062720723671964+26.047413314475794j), 
               (-1.8712000115389247+5.1700583425079616j), 
             (-4.3177660971856282-6.8460637620873861j), 
             (-5.0811490615313541+6.1740491469694714j), 
             (-5.7028474604321371-10.063653110222312j), 
               (13.047802773891865-2.4663324049081377j), 
               (17.342632768113415+2.1866788723011208j), 
               (22.784301164935428-8.2464150811048107j), 
              (15.567715378158324-12.348692249405129j), 
              (10.167274982501082+1.0728710576495961j)],
       [  (16.586455129332855+11.613915745804576j), 
               (11.730938462589588+2.0578255583440681j), 
             (-1.9248961039099792-19.621207357359861j), 
              (-6.6433630155169077-5.1069593223125631j), 
             (-2.8968349325189813+11.550212977125099j), 
              (9.6836327141711145-7.8141143508001267j), 
              (-1.4730755720389364-13.491159196965711j), 
             (-1.0483723923769797-11.866941016544185j), 
               (10.300106087044243-18.974193857743249j), 
              (-7.1052813794662271-3.3390728092856325j), 
              (19.397726108035513-5.4557798224234411j), 
             (-5.0583118660535451-9.2085967680149565j), 
              (2.2795674746274481+8.5271303104550924j), 
             (-1.8769753150329029-3.2968373433821654j), 
              (8.4326786213317142-8.5747691516662279j), 
             (-0.39182828317794804+8.3023252943393491j), 
                (6.3911776747351832-16.040808326532371j), 
                 (17.704857256546372-12.9417574920809j), 
              (9.9429063836500333-2.1321589822097846j), 
            (-0.98338280997981409+11.534195156780303j), 
               (-11.6352330543312-7.1474682741450257j), 
              (-7.0350425857063028+0.77318019678891181j), 
              (-16.503298988270828+23.131854620496899j), 
               (20.023342470652739-4.1480803936246913j), 
               (11.144905376164939+11.793340927142967j), 
              (-0.63232753295975819-7.8453277697566186j), 
              (-11.861658598010376-4.7724189527587324j), 
              (11.530168436340579-22.225466459722561j), 
                (-3.404193063949899-10.399045059524406j), 
               (11.691670999920392+5.9648959394132426j), 
               (14.250451768053862+7.0625020891820558j), 
               (2.0278316512112111-9.326053709548761j), 
              (-1.2034949104248491+2.5053291728174871j), 
              (-17.527546591422514+11.060208175825066j), 
               (17.604979411646358-8.4343134720995572j), 
               (0.6423855158313081-19.024451683816729j), 
                (11.765630017571812+6.480519502043518j), 
             (-10.943143748105712-1.3224014435584994j), 
            (-14.854036367933951-0.69248931642653322j), 
                (3.972912785014592+3.7477709573432638j), 
             (0.20568540415062678-4.1259232524837346j), 
                (-17.63488752659033-2.1375917119463268j), 
               (1.9794712300449049+12.383262942158545j), 
              (-3.6038477791353833-7.8783981208235554j), 
              (-16.454477656475174-5.5492363541922298j), 
              (-18.590811286588721-22.870611402254347j), 
               (14.959595614104435-6.6180840260414744j), 
                (0.7209109457943329-9.5550852543160012j), 
              (8.8098093735222136-5.6514914193628432j), 
              (4.0279660277778229-7.5741424467938101j), 
             (-12.968993615994464+2.7065342100062493j), 
              (-7.4874135491559999+3.0971772084093887j), 
              (0.87560206431944243+4.4754443936026034j), 
                (6.0247603662312947-9.8735261906038687j), 
              (-15.232520304443566+1.6469541086648176j), 
               (-2.784814296920493-3.6413282913613303j), 
            (-0.16491190231249975+0.99116227537880575j), 
            (5.0478134482491228+0.083073095216764106j), 
             (-0.076870153676589004-16.910891135333639j), 
              (-3.6962716070774775-1.5084408454177047j), 
               (16.91281492985194+8.5878384462871118j), 
              (-14.606960394082822+19.876443623661132j), 
               (4.1263691617449529-2.6614818797962299j), 
             (-8.6023428250044436-14.966804829218525j), 
              (-1.5359376625370604-1.4400281840670694j), 
               (5.4528884201646299-9.1015448242715742j), 
                (1.814784988907963-1.8143139710432121j), 
              (5.2603950546007479-6.6518564916523157j), 
             (-4.5351355646180078+6.8772891025523188j), 
               (14.526241376404521+14.504380363303628j), 
              (-17.725522845824653-5.0693856632878598j), 
               (3.1382221199911697+1.2822134528208249j), 
            (-1.7715913583598124-0.33496813045632745j), 
               (-24.218620731172752+9.2218658281693973j), 
              (16.998421188062544+7.6333606504849216j), 
              (8.4463685771900892-0.92467821696246066j), 
              (10.671254498301296-14.176152350261615j), 
               (0.9342401313683073+1.8709499345991589j), 
               (7.0945278188461796-18.611044870740145j), 
              (0.82297349137868614+10.681223294237137j), 
             (-4.8137008021031864-5.5930621794586717j), 
              (4.8890742953390838+6.8941180937763669j), 
               (12.908340042070328+2.7333155358259904j), 
              (-9.2295594105892835+16.339800374220424j), 
             (-0.89310024487997541-9.0139769437385837j), 
              (1.4320956333821719+3.8416559483885839j), 
             (-0.3727074228363696+11.448841180941686j), 
                (12.112373261969323-13.96371992636767j), 
               (-1.5760072678577239+9.6003900029777931j), 
             (-0.59233623912002642-6.9626124464615922j), 
               (4.6211102428666653-11.404987435336523j), 
                 (5.2304385638860049+21.99100835955095j), 
              (16.563603050276548+5.7183778512492651j), 
              (8.1784196939591087+11.771059835425037j), 
              (5.4387508895808514-8.4471053341235631j), 
              (-8.3451626014224178-4.4903230699249983j), 
              (-19.688376493575493+4.4400687166955581j), 
               (4.6113396815140781+14.849595684557704j), 
             (-2.9202721312720152-12.276978838567326j), 
              (2.844766783168426-0.19803380987158256j)],
       [   (9.503276990819213+10.819886268334319j), 
              (0.55546855583687538+3.8780608194981299j), 
                (6.1349044916940692-7.86187677141635j), 
              (-2.7643357549560306-5.0410220944341342j), 
             (-6.4873823974818574+14.629813413900003j), 
            (-10.875283092737238-0.61986251862149133j), 
             (-0.32529321786479615+7.5029138650788427j), 
             (-10.856497148692005-2.1035079236622951j), 
              (-6.6335826848803991-3.8513342339752747j), 
               (-4.196052897862109+3.7190972134570477j), 
              (-12.675523836508443+2.330538333800424j), 
              (3.1882421898675801-3.3119945963244231j), 
             (-6.8104889122250594+4.7241264844554038j), 
              (7.6945084563890784-3.5210081683910159j), 
             (-4.2669476616778663+5.6725576430517943j), 
               (2.2588759107399778+4.5152518983307637j), 
                (5.1728350630772901+2.3277181929929616j), 
               (8.7356252088798598+7.7684186698726592j), 
             (-13.052007973956812-9.9551731857997545j), 
             (-16.364978151878834+6.8886685065086448j), 
            (-0.91311049552738333+11.844371324132757j), 
                (-8.8023405070275711-2.831672361121353j), 
              (-22.402577760932406+13.079733508228577j), 
               (6.7795636350507333+7.8141631944544727j), 
               (15.617511948379274+4.7009208714645903j), 
                (3.0356304080699208+8.2907806669906563j), 
                (-13.085324499076656-2.77699376375271j), 
              (11.016925774626781+4.7341109582812209j), 
                 (12.94391078511072+4.6095325138453465j), 
               (11.227205404952549-18.042367844185499j), 
              (-13.496455191934425+10.311853354875325j), 
            (-0.50229346712317469-17.082438986464325j), 
             (-0.68588243285062989+23.267797941303883j), 
              (-6.3032916668533501+7.8433980402947734j), 
               (2.3248835497754894-9.1272298107831826j), 
                (11.29597753464094+1.5016262623533014j), 
              (4.3074580444364781+0.94667123623274874j), 
              (22.012501772835265+7.6951311809702627j), 
              (-6.379200013262702+8.3341030596573002j), 
                (19.601902228803596+18.21088867468421j), 
            (-6.2301855067379384+0.43743601409289479j), 
            (-4.3219866792852075+0.0028998083863341555j), 
              (-5.2348348883263993+8.2521095862459308j), 
               (8.7943176951422402+12.811993422433698j), 
               (13.500273521788573-2.9579318161125272j), 
              (-0.30499117065418974+7.409967489391458j), 
              (-1.1657145312571224+12.587788683068339j), 
               (-10.187560732334104+2.9517596336095719j), 
              (14.806216391322351+11.379212288921609j), 
             (-3.0556222806463995+4.8977821905364607j), 
             (-5.8867610686542964-6.3617760254236275j), 
                (2.7075313073197438-22.81733817851687j), 
            (-5.9950608163645827+0.060921290083212516j), 
                 (4.021386753977092-13.818132897865407j), 
               (31.229069792585733-5.2923529035768437j), 
               (2.7245513898359692+9.3606871370658951j), 
              (-1.6147222770779901-5.0839391786850356j), 
              (-6.5520558604716612+11.66730247860272j), 
               (-9.951970119435396-0.31771727449978082j), 
             (-15.013953716488395-0.10680618896383616j), 
             (-3.3312571872277266+2.4518032379651609j), 
               (16.060120733954403-2.4615708151407603j), 
              (-16.649132114049149-9.1452052286439987j), 
              (-1.675208238920713-6.6999747368156957j), 
              (-17.790334881683037-11.093323053129051j), 
              (-2.2280417263517793-9.6649429769128918j), 
              (-14.932817609267978-8.8211456245486168j), 
              (4.6246941739897656+12.987062875042676j), 
             (-3.3667400765272499+1.0010599484309486j), 
               (1.9053969911988187-6.2599836458952831j), 
               (4.7360754080773395-9.9150882252096544j), 
              (8.4978805063813496-0.12477232025435073j), 
             (-4.3753178297999646+1.2390400808980857j), 
                (8.7681941042618412+7.7893867149056684j), 
            (-0.83052084041200547+6.4654686013910192j), 
               (1.9899065318148974-1.7132371894968084j), 
              (10.090888612789735-15.000934590265942j), 
               (6.1585620174505173+8.5144314615344676j), 
              (0.39566187912210038-16.672245218988728j), 
              (-21.514570804261091+13.419718129597396j), 
              (5.0183389267719676+8.6117457205602079j), 
              (2.5636665750636372-8.5119485498382712j), 
              (-14.976752895353071-24.232705782978282j), 
              (-12.613598721244649+4.5180400925974764j), 
               (-1.8246751302692696-10.32755675912578j), 
               (16.02537718032254-27.267515649509733j), 
             (-13.714447343138879+4.9682628924547849j), 
               (13.428965141108172+19.423121924683823j), 
                (6.8960057660622347+22.529223634324055j), 
                (5.205280562169432-1.6368548811087571j), 
              (-4.3891497558387345-8.4113377122182325j), 
                (-13.47891524267677+2.0569114799070869j), 
               (9.1044581454819422-9.054432797722697j), 
              (6.5463730085536689-9.2959896340379835j), 
             (-11.867021123623541+16.382990468262239j), 
              (-9.9679424070403613-3.6911493680987402j), 
               (1.6720609130251842-1.2203958273227977j), 
              (3.6510091112972725-0.80459636920242439j), 
              (11.120794515333316-2.2808489542797554j), 
             (-10.572863492331507-4.3736202019009678j)],
       [ (16.568936415231537+0.95165607347394521j), 
              (-4.8000936559647407-6.1863831523489878j), 
               (-15.85998590135336+14.23800702163925j), 
              (-7.6662069913008777-6.4224530349596005j), 
              (1.7897593266256953+1.7873362933230654j), 
             (-13.340376847204933-4.8755504676746897j), 
              (-2.6225479462833312-5.6660389842846453j), 
               (1.120786821586641-6.8443595173948504j), 
                (1.6583662310533263+4.439590156468892j), 
               (4.2591421626888879+26.781085632674202j), 
              (8.4548857860553159+14.619405681075389j), 
             (-2.3287764304612781+9.4925025206046456j), 
            (-14.306893224864584-0.70309286276993288j), 
             (-23.006140757613394-5.7904394078333894j), 
             (-4.8557385339094958-11.186147481824122j), 
              (-6.0998605178789891-8.7622827999163491j), 
                (22.133771026964592-2.8953379276000679j), 
               (7.5028492234930519+9.0953935013335787j), 
              (1.4817156772048825+14.376199364604441j), 
              (12.629955176271185+3.7640542096184513j), 
             (-1.1710437205899413-11.111456429255123j), 
               (-11.123215043736058+4.5666056757320028j), 
               (4.7242492616310923-6.0141319417574426j), 
               (-5.083870366176825-3.1963458189860305j), 
              (-2.4367592358493022-7.0172945347745834j), 
                (16.003581085305076-3.4181483747119872j), 
               (24.093305515680626-2.6235575663619679j), 
             (-5.9215997486776768-6.1388119988833196j), 
               (14.292164825432847-0.92564241853422213j), 
               (-16.76145159643437+0.4363579946332577j), 
               (4.9316073156781659+4.1749230281088661j), 
             (0.39790299665227319+6.9962741342388384j), 
              (-1.2018864525666058-1.0324473323244363j), 
              (-11.195768943718589-3.7202221658001329j), 
              (-10.163001795268507-1.4955085662208174j), 
                 (0.770949305297147+5.566529121208216j), 
              (-21.099193525715869+15.939804131243033j), 
             (-1.6100468971676811-16.166012351797473j), 
              (6.2936599130422657+14.637211998720883j), 
              (-3.4791230354019227-7.2503260788107582j), 
              (4.5090562334409894-2.3267252164414316j), 
               (-3.2977416347020716-6.8778307335942355j), 
              (-2.1370089024314618-17.416010590362689j), 
              (12.164915171382098-0.78823102152954205j), 
              (-16.026290831951172+14.684905204814537j), 
              (-9.6159664786588461-6.4985743829356419j), 
               (4.5123847126307313-4.1289225347668381j), 
                (-15.117648536935333+13.30936431969165j), 
             (-7.6728768576772568-3.6315375845847733j), 
             (-14.527102020651043+9.8270038613709261j), 
             (-9.1208190031120786-10.415949784419489j), 
              (-5.0377103352784092-5.3676781609857667j), 
              (-2.0758143267750633-10.702745029854341j), 
               (-9.4506270590022297+22.273354593485134j), 
            (-0.79730050841660671-0.91474351202543891j), 
               (2.5873971201423647+6.7469220380277415j), 
               (13.333252126785627+2.2949097582766047j), 
              (6.9477823427429435-14.028139850022676j), 
                (5.4384423971278633+1.1372992895697163j), 
               (5.4505144139816384-10.679912022493532j), 
               (-11.370538642142595-12.3367128627014j), 
              (-9.5563062679641924-2.4432762530041834j), 
               (6.6196015931988041+5.7508921442054319j), 
             (-9.3971972127188543-22.950773140986598j), 
               (6.8208606728877843-8.0568672094946887j), 
               (6.7526151617677099+1.2643332454751808j), 
               (15.699785860194977-9.9275296967089002j), 
             (-11.480062295965247-3.3011508136101138j), 
             (-8.3817935331506419-8.2899697170265014j), 
               (2.7920444272050853-1.9784294148089221j), 
               (12.588424816139421-7.6586130122381793j), 
               (-11.06964716164012+13.628441592443787j), 
             (-1.1811595311599521-9.1688199799724472j), 
               (-5.0583529735589465-7.6559515560452098j), 
              (-1.9255906043860476+2.847821470001632j), 
               (1.2846744477755834+2.1183859571475065j), 
             (-4.3817913969115274-8.8009924024257895j), 
             (12.246894282560332+0.084793165070554691j), 
                 (14.955073556426456+1.89231533334973j), 
               (7.4910546614847089+12.058438401103633j), 
              (13.431722629953546-4.7713562892293524j), 
             (-11.065142779887296-15.951496009134969j), 
               (-8.0081652950519722-7.673781710319787j), 
               (-6.454607052391685+13.589929785182415j), 
               (18.177423654197341-7.9189604981488007j), 
              (-8.7866387251121711+9.914768711284772j), 
             (-1.2999735619376616-1.0918514531850163j), 
               (1.6520397870837702+9.9490314441989049j), 
                (3.2715494856471281+5.9745203687964112j), 
              (-2.0568346379986044-10.412116672506748j), 
               (4.1452931716468031-2.5362895491940773j), 
                (3.3485535597540323-15.080397692870029j), 
              (16.936615113159515-9.4478501912228996j), 
             (-7.3238661546571704+7.4952098241779384j), 
            (-2.5361919274565858+0.52238923114139513j), 
               (7.6616097137913357-8.4165241200755023j), 
               (-19.79922255769706-8.8727555846371082j), 
              (-11.561605430348713+4.0436239473220157j), 
              (-8.734112622585231-4.5919004283715905j), 
              (1.9868536452560812-2.1529119898608489j)],
       [   (7.471652493216002+1.6055989191527842j), 
               (8.3670361469771137+12.789359452836173j), 
             (-2.6005422619539731+2.2550822150683416j), 
               (5.8406992564132656-13.901692183483787j), 
              (8.2371481423333783-9.9000843231595539j), 
             (-8.6254608361041214-1.8172837731902893j), 
              (-2.8964596009636141-9.5398872829312058j), 
             (0.85677760420761739+12.759677675710678j), 
                 (7.10232759467885+4.4920106767256458j), 
              (-4.1210410385934289-2.6517382757521704j), 
              (3.5105577977837301-5.6940391567357214j), 
              (6.6772385592838805-6.1333563189600433j), 
            (-0.77966441839728773+1.6221877987730029j), 
               (11.62118561742016+13.486593602892842j), 
              (-22.350934473725879+12.43992305430571j), 
               (5.7657818346206966-1.2035103908418729j), 
               (-1.7577175090114783-0.6963562123166912j), 
               (12.016029582022338+4.3034730618307933j), 
                 (1.15386478721507+9.279534925013305j), 
             (-16.569424478446951-18.392722527469466j), 
              (5.7585507034475363+2.2245646601617395j), 
               (-24.328798482891251-8.1517885732138513j), 
               (4.8416616131524268-4.9111822290265099j), 
               (-7.1612379170466598+6.762356634333476j), 
               (7.4431699587695874+8.6490636886343228j), 
               (-9.0074402510835192-3.2562596750162136j), 
              (-22.202191258472826+19.974206059455593j), 
              (1.3054276312086395+19.776804798578045j), 
               (-11.269140519910577-20.115391153695899j), 
              (11.468587428362245-0.62619178743611448j), 
             (0.013725907854978134+1.8363603878512915j), 
              (15.075942495697506+20.305346604967852j), 
               (9.5486048363077511-6.0389162074139415j), 
               (5.8996924617784146-4.5403808186243539j), 
                (8.910415269795104-29.555366737368566j), 
                (13.52139972670283-5.1095863778887951j), 
               (5.4822739302890717+2.6506867758158963j), 
             (-14.088520785051941+16.493085558193762j), 
               (13.30978203109029-22.705481958398011j), 
               (9.3754373884429789-2.0600229294709913j), 
               (6.052816852437541-5.1545936033822626j), 
               (-12.067301370909016+10.844816439046937j), 
              (13.970841492599114+0.14528021882691677j), 
              (-4.2038502280629553-12.681463738722989j), 
              (11.108392731447491-0.57887822963330871j), 
              (-3.2795324198279214+2.0471492431534677j), 
              (-17.932127321234319+2.7205906936670026j), 
                (23.482299583114049-15.271456466399728j), 
             (-3.7988846896472355+7.1972151961116317j), 
               (6.7062346812189988-1.237787809152789j), 
             (-7.8596009369940445-8.7400525149746269j), 
               (2.3057290535067891-7.7689218681384355j), 
              (-4.0501422481619462-20.538137544812276j), 
               (-21.457876773621631+11.367352643208628j), 
              (-4.5550837295054327+20.189896872104775j), 
                (-16.8051780781255+11.866185286619274j), 
              (0.60728364756343667+4.5320845339163061j), 
            (-0.66519286560389834-16.569580898857897j), 
                (7.6555770861910304+5.4386570168817503j), 
                (8.0438805491304421+6.894125814262317j), 
               (17.475325295697616-5.147467396057479j), 
               (-2.386706888894166+6.5627612735356333j), 
               (1.6390333909877162+1.4872324161248085j), 
             (-1.4125929223566871+2.7092982852064971j), 
              (-0.80132717812957599+13.93889167631661j), 
               (2.9451715090012121-5.2113209672239407j), 
                (-4.101673039355803+4.724877544901279j), 
             (-18.821388527181263-5.3907428202134424j), 
              (2.2969055176945115+1.7800218343635996j), 
              (-1.9156941968086203+9.1228358377866368j), 
              (-7.0478159180569158-8.5333165290650737j), 
              (-9.4563867094324383-4.9151740199388119j), 
             (-6.7843571657299782+3.9556308044871855j), 
                (-3.500164066527331-11.490134269585145j), 
            (10.944016838042739-0.053071799422301127j), 
               (8.1670636391524614-12.732598847506825j), 
              (8.4015622430131955+4.2871747081808458j), 
              (-10.282434657531157-3.8244169428944153j), 
              (-4.8609834720621228+2.8392564159836589j), 
               (4.1246200911597235-1.1665362458998192j), 
              (8.5393594731721336+1.7345739775881397j), 
              (1.1652455715616428+12.589903771274818j), 
               (-11.012495475545157-7.710992058571061j), 
              (-9.2182034716153876-5.5414686439093028j), 
               (4.6913654848381032-13.720473632525534j), 
              (-5.1716173225529687-7.555908541028229j), 
                (13.605411490214118-1.32523860909604j), 
            (-5.9670958602061539+0.095004505134971842j), 
                 (8.946194693849673+12.687276749848342j), 
              (-15.367871829597981-29.950008585201143j), 
              (-8.6350123423782534-10.887293204447285j), 
                (3.3412629901074196+4.8873535937463997j), 
            (-13.456543690351921-0.87548692186900379j), 
               (9.116586206542852+18.076850635459468j), 
             (-8.4111280159914301+11.489928972729347j), 
              (-5.3163144100946438+6.9819610716745908j), 
            (-6.3920204586093954-0.041183680464380618j), 
               (6.4473480036519888+1.1171664139163906j), 
            (-7.0234306198892096-0.78888577105026625j), 
               (1.4003236891693329-5.480352490950839j)],
       [  (8.6496142609895763-11.225175641739662j), 
               (2.7193419778040164+7.9950292835912897j), 
              (8.9214781119408695+4.2651356017358575j), 
               (7.7524167514935272-7.8747738430764267j), 
               (19.96781069443724+4.3847337487019864j), 
             (-6.6972031421596823-3.1582786671362255j), 
               (-16.40221931166834-2.7750950860760675j), 
              (1.2870604429256149-5.1543611994012783j), 
              (-3.4321518182262425+10.737563874721594j), 
               (6.7090992212470955-10.337103037762411j), 
              (3.1128663288712852-22.324857596849004j), 
             (-5.8666964320068979+3.2296728591864499j), 
             (-15.192580638560544-5.3164752727417923j), 
             (-8.9463608421534566+1.5436165905342145j), 
             (-9.8549931603770329-7.1257900981074158j), 
              (-2.7413630941958624+1.5238424208020327j), 
               (-12.995118892163921-15.601117140643293j), 
               (7.4325837681666815+10.532056947361813j), 
              (6.6400097026739733-1.9788338108120975j), 
             (-1.3306255829453175+4.3731407040036601j), 
             (-10.306650548177078-13.602535479193982j), 
            (-0.98970476014009445+0.020524418571216181j), 
              (-6.6336500566041341+10.326964094650975j), 
              (-8.8023824290830888-4.1446216163946517j), 
               (10.595721052965105-4.6083961656633781j), 
                 (2.398500212660776+4.0241417738351863j), 
              (-1.1574384948161136+6.2324023751470614j), 
              (4.3610017394293195-6.7358286767709004j), 
                 (15.82178275256739-1.6685509800665119j), 
              (-3.7364812232102156+9.8521071095947228j), 
              (-8.4361442236895794-4.1753079733777012j), 
              (2.6926818174210698-6.8990917207959592j), 
                (10.48895814132166-19.198193218506173j), 
                (13.848155749044563-6.840522648814642j), 
              (-16.510638471112632+6.3632237804311007j), 
              (0.70230972423699822+2.5005581952193161j), 
               (-7.6309969826921424-4.392250059459041j), 
             (-3.9237424073205958+7.8693583226854766j), 
             (-14.773157359075238-4.5448107998349556j), 
              (-7.1905557046336863-9.0447507353739027j), 
              (5.5435170786809937+2.4161964323907905j), 
                (8.0960237521211003-7.6335737395327445j), 
               (18.276835918026258-13.520119656990467j), 
                (-17.152952715939019-3.91889106465104j), 
               (8.2390697738477705-2.7813607752505365j), 
              (-4.1473697277878454-17.151541535778932j), 
               (-11.06094006838482+17.624688809158194j), 
               (1.1567381985666676+0.12494592217187141j), 
             (-15.010875146529202-8.1181816789802621j), 
              (16.587589594340983-7.5339101833728126j), 
                (-18.71760551355759-10.0923172432464j), 
              (0.86355188741630995+2.6668096890697521j), 
              (-6.6459975590089835+8.3479978231472707j), 
                (1.5227526993109872+17.888872000637679j), 
              (-1.4451754751604662-4.2724175173332055j), 
              (-2.0862537240158217-9.0478148401077263j), 
              (-6.7944374321629493+10.737646594603852j), 
              (11.179936934091659+13.424086606325627j), 
               (-9.1443198856554755-1.6440774744064892j), 
              (-10.941870916261841-3.4334640716008606j), 
             (-7.1677094444829912-5.0659557262612545j), 
              (-10.753480536549667-20.005102569236822j), 
               (-5.2304536745477037-1.253351515968864j), 
              (13.172401373515783+19.120029841907431j), 
              (-11.456506673352646-9.9212084335048569j), 
               (4.8971778561735757+8.0664479968794698j), 
               (3.0543451714678782-1.5270155549172248j), 
              (20.854986186057598-8.3305867709470363j), 
            (-2.8143169264085999+0.87108066119717087j), 
              (-14.961198415867718+0.5739471870438364j), 
              (-2.9616169256604428-1.2128619588284777j), 
              (-7.8525399484359255+13.903589405800814j), 
            (-15.295704890441574-0.44356792410455731j), 
                (12.074546479751787+3.2132367818055165j), 
              (14.737983188753379-2.0633448556010765j), 
               (3.7250562134497676-2.9589154291391182j), 
             (-37.526080064933666-7.2082368825177925j), 
               (6.6182535892663443-2.7443442246049776j), 
              (-10.304471626907972+10.691997139024904j), 
               (8.7587414122964038-6.3683283383809002j), 
              (27.613394520826056+6.2082000315965589j), 
              (-6.2430186688850089+8.892612184426973j), 
              (-4.4665866739932012+17.706285663886472j), 
               (4.2687145600741792-2.6455577474564365j), 
               (4.2470940744400796+5.9006795960546112j), 
                (6.7792771534271967-11.5367271222366j), 
            (-0.98907223845971937-2.7677400479763481j), 
               (1.2389857895210044-7.0455926985651542j), 
                 (17.89493279270739+7.6969318751946902j), 
               (7.0821553416855227+1.5844030270991007j), 
              (10.806360281721815-0.71557525934621591j), 
               (-8.2916738663291554+19.363001039247713j), 
             (-1.9688091697123558+13.050979164654233j), 
              (16.449724241176888-9.4982113822737215j), 
              (1.0890204257922733-12.068177837851197j), 
                (13.37700835147135-7.8217602204180379j), 
               (8.9747010664673503-26.964589224004996j), 
               (1.4230324593207362-15.386403175066734j), 
             (-9.4847808312629063-9.9231420201667557j), 
             (-5.1253549448900788+14.856198800219351j)],
       [  (4.5929814054304376-4.4052281896383629j), 
              (-1.9967648555517481-12.997807348625461j), 
              (-9.426195994874341+16.839997053943492j), 
              (-11.976777502658479+6.3891509707454555j), 
             (-5.4709747711640428+9.7723617131847345j), 
              (7.8360484785468945+13.453718223040394j), 
              (-10.353571614694058+2.4195100756201686j), 
               (-1.99877025107983+0.2900744980178252j), 
               (0.6777423285276617-10.786487856462879j), 
             (-10.000463212976129-0.94558015153060671j), 
             (1.0738211163094016+0.33214294712033959j), 
              (19.105065040896928+10.656930257567121j), 
             (-13.723748669840937+9.6500239154599203j), 
             (-8.8529330305832854-28.058969462044612j), 
             (-11.095152011999796-8.4939372376806741j), 
               (12.050364983030256-7.6492278442945025j), 
               (-39.200416628169478+17.030530495342372j), 
               (10.195002721960657+6.8739562492501385j), 
             (-9.2828901558301453-2.3425762737514262j), 
              (22.131972527895577+7.7290942084228211j), 
             (-20.130364409482546-6.5057718168861243j), 
                (6.9603436671744525-13.314493118217303j), 
              (-7.0835256544056495-6.9455599077035153j), 
              (-1.3057607791306201+4.3171041841210869j), 
              (-11.777030407444913-24.978677691224391j), 
               (-2.4422490402067174+4.2094857505187733j), 
               (-15.61630442347731-13.650427614340416j), 
              (3.9845136571078705-5.4910097884991638j), 
                (14.707483344090784-11.911581934539637j), 
              (-2.9116933732831098-12.591223007264553j), 
              (-6.9041968812316519+6.5378038039144526j), 
             (-7.6703510378397439-8.9175126551196353j), 
             (-0.63075856115787055-2.6448133863731655j), 
               (5.2163918387577208+5.2153591166213928j), 
               (4.2111980448750792-17.703711153019089j), 
               (21.109396459351881+10.523301521542132j), 
               (2.1848498914420844+13.390412956035437j), 
              (-7.726225876974655-6.8865518222899222j), 
              (7.4455984241829789-19.854760749091717j), 
               (2.8036882044465914-17.137725453390907j), 
             (-2.7507134224711143-18.532036023286963j), 
                (3.0674134387480838+14.585448275352565j), 
              (-6.3786080647010817-21.277775818857481j), 
               (9.3085463966722166+14.152561345246182j), 
               (2.1617860814638696+4.7284650789360825j), 
              (-9.3825158330401788+6.1357460863532847j), 
              (-8.3668368532444504-4.7256070570917066j), 
                (4.9105290716345307+2.1419059980481463j), 
             (-2.9993466066931807-23.518871797089126j), 
            (-8.1881516147703231-0.71610544870430637j), 
              (15.697290423365606-3.2693091590286913j), 
                (-8.04821937222043+11.343234994587228j), 
              (-15.699788330217007-2.8710578124717494j), 
               (-5.0969221160132587+9.4842501096395981j), 
               (13.598421631160493-12.520699960319037j), 
              (-8.2536111013834113+1.8984101861112417j), 
              (-4.7702468912344482+13.254778299907537j), 
              (13.498869354811943-4.0121631270210676j), 
               (-6.7768967469353472+4.3466004515288201j), 
               (-2.7322106389708951+14.57609528474123j), 
            (-5.3837660499477789-0.87616298773624535j), 
               (2.1337465681229593+2.2960509062001582j), 
             (-1.3330808744282985-0.31174762421419305j), 
              (12.319882211541916-3.8141956060157178j), 
            (-5.9272377287514741+0.047227245929538912j), 
             (-0.62850677597895266+18.070566090674298j), 
              (-1.8522344173619452+12.367086548632503j), 
             (-3.7062020345840057+18.850982974275794j), 
              (2.8299748788500967-6.2596426173371613j), 
              (-5.8946954147297914+19.001490328844699j), 
               (4.3394044637136204-5.2989402719137404j), 
                 (18.651153570793543-6.98912810743421j), 
             (-1.8412378068477593-3.4819494379436051j), 
               (-5.6114650437148983+9.8469255815444239j), 
             (-32.715464178917216-9.6883295340177114j), 
              (-2.7419339554680904+8.4580610183892073j), 
              (-12.357324144230208-11.27153363543008j), 
               (-1.7653286221576967+9.281065378206355j), 
              (-15.232531272323842+10.523381268782595j), 
              (-24.300063421968648-3.0122745343509445j), 
            (-10.610299293155418-0.49355936023077041j), 
             (-5.2194165333152389-4.0789878711913499j), 
                (-11.5043979700012+1.3175094921396764j), 
              (-3.4246402701271075-7.0473194506738457j), 
              (-13.583018896267935+8.9805723293266482j), 
              (-1.5773618534199527-5.026745941470776j), 
             (-27.300573282102437+1.0303929103655776j), 
              (-11.752553355015623+6.0919083388269302j), 
                (0.5967988028674619-17.668806647650335j), 
               (10.487210824246997+5.5193692162066572j), 
               (13.848826074188258+1.7191821539307752j), 
               (-17.429925685200402+4.1860056890997219j), 
              (6.4092491376289153+1.5581741931732287j), 
              (8.9688680970268706-3.9455050211462077j), 
              (7.7595504545463401+3.4122486896576589j), 
              (-1.0412369156397441+4.7490619388711037j), 
               (11.105156271086106+2.7815287060035909j), 
               (-9.313401566009329-9.2927604382524329j), 
             (10.526883885237044-0.06386708259533351j), 
              (11.670049681717845+18.279084478219321j)],
       [ (-5.7077325815399362+16.595330747588054j), 
              (-3.4005876187253077-15.710025023867829j), 
              (3.9318980134745929-11.151381221475006j), 
              (25.683814819089573+0.69044893619088599j), 
              (6.9091722274298668+1.0650993041565013j), 
             (-3.3950383382286287+6.2883315464856624j), 
               (-4.108193458310855+6.8415082187231668j), 
             (-13.001850395652095+17.333093651892526j), 
              (-5.5713798835304758+7.0988304750492945j), 
               (-10.528380784841369+5.628289247471578j), 
             (-13.985261274541816+6.4726774880156182j), 
             (-8.4212782201763883+7.5297068355151442j), 
             (0.95362362259154232-15.844326181251704j), 
            (-0.89993739538024131-7.6990104929262699j), 
             (-15.640732642379609-3.3111713454888299j), 
               (8.5414345335910067-1.7120709367853291j), 
                (0.3337880458552262-1.6827137414067139j), 
              (0.35429866300638435-10.392330882827238j), 
                (4.095168919042556+15.62012084793102j), 
              (6.3034464682890254-6.4418386329362498j), 
             (0.39232430150877745+13.932144748073247j), 
                 (4.188777004471306+17.367224319260973j), 
             (-7.5515689553673857-0.59714880055712372j), 
              (-2.0077273337556361+3.7792673008108446j), 
                (6.941745584997542+27.930020467502672j), 
               (-5.0327130536878499+3.6112039524823087j), 
               (9.2555870180292779+13.837424364544862j), 
            (0.029095850642554062-14.911431639409908j), 
                (-8.3532800834045524+2.069023045797965j), 
               (-14.710993581054819-7.438593360782253j), 
              (-7.7501791359265573-25.298867482244912j), 
              (26.006750046621534-9.0854234248383818j), 
              (-5.0143574584515269-2.6154633788812127j), 
               (-2.367526322787104-3.5725298418117917j), 
              (-2.0378458227807892-12.716168881414529j), 
               (-8.182526730963966-9.0691498546475575j), 
                (-17.419406991820338-12.9642605828393j), 
             (-13.019796642366508-27.716132505797173j), 
              (2.1663712460372131+8.1976478517766207j), 
              (-14.887882018289831+1.2033040180475014j), 
             (-17.905864584432528-8.2598902304377617j), 
               (-15.124436063721539+1.7296211897260068j), 
             (-0.53036946227894222+7.5537600495926345j), 
               (2.9771741603625355-8.6679682146583623j), 
                (7.2990176768321566+4.631018502810087j), 
              (-10.388903193353132+19.455411671299792j), 
              (-13.947613782109007-2.0051835035180381j), 
                (-2.2121459384344342-6.315871825288685j), 
              (-4.4164619172620743-14.00785793077204j), 
             (-2.6985847216300241-4.0763475346012976j), 
              (17.069012258871712-8.7049732917224567j), 
              (-5.5968911497690108+3.1462398843729638j), 
              (-0.61635902252103381+2.811707473653156j), 
               (-4.6458616028431274+18.468553417912158j), 
              (-3.2650084679563278+29.349925152983175j), 
               (4.8196087958363574-5.8538091229433959j), 
               (12.291029740926874+10.230206659995842j), 
              (6.4391943442326376+4.1750515864159343j), 
               (-3.5425635111328702+3.0841218855261152j), 
               (5.6495102455051738-3.0762865522147145j), 
             (-8.6039607160781184-7.3012963569987379j), 
              (-3.2407936507153816+11.171544089882531j), 
               (5.2753010226544452-6.9228570661057471j), 
              (7.5396731422777377-0.8139052769942976j), 
               (-10.12092137903112+4.1733843088436648j), 
                  (-12.6483066485413-14.8109404418792j), 
                 (1.134930307465229-6.960565349245913j), 
             (-26.246242423180387+1.5884770839077493j), 
              (14.470726005237291-5.7440266102131599j), 
              (-15.321811057441032-2.2838167912801941j), 
              (-11.154384589402103+8.8742635501911664j), 
              (-10.490780367852214-8.7110463138477563j), 
             (0.82803375379656585+9.2854599807590237j), 
               (-1.1106680123886217+14.743791047134465j), 
               (5.566195022431053+6.6195034963991279j), 
              (-18.672643629325282-12.813654521705857j), 
             (0.63060296419602435+14.765439975072802j), 
              (0.59129374448991578-14.931333890986503j), 
               (16.251951637169881+9.5389928495862648j), 
               (2.0673109244093713+12.264349333170479j), 
              (15.421750657592622+3.0044459732990987j), 
              (12.520230091391563-11.524188707780462j), 
              (-6.2367971307543835+7.4594496207574874j), 
              (-6.5221568724319496+4.4044415339333733j), 
               (5.8108486535299715+5.2877508958460693j), 
              (7.853531520039887-0.14059935983879712j), 
               (4.206342351719381+11.501192828114316j), 
               (12.389947760842688+5.5298335439905433j), 
                 (8.8355713009449115+2.789392413130491j), 
              (-3.2213745891325423-2.1420901520806308j), 
                (27.15492734276576+9.7567116384766486j), 
               (-10.855365125831378+18.372130646430854j), 
              (11.328089737925515-9.4217689374244884j), 
             (-17.236643941465349+3.7841948708533364j), 
               (6.5249863029230672+24.59142449990987j), 
                (13.43700576879338-12.977913546612946j), 
              (-11.793272078258564-26.052245375465578j), 
              (-6.9623377335678329+5.3155654047630243j), 
            (-0.13295863993971982-25.906147495379102j), 
               (6.1889624854625946+8.960104166230801j)],
       [  (6.2014965828810613-5.9811047363268575j), 
              (-1.5263484660792286+4.4617443959154883j), 
             (-9.4724888545274979+2.4704786238614806j), 
              (5.8070864255235799+0.39684620674722781j), 
             (-0.63860082901391357+4.209348512116736j), 
              (12.795456359302014+12.878229896736679j), 
               (2.1551177104062713-10.061721438092839j), 
             (-2.8929734978774242-4.0575387742932687j), 
               (5.0241789483078243+17.484626414958669j), 
               (4.7104585207903487+6.5234888950862615j), 
             (-9.4724817002578323+15.314566932765132j), 
             (-3.1073763154411043+12.057373762598205j), 
              (3.2662656816587088+12.370876519227439j), 
              (1.6405868995912274+3.1102227074431998j), 
             (-5.9942154362581963-7.9675851035107161j), 
             (-5.2776389211460062-0.88119404095210574j), 
               (-4.8327165417990408+22.257344111211633j), 
              (-8.4072105659999625-17.702445858196299j), 
              (9.8036727786151907-10.682921654177594j), 
              (9.9455860752508691-5.3198888122732759j), 
             (0.14517150766507206-24.216599311467299j), 
                 (5.590257099251982+8.2974291012446315j), 
               (11.497672424992235+13.746515164468654j), 
              (-6.7722544325225282-7.4532404079160273j), 
            (0.96494829152673767-0.041076272098690095j), 
              (-8.5456892905284185-0.64815800246704991j), 
             (-0.27421358290408598+3.2313382055606121j), 
              (10.429150587107682+2.2499948019928819j), 
                (16.378435127803485+11.713331480983308j), 
                (-19.467199516459214-14.0872894382626j), 
                (2.940699379281511-5.0376704594654615j), 
            (-1.7952400338040766-0.47552160226479795j), 
              (-7.6514241362036808+3.9191640910444603j), 
             (-0.85762022962653217-16.963122401001812j), 
              (-11.244248175030457+6.1778743227413733j), 
             (-0.90223165434379793-7.0026196861846621j), 
              (5.7705980004638215-0.53571407026761964j), 
              (1.8625851826538133+10.476822846473379j), 
              (22.610843179216971-2.0949296458746076j), 
               (4.6649727102997316-11.364614206362729j), 
             (-3.2629311485725876+13.990050462148055j), 
                (1.2519527909718231-2.9822213037401242j), 
              (26.365441401506757-0.17074128874697397j), 
              (0.96870278224847772-7.2389242703085177j), 
               (5.3509918253492099+8.4581967527518884j), 
                (-7.04201828350201-8.9488208322954996j), 
              (-11.520650386957215+6.3151982808252409j), 
               (-6.4832564740154917-9.3428866983747803j), 
              (2.5323097091573836-4.1326498662426863j), 
              (19.684170119846588-18.754044334036763j), 
              (7.1061620984768128-1.4410874573036458j), 
              (-13.404898033245695+4.8517822696543371j), 
               (8.8605060862391305-14.236961415341982j), 
               (-13.807369507236416+13.121836452666107j), 
              (-23.064388887108578-2.7207902190311595j), 
              (-5.1469119897768723+4.3626415594162999j), 
                (9.9780836213132282+12.48997004214527j), 
             (1.1609888826086625-0.25928825939322836j), 
              (-0.98222881257921457+13.346138419017549j), 
               (13.016920859208774+10.373778268185102j), 
              (15.324318013661941-8.6218905534931132j), 
               (10.561011155195645+23.816847132532217j), 
            (-0.44125985518100563+0.87448519481699316j), 
             (-7.9774169903393952-4.6764160670913384j), 
               (16.639584986958507-8.6305364156398809j), 
              (-5.0725472738007671+2.2515370772857795j), 
               (12.646930365052103+5.6818847481283177j), 
            (-7.5620239709244688+0.76732124394240053j), 
              (2.6615502496115702-1.9614634781243252j), 
              (-5.9975990174216074+3.4158524899868321j), 
               (17.587409779928954-17.146486431413752j), 
              (-1.1124080317851535-13.021094750566251j), 
              (8.4986236044943659-7.8684075955474642j), 
               (-7.1660937189631539-4.3891741168242753j), 
                (8.06023558390266+6.8642797748304352j), 
                 (-12.645679551032-15.407549859061842j), 
             (-5.4382226145565866+1.6870191229761975j), 
               (7.4639287988924972-1.5895134677211198j), 
               (8.6943508862768066+1.0399333421226389j), 
              (-9.5089793424682156+8.3379366153687453j), 
              (5.5459016257104228+5.8030249537544485j), 
              (7.8986260275297422-5.0391929988903197j), 
              (-23.397508225676518+10.983916493586063j), 
            (0.041524205248279711+0.63603650710031467j), 
               (3.7648500668621216-4.0073384739621245j), 
             (-11.547348806457849+9.4715359588099055j), 
             (15.985064098695092-0.69844113590773704j), 
                (2.633226904820178+13.085969042545926j), 
               (2.2874330447545406+0.02790914540733181j), 
               (9.1266910513410888+12.938733357611811j), 
               (15.511710550345409+8.3785467723715197j), 
               (-14.664250847112015-10.872513962046384j), 
               (10.64149152870189+10.095071382256728j), 
             (-6.1686762545773641+20.835958101568401j), 
              (-12.57228030611321-10.139136587234852j), 
              (-3.0116053910371425-7.4500845149702419j), 
              (-2.5359080993721888-15.377812155071037j), 
            (-12.108646854605926+0.089104552348282448j), 
              (17.163151672969054+4.2786532678879849j), 
              (1.6220444911916378-26.043756455836416j)],
       [ (-5.1310300002106253-9.5095557763364518j), 
             (0.046209034832049828+7.7746321783815908j), 
              (-3.7660303709890766+5.598132832297452j), 
               (21.773135301729628-8.5962751562280122j), 
             (-1.3867422558901454+11.289166251113345j), 
              (-10.14421454550709+6.5970258415930036j), 
                (-13.34582035199756-16.15022860169185j), 
             (-3.9257153253386785+3.7517589605239547j), 
               (1.2204787432741246-0.2637449508895498j), 
               (4.9078855209666923-3.3543909856956269j), 
                 (13.1112150561747-17.72060842004651j), 
              (3.4983449885185305-10.795232467979652j), 
             (-6.5764087225604655-5.8758884889902578j), 
             (-3.8643680225731991-3.8674123846441226j), 
              (13.074726864617961+6.6671671375390069j), 
               (4.8962442519635143+5.5772859374628574j), 
              (10.898870699416472+0.028397360809305272j), 
               (10.899033784011497+6.8712347565086374j), 
                 (-12.14446636462611+5.2117004913475j), 
            (-0.10231698805870208-17.163516750848455j), 
              (3.2100722682819254-3.6568057714469049j), 
               (-9.2196770538720969-19.513616584105897j), 
              (-4.5193875630452194+2.8749208215985114j), 
               (12.291171804054684+15.206634949078753j), 
              (-1.7274892432275701+2.4259245619066974j), 
                (7.3574987245887602-6.5980368771045939j), 
               (4.4826530654763621+4.5621312058506476j), 
            (0.88223625349553703+0.26768180915978901j), 
               (0.52339802562897919+16.346448463996783j), 
               (-3.637403341314255-2.3632601757594647j), 
                (16.2115993030027+0.49246566289166882j), 
              (2.8788008744929785+6.2174262683453563j), 
              (-5.7801269041561785+14.531866866051184j), 
                (3.797580780387892-20.741137597410418j), 
               (3.5923313406384558-8.9144742347855868j), 
              (-9.2909374186336748+3.0261144948212806j), 
                (10.444017191844813-17.32693867562266j), 
             (-2.6504423247746272-18.598787574310908j), 
              (-17.39746953713961-14.055362452207126j), 
               (20.536968335515322+1.4871528922685517j), 
            (-9.9875343395808791+0.46276966066724312j), 
                (2.9749858786099099-1.5969436164093778j), 
              (-11.030791153513276-23.625446938169432j), 
              (-20.543099363268237-1.0090033274324677j), 
              (-5.8297561227437207+3.2793969712843642j), 
              (-11.100662602445668+18.657788334557726j), 
                (2.1664380547453832-9.383140512316368j), 
                 (5.9742183032699883-5.425035301322235j), 
             (-16.832211625310652+6.1202894969130464j), 
             (-11.030677132375985-20.008974712907538j), 
              (8.6281030952441196+12.681608504352209j), 
              (6.8863832672848062+0.26827219250948997j), 
             (-0.96745738755203803+5.8881429930806615j), 
               (-16.684039085901301-16.596273601780979j), 
              (-1.3562604472437079+8.3588652049189545j), 
              (-6.9058332958977795-5.1907630158021698j), 
              (0.78578616490770647+11.530629471934988j), 
             (-0.47463913306082245-14.11232729392224j), 
              (-0.76964079925412432+12.621681019662027j), 
               (5.6860337740775861-3.1102387349499248j), 
              (2.3747227333694587-9.4561088334752483j), 
               (5.6672482536568012-7.4855918515850641j), 
              (-11.885930614862815-4.2869004427709685j), 
              (2.1799827389898354-18.915474374529637j), 
              (-14.646613775048358+17.555851181296575j), 
              (-5.0083975661959759-1.7858144951985642j), 
              (-15.651901461631672+3.7901794334677636j), 
            (-0.98204695198710801+4.3086530884163015j), 
              (2.5540555475072453-21.138135101600831j), 
               (8.9533167799140259+6.0776756192890327j), 
              (-10.350193343001362-7.5613646702508328j), 
               (-13.47884327029772+2.9400649991688743j), 
             (-13.875025334630998+10.965508878100207j), 
                (7.2723117399980328-20.223557965251896j), 
               (6.6178331084484965+2.414754105019489j), 
               (3.6399584700493826-9.5014378383600437j), 
               (8.5343891003211052-5.433515679742972j), 
               (1.5522879169622179-2.5348350071929246j), 
               (17.441736935353045-1.2873128891224386j), 
                (1.803330534490968-8.0697668245309746j), 
              (6.2747721231798606-4.8547375611293297j), 
             (-3.0638347110348541-11.941299954044858j), 
              (0.22665586423342196+9.4283892822312136j), 
                 (10.6819362571882-7.3368475551231471j), 
              (-4.6723729907131402-7.4502871485595055j), 
             (-9.1748726507158391+16.998958163068551j), 
              (1.1816824759027909-16.138046682329559j), 
              (5.1944811584622332-0.71568572668169417j), 
             (-0.098410540321675608-7.0629991472221985j), 
            (-0.050558107070368064+3.4421133076801214j), 
              (-3.7457127310247396+14.488714022053617j), 
               (-3.739271914707849+0.73830296081764002j), 
             (-4.5854511180179705+6.1518979653508925j), 
              (15.708659099988665+3.9518125390451795j), 
             (-11.863528186068116-12.381316889203191j), 
              (6.9855227333449275-0.15166805473285286j), 
              (-12.359594317818274-5.0627861721273737j), 
              (-14.588776246734263+6.8958940030755835j), 
              (1.9083324381371751-5.7737169403741397j), 
              (16.568575137215717-1.9405469713386747j)],
       [ (-21.078294541588292-22.031444625795999j), 
              (-16.762166608988846+14.976817637353507j), 
              (0.3321658827698632+14.131299053780017j), 
               (32.029046807508692+17.430662971057352j), 
            (-18.647355808414343-0.55924030404501124j), 
              (5.2043163977933347+1.4474289472517587j), 
               (11.178402263599516-3.5446586309780379j), 
              (1.8805865103474142+3.8790100826007916j), 
              (-8.2442778809519837+16.671992618477532j), 
              (-10.994419358282919-6.7747805641068783j), 
             (-5.7175266775556421-6.4512268107765616j), 
             (-3.0160576279032183-12.690128164120109j), 
            (-0.89140775583179876-13.147099050815456j), 
             (-2.8247520695472077+10.368666632193001j), 
               (10.95349818970929-9.8859496871709247j), 
               (2.3214825036176179-6.5853153909328235j), 
               (-2.9120900706980519+6.2774277496158879j), 
               (2.8515866539629098-1.7818569675463769j), 
             (0.57272612371140308+9.0573416798243045j), 
              (3.4552549189579844-6.6893369637987501j), 
             (-9.3974453119023131+1.1082036536972886j), 
                (10.096489548369922+1.3911823976485165j), 
               (25.14145844816489-0.60839088644517647j), 
              (-21.895571522336283-17.958858355962192j), 
               (8.7403633055026209+2.6368478131576523j), 
                (2.5580089058910587-4.6255804595500569j), 
               (13.953520748738331+4.3591155908972201j), 
              (11.601674014649252-4.4791362776293484j), 
                  (7.168312529904072-29.67174582601363j), 
              (-8.7281275105715732+1.1874865942139337j), 
               (8.7458824265302919-22.644828855225533j), 
             (-5.5160848792730874+2.9595015448693793j), 
              (-5.4381953180397815-13.045322913733122j), 
                 (6.923537818442739+25.86021196135674j), 
                (3.0613037142896378+5.056923736998197j), 
               (6.4906859186638846+6.2230649002875884j), 
               (10.976095091219797-3.2683964463898754j), 
             (3.1073933020934543-0.33388482331957225j), 
              (11.279100447955713+24.773199271422229j), 
              (-22.164596321411985+15.685221637546814j), 
             (-12.944864126102146-10.377827236318126j), 
                 (1.2409273405193482+3.369174652931731j), 
               (1.5766620145036319+14.677143007528146j), 
               (16.765698816311229-4.2574431389397152j), 
               (-5.327608122695942+6.7553243217010852j), 
             (-0.84642792364014785-8.0628889419432017j), 
               (-6.1171253863749566+0.308082694467958j), 
                (1.5467904366257739+5.7830289388664493j), 
             (-3.9704940623295935-12.193453572422806j), 
              (16.141024152967447+4.2278045395299104j), 
             (-1.6155198585646369+14.665755713566433j), 
               (3.5197961818727248-3.8396976093848725j), 
               (-4.2019599001390677+4.314812343170999j), 
               (-13.036262289872951+18.620762500145222j), 
               (15.318328860219276+9.9840767744934436j), 
             (-0.63088010808435635+5.1277768813702345j), 
               (16.199217240298708-1.6548343652774693j), 
              (3.0327955723189999-15.481176419408724j), 
                (8.8667781713543228-5.3716849412551735j), 
               (12.413631119461661+6.5039199995287467j), 
             (-7.3242476329454895+8.4004412276317915j), 
              (-3.0666190480412854+2.5602913053804217j), 
              (-2.3023086110412323+10.019990292395304j), 
             (-21.774060721970756-5.6252756629664349j), 
               (6.3261721081393398-11.243912281870889j), 
                (5.4123227446732116+16.08135821419053j), 
               (6.8285172976513469-13.958656127078346j), 
              (-3.215011734600473+12.863447562135985j), 
            (-4.9009969077969826+0.54511255016618554j), 
               (5.6278058054030931-1.2444319145388212j), 
               (1.9373743346766954+15.050689913444511j), 
                (2.833269349313686-18.870820509988132j), 
            (0.040103133620068177-9.0560926656187988j), 
              (-6.1585788973344266-0.80571730883239123j), 
              (5.2076188839512056-19.705014156021605j), 
               (3.1370490126853543-5.1952907442703378j), 
               (10.48612438535088-6.3488040731050539j), 
               (2.0446117944058151-8.8741403664437328j), 
             (-9.4250356741187282+0.48559716573763739j), 
               (5.3192462774614224-12.924345644776846j), 
               (9.9533062263308381-9.532959314802115j), 
               (13.65639560309566+9.9265224816723876j), 
               (19.383410538139213+4.9052189781401019j), 
              (-29.683468950416536+2.4836363308330442j), 
            (-0.065643188290264567-3.6501026350582055j), 
             (-1.2458548772592484-2.9059812815066182j), 
              (13.863564565366467+15.145145504469504j), 
              (-3.7330774506051334-3.0336787137550134j), 
                 (-15.263465550572931-4.63034217596479j), 
               (-8.748376966548701+2.4388888192201787j), 
               (4.3645686568757558+1.0908571451046971j), 
                (-9.420798831403566+11.502988817190737j), 
             (0.66464680761784489+4.7724286614919382j), 
             (3.1013398247202089-0.93480325785634188j), 
             (-8.7219029300087403+8.5567162682815709j), 
                (10.33930610586159+4.6918418610133656j), 
               (5.7898979542280662-15.928311912554395j), 
               (4.9955693830457513+14.898624203632524j), 
            (-2.8182869900144478+0.97082279209123223j), 
            (0.025116655290580985-4.9752377958047846j)],
       [ (-6.9428752976416117+14.575885490187781j), 
             (-17.975547446402679+0.20850207051340786j), 
             (-7.5063643225381558-11.517893495378811j), 
               (10.276382294314992+0.3384708383003191j), 
              (6.7350608290654632+3.6341128748384381j), 
             (0.86046606412857685+5.1666522219373636j), 
               (18.975750373344482-7.7530754510655386j), 
             (-14.322889997628781+13.216306432633427j), 
              (15.790667531137338-0.44101352189259529j), 
              (-5.8378379905072944-5.3760847564404726j), 
              (8.9911738094611096-10.287137529456533j), 
               (-3.551894635346847-13.68424392752104j), 
             (-7.2166418898084093+4.5478262296074448j), 
             (-10.050529056808166-14.256592391091774j), 
             (-4.3262760195845793+4.7400005362792266j), 
               (4.6075651563069595+8.5642649012214367j), 
                (-10.57371493833195-3.4447853589402961j), 
               (20.500892608101047-0.9833842706172935j), 
             (-4.8002762571987283+2.5490479146191674j), 
              (8.9958448684491312-7.4507071108476053j), 
             (-9.0713133464946267+23.630932169467599j), 
                (6.1024370655312428+24.307951208660331j), 
               (8.3965551957978484+4.8036595850434107j), 
              (-12.560862092263605-12.668809612982844j), 
               (10.835761482669389+7.4661440779374724j), 
                (20.874636209717707+8.7621205391346564j), 
               (7.8762222463838727-8.2135652472822667j), 
               (8.814876129254543+6.4318050783546257j), 
               (-10.665030343019149-2.2841555813711052j), 
                (8.037379264402027+18.844001079873589j), 
               (-5.938761234543998-1.5401490565896432j), 
               (1.2710016802214439+14.09723802813415j), 
               (13.166070732591868+5.1632345723043302j), 
                (17.045854358063075+12.68102750223659j), 
              (-8.1894335176301354+6.8238729109634164j), 
             (-21.731562262398498-0.69875024200346214j), 
               (1.4359466717359788-10.021621355070263j), 
            (-0.28534230039045511+7.2073056013930925j), 
            (-16.931351637665102+0.86089846705569961j), 
               (3.2722463884046271+9.7782492220693324j), 
              (5.2023256841999155-6.7885203720246734j), 
                (3.1657656718768816+7.1731099216299032j), 
                (5.3664711839732764+9.068274293393749j), 
              (-13.692458169378224+5.8203938450819548j), 
              (0.59537717925959988+9.5564010187025712j), 
              (-4.1525331046935232-13.217401844911738j), 
               (2.8609810829781286-1.4406898403055866j), 
               (0.60669597958240384+3.8869780455548186j), 
              (9.6724203068944767+1.3889530274820829j), 
              (-8.5380053159253162+17.57094376649167j), 
             (-9.5167248058149632+8.3124353033466694j), 
               (9.6548694078062027-18.093612262160235j), 
               (17.473374075995974-10.780643540942741j), 
               (-10.410791783546125-2.1547148791625608j), 
              (-4.4837136146609229+4.0811272934615506j), 
               (-4.0960328102562666-5.802375341156548j), 
               (17.633996725791974+5.5485190428345623j), 
             (-10.919107816997723-19.100688367944027j), 
               (-15.720084116048508-2.5565434510036149j), 
               (4.4845955872048009-8.8671411619672433j), 
            (-0.85061827874298823+9.6787439512810938j), 
             (-0.47982144827156742-13.996266798706937j), 
                (9.9761734172339764-3.809710620757802j), 
             (-15.153212786069176-4.4384160200622231j), 
              (-11.550676838653356+9.9941791151006569j), 
              (-13.68105980783101+0.45384897382602274j), 
              (1.0993697795216246-0.33790068087260772j), 
             (8.7014428296810298+0.77414337287144352j), 
             (-17.336097113755983-9.9165995968027403j), 
               (6.9780277908258581+9.5810149298504204j), 
                (2.1628230398518218+6.823378167884762j), 
               (1.2601586590949962-10.338305732093263j), 
              (-7.864517155824621+6.5407327654660836j), 
                 (3.994586878618855-12.377100952995201j), 
             (7.6684203713518482+0.17076746206177007j), 
               (11.602113439791516-2.1541045532816616j), 
              (13.066310658623498+1.8932786809223934j), 
              (-8.1236402757074035+6.4761698419134213j), 
               (11.048344086379828+9.5830552488778338j), 
               (11.376090448390704+11.780225334186031j), 
             (-6.4983386767507065+7.1864681446593659j), 
              (-19.91305745224226-3.0781290304018145j), 
               (2.6262482572493893-8.2591967673707725j), 
              (-5.7863764496931687-5.5230510502757095j), 
               (-6.724934673866489-9.9476503719815526j), 
             (-11.021309929239816-12.473652060806016j), 
              (7.2138237516723391-6.0216023475853699j), 
               (14.844108590971757+2.7809574163177988j), 
               (-12.388193031517984+0.5886487574919026j), 
               (7.9505951456293813+8.1066242159131079j), 
              (-12.212711956857138-7.3086430115586296j), 
                (19.895435400637609-15.030374580198112j), 
              (10.190763281908993+4.0892801759274384j), 
              (18.792845160905799-7.1378894178746553j), 
             (-6.1984976489997443-3.4989801134265788j), 
               (10.043319159496411+26.512738923877265j), 
             (-0.66209036029440926-8.9143595056244678j), 
              (-5.3069811950868653+11.428545167867039j), 
              (12.565026966702915+17.748809522295819j), 
             (-14.962051535267015+22.847294957878695j)],
       [ (-5.6041443546879766+2.2872713150208939j), 
               (15.955065459145558+2.8543933482500399j), 
            (-0.93462217942787185-5.6346647520784368j), 
                (11.262338539170155+3.864482922854406j), 
            (-0.20401828585539114+1.9985579250365573j), 
              (0.7824710302314748-15.109235015034519j), 
               (2.7390949898524841+8.6433108081998622j), 
               (-12.0626786973374+6.1231276289880698j), 
             (0.098046255841790567+8.9474462168886806j), 
               (8.1205954595966219+1.1521258742174343j), 
              (0.73783496877979859-8.673545291682748j), 
             (-6.4562543895113143+12.825112567579991j), 
             (-3.7159169434993644-23.856117604841167j), 
              (14.900857243532105-14.094852322442527j), 
            (-0.15621253102456897-4.6970107256883455j), 
              (-9.3624262082236456-7.3251949362120152j), 
                (3.9826748977788795-8.0686450691631268j), 
              (-4.7151646214218843-7.4698898746112192j), 
              (22.608318016618163-4.2056987027095589j), 
              (14.312638146048506+9.9115859564994011j), 
               (10.82038796022063-18.188283174585024j), 
               (-10.888437963293311+23.182779554511676j), 
               (-13.17816960262908+12.760534130311436j), 
                (-16.143951116870628+1.96321426992548j), 
               (10.418590837386004-7.7578261853237782j), 
               (-9.8899437382033373+4.1609297578955147j), 
             (-6.1850688172620902+0.37204554076637764j), 
              (-10.292742876259705-7.705515724847797j), 
               (0.81191367084012556-20.210933003175064j), 
                (3.8804876958743111+5.835081032120395j), 
               (14.148190097250593+2.9718522427821319j), 
             (-15.668737289794256-3.6329086766204894j), 
               (1.0435370222335829+2.8402682769068672j), 
               (11.422011336849522-16.652683093289905j), 
               (1.6218322252255106+11.109008320285543j), 
              (0.37852586863684734+13.548321875882404j), 
               (-6.1230708717578892-2.115073201216243j), 
             (-10.034313685033627-1.7527537297675586j), 
             (-4.9290676581353949+3.0298756552199864j), 
              (-19.703516997055594-2.4299668844121363j), 
              (15.004727812441988-2.6325938600113128j), 
                 (-22.65053579325237-17.13249631815836j), 
              (0.16245117299631529+2.5331160342619876j), 
              (-0.1765103021977141-6.1965955620591329j), 
               (4.5412855854320719+19.967316921369363j), 
                (6.581133747280985+2.5647205500587127j), 
                (3.0538916780421173+2.691344314515089j), 
               (18.31342943079914+0.020486192377448326j), 
             (-5.1270352210212433-13.526135389223011j), 
              (3.5743752063950849-22.997173864293799j), 
              (12.939862966553168-12.861512517816212j), 
              (-5.3864734780720767-11.997102619175493j), 
              (-8.5305281745277526-8.4533608360502619j), 
               (-10.660237920335913+6.8938406353378685j), 
               (9.0592463274354174-9.2934851766107052j), 
               (5.4314089965250902-21.432270197283842j), 
               (12.910537211778481-1.9013858699277284j), 
             (-16.670138365188642+7.5246336441016979j), 
                (2.0142956369000702-0.7213464043960065j), 
              (-12.090437551842669-10.793543422545032j), 
              (1.8536625658084873-6.9203374956614336j), 
              (-1.7279137449933435+2.5977113398879044j), 
               (18.732978653212896+11.240167857224288j), 
             (-8.3468542355202437+3.0355787981537627j), 
            (-0.29244951329636393-0.52093382686673617j), 
             (-0.068080484413178738+13.41451479896927j), 
              (-4.3040741057003853+6.8707285735892887j), 
             (-9.3637215045980682+11.412379056733556j), 
               (16.43445764861368+4.5723128535879471j), 
              (13.746883224253953-0.87033368596650285j), 
            (-0.071326044564810148+2.0313755695225453j), 
               (-8.470463261270357+14.606858619846212j), 
               (3.3845553857132042+26.19450186563688j), 
               (-2.5319527188896562+1.7891538487465295j), 
             (-1.8421987267534909+3.6799487373999766j), 
               (-9.8878981019244989-16.52545141710927j), 
             (-10.325355198136803-4.7020376790426983j), 
              (-2.1635949792353126+5.8402094627966381j), 
              (-6.2542377203041379-18.124553346725286j), 
              (-6.3807293206852975+9.9303899763202885j), 
             (0.95903637797117136-1.9979175380222776j), 
              (6.0654059199661381-2.3099708887484076j), 
              (-7.7073622027776896-11.909711386658708j), 
              (-5.0852196594583168+11.225293182659989j), 
               (-16.516491886733565+9.074269451347865j), 
              (9.8817524839833162+24.396286382911718j), 
             (0.63619760900541344-14.219936248825277j), 
               (4.0006518350399087-2.7015095092574466j), 
              (-11.433274906404112-0.12505687629200396j), 
              (-16.002169617668969+3.8069385189555529j), 
              (0.11831371397032495-1.3071542400479996j), 
               (-7.5280143367062378-18.119508245165822j), 
              (10.356000921349626-7.7104623340012051j), 
             (-0.76989460408762023-1.546606893688999j), 
             (-21.567759327852109-4.5161791121497465j), 
              (-11.236431727675383-20.381179746488101j), 
               (19.217704594568421-6.6769110212115415j), 
               (-20.375774693061377+11.55230979311326j), 
            (-20.708529339939759+0.61990955346284027j), 
              (2.2178298979751587+13.351559692986235j)],
       [ (0.55928589619908453+6.9126743267428905j), 
              (16.763266102340172-0.82116278613144089j), 
             (-11.118690576860718+5.9039994909258997j), 
              (-5.2268455378946674+7.4347174636652946j), 
              (15.159251873013469+3.1560210252756966j), 
              (1.5219233333250324+14.632312518823511j), 
              (-11.145870552779119-17.511441164115311j), 
             (-3.4604220730995094+4.2985120597708102j), 
              (-10.528221495955421+4.7993399814452058j), 
               (6.1182661748078804+2.2584367018655982j), 
             (-15.769307128265979-4.5312669556162515j), 
             (-6.1050446916913783-6.0821037488014653j), 
              (-16.593096791669574-24.92983426938018j), 
              (6.1373841083192717+9.7588487102052266j), 
             (-6.1920997980240671+4.8264121061483367j), 
               (1.5619068853270939-15.518239583486903j), 
                (17.246033404313735+10.953003867942748j), 
               (1.8590027712851533-12.722586263469921j), 
             (-14.081067614822373-11.277648272111023j), 
               (10.18190515383575+8.8715364945027186j), 
             (-18.176072081978333-7.5788006480359229j), 
                (15.931648765422622+10.841741616942794j), 
              (-10.402067234391721-3.2779822282298272j), 
              (-5.9146847429516285-6.4556381298483601j), 
               (18.703267499865245-8.2067171116156885j), 
               (-3.9659976178958756-12.867050666528513j), 
              (-22.984118168700654+12.256056983139526j), 
             (-5.8705732778374529+10.251794154821168j), 
                (14.518034356120324+23.028915365153679j), 
               (7.0672689701132079+7.3019828604590238j), 
              (6.9522171163259259+0.75202975738682554j), 
              (1.8525793069980296-8.1621913911674486j), 
              (-10.990361765263138-4.4277781563145089j), 
               (-9.799980865087651+4.0642021622778373j), 
               (19.645547616078463-1.7586357368311953j), 
               (22.546162180473999-3.4287548435894122j), 
               (4.8143732132978654+3.8289016814903514j), 
               (-5.86113068998114-5.1056103096412206j), 
             (-4.6437030062109477-17.969864974855327j), 
                (12.03063297524478-14.800637501918075j), 
             (-4.4996779248105057-4.1412446261889126j), 
                 (14.91908194924239-4.4511102825317712j), 
              (-10.650540400362789+8.3120561747126498j), 
               (15.264289826536663+2.3453997786916578j), 
                (14.276017940977502+6.148289704048544j), 
               (5.4529520976979367-5.4379064815295131j), 
                (2.674937970151285+8.3162340704923174j), 
                (8.5101894195692367-1.4509048951941017j), 
            (-0.71820886676678397-3.8466642193873346j), 
              (2.8922377854461829-6.7144159821614311j), 
              (-12.46476353375918+1.7622757587704483j), 
              (2.2381959562363649+0.41411016596157169j), 
            (-10.314743877416625-0.013561404901045907j), 
                (11.075433363300382+5.9966080775475508j), 
               (5.2500884280942559+23.800385727378313j), 
              (-4.7795698153522395-4.3838983020606408j), 
                (10.47795895497385-6.4634157305268483j), 
              (2.7343054030440976+5.1242293265178942j), 
                (7.9853222876817842-26.055478408040265j), 
               (23.678809744193764+4.9840349502108747j), 
              (4.2913257441682182+4.4268236948805129j), 
              (-7.1663502677944049-10.470842825773802j), 
               (20.698278202738098-12.356343337501329j), 
             (-14.467932811354263-7.7544849078582088j), 
                (5.876774069505438-11.390150000255499j), 
               (2.7168245300328637-15.505888362008374j), 
              (-7.2763435784417849-1.0584115797604703j), 
              (5.6915437518860523+3.5903185736429624j), 
             (-11.458336845564901-8.7246894114317435j), 
              (-1.9448678673769875-5.7182035569009182j), 
               (-6.995728466145442-10.315792005250746j), 
              (-12.264400824880541-14.471148918370226j), 
              (-14.31474108880067+2.6984547326237429j), 
                (10.616171887278234+3.6177143960041875j), 
             (-22.134722066861535+28.311019152728498j), 
               (6.9263204590666394-9.8300741454450424j), 
              (5.0774292418367999-1.8515117546905486j), 
              (-6.4847753371550887-8.8490053524753218j), 
              (-4.7627124362423965+4.9242671988077955j), 
               (6.8024820928340866+13.421033351906456j), 
              (-3.143381701022347+13.040439538980939j), 
              (6.5617007524521398-2.8047156143979541j), 
               (1.9903636188338711-5.2165339243588367j), 
              (-3.3619679103970626+6.6811087912416731j), 
               (-31.14980902790591+13.787766321992848j), 
             (0.47037809624081472-8.4772882511509131j), 
             (-13.206533221838392-2.4031347544243045j), 
               (10.831284460576022-5.8642000054198817j), 
                (25.096177900302777+6.8218026169690136j), 
               (8.2504121443877025-0.6762674461527175j), 
              (-14.135718356876041-1.3576167901459018j), 
               (-1.5134354776505372-19.757189450144853j), 
              (1.7851292247982986+11.233673592316665j), 
             (0.81138363887533549-3.2135097846153511j), 
              (5.2515621943181721-8.3764066806476443j), 
              (0.42102120345018212-7.2690329257161599j), 
             (-0.52511209125559544+1.4178368901952503j), 
               (-8.900368601429431-5.3384355173378006j), 
              (1.2251714562418379-13.964871118695452j), 
             (0.34314827194117187+1.7471872924245075j)],
       [(-0.53040104521349274+18.326545867621125j), 
              (-8.8399488879416701-8.2418631823209072j), 
               (3.8080773481193626-11.06606118705959j), 
              (-2.5988232706603402-3.1024070913299644j), 
               (31.53840058668515-9.3164259561320488j), 
               (15.939386035464532-6.728491532954437j), 
              (-3.7573109652447121+1.2593120795800483j), 
               (5.649660617822315+1.1848444530269118j), 
              (-13.186337424700227+1.5183441798812871j), 
               (2.8139758613312749+2.1008136110122728j), 
             (-13.116908060957906-23.401259751093736j), 
              (8.0020859837419298+5.3472786183718206j), 
               (8.8712313937527636+20.70573503247951j), 
              (14.440046398405341-5.0388191079776865j), 
             (-9.4609199116473626+12.703733167360035j), 
              (-2.8460045603647242+8.8556529122312746j), 
                (4.1347270718014801+13.203979356225158j), 
               (10.442596361161671+5.7895996194234387j), 
             (-6.9424686883879039-10.755488671483313j), 
             (4.4236797887364041-0.04101656611552193j), 
             (4.9285288567123526-0.49877573154744642j), 
               (-15.284718336900863-2.4066973125462789j), 
                (5.7723765495306667+1.965318713611139j), 
              (-12.520112111646657-11.272713073976595j), 
              (-2.3898736488623444+1.0390230440342665j), 
            (-0.33048642911118031+0.090508170020724227j), 
               (7.1355304027795174+21.214605988224843j), 
             (-0.8540294904761474+7.6662315519100952j), 
               (0.51996872385458792+3.7166994455499984j), 
               (6.8968814401265917+1.4983258204410379j), 
             (-0.60508921289633955+12.294628914640704j), 
              (3.1999376234135046-5.3016866859414824j), 
              (-10.780973406510411+14.032467681167983j), 
               (6.0739306443516439+1.1358807333695999j), 
               (22.080796366505595-22.210566111579745j), 
              (-5.2605552668079012+12.155591971038424j), 
              (-1.9193398162953472-2.0641266592684477j), 
             (-2.0972313461219412+9.7076720018486871j), 
              (8.7558182063622745+2.5971786933128631j), 
             (-6.6364199984885497-0.83518819603767169j), 
              (5.6233646397929498+15.084374155697752j), 
               (-11.324420945406537-10.691003510916472j), 
             (-0.87540136154086856-3.1047789960452499j), 
               (-16.780425511352494+10.66858219994333j), 
               (-6.5255953999520795+8.061317824526693j), 
             (-0.30242654940474534+10.428509630734833j), 
               (17.340284307632842+5.4570602482248143j), 
               (-4.4820025294421146+4.1078660283036976j), 
             (-19.767459558324184-7.7632340909312978j), 
               (21.542221829785127-5.045815091455264j), 
              (-7.5764416226817231+7.567124463583971j), 
               (13.143009232504408+7.3655229048621385j), 
               (-2.7480034552417951-11.65643902886562j), 
                (1.9571878862444827-7.4896866244185798j), 
              (-6.5342787792083401+6.7997032908828512j), 
               (12.426876164087034-5.7013519060222526j), 
               (6.7471845247300681+1.4063244289932313j), 
             (-6.8802014717300173+7.5449319857572386j), 
             (-1.7853666996108504-0.047555772831466919j), 
               (-14.194290250599135+3.081776422413613j), 
             (-1.1835084717655331-2.4940050304482027j), 
               (9.5617895484439863+1.0889231442145633j), 
               (13.338201011086747-9.4489670264359802j), 
              (8.9894184412777172-6.6503359401153972j), 
              (-2.5640505108607821+5.9628429779734802j), 
              (-8.3251904249130693-1.0798681148980966j), 
                (9.426876495974831+3.2404168205616077j), 
               (8.8460942116001497+1.130138561706945j), 
             (-7.5975025285240392-10.399776155271848j), 
             (0.041272202729683918+3.2416177660108114j), 
              (-18.923359497541369-24.276963347238642j), 
               (-16.011499708493762-5.743997969016351j), 
             (-9.6085498155705249+11.364785443190563j), 
                (1.7334754544262341-1.6994355018396115j), 
             (-4.0878532833290437-1.6875938432589273j), 
               (21.038736334333027+1.8629529307853632j), 
             (-9.4004482625023922+1.3823207787265348j), 
              (8.6939574052760875-0.72376266893387831j), 
              (-4.0381559332706365+23.378154073010439j), 
              (-2.7190156609130915+2.4272683942402478j), 
             (5.7271241923893443+0.38690230314466584j), 
            (-5.2750169228969792-0.38062793809466777j), 
               (-4.1727518422403245-12.32592599590385j), 
               (6.4990231934730254-6.5480380646409113j), 
               (1.2401469879898197+9.3261792821738947j), 
             (-3.3358795128876189-7.0306856954355084j), 
             (-7.2816016512117612+11.561840500419478j), 
              (-12.477694584493229-15.523193804936735j), 
               (-6.4122988219785091+6.2137294890824792j), 
               (-20.884890856100839+10.34965242139765j), 
               (3.7611467849822233-3.3582505460701784j), 
                (0.16006071473137395-15.38423309126479j), 
             (-18.801811108220868-5.8211465779559166j), 
              (-3.8338966040498161-2.165242126930798j), 
              (5.7408661168608566+3.0165801550711331j), 
              (-9.7437762038162195-10.759034224806413j), 
              (-15.305564060788692+9.2548767293245078j), 
              (-2.1679134350153992+14.832459788878056j), 
             (-7.1365180192356314+4.4098922788843238j), 
              (12.727951932101071-2.7804868357734396j)],
       [  (9.7548252522089225+18.484618449548414j), 
              (-8.2299560146224522-6.7267074751444529j), 
             (1.6651963826903151-0.22348775925376912j), 
             (-0.64462168961492217+13.793389670829288j), 
             (-1.8598771368762361-1.9853087530009734j), 
             (10.605380781726836+0.36978170459452647j), 
             (-8.2660508774572552+0.57188308363907059j), 
             (-6.1932572110841431+8.6578138398814488j), 
             (-0.80222301134391194+7.5587756941965436j), 
              (-1.2272755083146452-6.2267842938786346j), 
             (-10.364523693046905-10.601844110268638j), 
              (14.351327713080348-2.8871202889921732j), 
              (6.1905563043639749-5.3906507318946693j), 
             (2.9347867447702232-0.37448249618370566j), 
             (-5.6385189524426451-7.5654323591622514j), 
              (3.7685385281224084-0.55325235395658501j), 
              (-4.8920424554183581-0.71566749724309431j), 
               (7.0098181513731506-7.5024769989183193j), 
              (1.5580258789432491-15.815300723805258j), 
             (-1.0709742936916726+3.3141426580225923j), 
             (-6.2854268192120086-1.6580860592849911j), 
                 (7.030115457046394-24.905654354525666j), 
               (4.0745375198835463+13.764483607065213j), 
               (12.150764677209221+15.074134143136586j), 
               (5.4607316065546732+4.3284823825953387j), 
               (-17.494837785050105+8.4014208242278983j), 
              (-13.878209813284938-1.4427070977089207j), 
              (2.0997457822882803-6.9469881697115268j), 
               (-9.7428959961781221-1.4534176851512213j), 
              (-0.9304350514321249-1.7645202922938363j), 
              (-10.690583670698143+11.214300625527381j), 
              (2.7990479121016616+12.471579438205014j), 
               (6.8709743622155468-3.1674657198162248j), 
               (21.974374359128348+2.3366683743390397j), 
               (3.1606338097076785-1.3031037728904451j), 
               (-19.814442329237913+5.406599607405278j), 
               (18.920976848896721-2.9521130224724983j), 
              (6.2061850712634143-7.2079270402901248j), 
             (-17.923962437359783+12.286988189074567j), 
              (-11.231095945459742+5.1335083275386939j), 
              (-2.382464195245833-19.454294623488497j), 
                 (-15.4084088315633+5.7614483037989235j), 
                (5.524466471205689+4.9414545149836933j), 
              (-2.1062047502512131+23.588073924463075j), 
               (20.565752830595208-7.7994864626305427j), 
              (-27.763532331426092+9.3125603919037658j), 
              (-1.6526045438376233+6.8783977262310074j), 
                 (10.319357132034499+9.230070273539658j), 
             (-5.7176814783360346-3.1100789499924746j), 
             (-14.786238646214384-16.092122461336011j), 
              (14.344961917152325+5.1750206885199717j), 
               (9.4661446521948029+3.6189087148471795j), 
              (-15.310237058183295-5.7285762615277092j), 
               (-2.4402718267394494+11.167238354151634j), 
              (-2.2565326525860963-20.370829002958473j), 
            (-0.059050000342513856+2.8591092690252253j), 
               (6.5906618379904982+2.0320366934979068j), 
              (-13.63198533368514+23.117337733990354j), 
                (1.9170604354956216+7.5322206794504307j), 
              (0.61940994779023395-14.048383130637367j), 
              (4.0234103722611678+14.917441873920909j), 
                (10.961359185293023+1.814131110917542j), 
                (14.605127786091254+12.91521121848125j), 
               (10.64965686594207+8.0442700006025287j), 
              (-6.0769928605419468+21.519503082984414j), 
                (2.408379352982799-5.7823556917322705j), 
             (-3.0672993400070969-0.17781074192348725j), 
            (-9.9875837913965704-0.63025236016623953j), 
              (21.799287260808335+4.9095853685371411j), 
               (1.2917475635289888-8.8136349404193552j), 
              (6.2267781810150744-0.98308686571793169j), 
                (26.741568809585395+2.112611421197343j), 
             (-4.3599644839391187+5.8731086234992702j), 
             (11.040568600729951+0.0051318018428251448j), 
              (1.9682723168378977+16.859539766766105j), 
               (2.7755474137864677-2.5580331235572586j), 
             (-1.8008636442170527-3.6180935961123915j), 
             (-0.88359961706188694-8.8975463908183947j), 
               (-6.254993675222166-16.269516805229223j), 
               (7.8858944691067565-7.8076346200840616j), 
              (-1.335010906063077-5.8295800457801672j), 
             (-13.900534782404046-2.3366575498440563j), 
              (8.5567999905736762+0.31145808021138111j), 
              (-3.8429142190348804-5.4862928557143515j), 
               (9.9384605271527295+4.8941679328433727j), 
            (-0.12103006731035762+10.021976121023176j), 
             (-6.9640093300602572+13.058761169640645j), 
               (-12.87618872907036-4.6058328511292519j), 
             (-0.60177384989663985-0.61132180488675336j), 
              (-5.8330217385633345+7.5405977933775459j), 
               (6.1447168174912949+12.497127087861005j), 
               (-6.8871046804256162+1.1136362669539221j), 
              (1.1993975097019409+5.3935831398372471j), 
             (-15.814320306077347-1.6776927394591847j), 
              (2.3044363560419647+5.5258064830417553j), 
              (-5.3808063813404221-2.4140353940496277j), 
              (-10.234519576555954-16.432146625240115j), 
               (20.272270663863615+9.6189496382388047j), 
             (-9.2921330329207201+11.571926862842119j), 
               (16.273642608182005+10.03825868012073j)],
       [   (-17.437781258274377+11.3164010237713j), 
               (13.587127076311582-9.3941169698623348j), 
             (-3.9905819117614301-9.4001445426483841j), 
              (-8.1940215502856653-16.150903433940709j), 
             (-4.2808903210548017+2.4629816736500465j), 
              (6.4533407465414996-6.4409842881538264j), 
               (-20.507437470533457+6.400762686759812j), 
              (19.856740885484186+1.1406414656814703j), 
               (6.9773944236216661+1.8732402218909086j), 
               (8.5507225829817521-13.361488349209129j), 
             (-8.0991643818759247-15.307676369496086j), 
              (11.691495809616994-3.9139447549994077j), 
             (-8.3166907417416152-5.5402462153617105j), 
              (4.3376909465456119+0.9826925517418722j), 
             (-3.9129867074122564-9.3735474038935802j), 
              (-7.9700065551440176+10.548918386390294j), 
               (-13.381716859232007-14.997192242587181j), 
               (7.0660115173669658+4.6626924794553943j), 
              (6.5657447049537971-12.937824594432055j), 
             (7.1640838423164173-0.26154134096026882j), 
              (-7.794700517390309-17.028626865788006j), 
              (-0.78213514263093797+3.2855458424518273j), 
              (10.042137524654898+0.74432613554642879j), 
              (4.6339976257066615+0.16181528055540448j), 
             (-0.20832776813760137-2.7430806150303817j), 
                 (13.376141997818349+22.48208148918113j), 
              (-9.4664239514633017+3.9391417237670021j), 
            (-0.21628677245211431+4.8435014768355309j), 
                (13.140919896153902-16.152702996694533j), 
              (-4.1853681393155675-2.8053353134597048j), 
               (4.4425544342960936-20.345441331705572j), 
             (-5.3915029946023383-7.7636340735361138j), 
                (15.56226036813565-21.070884682264762j), 
              (-16.033728586331346+2.6729148210843352j), 
              (-5.7519509649196028+1.3800158033455783j), 
               (0.2671557901885534-10.451667129278849j), 
             (-0.75378675899189607-5.5698849407784081j), 
            (-0.62413896211485753+5.0580007677305785j), 
             (-9.4344015392583369+4.9318299006347104j), 
               (16.260069611949007+3.2871496058746521j), 
               (1.724299897229669-4.8828879480283547j), 
                (-1.02090910873887-0.68154569705341161j), 
              (-16.933496610465156+1.5505906193318506j), 
                (-4.134413157875656-4.842381084195587j), 
               (12.259994225775394+7.4853184978396206j), 
              (-5.6076351689767936-6.5715170686725655j), 
              (-17.002040886963016-5.8147995458982935j), 
               (-6.8597529411470894-2.9351287329158522j), 
              (12.517026195511079-3.0232090562529961j), 
            (-0.25674128267429519+1.8020592467066512j), 
            (-2.7909341359813156+0.79478109139718889j), 
              (-19.638039851556407-7.0928545616201486j), 
               (-14.604262134124253-12.05267970943569j), 
                 (9.1981880007392824+3.465840740443066j), 
                (3.929742137409078+14.545224760474092j), 
              (-1.7292147223409235+30.823797981862725j), 
              (-1.9527426388322524-3.3123196973189257j), 
            (-0.33854672368802052-2.5255247588330958j), 
                (-19.46011806768642+9.7454835309794206j), 
             (14.616685901596654-0.084673071474836034j), 
              (2.7150547608564324+7.9928738172533373j), 
               (2.0265593668490181+17.664145289454595j), 
               (16.826764213735345-2.3901799181410777j), 
             (-5.1335405864751174-7.2936172785500775j), 
              (-6.6061509838085861-2.5814589195917059j), 
              (10.922914772447294+0.25919988616369488j), 
             (-1.3289096211577911-0.40290022227276168j), 
               (5.6744558160464917+4.827922936516444j), 
              (18.476501519355647+1.8528459045865082j), 
              (-9.7199371126109355+13.685872021020431j), 
              (-4.1038307524796789-5.0493393122027177j), 
                (-9.4460786525205851-11.3177494623167j), 
               (13.36150975353198+10.271928945280305j), 
                (-11.48917436153468+1.8909387475433226j), 
             (-2.5128467404704162+2.4271491696691667j), 
             (-12.497559228204555-0.64532416225133626j), 
             (-9.7780299818518372+5.1839149067723858j), 
               (6.6295780010992953+18.165939550280523j), 
              (-9.0121034211747517+2.8516873572158663j), 
             (-3.2885200898327875-0.14138627661298417j), 
             (9.0328475385953979+0.21025625239929674j), 
              (5.5437720036348948+5.0057953013135537j), 
              (-9.1606595680944309-12.516581937605807j), 
              (-16.893380344214187+1.4682520141063859j), 
              (-11.897691831703103+4.0183798902100989j), 
              (6.1323101317550597-1.5908884287222032j), 
             (0.69847508191716479+7.6550491678497963j), 
               (5.4136489349312527-6.1328669551053583j), 
                (7.4047472447391849-3.3759165476326252j), 
               (11.819410822908335-7.1590789285897349j), 
              (-9.3752205790523178+1.7668904985093004j), 
                (7.2651299310969009+11.194290345312048j), 
             (-15.999442828232631+3.2130086761880849j), 
              (9.5904913084911048+18.308807195694033j), 
              (19.773486251706633+13.962956772631131j), 
              (-7.2534289685221376+6.5062763422505165j), 
              (-10.849897845034178-15.211849147846655j), 
               (1.3236381477022474-4.1869510391204869j), 
             (13.792696577746648-0.62469093293561084j), 
               (6.6757139706543551+4.843714761783084j)],
       [ (-6.8033511151537347+3.7269473641106945j), 
              (5.7547663288743456+0.53147274040012982j), 
              (11.088835069565832-12.915415292623081j), 
              (-7.4194215154530205+1.6895874585323729j), 
             (-20.253753485958555-9.0517038513167662j), 
             (-7.1467231621969818+6.0633070088794998j), 
               (-10.011440338719421+12.29027537945505j), 
              (8.2483757121739778-6.3369661519295173j), 
                (10.76538628020289+17.379277153168104j), 
               (-9.4698367927314546-4.499901649229276j), 
             (-25.462739353492051+19.616407697600462j), 
              (4.1846680051766505+11.118702453762241j), 
            (-0.41522147256970238+5.9421060520881506j), 
             (-3.7733623803519456-10.876606247160455j), 
             (-7.3386625304765936-7.1626153938099293j), 
              (-6.5090843944213823+1.6087571218394174j), 
                (2.1820692919565059-1.7107269745824383j), 
               (2.2888192690277229-4.9803050867467018j), 
             (0.31200339682538969+11.138119670810379j), 
            (-11.065665359057849+0.04837600511910068j), 
             (-2.5557617838648876+2.2723187443559127j), 
                (1.5790231204182117+12.775274268817631j), 
               (12.523355743171249-16.347415393010241j), 
               (-4.3590852668859954-6.591383618130072j), 
              (-7.8435788237255064-13.534081081802887j), 
                (1.2606570298357376+4.7540162029714965j), 
                (14.046172779266799+9.548580661098665j), 
              (1.8720981377234218-7.9974874718301416j), 
             (-0.025896478739632918-7.9631305273840916j), 
              (-9.2327658358930638+6.5343543074941852j), 
               (4.9351584808755202+12.361589147305089j), 
             (-6.5003219290108323+21.358256653455037j), 
              (-3.7803409611663623-2.7269319945967618j), 
              (0.15140241234751797+3.2153111056232149j), 
                (10.673995913998361-10.85029106949515j), 
               (2.1948174240133298+18.073430336106398j), 
              (-11.375893860989496-6.4039915396012601j), 
              (9.8136227076438907+1.2689151484607264j), 
              (-15.51364241635579-6.8715647815365024j), 
              (-4.3013397473045334-6.1336690621247767j), 
              (9.5942099162582402-2.1751799750316687j), 
                (3.8609169855840624+9.4634264950534259j), 
               (-5.3857258226214615+13.34068788474803j), 
              (-5.5710677196002845-7.3944929664195485j), 
               (7.5488747291791904+8.7048070329876062j), 
               (-1.175059094285432+13.010543726033868j), 
             (-0.48042598531151104+6.6765508368807325j), 
               (-0.73286618114006885+11.93770155174391j), 
              (3.5655635563781267-32.218269991816079j), 
              (5.9627693773897441-23.333920043628012j), 
              (9.1842307065514852-2.9184990047556298j), 
              (9.6117259349029673-0.13682076460101586j), 
                (8.120732167350317-4.6938870050493984j), 
               (0.43779609760238425-4.6093795528158346j), 
                (6.968108808730344-1.2255925710168742j), 
              (-15.557994166250817-11.869923811136967j), 
                (1.6316423335936787+7.088867389901643j), 
            (-16.318305765138533-0.42671345390624604j), 
               (-9.7500868224346977-3.1514789986391349j), 
               (2.3940520696034695+2.4865888135549974j), 
             (-13.432896061009513-9.1986893507340799j), 
             (-0.66004405033379099-4.8519448939487386j), 
               (17.511960930803568+10.884325894483009j), 
              (6.3625433178834783-21.268232773205781j), 
              (-6.5111538879767394-15.046954997576137j), 
               (13.281947484228953+9.9499574289606532j), 
               (16.208300684414596-1.5930645948557491j), 
              (18.110917057262025+8.5823198621747316j), 
             (-8.9528006614490696-7.4687338970166124j), 
               (4.5248620144758807+8.2610786204786386j), 
               (1.9260698119661703+3.1155619409929765j), 
              (-23.570404805825195-11.296852418206459j), 
               (4.7912234312587776-9.928414551096914j), 
                 (15.398310158886023+15.12342922314672j), 
            (-0.46796769908637076-8.7498273231329069j), 
              (-0.36344289207277164+11.46448607305935j), 
             (-4.2365858056650296-6.1671535948296707j), 
               (2.5547145004078713+3.7039471844755933j), 
             (-0.90119947851354143-15.063755833652417j), 
             (-8.5790818591848286+0.87290475079964036j), 
             (-8.0246238142658761+8.8555029863161057j), 
             (0.49936079821420648+7.1892825600222432j), 
               (4.4119053772821291+17.467050044963731j), 
               (5.9387282813055418+1.1093869412060435j), 
               (13.089014831659952+11.725866677516898j), 
             (-9.1568742792098572-15.440935878381264j), 
            (-0.78127776557004769-10.019416088729642j), 
             (-10.833947941401657-0.57217630618377213j), 
                (19.912997129628877-2.1088267858240504j), 
               (13.620134899579027-10.606098923598362j), 
              (-15.835019550233124+27.773111663506871j), 
              (-0.92766872603406647-4.1117439213752878j), 
             (-20.976277440469989-3.9631391925787418j), 
             (-10.347804453159581-11.313287478361115j), 
                (8.401056965419043+9.657522048407829j), 
               (12.387209743547743-13.411150947529929j), 
               (1.9396505041250525-23.274890383542722j), 
              (2.9552348675315705-0.53826231441146621j), 
              (-6.069464689916197+2.3630379586105641j), 
              (1.0455170491630708-13.019232958217044j)],
       [  (6.2981550900639771-2.8864888252563898j), 
               (5.4917524124413593+1.7263525472980876j), 
              (1.4971552932003762+7.8472173775617833j), 
              (-10.003492893260422+3.8702098977775141j), 
              (14.487293270723651-3.4486724847689842j), 
             (0.47357791285964534-1.3677121313537577j), 
              (-4.3462594775544954+1.4019910226576542j), 
              (-2.2874641498524464+8.890835538500717j), 
               (5.0055528466322059+1.4633041735844512j), 
              (-4.1761635638369823+8.7588086948510853j), 
             (-6.1881225014240862+7.0577453465887032j), 
             (-6.4479007607529857-7.1498950435593054j), 
             (-16.177033622027771+5.0950936059367349j), 
             (-23.881072695626816+6.0608963488345946j), 
              (5.2808340884711154+3.1067286644356988j), 
              (-16.355518495626356+18.397893356748234j), 
               (-20.461642855990586-4.8844816360054368j), 
              (0.55329601297242015-2.7035570342962667j), 
             (-9.3911203622643562+19.085709891484942j), 
             (-8.7616140051163889+3.4963540640019741j), 
            (-0.37895689763007756+2.7262518758046146j), 
                (2.9663954800219612-14.599176305512094j), 
              (-4.9050865339598992-2.3518494697169969j), 
               (-7.588330239203767+9.2907739560026208j), 
              (-12.876067916906333+14.422594338584023j), 
                 (16.262641896723764-2.522522959691857j), 
              (-3.5989417509521715-4.9769038252131912j), 
              (1.7340325663830987+9.2063622692145746j), 
               (16.244339260015185-0.33775921971887618j), 
               (11.105594167871367-13.570632865058522j), 
               (19.756284484999981+5.5959656712445049j), 
             (-4.8448964074854803-13.250915685101601j), 
              (9.9268442077287045-0.11781335939397834j), 
              (-13.537496192294768+5.8709794790173406j), 
               (14.473982624764588+13.142755719032506j), 
              (-16.155363991467947-7.2589889035843598j), 
               (20.293089491883972-7.5331258225384436j), 
             (-10.538787832146836-9.5522302624680275j), 
              (11.988635482657532-4.5909488101113682j), 
               (7.2012164423480431+4.0485487932932465j), 
              (3.1574540404118627-7.1779031134646463j), 
                (13.459233928438319+0.2205347199262879j), 
              (-3.3689916620226446-4.3318981828123162j), 
              (-32.394428452757069+5.1868069631593059j), 
              (-15.151689744602631-12.805757183607975j), 
                (4.598006734528358+11.902972701878644j), 
                (7.689757357623507-2.2443958798102752j), 
                (-5.9848290411921221-4.208398276334659j), 
             (-7.6579675339103215+12.386688920725286j), 
             (-23.473415730823341+3.4406844927473696j), 
              (4.0512397827214945+11.729511633591054j), 
              (-3.1315561313362124+15.381997377036393j), 
               (4.2852255055415505+7.1548943626432759j), 
                (2.1037587034499121-7.9082626814272059j), 
               (2.6620231360006237+14.515054693792868j), 
              (-9.2893925915193272+11.104778126243781j), 
              (-15.044300795656152-7.8504980365526897j), 
              (9.2034588735013596-2.7807768518054083j), 
                (10.150871287309917+1.6897944154200406j), 
              (-1.7180247310955086+2.0797767154490683j), 
            (-0.33361732407093769+9.3332233033161653j), 
            (-0.098161210642656649+14.326563387602381j), 
               (2.9924341913540649-6.0925378001562009j), 
             (-2.4687322029778871-4.7568137927536052j), 
             (-3.3230476906445503+0.32946183880771407j), 
                (8.048808473686508+4.5904218482420518j), 
               (12.589557879359283-7.8436224664352654j), 
              (8.7357924032696026-8.0162007082606994j), 
              (8.9539490659061052-6.8456047110031726j), 
              (-2.9020182367275633-5.5748179716781108j), 
               (18.124051390605761+5.2619791313060773j), 
              (-15.317314755629063-10.052489979419459j), 
             (-9.5266136070625826-8.4521532676370636j), 
                (8.5362522672466383-8.0916182266938979j), 
              (-5.150011166852658-9.4322726704741573j), 
              (9.4209982584828182+0.19153753987862762j), 
              (2.1614247201517673+4.9265329330287981j), 
               (2.2167777249149805-9.3899139464629418j), 
              (10.19807417886328-0.014185788718556315j), 
               (5.2809378748869715-3.7638569048605568j), 
              (6.8038717057724849+8.0285178778357533j), 
             (-8.3723834970694444+10.994780543180172j), 
               (2.5724679667514949+9.7504424077089134j), 
               (3.2383179821643822-18.308853645461237j), 
              (-7.9207068305401371-9.7813330740727142j), 
             (-5.1408444246474669-3.4201596372219205j), 
              (10.163827962944708-8.2408260955058346j), 
                (-4.354284875804292+6.287414695260277j), 
                (9.7337741258065176+12.649200270105768j), 
               (1.8682796053902992+8.5746200403308901j), 
              (-4.6572872993664198+4.8810924518629637j), 
               (-1.0465739190816079+26.933089862800863j), 
             (-2.8217895997529356+2.2865604614613928j), 
             (0.65032897351985408-5.9206120834619824j), 
             (-13.055201421614356+14.452785354617317j), 
               (10.191139932005546+5.9371200969964955j), 
                (1.770245344156822+7.0211230313104176j), 
              (-7.6118095605805394+4.5701593297920082j), 
             (-1.2772920316722707+1.9533545194723745j), 
             (-11.959948073328155-6.7052581098144497j)],
       [  (7.6028746604353161-2.9724582816384819j), 
              (-13.753535842001563+17.367226720770606j), 
              (9.1017589536050618-17.769126652406189j), 
               (12.490367377756705+14.409878252891682j), 
              (14.605447784437629+18.536395631185833j), 
              (1.1244093132124506-1.8047632713514443j), 
              (-7.4226663804827799-9.7211623919135128j), 
             (-5.1710923116727887-5.6636237936520484j), 
               (11.458209184841445+16.677133064033697j), 
               (2.2752476592683588+6.4156039290901266j), 
            (-1.9507631993389341+0.86804402969956196j), 
              (11.346160453647034+13.377007986758954j), 
             (-14.840551339084442+12.325127185024144j), 
             (-11.178417311364983-2.4213148132988591j), 
             (-12.624480134196221+0.4529966086662931j), 
              (-2.5541641326511311-9.8752429934641324j), 
               (22.998205387756137-0.56315352459142731j), 
               (1.3330825707200313-1.8050540350298201j), 
              (-18.665805933787809-20.30006916112734j), 
              (11.460512719395544+7.0338408044045231j), 
             (-11.542440544277657-5.2642850766770977j), 
                 (2.353678952209004-17.153341877430805j), 
               (3.0712542139557373+9.8162419443501356j), 
               (3.2569726001607262-8.4890489669566271j), 
               (9.7652208903488535+6.7487024506030693j), 
               (-11.838359632913871-2.4496338770471553j), 
              (-1.5756039772045303+7.2645515029488941j), 
              (13.493419838471166-11.575887153637412j), 
              (-0.52188550552353818+15.163444361154134j), 
                (10.43396889644116-4.2825875358065888j), 
                (4.6706222683365723+16.39397487818762j), 
             (-1.0761289404498442+22.717361380841695j), 
              (-9.1621941145509123-2.3979582562908668j), 
              (-20.927379567804877-10.267203166212864j), 
                (6.961793294243007-5.5266106413546083j), 
               (8.7130130657643541-15.995055290668546j), 
               (20.212967602337315+2.9567930965417588j), 
            (-0.52367743889034024-10.011353546910032j), 
             (-7.0352504814457983+4.6060752595341299j), 
               (10.354737965917824+3.2809360008409398j), 
             (-13.892721330075306-10.854679605922817j), 
               (-7.6879566577560707-4.2486572685883957j), 
              (-3.1493816550019158-10.109404858714608j), 
              (-4.8828614393131113+7.8181269017877408j), 
              (-12.756755515698678-16.038653560586305j), 
              (-22.687653424938294+10.419302978900333j), 
              (-18.084307719470058-1.4860343718361257j), 
                (1.3269208905499541+3.7219191033645109j), 
               (5.1970434806042389+9.198461156215803j), 
            (10.516467973753912+0.055148867816258038j), 
              (11.874761859024918+11.405855401026015j), 
               (5.2191387780848455+1.2807962297623223j), 
               (3.9624670848848464+7.8635705952293558j), 
               (-3.0433143885936005-13.714458140383449j), 
             (-0.85206396259321582+14.286519707353907j), 
              (-14.789757595516393+1.8337833468267448j), 
              (-16.161528406409918-5.4748700296901545j), 
              (7.0004019614254878-2.4727115908330837j), 
              (-5.7081220239899642-0.41472164325495897j), 
               (17.934663730451334-2.8054121147108493j), 
              (5.5109760565696577+2.3159067993705111j), 
             (-0.51485386118330356-9.8419962740444458j), 
             (-12.328347488864292-0.87912668824281348j), 
                 (20.27788459374317+23.1396807244301j), 
              (-2.2046925003793665-20.866992829781886j), 
               (2.7263687000955295-2.8439260988591943j), 
              (-9.5976564034524863-17.200594309404028j), 
            (-3.4840482055945605+0.99119967937685793j), 
              (2.4901334933244237-10.311592900258104j), 
                (16.926030484623261+15.44983327335671j), 
               (13.250740211505761+24.528808939119141j), 
              (-9.9547724733535272+6.7267193789038124j), 
             (-4.5393982069315673-4.6990190003484118j), 
               (-5.2642827762261515+9.5369028127548177j), 
             (-11.203036246402966-4.3528298613369074j), 
               (-4.5328032382314039-0.710798264916781j), 
             (21.427744505484419+0.13792421353792805j), 
               (9.7866968771946858+4.2011930368494541j), 
                (6.2913002457460045-1.961479975461105j), 
              (-1.2590473160545221+19.266089921228364j), 
             (-13.757885809198598+6.7829793052742264j), 
              (-5.498423911459243-11.419575193599947j), 
              (-9.8434247188548234+1.4346701390796355j), 
               (6.3744450124390344-16.663605687260905j), 
              (10.770335174026442-0.41592813720775923j), 
             (-2.2835230215745184-17.804262843970079j), 
             (-9.0408346694536164+1.8868211805278814j), 
               (1.1189814961599691-5.9495963550669071j), 
                (11.487664952943344-1.8210352003526471j), 
               (7.5745725143889757-18.478462057019357j), 
               (8.0742967482088464-3.1470978158844947j), 
                (-1.8801853543875877-17.20697816857669j), 
               (7.849840493671957-9.7028388215795562j), 
               (10.82612708764556-5.6034860370916473j), 
             (-10.081190814287478+9.7519985537414495j), 
               (5.8421160600264308-24.711888519939798j), 
               (1.0548184659707962-2.2498004956290916j), 
               (18.222725025578544-3.7550779043217579j), 
               (8.8180328983689282+10.59249825483281j), 
             (0.47231594722822523+3.9352132143495306j)],
       [ (-9.7301335030299576-18.251367286145758j), 
               (-13.00088927721244+5.3710012510642731j), 
             (-5.687868128777323-0.58706997096436853j), 
               (-15.955953429459964+15.17617737859084j), 
                (2.90234065978568+9.9705378089877446j), 
               (1.4082278244448618+0.171722516496221j), 
               (3.0811733165679382+15.454488929010457j), 
             (-8.1696181355259245+10.638646368994571j), 
               (3.0181843761369964+2.5882449829767387j), 
               (10.002454837171701-6.0481878199624584j), 
              (-13.49191520783635-2.8875343389188926j), 
              (9.1719754430786651+15.410752085957116j), 
             (-2.3819204307211956+12.167235540064738j), 
            (0.014036008674812583-18.078958857826876j), 
             (-19.491293458201646+6.2253474746511586j), 
                 (-9.20102599698596+1.110507690926287j), 
                (-5.9011636210016523+2.507180826091671j), 
               (19.319647874765973+4.7077761157633109j), 
             (-2.1512341507742523+9.6151001537106335j), 
              (10.102667889991801-12.277284193828681j), 
               (-8.06443334511372+5.0589007372202488j), 
               (-14.322265442491318+4.1417864559198883j), 
              (-8.4439170354871944+1.0634655124966454j), 
              (-4.7963882329319611-13.649827427297884j), 
              (-7.5893024347063207-4.5296257861519198j), 
                (12.306037866127673+8.5958407892781619j), 
              (11.421519328896245-0.58881329814165884j), 
              (15.040477534934386+16.304690256013874j), 
               (-0.65878156166123736-2.902724193498436j), 
              (-3.2774502620016168-7.6692720084202115j), 
             (-0.60339314181870352-11.737906940500531j), 
              (9.6865355977863068+7.1448866505344331j), 
                (1.1931534489894613+7.953277616791202j), 
               (2.5817479663493774-14.503292060161456j), 
               (19.807534000086825+5.0552601501245942j), 
              (-5.1606525530893519-1.7955811787912601j), 
              (-3.6366011197024397-16.660235965225542j), 
               (15.69096795440988-1.3453541521599801j), 
              (9.6773779274169911-8.9547063172033408j), 
              (-20.543952489662701+5.4441627392033194j), 
             (5.7384155985138943-0.17535857977910838j), 
                (-14.43258396193324-12.151260895707752j), 
               (3.1297473905319642+6.8206363104229819j), 
               (1.8884051174273795-5.8300115794397787j), 
              (0.64399476646701981+7.0720859484906109j), 
               (12.993013734123995+12.836810851066399j), 
               (1.9472676043942092-5.2737538428576443j), 
                (1.5047132535591463-20.594634720088361j), 
             (-8.0250666253015197-7.3363817990097466j), 
             (-15.925909174035509+16.054024211557923j), 
               (9.713706161332837+14.395617381972297j), 
              (-6.5134901619628183+7.4762121974882572j), 
              (-1.0620527891468823-6.7013300019411002j), 
               (-6.6695574085585987-7.8137323544541362j), 
               (7.9192067406934825+1.0034265357298124j), 
              (-3.6535786321970622-11.148584039321232j), 
               (4.4569101182469701-4.4434184439445836j), 
             (-2.7047128263121749-12.385675602486518j), 
                (-14.153626416395973+8.276650865326836j), 
               (2.6534722103417856+5.1769158647553564j), 
              (5.5149963347654749-10.586268698722749j), 
               (14.840302509364873+22.333066579971316j), 
              (-16.346107001506471-3.9363584027628127j), 
              (6.2354094097893693-19.778633095813397j), 
               (12.398205694740463+2.4679996186416222j), 
             (-0.83477230836280392+10.722543376292764j), 
              (-11.905120326865859-4.6672669122297057j), 
             (-5.8414231669989691+2.6361760435423398j), 
               (8.7826155758998397-15.69277888987186j), 
             (-5.5767310211042194-0.51260184091838168j), 
               (-6.762511333361017-5.1292667416854618j), 
               (12.340050506327444-5.8922065690949035j), 
             (-10.213620099467022+13.720950472754637j), 
               (-16.076660361942857-14.151257523715699j), 
             (-3.5570903307740416+5.4229281809778591j), 
              (-5.9565216466395645-6.6316252529581865j), 
              (5.5725231258791252+2.9825792559292714j), 
               (2.7300869253318676-5.8051021529124487j), 
               (14.905046171219565-9.9753968584222683j), 
              (-8.8604515668895587+6.2008690650489839j), 
              (-5.6743289207337257+8.950680313152894j), 
              (9.0037146156729015+6.3937432285620446j), 
              (-12.311544126026599+3.8111702991483662j), 
                (6.9198656232877651-1.986880166837268j), 
              (-2.2269802819042508+7.4857221070054312j), 
            (-11.498325607112461-0.90133186580163682j), 
            (-10.175807798484435-0.47523578486296408j), 
              (14.144941618909446+0.19458523068498779j), 
               (-6.1433077870702579+7.7393317217472752j), 
               (15.568476038563531+2.7709881990126748j), 
              (-17.379199384655884+2.3589350697945579j), 
               (-16.931927284131323+24.297732814025061j), 
               (8.065195217605881-3.0017995254119159j), 
             (0.14485707349862773+3.0337000314238534j), 
             (-8.1765132420577125+6.2839187062529067j), 
              (-5.1898452194353517-7.1131494179716137j), 
              (-8.3041116227274934-19.396848218833206j), 
               (13.953172867818695-3.0000415896021431j), 
              (14.063792772836015+2.9934551416938078j), 
               (11.55788870145722+4.0194421618342417j)],
       [ (-11.597338299344903+1.5185323148159358j), 
              (0.79782491260978872-1.8997593457115922j), 
             (-3.9072967802597551+7.4514113221546561j), 
               (3.5084621377584129+17.999314844072131j), 
              (13.054838249622749+6.8994650354521516j), 
              (16.297100223587201-2.2093383832071489j), 
               (6.3160892206447947+14.268538907130999j), 
               (3.550262228961734-3.5719148573862642j), 
              (6.3996657849644816+0.55133119660771601j), 
               (10.473619418288745+11.288051341892057j), 
              (13.639312891934683+18.088688518194065j), 
                (9.93494930017361-1.5295975837234859j), 
             (-17.152837514297342-2.4315899693614105j), 
              (5.2166455684607902+17.400299181426693j), 
              (2.0948063992558792-5.3270577590279613j), 
                (3.433487507120176+13.715552188429152j), 
                (-2.976064617583611+2.6249670411934694j), 
              (-5.3078942478857405-17.422678163219462j), 
              (17.132842552597435+14.963897492884232j), 
             (-0.88359308490308541+21.10342961647526j), 
             (-3.9125508336215233-12.941212967346798j), 
              (-0.11611260466083941+14.031069889630118j), 
              (-11.131891426264591-1.8653060474709957j), 
               (14.939986699514831-7.4125382664668322j), 
              (-5.2115743231888647+5.8447154594453572j), 
                (-10.96613667374273-10.052536190794426j), 
               (5.8229516399804737-2.6591711405321874j), 
             (-30.620652640442859+20.271612520727601j), 
              (-6.7923177291056094-0.43132482385010928j), 
               (-7.374629114895864+9.7421076169062353j), 
              (-5.5434884895748642+5.9248592788352825j), 
              (-10.53091612391915-3.0602083604669157j), 
              (-3.3432287800239804+6.4316961602199729j), 
               (2.7604694862103329+11.206633815096719j), 
              (-3.2586628351341265-13.709932994538178j), 
                (3.849669245325988-5.2227797123113611j), 
               (13.964249066208978+6.5866147240358259j), 
             (0.91745474556959861+14.789505904213353j), 
               (11.65422728205651+5.3635400291788837j), 
              (-8.5367640626680252+10.777852341531148j), 
              (28.895150897265896+3.5482173420460557j), 
                 (9.9740181355954771+10.61216847318388j), 
              (-6.4332421266106943-8.5819127031367319j), 
              (-17.270756187424464+3.7408208968413215j), 
                (-14.34544653963939-13.52356231860078j), 
               (8.0469174675062973+1.7594647401015182j), 
              (-9.1379669235419811+2.6685422938506553j), 
               (-13.702666309256843+3.9463796966018045j), 
             (-3.4690418471103945+21.225317327219027j), 
              (8.3170626965965369-3.3224865937460404j), 
              (3.4518012208835822+10.489655601311149j), 
               (24.094938055442867+3.8488787149111321j), 
               (9.5804209916835177-6.8223900997379374j), 
               (-2.1558260652515191-7.7609834063879486j), 
              (-14.500986153724632+12.132731490649691j), 
               (1.8999517580150482-1.5548132076816059j), 
              (-25.541013715779052+19.963066964046682j), 
             (-1.8497619639326395+15.056956411018101j), 
                 (8.6505020091612579-7.143732752547578j), 
             (-0.28964210173539234+14.259192008177104j), 
              (9.2649595507174336+6.1850475455959577j), 
               (-7.257305045171579+11.518968137578256j), 
              (-5.7492860279514213+8.7707470920986736j), 
             (-16.857396514834576+4.7704127975727015j), 
              (-10.822922494205958-17.709757298325826j), 
                (7.964752061760664+9.6038685108735411j), 
              (-2.8790253906696917+16.486844838311537j), 
               (17.70060799632849+13.338577176317683j), 
             (-7.8366363949734641+15.935164194867825j), 
              (-6.0076055746772949-11.116481163150498j), 
               (8.3578957117020796-12.415275771948593j), 
              (-6.6916070254793469-8.0699157914032948j), 
              (-7.882952902076104-16.844147281653793j), 
                (1.3041885895013277-1.1544723989997581j), 
             (-6.8031034325043329-10.780305432646548j), 
               (4.2852807118584266+12.936961056139939j), 
              (14.303257422875886-4.4910813609309805j), 
               (9.2245528507673082-2.2859518225547033j), 
               (31.552749948175457-10.182766059070287j), 
               (6.6325569489277836-9.6641155768382365j), 
              (8.8622799443195248-10.367200932215292j), 
             (-9.5856002684473047-7.9930538853986661j), 
               (4.8590920833155868+26.063638660906548j), 
               (29.802993787554545+12.208423725856118j), 
                 (6.47637779450812-6.8222015738833974j), 
             (-4.2876342445272337+3.1135459250269379j), 
             (-13.822957145976851-2.4676325020154892j), 
              (-13.506140022353591+8.3866197719794826j), 
                (0.24366919452428676+2.851572165796215j), 
               (4.6321057078059669+1.1914753685794204j), 
              (-9.6105412698814376-1.0605831550121272j), 
               (-1.1044650622305234+15.887065213844327j), 
               (6.967855013562021-29.748418648574951j), 
               (15.739174893615385+13.36229783304162j), 
            (-0.20866647565801547-11.341098864604904j), 
               (-9.503316972028891+18.232243301000686j), 
              (-18.007569379609606-7.7661391955375683j), 
              (-6.0744250312387793-4.0417023596555453j), 
             (-6.4111814569527956+4.8793364454764765j), 
              (1.2034889494407282-9.9802581129873236j)],
       [    (9.830378460487502+10.27303208982385j), 
              (-11.452613471291077+17.016532751417724j), 
              (23.098049153568191-16.491518332257449j), 
               (6.7083468833994342+14.307675135336343j), 
             (-13.186046111697166-10.497466913194023j), 
              (6.2103145520736716+12.551778250291992j), 
               (7.7571994348136961-20.302042729283798j), 
              (4.8324490055090896+32.099887482154173j), 
               (-11.78216948883758+4.2081107396755453j), 
              (2.222112236315763+0.014365760017161791j), 
             (-9.6963199852526536-16.337715748936894j), 
            (-0.11222383500570704+13.977280196590344j), 
             (-3.6674922997161987-1.9661703420736762j), 
             (-8.8255721857326304+7.8533395188496709j), 
              (6.2287376736637388+8.1265224557689706j), 
               (8.6173847282368996-8.6282581135041774j), 
               (-5.1745521592476615+16.925659031968301j), 
               (7.4730924564636902-10.400531961085107j), 
              (-23.76217980987974-8.1266438189956887j), 
              (14.360384483968854-2.7107098721863041j), 
              (-1.2938714585664355-11.06213033004363j), 
                (13.302652667943011+3.7366919734252675j), 
               (18.775535562454337-2.4293528346686517j), 
               (7.7905086728576913-1.4888720110439266j), 
                (-8.336333706405382-11.64050009568056j), 
                 (15.885406887814389-25.57553333480849j), 
               (24.405031297183491-7.1283673909562797j), 
             (-9.5235862880151352-21.400655203917186j), 
               (17.634033006854153-0.51452702580909548j), 
               (-3.4034057398098323+11.23620825326827j), 
               (1.5792995759740114+7.4385760357172774j), 
            (-0.92550076244710056-5.7210311771866245j), 
              (-4.3595340171947745+3.0687132304805802j), 
              (-5.5950453376301335-9.7150525360405702j), 
               (13.406883177488112-3.2473298781593742j), 
                (6.528679296084797+4.9322715413145763j), 
                (11.23783952284654+12.183039290495115j), 
              (8.6649852670692908-2.9002825797186222j), 
            (-0.94925651988941084+10.330473685331272j), 
               (7.7768921835339624+7.9754410767486403j), 
              (7.8503414167840022-14.457417951305022j), 
               (-1.9064076936055321-3.9347790635029876j), 
               (-3.293671863940169-14.272904865815876j), 
               (8.6218314265648814+17.262184442420303j), 
              (-3.144022584873305+0.22041439563969445j), 
               (5.9038445534719823-10.375926082425046j), 
              (-13.707181641533774+4.8981930037767718j), 
                (-3.6780562536277066+15.29307563884503j), 
             (-15.529341372276582+4.4075686897467694j), 
              (13.396686582925314+9.2373245590560042j), 
             (-3.2221812758525319+11.555100343354461j), 
               (1.8190341304975086-2.1504596119693975j), 
            (-17.129119103120399+0.091448102263447378j), 
                (19.916716220574038+29.091512864093797j), 
               (1.5610748214463293-3.1932307439198286j), 
              (-9.7417283883544457-16.402154773707071j), 
              (0.85558057797292963-8.3937723835975131j), 
              (2.1778242014175717-16.558401402139367j), 
                (3.0208011286903815+11.359958453551959j), 
               (3.0556648951027885+3.9089289929869526j), 
             (-6.8414438281525047-6.5619304198726116j), 
              (0.95685395393900097-12.220326532996841j), 
             (-0.91750363101875332+7.1497769536037978j), 
             (-12.256492021329045-12.012442338420136j), 
                (5.927203831391811-5.5618545915574984j), 
              (7.4850725133914073-0.10606494774397589j), 
               (6.7411364719311333-10.535576687154013j), 
              (3.6827178729353345+8.1389020929229225j), 
             (5.5904714016825485-0.72810649569535146j), 
              (-7.2097553625495312-7.5127039091693639j), 
               (-9.969693716286498+7.2303218920615802j), 
               (3.2452346313252285-12.313304681854728j), 
             (-5.5982007013979782+15.791709663443891j), 
                (15.150580271676596+17.135716502855789j), 
             (-10.587959393010403-2.5779878432274583j), 
               (1.0135016048125607-18.758285254033339j), 
            (-0.41691934241690287+25.081014588991675j), 
               (20.215265789691518+7.8523755525831609j), 
               (5.7114516675418914+8.6636903861609245j), 
                (1.979359310513862-4.2047780745239134j), 
            (0.021262916527944337-20.959505374985699j), 
             (-27.322304723310001+2.1920208168205084j), 
               (7.9189117388478136-22.827504313938949j), 
                (5.217592282679318+7.5979520149659887j), 
              (-11.596433270998407-10.092575692041795j), 
            (-0.28165451457375051+5.2239015798874995j), 
              (10.924927870241696+15.703604475849811j), 
              (-4.1965390523770605+7.1676771861078485j), 
                (7.9972546679161685+12.181751119193738j), 
              (0.34896484417616447+3.6793250580893657j), 
              (-17.424793942082466+13.798566764403846j), 
                (8.1545300565702803+6.5487347575920429j), 
             (-6.7149677048667522-19.095704601101975j), 
               (15.601919491285567+7.762310698111996j), 
              (1.6636469495085182-14.873771146712937j), 
               (2.7220052116309326+12.294233509785473j), 
               (1.5834460907364725-4.2906206583380166j), 
               (17.938334596081617-7.0885004343956437j), 
              (10.052207368351935-14.747237468844403j), 
            (-2.6648709773755468-0.44393376972124621j)],
       [(-0.90966232019485993+4.6775242578100524j), 
               (4.0849163511756412-10.562326402437819j), 
             (-6.6834314080990396-7.9904213046489536j), 
                (4.936218409500678-12.184603834533796j), 
               (-10.65281442017195-9.110878870271117j), 
              (16.105740268496184-1.7573747777466528j), 
               (-2.665663359377255-7.4989039520443201j), 
             (0.52220830632313764+14.629903292998971j), 
               (3.1280291068516135-11.745639599994595j), 
            (-0.019733407856301989+3.6563237781672493j), 
             (-13.841568527059074+6.5035219382955392j), 
              (-6.7635149337815994+4.384623243689366j), 
              (9.8861127096358032-1.5466037412098115j), 
             (-5.4377036264485499+3.3442552000990071j), 
              (12.154928180976853-6.7862107820164841j), 
               (3.3705870322388516-3.2344838463711105j), 
                (9.3796149277669034-7.9606284344940477j), 
               (16.414100510974947-28.235681824333628j), 
               (0.1897847263020695-2.650509349561796j), 
              (3.2947869230469933+32.364511676199676j), 
             (-1.795230483121637-0.28675635548391387j), 
                 (8.514027130052904-11.840674600642187j), 
               (10.200034358381167-13.092657255804221j), 
             (-10.225427722819536-0.50625433131496056j), 
                (6.055078833449449+6.7052906278432296j), 
                (3.8202954766687354-18.526641408939728j), 
              (-8.8121018940454778+11.864529230234409j), 
              (5.8626024338358231-1.0379643841964943j), 
               (0.58806041869868253-6.7454114124988163j), 
              (-3.6434766831699732+5.5501599644399526j), 
               (13.917270310613771-15.872023678556236j), 
               (2.1376916269254038-0.884335639516453j), 
              (-10.216840944632771+3.5290000633756975j), 
              (-14.358832677958022-0.1067859828194786j), 
              (3.1553588512481938+0.25553777198503669j), 
               (3.5576606654344229+15.568006665532184j), 
                (-2.5960815190589455+4.11409011011615j), 
              (21.069765136924939-2.2628627419674738j), 
              (1.9697725838017845-2.1147133214941864j), 
              (-12.781963863297905+1.9286178789463309j), 
               (22.702082382761652-9.545364113899744j), 
                (13.663993630609605+5.1760331997499174j), 
               (5.9583579634837749-14.386674207052097j), 
               (-5.913565668474428-4.5224132026976118j), 
               (3.3516917989044757+2.9382627698198815j), 
               (5.7870349819758795+3.2963920753299858j), 
               (1.9652483572420043-22.045333594035085j), 
                (-17.597495650882585+5.793951170561126j), 
             (12.937614291853603-0.14840218244856826j), 
             (-1.0174042432553818+13.139376605995993j), 
              (2.7339556617421348+7.8118215953196968j), 
              (6.9522644968612894-0.23272491249374477j), 
              (-5.2167236922946367-2.2254707601689057j), 
                 (8.3174538201184305-10.83179469059205j), 
                (7.668010845080663+12.846357564508214j), 
               (1.4263682429895284+8.6727657726107452j), 
               (4.7326769121888441-2.6084435940286572j), 
               (4.5098341623053679-19.64769215371755j), 
               (-11.169767758979106+8.3328992329451186j), 
              (-17.033567849992124-23.512223981864992j), 
             (-3.1597158483903032+1.4113516176760397j), 
               (-5.435661644453706-13.055794611578138j), 
              (0.95903396042237343-3.0684917186335383j), 
              (10.054171005884847+16.037035044566146j), 
              (-5.4544005685597652+9.8404792467986759j), 
              (-10.793798489582652+8.2857512744054667j), 
              (-4.9971618771439736+3.3029909200003926j), 
              (-9.756000448215584+1.7124570033979625j), 
              (5.8147788333917898-6.3824176916257427j), 
               (4.2328391598802018+3.7452144574687414j), 
              (0.64992791327240329-8.4102999386747772j), 
               (7.4049717054486317-14.061211556918327j), 
             (-12.355233712586493+7.6527828288887099j), 
                (-17.47562602292977-3.9799075167167568j), 
             (-4.0757277878877964+19.501364178563048j), 
              (-14.694132398876739+14.785673697619499j), 
             (-2.4658528444362764-8.5952677085103844j), 
              (-11.550207646639322-6.9076320086595677j), 
              (-16.015881088284271-13.544504544180073j), 
               (16.240290347358972+12.838944702740232j), 
             (0.16053673259459283-6.2368137326221653j), 
             (-5.9961439584164875-4.8596794149584852j), 
               (16.611499172779723-20.740775835360207j), 
              (-6.3367525127992543-6.6358599688237518j), 
              (-12.782631762850617-7.7368419752763007j), 
             (6.5924270806677443+0.67675045860836003j), 
              (16.754766693585175-7.5214979868238263j), 
              (-9.7656332565979334+2.1814167982037671j), 
                  (6.600880359903007+3.963727644593154j), 
              (10.024908136769533-0.89510121406185916j), 
               (18.268286578096351+1.5052769166396356j), 
                (27.760629161451618-8.7627540678293663j), 
             (-4.8880096631014567-3.9934894884534735j), 
               (4.4872365391529829+3.643193003665786j), 
            (3.9616318161698301+0.036339675735570898j), 
              (-13.987786152763427-5.9511900069783108j), 
               (-6.9578584804219901+1.408779380201878j), 
               (6.5955900085510599+9.1428535391648182j), 
              (2.6564682091830627+4.6197239288464012j), 
              (9.7322506077596156-4.2254323787136281j)],
       [ (-1.7199219826793124-26.929149419568578j), 
              (-7.7232114118603263-15.009299264687215j), 
               (10.134051380620946+11.20962994544378j), 
                 (-14.997832843431+5.1536487389606647j), 
             (-21.612005097850755+4.9494560102447833j), 
              (8.8215189954125357-16.344578751847965j), 
              (-15.282995809618107-3.6667030953484359j), 
             (-2.8770078672793344-3.1592509395801596j), 
               (13.627488400152588-10.928610819107718j), 
                (13.890928010184791+4.702332120560893j), 
              (15.029647434116429+5.9853576389699894j), 
             (-11.719416204605675-9.9855729081878923j), 
              (16.271797946721176-4.3788246378172611j), 
              (2.7001063401066681-17.881358069158328j), 
              (19.852147198862514-4.9723749520554641j), 
              (0.58097314843203052+4.4771011790733102j), 
               (-14.627719976927011+15.353904911514221j), 
              (10.824680309798062+0.55580068080743195j), 
              (10.092447780495462+3.6562195611829114j), 
              (10.419904284149533-8.4159013064773642j), 
             (-12.599565034513873-11.407357582185568j), 
                (9.5111679899103656-8.5792259137486688j), 
               (13.540901424522602+19.392336027473796j), 
              (-13.215622474802132-15.180141942128733j), 
                (14.736997459404225+9.415978629460616j), 
                (8.8192256597890974+5.5962963526672818j), 
              (-16.331779003288691-3.6408025437122715j), 
             (-1.1754890073858788-6.0040659908781855j), 
               (-8.4604210064685468+8.2918378230104484j), 
               (1.7581750917313974-3.6041207079476871j), 
              (-7.0997324627453597-4.7208270326442019j), 
              (5.7733775103027245-7.8631607180591443j), 
              (-32.846057218412653-3.3133895741591708j), 
               (9.6439288914605967-6.9969104803312483j), 
              (-11.500822653954724-3.3342836878326421j), 
               (0.89711010603183938-10.97344100954018j), 
               (18.291405646117163-12.989068504899494j), 
              (-13.47825797318098-19.670192879372379j), 
              (11.741779814920408+4.6265987491264973j), 
               (8.3030420365727782+8.3601229977291762j), 
             (9.6730024484101804+0.75700743859592579j), 
                (3.1954979947729498+6.6659735837784631j), 
              (1.8007729012766349+0.31211226276702636j), 
               (9.9942489846199845+10.596203584319344j), 
                (11.90000804562394-6.9715970050325584j), 
              (-8.5889166304654552-6.2511866506976945j), 
               (8.5476565264824735-14.439718394559938j), 
                (10.049587088283925+0.8496832421944851j), 
             (-7.8848245712020688+2.9445359057970206j), 
              (15.289078781764552+13.412351306112694j), 
             (-3.1304760026582521-17.403724257384869j), 
              (-5.2626565203102382-7.6674676970711744j), 
               (-5.722775711752476+4.7126251690297165j), 
                (5.3902685499725544+16.063501857814899j), 
               (3.2936782125434227+12.314651467204932j), 
               (3.8247830764949087-8.1819535688834364j), 
               (-1.0964434973387944-3.680551659618617j), 
             (-6.0777299128469906-14.049583297602302j), 
                (3.2177960887635204+1.7505649437274087j), 
                (1.683397346221895+8.6902379263981029j), 
             (-15.706954041287812+20.032197803754208j), 
                (4.2956626489171921-11.90570935661688j), 
               (9.5427250124894343+1.7086964831843963j), 
               (2.550071401017648+9.2121278085380816j), 
                (6.1181334004110974-3.124878819128114j), 
             (-16.064586337536802+0.74511697420457956j), 
                (19.389065390882301-1.143741254243239j), 
              (1.9554354104105196-17.198913995775381j), 
              (-6.129818369557432-17.510820950687723j), 
               (12.889783925949555+3.6807422800995266j), 
              (-13.034320274409495-6.8161776933024072j), 
              (-2.4434311478763506-11.418817102148804j), 
             (-1.5251184522125414+14.065929270771733j), 
               (3.5749199379465884-0.62099763130725683j), 
             (-11.445181800514741-3.6598650040862908j), 
               (30.819826462693843+24.392723663526962j), 
              (-1.4025685486562702+5.671846440217621j), 
                (4.057250790739106-29.673579509376982j), 
              (-2.7058675304545519+18.201223415037319j), 
               (13.641355541427707+5.9188363738592962j), 
             (-5.7564831397432048-1.2780908738062855j), 
              (-20.821366649891026-6.255480037447966j), 
               (1.0169954385197526-32.575691581105858j), 
              (-8.0096098507420983-9.5537069628190725j), 
              (-25.949177496932194-11.094131648171317j), 
              (15.109851245326949+9.2073833852604707j), 
             (0.84291459251399226+5.8590004265516162j), 
              (-8.4687774661561921+1.1302971043758827j), 
               (-1.3853162608987792-4.5516084894424909j), 
                (2.4422798813196316+9.882899704130141j), 
              (-8.1158885854839866+7.5934522870116092j), 
               (-10.448189635873623-5.6548834047294712j), 
               (6.3009263353751512-3.922549445708523j), 
             (-1.4183319676275978+10.121424308760709j), 
             (0.24573350050560497+10.703959179024615j), 
               (7.8863616816871351-6.6482004106060879j), 
              (-1.7816980198420533+1.3193846591573097j), 
              (-7.2782258229074257+8.1335893970338873j), 
              (16.735334546184355+11.338009527232957j), 
              (5.3479416481376107-13.337379900101302j)],
       [  (-9.1744810021097418-7.267197627704336j), 
               (3.6043164552587448-2.2401664169651361j), 
              (8.7683755872484355+8.3015746021858821j), 
              (-4.9280298083652898-4.0460284610053536j), 
              (3.5476810497275189+14.791697980581567j), 
             (-8.0499788965281525-9.2089511230791228j), 
             (-7.3743937426394011-0.56086297962154275j), 
            (-0.50509889034688404+14.816621964040113j), 
              (-18.093964660639013-11.811875809074204j), 
               (10.066090578446554+11.574185768840547j), 
             (-0.2414490691096394-5.0001011400014574j), 
            (0.075828778071073161-4.5173671432635647j), 
               (5.528868086477301-15.859336759283352j), 
               (2.221129533696403-19.681033771181539j), 
            (-0.45326553763253208-9.2303492194889749j), 
                (8.281590794947979+1.6207603373147674j), 
              (-0.31983908461866317-14.474659087262117j), 
              (-6.2463614624363428+22.707225975762459j), 
            (-16.694408501744118+0.27305984906496822j), 
            (-1.6470633117369524+0.42131046130829197j), 
               (4.0534360451014093-5.216868342446455j), 
                (9.4064131633065085+1.8539784712867391j), 
              (-23.696432529306684+7.1168814458590992j), 
              (-1.6572778857346815-30.821718471594345j), 
              (-7.7482717672785908-3.2150295370876849j), 
                (6.0472873429731333-5.5464485443499196j), 
             (-0.51703137774611474+12.143127056823994j), 
              (-4.179254725337155-2.4881287895886746j), 
                (-4.5122066726592793-3.155767449172501j), 
                (5.4743928512650601-14.11073755023234j), 
              (0.88938068142804783-13.314435222571987j), 
             (-2.9736874298307687-4.2621313642688143j), 
               (14.896109102543136+6.8063608356512315j), 
              (-18.914917327545645+9.4461319206527978j), 
               (5.3554671335060098+1.6862904926235327j), 
               (12.680244661687228+10.950105171639677j), 
               (-9.9370460451425799+2.186928337704769j), 
              (3.7489242792961743+15.238533730472948j), 
             (-6.9582121630581852-7.4462543009254389j), 
              (-12.497373925375904-15.667172459656094j), 
               (12.19058411841579-4.2484003257511018j), 
                (5.8065275189542902-2.7077419223768535j), 
               (-3.058370029100574-6.0368735536474727j), 
               (2.3940078774027858-10.263751663377327j), 
               (7.4879772911035456+8.1639302946436718j), 
              (-19.998215240965401-4.8056984747948057j), 
               (-2.190751923058369-5.3252485810772772j), 
                 (2.8206236426623481+15.00588793422555j), 
             (-9.2147091333090021+5.7486750070736079j), 
              (7.8687221238834191-11.894459515225755j), 
              (8.0377365013353668-1.8658788094592151j), 
               (9.5280023075301479+17.486914242746586j), 
              (-5.8258745716442597-3.5235381221379765j), 
                (11.862471994986182-1.2509443679897878j), 
               (-2.6099067293185629+4.727429827472811j), 
               (5.3666999775549451-8.2127893151617766j), 
              (1.9546655203138872+0.88174325303095824j), 
             (-4.9915933621795716-7.2510372009403774j), 
                 (2.6525032784440477+7.101477277668323j), 
               (8.1267671244517175-4.4244658805885537j), 
              (6.8692722559709329-12.022723307816932j), 
                 (10.7156824238719+9.2532608139809422j), 
               (6.1268959556834428+3.4227485384393148j), 
              (12.867572738777826-3.4450972547100815j), 
              (-21.068683439567344+4.1492282324475784j), 
               (8.2840829013019146-5.0845799777884384j), 
                (17.53319360837618-10.070235177187165j), 
             (0.13241945333676514-1.0739129879845379j), 
              (9.3418922724217985+0.6612391307770018j), 
               (13.978057718634748-1.4081873333718775j), 
               (-4.7921536102522619-5.930541092774682j), 
              (-4.8711268441561586-15.216519306041349j), 
              (12.044692930982082+27.419877319406488j), 
             (-0.086976282460744486+7.0618906012073364j), 
             (-11.864708874591214+15.500013058052268j), 
              (-5.7401903865891226+3.4906764054559787j), 
             (7.8800742844579208-0.32094256574192748j), 
              (-3.7048911701584082-10.911263435782125j), 
              (-5.4878840848901476+2.8662745911558569j), 
             (-13.793989644078641+0.50268227642774554j), 
              (7.2221834847140283-8.4833114218959373j), 
               (8.9252905522856825-4.716844954704035j), 
              (-6.5338675065491039+1.7150346826116858j), 
               (-20.06149498037221+2.7606661111021893j), 
             (-0.017318225427831315+9.610282598603817j), 
                (9.261677650257603+6.285711105439777j), 
              (-5.9001397977771539-6.625946397133001j), 
              (-8.6642174431919088+6.0817302053541455j), 
               (1.3351755853457066-0.66433214207024904j), 
                (7.4745005162042188+4.695086208533211j), 
              (-11.577742673330064-4.7663928412516618j), 
              (-0.33181537585734949+7.2994565044284911j), 
              (4.2728166533211107-4.0646630930837011j), 
             (-2.8539831531640942-9.5499106472064774j), 
              (8.1053802418458254-4.9323721855838869j), 
               (1.777663702824781+0.50933955231143568j), 
              (-12.989692470611882+6.9611125415574371j), 
              (0.81311630644636934-3.1450971857741234j), 
               (17.403596334011183+4.684207318134451j), 
              (4.5194518215047017-21.433706343773927j)],
       [ (-1.4549377262711354+4.9093895227619404j), 
                (12.477788361247921+14.23672754345386j), 
             (-13.102968282716304-6.3130013149369635j), 
               (5.0464641751912929+7.5771708281165786j), 
               (11.32305643970094+6.9127371710338288j), 
              (5.6549927989101363-3.5587984324359647j), 
              (12.061410836707363-0.83800986452803039j), 
             (-1.0241799925871704+10.421335993258475j), 
              (0.57458820990522808-19.134723235736892j), 
               (9.7728696220616502+8.1372098539418545j), 
             (8.4710946965015808-0.87357578090549515j), 
               (1.9437463147033225+1.769796224630849j), 
              (-11.069197542308038+29.32236871171488j), 
              (0.3100025037511237+10.793908906597721j), 
              (-16.56991258238936+15.382256500075073j), 
                (1.558617777191504+8.0165907681923407j), 
               (-4.6380992400163397+5.2995143137326748j), 
               (2.5992669604639476+9.6228172802249627j), 
              (17.345122904465075+3.9234381224973798j), 
            (-8.0303444919173437-0.85330968316954636j), 
            (-7.7224622897836737+0.31862348060552664j), 
               (-5.5470042573863481-2.4091482974057459j), 
              (-5.0050406987071696-16.847475743737355j), 
               (6.6794793196342228+3.2594289418832059j), 
                (1.452289454083745+6.1463446557531469j), 
                (3.722109020683066+0.86948897758202914j), 
              (-18.394591218721704-6.8485308456693916j), 
              (4.9478722909747166+6.5694787172464189j), 
               (-2.1476180779893008+10.627962455078293j), 
               (0.4827908523544075-15.520969784668138j), 
              (-2.8494930435306003+1.1058374641235331j), 
             (-11.190047687318391-3.4392677608241935j), 
             (-0.97586087408009248-9.4659300872899657j), 
                (-8.401323451322904+20.87622642277001j), 
              (-16.029844820835017+2.3743114947809314j), 
               (19.719591880771322-13.247448770747667j), 
                (-9.24400070742041-11.404952374254806j), 
                 (14.945306068311+3.3628281862075085j), 
              (6.5677391286066156+4.2251402602838475j), 
             (-8.9947194758691236+0.78201597633099074j), 
               (2.855677922676418-9.1907872601447238j), 
               (-13.284479515159052+6.5943977809312546j), 
              (2.8003403209657716+0.36216818455723199j), 
               (17.512324323112161-5.6879555866422109j), 
               (3.0487434131228168-8.1064930552277019j), 
               (16.516722329879183+19.861504724960604j), 
               (28.707823120868706+14.670198188098755j), 
               (-3.6755644646576844-5.2152281677760843j), 
             (-4.6048826277096024-10.678231163260687j), 
             (-8.5132065863461222-3.0449217578457217j), 
              (1.9213865162754562+2.2294820023506143j), 
               (8.1442253840903351-11.596110253207172j), 
              (-13.675330196234238+6.1481276957001443j), 
                (7.5765622203019634-11.173880707329779j), 
              (5.0514808622534648-0.73954127015045867j), 
              (-7.8909880895009561+6.8708595791264413j), 
              (-15.556126034137364+1.9240431452202398j), 
             (-3.3450674272752963-2.8182645772680379j), 
                (12.900137647031475+2.9365945054139626j), 
               (11.844459475959672-7.0339999932688757j), 
              (3.3045874359751828-2.0483242890505786j), 
              (-8.5385974934533291-1.5057340549027776j), 
                (26.407447384692468-11.52364348295831j), 
               (7.662415080569815-6.8665566093490407j), 
              (0.45615138676426426-4.0850479818277421j), 
              (0.02798152939006518-18.102001104866424j), 
               (4.7182484645727794-21.193548975475963j), 
             (0.25977025798863618-5.8880477710326442j), 
              (2.3897923258173543+3.9547413335663988j), 
              (-1.3643103377653349-4.6640468608669909j), 
              (-1.9745779216152641+4.1394277622649129j), 
               (-13.595360258828951+17.43597903685021j), 
             (-2.2792384645256933-8.6177879896260929j), 
               (-17.825600858764659-10.096388577309883j), 
                (2.026276991563678+10.60161263081956j), 
              (-11.105742220262268-6.4925101557349389j), 
                (1.7746164132427076+3.84850202683706j), 
              (-1.2844845406921845+7.8410972749789609j), 
               (16.003389050522415-2.7539014641241937j), 
               (6.2316672204010377-12.100569432789232j), 
             (-5.6541340637230606-24.693367373467279j), 
               (6.846140103716067+9.8757506358840548j), 
               (14.861979882745814-5.0526848858419076j), 
              (-5.8192892704052666-2.1868571073149403j), 
                (11.39033853128295-7.9986017413587422j), 
             (-7.2697773153741547-2.8751514466663592j), 
             (-8.8836356308189437-10.418172244148455j), 
                 (2.9097198516948-0.11634395294554956j), 
               (-9.2968441596059801+2.6112154708662754j), 
              (-5.7989477018034483-14.336896569294449j), 
              (-9.8229673786195413+5.1948030487611891j), 
               (-4.1067345670325626+7.8955747945315879j), 
             (-2.4696190622884737-9.7822976392244207j), 
             (-2.6194544336891235-9.8231800412365846j), 
             (-6.8624753977319877+4.3115938922449013j), 
               (7.9908650880326526-4.2369889824069045j), 
                (8.3383696589847229-18.49070452234718j), 
             (-4.3860269699160099+0.57452569279222609j), 
              (1.9069032167759854-23.092991983071023j), 
              (18.774848335210045-3.1199812842903949j)],
       [  (3.6672654706827421-2.2223614554212952j), 
              (-2.5019026040892713-3.5371344782656138j), 
              (9.7307460111315063-14.903356494103841j), 
               (2.0241793041638907-1.2495240851319409j), 
              (6.6357507082016118-8.3345346998089926j), 
            (-0.19559934840482099+5.6009479784758112j), 
              (-2.3672294278619002-8.2639766388261915j), 
             (-13.998000947452523+6.6749265008335961j), 
              (-1.9087133358464596+8.6052160268264366j), 
              (0.10002988777567627-8.4709256227231577j), 
              (6.5667658749329636-1.6183628614070975j), 
             (2.9627964745725404+0.91919263133828566j), 
            (-0.90819516882762807+4.9958503981285975j), 
             (-3.3359041506140263+1.6681204221545254j), 
             (-2.339079682182676+0.41708756243906453j), 
              (-1.0361163386281937-11.174377650554401j), 
               (-3.2596705341902696+6.7002477816167367j), 
              (-10.173501586247873+11.041261274044254j), 
             (-1.7121578274287428-12.689712682237438j), 
             (-2.7210709483815987-1.3144545619575612j), 
              (1.9888529985877352+2.1456949388266207j), 
               (-9.8221970006644845+25.689172268982826j), 
               (2.7920059566569506+9.8805518020408378j), 
               (-6.8762157113488565+11.49123880500763j), 
              (-7.2903876814709605-6.8924802290749634j), 
                (4.5386705546423523-9.5510223006386905j), 
               (8.6065911005212534+6.7020417575515756j), 
              (13.427560495652262+7.0477362661407126j), 
              (-4.3271840956850074-0.13386199462621515j), 
               (12.615706163061484+4.5987481762002673j), 
               (8.5501120045587147-6.8017467316105371j), 
             (-4.5451111996633955+2.5600414266790223j), 
              (-4.1912175681151194+10.125739194639307j), 
               (-5.2735451267961206-5.361044440077178j), 
              (-2.0926419254833868-5.2105338286727036j), 
              (-8.1872915522978786-6.3721048887831877j), 
               (8.3127242012606999+6.6130808399360452j), 
            (-0.29107942918607788+4.7599249518584426j), 
              (16.199157232764314+6.1089722446432209j), 
              (-5.8697629587182076-3.9925391278883393j), 
             (-8.7909962363052703+17.861680832857104j), 
                (5.8999085386461347+6.0768360830093453j), 
              (-3.6015911424770048+14.545969028532999j), 
               (6.4712142554117777-6.1947136717905025j), 
              (9.4260771001940071+0.66333719671224389j), 
              (-2.5603490787291063+3.7495995723755131j), 
             (-0.39116652452268502+4.9916524028677847j), 
               (0.84437093557191734-8.4788225510734918j), 
              (2.3933942483578416+17.432901025987057j), 
             (-14.633141726394928+3.6927930429901097j), 
             (-1.8690228220559839+9.7223272318981362j), 
               (2.0256741076634741-14.288003709505229j), 
               (13.479040122799928-5.9851001591124167j), 
               (-27.799782561448218+3.4720172168843226j), 
              (-21.042334209948468+12.162648718607251j), 
               (3.8587767368348724+9.3764770965645443j), 
               (2.9251510353211101+3.5059383996397742j), 
             (-16.617181745153484-5.1415540448719135j), 
                (7.6120256373188919+4.4789634307266049j), 
              (-3.0650385859737552+10.510804188313775j), 
              (17.033465447990025+11.004523729561207j), 
               (7.8150250427296273-4.4984985063802805j), 
               (1.7642059511739907-14.056127609943893j), 
             (-5.5008498277043705+3.7463470833234522j), 
               (4.4399174920048647-3.2175160546495163j), 
                (2.3321623627624648+5.423188818193668j), 
            (-0.056708414792960467-4.2177626671041439j), 
             (-13.705529807928464-4.6133434040744623j), 
              (4.3876479387624574-1.4411653766975718j), 
               (10.624215165533798-4.6019480324377113j), 
               (11.277916116280309-10.581652592467115j), 
              (13.954884843572318+0.77317349458439832j), 
              (4.9499066471976763-3.7232984054618763j), 
                (2.8580461879440371-6.9784019020015524j), 
              (-2.7464328100546802+6.939083081056828j), 
               (-15.235525777385055-4.048714690337837j), 
              (6.4931227874664224-4.7324932833689335j), 
               (8.3701395297637458+10.747215390840282j), 
               (7.6400448825200833+7.8131338715817744j), 
               (9.0377351990184156+2.5348666229246715j), 
             (0.73337461385017244-2.4141263419347587j), 
             (-2.5928498351020717+1.5209972284662268j), 
               (-8.0302480952291777-1.092149035640205j), 
               (6.7141219801860377+2.0965735667741723j), 
              (-7.5493599794647723+11.537749554946855j), 
             (-10.625398131521177+7.5234717703536269j), 
             (-8.9854562531753643-9.4026118737604083j), 
               (-1.8204633516365405-5.174150043462741j), 
                (12.187811469652443+14.265459166101008j), 
              (-27.380695805692191-8.9967655099482879j), 
              (-7.2985539357037315-4.6650517328099088j), 
               (-2.8832711593819842-1.7362840165166769j), 
              (-2.844327068135784+3.2779748521977821j), 
              (1.4221009308770207+10.096776675700838j), 
              (6.0485931966317432-2.8459465018119596j), 
              (-4.1034701851542232+12.265022732022427j), 
              (-12.971535096004033-12.147607747722155j), 
               (5.7096888155048138-8.5079707563406828j), 
              (2.0019525507565357-15.941278615521444j), 
             (-6.5429995816487354+9.7543000571667484j)],
       [ (-1.6780889195485438+10.784196759630207j), 
             (-4.5195956814816585-0.15271340837048603j), 
            (-2.4734778842013401-0.11737452793737661j), 
              (-15.515285855020712+3.9725237886047693j), 
             (-10.065508664278585-13.699047478767561j), 
             (-5.5666271242467236+8.2863494490699843j), 
              (-3.9597892992510015+14.119555474675353j), 
             (-7.5957752574463031+18.233524486324718j), 
              (-6.1083959093787197+14.868586570778366j), 
               (-1.245664759342278-7.0416926306020731j), 
              (2.1221287785398308-2.5946306088324196j), 
             (-16.338309363611792-7.9925884274258365j), 
              (2.3847788251155615+2.5710303836661104j), 
             (-8.2951558201574862-7.9708002127495252j), 
              (19.410511028405104+3.6843433439065669j), 
            (-0.35320441215872123-0.96710258688523465j), 
               (-1.7769176847060109+20.360054105284089j), 
              (-12.841725221564362-10.175372481078671j), 
              (24.127608655357786+15.596247250802291j), 
             (-41.330870149100591+4.3779336286791111j), 
             (-13.349491584095821-1.5061089143881263j), 
               (-10.854592224307471-9.4240324241945075j), 
              (-15.598009294742264+9.2170711636824603j), 
              (-1.7980097638648496-2.0317974087298047j), 
               (-1.6050470738419294+16.18030115592973j), 
                (6.0705952731635353-1.8472911939480043j), 
                (5.7411926964198052-1.009871717521946j), 
             (-1.3795860704197593+6.4038207277172852j), 
               (-14.079599317772956+12.797787342729945j), 
              (-2.3840381372875492+5.6677801264661802j), 
              (17.582403104731895+0.75908389571721502j), 
             (-26.019771642927637-8.0582424132218087j), 
              (-11.943618646471778-1.8812515201569164j), 
             (9.4389175689069322-0.084864451909556937j), 
              (-6.3990732327528699-18.537999795406911j), 
               (-2.8666168509629379-1.298750648173155j), 
               (13.079666454358049+13.643308886973209j), 
             (-8.4995862139601481-20.618900564703182j), 
             (-2.0261682955125062+7.4791741289740408j), 
               (3.3318203877488268-8.2295353282287316j), 
             (-5.8522679501647454-14.976164253754948j), 
                (8.2796452158476512+18.241829234554501j), 
               (14.679193207706284-17.656860668186361j), 
               (10.665838926869986+9.1137263238444124j), 
               (3.8978446390031651-13.230275694815196j), 
              (-9.0334175708527891+12.319622917167319j), 
               (22.411852364852223-6.3963872717105872j), 
              (-0.62718434378029975+15.301122854660639j), 
             (-13.664708830167754+2.1804272777946778j), 
             (-14.493224767209016-2.6165011675205099j), 
              (4.6910003791299193+14.760970222126627j), 
               (4.5299538888516588-10.226512915116022j), 
              (-6.5106066307057482+14.917805158749637j), 
                (13.944392084344992+0.2779984177014912j), 
               (20.450106942815417-5.9728061924032874j), 
              (-9.9900124561424661+8.0659065321732797j), 
               (5.6816905924951575-16.584778095770872j), 
             (-7.7081706166189621+11.206095958307161j), 
               (-11.303496817609478-8.0127825772529562j), 
              (-7.5941882125425906+5.7847060257948115j), 
              (2.9296455517500331-13.277008209111511j), 
                (11.367283252034087-15.02895342890403j), 
               (3.1653234127294989+13.512198912482479j), 
              (-4.159274877394993+9.3766045949251655j), 
               (-4.1865850485270588+6.074194588810192j), 
               (-9.160225011590386+12.287920854778829j), 
               (3.7964335828417726-4.3156431104750155j), 
              (7.0762996264989582-2.2482355141863577j), 
             (2.5572804746207636+0.89949030714946576j), 
               (-6.6749563155263383-6.946279455175949j), 
              (-5.8885341220251046-1.4080090514048198j), 
             (-0.20116232127559602+18.208672204542278j), 
              (10.059291044341103+4.1198245007523022j), 
                   (14.675360985478642-6.0948822403245j), 
               (-14.67233881423679+11.01807317719145j), 
               (11.631160705416242-4.2132554351201694j), 
              (-8.734549548107875+4.0252531114073626j), 
              (8.0138447948789384+0.38253596416059682j), 
              (-16.509987851105311+5.3481271397984145j), 
                (7.339140049708675-6.1679748352619885j), 
             (-17.102052982765379+7.1687942729441509j), 
               (8.491660165414034-13.802860591406478j), 
              (-10.302475173941453-2.1302266262735747j), 
              (-7.3258236492202276+11.147736486669807j), 
              (-9.0579514895647648-17.180382735694899j), 
             (-13.129939132610398+17.531643493121404j), 
             (-12.008645458041773-4.3277395133965841j), 
               (2.1627257274169924+18.779716695048361j), 
               (-30.462378220169953+1.8506549526072278j), 
                (6.787397961718141-4.2275512517706959j), 
              (-0.63200443459112587-5.827938180022243j), 
                (28.279680068009661-6.9133674713722071j), 
              (17.205939055082393-11.470142260452825j), 
            (-0.34437549638573173-5.1770659419094507j), 
             (-7.5365150115003772-3.8101493298914964j), 
              (-3.4562820158047591+6.5073887780293171j), 
              (-3.0091226544494214+5.4193897878901218j), 
               (3.4089413109159272+10.889606390472888j), 
              (-8.6204265656524175+21.01466733216219j), 
             (-17.754104192251944-11.253958921302198j)],
       [ (-24.772574236582578+2.3640606208068942j), 
               (5.2375142319360428+6.6636251991977327j), 
             (-7.8269538250737183+7.7149775401087481j), 
                (23.75122056903674-3.4979839314439563j), 
              (28.345104890694358-8.5679577942551095j), 
              (2.2612268640542768+6.7681689675615475j), 
               (1.8099770927303176+8.5097958092884376j), 
             (-9.3239017855949911+4.6409839973640858j), 
               (8.4540015440263403-9.4447617491332441j), 
               (3.8712429496031335-7.1093906981392934j), 
             (-9.4805020615462183-3.5824061616695273j), 
              (-14.532352518129724-1.715824677879749j), 
                (12.953651450708463-3.01447627397354j), 
            (-0.62693562640103684-2.9990911499949031j), 
              (3.5129916769335323+12.603829862982654j), 
             (-0.26470221763582313-4.3087793311697116j), 
               (-5.6469366423570158-6.1754625946209627j), 
               (2.9929141593332136+2.7902168724538057j), 
             (-24.315713397579938-10.741900258574486j), 
             (-18.311169979265323-18.125493051118383j), 
             (-1.4883336929030304-7.5055267930447531j), 
                (3.3725189634370056-1.9492729230211046j), 
              (-1.1115157955043296-22.681205604807037j), 
             (-20.994486320073502-0.78479234666880049j), 
              (-5.7779813379173088-12.305918928421926j), 
                (18.883013600100238-14.895604443207702j), 
                 (24.035436028226883-3.99924023416018j), 
             (-4.5223243018870587-15.993992943525054j), 
                 (6.618910374189424-2.2363160784741827j), 
               (2.3489229135647518-4.3309341897692564j), 
               (2.3702906810840312-1.4312148513188485j), 
             (-6.5029575146860008+17.465937965036677j), 
              (16.166804617240853+0.77046787393589156j), 
             (0.087546092064880898+6.4573945516090188j), 
               (3.7513333749641768+3.3029753937031625j), 
               (14.021667246646331-1.0626283755525008j), 
               (9.2363483470204475-12.742438452720846j), 
              (17.662348019811166-1.7937216997361138j), 
             (-2.6980847055955266+6.7935003137872378j), 
             (-11.120102313455417+0.49063464111530536j), 
              (7.6216229031659477+1.4395273854362434j), 
                (0.21968318021761213-19.66214673076211j), 
             (2.6157851231288087-0.096455832182433587j), 
              (-3.9611280712796733+5.5008779422893141j), 
              (-3.8395204784086734-22.198839923029013j), 
               (-9.277709307734785-19.214463633127504j), 
              (-6.5985636058448431-6.3951731614182838j), 
                (-13.47614587614081-2.0072173755461877j), 
             (0.55693753589798345-2.2598479625928443j), 
            (-14.830598085973678-0.87409418395351335j), 
             (-8.4224091960547387-7.8084355692582648j), 
               (-5.082249322693916+6.0625110039255468j), 
              (-4.2591569350055023+4.9276517020835788j), 
               (-19.768362265240665-4.7449088735333769j), 
              (-3.7384455543336497-2.0247296205576704j), 
              (-13.739470117484345+8.2842241101389718j), 
             (-0.45304862517956446+15.672273578804369j), 
             (-3.6824631451749665+3.3750402687576986j), 
                (1.4316555533255086+11.402054839134443j), 
               (9.6321393989014474-8.8044612461299749j), 
             (-16.224407576313013-3.8005735858074359j), 
               (3.3042918789556239-9.2889703833585155j), 
                (-22.68821653394836-20.59092872324619j), 
              (-13.304752356097371-12.47052232555383j), 
               (7.2046169836630352-3.4468972676454452j), 
               (0.10607843638379208+1.269542385217119j), 
               (13.806883965461763+22.765243540907466j), 
             (-5.5129051836944782+0.9511978229970165j), 
              (5.4706151968831707+1.0119983492957405j), 
              (-5.0100006842375056+18.253920713306655j), 
               (1.8235011721076617-3.4774418352861551j), 
              (-4.4190643969813248+3.6819123005785412j), 
             (-19.899685451079417-9.2427001166165432j), 
                (3.5021096895781327-4.0464955150666988j), 
              (11.295596013975342-13.515096438829087j), 
               (17.084157243467221+2.7366881647605479j), 
              (-3.522286967506095+24.748204760330907j), 
               (11.482356886654049+14.452638019819199j), 
               (8.2579841454792398-2.7844260688356943j), 
               (1.5728170294503176-8.1667038231525328j), 
             (-9.4767135303670695-12.913156887540199j), 
              (6.9393009630994404+15.250609161715719j), 
               (8.4205076974480022+5.0312989632253835j), 
              (-10.688879722942728+4.1913653094398811j), 
               (-7.835706970028097-2.7393183177578768j), 
             (-3.9059088283732351-2.4377681687718056j), 
             (-9.431587501599008-0.51032063203872158j), 
              (-3.9996054694237877-14.960524905651544j), 
              (-4.8893657567839099+0.31975148945247778j), 
              (-5.2805429155960661+3.3181948760025399j), 
              (-5.0311560383235321-4.5920348135580618j), 
                (4.4877578075550133+0.9229244985167655j), 
              (-3.5888823308254341+2.708689666283032j), 
              (9.3623892023333575-3.9624995783769288j), 
             (-12.006027191790089-10.859961222915381j), 
               (-8.7164889054007784+2.136050585479969j), 
               (8.1140123366012631-1.4571917087543851j), 
              (-8.6956065312573863+3.2591650813938164j), 
             (0.70463682353684964+16.795990921337506j), 
             (-4.3795400511151197+8.5799400235489962j)],
       [ (-29.573910271944321-3.5786031918049757j), 
               (2.0234260907836226-0.5633612551610897j), 
              (1.7595853706470281-11.593200737070511j), 
                (2.2852012075950903+5.125570534152879j), 
                (5.875728436230605+6.348877448429123j), 
             (-6.6286717230479475-7.8887523108476865j), 
              (10.860094080477909+0.10020524440385986j), 
              (3.1896992372927722+12.904946211645596j), 
              (-16.814629247305668-6.3328431655046566j), 
              (1.92271127038088+0.0053823617587132559j), 
              (12.813125725528316+20.928658675416507j), 
              (-4.2755681283228748+1.089338394610879j), 
            (-2.8128764151648431-0.42007032904907438j), 
               (4.2311016332734965+2.435776468766039j), 
              (11.033193385899192-11.002578248958638j), 
              (-1.5121389918951813-11.459008989357443j), 
               (0.13067613697644248+6.5154623059597299j), 
             (-0.14482878034466087-16.543618935103463j), 
             (-1.1029775918271447-20.041935679164574j), 
              (8.4100520244564212-6.9231618207333252j), 
            (-0.76801697975849514+11.018037137051175j), 
                (2.7804837564537537+4.3867026764064789j), 
               (7.7362955615799649+5.3217807515715929j), 
             (-10.319254098441355+0.87374037075855604j), 
               (14.500094645505836-4.1990255048573664j), 
               (-2.9400216349483532-4.5954514894059777j), 
               (1.6746688050833345-1.0529429995474122j), 
             (-17.152366049563504+6.1212104090739183j), 
                (8.9289536137365015-12.080296872642931j), 
               (3.0734828149562405+2.9603938441949489j), 
               (2.9331504073918611+7.9741398682653051j), 
             (-7.6061743967175941-17.073880072025197j), 
                (11.63690171016219+12.791725417078389j), 
              (-5.4033789074008229+1.0609611240432972j), 
               (-3.4463853486579414+11.42738296756368j), 
               (5.3348320812451613-2.8603094707056846j), 
               (5.0394487863919615+5.2331916299034269j), 
              (7.7613692649340358+3.2225990362873547j), 
              (2.3919007791397502+14.815525980708202j), 
               (6.3100126089590569+3.0417821407597776j), 
            (-0.93229128202256273-13.027409844619262j), 
                (8.9018124106505852-2.5996037652248667j), 
               (11.474055525873609-2.6022972424725572j), 
              (-9.4867479671886894+7.4180848156782853j), 
              (-2.3563064311889494+5.1724709524294896j), 
              (-5.9284194575491895+7.0910721629486577j), 
               (9.9906961079754968-9.7031000516610106j), 
                (23.876758321722086-5.1157864355350107j), 
              (12.483557710679873+17.896385500497157j), 
             (-7.1318342279841715+1.8158052672754652j), 
             (-8.8331563754277003+12.453566435395365j), 
               (19.986181949567289+11.788705248763913j), 
              (3.7794289914863417-0.14806938903263978j), 
               (-14.954405641838376+1.3473320807744589j), 
                (1.762980163628932+16.368791590223573j), 
               (1.3478813295359879-4.3798563292354018j), 
               (2.4099657752224801+5.9837966004380299j), 
              (4.8958483575205225+10.145005198440701j), 
                (-8.1511201801673483-15.49749813397441j), 
              (-5.0717223557268145-7.4706129056231667j), 
             (-1.5441609231887898-13.634045981179614j), 
              (-17.673175530160542+8.8190125224970206j), 
               (-3.4034780738591781-11.33967727690548j), 
             (-4.2566768534732233+5.1527664442599397j), 
              (-6.2112880054885018-18.195007391567021j), 
              (-12.669220108895619-6.3934398853355727j), 
              (-1.5125973409733864+3.6915670801445089j), 
             (-4.9005048971519791+10.772048065707899j), 
             (-1.3801676067933801+3.1170512709234028j), 
              (-2.6407898457896128-5.7382662901879966j), 
              (-4.6389171718158968-3.1305672730052154j), 
              (-11.204121588366744+1.8380961927054154j), 
              (5.5748107866333978-3.9706268142081367j), 
                  (2.218448099679919+17.91059663750962j), 
               (-3.8590123119912976+8.20596056813039j), 
               (3.1953801175891607+1.4560194228692638j), 
              (3.6296781858806746-6.2251540887770043j), 
              (-5.6399745353611941+8.7081445226707324j), 
               (-5.2711413830509866+12.28621630432845j), 
                (13.78571357762258+3.3167422693268582j), 
              (7.1543537379879627-3.6464092887873822j), 
            (-0.70235216544748136-2.9893233181415519j), 
               (3.0085988393743044+4.5696414235546818j), 
              (7.8676979450746387+0.54588187582133652j), 
              (-9.8289500256903679-2.0037957201500638j), 
              (5.9747463206678848+1.3578644186018074j), 
               (11.24023702652865+4.4887696346129866j), 
              (-2.4670019726725299+1.2440771023089212j), 
                 (-2.633543023590355-11.33092647331345j), 
              (0.89804461557692972-5.6869219217610443j), 
              (-12.633399977987454+2.3988249737363265j), 
                (6.4213906812997799-16.164237503042493j), 
               (7.4199189677145183-1.106390093531733j), 
             (-5.7743139988539474+6.3250422204124224j), 
              (2.4613530095987941-8.6186395181115181j), 
               (-3.9115437023365263-3.123026754410851j), 
              (-8.0138660736275167+7.3746454709696057j), 
                 (-1.57557016543429+12.34029832225249j), 
              (9.6558364495374178-17.108872630269399j), 
                (-13.3379018667802-10.13947410260309j)],
       [ (-0.98794265271352322+12.80734837662536j), 
               (11.379834792117475+6.4083914991187392j), 
              (5.3149737481874295+3.6615063540524693j), 
               (10.987528151621547+13.842743248797994j), 
              (-6.9800217654539196-12.32557114383857j), 
              (5.7292047109265454+14.426789046332713j), 
              (-12.729015699796502+10.479703965721539j), 
              (-0.883600029115855-14.230392399252427j), 
             (-19.819648474934464-0.35425013433939012j), 
               (5.1923406698242802-9.4526457838513895j), 
            (-0.24879808727382743-9.0508630931923442j), 
              (31.104522723308566+16.802987824118855j), 
              (-6.585585334003853+6.8242850085174078j), 
              (17.833309329134522-3.2761163478970419j), 
             (-16.698343723101129-3.5562185732456397j), 
               (1.5746677472827453-5.6122620855382799j), 
               (-3.1468397177910736+7.1445302333024729j), 
              (-10.951271636991986+11.469933741362038j), 
             (-6.2129281830364818-2.7781814883661182j), 
              (5.6406653298160458+11.651569796469508j), 
              (1.9546187868545082+9.5551921488721572j), 
                (15.432519068411318-6.8785662103103808j), 
               (-4.229966710449018-10.057932743332337j), 
              (-5.9529166313462429+9.7335862045490238j), 
             (-0.03379050441833098-18.750521705540585j), 
               (-13.766985491681844-6.0229592670332268j), 
               (10.864732857124579-10.286528832785731j), 
            (-14.218855675595101-0.94869999434482655j), 
                (8.6434280229362166+2.7875736983255632j), 
               (-4.2825575547383723-12.26847097828086j), 
              (-7.9330352566818103-2.3436910781321614j), 
               (6.1475747173816453+10.66052799973987j), 
                (7.220696232395504-1.6574999941710358j), 
              (-6.1555033826404317+9.3625768598453831j), 
               (-13.982285276251316+2.271248095696131j), 
              (-1.0978911721325373-13.963471827909562j), 
               (12.054883199428843+4.7291465545063334j), 
              (-9.6313461083191214+6.558768263817484j), 
             (-8.8575233484724976+6.2225362169536336j), 
              (-24.126877898714024+3.7879387929575081j), 
             (-7.4505164825994683+5.3469779611706247j), 
               (-4.9247283588993902-13.653046892905909j), 
                 (2.924293186896449-13.46484378238311j), 
              (-7.0369120281789952+6.1779954197493057j), 
                (10.466443036312004-2.343271108878159j), 
              (-6.3530834004817365+13.229562342492052j), 
               (20.516963967740523+20.006259495663432j), 
                (2.4207352837732414+1.5296736932078014j), 
             (-7.2178363569303103+16.716188742829065j), 
              (-9.4839510999831624+11.55779986709415j), 
              (-8.8494913382894733+16.53769650818532j), 
               (11.681751349831647+4.6169057875886583j), 
              (-1.0677049159349603-15.415025242790916j), 
               (0.82803968011930529+6.6859216424075001j), 
               (16.358900819026939+1.7890751859440699j), 
              (-9.4577898192429686+7.1471349577512209j), 
               (12.536543873901982+8.8903078168659668j), 
             (-13.741563152086263-3.4134677503334614j), 
                (3.4064866778459453-8.3021329597658386j), 
               (-22.03301395470433+11.477331620660534j), 
              (-15.353338177425698-4.920384096672862j), 
              (-3.7080615967307704+11.311510429144976j), 
              (-7.4800794551088803-8.1185960098619212j), 
              (10.782974049670916+9.2419661015538654j), 
              (-2.2856710087152963-16.369279909798614j), 
              (-14.077977236317924-12.551147412748762j), 
               (11.413370124089347+12.724639713741899j), 
             (-11.685036582541198+14.688227776178131j), 
             (0.12384172675841555+3.6822262868587874j), 
               (-2.7042067591897578-1.224284322224138j), 
               (11.138538581383049-10.071753948100968j), 
              (-4.9169456753073533-7.4858857414339415j), 
            (-3.1060052844525639-0.37964117270671777j), 
               (-10.229828419939672-7.4943613226397527j), 
             (-5.2995761628863125+16.640522976578104j), 
              (-14.223700424138448+1.5245895077012488j), 
              (17.358973054992411+5.7097910573690003j), 
              (-8.4945562845811313+9.3296140263008418j), 
               (10.438370250396975-11.488911229965264j), 
              (-1.0691845326587508+8.8379753080094119j), 
            (-0.75824630794467751-7.1454199511348504j), 
              (5.0907031663269979-1.8497500105188727j), 
              (-4.0309464842965905+6.3900070903892683j), 
              (-1.2646408918465022+10.244492375320215j), 
              (-5.9613439119881262-3.8958396776099264j), 
             (0.38130705276430732+10.190162674524606j), 
             (12.990616898397258+0.46140286864192187j), 
              (-5.3487791821710617-5.5407475725728261j), 
                (5.9946693817067951+9.8949792252900277j), 
              (-3.4937913721831748-1.0847648778378902j), 
               (10.101577688094537+5.7864174322093724j), 
                  (5.701926161967573+7.290621403807088j), 
              (13.536713973798275+14.871460773827605j), 
              (3.2814385650765172+12.609564360639157j), 
             (-4.1122945983470318-1.2749568758050687j), 
               (5.8230660696972683+8.2286126324497761j), 
              (-4.1908516227404382+6.7813224523625451j), 
               (5.2242441435101323-3.9049880048230912j), 
              (2.1482166608572282-1.5001642067163901j), 
            (0.80759751443039085+0.24353103805903234j)],
       [ (-0.2254521197026762+6.8958161780803495j), 
              (-14.576587496744134+0.5663434822707083j), 
              (12.881128238151902-9.5484523813079463j), 
                (5.7919322552433705-11.49188044120114j), 
              (8.5530266340264625-12.010266438479754j), 
              (5.8352424797090752+28.212239331860168j), 
               (1.4234430420050279-8.4990906107000832j), 
              (-3.9091320453226492+9.280603345974022j), 
              (-13.111896362539097-15.983479721748166j), 
              (-13.007931719107418+5.4885901490419977j), 
             (18.794929378046422+0.55971506241691571j), 
             (-33.324386636299757+1.9651192946989593j), 
            (-0.64797953355668347+3.4984224235562777j), 
              (-14.671948019039947-9.543921437083613j), 
             (-5.2592397271756397+15.816785326049331j), 
               (4.1597391387205098+3.1358518837239986j), 
                 (3.903989055133005+13.037648525540185j), 
              (-13.039309079358173-10.859495129370195j), 
              (13.647692060907552+4.8071659111570666j), 
             (1.4278885003636901-0.22285324219303698j), 
              (13.685118217754727-0.8274606972173576j), 
                (2.9224829947695725-19.317778570990534j), 
               (-4.4474495538792818-3.131703033434265j), 
              (-5.4648220139279022+4.9623627581063365j), 
              (0.88317356701388117-8.4929344703609395j), 
               (6.1106292203685166-0.75183152462520297j), 
               (-9.6900212778127113-17.09732492520093j), 
              (0.59896237202364322-10.49809164340566j), 
                (1.2334672206703294-6.9862567034467249j), 
              (-2.5174663574955662+13.879571868841348j), 
              (-12.611880166569829-10.845449441448283j), 
              (19.659616569826447-6.6364996465574162j), 
              (-4.7692881172409711-12.586218017382823j), 
              (-1.1927035617306627-8.1736799282966146j), 
              (-10.822171346128346-5.9823549184958402j), 
             (0.082000555675237841+5.3440750286266887j), 
              (-2.8904038089327253+4.9884871367559249j), 
             (-3.8653096982779136-8.6681086556552209j), 
              (-20.88671827297356-10.018890383049619j), 
               (9.3262779725475866+16.387814136887201j), 
              (1.5516545826900923-5.2577172866047057j), 
              (-6.9467843984473285+0.28470983677445588j), 
               (7.7839053873718438-9.2766805035883042j), 
               (5.0896393199938998-2.0521127489784794j), 
              (-19.561998924342944-4.3556873281270168j), 
              (-3.2790945227266857+7.4989409117898234j), 
              (-26.109662235935787-9.8114524880530531j), 
                (5.2317677282220023-10.666181601616678j), 
             (-8.9914817895940544-25.399783175609052j), 
              (-9.937211299545055+6.1310741176487857j), 
              (15.739477507504605+12.037855370250625j), 
               (-2.907413883145376+7.9888165300638683j), 
              (-16.123872237378137+9.3996687245459789j), 
                (8.3374642722411387+9.1074891091162673j), 
               (2.3745243650612906+1.4293612827820368j), 
              (-7.6795555913941733-7.0181273109674756j), 
               (-19.44635200023416-1.3210123901395558j), 
              (1.9958668992080055-3.6134224294665858j), 
                (16.315762174314624-13.807740396160451j), 
              (-14.155583790754944+1.1127711549038468j), 
             (17.866704712537661+0.44037636976163147j), 
               (-20.964760551807643+10.76069657778023j), 
              (-8.5341366671100243-4.3558206056258904j), 
               (8.9932229606124139+17.42128838891125j), 
              (-1.3693789031081485+4.5069214379799316j), 
             (-21.062049673653039-0.12359531398840225j), 
               (10.285920360240297+5.0213004211515067j), 
             (-9.9696899145863487+3.3620720134405273j), 
              (4.6903688612201364-5.1748174465353527j), 
                (5.119455905565494+10.604202383185832j), 
               (9.2093591460003914+4.8496922421845063j), 
               (-24.264176211970266+8.022576646038587j), 
             (-5.9786901873325791-5.8601593183668665j), 
               (-2.1990438920602409-10.849780815540935j), 
              (-6.039112055864404+1.5964211097204486j), 
               (1.0442976187072319+9.5006784033417588j), 
              (4.8782720937191435-9.8252447519093451j), 
               (16.726705584630956-1.5481277183538218j), 
               (5.2484565447678611-4.0283883122735578j), 
                (15.349623210341472-7.471850693653205j), 
              (5.9587617004542075+14.500983947397639j), 
               (3.4930457385867268+5.854103477764947j), 
               (-3.030477220757255-9.4219796962457565j), 
               (13.022879664642243+10.675391536460399j), 
              (-1.2486524457101131-7.4634280518977727j), 
              (2.1133329448676714+2.8774694807730761j), 
              (-13.171372365995373+0.414269609861598j), 
               (25.497066880388068-6.2889735753071898j), 
               (-2.3285165340184584-10.132289673467493j), 
              (-9.3439925225097742+10.774583714222818j), 
              (-13.911722335771991+4.2975303341926017j), 
               (-4.4328994026941588-14.621360642624584j), 
             (-3.0422513747986586+9.5654313417059758j), 
              (9.5960404179523646-11.502339887486983j), 
            (-0.53894235261664603+12.888995007606814j), 
              (-12.159973914159467+23.592877449937806j), 
               (6.6904876627651566-4.6394159357249345j), 
              (-11.319915314787375-13.872126470198619j), 
              (6.5868295644314383+10.237833041855311j), 
             (-11.548765642995242-13.136972104594381j)],
       [  (4.5092208216658589-12.727845190867786j), 
                (12.779415023028522-4.266405926369667j), 
             (-16.988748561195209+10.842343161871167j), 
               (1.2546233300748366-14.016964801601288j), 
             (-14.784422094538488-13.882011702209516j), 
               (15.82555691251223-2.2422661062680929j), 
               (17.649695007454071-4.8256135116857992j), 
             (-9.6190197738811705+14.949325577537353j), 
              (-3.5201504044891769+3.7212501017561355j), 
             (-0.99031605915619048+6.4532422511032506j), 
             (-12.717048579411589-3.8347304125023984j), 
             (-3.9543252106301092-6.7342037202166534j), 
              (20.411786827666049+8.6134268999549874j), 
             (-2.6043510737525115-0.4516129015481537j), 
              (12.977229215170583-4.7133517861974354j), 
               (11.971288379771178-12.132975293066826j), 
               (0.94395831110646733-11.713360720916263j), 
               (17.097523972841383+3.3869486815529815j), 
              (5.7737488421372829-19.744942890864266j), 
             (-0.56118569351815795+7.404794084941182j), 
              (5.7148368019872731+16.730472364642747j), 
               (-1.5833438235057322-1.7094983062907416j), 
               (-5.562486320314207-9.7784973690270824j), 
               (6.2994506076214476-21.261744207660623j), 
                (10.17577839760882+4.5768279022299279j), 
                (3.8525226818856293-6.3956149315660333j), 
              (-11.550353536240753+14.277958922649885j), 
            (-17.585117120403631-0.10138545141482833j), 
                (-13.93578753219894+5.4921091240772846j), 
              (-9.4052067223134941-3.3731418819317867j), 
                (7.738371365444392+7.8571094897788694j), 
              (-4.0505284896274576-5.494789201204612j), 
              (7.2589026009872732+0.90405722661056975j), 
              (-18.849262311525518-30.480585755942535j), 
               (4.0133746619809774-16.976018268396885j), 
             (2.8314899445145398+0.038378577808724404j), 
             (0.055771956109398065-1.8197569146430934j), 
              (4.8363793207986783-14.567982029676481j), 
             (-2.3490261157402639-20.710192518430613j), 
               (1.3327283235096661-10.708549151861359j), 
             (-6.0577348257213508-6.0480409477409864j), 
                (3.5944592888715143+3.8952219317467982j), 
                (8.961161833022107-7.0049222112698644j), 
               (4.4083023165616115-10.831345744943661j), 
              (-16.293075394704662+1.2802422444461967j), 
              (-4.6220215687932393-6.3581551233784284j), 
               (11.561024082109757-4.9543613940040201j), 
               (-8.6983301932922998-4.9799460526655288j), 
              (4.3057084835007222+6.9324991730971721j), 
              (5.9678658463005547+22.030432924658147j), 
              (-1.8975812555083935-10.24118331636145j), 
               (9.9506833522287188-2.1801580734688502j), 
               (20.794267259652784+3.4237853623795726j), 
                (2.6043527383157667-2.2360253773678678j), 
               (5.7532540072383496-8.1275225661814243j), 
              (-3.0031172066978327-0.6438392398214553j), 
               (2.6703796918229012+8.0015432992551805j), 
            (-0.35009621156017084+17.840942022625981j), 
                (10.847611136768835+15.570858841754781j), 
              (-20.500897944112037+9.6914243236556921j), 
             (-3.3079086136556417+7.6308990040841511j), 
              (-8.7176813385666065+3.4492424145300706j), 
              (-2.4208929173964835+2.7952234045452773j), 
             (-6.4812674379722974+11.291621857804909j), 
               (7.8732640699983705-21.173616454442662j), 
               (3.1540485419129185-1.0320601589552705j), 
               (6.9575175141598846-4.8273925563675872j), 
             (-5.1671486629814236-11.764789551083316j), 
              (5.2093828274465679+7.5429262886607624j), 
              (-10.039622710721162+4.9494429635395791j), 
               (13.728400844847858-7.2275870206744317j), 
             (-0.35219007185763873-17.617380935380911j), 
              (-7.0794042425847534+5.028698700329425j), 
                (-10.15613643894744-8.7931565120493111j), 
              (1.7508136841917175+2.6076695980005464j), 
             (-25.505052705902397-0.51666977807427517j), 
              (-15.34848389429321-16.158103623321132j), 
               (5.6368486695605222-11.943100921489304j), 
              (-25.019994976986251+13.926668659988655j), 
              (-10.933836443014918-16.685845972442031j), 
             (-4.7184645885925818+5.3855505408196045j), 
             (-5.1051291531205205+7.7108538407587393j), 
               (22.158255487336721+3.5566983092218187j), 
              (-10.996204382306606-0.9185875012872371j), 
              (12.993470511125199-0.73171024554489306j), 
              (17.254738571605802+24.375616973524398j), 
             (-11.191217593070817-6.1944943784296012j), 
               (0.3873747359557988+4.7886880880858138j), 
               (-7.6708342116972892-21.154077786755447j), 
              (-7.3225942865402294+3.9791052822520334j), 
                 (2.59872078303149-7.1840211668170024j), 
               (-23.418473101953001-2.8177421063517816j), 
             (-4.5139381689502152-19.256537518631248j), 
              (8.0981318260060302+11.759226406142762j), 
              (5.9661989724224238+11.808271274453279j), 
                (3.4207175087715309+12.43198812636868j), 
              (-1.3282836721293361+6.7435112150376781j), 
              (-10.185261926314739-10.808700718109876j), 
             (-13.217093096919337+9.1280394141872669j), 
              (12.378082210854446-4.3311320214281821j)],
       [ (-5.6938987020665452-10.355134048251696j), 
              (-9.1057176948899112-13.298289855497822j), 
              (6.2832394655910129-3.9213923028623814j), 
               (9.6048697066009154+5.7336874453353834j), 
               (4.588433498934215+14.539553390157794j), 
             (-1.0524878727965494+15.710109475045343j), 
              (-12.825557719525332-14.163987753332785j), 
             (-2.2902832381338398+11.439112421131014j), 
              (-5.4792468755718957-7.8785127054424811j), 
            (-1.8817279847474089-0.034821323209425492j), 
             (-7.1729322577072319-2.9142324034313658j), 
             (-7.9494176453040746+6.8251591741953792j), 
              (-2.122302036465026+15.592064619835471j), 
              (-3.2990650705635356-4.009041639305547j), 
             (-1.3509190346585351+6.7489370094328827j), 
              (-6.8762021671957392-7.3414350377272015j), 
                 (13.468149755397915-2.683672994571316j), 
               (0.6753131502775882+17.143873999551733j), 
            (-10.861458746101125-0.68031302166619179j), 
              (10.679497056250714+11.636071546699965j), 
             (-11.606065165831307+1.8769812834068431j), 
               (-3.3016035195581352-26.596258778672389j), 
               (5.4265534968560338-8.9704354851433568j), 
               (3.6148014114267539+14.240501721645764j), 
               (7.3751313680627444+3.1049350667578035j), 
              (-0.69329697922156808+3.7246154255886781j), 
               (14.733364996020375+6.5680223778944127j), 
             (-13.213861543818686+9.6543723926311422j), 
               (-1.0144093406108392+5.8297395283901885j), 
               (2.9504796690104111-12.071896714066092j), 
                (2.1267007133083835+7.314809116656809j), 
              (14.383214419434401-12.094839540794629j), 
               (12.175217626275533+8.5826678091138966j), 
              (-1.7847268652877892-12.067353519047664j), 
               (6.1363702974183063-10.928382446900313j), 
              (-5.1079013987157706+4.2180413255760971j), 
               (4.3771945182245968-1.6330905748358102j), 
             (-11.553685283411445+6.3632270997891061j), 
              (8.2417745021620483-18.090834230790428j), 
              (3.0384581461805107+0.48743640923009468j), 
              (14.445039452940303-5.8280658822255118j), 
                (3.9999246898122682+12.427373976822466j), 
               (5.7492871253613096+7.3350158944649779j), 
               (0.4427427833666685+9.0293511137664435j), 
              (-3.7157238042113128-4.5658324192584141j), 
              (-6.1860618789292783+22.286305098652889j), 
             (-5.8718904225829851-0.84630806107723688j), 
                (5.8927835477280857+5.8940251288026344j), 
               (-2.01680546615597-6.1206300171257046j), 
              (11.752202457110858+1.0048176401829296j), 
              (13.809483167052626+7.0602369915874865j), 
               (9.8448417087912823-7.9084685937508468j), 
                (3.778620125022857-6.9296323362024879j), 
               (-7.5250332750060123+6.1829999503642687j), 
              (-1.5035522271021966-5.1619793468047348j), 
               (8.6960008528622161+2.5015391225456489j), 
              (-1.1605300560395773+9.4342285472387317j), 
              (24.647172883719936-12.154632451284273j), 
               (-9.1965396919044284-11.588962475157569j), 
             (-0.22391635328583498+16.288151976536238j), 
              (3.2522205333795688+10.020527427667961j), 
               (0.15535223454856728+9.472768134712382j), 
              (-1.9495603946442877-8.8516538601098365j), 
             (-29.791334378655744+9.3628243752090192j), 
               (3.9552972679415408-1.9601423869023826j), 
               (-21.45043609889802-14.034853406782194j), 
             (-7.9382681612122932+0.64379784436368481j), 
              (11.983941439715405+8.6531500362291265j), 
            (-3.9124816039843728+0.73505281937597755j), 
             (-11.327429187731138+0.30265614458074913j), 
                (3.009813840836697-4.9955141675059238j), 
               (-18.11341294200043-7.5278420556739469j), 
              (23.651624150380073+7.6960616204024177j), 
                (23.548465736817835+6.3318623610919156j), 
             (-8.8371444766945082-16.901975953294897j), 
               (-1.991848073027739+7.3076158873773513j), 
             (-4.4699933890787307+3.4510395483065586j), 
              (-3.2838967490457502-6.2647607420473577j), 
              (-4.9354862182056642-1.8194083219094539j), 
            (-0.70503393905376421+0.69835745689535089j), 
               (13.895101176060507-1.659394380620975j), 
              (3.1980846046851537-11.073873226837843j), 
               (18.521623685379211-6.3416425492719704j), 
               (7.2252538849770538+4.2610182433905548j), 
              (-4.5636550073456918+8.7424833965923447j), 
              (-1.6646812208469841-9.954225766387383j), 
             (-2.2733710329047447+4.5663088413536599j), 
              (-17.769906077499414+4.7788634338122122j), 
               (-11.311455511756161-6.6349239788975201j), 
              (-1.7350887138275763-5.6011882931319494j), 
               (3.1229986629188442-16.138685639692206j), 
                (12.157873887572615+10.906785023346576j), 
              (8.6831372424321565+2.9525692628112332j), 
             (-0.22203061883690656+12.33806612957855j), 
            (-2.4570011949882815+0.19558770820977497j), 
             (-0.37325374980233017+10.113569684191233j), 
              (-9.2138280808608162+11.899240079648475j), 
               (6.1792625164820159-7.6309364397758923j), 
            (-12.216134602632508+0.97407784585554769j), 
              (1.6290057287667388-2.4528994828616768j)],
       [  (13.620631489303154+8.9220932557609416j), 
               (5.7282690048735043+12.128773878542125j), 
              (-4.045425153493623-6.7209662814021804j), 
               (-13.82966730369575+8.4829909089447177j), 
              (1.1408935313555153-2.3917960997169936j), 
               (6.6784892790095771+4.430392636804771j), 
               (4.1835427922992716-18.939511482982134j), 
             (-9.4870332565719604-9.4575940166410035j), 
              (-4.3483013302781952+9.1409214690571403j), 
               (8.1479375992135878+15.766526157838342j), 
              (7.616730101522954-0.94974222537928921j), 
              (8.0471422948961866-4.3550492897488162j), 
             (-5.2438313378738517-1.3445481661400431j), 
              (5.8900482724968617+6.5216603867565492j), 
              (20.058717278899124-5.3030243377620687j), 
               (7.8464562573136751+13.134297009553357j), 
               (-9.0072285063045001+16.440827493157656j), 
              (-0.7117624400028415-1.3838644489341814j), 
             (-18.975361700332943-1.4328959719685241j), 
              (1.9897961038865226+11.340381178626357j), 
             (-3.8131625300987704+9.5392516889516301j), 
                (17.256721291382672-3.9632922927224747j), 
             (-0.69695876259179967-1.1467020857899703j), 
              (-12.857733197933763+10.955155525417478j), 
              (-36.442002533148056-2.2581951400098079j), 
                (19.336542976759155-10.290984765364474j), 
               (10.805145250901031+13.652057419371474j), 
              (20.132937573343455+1.7518953493632692j), 
                 (-15.11794754300041-3.005150923309384j), 
               (3.6797334257355709+13.871486447785555j), 
               (-2.0221887085744599+16.70453703964273j), 
               (5.232183109635451-12.856838173757172j), 
               (14.607298100587283-2.5478417464797083j), 
                (15.77520623559813-2.8182135192880264j), 
              (-4.8942826479051824-1.9616885564322657j), 
               (19.757958627797436-4.0921768696211789j), 
              (-9.3194654262793932+4.0285277305325176j), 
             (-2.8308797531055445-9.2070751824608994j), 
                (12.9610222864093+4.0979175079108723j), 
              (-13.961357869416505+11.196973012391085j), 
              (3.3256047810609477+5.5349891620819625j), 
               (-16.143194474486862+8.2988443990426681j), 
             (-0.42818761131200356-4.4572770586599377j), 
               (2.1284144258160715-2.6005457595844095j), 
               (-14.548489536752932+2.342141106873358j), 
              (-17.459990663215976+1.9179220323926485j), 
               (3.6966921529122221+18.215325424652974j), 
                (3.6378842206735413-11.938644830838591j), 
             (-3.6182082848173458-34.217242269859121j), 
               (0.20722894082688031-21.4401800371921j), 
                 (10.056184903022+11.116666073666861j), 
                (9.5078352545374969-1.978304354426788j), 
              (-14.382333769171476-7.6295061342370634j), 
                 (3.4047256449330714-0.418247797593646j), 
              (-5.7783943713616974-9.1545317290909072j), 
              (-13.170352307528049+10.679072587781972j), 
              (-6.0090570439565036+15.760182345651438j), 
              (1.5285091541900688-12.168096697331151j), 
               (-3.0619167446509343+14.339457950650811j), 
              (-11.655983825843634+15.263939114397754j), 
             (-4.3760019103619516+4.1684514680117299j), 
               (5.8891832592407596-5.9937062178484171j), 
               (-18.21345627662998-12.352829420844031j), 
             (-1.0763983323472404+5.3958531315059224j), 
               (0.21517232766873567+11.46776612260286j), 
               (10.271952102482507+8.5504743932753975j), 
              (-15.099710164720726+15.502795515989243j), 
             (-3.7944698821869394+26.881431155251633j), 
              (3.1124384004136472+3.8857238324908829j), 
                (7.3125145558411484-1.205952740140964j), 
              (-7.6972592341483868-22.139314696535116j), 
                (3.393986402003113+3.7568194047018393j), 
             (-11.919867121063978-23.994815379871657j), 
                (14.939543890483185-15.899220979414959j), 
              (6.9301932944854077+10.322410895748767j), 
              (-3.8496827850461708-2.9936521833568781j), 
             (-26.673667189543252-1.1668512838920027j), 
               (-3.7940494392463715+3.515372841476796j), 
               (1.8774098738852758-6.5607901365354397j), 
             (-13.594653233144133-0.52802910669241931j), 
             (-8.7236645431595665+5.2802201530657307j), 
              (8.0291847783326737+18.193546610285932j), 
               (4.3414143445071831+11.889632248433323j), 
              (-3.0924387362951471-13.194404423835024j), 
               (-5.6980965958018874+7.375197386936577j), 
              (-2.1138873385361312-10.58585522557207j), 
             (-3.0694091917968342+4.6987614187564954j), 
              (-12.868961113481539-6.6108411470732413j), 
               (-4.9026618276124063+10.035124771896287j), 
               (6.9398379819269538-13.736373233712891j), 
               (7.7127266588813583-1.7300845250545083j), 
              (-0.74547154288443451-1.5419368521835772j), 
             (-14.897331046912097-14.140865994526129j), 
             (-1.2263050538252671+21.899764500466912j), 
             (-5.6501641254426671-24.276520741180082j), 
              (-15.563626992539186-8.7965728329420187j), 
             (-0.55589983899881623+4.4572934568260116j), 
              (-5.0281356537755499+6.5295909897586437j), 
              (7.9735343491907615-22.024156253795063j), 
              (9.0761317598888063+1.5466595972605424j)],
       [  (6.9491733161211116+11.433574576989106j), 
               (8.0252365553266287+1.2648257181375779j), 
              (6.8365390332698972+5.8484608013822488j), 
              (-16.599619009597554-12.253339242778996j), 
             (-5.0646809878026646+12.882811289120175j), 
              (5.1474697550274957-14.779361022057135j), 
              (0.42968471581822076+5.4515708965571577j), 
             (-7.0376279089879956+3.8634041581775729j), 
              (1.7369174465375483-0.36863912665505927j), 
              (-6.7084936356558984-9.7125004630004703j), 
            (-0.40642178956918085+5.0872218894104249j), 
              (13.634313831069957+12.870834862082496j), 
             (-5.7250462978881487+15.843999063165109j), 
             (-4.8798991120750825+22.043033453898833j), 
              (2.7998628584862981+2.6945920091485407j), 
                (16.50750210908382+4.3214221325594684j), 
               (12.145883458020997+0.84954195056382331j), 
              (6.4271870671511646-0.27444539129561774j), 
              (15.703645140666749-5.5192730883354679j), 
            (-4.4627880659734318+0.68688079513052336j), 
            (-0.55669057203424499-11.146373473789312j), 
                (10.923096624154384-1.7296688978371697j), 
              (0.90118626049968553+1.0197135338167214j), 
                (15.85243754401089-11.732525660541679j), 
               (8.0880796896103355+4.5996658784135995j), 
                (15.887303647640007-6.0613053286157399j), 
               (8.5828025115014235+10.372811277427745j), 
            (-0.72474123094597942-1.6060983840709757j), 
                (-1.9774215635187593+9.318271383548435j), 
               (7.7857614818391339-13.047339787926738j), 
              (-4.1586737279800783-1.4480126922612815j), 
             (0.23167768769299227-1.1199506969741764j), 
              (-1.9478775285952055-11.255342134510881j), 
                (4.1566843617802727-1.894361486345201j), 
              (-2.7199485140301838+3.1420736300687135j), 
               (4.1310631185172442+21.482262589136681j), 
              (8.3541191061745366-0.73279900476092286j), 
              (18.088450108070383+12.210660996797282j), 
              (11.737328647389926+3.0474901172051965j), 
              (-9.9990135028144618+2.6688633803272683j), 
              (-15.94181815864486+19.532917911275714j), 
                (-17.54965463142296-14.942694439396377j), 
                 (-20.502580035849+2.0842902611305116j), 
              (-7.1330887512845598-3.9186164793371314j), 
              (-15.845403712509103+19.754622259057232j), 
             (-4.2204172575151917-0.95537339730837623j), 
               (6.2458359839822979+10.808972038042556j), 
               (-12.379511222825414-3.8787894856568887j), 
              (10.162264585116812+3.3537738636085828j), 
              (8.5282179666185574+8.7673639749144563j), 
              (8.9165579248485205-9.2734147509289855j), 
               (-20.95066333466546+18.072695900527879j), 
              (-9.9411351186513688+3.7622267990979719j), 
                (7.9827501004285857-2.8690872492425794j), 
               (-5.8107162797370311-11.42906622925722j), 
               (3.4320386368664852+3.6397010430013381j), 
               (-20.81373422614211-18.634036524376185j), 
              (13.749060000737909+11.614521093155981j), 
                (2.6510859474447712-5.3380437911369736j), 
              (-5.4030447123519405-8.5667189933018602j), 
              (2.4394673845172359+8.6587282212322005j), 
              (-4.2223921125808497-22.691933263204373j), 
              (-13.399486529279386+4.3335799348122634j), 
             (-6.4147337738711201+6.3084651453774132j), 
              (-11.925946920940454+10.618279206982013j), 
              (-9.6936606453405574-2.0541971969162978j), 
                (-6.4632674936899015-12.0168762076813j), 
               (17.328003594920212+0.964809334439647j), 
              (-8.8053955541799418-5.131777205606034j), 
               (2.8580459753793281+8.1852023479816047j), 
               (1.0847522486770296-14.275076841441415j), 
               (7.9660375320373289+1.1154710272078383j), 
             (-6.4342231248195478+5.0540928279654453j), 
            (-4.2761768467743808-0.0031682929549314062j), 
              (12.444429754843469+5.1397417850937277j), 
               (6.0560630236895427+1.0424826476405875j), 
             (-6.7523022078415611-12.249897836336674j), 
             (-1.8372825370972401-0.96491122578185307j), 
             (-0.23133686894849584+3.3560641518207222j), 
              (-8.7917749968831327+4.2915349834751124j), 
             (-8.9913041031135847+7.1587999833046565j), 
             (-5.1703154551443031+10.781021116649992j), 
               (-8.7785476336698629+1.332633773271906j), 
              (0.7621629541833751+0.49133558684987505j), 
              (-10.788232706732561+22.201782835313001j), 
             (-1.2144764053908896+7.1797359554125944j), 
              (11.019377833139171+10.380161610118231j), 
               (19.929352899977211-2.3377476313736554j), 
                (2.4291840600778669+9.5244507363706337j), 
              (-11.286348082890873+13.025957553852148j), 
               (2.3901019420570249-7.0256074344996069j), 
               (-4.2773883837912932+22.854321911355736j), 
              (2.7842489719117411+9.7901881346436159j), 
               (7.506010756616222-3.7516616962382732j), 
             (-6.3093274751777306+10.099796092526624j), 
              (-16.81076419846065+0.95067762456675009j), 
              (0.72022160235389665+9.5876013262040871j), 
              (13.042487201435375-0.98809039403273857j), 
              (-9.0046466381274506-2.022071506996685j), 
             (0.86826643161690176+23.164392642729542j)],
       [  (3.4628155904500564+15.484362335398341j), 
               (8.8875004685148653-6.3103275922801529j), 
             (-3.3417069254442264+8.9205587715540329j), 
               (6.0249789110323899+5.7002967199760812j), 
              (-1.6300956157118218+13.66830669479066j), 
              (-8.469440075567471-2.3837022260029817j), 
                (12.12198459399837-3.6142286445647072j), 
                (8.52541247859617+6.4508316934275562j), 
               (7.3104248661862439-16.992260968787029j), 
               (8.0824927086268428-10.757341563368056j), 
             (-14.013278592130654-2.5676082187634264j), 
              (9.9334373249360333+5.0360116097710952j), 
             (-15.708396531698634-8.3857098424744141j), 
             (0.21785111257311443+3.2122787344902877j), 
             (-7.7942707408686065+2.0124310832239569j), 
               (2.1442214039830425-6.1606401118153995j), 
                (3.0787750910862877+9.3360495743438925j), 
              (0.14032238725169582+4.3929793084208777j), 
              (13.684503251719345+10.062784131626703j), 
              (3.5267109772517453-21.760618815988025j), 
              (2.1384417268100648+9.1463468421804315j), 
                (11.728685288029643-13.770617908232198j), 
                 (1.624509393773508-27.80923457997309j), 
              (-9.8430696882343582+5.7953373866520463j), 
               (23.471126575147792+8.4262539231979687j), 
                 (6.9149126647606014+6.310441611354225j), 
               (2.8051562490699955-3.3024706475551087j), 
              (0.6650914263114639+13.951773150332771j), 
                (6.8543291534144775-7.6080358973649487j), 
              (-16.246532871550784+21.310992894395874j), 
              (-5.2307862776742011-1.2018627437043115j), 
              (2.0188608948730193+2.1906967902445134j), 
               (12.532369424710108-9.1444665419248512j), 
               (5.1018605236754864-8.0648626289618957j), 
              (-7.2295136447922923+11.408910096560289j), 
             (-0.75127750888844136-9.8949897582933968j), 
               (-6.403405691795574+9.5619432047619313j), 
              (13.760285088489796+7.1034085344779028j), 
             (-16.705462865264892+20.664291521073572j), 
            (-0.039408756045654456-2.9743872426409128j), 
             (-13.283500774792138+19.752058593305811j), 
                (1.4430579400410148-8.8945182996577774j), 
               (2.8740725157626028+19.264941190142586j), 
               (5.3657897481809282+4.1927876806443436j), 
              (-3.3336040725130998-6.2985636311274638j), 
               (7.6383543868226722+4.7197285657049779j), 
             (-0.065449590963839288+7.697482970921369j), 
                (14.740911433448263+11.800232665911931j), 
             (-10.419213804886724+1.1214648607022253j), 
              (8.4370835003288356-13.746134828566932j), 
              (3.4631681330739217-19.633955442653587j), 
              (-3.9870286877501289+17.009481581263724j), 
                (9.894873973823028+10.490547771894727j), 
                (13.817150501405585+8.0052487328955273j), 
               (2.8018859617138641+9.1306035025256431j), 
               (1.4177287549399211+9.7141998080766321j), 
              (-6.7585583625385546+5.5861494826368165j), 
             (-2.1453472349184137-0.3247322175956443j), 
                (8.0702930449530328-1.8666164346617955j), 
               (4.6054412458764533-6.4399402858021846j), 
             (-1.1153097358807211-12.551718476197401j), 
                (5.932324306700723-11.467440418742198j), 
               (4.6780889073468028+5.8469375646103972j), 
              (9.2800593583773843-16.229588580314985j), 
              (-10.157945553884014+6.3712958614820172j), 
              (-5.9120626191989443+9.1387838300708086j), 
                 (7.695658078285752-7.493101052950724j), 
             (-18.704597325341791-20.725481580220304j), 
               (-11.7887837926265-2.7982303958085826j), 
              (-8.7588424000278877+12.627494384762411j), 
               (11.606684522233635+4.7282460397363488j), 
              (-27.991560918656297-17.386018480598537j), 
                (7.29183364802092-3.2131234196353753j), 
                  (7.8030631423415748+12.9662090216741j), 
             (-1.8447566738888117+8.1310298223579345j), 
             (-0.44823256428968949-16.122783112294513j), 
             (-9.8355598534700412+7.9040676744765452j), 
             (-3.5847600310423209-0.77174198840971309j), 
               (22.087972253383899+10.602547375937537j), 
               (5.7574276971025364-6.0293458035739187j), 
              (10.842721094027432+14.865678333075786j), 
              (2.7787806749186741-17.922942799313375j), 
              (-11.188711449284426-5.5785941011193172j), 
               (9.3713869726601597-18.744449040596727j), 
              (-6.5003025062651663+1.0474242794161031j), 
             (15.435726585329421-0.58220379582283122j), 
              (5.7023922490365191+3.6610289219375947j), 
              (-11.375139383843113+26.350125024344514j), 
                (13.967450472116514+3.1344911702246838j), 
               (10.685921960845912-1.9427159496860695j), 
              (-19.354442241744302-6.2198160078654965j), 
               (-3.5406537929897377-2.2213594018730478j), 
               (9.274463687228895+1.6211257907638599j), 
            (0.087067072548943664+6.6907996217849703j), 
             (-14.821106164866398-11.657346640336687j), 
              (-3.0130933126093025+2.5025255125306325j), 
               (3.6126811753687758+2.2435920466204688j), 
               (-1.7624503561217029+15.63590823476904j), 
              (2.0356190093778666+9.2509271962993687j), 
              (4.4093613452423002-3.9264893772037408j)],
       [ (-4.5961447159958517+9.5593966366807166j), 
              (-2.0576262188699319+4.2354146964086938j), 
              (2.3724070294368755+1.5350232241049564j), 
               (-1.084643502913005+15.160559525832319j), 
              (-8.564415577614092-17.357335952795573j), 
              (-26.09291283407461-12.256440618335393j), 
               (0.44754337986737092+4.575316582725053j), 
              (-16.70172627416488-10.776617860941084j), 
             (-0.75435340748900581-9.3486905209308944j), 
               (6.4346916844675572+12.334393708826966j), 
             (-4.7419441959751714-3.4108496820093666j), 
              (4.5995746370933368+22.115364021847007j), 
              (7.9515941611379386+16.746439802992509j), 
              (7.9535880379132129-20.617874699468718j), 
             (-5.9999017543528446+4.2764183443783361j), 
               (12.392923714613193-14.231680400932218j), 
                (-2.206529877228149-3.0253415158257684j), 
              (-6.2486467592790227+7.9002402344227391j), 
              (8.8820988382578676-15.637481897885706j), 
              (6.7706611878748788-15.431764455740815j), 
             (-15.026213843703456+11.296180335967605j), 
                (1.8790069112218668+5.7538216086781784j), 
              (-5.317359195900643-0.70929434484408116j), 
               (-12.325606492814176+17.82289410224816j), 
              (-1.5388829626750513+6.9783279948596642j), 
                (12.802258662967024-23.625398236779965j), 
              (-15.800759584279071+7.4678735752671894j), 
              (8.0741833258397566-4.2154015995076106j), 
                (15.536282637232809+2.1717842785197048j), 
              (10.542784423606266+0.52784784420080288j), 
              (-8.3183174214018756+12.651349101443014j), 
             (-5.8608798774106763+4.6472444383185261j), 
              (-14.778120525466685-14.135779044536944j), 
            (-0.016308614104183029-9.9169811049065899j), 
              (-4.8416280536105791-12.908079462280273j), 
             (-8.4249809011162871-0.35050489469959006j), 
               (5.6966708433389721+5.0890538540607624j), 
             (-6.7380957185239474-2.1966861522484664j), 
             (-1.5410157715532726+7.6147993354573202j), 
               (16.843843993849219+5.2068253557964717j), 
             (3.7685421253813001+0.82607775205945855j), 
               (-13.483755607004234-1.6427273331800365j), 
               (7.9417841726825333+11.944833581175331j), 
              (-2.8456785307392973+2.7967445052851621j), 
               (4.2132531354437655-6.0600220981160327j), 
               (1.6592484260634357-6.6506358427853645j), 
             (-2.4444896972022634+0.59127624277368596j), 
                (9.7231786618190714+10.092735322213004j), 
              (-13.648126955113916+1.726374348126265j), 
              (8.4135446639246272-6.1833643884192702j), 
               (18.41637632028505+22.639652519504093j), 
               (-6.5972488181985032+1.702088507853341j), 
               (4.2804696318295834+10.923907501384901j), 
                 (6.008873162461752-1.0314885928984383j), 
              (-5.6031979918509611-13.696423081488987j), 
               (1.8017788225151798-9.6990334335169273j), 
              (-4.4964227385684161-11.030886867543273j), 
              (15.708427123162693-17.007848400414154j), 
                (-1.870132133414055+10.406487638776312j), 
                (5.0319667490715361-8.819513475110611j), 
              (3.8316965798827951-6.9825118347964255j), 
               (13.943787060279316-8.8851560789201045j), 
               (11.669723605172797-6.9993729020961855j), 
             (-2.2806889983852887-1.1036111082242253j), 
               (-7.8352182400776389+2.845643851151932j), 
              (-18.257443830318504-2.5079641848448531j), 
              (-6.9001910348727851-5.5035771281279615j), 
              (14.523583505564028-3.1473877589603205j), 
             (-8.5631875051611885+2.2238925573157755j), 
              (-8.0194596963669653-10.515727492779343j), 
               (4.6779888638875047-10.709433074361154j), 
               (8.7927089162422973+13.966220270815938j), 
            (0.069532230797392403+7.8499466671267371j), 
                (22.953195437922172+18.572287377694916j), 
            (-15.716155114852778-0.18648588393817947j), 
              (3.0887061594442802-0.97475308203075595j), 
             (-20.265909034859988-1.3293721667702629j), 
              (-7.0529979110230432-3.2705689644303959j), 
              (-7.0711576439742849-4.4238354193463589j), 
               (6.0437473664476817-9.6641932616026054j), 
             (-16.923023141887729-15.704495616437431j), 
             (-3.2638046037926385-2.1494465928801008j), 
               (10.901887965278226+4.2978299097970432j), 
             (-0.87795165758708782+4.2360892049916883j), 
                (12.314796046796396+4.708451535201374j), 
              (16.850732848703856-4.0316509650825632j), 
              (6.3119894572024204-11.869136900956953j), 
               (1.0252360837861036+13.266444844058082j), 
               (-19.364797136175234-6.4200909998572699j), 
             (-10.570037461400384-0.79256039385993116j), 
               (-7.3353276664547238+10.63278650653859j), 
               (0.10520689008903712+18.287884176555206j), 
             (-7.5229751355465595-4.4465980608499045j), 
              (7.0509664273038117+7.6493582240399016j), 
              (9.9231794631128061+13.775359147354294j), 
              (-8.6603418922470397-9.9006488195750215j), 
              (-4.0504851246528357-10.426197651246497j), 
               (9.7066878474331215-3.2631318445166988j), 
              (7.1117104235755093-3.5863691928640891j), 
              (9.5433675574972661-2.7124654829763193j)],
       [   (-22.61613248431431-9.970334704117656j), 
            (15.754317414651185-0.0060724028828585755j), 
             (7.8104527331040794+0.13744357533641258j), 
               (-1.167105934688538+4.8688907311749849j), 
             (-5.6633723410351635+3.1347905969893035j), 
             (-10.101397331108197-2.5468582183426607j), 
               (-4.784598660896874-17.568895673579135j), 
              (4.6808589713861917+16.079434879314892j), 
               (17.194160544548907-15.903353809666349j), 
               (3.4840996011585195-2.5483502301517804j), 
             (-26.093334357166999+11.430710662780497j), 
                (7.67963308882302+7.1723908140250101j), 
              (-3.659554864331886+15.971238612505223j), 
             (-2.6358663072380368+8.0823474105929289j), 
             (-8.1667259415912135+1.8809634947396723j), 
               (16.142733858296445+5.0027345252858249j), 
               (-4.0216336732304461+22.385507679885951j), 
               (8.6697767324094048-10.018450124153489j), 
             (-4.4431783789693124+11.075849994801423j), 
             (13.949552489776087-0.51546569234054829j), 
             (3.6258120117171071-0.21905611644685857j), 
                (3.3103151495165104-12.052996410937787j), 
               (-16.04348170530821-6.2315141097092344j), 
               (11.058457236097464-10.351310918018665j), 
              (-11.305324156305506-3.4340007288690657j), 
               (-7.9944875389176229+13.804171171923565j), 
               (8.5699771370672675-26.069106641007153j), 
               (-3.5923604143701979-7.45363985440666j), 
               (-18.267600989121547-14.270721413556185j), 
               (15.570737901973882+17.460192912266407j), 
               (2.9606587168150944+3.4161630745285292j), 
               (9.647501702927304+5.8361719711044646j), 
               (25.890162944119663-6.7311075888603513j), 
               (-10.66264365549063+11.522127643891608j), 
              (-14.850410438430794-3.0368509131869055j), 
               (4.1573084775025695-1.2599779170441792j), 
               (-10.24867181004012+4.8755244724184541j), 
               (19.44769840439378+4.5598789361267151j), 
              (6.7195023102515989-8.7439875527062796j), 
             (0.034384210798740322-8.5630062190976908j), 
              (8.6969562043212196-3.0170922568088971j), 
                (1.0011341549633939+6.0478892169400407j), 
               (23.891157716213741+6.7147282814551161j), 
               (7.1508544887600145-4.5202869863355524j), 
               (13.188114045630719+12.093307694045629j), 
            (-1.0573354289736228-0.097759649690159156j), 
               (17.983495590005695+13.174243167547946j), 
               (-6.6554888674802761-2.4580015905738199j), 
              (11.410123490973376+32.299843878293181j), 
             (-7.5859882510922363-7.4747305083839288j), 
              (-4.147087167901061+8.6491376809587237j), 
              (-7.3865857775280741-1.2472199703876938j), 
                (13.403679103309976+7.702710434559954j), 
               (-1.8604930180127135-6.2017081456957701j), 
              (-7.0965667691641343-4.1165578518176682j), 
              (-8.6848537960733978+3.9615988790901806j), 
                (3.845643457105552-10.459112535791482j), 
             (-17.321882644814782+2.6494618070569196j), 
               (-6.7700828072125185-12.180668699870633j), 
               (12.614185504022101+2.2236824365648227j), 
              (6.5724531744307253+13.017018182664444j), 
                (13.83520868872866+8.8072622957472078j), 
               (3.7049733957037523+13.400296017253568j), 
             (-8.8202929449173801-13.673871880274497j), 
                (13.04169428268197-13.308447087865623j), 
               (20.828088668845318+13.370580312342398j), 
               (8.9079933981277915-10.703956362334498j), 
              (5.9404063352276149+6.8271060696757484j), 
               (8.6878915929904643+7.788532402480195j), 
              (0.65993514567122269-16.443113259856691j), 
              (-8.9694570148923578+4.5710654544294709j), 
               (-2.5555069538938708+7.083010904349659j), 
              (24.068973395672465-2.3886606682579203j), 
               (-9.8359950200892605-9.0877375572039654j), 
              (5.0251456380940223-7.8534661501495995j), 
               (1.4752415402382408-2.9047959894423641j), 
             (-3.9492123308705724+8.0911481022178382j), 
               (4.7019446412857064+3.9376463919615228j), 
               (5.9646072011798292-17.055303771146878j), 
              (-0.2715440274080968-6.8455342370673815j), 
              (3.0352948979833858+16.035523855047042j), 
              (3.1731981036688488+11.672626627836095j), 
              (-1.1751172930863689+14.874921783741051j), 
                (8.561094900065088-13.016067076704223j), 
               (12.891023933301158-14.935306769356346j), 
            (-12.261796521106037-0.47556394573196281j), 
              (1.1768252445688074-10.494639586681076j), 
              (-7.8766516363561028+7.4294289410481298j), 
               (-21.899443823063528+2.6472992728322908j), 
               (9.9085842538299822+5.4579183222938008j), 
              (-10.035589632194464+4.8172492414276089j), 
                (9.9714037245086189-8.6431367150553768j), 
              (1.6973580849929149+3.7947866978862157j), 
              (7.7222327698859399+10.647302417507934j), 
              (4.4286044165073033+3.2825144087052598j), 
              (-5.1481208369818763+11.467570225446948j), 
              (-2.2251315010379389+3.5612136182730962j), 
               (5.4330820917063924+1.7014911159953199j), 
              (15.646461574353472-8.9214068183410493j), 
               (-3.3691908020692045-34.1379213232849j)],
       [  (3.0906935519619743-20.478033634178921j), 
              (-13.681877518548236+7.9214436328610205j), 
             (-21.662658863871073-10.227085551340991j), 
               (25.738995996847407-8.9958998998089186j), 
              (12.225769764420019+5.3135372161459262j), 
              (-6.828362571735763-13.327943280835655j), 
               (9.9348462273933364-9.2713202703490527j), 
            (14.267398248131594+0.054748672206075509j), 
               (13.145088580783597-9.3691205886072968j), 
              (-12.410235811211061-6.7881475595832272j), 
             (-8.9493728707519224-3.2028653519222394j), 
             (-7.2400211750921217+7.7042838804207072j), 
             (-3.5036164741072238-13.633666649225436j), 
               (-11.585479928111937-1.35380916052113j), 
             (-4.4864453891620606-7.4382906722571329j), 
               (9.2991527699695187+11.470513575302368j), 
                 (-12.053352937901032+7.80125337767715j), 
               (2.4500416045231823-2.0065319613769632j), 
             (0.20658734517705141-2.9907145139846305j), 
             (-4.3616535384750659-13.182045780825881j), 
             (-6.5803838174679292-4.7463084551099124j), 
                (3.5372255288521188+10.968166054689551j), 
                (13.22717793370667-5.5105032350570475j), 
              (-10.621455742353357-9.0040004410578121j), 
              (-5.8977674970732679+15.952164577213328j), 
               (-4.7038193619040038+8.8599742793406886j), 
              (-4.6263172361826284+1.8092839151966988j), 
              (7.6202941427995743+19.064621462462622j), 
               (-15.187754203774675+12.922752848964238j), 
               (-2.872912242478221-13.199601446140809j), 
              (-6.0534167049183143+6.9993372438749208j), 
            (-3.8316770883843434-0.96856578877964794j), 
              (-3.4981506548167314+4.0873298251205563j), 
              (10.462635415457154+0.76753394872250458j), 
               (1.6781908816236193-12.638903094329617j), 
              (-12.237640909549761+13.621164091835197j), 
               (4.3108625490338879-22.601887979200722j), 
             (-3.8512023742516295+3.8420391216250325j), 
             (-1.5258971738203795-6.1502739684961014j), 
               (7.5433317114190981+2.5832246146096072j), 
              (7.8763346256128299+12.562850505226795j), 
               (-21.520622576251945+13.473839709653641j), 
              (-22.454274155826148+4.5842397331134128j), 
               (2.8232542121445849-3.7521225186967149j), 
               (1.1224229190974331-5.9792124110017175j), 
                (4.4536965779480244+4.744889664295874j), 
               (9.7868224960125065+12.354557554803396j), 
                (5.2487707251077333-15.902798036688468j), 
             (-7.0139218563201835+12.448295368962008j), 
               (-5.3776480910891769+1.07555838772492j), 
             (-25.697677887271748+2.5621378661184693j), 
              (-10.042085348093096+4.7018158972631561j), 
               (2.6518274803179769-3.8831947012273602j), 
               (2.8479828105827885-0.26954357119893035j), 
              (-18.453525225365265-6.7523033868807083j), 
              (-19.676710811838319-13.313963015347984j), 
              (8.8303271914017909+0.85451503898151748j), 
             (-6.4373133137749807-8.2295837306776427j), 
            (-0.54402357431958026+0.088068923603995403j), 
               (19.012634345059357-2.2149888197289496j), 
               (3.329808941991244+12.150874830503508j), 
               (8.2308234587136457-13.228803752590583j), 
              (-9.3056346995583397+5.4173356315253498j), 
             (-3.9292504429539448-1.0120502258154911j), 
               (1.7202678196860701-1.8334804077625997j), 
              (-3.3374567283439873+4.9267426776909611j), 
              (-16.645344958721754+6.3851666475711539j), 
              (17.487275877258583+14.787290075224229j), 
              (11.857806421883026+10.576007521445101j), 
               (-9.914259413031834-9.3911135168249729j), 
              (-14.960697714109433-6.5502390276571365j), 
              (-4.2955320955681708-14.062983642533419j), 
             (5.6756413577117693-0.73866626031389326j), 
                (3.5904727517018378-20.326212278416328j), 
              (5.8664850221580025-4.6041396087615958j), 
              (0.50905961919266929-5.5700825316569835j), 
              (15.494600121082261-6.6660373072093595j), 
             (-0.78672000455769397+11.607096681382412j), 
              (-2.7271827787716454+3.8069219749736365j), 
                (23.75706834974174+4.6481295436011898j), 
               (3.862166852635772-14.391112649585821j), 
               (-4.139007128164419+9.814260914014616j), 
               (5.6818743282965087-20.868796735710813j), 
               (5.3257916295438656+7.2201388000456497j), 
               (17.687522911656053+9.4249529923112068j), 
             (-7.6199627566374399-5.2161273650637296j), 
              (4.4882295569525867-4.7605322542613457j), 
             (-7.9269288448344497+0.26425162253005025j), 
               (-2.4956559565034873-6.5597581968740526j), 
               (9.1400760815887132+4.4527082796815565j), 
               (14.066485887982324-3.0919206239376185j), 
               (0.43063354785412444-9.1046451078294339j), 
            (-12.667273093364525-0.93674419154091693j), 
             (7.9278242154011904+0.75626083807333278j), 
             (2.8892384294650055-0.30862131490982053j), 
              (-5.0851200198940996-6.3114002631119002j), 
              (-11.193364445941313-2.2507344255579746j), 
              (-1.7570589286734322-17.070741258248351j), 
               (5.2657717213291502+19.12785618690058j), 
              (15.215822588264379-1.2837210567076249j)],
       [  (17.323572799472583+1.9369436438843119j), 
               (14.099676656632747+1.5030800972051468j), 
              (8.4179193485641406+3.6186422477623266j), 
               (5.3860430332384439+2.1426419955378155j), 
             (-10.133834668550614-4.7345333668178924j), 
             (-2.4723823600677024+10.883734360423173j), 
               (4.4128066867055082+13.874193374447907j), 
             (-5.7372247268014576+3.9293543553968542j), 
               (6.6387492650769167-9.4880286426914253j), 
              (0.21491795425408353-12.165935215909949j), 
             (-6.6802958836594373+2.2151060931490223j), 
              (4.2582158867487694-4.1416117226642362j), 
             (-9.3049488445956126+9.3983476308266187j), 
              (11.950269584313158+4.1692612944094272j), 
               (11.710026746293597-20.77626413204467j), 
               (14.735284441625893-10.380341609613517j), 
              (0.093545507350287493-10.339626650472777j), 
              (-15.473764191668691-12.171160522801255j), 
              (-7.551465764576716+6.4676900196279714j), 
              (-11.065626110042434-13.28186531182517j), 
               (11.738961422440667+14.48806730054535j), 
                (-13.459117095756675-6.039659301686326j), 
               (-7.008584249331701+11.382605457842519j), 
              (-16.657329127665456+21.236882290365298j), 
              (-2.3157950519897628+2.6108231605201344j), 
              (-2.3129490127198551-0.36701591828717517j), 
               (3.6076595629673882-7.4175539343015888j), 
             (-5.1145193013054335+4.5126114003556461j), 
                (-19.447724480284702-3.428227395473928j), 
              (-6.4941250644242263+7.4235491670380735j), 
                (13.186093810110718-12.44412116949491j), 
             (-22.361426979328101-4.6323672171428507j), 
             (-13.334743641223032+0.53269464010589074j), 
               (1.7937854301052447+9.0388777123016233j), 
               (6.6316788881249833+3.5474918622637865j), 
              (-10.929409102939891-5.3277405781639349j), 
                (3.126687902562618-10.197652244580137j), 
              (-4.4790354992757377-16.89840553695015j), 
             (8.0113165965211017-0.80182779571753071j), 
               (2.2254298959921748-2.6090811698176486j), 
              (6.9924234479393013+5.0432287027697198j), 
                (-2.188597447566309-13.014776105817054j), 
              (-3.4574748544878382+10.795686939833972j), 
              (-22.123172032518742-13.115451663968603j), 
             (-10.007684589208647+0.93479639993190478j), 
                (11.143030763425825+3.527389371403693j), 
               (6.9238020149892314+9.8364260063197797j), 
                (5.9936619424149162-13.192114654518839j), 
             (-9.4989039247758971-8.7052545362997495j), 
             (-17.864932780879769+5.1049821748812931j), 
             (-3.8282654718247926-13.500873570562565j), 
              (3.5910206741508506+0.48165994482717223j), 
             (-0.81039238439219907-10.326606216060538j), 
                (5.3334924531565857-7.2449962586783876j), 
               (8.6820869546420791-8.8987222624711713j), 
              (-2.6207454523200862-10.062574296324758j), 
                (-9.013437318668938+1.418377809533367j), 
             (-4.4588038713866647+21.962529837650244j), 
                (3.7711987824606035-1.7000301632172414j), 
               (4.1123539349437541+22.334105583156024j), 
            (-5.6652369634934985+0.61134934366328575j), 
              (-1.6732073684086228+2.0660925359164017j), 
               (-5.589800410374627-14.556226451555286j), 
             (-10.951956073623679-7.2128903185827511j), 
               (4.3202766373584698+19.332423182304794j), 
              (-7.7693290088094846+4.2690193821710567j), 
               (7.8605820448580941-9.2521382676238915j), 
              (3.0147853948501311+15.934111493530082j), 
            (-0.86516694413366391-2.9093028546564486j), 
               (20.108693810215676+23.921262450805244j), 
               (11.431953708361478-8.0167773151179968j), 
              (-11.784199446331638+1.0041080574617616j), 
             (-1.4964712207215105+6.2866637633921485j), 
               (-5.1871305811884216+1.7486848830756512j), 
             (-2.1441010767063369-6.2830222184302942j), 
                 (4.9687338274396611+13.2461297100528j), 
              (15.945515758799242+12.596529268732741j), 
               (11.435992152560653+10.346492330207166j), 
              (0.75415965364552739-4.4051888207968588j), 
               (28.455971066062897-11.021810347080741j), 
             (-11.383743975851274-12.365998313079166j), 
             (-19.108220161161388-8.8005902053525347j), 
                (7.653798828939923+1.1491003718293435j), 
              (-4.8274998449539943+6.2322326077458747j), 
              (-4.0494115426527557+2.4909236980331482j), 
              (8.0553410113047317-5.1734356140633313j), 
             (-16.164848626035372-10.024937284540842j), 
              (-4.3981914021478081+3.8054396400488466j), 
               (-21.495947018989675-6.5574234186509761j), 
               (-23.59464541558506-13.983543202162332j), 
             (-0.22229870686462821+14.025047371633235j), 
                (16.080841085535404-3.8766766949542348j), 
             (-18.787787962912599+9.2018657807630184j), 
             (-4.3102049508013014-10.821494405990544j), 
              (21.463624242365746-7.2818202577337541j), 
               (14.426163751853561-6.2107565710760539j), 
              (-1.7378778005432425-3.4577315954162247j), 
              (-5.6594564396394702+8.7126095313539089j), 
              (9.9493919752135032-7.9328105133227877j), 
              (7.1587432216558868-13.785458133103967j)],
       [ (-19.348478925902068+3.7534099121427031j), 
               (21.054334717751175+14.166182510900093j), 
              (11.292634692656973-1.4733579759106892j), 
              (-13.052067085446314+6.3941485415371027j), 
               (4.269571522825319+24.261843342471707j), 
             (-12.638574154224125-14.521120475722178j), 
              (-17.835418285993313-7.9123438109858535j), 
             (-1.5627119187838823+5.3604424998801097j), 
               (-7.674879292630119+8.3263104003484862j), 
              (-7.5643374002414276-7.7262319891882907j), 
             (-6.7084263731553211-12.320489013587711j), 
             (-9.3055212407738104-3.3228634999624846j), 
             (-7.8024180956408271-2.8378449575787585j), 
             (-10.572406959432158+17.490743117375992j), 
             (-14.707455242135286-6.2003821021451957j), 
              (-8.3964851394181892+13.587643886622045j), 
               (-8.7005186228442568+2.7880736339967083j), 
                (6.0612833143415941+7.932511053671516j), 
             (-10.821608309148306-5.7441944978300512j), 
              (1.3030472647122782-9.7349647377835389j), 
             (-18.720599751025826+7.0833048668412149j), 
                (7.6125431663793828-20.975397374252601j), 
              (2.3252256749626667-0.44200119257639459j), 
               (12.328959473776386+9.5162115664722862j), 
              (-8.0482129380999154-3.4859626747872134j), 
               (-10.970841963028199+13.255149956683825j), 
              (-18.968738365814882+22.199822934826884j), 
               (1.8643148955131481+1.398264194956228j), 
                (19.392623383602924-3.2555439355350946j), 
               (9.2945480645413685+4.5171231901610192j), 
              (-13.164883939459299-6.3826294657312008j), 
              (12.695480640049343+4.7789323148609366j), 
               (0.70086921392459445+5.100544036149671j), 
                (4.8747455297286937-3.356607052357977j), 
               (13.286036467068973-12.450743117509557j), 
               (4.6412801506711752-17.188604849708444j), 
               (10.118055354412673-2.8632768601641203j), 
              (7.5675048793850772-4.7356438200587245j), 
            (-0.78548374211990013+7.8905947153353493j), 
               (5.0198545838145066-4.3087838770615114j), 
             (-19.430603841464894+4.3799236485059829j), 
               (-5.8350034358661187-4.6298400262859083j), 
              (-23.482689092069833-3.0483579916697385j), 
              (-7.3640677610850789+8.5328132321083441j), 
               (2.0563963606653672-2.1060522127451895j), 
               (-3.3905439218948876+10.09377409932071j), 
            (-0.019043569759570167-6.7615037308303325j), 
               (-3.4343850445024549-11.471988791717479j), 
             (-5.8889619930463812+19.937861503595297j), 
              (14.790092012545959-1.5033484967729651j), 
             (-7.3199939063092634-3.4535088429498688j), 
              (-9.8647549806451682-11.619471431874684j), 
              (-1.9785837050903656+15.211450810489657j), 
                (4.4994897973534771+10.572863020838684j), 
              (-14.953518902159757+8.5586768409106107j), 
                (9.1766097415959553-9.347985220277927j), 
               (3.2959426018731453+2.7042622653155339j), 
             (-1.2677486731486192+20.452038327648175j), 
               (-3.4944496668652807-18.704951240566821j), 
              (0.63203399991164178-8.5616355842170275j), 
             (-8.1045945170418321-6.4088257383680878j), 
                 (9.124834321376774+12.51150687473616j), 
               (5.4025703132661329-7.5214982342233441j), 
             (-8.4840174826230292+12.384319867608713j), 
              (-2.4922238912611374+6.1891729314443058j), 
                (7.628953161412876+7.0362132464067138j), 
               (19.842957984750981-9.7385627669787809j), 
             (-4.4798256495938897-15.241136369853031j), 
             (-4.1429035074542595+1.6615300955609795j), 
               (9.2248788001579261+9.9992862484469924j), 
               (13.903450330287431-3.0904575959170604j), 
              (-2.5805521979307198+21.761136161641961j), 
             (-7.5675506400715626+26.091898401457115j), 
               (-1.2718949505773316+8.5684640531739333j), 
             (-18.953625904182775+8.2886767000914183j), 
               (28.829559792535623+1.9438854460604327j), 
             (-2.4311965472444235+4.5022327263545074j), 
              (-6.5703932406987766+8.3545820046068044j), 
              (3.6665608777626622-0.78887089375817443j), 
               (1.3861014127157514-14.123333181824513j), 
              (13.143520773640653-10.569614462146736j), 
             (-6.3796687299258092-9.2749217393547649j), 
              (-9.9916587782685404+3.8679153249839686j), 
               (13.426219537826473-5.5491282156583219j), 
                (6.919669070612029-11.272827967842083j), 
              (1.0084591624382124+5.1313114571355909j), 
             (-6.9608937310003016+20.261644212706486j), 
               (-8.936324666985433+3.8562499533215062j), 
                (-1.559405016656505-1.8532217634568207j), 
              (-9.1492828077055641-21.083739428590413j), 
               (-9.6851084864937498+2.640363618991425j), 
                (-3.5700586238273453-3.956153495338504j), 
             (-4.7565234404967249-14.008533061125876j), 
             (-12.917561419650438+2.5275308963005072j), 
              (-2.713047635476284-11.604525770229518j), 
               (3.7811302664895847-10.174569320438685j), 
             (-0.61120761163434134-6.5696238820510908j), 
              (-5.0352640088254583-4.5632689811104914j), 
             (-4.4787007298438226-8.8382368858738953j), 
             (-6.8079127499787457-7.5208865893087502j)],
       [ (-0.5056341292549883+2.9050193941773479j), 
               (2.1641908511578949+1.0669980241379575j), 
              (14.063608170576924-9.5170450850746402j), 
              (-7.0748064255397001-4.3787595669349146j), 
             (-1.2596994743276555+12.190340682494657j), 
             (-9.7104477180808875-15.950116961743316j), 
              (-1.1999255287236448-1.6677582528529045j), 
               (7.9427978127389176-4.507505910767807j), 
               (14.460008480588158+13.614236597029283j), 
               (4.8297226942339169+3.7289173541589253j), 
              (7.4846858924745092+12.983861530007648j), 
             (8.4472706527047787+0.21892972569078684j), 
            (-0.91168964644909378-14.905054499598746j), 
              (1.8000976622465827-5.1420237819516936j), 
             (-1.6200996488043327-16.122493995753395j), 
              (-18.218139190688639-31.305693980105236j), 
                (5.3537173076882771+10.127266804839078j), 
              (0.76015296769097784+1.9791465063914739j), 
              (3.8357808154920416+15.710902904958974j), 
              (-14.44881392783806-5.7944032030699608j), 
              (6.9609923447886537+3.1140709318414079j), 
                (3.0465763884561401-12.859825693830834j), 
               (0.5829017056599417+4.5658251125094704j), 
               (18.545970321622704+4.3367529380486394j), 
              (-10.251575706817984-11.098659158077794j), 
               (6.4375987136585344+0.58443311985914126j), 
               (14.656514362149002-7.0951416592612757j), 
             (-2.8045018303584861+1.7061187131543614j), 
                (8.0799587875400203-11.263508741658823j), 
             (-0.88314772950892173+19.196919463542674j), 
              (0.92332654287342741-6.4612873487755387j), 
               (12.088669796239234-2.368721056024325j), 
              (-1.6663826546226754-4.4243406118601376j), 
              (-9.3550336532692633-5.4494134300199129j), 
              (-6.2954069434644486+5.5746725228988439j), 
              (-7.6756813254689149-3.4761543135204609j), 
               (7.9086569822350707+3.1111993942205531j), 
             (-13.101298462262553+23.115814704600819j), 
                (2.099156037984601-4.840410241183303j), 
              (-7.5541311767473642-16.271900559951984j), 
             (-4.4471265267743494-7.5264658927872494j), 
               (-8.9445589880867828+6.4426807322481157j), 
                (18.386700334228223-7.000913150974938j), 
            (-7.0700056750924958+0.018830794502144945j), 
              (0.85462134331119499-4.1409785657052298j), 
              (-14.385614181201554-10.064239113851809j), 
              (-11.471415854862439+12.035983139999324j), 
                (-3.1776548134166576+18.64985336209584j), 
             (-5.3722562947303345+8.9259394161412402j), 
             (-3.8804301930019971-8.1775047634697398j), 
              (15.010774898977717+6.6909065408152895j), 
               (-2.1965294698651796+8.564179369761451j), 
                (-4.896632802915887-5.996559926899657j), 
                (8.7898020928715308+1.9178928677630827j), 
              (-5.8531420928681941+7.0321494799389335j), 
              (-9.3806601058965313-2.9883126779605185j), 
               (-2.308662740944591+14.809123797861901j), 
             (-1.4970680362245972+3.5994756321015471j), 
                (14.542251159209398+19.333210774480886j), 
              (-4.3575114329596918+2.3710314699579018j), 
             (-13.326409584402478+5.7006282203297935j), 
               (20.720336258908866+10.100858788001734j), 
              (11.095928460004583+0.33441970225019901j), 
              (20.487071250447254-4.3136194710244773j), 
               (15.820794317760685-7.8056683974406171j), 
              (0.66468512462753693-4.5477987727053177j), 
               (1.9651263406735744+1.8937320161861406j), 
              (-5.1947287713285366+22.74126380717675j), 
             (-3.3621703932751652+0.7039125661525838j), 
              (-4.4219741651039461+10.141463828002045j), 
               (7.8382527279224163-7.3040858945177414j), 
               (4.4973563691967717-4.1881525652324756j), 
             (-2.3708433402264832-4.9838858475282883j), 
                (-10.232674898288908+5.574821051256178j), 
              (10.379381358507498+5.5728800221234467j), 
              (-12.974155190362822-6.3111038804955371j), 
            (-3.5568536953614411+0.84812719508831869j), 
              (-20.591350223165708-17.732670728652295j), 
               (10.526878262959794+4.1504433207873257j), 
               (-1.710570686641314+5.4299918473199185j), 
              (22.057340717826584-2.4660272304080806j), 
              (3.3254938062244404-17.858187358391046j), 
              (-5.3047179690861075-18.093969304926478j), 
                (6.235779678184409-14.458258386543614j), 
              (-23.183546866015462-9.0741334161992331j), 
             (-2.7627526707655372+6.0791409494863258j), 
              (11.999857149870923-11.271455992024586j), 
               (22.278121758144973+4.6216664938095935j), 
                (5.3016909063531239-1.1575085376940548j), 
              (-9.5380171086886971-15.577922059830998j), 
               (-2.3849793082937749-5.793883004229432j), 
                (4.2565747364727544-11.080845719526069j), 
            (-0.20034145815006182+5.8912270657145598j), 
              (4.8359086006120924-2.3891626046227117j), 
              (-5.3772269228587959-5.580420413063127j), 
              (-6.3596682611339874-25.721396302721811j), 
              (-6.6312834495855286+12.478201648288493j), 
               (5.3996432780208359-16.634052617130941j), 
            (-0.055597432170545594-11.53585436067404j), 
            (-4.6378594514309359-0.25741399578347679j)],
       [  (5.3648347222644421+6.1854077762736051j), 
               (-6.983003641526353+1.9056271396466404j), 
             (-3.7146094000768786-5.1138712692571193j), 
                (-11.545737767765289+8.82204616325423j), 
               (3.6078265463205783-10.14678497193237j), 
              (1.1595698592820216+9.5381006803056163j), 
                (3.793338210223101+8.8414377563987383j), 
              (3.4088865213134731-17.045660470337985j), 
             (-0.30908355835053669-14.135362176872881j), 
              (-7.8637832826929976-16.781961782368754j), 
             (-5.3153286821676593+1.9034784117718759j), 
              (-8.7208563093187585-2.452866396191197j), 
             (-20.535531585224383-11.711778587096326j), 
             (17.545533622234647+0.38063462844201373j), 
              (3.5700118844796163-16.420372661707155j), 
               (11.079025969546024+9.5755886573939382j), 
               (-5.9773503160410471+4.6523820815171142j), 
              (-11.544236024832133-16.129519665155311j), 
               (-15.544940538741061+27.9924169291426j), 
              (-2.7884885762727434-10.41295232632957j), 
              (3.3381256030504387+3.9882920575894598j), 
                (7.5093913787106743+3.9808082204167543j), 
                (-7.63213206795752+2.5524769333058428j), 
              (12.754781414728191+0.12932673128354827j), 
              (-22.175997484022474-9.6677937723229164j), 
               (-1.4396551310663976+11.977136851453301j), 
              (12.692145229292075+0.66512924989687094j), 
            (-1.3052700263831625-0.54643515449323499j), 
                (-3.1301854655004409-25.49628027656885j), 
               (9.0580457875208413-6.3810696877798714j), 
                (14.541780358689236-7.966112183760119j), 
               (-11.9028653346264+6.5540325797899976j), 
               (11.102616023882936-20.345941143094674j), 
             (-0.34463904482123331-15.322398503560503j), 
               (6.0985790810891558+9.5756279084039324j), 
              (-15.154768097640748-24.488659604401299j), 
              (-16.900904359111536-5.6890807831791541j), 
               (2.436310161917405-4.0909813126244323j), 
             (-5.5705076402854594+6.7648024104345552j), 
               (5.4696532980476746+3.9280480093873016j), 
              (24.709986692633791-1.9308276625547551j), 
               (-5.2526551705725488-15.163955465385451j), 
            (-2.6499623015446341-0.066430263829360972j), 
               (9.8522409422449453+14.715098679594922j), 
               (-2.314695868631095+13.678662927304117j), 
              (-5.5938830050257069-1.7869587119962196j), 
               (-11.380078643499072+3.525969102164777j), 
              (-2.5102222110997134+0.10353787359457191j), 
              (2.8200039873145508-9.4548566858675684j), 
              (7.7806692427924116+14.438313376096005j), 
             (-4.5797488608798131-9.5036744021068316j), 
              (-2.9453805588197994-8.1146670886795267j), 
               (0.1071302436346136-9.6765633423098834j), 
               (4.0516681251463709-0.88983953523180348j), 
               (4.8686151009364407-23.420379669255041j), 
              (-9.1708604618613876-16.799396170184604j), 
               (4.6657117161492314+5.7910121640529955j), 
             (0.22706674644340677+0.4711596859518824j), 
              (-1.7623365085174745+0.18595357696259782j), 
              (-5.3807463860861517+1.5492335647676341j), 
               (8.103410320180501-2.7146609889527751j), 
               (13.915050818217868-3.6382821392680036j), 
               (12.110223980501964-12.085833649712825j), 
             (0.85629554221328108+4.5902191921790392j), 
                (10.073944099206265+12.84381213876866j), 
              (-0.6106589665283636-20.925938520916162j), 
               (8.1867799443236731-10.350626442287616j), 
               (3.249896474977473-12.008917222276462j), 
            (-15.244408493971868-0.78377254911737093j), 
              (-2.1466749162112659+4.6992086165855609j), 
               (15.958154947972094-6.1180679057141401j), 
              (-17.115832739277849+2.0860059333311014j), 
               (3.9216509710225478+18.75308040657282j), 
               (-5.2989727628340644+4.9313462982136667j), 
              (13.698553412533158-13.525367792327359j), 
             (-19.064610501343473+0.66383520519424433j), 
              (8.5479748693080762+7.1214710521089177j), 
               (7.9958085321968646-1.7643782486045656j), 
               (7.0954376034614235+5.8521238221281298j), 
                (4.033375879813244-16.482812562979476j), 
             (-5.3929001077451666-18.520868938220605j), 
              (6.0126893017803527-9.8900325295802389j), 
               (4.9676640352580064+5.2785145959186526j), 
              (-16.489943564156064+5.7630117491736446j), 
              (-5.1057535537828871+3.2693944146140099j), 
             (-12.895200581614958+3.9519435228270723j), 
            (-10.615792850547889+0.54976160379066552j), 
               (5.1749851548657801-13.279379669815057j), 
               (-7.5858137650988846-2.5150864808198441j), 
               (10.082866845127651-15.952454234895615j), 
              (15.809689624555768-0.90720018505645206j), 
                (1.1413418443215282+9.4138408213443157j), 
              (11.373204331491152-8.3046198325674307j), 
             (0.21172648935287236-2.6115111997223228j), 
              (8.1968369236892116+1.5343503551394224j), 
              (-20.120581252278239-2.0083058278188388j), 
              (-3.7617245787842437+3.4750730185114076j), 
              (-17.913406075395464-23.133476330222599j), 
             (-0.6826391450592445-4.2257314072392331j), 
              (14.923123451222835+2.3608493726862965j)],
       [  (18.350117197404987+3.4524803187013129j), 
              (-2.6607773501262493+19.416132739939478j), 
              (3.7599395727513381-4.9189403629791082j), 
              (-6.3883753887499672+3.0174923749021061j), 
              (-7.827813269269126+5.2889133691871688j), 
             (-6.7036985774932658+11.469656577538618j), 
              (-14.364949772687828-4.7711710826431117j), 
             (-1.6035469448629993-2.1270632190624466j), 
              (-24.461720944781653+4.8420935790315429j), 
               (17.876544484817867-5.2200566732254439j), 
             (-9.9588598793271341-7.0444719721633007j), 
             (-17.923793023995906+6.5825699934294466j), 
            (-5.9846097293006695+0.24802833043358452j), 
              (3.2276178755606413+3.8713562388652436j), 
               (19.23161750845734+2.7120976361579241j), 
               (4.9703809905958112+6.1579731519342937j), 
              (-5.7199170104162045+0.33702233709796919j), 
               (4.5964120259618237+2.7977507349815731j), 
             (-6.4695607746061512-17.645194585590318j), 
             (-4.8746687362193502-3.6449070644241335j), 
             (-10.472484442662452+9.0987458971445019j), 
               (10.581283357090609-0.79329852231166331j), 
              (-14.686045750372134+5.5032109577964352j), 
              (-8.8064004727265104-10.810813713168706j), 
              (0.57635866084764298+1.2388629451499884j), 
                (27.693317462698683+4.1294818502928212j), 
               (1.8113582189347566-6.4111482408564235j), 
              (4.4826480072523776+7.4608776138016353j), 
                (-9.028878839112954+1.8411611844754494j), 
             (-0.99139842059954542-1.4156467469960479j), 
              (0.22731633429408393+12.748917971871274j), 
            (-13.643925277905449-0.59162133505179837j), 
               (3.9569497716195534+2.1650235419094535j), 
               (9.5581126636957343-5.6306282667200573j), 
              (-1.3985871903804976+24.199440446844825j), 
              (-0.2188242497785492-2.8051064088099946j), 
              (-4.4828312885489785-2.9918169557397949j), 
             (-5.5143782268800834-1.4701780209049062j), 
             (-5.4786644472009263-7.6907043303298641j), 
              (-11.640082202167982-8.0971018458857884j), 
             (-7.4342622401304919+5.6784969503776903j), 
                (7.4952009217911417+12.361732735564921j), 
                (8.7391193903835003+15.59977173771057j), 
               (21.758310173696547-4.4406989519378479j), 
              (0.20535375730365557-16.927487410161437j), 
               (3.1348252874089577+5.3312754020437749j), 
              (-8.6751095655429129-6.0041923944709605j), 
                 (5.438378175003475+5.7535802756828778j), 
             (-4.2079600313093728+11.834243787989738j), 
             (-3.1685968028815386-8.3276711432362909j), 
               (10.28968111580442-13.018142882367856j), 
             (-3.6593153001852867-0.47450357594096637j), 
              (0.69970380860379122-3.2848346095604626j), 
                (11.612613394410305-12.681120453978799j), 
               (6.1069725963512456+2.7270050883094448j), 
               (-3.115896342970907+23.665627755683957j), 
               (6.4311915503620121-10.384289765065454j), 
              (9.6015237092351899+6.6502495568102216j), 
               (-4.8552673749521071-6.1461291610457405j), 
               (11.276813512320103+17.401502253489195j), 
              (2.5610907555555555-18.077142578849735j), 
             (-3.3843422761441886+0.47033265094891175j), 
               (13.609401528248693+22.002678135172459j), 
              (1.5005134526254251+9.6051285809945028j), 
                (10.57701156898978-3.0157321197306497j), 
              (-0.2841083658900575+1.0929966730262812j), 
               (-4.725978720562324-14.958707075636378j), 
              (-9.133302568499742-2.4848335524330469j), 
             (-3.2364035672618212-7.0574080316269514j), 
               (1.9222652811507848+7.6534602625151269j), 
              (-24.935771411300728+1.2665526094960311j), 
              (-14.299781643252985+4.1301799339528191j), 
             (-26.999566016665749+30.662616989025008j), 
                (9.7538023909780414-8.2985290613782681j), 
               (4.6713733756613536-2.094615431994491j), 
               (3.9489766469702108-9.1998178606235737j), 
              (4.1276174202114131-6.8983067477849138j), 
               (-1.5224017401123258-13.26676555183094j), 
              (-26.852808594863752+10.304573512157372j), 
               (21.958149611975198+18.643696420704586j), 
             (-2.4325391256327249-9.9642435030776255j), 
               (6.7343391008149869+9.937157569833504j), 
               (1.5198547833924638+9.2906339585277937j), 
             (-17.241921301314562-0.62121076871459002j), 
             (-0.49567053629256408+4.9014852556758024j), 
              (8.1974843923793035+8.5994811512317675j), 
             (-1.7034798550481494-5.8617542493344823j), 
              (-3.9777054557225995+5.2617360947988328j), 
               (-6.4953318061082941+1.7771115339956753j), 
               (12.923591061315165+7.7283655336696491j), 
             (-0.10482600805667151+9.8884218311150764j), 
                (4.0264814343692343-10.475373793494002j), 
             (-2.8424247670719587+8.8311758704954109j), 
              (21.957262571997092-1.1359429002843913j), 
              (8.6185337793127008-9.4545581422574312j), 
              (0.55230533651389768+1.2192097048764263j), 
               (-6.166287624081523+7.8670928194908321j), 
              (-17.384249581586204+15.104709170127329j), 
              (12.288388424510387+1.6685957814713648j), 
               (3.706059997412432+4.9155476962116591j)],
       [  (2.8925964719901707+5.3772313358375667j), 
             (-3.8855166407670847+0.69405206311421308j), 
               (-8.5236736142731271-12.5038894031476j), 
               (4.0352647417744523-2.7893132675603702j), 
              (5.1188961985086303+11.784178743040147j), 
             (-9.2863690935667655-12.620214000537029j), 
               (4.5154481381561036-6.3434550623935815j), 
              (-22.543219124561986+6.988783746100796j), 
              (-1.5077283431578725-3.0306762548530859j), 
                (-9.309095433580941+3.043181221528426j), 
              (2.6769944264780881+3.2852306339186126j), 
              (13.405133244178289-2.3523722286456268j), 
            (-9.9018976871795381-0.74307132100451356j), 
               (8.476421401466677+2.1539249755731293j), 
              (-14.293879303626362-5.151659977769464j), 
               (4.8390083238032942-2.0993781539580545j), 
               (-9.0217747839986089+2.6421401608756234j), 
              (-7.0382940145019957-2.0719180842418048j), 
              (2.9782089064444421+1.9455737750783162j), 
             (-16.155339880861003+14.211166604088259j), 
             (-17.526457917615648+12.738563776382311j), 
                (-12.89537255579496+6.5690631695069603j), 
               (7.9893215921072072-5.6042891054219091j), 
               (14.940943982856524-18.966269541576828j), 
                (-2.6686430293599468-18.7622492976015j), 
               (-2.3704072480437501-9.5234756763414214j), 
             (-0.89943536049127326+1.4078653620152446j), 
            (-3.3843036221240346+0.32971807639423872j), 
               (-6.1542018466499213+2.1079135911271134j), 
               (11.443221180131697-8.1594427708770816j), 
               (-1.6782780535809241+10.20379124591113j), 
              (2.6085920427652804+5.3106856992890163j), 
              (15.596256457996445+0.55476820374054869j), 
               (5.6970503112051993+8.6156364035472794j), 
             (-0.66828278998143187-9.2528423871149172j), 
              (-12.921346940027725-11.586674076174027j), 
              (1.6559216132370378-0.18632577024747915j), 
              (13.195895098657642+3.8780058747519321j), 
              (3.3962628619683115-5.6076048882223892j), 
              (-6.2585491470089982+9.3397878773941674j), 
            (-2.8831767493670175-0.61071418823390089j), 
               (0.25408786164360952+13.692236420821365j), 
               (2.6885621923222858+15.193351916004049j), 
              (0.66477820105991769+1.0041090161152924j), 
               (2.3999301049461828-26.391580633387981j), 
                 (7.53188257816924-11.466698173574542j), 
                (-9.907362940694556+6.634008107468591j), 
               (0.34069601063878863+5.8551843624860886j), 
              (11.153035236708302+7.4130469710737534j), 
              (9.3169035890032621+13.517165944887541j), 
             (-7.0733881978457189-11.908278603317264j), 
               (11.369010708397862-19.007354760827425j), 
               (-1.414676158758952-4.3226119269565348j), 
                 (2.0625463359868719+3.018212356959812j), 
               (19.336021526296175-1.6719046713354797j), 
              (-5.6335198929320507+12.275555525418071j), 
              (-6.3928685340432523+3.7660120002103694j), 
              (7.0330465592031564-5.3132243622175332j), 
               (6.9874154372368764+0.13012121026186574j), 
              (-0.4730173355220344-12.704623887140833j), 
            (-8.4761189490974012+0.67946226531801812j), 
                   (8.8649474621093098+18.63443421705j), 
               (17.653859534839363-18.342279422338127j), 
              (12.708083500715144+3.1755033605000622j), 
            (-0.035020489888197996-4.5722630159310915j), 
              (-13.522751365187393-9.1273678574970667j), 
              (-1.2247289638103844+11.942651816216346j), 
             (-8.7120371149026781+5.6035635977751621j), 
             (-8.4739539925557654+9.6666493863565321j), 
               (12.276108711528316+1.0987828847713437j), 
              (-9.0875577089819561-10.828927569057996j), 
              (-5.4646857140509102-3.5861705433662499j), 
             (-6.1107310210843053-10.456081662755874j), 
               (-14.086079316155203-21.933050416786742j), 
             (-14.060003991385075+1.2100225319259674j), 
               (3.1897293612396811+2.0264327422923976j), 
                (7.8593504307937865-2.77979779444393j), 
               (8.9415274420760653-11.602524803397252j), 
                (9.174366210719354+7.1378788712489278j), 
               (7.8142310878599899+4.6459250717729619j), 
              (8.5151812634109767+12.229258907987148j), 
             (-26.042009919882876-4.0455027150386522j), 
              (-15.257426491335405+12.431671335245845j), 
              (-4.0741002087656826-14.727847406676581j), 
              (-2.0078117071387735-12.130329617607778j), 
              (3.9844487410002349+14.328905532917069j), 
             (-16.832821369053981-1.8059621635252878j), 
              (-4.6636574965349489-9.8006817469020895j), 
                (26.994440759123421-4.1956214427035343j), 
               (-19.92252614155144+9.3431881326925144j), 
               (22.249452067505231-4.6441441180377057j), 
               (-12.369332570690958+7.2095674628912834j), 
               (0.748928089873936-13.063060475121782j), 
              (-12.81759538851002-1.5778864968521571j), 
            (-5.5343522323326431+0.88785946582466246j), 
              (-12.974459287649074+6.9666224483897867j), 
               (11.563273174388902+10.398000448585643j), 
               (1.3386378833047665+14.355764777128513j), 
              (5.4212865152291245-13.356421616951097j), 
             (-9.7270237148814491-23.244608694343842j)],
       [ (-2.4824355741400161-12.892955247898115j), 
                (-12.162757097094548+4.45722020085607j), 
             (-11.52094013146176+0.67578564614176373j), 
               (5.1340331108959774+5.6107604286284607j), 
              (23.738287070330863-5.3662546933991369j), 
              (5.9894042215671774+2.7183426520761249j), 
              (-21.897641506915573+14.374587682175353j), 
             (-16.180342523067797-13.642949693647646j), 
               (22.376999571218338+1.3742423569111648j), 
               (18.770755305256749-5.3800173481722799j), 
             (-10.779854269837072-3.4561690806201484j), 
              (-7.527457116785147-10.015546341973081j), 
               (6.2565711379926556-3.341407145729522j), 
              (18.271590167165886-4.1332242128345609j), 
             (-8.3843194451140857+32.371197105417721j), 
             (-0.62583479708949907-7.6660544296053192j), 
               (-8.1030997526662922-15.166964428900267j), 
               (1.9410657293567903+6.1864265772882447j), 
              (9.2630897593955535+3.8543712518959743j), 
               (13.474969927262334+25.67359356870336j), 
             (0.70831759177110443+9.3415731344034452j), 
                 (-4.719480080473005+1.339526891702816j), 
               (-6.9745297461833164-3.342763027296789j), 
              (-10.857928981942738-20.657276590542981j), 
              (-2.7256862126998751+11.526491746983281j), 
                (-2.100759553872908-10.619434254167752j), 
              (0.67613175006120674-8.9509444831235836j), 
              (-3.635245047677802+9.0121828597746223j), 
                (0.54585105865105554-10.38508507110431j), 
              (-6.4627489210324809+9.5613727393393582j), 
               (-5.642105804429189+2.5107280313538007j), 
              (1.4399055170748296+4.5170374743633328j), 
              (-4.9420032454893423+7.9689614454396676j), 
                (3.4682064027466564-5.039528282468134j), 
               (5.0464903993360091-15.333086373446246j), 
              (-14.584526334221135-7.9190496595874826j), 
              (-7.4458493915671156-6.1048407105533578j), 
              (3.319078424688314-0.63517232170833915j), 
              (14.991121566609051-12.646000360840999j), 
               (4.0489829194675844-19.872600489351843j), 
              (7.590653705875158+0.18697360754627221j), 
                (11.014613509978094-0.1511605961614586j), 
               (6.1441107044579981-9.6936344500960772j), 
              (18.992995828411825+0.88696951039572203j), 
              (-18.154769367899817-14.359284351582438j), 
               (22.335892088569338+10.850933366670649j), 
              (-9.9301734383519769+9.5344810454615665j), 
                (23.054372196223078-10.254536238110186j), 
              (1.9219410792317713-7.1644924789768467j), 
             (-13.301839536841504+6.0631018114345148j), 
             (-5.4588811834162199+10.127526449983716j), 
              (-7.1472139679101172-11.652179502871221j), 
                 (14.21980897188984+4.993209285050467j), 
               (-9.2888263216500064-6.3621925376905555j), 
                (3.3370906922829136+14.34457444789456j), 
              (-7.2021321263218177-3.1938460240499422j), 
              (-7.1654704577612529+12.726266125487406j), 
             (-5.4207904947904257+9.9022098762002742j), 
                  (1.01469749528151-4.0542274401636211j), 
               (4.0429398233205385-7.0069341903468763j), 
              (13.367448131415042+2.2163732396645672j), 
                (-9.234791690179069+13.49781158106423j), 
               (1.7081395517233189+7.8283658123797686j), 
             (-6.2613945577414061+11.769948479606038j), 
              (-7.9341540490307843-1.2640295123080261j), 
               (7.5592626413170141+3.6727312428255003j), 
               (7.8565466399097019-7.0344366007426888j), 
            (-0.77396613822805271+1.5410265975913675j), 
            (-0.88476931300381023+11.332901694959993j), 
              (-7.4285151089568036+1.8597716699145614j), 
              (-8.7925589820878951-8.1726244191872262j), 
               (5.7744241420358398-6.7844871425889917j), 
              (6.5336492733665015+9.6182863388256585j), 
               (-14.524542993698724+2.3762653240356366j), 
              (12.443352072318705-6.0672056378404875j), 
               (18.122093088826176+13.599352169907613j), 
              (-1.211463735445131-23.682534317626221j), 
              (-5.2988464140832949+7.9176015323174385j), 
             (-13.132527426108499-0.92377484275942856j), 
               (1.6500122591064388-9.5399652094213145j), 
             (-16.761534538974985-13.831906141928981j), 
             (-5.7750047368404669-8.3078638425044478j), 
              (-2.0077703328506367+7.3460186118325153j), 
              (-1.1825483192277426-4.8181857236922729j), 
                (7.9498294717974538+11.28411504382629j), 
             (-4.3632178899516205+4.4030637155860077j), 
              (2.9969977953809259+1.7231478693507811j), 
              (3.6434855858522424-0.31976277178484913j), 
            (-0.0021710367386692498-5.1962643028360436j), 
              (-2.0751643017151284-2.6128508351218969j), 
                 (10.74403896172894+2.236506775095997j), 
                (-5.209271718506737+6.5110209940821271j), 
             (-15.152521647044171-11.430375997298306j), 
             (-9.2781448074627342+10.637455882908903j), 
              (15.260099635056219+6.6879233274027774j), 
              (-13.001236073143795+8.6168269147176062j), 
              (-14.357022934222947+9.3577578929006542j), 
               (8.3032392113492897-12.275670362811406j), 
              (2.0038437670619733-19.847806722787865j), 
             (-2.6786929380192088-7.4613641485911248j)],
       [  (11.328235569806216+6.0434972431002691j), 
               (3.8675180530772324-16.845160892970497j), 
              (2.8684689185062724+1.8194344386832484j), 
              (-13.535170017626585-2.7249140485159251j), 
             (-1.2424232329832567-2.9646823438064818j), 
             (-12.361500901600596+12.502021481529459j), 
               (5.6046489782081546-12.920300865559557j), 
             (-5.1921146605554238-2.3257445574706228j), 
               (-7.1588508731305946-15.66377913204686j), 
              (-11.527594193475586+2.7981866414612204j), 
              (19.436215238906286+7.2748166282543911j), 
              (12.134147327000562+10.721612685808424j), 
             (-1.7434700245770953-4.4244241068223209j), 
            (-6.5403434788402333+0.21113924244253357j), 
             (0.79667896554500695-14.504534482700137j), 
              (-16.720117113252829+5.0273536177272957j), 
                 (-13.3953175802675+4.1731408250103499j), 
               (4.4096860379796512-11.859492695320039j), 
               (3.0531440015875471+9.826674885429119j), 
              (-9.0823707416451001+10.71041306640131j), 
              (-1.523418468165874+6.0900566673851921j), 
                (2.2489142793599015+3.2399220520926213j), 
               (2.1606802899302422+6.7665230635902791j), 
              (-3.0378280993793028-15.706081438799986j), 
              (-12.330978724404444+1.7360584277874527j), 
               (9.4510126127954415-0.42157390219240393j), 
               (19.35273325416026-0.67594791417125744j), 
              (1.8659785337115318-3.9027555023200082j), 
               (-11.288572836607781+6.4151219325627338j), 
             (-7.8516190279126699+0.71624294676351496j), 
               (3.2371944361644847+14.514582150105142j), 
            (-5.5875637019849407-0.51422444206466178j), 
              (7.8009773213915725-0.95460599567508342j), 
              (2.3238705137530031+0.67143920574049731j), 
              (-13.369058364904891+9.7077264924836015j), 
               (5.0255656718162136-9.2717537884225969j), 
              (-7.407279738305462+0.41930377335034674j), 
             (-15.666691188650827+5.3781138928811654j), 
             (-6.5199003778152198+12.183139247094253j), 
               (18.190576290514308-8.5004684012318013j), 
              (7.5845468550667094-8.1711198230836075j), 
                (8.1671718166252045-14.044971573747382j), 
              (0.65654992425672287-2.6742648872639285j), 
              (-26.879718262803152-16.458913844828302j), 
               (10.052638354517677+2.7270879759131113j), 
               (-18.796640691660883-10.43019933824959j), 
              (-9.7287557134872458-1.3177475910042333j), 
               (-12.557497168856882-5.9079283250083456j), 
              (26.352715348389349-12.001256676983477j), 
              (-12.72412130497573+10.167227451493996j), 
              (6.3278708904435286-9.5131972677974872j), 
              (-10.680027281124698-2.0100867951424997j), 
                (18.449929276375862+9.419243898171727j), 
              (-0.78674340164366097+1.4772353050355702j), 
               (5.3653927038119198-13.248172176791472j), 
                (9.296164850191138-2.2687338331543287j), 
               (21.905262808665885-2.0118188866500626j), 
              (20.770099504429488+9.4716084493615362j), 
                (17.356728663692589-5.1648886674473466j), 
              (0.81338789905032061-22.136685441881816j), 
               (8.295807678902742+1.0090318205950184j), 
              (-3.0714068613558969-20.193129715988746j), 
               (10.310697818766229+1.2295141823510363j), 
             (-2.2084153870431704-2.2219840522308205j), 
               (13.870177939676179-7.4569667218236804j), 
             (-18.052437939571377+0.25628497970097786j), 
              (-2.2771504435393601+5.6540878172078104j), 
             (-8.1055344971059711-22.453981882306479j), 
              (6.2966940324374141+4.3738102736272362j), 
              (-15.226490812182536-8.6520147817730493j), 
               (13.762797605556623+10.780989614578964j), 
                (3.201560505428791-7.4740107278141839j), 
              (10.364385681497623+21.663868714597175j), 
                (11.336409631429552-5.6531345250676477j), 
               (7.959333372651697+9.4696207016167229j), 
             (-6.4102848186578774+0.15928248391580896j), 
             (-3.0588636837461793-3.4685028595999086j), 
               (13.934580145192953+5.2244680292075794j), 
               (1.7625017632591533+7.6840163492062796j), 
              (-5.9393202340129472+21.871984391978891j), 
             (-2.4562415462065079-6.9507450881061263j), 
              (8.7630180340179304-2.4332841541715169j), 
              (-2.9896906679155606+14.820985114093578j), 
               (24.709613184735328-15.666245045063947j), 
              (-13.288476603841966+4.6024937708226235j), 
             (-6.6689160356471966+5.7007982579093905j), 
              (-5.1280970740698661+12.98937352031286j), 
               (-6.231362070644769+1.9703681127481512j), 
                (-25.42112645271494-4.5844590235821832j), 
               (7.9237466709846203-6.0403722531959207j), 
               (-2.321238736042345-12.030910424774842j), 
               (-4.2959824749700282+1.5817692887339785j), 
            (-5.9976459014029606+0.46621006087210676j), 
              (0.1778286700727027+7.1015869359675197j), 
              (12.855829433142954+13.047265714295564j), 
              (-13.218988874200013-5.7222534836636338j), 
               (10.738165844634507+15.192305510000011j), 
             (-2.6681841924586136-0.31400395715123436j), 
             (9.1687937571274443+0.58086952471933306j), 
            (0.56493572975454021-0.11794462711780777j)],
       [   (14.33761640161665-13.433492266164471j), 
               (-12.370525280342466-18.39142029415428j), 
              (14.712754680739458-19.861456853193829j), 
               (12.366226965456308-5.8183536117626051j), 
            (-1.4165236270889092-0.97283800313443858j), 
             (-5.3215647442351699-9.8661737325875727j), 
               (4.3049056103258012-2.6239511152553812j), 
              (6.3594840187602788-4.9156728341672533j), 
               (7.3662347451881338-4.6408824131628741j), 
              (6.7942516269044315+0.13945801601176269j), 
               (13.986857298200349-2.584504622343347j), 
             (-1.6942003021042176-5.4134081959751565j), 
              (-12.496102747416845-3.256097045989832j), 
             (-7.6363180535658408+2.1593081747881619j), 
              (-9.242233840771835-20.200794831133315j), 
              (-8.3822732620434639-4.3270544855006339j), 
                  (8.142564422411553-17.65645127898615j), 
               (4.6288518300406976-3.7465917909470887j), 
              (11.350146164881243-5.1869859115876977j), 
               (14.96740558062954-12.275612801347354j), 
             (-3.8130525673760234+5.9129710364030572j), 
                (17.063789788815406-9.4827617789600502j), 
              (-2.0411529163354323-1.3093903187521636j), 
              (0.37797046191299705+11.128225095122875j), 
              (0.29257811231919972+8.1655217499041015j), 
                (6.2298328245400905+6.0517840811654935j), 
               (10.089989143107875-5.1954917268852983j), 
            (-11.246865617492691+0.73302546714674066j), 
                (8.4063044900603927+14.733759465279917j), 
               (3.3598971137933913+8.0318690504598891j), 
              (0.79439265991283459+7.7976206788769371j), 
              (29.465806835463738-12.632042977727876j), 
              (-1.9083852175730489+22.669237434256615j), 
              (-7.1371423633182465-3.3682807969032158j), 
              (-14.777344807074904+6.4074582692557591j), 
               (4.5211778448239608-4.7325922035147512j), 
              (-14.146210200828071+3.7036517191769427j), 
              (4.5517412919414664+2.0636765319402754j), 
             (-13.115738944268976-3.9622075896777273j), 
               (4.1657707653284906+8.1865585854708076j), 
               (19.292301097289442-4.822059512312908j), 
                (16.255843013281705-6.7008547926634234j), 
             (-0.45953625154957051+12.722432619936473j), 
            (0.076940637413138988-0.15282667042290968j), 
              (0.45560504423424408-18.039219058425985j), 
              (11.483976419175693-0.26252578867719317j), 
              (-10.237154855301711+4.0216247039901649j), 
                (4.8940230725642264+8.7971895481220201j), 
              (7.2719259399596421-8.7536504023145518j), 
              (5.8098905536569809-19.940473009748462j), 
              (2.8503015543384747+8.8992243233198582j), 
              (-19.622668004688819+2.0052940511486779j), 
              (-3.7279708525197019+5.5192525639779895j), 
                (5.0557793109131977+3.5080708828443736j), 
               (8.2732124338523665+10.537545485826014j), 
               (4.6649276758292206-3.5666077650381105j), 
              (-5.4588912659500464+13.786673301244864j), 
            (-20.958023368690636-0.45016883074910918j), 
                (2.2516230876559891-5.1107023232722639j), 
              (-5.6802448549293505+6.2457549276855353j), 
              (6.1426265895341023-15.202959498663063j), 
               (5.3647354978298871-21.391305904215926j), 
              (5.2801904170456524+0.48047791369571718j), 
              (4.8561508998355869-2.6876485220748325j), 
               (6.8446823147319282+2.7378892572418079j), 
               (7.8237491853468741+11.513869287294717j), 
               (-3.7400176411542758-4.481286047964101j), 
              (12.411210964989722-10.012543680278513j), 
             (-5.0536672471757829-1.7389602460249893j), 
              (-10.725214989544076-3.5466063742656777j), 
               (13.579967981029936-13.104486631263327j), 
               (4.2187621206767174+10.848730553015587j), 
              (3.7730718042289828-18.217398361025673j), 
               (-13.365542855995969-12.314028083860386j), 
              (2.8990922305546181+11.398091903308698j), 
               (1.3875871048638859-7.5225278552103276j), 
             (-13.326459011076155-4.8323631570388894j), 
               (11.755535821272154+2.6082498314106712j), 
               (9.6557132156868004-6.4684900329783748j), 
              (-0.15210439814058366+9.137814308066206j), 
              (4.1999423687344093-8.2653806069383613j), 
               (2.0842830051208581-1.653951615390624j), 
               (19.258185130012627-2.4615308131830673j), 
               (-21.87151982438612-9.3804264101924844j), 
              (-15.144879532427094-7.1704843309416937j), 
              (1.4592040578670826-10.027649999493153j), 
              (4.5783763332116871+10.474766808451717j), 
               (-3.6802088688630259-1.128466246752621j), 
               (-1.5849248716343389-1.3658403354361879j), 
                (5.0645203271694808+11.59740241806996j), 
               (2.7183278635099462+3.0088248212018542j), 
              (-0.16714298516620202-9.4674528767054706j), 
            (-0.89365751219098744+10.349799764137462j), 
               (6.1220508583948599+11.70860728865248j), 
              (14.787578628371685+5.6274377811540832j), 
              (-13.489439146469422-2.4725886184090653j), 
               (17.262830023206615+5.1425014607667592j), 
              (-4.5345604188372635+7.9621775855216246j), 
            (-7.4766730492859201-0.26908491007203433j), 
              (14.047599196756213+9.1502467653439261j)],
       [ (-15.825070507298589-2.3685245460699087j), 
              (0.012091148145748902-10.34026865452172j), 
              (1.4560470423518006+8.3920598893422031j), 
               (4.9026658004024988+17.894666238989242j), 
            (-0.81079890796305576+9.1943801800828471j), 
             (-4.7145656974937751-7.0242002419880727j), 
            (0.0014883211307666901-7.9870508145666266j), 
             (1.0120462838642803+0.11703837226194039j), 
            (-0.010603735950461201-6.7207017928391313j), 
              (-1.9792180791530392-14.161646926166318j), 
             (-1.3386462085078679+5.5493199128479773j), 
              (5.2326916402299268-15.674998329066801j), 
             (15.625661987816581-0.90548440583162371j), 
              (8.7695186162415943+2.9100169283987469j), 
              (11.638406863410831+14.285927096268018j), 
               (13.961319836862611+16.750008136974945j), 
                (0.6238264748067498+6.9469720025485726j), 
              (-4.2778878074513029-9.4362735820684147j), 
             (-1.1422020955799155+17.464876561551392j), 
              (5.9942301100670914+1.0210347802554849j), 
             (0.24135503310205852-5.6342694208715169j), 
                (8.7544144238588544+1.9932987107713664j), 
               (6.0258676226842391+11.232692015124094j), 
               (5.9937305153872042+12.487367000209606j), 
               (4.5094087785204309-17.860033672024343j), 
               (-7.8614840683943736+13.514201085766436j), 
             (-7.7212659730493085+0.20227679747779664j), 
             (-8.6739992836644646-4.2583675214320396j), 
                (17.386809067732361-8.4518733881628734j), 
              (-3.1480205113167936+9.6275769969796468j), 
              (-12.455291316071971+3.6955115478825755j), 
              (-34.829693469121509+2.858846829578892j), 
            (-0.22289686098414527+0.25861852226482451j), 
              (-2.5268789362161979+5.7225039370304707j), 
              (0.94123716759409104+12.267558098450246j), 
               (19.667271193814436+17.819963563915596j), 
                  (3.924880417647735+12.2330833603003j), 
             (-17.242022973930137+6.7168355490837488j), 
              (5.3948062592681421-3.3453062146005488j), 
               (3.7445809548709281-4.9205757258020437j), 
             (-3.6282327390199391-3.6915881872318894j), 
               (0.65865113742547676-4.5816047398435469j), 
              (-12.855767692495448+8.3185694654594808j), 
               (7.6546631771197777-2.4220070787115873j), 
              (0.84218912782344257-23.490336086169997j), 
              (-4.7350616844414866+1.4471976227486318j), 
              (-4.9478658161451179-5.0420445188862555j), 
                (-12.45621016488743-5.8520394391642929j), 
             (-1.2350919764556514-12.833922864522595j), 
             (-13.970133678042595+7.0307340325769507j), 
              (-11.539613797410883+17.72209771458742j), 
              (-9.7089848023580938-11.674672319404355j), 
               (10.003217591802706-4.7557513080042497j), 
                (-7.2687234728840897+20.11384010652943j), 
               (1.4215919064840694-3.6940172902957977j), 
              (-6.8381512041110648-7.9777527218848574j), 
              (4.5564987954832494+0.38833656518192816j), 
              (2.3450842547702506-1.9591620397992791j), 
               (-6.8350414538868307+6.8323020978542477j), 
               (4.7459817344030171-7.2267364731012247j), 
             (-24.890294487579329+20.329028068620353j), 
              (19.783494708104975+0.43428466835946666j), 
              (2.7700855437063927-0.55310366538226874j), 
              (13.159831222039989+9.7483926474203013j), 
               (27.450384320325799+3.7285491098848373j), 
               (11.890490776875492-8.7550638711064188j), 
              (-10.180832540995926-4.8064949005746813j), 
             (-8.1272258399770401-8.8111765199125767j), 
              (4.3250452409164684-6.7810130222364045j), 
              (-7.3433034917451288-7.2043304119709894j), 
               (8.2264952780530702+3.7863340457865218j), 
               (10.682761817105753+8.5749507831470346j), 
             (-6.5785608784733975+3.2978384128860267j), 
                (8.6045052725300337+15.450549661744763j), 
              (-2.664049305272342-8.4613739016517968j), 
               (21.673089302347691+21.374140703687768j), 
             (-8.3433228720500257-13.228785999244161j), 
            (11.474603738022424+0.0015157277555936154j), 
              (-12.146741356014596-16.769441066180544j), 
             (-8.9002312108673483-0.34207760826680111j), 
              (5.3637625938854896-5.6851489917216149j), 
            (-9.6655427663852382+0.54169670039358508j), 
               (1.8173958649350788-5.0884117417358299j), 
               (5.2280880055689707+6.3764006232950994j), 
               (19.562887698656347-19.853508756670998j), 
              (24.409349940586264-5.4974041438276231j), 
              (4.6788512987211162-13.436520486035297j), 
               (4.0765536379716512-2.6097462195196868j), 
                (-19.66045819036156+3.1525076115297779j), 
              (-6.6178686359481613+6.5775612600643303j), 
                (-20.6856488716817-13.251420872273112j), 
               (-1.1636276720183965-5.6433083323230315j), 
             (-9.127148869987133-0.31749678252504365j), 
               (8.666615506262529+13.116581584107667j), 
              (-9.3991057961232212+3.067004174460302j), 
              (-6.6503213054159644+11.425173803573141j), 
               (-16.64144506940897+3.6607121722711913j), 
              (-9.6656046040940637-17.362921092515965j), 
             (-2.8151689649460336-16.881846951150543j), 
             (-11.515436924029416+3.1795239594757021j)],
       [ (-4.1647276949698444-5.1748508908281128j), 
               (5.7246376255222975-11.731323426640657j), 
              (1.9956921296510266+1.5801383191308305j), 
               (1.2162696856816944-7.1871799024542753j), 
               (1.163632861615493-5.7960377789291702j), 
              (-1.071048473823115+8.1872249712081864j), 
              (-3.8696067935837282+9.0280559097480833j), 
             (-10.434449905172123+13.552759799851072j), 
               (3.4065947150202276-42.722131331420883j), 
              (4.0987617500081051+0.51990532458979688j), 
               (6.8897648831967899+2.354595088076092j), 
             (-7.9270869748774606+11.388815457231406j), 
             (-4.2628420044375748-1.2415466734119673j), 
              (3.5389596016085916+2.1168087506619275j), 
             (-13.551129631935213+2.0765824557666632j), 
              (0.39108518659815306+3.0779709815085754j), 
                (8.2286651023578905+3.5421926433146522j), 
              (-10.434393097800216-5.8813108613867593j), 
              (12.368125474894319+9.2633825755878814j), 
              (1.6716098868438487+6.0341489994914701j), 
              (1.9780109791050982+13.761849203646747j), 
                (10.943606761839803+4.3742831363168113j), 
               (4.6861553575406507+1.3683852905221714j), 
               (-12.842082730997376+2.475312906679489j), 
              (-17.879361752442936+1.8319753173083213j), 
                (6.0402524792027172+20.082968254721049j), 
              (-2.6371046078781211-4.6170909312570352j), 
            (-0.58300987230972556-0.3268792516135498j), 
                 (11.03551209470584+1.0009142470191965j), 
              (4.7906409116924529+0.45711612296350923j), 
                (3.3343796260832415+4.070799271508676j), 
             (-13.912229939262474-4.3217834918484392j), 
              (-3.3731991843597124+15.212189808671756j), 
              (-3.7856408428275756+3.1126509309091888j), 
            (-0.32174101668278465+0.74873521203766646j), 
              (-18.902732445466977+13.955713412164247j), 
                (7.4485371771662248-6.991272438849089j), 
             (-6.9992923829399221+1.7467393648684995j), 
             (-8.1123002266810236-4.3995131412138573j), 
              (0.11254579449750966+18.186499834878415j), 
              (4.1396819053913445-12.417533970808732j), 
                (-8.1714407019315676-19.54152360080872j), 
               (5.0568987076198226+6.7538921961322842j), 
              (3.4244995578064281+0.37399840510627919j), 
                (12.09573886945757-11.244552993041324j), 
              (-1.5573330924552209+18.803710410609249j), 
              (0.58262030063735359+11.584061411166671j), 
              (-2.8537925602767169+0.11159415467040368j), 
             (-13.929665269240912+8.8724096852505472j), 
             (-5.1738130376959903-1.1509632458193384j), 
             (-7.4006456350913838+11.596983491050318j), 
               (12.652605150767119-10.174922257696952j), 
              (-4.3834326694953241+12.913430169970972j), 
                 (1.6219089451747528+4.787714101074104j), 
               (6.5590753818217049+7.7645291073017226j), 
                (15.677977999626373+14.63135131512132j), 
               (7.0302217138670633-4.4336268455984955j), 
              (16.244330334103807+2.3030989197753113j), 
                (9.4161922797962703-1.5102509086373594j), 
               (7.6317826790893459-6.1477106228148752j), 
             (-9.2492390363365971-4.4978651740609612j), 
               (5.3098012466388074-6.2133766364194365j), 
              (-0.7789591124877806+1.0852311980018896j), 
              (5.6461009123397137+8.1150980073105288j), 
              (-23.718662821964472-7.6149493721729709j), 
               (-15.55472579028504-9.8284079408972005j), 
              (4.5191600737846098+0.40552233031778911j), 
              (-1.6644732518408958-13.35624401615811j), 
            (0.21449706032684951-0.77503679148611448j), 
            (-2.7910595468963244-0.068874123532572051j), 
              (-7.4777556495549904-16.233141053430611j), 
              (-11.624348235388318+2.2640930416621434j), 
             (-5.0367743517719799+18.745880669261552j), 
               (-19.889113318561925-3.9588598403836199j), 
            (0.075043595760012405+5.6062899310044925j), 
              (-14.993617463614356+2.1326627069287372j), 
              (1.0555103649757465-4.2398864851104072j), 
              (-16.41008097321857-0.59883143194517896j), 
               (4.6255848031604998+9.6620757713387064j), 
              (-3.5663456477496656-4.4242501267207937j), 
              (-26.922370273156812+6.955940586798234j), 
             (-19.223289424768907+3.0175034489738071j), 
              (-2.3862589299090105+2.4670105861942919j), 
                (6.758274731103338-5.1952547809546301j), 
               (13.360778717298407+1.1124498433225791j), 
              (3.6003816838520937+12.466972514020165j), 
              (4.6214815235309272+7.6010420827413414j), 
              (-3.8527196370213481-7.9943773744374669j), 
               (-1.3052194615517709-11.576015824447811j), 
                (0.46703682812414171-13.5370116344804j), 
              (-12.219768550366961+3.0833439147975019j), 
               (-10.760042887519973-8.8760567664457213j), 
            (-1.8554998930698685-0.65235902159312942j), 
             (-9.3430131940170114-6.6221553833834035j), 
            (-14.796959215924286-0.54379081489738457j), 
             (-8.5391733598852131-0.90257208887678175j), 
               (5.8151533694522541+2.4964279191269196j), 
               (8.8251320390666717+2.7880380499028021j), 
             (-9.9949914965272377-7.6088068227649845j), 
              (-3.3361263984360674-1.025085706218007j)],
       [ (-9.6359008396677019-10.686111871102039j), 
               (6.7718098639408471-4.4549787693300029j), 
             (-5.1598598937742697-7.0320008950180863j), 
               (7.2280163758454599-14.146213699905502j), 
              (4.4849364105541545-8.6081510288116352j), 
             (-8.0735054828081108-3.3897786327049833j), 
               (4.1060659133208572+8.5820026279790103j), 
             (-17.763539870390954+3.8544668767921912j), 
              (-4.2795553036668696+5.0615035607587746j), 
               (6.4003563797070466+7.9397518513142344j), 
               (5.7378124355345603-9.309074663704509j), 
              (15.19867553810645+0.11353928361805149j), 
              (5.5234302274636073+6.0728408462661143j), 
              (11.322342616199293-4.0227122742380921j), 
              (-3.827433812634907-14.650016808649095j), 
               (5.2312070191939144-6.4145004714290712j), 
                (-17.79418936418455-8.3944135458923714j), 
               (6.7987527758361574+18.040773054768575j), 
               (17.029407361885394-22.65000668057894j), 
              (2.0627274830425706+13.561971232448007j), 
              (20.456025684526242-4.3686498556117641j), 
               (-4.9559588136087109+12.004779894936501j), 
                 (-10.9246399971763-13.64531800516639j), 
              (0.11927347655314403+4.4798644615772254j), 
               (10.746552773737756+19.115377600199565j), 
               (-3.3855915307320101-12.294164482070386j), 
              (0.26687637092995831+2.1419992343980008j), 
             (-19.433492182770479+8.0611415960668822j), 
               (-6.4124336303229779+9.8136834910553787j), 
                (2.184079250889019-7.3598769540008924j), 
               (4.9270642951155459+16.770839302111391j), 
              (9.4033290481834459-4.9584890300386872j), 
              (-12.578360994211197+2.2182423697035016j), 
                (5.0590013504183142+3.708159704215551j), 
              (-2.1069622565308905-14.281743477830551j), 
               (7.1441737863226695+6.1331004587342903j), 
               (-7.7540682377041845+2.683055519689411j), 
             (-5.6546314706907665+1.9273275027840975j), 
            (-9.3923550024922005+0.62340690807719656j), 
               (4.3957462065924178+6.2640975448723948j), 
             (-1.9339493474282494-8.4105589572946009j), 
               (-28.107420516461342+9.7444456292986548j), 
               (15.427366304899115+11.049906763924511j), 
              (-3.0184731817768577+15.777884152950714j), 
              (-29.390879844055089+3.0013787516522568j), 
              (-6.8687106981462778-3.0878718817836983j), 
               (6.8353579772166757-6.7186083956876184j), 
               (-5.2954193244765619-3.9751025053978974j), 
            (0.87519134195092219+0.42490553645202428j), 
             (-11.944013382663281-1.4976922400380044j), 
              (-10.347118456558565+5.710896025433315j), 
              (-5.4571607357745657-4.1598345199626792j), 
              (-15.985098670066307+4.5560108511489306j), 
             (-0.043569111945412617-19.531735944924637j), 
               (7.6546961028973373+10.508998001729548j), 
             (-0.24029438670332531-4.9822455945942634j), 
              (-7.5869571139020264+16.113825826678262j), 
             (-6.5166750469876957-5.9345833782747786j), 
                (9.6436047605157942+16.425622998108722j), 
              (-1.8619922772203754-5.8025271140569865j), 
              (5.4166328885022548+6.5476116986963984j), 
               (20.633876144563391-3.2089560253032912j), 
              (-8.6285488591242281+8.3166023926857822j), 
              (12.758785739367598+14.547870050097014j), 
               (1.8338070551811931-17.294768583927553j), 
              (-23.230965981417803+7.7570667541851375j), 
              (-22.596310975399824-6.3529336240599408j), 
             (-2.0387586111314078-8.0958533444124505j), 
              (9.2284056004752273-11.356408324106962j), 
                (11.61962729332256-11.922506987894746j), 
              (-4.4597194353675276+15.662528160646463j), 
              (-4.8827446677683755+12.882848269508454j), 
              (-7.9388107173424229-10.48782858876713j), 
               (-9.5616543598358721+5.4067661751292384j), 
              (1.9009282583693015+4.8304771885700433j), 
              (-4.1083303500246364-14.616592975999918j), 
              (7.4218235709450395+12.581966660327634j), 
             (-0.76552961133786046+19.082705675562483j), 
              (-8.6957704566466152+10.138434268897223j), 
              (-12.405441670940167-4.4882354307566894j), 
               (22.466505764800424-10.88173077359528j), 
             (-1.4016176419965936+10.975049876044501j), 
              (-13.792300639366735+2.5531438326501026j), 
              (-1.8428238392456586+10.943876432458895j), 
              (-4.7976995381612193+1.0415312032690203j), 
              (1.6934244320343774+9.7610282531952173j), 
              (11.788523103230091+14.255487768877575j), 
              (0.31302607031171498+13.285136464485479j), 
               (-20.952561214534352-12.301938369377437j), 
               (2.8989861167550695-17.437041598271765j), 
               (4.0907409924396738+1.9470653153728668j), 
                (0.78144844754878173+13.97184517562799j), 
              (2.6145599366465282-9.4997153735494759j), 
              (12.925185391516154-13.308648727409572j), 
             (-9.6860502782501534-6.0512005724188924j), 
                 (2.96544106005949-12.979448096296364j), 
                (8.5013307819452688-10.80187023049205j), 
              (-10.938468830671827+11.036128613134352j), 
              (7.8912578605406303-6.3618843918714436j), 
             (-3.3430486481966715+3.0718573938502298j)],
       [  (2.6775318242595816-16.710981132080093j), 
               (14.427113768029123+4.4942016480101179j), 
              (-10.64413931908949-10.087958165067066j), 
               (2.3756742968286018+5.8603339661532612j), 
              (3.6312758579231454-9.3693580432432899j), 
             (0.32809790247700554+2.4074407584149355j), 
               (-7.0515658993532426-8.354586150076468j), 
              (21.069163671543283+10.847455838613005j), 
               (13.651436426771031-3.9968216974848096j), 
              (-12.018889446996903-3.7210639140647901j), 
              (5.4071615759433413+4.3894078174380669j), 
             (0.99435580004530222-4.9864950542915238j), 
              (10.691088488097444-3.8806893017257416j), 
            (-13.330914850786378-0.15781273939701621j), 
               (4.5059036572250823+13.43918678808121j), 
               (5.9006988298978289+5.4768552457363899j), 
                (3.4840440323993089+5.1674680959795269j), 
             (-0.27334748849171614+2.3307826977006716j), 
              (2.5339549627800926-19.362798977732687j), 
             (-9.3686913085332506+4.0183586867116707j), 
              (5.0972749211983883-7.6815360641147929j), 
                 (2.2500962963133513-7.046447236884708j), 
               (9.3052687093234105-1.2304741332313369j), 
               (8.5987717190476811+13.165397530335671j), 
               (14.097625897907784+4.3875662376388176j), 
                (11.272977821221492+7.1675262612011004j), 
              (-4.2307127692692301+10.980311910052636j), 
              (2.5808912134716944-2.9748435964130753j), 
               (10.475881890326924+0.17085996526114328j), 
              (-11.253512598998681-9.3915243058434186j), 
             (-0.82529083893703281+6.5113202851577938j), 
             (-20.081592655650589+15.022700315168599j), 
             (-0.49002045724976429+5.5777209135212749j), 
               (-3.566165730578537-2.8836158737414221j), 
             (-20.379776054407188+0.82673243697821708j), 
               (3.8679245015201777-8.3926616916989101j), 
              (-8.8499769814156561-4.9815729152244597j), 
             (-3.5305108616915764+3.9488095367781022j), 
               (11.82821035129346-6.8112653411216195j), 
              (-7.9511515619589765-12.055514389386655j), 
             (-6.2779806550735877+6.0461702380106184j), 
               (-17.476346996016467+9.6625156002989865j), 
              (-4.9632822657798412+5.6076429856422108j), 
             (25.178323647831821-0.025607357537926114j), 
             (-0.56149006896809084-3.2242090008494877j), 
               (6.5776636252340897-11.418881189778858j), 
                (3.879609766309752+16.022984522980554j), 
                (17.821864417749751+8.8906454718794983j), 
             (-3.8376863993776924-4.0497962648234145j), 
             (-9.2417780033524402-4.8268733377051216j), 
             (-2.3058695391271762+16.444526655803319j), 
             (-8.9138577464553137-0.69943499108516927j), 
                (7.9475292576952317+15.05056136421654j), 
               (-5.4668892136154481-20.386855498055127j), 
               (8.0683585498141568-6.3985050011568259j), 
               (1.9649692988648206-2.4057494938645325j), 
               (15.478707989583887-8.0872219784823667j), 
              (-1.6693814894675123+6.462643841964625j), 
                (6.5971480911487799+9.5341401201549552j), 
               (7.0663091541113223-12.402472491733594j), 
             (-8.6746504090387724+1.8925004978289919j), 
              (-5.6112027036871055-3.9960917263344005j), 
               (7.8567962826522075-1.3723383533319016j), 
              (3.3657830770354269-3.4120979113410637j), 
              (-14.569318866247929+13.008842460648014j), 
              (-5.4382451143649835+2.0616928048159497j), 
             (-0.22620942096261809-2.6396109566045305j), 
              (-10.46274376682668-13.141735156634745j), 
              (2.3698024723725402-2.7689878391871279j), 
               (7.8694867688877981+2.4069645332864549j), 
               (5.4316866813377009+6.3674752543816018j), 
               (-3.0341005168381825-4.304151950283309j), 
             (-2.8321860752475905-12.616451844268857j), 
                (1.976463532822982+0.77334701502186076j), 
             (-9.2063783824872267-10.404047245439486j), 
            (-1.5051952408364713+0.011636778507053202j), 
             (-3.0595616517502844-2.3022333805590529j), 
               (7.6188888172471056-10.812584813362784j), 
               (14.079739121489812-2.7959377808377051j), 
                 (5.378933921408743+2.503763953762097j), 
              (1.6084304087914789-7.7679344672021289j), 
             (-17.281964030604389+11.087618868952836j), 
               (2.8651449648306486-2.1718445133030846j), 
              (-4.3660977816006952-9.8020633425664254j), 
             (-0.34830025556083388-21.918532196060202j), 
              (12.794064276031227-10.398886886677474j), 
              (13.944163122165127+11.415496361035407j), 
              (-1.0505151973630549+1.5403551122526282j), 
               (-6.2896290326039228+10.403128078745578j), 
               (7.8039691057670133-4.4346164565064585j), 
               (3.4983841496364478-11.168439722227504j), 
                 (14.891355063405253-22.96084592075124j), 
               (8.2111258183078668-7.440119179629904j), 
              (3.5370831646259928+2.0285837676587244j), 
             (9.9554314219103706-0.50599952426169148j), 
             (-2.3343284466057952-0.90020260961859289j), 
              (-11.058456661866217-12.752753953878521j), 
              (-5.2881606695397698-11.910486491302894j), 
               (9.270107567752083-11.735168158434012j), 
              (3.1002140373083051-15.676082489576027j)],
       [  (12.900955446819662+9.4654610359325346j), 
              (-10.110531301711376+1.2920452782623824j), 
             (0.64500883972313439-16.586523118899869j), 
                (5.3397048261857636+13.79944830532594j), 
              (5.1372175512980336-0.9351133760620699j), 
               (-10.519178461152039+6.64222098181411j), 
               (1.3621150509457423-4.9870043806108058j), 
              (4.8498956157662185-1.7833943160626822j), 
              (-13.453684840641724+2.0732126104241906j), 
               (1.0762216421675368-1.9983622490025319j), 
             (-4.6914844797013995-2.8086466231872125j), 
              (1.4746684549266385+19.235143697324141j), 
             (-7.2651124577402539-21.413293002194397j), 
             (-13.110178356586001-13.889312541326717j), 
             (-8.2842379127476313-1.1947571362800138j), 
              (-19.663393917708735+10.432078929318925j), 
               (4.3951450843603999-0.98502187541915176j), 
              (-4.4181062495697319+8.9453940613372112j), 
             (-2.1698363928838464-7.7882141660734483j), 
             (-12.222404147010483-6.6131333425679797j), 
             (-1.0974476714328643-10.470331030139661j), 
               (0.53702975822924537-12.874085640392646j), 
               (13.897464961418837+5.7688882871816674j), 
              (-6.7716589331179584+5.9742695965474759j), 
                (13.62266432550153-11.252666478533689j), 
                 (6.6400845067398198-19.70465602570664j), 
               (18.371109744583752-4.4532527492877456j), 
             (-7.1394017842505519+9.1784047489009524j), 
              (0.75419128152117165+0.10048115090797392j), 
              (-12.891565030061576-2.9068070005294224j), 
               (-14.366949386384142-9.156289679490051j), 
             (-3.6676903439204045+3.5483637770383885j), 
               (12.238242225930069+5.6611943962594102j), 
              (-15.020639289656479+2.5610905803156783j), 
               (8.2638476189220516+12.347456517611393j), 
               (6.8809627055741167+9.7897445789594624j), 
               (9.7094939126991768-5.5616700215925992j), 
             (-12.301348471559066-14.060820184588522j), 
              (-4.5872754031107661+22.07484541074566j), 
               (-14.255145174557907-6.930099646622585j), 
              (9.1845150690363635+6.3446642231350001j), 
                (10.548746126926209-7.0964280755113833j), 
               (-3.2391802766470978+2.019958097283677j), 
               (1.6170058544377044-12.827363560136186j), 
                 (5.7652057582127947-1.02542976333525j), 
              (-7.1558461620024811+19.261217001286468j), 
              (0.33643688493487506-23.735254125951872j), 
               (-17.357479753295703-4.8864373065003219j), 
              (4.4501723743762254-4.9135119876217201j), 
             (-2.3234770030462668+18.599418713678961j), 
              (20.910322894732587+7.7891600318967118j), 
              (-13.481009105883725+7.5369955204941865j), 
               (7.0230307902866542+6.9411085316706558j), 
               (-9.8709622768058392-13.486675369640338j), 
              (-1.8987566390127699+4.3424130391769831j), 
               (5.1062647087838986+15.810656439055968j), 
                (9.9234624933462392+6.180113946082745j), 
             (-7.3956318089374831+8.5534609566103441j), 
             (-7.2429218399383917-0.038473546725141826j), 
               (7.9312526342601464-5.6778428706505135j), 
              (15.219816088090894-8.4586494806813928j), 
              (-14.275555406003239+9.7410310006858012j), 
              (-9.2343059934823639-11.517194602646313j), 
             (-4.7994948829569282-11.333642235700992j), 
             (-0.51696411820754906+1.9145843707939771j), 
               (-15.03396038654204-3.8722694878012676j), 
              (-5.1501722283096898-3.6990951666098679j), 
            (-5.6441439842064582+0.38567485164435616j), 
             (-5.1941878123124763-3.4728137294514156j), 
               (9.1841346697633135+12.703420465250382j), 
               (19.203664872551048-12.692437744053461j), 
              (-11.313681341878175+1.4788240086512165j), 
              (6.2211950965038278-5.7740332626122139j), 
                (2.2421274055802791+3.3096043863204443j), 
              (6.3125452309211543-12.893886014900247j), 
              (-14.585314210176737-3.8184558715490251j), 
             (-17.975808010379978+5.1902926904872508j), 
              (-5.7671598755265325+8.0369648748863014j), 
               (7.2726750558614119-7.7516118960269438j), 
                (-3.465289218053822+7.753672701497786j), 
                (4.787505155364288+6.811597797107626j), 
              (14.490320812094303+12.207107279926323j), 
              (-3.2536843373304176+13.739938973480275j), 
               (7.2797705959465686+2.1027562116507603j), 
               (0.15534847324695111+16.52846574589389j), 
             (-8.8701655159751791-2.2478218287075493j), 
             (-19.289485399529131+8.2500726230798307j), 
              (-7.7214692197857859+11.458406760171183j), 
                 (17.640082763166109-3.767051644401298j), 
              (-9.5250868609290169+2.0561619830077609j), 
              (-5.0930560781168008-2.6285463539977885j), 
               (-15.119331204362958+4.0640199944729689j), 
              (1.7908878053698742+13.978216052308241j), 
             (-4.5715436321744551+9.0350989651502562j), 
             (-2.9913611233749329-11.880960199908072j), 
              (-4.9995919249979206-17.070269985240923j), 
                (4.232786198095698-11.831034165399359j), 
              (-3.1911988019120976+13.690537003334304j), 
             (-2.6967607227060872-16.075063606300017j), 
              (3.6542729508770035+11.144669522801562j)],
       [(-4.5541668783978997-0.60280589256107198j), 
              (-5.5283354432540044+3.6520425476473921j), 
              (1.8017270754844881-9.1147480594787318j), 
              (-6.9546082560947395+7.1775236097827175j), 
             (3.6575522101029652+0.13699082907436719j), 
             (-27.015483668189798-1.4180560597230474j), 
               (4.2102177768249396+8.1240620144583673j), 
              (19.719630584926065-7.4423642714279463j), 
                (10.339729495324331+0.554951374785838j), 
               (1.5920061783772244-7.6900301272543761j), 
                (14.7345520948583-8.6510624611349982j), 
             (-9.5026075636771381-12.055268195099353j), 
             (0.50497352133927154-11.071924560240713j), 
              (-15.77942202344544-3.4345318013112407j), 
             (-8.1419129952670861+17.174373283343208j), 
                (10.01466236590459+8.9651085075918129j), 
                (3.2041514582562698-2.9561503332433632j), 
              (-11.401515872826719-2.6345374851700427j), 
             (0.55065523274600703-11.120793241271656j), 
              (30.248735573644012+5.0677296831322067j), 
               (8.164709269333482-1.2493106885506502j), 
                (12.170163162541176-12.949165645202282j), 
              (-11.673602485181625+11.730820016603854j), 
              (-9.0429197493613245-3.0241530412741282j), 
              (0.37086654071329384-15.949026358173509j), 
               (-7.5522390783594195+5.5501585240775455j), 
              (-3.2631273999669879+17.571557005814086j), 
             (-12.915252812075416-1.6191614088640847j), 
               (7.7149592184902405-0.90526396197508552j), 
             (-0.67281996747635819-1.4006645869593293j), 
             (-16.376427529784571-0.78016671026380813j), 
             (-24.883534356783478+1.5898240289452028j), 
              (0.52271534580897894-3.8399856396004868j), 
              (-2.5763167075773588+1.2775753257219584j), 
               (8.8562839888508744+13.188601155431988j), 
               (-3.1937328883089968+13.51773373656366j), 
               (9.5159202223481199-12.193217735840161j), 
             (-19.929290324093639-11.940904818578638j), 
             (-3.6209792308617312-2.7582512673682231j), 
             (-3.7019164093977954-0.48064372573686631j), 
             (-9.3462915791445962+5.9280154871300468j), 
              (-6.0618947305836048-0.37882374092319004j), 
              (-3.8184847198790219-6.3292071479076917j), 
               (2.4740782313058247-16.262257823269429j), 
               (1.0958031208943069+4.5491766177175768j), 
               (12.349316264897451-11.973627486445809j), 
              (-8.0466695866436986+11.337878872827252j), 
               (0.71842091794272578+7.9789853638035506j), 
             (-1.4630072085942722-4.7393166021531075j), 
             (-12.674647365682679-2.6991567368088694j), 
             (-16.035149307131526-1.2574945010639729j), 
              (-10.858994429111068-2.3864006801735136j), 
              (-4.8409305725877916-2.4368215750217299j), 
              (-12.405108621618018+0.87545449533817943j), 
               (9.4567954678249873+20.247499378790735j), 
                (7.312422469382879+8.6517925128421123j), 
             (0.17932268905586934+0.65650284873561959j), 
             (-6.0403701428397643-3.6011272643321601j), 
                (-3.9129246566032529+9.372780684434133j), 
              (-10.590210899950275-6.6008464277089054j), 
             (16.760997086030208-0.97854359595008056j), 
               (-9.9897293103928302-3.649688955613855j), 
               (10.115461617982767+8.8785669875975977j), 
             (-3.8766736413837553+16.289931189282537j), 
               (-2.814422083258608-1.4758141518954759j), 
             (0.074811145047854299-13.345525054765123j), 
              (4.0165475626180331+0.81035643057023954j), 
             (-6.2571049379951491-15.549182187093436j), 
              (6.4485585573684814+10.349146354197771j), 
               (10.923045759535214+6.6463203146971743j), 
               (4.6009299544623659+14.947848964300974j), 
               (17.778239571206488-3.6543886249248603j), 
             (7.9668866720388252+0.23378446147432447j), 
                (5.1326491850349427+2.6613244439762469j), 
              (2.5041831449151357-8.3192784194517202j), 
              (-11.985697011913075-3.9050675671917254j), 
              (21.219137584538043-21.349119401398863j), 
               (9.5146675542892787+11.575747230480927j), 
             (-28.840550849783703+0.79043411089372839j), 
              (-1.5802601625114698-5.9181435653502756j), 
             (-12.386511169037192+14.844261239811249j), 
             (-5.4025662616007395+7.5324336391526137j), 
              (-4.9818822249936465+3.3131483129968142j), 
               (1.5052218466662006-9.9854505591229348j), 
              (-9.4853800286443004-2.7855406396863707j), 
              (7.8262519841566451-6.7911724385457291j), 
               (4.4089969163741465-17.73468441908302j), 
               (23.933013823310283-7.4473401755630153j), 
               (-2.1044762801223325-2.1763006001122784j), 
              (-12.565734751075919-5.6665456415383009j), 
             (-21.489081797608772-0.21003873193362971j), 
               (-6.0087354467942458+17.668071905197319j), 
             (-16.638301856691569+7.0316639840181994j), 
             (-11.990522874575023-9.4038513820733876j), 
             (-11.659925250995613-1.7804397389746347j), 
              (0.28874504138756296-8.0525398198219484j), 
               (12.739178652590873+7.0857237348652244j), 
              (-3.7051803275216821+9.5476861945336751j), 
              (12.518103645086898+5.6400988473260592j), 
             (-9.9585654785592244+2.8780678639068649j)],
       [  (3.0085612258709187+2.3239971199271809j), 
               (7.7046123912584372-18.186065568035207j), 
              (-2.9243142454310735-1.758785901509087j), 
              (-4.0543922833351793-6.0333026056936845j), 
              (5.9785523686150288+6.1070541395186009j), 
              (-5.3016217509784873-18.30436348833565j), 
              (-8.8590179764385333+22.084239705790356j), 
             (-14.440580016163258-7.6895164540979462j), 
              (-3.2695661322601999+17.310121064771369j), 
               (6.1482441272921804-4.3457109442477773j), 
             (-2.2628719665730253+1.1759738041112331j), 
             (0.31500654423430452-1.8220417977612577j), 
             (-7.3016786424762712+10.983339264577967j), 
              (15.935489988825456-7.7480835899768472j), 
             (-16.273975330024399+6.2733434481601744j), 
               (-13.172740538467849+10.82405971883458j), 
               (-12.870524143986602-3.5127361740358549j), 
             (0.59254915378250406+0.71286906556884566j), 
             (-17.805763299988172+14.405949351216751j), 
              (6.2643102751861619-12.243912036265419j), 
              (13.603381172731632+2.6550385390772471j), 
             (-0.078137975260178114-5.6175194755061959j), 
              (-12.803117561573229-12.920812764678235j), 
             (-4.8795291182040081-0.75932705623315777j), 
              (-10.209489739540123+9.7545894735373562j), 
              (-0.67165025098249265-11.818206729440357j), 
              (-13.601388319003107+9.9941968544409079j), 
               (5.921217831113875+7.2510826925438634j), 
                (13.705983943805226+10.621613682210993j), 
               (18.726591614639169+18.325265614885179j), 
               (9.3849513394751085+2.5400437845219037j), 
             (-5.8994237179851305-17.848450684010988j), 
              (-19.069113965842117+8.5858166356044094j), 
              (-3.2031143738986345+14.090971752663204j), 
              (-15.879898297064399+2.1242918633663637j), 
              (1.3637344237521778+0.03233642719444664j), 
               (7.5275945616738404+5.9929998663214477j), 
             (0.87226069227378134+12.521921671372187j), 
             (-6.7920958366095787+3.8297013693914819j), 
             (-0.06970475710290118+29.019161083889394j), 
             (0.48593155627165041+16.134734565547749j), 
               (-1.7363051584124438-3.4868310259490807j), 
              (-10.408898313447679-2.9467992185973086j), 
                (5.388925644368399-6.9229433784131302j), 
               (2.8310373919161407+12.016121819510728j), 
              (-7.0785813143595364+13.084844197148948j), 
               (5.3493463450161887-14.044888581080915j), 
             (-0.075478894440577121-3.7925606552373807j), 
             (1.1712104874103317-0.34238609770985928j), 
              (2.7479703729726808-15.888935234377854j), 
             (-11.723785088071576-1.9412405070980716j), 
               (11.280380362261164-5.1099053849629765j), 
               (27.310019359114136-1.5126035825688544j), 
               (-1.6555239148813925-10.864161051027191j), 
              (-5.2355198537201701-12.092183634915347j), 
               (15.829964072840315-3.6385546905518411j), 
              (-5.2039263635581792+2.8623977032425247j), 
             (-10.874471524893876-4.5339957826953947j), 
               (5.0747381593721519-0.94471557022611063j), 
              (-3.3976067179940053+4.2706265901958558j), 
              (17.118252623300336+11.426184108598319j), 
              (-1.0709424265987906-5.4099114449131394j), 
               (-2.5308271613067843-3.652528604682606j), 
             (-8.8841241898358696+2.1112787070242742j), 
             (0.56054065035284995+0.66675890927004311j), 
              (-12.265830864893143+6.2957499407658215j), 
               (2.8814728816003408+2.3503032064177214j), 
               (22.515652424936956-6.679952197105048j), 
               (5.2310652657502708+3.578321016981485j), 
               (0.62765825123784202+20.73500559503179j), 
             (-6.4659547328171554+0.48732393889839348j), 
             (0.19788040612781338-0.38044749026497793j), 
              (7.5040379192698374-3.4219973021000616j), 
               (-8.5911506210223667-8.5789511275190495j), 
             (-8.7756146391450613+4.1572616887302596j), 
               (2.9809466718360205+11.429839949061314j), 
             (-20.509945827564678-21.823584083689461j), 
              (-11.731964829930277+13.242425798974153j), 
              (-16.002200701193438+9.0812899281369539j), 
              (-1.4022675984546225+8.8810252456233645j), 
             (5.9787345922497117-0.44521107203599697j), 
             (-8.4185967802031989-1.7779363213205299j), 
              (-5.5255300768496287-3.3639018088611921j), 
               (9.2462133550871695+4.4122873559851037j), 
              (-14.525438259396122+6.3840910943327245j), 
             (-16.643291461218343+4.0635071052817819j), 
               (14.19130694753261-2.8496940597875051j), 
               (4.7126998846313661-1.3248740441693108j), 
                 (5.4729252428066015+20.93668252665292j), 
               (12.640252073384769+18.131856027404744j), 
               (20.702043552893539+2.8169926564726859j), 
                 (12.828241813038444+0.210391894667871j), 
               (2.3936059150045987+4.122928971599884j), 
              (-6.699210070335738-3.7622354155116566j), 
             (-8.3719545053613693-13.017786332808175j), 
             (-11.321694467252945+0.70388044849783571j), 
               (13.928193230095561+6.3331242558076433j), 
               (10.864180841279778+7.1354863500147196j), 
              (9.3357051227925538-8.1720069507314665j), 
              (13.576721849884761-21.257625710951697j)],
       [   (-8.7426343204684418+14.9521507918257j), 
             (-0.84792719442115394-10.391612442249105j), 
             (-16.774709108346357+4.8188355208382108j), 
              (-10.520634756961877+1.5923327823168212j), 
             (-4.4574023421696349+3.7637964420961838j), 
              (5.1180788906139281+12.671777902302853j), 
               (11.182125966351615-4.0394609086249913j), 
             (-1.8661275205587269-8.4619008232201871j), 
               (2.9045679770755384-15.689562044470911j), 
              (-17.206070925899837+13.867158484552274j), 
               (9.6878509224747482+17.16722094912987j), 
              (3.7823632087528298-15.380153991062794j), 
              (10.360202197393814+17.455095225169945j), 
              (3.2718212135549996-5.3394695775852661j), 
              (17.128853737893511+2.7165638759634514j), 
               (19.312272612150075+3.7981660325669537j), 
               (-8.2850045511679173-10.303081275879329j), 
              (-9.0765222185735013+2.7527560380339926j), 
             (-8.8796607297747077-1.6112144221434244j), 
              (-3.8561615464844583+10.31207405991452j), 
              (2.0836003278269906+9.0036856408211055j), 
               (-1.7616488641102646-1.9275081238940284j), 
              (-7.6681964272303906+7.7177479445853656j), 
              (-5.8351152631675909+9.1787657701427285j), 
              (-9.8888239897942629+9.4967907463037875j), 
               (-14.819748136783552-5.6769324598792519j), 
              (-3.3449676447652688-11.084972406123669j), 
              (18.363207146898944+12.658612425408041j), 
               (-1.9827460924607385+2.5257878427289708j), 
              (-7.6041349811322974-3.9773455733399588j), 
               (1.0299962473111712-4.8768489996122382j), 
               (2.967974778892486+8.7396040002109654j), 
               (12.349795144077511+4.3396585038855209j), 
              (-6.9684776821589569-4.3826691903004118j), 
             (-0.53101923025041553+14.171394031823466j), 
               (6.0692294937619318-11.676806435352308j), 
               (7.4866846006254004-2.3145520601560969j), 
             (-8.4842796417838606+10.642699639212969j), 
             (-1.4711980308804375-7.4894798636637301j), 
               (17.611947507904393+9.8591565136805777j), 
              (10.623471590963584-15.332765842214149j), 
                (12.130369552085687+2.4712199559445529j), 
               (12.446083566040098-10.134134839045313j), 
               (1.3568250853390986-12.184491434933179j), 
               (5.0806234962117856+7.9680756067838754j), 
              (-15.249456826017159+11.383337064211076j), 
              (-3.8071096464685983+14.445776156903346j), 
                (-3.010842895631296+16.338398184959427j), 
            (-0.69986809396312288-5.1550887130749521j), 
              (6.1981886621638971-2.5343021880263028j), 
             (-12.467846782513998-1.3444196744494348j), 
               (12.355293317467728-9.0743371897525797j), 
                (2.526882044406578+5.8384660360228668j), 
                (10.041009213041384-2.1579579187278939j), 
              (-21.997933961121021+2.4078331991176425j), 
               (-4.2691805526813074-29.69634154861248j), 
               (26.337401784132677-11.554175171593606j), 
              (5.3698917623536691-1.2708394661720237j), 
                 (6.478351174227436-22.618665432993584j), 
               (1.2390698528141559+8.3411835936886938j), 
              (14.716327910782152-10.364984516080062j), 
              (0.24049979853860942-8.2364733763958906j), 
              (-2.3460008318893029-15.383230865669963j), 
               (-9.02055859285454-25.980773391465771j), 
               (3.8731119586528622+3.9146418802753757j), 
               (-11.325754543069733+17.00136867821686j), 
              (-6.5253256790017371-5.4547893757687218j), 
               (3.6713971976605735-6.332040147627259j), 
             (0.82710770867033556+10.507996322935714j), 
                (5.569007013886873+8.3790476802557166j), 
              (-2.3950323651152532+0.2529064768241438j), 
               (2.8640864772206314-5.9253014294752404j), 
              (-22.03004856992894+2.9178976312631666j), 
                (14.174332221068324+3.9087064312425479j), 
              (2.4974779322795717+7.2736983798717141j), 
               (8.8034234369016158+5.3242170793918886j), 
             (-1.5170989119808942-11.076221417267284j), 
               (-5.6573883102359037+3.084164688662006j), 
               (27.764714352435234+8.2960972202096528j), 
               (10.429080059885276-11.901720095308324j), 
              (-0.15696638095364898+13.8352487220608j), 
            (-3.8293679545028754+0.93828099728395098j), 
               (5.1064139304223701-11.059834650328176j), 
              (-7.6565646714384332-11.847887301224869j), 
               (4.1364968349995248+9.1501475095983746j), 
              (4.6165702849976755+9.6611115331270536j), 
              (3.5844804004209658-1.0928374779900523j), 
              (-4.5999146389337602+2.9462108433931578j), 
                (-4.476206749030645-0.2829718542058357j), 
             (-9.5378263129772005-0.48965741295121662j), 
              (2.9181224896873887+0.52145615242325905j), 
                 (11.307737920314185-12.38402066500343j), 
              (8.4787600012889914+2.4747469921384435j), 
             (-18.115427655547492+3.0110978433855213j), 
             (-2.2449260012359145+9.7234621444025056j), 
                (7.764014828902658+3.4389624836552759j), 
              (-5.9759028829977403+5.9562652104129921j), 
               (-21.50971905050854-3.0451505941328301j), 
             (-0.66730241793901013+11.50514748701319j), 
              (4.4650411609201361+11.729003626160042j)],
       [ (-2.2418780487381729-7.1772655299197039j), 
               (-3.767470277575736-16.752102630964163j), 
              (6.4148962811899048+18.989762241717024j), 
              (-1.3344796479360796-2.2460188615556866j), 
              (6.7461051547904214+6.4351055897171854j), 
              (27.352289762820028+3.0652656130152014j), 
                (11.50095691819997-2.6681644251877152j), 
            (1.8350300309617293+0.071849797551437042j), 
              (-2.7837437784616452-1.5775272465981172j), 
              (0.89860249977472906-13.112884553786364j), 
              (15.297630436799452-4.9363469987818593j), 
             (-8.0740021867957399-9.4702040340102815j), 
             (2.2273776718180636+0.95045638566764423j), 
              (2.6589193650987912-3.2412967193857667j), 
             (0.55610304971720326+3.7140865800362239j), 
              (-18.536429062428475+5.1521646908603334j), 
                (1.6035854624450707+14.030648774877223j), 
               (9.1419801614453249-2.2851837382838305j), 
             (-5.1543716694976407+3.6882768410682223j), 
             (-5.9366918756758889-18.458857085820025j), 
            (-0.55499324645581893-9.4618761736194443j), 
               (-11.706880752672365-8.6379521064450717j), 
              (-11.451874090724255+2.5920214794644467j), 
              (-1.6024323685316768-8.1190782572368825j), 
                (3.768411493056512-7.7451302949432748j), 
                (6.8109020799943085-13.379930626973247j), 
                (5.666263704033109+3.7127929257423551j), 
             (-2.0909084833883385-5.6100600858701313j), 
               (-5.1754163669508921+2.1867730231099975j), 
               (0.4688682323544292+11.068142634536709j), 
              (-17.310983650501626+2.7105092362652172j), 
               (-10.982534701782697-10.8458699860998j), 
              (-7.5964132669793782+3.6253948508944238j), 
              (-8.8707125916184069+1.4627472065798917j), 
               (7.9432923144260297-10.207595456798636j), 
               (16.142395329076201-3.2841895703770745j), 
              (-10.965898902370132-12.016860813686883j), 
              (3.2744685178824167-4.8180540410643582j), 
             (-1.7610742177812528+8.1267055204534682j), 
              (-1.7838769417936597+9.8206604129108737j), 
              (10.170054312899403-17.419437432728483j), 
                (3.3483135571930212-10.153899563413816j), 
               (18.406897774528865+4.9397152279590886j), 
              (-16.040857243650787+1.5287495418648456j), 
               (6.8504676726220879-4.6713527928522076j), 
               (4.1383582269224508-6.1173158972903243j), 
               (-9.331743580857589-3.2001766251968604j), 
                (13.346603322116975+5.6785840382582613j), 
             (-5.4543595871803134-12.904100586895259j), 
              (5.1874167447726887+3.8095848785569872j), 
              (4.8778985285828949+3.5752559320055859j), 
               (14.128424103106582+3.4479229684898574j), 
              (-3.6479671707692041+5.5343150923896616j), 
                (2.9966263778590214-9.3766053654609323j), 
               (9.033100632209015-0.21384542866729961j), 
                (3.446962861846159-3.0047096778502103j), 
             (-5.2481956146691733+0.47661570639796147j), 
             (-2.6494963760405064-1.1056447117724664j), 
               (-8.1698533503944333+5.7034589587621269j), 
              (-7.0448507649087109+10.714114978617273j), 
             (-14.226640287795592+9.3033274031517301j), 
                 (4.3686752235899018-13.1720245117756j), 
              (-18.360036444997668-3.2127534032464089j), 
              (0.6979650582621062-3.8690506173596213j), 
              (13.781003381143943-0.96882170616059748j), 
               (1.9708758335967875+12.655092662736413j), 
               (21.998197028355367-4.4588080914373425j), 
             (-6.6382343458473025+3.0108190878407513j), 
             (14.991121297928345-0.20995139980422012j), 
               (9.3243449484268481-13.802373565805775j), 
              (-3.6394959400726186+3.7186633547163206j), 
               (1.7361535626419278+1.4042397262784205j), 
             (-16.952605421449608+2.7373051052905502j), 
                (6.2645583449676359+5.9442832518072901j), 
             (-21.846965063220949-3.4786271203683854j), 
               (-19.957905287594908+6.236396880484615j), 
              (-6.540720325455414-5.0143506044268884j), 
              (-6.4796393879340872-6.4546628119228258j), 
              (-8.7270204864684313+5.8200795588089242j), 
              (8.8972197288269825+0.15559602537502026j), 
             (-9.360598858083943+0.70470000518190301j), 
              (-14.417465969595691-7.990174225904676j), 
               (10.051733262989121+7.0356113002378198j), 
               (6.1416140437555891-19.763655412411637j), 
              (-10.427845624126864+2.9453871756400423j), 
             (-2.0121678478651619+4.3004496163842818j), 
              (3.9503133714952106-15.955996405077816j), 
                 (-10.74451843810567+7.71169446022156j), 
              (-13.460311950493066+0.34532639784200181j), 
              (-4.7896397276036575-20.370412957315146j), 
              (-18.205540251432733-15.866184751988905j), 
                (6.6841414171307667+6.0617783678632451j), 
            (-4.1331678401834901+0.74586256045446131j), 
              (21.920241137132741-4.4122860863262758j), 
              (20.335072096365558-3.6267322553865999j), 
               (7.6814040256287885-7.5472576055751102j), 
              (-2.7718346019453772-15.735742090497631j), 
               (7.5318024337177389-8.8378514736861788j), 
              (24.971457711695809+2.0279529753636112j), 
              (3.1035287375291021-7.1868697440713705j)]])
# jacobi ----------------------------------------------------------------------
jacspd = {}
jacspd[Float] = \
array([[  10.3553773584,    2.2360776737, -0.530415139773,  -1.56771093671, 
            -0.644042363283, 0.0910371341314, -0.607994374559,  0.642996438062, 
             0.214608370307, 0.0894927891328],
       [   2.2360776737,   8.67983679705, -0.886891174545,   1.42194305108, 
             0.801292570608,  0.338773373148,  0.327261908741,  -1.05740043939, 
             0.734762641596,   1.40541644385],
       [-0.530415139773, -0.886891174545,   6.98927781244,  -0.65624751238, 
             0.139187260471,  0.206621480413,  -1.66715151085,  -1.53083605551, 
            -0.531880520472, -0.791589625657],
       [ -1.56771093671,   1.42194305108,  -0.65624751238,   7.18977554572, 
            -0.902307164117, -0.467700227322,  -1.77479086424,   2.73451553567, 
              1.97947989266,   2.09276037126],
       [-0.644042363283,  0.801292570608,  0.139187260471, -0.902307164117, 
               7.9812493695,    2.6718617373,   2.55129468808,  -1.47809014212, 
             -2.73390728441,   1.76901803904],
       [0.0910371341314,  0.338773373148,  0.206621480413, -0.467700227322, 
               2.6718617373,   4.84166328803,   1.46411099526,  -2.67610832321, 
             0.390240381753, 0.0581856268647],
       [-0.607994374559,  0.327261908741,  -1.66715151085,  -1.77479086424, 
              2.55129468808,   1.46411099526,   8.80137277355, -0.717433827397, 
              2.07912070553, -0.397353243111],
       [ 0.642996438062,  -1.05740043939,  -1.53083605551,   2.73451553567, 
             -1.47809014212,  -2.67610832321, -0.717433827397,   5.40934347451, 
             0.431726994742,  0.670779322288],
       [ 0.214608370307,  0.734762641596, -0.531880520472,   1.97947989266, 
             -2.73390728441,  0.390240381753,   2.07912070553,  0.431726994742, 
              5.60430694444, -0.681479889287],
       [0.0894927891328,   1.40541644385, -0.791589625657,   2.09276037126, 
              1.76901803904, 0.0581856268647, -0.397353243111,  0.670779322288, 
            -0.681479889287,   7.83286548637]])
jacspd[Complex] = \
array([[(12.2419903999-7.11134981197e-17j),     (1.2043934426-0.772274208564j), 
              (0.767890620358+0.315961343689j), 
             (-1.93391396982+0.0538080371476j), 
              (-0.825627211341+2.38943032909j), 
                  (2.3152034842-1.0874112756j), 
               (0.517552196117-1.67318250803j), 
               (0.582397724753+0.57887234903j), 
               (0.718879874555+1.25912491684j), 
              (-0.220273688689+1.00913921717j)],
       [    (1.2043934426+0.772274208564j), (10.2926947014-2.30376020994e-16j), 
            (-0.229626743317+0.0667771527511j), 
               (0.71515926223-0.468550340772j), 
                (1.43868773695+2.11355922701j), 
               (-0.716990575938-1.2534015599j), 
              (0.532827484609-0.132801443315j), 
               (1.01543145438+0.396195832869j), 
               (1.48803731979+0.167089920412j), 
              (-1.17229751782-0.492099265205j)],
       [  (0.767890620358-0.315961343689j), (-0.229626743317-0.0667771527511j), 
            (9.41596397244+6.30768495161e-17j), 
              (-2.85595311017+0.623624268974j), 
              (-0.209087392545+1.06656997628j), 
             (0.324285340444+0.0652753703156j), 
              (0.567787658624-0.338063896553j), 
               (0.830917505911+1.14749481548j), 
              (0.548336370346+0.689579788168j), 
              (0.844609634607+0.686448053345j)],
       [ (-1.93391396982-0.0538080371476j),    (0.71515926223+0.468550340772j), 
              (-2.85595311017-0.623624268974j), 
            (11.7239571251-1.85554425557e-16j), 
               (2.30441178815+0.195965323439j), 
              (0.114126500773+0.268470898403j), 
               (0.241939631069-1.53824829019j), 
               (1.20497249707+0.108264681724j), 
             (-0.945771372073+0.174662917586j), 
              (0.566337986699-0.237720325802j)],
       [  (-0.825627211341-2.38943032909j),     (1.43868773695-2.11355922701j), 
              (-0.209087392545-1.06656997628j), 
               (2.30441178815-0.195965323439j), 
            (14.2625491889-3.86814536023e-17j), 
               (0.694843307601-1.73284786968j), 
              (0.317919989339+0.760792370376j), 
            (-0.929282960806+0.0452110212479j), 
              (-0.188093422928-1.17719256578j), 
               (0.617244643239-2.73013451186j)],
       [      (2.3152034842+1.0874112756j),    (-0.716990575938+1.2534015599j), 
             (0.324285340444-0.0652753703156j), 
              (0.114126500773-0.268470898403j), 
               (0.694843307601+1.73284786968j), 
            (11.9989652699-3.86094558017e-17j), 
            (-0.0939219892922-0.221027438688j), 
             (-0.041722747023+0.318257721257j), 
               (1.92945042456+0.203176722074j), 
             (0.0989960363454+0.593615751903j)],
       [   (0.517552196117+1.67318250803j),   (0.532827484609+0.132801443315j), 
              (0.567787658624+0.338063896553j), 
               (0.241939631069+1.53824829019j), 
              (0.317919989339-0.760792370376j), 
            (-0.0939219892922+0.221027438688j), 
            (10.1474565157+1.05150828891e-16j), 
                (-1.15786254507-1.6344188006j), 
              (0.583294702128+0.708324301769j), 
               (1.77278865929+0.886183935063j)],
       [   (0.582397724753-0.57887234903j),    (1.01543145438-0.396195832869j), 
               (0.830917505911-1.14749481548j), 
               (1.20497249707-0.108264681724j), 
            (-0.929282960806-0.0452110212479j), 
             (-0.041722747023-0.318257721257j), 
                (-1.15786254507+1.6344188006j), 
            (13.3912845557-1.02782365952e-16j), 
               (-1.2025986246-0.810418874502j), 
              (-0.23186870065-0.755811500094j)],
       [   (0.718879874555-1.25912491684j),    (1.48803731979-0.167089920412j), 
              (0.548336370346-0.689579788168j), 
             (-0.945771372073-0.174662917586j), 
              (-0.188093422928+1.17719256578j), 
               (1.92945042456-0.203176722074j), 
              (0.583294702128-0.708324301769j), 
               (-1.2025986246+0.810418874502j), 
            (12.8082447855+1.52906387638e-17j), 
              (0.987466226106+0.261395524328j)],
       [  (-0.220273688689-1.00913921717j),   (-1.17229751782+0.492099265205j), 
              (0.844609634607-0.686448053345j), 
              (0.566337986699+0.237720325802j), 
               (0.617244643239+2.73013451186j), 
             (0.0989960363454-0.593615751903j), 
               (1.77278865929-0.886183935063j), 
              (-0.23186870065+0.755811500094j), 
              (0.987466226106-0.261395524328j), 
            (11.6692668416-2.26759719705e-17j)]])
# arpack shift-invert ---------------------------------------------------------
arpsi_a = {}
arpsi_m = {}
arpsi_a[Float] = \
array([[           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0, -4.1529667819, 
            0.538863121195,  13.2432466345,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
            -6.83068848873,            0.0,            0.0,  13.2389686385, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,  4.28474708745,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
             3.88980178471,   23.3764847187,            0.0,  8.35476202838, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
             -5.72425132066,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,  7.49089324573,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,   2.08319575097,            0.0,            0.0, 
            -9.49850686881,            0.0,            0.0,            0.0, 
                        0.0, -2.10059715408,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,  5.68190055971,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,  -7.98345855283, 
                        0.0,            0.0,            0.0,             0.0, 
            -9.29382539814,            0.0,             0.0,            0.0, 
                       0.0,  13.3269902682,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
             -7.18765374668,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0, -7.36726915477, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,  -13.453676269,            0.0, 
                       0.0,            0.0, -1.71380535375,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0, 0.785515754567,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,  4.68515259657,            0.0,            0.0],
       [ 22.0686419672,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,  -1.3967724801, 
                       0.0,            0.0,   2.0944464917,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,   3.96368904627, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,   4.71807440545,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
               8.4078480513,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0, -5.57869736477, 
                       0.0,            0.0,  9.90419004401,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,  2.67540766704,             0.0,   10.6176347295, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
            -7.09290929949,            0.0,             0.0,   1.80426422003, 
                       0.0,            0.0, -0.720707770809,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,   -8.1660400254,            0.0,            0.0, 
                       0.0,            0.0,  14.3117420982, -2.69795096441, 
              3.36798528286,            0.0,            0.0,             0.0, 
                       0.0,            0.0,  -11.4355006255,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0, -0.805443811951,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0, -0.141242504822, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,  11.2895752148, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0, -10.8341306794, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0, 0.0787368988242, 
                       0.0,            0.0,  -17.4398183891,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,  4.39194384933,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0, -8.66545971949,            0.0, 
            -12.0946768307,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,  -3.11673438307,             0.0, 
                         0.0,             0.0,  9.25412948233,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,   11.775926614,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,   6.52917466646, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
             6.01764370032,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
            -5.31016126796,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0, -2.63255077089, 
                       0.0,  5.60841649587, -4.57497412059,             0.0, 
                       0.0,   5.32689177579,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,  4.50397199992, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0, -16.3952298421, -3.18409152349, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,  7.15740722264,            0.0, 
                        0.0,  3.65067453364,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0, -14.2939414996,            0.0, 
                        0.0,            0.0,             0.0,  -5.09855771472, 
                        0.0,            0.0, -1.61348916119,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
            -6.53820888787, -4.46754651758,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
             16.2846461558,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
             -0.376149055413,             0.0,            0.0, -11.8013656163, 
             9.14790814773,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,  -10.1220895693, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,  0.799243633546,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0, -17.5967380632,            0.0,            0.0, 
                       0.0,            0.0,   14.9584235556,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,  4.04252258349,             0.0,            0.0, 
             4.08625693219,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
            -3.93737357917,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,   6.42864870909,            0.0,            0.0, 
                       0.0,            0.0,            0.0,   1.0301628332, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0, -1.14957179812,            0.0,            0.0, 
                        0.0,            0.0,   3.52924654797,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,  9.11053313263, 
                        0.0,             0.0,            0.0, -5.48880251098, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0, -10.9805379108,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0, -8.42403838608,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0, -8.40010887023, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
            0.00935888097832,             0.0,            0.0,            0.0, 
            -12.2331916136,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,   17.2272764179, 
                        0.0,            0.0,            0.0,  8.45032486116, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
             -3.22532729782,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0, -5.06287817317,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0, -17.7488071911, 
                       0.0, -6.82312493617,             0.0,             0.0, 
                       0.0,            0.0,             0.0, 8.68632136983, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
             6.76297509285,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,  27.7722297214,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,   4.6639171715, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,  1.56887871789,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0, -0.892944237303,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0, 0.541802990474,            0.0, 
             -5.15260593722,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0, 0.395235711224,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0, -17.6993806415,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,  -2.51463595131, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
             -12.5000497831,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,  3.21741597845,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,  6.49446975673, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,  6.25220514937,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
            -15.9232071824,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
             -4.12734516984,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
             9.86504084578,  4.02251085477,            0.0,            0.0, 
             2.30851719045,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,  -4.2550029182,            0.0,            0.0, 
                        0.0,            0.0,  -3.84493730909,             0.0, 
                        0.0,            0.0,  2.40980994904,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,  -8.0157064851,            0.0, 
            -2.32398135295,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,    3.7512681481, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
            -11.9683439497,            0.0,             0.0,             0.0, 
            -5.62121946626,            0.0,             0.0,           0.0, 
                       0.0, -5.97293015628,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0, -12.3247657981,  8.26472945781, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0, 0.0203966355708, 
                         0.0,   11.3350828663,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
             -14.5513299223,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
            -2.05343337867,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
              3.57743826587,            0.0,  -2.24355995803,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0, -14.8248304451,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
            -17.7849972284,            0.0,            0.0,             0.0, 
            -6.46172664984,             0.0,            0.0,            0.0, 
                       0.0,   3.11626068435,            0.0,            0.0, 
                       0.0, -8.13777614844,            0.0,            0.0, 
                        0.0, -5.38218658469,            0.0,             0.0, 
                       0.0,  4.49805929441,             0.0,             0.0, 
                         0.0, -0.191866287504,            0.0, -1.65848849894, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0, -16.7727687497,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0, -1.03832782068,             0.0,             0.0, 
                        0.0,            0.0, -7.14379762286,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,  3.43788855538,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0, -9.88164194675, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,    9.0061854784,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,  6.52904723674,            0.0,  1.76561185165, 
                        0.0,            0.0,  -2.8181977061,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,  5.35347896916,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0, -3.98529488701,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,  -3.05859776874,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
             7.01048146192,             0.0,            0.0,            0.0, 
             -14.0618427686,             0.0,            0.0,            0.0, 
                       0.0,             0.0, -12.6905244313,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,   4.60848230712,             0.0, 
                       0.0,  2.74990306963,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
             11.0883404374, -3.22951433188,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,  0.354106802279,            0.0,            0.0, 
                       0.0, -3.23192919456,            0.0,            0.0, 
                       0.0,             0.0,            0.0,   18.2320098464, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
            -0.839092110555,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0, -14.0378515886,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
             14.5630009778,             0.0,            0.0,            0.0, 
              9.41968432286,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0, -8.85447879242, 
                       0.0, -9.32913848486,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,   -7.9593767519, 
              -9.34185123977,             0.0,            0.0,            0.0, 
                       0.0,  3.43666148169,            0.0,            0.0, 
             11.2107694267,             0.0,  10.6321856771,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0, -6.41424135338,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,   8.75246444428, 
                       0.0,            0.0,  -3.29314403042,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,  -3.55079961921,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0, 0.845577172747,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0, -8.50752656218,            0.0,  -20.2329388086, 
             8.44702318133,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
             -10.8542241371,            0.0,            0.0,             0.0, 
                       0.0,  14.3120029455,   9.63843313999,             0.0, 
                         0.0,             0.0,            0.0, -1.11280329113, 
             26.1798495288,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,    15.10925399,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0, -2.65333478565,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,  7.32070851117,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,  1.93785640668,             0.0,             0.0, 
                       0.0,  7.68398641593,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,   17.9292316741,            0.0,            0.0, 
                       0.0,   13.9978053942,  16.4535912315,            0.0, 
                       0.0,            0.0,            0.0, -6.70741830672, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,  12.8615975024,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
             12.5779661403,            0.0,            0.0,            0.0, 
                       0.0,             0.0, -2.15955967126,             0.0, 
                        0.0,            0.0,            0.0, -14.3732018364, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
             2.49009927302,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0, -5.39189617516, 
                       0.0,            0.0,             0.0,             0.0, 
             -5.5178712507,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,  14.8631910748,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0, -12.1607332001,             0.0, 
            -11.1100139426,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0, -12.5768778244, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,   12.957727031,   5.50100626493,            0.0, 
                       0.0,            0.0, -2.62770188886,            0.0, 
                       0.0,             0.0, -5.68480951544,            0.0, 
             2.10715056383,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,   13.9278763449,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0, -12.1254238872, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0, 3.68895153096, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,   -13.469723376, 
                       0.0,             0.0,            0.0,            0.0, 
            -12.0775203219,   5.08836235318,            0.0,            0.0, 
                       0.0,            0.0,            0.0,  18.2052201036, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,  -12.540573629, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,   19.303093959,            0.0, 
                       0.0,    1.9954628217,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,  6.33388346432,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0, -0.869672038237,            0.0,            0.0, 
                       0.0,             0.0,            0.0, -7.43369655991, 
                       0.0,            0.0,            0.0, -5.53243232572, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,  6.03182385984, 
                       0.0,            0.0, -7.24916097876,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0, -3.89747202699,            0.0,            0.0, 
                       0.0,            0.0, -12.1399843492,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0, -0.272584734132, -9.73092086453,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
              3.2537199903,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,  19.4969799791,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,   -18.171519895,            0.0,  -24.6331354139, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
             3.29011855658,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,   10.474087033, 
                        0.0,             0.0,            0.0,            0.0, 
             3.37872131103,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0, -3.24054537008,  12.7828548174, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0, 0.0254083171421,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
             28.0743930257,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0, -12.5694589309,            0.0, 
             1.01336604281,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0, -15.1358338105, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0, -2.49345066516,            0.0,             0.0, 
                       0.0,            0.0,    14.919581087,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
            -8.92589367219,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,  7.87776302091,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,  14.9126375924,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0, -0.820672257426,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,  1.63852093352,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
            -2.10328629638,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
             1.72155145639,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
              12.0012939227,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0, -11.2817063772,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,  -2.8375066553, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,  16.9961917137,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,  16.0324570122,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,  12.5563436804,             0.0,             0.0, 
                        0.0,  8.02374850764,            0.0,            0.0],
       [           0.0,            0.0,            0.0, -3.31492966985, 
                       0.0,            0.0,             0.0,             0.0, 
              5.3970618221,            0.0,             0.0, -5.5438727949, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
            -18.2436952665,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0, -11.3278400003,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,  5.72615694926,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,  5.58329261083,            0.0,            0.0, 
                       0.0,            0.0,            0.0, -10.1921283645, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0, -21.2933618613,             0.0,            0.0, 
                       0.0,            0.0, -3.05915652671,            0.0, 
             9.35787304436,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,  -2.53285145951,            0.0,            0.0, 
                        0.0, -10.7457591467,             0.0,             0.0, 
            -0.513394729715,            0.0,            0.0, -4.41709767646],
       [           0.0,            0.0,            0.0, -23.5289106812, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
            -0.615064779729,            0.0,             0.0,             0.0, 
             0.878942654245,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
            -10.7484286927,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,  2.98781668411,             0.0,   11.6979295382, 
                       0.0, -8.01776928132,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,  2.00041309438,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,  4.05970654562, 
                       0.0, -0.436937598553,            0.0,            0.0, 
                       0.0,             0.0,            0.0, -7.44522523837, 
                        0.0,             0.0, -16.2158694921,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
            -26.8584035065,            0.0,             0.0,  7.19446519027, 
                       0.0,            0.0,            0.0,             0.0, 
             11.9671761516,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
             -23.8327116662,            0.0, -4.02635516559,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,  4.82617581659,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,  2.25145775902,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,  10.3311857946,             0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0, -2.54809880099, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
              2.64475955582,            0.0,            0.0,            0.0],
       [           0.0,            0.0, -4.04459344395,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,            0.0, 
                       0.0,            0.0,            0.0,             0.0, 
                       0.0,             0.0,            0.0,            0.0, 
                       0.0, -0.576763314409,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                         0.0,             0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,             0.0, 
                       0.0,            0.0,   -11.920510885,            0.0, 
                       0.0,            0.0,            0.0,            0.0, 
                       0.0,             0.0,            0.0,            0.0, 
            -6.72404287521,             0.0,            0.0,            0.0, 
                        0.0,             0.0,            0.0, -3.50668842166, 
                       0.0,             0.0,            0.0,            0.0, 
                        0.0,            0.0,             0.0,             0.0, 
                        0.0,            0.0,            0.0,            0.0],
       [           0.0,            0.0,            0.0,            0.0, 
                       0.0,            0.0,             0.0,             0.0, 
                       0.0,            0.0,             0.0,           0.0, 
                       0.0,            0.0,             0.0,     