#
# Unit Tests for util/math
#
#

import os
import sys
from os.path import abspath, dirname
sys.path.insert(0, dirname(dirname(abspath(__file__)))+"/../..")
pkgdir = dirname(abspath(__file__))+"/../.."

import unittest
from nose.tools import nottest
import pyutilib

class CrossDebug(unittest.TestCase):

    def setUp(self):
        self.tmp = [(10,22,31), (10,22,32), (10,22,33), 
               (10,23,31), (10,23,32), (10,23,33),
               (11,22,31), (11,22,32), (11,22,33),
               (11,23,31), (11,23,32), (11,23,33)]
        self.tmp.sort()

        self.ttmp = [(10,22,31), (10,23,32), (11,22,31), (11,23,32)]
        self.ttmp.sort()

    def test_cross1(self):
        """ Apply the cross() method """
        ans = pyutilib.cross( ((10,11), (22,23), (31,32,33)) )
        ans.sort()
        self.failUnlessEqual(ans, self.tmp)

    def test_cross2(self):
        """ Apply the cross_iter() method """
        ans=[]
        for item in pyutilib.cross_iter( (10,11), (22,23), (31,32,33) ):
            ans.append(item)
        ans.sort()
        self.failUnlessEqual(ans, self.tmp)

    def test_cross3(self):
        """ Apply the flattened_cross_iter() method """
        ans=[]
        for item in pyutilib.flattened_cross_iter( (10,11), ((22,31), (23,32)) ):
            ans.append(item)
        ans.sort()
        self.failUnlessEqual(ans, self.ttmp)

if __name__ == "__main__":
   unittest.main()
