#  _________________________________________________________________________
#
#  PyUtilib: A Python utility library.
#  Copyright (c) 2008 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  _________________________________________________________________________

def Task(id=None, data=None, generateResponse=True):
    return {'id':id,
            'data':data,
            'generateResponse':generateResponse,
            'result':None,
            'processedBy':None,
            'type':None}

#
# Note: We have more flexibility in which serialization scheme gets
#       used by Pyro when we do not pass user defined classes across
#       the wire. Also, the default serializer used by Pyro4
#       ('serpent') does not support most user defined classes. The
#       serializer can be set to 'pickle' by the user if they need
#       this functionality (see: Pyro4 docs).
#
class XTask(object):

    def __init__(self, id=None, data=None, generateResponse=True):

        self.id=id
        self.data=data

        # not all tasks require a response to be
        # generated by the worker - but most do.
        self.generateResponse=generateResponse

        self.result=None
        self.processedBy=None

        self.type=None

    def __str__(self):
        return "<Task id=%s>" % str(self.id)
