#!/usr/bin/python
#-*- coding:utf-8 -*-

import TekDPO,cVXI11
import pylab
import time,gc

def test(hostaddr="169.254.254.254"):
    osc=TekDPO.TekDPO(hostaddr, device="inst0", proto="tcp")
    osc.CLS()
    osc.Stop()
    #osc.write(":WAV:FORM BYTE")
    osc.write("""ACQUIRE:STATE OFF;
    SELECT:CH1 ON; SELECT:CH2 ON; SELECT:CH3 ON; SELECT:CH4 ON;
    HORIZONTAL:RECORDLENGTH 1000 ;
    ACQUIRE:MODE SAMPLE ;
    ACQUIRE:STOPAFTER SEQUENCE;
    """)
    osc.set_wf_binary()
    osc.set_byte_width(2)
    osc.set_fulldata()
    #osc.set_record_length(20000000)
    #osc.set_record_length(   100000)
    osc.set_record_length(    10000)
    osc.Run()
    time.sleep(0.1)
    osc.Stop()
    print "SRQ_source:", osc.check_SRQ_source()
    #
    osc.createSVCThread() # start thread for SRQ handling
    #
    osc.CLS()
    osc.write(":DESE 1") #OPC
    osc.write("*ESE 1") #Pon(7)/URQ(6)/CME(5)/EXE(4)/DDE(3)/QYE(2)/RQL(1)/OPC(0)
    osc.write("*SRE 32") # SRE /ESB(5)/MAV(4)
    osc.write("*SRE 48") # enable all SRQ source
    osc.write("ACQUIRE:STATE ON;")
    #osc.write("*OPC")
    osc.enable_srq()
    pylab.clf()
    pylab.subplot(4,1,1)
    pylab.show(False)
    #osc.Run()
    def plot(wf,subp,lcol):
        pylab.subplot(4,1,subp)
        pylab.cla()
        pylab.plot(wf.x[::10],wf.y[::10],lcol)
    while 1:
        print "new loop"
        wf1=wf2=wf3=wf4=None
        s=time.time()
        print "Stop"
        osc.Stop()
        #osc.svc_lock.acquire(False) #non-block
        #print "lock status:",osc.svc_lock.acquire(False),osc.svc_lock.locked()
        #print osc.check_SRQ_source() ,osc.svc_lock.locked()
        while osc.check_SRQ_source()["SBR"] !=0: # to clear status
            print ",",
            time.sleep(0.1)
        osc.OPC()
        print "Run"
        osc.Run()
        time.sleep(0.1)
        #print osc.check_SRQ_source() ,osc.svc_lock.locked()
        print "lock:"
        osc.svc_lock.acquire(True) # block
        osc.Stop()
        print "released"
        try:
            wf1=osc.get_waveform(1)
            plot(wf1,1,"b")
        except KeyError:
            return
        except:
            pass
        try:
            wf2=osc.get_waveform(2)
            plot(wf2,2,"g")
        except:
            pass
        try:
            wf3=osc.get_waveform(3)
            plot(wf3,3,"r")
        except KeyError:
            return
        except:
            pass
        try:
            wf4=osc.get_waveform(4)
            plot(wf4,4,"y")
        except KeyError:
            return
        except:
            pass
        pylab.draw()
        #gc.collect()
        e=time.time()
        print time.ctime(), (e-s),gc.get_count(),
        try:
            print len(wf1.y), len(wf2.y),len(wf3.y),len(wf4.y),
        except KeyError:
            return
        except:
            pass
        finally:
            print
            #time.sleep(0.05)

def test_srq(hostname="192.168.2.3"):
    """
To generate a service request (SRQ) interrupt to an external controller, at least one bit in the Status Byte Register must be enabled. These bits are enabled by using the *SRE common command to set the corresponding bit in the Service Request Enable Register. These enabled bits can then set RQS and MSS (bit 6) in the Status Byte Register.
    """
    import select,threading,atexit
    osc=TekDPO.TekDPO(hostname,device="inst0",proto="tcp")
    osc.createSVCThread()
    print "Thread Created"
    osc.Stop()
    osc.write(":DESE 1") #OPC
    osc.write("*ESE 1") #Pon(7)/URQ(6)/CME(5)/EXE(4)/DDE(3)/QYE(2)/RQL(1)/OPC(0)
    osc.write("*SRE 32") # SRE /ESB(5)/MAV(4)
    osc.write("*SRE 48") # enable all SRQ source
    osc.write("*OPC")
    osc.check_SRQ_source()
    osc.enable_srq()
    #osc.TRG()
    return osc
    
if __name__ == "__main__":
    test("192.168.2.4")
    
