#!/usr/bin/python
#-*- coding:utf-8 -*-
#from __future__ import print_function
import sys
import matplotlib
matplotlib.use('TkAgg')

import numpy as np
from matplotlib.lines import Line2D
import matplotlib.pyplot as plt
import matplotlib.animation as animation
import serial,json,time

import datetime,sys
import matplotlib.dates as mdates
import pytz
JST= pytz.timezone("Asia/Tokyo")
#

import TekDPO,cVXI11

import pylab
import time,gc

class TestDPO(TekDPO.TekDPO):
    def __init__(self,hostaddr="169.254.254.254"):
        TekDPO.TekDPO.__init__(self,hostaddr, device="inst0", proto="tcp")

    def setup(self):
        self.CLS()
        self.Stop()
        #self.write(":WAV:FORM BYTE")
        self.write("""ACQUIRE:STATE OFF;
        SELECT:CH1 ON; SELECT:CH2 ON; SELECT:CH3 ON; SELECT:CH4 ON;
        HORIZONTAL:RECORDLENGTH 1000 ;
        ACQUIRE:MODE SAMPLE ;
        ACQUIRE:STOPAFTER SEQUENCE;
        """)
        self.set_wf_binary()
        self.set_byte_width(4)
        self.set_fulldata()
        #self.set_record_length(20000000) #20M,10M,1M,100k,10k
        self.set_record_length(   100000)
        #self.set_record_length(    10000)
        #self.CLS()
        self.Run()
        time.sleep(0.1)
        self.Stop()
        #print "SRQ_source:", self.check_SRQ_source()
        #
        self.createSVCThread() # start thread for SRQ handling
        #
        self.write(":DESE 1") #OPC
        self.write("*ESE 1") #Pon(7)/URQ(6)/CME(5)/EXE(4)/DDE(3)/QYE(2)/RQL(1)/OPC(0)
        self.write("*SRE 32") # SRE /ESB(5)/MAV(4)
        self.write("*SRE 48") # enable all SRQ source
        self.write("ACQUIRE:STATE ON;")
        #self.enable_srq()
    
    def get_next_wfs(self,):
        self.Stop()
        while self.check_SRQ_source()["SBR"] !=0: # to clear status
            print ",",
            time.sleep(0.1)
        #print "Start Run"
        if not self.svc_lock.locked():
            self.svc_lock.acquire()
        #print self.check_SRQ_source(), self.svc_lock.locked()
        self.Run()
        #time.sleep(0.07) # 0.05 was not sufficient
        self.enable_srq(True)
        self.OPC()
        #time.sleep(0.1) # 0.05 was not sufficient
        #print "wait:",
        while not self.svc_lock.acquire(True) :# block
            srq_source=self.check_SRQ_source()
            if srq_source["SBR"] !=0: # to clear status            if srq_source
                print "Break:",srq_source, self.svc_lock.locked()
                break
            print "try again:",srq_source, self.svc_lock.locked()
            time.sleep(0.01)
        else:
            #print "got SRQ/OPC"
            srq_source=self.check_SRQ_source()
            #print srq_source, self.svc_lock.locked()
        self.Stop()
        self.enable_srq(False) # stop SRQ
        #
        wf1=wf2=wf3=wf4=None
        try:
            wf1=self.get_waveform(1)
            wf2=self.get_waveform(2)
            wf3=self.get_waveform(3)
            wf4=self.get_waveform(4)
            return (wf1,wf2,wf3,wf4)
        except:
            return None
        # try:     
        #     print  len(wf1.y),
        #     print  len(wf2.y),
        #     print  len(wf3.y),
        #     print  len(wf4.y),
        # except:
        #     pass
        # finally:
        #     print 



class Viewer:
    lcolors=("y","b","r","g")

    def __init__(self,osc):
        self.fig, self.axes= plt.subplots(4,1,sharex=True,sharey=False,)
        self.osc=osc
        self.osc.setup()
        self.lines=None
        self.suptitle=self.fig.suptitle("DPO4K with PyVXI11 on %s"%time.ctime())
        plt.draw()

    def Run(self):
        self.ani = animation.FuncAnimation(fig=self.fig, 
                                           func=self.update, 
                                           frames=self.emitter,
                                           init_func=None,
                                           interval=1000
                                           blit=False)
        plt.draw()
        plt.show()

    def emitter(self):
        while True:
            wfs=self.osc.get_next_wfs()
            if wfs:
                yield wfs
            
    def update(self,wfs):
        if self.lines:
            for l, wf in zip(self.lines,wfs):
                if wf:
                    l.set_data(wf.x[::10],wf.y[::10])
                    ax=l.get_axes()
                    ax.set_xlim(min(wf.x),max(wf.x))
                    ax.set_ylim(min(wf.y),max(wf.y))
                else:
                    l.get_axes().cla()
        else:
            self.lines= [ax.plot(wf.x[::10],wf.y[::10],lcol)[0] 
                    for ax,wf,lcol in zip(self.axes,wfs,self.lcolors)]
        self.suptitle.set_text("DPO4K with PyVXI11 on %s"%time.ctime())        
        plt.draw()
        return self.lines

def test(oscaddr="192.168.2.4"):
    osc=TestDPO(oscaddr)
    viewer=Viewer(osc)
    viewer.Run()

def test_srq(hostname="192.168.2.3"):
    """
To generate a service request (SRQ) interrupt to an external controller, at least one bit in the Status Byte Register must be enabled. These bits are enabled by using the *SRE common command to set the corresponding bit in the Service Request Enable Register. These enabled bits can then set RQS and MSS (bit 6) in the Status Byte Register.
    """
    import select,threading,atexit
    osc=TekDPO.TekDPO(hostname,device="inst0",proto="tcp")
    osc.createSVCThread()
    print "Thread Created"
    osc.Stop()
    osc.write(":DESE 1") #OPC
    osc.write("*ESE 1") #Pon(7)/URQ(6)/CME(5)/EXE(4)/DDE(3)/QYE(2)/RQL(1)/OPC(0)
    osc.write("*SRE 32") # SRE /ESB(5)/MAV(4)
    osc.write("*SRE 48") # enable all SRQ source
    osc.write("*OPC")
    osc.check_SRQ_source()
    osc.enable_srq()
    #osc.TRG()
    return osc

import time
def speed_test(oscaddr="192.168.2.4"):
    osc=TekDPO.TekDPO(oscaddr, device="inst0", proto="tcp")
    osc.set_byte_width(4)
    osc.write(":WAV:FORM BYTE")
    osc.write(":WAV:SOU CH1")
    osc.set_wf_binary()
    osc.set_fulldata()
    osc.Run()
    time.sleep(0.5)
    osc.Stop()
    for sz in (10000,100000,1000000,10000000,20000000):
        osc.set_record_length(sz)
        osc.Run()
        time.sleep(1.0)
        osc.Stop()
        st=time.time()
        r=osc.ask(":curve?;",io_timeout=3000,requestSize=40000000)
        #r=osc.ask_block(":curve?;",io_timeout=3000)
        # osc.write(":curve?;")
        #         time.sleep(0.2)
        #         r=osc.readResponce(io_timeout=120)
        en=time.time()
        print sz,len(r),en-st,len(r)/(en-st)

if __name__ == "__main__":
    #test("192.168.2.4")
    try:
        test("169.254.4.84")
    except KeyError:
        sys.exit()
