#!/usr/bin/python
#-*- coding:utf-8 -*-
import matplotlib
## the default backend; one of GTK GTKAgg GTKCairo CocoaAgg FltkAgg
# MacOSX QtAgg Qt4Agg TkAgg WX WXAgg Agg Cairo GDK PS PDF SVG Template
#matplotlib.use('MacOSX')
#matplotlib.use('WXAgg')
matplotlib.use('TkAgg')

import numpy as np
from matplotlib.lines import Line2D
import matplotlib.pyplot as plt
import matplotlib.animation as animation
import serial,json,time

import datetime,sys
import matplotlib.dates as mdates
import pytz
JST= pytz.timezone("Asia/Tokyo")

import AgilentDSO,cVXI11
import pylab
import time,gc

class TestDSO(AgilentDSO.AglDSO):
    def __init__(osc, hostaddr, device="gpib0,7", proto="tcp"):
        osc.CLS()
        osc.Stop()
        osc.write(":WAV:FORM BYTE")
        osc.set_wf_point_mode("MAX")
        osc.set_wf_point("5000")
        osc.set_wf_point(2000000)
        osc.Run()
        time.sleep(0.1)
        osc.Stop()
        #
        osc.createSVCThread()
        osc.CLS()
        #osc.write("*SRE 161") # OPER/ESB/TRG
        osc.write("*SRE 32") # ESB
        #osc.write("*ESE 255") # 
        osc.write("*ESE 1") # OPC
        osc.write(":OPEE 0") # OPER/ESB/MAV
        osc.enable_srq()

class Viewer():
    def __init__(self):
        fig, ax = plt.subplots(4,1)
        self.fig=fig
        self.ax=ax
    def plot(self, wf, subp, lcol):
        pylab.subplot(4,1,subp)
        pylab.cla()
        pylab.plot(wf.x[::1000],wf.y[::10000],lcol)

    #

    pylab.clf()
    pylab.subplot(4,1,1)
    pylab.show(False)
    osc.TRG()
    osc.check_SRQ_source()
    osc.svc_lock.acquire(False) #non-block
    print osc.check_SRQ_source(), osc.svc_lock.locked()
    while 1:
        osc.svc_lock.acquire(False) #non-block
        print "Start:",osc.check_SRQ_source(), osc.svc_lock.locked()
        osc.TRG()
        #osc.Run()
        s=time.time()
        osc.write("*OPC")
        while osc.svc_lock.acquire(True): # block
            if osc.qOPC():
                break
            time.sleep(0.01)
        osc.Stop()
        print osc.check_SRQ_source(), osc.svc_lock.locked()
        try:
            wf1=osc.get_waveform(1)
            plot(wf1,1,"y")
        except:
            pass
        try:
            wf2=osc.get_waveform(2)
            plot(wf2,2,"g")
        except:
            pass
        try:
            wf3=osc.get_waveform(3)
            plot(wf3,3,"b")
        except:
            pass
        try:
            wf4=osc.get_waveform(3)
            plot(wf4, 4,"r")
        except:
            pass
        pylab.draw()
        #gc.collect()
        e=time.time()
        print (e-s),gc.get_count(),
        try:
            print len(wf1.y),len(wf2.y),len(wf3.y),len(wf4.y),
        finally:
            print 
            time.sleep(0.01)

def test_srq(hostname="192.168.2.3"):
    """
To generate a service request (SRQ) interrupt to an external controller, at least one bit in the Status Byte Register must be enabled. These bits are enabled by using the *SRE common command to set the corresponding bit in the Service Request Enable Register. These enabled bits can then set RQS and MSS (bit 6) in the Status Byte Register.
    """
    import select,threading,atexit
    #hostname="169.254.254.254"
    osc=AgilentDSO.AglDSO(hostname,device="gpib0,7",proto="tcp")
    osc.createSVCThread()
    print "Thread Created"
    osc.Stop()
    osc.set_wf_point_mode("RAW")
    #osc.set_wf_point("5000")
    osc.set_wf_point("20000")
    osc.write("*ESE 1")#Pon(7)/URQ(6)/CME(5)/EXE(4)/DDE(3)/QYE(2)/RQL(1)/OPC(0)
    osc.write("*SRE 32") # enable OPC/ESB
    # SRE OPER(7)/ESB(5)/MAV(4)/MSG(2)/USR(1)/TRG(0)
    #osc.write("*SRE 191") # enable all SRQ source
    osc.write("*SRE 177") # OPER/ESB/MAV
    osc.write(":HWE 65535")
    osc.write(":OVL 65535")
    osc.write(":OPEE 32") # enable SRQ by Wait Trigger
    #osc.write(":OPEE 6184") # HWE(12)/OVLR(11)/Wait Trig(5)/Run(3)
    #osc.write(":OPEE 2088") # HWE(12)/OVLR(11)/Wait Trig(5)/Run(3)
    #osc.write("*OPC")
    osc.write("*SRE 161") # OPER/ESB/TRG
    osc.write("*ESE 255") # 
    osc.write(":OPEE 0") # OPER/ESB/MAV
    osc.enable_srq()
    #osc.TRG()
    return osc
    
if __name__ == "__main__":
    test("192.168.2.11")
    
