/*
 * This is sample code generated by rpcgen.
 * These are only templates and you can use them
 * as a guideline for developing your own functions.
 */

#include "vxi11.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

void 
vxi11DeviceClear(char *host,char *device)
{
  CLIENT *clnt;
  Create_LinkResp  *result_1;
  Create_LinkParms  create_link_1_arg;
  Device_Error  *result_6;
  Device_GenericParms  device_clear_1_arg;
  Device_Error  *result_7;
  Device_GenericParms  device_remote_1_arg;

  clnt = clnt_create (host, DEVICE_CORE, DEVICE_CORE_VERSION, "tcp");
  if (clnt == NULL) {
    clnt_pcreateerror (host);
    clnt_destroy (clnt);
    exit (1);
  }
  
  memset((char *) &create_link_1_arg, 0, sizeof(Create_LinkParms));
  create_link_1_arg.clientId = (long) clnt;
  create_link_1_arg.lockDevice = 0;  /* do not try to lock the device */
  create_link_1_arg.lock_timeout = 0;/* if device is locked, forget it */
  create_link_1_arg.device=device;
  
  result_1 = create_link_1(&create_link_1_arg, clnt);
  if (result_1 == (Create_LinkResp *) NULL) {
    clnt_perror (clnt, "call failed");
    clnt_destroy (clnt);
    exit (1);
  }
  {/* make a device in remote state */
    device_remote_1_arg.lid=result_1->lid;
    device_remote_1_arg.io_timeout=0;
    memset((char *) &device_remote_1_arg, 0, sizeof(Device_GenericParms));
    result_7 = device_remote_1(&device_remote_1_arg, clnt);
    if (result_7 == (Device_Error *) NULL) {
      clnt_perror (clnt, "call failed 7");
      clnt_destroy (clnt);
      exit (1);
    }
  }
  {/* clear device */
    device_clear_1_arg.lid=result_1->lid;
    device_clear_1_arg.io_timeout=0;
    result_6 = device_clear_1(&device_clear_1_arg, clnt);
    if (result_6 == (Device_Error *) NULL) {
      clnt_perror (clnt, "device_clear failed.");
    }
  }
  clnt_destroy (clnt);
}


int
main (int argc, char *argv[])
{
  char *host;
  char device[255];
  int ln;
  
  if (argc < 2) {
    printf ("usage: %s host_ip_address [device_number:default=7]\n", argv[0]);
    exit (1);
  }
  
  host = argv[1];
  if (argc >2) {
    ln = atoi(argv[2]);
  }
  else{
    ln=7;
  }

  snprintf(device, sizeof(device), "%s,%d","gpib0",ln);
  vxi11DeviceClear(host,device);
  exit (0);

}
