#!/usr/bin/python
#-*- coding:utf-8 -*-

import TekDPO,cVXI11
import pylab
import time,gc

def test(hostaddr="169.254.254.254"):
    osc=TekDPO.TekDPO(hostaddr, device="inst0", proto="tcp")
    osc.CLS()
    osc.Stop()
    #osc.write(":WAV:FORM BYTE")
    osc.set_wf_binary()
    osc.set_byte_width(2)
    osc.set_fulldata()
    #osc.set_record_length(20000000)
    osc.set_record_length(  1000000)
    osc.Run()
    time.sleep(0.1)
    osc.Stop()
    #
    #osc.createSVCThread()
    #
    osc.CLS()
    osc.write(":DESE 1") #OPC
    osc.write("*ESE 1") #Pon(7)/URQ(6)/CME(5)/EXE(4)/DDE(3)/QYE(2)/RQL(1)/OPC(0)
    osc.write("*SRE 32") # SRE /ESB(5)/MAV(4)
    osc.write("*SRE 48") # enable all SRQ source
    osc.write("*OPC")
    osc.enable_srq()
    pylab.clf()
    pylab.subplot(4,1,1)
    pylab.show(False)
    osc.Run()
    while 1:
        wf1=wf2=wf3=wf4=None
        osc.check_SRQ_source()
        s=time.time()
        osc.Run()
        #osc.svc_lock.acquire(False) #non-block
        #osc.TRG()
        osc.OPC()
        #osc.svc_lock.acquire(True) # block
        print osc.check_SRQ_source() #,osc.svc_lock.locked()
        osc.Stop()
        try:
            wf1=osc.get_waveform(1)
            # pylab.subplot(4,1,1)
            # pylab.cla()
            # pylab.plot(wf1.x[::100],wf1.y[::100],'b')
        except:
            pass
        try:
            wf2=osc.get_waveform(2)
            # pylab.subplot(4,1,2)
            # pylab.cla()
            # pylab.plot(wf2.x[::100],wf2.y[::100],'g')
        except:
            pass
        try:
            wf3=osc.get_waveform(3)
            # pylab.subplot(4,1,3)
            # pylab.cla()
            # pylab.plot(wf3.x[::100],wf3.y[::100],'r')
        except:
            pass
        try:
            wf4=osc.get_waveform(4)
            # pylab.subplot(4,1,4)
            # pylab.cla()
            # pylab.plot(wf4.x[::100],wf4.y[::100],'y')
        except:
            pass
        pylab.draw()
        gc.collect()
        e=time.time()
        print (e-s),gc.get_count(),
        try:
            print len(wf1.y),len(wf2.y),len(wf3.y),len(wf4.y),
        except:
            pass
        finally:
            print 

def test_srq(hostname="192.168.2.3"):
    """
To generate a service request (SRQ) interrupt to an external controller, at least one bit in the Status Byte Register must be enabled. These bits are enabled by using the *SRE common command to set the corresponding bit in the Service Request Enable Register. These enabled bits can then set RQS and MSS (bit 6) in the Status Byte Register.
    """
    import select,threading,atexit
    osc=TekDPO.TekDPO(hostname,device="inst0",proto="tcp")
    osc.createSVCThread()
    print "Thread Created"
    osc.Stop()
    osc.write(":DESE 1") #OPC
    osc.write("*ESE 1") #Pon(7)/URQ(6)/CME(5)/EXE(4)/DDE(3)/QYE(2)/RQL(1)/OPC(0)
    osc.write("*SRE 32") # SRE /ESB(5)/MAV(4)
    osc.write("*SRE 48") # enable all SRQ source
    osc.write("*OPC")
    osc.check_SRQ_source()
    osc.enable_srq()
    #osc.TRG()
    return osc
    
if __name__ == "__main__":
    test("192.168.2.4")
    
