#!/usr/bin/python
#-*- coding:utf-8 -*-

import AgilentDSO,cVXI11
import pylab
import time,gc

def test(hostaddr="169.254.254.254"):
    osc=AgilentDSO.AglDSO(hostaddr, device="gpib0,7", proto="tcp")
    osc.CLS()
    osc.Stop()
    osc.write(":WAV:FORM BYTE")
    osc.set_wf_point_mode("MAX")
    osc.set_wf_point("50000")
    osc.Run()
    time.sleep(0.1)
    osc.Stop()
    #
    osc.createSVCThread()
    #
    osc.CLS()
    osc.write("*SRE 161") # OPER/ESB/TRG
    osc.write("*ESE 255") # 
    osc.write(":OPEE 0") # OPER/ESB/MAV
    osc.enable_srq()
    pylab.clf()
    pylab.subplot(4,1,1)
    pylab.show(False)
    #    osc.Run()
    while 1:
        osc.check_SRQ_source()
        osc.svc_lock.acquire(False) #non-block
        osc.TRG()
        s=time.time()
        osc.svc_lock.acquire(True) # block
        osc.write("*OPC")
        print osc.check_SRQ_source()
        try:
            pylab.subplot(4,1,1)
            #pylab.cla()
            wf1=osc.get_waveform(1)
            #pylab.plot(wf1.x[:-1],wf1.y[:-1],'b')
        except:
            pass
        try:
            pylab.subplot(4,1,2)
            #pylab.cla()
            wf2=osc.get_waveform(2)
            #pylab.plot(wf2.x[:-1],wf2.y[:-1],'g')
        except:
            pass
        try:
            pylab.subplot(4,1,3)
            #pylab.cla()
            wf3=osc.get_waveform(3)
            #pylab.plot(wf3.x[:-1],wf3.y[:-1],'r')
        except:
            pass
        try:
            pylab.subplot(4,1,4)
            #pylab.cla()
            wf4=osc.get_waveform(4)
            #pylab.plot(wf4.x[:-1],wf4.y[:-1],'y')
        except:
            pass
        #pylab.draw()
        gc.collect()
        e=time.time()
        print (e-s),gc.get_count(),
        try:
            print len(wf1.y),len(wf2.y),len(wf3.y),len(wf4.y),
        finally:
            print 
        #time.sleep(0.1)

def test_srq(hostname="192.168.2.3"):
    """
To generate a service request (SRQ) interrupt to an external controller, at least one bit in the Status Byte Register must be enabled. These bits are enabled by using the *SRE common command to set the corresponding bit in the Service Request Enable Register. These enabled bits can then set RQS and MSS (bit 6) in the Status Byte Register.
    """
    import select,threading,atexit
    #hostname="169.254.254.254"
    osc=AgilentDSO.AglDSO(hostname,device="gpib0,7",proto="tcp")
    osc.createSVCThread()
    print "Thread Created"
    osc.Stop()
    osc.set_wf_point_mode("MAX")
    osc.set_wf_point("5000")
    osc.write("*ESE 1")#Pon(7)/URQ(6)/CME(5)/EXE(4)/DDE(3)/QYE(2)/RQL(1)/OPC(0)
    osc.write("*SRE 32") # enable OPC/ESB
    # SRE OPER(7)/ESB(5)/MAV(4)/MSG(2)/USR(1)/TRG(0)
    #osc.write("*SRE 191") # enable all SRQ source
    osc.write("*SRE 177") # OPER/ESB/MAV
    osc.write(":HWE 65535")
    osc.write(":OVL 65535")
    osc.write(":OPEE 32") # enable SRQ by Wait Trigger
    #osc.write(":OPEE 6184") # HWE(12)/OVLR(11)/Wait Trig(5)/Run(3)
    #osc.write(":OPEE 2088") # HWE(12)/OVLR(11)/Wait Trig(5)/Run(3)
    #osc.write("*OPC")
    osc.write("*SRE 161") # OPER/ESB/TRG
    osc.write("*ESE 255") # 
    osc.write(":OPEE 0") # OPER/ESB/MAV
    osc.enable_srq()
    #osc.TRG()
    return osc
    
if __name__ == "__main__":
    test("192.168.2.3")
    
